!!****h* BigDFT/lazy_100
!! NAME
!!   lazy_100
!!
!! FUNCTION
!!   Filters for interpolating scaling functions (order 60)
!!
!! SOURCE
!!
integer, parameter :: m=102
real(dp), dimension(-m:m) :: ch = (/ &
     0._dp, 0._dp, 0._dp, &
     -1.2683805626484815e-31_dp,0._dp,1.28158741180595538e-29_dp,0._dp,&
      -6.41198417717232202e-28_dp,0._dp,2.11779334023809847e-26_dp,0._dp,&
      -5.19441179715542395e-25_dp,0._dp,1.00911662890805933e-23_dp,0._dp,&
      -1.61729304931893186e-22_dp,0._dp,2.19924673311587861e-21_dp,0._dp,&
      -2.59007672484430282e-20_dp,0._dp,2.68351845030850743e-19_dp,0._dp,&
      -2.47631006363911635e-18_dp,0._dp,2.05560047903738218e-17_dp,0._dp,&
      -1.54763876066192241e-16_dp,0._dp,1.06410357358472536e-15_dp,0._dp,&
      -6.72076683598079057e-15_dp,0._dp,3.91882394735691508e-14_dp,0._dp,&
      -2.1187969775075261e-13_dp,0._dp,1.06630135673478305e-12_dp,0._dp,&
      -5.01180443685748998e-12_dp,0._dp,2.20666419683207691e-11_dp,0._dp,&
      -9.1258654919835045e-11_dp,0._dp,3.55352205999457932e-10_dp,0._dp,&
      -1.30569909741619005e-9_dp,0._dp,4.53620646231137398e-9_dp,0._dp,&
      -1.49279735540769725e-8_dp,0._dp,4.66118357913015673e-8_dp,0._dp,&
      -1.38309751701521672e-7_dp,0._dp,3.90568525175243503e-7_dp,0._dp,&
      -1.05103157937523999e-6_dp,0._dp,2.69873794098621337e-6_dp,0._dp,&
      -6.61998110310293365e-6_dp,0._dp,0.0000155312721433740143_dp,0._dp,&
      -0.0000348898934935080536_dp,0._dp,0.0000751302114254144957_dp,0._dp,&
      -0.000155250095336387829_dp,0._dp,0.000308205854288494064_dp,0._dp,&
      -0.000588508297900663563_dp,0._dp,0.00108221904295030132_dp,0._dp,&
      -0.00191926718143360074_dp,0._dp,0.00328782888345707184_dp,0._dp,&
      -0.00545087420152093489_dp,0._dp,0.00876675750345045625_dp,0._dp,&
      -0.0137206712673049998_dp,0._dp,0.0209859998811194541_dp,0._dp,&
      -0.031565718829452402_dp,0._dp,0.0471537281279474153_dp,0._dp,&
      -0.0711699126403181485_dp,0._dp,0.112357606764076737_dp,0._dp,&
      -0.202867901101805219_dp,0._dp,0.633444670787269357_dp,1._dp,0.633444670787269357_dp,&
      0._dp,-0.202867901101805219_dp,0._dp,0.112357606764076737_dp,0._dp,&
      -0.0711699126403181485_dp,0._dp,0.0471537281279474153_dp,0._dp,&
      -0.031565718829452402_dp,0._dp,0.0209859998811194541_dp,0._dp,&
      -0.0137206712673049998_dp,0._dp,0.00876675750345045625_dp,0._dp,&
      -0.00545087420152093489_dp,0._dp,0.00328782888345707184_dp,0._dp,&
      -0.00191926718143360074_dp,0._dp,0.00108221904295030132_dp,0._dp,&
      -0.000588508297900663563_dp,0._dp,0.000308205854288494064_dp,0._dp,&
      -0.000155250095336387829_dp,0._dp,0.0000751302114254144957_dp,0._dp,&
      -0.0000348898934935080536_dp,0._dp,0.0000155312721433740143_dp,0._dp,&
      -6.61998110310293365e-6_dp,0._dp,2.69873794098621337e-6_dp,0._dp,&
      -1.05103157937523999e-6_dp,0._dp,3.90568525175243503e-7_dp,0._dp,&
      -1.38309751701521672e-7_dp,0._dp,4.66118357913015673e-8_dp,0._dp,&
      -1.49279735540769725e-8_dp,0._dp,4.53620646231137398e-9_dp,0._dp,&
      -1.30569909741619005e-9_dp,0._dp,3.55352205999457932e-10_dp,0._dp,&
      -9.1258654919835045e-11_dp,0._dp,2.20666419683207691e-11_dp,0._dp,&
      -5.01180443685748998e-12_dp,0._dp,1.06630135673478305e-12_dp,0._dp,&
      -2.1187969775075261e-13_dp,0._dp,3.91882394735691508e-14_dp,0._dp,&
      -6.72076683598079057e-15_dp,0._dp,1.06410357358472536e-15_dp,0._dp,&
      -1.54763876066192241e-16_dp,0._dp,2.05560047903738218e-17_dp,0._dp,&
      -2.47631006363911635e-18_dp,0._dp,2.68351845030850743e-19_dp,0._dp,&
      -2.59007672484430282e-20_dp,0._dp,2.19924673311587861e-21_dp,0._dp,&
      -1.61729304931893186e-22_dp,0._dp,1.00911662890805933e-23_dp,0._dp,&
      -5.19441179715542395e-25_dp,0._dp,2.11779334023809847e-26_dp,0._dp,&
      -6.41198417717232202e-28_dp,0._dp,1.28158741180595538e-29_dp,0._dp,&
      -1.2683805626484815e-31_dp,&
     0._dp, 0._dp, 0._dp   /)
real(dp), dimension(-m:m) ::  cg,cht,cgt

!******** coefficients for wavelet transform *********************
do i=-m,m
   cht(i)=0._dp
   cg(i)=0._dp
   cgt(i)=0._dp
enddo

! the normalization is chosen such that a constant function remains the same constant 
! on each level of the transform

cht( 0)=1._dp

! g coefficients from h coefficients
do i=-m,m-1
   cg(i+1)=cht(-i)*(-1)**(i+1)
   cgt(i+1)=ch(-i)*(-1)**(i+1)
enddo
!!***

