//
// BAGEL - Parallel electron correlation program.
// Filename: _complex_eriroot_8.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Ryan D. Reynolds <RyanDReynolds@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <complex>
#include "comperirootlist.h"

using namespace std;
using namespace bagel;

void ComplexERIRootList::complex_eriroot8(const complex<double>* ta, complex<double>* rr, complex<double>* ww, const int n) {

  static constexpr double ax[8] = {7.479188259681809e-02,6.772490876492899e-01,1.905113635031426e+00,3.809476361484904e+00,6.483145428627162e+00,
    1.009332367522134e+01,1.497262708842639e+01,2.198427284096267e+01};
  static constexpr double aw[8] = {5.079294790166138e-01,2.806474585285338e-01,8.381004139898596e-02,1.288031153550992e-02,9.322840086241799e-04,
    2.711860092537858e-05,2.320980844865209e-07,2.654807474011186e-10};
  static constexpr double xr[30240] = {   1.920322242696510e-02,  -5.935535205422543e-04,   1.361658943507880e-05,  -2.738698298756991e-07,   5.071401066702567e-09,
  -8.811599238109736e-11,   1.445208657845989e-12,  -2.233854363442283e-14,   3.221133156288056e-16,  -4.231368594825682e-18,   4.772247853345643e-20,  -3.766236418844165e-22,
  -8.709079624203859e-25,   1.275554852942771e-25,   1.920450472970352e-02,  -5.936308386473865e-04,   1.361945362658442e-05,  -2.739528103646429e-07,   5.073443442330367e-09,
  -8.816019935532316e-11,   1.446058356156773e-12,  -2.235287394454725e-14,   3.223144135805157e-16,  -4.233272174918300e-18,   4.771554067969748e-20,  -3.756444731960687e-22,
  -9.041645690376230e-25,   1.283937929427808e-25,   1.920676759277750e-02,  -5.937672867011739e-04,   1.362450847401119e-05,  -2.740992645095044e-07,   5.077048219392519e-09,
  -8.823822621938918e-11,   1.447558091241970e-12,  -2.237816519739904e-14,   3.226692289217003e-16,  -4.236626919554486e-18,   4.770313011041904e-20,  -3.739117034281916e-22,
  -9.629657654945415e-25,   1.298750294113735e-25,   1.920950424567342e-02,  -5.939323136174068e-04,   1.363062244657084e-05,  -2.742764160133137e-07,   5.081408813947169e-09,
  -8.833261629591509e-11,   1.449372318456635e-12,  -2.240875650095885e-14,   3.230982321285172e-16,  -4.240676418022559e-18,   4.768783519935254e-20,  -3.718078669128285e-22,
  -1.034272447111571e-24,   1.316696166024344e-25,   1.921216133336747e-02,  -5.940925529019221e-04,   1.363655945809684e-05,  -2.744484519466533e-07,   5.085643742021517e-09,
  -8.842428956229049e-11,   1.451134304830115e-12,  -2.243846326691309e-14,   3.235146551693646e-16,  -4.244600153223243e-18,   4.767268513374484e-20,  -3.697565318894434e-22,
  -1.103709092056812e-24,   1.334153941381114e-25,   1.921430212988251e-02,  -5.942216639591763e-04,   1.364134343620490e-05,  -2.745870850871843e-07,   5.089056590839299e-09,
  -8.849816974501299e-11,   1.452554286939290e-12,  -2.246240127747767e-14,   3.238500869482141e-16,  -4.247755713937679e-18,   4.766026366322525e-20,  -3.680975708466480e-22,
  -1.159799284511739e-24,   1.348243658282898e-25,   1.921571686779516e-02,  -5.943069901816328e-04,   1.364450519080631e-05,  -2.746787125676655e-07,   5.091312350656481e-09,
  -8.854700284655386e-11,   1.453492854514348e-12,  -2.247822232993370e-14,   3.240717178879278e-16,  -4.249838227813023e-18,   4.765194948843847e-20,  -3.669982065535921e-22,
  -1.196937592538758e-24,   1.357566602529937e-25,   1.921644344599871e-02,  -5.943508129712601e-04,   1.364612908466561e-05,  -2.747257742113278e-07,   5.092470979966840e-09,
  -8.857208543235758e-11,   1.453974936965851e-12,  -2.248634819923613e-14,   3.241855308760218e-16,  -4.250906885582963e-18,   4.764764685929912e-20,  -3.664326548413075e-22,
  -1.216033062561320e-24,   1.362358311177792e-25,   1.921669634497741e-02,  -5.943660664822648e-04,   1.364669432470553e-05,  -2.747421554899504e-07,   5.092874281553934e-09,
  -8.858081636478320e-11,   1.454142743406107e-12,  -2.248917664190372e-14,   3.242251437134608e-16,  -4.251278712215659e-18,   4.764614404885061e-20,  -3.662356540236434e-22,
  -1.222683105282914e-24,   1.364026735016878e-25,   1.921673647688428e-02,  -5.943684870322899e-04,   1.364678402188779e-05,  -2.747447550227568e-07,   5.092938281387834e-09,
  -8.858220187716157e-11,   1.454169372605088e-12,  -2.248962548436925e-14,   3.242314296864429e-16,  -4.251337709832025e-18,   4.764590532466584e-20,  -3.662043853301831e-22,
  -1.223738550640487e-24,   1.364291520609077e-25,   1.678929270514389e-01,  -4.778649248786803e-03,   9.230669230161967e-05,  -1.341931176139617e-06,   1.281819971085302e-08,
   5.133281860742448e-12,  -3.489354049087696e-12,   8.818393267885044e-14,  -1.269188762618512e-15,   6.275445691613415e-18,   2.416675338442833e-19,  -8.731663339673442e-21,
   1.595810058047475e-22,  -1.424170865752108e-24,   1.679015952042107e-01,  -4.779026643765102e-03,   9.231387458505865e-05,  -1.341924901051366e-06,   1.281325370894525e-08,
   5.307209014126280e-12,  -3.492663860981720e-12,   8.820392719463838e-14,  -1.268137753348581e-15,   6.230042257185373e-18,   2.426476378040635e-19,  -8.741536985576671e-21,
   1.594258146756683e-22,  -1.414403384975626e-24,   1.679168908404557e-01,  -4.779692561462064e-03,   9.232654556628598e-05,  -1.341913695897400e-06,   1.280452263519509e-08,
   5.614137635639480e-12,  -3.498501814156676e-12,   8.823908297279308e-14,  -1.266279875806361e-15,   6.149886346179610e-18,   2.443762479861097e-19,  -8.758900850141645e-21,
   1.591503474408174e-22,  -1.397148375319803e-24,   1.679353874152134e-01,  -4.780497793372170e-03,   9.234186357893535e-05,  -1.341899920289602e-06,   1.279395849164212e-08,
   5.985332446274776e-12,  -3.505557267749324e-12,   8.828138074345521e-14,  -1.264027591520985e-15,   6.052891500115686e-18,   2.464651344761307e-19,  -8.779797866747698e-21,
   1.588144716867014e-22,  -1.376249209521736e-24,   1.679533445414362e-01,  -4.781279495525289e-03,   9.235672998294429e-05,  -1.341886310256408e-06,   1.278369626662570e-08,
   6.345737732140103e-12,  -3.512402529719467e-12,   8.832221956802978e-14,  -1.261835126570161e-15,   5.958658056969732e-18,   2.484915502298555e-19,  -8.799979973477379e-21,
   1.584855023662273e-22,  -1.355924962919305e-24,   1.679678112648593e-01,  -4.781909222412766e-03,   9.236870325643039e-05,  -1.341875176429870e-06,   1.277542432594564e-08,
   6.636115392904101e-12,  -3.517914077352511e-12,   8.835495886183440e-14,  -1.260064617836965e-15,   5.882693007548822e-18,   2.501229682644143e-19,  -8.816163573358126e-21,
   1.582184075287008e-22,  -1.339526535689509e-24,   1.679773709587507e-01,  -4.782325333636489e-03,   9.237661355786934e-05,  -1.341867736270419e-06,   1.276995601277952e-08,
   6.828011239761966e-12,  -3.521554585020911e-12,   8.837651406942911e-14,  -1.258892598638806e-15,   5.832471348184845e-18,   2.512004708818304e-19,  -8.826820733557053e-21,
   1.580408974574707e-22,  -1.328678312224032e-24,   1.679822804243552e-01,  -4.782539026322805e-03,   9.238067543555709e-05,  -1.341863889684062e-06,   1.276714704194930e-08,
   6.926564947035780e-12,  -3.523423718882195e-12,   8.838755946838511e-14,  -1.258290061848929e-15,   5.806672309385901e-18,   2.517536620757718e-19,  -8.832282347154775e-21,
   1.579494226634262e-22,  -1.323103393347379e-24,   1.679839892255937e-01,  -4.782613403965381e-03,   9.238208913913239e-05,  -1.341862546751520e-06,   1.276616923766448e-08,
   6.960868422921259e-12,  -3.524074217795201e-12,   8.839140006243119e-14,  -1.258080240116416e-15,   5.797691474880278e-18,   2.519461801513128e-19,  -8.834181504598683e-21,
   1.579175339052426e-22,  -1.321162381674481e-24,   1.679842603896126e-01,  -4.782625206670352e-03,   9.238231347108944e-05,  -1.341862333452313e-06,   1.276601406807186e-08,
   6.966311957452392e-12,  -3.524177439678458e-12,   8.839200932864032e-14,  -1.258046939394175e-15,   5.796266281154463e-18,   2.519767289220808e-19,  -8.834482788925239e-21,
   1.579124712194302e-22,  -1.320854340905786e-24,   4.403230644125037e-01,  -1.058242045683375e-02,   1.352139585206280e-04,  -3.627828892930729e-07,  -2.406218884550213e-08,
   4.840560860629506e-10,  -9.483467669092096e-13,  -1.397950444252956e-13,   2.790035491610015e-15,  -1.424056045191375e-19,  -1.032038709493677e-18,   1.912476601157831e-20,
   4.610938230208827e-23,  -8.505901519735982e-24,   4.403357135114219e-01,  -1.058252089954168e-02,   1.352004165667008e-04,  -3.623314012297390e-07,  -2.406343704441090e-08,
   4.837809027870621e-10,  -9.411125929941040e-13,  -1.397930264812902e-13,   2.785692757967127e-15,  -4.619287310741630e-20,  -1.031699597321017e-18,   1.906303220471426e-20,
   4.727881802608329e-23,  -8.497606152904030e-24,   4.403580320128233e-01,  -1.058269802944903e-02,   1.351765210248531e-04,  -3.615349531556815e-07,  -2.406563127558892e-08,
   4.832953420170097e-10,  -9.283570401822153e-13,  -1.397892035529638e-13,   2.778031146191252e-15,   1.233177000791541e-19,  -1.031095407362852e-18,   1.895415254770331e-20,
   4.933672994889180e-23,  -8.482872047164999e-24,   4.403850180224357e-01,  -1.058291204152312e-02,   1.351476253432193e-04,  -3.605722372156455e-07,  -2.406827052852147e-08,
   4.827082046182987e-10,  -9.129486781667682e-13,  -1.397841341805203e-13,   2.768768720201039e-15,   3.278514121961243e-19,  -1.030354907952602e-18,   1.882258079850920e-20,
   5.181567935581391e-23,  -8.464890875676215e-24,   4.404112137295753e-01,  -1.058311961720701e-02,   1.351195729376011e-04,  -3.596380236968411e-07,  -2.407081798166862e-08,
   4.821382304035170e-10,  -8.980070385175601e-13,  -1.397787458159885e-13,   2.759779109530167e-15,   5.259483268815017e-19,  -1.029625694440179e-18,   1.869494450532914e-20,
   5.421226220035809e-23,  -8.447263430093835e-24,   4.404323153294462e-01,  -1.058328670600729e-02,   1.350969735859556e-04,  -3.588857017250447e-07,  -2.407285965947311e-08,
   4.816790730130158e-10,  -8.859820910179838e-13,  -1.397740707760035e-13,   2.752538778928763e-15,   6.852025451201626e-19,  -1.029030851353945e-18,   1.859218812098741e-20,
   5.613580420517837e-23,  -8.432940479183470e-24,   4.404462582438589e-01,  -1.058339705095005e-02,   1.350820399959106e-04,  -3.583887121288687e-07,  -2.407420361686513e-08,
   4.813756732382010e-10,  -8.780420179497471e-13,  -1.397708181142307e-13,   2.747755277365151e-15,   7.902733336179968e-19,  -1.028634174248508e-18,   1.852432086813761e-20,
   5.740336606125985e-23,  -8.423416332261325e-24,   4.404534183975013e-01,  -1.058345369845663e-02,   1.350743707775952e-04,  -3.581335248153956e-07,  -2.407489221211688e-08,
   4.812198639636054e-10,  -8.739662034595996e-13,  -1.397690971969848e-13,   2.745298962671922e-15,   8.441822580055089e-19,  -1.028429344961496e-18,   1.848947781641601e-20,
   5.805324395632858e-23,  -8.418506774645848e-24,   4.404559105226984e-01,  -1.058347341197196e-02,   1.350717014191846e-04,  -3.580447110014190e-07,  -2.407513163073289e-08,
   4.811656332841743e-10,  -8.725478643282600e-13,  -1.397684901764946e-13,   2.744444058506926e-15,   8.629378012727331e-19,  -1.028357874617755e-18,   1.847735197262293e-20,
   5.827926869764434e-23,  -8.416795024063477e-24,   4.404563059871331e-01,  -1.058347654008495e-02,   1.350712778279734e-04,  -3.580306177793342e-07,  -2.407516961114750e-08,
   4.811570276301203e-10,  -8.723228069917151e-13,  -1.397683934691097e-13,   2.744308398826992e-15,   8.659136702183170e-19,  -1.028346524828274e-18,   1.847542784419739e-20,
   5.831512758431604e-23,  -8.416523253601629e-24,   7.925107311049799e-01,  -1.459010103379190e-02,   6.596998033221576e-05,   1.915584117686170e-06,  -2.520470270430107e-08,
  -3.918398281789692e-10,   1.009838767617233e-11,   7.292026999517633e-14,  -4.061113346845506e-15,  -2.515118268785688e-18,   1.595527116652239e-18,  -9.044023194423628e-21,
  -5.980056415077359e-22,   7.637889538351838e-24,   7.925168874790223e-01,  -1.458956356622734e-02,   6.595588210468746e-05,   1.915217974127659e-06,  -2.519062612041568e-08,
  -3.916964226168838e-10,   1.008786354264873e-11,   7.291062782530811e-14,  -4.054498259840267e-15,  -2.559686394636946e-18,   1.591906164190427e-18,  -8.990577329576438e-21,
  -5.962899525709686e-22,   7.593953010527813e-24,   7.925277494329226e-01,  -1.458861527975181e-02,   6.593101196827484e-05,   1.914572017302197e-06,  -2.516579974494857e-08,
  -3.914433972406868e-10,   1.006930759051440e-11,   7.289349328460807e-14,  -4.042838184490475e-15,  -2.638105957047483e-18,   1.585525518219285e-18,  -8.896529378700491e-21,
  -5.932670264914349e-22,   7.516655707256703e-24,   7.925408820081408e-01,  -1.458746874396641e-02,   6.590094965578378e-05,   1.913791105667786e-06,  -2.513579983943026e-08,
  -3.911374636547307e-10,   1.004689346830701e-11,   7.287256848792926e-14,  -4.028759734036935e-15,  -2.732554625009013e-18,   1.577824590058632e-18,  -8.783244777704171e-21,
  -5.896192262782163e-22,   7.423577224273156e-24,   7.925536289840922e-01,  -1.458635585592103e-02,   6.587177711604128e-05,   1.913033205209917e-06,  -2.510669781272939e-08,
  -3.908404974877945e-10,   1.002515926632429e-11,   7.285204035851466e-14,  -4.015114622413662e-15,  -2.823849794516588e-18,   1.570363949774211e-18,  -8.673728777921568e-21,
  -5.860859079652757e-22,   7.333625769165360e-24,   7.925638964205722e-01,  -1.458545943456136e-02,   6.584828428563400e-05,   1.912422790194104e-06,  -2.508326889462877e-08,
  -3.906012862030949e-10,   1.000766840067366e-11,   7.283534970412289e-14,  -4.004138045955243e-15,  -2.897114383206754e-18,   1.564364694709268e-18,  -8.585831959772396e-21,
  -5.832451696433381e-22,   7.261453240099776e-24,   7.925706802931464e-01,  -1.458486714757065e-02,   6.583276464963216e-05,   1.912019507241466e-06,  -2.506779496834902e-08,
  -3.904432298779318e-10,   9.996119518193957e-12,   7.282424582825587e-14,  -3.996892623141786e-15,  -2.945388699271328e-18,   1.560405844691524e-18,  -8.527911495806193e-21,
  -5.813708279415928e-22,   7.213905173566368e-24,   7.925741639302002e-01,  -1.458456299602610e-02,   6.582479581312537e-05,   1.911812423306398e-06,  -2.505985068089671e-08,
  -3.903620635661690e-10,   9.990191325248300e-12,   7.281852029754417e-14,  -3.993174132634449e-15,  -2.970137367102262e-18,   1.558374439408355e-18,  -8.498216034371475e-21,
  -5.804091192179337e-22,   7.189530891643669e-24,   7.925753764091683e-01,  -1.458445713586907e-02,   6.582202238385429e-05,   1.911740349214622e-06,  -2.505708596722878e-08,
  -3.903338133942523e-10,   9.988128394844609e-12,   7.281652379000867e-14,  -3.991880256847254e-15,  -2.978744606034288e-18,   1.557667653351130e-18,  -8.487888126140569e-21,
  -5.800745238320682e-22,   7.181054186504291e-24,   7.925755688113244e-01,  -1.458444033744224e-02,   6.582158228818893e-05,   1.911728912208778e-06,  -2.505664726273033e-08,
  -3.903293305050857e-10,   9.987801056680065e-12,   7.281620679691823e-14,  -3.991674954563593e-15,  -2.980110135420857e-18,   1.557555508628566e-18,  -8.486249602784795e-21,
  -5.800214346147317e-22,   7.179709381709924e-24,   1.170701720696996e+00,  -1.463351576493358e-02,  -5.986123841593099e-05,   1.919780845036218e-06,   2.351362517512491e-08,
  -3.901469923248015e-10,  -9.475272291522244e-12,   7.171372756256283e-14,   3.772609800616640e-15,  -2.457640996799597e-18,  -1.454128670072389e-18,  -8.560428591391872e-21,
   5.280147104608327e-22,   7.050046415190845e-24,   1.170696135116783e+00,  -1.463297711152632e-02,  -5.984808652591681e-05,   1.919416268576128e-06,   2.350041605006262e-08,
  -3.900059579597861e-10,  -9.465493477227923e-12,   7.170433969320758e-14,   3.766577776457149e-15,  -2.499871800320396e-18,  -1.450928297109490e-18,  -8.511035448191647e-21,
   5.265697275649975e-22,   7.010606377760678e-24,   1.170686280266044e+00,  -1.463202673225779e-02,  -5.982488582232482e-05,   1.918773075114560e-06,   2.347711947195074e-08,
  -3.897571161617182e-10,  -9.448251416416408e-12,   7.168766016913363e-14,   3.755945093103006e-15,  -2.574183859842972e-18,  -1.445288417532823e-18,  -8.424112234360116e-21,
   5.240236505485831e-22,   6.941215111349296e-24,   1.170674365368779e+00,  -1.463087766523989e-02,  -5.979684153325746e-05,   1.917995501890289e-06,   2.344896796984064e-08,
  -3.894562406522214e-10,  -9.427423959922336e-12,   7.166729629321889e-14,   3.743106538249484e-15,  -2.663694157976295e-18,  -1.438480928268120e-18,  -8.319398119113279e-21,
   5.209510710868692e-22,   6.857648918730816e-24,   1.170662800365831e+00,  -1.462976231928479e-02,  -5.976962735173965e-05,   1.917240839079203e-06,   2.342165883036311e-08,
  -3.891641839833347e-10,  -9.407227863120739e-12,   7.164732387149099e-14,   3.730662547029365e-15,  -2.750224957816337e-18,  -1.431885214118187e-18,  -8.218155405455284e-21,
   5.179747127239839e-22,   6.776881959916284e-24,   1.170653485019969e+00,  -1.462886391741170e-02,  -5.974771164508648e-05,   1.916633029959778e-06,   2.339967315726906e-08,
  -3.889289271506901e-10,  -9.390974498838333e-12,   7.163108886729545e-14,   3.720651754195482e-15,  -2.819672655173817e-18,  -1.426581008864859e-18,  -8.136890013585552e-21,
   5.155816130375818e-22,   6.712072720543729e-24,   1.170647330227141e+00,  -1.462827032151116e-02,  -5.973323389760948e-05,   1.916231467806222e-06,   2.338515237233571e-08,
  -3.887734835726513e-10,  -9.380242564239611e-12,   7.162028997259965e-14,   3.714043612380658e-15,  -2.865435201642988e-18,  -1.423080592558107e-18,  -8.083335152943135e-21,
   5.140025536522246e-22,   6.669372788344269e-24,   1.170644169638791e+00,  -1.462796549771019e-02,  -5.972580004442139e-05,   1.916025267234121e-06,   2.337769740497177e-08,
  -3.886936589430924e-10,  -9.374733674848820e-12,   7.161472226668169e-14,   3.710652120662600e-15,  -2.888897155060587e-18,  -1.421284354486653e-18,  -8.055876597751389e-21,
   5.131923291023525e-22,   6.647482884915466e-24,   1.170643069597679e+00,  -1.462785940355724e-02,  -5.972321280884972e-05,   1.915953500549243e-06,   2.337510297760305e-08,
  -3.886658757418240e-10,  -9.372816648968389e-12,   7.161278088271705e-14,   3.709472015960908e-15,  -2.897057050102831e-18,  -1.420659379088865e-18,  -8.046326463631343e-21,
   5.129104341160220e-22,   6.639870036323151e-24,   1.170642895037757e+00,  -1.462784256799797e-02,  -5.972280225898369e-05,   1.915942112321998e-06,   2.337469129395907e-08,
  -3.886614669537965e-10,  -9.372512462042411e-12,   7.161247264605100e-14,   3.709284765500956e-15,  -2.898351616321198e-18,  -1.420560214624231e-18,  -8.044811324276738e-21,
   5.128657065370324e-22,   6.638662273133883e-24,   1.520757170951292e+00,  -1.086872190044256e-02,  -1.285387303891642e-04,  -2.024845544107910e-07,   2.373268226318700e-08,
   4.160822731412002e-10,  -2.235280340274928e-14,  -1.274503394914729e-13,  -2.151949984088080e-15,   5.957627081173590e-18,   8.581853017421229e-19,   1.307972274371976e-20,
  -8.251467862094976e-23,  -6.435204595140255e-24,   1.520745147266308e+00,  -1.086877748301766e-02,  -1.285253813662092e-04,  -2.020965843936465e-07,   2.373258502175846e-08,
   4.158317065090324e-10,  -2.792730600964636e-14,  -1.274285287332165e-13,  -2.148347129498911e-15,   6.023261861818530e-18,   8.576426449503777e-19,   1.303318866230042e-20,
  -8.321312506196478e-23,  -6.425797973857890e-24,   1.520723932302043e+00,  -1.086887547100140e-02,  -1.285018268647807e-04,  -2.014121960546611e-07,   2.373240709370999e-08,
   4.153896134846055e-10,  -3.775592549308009e-14,  -1.273898645393403e-13,  -2.141991725084036e-15,   6.138880933189202e-18,   8.566816483769474e-19,   1.295113517201785e-20,
  -8.444161655413608e-23,  -6.409147249637906e-24,   1.520698280674717e+00,  -1.086899380851356e-02,  -1.284733446135427e-04,  -2.005849517752682e-07,   2.373218113013791e-08,
   4.148550910101556e-10,  -4.962770824094639e-14,  -1.273428069338763e-13,  -2.134309931469930e-15,   6.278357220704345e-18,   8.555136976858652e-19,   1.285201198261914e-20,
  -8.592043093170995e-23,  -6.388923687689036e-24,   1.520673380334897e+00,  -1.086910853084821e-02,  -1.284456946480305e-04,  -1.997822180927174e-07,   2.373195045502221e-08,
   4.143362501121236e-10,  -6.113892638253505e-14,  -1.272968058743916e-13,  -2.126855971206967e-15,   6.413411421660749e-18,   8.543737066252571e-19,   1.275588650961127e-20,
  -8.734904127937991e-23,  -6.369197902445548e-24,   1.520653322246071e+00,  -1.086920083672329e-02,  -1.284234202766600e-04,  -1.991357904018725e-07,   2.373175652539878e-08,
   4.139183248542833e-10,  -7.040239835320412e-14,  -1.272595202499347e-13,  -2.120853595364372e-15,   6.521960878452098e-18,   8.534509397468516e-19,   1.267852206627618e-20,
  -8.849490442402619e-23,  -6.353240670951223e-24,   1.520640068855353e+00,  -1.086926177551074e-02,  -1.284087018093681e-04,  -1.987087620223163e-07,   2.373162441599487e-08,
   4.136421899911719e-10,  -7.651873061708411e-14,  -1.272347711840315e-13,  -2.116888528776158e-15,   6.593566837205689e-18,   8.528390399598774e-19,   1.262743683313856e-20,
  -8.924962158984082e-23,  -6.342664033207575e-24,   1.520633262802083e+00,  -1.086929305339715e-02,  -1.284011431848403e-04,  -1.984894994789105e-07,   2.373155534600496e-08,
   4.135003885622876e-10,  -7.965827411976420e-14,  -1.272220269344664e-13,  -2.114852647993736e-15,   6.630302333609490e-18,   8.525241356953843e-19,   1.260121321321838e-20,
  -8.963644822381734e-23,  -6.337222435500838e-24,   1.520630893924279e+00,  -1.086930393723033e-02,  -1.283985123383857e-04,  -1.984131890270089e-07,   2.373153111050415e-08,
   4.134510343978470e-10,  -8.075078446961847e-14,  -1.272175857044922e-13,  -2.114144100103827e-15,   6.643082476361021e-18,   8.524144246942914e-19,   1.259208760939859e-20,
  -8.977096635231311e-23,  -6.335326849836236e-24,   1.520630518017485e+00,  -1.086930566421556e-02,  -1.283980948593827e-04,  -1.984010798886006e-07,   2.373152725540472e-08,
   4.134432026249337e-10,  -8.092413958797369e-14,  -1.272168806824908e-13,  -2.114031666116895e-15,   6.645110224986160e-18,   8.523970100538981e-19,   1.259063958567816e-20,
  -8.979230681079476e-23,  -6.335025971170052e-24,   1.795597033387732e+00,  -5.427674028882138e-03,  -9.629113939248355e-05,  -1.238322586262584e-06,  -8.959372729117005e-09,
   6.872029364428205e-11,   3.785749135251218e-12,   7.257498699536489e-14,   7.206767830850767e-16,  -3.212295643476821e-18,  -2.995485597915465e-19,  -6.693634632115183e-21,
  -7.839939278960679e-23,   1.164178751378677e-25,   1.795587996055665e+00,  -5.428022075011282e-03,  -9.629614884307808e-05,  -1.238256961576262e-06,  -8.954027012104199e-09,
   6.886298662116170e-11,   3.787614449664771e-12,   7.256324734195147e-14,   7.193979055610761e-16,  -3.246758938424135e-18,  -3.000218783700633e-19,  -6.692392803912269e-21,
  -7.814630737872849e-23,   1.234964564387424e-25,   1.795572049162611e+00,  -5.428636192676658e-03,  -9.630498564774550e-05,  -1.238141057082766e-06,  -8.944592288038061e-09,
   6.911475139447026e-11,   3.790903087880506e-12,   7.254243801380247e-14,   7.171396929902752e-16,  -3.307564359519020e-18,  -3.008557752614939e-19,  -6.690159508245714e-21,
  -7.769900353078204e-23,   1.359858442432424e-25,   1.795552765363984e+00,  -5.429378764376731e-03,  -9.631566702874120e-05,  -1.238000718794978e-06,  -8.933180102342699e-09,
   6.941915515741168e-11,   3.794875072782241e-12,   7.251711398985711e-14,   7.144062908393585e-16,  -3.381081246632540e-18,  -3.018619452607063e-19,  -6.687387254144579e-21,
  -7.715687563602803e-23,   1.510865630116765e-25,   1.795534044310635e+00,  -5.430099612940921e-03,  -9.632603195290686e-05,  -1.237864286745651e-06,  -8.922097565543664e-09,
   6.971463048602209e-11,   3.798726111958324e-12,   7.249236111266034e-14,   7.117498781726763e-16,  -3.452439879515598e-18,  -3.028364242523894e-19,  -6.684620889345236e-21,
  -7.662928851871894e-23,   1.657443183748670e-25,   1.795518962389674e+00,  -5.430680299674500e-03,  -9.633437866532288e-05,  -1.237754239820551e-06,  -8.913166908393857e-09,
   6.995263670209923e-11,   3.801824949671425e-12,   7.247229961574875e-14,   7.096078507765859e-16,  -3.509917985851000e-18,  -3.036198063791930e-19,  -6.682338530891998e-21,
  -7.620334293488719e-23,   1.775510804853695e-25,   1.795508996288120e+00,  -5.431063997571903e-03,  -9.633989248863490e-05,  -1.237681454698720e-06,  -8.907264363318001e-09,
   7.010989475704965e-11,   3.803870887299420e-12,   7.245898414376246e-14,   7.081914317098873e-16,  -3.547894788167879e-18,  -3.041366447598071e-19,  -6.680804043499042e-21,
  -7.592143209985252e-23,   1.853520953686927e-25,   1.795503878144871e+00,  -5.431261041846264e-03,  -9.634272362579491e-05,  -1.237644055004263e-06,  -8.904232714107092e-09,
   7.019065050788153e-11,   3.804921042328265e-12,   7.245212770691903e-14,   7.074637220135276e-16,  -3.567396537692164e-18,  -3.044018163652595e-19,  -6.680007863552163e-21,
  -7.577651731937575e-23,   1.893580721998283e-25,   1.795502096716584e+00,  -5.431329624439839e-03,  -9.634370895339498e-05,  -1.237631034346714e-06,  -8.903177455596338e-09,
   7.021875768322148e-11,   3.805286473717693e-12,   7.244973834720720e-14,   7.072103865414109e-16,  -3.574184115402538e-18,  -3.044940720119002e-19,  -6.679729448810788e-21,
  -7.572605611986292e-23,   1.907523539230719e-25,   1.795501814027895e+00,  -5.431340507530561e-03,  -9.634386530772515e-05,  -1.237628967988584e-06,  -8.903009997507096e-09,
   7.022321787619546e-11,   3.805344458625770e-12,   7.244935905038848e-14,   7.071701833439386e-16,  -3.575261201715046e-18,  -3.045087098246196e-19,  -6.679685206652632e-21,
  -7.571804756496652e-23,   1.909736055478729e-25,   1.960200745705388e+00,  -1.147905228565399e-03,  -2.435376829485915e-05,  -4.470021294837412e-07,  -7.415177772891893e-09,
  -1.123110886363666e-10,  -1.538253630664229e-12,  -1.836311591385636e-14,  -1.702608275333907e-16,  -5.819526926377699e-19,   2.373697073026432e-20,   8.256081756874270e-22,
   1.810225291863192e-23,   3.210410635187949e-25,   1.960198454146110e+00,  -1.148031319677350e-03,  -2.435795156703274e-05,  -4.471077251566444e-07,  -7.417346194352990e-09,
  -1.123472701256681e-10,  -1.538698409215673e-12,  -1.836496624253776e-14,  -1.701570147451871e-16,  -5.776029287297338e-19,   2.385089553328673e-20,   8.279866028788539e-22,
   1.814357710508138e-23,   3.216001166689874e-25,   1.960194410333346e+00,  -1.148253833629533e-03,  -2.436533400959286e-05,  -4.472940779715954e-07,  -7.421172915848323e-09,
  -1.124111158391094e-10,  -1.539483004195299e-12,  -1.836821917308769e-14,  -1.699734430107220e-16,  -5.699176997269279e-19,   2.405212592791603e-20,   8.321866937568211e-22,
   1.821653102644159e-23,   3.225862082615959e-25,   1.960189519965438e+00,  -1.148522941147925e-03,  -2.437426263132166e-05,  -4.475194648294359e-07,  -7.425801093886134e-09,
  -1.124883237003652e-10,  -1.540431362703437e-12,  -1.837213216563459e-14,  -1.697507964812038e-16,  -5.606075746706737e-19,   2.429581114388106e-20,   8.372711456084937e-22,
   1.830481010928438e-23,   3.237779689129949e-25,   1.960184771908769e+00,  -1.148784229291570e-03,  -2.438293215615977e-05,  -4.477383157543768e-07,  -7.430294955149191e-09,
  -1.125632809143686e-10,  -1.541351611835700e-12,  -1.837590935445554e-14,  -1.695339532322905e-16,  -5.515515849863033e-19,   2.453274873089770e-20,   8.422129655142193e-22,
   1.839057498799016e-23,   3.249342390012088e-25,   1.960180946526068e+00,  -1.148994750595291e-03,  -2.438991748341970e-05,  -4.479146545129120e-07,  -7.433915800428694e-09,
  -1.126236691555375e-10,  -1.542092664813980e-12,  -1.837893680377048e-14,  -1.693587638152217e-16,  -5.442433769109747e-19,   2.472388936010100e-20,   8.461982730890344e-22,
   1.845971247620537e-23,   3.258652284698719e-25,   1.960178418580561e+00,  -1.149133874489355e-03,  -2.439453388550678e-05,  -4.480311933073045e-07,  -7.436308708232483e-09,
  -1.126635744286784e-10,  -1.542582198318788e-12,  -1.838092973885746e-14,  -1.692427551544573e-16,  -5.394079624644595e-19,   2.485032235561007e-20,   8.488337696259026e-22,
   1.850541994011986e-23,   3.264801689127363e-25,   1.960177120297493e+00,  -1.149205325956622e-03,  -2.439690482132123e-05,  -4.480910468997902e-07,  -7.437537679138395e-09,
  -1.126840682512133e-10,  -1.542833553515144e-12,  -1.838195087017346e-14,  -1.691831028504542e-16,  -5.369228026661793e-19,   2.491529216975844e-20,   8.501878651892537e-22,
   1.852889989465949e-23,   3.267958952426628e-25,   1.960176668408297e+00,  -1.149230196040954e-03,  -2.439773007788417e-05,  -4.481118803417808e-07,  -7.437965449357437e-09,
  -1.126912014021493e-10,  -1.542921033034920e-12,  -1.838230591222147e-14,  -1.691623281683861e-16,  -5.360575106280699e-19,   2.493791194453565e-20,   8.506592727448227e-22,
   1.853707341825864e-23,   3.269057746933759e-25,   1.960176596699235e+00,  -1.149234142616275e-03,  -2.439786103618970e-05,  -4.481151863625018e-07,  -7.438033331342337e-09,
  -1.126923333391547e-10,  -1.542934914499514e-12,  -1.838236223483934e-14,  -1.691590309355214e-16,  -5.359201860085034e-19,   2.494150169682261e-20,   8.507340834828325e-22,
   1.853837049656827e-23,   3.269232104787586e-25,   1.702784473257409e-02,  -4.965098048908691e-04,   1.076441967569319e-05,  -2.051348066584508e-07,   3.610735227304222e-09,
  -5.990035857513413e-11,   9.435746918122216e-13,  -1.413215338754974e-14,   2.001715500508759e-16,  -2.648975772254953e-18,   3.181482302224809e-20,  -3.237483012436291e-22,
   2.115088765023848e-24,   1.317097115877285e-26,   1.702885798742244e-02,  -4.965676976242226e-04,   1.076645823886617e-05,  -2.051911984047223e-07,   3.612068377769177e-09,
  -5.992832419157777e-11,   9.441029227266319e-13,  -1.414113704839774e-14,   2.003061752981976e-16,  -2.650640755303566e-18,   3.182753189718933e-20,  -3.236388081013754e-22,
   2.106983110091553e-24,   1.340831333164565e-26,   1.703064604784703e-02,  -4.966698631998836e-04,   1.077005592685325e-05,  -2.052907238889077e-07,   3.614421347787284e-09,
  -5.997768436311318e-11,   9.450352820532946e-13,  -1.415699342481763e-14,   2.005437669238690e-16,  -2.653578171550254e-18,   3.184991570540660e-20,  -3.234441805908978e-22,
   2.092642028940434e-24,   1.382815374826225e-26,   1.703280845616161e-02,  -4.967934249674420e-04,   1.077440733194128e-05,  -2.054111075971709e-07,   3.617267616159814e-09,
  -6.003739577047501e-11,   9.461631913036928e-13,  -1.417617490830116e-14,   2.008311389188332e-16,  -2.657129316834724e-18,   3.187691206013615e-20,  -3.232064006852074e-22,
   2.075234861284866e-24,   1.433761352633540e-26,   1.703490796388629e-02,  -4.969133996998169e-04,   1.077863269244335e-05,  -2.055280121754515e-07,   3.620031805096153e-09,
  -6.009538829709784e-11,   9.472586596926354e-13,  -1.419480411029255e-14,   2.011101916914995e-16,  -2.660575853907871e-18,   3.190304577692393e-20,  -3.229730135178211e-22,
   2.058267286336141e-24,   1.483405675904347e-26,   1.703659950005592e-02,  -4.970100663433506e-04,   1.078203737033345e-05,  -2.056222163304152e-07,   3.622259374399022e-09,
  -6.014212475946046e-11,   9.481415228393187e-13,  -1.420981739168310e-14,   2.013350480689309e-16,  -2.663351724257106e-18,   3.192404570648306e-20,  -3.227831656899900e-22,
   2.044548911048864e-24,   1.523532377270720e-26,   1.703771733498478e-02,  -4.970739500484742e-04,   1.078428750399347e-05,  -2.056844781503919e-07,   3.623731691879524e-09,
  -6.017301641031805e-11,   9.487250833131913e-13,  -1.421974075894358e-14,   2.014836560968284e-16,  -2.665185667266072e-18,   3.193789606120456e-20,  -3.226568180257400e-22,
   2.035459775327850e-24,   1.550112939157296e-26,   1.703829142700523e-02,  -4.971067598958632e-04,   1.078544317380410e-05,  -2.057164567164271e-07,   3.624487914694074e-09,
  -6.018888354386771e-11,   9.490248252828189e-13,  -1.422483776675392e-14,   2.015599817534552e-16,  -2.666127390829336e-18,   3.194500082235369e-20,  -3.225916539146329e-22,
   2.030784554183107e-24,   1.563783602477936e-26,   1.703849124981404e-02,  -4.971181800630241e-04,   1.078584543413346e-05,  -2.057275878087076e-07,   3.624751143652280e-09,
  -6.019440668964625e-11,   9.491291620952461e-13,  -1.422661196771205e-14,   2.015865489216774e-16,  -2.666455151358428e-18,   3.194747241565424e-20,  -3.225689285757001e-22,
   2.029156103624747e-24,   1.568545029544386e-26,   1.703852295917079e-02,  -4.971199923052286e-04,   1.078590926820348e-05,  -2.057293541910631e-07,   3.624792915349639e-09,
  -6.019528315792445e-11,   9.491457193317588e-13,  -1.422689351564937e-14,   2.015907648282481e-16,  -2.666507161728620e-18,   3.194786456250300e-20,  -3.225653202702504e-22,
   2.028897634109369e-24,   1.569300755665078e-26,   1.501581502967388e-01,  -4.101139772218616e-03,   7.742481627489450e-05,  -1.139808634290090e-06,   1.226077854745052e-08,
  -5.331163237876802e-11,  -1.545274634173233e-12,   5.242226730801905e-14,  -9.433957902639289e-16,   1.023151206215616e-17,  -1.973655434526030e-21,  -2.973570521307605e-21,
   8.155196748849599e-23,  -1.330258258322158e-24,   1.501654226784150e-01,  -4.101460515545982e-03,   7.743170050199197e-05,  -1.139857741023770e-06,   1.225857622643408e-08,
  -5.320788444025641e-11,  -1.547750827015842e-12,   5.245638763285149e-14,  -9.433877380709865e-16,   1.021580413901270e-17,  -1.464904072698791e-21,  -2.983231269133278e-21,
   8.164230254697321e-23,  -1.329073031109000e-24,   1.501782554337006e-01,  -4.102026483278097e-03,   7.744384681513572e-05,  -1.139944311386836e-06,   1.225468736540410e-08,
  -5.302476515804007e-11,  -1.552120081176793e-12,   5.251655010705313e-14,  -9.433717812796697e-16,   1.018804683231554e-17,  -5.667557765204729e-22,  -3.000270538411625e-21,
   8.180116516415685e-23,  -1.326964901242358e-24,   1.501937738309106e-01,  -4.102710876395582e-03,   7.745853253714859e-05,  -1.140048858053955e-06,   1.224998008611747e-08,
  -5.280324263521021e-11,  -1.557403381285627e-12,   5.258922517854444e-14,  -9.433495036542803e-16,   1.015441348656479e-17,   5.200576441144721e-22,  -3.020862136880361e-21,
   8.199235006650100e-23,  -1.324387131839107e-24,   1.502088397567508e-01,  -4.103375293151434e-03,   7.747278736949932e-05,  -1.140150208594399e-06,   1.224540528614011e-08,
  -5.258809535940327e-11,  -1.562532263306257e-12,   5.265969925425983e-14,  -9.433247523418275e-16,   1.012169067792304e-17,   1.575913842541284e-21,  -3.040838960820440e-21,
   8.217699091803458e-23,  -1.321854746706764e-24,   1.502209773401696e-01,  -4.103910552799513e-03,   7.748426957771333e-05,  -1.140231753823181e-06,   1.224171626510061e-08,
  -5.241470602233805e-11,  -1.566663982775805e-12,   5.271641656640758e-14,  -9.433025733191572e-16,   1.009527794089250e-17,   2.427066916903342e-21,  -3.056922551845469e-21,
   8.232504758106831e-23,  -1.319793254824783e-24,   1.502289979668504e-01,  -4.104264249763414e-03,   7.749185617983594e-05,  -1.140285587775501e-06,   1.223927685245935e-08,
  -5.230009943065460e-11,  -1.569394128301055e-12,   5.275386706263287e-14,  -9.432868208281562e-16,   1.007779958459894e-17,   2.989771654546116e-21,  -3.067545636569999e-21,
   8.242254367305469e-23,  -1.318420566555192e-24,   1.502331170437889e-01,  -4.104445892218432e-03,   7.749575206611417e-05,  -1.140313218719015e-06,   1.223802354895302e-08,
  -5.224123294896186e-11,  -1.570796181938428e-12,   5.277309123782286e-14,  -9.432783918362977e-16,   1.006881579277771e-17,   3.278833276214677e-21,  -3.072999650683991e-21,
   8.247250823150268e-23,  -1.317712381850026e-24,   1.502345507423759e-01,  -4.104509114878981e-03,   7.749710803365514e-05,  -1.140322833475321e-06,   1.223758723788547e-08,
  -5.222074225755003e-11,  -1.571284178458647e-12,   5.277978104282086e-14,  -9.432754040189141e-16,   1.006568765702826e-17,   3.379457469754156e-21,  -3.074897739219745e-21,
   8.248988223261024e-23,  -1.317465375372190e-24,   1.502347782513625e-01,  -4.104519147460663e-03,   7.749732320554050e-05,  -1.140324359088577e-06,   1.223751799718339e-08,
  -5.221749058759159e-11,  -1.571361616733601e-12,   5.278084255886762e-14,  -9.432749273283389e-16,   1.006519120587761e-17,   3.395425791151488e-21,  -3.075198928752546e-21,
   8.249263845808333e-23,  -1.317426154336866e-24,   4.001209472809295e-01,  -9.523945429839897e-03,   1.288628603485259e-04,  -6.727174558513729e-07,  -1.487451166710685e-08,
   4.241644579623783e-10,  -3.660763100051434e-12,  -5.693360278743493e-14,   2.240870843689773e-15,  -2.521389601927644e-17,  -2.606928895312361e-19,   1.405403352963708e-20,
  -1.930906222425367e-22,  -1.174683763832369e-24,   4.001330112961911e-01,  -9.524133234162345e-03,   1.288544648223878e-04,  -6.723207572552431e-07,  -1.487959035778657e-08,
   4.240510506570916e-10,  -3.654904416148590e-12,  -5.701682163507337e-14,   2.239734032373146e-15,  -2.514180079457104e-17,  -2.618499692860248e-19,   1.404463116271699e-20,
  -1.922771397417344e-22,  -1.189514129748049e-24,   4.001542977979311e-01,  -9.524464527307366e-03,   1.288396484779628e-04,  -6.716208631740778e-07,  -1.488854509870003e-08,
   4.238508094043135e-10,  -3.644569124540928e-12,  -5.716346505752119e-14,   2.237724175373030e-15,  -2.501462787723173e-17,  -2.638875671948328e-19,   1.402795335212534e-20,
  -1.908421518680383e-22,  -1.215609718573550e-24,   4.001800365668287e-01,  -9.524864976159658e-03,   1.288217284653296e-04,  -6.707746918981042e-07,  -1.489936186425413e-08,
   4.236084502123730e-10,  -3.632075759783693e-12,  -5.734045109947920e-14,   2.235287133971331e-15,  -2.486091788951209e-17,  -2.663444842652031e-19,   1.400763800164214e-20,
  -1.891076637667696e-22,  -1.247040666253847e-24,   4.002050221698048e-01,  -9.525253563348639e-03,   1.288043279137898e-04,  -6.699533986730371e-07,  -1.490985065454590e-08,
   4.233729364170843e-10,  -3.619951802377697e-12,  -5.751191354076273e-14,   2.232914291548554e-15,  -2.471177132348758e-17,  -2.687223218030901e-19,   1.398776122374517e-20,
  -1.874246103358965e-22,  -1.277423383477450e-24,   4.002251494237621e-01,  -9.525566488343332e-03,   1.287903073103430e-04,  -6.692918867948244e-07,  -1.491829173547438e-08,
   4.231830408918833e-10,  -3.610188046810873e-12,  -5.764978892600591e-14,   2.230997750252584e-15,  -2.459167290790887e-17,  -2.706326512864886e-19,   1.397163796827385e-20,
  -1.860693137387060e-22,  -1.301806281242635e-24,   4.002384487516818e-01,  -9.525773206915760e-03,   1.287810413039583e-04,  -6.688548260323774e-07,  -1.492386526473435e-08,
   4.230574788026801e-10,  -3.603737873919087e-12,  -5.774077090821690e-14,   2.229728884213476e-15,  -2.451233962284809e-17,  -2.718924049742311e-19,   1.396092987403997e-20,
  -1.851740295093687e-22,  -1.317872539222848e-24,   4.002452784682959e-01,  -9.525879349263133e-03,   1.287762823207145e-04,  -6.686303912788875e-07,  -1.492672624408435e-08,
   4.229929711620017e-10,  -3.600425879091615e-12,  -5.778745628595028e-14,   2.229076503941445e-15,  -2.447160612381194e-17,  -2.725385578009010e-19,   1.395541403666050e-20,
  -1.847143427816210e-22,  -1.326109256351997e-24,   4.002476555938672e-01,  -9.525916290288344e-03,   1.287746258420888e-04,  -6.685522773923280e-07,  -1.492772182805709e-08,
   4.229705146287835e-10,  -3.599273185032486e-12,  -5.780369947450938e-14,   2.228849316588285e-15,  -2.445742972201677e-17,  -2.727633312966526e-19,   1.395349153935689e-20,
  -1.845543581186097e-22,  -1.328973880798622e-24,   4.002480328100151e-01,  -9.525922152187798e-03,   1.287743629783775e-04,  -6.685398819217949e-07,  -1.492787980373865e-08,
   4.229669508936154e-10,  -3.599090271972600e-12,  -5.780627675597925e-14,   2.228813259368574e-15,  -2.445518018240776e-17,  -2.727989937775119e-19,   1.395318633929356e-20,
  -1.845289713984157e-22,  -1.329428350895820e-24,   7.353410779010391e-01,  -1.397775649318279e-02,   8.632264638322517e-05,   1.463215843483395e-06,  -3.052723505131566e-08,
  -1.393332236005869e-10,   1.038827910479116e-11,  -4.738222510498329e-14,  -3.163186402408119e-15,   4.663897859013990e-17,   7.436241264156262e-19,  -2.520200503382466e-20,
  -4.969051687654463e-23,   1.066660340446044e-23,   7.353491363286836e-01,  -1.397734542748353e-02,   8.630555670468255e-05,   1.463084457497455e-06,  -3.051272389359971e-08,
  -1.394240632679367e-10,   1.038004028558577e-11,  -4.722811780884843e-14,  -3.160060295335596e-15,   4.651197963947469e-17,   7.432852639814352e-19,  -2.512592430678400e-20,
  -5.037594297110020e-23,   1.063170493345300e-23,   7.353633542584340e-01,  -1.397662012575332e-02,   8.627540831085279e-05,   1.462852556367973e-06,  -3.048712812108832e-08,
  -1.395841062483518e-10,   1.036550942401482e-11,  -4.695653936573877e-14,  -3.154545419767266e-15,   4.628820496392951e-17,   7.426839462784791e-19,  -2.499188495262091e-20,
  -5.158009267900030e-23,   1.057021405282915e-23,   7.353805445273509e-01,  -1.397574313459228e-02,   8.623896382336550e-05,   1.462572022389683e-06,  -3.045619345107984e-08,
  -1.397772144915936e-10,   1.034794991275410e-11,  -4.662873369670819e-14,  -3.147878809449024e-15,   4.601815410658175e-17,   7.419510650373337e-19,  -2.483015450945575e-20,
  -5.302715634473303e-23,   1.049600866012260e-23,   7.353972302356484e-01,  -1.397489182063532e-02,   8.620359594642672e-05,   1.462299562861857e-06,  -3.042617936944237e-08,
  -1.399642439755081e-10,   1.033091533888879e-11,  -4.631112259398141e-14,  -3.141409121810412e-15,   4.575655800393317e-17,   7.412335863521010e-19,  -2.467351689552689e-20,
  -5.442253679036632e-23,   1.042412840869243e-23,   7.354106703724711e-01,  -1.397420605179761e-02,   8.617511249719436e-05,   1.462079985712535e-06,  -3.040201241975824e-08,
  -1.401145999724350e-10,   1.031720102934348e-11,  -4.605570074148151e-14,  -3.136198767556823e-15,   4.554622358569873e-17,   7.406513047528482e-19,  -2.454759466177701e-20,
  -5.553991907291135e-23,   1.036633510394341e-23,   7.354195505663306e-01,  -1.397375292687688e-02,   8.615629527885118e-05,   1.461934850347009e-06,  -3.038604920558831e-08,
  -1.402137996539884e-10,   1.030814302967768e-11,  -4.588713849725861e-14,  -3.132756616115777e-15,   4.540743594440300e-17,   7.402644494375458e-19,  -2.446451613039773e-20,
  -5.627498402355208e-23,   1.032820137943499e-23,   7.354241107205761e-01,  -1.397352023139796e-02,   8.614663301619285e-05,   1.461860303197740e-06,  -3.037785314799981e-08,
  -1.402646961857589e-10,   1.030349260346011e-11,  -4.580064046306820e-14,  -3.130989141620240e-15,   4.533622291246647e-17,   7.400651345235335e-19,  -2.442189108400729e-20,
  -5.665146195681754e-23,   1.030863491198991e-23,   7.354256978841915e-01,  -1.397343924053683e-02,   8.614327018084148e-05,   1.461834354280029e-06,  -3.037500072428404e-08,
  -1.402824036698709e-10,   1.030187418538843e-11,  -4.577054465174656e-14,  -3.130373993397342e-15,   4.531144628174924e-17,   7.399956583904163e-19,  -2.440706137279037e-20,
  -5.678233741490935e-23,   1.030182733384609e-23,   7.354259497433078e-01,  -1.397342638844680e-02,   8.614273655485254e-05,   1.461830236444499e-06,  -3.037454809765243e-08,
  -1.402852132467876e-10,   1.030161737447857e-11,  -4.576576936513631e-14,  -3.130276379625829e-15,   4.530751503290919e-17,   7.399846286094579e-19,  -2.440470840214964e-20,
  -5.680309790114367e-23,   1.030074719359787e-23,   1.111363932724487e+00,  -1.501452941327925e-02,  -3.486163499165786e-05,   2.222142646106979e-06,   1.366792758875274e-08,
  -5.803084333971902e-10,  -5.872386753389959e-12,   1.795460758456996e-13,   2.621224864652334e-15,  -5.983308924545648e-17,  -1.199636859858267e-18,   2.037221075558318e-20,
   5.542678115891747e-22,  -6.880765378403279e-24,   1.111360679792544e+00,  -1.501390634215718e-02,  -3.485399291612671e-05,   2.221601550270331e-06,   1.365974956720921e-08,
  -5.799581161706400e-10,  -5.865608049256534e-12,   1.793468206045940e-13,   2.616270536944357e-15,  -5.972995193963471e-17,  -1.196305353160161e-18,   2.032303044756135e-20,
   5.521395615993584e-22,  -6.860115959548008e-24,   1.111354940519858e+00,  -1.501280704655861e-02,  -3.484051207455869e-05,   2.220647044175792e-06,   1.364532702932166e-08,
  -5.793402935144715e-10,  -5.853657427770029e-12,   1.789955131908368e-13,   2.607539888440417e-15,  -5.954816954495725e-17,  -1.190437465440461e-18,   2.023637306604189e-20,
   5.483930868131375e-22,  -6.823732826128054e-24,   1.111348001513479e+00,  -1.501147797659720e-02,  -3.482421723899248e-05,   2.219493298631571e-06,   1.362790028004084e-08,
  -5.785937569863339e-10,  -5.839224510125870e-12,   1.785711882695683e-13,   2.597002007005195e-15,  -5.932870553061725e-17,  -1.183360010551075e-18,   2.013179391671229e-20,
   5.438778787815939e-22,  -6.779828419411057e-24,   1.111341266275842e+00,  -1.501018795836476e-02,  -3.480840513300714e-05,   2.218373737038836e-06,   1.361099644065654e-08,
  -5.778695986247031e-10,  -5.825232008811211e-12,   1.781597628884414e-13,   2.586792205894071e-15,  -5.911601889742868e-17,  -1.176508210991567e-18,   2.003048770594257e-20,
   5.395103344734089e-22,  -6.737301443744468e-24,   1.111335841193549e+00,  -1.500914889395842e-02,  -3.479567186022720e-05,   2.217472172687057e-06,   1.359738876991186e-08,
  -5.772866315968610e-10,  -5.813973233524850e-12,   1.778286832218535e-13,   2.578581767995124e-15,  -5.894494268608122e-17,  -1.171001984276397e-18,   1.994903232470818e-20,
   5.360031488998418e-22,  -6.703110038347730e-24,   1.111332256756874e+00,  -1.500846237581279e-02,  -3.478726026730752e-05,   2.216876601392192e-06,   1.358840187964718e-08,
  -5.769016158172564e-10,  -5.806540191293440e-12,   1.776100874452180e-13,   2.573163520637322e-15,  -5.883202642257696e-17,  -1.167370163765481e-18,   1.989528416004543e-20,
   5.336911610571560e-22,  -6.680550129208523e-24,   1.111330416088779e+00,  -1.500810983973818e-02,  -3.478294123129271e-05,   2.216570798473319e-06,   1.358378817029686e-08,
  -5.767039531399861e-10,  -5.802724994653866e-12,   1.774978823830790e-13,   2.570383173984456e-15,  -5.877407803006143e-17,  -1.165507087701138e-18,   1.986770542375329e-20,
   5.325055426037348e-22,  -6.668974787704207e-24,   1.111329775445165e+00,  -1.500798714012436e-02,  -3.478143806577287e-05,   2.216464369154824e-06,   1.358218256347038e-08,
  -5.766351645995761e-10,  -5.801397402986309e-12,   1.774588370302080e-13,   2.569415796176424e-15,  -5.875391484927972e-17,  -1.164858951187674e-18,   1.985811013464558e-20,
   5.320931473469863e-22,  -6.664947515707943e-24,   1.111329673784690e+00,  -1.500796766956566e-02,  -3.478119953954301e-05,   2.216447480676430e-06,   1.358192778702812e-08,
  -5.766242492690975e-10,  -5.801186747778579e-12,   1.774526414808758e-13,   2.569262303125570e-15,  -5.875071552864083e-17,  -1.164756116234599e-18,   1.985658767205706e-20,
   5.320277187178203e-22,  -6.664308520556797e-24,   1.475220213775423e+00,  -1.189967003278146e-02,  -1.284193292861842e-04,   2.424341243938557e-07,   3.172147765029321e-08,
   3.654019002078082e-10,  -4.469610054835233e-12,  -1.852536073285728e-13,  -1.201240594105105e-15,   4.928641692940946e-17,   1.210946479323504e-18,  -3.427196337768135e-22,
  -4.891664694301175e-22,  -7.671122582916984e-24,   1.475208210233754e+00,  -1.189960065307709e-02,  -1.284015216908503e-04,   2.427736464012138e-07,   3.171515636446711e-08,
   3.650398267686642e-10,  -4.472660073874063e-12,  -1.850873743874545e-13,  -1.196228034038119e-15,   4.928257291347948e-17,   1.207952251429467e-18,  -3.964625987341475e-22,
  -4.884692890200679e-22,  -7.628310636264410e-24,   1.475187031148334e+00,  -1.189947815438929e-02,  -1.283701028074832e-04,   2.433724631791282e-07,   3.170399890946891e-08,
   3.644012084949486e-10,  -4.478031241267709e-12,  -1.847940658096096e-13,  -1.187393533904877e-15,   4.927556719481713e-17,   1.202672425363705e-18,  -4.910401313057014e-22,
  -4.872364592478774e-22,  -7.552897657648444e-24,   1.475161423478246e+00,  -1.189932989623447e-02,  -1.283321157016768e-04,   2.440960898182625e-07,   3.169050132702855e-08,
   3.636294380023023e-10,  -4.484507988515726e-12,  -1.844394149258290e-13,  -1.176728215294001e-15,   4.926671647833409e-17,   1.196294041703746e-18,  -6.049738190451961e-22,
  -4.857412203658566e-22,  -7.461928040885101e-24,   1.475136566410323e+00,  -1.189918583220374e-02,  -1.282952436552184e-04,   2.447980830714019e-07,   3.167739197262391e-08,
   3.628806914988779e-10,  -4.490776540577056e-12,  -1.840951484894672e-13,  -1.166392774908711e-15,   4.925772805057908e-17,   1.190108352074898e-18,  -7.151285533586652e-22,
  -4.842849943912881e-22,  -7.373847240953439e-24,   1.475116543609802e+00,  -1.189906967755669e-02,  -1.282655437252749e-04,   2.453632480593848e-07,   3.166682685892489e-08,
   3.622778513260107e-10,  -4.495812831781331e-12,  -1.838178284213906e-13,  -1.158079758757719e-15,   4.925020378774762e-17,   1.185129787855405e-18,  -8.035457407153171e-22,
  -4.831085469573244e-22,  -7.303055923817990e-24,   1.475103313746978e+00,  -1.189899287640414e-02,  -1.282459203581270e-04,   2.457365268898168e-07,   3.165984347439249e-08,
   3.618796718802477e-10,  -4.499134083098122e-12,  -1.836345884879337e-13,  -1.152593067155115e-15,   4.924509343835153e-17,   1.181842270823481e-18,  -8.618127577167559e-22,
  -4.823295479492940e-22,  -7.256359268923213e-24,   1.475096519841343e+00,  -1.189895342042494e-02,  -1.282358433823050e-04,   2.459281702093004e-07,   3.165625650938253e-08,
   3.616752392044566e-10,  -4.500837652179004e-12,  -1.835404885907624e-13,  -1.149777367525336e-15,   4.924242626805889e-17,   1.180154663710185e-18,  -8.916869958696143e-22,
  -4.819289941582513e-22,  -7.232403345359366e-24,   1.475094155201972e+00,  -1.189893968503625e-02,  -1.282323360880907e-04,   2.459948649498146e-07,   3.165500792788319e-08,
   3.616040927417438e-10,  -4.501430268358480e-12,  -1.835077366728201e-13,  -1.148797652491340e-15,   4.924149113230794e-17,   1.179567386539080e-18,  -9.020772544403688e-22,
  -4.817894981969717e-22,  -7.224069253429779e-24,   1.475093779968250e+00,  -1.189893750530654e-02,  -1.282317795330513e-04,   2.460054480844317e-07,   3.165480979018871e-08,
   3.615928031673417e-10,  -4.501524292879925e-12,  -1.835025394141741e-13,  -1.148642200161580e-15,   4.924134241629672e-17,   1.179474198960555e-18,  -9.037256778378111e-22,
  -4.817673583355676e-22,  -7.222746937073915e-24,   1.772248308643338e+00,  -6.259739436808481e-03,  -1.119477679800700e-04,  -1.365005188966746e-06,  -6.499122948911082e-09,
   1.863644545080285e-10,   6.103189673643748e-12,   9.083458905155844e-14,   3.089257776791924e-16,  -2.209212918473813e-17,  -6.646362189448392e-19,  -9.339699720835205e-21,
  -4.975008488814645e-24,   3.254101549907528e-24,   1.772237806320498e+00,  -6.260122722773741e-03,  -1.119513752293309e-04,  -1.364828980433984e-06,  -6.490531540267783e-09,
   1.865420765125091e-10,   6.103942700254302e-12,   9.075880143975336e-14,   3.061221263572033e-16,  -2.213933671988646e-17,  -6.646328988505825e-19,  -9.315362793582014e-21,
  -4.238226001681736e-24,   3.263994948391962e-24,   1.772219274537194e+00,  -6.260798996348952e-03,  -1.119577363464761e-04,  -1.364517922692711e-06,  -6.475371026190107e-09,
   1.868553714299484e-10,   6.105265444464106e-12,   9.062494417298371e-14,   3.011750807695032e-16,  -2.222253258714863e-17,  -6.646233402701288e-19,  -9.272361852585043e-21,
  -2.938711984618201e-24,   3.281395113683170e-24,   1.772196865247619e+00,  -6.261616684436355e-03,  -1.119654215744890e-04,  -1.364141558203690e-06,  -6.457037345777491e-09,
   1.872340029948667e-10,   6.106854719318171e-12,   9.046286305739831e-14,   2.951931394492538e-16,  -2.232295886094632e-17,  -6.646054746814142e-19,  -9.220265907171563e-21,
  -1.368270704385979e-24,   3.302338528550884e-24,   1.772175110216594e+00,  -6.262410409442264e-03,  -1.119728752413785e-04,  -1.363775949148867e-06,  -6.439237840121446e-09,
   1.876013539725626e-10,   6.108386876966215e-12,   9.030528792734711e-14,   2.893860682330449e-16,  -2.242026741957634e-17,  -6.645815286679299e-19,  -9.169588953221013e-21,
   1.552884248072826e-25,   3.322568344876258e-24,   1.772157584302337e+00,  -6.263049772066761e-03,  -1.119788747888676e-04,  -1.363481246685310e-06,  -6.424897729286286e-09,
   1.878971308265982e-10,   6.109613509094658e-12,   9.017818312649077e-14,   2.847080422436057e-16,  -2.249852628235154e-17,  -6.645575092274562e-19,  -9.128690587648613e-21,
   1.381926713920753e-24,   3.338792322246781e-24,   1.772146003321964e+00,  -6.263472226071087e-03,  -1.119828367202410e-04,  -1.363286428078831e-06,  -6.415421521930789e-09,
   1.880924983150767e-10,   6.110420298118194e-12,   9.009411415072572e-14,   2.816169259098081e-16,  -2.255017382731217e-17,  -6.645393229558115e-19,  -9.101629689553648e-21,
   2.192111934156865e-24,   3.349477127750953e-24,   1.772140055882334e+00,  -6.263689168550492e-03,  -1.119848705999315e-04,  -1.363186353284969e-06,  -6.410554876331319e-09,
   1.881928051721227e-10,   6.110833463902998e-12,   9.005091586350416e-14,   2.800295027800753e-16,  -2.257667734756319e-17,  -6.645292677600609e-19,  -9.087721512325125e-21,
   2.608070349831622e-24,   3.354953239640031e-24,   1.772137985813217e+00,  -6.263764676114805e-03,  -1.119855783891275e-04,  -1.363151517178975e-06,  -6.408860970370444e-09,
   1.882277141188540e-10,   6.110977085527305e-12,   9.003587634992005e-14,   2.794769877539074e-16,  -2.258589896085966e-17,  -6.645256540342945e-19,  -9.082878876549668e-21,
   2.752830854190284e-24,   3.356857491532709e-24,   1.772137657321364e+00,  -6.263776658065899e-03,  -1.119856906997686e-04,  -1.363145988971362e-06,  -6.408592169618504e-09,
   1.882332535087687e-10,   6.110999867541778e-12,   9.003348959855400e-14,   2.793893113310086e-16,  -2.258736215291689e-17,  -6.645250751777722e-19,  -9.082110333077721e-21,
   2.775801514605756e-24,   3.357159586570703e-24,   1.955182402308155e+00,  -1.366393063954802e-03,  -3.051077852336094e-05,  -5.858066916668739e-07,  -1.007546148835604e-08,
  -1.560255711486159e-10,  -2.130042254998825e-12,  -2.387428552261100e-14,  -1.625291802887639e-16,   1.420780930129525e-18,   8.651334715041716e-20,   2.229570450583002e-21,
   4.365331148976664e-23,   6.989877244081964e-25,   1.955179530516810e+00,  -1.366558338463621e-03,  -3.051646289771863e-05,  -5.859533597676256e-07,  -1.007846179605322e-08,
  -1.560724917331443e-10,  -2.130461146573005e-12,  -2.386918470247327e-14,  -1.621553915517771e-16,   1.432477274886223e-18,   8.678685885927808e-20,   2.234709983961246e-21,
   4.372698301918517e-23,   6.995066856551273e-25,   1.955174462760447e+00,  -1.366850001544195e-03,  -3.052649443909377e-05,  -5.862121936796157e-07,  -1.008375636211808e-08,
  -1.561552755285460e-10,  -2.131199484287249e-12,  -2.386015198422246e-14,  -1.614948943363627e-16,   1.453137233218773e-18,   8.726984414309022e-20,   2.243781782751321e-21,
   4.385688414072739e-23,   7.004169128066145e-25,   1.955168334032914e+00,  -1.367202740970502e-03,  -3.053862702801096e-05,  -5.865252393482978e-07,  -1.009015941884783e-08,
  -1.562553643666982e-10,  -2.132090919480436e-12,  -2.384917451085250e-14,  -1.606946085110211e-16,   1.478156269584203e-18,   8.785450493176305e-20,   2.254756610855537e-21,
   4.401380195435112e-23,   7.015082009545825e-25,   1.955162383592794e+00,  -1.367545234324425e-03,  -3.055040758792566e-05,  -5.868292024714241e-07,  -1.009637624381664e-08,
  -1.563525139505498e-10,  -2.132954872233712e-12,  -2.383846010785381e-14,  -1.599160224779920e-16,   1.502482858186627e-18,   8.842274263230145e-20,   2.265416108684333e-21,
   4.416596663655541e-23,   7.025577808157920e-25,   1.955157589438460e+00,  -1.367821185529062e-03,  -3.055989961121465e-05,  -5.870741169239627e-07,  -1.010138504442386e-08,
  -1.564307656643577e-10,  -2.133649830416875e-12,  -2.382978737307240e-14,  -1.592875974768433e-16,   1.522107663859748e-18,   8.888097950173538e-20,   2.274007056420586e-21,
   4.428842725492771e-23,   7.033962605106226e-25,   1.955154421273855e+00,  -1.368003550231414e-03,  -3.056617263164536e-05,  -5.872359744121449e-07,  -1.010469506773727e-08,
  -1.564824677374463e-10,  -2.134108541137144e-12,  -2.382403632310019e-14,  -1.588717545201057e-16,   1.535088913502850e-18,   8.918400523027820e-20,   2.279685651565581e-21,
   4.436928742948312e-23,   7.039468581417157e-25,   1.955152794185361e+00,  -1.368097209746025e-03,  -3.056939439392968e-05,  -5.873191028980934e-07,  -1.010639501491961e-08,
  -1.565090175947089e-10,  -2.134343954675141e-12,  -2.382107661461508e-14,  -1.586580164527822e-16,   1.541759590529825e-18,   8.933969484472368e-20,   2.282602452247701e-21,
   4.441079450810786e-23,   7.042285471199116e-25,   1.955152227848876e+00,  -1.368129809834888e-03,  -3.057051580016763e-05,  -5.873480376307244e-07,  -1.010698671171950e-08,
  -1.565182582557436e-10,  -2.134425867609799e-12,  -2.382004546263614e-14,  -1.585835938512664e-16,   1.544082046946341e-18,   8.939389540606583e-20,   2.283617762084068e-21,
   4.442523847868166e-23,   7.043264212495049e-25,   1.955152137978438e+00,  -1.368134983069250e-03,  -3.057069375390484e-05,  -5.873526292266040e-07,  -1.010708060654641e-08,
  -1.565197246090410e-10,  -2.134438864881982e-12,  -2.381988178561839e-14,  -1.585717826273117e-16,   1.544450620421579e-18,   8.940249682818872e-20,   2.283778882072224e-21,
   4.442753039782953e-23,   7.043419444398084e-25,   1.519972177858265e-02,  -4.193424715274182e-04,   8.613545444632186e-06,  -1.558392422298323e-07,   2.610531001245322e-09,
  -4.135913958854741e-11,   6.248137357643322e-13,  -9.032885459696442e-15,   1.245625500017508e-16,  -1.630451823896489e-18,   1.986993893726390e-20,  -2.205302622531655e-22,
   1.985131894966245e-24,  -1.086368697066404e-26,   1.520053225478146e-02,  -4.193864383662357e-04,   8.615018849159265e-06,  -1.558781666941586e-07,   2.611413533931371e-09,
  -4.137701111510027e-11,   6.251424523850508e-13,  -9.038417952815346e-15,   1.246467694709210e-16,  -1.631591830052902e-18,   1.988217873980708e-20,  -2.206054415276200e-22,
   1.984214225550037e-24,  -1.078667068394971e-26,   1.520196246570331e-02,  -4.194640274727242e-04,   8.617619099178575e-06,  -1.559468631735323e-07,   2.612971153265907e-09,
  -4.140855457529847e-11,   6.257226580165186e-13,  -9.048183254271856e-15,   1.247954179938234e-16,  -1.633603699659185e-18,   1.990377134125931e-20,  -2.207376367449110e-22,
   1.982585367059835e-24,  -1.065063210717566e-26,   1.520369208458876e-02,  -4.195578642739589e-04,   8.620764039198014e-06,  -1.560299549689414e-07,   2.614855285357607e-09,
  -4.144671239268436e-11,   6.264245558125637e-13,  -9.059996899154695e-15,   1.249752368838288e-16,  -1.636037002515472e-18,   1.992987325963505e-20,  -2.208967040363701e-22,
   1.980599285990911e-24,  -1.048588912131611e-26,   1.520537137033484e-02,  -4.196489753621529e-04,   8.623817815152059e-06,  -1.561106434286178e-07,   2.616685040811395e-09,
  -4.148377118787249e-11,   6.271062675535552e-13,  -9.071470971778206e-15,   1.251498768175519e-16,  -1.638399762697358e-18,   1.995520403981434e-20,  -2.210503014528604e-22,
   1.978653943307326e-24,  -1.032570258091155e-26,   1.520672432561038e-02,  -4.197223846970648e-04,   8.626278415211287e-06,  -1.561756624769621e-07,   2.618159550077008e-09,
  -4.151363662846675e-11,   6.276556760832186e-13,  -9.080718341683793e-15,   1.252906181095638e-16,  -1.640303565809040e-18,   1.997560405904783e-20,  -2.211734477841554e-22,
   1.977074366549969e-24,  -1.019647310938743e-26,   1.520761840512161e-02,  -4.197708978736459e-04,   8.627904589499498e-06,  -1.562186344635322e-07,   2.619134115616675e-09,
  -4.153337674157901e-11,   6.280188282926158e-13,  -9.086830800741244e-15,   1.253836437039118e-16,  -1.641561757537360e-18,   1.998908101574942e-20,  -2.212545317122649e-22,
   1.976024503764813e-24,  -1.011098937244451e-26,   1.520807757961784e-02,  -4.197958134418141e-04,   8.628739786244363e-06,  -1.562407052816770e-07,   2.619634674674771e-09,
  -4.154351595455850e-11,   6.282053592300090e-13,  -9.089970447674641e-15,   1.254314249166911e-16,  -1.642207958636470e-18,   1.999600114357996e-20,  -2.212960827749330e-22,
   1.975483456506268e-24,  -1.006706107371134e-26,   1.520823740299084e-02,  -4.198044858090333e-04,   8.629030496608211e-06,  -1.562483876534739e-07,   2.619808910465134e-09,
  -4.154704527439649e-11,   6.282702885877831e-13,  -9.091063327139133e-15,   1.254480568978386e-16,  -1.642432884301229e-18,   1.999840960847189e-20,  -2.213105307638251e-22,
   1.975294838414665e-24,  -1.005176691089970e-26,   1.520826276492444e-02,  -4.198058620073545e-04,   8.629076628932100e-06,  -1.562496067600816e-07,   2.619836559837403e-09,
  -4.154760534185197e-11,   6.282805922464483e-13,  -9.091236756644628e-15,   1.254506962255436e-16,  -1.642468577355148e-18,   1.999879179160340e-20,  -2.213128227846265e-22,
   1.975264892994328e-24,  -1.004933972331302e-26,   1.349103503652818e-01,  -3.533209006517272e-03,   6.488365977142076e-05,  -9.537390796839004e-07,   1.092636868866208e-08,
  -7.586106572882872e-11,  -4.460119834384281e-13,   2.791541641214759e-14,  -5.991841431037540e-16,   8.466205242832011e-18,  -6.806365381971513e-20,  -4.440208090255646e-22,
   2.950481018233850e-23,  -6.826161640036583e-25,   1.349164455269101e-01,  -3.533477493868493e-03,   6.488980218578368e-05,  -9.538097329560499e-07,   1.092572280765022e-08,
  -7.580565405582826e-11,  -4.475906262846960e-13,   2.794392423691783e-14,  -5.994652647337809e-16,   8.463720013741766e-18,  -6.787701668312586e-20,  -4.490464867121147e-22,
   2.959284444088570e-23,  -6.832379069247529e-25,   1.349272010033815e-01,  -3.533951260104744e-03,   6.490064027294589e-05,  -9.539343593942196e-07,   1.092458133331605e-08,
  -7.570783368864094e-11,  -4.503767627518536e-13,   2.799421977969831e-14,  -5.999606645580402e-16,   8.459313685273895e-18,  -6.754725011620429e-20,  -4.579180282768110e-22,
   2.974814170445963e-23,  -6.843318634098586e-25,   1.349402074382259e-01,  -3.534524170712867e-03,   6.491374529231382e-05,  -9.540849867432151e-07,   1.092319796858684e-08,
  -7.558947051404340e-11,  -4.537468045850506e-13,   2.805502577607497e-14,  -6.005586086934637e-16,   8.453949513625650e-18,  -6.714773867023615e-20,  -4.686518090453085e-22,
   2.993585881437716e-23,  -6.856493507904357e-25,   1.349528346954373e-01,  -3.535080371112604e-03,   6.492646688198310e-05,  -9.542311374537870e-07,   1.092185179426342e-08,
  -7.547448419284452e-11,  -4.570194454421722e-13,   2.811404266069992e-14,  -6.011379307149149e-16,   8.448704364692188e-18,  -6.675911027991271e-20,  -4.790784725328282e-22,
   3.011801697989775e-23,  -6.869227323514279e-25,   1.349630076481895e-01,  -3.535528459478003e-03,   6.493671484442925e-05,  -9.543488202965136e-07,   1.092076502061622e-08,
  -7.538179439186203e-11,  -4.596566028430482e-13,   2.816157688627073e-14,  -6.016037988105307e-16,   8.444451916818214e-18,  -6.644547069347957e-20,  -4.874826990202996e-22,
   3.026470721276182e-23,  -6.879445137866507e-25,   1.349697300472071e-01,  -3.535824558350093e-03,   6.494348632686278e-05,  -9.544265564423298e-07,   1.092004576721736e-08,
  -7.532051807235570e-11,  -4.613995614848163e-13,   2.819298223017205e-14,  -6.019112312468610e-16,   8.441628739528432e-18,  -6.623794635867800e-20,  -4.930383303023111e-22,
   3.036161075856871e-23,  -6.886177047232111e-25,   1.349731824113889e-01,  -3.535976622400174e-03,   6.494696374872892e-05,  -9.544664694507276e-07,   1.091967604583799e-08,
  -7.528904092150780e-11,  -4.622947691192903e-13,   2.820910900523398e-14,  -6.020689872129439e-16,   8.440174808906283e-18,  -6.613128706590685e-20,  -4.958921132306239e-22,
   3.041136703057098e-23,  -6.889628054456894e-25,   1.349743840527868e-01,  -3.536029550180667e-03,   6.494817408795868e-05,  -9.544803602296927e-07,   1.091954730514766e-08,
  -7.527808360539044e-11,  -4.626063726320880e-13,   2.821472185832503e-14,  -6.021238756665310e-16,   8.439668103196887e-18,  -6.609414969296553e-20,  -4.968855099341415e-22,
   3.042868382401305e-23,  -6.890828228688629e-25,   1.349745747374123e-01,  -3.536037949114010e-03,   6.494836615168397e-05,  -9.544825644428557e-07,   1.091952687312510e-08,
  -7.527634476350647e-11,  -4.626558206866058e-13,   2.821561253042331e-14,  -6.021325847607004e-16,   8.439587665032775e-18,  -6.608825585633602e-20,  -4.970431535974167e-22,
   3.043143169725998e-23,  -6.891018633239477e-25,   3.640309413240391e-01,  -8.528767273826799e-03,   1.196256287642394e-04,  -8.480244207824426e-07,  -7.360787288729785e-09,
   3.243956431233933e-10,  -4.395614593436026e-12,  -7.188526644601670e-16,   1.269129446390182e-15,  -2.605163446886762e-17,   1.521163865239476e-19,   5.013819724097710e-21,
  -1.587914007100840e-22,   1.741648932041561e-24,   3.640421478226845e-01,  -8.529004709110692e-03,   1.196214536830203e-04,  -8.477203253887413e-07,  -7.366929044810196e-09,
   3.243928418329939e-10,  -4.392270623946957e-12,  -8.060886179043489e-16,   1.269739849874073e-15,  -2.602530817013046e-17,   1.511407142367804e-19,   5.026073168223042e-21,
  -1.586453920446934e-22,   1.732912334666923e-24,   3.640619215437953e-01,  -8.529423597881959e-03,   1.196140838870332e-04,  -8.471837468361816e-07,  -7.377762442200168e-09,
   3.243877596219686e-10,  -4.386368853395039e-12,  -9.599452493560799e-16,   1.270813576098639e-15,  -2.597880412858121e-17,   1.494198729717584e-19,   5.047642581574694e-21,
  -1.583865459981666e-22,   1.717493278220778e-24,   3.640858315893781e-01,  -8.529930004118867e-03,   1.196051674788105e-04,  -8.465349147438239e-07,  -7.390855774307045e-09,
   3.243813767368150e-10,  -4.379230185305574e-12,  -1.145866480759274e-15,   1.272106243564418e-15,  -2.592248435079510e-17,   1.473402925974838e-19,   5.073635901639252e-21,
  -1.580714849995671e-22,   1.698843066425762e-24,   3.641090424723879e-01,  -8.530421490393566e-03,   1.195965065882099e-04,  -8.459050445076930e-07,  -7.403559717393511e-09,
   3.243749318190909e-10,  -4.372297808967275e-12,  -1.326225777032942e-15,   1.273355182588453e-15,  -2.586771959570353e-17,   1.453228168943418e-19,   5.098776923434542e-21,
  -1.577634755178928e-22,   1.680732341633380e-24,   3.641277404455279e-01,  -8.530817336403793e-03,   1.195895259089478e-04,  -8.453976326891568e-07,  -7.413788949106120e-09,
   3.243695618829961e-10,  -4.366711546847340e-12,  -1.471427782080814e-15,   1.274357042784563e-15,  -2.582353711995499e-17,   1.436985320608955e-19,   5.118963671198826e-21,
  -1.575138075924813e-22,   1.666138800247756e-24,   3.641400955311310e-01,  -8.531078860847911e-03,   1.195849114487907e-04,  -8.450623457153856e-07,  -7.420545843848495e-09,
   3.243659264032404e-10,  -4.363019448083432e-12,  -1.567329062465278e-15,   1.275016964666858e-15,  -2.579431050184853e-17,   1.426257087220843e-19,   5.132270134298246e-21,
  -1.573480791673885e-22,   1.656493842218494e-24,   3.641464403962897e-01,  -8.531213152695968e-03,   1.195825411610830e-04,  -8.448901603479709e-07,  -7.424015090508010e-09,
   3.243640324734529e-10,  -4.361123132830662e-12,  -1.616564843586090e-15,   1.275355220074814e-15,  -2.577929146617922e-17,   1.420749098667867e-19,   5.139093563187025e-21,
  -1.572627373462294e-22,   1.651540145553572e-24,   3.641486487747669e-01,  -8.531259892059455e-03,   1.195817160745210e-04,  -8.448302297399286e-07,  -7.425222475428735e-09,
   3.243633689859936e-10,  -4.360463063830604e-12,  -1.633699560304557e-15,   1.275472850126777e-15,  -2.577406239909255e-17,   1.418832227538355e-19,   5.141466915812936e-21,
  -1.572329963820509e-22,   1.649815879450959e-24,   3.641489992135447e-01,  -8.531267308850950e-03,   1.195815851405540e-04,  -8.448207195818992e-07,  -7.425414065178186e-09,
   3.243632634961243e-10,  -4.360358318114898e-12,  -1.636418497141452e-15,   1.275491511514074e-15,  -2.577323254440053e-17,   1.418528057638694e-19,   5.141843458026053e-21,
  -1.572282751465014e-22,   1.649542258072262e-24,   6.809105242176491e-01,  -1.322537114776599e-02,   1.009008608395872e-04,   9.653976786494815e-07,  -3.098013053197125e-08,
   8.433022110886343e-11,   7.925360453647946e-12,  -1.181365138137106e-13,  -1.209340235415207e-15,   5.523633862163261e-17,  -2.530361882341884e-19,  -1.721031809472091e-20,
   3.105146501031007e-22,   2.567015288260772e-24,   6.809199487998610e-01,  -1.322509935894087e-02,   1.008834972259618e-04,   9.654748100685347e-07,  -3.096902333303376e-08,
   8.410056402459640e-11,   7.922165305997436e-12,  -1.179523821486177e-13,  -1.210348150629078e-15,   5.514835249147888e-17,  -2.511740363610565e-19,  -1.719101179291268e-20,
   3.092322705363327e-22,   2.576865193251181e-24,   6.809365773077207e-01,  -1.322461976597358e-02,   1.008528639266572e-04,   9.656107355294282e-07,  -3.094942816649029e-08,
   8.369562407434847e-11,   7.916525302575744e-12,  -1.176277197912893e-13,  -1.212120297824897e-15,   5.499318105223843e-17,  -2.478946472152251e-19,  -1.715688838790728e-20,
   3.069734541433268e-22,   2.594139402824135e-24,   6.809566824339497e-01,  -1.322403980754582e-02,   1.008158304576187e-04,   9.657748012760562e-07,  -3.092573972519687e-08,
   8.320646668801596e-11,   7.909701752914964e-12,  -1.172355451366560e-13,  -1.214252410339308e-15,   5.480568516757243e-17,  -2.439400858956942e-19,  -1.711552901619696e-20,
   3.042488193673211e-22,   2.614847105067440e-24,   6.809761977938131e-01,  -1.322347676309862e-02,   1.007798880571401e-04,   9.659337628798534e-07,  -3.090274993659916e-08,
   8.273212476711947e-11,   7.903073813737890e-12,  -1.168552584841319e-13,  -1.216310951528203e-15,   5.462381325475824e-17,  -2.401124748291672e-19,  -1.707527703742695e-20,
   3.016108517321542e-22,   2.634761394518489e-24,   6.809919174313663e-01,  -1.322302315973815e-02,   1.007509398101321e-04,   9.660615978862015e-07,  -3.088423434933680e-08,
   8.235037600651757e-11,   7.897731749746084e-12,  -1.165492122520110e-13,  -1.217961219256102e-15,   5.447740424993351e-17,  -2.370371631288624e-19,  -1.704277857275098e-20,
   2.994907925652772e-22,   2.650669516955190e-24,   6.810023038640952e-01,  -1.322272341591898e-02,   1.007318144982292e-04,   9.661459601462364e-07,  -3.087200187480939e-08,
   8.209830670237272e-11,   7.894200498991172e-12,  -1.163471329802681e-13,  -1.219047742732404e-15,   5.438071108184393e-17,  -2.350090433399913e-19,  -1.702126907076566e-20,
   2.980923671526754e-22,   2.661115597065318e-24,   6.810076375395482e-01,  -1.322256947978795e-02,   1.007219937169620e-04,   9.661892505569599e-07,  -3.086572062392644e-08,
   8.196891377496932e-11,   7.892386628333764e-12,  -1.162434021757634e-13,  -1.219604505950783e-15,   5.433107038897125e-17,  -2.339687401122630e-19,  -1.701021209163653e-20,
   2.973749727660889e-22,   2.666459868529492e-24,   6.810094939335830e-01,  -1.322251590037666e-02,   1.007185756603554e-04,   9.662043128253524e-07,  -3.086353449009301e-08,
   8.192388640994431e-11,   7.891755229717764e-12,  -1.162073051323690e-13,  -1.219798098591668e-15,   5.431379501972697e-17,  -2.336068493006858e-19,  -1.700636188905704e-20,
   2.971253986625191e-22,   2.668316764009057e-24,   6.810097885158246e-01,  -1.322250739803678e-02,   1.007180332692637e-04,   9.662067027456835e-07,  -3.086318758612906e-08,
   8.191674161580860e-11,   7.891655032400836e-12,  -1.162015773806194e-13,  -1.219828809874775e-15,   5.431105377660694e-17,  -2.335494315278461e-19,  -1.700575083335118e-20,
   2.970858004605099e-22,   2.668611274608182e-24,   1.050920945685856e+00,  -1.518396470839638e-02,  -7.286591302090760e-06,   2.342174007479355e-06,   1.099092969873579e-09,
  -6.537101518713633e-10,  -4.845608415571481e-14,   2.218551689380815e-13,  -1.215875482108785e-16,  -8.381222329415001e-17,   9.925886033636838e-20,   3.359392904254126e-20,
  -6.884090986194919e-23,  -1.423385481702745e-23,   1.050920263809511e+00,  -1.518330811832977e-02,  -7.285973470798869e-06,   2.341564786196489e-06,   1.099021165704658e-09,
  -6.532777949208737e-10,  -4.876691358053650e-14,   2.215767015423266e-13,  -1.211819361823701e-16,  -8.364290763217316e-17,   9.884799459249804e-20,   3.349311852734113e-20,
  -6.851357044231089e-23,  -1.417413228871106e-23,   1.050919060674995e+00,  -1.518214969348347e-02,  -7.284883331443763e-06,   2.340490133822852e-06,   1.098894114014123e-09,
  -6.525153378235184e-10,  -4.931451929636029e-14,   2.210858031592953e-13,  -1.204676233663616e-16,  -8.334456674415284e-17,   9.812464888233939e-20,   3.331558827797795e-20,
  -6.793717930693257e-23,  -1.406901565247586e-23,   1.050917605912060e+00,  -1.518074915015011e-02,  -7.283565180822207e-06,   2.339191212007036e-06,   1.098739882050487e-09,
  -6.515941223296591e-10,  -4.997522956588513e-14,   2.204929900724990e-13,  -1.196062451373541e-16,  -8.298452362638404e-17,   9.725275240259436e-20,   3.310151505378047e-20,
  -6.724225146226414e-23,  -1.394235787506580e-23,   1.050916193737340e+00,  -1.517938977438258e-02,  -7.282285603404126e-06,   2.337930826609471e-06,   1.098589529177167e-09,
  -6.507006130720059e-10,  -5.061510891202667e-14,   2.199183199874974e-13,  -1.187725178024781e-16,  -8.263574628051490e-17,   9.640923723938515e-20,   3.289432159097430e-20,
  -6.656977074850631e-23,  -1.381987110905905e-23,   1.050915056167904e+00,  -1.517829485619823e-02,  -7.281254835841823e-06,   2.336915895765751e-06,   1.098467958102845e-09,
  -6.499813797847542e-10,  -5.112949530227676e-14,   2.194559619253003e-13,  -1.181026540677704e-16,  -8.235530959346648e-17,   9.573179143190733e-20,   3.272785616645020e-20,
  -6.602956179757879e-23,  -1.372153355061093e-23,   1.050914304511737e+00,  -1.517757144053787e-02,  -7.280573744271307e-06,   2.336245452732868e-06,   1.098387406621467e-09,
  -6.495064002612398e-10,  -5.146885868273564e-14,   2.191507319064631e-13,  -1.176608883205183e-16,  -8.217026302967629e-17,   9.528516376835959e-20,   3.261807722360637e-20,
  -6.567335068723369e-23,  -1.365671810314582e-23,   1.050913918509438e+00,  -1.517719995881275e-02,  -7.280223977747832e-06,   2.335901211594539e-06,   1.098345971756305e-09,
  -6.492625611811022e-10,  -5.164297303359557e-14,   2.189940706784812e-13,  -1.174342886995766e-16,  -8.207531340540353e-17,   9.505611312345184e-20,   3.256176795726302e-20,
  -6.549065073544420e-23,  -1.362348299445244e-23,   1.050913784159252e+00,  -1.517707066546753e-02,  -7.280102239355683e-06,   2.335781405411802e-06,   1.098331539178736e-09,
  -6.491777043855408e-10,  -5.170354887628440e-14,   2.189395574656006e-13,  -1.173554613024582e-16,  -8.204227815033934e-17,   9.497643991470562e-20,   3.254217973600214e-20,
  -6.542709717719118e-23,  -1.361192327941915e-23,   1.050913762839797e+00,  -1.517705014859705e-02,  -7.280082921199292e-06,   2.335762394299950e-06,   1.098329248415144e-09,
  -6.491642394277100e-10,  -5.171316018228492e-14,   2.189309076417014e-13,  -1.173429545056094e-16,  -8.203703651932942e-17,   9.496379924522333e-20,   3.253907186451804e-20,
  -6.541701385092090e-23,  -1.361008929477116e-23,   1.425598104025475e+00,  -1.290625103316173e-02,  -1.222475269240992e-04,   8.007961535829545e-07,   3.752235294047175e-08,
   1.935069275726682e-10,  -9.863904434294679e-12,  -1.864497344509819e-13,   1.369514847495522e-15,   8.935872999259385e-17,   5.738379570162008e-19,  -2.988534032931404e-20,
  -6.355422338956828e-22,   4.551836494452176e-24,   1.425586685553422e+00,  -1.290602518207106e-02,  -1.222264986722975e-04,   8.009745241181009e-07,   3.750852499575949e-08,
   1.931445803236636e-10,  -9.860262346907727e-12,  -1.861521256723918e-13,   1.371814112619642e-15,   8.920598552142229e-17,   5.700356087157473e-19,  -2.985079874479590e-20,
  -6.327226841510555e-22,   4.574961525487605e-24,   1.425566539072999e+00,  -1.290562662400409e-02,  -1.221894003041481e-04,   8.012889870131099e-07,   3.748412955174399e-08,
   1.925056872887573e-10,  -9.853830992803878e-12,  -1.856274084079855e-13,   1.375858274618458e-15,   8.893661156549792e-17,   5.633403927675547e-19,  -2.978971540972192e-20,
  -6.277562386967522e-22,   4.615519526187414e-24,   1.425542180449737e+00,  -1.290514461471941e-02,  -1.221445513238119e-04,   8.016687707312233e-07,   3.745463745451904e-08,
   1.917339394152635e-10,  -9.846045907769895e-12,  -1.849936273172066e-13,   1.380726509033941e-15,   8.861113113514891e-17,   5.552684564826704e-19,  -2.971562501987860e-20,
  -6.217655741555902e-22,   4.664143516656432e-24,   1.425518536363798e+00,  -1.290467661665422e-02,  -1.221010239790607e-04,   8.020369682375742e-07,   3.742601451280082e-08,
   1.909855859146403e-10,  -9.838479694937800e-12,  -1.843791095133407e-13,   1.385429500633075e-15,   8.829542205693381e-17,   5.474574448221166e-19,  -2.964346210290493e-20,
  -6.159654409365467e-22,   4.710909278174885e-24,   1.425499491032971e+00,  -1.290429955209615e-02,  -1.220659669892009e-04,   8.023332325324240e-07,   3.740296160287731e-08,
   1.903833277939503e-10,  -9.832378316542255e-12,  -1.838845961537742e-13,   1.389201715300654e-15,   8.804127876821315e-17,   5.411829414003549e-19,  -2.958515949917963e-20,
  -6.113040255407611e-22,   4.748270631787819e-24,   1.425486907215048e+00,  -1.290405036940054e-02,  -1.220428059071012e-04,   8.025288270154237e-07,   3.738773127626925e-08,
   1.899856627708524e-10,  -9.828343636967684e-12,  -1.835580919890460e-13,   1.391686283070112e-15,   8.787343751797269e-17,   5.370456373127607e-19,  -2.954655174253953e-20,
  -6.082292746430959e-22,   4.772805717610219e-24,   1.425480445130864e+00,  -1.290392239438795e-02,  -1.220309128054032e-04,   8.026292210650914e-07,   3.737991058708869e-08,
   1.897815343873829e-10,  -9.826270710420194e-12,  -1.833904973133644e-13,   1.392959742212502e-15,   8.778727151920999e-17,   5.349236454503304e-19,  -2.952669939495585e-20,
  -6.066519212063665e-22,   4.785358539592951e-24,   1.425478195992386e+00,  -1.290387785027528e-02,  -1.220267734970067e-04,   8.026641556853505e-07,   3.737718865394084e-08,
   1.897105002191896e-10,  -9.825549062134582e-12,  -1.833321773189275e-13,   1.393402585893641e-15,   8.775728519632687e-17,   5.341854982587038e-19,  -2.951978556391771e-20,
  -6.061031760087395e-22,   4.789720170375190e-24,   1.425477839087416e+00,  -1.290387078167933e-02,  -1.220261166550081e-04,   8.026696989274328e-07,   3.737675672677814e-08,
   1.896992287673317e-10,  -9.825434539504071e-12,  -1.833229233498173e-13,   1.393472840318850e-15,   8.775252699554301e-17,   5.340683849463058e-19,  -2.951868824251236e-20,
  -6.060161103825002e-22,   4.790411945503671e-24,   1.745312394445162e+00,  -7.222270274806084e-03,  -1.288005789372797e-04,  -1.430340809444970e-06,  -1.099132028126935e-09,
   3.635406342416743e-10,   8.624265428132195e-12,   8.208682089370529e-14,  -1.058917097333159e-15,  -5.615963358623626e-17,  -9.956613911410891e-19,  -3.174334444696356e-21,
   3.146135916208178e-22,   9.257623825232001e-24,   1.745300318312083e+00,  -7.222671351918957e-03,  -1.288011289510174e-04,  -1.429998660407197e-06,  -1.087038190975301e-09,
   3.636992212026542e-10,   8.621400543867499e-12,   8.189693402736108e-14,  -1.063053481183326e-15,  -5.617339714355207e-17,  -9.936753060489505e-19,  -3.107302626671824e-21,
   3.154722425290928e-22,   9.245757861833112e-24,   1.745279009751179e+00,  -7.223378980339835e-03,  -1.288020939363018e-04,  -1.429394813096155e-06,  -1.065701733583469e-09,
   3.639787462944005e-10,   8.616336621795534e-12,   8.156183980627254e-14,  -1.070345349265320e-15,  -5.619740284578351e-17,  -9.901665686050660e-19,  -2.989096095635630e-21,
   3.169818837834661e-22,   9.224699544387495e-24,   1.745253243153788e+00,  -7.224234518397316e-03,  -1.288032513913606e-04,  -1.428664430107589e-06,  -1.039907109487257e-09,
   3.643162324756976e-10,   8.610198297665681e-12,   8.115657967847735e-14,  -1.079151070642199e-15,  -5.622595305325297e-17,  -9.859165225738435e-19,  -2.846283033304868e-21,
   3.187980450609518e-22,   9.199030292722189e-24,   1.745228229326819e+00,  -7.225064919807319e-03,  -1.288043651702610e-04,  -1.427955173135415e-06,  -1.014872058351205e-09,
   3.646433151542493e-10,   8.604223649525622e-12,   8.076309735658485e-14,  -1.087687265134206e-15,  -5.625316907987093e-17,  -9.817830904359915e-19,  -2.707772574512665e-21,
   3.205513901448720e-22,   9.173896526942274e-24,   1.745208078470194e+00,  -7.225733779967423e-03,  -1.288052553534697e-04,  -1.427383651890883e-06,  -9.947083969977871e-10,
   3.649064195693841e-10,   8.599399332704085e-12,   8.044606858835406e-14,  -1.094555128307610e-15,  -5.627473588379297e-17,  -9.784478507445903e-19,  -2.596283925537493e-21,
   3.219568740750054e-22,   9.153495754014940e-24,   1.745194763122201e+00,  -7.226175701672532e-03,  -1.288058401130265e-04,  -1.427005925953401e-06,  -9.813866923080202e-10,
   3.650800837345782e-10,   8.596206021123303e-12,   8.023656001524486e-14,  -1.099088985437493e-15,  -5.628881159833008e-17,  -9.762413463703737e-19,  -2.522660205917307e-21,
   3.228821712087791e-22,   9.139940350067620e-24,   1.745187925047446e+00,  -7.226402634404538e-03,  -1.288061393458100e-04,  -1.426811922465822e-06,  -9.745460044099865e-10,
   3.651692096621937e-10,   8.594564406097395e-12,   8.012896069567332e-14,  -1.101416006039855e-15,  -5.629598597143395e-17,  -9.751073866128377e-19,  -2.484865164635605e-21,
   3.233562973841181e-22,   9.132955856934285e-24,   1.745185544991883e+00,  -7.226481617998720e-03,  -1.288062433263051e-04,  -1.426744394091693e-06,  -9.721651430549054e-10,
   3.652002213753851e-10,   8.593992756901054e-12,   8.009150871322894e-14,  -1.102225734751389e-15,  -5.629847445365818e-17,  -9.747125720452004e-19,  -2.471712528195607e-21,
   3.235211528771938e-22,   9.130521158177648e-24,   1.745185167309795e+00,  -7.226494151492382e-03,  -1.288062598184972e-04,  -1.426733678093883e-06,  -9.717873380247032e-10,
   3.652051420617636e-10,   8.593902031227577e-12,   8.008556554945335e-14,  -1.102354217474769e-15,  -5.629886893213362e-17,  -9.746499142661235e-19,  -2.469625493945780e-21,
   3.235473051759518e-22,   9.130134630275985e-24,   1.949179930479622e+00,  -1.641594911850903e-03,  -3.862032189873054e-05,  -7.749927163236561e-07,  -1.376406224764800e-08,
  -2.156793950808149e-10,  -2.857566564754469e-12,  -2.735429001904305e-14,  -1.876066936037520e-17,   7.608966050889640e-18,   2.459297102436173e-19,   5.413422851564685e-21,
   9.347814399005331e-23,   1.204497004473383e-24,   1.949176294243294e+00,  -1.641813592015549e-03,  -3.862808685305078e-05,  -7.751953641801984e-07,  -1.376808098229225e-08,
  -2.157328268631845e-10,  -2.857593940927951e-12,  -2.732787204163182e-14,  -1.770446884822391e-17,   7.637216517446465e-18,   2.465105162207513e-19,   5.422116444212839e-21,
   9.353113262421424e-23,   1.202451653083464e-24,   1.949169877452447e+00,  -1.642199503026927e-03,  -3.864179007519338e-05,  -7.755529801110324e-07,  -1.377517212556899e-08,
  -2.158270654363474e-10,  -2.857639981201733e-12,  -2.728117934027076e-14,  -1.583879222745043e-17,   7.687101236522601e-18,   2.475356168593492e-19,   5.437444028434286e-21,
   9.362398023444473e-23,   1.198825027357412e-24,   1.949162117186383e+00,  -1.642666229902617e-03,  -3.865836329192043e-05,  -7.759854823194797e-07,  -1.378374684883828e-08,
  -2.159409469231021e-10,  -2.857691787954694e-12,  -2.722458536361781e-14,  -1.357939524540167e-17,   7.747484275417932e-18,   2.487756194721324e-19,   5.455957097805795e-21,
   9.373513991278704e-23,   1.194409689656097e-24,   1.949154582592433e+00,  -1.643119403175523e-03,  -3.867445556584154e-05,  -7.764054204178647e-07,  -1.379207107828768e-08,
  -2.160514247516701e-10,  -2.857738029271970e-12,  -2.716950590012140e-14,  -1.138244963702605e-17,   7.806167863179542e-18,   2.499798503949025e-19,   5.473906963409576e-21,
   9.384188474536650e-23,   1.190091928773336e-24,   1.949148512060533e+00,  -1.643484533074993e-03,  -3.868742164399285e-05,  -7.767437689724649e-07,  -1.379877699384923e-08,
  -2.161403694740196e-10,  -2.857772374962730e-12,  -2.712503493873176e-14,  -9.610066037144760e-18,   7.853488979628265e-18,   2.509502891824003e-19,   5.488351098035275e-21,
   9.392703945410364e-23,   1.186591058332911e-24,   1.949144500388556e+00,  -1.643725833496192e-03,  -3.869599054883859e-05,  -7.769673690653605e-07,  -1.380320815477344e-08,
  -2.161991157094251e-10,  -2.857793646208968e-12,  -2.709560049784266e-14,  -8.437656400110140e-18,   7.884780626742783e-18,   2.515916966507376e-19,   5.497887643380942e-21,
   9.398289754293363e-23,   1.184266701726704e-24,   1.949142440087794e+00,  -1.643849761804561e-03,  -3.870039144756096e-05,  -7.770822062639799e-07,  -1.380548377131335e-08,
  -2.162292764011610e-10,  -2.857804129470367e-12,  -2.708046940019341e-14,  -7.835181294379108e-18,   7.900857401034980e-18,   2.519211390127964e-19,   5.502782672731477e-21,
   9.401145623852173e-23,   1.183069616216187e-24,   1.949141722962898e+00,  -1.643892897619455e-03,  -3.870192327735146e-05,  -7.771221776525078e-07,  -1.380627582101566e-08,
  -2.162397727824029e-10,  -2.857807708110610e-12,  -2.707520047806565e-14,  -7.625422755775966e-18,   7.906454186299754e-18,   2.520358122190657e-19,   5.504486043101311e-21,
   9.402137610832694e-23,   1.182652415463704e-24,   1.949141609164182e+00,  -1.643899742747197e-03,  -3.870216636033365e-05,  -7.771285206207057e-07,  -1.380640150841985e-08,
  -2.162414383506941e-10,  -2.857808272660642e-12,  -2.707436425850493e-14,  -7.592134041970533e-18,   7.907342372051554e-18,   2.520540096463940e-19,   5.504756326022592e-21,
   9.402294929370664e-23,   1.182586185612951e-24,   1.364925058135083e-02,  -3.572622959117761e-04,   6.969210825300796e-06,  -1.199519852152480e-07,   1.914933144913304e-09,
  -2.899743254288181e-11,   4.198645572507219e-13,  -5.850014253211316e-15,   7.807421777316435e-17,  -1.003747850467049e-18,   1.205899047353234e-20,  -1.388417389805597e-22,
   1.453030478471052e-24,  -7.258492246219036e-27,   1.364990611269937e-02,  -3.572961284604319e-04,   6.970291320968105e-06,  -1.199792675985216e-07,   1.915526016103433e-09,
  -2.900900396054222e-11,   4.200705592583466e-13,  -5.853420619464395e-15,   7.812538267317776e-17,  -1.004465810712312e-18,   1.206803654601269e-20,  -1.388946766325179e-22,
   1.454242612814436e-24,  -7.255910939241264e-27,   1.365106289084853e-02,  -3.573558327809505e-04,   6.972198144303682e-06,  -1.200274166300918e-07,   1.916572382596967e-09,
  -2.902942737081471e-11,   4.204341624165938e-13,  -5.859433177912474e-15,   7.821569502058146e-17,  -1.005732884654957e-18,   1.208400446632876e-20,  -1.389880710244496e-22,
   1.456371058472625e-24,  -7.251387702652191e-27,   1.365246182049377e-02,  -3.574280385519259e-04,   6.974504358855589e-06,  -1.200856540243459e-07,   1.917838062544064e-09,
  -2.905413289167342e-11,   4.208740217795353e-13,  -5.866706990000182e-15,   7.832495467779285e-17,  -1.007265422141641e-18,   1.210332321222866e-20,  -1.391009791891119e-22,
   1.458927109735832e-24,  -7.245970927402396e-27,   1.365382002500474e-02,  -3.574981458384370e-04,   6.976743677385837e-06,  -1.201422056642769e-07,   1.919067184230097e-09,
  -2.907812634095097e-11,   4.213012250350978e-13,  -5.873771802230518e-15,   7.843107758237661e-17,  -1.008753578933509e-18,   1.212208811664267e-20,  -1.392105621058793e-22,
   1.461389980804251e-24,  -7.240766435429877e-27,   1.365491428282664e-02,  -3.575546313640916e-04,   6.978547991101388e-06,  -1.201877742429504e-07,   1.920057650758757e-09,
  -2.909746214467723e-11,   4.216455144666868e-13,  -5.879465646511978e-15,   7.851660860704647e-17,  -1.009952702336073e-18,   1.213721244265876e-20,  -1.392988218865819e-22,
   1.463360799513354e-24,  -7.236611595234716e-27,   1.365563740077366e-02,  -3.575919599143165e-04,   6.979740419795369e-06,  -1.202178906881395e-07,   1.920712281335330e-09,
  -2.911024232407775e-11,   4.218730833758679e-13,  -5.883229273068296e-15,   7.857314547310518e-17,  -1.010745200583433e-18,   1.214721001800978e-20,  -1.393571332183400e-22,
   1.464656606258916e-24,  -7.233884321405218e-27,   1.365600877248234e-02,  -3.576111311237151e-04,   6.980352841668297e-06,  -1.202333586373358e-07,   1.921048511217471e-09,
  -2.911680661701338e-11,   4.219899721139128e-13,  -5.885162457567941e-15,   7.860218588712272e-17,  -1.011152229295040e-18,   1.215234538977948e-20,  -1.393870760536218e-22,
   1.465320063933929e-24,  -7.232489280158122e-27,   1.365613803436063e-02,  -3.576178040317924e-04,   6.980566009097267e-06,  -1.202387426715276e-07,   1.921165546392401e-09,
  -2.911909154794120e-11,   4.220306596873002e-13,  -5.885835380983066e-15,   7.861229462894297e-17,  -1.011293906201700e-18,   1.215413298395180e-20,  -1.393974974828988e-22,
   1.465550668002290e-24,  -7.232004599269857e-27,   1.365615854656174e-02,  -3.576188629395698e-04,   6.980599836230656e-06,  -1.202395970565559e-07,   1.921184118608698e-09,
  -2.911945414301787e-11,   4.220371164051938e-13,  -5.885942167550028e-15,   7.861389879261558e-17,  -1.011316388700107e-18,   1.215441665911548e-20,  -1.393991511989108e-22,
   1.465587246576614e-24,  -7.231927728539363e-27,   1.217472090999711e-01,  -3.057065146290268e-03,   5.443640973953266e-05,  -7.914063592344346e-07,   9.355343858291226e-09,
  -7.909014273886789e-11,   1.091395085318914e-13,   1.307478998451655e-14,  -3.451226829980441e-16,   5.663635428448995e-18,  -6.650572485286947e-20,   3.381642039354140e-22,
   7.094987745593008e-24,  -2.181807129626976e-25,   1.217523230689068e-01,  -3.057287989241029e-03,   5.444167290965427e-05,  -7.914802868086288e-07,   9.355486544714392e-09,
  -7.906409696262938e-11,   1.082278043073474e-13,   1.309394824823153e-14,  -3.454017521385760e-16,   5.665315125688377e-18,  -6.645940741596521e-20,   3.365269568518008e-22,
   7.147195583216599e-24,  -2.189371959103017e-25,   1.217613471489284e-01,  -3.057681216005109e-03,   5.445095991897925e-05,  -7.916107132324356e-07,   9.355737272553175e-09,
  -7.901810809394942e-11,   1.066184931821425e-13,   1.312775786817375e-14,  -3.458940130480216e-16,   5.668272071624379e-18,  -6.637741724716615e-20,   3.336335009958387e-22,
   7.239289222703758e-24,  -2.202727874420737e-25,   1.217722598473046e-01,  -3.058156738774347e-03,   5.446218997671458e-05,  -7.917683922356853e-07,   9.356038673740465e-09,
  -7.896244553411786e-11,   1.046714832359246e-13,   1.316864858779620e-14,  -3.464889851005907e-16,   5.671835853526222e-18,  -6.627782667243854e-20,   3.301270143687646e-22,
   7.350602351344303e-24,  -2.218890915037472e-25,   1.217828544226868e-01,  -3.058618398165530e-03,   5.447309203382773e-05,  -7.919214286347030e-07,   9.356329402534219e-09,
  -7.890835448037160e-11,   1.027802984086676e-13,   1.320835270637403e-14,  -3.470662848039039e-16,   5.675283149735894e-18,  -6.618067769862594e-20,   3.267149222879941e-22,
   7.458613620416217e-24,  -2.234595088453322e-25,   1.217913897883542e-01,  -3.058990326544224e-03,   5.448187466882760e-05,  -7.920446872115932e-07,   9.356562272281325e-09,
  -7.886474015942261e-11,   1.012560243202216e-13,   1.324034363116820e-14,  -3.475311424119543e-16,   5.678051378043339e-18,  -6.610208039366141e-20,   3.239604108212124e-22,
   7.545590658512502e-24,  -2.247255634418113e-25,   1.217970300573688e-01,  -3.059236100754687e-03,   5.448767811641790e-05,  -7.921261217647279e-07,   9.356715493374120e-09,
  -7.883590136293702e-11,   1.002484390359127e-13,   1.326148550103578e-14,  -3.478382102047689e-16,   5.679876226938555e-18,  -6.604998053043952e-20,   3.221374503124663e-22,
   7.603046223727424e-24,  -2.255626087541632e-25,   1.217999266831433e-01,  -3.059362320838241e-03,   5.449065847642640e-05,  -7.921679384314982e-07,   9.356793977108726e-09,
  -7.882108531356692e-11,   9.973088071796561e-14,   1.327234373906631e-14,  -3.479958726684647e-16,   5.680812028790519e-18,  -6.602317399581369e-20,   3.212003979293162e-22,
   7.632547059762473e-24,  -2.259926125412350e-25,   1.218009348926498e-01,  -3.059406253414239e-03,   5.449169581992661e-05,  -7.921824924886532e-07,   9.356821261829446e-09,
  -7.881592750502003e-11,   9.955072148916748e-14,   1.327612318766001e-14,  -3.480507435072421e-16,   5.681137528920535e-18,  -6.601383565522817e-20,   3.208741089548880e-22,
   7.642814245555312e-24,  -2.261423016524184e-25,   1.218010948822009e-01,  -3.059413224933687e-03,   5.449186043214400e-05,  -7.921848019878048e-07,   9.356825590007215e-09,
  -7.881510898688588e-11,   9.952213183123725e-14,   1.327672294071683e-14,  -3.480594505149975e-16,   5.681189171134192e-18,  -6.601235340558189e-20,   3.208223247744084e-22,
   7.644443466184154e-24,  -2.261660563123266e-25,   3.317632093837307e-01,  -7.614013444075410e-03,   1.089383909849654e-04,  -9.195604913714141e-07,  -1.909231498712378e-09,
   2.224323390405732e-10,  -3.977892880363453e-12,   2.637293454949229e-14,   4.760271759037152e-16,  -1.745819167118849e-17,   2.388307309888052e-19,  -3.089769856287549e-22,
  -6.408587274227732e-23,   1.654966821095996e-24,   3.317734201180312e-01,  -7.614271333846034e-03,   1.089372855619253e-04,  -9.193515337327785e-07,  -1.914810347963450e-09,
   2.224833229399605e-10,  -3.976622808452045e-12,   2.631398575073069e-14,   4.770218296772294e-16,  -1.745931818909843e-17,   2.384298449721924e-19,  -2.969690589002289e-22,
  -6.418047114385995e-23,   1.653288712834204e-24,   3.317914370316017e-01,  -7.614726336556499e-03,   1.089353324778213e-04,  -9.189827861161170e-07,  -1.924652855272870e-09,
   2.225731904676574e-10,  -3.974379631668561e-12,   2.620996691815272e-14,   4.787755331409941e-16,  -1.746125570739663e-17,   2.377220039686227e-19,  -2.757910942341794e-22,
  -6.434697954324535e-23,   1.650310223821533e-24,   3.318132231262683e-01,  -7.615276449106739e-03,   1.089329664439728e-04,  -9.185368268320217e-07,  -1.936552029273305e-09,
   2.226816983397226e-10,  -3.971663554246451e-12,   2.608418164004663e-14,   4.808937780936779e-16,  -1.746351294105402e-17,   2.368652728485155e-19,  -2.501999541877956e-22,
  -6.454761980439186e-23,   1.646678922615134e-24,   3.318343725328959e-01,  -7.615810403401570e-03,   1.089306649911947e-04,  -9.181038285136345e-07,  -1.948100930761884e-09,
   2.227868674045747e-10,  -3.969023061711378e-12,   2.596206677852549e-14,   4.829476692190042e-16,  -1.746561458713979e-17,   2.360327348557365e-19,  -2.253749144040745e-22,
  -6.474165991034355e-23,   1.643122710128118e-24,   3.318514101072644e-01,  -7.616240488810331e-03,   1.089288077125002e-04,  -9.177549614736307e-07,  -1.957402703606021e-09,
   2.228714695041820e-10,  -3.966893214749729e-12,   2.586368935788401e-14,   4.846004904728578e-16,  -1.746724344796490e-17,   2.353614537564006e-19,  -2.053894291619816e-22,
  -6.489744640826369e-23,   1.640235705801849e-24,   3.318626681777294e-01,  -7.616524651606111e-03,   1.089275788606585e-04,  -9.175244122640955e-07,  -1.963548232214291e-09,
   2.229273139502496e-10,  -3.965484528309645e-12,   2.579868174092185e-14,   4.856917798791033e-16,  -1.746828834804602e-17,   2.349175902411742e-19,  -1.921898866598734e-22,
  -6.500012763017645e-23,   1.638317192567963e-24,   3.318684497185219e-01,  -7.616670573526188e-03,   1.089269472931550e-04,  -9.174060067691283e-07,  -1.966703971432869e-09,
   2.229559744635467e-10,  -3.964760691886858e-12,   2.576529674088583e-14,   4.862519414771652e-16,  -1.746881523897265e-17,   2.346895546096001e-19,  -1.854133087570018e-22,
  -6.505277895080263e-23,   1.637328598688865e-24,   3.318704620340220e-01,  -7.616721361510589e-03,   1.089267273917734e-04,  -9.173647934674459e-07,  -1.967802310178638e-09,
   2.229659471071571e-10,  -3.964508688966194e-12,   2.575367671040745e-14,   4.864468682209231e-16,  -1.746899708170913e-17,   2.346101703253252e-19,  -1.830549806303477e-22,
  -6.507109191832147e-23,   1.636983977315811e-24,   3.318707813606487e-01,  -7.616729420794169e-03,   1.089266924927247e-04,  -9.173582534278269e-07,  -1.967976599265532e-09,
   2.229675294901808e-10,  -3.964468696486658e-12,   2.575183276803388e-14,   4.864777983866310e-16,  -1.746902586423496e-17,   2.345975724495590e-19,  -1.826807617261009e-22,
  -6.507399732593435e-23,   1.636929265391837e-24,   6.296851737347585e-01,  -1.238006226657189e-02,   1.095974622402755e-04,   4.923623487204864e-07,  -2.767453432914510e-08,
   2.322079162693746e-10,   4.353525624939479e-12,  -1.281809375975041e-13,   4.560766844648417e-16,   3.453895021081389e-17,  -6.704222405333748e-19,  -2.146330468437592e-21,
   2.679912904281561e-22,  -3.088369063432787e-24,   6.296954172974343e-01,  -1.237992303101532e-02,   1.095819299853581e-04,   4.925779388441339e-07,  -2.766839880253184e-08,
   2.319574090215739e-10,   4.354665659761914e-12,  -1.280646823386920e-13,   4.533010632171969e-16,   3.452705085763110e-17,  -6.687801577310255e-19,  -2.167882963032532e-21,
   2.676455959695882e-22,  -3.069584686284345e-24,   6.297134910454805e-01,  -1.237967729875072e-02,   1.095545258857817e-04,   4.929581606497072e-07,  -2.765757128817813e-08,
   2.315155709575074e-10,   4.356671377557152e-12,  -1.278595813613772e-13,   4.484090536708688e-16,   3.450596496431487e-17,  -6.658844306899635e-19,  -2.205801908001817e-21,
   2.670342559521004e-22,  -3.036506390657383e-24,   6.297353440038269e-01,  -1.237938007326281e-02,   1.095213933450152e-04,   4.934176044382183e-07,  -2.764447636230420e-08,
   2.309816126141347e-10,   4.359086675501030e-12,  -1.276116279385269e-13,   4.425031581514949e-16,   3.448031573385780e-17,  -6.623858817692971e-19,  -2.251465300208713e-21,
   2.662927132602994e-22,  -2.996621967311011e-24,   6.297565563719093e-01,  -1.237909144459786e-02,   1.094892338637070e-04,   4.938632848452503e-07,  -2.763176175809620e-08,
   2.304635869720720e-10,   4.361420904278551e-12,  -1.273709788139209e-13,   4.367798382465739e-16,   3.445525719530596e-17,  -6.589926934107800e-19,  -2.295597376810133e-21,
   2.655704360100202e-22,  -2.958022336070208e-24,   6.297736432712587e-01,  -1.237885886657077e-02,   1.094633301978901e-04,   4.942220759003028e-07,  -2.762151741106538e-08,
   2.300465100051836e-10,   4.363293812309986e-12,  -1.271771579802292e-13,   4.321763826046605e-16,   3.443495693179550e-17,  -6.562614406226826e-19,  -2.331008588170912e-21,
   2.649868674467495e-22,  -2.927012496334647e-24,   6.297849332514004e-01,  -1.237870515254903e-02,   1.094462152768839e-04,   4.944590395542876e-07,  -2.761474733397254e-08,
   2.297710293723896e-10,   4.364527719357821e-12,  -1.270491057263019e-13,   4.291380133925389e-16,   3.442148745518684e-17,  -6.544577835112611e-19,  -2.354338739490090e-21,
   2.646004212145031e-22,  -2.906563586442300e-24,   6.297907309680150e-01,  -1.237862620358142e-02,   1.094374264903263e-04,   4.945806949087148e-07,  -2.761127032992035e-08,
   2.296295928801373e-10,   4.365160253088124e-12,  -1.269833513050719e-13,   4.275787513010221e-16,   3.441455311843864e-17,  -6.535318616999018e-19,  -2.366298587234936e-21,
   2.644017052294228e-22,  -2.896075024922171e-24,   6.297927488800169e-01,  -1.237859872316401e-02,   1.094343675593352e-04,   4.946230323077527e-07,  -2.761006008776159e-08,
   2.295803703438018e-10,   4.365380231356984e-12,  -1.269604659186378e-13,   4.270362086956053e-16,   3.441213683630804e-17,  -6.532096406787844e-19,  -2.370457932447883e-21,
   2.643324994047851e-22,  -2.892426443210129e-24,   6.297930690931344e-01,  -1.237859436232874e-02,   1.094338821532292e-04,   4.946297503916648e-07,  -2.760986803714521e-08,
   2.295725596772076e-10,   4.365415130292428e-12,  -1.269568343724854e-13,   4.269501228610786e-16,   3.441175327639881e-17,  -6.531585112304835e-19,  -2.371117802385416e-21,
   2.643215154528913e-22,  -2.891847561236971e-24,   9.902456307201234e-01,  -1.513051785121446e-02,   2.049903185804593e-05,   2.257171951641616e-06,  -1.149735159054030e-08,
  -5.834609450549749e-10,   5.676905300563762e-12,   1.731855134210284e-13,  -2.738170962235090e-15,  -5.367665616000990e-17,   1.272230830133807e-18,   1.547450180497337e-20,
  -5.907654050314836e-22,  -3.502376851334992e-24,   9.902475396084446e-01,  -1.512988493891220e-02,   2.049260915548113e-05,   2.256627798043254e-06,  -1.148945201218097e-08,
  -5.831228310964731e-10,   5.669825775120347e-12,   1.730064055362733e-13,  -2.732917282374642e-15,  -5.359784809911041e-17,   1.268683136747928e-18,   1.544920924457748e-20,
  -5.884279144878260e-22,  -3.496600986864550e-24,   9.902509073877303e-01,  -1.512876827911296e-02,   2.048127978855893e-05,   2.255667887276552e-06,  -1.147552113318876e-08,
  -5.825265093602162e-10,   5.657344984387708e-12,   1.726905823704951e-13,  -2.723659155328081e-15,  -5.345889573521768e-17,   1.262434827988975e-18,   1.540461442857755e-20,
  -5.843130275477248e-22,  -3.486411747918928e-24,   9.902549789170310e-01,  -1.512741821339780e-02,   2.046758632053355e-05,   2.254507590668745e-06,  -1.145868948491723e-08,
  -5.818059175881663e-10,   5.642272061559131e-12,   1.723090528959874e-13,  -2.712484688657816e-15,  -5.329105317989984e-17,   1.254899140895770e-18,   1.535074838270301e-20,
  -5.793536880950775e-22,  -3.474094931447753e-24,   9.902589306230879e-01,  -1.512610781413385e-02,   2.045429934808857e-05,   2.253381653021902e-06,  -1.144236396793761e-08,
  -5.811068890857591e-10,   5.627659385087114e-12,   1.719390550371551e-13,  -2.701658204832830e-15,  -5.312830303496190e-17,   1.247604354791092e-18,   1.529851738636026e-20,
  -5.745564080231004e-22,  -3.462142405504703e-24,   9.902621134471318e-01,  -1.512505233195395e-02,   2.044360012585067e-05,   2.252474940471722e-06,  -1.142922262185048e-08,
  -5.805441256695715e-10,   5.615901814018044e-12,   1.716412647814524e-13,  -2.692951906917701e-15,  -5.299732860745421e-17,   1.241742592198215e-18,   1.525648463545162e-20,
  -5.707040490237996e-22,  -3.452516855781370e-24,   9.902642162975652e-01,  -1.512435496568716e-02,   2.043653251685907e-05,   2.251875961600678e-06,  -1.142054408373868e-08,
  -5.801724401865180e-10,   5.608139572269612e-12,   1.714446249625208e-13,  -2.687206459327730e-15,  -5.291084908949385e-17,   1.237876489302337e-18,   1.522873161379415e-20,
  -5.681644739126997e-22,  -3.446158086611914e-24,   9.902652961181909e-01,  -1.512399685872290e-02,   2.043290365601522e-05,   2.251568406955013e-06,  -1.141608879384616e-08,
  -5.799816171086919e-10,   5.604155438265047e-12,   1.713436826414462e-13,  -2.684258220296780e-15,  -5.286645813824429e-17,   1.235893298641536e-18,   1.521448574861251e-20,
  -5.668621321938266e-22,  -3.442893062874174e-24,   9.902656719447340e-01,  -1.512387222013216e-02,   2.043164070832188e-05,   2.251461367649756e-06,  -1.141453833684643e-08,
  -5.799152081755976e-10,   5.602769065869724e-12,   1.713085553691507e-13,  -2.683232428375572e-15,  -5.285101071121518e-17,   1.235203387062676e-18,   1.520952840169799e-20,
  -5.664091347963336e-22,  -3.441756723006708e-24,   9.902657315825225e-01,  -1.512385244188559e-02,   2.043144030116463e-05,   2.251444382361469e-06,  -1.141429231241978e-08,
  -5.799046704096130e-10,   5.602549083894159e-12,   1.713029814693941e-13,  -2.683069666870925e-15,  -5.284855957156914e-17,   1.235093924497019e-18,   1.520874178919039e-20,
  -5.663372643277145e-22,  -3.441576405402837e-24,   1.372092680917504e+00,  -1.383538470463243e-02,  -1.089543280640985e-04,   1.417605526775603e-06,   3.864083818581323e-08,
  -9.786375461396508e-11,  -1.397306513096347e-11,  -8.977720739994448e-14,   4.611761975101405e-15,   7.862313423121382e-17,  -1.237248518917163e-18,  -4.650430391250146e-20,
   1.034757938601113e-22,   2.253776744549869e-23,   1.372082509878371e+00,  -1.383498633243636e-02,  -1.089327026732474e-04,   1.417512332246021e-06,   3.862133032901627e-08,
  -9.803639236711527e-11,  -1.396106652967884e-11,  -8.951791898727856e-14,   4.606565506780327e-15,   7.838956356464334e-17,  -1.236538798307841e-18,  -4.634385249802404e-20,
   1.049932096109950e-22,   2.245855411041482e-23,   1.372064564554715e+00,  -1.383428341997849e-02,  -1.088945532181996e-04,   1.417347758708667e-06,   3.858692208394821e-08,
  -9.834060236249959e-11,  -1.393990588436343e-11,  -8.906103683292554e-14,   4.597398751294858e-15,   7.797809261298522e-17,  -1.235278990162937e-18,  -4.606120179872083e-20,
   1.076581693477634e-22,   2.231897221164310e-23,   1.372042867664795e+00,  -1.383343348748723e-02,  -1.088484376388846e-04,   1.417148532629445e-06,   3.854533857496504e-08,
  -9.870775447742895e-11,  -1.391433708674237e-11,  -8.850965379374049e-14,   4.586318483554574e-15,   7.748167547651976e-17,  -1.233742880048264e-18,  -4.572021534255717e-20,
   1.108593326027606e-22,   2.215051446005873e-23,   1.372021807617756e+00,  -1.383260842626048e-02,  -1.088036852915392e-04,   1.416954895196886e-06,   3.850499442172685e-08,
  -9.906344529686828e-11,  -1.388953510763627e-11,  -8.797551397524487e-14,   4.575566446072114e-15,   7.700095223802465e-17,  -1.232238367882809e-18,  -4.539002603650552e-20,
   1.139446944840066e-22,   2.198732018887766e-23,   1.372004844008146e+00,  -1.383194379528543e-02,  -1.087676447414246e-04,   1.416798737218106e-06,   3.847251116943981e-08,
  -9.934945983951779e-11,  -1.386956911545278e-11,  -8.754602876042259e-14,   4.566907980471230e-15,   7.661453922133747e-17,  -1.231016873617547e-18,  -4.512462700016254e-20,
   1.164143128534154e-22,   2.185609778260337e-23,   1.371993635780462e+00,  -1.383150463250760e-02,  -1.087438353480272e-04,   1.416695469518141e-06,   3.845105536704797e-08,
  -9.953819617719281e-11,  -1.385638287507782e-11,  -8.726262915546662e-14,   4.561188211335371e-15,   7.635962075256165e-17,  -1.230205106364455e-18,  -4.494954815447908e-20,
   1.180384228388814e-22,   2.176950821168759e-23,   1.371987880135698e+00,  -1.383127910559399e-02,  -1.087316098044557e-04,   1.416642411489995e-06,   3.844003943002795e-08,
  -9.963504189831117e-11,  -1.384961325307125e-11,  -8.711721244588609e-14,   4.558251329472386e-15,   7.622883658392729e-17,  -1.229786797823366e-18,  -4.485972706729533e-20,
   1.188700823149146e-22,   2.172507739262752e-23,   1.371985876881204e+00,  -1.383120060955295e-02,  -1.087273548657233e-04,   1.416623940159252e-06,   3.843620565315679e-08,
  -9.966873729958426e-11,  -1.384725736533820e-11,  -8.706661832961735e-14,   4.557229199492547e-15,   7.618333643038539e-17,  -1.229640974783353e-18,  -4.482847838224340e-20,
   1.191591675052769e-22,   2.170961874071390e-23,   1.371985558994697e+00,  -1.383118815334395e-02,  -1.087266796785377e-04,   1.416621008823679e-06,   3.843559730554680e-08,
  -9.967408369579410e-11,  -1.384688353459818e-11,  -8.705859066577124e-14,   4.557067005277820e-15,   7.617611715444049e-17,  -1.229617823908424e-18,  -4.482352032822504e-20,
   1.192050232397960e-22,   2.170716594572398e-23,   1.714254200979288e+00,  -8.321001074049796e-03,  -1.457919078910633e-04,  -1.377828437514409e-06,   8.398955537369306e-09,
   5.921314644208577e-10,   1.008961426381449e-11,   8.235939584525858e-15,  -3.776917272428738e-15,  -9.243469905286325e-17,  -6.118817687972245e-19,   2.519646930634044e-20,
   8.784669866920884e-22,   1.015669505061258e-23,   1.714240542659888e+00,  -8.321386631882437e-03,  -1.457871041286359e-04,  -1.377273225068271e-06,   8.413026125071607e-09,
   5.921427796307758e-10,   1.007965065013240e-11,   7.927440841643774e-15,  -3.779326131736682e-15,  -9.230207878270100e-17,  -6.065069231705707e-19,   2.526654688798461e-20,
   8.771706517540823e-22,   1.008059777245853e-23,   1.714216442715653e+00,  -8.322066827786714e-03,  -1.457786214072619e-04,  -1.376293536840311e-06,   8.437842488388179e-09,
   5.921622534274322e-10,   1.006206466043385e-11,   7.383455814677251e-15,  -3.783558220720320e-15,  -9.206777874903588e-17,  -5.970295407403030e-19,   2.538974848397691e-20,
   8.748745236177034e-22,   9.946396713036764e-24,   1.714187301445685e+00,  -8.322889111469060e-03,  -1.457683530890550e-04,  -1.375108875462161e-06,   8.467831241126776e-09,
   5.921849627340485e-10,   1.004079093275718e-11,   6.726287664994312e-15,  -3.788644382208619e-15,  -9.178396835065673e-17,  -5.855807014008239e-19,   2.553795580494045e-20,
   8.720831839649200e-22,   9.784246196772490e-24,   1.714159012275956e+00,  -8.323687143545283e-03,  -1.457583733518062e-04,  -1.373958814561923e-06,   8.496923421043760e-09,
   5.922061308591122e-10,   1.002012983534437e-11,   6.088974707776027e-15,  -3.793549155792127e-15,  -9.150793625415846e-17,  -5.744782509423057e-19,   2.568102763033294e-20,
   8.693579129410554e-22,   9.626967417231297e-24,   1.714136223369568e+00,  -8.324329865385683e-03,  -1.457503256177215e-04,  -1.373032331987602e-06,   8.520345095663630e-09,
   5.922225551357615e-10,   1.000347914914128e-11,   5.576033111928745e-15,  -3.797476902185893e-15,  -9.128520136121239e-17,  -5.655428032218269e-19,   2.579570773519701e-20,
   8.671514092812370e-22,   9.500362706739492e-24,   1.714121165101754e+00,  -8.324754485001772e-03,  -1.457450038108665e-04,  -1.372420124753218e-06,   8.535814567547243e-09,
   5.922331004264652e-10,   9.992473560763766e-12,   5.237320485168398e-15,  -3.800060798571555e-15,  -9.113784287589254e-17,  -5.596426116943118e-19,   2.587120405326283e-20,
   8.656879896481166e-22,   9.416752448738644e-24,   1.714113432033593e+00,  -8.324972522897626e-03,  -1.457422695693167e-04,  -1.372105725811370e-06,   8.543756668974982e-09,
   5.922384208474958e-10,   9.986820704328537e-12,   5.063446528536453e-15,  -3.801384201310615e-15,  -9.106211191253247e-17,  -5.566138800911355e-19,   2.590988776022752e-20,
   8.649347862881634e-22,   9.373829466793374e-24,   1.714110740480007e+00,  -8.325048409068558e-03,  -1.457413176942656e-04,  -1.371996296185796e-06,   8.546520637837660e-09,
   5.922402575330324e-10,   9.984853023197386e-12,   5.002939441912691e-15,  -3.801844258428411e-15,  -9.103574425745800e-17,  -5.555599093361494e-19,   2.592333808820614e-20,
   8.646723617874157e-22,   9.358892106770757e-24,   1.714110313368072e+00,  -8.325060450972884e-03,  -1.457411666354413e-04,  -1.371978931202100e-06,   8.546959224906162e-09,
   5.922405482712455e-10,   9.984540772056667e-12,   4.993338338827451e-15,  -3.801917236321372e-15,  -9.103155965616605e-17,  -5.553926685246957e-19,   2.592547181063259e-20,
   8.646307060501475e-22,   9.356521866438110e-24,   1.941930976551586e+00,  -1.991854288579243e-03,  -4.939670909936978e-05,  -1.033710305907037e-06,  -1.882449321324676e-08,
  -2.931857576900373e-10,  -3.574048347883675e-12,  -2.111890682067137e-14,   5.033615020844035e-16,   2.376225561162829e-17,   6.057816370026842e-19,   1.144993148501678e-20,
   1.554874688357784e-22,   8.536709407345220e-25,   1.941926324305438e+00,  -1.992145988444860e-03,  -4.940732612478813e-05,  -1.033985504331097e-06,  -1.882950286673353e-08,
  -2.932260317624870e-10,  -3.572673523760979e-12,  -2.103716400537389e-14,   5.059475974936535e-16,   2.382150601901308e-17,   6.067309578364636e-19,   1.145548356487556e-20,
   1.552153463167700e-22,   8.412221840071692e-25,   1.941918114531210e+00,  -1.992660760438755e-03,  -4.942606232055116e-05,  -1.034471126580439e-06,  -1.883834088634349e-08,
  -2.932969643984360e-10,  -3.570242087413185e-12,  -2.089276478995995e-14,   5.105140483164839e-16,   2.392607686069327e-17,   6.084046566017530e-19,   1.146520570853989e-20,
   1.547330221945298e-22,   8.192131785060487e-25,   1.941908185798632e+00,  -1.993283335645315e-03,  -4.944872222833845e-05,  -1.035058397789258e-06,  -1.884902519392005e-08,
  -2.933825123348592e-10,  -3.567292521879004e-12,  -2.071787820289586e-14,   5.160413787729981e-16,   2.405256330116890e-17,   6.104261287689065e-19,   1.147683447375228e-20,
   1.541461056207388e-22,   7.925263667673414e-25,   1.941898545705496e+00,  -1.993887833365255e-03,  -4.947072415763972e-05,  -1.035628564456044e-06,  -1.885939448068804e-08,
  -2.934653254007287e-10,  -3.564419236162465e-12,  -2.054781066978566e-14,   5.214130015356988e-16,   2.417539394036232e-17,   6.123860347537957e-19,   1.148798988964514e-20,
   1.535724747402018e-22,   7.665425197734796e-25,   1.941890778731786e+00,  -1.994374889467536e-03,  -4.948845155081068e-05,  -1.036087921895899e-06,  -1.886774579440798e-08,
  -2.935318697128922e-10,  -3.562097458021603e-12,  -2.041059818156066e-14,   5.257444536639982e-16,   2.427437302308280e-17,   6.139631085583978e-19,   1.149688067471466e-20,
   1.531075953244282e-22,   7.455552735355276e-25,   1.941885645944644e+00,  -1.994696766929129e-03,  -4.950016692841599e-05,  -1.036391475977548e-06,  -1.887326318898788e-08,
  -2.935757582868942e-10,  -3.560559792019137e-12,  -2.031982861191193e-14,   5.286086272289079e-16,   2.433979042417466e-17,   6.150043263188549e-19,   1.150270854159901e-20,
   1.527990541259891e-22,   7.316603454129028e-25,   1.941883009855344e+00,  -1.994862078612453e-03,  -4.950618377819656e-05,  -1.036547371352922e-06,  -1.887609632403611e-08,
  -2.935982715732561e-10,  -3.559769051487626e-12,  -2.027318254657340e-14,   5.300801440601387e-16,   2.437338963662516e-17,   6.155387673363726e-19,   1.150568687965721e-20,
   1.526401835348404e-22,   7.245163063758249e-25,   1.941882092315247e+00,  -1.994919618800881e-03,  -4.950827806835737e-05,  -1.036601633093621e-06,  -1.887708237308254e-08,
  -2.936061034525356e-10,  -3.559493655756286e-12,  -2.025694193356988e-14,   5.305924187110989e-16,   2.438508482483167e-17,   6.157247407345399e-19,   1.150672119983706e-20,
   1.525848202999800e-22,   7.220284322118704e-25,   1.941881946713079e+00,  -1.994928749728577e-03,  -4.950861040670935e-05,  -1.036610243728594e-06,  -1.887723884313310e-08,
  -2.936073460703789e-10,  -3.559449946116177e-12,  -2.025436453350172e-14,   5.306737143776596e-16,   2.438694072212756e-17,   6.157542500763050e-19,   1.150688522215359e-20,
   1.525760317421378e-22,   7.216335778976609e-25,   1.232327381009253e-02,  -3.067862190472105e-04,   5.696114972105750e-06,  -9.345615077735630e-08,   1.423812754125702e-09,
  -2.063430575138243e-11,   2.862094802706993e-13,  -3.847468899505397e-15,   4.932841484255466e-17,  -6.240844415216245e-19,   7.386984135676952e-21,  -7.510096370119291e-23,
   1.243225886623877e-24,  -2.993088871699605e-27,   1.232380943220650e-02,  -3.068125719157366e-04,   5.696918146611797e-06,  -9.347555940392901e-08,   1.424216775413768e-09,
  -2.064191412782177e-11,   2.863396165590100e-13,  -3.849585305424927e-15,   4.935982476901718e-17,  -6.244726946211156e-19,   7.394644642805604e-21,  -7.512647522830683e-23,
   1.242541378702532e-24,  -3.059240058954355e-27,   1.232475460735700e-02,  -3.068590764165993e-04,   5.698335545812563e-06,  -9.350981204079156e-08,   1.424929826382227e-09,
  -2.065534262045751e-11,   2.865693112727138e-13,  -3.853320803103025e-15,   4.941527432545791e-17,  -6.251578839711321e-19,   7.408158249089216e-21,  -7.517187968044967e-23,
   1.241330293792952e-24,  -3.175644588748395e-27,   1.232589762812733e-02,  -3.069153177440746e-04,   5.700049795812761e-06,  -9.355124060347656e-08,   1.425792309426909e-09,
  -2.067158628326409e-11,   2.868471751703100e-13,  -3.857839624875167e-15,   4.948236926677714e-17,  -6.259866120282736e-19,   7.424493103034824e-21,  -7.522744514165345e-23,
   1.239860304360697e-24,  -3.315856798813681e-27,   1.232700736274690e-02,  -3.069699237986617e-04,   5.701714290741548e-06,  -9.359146911306032e-08,   1.426629859295026e-09,
  -2.068736141051219e-11,   2.871170406846247e-13,  -3.862228322966427e-15,   4.954755072065440e-17,  -6.267913270249700e-19,   7.440344458784240e-21,  -7.528207862216733e-23,
   1.238427503218837e-24,  -3.451402167499560e-27,   1.232790142923493e-02,  -3.070139194212419e-04,   5.703055423199855e-06,  -9.362388411467951e-08,   1.427304769397436e-09,
  -2.070007399131243e-11,   2.873345268851485e-13,  -3.865765165576740e-15,   4.960009361002972e-17,  -6.274397393596403e-19,   7.453109625653840e-21,  -7.532658492969936e-23,
   1.237269152732703e-24,  -3.560187835727588e-27,   1.232849225098521e-02,  -3.070429937337143e-04,   5.703941735690516e-06,  -9.364530701252020e-08,   1.427750831420115e-09,
  -2.070847636532792e-11,   2.874782800392117e-13,  -3.868102916341735e-15,   4.963482944310489e-17,  -6.278682697819089e-19,   7.461542423413329e-21,  -7.535623545028711e-23,
   1.236501734992006e-24,  -3.631871998233160e-27,   1.232879567814406e-02,  -3.070579256468649e-04,   5.704396935457263e-06,  -9.365630982213841e-08,   1.427979934516445e-09,
  -2.071279204433643e-11,   2.875521171995191e-13,  -3.869303669872799e-15,   4.965267303524568e-17,  -6.280883627327274e-19,   7.465872388236766e-21,  -7.537153701134687e-23,
   1.236107012608436e-24,  -3.668623612999684e-27,   1.232890129064320e-02,  -3.070631229733033e-04,   5.704555377619416e-06,  -9.366013963014388e-08,   1.428059680549169e-09,
  -2.071429426068580e-11,   2.875778189751738e-13,  -3.869721636036857e-15,   4.965888446955231e-17,  -6.281649716217067e-19,   7.467379363763070e-21,  -7.537687472731541e-23,
   1.235969527871959e-24,  -3.681405541974725e-27,   1.232891804998239e-02,  -3.070639477239496e-04,   5.704580520479752e-06,  -9.366074737644427e-08,   1.428072335364760e-09,
  -2.071453264670450e-11,   2.875818975915511e-13,  -3.869787963072734e-15,   4.965987017701983e-17,  -6.281771285646618e-19,   7.467618494877859e-21,  -7.537772231253705e-23,
   1.235947706289112e-24,  -3.683433392590866e-27,   1.103332199616240e-01,  -2.657135477847697e-03,   4.578619891636305e-05,  -6.541287038996329e-07,   7.823673651752581e-09,
  -7.315477804052979e-11,   3.478020871701268e-13,   4.813492815838884e-15,  -1.848437634087182e-16,   3.372015609366555e-18,  -4.680327717733842e-20,   5.210417573853349e-22,
   2.264330512006970e-24,  -1.801313037885127e-26,   1.103375212492601e-01,  -2.657319692450151e-03,   4.579060244907637e-05,  -6.541972049792858e-07,   7.824156954944771e-09,
  -7.314511920619006e-11,   3.473128062604350e-13,   4.824943154146673e-15,  -1.850407529419077e-16,   3.374694720951119e-18,  -4.678897273413633e-20,   5.208571156526954e-22,
   2.270661383075699e-24,  -1.897575834779500e-26,   1.103451112750325e-01,  -2.657644757668148e-03,   4.579837277159576e-05,  -6.543180687956838e-07,   7.825009190055388e-09,
  -7.312805767898169e-11,   3.464490422634869e-13,   4.845154801999490e-15,  -1.853882947563742e-16,   3.379421227473368e-18,  -4.676370037891524e-20,   5.205256226893184e-22,
   2.281840506052555e-24,  -2.067186581903234e-26,   1.103542897883349e-01,  -2.658037856693092e-03,   4.580776910316226e-05,  -6.544642059588712e-07,   7.826038765018824e-09,
  -7.310739538108510e-11,   3.454038533172368e-13,   4.869607466075366e-15,  -1.858084618690419e-16,   3.385135141543030e-18,  -4.673308628648801e-20,   5.201150863951727e-22,
   2.295372672129795e-24,  -2.271862088948962e-26,   1.103632007302688e-01,  -2.658419498370191e-03,   4.581689129120144e-05,  -6.546060601228483e-07,   7.827037256160369e-09,
  -7.308730397492332e-11,   3.443884519784239e-13,   4.893358801530488e-15,  -1.862162645986270e-16,   3.390680594139730e-18,  -4.670330955499077e-20,   5.197064087951202e-22,
   2.308524728449081e-24,  -2.470118915137220e-26,   1.103703796991904e-01,  -2.658726963966050e-03,   4.582424028797011e-05,  -6.547203264800921e-07,   7.827840909119472e-09,
  -7.307109508746089e-11,   3.435699205556443e-13,   4.912501962043998e-15,  -1.865447218900098e-16,   3.395146837605991e-18,  -4.667928086738763e-20,   5.193699299380076e-22,
   2.319131029553303e-24,  -2.629518340955967e-26,   1.103751236445009e-01,  -2.658930141558318e-03,   4.582909651149915e-05,  -6.547958269923238e-07,   7.828371596752656e-09,
  -7.306037302838125e-11,   3.430287865184746e-13,   4.925156020216836e-15,  -1.867617296039318e-16,   3.398097506732919e-18,  -4.666338308208943e-20,   5.191440428124891e-22,
   2.326145052553959e-24,  -2.734693278048323e-26,   1.103775599525183e-01,  -2.659034486005475e-03,   4.583159045711613e-05,  -6.548345986757049e-07,   7.828644021383068e-09,
  -7.305486317627019e-11,   3.427508069516045e-13,   4.931655906633093e-15,  -1.868731638515955e-16,   3.399612646713403e-18,  -4.665521260354030e-20,   5.190269425168210e-22,
   2.329748831475742e-24,  -2.788658260348670e-26,   1.103784079422007e-01,  -2.659070804528529e-03,   4.583245850448753e-05,  -6.548480932854969e-07,   7.828738823937276e-09,
  -7.305294485469563e-11,   3.426540406677265e-13,   4.933918478008335e-15,  -1.869119480336245e-16,   3.400139977914562e-18,  -4.665236780557725e-20,   5.189860101989327e-22,
   2.331003438962426e-24,  -2.807433727967362e-26,   1.103785425069767e-01,  -2.659076567800865e-03,   4.583259625197134e-05,  -6.548502346833155e-07,   7.828753866974077e-09,
  -7.305264041655860e-11,   3.426386845763955e-13,   4.934277527671877e-15,  -1.869181024766013e-16,   3.400223656822770e-18,  -4.665191632840787e-20,   5.189795065216988e-22,
   2.331202541184613e-24,  -2.810412778300939e-26,   3.029799550648281e-01,  -6.786858785925718e-03,   9.785112720645106e-05,  -9.194309555325759e-07,   1.651201974778595e-09,
   1.370292337962374e-10,  -3.107898496454971e-12,   3.332462615363527e-14,   1.006141105831991e-17,  -8.802495469162587e-18,   1.845843184775075e-19,  -1.628626254924567e-21,
   2.076762043805964e-24,   8.432791760621807e-25,   3.029891304044163e-01,  -6.787116920833238e-03,   9.785203133922352e-05,  -9.193019437427762e-07,   1.646832028732858e-09,
   1.370943651345338e-10,  -3.107855998857045e-12,   3.329470602871696e-14,   1.084028955846477e-17,  -8.810655069116541e-18,   1.845904877484378e-19,  -1.622503059046847e-21,
   1.932586218651295e-24,   8.424913488048445e-25,   3.030053205016769e-01,  -6.787572374350876e-03,   9.785362469744193e-05,  -9.190742509111416e-07,   1.639121244989357e-09,
   1.372092424132327e-10,  -3.107779348861864e-12,   3.324188928263751e-14,   1.221464823085053e-17,  -8.825027187240570e-18,   1.846006482606588e-19,  -1.611703233162886e-21,
   1.678185358043301e-24,   8.411037521279398e-25,   3.030248978530659e-01,  -6.788123063153770e-03,   9.785554799600636e-05,  -9.187988379315656e-07,   1.629797377641185e-09,
   1.373480713909000e-10,  -3.107683828466657e-12,   3.317798487867863e-14,   1.387656181616948e-17,  -8.842362427666722e-18,   1.846116978342007e-19,  -1.598651886107699e-21,
   1.370562091091372e-24,   8.394301513712958e-25,   3.030439033248999e-01,  -6.788657609463396e-03,   9.785741153298073e-05,  -9.185313834539675e-07,   1.620746029487382e-09,
   1.374827584105252e-10,  -3.107588130742484e-12,   3.311590803536402e-14,   1.548994212858353e-17,  -8.859145456387485e-18,   1.846211295991035e-19,  -1.585990142909688e-21,
   1.071929763095446e-24,   8.378099096230491e-25,   3.030592139703030e-01,  -6.789088195146852e-03,   9.785891021770595e-05,  -9.183158623433026e-07,   1.613454454565932e-09,
   1.375911990615952e-10,  -3.107508911198112e-12,   3.306587144050009e-14,   1.678967554036964e-17,  -8.872632897913943e-18,   1.846277998765054e-19,  -1.575795929844255e-21,
   8.313590086974844e-25,   8.365078335620996e-25,   3.030693310133495e-01,  -6.789372699949964e-03,   9.785989927018706e-05,  -9.181734188672612e-07,   1.608636348183874e-09,
   1.376628246106218e-10,  -3.107455523039603e-12,   3.303279431238558e-14,   1.764852305528397e-17,  -8.881529129451133e-18,   1.846317531924501e-19,  -1.569062671701789e-21,
   6.723964521101890e-25,   8.356489861113974e-25,   3.030745266118053e-01,  -6.789518801043330e-03,   9.786040680886626e-05,  -9.181002577522239e-07,   1.606162031386169e-09,
   1.376995984462010e-10,  -3.107427783634660e-12,   3.301580334873033e-14,   1.808958432901968e-17,  -8.886092813752095e-18,   1.846336429189876e-19,  -1.565605716395976e-21,
   5.907624089517417e-25,   8.352084012053640e-25,   3.030763349894598e-01,  -6.789569651953585e-03,   9.786058340072565e-05,  -9.180747918320584e-07,   1.605300824584296e-09,
   1.377123964339486e-10,  -3.107418077412884e-12,   3.300988880786763e-14,   1.824310004801837e-17,  -8.887680456913492e-18,   1.846342782894859e-19,  -1.564402633849182e-21,
   5.623490764265373e-25,   8.350551269091036e-25,   3.030766219541846e-01,  -6.789577721249355e-03,   9.786061142049610e-05,  -9.180707506689008e-07,   1.605164163012098e-09,
   1.377144272279652e-10,  -3.107416534735309e-12,   3.300895021939674e-14,   1.826746089254289e-17,  -8.887932356565497e-18,   1.846343780522428e-19,  -1.564211727977208e-21,
   5.578402789122394e-25,   8.350308079605700e-25,   5.819457811969344e-01,  -1.148679270245551e-02,   1.130174672512110e-04,   9.122233784332660e-08,  -2.226352309627051e-08,
   2.962360217124918e-10,   1.118743436448889e-12,  -9.885078679094359e-14,   1.223975546169321e-15,   9.002711199118871e-18,  -5.432691359122418e-19,   6.532922916335205e-21,
   9.596738946118283e-23,  -2.924990538045112e-24,   5.819563514426203e-01,  -1.148676607410549e-02,   1.130049531555858e-04,   9.149842700948594e-08,  -2.226191249779998e-08,
   2.960419083830211e-10,   1.121909492168832e-12,  -9.881954946689708e-14,   1.221703067480916e-15,   9.035568283305589e-18,  -5.426661442701971e-19,   6.511622442823912e-21,
   9.616865049565531e-23,  -2.923439344830936e-24,   5.819750018549866e-01,  -1.148671902511607e-02,   1.129828725819822e-04,   9.198544289692914e-08,  -2.225906697013070e-08,
   2.956994427716621e-10,   1.127491209415556e-12,  -9.876434116896419e-14,   1.217695319197804e-15,   9.093455926629417e-18,  -5.416011650102706e-19,   6.474047128617357e-21,
   9.652183757454091e-23,  -2.920666169997521e-24,   5.819975525089544e-01,  -1.148666202583925e-02,   1.129561737878563e-04,   9.257409574459665e-08,  -2.225561999088081e-08,
   2.952854157499652e-10,   1.134232435605671e-12,  -9.869743018552165e-14,   1.212852649394391e-15,   9.163302220996089e-18,  -5.403116975909953e-19,   6.428627352904401e-21,
   9.694561079858085e-23,  -2.917251499322131e-24,   5.820194425929577e-01,  -1.148660657976555e-02,   1.129302563934954e-04,   9.314528591611476e-08,  -2.225226730152838e-08,
   2.948835757241785e-10,   1.140768070114332e-12,  -9.863231465759487e-14,   1.208155181699298e-15,   9.230948592986333e-18,  -5.390581508769625e-19,   6.384552289683412e-21,
   9.735354924057995e-23,  -2.913872619391295e-24,   5.820370757415886e-01,  -1.148656183278639e-02,   1.129093786336028e-04,   9.360524028571450e-08,  -2.224956182095507e-08,
   2.945599233694425e-10,   1.146026910807649e-12,  -9.857974430206032e-14,   1.204373624732277e-15,   9.285329589305128e-18,  -5.380470591361372e-19,   6.349058781841956e-21,
   9.767970984276368e-23,  -2.911104963884334e-24,   5.820487268155504e-01,  -1.148653222544989e-02,   1.128955834502573e-04,   9.390907740742968e-08,  -2.224777183783719e-08,
   2.943460913949572e-10,   1.149498833547850e-12,  -9.854495092585711e-14,   1.201876143427394e-15,   9.321207755888743e-18,  -5.373783377033402e-19,   6.325611618899269e-21,
   9.789402392088274e-23,  -2.909253849985101e-24,   5.820547100150339e-01,  -1.148651700850461e-02,   1.128884991084984e-04,   9.406508369321305e-08,  -2.224685190039438e-08,
   2.942362882667167e-10,   1.151280896570249e-12,  -9.852706561193270e-14,   1.200593970780524e-15,   9.339615648384838e-18,  -5.370347291079896e-19,   6.313572342878475e-21,
   9.800371159276061e-23,  -2.908296333234153e-24,   5.820567924930375e-01,  -1.148651171017152e-02,   1.128860333615590e-04,   9.411937855439183e-08,  -2.224653159705004e-08,
   2.941980718467548e-10,   1.151901011024094e-12,  -9.852083771949204e-14,   1.200147763102890e-15,   9.346019935891687e-18,  -5.369151030827673e-19,   6.309382276279853e-21,
   9.804183006922362e-23,  -2.907961966527492e-24,   5.820571229522221e-01,  -1.148651086930712e-02,   1.128856420825747e-04,   9.412799418485050e-08,  -2.224648076406616e-08,
   2.941920075015115e-10,   1.151999407579178e-12,  -9.851984930843620e-14,   1.200076959140384e-15,   9.347036077662824e-18,  -5.368961186612231e-19,   6.308717385328347e-21,
   9.804787613100722e-23,  -2.907908855214811e-24,   9.302175742780868e-01,  -1.486213999457746e-02,   4.612427806857441e-05,   1.988714631311331e-06,  -2.146871847620457e-08,
  -4.003368853586835e-10,   9.084137746881868e-12,   6.529144258187702e-14,  -3.667537324210228e-15,   2.421457975980491e-18,   1.336154848987351e-18,  -1.097229619993379e-20,
  -3.989617548823737e-22,   9.173304927185114e-24,   9.302218743235998e-01,  -1.486158198761824e-02,   4.611227335095312e-05,   1.988340397947550e-06,  -2.145605625083492e-08,
  -4.002082384786189e-10,   9.074625054077887e-12,   6.529821475452069e-14,  -3.661978269246394e-15,   2.367367489417146e-18,   1.333727604319299e-18,  -1.090799133503937e-20,
  -3.980668141469840e-22,   9.122683096603817e-24,   9.302294609151742e-01,  -1.486059746092839e-02,   4.609109660175332e-05,   1.987680155364359e-06,  -2.143372438537872e-08,
  -3.999812288773326e-10,   9.057851574385203e-12,   6.531001775928487e-14,  -3.652177518023978e-15,   2.272190715292472e-18,   1.329449171512640e-18,  -1.079482221954067e-20,
  -3.964897855571707e-22,   9.033591811060946e-24,   9.302386331576084e-01,  -1.485940710628002e-02,   4.606549927490590e-05,   1.986881950208458e-06,  -2.140673891258612e-08,
  -3.997067092815981e-10,   9.037589039408548e-12,   6.532404061068102e-14,  -3.640340467390288e-15,   2.157555907465219e-18,   1.324283273974905e-18,  -1.065848380341525e-20,
  -3.945864186905148e-22,   8.926256035991836e-24,   9.302475357940974e-01,  -1.485825168298517e-02,   4.604066011695790e-05,   1.986107241587941e-06,  -2.138056119949264e-08,
  -3.994401926426376e-10,   9.017939591894227e-12,   6.533739314595502e-14,  -3.628864039064282e-15,   2.046744723993670e-18,   1.319276289962188e-18,  -1.052665844158839e-20,
  -3.927424229356095e-22,   8.822468322908780e-24,   9.302547064834744e-01,  -1.485732099817932e-02,   4.602065737965188e-05,   1.985483271880682e-06,  -2.135948660636313e-08,
  -3.992254777166509e-10,   9.002125338732930e-12,   6.534796349787857e-14,  -3.619629354844217e-15,   1.957815749942777e-18,   1.315248439803665e-18,  -1.042084026879566e-20,
  -3.912596159773298e-22,   8.739152804524118e-24,   9.302594441800006e-01,  -1.485670607168833e-02,   4.600744353220414e-05,   1.985071025255094e-06,  -2.134556765987636e-08,
  -3.990835918128753e-10,   8.991682944201294e-12,   6.535485717202712e-14,  -3.613532415096201e-15,   1.899218780484856e-18,   1.312589701823512e-18,  -1.035110255079074e-20,
  -3.902811208881492e-22,   8.684243320756785e-24,   9.302618770384460e-01,  -1.485639029404050e-02,   4.600065870390773e-05,   1.984859335889251e-06,  -2.133842170759050e-08,
  -3.990107247363013e-10,   8.986322557051105e-12,   6.535836929121266e-14,  -3.610402944437949e-15,   1.869177615543415e-18,   1.311225176056828e-18,  -1.031534605061371e-20,
  -3.897790240754127e-22,   8.656089125578835e-24,   9.302627237891835e-01,  -1.485628038736961e-02,   4.599829735971259e-05,   1.984785658492001e-06,  -2.133593482655918e-08,
  -3.989853623854319e-10,   8.984457188443694e-12,   6.535958724434408e-14,  -3.609313958107804e-15,   1.858729655500943e-18,   1.310750377772704e-18,  -1.030290976598792e-20,
  -3.896043294994995e-22,   8.646296871738548e-24,   9.302628581555384e-01,  -1.485626294681952e-02,   4.599792265533236e-05,   1.984773967047373e-06,  -2.133554020860159e-08,
  -3.989813377155404e-10,   8.984161197377988e-12,   6.535978030449507e-14,  -3.609141163059809e-15,   1.857072094568581e-18,   1.310675040346100e-18,  -1.030093673042414e-20,
  -3.895766109530571e-22,   8.644743311522988e-24,   1.315130100110094e+00,  -1.462873400927404e-02,  -8.835870174069825e-05,   2.001454584709420e-06,   3.322214412196247e-08,
  -4.445274098217972e-10,  -1.408533421934120e-11,   8.979790549610749e-14,   6.103677455125851e-15,  -5.957753303138034e-18,  -2.741944081838941e-18,  -1.248868469654471e-20,
   1.251971054685965e-21,   1.519743540291394e-23,   1.315121853787202e+00,  -1.462817256363303e-02,  -8.834012497443114e-05,   2.001039324203820e-06,   3.320252301665157e-08,
  -4.443509685824144e-10,  -1.406954526380059e-11,   8.977624170230520e-14,   6.092352078613859e-15,  -6.018074448427504e-18,  -2.734383263162284e-18,  -1.238312830890008e-20,
   1.247947316564051e-21,   1.509560263427467e-23,   1.315107304423257e+00,  -1.462718197864649e-02,  -8.830735490684895e-05,   2.000306724871163e-06,   3.316791922698580e-08,
  -4.440396706696164e-10,  -1.404170942640394e-11,   8.973785305778823e-14,   6.072394042982690e-15,  -6.124075236264503e-18,  -2.721062204488531e-18,  -1.219747031025592e-20,
   1.240857885369305e-21,   1.491647411797655e-23,   1.315089713567886e+00,  -1.462598431411211e-02,  -8.826774420964907e-05,   1.999421087010423e-06,   3.312610655823253e-08,
  -4.436633064938164e-10,  -1.400809095819615e-11,   8.969115676919705e-14,   6.048304464905891e-15,  -6.251509408409039e-18,  -2.704988516362278e-18,  -1.197398790647076e-20,
   1.232303189214420e-21,   1.470081746808685e-23,   1.315072639173198e+00,  -1.462482181111933e-02,  -8.822930676016338e-05,   1.998561564971499e-06,   3.308554756694016e-08,
  -4.432980023360133e-10,  -1.397549753836749e-11,   8.964553648800663e-14,   6.024964622549741e-15,  -6.374444288031683e-18,  -2.689420308012869e-18,  -1.175809742519922e-20,
   1.224017185424986e-21,   1.449245100439976e-23,   1.315058886056005e+00,  -1.462388543489888e-02,  -8.819835345925828e-05,   1.997869317040408e-06,   3.305289669909869e-08,
  -4.430037638330881e-10,  -1.394927134072166e-11,   8.960857952312336e-14,   6.006195196136079e-15,  -6.472924549072002e-18,  -2.676904415631535e-18,  -1.158493802649548e-20,
   1.217355507902526e-21,   1.432530046756054e-23,   1.315049799118960e+00,  -1.462326675344603e-02,  -8.817790565332780e-05,   1.997411976072776e-06,   3.303133280670355e-08,
  -4.428093587484988e-10,  -1.393195652387143e-11,   8.958405851877052e-14,   5.993808759257001e-15,  -6.537727679330589e-18,  -2.668646684589796e-18,  -1.147088827524794e-20,
   1.212960155340920e-21,   1.421519560598918e-23,   1.315045132813423e+00,  -1.462294904924616e-02,  -8.816740645302995e-05,   1.997177135620450e-06,   3.302026218442918e-08,
  -4.427095294001575e-10,  -1.392306916901871e-11,   8.957143479167840e-14,   5.987452696090854e-15,  -6.570923548907053e-18,  -2.664409822276691e-18,  -1.141243280050201e-20,
   1.210704960750331e-21,   1.415875808378946e-23,   1.315043508706258e+00,  -1.462283847230781e-02,  -8.816375238503054e-05,   1.997095401392306e-06,   3.301640950498887e-08,
  -4.426747839912202e-10,  -1.391997658095084e-11,   8.956703605530610e-14,   5.985241200184763e-15,  -6.582464371603904e-18,  -2.662935760634474e-18,  -1.139210505508033e-20,
   1.209920342582575e-21,   1.413913144149057e-23,   1.315043250984869e+00,  -1.462282092540910e-02,  -8.816317254780920e-05,   1.997082431492589e-06,   3.301579816402548e-08,
  -4.426692704260615e-10,  -1.391948586480729e-11,   8.956633780237224e-14,   5.984890303743132e-15,  -6.584295109888023e-18,  -2.662701876643040e-18,  -1.138888018639202e-20,
   1.209795849815356e-21,   1.413601776821517e-23,   1.678537329825615e+00,  -9.550202816446675e-03,  -1.610865896786472e-04,  -1.135755075624111e-06,   2.259774110790938e-08,
   8.202168919325583e-10,   8.110718600813613e-12,  -1.676166277774366e-13,  -7.153976109104269e-15,  -8.093679281239248e-17,   1.545543520121905e-18,   7.347296412937069e-20,
   9.243391431443725e-22,  -1.419379124668733e-23,   1.678522253632427e+00,  -9.550519548968735e-03,  -1.610738154560277e-04,  -1.134988937454552e-06,   2.260892656111725e-08,
   8.198827292341821e-10,   8.092078208527992e-12,  -1.678800412643307e-13,  -7.147282807470082e-15,  -8.056220780751528e-17,   1.550970983084670e-18,   7.336425755506564e-20,
   9.180231439584357e-22,  -1.428394493644299e-23,   1.678495652433075e+00,  -9.551078253803053e-03,  -1.610512700754599e-04,  -1.133637330553116e-06,   2.262864221308557e-08,
   8.192926770626105e-10,   8.059201331207332e-12,  -1.683438138436777e-13,  -7.135454011955824e-15,  -7.990170735134625e-17,   1.560516183823346e-18,   7.317191721955866e-20,
   9.068901110165394e-22,  -1.444227293829571e-23,   1.678463487651028e+00,  -9.551753547848643e-03,  -1.610239993328290e-04,  -1.132003389679913e-06,   2.265244635787410e-08,
   8.185784700572182e-10,   8.019470819375762e-12,  -1.689028663391528e-13,  -7.121119275725621e-15,  -7.910381013034795e-17,   1.572004428967661e-18,   7.293844361188083e-20,
   8.934478419595563e-22,  -1.463244808818328e-23,   1.678432264389062e+00,  -9.552408799807165e-03,  -1.609975163417037e-04,  -1.130417645675816e-06,   2.267551708203135e-08,
   8.178843885866937e-10,   7.980926878542550e-12,  -1.694437572693032e-13,  -7.107170752415146e-15,  -7.833005134717350e-17,   1.583100612443356e-18,   7.271085956468098e-20,
   8.804192418699133e-22,  -1.481573157566166e-23,   1.678407112590556e+00,  -9.552936438888339e-03,  -1.609761755271431e-04,  -1.129140518926377e-06,   2.269407539264593e-08,
   8.173247151814703e-10,   7.949894856309509e-12,  -1.698781833181444e-13,  -7.095910705445808e-15,  -7.770731451614363e-17,   1.591999175354736e-18,   7.252685583723731e-20,
   8.699386100593406e-22,  -1.496242690524621e-23,   1.678390493344878e+00,  -9.553284984037869e-03,  -1.609620707358306e-04,  -1.128296776995937e-06,   2.270632509724357e-08,
   8.169546336745710e-10,   7.929398504404446e-12,  -1.701646038801071e-13,  -7.088458886563339e-15,  -7.729611208783018e-17,   1.597859431747513e-18,   7.240494496270038e-20,
   8.630205782323376e-22,  -1.505889324775860e-23,   1.678381958757146e+00,  -9.553463944833284e-03,  -1.609548262734773e-04,  -1.127863524849689e-06,   2.271261179551069e-08,
   8.167644990115072e-10,   7.918875449548371e-12,  -1.703114965516895e-13,  -7.084628507232011e-15,  -7.708503006706320e-17,   1.600862847405809e-18,   7.234223777877792e-20,
   8.594701252641602e-22,  -1.510828891537147e-23,   1.678378988245998e+00,  -9.553526228393705e-03,  -1.609523046164985e-04,  -1.127712735387416e-06,   2.271479928398881e-08,
   8.166983081562638e-10,   7.915213250291763e-12,  -1.703625923767302e-13,  -7.083294749739384e-15,  -7.701157539115940e-17,   1.601907241863716e-18,   7.232039605133774e-20,
   8.582347221179790e-22,  -1.512545854834299e-23,   1.678378516868227e+00,  -9.553536111681403e-03,  -1.609519044568829e-04,  -1.127688807552234e-06,   2.271514637721755e-08,
   8.166878039742622e-10,   7.914632130899922e-12,  -1.703706990844860e-13,  -7.083083074272140e-15,  -7.699991982738689e-17,   1.602072926748548e-18,   7.231692931475330e-20,
   8.580386979654890e-22,  -1.512818204181834e-23,   1.933086794765249e+00,  -2.442243064266453e-03,  -6.381742821322570e-05,  -1.386628808763870e-06,  -2.558042185611247e-08,
  -3.832541955574807e-10,  -3.771556486358287e-12,   1.447311707496671e-14,   1.936984606276504e-15,   6.032891625468484e-17,   1.276809044668548e-18,   1.870558522789829e-20,
   1.051691784876599e-22,  -4.130821044324647e-24,   1.933080782948043e+00,  -2.442634317412011e-03,  -6.383184672841287e-05,  -1.386987838422484e-06,  -2.558566397236550e-08,
  -3.832224180663967e-10,  -3.766360233765873e-12,   1.467920263287024e-14,   1.942389364856312e-15,   6.042408989769679e-17,   1.277387364885701e-18,   1.867312234953298e-20,
   1.036137609356764e-22,  -4.171632332229776e-24,   1.933070173899371e+00,  -2.443324771799303e-03,  -6.385729080838191e-05,  -1.387621326678206e-06,  -2.559490778432522e-08,
  -3.831660151042151e-10,  -3.757179818833113e-12,   1.504310404593448e-14,   1.951928066190977e-15,   6.059188688869702e-17,   1.278399940270701e-18,   1.861559773503083e-20,
   1.008642005818402e-22,  -4.243698670253051e-24,   1.933057343444149e+00,  -2.444159816531265e-03,  -6.388806212322293e-05,  -1.388387304261360e-06,  -2.560607528716377e-08,
  -3.830972472375732e-10,  -3.746059074248134e-12,   1.548358092949333e-14,   1.963465620584103e-15,   6.079455212087907e-17,   1.279610904433602e-18,   1.854562319858407e-20,
   9.753087900106983e-23,  -4.330934024448809e-24,   1.933044885891219e+00,  -2.444970610009132e-03,  -6.391793863375288e-05,  -1.389130856596550e-06,  -2.561690579874326e-08,
  -3.830298967648375e-10,  -3.735242626542825e-12,   1.591165225845710e-14,   1.974669463347928e-15,   6.099104727543546e-17,   1.280772377877823e-18,   1.847725810377961e-20,
   9.428602763600290e-23,  -4.415716379149014e-24,   1.933034848837618e+00,  -2.445623879658870e-03,  -6.394200980604606e-05,  -1.389729819972153e-06,  -2.562562303845307e-08,
  -3.829752158084367e-10,  -3.726514259351059e-12,   1.625683316759483e-14,   1.983697541730183e-15,   6.114916236177457e-17,   1.281697920829545e-18,   1.842187218340637e-20,
   9.166563005988422e-23,  -4.484084198203916e-24,   1.933028215840510e+00,  -2.446055599999476e-03,  -6.395791709759367e-05,  -1.390125588218939e-06,  -2.563137947175185e-08,
  -3.829388757589978e-10,  -3.720739473319581e-12,   1.648508512760751e-14,   1.989664307518928e-15,   6.125355416755535e-17,   1.282304539437349e-18,   1.838512136652755e-20,
   8.993099214297858e-23,  -4.529293705037623e-24,   1.933024809265445e+00,  -2.446277324945071e-03,  -6.396608671349895e-05,  -1.390328829163633e-06,  -2.563433451111619e-08,
  -3.829201491040398e-10,  -3.717771606221480e-12,   1.660235368456266e-14,   1.992728888389165e-15,   6.130713713935851e-17,   1.282614530722113e-18,   1.836620079607620e-20,
   8.903920621312668e-23,  -4.552521206913769e-24,   1.933023623541778e+00,  -2.446354500873140e-03,  -6.396893029643851e-05,  -1.390399568240548e-06,  -2.563536285416491e-08,
  -3.829136208815632e-10,  -3.716738256562831e-12,   1.664317807840526e-14,   1.993795601190745e-15,   6.132578284582901e-17,   1.282722181312914e-18,   1.835960779173126e-20,
   8.872865813867470e-23,  -4.560607381706480e-24,   1.933023435382147e+00,  -2.446366747750158e-03,  -6.396938153736847e-05,  -1.390410793520049e-06,  -2.563552602923834e-08,
  -3.829125844564590e-10,  -3.716574261286712e-12,   1.664965672715164e-14,   1.993964876542048e-15,   6.132874145663687e-17,   1.282739252359286e-18,   1.835856121540327e-20,
   8.867937113473356e-23,  -4.561890623607488e-24,   1.118067234614846e-02,  -2.653450264953854e-04,   4.698824597098619e-06,  -7.363708424827679e-08,   1.071931576271263e-09,
  -1.489851796018216e-11,   1.975761172281116e-13,  -2.576848161061276e-15,   3.153763006218508e-17,  -3.780021415485788e-19,   5.297973373542278e-21,  -2.345885325371334e-23,
   7.723576223917432e-25,  -1.849387453736746e-26,   1.118111407369791e-02,  -2.653657862426089e-04,   4.699429131843693e-06,  -7.365109442671258e-08,   1.072210402389779e-09,
  -1.490361147275039e-11,   1.976593684501557e-13,  -2.578127228031021e-15,   3.156012857121273e-17,  -3.781283971334064e-19,   5.302592595498573e-21,  -2.359485171486209e-23,
   7.688872287712665e-25,  -1.850811273619891e-26,   1.118189355518506e-02,  -2.654024203547149e-04,   4.700495970671568e-06,  -7.367581949584488e-08,   1.072702490832962e-09,
  -1.491260110486052e-11,   1.978063146473966e-13,  -2.580384512183636e-15,   3.159984324847853e-17,  -3.783517479757106e-19,   5.310726003563914e-21,  -2.383490385255669e-23,
   7.627795836795000e-25,  -1.853294354303024e-26,   1.118283619144068e-02,  -2.654467241910577e-04,   4.701786221452159e-06,  -7.370572394555099e-08,   1.073297692088895e-09,
  -1.492347495825426e-11,   1.979840856071653e-13,  -2.583114642770418e-15,   3.164789339710245e-17,  -3.786227998184454e-19,   5.320531595315135e-21,  -2.412531390340888e-23,
   7.554212613691504e-25,  -1.856247140568135e-26,   1.118375136904617e-02,  -2.654897393242709e-04,   4.703039002766734e-06,  -7.373476161394773e-08,   1.073875673541777e-09,
  -1.493403476648702e-11,   1.981567485266767e-13,  -2.585765634369750e-15,   3.169456759647778e-17,  -3.788869521045769e-19,   5.330019963549593e-21,  -2.440738032786985e-23,
   7.483062702456937e-25,  -1.859061688858044e-26,   1.118448868344527e-02,  -2.655243958664328e-04,   4.704048390627334e-06,  -7.375815895993639e-08,   1.074341409992198e-09,
  -1.494254423310660e-11,   1.982959051319183e-13,  -2.587901689714655e-15,   3.173218771215950e-17,  -3.791004806697471e-19,   5.337641700355609e-21,  -2.463470960619739e-23,
   7.425947997514769e-25,  -1.861291935450725e-26,   1.118497591666440e-02,  -2.655472983048174e-04,   4.704715456221435e-06,  -7.377362194708569e-08,   1.074649220143118e-09,
  -1.494816842121341e-11,   1.983878875082657e-13,  -2.589313378240002e-15,   3.175705618632239e-17,  -3.792419344992327e-19,   5.342667271309944e-21,  -2.478497339457825e-23,
   7.388306753867141e-25,  -1.862747516071791e-26,   1.118522614320442e-02,  -2.655590604252656e-04,   4.705058051088936e-06,  -7.378156368483699e-08,   1.074807313880818e-09,
  -1.495105710808093e-11,   1.984351341920093e-13,  -2.590038416337748e-15,   3.176983035666258e-17,  -3.793146885276756e-19,   5.345244826170748e-21,  -2.486215599472796e-23,
   7.369006805164157e-25,  -1.863489430518057e-26,   1.118531323827105e-02,  -2.655631544381083e-04,   4.705177298313106e-06,  -7.378432799943051e-08,   1.074862342799016e-09,
  -1.495206260523121e-11,   1.984515803188285e-13,  -2.590290783398974e-15,   3.177427700397567e-17,  -3.793400288616105e-19,   5.346141440161605e-21,  -2.488902247830174e-23,
   7.362294155301164e-25,  -1.863746770654960e-26,   1.118532705912642e-02,  -2.655638041062678e-04,   4.705196221392480e-06,  -7.378476666378460e-08,   1.074871075270277e-09,
  -1.495222216678291e-11,   1.984541901631972e-13,  -2.590330831094093e-15,   3.177498264846191e-17,  -3.793440508605059e-19,   5.346283695415060e-21,  -2.489328593171368e-23,
   7.361229181552235e-25,  -1.863787564758169e-26,   1.003904050763413e-01,  -2.320224090460900e-03,   3.864101325927471e-05,  -5.401660381067089e-07,   6.451945841940931e-09,
  -6.375819700189770e-11,   4.157117291369059e-13,   5.260696454112780e-16,  -9.135963703816881e-17,   1.986482448413003e-18,  -2.193242371885040e-20,   5.907430645725110e-22,
  -3.148571437541836e-25,  -1.248315505059569e-25,   1.003940349563348e-01,  -2.320376222365545e-03,   3.864464575380606e-05,  -5.402258015752208e-07,   6.452527573723018e-09,
  -6.375705324167252e-11,   4.154699968436148e-13,   5.328523280259316e-16,  -9.145228007784089e-17,   1.989492320869234e-18,  -2.193580414181994e-20,   5.898163633971591e-22,
  -3.460114403133998e-25,  -1.250865419164013e-25,   1.004004402140408e-01,  -2.320644675172263e-03,   3.865105561300781e-05,  -5.403312542520508e-07,   6.453553771497165e-09,
  -6.375502416383706e-11,   4.150432586160530e-13,   5.448287105078891e-16,  -9.161576302742107e-17,   1.994799389426933e-18,  -2.194192381831691e-20,   5.881797019910109e-22,
  -4.008158886188445e-25,  -1.255339966788561e-25,   1.004081859930211e-01,  -2.320969314478858e-03,   3.865880693577909e-05,  -5.404587672092818e-07,   6.454794188164858e-09,
  -6.375255199548239e-11,   4.145269049178168e-13,   5.593247095917082e-16,  -9.181347062594900e-17,   2.001210101547760e-18,  -2.194958728145864e-20,   5.861981155794610e-22,
  -4.668002248119666e-25,  -1.260708449818919e-25,   1.004157059564366e-01,  -2.321284493102195e-03,   3.866633225953324e-05,  -5.405825529543632e-07,   6.455997868047102e-09,
  -6.375013258292872e-11,   4.140252844696741e-13,   5.734118566796912e-16,  -9.200542552045153e-17,   2.007426538769522e-18,  -2.195730202299612e-20,   5.842718017638396e-22,
  -5.305578114407658e-25,  -1.265876061443461e-25,   1.004217642960377e-01,  -2.321538414387743e-03,   3.867239490187411e-05,  -5.406822719703044e-07,   6.456967181996613e-09,
  -6.374816957426901e-11,   4.136209324632976e-13,   5.847707922454588e-16,  -9.216007924942104e-17,   2.012429421201359e-18,  -2.196371356952452e-20,   5.827181172606018e-22,
  -5.817062472777176e-25,  -1.270007595349622e-25,   1.004257677126790e-01,  -2.321706209611054e-03,   3.867640115407334e-05,  -5.407481639444275e-07,   6.457607513557036e-09,
  -6.374686561399206e-11,   4.133536199302726e-13,   5.922817193241750e-16,  -9.226228030998473e-17,   2.015732787852876e-18,  -2.196804628214803e-20,   5.816905576668373e-22,
  -6.153996338939287e-25,  -1.272722297280660e-25,   1.004278237124182e-01,  -2.321792383134573e-03,   3.867845860764417e-05,  -5.407820024476335e-07,   6.457936300681619e-09,
  -6.374619385223921e-11,   4.132163038258520e-13,   5.961405302742635e-16,  -9.231476814187841e-17,   2.017428467010882e-18,  -2.197030100560831e-20,   5.811625752015104e-22,
  -6.326704799078271e-25,  -1.274111691587307e-25,   1.004285393305109e-01,  -2.321822377040094e-03,   3.867917473137938e-05,  -5.407937802201296e-07,   6.458050729489878e-09,
  -6.374595970251580e-11,   4.131685035961464e-13,   5.974838779241008e-16,  -9.233303744429849e-17,   2.018018543018458e-18,  -2.197109050202202e-20,   5.809787613308809e-22,
  -6.386766128151655e-25,  -1.274594530034580e-25,   1.004286528896527e-01,  -2.321827136679827e-03,   3.867928837074176e-05,  -5.407956491890681e-07,   6.458068887359350e-09,
  -6.374592253018476e-11,   4.131609180683203e-13,   5.976970607125781e-16,  -9.233593655153522e-17,   2.018112174225877e-18,  -2.197121600818879e-20,   5.809495904786380e-22,
  -6.396294592693268e-25,  -1.274671114118033e-25,   2.773291386145193e-01,  -6.047549806742214e-03,   8.705464385146206e-05,  -8.748251176712456e-07,   3.720591439193776e-09,
   7.342790827905679e-11,  -2.208561026085793e-12,   2.986821403115948e-14,  -1.900114331147951e-16,  -2.704105487840381e-18,   1.259665337111461e-19,  -8.989840794907644e-22,
   1.912270115798923e-23,  -2.165796004831895e-25,   2.773373041369220e-01,  -6.047795606507424e-03,   8.705671911339703e-05,  -8.747557861273548e-07,   3.717479905855623e-09,
   7.348656381750381e-11,  -2.209048746402028e-12,   2.985896505465593e-14,  -1.894764893806590e-16,  -2.708800946166390e-18,   1.260772911427460e-19,  -9.005336309450775e-22,
   1.895888146418086e-23,  -2.159716792514171e-25,   2.773517124859540e-01,  -6.048229308127683e-03,   8.706037952148584e-05,  -8.746334048644172e-07,   3.711989003000051e-09,
   7.359004757494381e-11,  -2.209908192826386e-12,   2.984263216200180e-14,  -1.885321994829236e-16,  -2.717092616592269e-18,   1.262719046806063e-19,  -9.032641173324558e-22,
   1.867021673652073e-23,  -2.148909991808704e-25,   2.773691354819730e-01,  -6.048753717587974e-03,   8.706480329743288e-05,  -8.744853439872584e-07,   3.705348402020632e-09,
   7.371515588343774e-11,  -2.210945493904090e-12,   2.982286019808968e-14,  -1.873897195233017e-16,  -2.727129997633624e-18,   1.265058371712088e-19,  -9.065594729290368e-22,
   1.832183757716544e-23,  -2.135706466170686e-25,   2.773860497038183e-01,  -6.049262776750522e-03,   8.706909527909714e-05,  -8.743415293207748e-07,   3.698900835623577e-09,
   7.383658229230223e-11,  -2.211950444372080e-12,   2.980364280593183e-14,  -1.862799577326614e-16,  -2.736885623378651e-18,   1.267314743551410e-19,  -9.097518274335024e-22,
   1.798434538045028e-23,  -2.122747073228665e-25,   2.773996757807456e-01,  -6.049672847791317e-03,   8.707255102118465e-05,  -8.742256169764855e-07,   3.693706054382375e-09,
   7.393438277711286e-11,  -2.212758554783934e-12,   2.978814495429169e-14,  -1.853854754530604e-16,  -2.744752865632729e-18,   1.269121995702576e-19,  -9.123187032811326e-22,
   1.771297280718549e-23,  -2.112206091768467e-25,   2.774086797474269e-01,  -6.049943805438823e-03,   8.707483362157523e-05,  -8.741489962000125e-07,   3.690273090324959e-09,
   7.399899826215336e-11,  -2.213291822438780e-12,   2.977789613230256e-14,  -1.847941867887129e-16,  -2.749955428242762e-18,   1.270311083263560e-19,  -9.140124660452601e-22,
   1.753390247588602e-23,  -2.105191485429345e-25,   2.774133037453778e-01,  -6.050082952065288e-03,   8.707600557009215e-05,  -8.741096391175171e-07,   3.688509992347255e-09,
   7.403217851802011e-11,  -2.213565459019571e-12,   2.977263036041227e-14,  -1.844904605667954e-16,  -2.752628438254035e-18,   1.270920156597868e-19,  -9.148815548151015e-22,
   1.744201787516060e-23,  -2.101573934864639e-25,   2.774149131750230e-01,  -6.050131382830855e-03,   8.707641343356476e-05,  -8.740959391478763e-07,   3.687896312973864e-09,
   7.404372675014782e-11,  -2.213660665410784e-12,   2.977079716038029e-14,  -1.843847345517559e-16,  -2.753559002025093e-18,   1.271131898701333e-19,  -9.151839311790887e-22,
   1.741004878501974e-23,  -2.100312394292713e-25,   2.774151685695707e-01,  -6.050139068102992e-03,   8.707647815379463e-05,  -8.740937650860201e-07,   3.687798929703247e-09,
   7.404555927371220e-11,  -2.213675771676720e-12,   2.977050623779609e-14,  -1.843679567520235e-16,  -2.753706679085289e-18,   1.271165487321813e-19,  -9.152319085401695e-22,
   1.740497630912741e-23,  -2.100112090406677e-25,   5.378058738630986e-01,  -1.058387455330544e-02,   1.121727044349106e-04,  -2.169963777864680e-07,  -1.627085107163136e-08,
   2.944625324679856e-10,  -1.078350178880028e-12,  -5.806921413062471e-14,   1.234879692613737e-15,  -6.112985481814195e-18,  -2.018669555732434e-19,   8.037652438634637e-21,
  -2.434541945906255e-23,  -1.921846025003050e-24,   5.378163716438332e-01,  -1.058393461465842e-02,   1.121635437752128e-04,  -2.167212838075923e-07,  -1.627232940120049e-08,
   2.943479000582877e-10,  -1.075126327477710e-12,  -5.808878178202015e-14,   1.234023299534697e-15,  -6.072098180436597e-18,  -2.020155811533495e-19,   8.023377314740007e-21,
  -2.430289905850166e-23,  -1.925925947011612e-24,   5.378348944441667e-01,  -1.058404053112780e-02,   1.121473789797247e-04,  -2.162359636128770e-07,  -1.627493425820786e-08,
   2.941455985680497e-10,  -1.069439621420942e-12,  -5.812319743133861e-14,   1.232511672483067e-15,  -6.000011959003547e-18,  -2.022776127203871e-19,   7.998164963548519e-21,
  -2.422726168757247e-23,  -1.933081553682260e-24,   5.378572912204888e-01,  -1.058416849950329e-02,   1.121278311995866e-04,  -2.156492583881171e-07,  -1.627807780795232e-08,
   2.939009210502104e-10,  -1.062566317522649e-12,  -5.816462272216658e-14,   1.230682931261536e-15,  -5.912947012818471e-18,  -2.025940858599746e-19,   7.967637734961052e-21,
  -2.413476475796432e-23,  -1.941660185205338e-24,   5.378790323752261e-01,  -1.058429261700662e-02,   1.121088533641024e-04,  -2.150798513099363e-07,  -1.628112294634196e-08,
   2.936633376402468e-10,  -1.055897103164479e-12,  -5.820463835303966e-14,   1.228906715125791e-15,  -5.828533274597918e-18,  -2.029009137821297e-19,   7.937960573792240e-21,
  -2.404389085617571e-23,  -1.949910844122962e-24,   5.378965458725177e-01,  -1.058439252423197e-02,   1.120935642158208e-04,  -2.146212563020756e-07,  -1.628357136751416e-08,
   2.934719044443430e-10,  -1.050526814479463e-12,  -5.823673171153824e-14,   1.227475169971817e-15,  -5.760607679637352e-18,  -2.031478028238251e-19,   7.914023206880800e-21,
  -2.396991394756982e-23,  -1.956502181208906e-24,   5.379081180416868e-01,  -1.058445850187323e-02,   1.120834610028370e-04,  -2.143182796997452e-07,  -1.628518693855549e-08,
   2.933453897032893e-10,  -1.046979371176786e-12,  -5.825786859601189e-14,   1.226528913090576e-15,  -5.715761389116927e-18,  -2.033108011680762e-19,   7.898191278471136e-21,
  -2.392065563371784e-23,  -1.960830597561825e-24,   5.379140607688518e-01,  -1.058449237240431e-02,   1.120782723909345e-04,  -2.141627036690408e-07,  -1.628601589976765e-08,
   2.932804124342422e-10,  -1.045157944324466e-12,  -5.826870180917527e-14,   1.226042866804761e-15,  -5.692742347389570e-18,  -2.033944646865252e-19,   7.890056341768117e-21,
  -2.389524323612453e-23,  -1.963045099944262e-24,   5.379161291679057e-01,  -1.058450415941949e-02,   1.120764664265783e-04,  -2.141085567056403e-07,  -1.628630431399616e-08,
   2.932577955628943e-10,  -1.044524036553557e-12,  -5.827246897210660e-14,   1.225873678329863e-15,  -5.684732218129340e-18,  -2.034235775323520e-19,   7.887224189908375e-21,
  -2.388637979326663e-23,  -1.963814549909158e-24,   5.379164573933255e-01,  -1.058450602976468e-02,   1.120761798439356e-04,  -2.140999644563967e-07,  -1.628635007598298e-08,
   2.932542065323921e-10,  -1.044423446804177e-12,  -5.827306660587359e-14,   1.225846829707825e-15,  -5.683461209195827e-18,  -2.034281970070605e-19,   7.886774732606168e-21,
  -2.388497241277183e-23,  -1.963936588001611e-24,   8.716491983696908e-01,  -1.440405637942654e-02,   6.770313886313591e-05,   1.593394360534499e-06,  -2.721412680107538e-08,
  -1.732206822475668e-10,   9.349076114311138e-12,  -4.156799727073985e-14,  -2.772733020223283e-15,   4.238359717723698e-17,   6.111032957444977e-19,  -1.806840924842711e-20,
   7.960766194958075e-23,   6.589896364127276e-24,   8.716555149464313e-01,  -1.440360881264092e-02,   6.768790462946637e-05,   1.593231299373468e-06,  -2.720106504547521e-08,
  -1.733002868473690e-10,   9.341851267509986e-12,  -4.142732704829889e-14,  -2.770141460091393e-15,   4.229224713987689e-17,   6.115321743576946e-19,  -1.802155454740116e-20,
   7.822270643307426e-23,   6.565615397746334e-24,   8.716666594932607e-01,  -1.440281911139505e-02,   6.766102953733676e-05,   1.592943515397223e-06,  -2.717802561086038e-08,
  -1.734405264278223e-10,   9.329108450220947e-12,  -4.117936154838346e-14,  -2.765567196090236e-15,   4.213125361506189e-17,   6.122820491829974e-19,  -1.793902203009127e-20,
   7.578606226394984e-23,   6.522846292359816e-24,   8.716801336340734e-01,  -1.440186425997031e-02,   6.762854203629954e-05,   1.592595421762569e-06,  -2.715018012355572e-08,
  -1.736097239805463e-10,   9.313709145104747e-12,  -4.087994376389816e-14,  -2.760033549914401e-15,   4.193691069672007e-17,   6.131770852570980e-19,  -1.783946692964863e-20,
   7.285178380969055e-23,   6.471257300441759e-24,   8.716932120401470e-01,  -1.440093737351547e-02,   6.759701435574502e-05,   1.592257391638406e-06,  -2.712316290684124e-08,
  -1.737735787267073e-10,   9.298769660259754e-12,  -4.058971848775531e-14,  -2.754659092067325e-15,   4.174859328030863e-17,   6.140337282537595e-19,  -1.774307579303921e-20,
   7.001591913661980e-23,   6.421309392402622e-24,   8.717037463607415e-01,  -1.440019073369667e-02,   6.757162367538253e-05,   1.591985002513668e-06,  -2.710140871724240e-08,
  -1.739052921202460e-10,   9.286741696354063e-12,  -4.035623480998339e-14,  -2.750327729100453e-15,   4.159713570743665e-17,   6.147150789014304e-19,  -1.766560694544071e-20,
   6.774045007005280e-23,   6.381167791800428e-24,   8.717107065308938e-01,  -1.439969739083989e-02,   6.755484969079404e-05,   1.591804975241364e-06,  -2.708703908991260e-08,
  -1.739921861187400e-10,   9.278797304640064e-12,  -4.020210853908578e-14,  -2.747464780966953e-15,   4.149717675968271e-17,   6.151610279684414e-19,  -1.761450620554105e-20,
   6.624129184326872e-23,   6.354689804641206e-24,   8.717142806882743e-01,  -1.439944404292540e-02,   6.754623659879372e-05,   1.591712511068479e-06,  -2.707966119218562e-08,
  -1.740367671109869e-10,   9.274718553445021e-12,  -4.012300541196088e-14,  -2.745994255186922e-15,   4.144588060618854e-17,   6.153887238565778e-19,  -1.758829112212840e-20,
   6.547277103211689e-23,   6.341106578817362e-24,   8.717155246709780e-01,  -1.439935586401763e-02,   6.754323891657985e-05,   1.591680326227642e-06,  -2.707709350096939e-08,
  -1.740522770526041e-10,   9.273299077747314e-12,  -4.009548049727657e-14,  -2.745482383155805e-15,   4.142803248525422e-17,   6.154677654700972e-19,  -1.757917111280145e-20,
   6.520549806726171e-23,   6.336381118513682e-24,   8.717157220722153e-01,  -1.439934187129418e-02,   6.754276323440036e-05,   1.591675218849385e-06,  -2.707668605577732e-08,
  -1.740547379401067e-10,   9.273073834622011e-12,  -4.009111303566357e-14,  -2.745401154119265e-15,   4.142520051786854e-17,   6.154802983183656e-19,  -1.757772410131439e-20,
   6.516309586249208e-23,   6.335631362497157e-24,   1.255365258602204e+00,  -1.523128656746015e-02,  -6.150153441017377e-05,   2.444759144451856e-06,   2.126522035607464e-08,
  -7.312932237850557e-10,  -9.020367293623523e-12,   2.605796954493631e-13,   3.956922627878024e-15,  -1.073382631215671e-16,  -1.843257367875981e-18,   5.236468548390069e-20,
   1.120058106418996e-21,  -2.207750471601944e-23,   1.255359516713085e+00,  -1.523060137921825e-02,  -6.148964360168472e-05,   2.444077818734719e-06,   2.125265624359997e-08,
  -7.307858464732694e-10,  -9.010135936961117e-12,   2.602242843682267e-13,   3.949359920913633e-15,  -1.070743747544619e-16,  -1.836577832766417e-18,   5.220691517609288e-20,
   1.114609992750569e-21,  -2.201071750626984e-23,   1.255349385957133e+00,  -1.522939250881914e-02,  -6.146866780011091e-05,   2.442875993757042e-06,   2.123049830558195e-08,
  -7.298911367159313e-10,  -8.992098557874398e-12,   2.595978755101504e-13,   3.936038095716958e-15,  -1.066093972036363e-16,  -1.824818826613434e-18,   5.192892164530228e-20,
   1.105020970754568e-21,  -2.189304801569252e-23,   1.255337137269201e+00,  -1.522793099410037e-02,  -6.144331338118523e-05,   2.441423390263107e-06,   2.120372451824813e-08,
  -7.288102075422657e-10,  -8.970314832996769e-12,   2.588416409485016e-13,   3.919967827693562e-15,  -1.060482615560584e-16,  -1.810645901281501e-18,   5.159344110432033e-20,
   1.093467103118727e-21,  -2.175106324824066e-23,   1.255325248057233e+00,  -1.522651245758948e-02,  -6.141870994985528e-05,   2.440013914633489e-06,   2.117775373684072e-08,
  -7.277618680989173e-10,  -8.949196081328900e-12,   2.581087835209508e-13,   3.904407456998650e-15,  -1.055046923789449e-16,  -1.796935335144431e-18,   5.126846541218547e-20,
   1.082293927646134e-21,  -2.161354313101608e-23,   1.255315671410427e+00,  -1.522536990120933e-02,  -6.139889705030667e-05,   2.438878951148442e-06,   2.115684686767840e-08,
  -7.269180609191082e-10,  -8.932203488357873e-12,   2.575193205463498e-13,   3.891901090924415e-15,  -1.050676385491100e-16,  -1.785924788176083e-18,   5.100717227808243e-20,
   1.073323780879057e-21,  -2.150298496310807e-23,   1.255309343894676e+00,  -1.522461501732235e-02,  -6.138580861453610e-05,   2.438129228164851e-06,   2.114303924967594e-08,
  -7.263608411195358e-10,  -8.920985061478168e-12,   2.571302626698179e-13,   3.883651217759252e-15,  -1.047792512728824e-16,  -1.778666080314222e-18,   5.083476047921559e-20,
   1.067411526152215e-21,  -2.143004073920659e-23,   1.255306094586314e+00,  -1.522422737832471e-02,  -6.137908818192312e-05,   2.437744283946202e-06,   2.113595062411305e-08,
  -7.260747911838432e-10,  -8.915226945077623e-12,   2.569306015214576e-13,   3.879418872145993e-15,  -1.046312773504837e-16,  -1.774943595909332e-18,   5.074629480838538e-20,
   1.064379950851196e-21,  -2.139261457907410e-23,   1.255304963662440e+00,  -1.522409246179704e-02,  -6.137674924976682e-05,   2.437610312429266e-06,   2.113348372070254e-08,
  -7.259752462465827e-10,  -8.913223270459060e-12,   2.568611297010298e-13,   3.877946459021247e-15,  -1.045797938415571e-16,  -1.773648779897647e-18,   5.071551562183797e-20,
   1.063325523069401e-21,  -2.137959350171100e-23,   1.255304784201709e+00,  -1.522407105262889e-02,  -6.137637810179875e-05,   2.437589053556827e-06,   2.113309227408231e-08,
  -7.259594506601376e-10,  -8.912905338174474e-12,   2.568501065275075e-13,   3.877712840251880e-15,  -1.045716250751063e-16,  -1.773443349762273e-18,   5.071063196317337e-20,
   1.063158235009462e-21,  -2.137752749428549e-23,   1.637683211514697e+00,  -1.088595966405224e-02,  -1.719762093233055e-04,  -6.344702238641124e-07,   4.042547302839857e-08,
   9.305893068399336e-10,  -1.006866243597544e-13,  -4.242864590489323e-13,  -8.087067515890585e-15,   5.421063983824402e-17,   5.275396547470715e-18,   8.013903053929788e-20,
  -1.078011969780846e-21,  -6.270078312853348e-23,   1.637667134419721e+00,  -1.088613506165520e-02,  -1.719534723540292e-04,  -6.336047920616194e-07,   4.042508647096584e-08,
   9.297570905814887e-10,  -1.214608025267813e-13,  -4.240932489462920e-13,  -8.065035770777457e-15,   5.460646364834426e-17,   5.268475032358603e-18,   7.969047875922443e-20,
  -1.083512036609974e-21,  -6.252105130198127e-23,   1.637638767864941e+00,  -1.088644435681770e-02,  -1.719133528476861e-04,  -6.320783573529632e-07,   4.042438081194993e-08,
   9.282889461498093e-10,  -1.580702849688755e-13,  -4.237512533332074e-13,  -8.026184367789993e-15,   5.530303086518125e-17,   5.256234818001811e-18,   7.890007550173270e-20,
  -1.093164803773564e-21,  -6.220354401244531e-23,   1.637604469677377e+00,  -1.088681802459778e-02,  -1.718648403176313e-04,  -6.302336558931029e-07,   4.042348736533151e-08,
   9.265141872021792e-10,  -2.022589602515960e-13,  -4.233358819387501e-13,  -7.979245749147102e-15,   5.614214176005211e-17,   5.241387804604933e-18,   7.794614314886936e-20,
  -1.104748217223732e-21,  -6.181899032162287e-23,   1.637571176683499e+00,  -1.088718042388178e-02,  -1.718177456273421e-04,  -6.284439820848324e-07,   4.042257801835120e-08,
   9.247918457486160e-10,  -2.450729336902175e-13,  -4.229307381997906e-13,  -7.933721474254208e-15,   5.695340407980773e-17,   5.226926621954793e-18,   7.702200211850362e-20,
  -1.115900401813157e-21,  -6.144503063401902e-23,   1.637544358496619e+00,  -1.088747211668195e-02,  -1.717798070749008e-04,  -6.270030539422227e-07,   4.042181539710714e-08,
   9.234047548863569e-10,  -2.795034267979367e-13,  -4.226029954706406e-13,  -7.897078521173972e-15,   5.760456186220749e-17,   5.215242679151444e-18,   7.627890306752970e-20,
  -1.124818122126487e-21,  -6.114331957866880e-23,   1.637526638601492e+00,  -1.088766473905618e-02,  -1.717547381134541e-04,  -6.260513107351219e-07,   4.042129676414315e-08,
   9.224883886819487e-10,  -3.022251738046273e-13,  -4.223857622330924e-13,  -7.872880618914094e-15,   5.803366888904447e-17,   5.207505456264701e-18,   7.578855115484787e-20,
  -1.130678374662755e-21,  -6.094373430576108e-23,   1.637517538923027e+00,  -1.088776362182091e-02,  -1.717418640517204e-04,  -6.255626676488824e-07,   4.042102587603082e-08,
   9.220178523374423e-10,  -3.138848165994268e-13,  -4.222739966645089e-13,  -7.860458515484810e-15,   5.825367538794564e-17,   5.203526876916190e-18,   7.553694075191319e-20,
  -1.133677882117430e-21,  -6.084117017714905e-23,   1.637514371750025e+00,  -1.088779803281721e-02,  -1.717373831245637e-04,  -6.253926104631730e-07,   4.042093086758139e-08,
   9.218540876601980e-10,  -3.179416196925667e-13,  -4.222350628782400e-13,  -7.856135633673182e-15,   5.833019329526497e-17,   5.202141278043102e-18,   7.544939869257674e-20,
  -1.134720295288973e-21,  -6.080546108387919e-23,   1.637513869165824e+00,  -1.088780349308095e-02,  -1.717366720635136e-04,  -6.253656256563005e-07,   4.042091575671371e-08,
   9.218281009270327e-10,  -3.185853100037181e-13,  -4.222288830679871e-13,  -7.855449687243770e-15,   5.834233291025315e-17,   5.201921363781263e-18,   7.543550855188081e-20,
  -1.134885636307728e-21,  -6.079979403505809e-23,   1.922180730254326e+00,  -3.026911749849130e-03,  -8.318082973594881e-05,  -1.861861059435040e-06,  -3.407172508550388e-08,
  -4.595043636384530e-10,  -2.092188975700184e-12,   1.227169615592445e-13,   5.231510232438936e-15,   1.281057394941375e-16,   2.073880852139522e-18,   1.269398995995585e-20,
  -5.205351898593432e-22,  -2.350754571430476e-23,   1.922172893561948e+00,  -3.027436906758759e-03,  -8.320001063068918e-05,  -1.862289747722194e-06,  -3.407450243652294e-08,
  -4.592558607760501e-10,  -2.078278247774727e-12,   1.231508166964095e-13,   5.240147532690355e-15,   1.281643000707399e-16,   2.070436458427535e-18,   1.251754897769493e-20,
  -5.253566358992238e-22,  -2.359024614710906e-23,   1.922159064130985e+00,  -3.028363652056839e-03,  -8.323385685290548e-05,  -1.863045983424578e-06,  -3.407938714229837e-08,
  -4.588166784045421e-10,  -2.053714184429762e-12,   1.239165165212109e-13,   5.255376174573385e-15,   1.282668868449927e-16,   2.064334488634505e-18,   1.220572796009531e-20,
  -5.338667918500865e-22,  -2.373591152999268e-23,   1.922142338939041e+00,  -3.029484448877150e-03,  -8.327478616156326e-05,  -1.863960104787914e-06,  -3.408526652973821e-08,
  -4.582844289139709e-10,  -2.023979760335376e-12,   1.248426728543670e-13,   5.273770275427487e-15,   1.283896654058731e-16,   2.056914508492442e-18,   1.182783943264491e-20,
  -5.441617966439946e-22,  -2.391160466349180e-23,   1.922126099798076e+00,  -3.030572673351751e-03,  -8.331452181349482e-05,  -1.864847175164600e-06,  -3.409094558205218e-08,
  -4.577664886929367e-10,  -1.995081345708264e-12,   1.257420439758020e-13,   5.291605372574495e-15,   1.285075245118102e-16,   2.049667941867289e-18,   1.146012272654721e-20,
  -5.541605676365651e-22,  -2.408169352821082e-23,   1.922113015884221e+00,  -3.031449457710811e-03,  -8.334653390081704e-05,  -1.865561541568529e-06,  -3.409550008012645e-08,
  -4.573483530150671e-10,  -1.971777709165059e-12,   1.264667611291599e-13,   5.305957583281994e-15,   1.286015145080027e-16,   2.043799113955935e-18,   1.116327322629575e-20,
  -5.622186544156269e-22,  -2.421837540650570e-23,   1.922104369349897e+00,  -3.032028882326621e-03,  -8.336768768124202e-05,  -1.866033461603970e-06,  -3.409849958218185e-08,
  -4.570716206924948e-10,  -1.956367606249051e-12,   1.269457365116835e-13,   5.315433652801875e-15,   1.286631529488560e-16,   2.039905872424435e-18,   1.096681635838040e-20,
  -5.675448408222381e-22,  -2.430852530610850e-23,   1.922099928657164e+00,  -3.032326463494154e-03,  -8.337855139535941e-05,  -1.866275777810819e-06,  -3.410003686729712e-08,
  -4.569293706419837e-10,  -1.948450233681997e-12,   1.271917426205416e-13,   5.320297708285163e-15,   1.286946622498922e-16,   2.037901797622360e-18,   1.086583242455868e-20,
  -5.702805654561620e-22,  -2.435476975569009e-23,   1.922098382988236e+00,  -3.032430042353830e-03,  -8.338233264803356e-05,  -1.866360112243069e-06,  -3.410057143940513e-08,
  -4.568798377538432e-10,  -1.945693955031718e-12,   1.272773719595373e-13,   5.321990311290177e-15,   1.287056062588681e-16,   2.037203511300093e-18,   1.083066909505943e-20,
  -5.712328343250288e-22,  -2.437085729166501e-23,   1.922098137709721e+00,  -3.032446479035199e-03,  -8.338293268253566e-05,  -1.866373494673828e-06,  -3.410065624518004e-08,
  -4.568719765480942e-10,  -1.945256544768014e-12,   1.272909603773555e-13,   5.322258886215886e-15,   1.287073418259320e-16,   2.037092667284206e-18,   1.082508844953672e-20,
  -5.713839498241423e-22,  -2.437340976922892e-23,   1.018926074975737e-02,  -2.310185302318944e-04,   3.909024144093648e-06,  -5.863492952893086e-08,   8.160764048831877e-10,
  -1.091962392467885e-11,   1.377898899283427e-13,  -1.746005799511651e-15,   2.156394778806461e-17,  -1.801262148734245e-19,   4.634822839100218e-21,  -1.888214755885476e-23,
  -7.432162136587882e-25,  -3.632486476074919e-26,   1.018962814378375e-02,  -2.310350574405177e-04,   3.909484284094982e-06,  -5.864519564886592e-08,   8.162708463023900e-10,
  -1.092307108830013e-11,   1.378468954928334e-13,  -1.746616562447636e-15,   2.158335260328591e-17,  -1.802335751971237e-19,   4.630212111129617e-21,  -1.914030288497122e-23,
  -7.434987413947980e-25,  -3.618893823940020e-26,   1.019027645153549e-02,  -2.310642223130457e-04,   3.910296297458540e-06,  -5.866331300966429e-08,   8.166140065816855e-10,
  -1.092915464183656e-11,   1.379475240321896e-13,  -1.747694565183810e-15,   2.161757688143463e-17,  -1.804240887522566e-19,   4.622075151740761e-21,  -1.959501910619898e-23,
  -7.439823985538966e-25,  -3.594947803898921e-26,   1.019106045224068e-02,  -2.310994928008460e-04,   3.911278344624377e-06,  -5.868522520194207e-08,   8.170290710939551e-10,
  -1.093651260955248e-11,   1.380692755749178e-13,  -1.748998614431717e-15,   2.165893426100609e-17,  -1.806562897216335e-19,   4.612233760492024e-21,  -2.014349934349879e-23,
  -7.445419504764405e-25,  -3.566057448838956e-26,   1.019182160943875e-02,  -2.311337369820699e-04,   3.912231858140332e-06,  -5.870650187728269e-08,   8.174321252736886e-10,
  -1.094365734625408e-11,   1.381875435973132e-13,  -1.750265106641788e-15,   2.169905502921478e-17,  -1.808836197730187e-19,   4.602677781244307e-21,  -2.067452444176128e-23,
  -7.450587436639101e-25,  -3.538079585906617e-26,   1.019243483284000e-02,  -2.311613266603778e-04,   3.913000110261215e-06,  -5.872364545708241e-08,   8.177569041494547e-10,
  -1.094941430669354e-11,   1.382828715862486e-13,  -1.751285767713066e-15,   2.173135554781325e-17,  -1.810681227662960e-19,   4.594978130259344e-21,  -2.110128814745200e-23,
  -7.454561953986237e-25,  -3.515589900934482e-26,   1.019284006200420e-02,  -2.311795589028498e-04,   3.913507813417651e-06,  -5.873497527789429e-08,   8.179715532237090e-10,
  -1.095321901745032e-11,   1.383458884709976e-13,  -1.751960394742749e-15,   2.175268923897261e-17,  -1.811907084559020e-19,   4.589889632576101e-21,  -2.138278557564637e-23,
  -7.457096062985456e-25,  -3.500753034207906e-26,   1.019304817339365e-02,  -2.311889224877869e-04,   3.913768560552092e-06,  -5.874079419290325e-08,   8.180817984695177e-10,
  -1.095517310833943e-11,   1.383782586484656e-13,  -1.752306907651370e-15,   2.176364204331701e-17,  -1.812538689134884e-19,   4.587276231275993e-21,  -2.152719333284983e-23,
  -7.458368986390262e-25,  -3.493140982170440e-26,   1.019312060955501e-02,  -2.311921816418795e-04,   3.913859318729777e-06,  -5.874281960074204e-08,   8.181201723551116e-10,
  -1.095585327779781e-11,   1.383895266573327e-13,  -1.752427524152505e-15,   2.176745377890869e-17,  -1.812758854026746e-19,   4.586366579257364e-21,  -2.157743116675866e-23,
  -7.458807511727171e-25,  -3.490492713416748e-26,   1.019313210422779e-02,  -2.311926988281951e-04,   3.913873720933173e-06,  -5.874314100892571e-08,   8.181262618580761e-10,
  -1.095596121275854e-11,   1.383913147955447e-13,  -1.752446664781827e-15,   2.176805862567119e-17,  -1.812793806784861e-19,   4.586222228414120e-21,  -2.158540205108581e-23,
  -7.458876884813353e-25,  -3.490072525437463e-26,   9.168906652485247e-02,  -2.035362411985583e-03,   3.273808428117439e-05,  -4.465942667117154e-07,   5.276300868721878e-09,
  -5.387345042821505e-11,   3.993443845902418e-13,  -1.373162336368672e-15,  -2.963525771095266e-17,   1.593251528905446e-18,   4.380147596648675e-22,   3.315480773422195e-22,
  -1.205041159706176e-23,  -2.973394579650492e-25,   9.169214167858047e-02,  -2.035488194358387e-03,   3.274105535880597e-05,  -4.466447948907315e-07,   5.276861525427350e-09,
  -5.387606754115200e-11,   3.992665733617588e-13,  -1.367743004957912e-15,  -2.963581462534333e-17,   1.594879572535384e-18,   3.632528362219161e-22,   3.294427899791459e-22,
  -1.205494557202518e-23,  -2.960834669333816e-25,   9.169756806262325e-02,  -2.035710150894742e-03,   3.274629812828589e-05,  -4.467339546269566e-07,   5.277850724048176e-09,
  -5.388067678337984e-11,   3.991292715751337e-13,  -1.358176101797379e-15,  -2.963705390172347e-17,   1.597743526153901e-18,   2.313130592418184e-22,   3.257353932524593e-22,
  -1.206279874043699e-23,  -2.938710357567311e-25,   9.170413009110458e-02,  -2.035978562822415e-03,   3.275263817807319e-05,  -4.468417708861810e-07,   5.279046721909178e-09,
  -5.388623549832479e-11,   3.989632398942906e-13,  -1.346600201265066e-15,  -2.963899000644627e-17,   1.601191742712750e-18,   7.173444922077226e-23,   3.212649989784762e-22,
  -1.207204460515005e-23,  -2.912021848378761e-25,   9.171050079996046e-02,  -2.036239153118648e-03,   3.275879344615932e-05,  -4.469464405503460e-07,   5.280207617087677e-09,
  -5.389161626664279e-11,   3.988020536092755e-13,  -1.335354685377142e-15,  -2.964132781029886e-17,   1.604523628492455e-18,  -8.321836455678917e-23,   3.169384234856785e-22,
  -1.208075895033298e-23,  -2.886180478947565e-25,   9.171563325050130e-02,  -2.036449096063464e-03,   3.276375237785626e-05,  -4.470307635785960e-07,   5.281142705333969e-09,
  -5.389593980789838e-11,   3.986721996818283e-13,  -1.326289847085875e-15,  -2.964353950308808e-17,   1.607196606107296e-18,  -2.080721526687834e-22,   3.134624387307066e-22,
  -1.208759232796536e-23,  -2.865411200826416e-25,   9.171902482454847e-02,  -2.036587829863617e-03,   3.276702931205838e-05,  -4.470864839598335e-07,   5.281760539262297e-09,
  -5.389879127286305e-11,   3.985863922524691e-13,  -1.320297228942096e-15,  -2.964516175464382e-17,   1.608957412283633e-18,  -2.905857701533674e-22,   3.111701904609026e-22,
  -1.209201644533956e-23,  -2.851710796198809e-25,   9.172076660406826e-02,  -2.036659078547912e-03,   3.276871222419361e-05,  -4.471150994206238e-07,   5.282077809312455e-09,
  -5.390025394946872e-11,   3.985423253014996e-13,  -1.317218888385677e-15,  -2.964604459219504e-17,   1.609859986737190e-18,  -3.329642750410692e-22,   3.099944390542382e-22,
  -1.209426026146773e-23,  -2.844682263501709e-25,   9.172137285338036e-02,  -2.036683877661529e-03,   3.276929798507439e-05,  -4.471250593540946e-07,   5.282188235315134e-09,
  -5.390076277883617e-11,   3.985269872768175e-13,  -1.316147309446498e-15,  -2.964635978988229e-17,   1.610173868128433e-18,  -3.477151055360627e-22,   3.095854352060353e-22,
  -1.209503675970274e-23,  -2.842237076802954e-25,   9.172146905712908e-02,  -2.036687812956249e-03,   3.276939093763399e-05,  -4.471266398612275e-07,   5.282205758270691e-09,
  -5.390084351029614e-11,   3.985245533378451e-13,  -1.315977258252641e-15,  -2.964641018331360e-17,   1.610223664066618e-18,  -3.500558877774861e-22,   3.095205427118374e-22,
  -1.209515976655454e-23,  -2.841849114333601e-25,   2.544668809251084e-01,  -5.391998002723695e-03,   7.695379799927515e-05,  -8.061559928959519e-07,   4.723024653389948e-09,
   2.971424534446238e-11,  -1.465457897141792e-12,   2.313870854938068e-14,  -2.042764028426519e-16,   1.734465811148813e-18,   9.792348852788575e-20,  -6.629330466015278e-22,
  -1.624959112325233e-23,  -1.000553957802380e-24,   2.544741006389785e-01,  -5.392224634093879e-03,   7.695644302441456e-05,  -8.061277519782340e-07,   4.720957629045230e-09,
   2.975989093091230e-11,  -1.465985667586296e-12,   2.314446504001465e-14,  -2.038665755561893e-16,   1.730773912480466e-18,   9.782149307760320e-20,  -6.700043997435156e-22,
  -1.628146185661461e-23,  -9.960950018292180e-25,   2.544868401380805e-01,  -5.392624522193615e-03,   7.696110926621122e-05,  -8.060778856151716e-07,   4.717309731945862e-09,
   2.984044245288332e-11,  -1.466916054223281e-12,   2.315461212794350e-14,  -2.031437799400549e-16,   1.724230106137074e-18,   9.764136433665995e-20,  -6.824555502575246e-22,
  -1.633732076699426e-23,  -9.882378955216227e-25,   2.545022452181607e-01,  -5.393108060036869e-03,   7.696675012130681e-05,  -8.060175273012931e-07,   4.712897633214970e-09,
   2.993786183223817e-11,  -1.468039600318618e-12,   2.316686442604093e-14,  -2.022703667364920e-16,   1.716267223425443e-18,   9.742328575546391e-20,  -6.974667065388449e-22,
  -1.640422403171196e-23,  -9.787553739655522e-25,   2.545172005609518e-01,  -5.393577458553839e-03,   7.697222447503008e-05,  -8.059588703121222e-07,   4.708613374171754e-09,
   3.003245122006269e-11,  -1.469128762520080e-12,   2.317874017207377e-14,  -2.014231000202080e-16,   1.708484687286149e-18,   9.721130299926163e-20,  -7.119923058145113e-22,
  -1.646850256198247e-23,  -9.695691162827754e-25,   2.545292486468755e-01,  -5.393955591541962e-03,   7.697663333160786e-05,  -8.059115724463478e-07,   4.705161264784262e-09,
   3.010866289848101e-11,  -1.470005062375934e-12,   2.318829376193819e-14,  -2.007410030408670e-16,   1.702177767058325e-18,   9.704033596167881e-20,  -7.236603241214491e-22,
  -1.651980601616853e-23,  -9.621825276612056e-25,   2.545372099328795e-01,  -5.394205450992609e-03,   7.697954603219951e-05,  -8.058802970406580e-07,   4.702879797582758e-09,
   3.015902794121855e-11,  -1.470583559939159e-12,   2.319460004425433e-14,  -2.002905060032857e-16,   1.697991976777317e-18,   9.692726824975539e-20,  -7.313538995202204e-22,
  -1.655347276940934e-23,  -9.573083202519729e-25,   2.545412984729703e-01,  -5.394333764510035e-03,   7.698104165982488e-05,  -8.058642288754007e-07,   4.701708039148160e-09,
   3.018489456963014e-11,  -1.470880477373184e-12,   2.319783658909457e-14,  -2.000592224367233e-16,   1.695836722735668e-18,   9.686917306044869e-20,  -7.352998367600487e-22,
  -1.657069013160668e-23,  -9.548072573921632e-25,   2.545427215329664e-01,  -5.394378425003277e-03,   7.698156219750234e-05,  -8.058586351290177e-07,   4.701300179453595e-09,
   3.019389796808929e-11,  -1.470983795344335e-12,   2.319896277415276e-14,  -1.999787329361517e-16,   1.695085667788206e-18,   9.684894780870477e-20,  -7.366724476145292e-22,
  -1.657667132143217e-23,  -9.539370698648769e-25,   2.545429473532823e-01,  -5.394385511998909e-03,   7.698164479827586e-05,  -8.058577474275031e-07,   4.701235456861857e-09,
   3.019532669679286e-11,  -1.471000189208337e-12,   2.319914146882185e-14,  -1.999659608766732e-16,   1.694966443041798e-18,   9.684573811737160e-20,  -7.368902236658586e-22,
  -1.657761990956855e-23,  -9.537989987658321e-25,   4.972429748137900e-01,  -9.700898396845948e-03,   1.081952128776791e-04,  -4.320976600999888e-07,  -1.075004029957894e-08,
   2.532936761653039e-10,  -2.191413145477760e-12,  -2.297587360588028e-14,   9.489612589831643e-16,  -7.812967279446131e-18,   9.090988461085302e-20,   4.469608617187078e-21,
  -1.249437413925696e-22,  -1.931459870871404e-24,   4.972531059213746e-01,  -9.701019089092445e-03,   1.081891487798833e-04,  -4.318605818986202e-07,  -1.075309241166950e-08,
   2.532480336811878e-10,  -2.188914792350428e-12,  -2.300165760512759e-14,   9.493200474995709e-16,  -7.790455795384627e-18,   9.014002613005252e-20,   4.455810875821352e-21,
  -1.248758678844261e-22,  -1.925518779347200e-24,   4.972709819561110e-01,  -9.701231998320629e-03,   1.081784471949563e-04,  -4.314422885901085e-07,  -1.075847505236190e-08,
   2.531674558159600e-10,  -2.184505658180894e-12,  -2.304709250130539e-14,   9.499504978812514e-16,  -7.750791435296324e-18,   8.878195390762490e-20,   4.431499561038244e-21,
  -1.247548560387961e-22,  -1.915058148929541e-24,   4.972925970571246e-01,  -9.701489358127429e-03,   1.081655043567106e-04,  -4.309365433934725e-07,  -1.076497892340683e-08,
   2.530699503862445e-10,  -2.179172809754439e-12,  -2.310192831948638e-14,   9.507083487453932e-16,  -7.702926822610272e-18,   8.714036834089946e-20,   4.402161675156311e-21,
  -1.246064048094582e-22,  -1.902447354159066e-24,   4.973135797944194e-01,  -9.701739101917285e-03,   1.081529371953959e-04,  -4.304456370891229e-07,  -1.077128766242826e-08,
   2.529752207795649e-10,  -2.173994441221299e-12,  -2.315505264268809e-14,   9.514393496779119e-16,  -7.656563135475002e-18,   8.554738957844314e-20,   4.373743276369675e-21,
  -1.244600753424742e-22,  -1.890245022876920e-24,   4.973304826209578e-01,  -9.701940223018136e-03,   1.081428114790052e-04,  -4.300502140669830e-07,  -1.077636624130278e-08,
   2.528988555794762e-10,  -2.169821864255002e-12,  -2.319777066166780e-14,   9.520248623429663e-16,  -7.619286467556037e-18,   8.426457191435840e-20,   4.350894349288774e-21,
  -1.243406116842555e-22,  -1.880443573447068e-24,   4.973416514168791e-01,  -9.702073086354873e-03,   1.081361197173981e-04,  -4.297889474783050e-07,  -1.077972028388288e-08,
   2.528483692515912e-10,  -2.167064235677287e-12,  -2.322595969582457e-14,   9.524101078875843e-16,  -7.594690570463636e-18,   8.341713822330843e-20,   4.335817972829996e-21,
  -1.242608993525652e-22,  -1.873980917555958e-24,   4.973473870380719e-01,  -9.702141307550908e-03,   1.081326829090708e-04,  -4.296547813583300e-07,  -1.078144219103657e-08,
   2.528224342057827e-10,  -2.165647918241111e-12,  -2.324042428606342e-14,   9.526074394521840e-16,  -7.582070483074595e-18,   8.298201173695442e-20,   4.328082263130139e-21,
  -1.242197246590508e-22,  -1.870666347405401e-24,   4.973493833592373e-01,  -9.702165050893805e-03,   1.081314866537113e-04,  -4.296080846902655e-07,  -1.078204142835743e-08,
   2.528134060182315e-10,  -2.165154933213894e-12,  -2.324545693692859e-14,   9.526760412510960e-16,  -7.577679709772819e-18,   8.283057335279969e-20,   4.325390849487729e-21,
  -1.242053554824053e-22,  -1.869513366935532e-24,   4.973497001472329e-01,  -9.702168818556086e-03,   1.081312968224316e-04,  -4.296006746233710e-07,  -1.078213651487864e-08,
   2.528119733095241e-10,  -2.165076702198992e-12,  -2.324625545996937e-14,   9.526869235542622e-16,  -7.576983038234630e-18,   8.280654270743789e-20,   4.324963810038855e-21,
  -1.242030734912325e-22,  -1.869330437369984e-24,   8.152266202706238e-01,  -1.379353730204327e-02,   8.413500655410792e-05,   1.141887525524157e-06,  -2.857437708043049e-08,
   2.870593824804443e-11,   7.197497107339230e-12,  -1.026142430205337e-13,  -9.817259971628150e-16,   5.288013938578678e-17,  -2.749210550296230e-20,  -1.043198884604852e-20,
   1.476882752996716e-22,  -3.616304518883358e-24,   8.152344757619724e-01,  -1.379321605826960e-02,   8.411899044186581e-05,   1.141912765177102e-06,  -2.856428611884623e-08,
   2.850672967446678e-11,   7.194918337200406e-12,  -1.024372036128546e-13,  -9.818144799047770e-16,   5.282539856097057e-17,  -2.662899342083409e-20,  -1.045669902246465e-20,
   1.465872103380780e-22,  -3.584665716740119e-24,   8.152483356863007e-01,  -1.379264921308721e-02,   8.409073436698195e-05,   1.141957149973111e-06,  -2.854648340703778e-08,
   2.815550566984952e-11,   7.190367884366701e-12,  -1.021249656838823e-13,  -9.819676931232515e-16,   5.272870569331856e-17,  -2.511150632081978e-20,  -1.050011441550250e-20,
   1.446489905037198e-22,  -3.528986573637511e-24,   8.152650931856048e-01,  -1.379196376849855e-02,   8.405657467393874e-05,   1.142010563275682e-06,  -2.852496120552897e-08,
   2.773128363909749e-11,   7.184865138516799e-12,  -1.017476617149440e-13,  -9.821480010267748e-16,   5.261161056231762e-17,  -2.328588589652686e-20,  -1.055229605261858e-20,
   1.423131523028740e-22,  -3.461910700979731e-24,   8.152813589092333e-01,  -1.379129834100840e-02,   8.402342125932529e-05,   1.142062146765496e-06,  -2.850407309009585e-08,
   2.731996054698730e-11,   7.179522870135527e-12,  -1.013816514149175e-13,  -9.823178639735158e-16,   5.249775606280550e-17,  -2.152336695557285e-20,  -1.060262218040878e-20,
   1.400537969030325e-22,  -3.397057867145513e-24,   8.152944608125013e-01,  -1.379076227431197e-02,   8.399671919134877e-05,   1.142103508991376e-06,  -2.848724966857430e-08,
   2.698896520132888e-11,   7.175218998488802e-12,  -1.010869918014361e-13,  -9.824510056632078e-16,   5.240590745490186e-17,  -2.011048463746467e-20,  -1.064292770186706e-20,
   1.382395808454980e-22,  -3.345001493093179e-24,   8.153031175568892e-01,  -1.379040804758734e-02,   8.397907782490025e-05,   1.142130746085054e-06,  -2.847613489855325e-08,
   2.677042616036747e-11,   7.172374975616196e-12,  -1.008923808009173e-13,  -9.825371774683475e-16,   5.234515260836549e-17,  -1.918028902777338e-20,  -1.066944526673986e-20,
   1.370436597982918e-22,  -3.310695566872447e-24,   8.153075629743580e-01,  -1.379022613416503e-02,   8.397001903107318e-05,   1.142144704475372e-06,  -2.847042750360472e-08,
   2.665825056625783e-11,   7.170914402829108e-12,  -1.007924680797274e-13,  -9.825808733243598e-16,   5.231393266912822e-17,  -1.870364299827614e-20,  -1.068302759914428e-20,
   1.364303871370385e-22,  -3.293106249159429e-24,   8.153091102052098e-01,  -1.379016281736546e-02,   8.396686617691745e-05,   1.142149558179565e-06,  -2.846844108347542e-08,
   2.661921552427631e-11,   7.170406032194891e-12,  -1.007576972143023e-13,  -9.825959934019892e-16,   5.230306319555365e-17,  -1.853790966002169e-20,  -1.068774937398595e-20,
   1.362170735891525e-22,  -3.286988646989053e-24,   8.153093557276613e-01,  -1.379015276985346e-02,   8.396636586912555e-05,   1.142150328175253e-06,  -2.846812587027602e-08,
   2.661302161374683e-11,   7.170325360544595e-12,  -1.007521797786605e-13,  -9.825983885426185e-16,   5.230133821327886e-17,  -1.851161801974909e-20,  -1.068849838504280e-20,
   1.361832303884791e-22,  -3.286018082339355e-24,   1.193648509604972e+00,  -1.560134106011603e-02,  -3.063642921476930e-05,   2.658921598899134e-06,   5.122807973531478e-09,
  -8.498720876143957e-10,  -6.039096918141878e-13,   3.163934893509373e-13,  -5.727311431481069e-16,  -1.244437762520727e-16,   1.098448026305584e-18,   6.684307840436933e-20,
  -6.604524423952505e-22,  -3.811734166065458e-23,   1.193645643220006e+00,  -1.560059602694449e-02,  -3.063355253683964e-05,   2.658130021270583e-06,   5.121942187334598e-09,
  -8.492557124706304e-10,  -6.053204451114239e-13,   3.159821638922328e-13,  -5.682255568180685e-16,  -1.241095484110151e-16,   1.094439909448475e-18,   6.657356031699024e-20,
  -6.587536832843647e-22,  -3.794931919331397e-23,   1.193640585657235e+00,  -1.559928158427497e-02,  -3.062847699308162e-05,   2.656733737863695e-06,   5.120412917352011e-09,
  -8.481687629305386e-10,  -6.078002037383077e-13,   3.152572830845519e-13,  -5.602890572472871e-16,  -1.235209185588922e-16,   1.087376022077759e-18,   6.609898070068221e-20,
  -6.557605051862608e-22,  -3.765355511587807e-23,   1.193634470370991e+00,  -1.559769245313721e-02,  -3.062234027334653e-05,   2.655046134299549e-06,   5.118561026899694e-09,
  -8.468555262335253e-10,  -6.107825116127617e-13,   3.143822980352154e-13,  -5.507154600669911e-16,  -1.228110486561850e-16,   1.078848768825190e-18,   6.552679788865358e-20,
  -6.521484549588788e-22,  -3.729712929327110e-23,   1.193628534147217e+00,  -1.559615007351270e-02,  -3.061638356685495e-05,   2.653408672411764e-06,   5.116760445799262e-09,
  -8.455818244018691e-10,  -6.136607006291806e-13,   3.135344966714873e-13,  -5.414459548439864e-16,  -1.221239132658816e-16,   1.070585798069232e-18,   6.497309243371076e-20,
  -6.486495992466053e-22,  -3.695238666378877e-23,   1.193623752282139e+00,  -1.559490778274427e-02,  -3.061158543414925e-05,   2.652090151977578e-06,   5.115307923048566e-09,
  -8.445565810445915e-10,  -6.159671813043050e-13,   3.128526770292556e-13,  -5.339960102928442e-16,  -1.215717921074141e-16,   1.063940090156297e-18,   6.452829275846273e-20,
  -6.458364419489558e-22,  -3.667557373273313e-23,   1.193620592647771e+00,  -1.559408701182021e-02,  -3.060841516467793e-05,   2.651219189625478e-06,   5.114347146286207e-09,
  -8.438795266224022e-10,  -6.174853204300465e-13,   3.124027090399187e-13,  -5.290817555987135e-16,  -1.212076575534238e-16,   1.059554023972871e-18,   6.423499207976574e-20,
  -6.439802333343895e-22,  -3.649310397912254e-23,   1.193618970066672e+00,  -1.559366554152155e-02,  -3.060678715731823e-05,   2.650771999204106e-06,   5.113853440304465e-09,
  -8.435319529205684e-10,  -6.182631213643895e-13,   3.121718039144080e-13,  -5.265606889608570e-16,  -1.210208724569382e-16,   1.057303206818059e-18,   6.408455812657170e-20,
  -6.430278077315453e-22,  -3.639953393012043e-23,   1.193618405319201e+00,  -1.559351885047099e-02,  -3.060622052682197e-05,   2.650616364875432e-06,   5.113681553524838e-09,
  -8.434109967854996e-10,  -6.185335499222418e-13,   3.120914631115667e-13,  -5.256836285124509e-16,  -1.209558944694135e-16,   1.056520049917375e-18,   6.403222843671477e-20,
  -6.426964387327563e-22,  -3.636698779511803e-23,   1.193618315701875e+00,  -1.559349557288483e-02,  -3.060613061095348e-05,   2.650591668534126e-06,   5.113654275187640e-09,
  -8.433918036655813e-10,  -6.185764493419820e-13,   3.120787154540251e-13,  -5.255444710287884e-16,  -1.209455849844803e-16,   1.056395786073614e-18,   6.402392587012017e-20,
  -6.426438612748937e-22,  -3.636182420522343e-23,   1.591356894135246e+00,  -1.227983660075918e-02,  -1.751074644556250e-04,   1.565736079297123e-07,   5.791311822517874e-08,
   7.597756982464276e-10,  -1.498667346167687e-11,  -6.056435938530594e-13,  -1.717940364872739e-15,   3.079581035397877e-16,   6.412207138068923e-18,  -5.660952643875423e-20,
  -4.502089791491343e-21,  -4.699756688326959e-23,   1.591340542994936e+00,  -1.227979009253301e-02,  -1.750750076359398e-04,   1.572760252034241e-07,   5.789199712272117e-08,
   7.585997272167449e-10,  -1.499064500985899e-11,  -6.046122114153308e-13,  -1.691760805473920e-15,   3.076540353721322e-16,   6.384990837207166e-18,  -5.692657867360614e-20,
  -4.488260121960295e-21,  -4.651103213750992e-23,   1.591311693609779e+00,  -1.227970786913293e-02,  -1.750177467356862e-04,   1.585145602807839e-07,   5.785472427459548e-08,
   7.565263546832776e-10,  -1.499759752570052e-11,  -6.027931640377537e-13,  -1.645659345710383e-15,   3.071162002760055e-16,   6.337036732988743e-18,  -5.748316860889686e-20,
  -4.463864712265399e-21,  -4.565541273416279e-23,   1.591276812817553e+00,  -1.227960817291369e-02,  -1.749485227304650e-04,   1.600106913277325e-07,   5.780964620738967e-08,
   7.540220175446316e-10,  -1.500591035206435e-11,  -6.005949925834831e-13,  -1.590071010434538e-15,   3.064636323920107e-16,   6.279168572089956e-18,  -5.815134893463008e-20,
  -4.434378152885622e-21,  -4.462568910682868e-23,   1.591242955537992e+00,  -1.227951110614125e-02,  -1.748813385312788e-04,   1.614615200697933e-07,   5.776587756739634e-08,
   7.515937887588021e-10,  -1.501388179538283e-11,  -5.984625568857055e-13,  -1.536272109182775e-15,   3.058278248237133e-16,   6.223115173053387e-18,  -5.879493845079169e-20,
  -4.405766658699944e-21,  -4.363117262446204e-23,   1.591215683698649e+00,  -1.227943270747453e-02,  -1.748272281868423e-04,   1.626291508228994e-07,   5.773061269000466e-08,
   7.496397437097378e-10,  -1.502023302952254e-11,  -5.967457792753026e-13,  -1.493050698712741e-15,   3.053139815887705e-16,   6.178048111807419e-18,  -5.930978478341037e-20,
  -4.382727542559678e-21,  -4.283366522633243e-23,   1.591197664492619e+00,  -1.227938080371884e-02,  -1.747914790936456e-04,   1.634001435332492e-07,   5.770730764402431e-08,
   7.483495756223334e-10,  -1.502439536323357e-11,  -5.956118952571575e-13,  -1.464548616791952e-15,   3.049736406697865e-16,   6.148312083104639e-18,  -5.964821734294987e-20,
  -4.367508658193706e-21,  -4.230847667519855e-23,   1.591188411244224e+00,  -1.227935411795389e-02,  -1.747731220974907e-04,   1.637959130233720e-07,   5.769533857367970e-08,
   7.476873310636839e-10,  -1.502652227760713e-11,  -5.950297562836969e-13,  -1.449929313886446e-15,   3.047986117790438e-16,   6.133054654757105e-18,  -5.982147255920054e-20,
  -4.359694583895248e-21,  -4.203932020924181e-23,   1.591185190642171e+00,  -1.227934482484202e-02,  -1.747667330751801e-04,   1.639336368169833e-07,   5.769117249982121e-08,
   7.474568814774261e-10,  -1.502726087615619e-11,  -5.948271637236648e-13,  -1.444843777017855e-15,   3.047376520169726e-16,   6.127746307398750e-18,  -5.988168876443481e-20,
  -4.356975072407517e-21,  -4.194572581617513e-23,   1.591184679580579e+00,  -1.227934334992118e-02,  -1.747657192394925e-04,   1.639554903855326e-07,   5.769051139514292e-08,
   7.474203147085161e-10,  -1.502737800119765e-11,  -5.947950163206057e-13,  -1.444036907413157e-15,   3.047279766751541e-16,   6.126904047383948e-18,  -5.989124012500812e-20,
  -4.356543535225944e-21,  -4.193087785055266e-23,   1.908586670779877e+00,  -3.791704009747835e-03,  -1.091020162123825e-04,  -2.481688630690725e-06,  -4.336762621976058e-08,
  -4.447172695813176e-10,   4.498302777392552e-12,   3.803585006015626e-13,   1.136369741299080e-14,   2.091429449422161e-16,   1.477786761761876e-18,  -5.784543937486911e-20,
  -2.811860206426846e-21,  -6.865116126934584e-23,   1.908576393592962e+00,  -3.792403427880296e-03,  -1.091263725543741e-04,  -2.482099152256775e-06,  -4.336094619283695e-08,
  -4.439573646147797e-10,   4.528247605393801e-12,   3.810559974642486e-13,   1.136935913587019e-14,   2.088252324150001e-16,   1.460030988266475e-18,  -5.834557268795624e-20,
  -2.819641786200755e-21,  -6.861999301647236e-23,   1.908558257482893e+00,  -3.793637654947952e-03,  -1.091693465652016e-04,  -2.482822941430535e-06,  -4.334912489996132e-08,
  -4.426153880677824e-10,   4.581097460835671e-12,   3.822858556084708e-13,   1.137928812313542e-14,   2.082625291300761e-16,   1.428662015607345e-18,  -5.922785403277515e-20,
  -2.833326141469715e-21,  -6.856303548439548e-23,   1.908536323947047e+00,  -3.795130253593659e-03,  -1.092213058373211e-04,  -2.483697161093927e-06,  -4.333477200662426e-08,
  -4.409907601435841e-10,   4.645023990688646e-12,   3.837714985070021e-13,   1.139118989936646e-14,   2.075785316031523e-16,   1.390664610728212e-18,  -6.029434900093249e-20,
  -2.849794124268045e-21,  -6.849081607478939e-23,   1.908515027943552e+00,  -3.796579407953051e-03,  -1.092717413716445e-04,  -2.484544796829503e-06,  -4.332077723641691e-08,
  -4.394116157376434e-10,   4.707103504659299e-12,   3.852121437078737e-13,   1.140263443225110e-14,   2.069107802812164e-16,   1.353708785092114e-18,  -6.132928715906876e-20,
  -2.865697636124133e-21,  -6.841719970716996e-23,   1.908497869791094e+00,  -3.797746946307559e-03,  -1.093123675403594e-04,  -2.485226894346060e-06,  -4.330945935258454e-08,
  -4.381380570854035e-10,   4.757128736907862e-12,   3.863715651137497e-13,   1.141177545816432e-14,   2.063701705795044e-16,   1.323888644535851e-18,  -6.216272844033015e-20,
  -2.878449392770784e-21,  -6.835538019646070e-23,   1.908486530829755e+00,  -3.798518492815262e-03,  -1.093392106060200e-04,  -2.485677246366615e-06,  -4.330195920904902e-08,
  -4.372958170821981e-10,   4.790191724746919e-12,   3.871371287434148e-13,   1.141777719700999e-14,   2.060116343854858e-16,   1.304160090155214e-18,  -6.271330598323543e-20,
  -2.886846111663281e-21,  -6.831329855013357e-23,   1.908480707371875e+00,  -3.798914736782257e-03,  -1.093529951905684e-04,  -2.485908410485187e-06,  -4.329810088057646e-08,
  -4.368630716410675e-10,   4.807173372420045e-12,   3.875301083815448e-13,   1.142084746732010e-14,   2.058271035295031e-16,   1.294021143425527e-18,  -6.299600824399909e-20,
  -2.891149114061124e-21,  -6.829130627555241e-23,   1.908478680406929e+00,  -3.799052655975619e-03,  -1.093577929436223e-04,  -2.485988851249209e-06,  -4.329675689592128e-08,
  -4.367124164218143e-10,   4.813084343437328e-12,   3.876668608285544e-13,   1.142191420635326e-14,   2.057628113453194e-16,   1.290491014776665e-18,  -6.309439803167497e-20,
  -2.892645360828860e-21,  -6.828359093610977e-23,   1.908478358752797e+00,  -3.799074541987529e-03,  -1.093585542763102e-04,  -2.486001615234853e-06,  -4.329654357383362e-08,
  -4.366885078896683e-10,   4.814022349877518e-12,   3.876885602422465e-13,   1.142208339309312e-14,   2.057526059977889e-16,   1.289930776200901e-18,  -6.311001078716319e-20,
  -2.892882725591594e-21,  -6.828236373473658e-23,   9.323567627289831e-03,  -2.023543484416155e-04,   3.277081214406492e-06,  -4.716045256624644e-08,   6.271756048712299e-10,
  -8.126117543620626e-12,   9.782896459456753e-14,  -1.126455500804260e-15,   1.807229593359929e-17,  -2.834381199453280e-20,   2.389879072992532e-21,  -9.535494470214868e-23,
  -2.226393522385655e-24,  -1.113494922884254e-26,   9.323875562833039e-03,  -2.023676391966057e-04,   3.277434780026970e-06,  -4.716808944898705e-08,   6.273137402492674e-10,
  -8.128337004316106e-12,   9.787660234311270e-14,  -1.126564062070434e-15,   1.808194912957808e-17,  -2.883829415836859e-20,   2.376476067114862e-21,  -9.542838520216529e-23,
  -2.218329769892526e-24,  -1.098968703758921e-26,   9.324418946993280e-03,  -2.023910926927026e-04,   3.278058715440196e-06,  -4.718156654113305e-08,   6.275575368415899e-10,
  -8.132253457814243e-12,   9.796068024303512e-14,  -1.126756978975630e-15,   1.809893670279503e-17,  -2.971111544137820e-20,   2.352866673412045e-21,  -9.555711390982188e-23,
  -2.204114134436424e-24,  -1.073377105770882e-26,   9.325076059051382e-03,  -2.024194558946480e-04,   3.278813292780667e-06,  -4.719786607075013e-08,   6.278524313048731e-10,
  -8.136989583951991e-12,   9.806238275842490e-14,  -1.126992573652783e-15,   1.811940052754946e-17,  -3.076704886473618e-20,   2.324386819255908e-21,  -9.571131232696523e-23,
  -2.186946490350038e-24,  -1.042499562857152e-26,   9.325714020369509e-03,  -2.024469935251561e-04,   3.279545936490574e-06,  -4.721369239406347e-08,   6.281388071739014e-10,
  -8.141587658419157e-12,   9.816114996949293e-14,  -1.127223712448309e-15,   1.813918517684760e-17,  -3.179266022627546e-20,   2.296811140819310e-21,  -9.585947683475969e-23,
  -2.170303428593254e-24,  -1.012595027116480e-26,   9.326227988325797e-03,  -2.024691797214971e-04,   3.280136225779456e-06,  -4.722644403973247e-08,   6.283695776713543e-10,
  -8.145292041758732e-12,   9.824074140612747e-14,  -1.127411654689599e-15,   1.815506528310470e-17,  -3.261925656160210e-20,   2.274648131932643e-21,  -9.597774239995646e-23,
  -2.156912392761103e-24,  -9.885547648283641e-27,   9.326567626144906e-03,  -2.024838410613352e-04,   3.280526318113458e-06,  -4.723487116031379e-08,   6.285221008972589e-10,
  -8.147739947562079e-12,   9.829334664525509e-14,  -1.127536695642099e-15,   1.816553013703224e-17,  -3.316564047289820e-20,   2.260028458823667e-21,  -9.605535518438078e-23,
  -2.148071834055638e-24,  -9.726939572951576e-27,   9.326742051658175e-03,  -2.024913706999939e-04,   3.280726661467270e-06,  -4.723919921786616e-08,   6.286004394472042e-10,
  -8.148997100088218e-12,   9.832036585519433e-14,  -1.127601173706201e-15,   1.817089555304206e-17,  -3.344629140050457e-20,   2.252528362053942e-21,  -9.609504773343734e-23,
  -2.143534251638050e-24,  -9.645562447371844e-27,   9.326802762889979e-03,  -2.024939915136756e-04,   3.280796394760579e-06,  -4.724070569013696e-08,   6.286277075806532e-10,
  -8.149434669242212e-12,   9.832977075948852e-14,  -1.127623657848474e-15,   1.817276163693539e-17,  -3.354398352718791e-20,   2.249919126938738e-21,  -9.610883677885212e-23,
  -2.141955296785435e-24,  -9.617250422476376e-27,   9.326812396965957e-03,  -2.024944074032756e-04,   3.280807460566625e-06,  -4.724094474901719e-08,   6.286320347378232e-10,
  -8.149504105711673e-12,   9.833126321773760e-14,  -1.127627227764325e-15,   1.817305769238117e-17,  -3.355948634922992e-20,   2.249505136228512e-21,  -9.611102366166200e-23,
  -2.141704757006591e-24,  -9.612758264605840e-27,   8.403940737440339e-02,  -1.793537683458054e-03,   2.785156944929026e-05,  -3.702867761847506e-07,   4.291233335025369e-09,
  -4.480412410157501e-11,   3.563716165948245e-13,  -1.384276437360903e-15,   2.960528815008880e-17,   1.678908198566948e-18,  -2.867582196715528e-21,  -5.810306714271976e-22,
  -2.405684829597787e-23,  -7.441236131408700e-26,   8.404202330527190e-02,  -1.793641974443319e-03,   2.785398609776669e-05,  -3.703288020487932e-07,   4.291735395814032e-09,
  -4.480676068786983e-11,   3.564489701044379e-13,  -1.378688763791090e-15,   2.958853110261601e-17,   1.675894472039195e-18,  -3.013026155087015e-21,  -5.814996555897312e-22,
  -2.398313184063583e-23,  -7.304468750185995e-26,   8.404663934104546e-02,  -1.793826007143604e-03,   2.785825054190076e-05,  -3.704029593304702e-07,   4.292621378276785e-09,
  -4.481140408107961e-11,   3.565854230118877e-13,  -1.368837507863017e-15,   2.955846716680735e-17,   1.670574814828183e-18,  -3.269294843384522e-21,  -5.823191074147632e-22,
  -2.385318140988951e-23,  -7.063534284731272e-26,   8.405222141559930e-02,  -1.794048557847688e-03,   2.786340754530303e-05,  -3.704926344851157e-07,   4.293692868268839e-09,
  -4.481700374745020e-11,   3.567503568265562e-13,  -1.356939388876479e-15,   2.952126891443543e-17,   1.664139030113930e-18,  -3.578548132534111e-21,  -5.832962392491244e-22,
  -2.369625361519924e-23,  -6.772861694989126e-26,   8.405764072659704e-02,  -1.794264623389626e-03,   2.786841428546393e-05,  -3.705796931037563e-07,   4.294733209799867e-09,
  -4.482242392784289e-11,   3.569104011614566e-13,  -1.345403696805547e-15,   2.948427412160654e-17,   1.657887961874088e-18,  -3.878107152335708e-21,  -5.842304346627483e-22,
  -2.354412938589253e-23,  -6.491376910418810e-26,   8.406200668926427e-02,  -1.794438695283511e-03,   2.787244794439379e-05,  -3.706498289204400e-07,   4.295571408294783e-09,
  -4.482677898576286e-11,   3.570392795940079e-13,  -1.336121297562367e-15,   2.945383944181634e-17,   1.652849824688573e-18,  -4.118956408520184e-21,  -5.849727159987289e-22,
  -2.342173598276677e-23,  -6.265111452135694e-26,   8.406489175527421e-02,  -1.794553724914084e-03,   2.787511345839992e-05,  -3.706961746536428e-07,   4.296125330188743e-09,
  -4.482965116723233e-11,   3.571244148348516e-13,  -1.329992846869839e-15,   2.943341954126803e-17,   1.649519567265197e-18,  -4.277874552613553e-21,  -5.854581675609082e-22,
  -2.334093665254472e-23,  -6.115840423241782e-26,   8.406637341048440e-02,  -1.794612799996374e-03,   2.787648237193083e-05,  -3.707199757867712e-07,   4.296409812672745e-09,
  -4.483112445007205e-11,   3.571681279648978e-13,  -1.326847200562392e-15,   2.942283738726093e-17,   1.647808968065266e-18,  -4.359415293003501e-21,  -5.857059143349815e-22,
  -2.329946578965525e-23,  -6.039256927421271e-26,   8.406688911984340e-02,  -1.794633361916357e-03,   2.787695884191378e-05,  -3.707282600498348e-07,   4.296508832126602e-09,
  -4.483163696592869e-11,   3.571833414591166e-13,  -1.325752585315873e-15,   2.941913896463662e-17,   1.647213522362246e-18,  -4.387784941363786e-21,  -5.857918972849373e-22,
  -2.328503520546534e-23,  -6.012613149134322e-26,   8.406697095608655e-02,  -1.794636624823955e-03,   2.787703445147472e-05,  -3.707295746511719e-07,   4.296524545279337e-09,
  -4.483171828214318e-11,   3.571857555711611e-13,  -1.325578897093672e-15,   2.941855135409526e-17,   1.647119030675147e-18,  -4.392286274936037e-21,  -5.858055298434741e-22,
  -2.328274544743564e-23,  -6.008385708599460e-26,   2.340707406493015e-01,  -4.813744650390379e-03,   6.774732977453586e-05,  -7.275362944630840e-07,   5.014598414857450e-09,
   1.662144340880889e-12,  -8.947439656026743e-13,   1.827849442912363e-14,  -8.181084853485888e-17,   4.655191328837966e-18,   3.375509483119312e-20,  -2.608042696504744e-21,
  -5.924570321560661e-23,  -3.574092907221171e-25,   2.340770975969597e-01,  -4.813949262942285e-03,   6.775014336283849e-05,  -7.275344313590710e-07,   5.013337679647930e-09,
   1.698373550978100e-12,  -8.949560475659900e-13,   1.829385238745871e-14,  -8.167984246878959e-17,   4.641652624821616e-18,   3.339897953335136e-20,  -2.610418685803012e-21,
  -5.901919242735838e-23,  -3.530866433108530e-25,   2.340883147448771e-01,  -4.814310304535354e-03,   6.775510740659499e-05,  -7.275311161943713e-07,   5.011112851069684e-09,
   1.762324970814054e-12,  -8.953299968341235e-13,   1.832091453221175e-14,  -8.144989244163426e-17,   4.617753650576195e-18,   3.277174317527555e-20,  -2.614585620272433e-21,
  -5.861994214816774e-23,  -3.454713728926587e-25,   2.341018790044536e-01,  -4.814746879075298e-03,   6.776110899732365e-05,  -7.275270602381888e-07,   5.008422153067889e-09,
   1.839697288950930e-12,  -8.957817170835995e-13,   1.835357489528744e-14,  -8.117389871900586e-17,   4.588838258587825e-18,   3.201521553256705e-20,  -2.619580829414483e-21,
  -5.813789797972471e-23,  -3.362834465733567e-25,   2.341150473344802e-01,  -4.815170697225778e-03,   6.776693420716372e-05,  -7.275230733179010e-07,   5.005809639356028e-09,
   1.914852484007443e-12,  -8.962197564699777e-13,   1.838521452081330e-14,  -8.090812712201662e-17,   4.560750514249439e-18,   3.128281421166431e-20,  -2.624384608679992e-21,
  -5.767070302735339e-23,  -3.273853403632241e-25,   2.341256558433126e-01,  -4.815512118999277e-03,   6.777162618200391e-05,  -7.275198260515778e-07,   5.003704723898307e-09,
   1.975427653992318e-12,  -8.965722909521433e-13,   1.841065533606255e-14,  -8.069556902787665e-17,   4.538111147211226e-18,   3.069424911317980e-20,  -2.628221925436243e-21,
  -5.729488300885884e-23,  -3.202323605422228e-25,   2.341326658908250e-01,  -4.815737724121369e-03,   6.777472619380091e-05,  -7.275176629514514e-07,   5.002313682342469e-09,
   2.015469870633967e-12,  -8.968050714925648e-13,   1.842744283365404e-14,  -8.055586946910285e-17,   4.523145487533923e-18,   3.030604417113816e-20,  -2.630741638322796e-21,
  -5.704681440650383e-23,  -3.155132121137072e-25,   2.341362659270362e-01,  -4.815853583052140e-03,   6.777631808635707e-05,  -7.275165467249615e-07,   5.001599269287485e-09,
   2.036038169649899e-12,  -8.969245636293284e-13,   1.843605679746256e-14,  -8.048436036007234e-17,   4.515458064802006e-18,   3.010690132172767e-20,  -2.632030712465786e-21,
  -5.691950156943187e-23,  -3.130919880501410e-25,   2.341375189591976e-01,  -4.815893908798967e-03,   6.777687214133507e-05,  -7.275161573569405e-07,   5.001350603854837e-09,
   2.043197903213332e-12,  -8.969661457258514e-13,   1.843905381698107e-14,  -8.045950808302541e-17,   4.512782094427101e-18,   3.003762267850212e-20,  -2.632478603745099e-21,
  -5.687520225049794e-23,  -3.122496218068616e-25,   2.341377177984574e-01,  -4.815900307938898e-03,   6.777696006138427e-05,  -7.275160955289986e-07,   5.001311143722824e-09,
   2.044334089863406e-12,  -8.969727438411480e-13,   1.843952934813147e-14,  -8.045556613092054e-17,   4.512357440907189e-18,   3.002663076614694e-20,  -2.632549640768112e-21,
  -5.686817317930656e-23,  -3.121159671018337e-25,   4.601340203704052e-01,  -8.858635797567011e-03,   1.021354987024426e-04,  -5.665889347665068e-07,  -6.245468032486411e-09,
   1.961838828294226e-10,  -2.445234343585348e-12,   3.857612999327269e-15,   7.620132278657579e-16,  -2.335973022318093e-18,   1.243502661797129e-19,  -3.501406074735918e-21,
  -1.915890172637372e-22,  -1.091159992032204e-25,   4.601435884632240e-01,  -8.858794502324770e-03,   1.021319663711000e-04,  -5.664049501437853e-07,  -6.248882848404013e-09,
   1.961913435391450e-10,  -2.443224110292861e-12,   3.849258163596852e-15,   7.625005958176334e-16,  -2.354037755715539e-18,   1.231885638415033e-19,  -3.501750102139155e-21,
  -1.910752564120431e-22,  -1.008405207141022e-25,   4.601604712422566e-01,  -8.859074497290509e-03,   1.021257319607486e-04,  -5.660803007328993e-07,  -6.254906042761418e-09,
   1.962044944741741e-10,  -2.439676004384680e-12,   3.834466350511745e-15,   7.633566006240367e-16,  -2.385914241920155e-18,   1.211412974064515e-19,  -3.502308410599834e-21,
  -1.901695168760198e-22,  -8.627296148363326e-26,   4.601808856164346e-01,  -8.859412998450736e-03,   1.021181905925343e-04,  -5.656877215704942e-07,  -6.262185427765623e-09,
   1.962203734739247e-10,  -2.435383867422433e-12,   3.816495402998471e-15,   7.643849385312549e-16,  -2.424461161318577e-18,   1.186701098755960e-19,  -3.502900567896445e-21,
  -1.890756450356965e-22,  -6.871652877168790e-26,   4.602007030529695e-01,  -8.859741534386970e-03,   1.021108667859512e-04,  -5.653066024440855e-07,  -6.269248016491885e-09,
   1.962357641140212e-10,  -2.431215331518540e-12,   3.798960998698369e-15,   7.653761679810317e-16,  -2.461883269999459e-18,   1.162757163620934e-19,  -3.503388730884793e-21,
  -1.880151486683927e-22,  -5.173429503117779e-26,   4.602166673748848e-01,  -8.860006144833186e-03,   1.021049648336467e-04,  -5.649995706226390e-07,  -6.274934599027913e-09,
   1.962481450692298e-10,  -2.427855926088238e-12,   3.784772085733972e-15,   7.661696342102294e-16,  -2.492030931349851e-18,   1.143501122073384e-19,  -3.503719997567907e-21,
  -1.871618360592000e-22,  -3.809727023386803e-26,   4.602272161443669e-01,  -8.860180968344532e-03,   1.021010639551154e-04,  -5.647966859372435e-07,  -6.278690748207201e-09,
   1.962563175739764e-10,  -2.425635462710738e-12,   3.775365249962030e-15,   7.666914695272193e-16,  -2.511952357879551e-18,   1.130793162569771e-19,  -3.503908590178001e-21,
  -1.865984746518515e-22,  -2.910743818587400e-26,   4.602326333896419e-01,  -8.860270740431195e-03,   1.020990603663042e-04,  -5.646924938533088e-07,  -6.280619264135237e-09,
   1.962605118793064e-10,  -2.424494954716393e-12,   3.770524785627340e-15,   7.669586925898009e-16,  -2.522183073179198e-18,   1.124271991120948e-19,  -3.503996080795216e-21,
  -1.863093134763570e-22,  -2.449728686733440e-26,   4.602345189030959e-01,  -8.860301985130345e-03,   1.020983629509499e-04,  -5.646562286708048e-07,  -6.281290430691886e-09,
   1.962619713207386e-10,  -2.424097959650179e-12,   3.768838488702426e-15,   7.670515803811775e-16,  -2.525743983819516e-18,   1.122003029331185e-19,  -3.504025043411326e-21,
  -1.862086924219408e-22,  -2.289372362228430e-26,   4.602348181077158e-01,  -8.860306943172183e-03,   1.020982522784633e-04,  -5.646504738775569e-07,  -6.281396932206792e-09,
   1.962622028938129e-10,  -2.424034960538624e-12,   3.768570824018458e-15,   7.670663146204580e-16,  -2.526309052060016e-18,   1.121643013922395e-19,  -3.504029568696998e-21,
  -1.861927263916949e-22,  -2.263930965663315e-26,   7.614745702653818e-01,  -1.307331930047422e-02,   9.514109056153581e-05,   6.976575127119439e-07,  -2.651656406973920e-08,
   1.651485744906797e-10,   4.164429015843580e-12,  -1.045897004567127e-13,   8.042986696679493e-16,   4.381654217524287e-17,  -4.194658846456265e-19,  -9.606898592654390e-21,
  -1.194510161785037e-22,  -4.316976256309251e-24,   7.614834598505241e-01,  -1.307312254572902e-02,   9.512620823121979e-05,   6.978106298308584e-07,  -2.651068338143131e-08,
   1.649449920820726e-10,   4.166503222651786e-12,  -1.044431455065597e-13,   8.025068524965303e-16,   4.376586317150712e-17,  -4.201628263757391e-19,  -9.636581265915472e-21,
  -1.185358471648449e-22,  -4.282649744640588e-24,   7.614991445332444e-01,  -1.307277533416568e-02,   9.509995081992536e-05,   6.980806529477418e-07,  -2.650030445744687e-08,
   1.645860016346138e-10,   4.170159355917076e-12,  -1.041846868791304e-13,   7.993428093570812e-16,   4.367631676356076e-17,  -4.213880275620403e-19,  -9.688754250972207e-21,
  -1.169246672006574e-22,  -4.222192710419837e-24,   7.615181086923829e-01,  -1.307235542305666e-02,   9.506820467300962e-05,   6.984069045604322e-07,  -2.648775013588359e-08,
   1.641523052407576e-10,   4.174573845044010e-12,  -1.038723946933124e-13,   7.955128122455939e-16,   4.356782798210624e-17,  -4.228617853144287e-19,  -9.751497456571589e-21,
  -1.149826168134281e-22,  -4.149278901523004e-24,   7.615365167522714e-01,  -1.307194771868185e-02,   9.503739087626715e-05,   6.987233484869748e-07,  -2.647555841637777e-08,
   1.637316975973291e-10,   4.178852495137844e-12,  -1.035694771498529e-13,   7.917905397243922e-16,   4.346229155105708e-17,  -4.242843644892073e-19,  -9.812046850528091e-21,
  -1.131037832140195e-22,  -4.078695231020093e-24,   7.615513446005060e-01,  -1.307161923298197e-02,   9.501257113159089e-05,   6.989780743197136e-07,  -2.646573391807842e-08,
   1.633931604107759e-10,   4.182294402130107e-12,  -1.033256302626939e-13,   7.887889417023624e-16,   4.337711752827435e-17,  -4.254245694570613e-19,  -9.860566675904453e-21,
  -1.115948424975745e-22,  -4.021976584676789e-24,   7.615611418708065e-01,  -1.307140215377328e-02,   9.499617237556876e-05,   6.991462960632286e-07,  -2.645924059310638e-08,
   1.631696073430133e-10,   4.184566343801843e-12,  -1.031645885766017e-13,   7.868040821665036e-16,   4.332076024826116e-17,  -4.261751581579241e-19,  -9.892501562654678e-21,
  -1.106000184060140e-22,  -3.984567548798506e-24,   7.615661730190474e-01,  -1.307129066650060e-02,   9.498775135212962e-05,   6.992326561283871e-07,  -2.645590550519355e-08,
   1.630548473708152e-10,   4.185732349244391e-12,  -1.030819131953655e-13,   7.857843120428363e-16,   4.329179469023217e-17,  -4.265597445161817e-19,  -9.908862676989750e-21,
  -1.100898252457608e-22,  -3.965377710551044e-24,   7.615679241214277e-01,  -1.307125186126595e-02,   9.498482042098082e-05,   6.992627097887234e-07,  -2.645474462491246e-08,
   1.630149113103240e-10,   4.186138069438336e-12,  -1.030531416084380e-13,   7.854293001800111e-16,   4.328170924145807e-17,  -4.266934638088194e-19,  -9.914551110407309e-21,
  -1.099123586207580e-22,  -3.958701929226243e-24,   7.615682019956049e-01,  -1.307124570335893e-02,   9.498435532652173e-05,   6.992674786651745e-07,  -2.645456040576353e-08,
   1.630085743492605e-10,   4.186202446010925e-12,  -1.030485761597471e-13,   7.853729612922808e-16,   4.328010864306694e-17,  -4.267146765976085e-19,  -9.915453492069403e-21,
  -1.098842023678878e-22,  -3.957642736837187e-24,   1.130955315960059e+00,  -1.571869314473886e-02,   1.206985664986066e-06,   2.607045301665220e-06,  -1.132873845416727e-08,
  -7.638368393423881e-10,   7.414906266683511e-12,   2.397933701294676e-13,  -3.685317058264643e-15,  -3.728772813770165e-17,   2.746950485964289e-18,  -2.028587175612236e-21,
  -1.898626824964211e-21,  -3.018692373048961e-24,   1.130955416440664e+00,  -1.571796242222638e-02,   1.200671431369848e-06,   2.606333156401218e-06,  -1.131842258059140e-08,
  -7.633667542122968e-10,   7.405463017385120e-12,   2.396672271561516e-13,  -3.674093601728552e-15,  -3.729900349111945e-17,   2.735539580281824e-18,  -2.049696423239563e-21,
  -1.891320006245393e-21,  -3.001248530946245e-24,   1.130955593265922e+00,  -1.571667321298894e-02,   1.189534558151797e-06,   2.605076922536417e-06,  -1.130023076513010e-08,
  -7.625374836449692e-10,   7.388823986900966e-12,   2.394446143574610e-13,  -3.654328478598985e-15,  -3.731898653014058e-17,   2.715441327808329e-18,  -2.086839925309645e-21,
  -1.878452947049959e-21,  -2.970439528242557e-24,   1.130955806276350e+00,  -1.571511456379584e-02,   1.176075727856864e-06,   2.603558480853723e-06,  -1.127825126326339e-08,
  -7.615350653444943e-10,   7.368744301103435e-12,   2.391753746448901e-13,  -3.630494424954219e-15,  -3.734329913065701e-17,   2.691200401927504e-18,  -2.131576631067928e-21,
  -1.862938098445036e-21,  -2.933135303504787e-24,   1.130956012216772e+00,  -1.571360174350239e-02,   1.163018497264845e-06,   2.602085042319739e-06,  -1.125693301612758e-08,
  -7.605622958434010e-10,   7.349293532203196e-12,   2.389139447012264e-13,  -3.607425895353617e-15,  -3.736705692267358e-17,   2.667732643563371e-18,  -2.174820103119013e-21,
  -1.847922658791898e-21,  -2.896868907005264e-24,   1.130956177513460e+00,  -1.571238324242449e-02,   1.152505755398965e-06,   2.600898516690817e-06,  -1.123977296252149e-08,
  -7.597789039509011e-10,   7.333654461620246e-12,   2.387032993728474e-13,  -3.588891662201310e-15,  -3.738630706532587e-17,   2.648873752792127e-18,  -2.209523000439910e-21,
  -1.835859371771890e-21,  -2.867615762782547e-24,   1.130956286441825e+00,  -1.571157818008694e-02,   1.145562056126059e-06,   2.600114705556605e-06,  -1.122844058105928e-08,
  -7.592613791580632e-10,   7.323335216436419e-12,   2.385640886734469e-13,  -3.576668764181357e-15,  -3.739908154165144e-17,   2.636434835069499e-18,  -2.232388657341274e-21,
  -1.827904270646160e-21,  -2.848267459737522e-24,   1.130956342290001e+00,  -1.571116477343134e-02,   1.141997041191803e-06,   2.599712250259093e-06,  -1.122262292421969e-08,
  -7.589956445736046e-10,   7.318040354935861e-12,   2.384925911147192e-13,  -3.570399196563256e-15,  -3.740565862375838e-17,   2.630053869402249e-18,  -2.244111031601506e-21,
  -1.823823919078983e-21,  -2.838325499882885e-24,   1.130956361713864e+00,  -1.571102088845365e-02,   1.140756349451260e-06,   2.599572183027030e-06,  -1.122059836383010e-08,
  -7.589031594524207e-10,   7.316198156214238e-12,   2.384677047459108e-13,  -3.568218205641563e-15,  -3.740795050631411e-17,   2.627834031859408e-18,  -2.248187889106192e-21,
  -1.822404506529985e-21,  -2.834864204780738e-24,   1.130956364795471e+00,  -1.571099805612641e-02,   1.140559475611663e-06,   2.599549956809472e-06,  -1.122027710956428e-08,
  -7.588884836333905e-10,   7.315905859120908e-12,   2.384637555749606e-13,  -3.567872168877181e-15,  -3.740831432317085e-17,   2.627481827181024e-18,  -2.248834677259367e-21,
  -1.822179302854609e-21,  -2.834314901945859e-24,   1.539471294332284e+00,  -1.365642909676472e-02,  -1.672464779138466e-04,   1.179474620702484e-06,   6.815543814553785e-08,
   2.022063466532066e-10,  -3.074270760047287e-11,  -4.426381411717518e-13,   1.276898026647860e-14,   4.468166288754143e-16,  -1.121503352106043e-18,  -2.768439177053867e-19,
  -3.287768938791734e-21,   1.095605670715137e-22,   1.539455691475042e+00,  -1.365609672903722e-02,  -1.672083821397537e-04,   1.179657081061005e-06,   6.811260117995235e-08,
   2.013582328562927e-10,  -3.070930125001414e-11,  -4.411664318450907e-13,   1.276363877542573e-14,   4.454197122696124e-16,  -1.140662767257716e-18,  -2.760564319208663e-19,
  -3.261995267581661e-21,   1.093141285374479e-22,   1.539428162862458e+00,  -1.365551022045098e-02,  -1.671411810430163e-04,   1.179978395972185e-06,   6.803705282724739e-08,
   1.998640604880591e-10,  -3.065036698467389e-11,  -4.385733881072077e-13,   1.275414894982180e-14,   4.429581180077282e-16,  -1.174341945131984e-18,  -2.746683787043352e-19,
  -3.216675109345326e-21,   1.088783258999986e-22,   1.539394879870213e+00,  -1.365480093904003e-02,  -1.670599539891282e-04,   1.180365844612017e-06,   6.794576398624704e-08,
   1.980612732277791e-10,  -3.057912319611874e-11,  -4.354443430103486e-13,   1.274256376345077e-14,   4.399871323820119e-16,  -1.214849606816147e-18,  -2.729924535209376e-19,
  -3.162142010611687e-21,   1.083497343754977e-22,   1.539362574447656e+00,  -1.365411230883266e-02,  -1.669811349544719e-04,   1.180740834424926e-06,   6.785721045077052e-08,
   1.963153230992130e-10,  -3.050998218436947e-11,  -4.324135097506156e-13,   1.273120226640336e-14,   4.371088102624205e-16,  -1.253946604403441e-18,  -2.713681418023519e-19,
  -3.109482529208918e-21,   1.078349206442305e-22,   1.539336553294212e+00,  -1.365355750572763e-02,  -1.669176642764643e-04,   1.181042106611940e-06,   6.778592165267743e-08,
   1.949117885220195e-10,  -3.045429837578758e-11,  -4.299767690495695e-13,   1.272196760630784e-14,   4.347942657169937e-16,  -1.285280376454278e-18,  -2.700615176033822e-19,
  -3.067260951456288e-21,   1.074190165828208e-22,   1.539319360778505e+00,  -1.365319087650701e-02,  -1.668757361760270e-04,   1.181240783431481e-06,   6.773883916462913e-08,
   1.939858155259425e-10,  -3.041751102782507e-11,  -4.283689911432906e-13,   1.271582547257107e-14,   4.332669080121348e-16,  -1.305905922510580e-18,  -2.691990553235310e-19,
  -3.039459464715351e-21,   1.071436252361237e-22,   1.539310532155318e+00,  -1.365300258707008e-02,  -1.668542078601104e-04,   1.181342690346109e-06,   6.771466743849885e-08,
   1.935107345568797e-10,  -3.039862129748526e-11,  -4.275440548740188e-13,   1.271265883475495e-14,   4.324831710484578e-16,  -1.316473659261446e-18,  -2.687564280974773e-19,
  -3.025212256811531e-21,   1.070020239801029e-22,   1.539307459360719e+00,  -1.365293704996782e-02,  -1.668467153326875e-04,   1.181378140385471e-06,   6.770625542338522e-08,
   1.933454499619115e-10,  -3.039204692591649e-11,  -4.272570451603293e-13,   1.271155469204945e-14,   4.322104851727848e-16,  -1.320147965155291e-18,  -2.686024135800281e-19,
  -3.020258186490631e-21,   1.069527106952843e-22,   1.539306971754739e+00,  -1.365292665007346e-02,  -1.668455264002605e-04,   1.181383764888396e-06,   6.770492060824356e-08,
   1.933192249756662e-10,  -3.039100368136825e-11,  -4.272115062207463e-13,   1.271137938654508e-14,   4.321672184717237e-16,  -1.320730842221969e-18,  -2.685779757787531e-19,
  -3.019472271575830e-21,   1.069448840451181e-22,   1.891468143632805e+00,  -4.796053750467117e-03,  -1.433082108643261e-04,  -3.236407552591542e-06,  -5.007690077799193e-08,
  -1.606770133547852e-10,   2.140951560639410e-11,   8.679374844398883e-13,   1.887640045169868e-14,   1.630552693487798e-16,  -5.514997687778854e-18,  -2.967418964999423e-19,
  -7.331090191697716e-21,  -8.544298675253222e-23,   1.891454652321028e+00,  -4.796964464836192e-03,  -1.433362055381681e-04,  -3.236543745039034e-06,  -5.004621462166411e-08,
  -1.589602473755556e-10,   2.145855154153778e-11,   8.684472555515565e-13,   1.885169888197162e-14,   1.615033954305595e-16,  -5.559733908739655e-18,  -2.973109583826950e-19,
  -7.317918588915133e-21,  -8.443823669972918e-23,   1.891430844575921e+00,  -4.798571463318048e-03,  -1.433855884119233e-04,  -3.236782747819882e-06,  -4.999201255745956e-08,
  -1.559301908286993e-10,   2.154502263643173e-11,   8.693424807153815e-13,   1.880795969321152e-14,   1.587627612841268e-16,  -5.638603054969135e-18,  -2.983090538652022e-19,
  -7.294463428473597e-21,  -8.266162395734225e-23,   1.891402052393683e+00,  -4.800514711698145e-03,  -1.434452785343811e-04,  -3.237069516877540e-06,  -4.992637564123908e-08,
  -1.522648615820349e-10,   2.164949282009732e-11,   8.704177047478400e-13,   1.875480928960972e-14,   1.554448047795265e-16,  -5.733854732711578e-18,  -2.995056767025494e-19,
  -7.265737118000628e-21,  -8.050702137801628e-23,   1.891374097670048e+00,  -4.802401234266623e-03,  -1.435031993328215e-04,  -3.237345565639563e-06,  -4.986255681990563e-08,
  -1.487052130742571e-10,   2.175081447148132e-11,   8.714538722477325e-13,   1.870293920608967e-14,   1.522196733025850e-16,  -5.826199182870090e-18,  -3.006565482770828e-19,
  -7.237469147297827e-21,  -7.840881012085737e-23,   1.891351575006631e+00,  -4.803921028440746e-03,  -1.435498414037191e-04,  -3.237566268767899e-06,  -4.981107385459587e-08,
  -1.458366002669234e-10,   2.183236875284572e-11,   8.722831164429871e-13,   1.866095817978396e-14,   1.496186153613337e-16,  -5.900501000458746e-18,  -3.015759317636093e-19,
  -7.214424087899745e-21,  -7.671384659986863e-23,   1.891336691109373e+00,  -4.804925298970607e-03,  -1.435806527499074e-04,  -3.237711283643631e-06,  -4.977701990756639e-08,
  -1.439405810424373e-10,   2.188622444368889e-11,   8.728283820880599e-13,   1.863312236979148e-14,   1.478984523922168e-16,  -5.949554146356242e-18,  -3.021796471344596e-19,
  -7.199062863761072e-21,  -7.559156904937590e-23,   1.891329047107028e+00,  -4.805441045371551e-03,  -1.435964730956511e-04,  -3.237785501534636e-06,  -4.975952078011464e-08,
  -1.429667329724386e-10,   2.191387140885971e-11,   8.731075716606918e-13,   1.861879782951265e-14,   1.470146254429780e-16,  -5.974731566661982e-18,  -3.024885085149775e-19,
  -7.191132885128649e-21,  -7.501452447614586e-23,   1.891326386476912e+00,  -4.805620556492709e-03,  -1.436019790731790e-04,  -3.237811293281691e-06,  -4.975342833007377e-08,
  -1.426277521505282e-10,   2.192349251369486e-11,   8.732046139139971e-13,   1.861380734362879e-14,   1.467069312986180e-16,  -5.983492609515916e-18,  -3.025958233289001e-19,
  -7.188366217247705e-21,  -7.481356739242621e-23,   1.891325964268465e+00,  -4.805649042476321e-03,  -1.436028527751547e-04,  -3.237815384155460e-06,  -4.975246146058306e-08,
  -1.425739594199745e-10,   2.192501917099954e-11,   8.732200069049279e-13,   1.861301519922131e-14,   1.466581011510083e-16,  -5.984882762343670e-18,  -3.026128438220151e-19,
  -7.187926873472952e-21,  -7.478167298511749e-23,   8.563224874016359e-03,  -1.782423800695060e-04,   2.766388145802476e-06,  -3.830780831305939e-08,   4.859127836841886e-10,
  -6.091883616029595e-12,   7.430585194213940e-14,  -5.561241560598535e-16,   1.747403601815209e-17,  -4.786950540886472e-20,  -4.072205673276777e-21,  -1.893467642646786e-22,
  -1.067816271804467e-24,   6.030286267303227e-26,   8.563484772286818e-03,  -1.782531742704995e-04,   2.766662064358299e-06,  -3.831352867663326e-08,   4.860178137193425e-10,
  -6.092981505441726e-12,   7.435136187669996e-14,  -5.563106468340289e-16,   1.745666561856356e-17,  -4.882854243217971e-20,  -4.078230845107317e-21,  -1.889030811760101e-22,
  -1.055260287188450e-24,   6.035090804814180e-26,   8.563943387829363e-03,  -1.782722221178620e-04,   2.767145446124818e-06,  -3.832362318605750e-08,   4.862031927607222e-10,
  -6.094919059361239e-12,   7.443162768841630e-14,  -5.566423315156776e-16,   1.742599512107796e-17,  -5.051891558566868e-20,  -4.088799174234752e-21,  -1.881198982688479e-22,
  -1.033103322885878e-24,   6.043654238062887e-26,   8.564497986377281e-03,  -1.782952572120299e-04,   2.767730038664162e-06,  -3.833583100357997e-08,   4.864274435293497e-10,
  -6.097262503028814e-12,   7.452862253520694e-14,  -5.570478699053035e-16,   1.738887381175387e-17,  -5.255975582974182e-20,  -4.101470775311061e-21,  -1.871723551120808e-22,
  -1.006307933655941e-24,   6.054154318908520e-26,   8.565036418470862e-03,  -1.783176216219057e-04,   2.768297637021679e-06,  -3.834768363803139e-08,   4.866452348816482e-10,
  -6.099538039131941e-12,   7.462271699305703e-14,  -5.574462273605135e-16,   1.735280144594375e-17,  -5.453764013581870e-20,  -4.113659319209818e-21,  -1.862519582093285e-22,
  -9.802923466940811e-25,   6.064498108841535e-26,   8.565470199179543e-03,  -1.783356397758133e-04,   2.768754948538968e-06,  -3.835723303861411e-08,   4.868207510754837e-10,
  -6.101371586347679e-12,   7.469847062014379e-14,  -5.577704802598324e-16,   1.732371661384164e-17,  -5.612861266502590e-20,  -4.123397406103094e-21,  -1.855101096387513e-22,
  -9.593323199172301e-25,   6.072937744035960e-26,   8.565756846875196e-03,  -1.783475466716716e-04,   2.769057162040091e-06,  -3.836354363754486e-08,   4.869367615075362e-10,
  -6.102583360982670e-12,   7.474850392901154e-14,  -5.579863755222415e-16,   1.730448549069413e-17,  -5.717873072015619e-20,  -4.129792574149089e-21,  -1.850197177398390e-22,
  -9.454812281910355e-25,   6.078566392791129e-26,   8.565904058243548e-03,  -1.783536616862501e-04,   2.769212372473327e-06,  -3.836678459446531e-08,   4.869963484509281e-10,
  -6.103205727094770e-12,   7.477419120729158e-14,  -5.580977533514427e-16,   1.729460557033937e-17,  -5.771765522694368e-20,  -4.133064556051196e-21,  -1.847678185301313e-22,
  -9.383676964609151e-25,   6.081472932697017e-26,   8.565955297154967e-03,  -1.783557901134849e-04,   2.769266396373045e-06,  -3.836791266505967e-08,   4.870170898297421e-10,
  -6.103422357186716e-12,   7.478313075013078e-14,  -5.581365998422405e-16,   1.729116616670393e-17,  -5.790517530158734e-20,  -4.134201450191069e-21,  -1.846801332071978e-22,
  -9.358917135671545e-25,   6.082487113509034e-26,   8.565963428095229e-03,  -1.783561278674924e-04,   2.769274969292498e-06,  -3.836809167555456e-08,   4.870203812767387e-10,
  -6.103456733867652e-12,   7.478454927788249e-14,  -5.581427680625149e-16,   1.729062035192543e-17,  -5.793492942335167e-20,  -4.134381767101321e-21,  -1.846662183027953e-22,
  -9.354988066650614e-25,   6.082648170127828e-26,   7.728430173847368e-02,  -1.587396815917411e-03,   2.379199127778774e-05,  -3.083415512749367e-07,   3.478322784181582e-09,
  -3.655582841963515e-11,   3.394138006306032e-13,   4.377150005221988e-16,   7.875364262280174e-17,   7.204319878125077e-19,  -5.254912723000379e-20,  -1.582675390128295e-21,
  -1.195394478250999e-23,   5.825552933785758e-25,   7.728653616645435e-02,  -1.587483657494080e-03,   2.379395053945072e-05,  -3.083758147241509e-07,   3.478802466665319e-09,
  -3.655493176282930e-11,   3.396158984128833e-13,   4.399387331572385e-16,   7.852977170502987e-17,   7.124381525625062e-19,  -5.261775057634330e-20,  -1.578391807003334e-21,
  -1.183868590773908e-23,   5.829722057547704e-25,   7.729047899949426e-02,  -1.587636898657853e-03,   2.379740790745447e-05,  -3.084362724262251e-07,   3.479649103197706e-09,
  -3.655334614050626e-11,   3.399720240556962e-13,   4.438407330143974e-16,   7.813451727205281e-17,   6.983508860912971e-19,  -5.273825762479522e-20,  -1.570830768935106e-21,
  -1.163529876554404e-23,   5.837160419009928e-25,   7.729524697062494e-02,  -1.587822212870615e-03,   2.380158896893543e-05,  -3.085093773420234e-07,   3.480673255642171e-09,
  -3.655142291790148e-11,   3.404018377957220e-13,   4.485219165678296e-16,   7.765617942793752e-17,   6.813470806558872e-19,  -5.288298717541774e-20,  -1.561683435161460e-21,
  -1.138934198540286e-23,   5.846293530402435e-25,   7.729987590181905e-02,  -1.588002126691142e-03,   2.380564826399195e-05,  -3.085803450872524e-07,   3.481667893558875e-09,
  -3.654954976883650e-11,   3.408182373555862e-13,   4.530274619158975e-16,   7.719140861022054e-17,   6.648722053428035e-19,  -5.302245254445985e-20,  -1.552798665007240e-21,
  -1.115055159260264e-23,   5.855303570512021e-25,   7.730360510016199e-02,  -1.588147072949408e-03,   2.380891866090902e-05,  -3.086375148887733e-07,   3.482469453245835e-09,
  -3.654803642227621e-11,   3.411530696793825e-13,   4.566292532995021e-16,   7.681670366374932e-17,   6.516232841672063e-19,  -5.313406201272849e-20,  -1.545637815482553e-21,
  -1.095817094421133e-23,   5.862664016357866e-25,   7.730606938179620e-02,  -1.588242855762812e-03,   2.381107981884112e-05,  -3.086752912382303e-07,   3.482999252596861e-09,
  -3.654703430268828e-11,   3.413740202877848e-13,   4.589956450546521e-16,   7.656896302021667e-17,   6.428799091073690e-19,  -5.320744823475220e-20,  -1.540904380163122e-21,
  -1.083104227471028e-23,   5.867577267201721e-25,   7.730733493733714e-02,  -1.588292046338393e-03,   2.381218971950213e-05,  -3.086946910659461e-07,   3.483271374105171e-09,
  -3.654651901033028e-11,   3.414873960003557e-13,   4.602066947219180e-16,   7.644169244677037e-17,   6.383932554769662e-19,  -5.324502320615263e-20,  -1.538473014624843e-21,
  -1.076575346581242e-23,   5.870115714809749e-25,   7.730777543015131e-02,  -1.588309167810341e-03,   2.381257603738261e-05,  -3.087014433320949e-07,   3.483366095520918e-09,
  -3.654633955383361e-11,   3.415268426478763e-13,   4.606275423248760e-16,   7.639738777877553e-17,   6.368321899123512e-19,  -5.325808363012286e-20,  -1.537626672577726e-21,
  -1.074302875501279e-23,   5.871001666675438e-25,   7.730784533051362e-02,  -1.588311884763610e-03,   2.381263734103220e-05,  -3.087025148227159e-07,   3.483381126838889e-09,
  -3.654631107161226e-11,   3.415331015845629e-13,   4.606942932731580e-16,   7.639035690699385e-17,   6.365844966705008e-19,  -5.326015529028445e-20,  -1.537492365805900e-21,
  -1.073942264009733e-23,   5.871142369866356e-25,   2.158463469896204e-01,  -4.305327988037377e-03,   5.949608037144302e-05,  -6.480328095984282e-07,   4.873699883669435e-09,
  -1.380829739557150e-11,  -3.940962130813897e-13,   1.832717692667988e-14,   7.471536076256433e-17,   2.872445511285895e-18,  -1.419384247025008e-19,  -5.139591210769306e-21,
  -2.863180987124487e-23,   1.660448010676303e-24,   2.158519302331968e-01,  -4.305510291364765e-03,   5.949881870730193e-05,  -6.480454501552138e-07,   4.873147839173401e-09,
  -1.377207390779048e-11,  -3.939125730871297e-13,   1.833619485188747e-14,   7.411146409248468e-17,   2.846419493249208e-18,  -1.420994063665478e-19,  -5.127393672094750e-21,
  -2.828267215759532e-23,   1.661416697756008e-24,   2.158617821628126e-01,  -4.305831971296047e-03,   5.950365029211864e-05,  -6.480677269644900e-07,   4.872173952993357e-09,
  -1.370814289118643e-11,  -3.935898292680517e-13,   1.835203606003873e-14,   7.304534098253222e-17,   2.800547365696974e-18,  -1.423817048583899e-19,  -5.105864813027544e-21,
  -2.766662541065517e-23,   1.663152169782752e-24,   2.158736955768507e-01,  -4.306220954947785e-03,   5.950949226668022e-05,  -6.480946171640898e-07,   4.870996667977699e-09,
  -1.363081285439527e-11,  -3.932017674597479e-13,   1.837107034656277e-14,   7.175526042735448e-17,   2.745165601439264e-18,  -1.427200688054459e-19,  -5.079821363801400e-21,
  -2.692171548799229e-23,   1.665295102728501e-24,   2.158852612852209e-01,  -4.306598578608403e-03,   5.951516310485323e-05,  -6.481206723137384e-07,   4.869854143776729e-09,
  -1.355571719271411e-11,  -3.928273522034442e-13,   1.838942184027976e-14,   7.050192163089028e-17,   2.691493388938803e-18,  -1.430454110051215e-19,  -5.054527682141036e-21,
  -2.619859059334824e-23,   1.667421510204893e-24,   2.158945787361800e-01,  -4.306902790943702e-03,   5.951973113625439e-05,  -6.481416266087995e-07,   4.868934000825152e-09,
  -1.349520326115052e-11,  -3.925273828135150e-13,   1.840411489860276e-14,   6.949157057205505e-17,   2.648321289492386e-18,  -1.433052557925046e-19,  -5.034143337866408e-21,
  -2.561606507593340e-23,   1.669167260656447e-24,   2.159007356723705e-01,  -4.307103810808940e-03,   5.952274945234962e-05,  -6.481554555009330e-07,   4.868326113535522e-09,
  -1.345520802485881e-11,  -3.923299788328860e-13,   1.841377945211150e-14,   6.882361830663810e-17,   2.619826030616567e-18,  -1.434758565891832e-19,  -5.020669731218515e-21,
  -2.523114954358851e-23,   1.670336742532901e-24,   2.159038975940855e-01,  -4.307207044676301e-03,   5.952429945332706e-05,  -6.481625519378659e-07,   4.868013973455616e-09,
  -1.343466587018172e-11,  -3.922288531410368e-13,   1.841872895220238e-14,   6.848049103376679e-17,   2.605202278961078e-18,  -1.435631280758532e-19,  -5.013749146082015e-21,
  -2.503347912122225e-23,   1.670942227422722e-24,   2.159049981363232e-01,  -4.307242976256453e-03,   5.952483893759972e-05,  -6.481650210642215e-07,   4.867905336464815e-09,
  -1.342751555786400e-11,  -3.921936953345494e-13,   1.842044948895787e-14,   6.836104626204327e-17,   2.600113928833511e-18,  -1.435934495582756e-19,  -5.011340174389288e-21,
  -2.496467845569457e-23,   1.671153749953460e-24,   2.159051727775246e-01,  -4.307248678107506e-03,   5.952492454595541e-05,  -6.481654128400490e-07,   4.867888097565810e-09,
  -1.342638088150215e-11,  -3.921881181699407e-13,   1.842072241086840e-14,   6.834209125414747e-17,   2.599306552783001e-18,  -1.435982585889023e-19,  -5.010957894313384e-21,
  -2.495376075347746e-23,   1.671187352555970e-24,   4.262885536563379e-01,  -8.070168979614800e-03,   9.485623728950619e-05,  -6.382300265803364e-07,  -2.885894448106003e-09,
   1.414960595486578e-10,  -2.004166173914950e-12,   2.739658435879079e-14,   7.064157950019806e-16,  -3.025186608686283e-18,  -2.159358929839326e-19,  -1.116432765134993e-20,
  -8.967798519575817e-23,   4.246898388803890e-24,   4.262974431204002e-01,  -8.070348012522750e-03,   9.485459820254654e-05,  -6.380969225777766e-07,  -2.888691129188246e-09,
   1.415498075022005e-10,  -2.002331043008342e-12,   2.738491011486053e-14,   7.054882266905970e-16,  -3.081541779010192e-18,  -2.164571163999636e-19,  -1.113321870272312e-20,
  -8.895151529424992e-23,   4.247780576905348e-24,   4.263131285930151e-01,  -8.070663888396400e-03,   9.485170473390984e-05,  -6.378620175610608e-07,  -2.893623826528348e-09,
   1.416446272081009e-10,  -1.999094915135318e-12,   2.736415698583652e-14,   7.038497596599331e-16,  -3.180850895735310e-18,  -2.173731696180612e-19,  -1.107832040528350e-20,
  -8.766971858610541e-23,   4.249398615359178e-24,   4.263320954182181e-01,  -8.071045796851209e-03,   9.484820374924625e-05,  -6.375778981600991e-07,  -2.899584934070142e-09,
   1.417592509569356e-10,  -1.995185149505330e-12,   2.733880018288946e-14,   7.018655186039551e-16,  -3.300714063469649e-18,  -2.184746413235602e-19,  -1.101192620558071e-20,
  -8.611987437643521e-23,   4.251459202849521e-24,   4.263505078576657e-01,  -8.071416492478443e-03,   9.484480278082261e-05,  -6.373020069410055e-07,  -2.905368145168771e-09,
   1.418704906723583e-10,  -1.991393174914218e-12,   2.731391029389305e-14,   6.999361324068830e-16,  -3.416842151562089e-18,  -2.195374076627835e-19,  -1.094746046281277e-20,
  -8.461543264487507e-23,   4.253567689749234e-24,   4.263653405173545e-01,  -8.071715081007576e-03,   9.484206137679464e-05,  -6.370797002516377e-07,  -2.910024354476761e-09,
   1.419600786867444e-10,  -1.988340961211302e-12,   2.729366326398647e-14,   6.983796167096560e-16,  -3.510226467813450e-18,  -2.203888846615356e-19,  -1.089551931032225e-20,
  -8.340355771467524e-23,   4.255343120447571e-24,   4.263751415952595e-01,  -8.071912363867513e-03,   9.484024910892720e-05,  -6.369327783424774e-07,  -2.913099787737750e-09,
   1.420192644250037e-10,  -1.986325363072891e-12,   2.728018848068311e-14,   6.973500114519314e-16,  -3.571851404567799e-18,  -2.209492371829925e-19,  -1.086119332716991e-20,
  -8.260281243483918e-23,   4.256553686140190e-24,   4.263801748931733e-01,  -8.072013672141906e-03,   9.483931817625824e-05,  -6.368573189931470e-07,  -2.914678765821092e-09,
   1.420496552778211e-10,  -1.985290643848739e-12,   2.727323889368772e-14,   6.968209242588503e-16,  -3.603473472944219e-18,  -2.212362973498038e-19,  -1.084356397646368e-20,
  -8.219160362234270e-23,   4.257186882290615e-24,   4.263819267746961e-01,  -8.072048932473029e-03,   9.483899411739402e-05,  -6.368310534149313e-07,  -2.915228279288297e-09,
   1.420602324774681e-10,  -1.984930561953508e-12,   2.727081530909040e-14,   6.966367172426804e-16,  -3.614475797837659e-18,  -2.213360986099270e-19,  -1.083742770835712e-20,
  -8.204848055512730e-23,   4.257409100285726e-24,   4.263822047739808e-01,  -8.072054527757267e-03,   9.483894269185331e-05,  -6.368268853695587e-07,  -2.915315476454512e-09,
   1.420619109041616e-10,  -1.984873424840874e-12,   2.727043049568615e-14,   6.966074835935419e-16,  -3.616221524160870e-18,  -2.213519303471242e-19,  -1.083645395706145e-20,
  -8.202576898656264e-23,   4.257444449923003e-24,   7.107467598200788e-01,  -1.228563388383532e-02,   1.010914226520684e-04,   3.043206577977534e-07,  -2.243061741369439e-08,
   2.341801011691420e-10,   1.804897850249177e-12,  -5.780397118276552e-14,   1.958376271578832e-15,   1.639697703667335e-17,  -1.009416340945645e-18,  -1.713530642378381e-20,
  -1.056586378603163e-22,   5.731759270474961e-24,   7.107562118239459e-01,  -1.228554752406491e-02,   1.010788201502182e-04,   3.045392522796711e-07,  -2.242801967018964e-08,
   2.340671391775110e-10,   1.809950203080308e-12,  -5.775088568231980e-14,   1.954099800971183e-15,   1.631025509885839e-17,  -1.009988898258949e-18,  -1.709337268692070e-20,
  -1.039031631194792e-22,   5.731883585194122e-24,   7.107728890749351e-01,  -1.228539509107064e-02,   1.010565840390906e-04,   3.049248798458222e-07,  -2.242343016935321e-08,
   2.338678998241056e-10,   1.818856021997336e-12,  -5.765745223534488e-14,   1.946552008716798e-15,   1.615740869377219e-17,  -1.010990376643035e-18,  -1.701937694094049e-20,
  -1.008076720966674e-22,   5.732271905751303e-24,   7.107930537507133e-01,  -1.228521068253005e-02,   1.010296979466200e-04,   3.053910385046742e-07,  -2.241787071323566e-08,
   2.336271201953693e-10,   1.829609451116716e-12,  -5.754487486727227e-14,   1.937421931308750e-15,   1.597288498494636e-17,  -1.012186363692624e-18,  -1.692989468843268e-20,
  -9.706809154602147e-23,   5.733028181845624e-24,   7.108126275575638e-01,  -1.228503157298464e-02,   1.010035995431808e-04,   3.058434240975471e-07,  -2.241246345429412e-08,
   2.333935246314227e-10,   1.840032372942360e-12,  -5.743600867404424e-14,   1.928555278876411e-15,   1.579406652398013e-17,  -1.013331696509466e-18,  -1.684301992518290e-20,
  -9.344144237662266e-23,   5.734060836712708e-24,   7.108283947357059e-01,  -1.228488722096065e-02,   1.009825765506400e-04,   3.062077503455234e-07,  -2.240810010978305e-08,
   2.332054497029436e-10,   1.848417246867242e-12,  -5.734860952510628e-14,   1.921410050668740e-15,   1.565023766213910e-17,  -1.014243111384607e-18,  -1.677302916719604e-20,
  -9.052248036726475e-23,   5.735105337281707e-24,   7.108388128058305e-01,  -1.228479180452867e-02,   1.009686856872660e-04,   3.064484369423043e-07,  -2.240521330455425e-08,
   2.330812252509150e-10,   1.853952094377570e-12,  -5.729100549152057e-14,   1.916687459060131e-15,   1.555530826661633e-17,  -1.014839852173486e-18,  -1.672677754650451e-20,
  -8.859496049429049e-23,   5.735899117991220e-24,   7.108441627976798e-01,  -1.228474279398179e-02,   1.009615522980796e-04,   3.065720244230165e-07,  -2.240372968382986e-08,
   2.330174461464969e-10,   1.856792731824693e-12,  -5.726146873677479e-14,   1.914261827601670e-15,   1.550659154720521e-17,  -1.015144604904916e-18,  -1.670302415458145e-20,
  -8.760548120450925e-23,   5.736338691876694e-24,   7.108460248817819e-01,  -1.228472573387695e-02,   1.009590694938828e-04,   3.066150375345074e-07,  -2.240321311968677e-08,
   2.329952498058013e-10,   1.857781159645487e-12,  -5.725119546768332e-14,   1.913417508032723e-15,   1.548964067056539e-17,  -1.015250405936854e-18,  -1.669475640971667e-20,
  -8.726114658387375e-23,   5.736496763224035e-24,   7.108463203674810e-01,  -1.228472302660039e-02,   1.009586755088184e-04,   3.066218629974509e-07,  -2.240313113969995e-08,
   2.329917276737534e-10,   1.857937996137279e-12,  -5.724956558639620e-14,   1.913283523474162e-15,   1.548695105737643e-17,  -1.015267182241733e-18,  -1.669344442481769e-20,
  -8.720650839714756e-23,   5.736522087637803e-24,   1.068292201383373e+00,  -1.558806838782151e-02,   3.093679893864501e-05,   2.315275040232059e-06,  -2.435351923540533e-08,
  -5.191504159984090e-10,   1.241870384039894e-11,   1.198446399874591e-13,  -3.308287054279957e-15,   4.525618433985036e-17,   8.203632393432529e-19,  -7.717002546468489e-20,
  -8.686701731718910e-22,   3.829914973148851e-23,   1.068295074401949e+00,  -1.558741892481400e-02,   3.092319805787107e-05,   2.314790342514598e-06,  -2.433615726358598e-08,
  -5.189122251813943e-10,   1.241008714114733e-11,   1.199873250450189e-13,  -3.304992528844819e-15,   4.486888166082534e-17,   8.151617842000376e-19,  -7.689647459092270e-20,
  -8.649267292099214e-22,   3.817998475054229e-23,   1.068300142863515e+00,  -1.558627304758285e-02,   3.089920700535003e-05,   2.313935267984778e-06,  -2.430553161570478e-08,
  -5.184917102842663e-10,   1.239488977002914e-11,   1.202380401375233e-13,  -3.299196974567632e-15,   4.418662010290179e-17,   8.060025609252031e-19,  -7.641448736158687e-20,
  -8.583218178273106e-22,   3.797052285347861e-23,   1.068306269954252e+00,  -1.558488762891106e-02,   3.087021026194402e-05,   2.312901613537594e-06,  -2.426851550134093e-08,
  -5.179828393208888e-10,   1.237652473747945e-11,   1.205394108864857e-13,  -3.292219043167741e-15,   4.336356413779878e-17,   7.949592289329494e-19,  -7.583284944821723e-20,
  -8.503358527270885e-22,   3.771861085243717e-23,   1.068312216198811e+00,  -1.558354288561540e-02,   3.084207485186858e-05,   2.311898485315479e-06,  -2.423259842797190e-08,
  -5.174884398820005e-10,   1.235870859642307e-11,   1.208300977120644e-13,  -3.285476467606159e-15,   4.256658676903434e-17,   7.842721648935570e-19,  -7.526944345402163e-20,
  -8.425840034065954e-22,   3.747549055938732e-23,   1.068317005105948e+00,  -1.558245971914910e-02,   3.081941945021663e-05,   2.311090611674290e-06,  -2.420367665591219e-08,
  -5.170898751967090e-10,   1.234436494520961e-11,   1.210629270873808e-13,  -3.280067251560861e-15,   4.192600567325320e-17,   7.756868862821330e-19,  -7.481645503490310e-20,
  -8.363397695981007e-22,   3.728065832334713e-23,   1.068320168889135e+00,  -1.558174405119078e-02,   3.080445411772313e-05,   2.310556897488378e-06,  -2.418457180955987e-08,
  -5.168263726407760e-10,   1.233489121558498e-11,   1.212161192320706e-13,  -3.276503945916246e-15,   4.150343205642676e-17,   7.700256773828066e-19,  -7.451756007236076e-20,
  -8.322139594471396e-22,   3.715241584260070e-23,   1.068321793444876e+00,  -1.558137654283275e-02,   3.079677023504767e-05,   2.310282845081256e-06,  -2.417476245693473e-08,
  -5.166910088464320e-10,   1.233002732982392e-11,   1.212945875987755e-13,  -3.274677418860043e-15,   4.128664000318746e-17,   7.671220218710397e-19,  -7.436419646936397e-20,
  -8.300952407629212e-22,   3.708671128153613e-23,   1.068322358854811e+00,  -1.558124863158704e-02,   3.079409603313126e-05,   2.310187464262135e-06,  -2.417134852438569e-08,
  -5.166438874603208e-10,   1.232833462103854e-11,   1.213218669085516e-13,  -3.274042220513059e-15,   4.121121850964895e-17,   7.661119584393462e-19,  -7.431083805612007e-20,
  -8.293578143503544e-22,   3.706386671268950e-23,   1.068322448576082e+00,  -1.558122833399556e-02,   3.079367168569116e-05,   2.310172328907080e-06,  -2.417080679466582e-08,
  -5.166364096237037e-10,   1.232806602148927e-11,   1.213261942250934e-13,  -3.273941448966156e-15,   4.119925181701924e-17,   7.659517028397047e-19,  -7.430237181646613e-20,
  -8.292407955518747e-22,   3.706024275706033e-23,   1.482285502445206e+00,  -1.491921786606189e-02,  -1.465553756443581e-04,   2.259025308500582e-06,   6.411596976277222e-08,
  -6.242460926316114e-10,  -3.520701503438284e-11,   1.890833382987484e-13,   2.487449769625604e-14,   1.379474065850833e-16,  -1.408814057044952e-17,  -2.417678155742385e-19,
   5.358918064947749e-21,   1.747611471896115e-22,   1.482271834746328e+00,  -1.491858456585045e-02,  -1.465195852696878e-04,   2.258443272982820e-06,   6.406721608070872e-08,
  -6.238669936633496e-10,  -3.514292245598781e-11,   1.895178279294493e-13,   2.481610344656231e-14,   1.367479382112140e-16,  -1.405568682705113e-17,  -2.405472927275339e-19,
   5.343646097014407e-21,   1.737090440935751e-22,   1.482247720571586e+00,  -1.491746723017603e-02,  -1.464564547078731e-04,   2.257416553167224e-06,   6.398126224458587e-08,
  -6.231973873445971e-10,  -3.502995408361138e-11,   1.902812349861388e-13,   2.471317656718003e-14,   1.346365155735400e-16,  -1.399849799437121e-17,  -2.383998080752639e-19,
   5.316744978867370e-21,   1.718606031308259e-22,   1.482218566047818e+00,  -1.491611636183724e-02,  -1.463801542472841e-04,   2.256175529142545e-06,   6.387744998583541e-08,
  -6.223865359296672e-10,  -3.489356277365300e-11,   1.911988113913395e-13,   2.458890484690955e-14,   1.320919678956002e-16,  -1.392947459687101e-17,  -2.358134957261949e-19,
   5.284295401288385e-21,   1.696390658536582e-22,   1.482190268150143e+00,  -1.491480519873550e-02,  -1.463061225199059e-04,   2.254971284921714e-06,   6.377680061040990e-08,
  -6.215981690592592e-10,  -3.476137746736952e-11,   1.920837855375804e-13,   2.446846124472369e-14,   1.296307561098816e-16,  -1.386260375300889e-17,  -2.333136494748650e-19,
   5.252877511181106e-21,   1.674966410421115e-22,   1.482167475176632e+00,  -1.491374911219990e-02,  -1.462465117606511e-04,   2.254001534627676e-06,   6.369581167418847e-08,
  -6.209622097903831e-10,  -3.465504891639610e-11,   1.927925668937978e-13,   2.437157460138125e-14,   1.276544623129297e-16,  -1.380883067912692e-17,  -2.313075874649870e-19,
   5.227627776392659e-21,   1.657808708662182e-22,   1.482152415672060e+00,  -1.491305135196046e-02,  -1.462071358505264e-04,   2.253360923757421e-06,   6.364234107511004e-08,
  -6.205415588636415e-10,  -3.458486631085649e-11,   1.932588922138644e-13,   2.430762268265342e-14,   1.263517028179158e-16,  -1.377334592650020e-17,  -2.299858158704507e-19,
   5.210972716813134e-21,   1.646520694900810e-22,   1.482144682417303e+00,  -1.491269304433413e-02,  -1.461869187081030e-04,   2.253031995997661e-06,   6.361489541151398e-08,
  -6.203254047544502e-10,  -3.454884811111659e-11,   1.934977471245622e-13,   2.427480165274349e-14,   1.256836432898955e-16,  -1.375513749667620e-17,  -2.293081951393744e-19,
   5.202428692569016e-21,   1.640739031892816e-22,   1.482141990870168e+00,  -1.491256833616562e-02,  -1.461798826264118e-04,   2.252917518687706e-06,   6.360534493267725e-08,
  -6.202501497081917e-10,  -3.453631545484813e-11,   1.935807832550370e-13,   2.426338138890455e-14,   1.254512733287327e-16,  -1.374880222323818e-17,  -2.290725294384138e-19,
   5.199456324287972e-21,   1.638729099548084e-22,   1.482141563762646e+00,  -1.491254854689057e-02,  -1.461787661294225e-04,   2.252899353142962e-06,   6.360382950934069e-08,
  -6.202382067899410e-10,  -3.453432687565664e-11,   1.935939552226580e-13,   2.426156931151921e-14,   1.254144067377029e-16,  -1.374779701353144e-17,  -2.290351413818817e-19,
   5.198984719606921e-21,   1.638410266191535e-22,   1.869725763401480e+00,  -6.111504575147265e-03,  -1.869424535192617e-04,  -4.025888791150647e-06,  -4.581583228649592e-08,
   7.161824933225216e-10,   5.456666658391781e-11,   1.491086039402969e-12,   1.660122241997886e-14,  -4.325269526555190e-16,  -2.712055241525607e-17,  -6.750874124614310e-19,
  -5.454187708256093e-21,   2.721445205168279e-22,   1.869708186732492e+00,  -6.112634397717361e-03,  -1.869677887483054e-04,  -4.025192923454516e-06,  -4.573861462262915e-08,
   7.190932436541752e-10,   5.460786086607293e-11,   1.489538062408865e-12,   1.648592420635844e-14,  -4.359234502452964e-16,  -2.714887792182390e-17,  -6.729419413678689e-19,
  -5.337242763058038e-21,   2.749870590056462e-22,   1.869677170544218e+00,  -6.114627824088309e-03,  -1.870124577338958e-04,  -4.023962843117055e-06,  -4.560231668025082e-08,
   7.242267874846670e-10,   5.468030224255206e-11,   1.486797375639930e-12,   1.628238630932274e-14,  -4.419074718220330e-16,  -2.719826989440834e-17,  -6.691395657021691e-19,
  -5.130839779267088e-21,   2.799849614033856e-22,   1.869639662235412e+00,  -6.117038017723338e-03,  -1.870664115325360e-04,  -4.022471648501839e-06,  -4.543742523927409e-08,
   7.304300150606141e-10,   5.476747855523750e-11,   1.483467541330411e-12,   1.603610996874356e-14,  -4.491277625379361e-16,  -2.725699103873801e-17,  -6.645133621342280e-19,
  -4.881170974944949e-21,   2.859980173039558e-22,   1.869603246467190e+00,  -6.119377499555463e-03,  -1.871187256613376e-04,  -4.021020078136625e-06,  -4.527726951170745e-08,
   7.364474763507671e-10,   5.485166722483605e-11,   1.480218507448384e-12,   1.579686741747507e-14,  -4.561206446191226e-16,  -2.731294477832408e-17,  -6.599927503579146e-19,
  -4.638714089916453e-21,   2.918033519780693e-22,   1.869573907998356e+00,  -6.121261945863034e-03,  -1.871608238871057e-04,  -4.019847886954177e-06,  -4.514819158248294e-08,
   7.412918139420172e-10,   5.491917272863583e-11,   1.477589329859209e-12,   1.560402208643488e-14,  -4.617421897790800e-16,  -2.735726669565380e-17,  -6.563298813307963e-19,
  -4.443338468877809e-21,   2.964570040700351e-22,   1.869554520486600e+00,  -6.122507051548709e-03,  -1.871886194321215e-04,  -4.019071941209251e-06,  -4.506287058508900e-08,
   7.444912705061777e-10,   5.496362449576775e-11,   1.475846245818356e-12,   1.547653769757378e-14,  -4.654509974147223e-16,  -2.738618475499844e-17,  -6.538992071937169e-19,
  -4.314212082157542e-21,   2.995207298067520e-22,   1.869544563708669e+00,  -6.123146441056148e-03,  -1.872028869039157e-04,  -4.018673028435179e-06,  -4.501904534026448e-08,
   7.461338503638509e-10,   5.498640476305479e-11,   1.474949305590645e-12,   1.541105126720606e-14,  -4.673538473835477e-16,  -2.740092141262206e-17,  -6.526477552765791e-19,
  -4.247891893625241e-21,   3.010905890748448e-22,   1.869541098103154e+00,  -6.123368981358499e-03,  -1.872078517342358e-04,  -4.018534115140722e-06,  -4.500379015801751e-08,
   7.467054865827574e-10,   5.499432602630640e-11,   1.474636833568494e-12,   1.538825540311760e-14,  -4.680158648207593e-16,  -2.740603246763831e-17,  -6.522116695192563e-19,
  -4.224807361910918e-21,   3.016364333630162e-22,   1.869540548156545e+00,  -6.123404295198818e-03,  -1.872086395324980e-04,  -4.018512068283655e-06,  -4.500136930404612e-08,
   7.467961936384095e-10,   5.499558266005080e-11,   1.474587235093353e-12,   1.538463788486815e-14,  -4.681209042429979e-16,  -2.740684265890009e-17,  -6.521424446825983e-19,
  -4.221144109087287e-21,   3.017230247529355e-22,   7.891781319318628e-03,  -1.578265333502466e-04,   2.349623495731464e-06,  -3.141520252470865e-08,   3.809616026241328e-10,
  -4.435343476394433e-12,   6.598304864042056e-14,  -7.261133544131314e-17,   1.077560895852419e-17,  -3.780817209542703e-19,  -1.202657460718984e-20,  -1.289875125926662e-22,
   4.394221996191124e-24,   1.551269253248648e-25,   7.892002027333525e-03,  -1.578353835101571e-04,   2.349838311955398e-06,  -3.141936204656108e-08,   3.810547118788202e-10,
  -4.435507016535110e-12,   6.601030811487313e-14,  -7.390336531142179e-17,   1.072577525484117e-17,  -3.787024987957602e-19,  -1.199860209752390e-20,  -1.278492018335378e-22,
   4.411194542692549e-24,   1.552054998778669e-25,   7.892391486539729e-03,  -1.578510007081392e-04,   2.350217401222902e-06,  -3.142670171942425e-08,   3.812190353885916e-10,
  -4.435797661519799e-12,   6.605830208529371e-14,  -7.618484312225604e-17,   1.063793952784845e-17,  -3.797930955147777e-19,  -1.194915929590625e-20,  -1.258402327220036e-22,
   4.441097204860264e-24,   1.553393140549766e-25,   7.892862452810007e-03,  -1.578698868133695e-04,   2.350675872765558e-06,  -3.143557715492760e-08,   3.814177895069573e-10,
  -4.436152653814167e-12,   6.611615664938149e-14,  -7.894647030745850e-17,   1.053189258416518e-17,  -3.811037129625834e-19,  -1.188922798783315e-20,  -1.234103003626394e-22,
   4.477176942269791e-24,   1.554928708577611e-25,   7.893319688075691e-03,  -1.578882228165765e-04,   2.351121025198239e-06,  -3.144419351072781e-08,   3.816107913056787e-10,
  -4.436500984872834e-12,   6.617213227587256e-14,  -8.163037256888719e-17,   1.042911704033261e-17,  -3.823675083225977e-19,  -1.183089655668655e-20,  -1.210506925134372e-22,
   4.512118622245282e-24,   1.556332812929535e-25,   7.893688051900181e-03,  -1.579029952797827e-04,   2.351479688811255e-06,  -3.145113490544771e-08,   3.817663101925604e-10,
  -4.436784256151653e-12,   6.621709052159789e-14,  -8.379460379439645e-17,   1.034644652629767e-17,  -3.833794932669457e-19,  -1.178379736242203e-20,  -1.191493597721154e-22,
   4.540206153071198e-24,   1.557401770615604e-25,   7.893931470456131e-03,  -1.579127572564251e-04,   2.351716714075563e-06,  -3.145572173931894e-08,   3.818690934404397e-10,
  -4.436972739974352e-12,   6.624673208595806e-14,  -8.522572127153821e-17,   1.029188017141122e-17,  -3.840452018599993e-19,  -1.175262216092391e-20,  -1.178927733122977e-22,
   4.558735641672067e-24,   1.558077629416750e-25,   7.894056480718205e-03,  -1.579177706828813e-04,   2.351838446159794e-06,  -3.145807732401402e-08,   3.819218834684284e-10,
  -4.437069938603414e-12,   6.626193403401092e-14,  -8.596098704450314e-17,   1.026387657042083e-17,  -3.843861493795091e-19,  -1.173659585874865e-20,  -1.172473896474810e-22,
   4.568241986757452e-24,   1.558415275764590e-25,   7.894099992192030e-03,  -1.579195156812209e-04,   2.351880817443122e-06,  -3.145889721099050e-08,   3.819402584617706e-10,
  -4.437103833673487e-12,   6.626722196236388e-14,  -8.621695366943399e-17,   1.025413266027273e-17,  -3.845046719074453e-19,  -1.173101515661381e-20,  -1.170227475199575e-22,
   4.571549248360171e-24,   1.558531292972946e-25,   7.894106896887760e-03,  -1.579197925898182e-04,   2.351887541244745e-06,  -3.145902731595923e-08,   3.819431743647944e-10,
  -4.437109215402192e-12,   6.626806092955169e-14,  -8.625757445034048e-17,   1.025258657835723e-17,  -3.845234728036376e-19,  -1.173012945259434e-20,  -1.169870994156374e-22,
   4.572073993456795e-24,   1.558549631902305e-25,   7.129321846828325e-02,  -1.410967823654316e-03,   2.040314253649468e-05,  -2.580852962765529e-07,   2.831167672351700e-09,
  -2.797207624921004e-11,   3.871418637621947e-13,   2.826094694961524e-15,   4.950949877411482e-17,  -2.805785612776381e-18,  -1.204756459017763e-19,  -1.096664295424762e-21,
   3.961374832943160e-23,   1.448756318278500e-24,   7.129513446231704e-02,  -1.411040502200742e-03,   2.040473814687556e-05,  -2.581114747063924e-07,   2.831713488594946e-09,
  -2.796666545638992e-11,   3.872615222064304e-13,   2.816490213350848e-15,   4.900939008565536e-17,  -2.811026383959577e-18,  -1.202233764997565e-19,  -1.086032337076030e-21,
   3.976886233909114e-23,   1.449508544540574e-24,   7.129851538596672e-02,  -1.411168750619268e-03,   2.040755387647031e-05,  -2.581576628816073e-07,   2.832676722716970e-09,
  -2.795713346587640e-11,   3.874715990784926e-13,   2.799528878606749e-15,   4.812781194976341e-17,  -2.820229201788024e-18,  -1.197774673846680e-19,  -1.067268205312201e-21,
   4.004216128405197e-23,   1.450791586409175e-24,   7.130260384306127e-02,  -1.411323840173017e-03,   2.041095911305131e-05,  -2.582135071746404e-07,   2.833841701271823e-09,
  -2.794563362026916e-11,   3.877238161869021e-13,   2.778995134777103e-15,   4.706328606541145e-17,  -2.831281281391365e-18,  -1.192369479796218e-19,  -1.044571992469918e-21,
   4.037194201768821e-23,   1.452267428559577e-24,   7.130657306436840e-02,  -1.411474409103351e-03,   2.041426530421680e-05,  -2.582677125884632e-07,   2.834972877437729e-09,
  -2.793449737064838e-11,   3.879667703165510e-13,   2.759036393473472e-15,   4.603142310627244e-17,  -2.841930780651294e-18,  -1.187108392634402e-19,  -1.022532406166098e-21,
   4.069134720998605e-23,   1.453620783985811e-24,   7.130977077359525e-02,  -1.411595713124461e-03,   2.041692904873176e-05,  -2.583113745710421e-07,   2.835884305987046e-09,
  -2.792554594268138e-11,   3.881611352040615e-13,   2.742940098333896e-15,   4.520128733575011e-17,  -2.850452787978548e-18,  -1.182860241687790e-19,  -1.004773111406585e-21,
   4.094811695540405e-23,   1.454654043864051e-24,   7.131188383935236e-02,  -1.411675872405557e-03,   2.041868936030432e-05,  -2.583402230912066e-07,   2.836486643565877e-09,
  -2.791964069367379e-11,   3.882889046898115e-13,   2.732295271935856e-15,   4.465329725560355e-17,  -2.856056022005992e-18,  -1.180048303414921e-19,  -9.930359531600542e-22,
   4.111751851493343e-23,   1.455308854096725e-24,   7.131296902337371e-02,  -1.411717039189979e-03,   2.041959341297318e-05,  -2.583550374017365e-07,   2.836795997976091e-09,
  -2.791661106522339e-11,   3.883543153805970e-13,   2.726825965961093e-15,   4.437204800569853e-17,  -2.858924904228869e-18,  -1.178602744207835e-19,  -9.870077153625281e-22,
   4.120443091950747e-23,   1.455636476748653e-24,   7.131334673537514e-02,  -1.411731367850658e-03,   2.041990808449699e-05,  -2.583601935332764e-07,   2.836903675624524e-09,
  -2.791555705291988e-11,   3.883770495345667e-13,   2.724921898121917e-15,   4.427418368571708e-17,  -2.859922068352579e-18,  -1.178099366287761e-19,  -9.849094304940560e-22,
   4.123466823503866e-23,   1.455749130233370e-24,   7.131340667324657e-02,  -1.411733641620522e-03,   2.041995801890027e-05,  -2.583610117344118e-07,   2.836920762774763e-09,
  -2.791538981835984e-11,   3.883806555825442e-13,   2.724619728576278e-15,   4.425865525068490e-17,  -2.860080239212556e-18,  -1.178019475857440e-19,  -9.845764567904516e-22,
   4.123946584583604e-23,   1.455766941326215e-24,   1.995295625359927e-01,  -3.859162712168831e-03,   5.217727386064174e-05,  -5.725967546205718e-07,   4.546139927639840e-09,
  -1.679331719316241e-11,   1.576538859639916e-13,   2.082551686291902e-14,   2.055549587632460e-17,  -7.336263977956810e-18,  -3.569090034836955e-19,  -3.445524452320735e-21,
   1.211412154946837e-22,   4.224891472172689e-24,   1.995344592818017e-01,  -3.859323808869226e-03,   5.217983231212343e-05,  -5.726121573816045e-07,   4.546361857923091e-09,
  -1.675271860940899e-11,   1.576773368795220e-13,   2.080033015857289e-14,   1.907466928134413e-17,  -7.352822724388260e-18,  -3.561384525794420e-19,  -3.414514868567570e-21,
   1.215957890138089e-22,   4.227163534596663e-24,   1.995430998620988e-01,  -3.859608069998499e-03,   5.218434684160837e-05,  -5.726393049764236e-07,   4.546753472243098e-09,
  -1.668112229056860e-11,   1.577155712540889e-13,   2.075584327465591e-14,   1.646438870974801e-17,  -7.381910790568582e-18,  -3.547765284608847e-19,  -3.359786184246867e-21,
   1.223968416989232e-22,   4.231045203715557e-24,   1.995535484770951e-01,  -3.859951807500161e-03,   5.218980603212850e-05,  -5.726720796098709e-07,   4.547227039320906e-09,
  -1.659461639640035e-11,   1.577564458598169e-13,   2.070197354607657e-14,   1.331255253365665e-17,  -7.416862524469995e-18,  -3.531258001125459e-19,  -3.293588100451460e-21,
   1.233636650517270e-22,   4.235521252306583e-24,   1.995636921603697e-01,  -3.860285508096301e-03,   5.219510590119286e-05,  -5.727038416767503e-07,   4.547686790851265e-09,
  -1.651071043523161e-11,   1.577905195193329e-13,   2.064959877209956e-14,   1.025756868956296e-17,  -7.450560687426158e-18,  -3.515192484710990e-19,  -3.229304316212079e-21,
   1.243002999300944e-22,   4.239637980871851e-24,   1.995718640295531e-01,  -3.860554337380397e-03,   5.219937553676629e-05,  -5.727293894109916e-07,   4.548057173410973e-09,
  -1.644316884692250e-11,   1.578139551573028e-13,   2.060734997082644e-14,   7.799931719687205e-18,  -7.477540966444925e-18,  -3.502221307920515e-19,  -3.177504398391556e-21,
   1.250534247162009e-22,   4.242790223250252e-24,   1.995772639774697e-01,  -3.860731977146451e-03,   5.220219689953295e-05,  -5.727462516279446e-07,   4.548301920940290e-09,
  -1.639856402829581e-11,   1.578274772383379e-13,   2.057940520689766e-14,   6.177644604768548e-18,  -7.495287509633940e-18,  -3.493635997652910e-19,  -3.143269399857089e-21,
   1.255503724374889e-22,   4.244792645005469e-24,   1.995800371469373e-01,  -3.860823204334984e-03,   5.220364582399223e-05,  -5.727549052251788e-07,   4.548427611966882e-09,
  -1.637566519700848e-11,   1.578338144631419e-13,   2.056504574513942e-14,   5.345041157734722e-18,  -7.504375988088919e-18,  -3.489222645417315e-19,  -3.125686109471120e-21,
   1.258053590327784e-22,   4.245796048612676e-24,   1.995810023799897e-01,  -3.860854956899846e-03,   5.220415013855243e-05,  -5.727579162405688e-07,   4.548471360095238e-09,
  -1.636769630348869e-11,   1.578359235823539e-13,   2.056004645330006e-14,   5.055328503244973e-18,  -7.507535300894951e-18,  -3.487685839991879e-19,  -3.119565772543098e-21,
   1.258940742578266e-22,   4.246141319693485e-24,   1.995811555494676e-01,  -3.860859995599639e-03,   5.220423016647634e-05,  -5.727583940022232e-07,   4.548478302330589e-09,
  -1.636643180939417e-11,   1.578362536846831e-13,   2.055925307049718e-14,   5.009359016999352e-18,  -7.508036449700765e-18,  -3.487441937016539e-19,  -3.118594544639779e-21,
   1.259081504674733e-22,   4.246195920801239e-24,   3.954762278316446e-01,  -7.342539516439771e-03,   8.700617181329016e-05,  -6.640736975511512e-07,  -4.623595853634706e-10,
   1.049708332989394e-10,  -9.546235534260796e-13,   4.559331030008556e-14,   3.190279861347750e-16,  -2.178565000780971e-17,  -7.015438175705364e-19,  -8.136841872974360e-21,
   2.598880859263345e-22,   9.413572211480816e-24,   3.954843841068930e-01,  -7.342725937387393e-03,   8.700590421517168e-05,  -6.639745440636826e-07,  -4.636929193976440e-10,
   1.050594070644720e-10,  -9.538459682031544e-13,   4.551877100664948e-14,   3.161216282481462e-16,  -2.182491461726327e-17,  -6.998934858135236e-19,  -8.067724455186884e-21,
   2.608030478529775e-22,   9.419047090044467e-24,   3.954987759618070e-01,  -7.343054857286125e-03,   8.700543142643199e-05,  -6.637995190293881e-07,  -4.660447427976968e-10,
   1.052155770677662e-10,  -9.524800769548162e-13,   4.538713949088150e-14,   3.109990114592851e-16,  -2.189390762638882e-17,  -6.969768661531520e-19,  -7.945736713495709e-21,
   2.624157983876786e-22,   9.428442909952859e-24,   3.955161787105776e-01,  -7.343452551862474e-03,   8.700485868940435e-05,  -6.635877624614419e-07,  -4.688871218769424e-10,
   1.054042151221450e-10,  -9.508389388502633e-13,   4.522778947147585e-14,   3.048144138241073e-16,  -2.197684013817409e-17,  -6.934422498538987e-19,  -7.798179521451284e-21,
   2.643629664055245e-22,   9.439351992203446e-24,   3.955330729601456e-01,  -7.343838586145567e-03,   8.700430160183159e-05,  -6.633820731047018e-07,  -4.716449201026837e-10,
   1.055871275074652e-10,  -9.492567479623832e-13,   4.507290765877052e-14,   2.988207114482736e-16,  -2.205683157694032e-17,  -6.900027365480787e-19,  -7.654884350927311e-21,
   2.662500333328698e-22,   9.449467121569099e-24,   3.955466827208625e-01,  -7.344149541153445e-03,   8.700385204260659e-05,  -6.632162866926247e-07,  -4.738654715746157e-10,
   1.057343257902209e-10,  -9.479900277454679e-13,   4.494800298043525e-14,   2.939995792042887e-16,  -2.212090042163119e-17,  -6.872260621477136e-19,  -7.539413352296117e-21,
   2.677678722483608e-22,   9.457274251254578e-24,   3.955556757950493e-01,  -7.344355000387061e-03,   8.700355460167019e-05,  -6.631066960265503e-07,  -4.753322380736688e-10,
   1.058315165668478e-10,  -9.471568529782317e-13,   4.486540282912962e-14,   2.908174471202845e-16,  -2.216305418801376e-17,  -6.853884246122804e-19,  -7.463095789248572e-21,
   2.687696555654837e-22,   9.462265464604970e-24,   3.955602941648484e-01,  -7.344460509112374e-03,   8.700340173395417e-05,  -6.630504030046580e-07,  -4.760853279700300e-10,
   1.058814054078354e-10,  -9.467301682965784e-13,   4.482296352667130e-14,   2.891843799357244e-16,  -2.218464593980994e-17,  -6.844438256726803e-19,  -7.423898086661197e-21,
   2.692837501064532e-22,   9.464776775803479e-24,   3.955619016300980e-01,  -7.344497231686378e-03,   8.700334850823126e-05,  -6.630308076382823e-07,  -4.763474215884781e-10,
   1.058987659699020e-10,  -9.465818462454664e-13,   4.480818893107426e-14,   2.886161527183222e-16,  -2.219215219528916e-17,  -6.841149086517793e-19,  -7.410254181667304e-21,
   2.694626262145462e-22,   9.465642588160133e-24,   3.955621567126637e-01,  -7.344503059019695e-03,   8.700334006115368e-05,  -6.630276980255064e-07,  -4.763890109921932e-10,
   1.059015206760609e-10,  -9.465583185717882e-13,   4.480584425402676e-14,   2.885259912780843e-16,  -2.219334290969058e-17,  -6.840627073714778e-19,  -7.408089044707140e-21,
   2.694910085698505e-22,   9.465779587783729e-24,   6.632366879211508e-01,  -1.146802719366629e-02,   1.027509262936616e-04,  -1.516575365234839e-08,  -1.740716168394998e-08,
   2.653864460499514e-10,   1.088177741028603e-12,   5.008470382372510e-15,   1.637102744046453e-15,  -3.905599607561740e-17,  -1.716648087521124e-18,  -1.027656334289752e-20,
   4.899049155572322e-22,   1.725077701788274e-23,   6.632463011638891e-01,  -1.146803058243966e-02,   1.027411437242351e-04,  -1.491689136650161e-08,  -1.740558258576200e-08,
   2.653941874549859e-10,   1.092327944834192e-12,   4.875423299267697e-15,   1.629961327850880e-15,  -3.910405889680634e-17,  -1.713530303773920e-18,  -1.015002715009010e-20,
   4.917741687852582e-22,   1.725850745336165e-23,   6.632632631376506e-01,  -1.146803650506935e-02,   1.027238829598959e-04,  -1.447776469513420e-08,  -1.740279155504341e-08,
   2.654076337322852e-10,   1.099635865406847e-12,   4.640531369045967e-15,   1.617370955986220e-15,  -3.918833568787875e-17,  -1.708019540301230e-18,  -9.926712207840228e-21,
   4.950709274804257e-22,   1.727169577067645e-23,   6.632837724685321e-01,  -1.146804356973233e-02,   1.027030123110310e-04,  -1.394675918723794e-08,  -1.739940863078378e-08,
   2.654235288501203e-10,   1.108446814837987e-12,   4.356279842854561e-15,   1.602164928473652e-15,  -3.928933889907689e-17,  -1.701339870214161e-18,  -9.656611325319624e-21,
   4.990545957416531e-22,   1.728686952331263e-23,   6.633036812430816e-01,  -1.146805032636040e-02,   1.026827527590932e-04,  -1.343125911211617e-08,  -1.739611620490117e-08,
   2.654385779263500e-10,   1.116973265392007e-12,   4.080106687715183e-15,   1.587422460514778e-15,  -3.938644303669716e-17,  -1.694838619414441e-18,  -9.394335259417827e-21,
   5.029187612062102e-22,   1.730078626192097e-23,   6.633197185408770e-01,  -1.146805569659797e-02,   1.026664328693609e-04,  -1.301597252164546e-08,  -1.739345790336401e-08,
   2.654504277077036e-10,   1.123822684182225e-12,   3.857463657919696e-15,   1.575559954131465e-15,  -3.946398951624787e-17,  -1.689589306184072e-18,  -9.183002889902867e-21,
   5.060293337455838e-22,   1.731141198510438e-23,   6.633303152354205e-01,  -1.146805920950332e-02,   1.026556494386262e-04,  -1.274155543115372e-08,  -1.739169842821581e-08,
   2.654581238410635e-10,   1.128339175439896e-12,   3.710266384392369e-15,   1.567728202759677e-15,  -3.951489818490139e-17,  -1.686114785306862e-18,  -9.043336294546738e-21,
   5.080835461894353e-22,   1.731814566538347e-23,   6.633357570009452e-01,  -1.146806100252255e-02,   1.026501117738632e-04,  -1.260062817180513e-08,  -1.739079395239214e-08,
   2.654620347253103e-10,   1.130655678434907e-12,   3.634649271929403e-15,   1.563708322645675e-15,  -3.954093933547027e-17,  -1.684328638330094e-18,  -8.971604178399771e-21,
   5.091381016297842e-22,   1.732151458113896e-23,   6.633376510343206e-01,  -1.146806162484400e-02,   1.026481843616878e-04,  -1.255157699766751e-08,  -1.739047899791633e-08,
   2.654633893447998e-10,   1.131461491947217e-12,   3.608326186616544e-15,   1.562309500866373e-15,  -3.954998681605652e-17,  -1.683706664734544e-18,  -8.946636114881233e-21,
   5.095050877460162e-22,   1.732267295187559e-23,   6.633379515902428e-01,  -1.146806172351451e-02,   1.026478785090010e-04,  -1.254379324472561e-08,  -1.739042901217346e-08,
   2.654636039909338e-10,   1.131589341306424e-12,   3.604148892547290e-15,   1.562087542988623e-15,  -3.955142174897982e-17,  -1.683607952382404e-18,  -8.942673977786530e-21,
   5.095633204473813e-22,   1.732285609433585e-23,   1.006600623869904e+00,  -1.523674398873112e-02,   5.609462217566116e-05,   1.859694487149551e-06,  -3.153940081424345e-08,
  -1.912381971987886e-10,   1.454157546556834e-11,   3.931595605983769e-14,  -1.961935539679649e-15,   5.646757930200186e-18,  -2.713756200335411e-18,  -6.495309748782060e-20,
   1.436186904891847e-21,   4.592342875679835e-23,   1.006605847350320e+00,  -1.523622157974326e-02,   5.607699632884284e-05,   1.859515853875349e-06,  -3.151901574040790e-08,
  -1.911606421167528e-10,   1.453619572126108e-11,   3.932667600423264e-14,  -1.973098374774813e-15,   5.324918637657985e-18,  -2.704867878201209e-18,  -6.461709360829579e-20,
   1.436204976929093e-21,   4.592808349798145e-23,   1.006615062934112e+00,  -1.523529982158418e-02,   5.604590455155842e-05,   1.859200711799432e-06,  -3.148305219699212e-08,
  -1.910237818783416e-10,   1.452667942803738e-11,   3.934471803944641e-14,  -1.992764885077222e-15,   4.758436815211046e-18,  -2.689184023632104e-18,  -6.402419311510194e-20,
   1.436253271437880e-21,   4.593546165091346e-23,   1.006626204249943e+00,  -1.523418529118845e-02,   5.600832390898748e-05,   1.858819739488604e-06,  -3.143957535425480e-08,
  -1.908582676693388e-10,   1.451513194434354e-11,   3.936504796026274e-14,  -2.016493854284078e-15,   4.075842875364065e-18,  -2.670218423551307e-18,  -6.330722705345790e-20,
   1.436339322078503e-21,   4.594295288280066e-23,   1.006637017673601e+00,  -1.523310339705555e-02,   5.597185788463156e-05,   1.858450003783383e-06,  -3.139737997254684e-08,
  -1.906975681965064e-10,   1.450387972284387e-11,   3.938323041511421e-14,  -2.039475087266023e-15,   3.415707805814594e-18,  -2.651806338322274e-18,  -6.261118762225656e-20,
   1.436451406264082e-21,   4.594871910228596e-23,   1.006645727127342e+00,  -1.523223188927992e-02,   5.594249323093734e-05,   1.858152225187184e-06,  -3.136339595204247e-08,
  -1.905680964932795e-10,   1.449478493776581e-11,   3.939676728259729e-14,  -2.057949463026832e-15,   2.885713808233959e-18,  -2.636973317365968e-18,  -6.205045524972834e-20,
   1.436561865816578e-21,   4.595227946317285e-23,   1.006651481347163e+00,  -1.523165603795768e-02,   5.592309541735432e-05,   1.857955495451748e-06,  -3.134094385519089e-08,
  -1.904825372410388e-10,   1.448876052377606e-11,   3.940516934560224e-14,  -2.070137902333971e-15,   2.536385641218869e-18,  -2.627171664832784e-18,  -6.167992864797874e-20,
   1.436644613084061e-21,   4.595409864306945e-23,   1.006654436157085e+00,  -1.523136031863270e-02,   5.591313551366152e-05,   1.857854476779695e-06,  -3.132941484859940e-08,
  -1.904385964854571e-10,   1.448566214327574e-11,   3.940931652807745e-14,  -2.076391342459091e-15,   2.357261811743907e-18,  -2.622137963851675e-18,  -6.148964434457937e-20,
   1.436690100632013e-21,   4.595486742294057e-23,   1.006655464564781e+00,  -1.523125739206835e-02,   5.590966916479582e-05,   1.857819318130301e-06,  -3.132540226653784e-08,
  -1.904233021934565e-10,   1.448458299860845e-11,   3.941073331644715e-14,  -2.078566969206697e-15,   2.294959568489458e-18,  -2.620385924486970e-18,  -6.142341398894386e-20,
   1.436706407256713e-21,   4.595510862006392e-23,   1.006655627756975e+00,  -1.523124105909969e-02,   5.590911911658642e-05,   1.857813739023471e-06,  -3.132476553425169e-08,
  -1.904208751853852e-10,   1.448441171880197e-11,   3.941095687519845e-14,  -2.078912166566403e-15,   2.285075123049139e-18,  -2.620107899314414e-18,  -6.141290413647616e-20,
   1.436709017363998e-21,   4.595514564133628e-23,   1.420458443517030e+00,  -1.596701965382798e-02,  -1.138437970712113e-04,   3.142526973853919e-06,   4.407900118077249e-08,
  -1.315450286668045e-09,  -1.889093509551789e-11,   9.406429982173093e-13,   1.802478740068247e-14,  -5.363369650257611e-16,  -1.664917384030693e-17,   1.571612450126740e-19,
   9.226805004244707e-21,  -5.040734858688615e-23,   1.420447820157566e+00,  -1.596614010645064e-02,  -1.138191492894647e-04,   3.141309044809365e-06,   4.405297655790011e-08,
  -1.313626815512783e-09,  -1.884502861945545e-11,   9.388536102341583e-13,   1.795632745809380e-14,  -5.355392414709970e-16,  -1.659361985027052e-17,   1.568305769431469e-19,
   9.193246808219596e-21,  -4.971364881728115e-23,   1.420429076933659e+00,  -1.596458840708044e-02,  -1.137756696649984e-04,   3.139161370911431e-06,   4.400710763298758e-08,
  -1.310412125820605e-09,  -1.876417094687746e-11,   9.356983866470086e-13,   1.783571801388331e-14,  -5.341329932889014e-16,  -1.649575979350226e-17,   1.562511742499880e-19,
   9.134303519246769e-21,  -4.849387955892860e-23,   1.420406415599594e+00,  -1.596271254569447e-02,  -1.137231136984389e-04,   3.136566734027133e-06,   4.395173087369389e-08,
  -1.306529752363038e-09,  -1.866664399254897e-11,   9.318867705877695e-13,   1.769019800425237e-14,  -5.324348291153192e-16,  -1.637770820541599e-17,   1.555574702242826e-19,
   9.063488120833638e-21,  -4.702622453202867e-23,   1.420384419690253e+00,  -1.596089198391376e-02,  -1.136721142619263e-04,   3.134050367954141e-06,   4.389806453853491e-08,
  -1.302765901559551e-09,  -1.857222482623253e-11,   9.281904058162285e-13,   1.754926663191464e-14,  -5.307886600153578e-16,  -1.626339973493493e-17,   1.548912542528563e-19,
   8.995220262233072e-21,  -4.560911571151686e-23,   1.420366702451042e+00,  -1.595942571532932e-02,  -1.136310448011329e-04,   3.132024979208654e-06,   4.385489778577375e-08,
  -1.299737437229740e-09,  -1.849634680680833e-11,   9.252154445982808e-13,   1.743597521833085e-14,  -5.294642219666426e-16,  -1.617152412251920e-17,   1.543597165566159e-19,
   8.940565557560397e-21,  -4.447301575786124e-23,   1.420354996379748e+00,  -1.595845700359226e-02,  -1.136039141824424e-04,   3.130687501098691e-06,   4.382640631194379e-08,
  -1.297738065741716e-09,  -1.844629836282044e-11,   9.232510045559738e-13,   1.736123216450407e-14,  -5.285898823255783e-16,  -1.611091674990758e-17,   1.540110046446429e-19,
   8.904616916233677e-21,  -4.372500123221153e-23,   1.420348985112188e+00,  -1.595795957707098e-02,  -1.135899835832173e-04,   3.130000908774013e-06,   4.381178457189472e-08,
  -1.296711844286053e-09,  -1.842062402776678e-11,   9.222425914146878e-13,   1.732288446032746e-14,  -5.281411214655309e-16,  -1.607982356053933e-17,   1.538327019700454e-19,
   8.886206813276230e-21,  -4.334169605566556e-23,   1.420346892892800e+00,  -1.595778645170001e-02,  -1.135851352721203e-04,   3.129761976473517e-06,   4.380669693181662e-08,
  -1.296354746288935e-09,  -1.841169228584020e-11,   9.218916709636514e-13,   1.730954298783645e-14,  -5.279849665572835e-16,  -1.606900631518524e-17,   1.537707657613171e-19,
   8.879807152419556e-21,  -4.320841637566571e-23,   1.420346560889119e+00,  -1.595775897949074e-02,  -1.135843659290823e-04,   3.129724063222892e-06,   4.380588966889250e-08,
  -1.296298083921625e-09,  -1.841027515241110e-11,   9.218359879003340e-13,   1.730742615504946e-14,  -5.279601888411566e-16,  -1.606729000570230e-17,   1.537609432065576e-19,
   8.878792000719870e-21,  -4.318727305117469e-23,   1.841967212685535e+00,  -7.811123922786748e-03,  -2.389074554980864e-04,  -4.558192310773428e-06,  -1.479724449634962e-08,
   2.563462328279226e-09,   9.957443051659387e-11,   1.504190443369374e-12,  -2.577122772706730e-14,  -2.102704861334405e-15,  -5.311478090087621e-17,  -1.763869423366920e-19,
   3.654570777343108e-20,   1.433497812771811e-21,   1.841944800041458e+00,  -7.812397357753828e-03,  -2.389149938610247e-04,  -4.555765234190051e-06,  -1.465807774419784e-08,
   2.566310606142464e-09,   9.950233207757034e-11,   1.497082009879178e-12,  -2.598776784680886e-14,  -2.103218266572694e-15,  -5.288145583714853e-17,  -1.661655712845371e-19,
   3.670466286454921e-20,   1.428871959320734e-21,   1.841905252096694e+00,  -7.814643794749323e-03,  -2.389282319833667e-04,  -4.551480483242442e-06,  -1.441259998723425e-08,
   2.571325054462773e-09,   9.937465571088611e-11,   1.484537948547851e-12,  -2.636904981039768e-14,  -2.104081602235392e-15,  -5.246897764956032e-17,  -1.481582790435847e-19,
   3.698268365346952e-20,   1.420636806867302e-21,   1.841857429481263e+00,  -7.817359256837212e-03,  -2.389441315229251e-04,  -4.546295680272651e-06,  -1.411590952673296e-08,
   2.577369169382320e-09,   9.921948913072428e-11,   1.469367707904284e-12,  -2.682872313639569e-14,  -2.105053044677335e-15,  -5.196889600534505e-17,  -1.264325181293695e-19,
   3.731467872585800e-20,   1.410555242270007e-21,   1.841811003261508e+00,  -7.819994381487604e-03,  -2.389594533127508e-04,  -4.541258562940397e-06,  -1.382803867115364e-08,
   2.583216364807606e-09,   9.906804190187337e-11,   1.454638888568755e-12,  -2.727352191535101e-14,  -2.105920276807928e-15,  -5.148206583774017e-17,  -1.053930517493443e-19,
   3.763258599179765e-20,   1.400639556658261e-21,   1.841773602294740e+00,  -7.822116487609892e-03,  -2.389717152587029e-04,  -4.537198009125752e-06,  -1.359624224036720e-08,
   2.587912224569059e-09,   9.894545568134982e-11,   1.442772316279049e-12,  -2.763080973314743e-14,  -2.106564653307742e-15,  -5.108891527755428e-17,  -8.848111074483733e-20,
   3.788554457462898e-20,   1.392559894609929e-21,   1.841748888105720e+00,  -7.823518386828278e-03,  -2.389797780408560e-04,  -4.534513539051681e-06,  -1.344312858369722e-08,
   2.591008033402398e-09,   9.886416821145035e-11,   1.434930524800699e-12,  -2.786639112626572e-14,  -2.106963912072931e-15,  -5.082865823650775e-17,  -7.732431053303365e-20,
   3.805115622872343e-20,   1.387176286898364e-21,   1.841736196095700e+00,  -7.824238220672124e-03,  -2.389839063918722e-04,  -4.533134524846276e-06,  -1.336451390426440e-08,
   2.592595673776087e-09,   9.882233525858860e-11,   1.430903218939787e-12,  -2.798721619539779e-14,  -2.107160751303898e-15,  -5.069485904846136e-17,  -7.160044439119163e-20,
   3.813572987513427e-20,   1.384397761079656e-21,   1.841731778510849e+00,  -7.824488748160614e-03,  -2.389853413484941e-04,  -4.532654481032124e-06,  -1.333715397592335e-08,
   2.593147915408584e-09,   9.880776092307047e-11,   1.429501451621752e-12,  -2.802924542106854e-14,  -2.107227958254282e-15,  -5.064826603052394e-17,  -6.960910734336950e-20,
   3.816509075382069e-20,   1.383428478734859e-21,   1.841731077500284e+00,  -7.824528502602670e-03,  -2.389855689636001e-04,  -4.532578301591328e-06,  -1.333281245704324e-08,
   2.593235531880243e-09,   9.880544751260858e-11,   1.429279009200579e-12,  -2.803591369108315e-14,  -2.107238561142967e-15,  -5.064087127026099e-17,  -6.929315267644717e-20,
   3.816974632473128e-20,   1.383274563037507e-21,   7.295819709885020e-03,  -1.404400375125259e-04,   2.006564143371467e-06,  -2.594361545495365e-08,   3.080612630598571e-10,
  -2.853266702832978e-12,   6.602881174095587e-14,  -4.448894988524566e-17,  -1.205812803969060e-17,  -8.774419125502997e-19,  -9.681692932724962e-21,   3.223643484366102e-22,
   1.517477158121394e-23,   2.324230370064007e-25,   7.296008173822466e-03,  -1.404473435664779e-04,   2.006737949231922e-06,  -2.594629155856469e-08,   3.081537312505279e-10,
  -2.853400574339761e-12,   6.599638648168106e-14,  -4.740515308062180e-17,  -1.209598366873218e-17,  -8.757187847829377e-19,  -9.588603455669127e-21,   3.239486490364815e-22,
   1.515820136658285e-23,   2.303459766331614e-25,   7.296340734719465e-03,  -1.404602358259398e-04,   2.007044674607556e-06,  -2.595101370181766e-08,   3.083168554585089e-10,
  -2.853641438035599e-12,   6.593909262259014e-14,  -5.254606711273006e-17,  -1.216246197073672e-17,  -8.726717759399366e-19,  -9.424434906117748e-21,   3.267317100877155e-22,
   1.512842421334351e-23,   2.266724131899568e-25,   7.296742893613969e-03,  -1.404758263279217e-04,   2.007415642152749e-06,  -2.595672396866158e-08,   3.085140432156226e-10,
  -2.853940608372703e-12,   6.586967807506039e-14,  -5.875436586644945e-17,  -1.224230530611756e-17,  -8.689762143446172e-19,  -9.226074644806350e-21,   3.300757344238623e-22,
   1.509150081414447e-23,   2.222158772721380e-25,   7.297133326286247e-03,  -1.404909624107683e-04,   2.007775846347920e-06,  -2.596226761019004e-08,   3.087054028119901e-10,
  -2.854239319938462e-12,   6.580215169295369e-14,  -6.477272541579853e-17,  -1.231924755589951e-17,  -8.653770639605265e-19,  -9.033673660747327e-21,   3.332997257108163e-22,
   1.505469906366672e-23,   2.178746589867159e-25,   7.297447870809194e-03,  -1.405031566257097e-04,   2.008066076121925e-06,  -2.596673365072682e-08,   3.088595116516190e-10,
  -2.854485887495383e-12,   6.574765346837659e-14,  -6.961490113644403e-17,  -1.238082426235663e-17,  -8.624693826790547e-19,  -8.878796890552167e-21,   3.358809023906746e-22,
   1.502436812863633e-23,   2.143669118230958e-25,   7.297655724570404e-03,  -1.405112147293129e-04,   2.008257881201664e-06,  -2.596968480752834e-08,   3.089613205218863e-10,
  -2.854651716218873e-12,   6.571159329219437e-14,  -7.281151565043997e-17,  -1.242131387141833e-17,  -8.605440111294054e-19,  -8.776515992070651e-21,   3.375786379841572e-22,
   1.500399187962695e-23,   2.120439657865879e-25,   7.297762470002809e-03,  -1.405153530697136e-04,   2.008356390455918e-06,  -2.597120039168324e-08,   3.090135969741747e-10,
  -2.854737774039401e-12,   6.569305963506231e-14,  -7.445219868406379e-17,  -1.244204564173772e-17,  -8.595539979492672e-19,  -8.724008217655288e-21,   3.384480731655572e-22,
   1.499342453740370e-23,   2.108494609087218e-25,   7.297799624138950e-03,  -1.405167934758747e-04,   2.008390678804300e-06,  -2.597172790845388e-08,   3.090317911136884e-10,
  -2.854767869993032e-12,   6.568660643617465e-14,  -7.502310506473113e-17,  -1.244925172198950e-17,  -8.592092171949535e-19,  -8.705735341607817e-21,   3.387503004387695e-22,
   1.498973006790694e-23,   2.104334551947233e-25,   7.297805520008165e-03,  -1.405170220493916e-04,   2.008396119954690e-06,  -2.597181161828227e-08,   3.090346782180521e-10,
  -2.854772652582034e-12,   6.568558228899931e-14,  -7.511369299921527e-17,  -1.245039476236772e-17,  -8.591544958619273e-19,  -8.702835827458909e-21,   3.387982413393831e-22,
   1.498914302777067e-23,   2.103674290978834e-25,   6.595721838803771e-02,  -1.259399796207368e-03,   1.756116276718780e-05,  -2.167287225749633e-07,   2.371452589840306e-09,
  -1.768020615863718e-11,   4.663067142494172e-13,   1.815504113614451e-15,  -1.425487551627692e-16,  -7.721594945252213e-18,  -9.542266745290665e-20,   3.042570370596569e-21,
   1.399105779278720e-22,   2.164833200621025e-24,   6.595886742908814e-02,  -1.259460809326419e-03,   1.756250038005396e-05,  -2.167452715064168e-07,   2.372103804870850e-09,
  -1.767703867762845e-11,   4.659248635073243e-13,   1.789869783861328e-15,  -1.429237558820227e-16,  -7.705338479287182e-18,  -9.456425073556287e-20,   3.057341049693551e-21,
   1.397608130638219e-22,   2.145747510935502e-24,   6.596177729039672e-02,  -1.259568471716081e-03,   1.756486091577371e-05,  -2.167744700675183e-07,   2.373252444510215e-09,
  -1.767149042683312e-11,   4.652502982531574e-13,   1.744682624966076e-15,  -1.435825129410339e-16,  -7.676592860909381e-18,  -9.305036955603303e-20,   3.083289588123846e-21,
   1.394915421876720e-22,   2.111988616149968e-24,   6.596529610045382e-02,  -1.259698664675031e-03,   1.756771580667391e-05,  -2.168097733981936e-07,   2.374640641803033e-09,
  -1.766485097325951e-11,   4.644332749021397e-13,   1.690118704123312e-15,  -1.443740821248032e-16,  -7.641729965038080e-18,  -9.122116417029306e-20,   3.114471186624437e-21,
   1.391574159637486e-22,   2.071028922666940e-24,   6.596871228328162e-02,  -1.259825060496829e-03,   1.757048781492428e-05,  -2.168440412230035e-07,   2.375987493512643e-09,
  -1.765847827585179e-11,   4.636387335563233e-13,   1.637229640320631e-15,  -1.451372831666848e-16,  -7.607777825729827e-18,  -8.944688687153095e-20,   3.144536451288761e-21,
   1.388241529531800e-22,   2.031123357935366e-24,   6.597146444682887e-02,  -1.259926888163890e-03,   1.757272128804201e-05,  -2.168716440632280e-07,   2.377071935891753e-09,
  -1.765339660776230e-11,   4.629976698637302e-13,   1.594680782048901e-15,  -1.457483549283419e-16,  -7.580349452512764e-18,  -8.801863053480936e-20,   3.168609262682680e-21,
   1.385493215036517e-22,   1.998875180332609e-24,   6.597328309166250e-02,  -1.259994176440384e-03,   1.757419731296522e-05,  -2.168898821289176e-07,   2.377788239807770e-09,
  -1.765006422054904e-11,   4.625735824779044e-13,   1.566593636613237e-15,  -1.461503033969171e-16,  -7.562187705406621e-18,  -8.707539838845761e-20,   3.184443875254417e-21,
   1.383646111015186e-22,   1.977517382641656e-24,   6.597421707265597e-02,  -1.260028732922321e-03,   1.757495537979942e-05,  -2.168992478171675e-07,   2.378156010651294e-09,
  -1.764836075896823e-11,   4.623556439887696e-13,   1.552178329609683e-15,  -1.463561552588239e-16,  -7.552849187117836e-18,  -8.659117007309129e-20,   3.192553331505716e-21,
   1.382687941812380e-22,   1.966534167369355e-24,   6.597454215645453e-02,  -1.260040760738904e-03,   1.757521924104216e-05,  -2.169025075622386e-07,   2.378284003046900e-09,
  -1.764776910752127e-11,   4.622797647586083e-13,   1.547162349524514e-15,  -1.464277134867407e-16,  -7.549596987112732e-18,  -8.642265660154532e-20,   3.195372337761333e-21,
   1.382352916360954e-22,   1.962708987092244e-24,   6.597459374292627e-02,  -1.260042669393280e-03,   1.757526111262126e-05,  -2.169030248356388e-07,   2.378304313030937e-09,
  -1.764767528010744e-11,   4.622677226432369e-13,   1.546366449022014e-15,  -1.464390645008041e-16,  -7.549080820305771e-18,  -8.639591710090713e-20,   3.195819505980145e-21,
   1.382299680023747e-22,   1.962101871291298e-24,   1.848859456525073e-01,  -3.468015829867884e-03,   4.573266065632779e-05,  -5.021444048383008e-07,   4.294315809125959e-09,
  -6.285409436449784e-12,   6.895663427984418e-13,   1.434375302388731e-14,  -5.149826195522011e-16,  -2.203241850387650e-17,  -2.886852874960238e-19,   8.908611594447686e-21,
   4.148285196682750e-22,   6.390319954888219e-24,   1.848902379410232e-01,  -3.468157077613624e-03,   4.573508157693659e-05,  -5.021500708702384e-07,   4.295269213097317e-09,
  -6.258330344033828e-12,   6.881913009041924e-13,   1.427064156188173e-14,  -5.161187310341999e-16,  -2.198480394578094e-17,  -2.861386529732894e-19,   8.952262682678257e-21,
   4.144162207019377e-22,   6.334909633931029e-24,   1.848978119369064e-01,  -3.468406312743441e-03,   4.573935376165230e-05,  -5.021600483898797e-07,   4.296949928331543e-09,
  -6.210665263026288e-12,   6.857626427490890e-13,   1.414176710793096e-14,  -5.181147014155617e-16,  -2.190060749194638e-17,  -2.816473146398786e-19,   9.028952846972707e-21,
   4.136738177256093e-22,   6.236878612591245e-24,   1.849069708095799e-01,  -3.468707692671409e-03,   4.574452046952344e-05,  -5.021720787897178e-07,   4.298979569465346e-09,
  -6.153226469980016e-12,   6.828218463335521e-13,   1.398615592617536e-14,  -5.205133937697515e-16,  -2.179849059832660e-17,  -2.762202079020729e-19,   9.121118827511164e-21,
   4.127507520805793e-22,   6.117902097756516e-24,   1.849158624154958e-01,  -3.469000269332011e-03,   4.574953699067338e-05,  -5.021837216180190e-07,   4.300947082630624e-09,
  -6.097673389510392e-12,   6.799627607732230e-13,   1.383532752128491e-14,  -5.228264524302209e-16,  -2.169903844827432e-17,  -2.709557816789024e-19,   9.209995259601285e-21,
   4.118281840296510e-22,   6.001950729157510e-24,   1.849230256146760e-01,  -3.469235966889697e-03,   4.575357878654758e-05,  -5.021930751353389e-07,   4.302530058254704e-09,
  -6.053069096066982e-12,   6.776565126773337e-13,   1.371399168154942e-14,  -5.246786856717078e-16,  -2.161869351058147e-17,  -2.667178225250528e-19,   9.281164518819881e-21,
   4.110660564603196e-22,   5.908222824644629e-24,   1.849277590451787e-01,  -3.469391712421650e-03,   4.575624980319229e-05,  -5.021992431655598e-07,   4.303575067022620e-09,
  -6.023668052451484e-12,   6.761311178422429e-13,   1.363389826253599e-14,  -5.258971576139134e-16,  -2.156549192876847e-17,  -2.639189390571453e-19,   9.327981762022682e-21,
   4.105532126022944e-22,   5.846134590798459e-24,   1.849301899241325e-01,  -3.469471695446879e-03,   4.575762158148346e-05,  -5.022024068499209e-07,   4.304111421691867e-09,
  -6.008591675070959e-12,   6.753473018521974e-13,   1.359279219770358e-14,  -5.265212159925696e-16,  -2.153813609368599e-17,  -2.624820414758693e-19,   9.351959593868250e-21,
   4.102869882827505e-22,   5.814201888210642e-24,   1.849310360195299e-01,  -3.469499534309846e-03,   4.575809905476049e-05,  -5.022035073796744e-07,   4.304298055905702e-09,
  -6.003347779357564e-12,   6.750744155272469e-13,   1.357848895522797e-14,  -5.267381569691130e-16,  -2.152860919444768e-17,  -2.619819901732904e-19,   9.360294932995908e-21,
   4.101938724102524e-22,   5.803079900592084e-24,   1.849311702834882e-01,  -3.469503951955825e-03,   4.575817482382407e-05,  -5.022036819891853e-07,   4.304327669861446e-09,
  -6.002515815048275e-12,   6.750311088098213e-13,   1.357621942231291e-14,  -5.267725697800850e-16,  -2.152709714813534e-17,  -2.619026424412811e-19,   9.361617144330450e-21,
   4.101790746555483e-22,   5.801314638069087e-24,   3.674477242246570e-01,  -6.678337772297658e-03,   7.905936098646746e-05,  -6.554774295458383e-07,   1.513493620934164e-09,
   9.760235360350412e-11,   3.057551610103952e-13,   3.743579060081986e-14,  -1.008893892817008e-15,  -5.135214261771046e-17,  -5.830780600626278e-19,   1.868027863167899e-20,
   9.022747413707990e-22,   1.399543361603137e-23,   3.674551377387526e-01,  -6.678521800441746e-03,   7.906021455416566e-05,  -6.553853333103466e-07,   1.513891646831734e-09,
   9.767334602051561e-11,   3.030602346726965e-13,   3.726509904100580e-14,  -1.011175739308638e-15,  -5.125213129280259e-17,  -5.775352365414126e-19,   1.877616382390704e-20,
   9.014594491743671e-22,   1.387932924134657e-23,   3.674682190665154e-01,  -6.678846499841181e-03,   7.906172086228896e-05,  -6.552227747743821e-07,   1.514590870624034e-09,
   9.779834134866226e-11,   2.983002327842371e-13,   3.696418820457488e-14,  -1.015183118957531e-15,  -5.107526443704091e-17,  -5.677592993867434e-19,   1.894465616128555e-20,
   8.999881442134476e-22,   1.367383622436893e-23,   3.674840372595303e-01,  -6.679239093743640e-03,   7.906354260271123e-05,  -6.550261165508712e-07,   1.515431091513867e-09,
   9.794902371434619e-11,   2.925362957801024e-13,   3.660079682975356e-14,  -1.019996543340279e-15,  -5.086072314503325e-17,  -5.559458521098772e-19,   1.914720526817458e-20,
   8.981533615935991e-22,   1.342429637028205e-23,   3.674993934044958e-01,  -6.679620179314795e-03,   7.906531142606984e-05,  -6.548351093464178e-07,   1.516241221224106e-09,
   9.809481875274812e-11,   2.869323271236343e-13,   3.624851926407743e-14,  -1.024635478464203e-15,  -5.065174904028088e-17,  -5.444857894833775e-19,   1.934258335234334e-20,
   8.963140315784335e-22,   1.318095511004058e-23,   3.675117641990218e-01,  -6.679927149808963e-03,   7.906673658789057e-05,  -6.546811686257246e-07,   1.516889876955643e-09,
   9.821192226250901e-11,   2.824118216760584e-13,   3.596508543000737e-14,  -1.028348298149521e-15,  -5.048290168211267e-17,  -5.352597075373488e-19,   1.949907738023991e-20,
   8.947907206809505e-22,   1.298414910696490e-23,   3.675199386407220e-01,  -6.680129977178049e-03,   7.906767841715105e-05,  -6.545794141939887e-07,   1.517316549903209e-09,
   9.828913234894997e-11,   2.794218141277033e-13,   3.577797216537275e-14,  -1.030789795833997e-15,  -5.037108601605688e-17,  -5.291662529950417e-19,   1.960204429840680e-20,
   8.937638293691099e-22,   1.285372820553196e-23,   3.675241366203653e-01,  -6.680234134634070e-03,   7.906816212477804e-05,  -6.545271481847680e-07,   1.517535064406240e-09,
   9.832873092602284e-11,   2.778853956985070e-13,   3.568193465460465e-14,  -1.032039952492422e-15,  -5.031358791421847e-17,  -5.260379015215924e-19,   1.965478599940475e-20,
   8.932301975083847e-22,   1.278663564807490e-23,   3.675255977676455e-01,  -6.680270386937233e-03,   7.906833048893187e-05,  -6.545089548924094e-07,   1.517611024441002e-09,
   9.834250521798168e-11,   2.773504870708301e-13,   3.564851653788445e-14,  -1.032474496899823e-15,  -5.029356318240382e-17,  -5.249491988069647e-19,   1.967312144606009e-20,
   8.930434639707844e-22,   1.276326520169416e-23,   3.675258296316916e-01,  -6.680276139647457e-03,   7.906835720625508e-05,  -6.545060677901499e-07,   1.517623073697332e-09,
   9.834469061179630e-11,   2.772655976003512e-13,   3.564321395224735e-14,  -1.032543425386705e-15,  -5.029038496428509e-17,  -5.247764437530999e-19,   1.967602999436944e-20,
   8.930137845631598e-22,   1.275955576792370e-23,   6.190013011862902e-01,  -1.065106928417502e-02,   1.010779419933763e-04,  -2.496667421191495e-07,  -1.180359805330156e-08,
   2.973201706932543e-10,   1.653512587120114e-12,   2.132206166657990e-14,  -1.024334879617222e-15,  -1.061648325312719e-16,  -1.275804426244627e-18,   4.002743911509671e-20,
   1.700874155712798e-21,   2.716117461954822e-23,   6.190107639225781e-01,  -1.065113851988599e-02,   1.010713154021352e-04,  -2.493877046649959e-07,  -1.180130598324706e-08,
   2.973565507422083e-10,   1.650720518902060e-12,   2.096935193045865e-14,  -1.029381028378283e-15,  -1.059512511181216e-16,  -1.265340146681391e-18,   4.021411660223782e-20,
   1.699676288449027e-21,   2.694686968796476e-23,   6.190274605663363e-01,  -1.065126062353500e-02,   1.010596237177848e-04,  -2.488953126716439e-07,  -1.179726482182757e-08,
   2.974201821351518e-10,   1.645783305106913e-12,   2.034758133009263e-14,  -1.038249201958847e-15,  -1.055736131182581e-16,  -1.246882496621663e-18,   4.054221891166985e-20,
   1.697498293982678e-21,   2.656730420785253e-23,   6.190476494682735e-01,  -1.065140816369513e-02,   1.010454877806472e-04,  -2.482998629449389e-07,  -1.179238372565012e-08,
   2.974961686734368e-10,   1.639795210691470e-12,   1.959673928682711e-14,  -1.048911606884396e-15,  -1.051156596384505e-16,  -1.224575014732221e-18,   4.093675333133978e-20,
   1.694755115506978e-21,   2.610592688053612e-23,   6.190672476062891e-01,  -1.065155127910933e-02,   1.010317667123957e-04,  -2.477217648826533e-07,  -1.178765103218100e-08,
   2.975689335295657e-10,   1.633963328628818e-12,   1.886889390601272e-14,  -1.059198538846511e-15,  -1.046697197369340e-16,  -1.202931836794092e-18,   4.131743866443077e-20,
   1.691977622403008e-21,   2.565553961221204e-23,   6.190830349676799e-01,  -1.065166648932825e-02,   1.010207145262955e-04,  -2.472560240660933e-07,  -1.178384259181644e-08,
   2.976268349254678e-10,   1.629251857558415e-12,   1.828331124067488e-14,  -1.067439755825449e-15,  -1.043095005737250e-16,  -1.185505556434466e-18,   4.162244521877977e-20,
   1.689658261132831e-21,   2.529094757827333e-23,   6.190934666596791e-01,  -1.065174257818592e-02,   1.010134120884793e-04,  -2.469482550068773e-07,  -1.178132808006453e-08,
   2.976647442991796e-10,   1.626132067857191e-12,   1.789674133298755e-14,  -1.072862985868460e-15,  -1.040709977678183e-16,  -1.173995156521877e-18,   4.182316912069568e-20,
   1.688085659522744e-21,   2.504917439510025e-23,   6.190988237351950e-01,  -1.065178164108361e-02,   1.010096621381504e-04,  -2.467901959974197e-07,  -1.178003738879647e-08,
   2.976841041275335e-10,   1.624527890054675e-12,   1.769833455515735e-14,  -1.075641141976105e-15,  -1.039483681257123e-16,  -1.168085447486871e-18,   4.192599674147009e-20,
   1.687265694432322e-21,   2.492474875188719e-23,   6.191006882988710e-01,  -1.065179523531330e-02,   1.010083569655737e-04,  -2.467351813381988e-07,  -1.177958825236557e-08,
   2.976908252323811e-10,   1.623969220608155e-12,   1.762929563544996e-14,  -1.076607001188242e-15,  -1.039056623729004e-16,  -1.166028748637029e-18,   4.196174640831325e-20,
   1.686978331788880e-21,   2.488139945035220e-23,   6.191009841787105e-01,  -1.065179739243683e-02,   1.010081498541788e-04,  -2.467264512327742e-07,  -1.177951698537105e-08,
   2.976918909598250e-10,   1.623880552245060e-12,   1.761834098229167e-14,  -1.076760217360676e-15,  -1.038988844485472e-16,  -1.165702389780519e-18,   4.196741746806686e-20,
   1.686932637974776e-21,   2.487451853085315e-23,   9.466801610970436e-01,  -1.470746655575805e-02,   7.531908402880464e-05,   1.343668961907226e-06,  -3.182398060848318e-08,
   1.632032881999225e-10,   1.461975853142389e-11,  -4.519079077157560e-14,  -4.153823759487444e-15,  -1.312326324792698e-16,  -3.207141996310285e-18,   6.191727354913801e-20,
   3.873213727217339e-21,   4.720165309054005e-23,   9.466871865462639e-01,  -1.470708811372495e-02,   7.530129830291181e-05,   1.343821151952454e-06,  -3.180355405298762e-08,
   1.631074320100828e-10,   1.460859345956889e-11,  -4.562499898325733e-14,  -4.166588777706091e-15,  -1.309007527710339e-16,  -3.183322963734148e-18,   6.224445199148106e-20,
   3.870239781894923e-21,   4.688109283650757e-23,   9.466995817202279e-01,  -1.470642031213858e-02,   7.526992441929978e-05,   1.344089618509956e-06,  -3.176752394064770e-08,
   1.629376015695411e-10,   1.458886573576438e-11,  -4.639024636104119e-14,  -4.189031292174583e-15,  -1.303137929291584e-16,  -3.141310273212794e-18,   6.281980818916652e-20,
   3.864864772010928e-21,   4.631175866320202e-23,   9.467145678097808e-01,  -1.470561274023000e-02,   7.523200265346251e-05,   1.344414122607873e-06,  -3.172397790239139e-08,
   1.627310641257900e-10,   1.456496522021492e-11,  -4.731402073917501e-14,  -4.216029992632195e-15,  -1.296017337419130e-16,  -3.090536423755237e-18,   6.351218632860091e-20,
   3.858148233408282e-21,   4.561704599137179e-23,   9.467291136515470e-01,  -1.470482870153205e-02,   7.519520547273739e-05,   1.344729010514830e-06,  -3.168172718331568e-08,
   1.625293302612441e-10,   1.454171547510797e-11,  -4.820915664597648e-14,  -4.242094327315438e-15,  -1.289080766315048e-16,  -3.041276289700102e-18,   6.418080955955719e-20,
   3.851401023004666e-21,   4.493612115468745e-23,   9.467408298772519e-01,  -1.470419704583566e-02,   7.516557404204512e-05,   1.344982583030119e-06,  -3.164770706649845e-08,
   1.623659350716956e-10,   1.452295182881399e-11,  -4.892908325515203e-14,  -4.262987177328467e-15,  -1.283475593438065e-16,  -3.001615025974116e-18,   6.471690461303869e-20,
   3.845803226427114e-21,   4.438295055714614e-23,   9.467485709108197e-01,  -1.470377963730950e-02,   7.514599994536976e-05,   1.345150091564522e-06,  -3.162523527201643e-08,
   1.622575354447595e-10,   1.451053656403812e-11,  -4.940421767985831e-14,  -4.276741777417500e-15,  -1.279763413250316e-16,  -2.975418528821569e-18,   6.506989817771414e-20,
   3.842024922039274e-21,   4.401517534777597e-23,   9.467525460423157e-01,  -1.470356527135078e-02,   7.513594951121692e-05,   1.345236100442975e-06,  -3.161369743463145e-08,
   1.622017338389579e-10,   1.450415561273220e-11,  -4.964804229891979e-14,  -4.283789646628042e-15,  -1.277854443413111e-16,  -2.961968797097574e-18,   6.525079003497378e-20,
   3.840060054779799e-21,   4.382561262413622e-23,   9.467539295819051e-01,  -1.470349065824786e-02,   7.513245165227657e-05,   1.345266034267067e-06,  -3.160968198350108e-08,
   1.621822903787651e-10,   1.450193385009560e-11,  -4.973287907393962e-14,  -4.286240210770144e-15,  -1.277189597413454e-16,  -2.957288042752392e-18,   6.531368935582318e-20,
   3.839372261934514e-21,   4.375952361615565e-23,   9.467541491286214e-01,  -1.470347881812532e-02,   7.513189660384635e-05,   1.345270784240908e-06,  -3.160904480564511e-08,
   1.621792039631080e-10,   1.450158124833240e-11,  -4.974634014287562e-14,  -4.286628962337046e-15,  -1.277084075979384e-16,  -2.956545297575891e-18,   6.532366767845767e-20,
   3.839262933443300e-21,   4.374903098619302e-23,   1.355021843567260e+00,  -1.671705047751266e-02,  -7.282317395797696e-05,   3.622542679036145e-06,   1.561543062071661e-08,
  -1.409564327913686e-09,   1.181733822205388e-11,   1.100703687058382e-12,  -1.052927302174991e-14,  -9.496090396347689e-16,  -1.665545464037611e-18,   4.785150618397375e-19,
   3.921606819462783e-21,  -7.803033781439798e-23,   1.355015034227145e+00,  -1.671603622761938e-02,  -7.281429852596954e-05,   3.621238966627844e-06,   1.563172018292892e-08,
  -1.407447144636008e-09,   1.178957324387369e-11,   1.097562445856181e-12,  -1.053548046906318e-14,  -9.471628726713383e-16,  -1.640230803374942e-18,   4.779675423789958e-19,
   3.944953020470208e-21,  -7.758600167488715e-23,   1.355003019726553e+00,  -1.671424686273441e-02,  -7.279863031436993e-05,   3.618940143937624e-06,   1.566043158042529e-08,
  -1.403716337910384e-09,   1.174056875436380e-11,   1.092026372770372e-12,  -1.054634588045685e-14,  -9.428488453433548e-16,  -1.595450471216334e-18,   4.770038344699232e-19,
   3.985674328470774e-21,  -7.682005703581735e-23,   1.354988492836108e+00,  -1.671208364636332e-02,  -7.277967158526006e-05,   3.616163105730574e-06,   1.569509549261199e-08,
  -1.399213518633380e-09,   1.168129039353829e-11,   1.085343507774372e-12,  -1.055933461397764e-14,  -9.376361461446874e-16,  -1.541111902838475e-18,   4.758425261402646e-19,
   4.034108918853797e-21,  -7.592457179617212e-23,   1.354974391610145e+00,  -1.670998415953378e-02,  -7.276125363898917e-05,   3.613470053043832e-06,   1.572868983136255e-08,
  -1.394851164039031e-09,   1.162372152370915e-11,   1.078867845052813e-12,  -1.057178661801993e-14,  -9.325797911137642e-16,  -1.488164366561995e-18,   4.747192630029675e-19,
   4.080285818256505e-21,  -7.508721392348761e-23,   1.354963032725949e+00,  -1.670829321703014e-02,  -7.274640697503424e-05,   3.611302603027521e-06,   1.575571229738642e-08,
  -1.391343281302407e-09,   1.157732881244860e-11,   1.073659691505936e-12,  -1.058170490595063e-14,  -9.285093484552801e-16,  -1.445371118044145e-18,   4.738172603418433e-19,
   4.116882716608451e-21,  -7.443541842320707e-23,   1.354955527408656e+00,  -1.670717605674065e-02,  -7.273659196219265e-05,   3.609871387689035e-06,   1.577354833206066e-08,
  -1.389028452804924e-09,   1.154666555893348e-11,   1.070222424194115e-12,  -1.058820337151217e-14,  -9.258210858063412e-16,  -1.417026434611714e-18,   4.732226188418294e-19,
   4.140770679654091e-21,  -7.401581835490853e-23,   1.354951673202439e+00,  -1.670660239848436e-02,  -7.273155006109549e-05,   3.609136698269323e-06,   1.578270182517796e-08,
  -1.387840641291303e-09,   1.153091611619921e-11,   1.068458517742510e-12,  -1.059152350386048e-14,  -9.244409709220150e-16,  -1.402449281887221e-18,   4.729176650099715e-19,
   4.152947273102438e-21,  -7.380375339212496e-23,   1.354950331731899e+00,  -1.670640274054867e-02,  -7.272979495487152e-05,   3.608881031926855e-06,   1.578588680088268e-08,
  -1.387427365985132e-09,   1.152543399805424e-11,   1.067844780050345e-12,  -1.059267637579960e-14,  -9.239606787653790e-16,  -1.397372269887624e-18,   4.728115898912851e-19,
   4.157170966068834e-21,  -7.373048565261938e-23,   1.354950118860007e+00,  -1.670637105801475e-02,  -7.272951643294014e-05,   3.608840463527043e-06,   1.578639216607122e-08,
  -1.387361792165666e-09,   1.152456404336621e-11,   1.067747398114871e-12,  -1.059285919103697e-14,  -9.238844663118220e-16,  -1.396566461544513e-18,   4.727947603947401e-19,
   4.157840520639828e-21,  -7.371888484847026e-23,   1.806554367229728e+00,  -9.940400857510214e-03,  -2.928809626839382e-04,  -4.243343776723219e-06,   6.295046135280087e-08,
   5.281228389974835e-09,   1.159576460788251e-10,  -9.141026941500881e-13,  -1.347317064683135e-13,  -3.572309424500329e-15,   6.913565186910598e-18,   3.537108526327421e-18,
   1.107646945371739e-19,   3.968485471278674e-22,   1.806526982592547e+00,  -9.941576919281580e-03,  -2.928446584690487e-04,  -4.238409485350851e-06,   6.310935874732525e-08,
   5.279245627640628e-09,   1.156050681293566e-10,  -9.256827247849927e-13,  -1.346818517182539e-13,  -3.554034741659505e-15,   7.562649721956437e-18,   3.538309557223250e-18,
   1.099838727629877e-19,   3.656831068876455e-22,   1.806478664841485e+00,  -9.943650973549491e-03,  -2.927805274251710e-04,  -4.229704417732851e-06,   6.338933306251445e-08,
   5.275728712104193e-09,   1.149830576314362e-10,  -9.460657069287120e-13,  -1.345916879127522e-13,  -3.521785467752232e-15,   8.704027048537810e-18,   3.540246674856430e-18,
   1.086047380225309e-19,   3.109250513388584e-22,   1.806420243401293e+00,  -9.946157023782799e-03,  -2.927028573777181e-04,  -4.219180838477989e-06,   6.372719456739844e-08,
   5.271444871886962e-09,   1.142311216989807e-10,  -9.706274886469379e-13,  -1.344789286671700e-13,  -3.482784177663251e-15,   1.007746597743156e-17,   3.542279485900151e-18,
   1.069348069650153e-19,   2.451105533158521e-22,   1.806363534014881e+00,  -9.948587845428909e-03,  -2.926273289346602e-04,  -4.208967549973987e-06,   6.405446597762841e-08,
   5.267253645876066e-09,   1.135013748750354e-10,  -9.943820618106633e-13,  -1.343655674604915e-13,  -3.444917694361355e-15,   1.140372709630610e-17,   3.543929946867166e-18,
   1.053113651237050e-19,   1.816383495128025e-22,   1.806317853354103e+00,  -9.950544644859663e-03,  -2.925663928158369e-04,  -4.200741886601816e-06,   6.431759672390874e-08,
   5.263853977601546e-09,   1.129136604845921e-10,  -1.013454250820403e-12,  -1.342714616877382e-13,  -3.414410039588600e-15,   1.246709101870884e-17,   3.545029003746835e-18,
   1.040019428662527e-19,   1.308071325118934e-22,   1.806287670192027e+00,  -9.951836958648390e-03,  -2.925260826140969e-04,  -4.195307511654696e-06,   6.449121678943511e-08,
   5.261596163192205e-09,   1.125253888502742e-10,  -1.026025385263965e-12,  -1.342079187893915e-13,  -3.394249887510201e-15,   1.316726651058013e-17,   3.545642715297160e-18,
   1.031359375756888e-19,   9.736650122880326e-23,   1.806272170252513e+00,  -9.952500405787112e-03,  -2.925053675825952e-04,  -4.192517009112492e-06,   6.458030106170375e-08,
   5.260433154148982e-09,   1.123260176381125e-10,  -1.032471544624968e-12,  -1.341748667585362e-13,  -3.383896341865955e-15,   1.352607395264216e-17,   3.545923160502073e-18,
   1.026909709719427e-19,   8.023888179101249e-23,   1.806266775445548e+00,  -9.952731289962914e-03,  -2.924981553278162e-04,  -4.191545798408752e-06,   6.461129525124562e-08,
   5.260027799255974e-09,   1.122566286398052e-10,  -1.034713642020511e-12,  -1.341632959418438e-13,  -3.380292644426264e-15,   1.365083816513891e-17,   3.546015250391073e-18,
   1.025360598079246e-19,   7.428474470858048e-23,   1.806265919368203e+00,  -9.952767926455655e-03,  -2.924970107379658e-04,  -4.191391682985681e-06,   6.461621301326970e-08,
   5.259963448489808e-09,   1.122456177506961e-10,  -1.035069358537949e-12,  -1.341614566448233e-13,  -3.379720784920732e-15,   1.367063073491974e-17,   3.546029601792485e-18,
   1.025114758164306e-19,   7.334025122918947e-23,   6.764317969171306e-03,  -1.255532491994841e-04,   1.723217464581016e-06,  -2.138675139220217e-08,   2.663914616513461e-10,
  -1.358179939708663e-12,   5.432154601832340e-14,  -9.685501282467952e-16,  -4.497161981331023e-17,  -7.332536639745172e-19,   6.764563654391488e-03,  -1.255623865965737e-04,
   1.723445565479365e-06,  -2.138870913965772e-08,   2.665053313196271e-10,  -1.361130017355512e-12,   5.414557582298037e-14,  -9.720609378563061e-16,  -4.481681139859658e-17,
  -7.240724176166784e-19,   6.764967010019454e-03,  -1.255773877231532e-04,   1.723820099644912e-06,  -2.139192615630853e-08,   2.666919970410832e-10,  -1.365980471426768e-12,
   5.385714145081439e-14,  -9.777907439536517e-16,  -4.456208439313552e-17,  -7.090317300573358e-19,   6.765395033564271e-03,  -1.255933059081120e-04,   1.724217603878840e-06,
  -2.139534381895316e-08,   2.668896975442440e-10,  -1.371137228340094e-12,   5.355170167058250e-14,  -9.838246991053761e-16,  -4.429101163830789e-17,  -6.931158007246501e-19,
   6.765731913551054e-03,  -1.256058342048761e-04,   1.724530510176729e-06,  -2.139803655211725e-08,   2.670450240016233e-10,  -1.375202868544603e-12,   5.331176232177684e-14,
  -9.885403358853662e-16,  -4.407711026275072e-17,  -6.806214336995082e-19,   6.765926342882828e-03,  -1.256130647711938e-04,   1.724711121905514e-06,  -2.139959179058164e-08,
   2.671345598605437e-10,  -1.377552123052053e-12,   5.317346658501883e-14,  -9.912485638871119e-16,  -4.395343836198862e-17,  -6.734233801409496e-19,   6.765999354788956e-03,
  -1.256157799663655e-04,   1.724778948579043e-06,  -2.140017602682411e-08,   2.671681614280540e-10,  -1.378434837262245e-12,   5.312156882314129e-14,  -9.922630265213290e-16,
  -4.390695594308773e-17,  -6.707228429637451e-19,   6.766011457650253e-03,  -1.256162300512369e-04,   1.724790192093888e-06,  -2.140027288441373e-08,   2.671737303120361e-10,
  -1.378581188540168e-12,   5.311296780277107e-14,  -9.924310561807680e-16,  -4.389924858495396e-17,  -6.702753171886970e-19,   6.118511077988034e-02,  -1.128695045389601e-03,
   1.517848336935347e-05,  -1.810021869299789e-07,   2.130098661198409e-09,  -6.669702709871477e-12,   4.083167699848321e-13,  -7.537299497009277e-15,  -4.364006585621375e-16,
  -6.571690028713589e-18,   6.118727445683173e-02,  -1.128772353472470e-03,   1.518030695488488e-05,  -1.810118732267263e-07,   2.130949994125716e-09,  -6.692724437017241e-12,
   4.066072810739238e-13,  -7.568678867410270e-15,  -4.349892579142634e-16,  -6.486201630141600e-18,   6.119082667116436e-02,  -1.128899270240896e-03,   1.518330118473142e-05,
  -1.810277987348771e-07,   2.132344973165741e-09,  -6.730584624900850e-12,   4.038049742848337e-13,  -7.619878844622927e-15,  -4.326667702049742e-16,  -6.346151067141641e-18,
   6.119459610127286e-02,  -1.129033942875996e-03,   1.518647899860447e-05,  -1.810447294275886e-07,   2.133821594065308e-09,  -6.770846942682700e-12,   4.008370853321397e-13,
  -7.673779367278474e-15,  -4.301950856888027e-16,  -6.197945646004047e-18,   6.119756284806763e-02,  -1.129139933944477e-03,   1.518898046427456e-05,  -1.810580775297129e-07,
   2.134981127910371e-09,  -6.802598275961673e-12,   3.985053842703554e-13,  -7.715890957754353e-15,  -4.282445816149081e-16,  -6.081597331708918e-18,   6.119927509001811e-02,
  -1.129201104665114e-03,   1.519042431301469e-05,  -1.810657904331059e-07,   2.135649286457621e-09,  -6.820948421551929e-12,   3.971613368407787e-13,  -7.740070912718786e-15,
  -4.271168070851431e-16,  -6.014567138268424e-18,   6.119991806795305e-02,  -1.129224075106388e-03,   1.519096653110281e-05,  -1.810686884927952e-07,   2.135899991853511e-09,
  -6.827843954497848e-12,   3.966569406570673e-13,  -7.749127408268507e-15,  -4.266929212029228e-16,  -5.989418737263597e-18,   6.120002465149076e-02,  -1.129227882797822e-03,
   1.519105641354400e-05,  -1.810691689820109e-07,   2.135941539588390e-09,  -6.828987244463715e-12,   3.965733459711890e-13,  -7.750627422366109e-15,  -4.266226352360478e-16,
  -5.985251197008861e-18,   1.717093614467109e-01,  -3.125101529310328e-03,   4.011839654042635e-05,  -4.334479118522365e-07,   4.353764942782383e-09,   1.243269178452571e-11,
   7.314463374239855e-13,  -1.589907448022797e-14,  -1.360535665372314e-15,  -1.894715573489893e-17,   1.717150780820680e-01,  -3.125286516818683e-03,   4.012212243328132e-05,
  -4.334306337282573e-07,   4.355263042604063e-09,   1.238374896628351e-11,   7.261110282670271e-13,  -1.598936041703893e-14,  -1.356412291100239e-15,  -1.869376500922947e-17,
   1.717244632490544e-01,  -3.125590198527935e-03,   4.012823999408540e-05,  -4.334023198194045e-07,   4.357714230286800e-09,   1.230321078739677e-11,   7.173642239507649e-13,
  -1.613664757369673e-14,  -1.349626672445471e-15,  -1.827863517522058e-17,   1.717344221597390e-01,  -3.125912421202334e-03,   4.013473242572535e-05,  -4.333723458945075e-07,
   4.360304015096228e-09,   1.221749558333174e-11,   7.080994810611811e-13,  -1.629166596011581e-14,  -1.342404435961322e-15,  -1.783931306921931e-17,   1.717422602536037e-01,
  -3.126166007014133e-03,   4.013984288963482e-05,  -4.333488065307007e-07,   4.362334149962404e-09,   1.214985135164699e-11,   7.008198958417829e-13,  -1.641275196907485e-14,
  -1.336704573196941e-15,  -1.749440980021498e-17,   1.717467839227075e-01,  -3.126312354292345e-03,   4.014279259276903e-05,  -4.333352416823661e-07,   4.363502560546804e-09,
   1.211073830236864e-11,   6.966234478643032e-13,  -1.648226704121357e-14,  -1.333408729438716e-15,  -1.729569951868982e-17,   1.717484826341447e-01,  -3.126367308762909e-03,
   4.014390030254342e-05,  -4.333301517641523e-07,   4.363940702051072e-09,   1.209603696497331e-11,   6.950485371691191e-13,  -1.650830151264406e-14,  -1.332169913709833e-15,
  -1.722114626490165e-17,   1.717487642213948e-01,  -3.126376418232566e-03,   4.014408392482208e-05,  -4.333293082388063e-07,   4.364013298194593e-09,   1.209359927021082e-11,
   6.947875205312029e-13,  -1.651261345337786e-14,  -1.331964499423230e-15,  -1.720879139854963e-17,   3.419507777394757e-01,  -6.076774370534391e-03,   7.140555003651514e-05,
  -6.149710934663658e-07,   3.597366193840376e-09,   1.120529843962461e-10,   6.048829531900517e-13,  -2.647367699559483e-14,  -2.946303572655398e-15,  -4.341325226509879e-17,
   3.419609454638059e-01,  -6.077036354501976e-03,   7.140862809793342e-05,  -6.148123325423415e-07,   3.598520454432343e-09,   1.119705795990114e-10,   5.933327352264148e-13,
  -2.668137102673172e-14,  -2.937199928913318e-15,  -4.286347932642390e-17,   3.419776377469558e-01,  -6.077466394773946e-03,   7.141368190300059e-05,  -6.145517868962066e-07,
   3.600397641113662e-09,   1.118348597090217e-10,   5.743976125818711e-13,  -2.702031231716509e-14,  -2.922217884086740e-15,  -4.196274183867185e-17,   3.419953499819320e-01,
  -6.077922634418522e-03,   7.141904528418982e-05,  -6.142754450940289e-07,   3.602365422294241e-09,   1.116902560572131e-10,   5.543419610812529e-13,  -2.737721076538460e-14,
  -2.906270926297338e-15,  -4.100945202646218e-17,   3.420092899170734e-01,  -6.078281649410197e-03,   7.142326694279257e-05,  -6.140580477369888e-07,   3.603896674755242e-09,
   1.115760237638228e-10,   5.385841511110805e-13,  -2.765610758290381e-14,  -2.893684772027748e-15,  -4.026099913022866e-17,   3.420173350517633e-01,  -6.078488824742931e-03,
   7.142570360330694e-05,  -6.139326176432211e-07,   3.604773420872356e-09,   1.115099269416422e-10,   5.295004849282770e-13,  -2.781627001558558e-14,  -2.886406791496922e-15,
  -3.982977308965708e-17,   3.420203561035676e-01,  -6.078566617504543e-03,   7.142661864228954e-05,  -6.138855238620388e-07,   3.605101331121026e-09,   1.114850746552074e-10,
   5.260914594001318e-13,  -2.787626257188014e-14,  -2.883671152129791e-15,  -3.966797998217341e-17,   3.420208568873986e-01,  -6.078579512576486e-03,   7.142677032566480e-05,
  -6.138777177350246e-07,   3.605155617496871e-09,   1.114809533322723e-10,   5.255264691955248e-13,  -2.788619928487838e-14,  -2.883217539351010e-15,  -3.964116767079388e-17,
   5.779920429746052e-01,  -9.857181730148514e-03,   9.715207835344634e-05,  -3.886854072231499e-07,  -5.446934919683000e-09,   3.366842744793896e-10,   1.173725845949534e-12,
  -7.740813667351191e-14,  -5.088014492393303e-15,  -9.379571684017111e-17,   5.780058591022046e-01,  -9.857345983350000e-03,   9.714744026136406e-05,  -3.882083007444440e-07,
  -5.444665421671761e-09,   3.364457896785464e-10,   1.153818253237231e-12,  -7.785949164038107e-14,  -5.070439802479943e-15,  -9.270622351179092e-17,   5.780285400372729e-01,
  -9.857615484826620e-03,   9.713982740818585e-05,  -3.874253014662463e-07,  -5.440970192044297e-09,   3.360533222652252e-10,   1.121187751037926e-12,  -7.859645495231068e-14,
  -5.041514935421009e-15,  -9.092098760791757e-17,   5.780526056177531e-01,  -9.857901247338789e-03,   9.713175137390259e-05,  -3.865948165973041e-07,  -5.437090701789924e-09,
   3.356355894314139e-10,   1.086633737981498e-12,  -7.937298842868070e-14,  -5.010724665843039e-15,  -8.903128149312734e-17,   5.780715448894190e-01,  -9.858125999611850e-03,
   9.712539678139087e-05,  -3.859414656916114e-07,  -5.434067487739455e-09,   3.353058979017947e-10,   1.059489936244979e-12,  -7.998018995410928e-14,  -4.986421608067015e-15,
  -8.754739737445660e-17,   5.780824749264132e-01,  -9.858255650701727e-03,   9.712172993580072e-05,  -3.855645024725455e-07,  -5.432334732054060e-09,   3.351152534637643e-10,
   1.043844944581115e-12,  -8.032904252015449e-14,  -4.972367575289560e-15,  -8.669235728688620e-17,   5.780865792286430e-01,  -9.858304325043822e-03,   9.712035309565668e-05,
  -3.854229676434137e-07,  -5.431686331896543e-09,   3.350435942241983e-10,   1.037973921218170e-12,  -8.045974259226557e-14,  -4.967084825532193e-15,  -8.637153490345952e-17,
   5.780872595736209e-01,  -9.858312392936091e-03,   9.712012486979597e-05,  -3.853995072016430e-07,  -5.431578969842174e-09,   3.350317119714069e-10,   1.037000917012297e-12,
  -8.048139230894315e-14,  -4.966208853972472e-15,  -8.631836740035246e-17,   8.891463819994451e-01,  -1.404868724823480e-02,   8.855448291920876e-05,   8.789308629404066e-07,
  -2.525135327129424e-08,   4.787806059664430e-10,   1.065323710853676e-11,  -2.695688486143048e-13,  -9.974953740120961e-15,  -1.432347077019800e-16,   8.891589408505215e-01,
  -1.404830963193245e-02,   8.853304818253496e-05,   8.796053014751606e-07,  -2.522907700590873e-08,   4.779643272105605e-10,   1.061408324785207e-11,  -2.702447471519767e-13,
  -9.946557882463036e-15,  -1.410719350192039e-16,   8.891795560530834e-01,  -1.404768950714964e-02,   8.849787319268365e-05,   8.807116575273675e-07,  -2.519256700149346e-08,
   4.766228511145114e-10,   1.054988854204121e-11,  -2.713463848948716e-13,  -9.899781716340462e-15,  -1.375279083411447e-16,   8.892014274088701e-01,  -1.404703122630484e-02,
   8.846056827226471e-05,   8.818844390204595e-07,  -2.515390866231603e-08,   4.751975175137329e-10,   1.048188563291040e-11,  -2.725045040578925e-13,  -9.849932795313743e-15,
  -1.337763251201004e-16,   8.892186381328930e-01,  -1.404651295282744e-02,   8.843122245527910e-05,   8.828065925759934e-07,  -2.512354336939158e-08,   4.740743869828775e-10,
   1.042844873119887e-11,  -2.734081384125256e-13,  -9.810546249950427e-15,  -1.308302936781322e-16,   8.892285699174758e-01,  -1.404621376573640e-02,   8.841429175714516e-05,
   8.833384518602996e-07,  -2.510604260616780e-08,   4.734256534410633e-10,   1.039764208141082e-11,  -2.739265157328126e-13,  -9.787753647607886e-15,  -1.291326930685517e-16,
   8.892322992386705e-01,  -1.404610140264032e-02,   8.840793512159771e-05,   8.835381072391698e-07,  -2.509947536178468e-08,   4.731819433203891e-10,   1.038608009105219e-11,
  -2.741205808149651e-13,  -9.779183148611129e-15,  -1.284957222916506e-16,   8.892329174184579e-01,  -1.404608277603816e-02,   8.840688147153295e-05,   8.835711996481726e-07,
  -2.509838698258661e-08,   4.731415393881920e-10,   1.038416385360060e-11,  -2.741527187253280e-13,  -9.777761852138115e-15,  -1.283901614245663e-16,   1.287266943087828e+00,
  -1.712342575742125e-02,  -2.870816284531886e-05,   3.671605960314031e-06,  -7.569044106620011e-09,  -8.251245751246954e-10,   3.293445903245679e-11,   2.479206460795265e-13,
  -4.039291427132840e-14,  -5.480086378635447e-16,   1.287262845493321e+00,  -1.712186239447244e-02,  -2.871423884327196e-05,   3.670437605431313e-06,  -7.500613157972389e-09,
  -8.244261940659641e-10,   3.277655855725210e-11,   2.452435327423546e-13,  -4.024603163527031e-14,  -5.431441528046107e-16,   1.287256118065097e+00,  -1.711929624026901e-02,
  -2.872417193852989e-05,   3.668520262523802e-06,  -7.388514671363319e-09,  -8.232853863644146e-10,   3.251776277367374e-11,   2.408665600686682e-13,  -4.000483213078487e-14,
  -5.351675579028481e-16,   1.287248978979919e+00,  -1.711657384024079e-02,  -2.873465521098363e-05,   3.666486762671722e-06,  -7.269898040067424e-09,  -8.220826238412716e-10,
   3.224373598332716e-11,   2.362466191374974e-13,  -3.974881090397600e-14,  -5.267165007101970e-16,   1.287243359931045e+00,  -1.711443165028582e-02,  -2.874286475092593e-05,
   3.664887072334580e-06,  -7.176783708812316e-09,  -8.211416181506344e-10,   3.202849224180022e-11,   2.326283270823195e-13,  -3.954725760334214e-14,  -5.200748155161253e-16,
   1.287240116847642e+00,  -1.711319549211345e-02,  -2.874758628299463e-05,   3.663964133418096e-06,  -7.123140748934525e-09,  -8.206007745172662e-10,   3.190443796158591e-11,
   2.305472001204101e-13,  -3.943091250714264e-14,  -5.162455551262454e-16,   1.287238898995982e+00,  -1.711273132917654e-02,  -2.874935617666127e-05,   3.663617612304521e-06,
  -7.103015255778324e-09,  -8.203981030357931e-10,   3.185788593084146e-11,   2.297670500767410e-13,  -3.938721916196795e-14,  -5.148083503020061e-16,   1.287238697117445e+00,
  -1.711265438893687e-02,  -2.874964939899506e-05,   3.663560174191117e-06,  -7.099680115033938e-09,  -8.203645295136395e-10,   3.185017093173407e-11,   2.296377993902906e-13,
  -3.937997612344227e-14,  -5.145701511619069e-16,   1.761817796798770e+00,  -1.246112524866371e-02,  -3.338225879009006e-04,  -2.258348029705361e-06,   1.913466579165035e-07,
   7.161210020800256e-09,   1.322019948815378e-11,  -6.835821309453365e-12,  -2.075652934519627e-13,   1.187408023626923e-15,   1.761770620149637e+00,  -1.246205402309225e-02,
  -3.336591056275384e-04,  -2.248328470839091e-06,   1.913654909381752e-07,   7.140899646712599e-09,   1.242600877133039e-11,  -6.828571790394934e-12,  -2.059768500855187e-13,
   1.231365382881387e-15,   1.761693188871155e+00,  -1.246357570502937e-02,  -3.333907143464457e-04,  -2.231900583046537e-06,   1.913952005189447e-07,   7.107573286647683e-09,
   1.112676542629477e-11,  -6.816511866987096e-12,  -2.033735837160045e-13,   1.302984284117998e-15,   1.761611051168036e+00,  -1.246518618329998e-02,  -3.331059190696365e-04,
  -2.214497637598574e-06,   1.914250869130313e-07,   7.072233924987127e-09,   9.754343543359305e-12,  -6.803500815481450e-12,  -2.006173558755401e-13,   1.378239687078475e-15,
   1.761546424920919e+00,  -1.246645064063895e-02,  -3.328817757627032e-04,  -2.200821919984055e-06,   1.914474248820290e-07,   7.044438084051030e-09,   8.678706113688987e-12,
  -6.793106576999010e-12,  -1.984525867623613e-13,   1.436933364941108e-15,   1.761509134486766e+00,  -1.246717918304593e-02,  -3.327524152030641e-04,  -2.192937607578186e-06,
   1.914598434333726e-07,   7.028403191101562e-09,   8.059722989184874e-12,  -6.787046221306340e-12,  -1.972050265240798e-13,   1.470593574783670e-15,   1.761495132812348e+00,
  -1.246745253113698e-02,  -3.327038384578244e-04,  -2.189978521655615e-06,   1.914644174146115e-07,   7.022383188199760e-09,   7.827626452167105e-12,  -6.784758880996692e-12,
  -1.967368908035583e-13,   1.483193105222782e-15,   1.761492811900573e+00,  -1.246749783053219e-02,  -3.326957861372806e-04,  -2.189488092664572e-06,   1.914651709089339e-07,
   7.021385353097138e-09,   7.789170943069835e-12,  -6.784379109598503e-12,  -1.966593083319682e-13,   1.485279537722334e-15,   6.288151140022918e-03,  -1.127232777824565e-04,
   1.491450335469646e-06,  -1.728333439027811e-08,   2.491570051154863e-10,  -5.576430240918984e-13,   5.028413550350232e-15,  -2.536678247822940e-15,  -4.069614047293745e-17,
   1.332080067287497e-18,   6.288363812279395e-03,  -1.127306594573460e-04,   1.491663126453834e-06,  -1.728419092336807e-08,   2.491659417080735e-10,  -5.651128429606036e-13,
   4.875959992124943e-15,  -2.529749364311365e-15,  -4.022621004464361e-17,   1.336088364100017e-18,   6.288712970112793e-03,  -1.127427779507156e-04,   1.492012462254740e-06,
  -1.728560469804371e-08,   2.491803824953757e-10,  -5.773607279603267e-13,   4.627022441177587e-15,  -2.518360545964829e-15,  -3.945713950360213e-17,   1.342548136654813e-18,
   6.289083483332741e-03,  -1.127556369898336e-04,   1.492383141208620e-06,  -1.728711519305850e-08,   2.491953937192575e-10,  -5.903362355419141e-13,   4.364697353720871e-15,
  -2.506257432877321e-15,  -3.864435289597020e-17,   1.349239384755314e-18,   6.289375100740848e-03,  -1.127657573980923e-04,   1.492674872263190e-06,  -1.728831146264673e-08,
   2.492069829299842e-10,  -6.005332131176461e-13,   4.159558638321814e-15,  -2.496718871781699e-15,  -3.800704336827134e-17,   1.354387909313382e-18,   6.289543407490715e-03,
  -1.127715981949253e-04,   1.492843237852034e-06,  -1.728900485822001e-08,   2.492135815086374e-10,  -6.064121456372814e-13,   4.041694213061891e-15,  -2.491208693463879e-15,
  -3.764018465265075e-17,   1.357312293497093e-18,   6.289606609982212e-03,  -1.127737914932981e-04,   1.492906461160270e-06,  -1.728926580286734e-08,   2.492160424053838e-10,
  -6.086186195624242e-13,   3.997534089506815e-15,  -2.489138574573106e-15,  -3.750260417921513e-17,   1.358401579867436e-18,   6.289617086786008e-03,  -1.127741550650109e-04,
   1.492916941347268e-06,  -1.728930908812082e-08,   2.492164494416801e-10,  -6.089843149069796e-13,   3.990219144172023e-15,  -2.488795370575862e-15,  -3.747980766939278e-17,
   1.358581678371759e-18,   5.690023853517139e-02,  -1.015383054188541e-03,   1.320800037080960e-05,  -1.475574751632677e-07,   2.068821543351461e-09,  -1.114322743649386e-12,
  -1.597711488273910e-14,  -2.259223017455101e-14,  -3.906939179829212e-16,   1.248228048291125e-17,   5.690212168232479e-02,  -1.015446057419562e-03,   1.320976652210670e-05,
  -1.475596212328510e-07,   2.068770142390487e-09,  -1.180798952906044e-12,  -1.744396444796835e-14,  -2.252729274924859e-14,  -3.863400325937591e-16,   1.252021519527644e-17,
   5.690521335485070e-02,  -1.015549488216013e-03,   1.321266590823408e-05,  -1.475632122950741e-07,   2.068683543853712e-09,  -1.289789526175349e-12,  -1.983962379619091e-14,
  -2.242055545397392e-14,  -3.792146400011424e-16,   1.258136720874336e-17,   5.690849410531153e-02,  -1.015659237379000e-03,   1.321574232991408e-05,  -1.475671149484543e-07,
   2.068588655426285e-09,  -1.405245326562989e-12,  -2.236477020912644e-14,  -2.230712178785550e-14,  -3.716842395942145e-16,   1.264473311004132e-17,   5.691107625197220e-02,
  -1.015745611348110e-03,   1.321816345238300e-05,  -1.475702530924435e-07,   2.068511813327708e-09,  -1.495970792112036e-12,  -2.433991350157334e-14,  -2.221772240416157e-14,
  -3.657796342555653e-16,   1.269350613448006e-17,   5.691256653097745e-02,  -1.015795459778763e-03,   1.321956071426028e-05,  -1.475720909068684e-07,   2.068466601334521e-09,
  -1.548274533865263e-12,  -2.547494198360669e-14,  -2.216607814702733e-14,  -3.623807331483402e-16,   1.272121622217026e-17,   5.691312615911041e-02,  -1.015814178421768e-03,
   1.322008539708601e-05,  -1.475727860742824e-07,   2.068449460622904e-09,  -1.567904576890700e-12,  -2.590023794675734e-14,  -2.214667580971983e-14,  -3.611060680776256e-16,
   1.273153908869065e-17,   5.691321892619852e-02,  -1.015817281308039e-03,   1.322017237062086e-05,  -1.475729015745724e-07,   2.068446610705051e-09,  -1.571157981776988e-12,
  -2.597068841065673e-14,  -2.214345910010212e-14,  -3.608948614622571e-16,   1.273324590167840e-17,   1.598196108308762e-01,  -2.823751670287500e-03,   3.534563855987316e-05,
  -3.610902746481435e-07,   4.714682194084261e-09,   1.934454016847532e-11,  -3.734629133358198e-13,  -6.242956972974662e-14,  -1.211847673142790e-15,   3.726718400106526e-17,
   1.598246488604284e-01,  -2.823905736195797e-03,   3.534965931521464e-05,  -3.610642920763522e-07,   4.713831184465816e-09,   1.916107756003984e-11,  -3.780250337299142e-13,
  -6.223561666836760e-14,  -1.198937331253485e-15,   3.738326412195698e-17,   1.598329200143207e-01,  -2.824158652669572e-03,   3.535625949393227e-05,  -3.610218248864240e-07,
   4.712427216859192e-09,   1.886031482973840e-11,  -3.854776878869544e-13,  -6.191680687273740e-14,  -1.177808552504022e-15,   3.757045953664316e-17,   1.598416969091990e-01,
  -2.824427006232676e-03,   3.536326205492999e-05,  -3.609770183789509e-07,   4.710928155204648e-09,   1.854175473524447e-11,  -3.933356128775561e-13,  -6.157798211170880e-14,
  -1.155478496920885e-15,   3.776452884997929e-17,   1.598486047779964e-01,  -2.824638194418770e-03,   3.536877257058761e-05,  -3.609419394732470e-07,   4.709741645076488e-09,
   1.829146106416265e-11,  -3.994837813037462e-13,  -6.131093744513372e-14,  -1.137969221044495e-15,   3.791397622562980e-17,   1.598525916070596e-01,  -2.824760072261118e-03,
   3.537195258122921e-05,  -3.609217684659486e-07,   4.709054192827663e-09,   1.814717808046423e-11,  -4.030175817863799e-13,  -6.115666703509400e-14,  -1.127890169377320e-15,
   3.799891289358698e-17,   1.598540887318065e-01,  -2.824805838038779e-03,   3.537314666600779e-05,  -3.609142079777141e-07,   4.708795539415578e-09,   1.809302984829698e-11,
  -4.043418352077175e-13,  -6.109870811556192e-14,  -1.124110279532333e-15,   3.803055999912207e-17,   1.598543369032871e-01,  -2.824813424341773e-03,   3.537334460049557e-05,
  -3.609129554530276e-07,   4.708752637120508e-09,   1.808405566389687e-11,  -4.045612055527063e-13,  -6.108909907828810e-14,  -1.123483966882754e-15,   3.803579291966666e-17,
   3.187410411434192e-01,  -5.533896732879324e-03,   6.444657371124396e-05,  -5.391531250212835e-07,   5.864291271778084e-09,   1.061245873049213e-10,  -1.576340588168362e-12,
  -1.283709879335667e-13,  -2.685620948345443e-15,   7.997695204127639e-17,   3.187502223934225e-01,  -5.534126387530884e-03,   6.445156110217954e-05,  -5.390052784966990e-07,
   5.860807088379772e-09,   1.057476273818687e-10,  -1.586455102665932e-12,  -1.279543783516032e-13,  -2.657216438698465e-15,   8.024039615000587e-17,   3.187652954114385e-01,
  -5.534503357940344e-03,   6.445974652408253e-05,  -5.387629494362648e-07,   5.855071942620754e-09,   1.051296908447007e-10,  -1.602978728695608e-12,  -1.272695272251098e-13,
  -2.610728347148937e-15,   8.066539092306085e-17,   3.187812897419058e-01,  -5.534903291765749e-03,   6.446842891135872e-05,  -5.385063422234126e-07,   5.848965790723965e-09,
   1.044752423281890e-10,  -1.620401730927681e-12,  -1.265416131904814e-13,  -2.561594603129703e-15,   8.110620369388315e-17,   3.187938778659780e-01,  -5.535217997735092e-03,
   6.447525983566138e-05,  -5.383047690083505e-07,   5.844145269302834e-09,   1.039610792094123e-10,  -1.634034373580974e-12,  -1.259678593059326e-13,  -2.523066367071720e-15,
   8.144581722547661e-17,   3.188011429197075e-01,  -5.535399603061981e-03,   6.447920122847242e-05,  -5.381885885567769e-07,   5.841357277842891e-09,   1.036647031637489e-10,
  -1.641870288433451e-12,  -1.256363851510029e-13,  -2.500887206642543e-15,   8.163889606320992e-17,   3.188038710576461e-01,  -5.535467794335568e-03,   6.448068109660535e-05,
  -5.381449902408940e-07,   5.840309232208692e-09,   1.035534786225621e-10,  -1.644806758274182e-12,  -1.255118476968361e-13,  -2.492569341740736e-15,   8.171084869473519e-17,
   3.188043232875651e-01,  -5.535479097839482e-03,   6.448092639727219e-05,  -5.381377647043179e-07,   5.840135444233692e-09,   1.035350451303697e-10,  -1.645293204135692e-12,
  -1.254912003810294e-13,  -2.491191097392711e-15,   8.172274686906976e-17,   5.400867986462259e-01,  -9.099586977710308e-03,   9.218923911441743e-05,  -4.215343974882402e-07,
   1.288298492840349e-09,   3.183911515271795e-10,  -3.556970611701593e-12,  -2.603389422449452e-13,  -4.900287975512593e-15,   1.483341917521452e-16,   5.400999199742560e-01,
  -9.099765363368567e-03,   9.219029476842988e-05,  -4.210877561516576e-07,   1.280489258978086e-09,   3.176255431284253e-10,  -3.575334969055054e-12,  -2.595645788531033e-13,
  -4.844058441401387e-15,   1.488862148206111e-16,   5.401214608598300e-01,  -9.100058075990555e-03,   9.219202290801979e-05,  -4.203553043928888e-07,   1.267641418730228e-09,
   3.163703547099292e-10,  -3.605322691413418e-12,  -2.582914054245564e-13,  -4.752026892346776e-15,   1.497773859933668e-16,   5.401443175427710e-01,  -9.100368481585856e-03,
   9.219384994626179e-05,  -4.195791786963263e-07,   1.253971329366675e-09,   3.150407905255955e-10,  -3.636924504130202e-12,  -2.569378764210962e-13,  -4.654752711926861e-15,
   1.507025967745438e-16,   5.401623059724230e-01,  -9.100612638491426e-03,   9.219528301197671e-05,  -4.189691320283703e-07,   1.243185824346053e-09,   3.139960746272473e-10,
  -3.661638182400689e-12,  -2.558707878401231e-13,  -4.578471495060547e-15,   1.514160439203074e-16,   5.401726874869699e-01,  -9.100753492564343e-03,   9.219610812658066e-05,
  -4.186173699065722e-07,   1.236950481066046e-09,   3.133938138628423e-10,  -3.675838064055788e-12,  -2.552542146982044e-13,  -4.534558006554766e-15,   1.518219176241874e-16,
   5.401765858564747e-01,  -9.100806374532660e-03,   9.219641759918296e-05,  -4.184853378685163e-07,   1.234607007182446e-09,   3.131677847547970e-10,  -3.681158392176058e-12,
  -2.550225472674305e-13,  -4.518088829495569e-15,   1.519732201711265e-16,   5.401772320674190e-01,  -9.100815139941191e-03,   9.219646887937437e-05,  -4.184634547345777e-07,
   1.234218435298612e-09,   3.131303238328168e-10,  -3.682039686922967e-12,  -2.549841378126693e-13,  -4.515359923696836e-15,   1.519982423933187e-16,   8.344266612659431e-01,
  -1.330412860947439e-02,   9.702984367939609e-05,   5.621464510200163e-07,  -1.393057232601220e-08,   6.048840998645558e-10,  -1.749682122621783e-12,  -6.116092727936509e-13,
  -8.751955927704729e-15,   3.012825865023800e-16,   8.344404453581488e-01,  -1.330388563235045e-02,   9.701792561321307e-05,   5.629920499444334e-07,  -1.393469191013278e-08,
   6.030815739358234e-10,  -1.782334081183789e-12,  -6.100337141529762e-13,  -8.644402285611448e-15,   3.025064323033508e-16,   8.344630729472525e-01,  -1.330348648868604e-02,
   9.699835751516946e-05,   5.643783939914969e-07,  -1.394150407570887e-08,   6.001258592545494e-10,  -1.835630935876326e-12,  -6.074428818187536e-13,  -8.468381289401932e-15,
   3.044845230374203e-16,   8.344870808976291e-01,  -1.330306261689827e-02,   9.697759061446959e-05,   5.658469087271926e-07,  -1.394879892148458e-08,   5.969942750745220e-10,
  -1.891767159879832e-12,  -6.046880297224920e-13,  -8.282351501812124e-15,   3.065413958341174e-16,   8.345059740711263e-01,  -1.330272877476012e-02,   9.696124430901793e-05,
   5.670008265031174e-07,  -1.395458803016674e-08,   5.945330778871038e-10,  -1.935646249358762e-12,  -6.025158115259376e-13,  -8.136482699932317e-15,   3.081298614871162e-16,
   8.345168772060836e-01,  -1.330253600667342e-02,   9.695180947189828e-05,   5.676660495646196e-07,  -1.395794822311097e-08,   5.931140273905390e-10,  -1.960849532735592e-12,
  -6.012605404043964e-13,  -8.052514569143382e-15,   3.090344914965151e-16,   8.345209713500210e-01,  -1.330246360121014e-02,   9.694826639502536e-05,   5.679157103811232e-07,
  -1.395921362727011e-08,   5.925814159863096e-10,  -1.970290924357732e-12,  -6.007888652562877e-13,  -8.021024465063340e-15,   3.093719062616239e-16,   8.345216500081457e-01,
  -1.330245159795925e-02,   9.694767906866543e-05,   5.679570880060864e-07,  -1.395942357681096e-08,   5.924931415399973e-10,  -1.971854773711369e-12,  -6.007106621281259e-13,
  -8.015806680341844e-15,   3.094277172850520e-16,   1.218588743814856e+00,  -1.717988746828665e-02,   1.421877292155788e-05,   3.460999779651958e-06,  -1.640975870002413e-08,
  -1.079990687611938e-10,   2.039279165944716e-11,  -1.128987438042108e-12,  -3.699503840806406e-14,   9.025874118310684e-16,   1.218590739553456e+00,  -1.717841053783534e-02,
   1.420499789007535e-05,   3.460818299529355e-06,  -1.636789892795849e-08,  -1.112985589306608e-10,   2.025140569743225e-11,  -1.124332921625639e-12,  -3.670344922527565e-14,
   9.037891542831516e-16,   1.218594014501985e+00,  -1.717598597987339e-02,   1.418240925274228e-05,   3.460517007798213e-06,  -1.629939428248179e-08,  -1.167051340198448e-10,
   2.002012989328998e-11,  -1.116687851087757e-12,  -3.622608806410277e-14,   9.056927829514635e-16,   1.218597487602139e+00,  -1.717341342184571e-02,   1.415847528447325e-05,
   3.460192749425837e-06,  -1.622699698814526e-08,  -1.224282350747470e-10,   1.977585722343482e-11,  -1.108570640069279e-12,  -3.572137986294414e-14,   9.076189968816182e-16,
   1.218600219594897e+00,  -1.717138886739946e-02,   1.413966391956566e-05,   3.459934255986062e-06,  -1.617023039134919e-08,  -1.269224283028745e-10,   1.958442899853006e-11,
  -1.102178695964877e-12,  -3.532548288308898e-14,   9.090674230637782e-16,   1.218601795738406e+00,  -1.717022048253270e-02,   1.412881743324477e-05,   3.459783752876619e-06,
  -1.613755345851913e-08,  -1.295121386609007e-10,   1.947427843398336e-11,  -1.098488350076967e-12,  -3.509752895241418e-14,   9.098763787506569e-16,   1.218602387493387e+00,
  -1.716978174715697e-02,   1.412474634261012e-05,   3.459726987862146e-06,  -1.612529883480346e-08,  -1.304838489400214e-10,   1.943297743108195e-11,  -1.097102322464596e-12,
  -3.501202944706888e-14,   9.101750663973060e-16,   1.218602485579835e+00,  -1.716970902074002e-02,   1.412407159981181e-05,   3.459717565085221e-06,  -1.612326829323174e-08,
  -1.306448841684479e-10,   1.942613444831856e-11,  -1.096872554617379e-12,  -3.499786192855067e-14,   9.102243102868569e-16,   1.706548014788244e+00,  -1.517743714165607e-02,
  -3.379789048262148e-04,   1.888931554163269e-06,   3.188184415847163e-07,   4.551047676050276e-09,  -2.484652885418298e-10,  -1.046754251843234e-11,   5.655200602170067e-14,
   1.351390828583928e-14,   1.706500459276984e+00,  -1.517660878201718e-02,  -3.377096697245787e-04,   1.895153892442858e-06,   3.182911183868922e-07,   4.520832780589713e-09,
  -2.482116069459530e-10,  -1.040050370400545e-11,   5.793767224518485e-14,   1.343212215155244e-14,   1.706422416420680e+00,  -1.517524703454071e-02,  -3.372680011596564e-04,
   1.905338231622193e-06,   3.174258382191941e-07,   4.471373515418263e-09,  -2.477912764443859e-10,  -1.029075086402114e-11,   6.019158425706571e-14,   1.329793688240358e-14,
   1.706339643883210e+00,  -1.517379959091984e-02,  -3.367997974565392e-04,   1.916103045655135e-06,   3.165082643445675e-07,   4.419087914423158e-09,  -2.473400447057759e-10,
  -1.017470518306344e-11,   6.255490792171244e-14,   1.315566894762229e-14,   1.706274528210582e+00,  -1.517265862148162e-02,  -3.364316377055088e-04,   1.924544985322714e-06,
   3.157865334050612e-07,   4.378079415621933e-09,  -2.469811628103864e-10,  -1.008367373583306e-11,   6.439450410583044e-14,   1.304378858943062e-14,   1.706236959400384e+00,
  -1.517199941598009e-02,  -3.362192933571953e-04,   1.929404978715976e-06,   3.153701713381625e-07,   4.354468853627208e-09,  -2.467725461643019e-10,  -1.003125675593887e-11,
   6.544804667785053e-14,   1.297925554288998e-14,   1.706222853963790e+00,  -1.517175173998794e-02,  -3.361395801021108e-04,   1.931227686046603e-06,   3.152138541422673e-07,
   4.345613472627903e-09,  -2.466939262277079e-10,  -1.001159615416053e-11,   6.584213080816361e-14,   1.295502954631170e-14,   1.706220515892598e+00,  -1.517171067688280e-02,
  -3.361263677634817e-04,   1.931529706262058e-06,   3.151879439620646e-07,   4.344146126447451e-09,  -2.466808789788881e-10,  -1.000833831458377e-11,   6.590737519347761e-14,
   1.295101410279022e-14,   5.859902157349056e-03,  -1.015544374907480e-04,   1.307551895329129e-06,  -1.340550777671796e-08,   2.329628834675010e-10,  -1.370905270851591e-12,
  -7.282219600026431e-14,  -2.493187123219170e-15,   5.880265664618756e-17,   3.793950713135111e-18,   5.860088629848226e-03,  -1.015601677140278e-04,   1.307749945829657e-06,
  -1.340751881088417e-08,   2.328102344408235e-10,  -1.378059549324186e-12,  -7.258677520645781e-14,  -2.474534743269988e-15,   5.885986201899969e-17,   3.764609592345953e-18,
   5.860394774877196e-03,  -1.015695754377097e-04,   1.308074984473231e-06,  -1.341082748516108e-08,   2.325600001215266e-10,  -1.389764674216160e-12,  -7.220015001166602e-14,
  -2.444021448656197e-15,   5.895012269516476e-17,   3.716578993048861e-18,   5.860719645922161e-03,  -1.015795586235991e-04,   1.308419748909925e-06,  -1.341434805678274e-08,
   2.322949766604595e-10,  -1.402130777295983e-12,  -7.178972094869070e-14,  -2.411790449506108e-15,   5.904096421464310e-17,   3.665802028408676e-18,   5.860975341054525e-03,
  -1.015874160698279e-04,   1.308690988706471e-06,  -1.341712585228649e-08,   2.320867599124038e-10,  -1.411824011407225e-12,  -7.146657809693638e-14,  -2.386529945783068e-15,
   5.910890971936000e-17,   3.625975994748457e-18,   5.861122915696178e-03,  -1.015919510071245e-04,   1.308847489800357e-06,  -1.341873180755377e-08,   2.319667375298043e-10,
  -1.417402584342080e-12,  -7.128003416977234e-14,  -2.371993816879481e-15,   5.914670825398904e-17,   3.603046059258582e-18,   5.861178332949891e-03,  -1.015936539687340e-04,
   1.308906250585095e-06,  -1.341933539492247e-08,   2.319216950718038e-10,  -1.419494452674154e-12,  -7.120997543895088e-14,  -2.366543323850217e-15,   5.916063561395659e-17,
   3.594445937453262e-18,   5.861187519232491e-03,  -1.015939362615064e-04,   1.308915990660640e-06,  -1.341943547638589e-08,   2.319142300715024e-10,  -1.419841054721959e-12,
  -7.119836169762495e-14,  -2.365640246745677e-15,   5.916293024372206e-17,   3.593020887517406e-18,   5.303961058377340e-02,  -9.162420662742492e-04,   1.163448127291830e-05,
  -1.148886900423096e-07,   1.986641793714442e-09,  -9.889415397341977e-12,  -7.170820112282024e-13,  -2.253663971144404e-14,   5.371657031895692e-16,   3.535689001831046e-17,
   5.304126964983166e-02,  -9.162911665317661e-04,   1.163616904029912e-05,  -1.149033062075681e-07,   1.985136666831645e-09,  -9.954001636263895e-12,  -7.149311240262572e-13,
  -2.236279417600513e-14,   5.377037208208477e-16,   3.508415874818396e-17,   5.304399344759576e-02,  -9.163717771893543e-04,   1.163893886294772e-05,  -1.149273662982616e-07,
   1.982669081073408e-09,  -1.005965961642337e-11,  -7.113987405825957e-13,  -2.207839884452495e-14,   5.385527967388849e-16,   3.463770067627707e-17,   5.304688384170659e-02,
  -9.164573176424291e-04,   1.164187660873907e-05,  -1.149529844420857e-07,   1.980055299947701e-09,  -1.017126815123875e-11,  -7.076488215920722e-13,  -2.177799024246345e-14,
   5.394075789613827e-16,   3.416570825567601e-17,   5.304915876656680e-02,  -9.165246430093332e-04,   1.164418772588531e-05,  -1.149732099906450e-07,   1.978001512459410e-09,
  -1.025874157502284e-11,  -7.046963631916035e-13,  -2.154254742969505e-14,   5.400471025552265e-16,   3.379550482306734e-17,   5.305047173812257e-02,  -9.165634996340855e-04,
   1.164552115461487e-05,  -1.149849081251893e-07,   1.976817543367045e-09,  -1.030907896182369e-11,  -7.029919532723465e-13,  -2.140706107263291e-14,   5.404029507865879e-16,
   3.358235758100450e-17,   5.305096478483659e-02,  -9.165780910309875e-04,   1.164602180194346e-05,  -1.149893057186413e-07,   1.976373199178139e-09,  -1.032795373601546e-11,
  -7.023518396926381e-13,  -2.135625866582297e-14,   5.405340827253602e-16,   3.350241406668335e-17,   5.305104651506407e-02,  -9.165805097822444e-04,   1.164610478779577e-05,
  -1.149900349372255e-07,   1.976299555851271e-09,  -1.033108105461889e-11,  -7.022457269584996e-13,  -2.134784134515644e-14,   5.405556884350974e-16,   3.348916731878378e-17,
   1.490645328307753e-01,  -2.557013459669960e-03,   3.147458724608528e-05,  -2.836987485129601e-07,   4.855102576094903e-09,  -1.315245433266977e-11,  -2.346961385344473e-12,
  -6.378469219895273e-14,   1.553483279718082e-15,   1.054614105117822e-16,   1.490690201755904e-01,  -2.557134648756043e-03,   3.147870481792327e-05,  -2.837189977442206e-07,
   4.850166686590917e-09,  -1.333482832388404e-11,  -2.340738903203564e-12,  -6.326610502311564e-14,   1.555145166740011e-15,   1.046496739383520e-16,   1.490763872976302e-01,
  -2.557333606863606e-03,   3.148546145608432e-05,  -2.837524243123002e-07,   4.842073241334010e-09,  -1.363311865443488e-11,  -2.330519494839910e-12,  -6.241773753822587e-14,
   1.557770419856897e-15,   1.033208401591498e-16,   1.490842049532230e-01,  -2.557544725806646e-03,   3.149262666696439e-05,  -2.837881421815052e-07,   4.833498542747580e-09,
  -1.394812798449141e-11,  -2.319670368762911e-12,  -6.152159278097323e-14,   1.560416879170303e-15,   1.019159660220305e-16,   1.490903579016250e-01,  -2.557710884074369e-03,
   3.149826275643404e-05,  -2.838164326364484e-07,   4.826759677072434e-09,  -1.419495886182413e-11,  -2.311128160635779e-12,  -6.081924025128477e-14,   1.562399585149350e-15,
   1.008140357533177e-16,   1.490939090537221e-01,  -2.557806779893239e-03,   3.150151426454052e-05,  -2.838328317271985e-07,   4.822874341609340e-09,  -1.433697652345209e-11,
  -2.306196767429639e-12,  -6.041506660427065e-14,   1.563503949008866e-15,   1.001795802886525e-16,   1.490952425778772e-01,  -2.557842790225480e-03,   3.150273501347047e-05,
  -2.838390033606339e-07,   4.821416077024696e-09,  -1.439022378365550e-11,  -2.304344698218852e-12,  -6.026351585742611e-14,   1.563911134149110e-15,   9.994161778066121e-17,
   1.490954636302410e-01,  -2.557848759479822e-03,   3.150293735822783e-05,  -2.838400271148373e-07,   4.821174386650967e-09,  -1.439904596735740e-11,  -2.304037676477529e-12,
  -6.023840577722071e-14,   1.563978235126347e-15,   9.990218696120425e-17,   2.975980634336912e-01,  -5.042467070803140e-03,   5.859943219790922e-05,  -4.317500998190329e-07,
   7.283126284142297e-09,   1.939801155905984e-11,  -5.685806347612234e-12,  -1.330277724193401e-13,   3.339653716522596e-15,   2.311807275354454e-16,   2.976064149314105e-01,
  -5.042651308793980e-03,   5.860558306749667e-05,  -4.317256826238939e-07,   7.271148403108606e-09,   1.901853124064282e-11,  -5.672421439346584e-12,  -1.318911888210650e-13,
   3.343616835029360e-15,   2.293937482490837e-16,   2.976201258887828e-01,  -5.042953758485815e-03,   5.861567337427096e-05,  -4.316859806990298e-07,   7.251505461857140e-09,
   1.839797695534843e-11,  -5.650437853917364e-12,  -1.300318579802822e-13,   3.349891977606236e-15,   2.264683117081785e-16,   2.976346751195989e-01,  -5.043274671823921e-03,
   5.862636999946652e-05,  -4.316443728664091e-07,   7.230690908698828e-09,   1.774280769515080e-11,  -5.627098213065711e-12,  -1.280678564596490e-13,   3.356238413836443e-15,
   2.233753309772345e-16,   2.976461260524605e-01,  -5.043527225724169e-03,   5.863478108655366e-05,  -4.316120019786434e-07,   7.214330115634118e-09,   1.722955972073910e-11,
  -5.608720402235932e-12,  -1.265286020129340e-13,   3.361008713673804e-15,   2.209492132392080e-16,   2.976527348548512e-01,  -5.043672976895853e-03,   5.863963239981128e-05,
  -4.315934699545573e-07,   7.204896149095496e-09,   1.693430377458591e-11,  -5.598110535861942e-12,  -1.256428393326141e-13,   3.363672296825179e-15,   2.195522941607624e-16,
   2.976552165721842e-01,  -5.043727707416362e-03,   5.864145357023668e-05,  -4.315865392767170e-07,   7.201355144733413e-09,   1.682361145871324e-11,  -5.594125742328556e-12,
  -1.253107120988932e-13,   3.364655650194784e-15,   2.190283502270520e-16,   2.976556279547981e-01,  -5.043736779757533e-03,   5.864175542650681e-05,  -4.315853919086260e-07,
   7.200768254027405e-09,   1.680527207223041e-11,  -5.593465169986507e-12,  -1.252556828535458e-13,   3.364817767676416e-15,   2.189415313748788e-16,   5.051325205516742e-01,
  -8.381515781083886e-03,   8.744226602618956e-05,  -3.573261157206812e-07,   6.150713396628175e-09,   1.353254119589885e-10,  -1.173162806061431e-11,  -2.616252855222305e-13,
   6.713481443943579e-15,   4.513452435528162e-16,   5.051449745058046e-01,  -8.381667674497684e-03,   8.744737786427405e-05,  -3.571398094545492e-07,   6.125990976981306e-09,
   1.345788017342909e-10,  -1.170470572637902e-11,  -2.594078501315494e-13,   6.722203567991902e-15,   4.477978583618957e-16,   5.051654201911243e-01,  -8.381916976089388e-03,
   8.745575461865638e-05,  -3.568347109314231e-07,   6.085446745860771e-09,   1.333578484352489e-10,  -1.166048592989815e-11,  -2.557805853609449e-13,   6.736051855378963e-15,
   4.419902722535263e-16,   5.051871153277646e-01,  -8.382181428321384e-03,   8.746462241948782e-05,  -3.565119990687588e-07,   6.042482767715372e-09,   1.320687333337554e-10,
  -1.161353555752126e-11,  -2.519494318667295e-13,   6.750110446064884e-15,   4.358497899989285e-16,   5.052041900091294e-01,  -8.382389498670300e-03,   8.747158653377073e-05,
  -3.562587604848729e-07,   6.008710873228401e-09,   1.310588224832937e-10,  -1.157656439872899e-11,  -2.489470507205538e-13,   6.760717573536520e-15,   4.310330254573980e-16,
   5.052140443397682e-01,  -8.382509558143496e-03,   8.747559969467151e-05,  -3.561129064328287e-07,   5.989236884460212e-09,   1.304778349665263e-10,  -1.155521940187419e-11,
  -2.472194229152547e-13,   6.766656950583968e-15,   4.282595312302190e-16,   5.052177447763383e-01,  -8.382554637516247e-03,   8.747710554936393e-05,  -3.560581924418607e-07,
   5.981927314339811e-09,   1.302600179129015e-10,  -1.154720261220685e-11,  -2.465716453940407e-13,   6.768852926989730e-15,   4.272192589127961e-16,   5.052183581786407e-01,
  -8.382562109848524e-03,   8.747735510688300e-05,  -3.560491257488247e-07,   5.980715812348684e-09,   1.302239300466087e-10,  -1.154587363433807e-11,  -2.464643178230454e-13,
   6.769215133960386e-15,   4.270468823446258e-16,   7.828011543278249e-01,  -1.250382196964731e-02,   1.028131975329437e-04,   4.275422946599314e-07,  -3.742930003262450e-09,
   3.407098733567978e-10,  -2.018442474243566e-11,  -5.824800741799613e-13,   1.426248850072901e-14,   8.904633476620084e-16,   7.828157784876391e-01,  -1.250363778184355e-02,
   1.028097617265448e-04,   4.280131025217747e-07,  -3.785336679942768e-09,   3.390386449287347e-10,  -2.012728164534737e-11,  -5.781079722748016e-13,   1.427848052620836e-14,
   8.833636456009016e-16,   7.828397860217921e-01,  -1.250333526572342e-02,   1.028040953393242e-04,   4.287843195852883e-07,  -3.854865786653199e-09,   3.363043737538631e-10,
  -2.003343152736833e-11,  -5.709565051161413e-13,   1.430375854916708e-14,   8.717405217858869e-16,   7.828652593383421e-01,  -1.250301407998263e-02,   1.027980476194281e-04,
   4.296003485138188e-07,  -3.928521483099244e-09,   3.334157377294852e-10,  -1.993379580234776e-11,  -5.634035781573415e-13,   1.432926303089695e-14,   8.594513354974172e-16,
   7.828853065855548e-01,  -1.250276116577300e-02,   1.027932625371556e-04,   4.302409121820261e-07,  -3.986401953390957e-09,   3.311514914832265e-10,  -1.985534441424686e-11,
  -5.574849147702588e-13,   1.434838781349715e-14,   8.498115066069172e-16,   7.828968760885324e-01,  -1.250261514825254e-02,   1.027904907607120e-04,   4.306099317776483e-07,
  -4.019771043243051e-09,   3.298484007334948e-10,  -1.981005392065332e-11,  -5.540793549254492e-13,   1.435904747379962e-14,   8.442609556689293e-16,   7.829012205225306e-01,
  -1.250256030668627e-02,   1.027894480018617e-04,   4.307483772972773e-07,  -4.032294878251596e-09,   3.293597661529761e-10,  -1.979304416444801e-11,  -5.528024623342866e-13,
   1.436297916004402e-14,   8.421790876994885e-16,   7.829019406730982e-01,  -1.250255121535609e-02,   1.027892750479033e-04,   4.307713200329810e-07,  -4.034370535491639e-09,
   3.292788042994939e-10,  -1.979022441122249e-11,  -5.525909008235404e-13,   1.436362714746696e-14,   8.418341159756286e-16,   1.150353355464617e+00,  -1.690452554850484e-02,
   5.415622845469233e-05,   3.195112909747299e-06,  -1.675297260429015e-08,  -8.883492053462216e-11,  -2.037852259808245e-11,  -1.446233894473320e-12,   2.611534493227453e-14,
   2.333172895993013e-15,   1.150361033043689e+00,  -1.690316206070505e-02,   5.414168520447639e-05,   3.194951703145042e-06,  -1.679523386549615e-08,  -9.297477536159982e-11,
  -2.027424322335307e-11,  -1.434773684068018e-12,   2.612804383989042e-14,   2.314736211255065e-15,   1.150373635498847e+00,  -1.690092373254893e-02,   5.411778441776730e-05,
   3.194682873556093e-06,  -1.686445158933146e-08,  -9.974658220584861e-11,  -2.010302785861165e-11,  -1.416027503292460e-12,   2.614667446446252e-14,   2.284556539020247e-15,
   1.150387005592394e+00,  -1.689854877252313e-02,   5.409238897835239e-05,   3.194391953332092e-06,  -1.693767815245263e-08,  -1.068988632478449e-10,  -1.992132608073020e-11,
  -1.396228065100770e-12,   2.616345182281380e-14,   2.252652257996915e-15,   1.150397526415322e+00,  -1.689667972434090e-02,   5.407237743911056e-05,   3.194158902116696e-06,
  -1.699514942333896e-08,  -1.125038218609318e-10,  -1.977830748038692e-11,  -1.380712062404576e-12,   2.617450681273784e-14,   2.227629557359371e-15,   1.150403597581944e+00,
  -1.689560108344764e-02,   5.406081830319926e-05,   3.194022765543307e-06,  -1.702825371311289e-08,  -1.157289836207921e-10,  -1.969576217371566e-11,  -1.371783987583005e-12,
   2.618003099989624e-14,   2.213223061654407e-15,   1.150405877250795e+00,  -1.689519604750277e-02,   5.405647582817228e-05,   3.193971335694036e-06,  -1.704067269986350e-08,
  -1.169382576462714e-10,  -1.966476447043942e-11,  -1.368436412572032e-12,   2.618194427450015e-14,   2.207819825716249e-15,   1.150406255132492e+00,  -1.689512890723186e-02,
   5.405575590034679e-05,   3.193962794158207e-06,  -1.704273069144988e-08,  -1.171386168951513e-10,  -1.965962610088958e-11,  -1.367881768044713e-12,   2.618225294368795e-14,
   2.206924507562327e-15,   1.640702496973840e+00,  -1.769952689249227e-02,  -2.830009738420418e-04,   7.304394999640989e-06,   3.295760135460867e-07,  -4.239587266656738e-09,
  -4.372249870677481e-10,  -3.371203170127457e-13,   5.452128644351824e-13,   7.939760826728648e-15,   1.640662779341749e+00,  -1.769642981106305e-02,  -2.827247023982050e-04,
   7.298358718000592e-06,   3.286675172035098e-07,  -4.240009057373462e-09,  -4.351275099815488e-10,  -3.000260249703870e-13,   5.415800380820811e-13,   7.804678885745896e-15,
   1.640597604018993e+00,  -1.769134731354296e-02,  -2.822717109402965e-04,   7.288448990412221e-06,   3.271792698240132e-07,  -4.240623665756596e-09,  -4.316945062623148e-10,
  -2.396165381187376e-13,   5.356367494318460e-13,   7.584699210785543e-15,   1.640528485442718e+00,  -1.768595692261599e-02,  -2.817918022677065e-04,   7.277933782034082e-06,
   3.256044598292994e-07,  -4.241170602709306e-09,  -4.280658504696820e-10,  -1.761754502769451e-13,   5.293583932274716e-13,   7.353687581666322e-15,   1.640474115872068e+00,
  -1.768171648965939e-02,  -2.814146540047301e-04,   7.269658130796995e-06,   3.243682083067517e-07,  -4.241525313317329e-09,  -4.252202094415027e-10,  -1.267206471163518e-13,
   5.244374840356584e-13,   7.173609485299406e-15,   1.640442748989882e+00,  -1.767926998763829e-02,  -2.811972115070723e-04,   7.264882050690447e-06,   3.236559966920559e-07,
  -4.241699812140855e-09,  -4.235819866691272e-10,  -9.836827150892608e-14,   5.216056131685446e-13,   7.070372416154933e-15,   1.640430972465492e+00,  -1.767835144067702e-02,
  -2.811156006960093e-04,   7.263088578866452e-06,   3.233887907720591e-07,  -4.241759645137488e-09,  -4.229675826627175e-10,  -8.775727955746865e-14,   5.205437437573308e-13,
   7.031735763122342e-15,   1.640429020446227e+00,  -1.767819918569658e-02,  -2.811020746985301e-04,   7.262791284942172e-06,   3.233445100425587e-07,  -4.241769263399991e-09,
  -4.228657767337072e-10,  -8.600023155508727e-14,   5.203678041874426e-13,   7.025338026718244e-15,   5.473672233668691e-03,  -9.167691830595466e-05,   1.167785652997569e-06,
  -1.001073985801501e-08,   1.840298639585408e-10,  -3.623445569045223e-12,  -9.727931801913823e-14,   1.284043834444559e-15,   1.561779321130359e-16,   2.654465117942651e-19,
   5.473838731838451e-03,  -9.168121020726204e-05,   1.167941652938927e-06,  -1.001586377163784e-08,   1.838292969096919e-10,  -3.619595566426196e-12,  -9.668000435246766e-14,
   1.284900477490723e-15,   1.550629103282900e-16,   2.464067554950882e-19,   5.474112081404993e-03,  -9.168825763155196e-05,   1.168197630554408e-06,  -1.002427154064651e-08,
   1.835009461339425e-10,  -3.613273634571008e-12,  -9.569930309410660e-14,   1.286238646723454e-15,   1.532397687852410e-16,   2.154625906427603e-19,   5.474402147991586e-03,
  -9.169573763154534e-05,   1.168469077716342e-06,  -1.003318744468271e-08,   1.831537780870574e-10,  -3.606563576535347e-12,  -9.466299884611497e-14,   1.287566550404944e-15,
   1.513152312705867e-16,   1.830506161479724e-19,   5.474630447531921e-03,  -9.170162597840135e-05,   1.168682588925733e-06,  -1.004020040592150e-08,   1.828814489166620e-10,
  -3.601281339462508e-12,  -9.385052305271008e-14,   1.288545495953082e-15,   1.498077963316636e-16,   1.578457182722207e-19,   5.474762209917544e-03,  -9.170502487868015e-05,
   1.168805762743511e-06,  -1.004424615866902e-08,   1.827246400659242e-10,  -3.598232321746495e-12,  -9.338286749255865e-14,   1.289084119318308e-15,   1.489406992959378e-16,
   1.434204241418094e-19,   5.474811689185954e-03,  -9.170630131673036e-05,   1.168852006734922e-06,  -1.004576508336445e-08,   1.826658242993893e-10,  -3.597087286476234e-12,
  -9.320749222025324e-14,   1.289281417153881e-15,   1.486156379061937e-16,   1.380263583251848e-19,   5.474819891145300e-03,  -9.170651291079000e-05,   1.168859671863756e-06,
  -1.004601685127473e-08,   1.826560783040111e-10,  -3.596897475336760e-12,  -9.317843359669389e-14,   1.289313860861798e-15,   1.485617829082727e-16,   1.371334141659731e-19,
   4.955279680816745e-02,  -8.281624854825218e-04,   1.043650875626083e-05,  -8.578471063314530e-08,   1.580508588141155e-09,  -3.160805025522299e-11,  -9.302304801604925e-13,
   1.232957255860727e-14,   1.445757521266349e-15,   2.533747932343607e-18,   4.955428469186083e-02,  -8.281992666130226e-04,   1.043784741770015e-05,  -8.582937897999681e-08,
   1.578588490510261e-09,  -3.157108083766207e-11,  -9.246838841905785e-13,   1.233785321151554e-14,   1.435371470235886e-15,   2.355926779233373e-18,   4.955672742979099e-02,
  -8.282596625034704e-04,   1.044004388288079e-05,  -8.590267123115165e-08,   1.575444783832522e-09,  -3.151037466579218e-11,  -9.156077679614666e-13,   1.235081084142065e-14,
   1.418389619292720e-15,   2.066934534081247e-18,   4.955931954837821e-02,  -8.283237658407926e-04,   1.044237292274116e-05,  -8.598038822819082e-08,   1.572120519919777e-09,
  -3.144594122629402e-11,  -9.060173181782461e-13,   1.236370080078286e-14,   1.400463435432429e-15,   1.764247380266059e-18,   4.956135969311758e-02,  -8.283742289875381e-04,
   1.044420474798617e-05,  -8.604151444254510e-08,   1.569512578827907e-09,  -3.139521822910338e-11,  -8.984984686893981e-13,   1.237322782624871e-14,   1.386422465603046e-15,
   1.528874820254337e-18,   4.956253715415475e-02,  -8.284033576594738e-04,   1.044526147336503e-05,  -8.607677655437100e-08,   1.568010794519411e-09,  -3.136593975620046e-11,
  -8.941707444600515e-13,   1.237848005342399e-14,   1.378345947307440e-15,   1.394169975245002e-18,   4.956297931261457e-02,  -8.284142967864973e-04,   1.044565819800082e-05,
  -8.609001498854171e-08,   1.567447484349836e-09,  -3.135494443059158e-11,  -8.925478209187440e-13,   1.238040599674892e-14,   1.375318191590863e-15,   1.343800372122267e-18,
   4.956305260724269e-02,  -8.284161101572423e-04,   1.044572395623975e-05,  -8.609220929869851e-08,   1.567354140567189e-09,  -3.135312174747221e-11,  -8.922789130330972e-13,
   1.238072281014495e-14,   1.374816564331594e-15,   1.335462128227246e-18,   1.393203212301329e-01,  -2.317556039669439e-03,   2.851637820641456e-05,  -2.116442438305017e-07,
   3.927565911111709e-09,  -8.194648510181312e-11,  -2.907786955792885e-12,   3.872716800670510e-14,   4.269700767411097e-15,   7.774051148719576e-18,   1.393243859951963e-01,
  -2.317646803594474e-03,   2.851969776026974e-05,  -2.117598790125678e-07,   3.921552506541199e-09,  -8.183036764330316e-11,  -2.891413415083723e-12,   3.875288269285917e-14,
   4.238687321904619e-15,   7.240052536845872e-18,   1.393310593011491e-01,  -2.317795842723094e-03,   2.852514369525143e-05,  -2.119495933055382e-07,   3.911705453524424e-09,
  -8.163969549456549e-11,  -2.864621738434829e-12,   3.879318685543404e-14,   4.187979170646976e-15,   6.372268053159037e-18,   1.393381406513680e-01,  -2.317954032926182e-03,
   2.853091730094982e-05,  -2.121507323024555e-07,   3.901290768954125e-09,  -8.143731655816807e-11,  -2.836313166971388e-12,   3.883337359202649e-14,   4.134452303624862e-15,
   5.463444575383870e-18,   1.393437140418190e-01,  -2.318078564307025e-03,   2.853545757993722e-05,  -2.123089120570759e-07,   3.893118771565170e-09,  -8.127800079977794e-11,
  -2.814120418331255e-12,   3.886314722514940e-14,   4.092527313946214e-15,   4.756795123190854e-18,   1.393469306869115e-01,  -2.318150447770363e-03,   2.853807643120677e-05,
  -2.124001535041996e-07,   3.888412319446438e-09,  -8.118604010218065e-11,  -2.801347037834251e-12,   3.887959170113856e-14,   4.068411919324338e-15,   4.352400633496148e-18,
   1.393481385941638e-01,  -2.318177443365187e-03,   2.853905956539378e-05,  -2.124344066563172e-07,   3.886646843751356e-09,  -8.115150490227380e-11,  -2.796557015311584e-12,
   3.888562772325772e-14,   4.059371508546294e-15,   4.201191756024027e-18,   1.393483388234011e-01,  -2.318181918410670e-03,   2.853922251969343e-05,  -2.124400841360634e-07,
   3.886354288101879e-09,  -8.114578003963872e-11,  -2.795763343646909e-12,   3.888662095829050e-14,   4.057873730195201e-15,   4.176160702591735e-18,   2.783357417504965e-01,
  -4.592438360976438e-03,   5.410367070227067e-05,  -3.204835812708015e-07,   6.098840598581208e-09,  -1.423335973832504e-10,  -6.752343880581617e-12,   8.982525641018901e-14,
   9.308134731945336e-15,   1.683388401885243e-17,   2.783434514120109e-01,  -4.592575889587865e-03,   5.410879909476888e-05,  -3.206838584868301e-07,   6.084848768765269e-09,
  -1.420643445435368e-10,  -6.716666604456627e-12,   8.988008180075598e-14,   9.239658995383277e-15,   1.564490338338722e-17,   2.783561085844532e-01,  -4.592801726334796e-03,
   5.411720967934025e-05,  -3.210123687105987e-07,   6.061933213866105e-09,  -1.416222240278312e-10,  -6.658291167055670e-12,   8.996583418734227e-14,   9.127702589855667e-15,
   1.371297196805317e-17,   2.783695395226394e-01,  -4.593041439807822e-03,   5.412612242317474e-05,  -3.213605666121227e-07,   6.037691671911221e-09,  -1.411529711750567e-10,
  -6.596614056993249e-12,   9.005108454545506e-14,   9.009528298164462e-15,   1.169000678559782e-17,   2.783801102480294e-01,  -4.593230155795019e-03,   5.413312846088392e-05,
  -3.216343273167473e-07,   6.018666635552861e-09,  -1.407835772969997e-10,  -6.548264240736110e-12,   9.011405251972165e-14,   8.916972067098629e-15,   1.011730314797977e-17,
   2.783862110232557e-01,  -4.593339091610246e-03,   5.413716844440834e-05,  -3.217922105804473e-07,   6.007708192093840e-09,  -1.405703582847644e-10,  -6.520436750802943e-12,
   9.014874944913571e-14,   8.863734993503577e-15,   9.217387436580970e-18,   2.783885019633550e-01,  -4.593380002651262e-03,   5.413868486806274e-05,  -3.218514766384085e-07,
   6.003597204201730e-09,  -1.404902860386808e-10,  -6.510001619881055e-12,   9.016146913291879e-14,   8.843777708567223e-15,   8.880914233121376e-18,   2.783888817214905e-01,
  -4.593386784482383e-03,   5.413893620374986e-05,  -3.218612997449738e-07,   6.002915960886654e-09,  -1.404770125844685e-10,  -6.508272605019483e-12,   9.016356131197438e-14,
   8.840471282858586e-15,   8.825215559467582e-18,   4.729808725680248e-01,  -7.697359941058740e-03,   8.377924012911501e-05,  -2.544263566668706e-07,   5.635606393587743e-09,
  -1.954915167950965e-10,  -1.377679042531123e-11,   1.799704377336130e-13,   1.835806778027682e-14,   2.799619077176726e-17,   4.729928043185079e-01,  -7.697469527140155e-03,
   8.378389056028031e-05,  -2.547000038354240e-07,   5.607029861609429e-09,  -1.949525198759850e-10,  -1.370645106945404e-11,   1.800509996305079e-13,   1.822176193421770e-14,
   2.561605794764980e-17,   4.730123926712491e-01,  -7.697649513806174e-03,   8.379150762228042e-05,  -2.551486851531382e-07,   5.560223896979177e-09,  -1.940675352274484e-10,
  -1.359136487517592e-11,   1.801747497391795e-13,   1.799892112607991e-14,   2.174962883508360e-17,   4.730331780426519e-01,  -7.697840606794174e-03,   8.379956633748651e-05,
  -2.556240166397226e-07,   5.510704299712449e-09,  -1.931283258760353e-10,  -1.346977436972841e-11,   1.802945802649124e-13,   1.776372637123686e-14,   1.770231555460058e-17,
   4.730495366838811e-01,  -7.697991079884036e-03,   8.380589154674290e-05,  -2.559975590100434e-07,   5.471836954069415e-09,  -1.923890461662743e-10,  -1.337446086377310e-11,
   1.803806408943069e-13,   1.757953374071640e-14,   1.455677680435808e-17,   4.730589777536436e-01,  -7.698077953653601e-03,   8.380953512660576e-05,  -2.562129187368532e-07,
   5.449447789514455e-09,  -1.919623490040806e-10,  -1.331960506772487e-11,   1.804270233790644e-13,   1.747359513637936e-14,   1.275724869708405e-17,   4.730625230028410e-01,
  -7.698110581815913e-03,   8.381090203872153e-05,  -2.562937470838205e-07,   5.441048352885219e-09,  -1.918021118862354e-10,  -1.329903475993252e-11,   1.804438220799545e-13,
   1.743388255167112e-14,   1.208448734137236e-17,   4.730631106804142e-01,  -7.698115990727750e-03,   8.381112855603058e-05,  -2.563071433566986e-07,   5.439656443467113e-09,
  -1.917755498708275e-10,  -1.329562644409590e-11,   1.804465741428809e-13,   1.742730322872203e-14,   1.197312440999941e-17,   7.344623733454400e-01,  -1.166148802413312e-02,
   1.077118881402814e-04,   3.916018155896973e-07,  -2.705721778935692e-09,  -2.595855230918656e-10,  -2.563921018710385e-11,   3.182227761490860e-13,   3.687560590785063e-14,
   2.710615035799742e-17,   7.344776962845893e-01,  -1.166132211581056e-02,   1.077092780737775e-04,   3.912404352636947e-07,  -2.758781740718636e-09,  -2.586345202001118e-10,
  -2.549796247252746e-11,   3.182384858249261e-13,   3.659971411240598e-14,   2.243849587640297e-17,   7.345028510538025e-01,  -1.166104986006968e-02,   1.077049610079306e-04,
   3.906481489925713e-07,  -2.845673336548931e-09,  -2.570733394485045e-10,  -2.526686494128248e-11,   3.182476334507910e-13,   3.614873135579014e-14,   1.486105064893579e-17,
   7.345295417779989e-01,  -1.166076112450469e-02,   1.077003365501381e-04,   3.900210166265767e-07,  -2.937580598367156e-09,  -2.554168855905600e-10,  -2.502271434016890e-11,
   3.182348909783095e-13,   3.567282998695018e-14,   6.935852030561944e-18,   7.345505472054669e-01,  -1.166053399571613e-02,   1.076966654810862e-04,   3.895284224394806e-07,
  -3.009701601714293e-09,  -2.541133203414277e-10,  -2.483133288404944e-11,   3.182087415152375e-13,   3.530018819938224e-14,   7.813379216797551e-19,   7.345626697226099e-01,
  -1.166040295834686e-02,   1.076945341883419e-04,   3.892445224114059e-07,  -3.051239835126194e-09,  -2.533610413838092e-10,  -2.472118931279232e-11,   3.181872314224360e-13,
   3.508588689749844e-14,  -2.737630011902150e-18,   7.345672218245126e-01,  -1.166035376065217e-02,   1.076937314784969e-04,   3.891379880284586e-07,  -3.066821958715584e-09,
  -2.530785601716775e-10,  -2.467988712820590e-11,   3.181779461101373e-13,   3.500555756644152e-14,  -4.052839817972849e-18,   7.345679763993024e-01,  -1.166034560585939e-02,
   1.076935982919140e-04,   3.891203322753493e-07,  -3.069404080637971e-09,  -2.530317352517792e-10,  -2.467304374800743e-11,   3.181763433315687e-13,   3.499224936461316e-14,
  -4.270528325356618e-18,   1.083837681654185e+00,  -1.632283287881931e-02,   9.071316309145127e-05,   2.875167987647354e-06,  -2.589784671500688e-08,  -8.965385449502581e-10,
  -3.770194364392974e-11,   5.241431516695750e-13,   8.308106882965156e-14,   7.538829588532848e-18,   1.083850545458082e+00,  -1.632160986444256e-02,   9.069061744453272e-05,
   2.873905336613216e-06,  -2.597458283124144e-08,  -8.949759063779066e-10,  -3.738515136828871e-11,   5.239389157079202e-13,   8.238926624155241e-14,  -1.695517914771044e-18,
   1.083871661087466e+00,  -1.631960247487746e-02,   9.065355893700154e-05,   2.871834095979622e-06,  -2.610007634717276e-08,  -8.924111772247351e-10,  -3.686704796809129e-11,
   5.235709392716720e-13,   8.125879288398441e-14,  -1.665520369018516e-17,   1.083894063156331e+00,  -1.631747300436577e-02,   9.061417439434927e-05,   2.869638531017698e-06,
  -2.623258226429725e-08,  -8.896906475535397e-10,  -3.631995908368657e-11,   5.231364557848329e-13,   8.006635998829734e-14,  -3.225897843562965e-17,   1.083911691350272e+00,
  -1.631579747975722e-02,   9.058313335199448e-05,   2.867912188934469e-06,  -2.633639404561367e-08,  -8.875502183959645e-10,  -3.589131593523958e-11,   5.227629441929848e-13,
   7.913302059023952e-14,  -4.434574124019555e-17,   1.083921863982304e+00,  -1.631483065394394e-02,   9.056520088209164e-05,   2.866916516020145e-06,  -2.639611744796975e-08,
  -8.863152018106570e-10,  -3.564470458754582e-11,   5.225348295559810e-13,   7.859641475963857e-14,  -5.124424886150855e-17,   1.083925683728402e+00,  -1.631446762999650e-02,
   9.055846364940675e-05,   2.866542750543257e-06,  -2.641850861881282e-08,  -8.858514923928588e-10,  -3.555224429399680e-11,   5.224468094593417e-13,   7.839529924631337e-14,
  -5.382021982598473e-17,   1.083926316896580e+00,  -1.631440745509796e-02,   9.055734667677941e-05,   2.866480799874738e-06,  -2.642221840112407e-08,  -8.857746286687453e-10,
  -3.553692530539923e-11,   5.224320946191029e-13,   7.836198177970177e-14,  -5.424646123606779e-17,   1.566045062049854e+00,  -1.953329314957074e-02,  -1.682736265932942e-04,
   1.136292359008424e-05,   1.497015593267309e-07,  -1.280334838069535e-08,  -1.984221744896126e-10,   1.612343724232642e-11,   3.054928612122506e-13,  -2.070115002473085e-14,
   1.566021367826503e+00,  -1.952850497582366e-02,  -1.681481204558255e-04,   1.134509532571703e-05,   1.492916650179559e-07,  -1.275676681539841e-08,  -1.972650764375656e-10,
   1.602251248577354e-11,   3.025644097801057e-13,  -2.050839592437307e-14,   1.565982482464952e+00,  -1.952064982375018e-02,  -1.679423304803550e-04,   1.131587459460098e-05,
   1.486205107328570e-07,  -1.268051033225828e-08,  -1.953737719188337e-10,   1.585752806624666e-11,   2.977873973285390e-13,  -2.019379616935153e-14,   1.565941239121583e+00,
  -1.951232224519076e-02,  -1.677243087819382e-04,   1.128493323806910e-05,   1.479107405288951e-07,  -1.259988727979338e-08,  -1.933781291695094e-10,   1.568341439397488e-11,
   2.927598523416311e-13,  -1.986246613571159e-14,   1.565908792713863e+00,  -1.950577370889496e-02,  -1.675529683703000e-04,   1.126062854276974e-05,   1.473538628219777e-07,
  -1.253664654272735e-08,  -1.918156035740992e-10,   1.554706919169617e-11,   2.888328174276791e-13,  -1.960349688011778e-14,   1.565890072192647e+00,  -1.950199654776399e-02,
  -1.674541820502389e-04,   1.124662036241879e-05,   1.470331635685011e-07,  -1.250023305617709e-08,  -1.909170564729637e-10,   1.546865461459677e-11,   2.865782810195033e-13,
  -1.945475468372347e-14,   1.565883043383164e+00,  -1.950057858802695e-02,  -1.674171052309792e-04,   1.124136365097547e-05,   1.469128672159626e-07,  -1.248657527786270e-08,
  -1.905802496992898e-10,   1.543926063097540e-11,   2.857339093908784e-13,  -1.939903509020393e-14,   1.565881878306562e+00,  -1.950034356209653e-02,  -1.674109601891112e-04,
   1.124049246033947e-05,   1.468929331952743e-07,  -1.248431214105462e-08,  -1.905244511211530e-10,   1.543439086998271e-11,   2.855940601327666e-13,  -1.938980586052868e-14,
   5.124950804305665e-03,  -8.277132350297274e-05,   1.062578318968342e-06,  -7.750887036919954e-09,   9.388967281385361e-11,  -5.005989396878849e-12,  -4.270012284434746e-16,
   4.976294937724174e-15,   3.396706014288640e-17,  -6.268945016427362e-18,   5.125102178229087e-03,  -8.277465724426951e-05,   1.062658490198553e-06,  -7.757889917071533e-09,
   9.389026414868791e-11,  -4.991604665003896e-12,  -2.995483708520591e-16,   4.945654684742338e-15,   3.358267721057730e-17,  -6.213494408178806e-18,   5.125350691277932e-03,
  -8.278013225309750e-05,   1.062790105088672e-06,  -7.769371683775406e-09,   9.389142741314961e-11,  -4.968055031605501e-12,  -9.139639564906217e-17,   4.895555270752343e-15,
   3.295593003442458e-17,  -6.122968461746530e-18,   5.125614394050429e-03,  -8.278594455710079e-05,   1.062929759866068e-06,  -7.781534926922663e-09,   9.389292244107697e-11,
  -4.943155470356276e-12,   1.280043558871638e-16,   4.842668791680183e-15,   3.229668564823786e-17,  -6.027596699763197e-18,   5.125821937642502e-03,  -8.279052096614694e-05,
   1.063039669833329e-06,  -7.791093156819854e-09,   9.389428709621377e-11,  -4.923623218468397e-12,   2.996187047984741e-16,   4.801243629331092e-15,   3.178201754809950e-17,
  -5.953030706365652e-18,   5.125941718364627e-03,  -8.279316294055796e-05,   1.063103101411237e-06,  -7.796603672841384e-09,   9.389514981819661e-11,  -4.912376300986520e-12,
   3.982394323642028e-16,   4.777414975362121e-15,   3.148665174957844e-17,  -5.910193607411412e-18,   5.125986697832439e-03,  -8.279415518677629e-05,   1.063126920674510e-06,
  -7.798671845362213e-09,   9.389548795610159e-11,  -4.908157789299054e-12,   4.351930744573620e-16,   4.768481907486238e-15,   3.137605154766024e-17,  -5.894144869477634e-18,
   5.125994153855530e-03,  -8.279431967415247e-05,   1.063130869062345e-06,  -7.799014617558234e-09,   9.389554475454235e-11,  -4.907458764581675e-12,   4.413144846582553e-16,
   4.767001905145288e-15,   3.135773444693801e-17,  -5.891486511868733e-18,   4.640114616604282e-02,  -7.484131546804857e-04,   9.534570183132511e-06,  -6.655920488691081e-08,
   7.786374746780423e-10,  -4.497108972478133e-11,  -2.146775903096950e-14,   4.646603671227342e-14,   3.093873545777386e-16,  -5.832560447848067e-17,   4.640250434203633e-02,
  -7.484417921538725e-04,   9.535234842668696e-06,  -6.662207195706952e-08,   7.786053207979810e-10,  -4.483675538288811e-11,  -2.030813330958081e-14,   4.618101331979491e-14,
   3.058240706043097e-16,  -5.780779310738830e-17,   4.640473407614863e-02,  -7.484888243391123e-04,   9.536325973346892e-06,  -6.672514212711571e-08,   7.785542856778581e-10,
  -4.461683059094430e-11,  -1.841445407051370e-14,   4.571498301732766e-14,   3.000142172109101e-16,  -5.696245556794104e-17,   4.640710008935931e-02,  -7.485387551105307e-04,
   9.537483726817369e-06,  -6.683432263807587e-08,   7.785025044544376e-10,  -4.438429583938414e-11,  -1.641868923834653e-14,   4.522303679262162e-14,   2.939033645201755e-16,
  -5.607188901993907e-17,   4.640896222151584e-02,  -7.485780696883578e-04,   9.538394870485586e-06,  -6.692011466182259e-08,   7.784634624906845e-10,  -4.420188351929598e-11,
  -1.485779220691804e-14,   4.483770989321074e-14,   2.891328354025482e-16,  -5.537561901117694e-17,   4.641003692138455e-02,  -7.486007664295132e-04,   9.538920703691062e-06,
  -6.696957344491884e-08,   7.784416139736703e-10,  -4.409684724088547e-11,  -1.396087258666094e-14,   4.461606427797475e-14,   2.863951199269383e-16,  -5.497562803916516e-17,
   4.641044048697308e-02,  -7.486092907039800e-04,   9.539118158243533e-06,  -6.698813561346227e-08,   7.784335385467774e-10,  -4.405744988491347e-11,  -1.362480647145454e-14,
   4.453297260395611e-14,   2.853699912507940e-16,  -5.482577428560761e-17,   4.641050738401503e-02,  -7.486107037995122e-04,   9.539150889107227e-06,  -6.699121202621892e-08,
   7.784322067234810e-10,  -4.405092157157818e-11,  -1.356913749024082e-14,   4.451920626689642e-14,   2.852002148200172e-16,  -5.480095215469678e-17,   1.304915906294332e-01,
  -2.098661907444507e-03,   2.628898056574122e-05,  -1.650710626904409e-07,   1.754129565367653e-09,  -1.244942828793627e-10,  -1.609463789535436e-13,   1.392442500220813e-13,
   8.828854447958190e-16,  -1.738706883316016e-16,   1.304953347529828e-01,  -2.098732993193760e-03,   2.629047661197182e-05,  -1.652448399452694e-07,   1.753824927874790e-09,
  -1.240916483191895e-10,  -1.576442227342733e-13,   1.383948905410423e-13,   8.723740384022251e-16,  -1.723155015633456e-16,   1.305014814915502e-01,  -2.098849744795259e-03,
   2.629293243825880e-05,  -1.655297148732280e-07,   1.753329797449182e-09,  -1.234324664779830e-10,  -1.522527913457250e-13,   1.370061802347116e-13,   8.552366933733636e-16,
  -1.697767343533902e-16,   1.305080038652981e-01,  -2.098973699014483e-03,   2.629553802258490e-05,  -1.658314349277365e-07,   1.752811171256557e-09,  -1.227354741425866e-10,
  -1.465720999913461e-13,   1.355403024297939e-13,   8.372131986232428e-16,  -1.671022769682843e-16,   1.305131371590768e-01,  -2.099071303530097e-03,   2.629758846071081e-05,
  -1.660684896838431e-07,   1.752407874371079e-09,  -1.221887065936616e-10,  -1.421302073999807e-13,   1.343921661038539e-13,   8.231441184785408e-16,  -1.650114148442115e-16,
   1.305160997439689e-01,  -2.099127653788870e-03,   2.629877174075356e-05,  -1.662051383328716e-07,   1.752177067531921e-09,  -1.218738637841577e-10,  -1.395782180319946e-13,
   1.337317583878048e-13,   8.150706350337786e-16,  -1.638103046101092e-16,   1.305172122355233e-01,  -2.099148817797749e-03,   2.629921606139336e-05,  -1.662564209944265e-07,
   1.752090763894466e-09,  -1.217557706888679e-10,  -1.386220912391021e-13,   1.334841844676111e-13,   8.120476383907954e-16,  -1.633603251070349e-16,   1.305173966475274e-01,
  -2.099152326242240e-03,   2.629928971322619e-05,  -1.662649202337658e-07,   1.752076477154099e-09,  -1.217362021063119e-10,  -1.384637139089280e-13,   1.334431674576844e-13,
   8.115469904603133e-16,  -1.632857898493568e-16,   2.608092829621307e-01,  -4.173600243553068e-03,   5.072463987697097e-05,  -2.530446265952706e-07,   1.999811437686355e-09,
  -2.432408825448345e-10,  -6.221718244394406e-13,   3.077141436661085e-13,   1.818302609909960e-15,  -3.835267018852517e-16,   2.608165048705697e-01,  -4.173709468879285e-03,
   5.072634037128042e-05,  -2.533832900928645e-07,   1.998563244378468e-09,  -2.423510316125033e-10,  -6.153902557688939e-13,   3.058416649320093e-13,   1.795712976103367e-15,
  -3.800563197181252e-16,   2.608283609762441e-01,  -4.173888882697834e-03,   5.072913126271300e-05,  -2.539383580518467e-07,   1.996524352361101e-09,  -2.408941823619919e-10,
  -6.043207788458274e-13,   3.027802943998037e-13,   1.758889132067931e-15,  -3.743915172728541e-16,   2.608409414574293e-01,  -4.174079394148709e-03,   5.073209160482524e-05,
  -2.545261030449003e-07,   1.994374766465382e-09,  -2.393537540017341e-10,  -5.926611943891516e-13,   2.995490119234441e-13,   1.720168378647294e-15,  -3.684245262878082e-16,
   2.608508425336125e-01,  -4.174229428563355e-03,   5.073442068142353e-05,  -2.549877762379612e-07,   1.992693007482605e-09,  -2.381453279165329e-10,  -5.835469798060765e-13,
   2.970182827935577e-13,   1.689948284918701e-15,  -3.637600145835453e-16,   2.608565567069785e-01,  -4.174316056765879e-03,   5.073576454603758e-05,  -2.552538626021085e-07,
   1.991726416971766e-09,  -2.374494807632156e-10,  -5.783117130239386e-13,   2.955626662015511e-13,   1.672608688718353e-15,  -3.610806205634223e-16,   2.608587024488809e-01,
  -4.174348594150314e-03,   5.073626912565750e-05,  -2.553537137861595e-07,   1.991364204311256e-09,  -2.371884774864665e-10,  -5.763504791898211e-13,   2.950169950234664e-13,
   1.666116525804587e-15,  -3.600768538128368e-16,   2.608590581369998e-01,  -4.174353988090079e-03,   5.073635276405791e-05,  -2.553702620219857e-07,   1.991304201993813e-09,
  -2.371452279693529e-10,  -5.760256221924399e-13,   2.949265910875588e-13,   1.665041359116624e-15,  -3.599105900948208e-16,   4.435142054915208e-01,  -7.038206261024228e-03,
   8.108737868226268e-05,  -2.106442660902250e-07,  -8.490446498913878e-10,  -4.048232013445435e-10,  -1.647861353043143e-12,   6.051587367078510e-13,   3.281152866356597e-15,
  -7.640733017855066e-16,   4.435257433247529e-01,  -7.038298170111293e-03,   8.108663468591108e-05,  -2.112056433778004e-07,  -8.524184032903603e-10,  -4.030739029784988e-10,
  -1.635653633708674e-12,   6.014314234051000e-13,   3.238923546065309e-15,  -7.570417866336619e-16,   4.435446844663438e-01,  -7.038449223563837e-03,   8.108541125840042e-05,
  -2.121254602296141e-07,  -8.579385859050354e-10,  -4.002100771332600e-10,  -1.615731408366549e-12,   5.953379664590546e-13,   3.170103647540936e-15,  -7.455655513270095e-16,
   4.435647823741680e-01,  -7.038609733447657e-03,   8.108411034470131e-05,  -2.130990492809564e-07,  -8.637710453889155e-10,  -3.971820849612506e-10,  -1.594752954263104e-12,
   5.889069022518308e-13,   3.097764368198497e-15,  -7.334791514112821e-16,   4.435805994554650e-01,  -7.038736222225588e-03,   8.108308452334077e-05,  -2.138635291811515e-07,
  -8.683432842830908e-10,  -3.948067979470530e-10,  -1.578358440766795e-12,   5.838705415202609e-13,   3.041324862603502e-15,  -7.240324463806036e-16,   4.435897277711759e-01,
  -7.038809288101178e-03,   8.108249170345220e-05,  -2.143040292180976e-07,  -8.709748478642720e-10,  -3.934390757701611e-10,  -1.568942999273200e-12,   5.809739141929444e-13,
   3.008948608418489e-15,  -7.186066456155212e-16,   4.435931555385964e-01,  -7.038836737667410e-03,   8.108226894298212e-05,  -2.144693098963573e-07,  -8.719616749213876e-10,
  -3.929260679669718e-10,  -1.565416106824141e-12,   5.798880793207250e-13,   2.996827937101778e-15,  -7.165741181225266e-16,   4.435937237397993e-01,  -7.038841288490586e-03,
   8.108223200929969e-05,  -2.144967006024464e-07,  -8.721251844207992e-10,  -3.928410604446823e-10,  -1.564831932270518e-12,   5.797081855946672e-13,   2.994820707644586e-15,
  -7.162374565198032e-16,   6.895677698940881e-01,  -1.078231934341163e-02,   1.118855529203433e-04,   2.786546655765219e-07,  -1.268377303378671e-08,  -6.468149299643505e-10,
  -2.652961746440476e-12,   1.155235178253388e-12,   5.652688951935816e-15,  -1.540325217226955e-15,   6.895836701895592e-01,  -1.078220352697220e-02,   1.118746923962690e-04,
   2.777622353528699e-07,  -1.268918815609110e-08,  -6.434816951217456e-10,  -2.631915587337197e-12,   1.147731874162047e-12,   5.580608933348815e-15,  -1.525741489211958e-15,
   6.896097719767833e-01,  -1.078201366440684e-02,   1.118568598235355e-04,   2.763005459754758e-07,  -1.269804625997124e-08,  -6.380256081796434e-10,  -2.597567196400117e-12,
   1.135466897593742e-12,   5.463204792139073e-15,  -1.501944690089879e-15,   6.896374664666413e-01,  -1.078181257040184e-02,   1.118379336588219e-04,   2.747541644139890e-07,
  -1.270740248317752e-08,  -6.322579039686289e-10,  -2.561394384608491e-12,   1.122524431243271e-12,   5.339881394385854e-15,  -1.476890116013158e-15,   6.896592610723489e-01,
  -1.078165457208822e-02,   1.118230354707452e-04,   2.735404658746682e-07,  -1.271473494337623e-08,  -6.277342996168692e-10,  -2.533123079357477e-12,   1.112390271911934e-12,
   5.243724903684303e-15,  -1.457312876392379e-15,   6.896718387231694e-01,  -1.078156349374225e-02,   1.118144361562404e-04,   2.728413419950175e-07,  -1.271895429161361e-08,
  -6.251298801139429e-10,  -2.516885710457519e-12,   1.106562271884273e-12,   5.188589641498851e-15,  -1.446070653739469e-15,   6.896765616725166e-01,  -1.078152931285449e-02,
   1.118112067867365e-04,   2.725790642466362e-07,  -1.272053636816323e-08,  -6.241530724218910e-10,  -2.510803220850633e-12,   1.104377688782389e-12,   5.167953318542934e-15,
  -1.441859674745770e-15,   6.896773445645633e-01,  -1.078152364793442e-02,   1.118106714597898e-04,   2.725356011492861e-07,  -1.272079849716796e-08,  -6.239912146495631e-10,
  -2.509795741041751e-12,   1.104015767803683e-12,   5.164536108341459e-15,  -1.441162202451912e-15,   1.020204184941525e+00,  -1.546780011123133e-02,   1.220040298154825e-04,
   2.278274357806177e-06,  -5.025180346003979e-08,  -1.356622277537303e-09,   7.910805610211015e-12,   2.318646505884725e-12,   6.533821625523490e-15,  -3.592905264831526e-15,
   1.020221460923959e+00,  -1.546683407774640e-02,   1.219612200383387e-04,   2.276399703522207e-06,  -5.023463233534682e-08,  -1.349969629253590e-09,   7.934987253877292e-12,
   2.301220567621546e-12,   6.443291088327159e-15,  -3.556004732159493e-15,   1.020249817858393e+00,  -1.546524874289137e-02,   1.218909515447867e-04,   2.273328883734055e-06,
  -5.020640681586713e-08,  -1.339085239931117e-09,   7.974432071098148e-12,   2.272746744429367e-12,   6.295975325071170e-15,  -3.495820091478050e-15,   1.020279900796317e+00,
  -1.546356734747204e-02,   1.218164057743217e-04,   2.270079630812033e-06,  -5.017640817911389e-08,  -1.327586204520730e-09,   8.015943879057825e-12,   2.242714706934257e-12,
   6.141421572369240e-15,  -3.432491269489760e-15,   1.020303571911006e+00,  -1.546224463518507e-02,   1.217577483921652e-04,   2.267529041771906e-06,  -5.015276365095567e-08,
  -1.318572585811388e-09,   8.048367708520520e-12,   2.219209690253244e-12,   6.021050364639510e-15,  -3.383033689072572e-15,   1.020317231244448e+00,  -1.546148149414321e-02,
   1.217239002942859e-04,   2.266059683306730e-06,  -5.013910377758186e-08,  -1.313385113848218e-09,   8.066981968388156e-12,   2.205696536665959e-12,   5.952084745406052e-15,
  -3.354643287745789e-15,   1.020322360133066e+00,  -1.546119496903568e-02,   1.217111907957646e-04,   2.265508422260262e-06,  -5.013397169044629e-08,  -1.311439895557156e-09,
   8.073953314784390e-12,   2.200632027425295e-12,   5.926282121915009e-15,  -3.344011145227402e-15,   1.020323210302522e+00,  -1.546114747560967e-02,   1.217090840566136e-04,
   2.265417069090093e-06,  -5.013312083290531e-08,  -1.311117591633569e-09,   8.075107941121093e-12,   2.199793029692452e-12,   5.922009951043692e-15,  -3.342250229024361e-15,
   1.486113789884044e+00,  -2.031367566597804e-02,  -2.638925551643000e-05,   1.161460237785183e-05,  -1.149169613025695e-07,  -1.180262217747064e-08,   2.660610641110271e-10,
   1.282534821882175e-11,  -4.672469491464407e-13,  -1.361765672676735e-14,   1.486109843444073e+00,  -2.030877530525088e-02,  -2.648428756375180e-05,   1.159812001080781e-05,
  -1.143699224629873e-07,  -1.176536090708269e-08,   2.642908755788075e-10,   1.275826229162609e-11,  -4.627910246679014e-13,  -1.351726538538074e-14,   1.486103355438253e+00,
  -2.030073558283414e-02,  -2.663996702588618e-05,   1.157109942177987e-05,  -1.134745525673634e-07,  -1.170433367581374e-08,   2.613974066782703e-10,   1.264849651835673e-11,
  -4.555197249370312e-13,  -1.335313299689933e-14,   1.486096458559692e+00,  -2.029221162248568e-02,  -2.680470596669865e-05,   1.154247989610949e-05,  -1.125281317057099e-07,
  -1.163977322230271e-08,   2.583442444322078e-10,   1.253252347138834e-11,  -4.478635554931757e-13,  -1.317989255712623e-14,   1.486091021568813e+00,  -2.028550814407179e-02,
  -2.693403198604538e-05,   1.151999333697025e-05,  -1.117859177271151e-07,  -1.158910404259638e-08,   2.559536678973369e-10,   1.244161079023327e-11,  -4.418807558390890e-13,
  -1.304421328454352e-14,   1.486087880127329e+00,  -2.028164140742848e-02,  -2.700853875669752e-05,   1.150703077815472e-05,  -1.113586207473229e-07,  -1.155991797102230e-08,
   2.545789236417382e-10,   1.238928674417524e-11,  -4.384449789787750e-13,  -1.296617481847456e-14,   1.486086699795889e+00,  -2.028018978187271e-02,  -2.703649228283605e-05,
   1.150216601734916e-05,  -1.111983644760688e-07,  -1.154896890176389e-08,   2.540636183723109e-10,   1.236966561446811e-11,  -4.371580168054420e-13,  -1.293692055565469e-14,
   1.486086504102728e+00,  -2.027994917380516e-02,  -2.704112468771622e-05,   1.150135976173640e-05,  -1.111718101424861e-07,  -1.154715449520458e-08,   2.539782478882830e-10,
   1.236641455840624e-11,  -4.369448533120367e-13,  -1.293207387653723e-14,   4.810303999485580e-03,  -7.462457952678349e-05,   9.754041649200591e-07,  -7.003293565495138e-09,
   4.693381235276322e-12,  -3.430816159158737e-12,   1.205748870337480e-13,   2.625370646890714e-15,  -1.570846859249839e-16,  -2.431387070420859e-18,   4.810442817591846e-03,
  -7.462758639552818e-05,   9.754095869618621e-07,  -7.008111427428765e-09,   4.943676512264914e-12,  -3.423162932109230e-12,   1.199752891988610e-13,   2.613274686586474e-15,
  -1.558059798207520e-16,  -2.417931305164617e-18,   4.810670710769259e-03,  -7.463252412901417e-05,   9.754186403572496e-07,  -7.016012935636518e-09,   5.353665516118274e-12,
  -3.410624814611940e-12,   1.189945730644710e-13,   2.593466713463269e-15,  -1.537175828812629e-16,  -2.395883878773408e-18,   4.810912524126141e-03,  -7.463776544491224e-05,
   9.754284533090671e-07,  -7.024386471212097e-09,   5.787460159837700e-12,  -3.397356035661266e-12,   1.179588615010380e-13,   2.572516114703069e-15,  -1.515162514427182e-16,
  -2.372547775556808e-18,   4.811102833298919e-03,  -7.464189183441921e-05,   9.754363255003523e-07,  -7.030968842247389e-09,   6.127966745149323e-12,  -3.386938828154046e-12,
   1.171472885346955e-13,   2.556076462984607e-15,  -1.497943240854630e-16,  -2.354224314520329e-18,   4.811212664762822e-03,  -7.464427383393013e-05,   9.754409284834655e-07,
  -7.034764596340291e-09,   6.324122942132478e-12,  -3.380937016998573e-12,   1.166803275728628e-13,   2.546608268830754e-15,  -1.488047706619665e-16,  -2.343666470215166e-18,
   4.811253907630202e-03,  -7.464516840791296e-05,   9.754426682406067e-07,  -7.036189361640234e-09,   6.397714195908064e-12,  -3.378685196348197e-12,   1.165052457719146e-13,
   2.543056541369246e-15,  -1.484339761640487e-16,  -2.339705113870074e-18,   4.811260744229011e-03,  -7.464531670212994e-05,   9.754429572256912e-07,  -7.036425506395602e-09,
   6.409909448895252e-12,  -3.378312026041754e-12,   1.164762375135498e-13,   2.542467985435904e-15,  -1.483725534346653e-16,  -2.339048632401675e-18,   4.355519948877912e-02,
  -6.751859934868590e-04,   8.782039349167784e-06,  -6.088709564611899e-08,  -2.309332262127148e-11,  -3.070248771387303e-11,   1.106258326543518e-12,   2.441630743284814e-14,
  -1.464456041326793e-15,  -2.239127593301203e-17,   4.355644922415262e-02,  -6.752121396533954e-04,   8.782032603630260e-06,  -6.093018806606370e-08,  -2.079794329743961e-11,
  -3.063129445237834e-11,   1.100668556333147e-12,   2.430489577180846e-14,  -1.452529398847460e-15,  -2.226800315482970e-17,   4.355850086845711e-02,  -6.752550759761502e-04,
   8.782022925507841e-06,  -6.100085875704826e-08,  -1.703820129948673e-11,  -3.051465769669569e-11,   1.091525813520597e-12,   2.412244914792306e-14,  -1.433050942324851e-15,
  -2.206600168875179e-17,   4.356067782366004e-02,  -6.753006526052465e-04,   8.782014550421005e-06,  -6.107574743508917e-08,  -1.306034120830959e-11,  -3.039122069718665e-11,
   1.081870394958542e-12,   2.392947495807949e-14,  -1.412519509255350e-15,  -2.185216951444811e-17,   4.356239110037377e-02,  -6.753365345824136e-04,   8.782009328388722e-06,
  -6.113461408792991e-08,  -9.938060775587653e-12,  -3.029430901446086e-11,   1.074304522148437e-12,   2.377804849229644e-14,  -1.396459655543821e-15,  -2.168425195898497e-17,
   4.356337986650014e-02,  -6.753572479532051e-04,   8.782006862770331e-06,  -6.116855870624012e-08,  -8.139458041568226e-12,  -3.023847300165344e-11,   1.069951293484262e-12,
   2.369083559033754e-14,  -1.387230518696503e-15,  -2.158749234745102e-17,   4.356375115813472e-02,  -6.753650270086368e-04,   8.782006040419838e-06,  -6.118129986938212e-08,
  -7.464692684413855e-12,  -3.021752370126854e-11,   1.068319100029178e-12,   2.365811994990067e-14,  -1.383772298501711e-15,  -2.155118638590545e-17,   4.356381270504422e-02,
  -6.753663165500456e-04,   8.782005909562178e-06,  -6.118341161590297e-08,  -7.352873769152503e-12,  -3.021405198704033e-11,   1.068048671694705e-12,   2.365269863995149e-14,
  -1.383199439577376e-15,  -2.154516964485395e-17,   1.225054516660592e-01,  -1.895980392580536e-03,   2.439727436367878e-05,  -1.558259738171611e-07,  -4.668626418114042e-10,
  -8.417599883429255e-11,   3.205232995639646e-12,   7.250346544915759e-14,  -4.379578110241171e-15,  -6.522248127318138e-17,   1.225089228519567e-01,  -1.896047334682160e-03,
   2.439691328417545e-05,  -1.559439814065927e-07,  -4.602182334974830e-10,  -8.396449458722412e-11,   3.188517548113133e-12,   7.217880845820035e-14,  -4.343849297100102e-15,
  -6.486842620476152e-17,   1.225146213343868e-01,  -1.896157266978440e-03,   2.439632455204301e-05,  -1.561374945630364e-07,  -4.493357633602776e-10,  -8.361797123145523e-11,
   3.161177590477153e-12,   7.164713533018347e-14,  -4.285499064939242e-15,  -6.428812851250285e-17,   1.225206678227791e-01,  -1.896273962536445e-03,   2.439570534171987e-05,
  -1.563425346206748e-07,  -4.378230597304822e-10,  -8.325122632265218e-11,   3.132304785488059e-12,   7.108475914988310e-14,  -4.223996749123969e-15,  -6.367367765864095e-17,
   1.225254264107628e-01,  -1.896365837927354e-03,   2.439522198097960e-05,  -1.565036908535701e-07,  -4.287873695899845e-10,  -8.296327781336376e-11,   3.109680558696111e-12,
   7.064344619265349e-14,  -4.175890756447339e-15,  -6.319104398181987e-17,   1.225281726729090e-01,  -1.896418875182277e-03,   2.439494460965170e-05,  -1.565966126396291e-07,
  -4.235826427741327e-10,  -8.279736994417719e-11,   3.096663166025010e-12,   7.038926845081925e-14,  -4.148246270704608e-15,  -6.291288715987221e-17,   1.225292039193863e-01,
  -1.896438793876129e-03,   2.439484075339786e-05,  -1.566314897107897e-07,  -4.216300935393604e-10,  -8.273512141302895e-11,   3.091782455366546e-12,   7.029391900583814e-14,
  -4.137887816507450e-15,  -6.280850875337592e-17,   1.225293748631314e-01,  -1.896442095825956e-03,   2.439482355352760e-05,  -1.566372702416465e-07,  -4.213065295357654e-10,
  -8.272480554492133e-11,   3.090973800367355e-12,   7.027811857695289e-14,  -4.136171930787704e-15,  -6.279121035765754e-17,   2.449075362994937e-01,  -3.779765866772331e-03,
   4.772484692750768e-05,  -2.578950056700640e-07,  -2.336991503877315e-09,  -1.609577665426203e-10,   6.768566511897295e-12,   1.574678924230139e-13,  -9.681858591451070e-15,
  -1.377710750641473e-16,   2.449143240436393e-01,  -3.779876762624799e-03,   4.772293067324421e-05,  -2.581201894464431e-07,  -2.322979791497917e-09,  -1.604981114019728e-10,
   6.731621773491433e-12,   1.567814557483008e-13,  -9.602488234926676e-15,  -1.370481982481053e-16,   2.449254670399988e-01,  -3.780058884703545e-03,   4.771979334135926e-05,
  -2.584893968110453e-07,  -2.300033436431514e-09,  -1.597449831950909e-10,   6.671195684663765e-12,   1.556572251068160e-13,  -9.472870999511522e-15,  -1.358628479770975e-16,
   2.449372903705300e-01,  -3.780252223446876e-03,   4.771647593639453e-05,  -2.588805187945692e-07,  -2.275761689625236e-09,  -1.589478507936684e-10,   6.607383227679442e-12,
   1.544679502449855e-13,  -9.336259736175311e-15,  -1.346069915621874e-16,   2.449465952132742e-01,  -3.780404449430327e-03,   4.771387346672777e-05,  -2.591878743291388e-07,
  -2.256714655755257e-09,  -1.583219452459755e-10,   6.557381973133616e-12,   1.535346038721792e-13,  -9.229410591493393e-15,  -1.336200199585628e-16,   2.449519651477330e-01,
  -3.780492329009856e-03,   4.771237487106964e-05,  -2.593650712313510e-07,  -2.245744221874009e-09,  -1.579613000627861e-10,   6.528612978486731e-12,   1.529970005597435e-13,
  -9.168011172224484e-15,  -1.330509860247694e-16,   2.449539815978803e-01,  -3.780525333764424e-03,   4.771181276431202e-05,  -2.594315756799379e-07,  -2.241628863923829e-09,
  -1.578259832003763e-10,   6.517826480038222e-12,   1.527953233740593e-13,  -9.145005094863786e-15,  -1.328374161647335e-16,   2.449543158526361e-01,  -3.780530805043831e-03,
   4.771171962033541e-05,  -2.594425979116069e-07,  -2.240946903179060e-09,  -1.578035582408891e-10,   6.516039335563260e-12,   1.527619029476478e-13,  -9.141194143555264e-15,
  -1.328020196257017e-16,   4.166416492282695e-01,  -6.400450062221583e-03,   7.821953366018620e-05,  -2.855026754573204e-07,  -8.015289591105634e-09,  -2.544268240550823e-10,
   1.273334296240459e-11,   2.992843084143743e-13,  -1.921907297033765e-14,  -2.528553230605872e-16,   4.166527669813401e-01,  -6.400573201293518e-03,   7.821283851896846e-05,
  -2.858573802082083e-07,  -7.988974904525922e-09,  -2.535525409709121e-10,   1.266004446962443e-11,   2.980214936692673e-13,  -1.905960515277505e-14,  -2.516419113009068e-16,
   4.166710179078122e-01,  -6.400775461751786e-03,   7.820186332791074e-05,  -2.864387945546925e-07,  -7.945886445433427e-09,  -2.521199702204449e-10,   1.254016444937300e-11,
   2.959528720181585e-13,  -1.879920021743495e-14,  -2.496498525583318e-16,   4.166903826491932e-01,  -6.400990222014665e-03,   7.819023946517623e-05,  -2.870545108099425e-07,
  -7.900317228046406e-09,  -2.506035748695690e-10,   1.241357369959506e-11,   2.937640107921199e-13,  -1.852476699450155e-14,  -2.475361502279987e-16,   4.167056221498970e-01,
  -6.401159345267952e-03,   7.818110707990675e-05,  -2.875382083585496e-07,  -7.864563024446829e-09,  -2.494128188854509e-10,   1.231438695946997e-11,   2.920457862631668e-13,
  -1.831013830320504e-14,  -2.458727439946202e-16,   4.167144169024115e-01,  -6.401256991975357e-03,   7.817584286787776e-05,  -2.878170095683973e-07,  -7.843972174114729e-09,
  -2.487266732521479e-10,   1.225732050938341e-11,   2.910559372204021e-13,  -1.818681143127398e-14,  -2.449128180091707e-16,   4.167177193700649e-01,  -6.401293667288960e-03,
   7.817386728713772e-05,  -2.879216360682699e-07,  -7.836248334352250e-09,  -2.484692194848757e-10,   1.223592471949669e-11,   2.906845739583754e-13,  -1.814060267260068e-14,
  -2.445523699617574e-16,   4.167182667987454e-01,  -6.401299747169287e-03,   7.817353986874476e-05,  -2.879389759208741e-07,  -7.834968431205554e-09,  -2.484265534238021e-10,
   1.223237981247015e-11,   2.906230328489231e-13,  -1.813294826838105e-14,  -2.444926213269168e-16,   6.482437097066505e-01,  -9.878261306620586e-03,   1.136031658253836e-04,
  -2.052416792307126e-08,  -2.374659352237840e-08,  -3.521259227524242e-10,   2.422930818213698e-11,   5.265767248574582e-13,  -3.800041066205704e-14,  -4.258786716073262e-16,
   6.482598360704098e-01,  -9.878271790815074e-03,   1.135831724410883e-04,  -2.101230198021886e-08,  -2.369658335807909e-08,  -3.505864169967149e-10,   2.408456015395335e-11,
   5.244349378253931e-13,  -3.767633962494697e-14,  -4.243998362434681e-16,   6.482863080955614e-01,  -9.878289149920382e-03,   1.135503803889679e-04,  -2.181208373777060e-08,
  -2.361470338793958e-08,  -3.480636690180245e-10,   2.384784973774949e-11,   5.209244158467762e-13,  -3.714719154351084e-14,  -4.219597534958414e-16,   6.483143942290031e-01,
  -9.878307769617060e-03,   1.135156266269965e-04,  -2.265858376994088e-08,  -2.352812038431736e-08,  -3.453930833791519e-10,   2.359792336493060e-11,   5.172070718658848e-13,
  -3.658960226847045e-14,  -4.193541746616074e-16,   6.483364961874213e-01,  -9.878322568266026e-03,   1.134883049628181e-04,  -2.332324342592347e-08,  -2.346019424702427e-08,
  -3.432958347115436e-10,   2.340212550484898e-11,   5.142870171944959e-13,  -3.615356952633896e-14,  -4.172918863536456e-16,   6.483492508680794e-01,  -9.878331166851290e-03,
   1.134725489942733e-04,  -2.370621474080823e-08,  -2.342107878758952e-08,  -3.420872801064020e-10,   2.328948454791306e-11,   5.126040130279304e-13,  -3.590304125733238e-14,
  -4.160970926604287e-16,   6.483540402279011e-01,  -9.878334406659308e-03,   1.134666347180421e-04,  -2.384990778111161e-08,  -2.340640678319313e-08,  -3.416337974745300e-10,
   2.324725424334505e-11,   5.119724478703125e-13,  -3.580917553150526e-14,  -4.156475741001644e-16,   6.483548341249546e-01,  -9.878334944281524e-03,   1.134656544605666e-04,
  -2.387372081554516e-08,  -2.340397554459328e-08,  -3.415586442552509e-10,   2.324025752322253e-11,   5.118677790604517e-13,  -3.579362701532356e-14,  -4.155730147295350e-16,
   9.604363964758093e-01,  -1.439796813116099e-02,   1.437152690383427e-04,   1.288514097041987e-06,  -7.059275561297473e-08,  -4.771753905352012e-10,   5.792136232978797e-11,
   7.526363937766723e-13,  -8.512117330133725e-14,  -5.113489664607886e-16,   9.604567283756634e-01,  -1.439742036579473e-02,   1.436556708186606e-04,   1.287853629411752e-06,
  -7.047293668321241e-08,  -4.749691329763640e-10,   5.759785783559425e-11,   7.499552301857012e-13,  -8.435954143786167e-14,  -5.137421004965488e-16,   9.604901004581379e-01,
  -1.439652131973457e-02,   1.435579034355765e-04,   1.286771616207727e-06,  -7.027672537632854e-08,  -4.713530330707549e-10,   5.706892693566318e-11,   7.455456232970745e-13,
  -8.311607912110397e-14,  -5.175618008914106e-16,   9.605255026369538e-01,  -1.439556763305498e-02,   1.434542633825869e-04,   1.285626572970517e-06,  -7.006919533570954e-08,
  -4.675240025097968e-10,   5.651060722951722e-11,   7.408559732753272e-13,  -8.180597463611784e-14,  -5.214681387879243e-16,   9.605533584182693e-01,  -1.439481727230777e-02,
   1.433727694478078e-04,   1.284727628242471e-06,  -6.990634840665169e-08,  -4.645162844337734e-10,   5.607331018059648e-11,   7.371576025912656e-13,  -8.078161759580206e-14,
  -5.244374333421042e-16,   9.605694321625652e-01,  -1.439438430278931e-02,   1.433257662557818e-04,   1.284209714809515e-06,  -6.981255832692566e-08,  -4.627827782773789e-10,
   5.582177793365330e-11,   7.350202122382943e-13,  -8.019311613351077e-14,  -5.261093593530400e-16,   9.605754675652072e-01,  -1.439422173322556e-02,   1.433081214812927e-04,
   1.284015400365558e-06,  -6.977737546719620e-08,  -4.621322657429775e-10,   5.572748359696879e-11,   7.342170425661195e-13,  -7.997263222275590e-14,  -5.267293455322391e-16,
   9.605764679959441e-01,  -1.439419478577364e-02,   1.433051968916627e-04,   1.283983198783167e-06,  -6.977154531549419e-08,  -4.620244570004339e-10,   5.571186131579764e-11,
   7.340838763992667e-13,  -7.993611042625767e-14,  -5.268317046937463e-16,   1.405255203936215e+00,  -2.001376303382305e-02,   9.554013282475503e-05,   8.322484812300600e-06,
  -2.678905838092961e-07,  -3.033601396024223e-09,   3.851974228439112e-10,  -4.002156626718376e-12,  -4.190632586909026e-13,   1.316280354927479e-14,   1.405268349224088e+00,
  -2.001022557468213e-02,   9.531593588281579e-05,   8.318076106981086e-06,  -2.670876226675343e-07,  -3.044564799528115e-09,   3.835689332272457e-10,  -3.939216667861065e-12,
  -4.170705803101499e-13,   1.299372409781929e-14,   1.405289907004513e+00,  -2.000441964419153e-02,   9.494836974958277e-05,   8.310827636782511e-06,  -2.657719225194620e-07,
  -3.062429938861997e-09,   3.809012315815066e-10,  -3.836503079517106e-12,  -4.138012010288670e-13,   1.271794989934621e-14,   1.405312751144239e+00,  -1.999826098207097e-02,
   9.455901801752833e-05,   8.303121754125206e-06,  -2.643792429566384e-07,  -3.081206105715898e-09,   3.780783749175879e-10,  -3.728344917158816e-12,  -4.103348430167478e-13,
   1.242776309694698e-14,   1.405330707662185e+00,  -1.999341544430697e-02,   9.425307650742620e-05,   8.297046601567811e-06,  -2.632856402226008e-07,  -3.095853191226714e-09,
   3.758624028361492e-10,  -3.643821198243741e-12,  -4.076088305119077e-13,   1.220113565627211e-14,   1.405341061931980e+00,  -1.999061953598473e-02,   9.407670401202993e-05,
   8.293536289177407e-06,  -2.626554788855635e-07,  -3.104254441655576e-09,   3.745857782767165e-10,  -3.595279419231448e-12,  -4.060364318051434e-13,   1.207104351281694e-14,
   1.405344948403068e+00,  -1.998956974791121e-02,   9.401051071346146e-05,   8.292217336013244e-06,  -2.624190317757214e-07,  -3.107399412785646e-09,   3.741068194079846e-10,
  -3.577096469943813e-12,  -4.054461412557111e-13,   1.202232438510517e-14,   1.405345592553719e+00,  -1.998939573596261e-02,   9.399954014255013e-05,   8.291998658711618e-06,
  -2.623798470249635e-07,  -3.107920221257731e-09,   3.740274476088620e-10,  -3.574084755600184e-12,  -4.053483006966753e-13,   1.201425543504862e-14,   4.526876211134252e-03,
  -6.716034027516658e-05,   8.901027715700908e-07,  -7.305585766248635e-09,  -3.209647946560048e-11,  -2.456925932136381e-13,   1.220029510057392e-13,  -2.232399240411757e-15,
  -1.055926385931168e-16,   4.236530541275752e-18,   4.527002827118369e-03,  -6.716346062460071e-05,   8.900768116043451e-07,  -7.305988689037190e-09,  -3.184093726098640e-11,
  -2.520384201546777e-13,   1.215905713825016e-13,  -2.211876947838097e-15,  -1.051898504119347e-16,   4.192136212472354e-18,   4.527210685314679e-03,  -6.716858332000703e-05,
   8.900343502769669e-07,  -7.306656544937543e-09,  -3.142205514764313e-11,  -2.624125551483124e-13,   1.209147455442355e-13,  -2.178347640913999e-15,  -1.045282451998613e-16,
   4.119657573220037e-18,   4.527431235628335e-03,  -6.717401908275887e-05,   8.899895075466509e-07,  -7.307373856040617e-09,  -3.097844649760769e-11,  -2.733612919295876e-13,
   1.201992219225137e-13,  -2.142988946792445e-15,  -1.038257598156835e-16,   4.043296066558688e-18,   4.527604807503504e-03,  -6.717829719282697e-05,   8.899543694241950e-07,
  -7.307944637957382e-09,  -3.062994434520367e-11,  -2.819354195550752e-13,   1.196372452870692e-13,  -2.115319031102568e-15,  -1.032725765971642e-16,   3.983591259031812e-18,
   4.527704978274719e-03,  -6.718076622867579e-05,   8.899341519389944e-07,  -7.308276548179548e-09,  -3.042906528501277e-11,  -2.868666943748819e-13,   1.193133763593594e-13,
  -2.099413133109193e-15,  -1.029531998035726e-16,   3.949291054714842e-18,   4.527742593215717e-03,  -6.718169338659238e-05,   8.899265716733365e-07,  -7.308401655709584e-09,
  -3.035368011019431e-11,  -2.887152255632529e-13,   1.191918470841315e-13,  -2.093452184082356e-15,  -1.028332478961771e-16,   3.936440520215745e-18,   4.527748828421128e-03,
  -6.718184707683781e-05,   8.899253157476514e-07,  -7.308422418952429e-09,  -3.034118641238354e-11,  -2.890214767846886e-13,   1.191717064428231e-13,  -2.092464697254880e-15,
  -1.028133629671893e-16,   3.934311916559116e-18,   4.099028306251266e-02,  -6.078950857830944e-04,   8.033982248861004e-06,  -6.459342394983829e-08,  -3.448091076582062e-10,
  -1.447459926340861e-12,   1.119303920783879e-12,  -2.073191741999868e-14,  -9.771218194177957e-16,   3.954029746834187e-17,   4.099142579204645e-02,  -6.079226712606057e-04,
   8.033701094086592e-06,  -6.459597849090379e-08,  -3.424650585340917e-10,  -1.506377366907545e-12,   1.115487140301441e-12,  -2.054037362800360e-14,  -9.734310804850415e-16,
   3.912616758326031e-17,   4.099330174076968e-02,  -6.079679581904393e-04,   8.033240965302125e-06,  -6.460023153163892e-08,  -3.386227703063879e-10,  -1.602693247175148e-12,
   1.109231928987046e-12,  -2.022742871980606e-14,  -9.673681606915193e-16,   3.845005346550682e-17,   4.099529223108855e-02,  -6.080160123616824e-04,   8.032754677727751e-06,
  -6.460482477019128e-08,  -3.345537441134194e-10,  -1.704340952983730e-12,   1.102609148249881e-12,  -1.989740819111556e-14,  -9.609297471796565e-16,   3.773771632806943e-17,
   4.099685873123570e-02,  -6.080538321513511e-04,   8.032373373277071e-06,  -6.460849773247114e-08,  -3.313571397741789e-10,  -1.783940754465853e-12,   1.097407474550027e-12,
  -1.963915012627601e-14,  -9.558590938148683e-16,   3.718075965384014e-17,   4.099776277862343e-02,  -6.080756590565352e-04,   8.032153878281364e-06,  -6.461064068585148e-08,
  -3.295146157067512e-10,  -1.829720481135846e-12,   1.094409693021022e-12,  -1.949069159182372e-14,  -9.529313370644948e-16,   3.686078947289694e-17,   4.099810225542903e-02,
  -6.080838553457667e-04,   8.032071562129449e-06,  -6.461144976713667e-08,  -3.288231638175950e-10,  -1.846881248496816e-12,   1.093284791397161e-12,  -1.943505470151508e-14,
  -9.518316802730697e-16,   3.674091289552136e-17,   4.099815852846445e-02,  -6.080852140016893e-04,   8.032057922660707e-06,  -6.461158411488882e-08,  -3.287085686699423e-10,
  -1.849724311307557e-12,   1.093098364802905e-12,  -1.942583792835456e-14,  -9.516493831240638e-16,   3.672105615067247e-17,   1.152997326993855e-01,  -1.708507401363240e-03,
   2.244169852149507e-05,  -1.721907311239349e-07,  -1.301810694173857e-09,   7.217119553009698e-13,   3.238751650604021e-12,  -6.161701878476087e-14,  -2.874736066202821e-15,
   1.185674023342393e-16,   1.153029241604637e-01,  -1.708580915230464e-03,   2.244062532805697e-05,  -1.721911736027752e-07,  -1.295030349934102e-09,   5.466856515024175e-13,
   3.227517695445649e-12,  -6.104261251144609e-14,  -2.864113713812648e-15,   1.173268635182831e-16,   1.153081633562223e-01,  -1.708701600621050e-03,   2.243886764957703e-05,
  -1.721920762735361e-07,  -1.283916531886466e-09,   2.605710935148552e-13,   3.209106021128704e-12,  -6.010414070217823e-14,  -2.846659617409969e-15,   1.153015294286204e-16,
   1.153137224066037e-01,  -1.708829657829619e-03,   2.243700824073349e-05,  -1.721932729665948e-07,  -1.272147281692857e-09,  -4.136651464552451e-14,   3.189611532668389e-12,
  -5.911445524927756e-14,  -2.828118690612905e-15,   1.131676695415363e-16,   1.153180973063825e-01,  -1.708930440041850e-03,   2.243554894350897e-05,  -1.721943872028829e-07,
  -1.262901719818296e-09,  -2.778010035621867e-13,   3.174299492354852e-12,  -5.833997064065718e-14,  -2.813512362142450e-15,   1.114992509111159e-16,   1.153206221057326e-01,
  -1.708988603641592e-03,   2.243470838343243e-05,  -1.721950991958276e-07,  -1.257572692843470e-09,  -4.137755173989197e-13,   3.165474735560536e-12,  -5.789475959928405e-14,
  -2.805077114946931e-15,   1.105407436804760e-16,   1.153215701852788e-01,  -1.709010444693060e-03,   2.243439305246467e-05,  -1.721953795669623e-07,  -1.255572868563826e-09,
  -4.647454061954487e-13,   3.162163243298341e-12,  -5.772791024021681e-14,  -2.801908548272765e-15,   1.101816387613987e-16,   1.153217273426273e-01,  -1.709014065162174e-03,
   2.243434079807138e-05,  -1.721954267283593e-07,  -1.255241436483061e-09,  -4.731896564961143e-13,   3.161614436967365e-12,  -5.770027005862629e-14,  -2.801383258227992e-15,
   1.101221554093902e-16,   2.305313285514691e-01,  -3.411164236010827e-03,   4.433063754273999e-05,  -3.113678466235696e-07,  -3.761819526352168e-09,   1.837881726114692e-11,
   6.797771960467573e-12,  -1.355976979370284e-13,  -6.171666045291962e-15,   2.635187960463938e-16,   2.305376308308059e-01,  -3.411297085452859e-03,   4.432750598661143e-05,
  -3.113449242542348e-07,  -3.747594986562664e-09,   1.799384656867277e-11,   6.773635684464756e-12,  -1.343209428537630e-13,  -6.149768799726425e-15,   2.607664005210533e-16,
   2.305479767333433e-01,  -3.411515172993001e-03,   4.432237371823964e-05,  -3.113076810929019e-07,  -3.724280097485528e-09,   1.736456546587752e-11,   6.734075430576174e-12,
  -1.322349476458788e-13,  -6.113770488099718e-15,   2.562726893725449e-16,   2.305589541161641e-01,  -3.411746572204128e-03,   4.431693977989986e-05,  -3.112686885217722e-07,
  -3.699591423827322e-09,   1.670052179050144e-11,   6.692185115116284e-12,  -1.300350932129858e-13,  -6.075506555853817e-15,   2.515380757590270e-16,   2.305675930708633e-01,
  -3.411928678476990e-03,   4.431267177208047e-05,  -3.112383803177430e-07,  -3.680197630369066e-09,   1.618056553442730e-11,   6.659279664575330e-12,  -1.283135661337714e-13,
  -6.045345428448173e-15,   2.478361053315322e-16,   2.305725786591099e-01,  -3.412033773130232e-03,   4.431021203743500e-05,  -3.112210404573283e-07,  -3.669019638842228e-09,
   1.588154769214817e-11,   6.640314336372909e-12,  -1.273239426603359e-13,  -6.027920337924338e-15,   2.457092903928342e-16,   2.305744507741339e-01,  -3.412073236758741e-03,
   4.430928902791841e-05,  -3.112145577746879e-07,  -3.664824939542310e-09,   1.576946333824711e-11,   6.633197404078636e-12,  -1.269530654806232e-13,  -6.021373592450351e-15,
   2.449124728873218e-16,   2.305747611027864e-01,  -3.412079778395882e-03,   4.430913605991255e-05,  -3.112134846852937e-07,  -3.664129753002827e-09,   1.575089428487121e-11,
   6.632017920633264e-12,  -1.268916260841773e-13,  -6.020288194822798e-15,   2.447804850345558e-16,   3.922662224817123e-01,  -5.790848020815660e-03,   7.391458109425863e-05,
  -4.362893477023259e-07,  -9.737770290941453e-09,   8.093945399588210e-11,   1.253179478015936e-11,  -2.709631246946476e-13,  -1.162767142674486e-14,   5.284428247162519e-16,
   3.922767246500147e-01,  -5.791033899491550e-03,   7.390641479300763e-05,  -4.361806220426029e-07,  -9.711559569766897e-09,   8.017032273230151e-11,   1.248625784909174e-11,
  -2.684023609221261e-13,  -1.158951831979360e-14,   5.229405063629716e-16,   3.922939648431545e-01,  -5.791339017372846e-03,   7.389302449221822e-05,  -4.360029056264938e-07,
  -9.668600259718009e-09,   7.891310616536304e-11,   1.241161236851430e-11,  -2.642184569045667e-13,  -1.152672883814563e-14,   5.139566726906699e-16,   3.923122569127271e-01,
  -5.791662727598396e-03,   7.387883807595605e-05,  -4.358153841647448e-07,  -9.623111922956125e-09,   7.758646797374180e-11,   1.233255851132073e-11,  -2.598061000390176e-13,
  -1.145989733745399e-14,   5.044906239143762e-16,   3.923266520662181e-01,  -5.791917457902680e-03,   7.386768900491609e-05,  -4.356685612131236e-07,  -9.587380934820018e-09,
   7.654771140546668e-11,   1.227045205020489e-11,  -2.563530876586078e-13,  -1.140715354485320e-14,   4.970887369095296e-16,   3.923349594697792e-01,  -5.792064455210564e-03,
   7.386126095054237e-05,  -4.355841296534101e-07,  -9.566787345461384e-09,   7.595034903180641e-11,   1.223465308459395e-11,  -2.543680921813345e-13,  -1.137665605103125e-14,
   4.928361155545128e-16,   3.923380789217775e-01,  -5.792119651796620e-03,   7.385884834084005e-05,  -4.355524819101729e-07,  -9.559059435683012e-09,   7.572643432957744e-11,
   1.222121851915708e-11,  -2.536241789454249e-13,  -1.136519308214594e-14,   4.912428261482327e-16,   3.923385960123987e-01,  -5.792128801296172e-03,   7.385844847893656e-05,
  -4.355472388562432e-07,  -9.557778697630590e-09,   7.568933838964315e-11,   1.221899198577913e-11,  -2.535009422755265e-13,  -1.136329236090383e-14,   4.909789059927198e-16,
   6.105372076862881e-01,  -8.977195519709822e-03,   1.109547816569194e-04,  -4.227136593371873e-07,  -2.449785542119403e-08,   2.689109183776592e-10,   2.241951545992100e-11,
  -5.586417135538099e-13,  -2.068965735720286e-14,   1.064963117116010e-15,   6.105529558406397e-01,  -8.977374683200295e-03,   1.109341295162554e-04,  -4.223443091536095e-07,
  -2.445096215995033e-08,   2.673233658730928e-10,   2.233824716536850e-11,  -5.534786747507226e-13,  -2.063367369181431e-14,   1.053965839351054e-15,   6.105788069035391e-01,
  -8.977668698185415e-03,   1.109002543183224e-04,  -4.217395601668643e-07,  -2.437410403531080e-08,   2.647281049534630e-10,   2.220499628125900e-11,  -5.450427120860377e-13,
  -2.054125149179712e-14,   1.036007573610836e-15,   6.106062340524392e-01,  -8.977980520374221e-03,   1.108643489882239e-04,  -4.211000420001153e-07,  -2.429272103355708e-08,
   2.619891859304702e-10,   2.206383070653981e-11,  -5.361456764672272e-13,  -2.044249194391816e-14,   1.017081863773291e-15,   6.106278173173033e-01,  -8.978225817361313e-03,
   1.108361194169774e-04,  -4.205983022219071e-07,  -2.422879472913567e-08,   2.598443598285730e-10,   2.195289538764414e-11,  -5.291827347429015e-13,  -2.036427315516412e-14,
   1.002280560481645e-15,   6.106402726219936e-01,  -8.978367339538345e-03,   1.108198388373340e-04,  -4.203093638995648e-07,  -2.419195069456712e-08,   2.586108228211168e-10,
   2.188893787578105e-11,  -5.251798975103655e-13,  -2.031893558089151e-14,   9.937757324410839e-16,   6.106449495579112e-01,  -8.978420474307074e-03,   1.108137274443639e-04,
  -4.202009827290693e-07,  -2.417812466656978e-08,   2.581484257115636e-10,   2.186493358464364e-11,  -5.236797373953360e-13,  -2.030187409388197e-14,   9.905891198067947e-16,
   6.106457248188163e-01,  -8.978429281722312e-03,   1.108127145056570e-04,  -4.201830232214591e-07,  -2.417583329363096e-08,   2.580718193786830e-10,   2.186095518402655e-11,
  -5.234312196057250e-13,  -2.029904397450560e-14,   9.900612639294121e-16,   9.052144664568946e-01,  -1.320581981282752e-02,   1.523366788287630e-04,   1.599408052092001e-07,
  -6.607370394495700e-08,   8.727068997472580e-10,   4.424108555284382e-11,  -1.444453929305181e-12,  -3.409050281926760e-14,   2.458455764450327e-15,   9.052360326985670e-01,
  -1.320574727222476e-02,   1.522807873432355e-04,   1.611480574692955e-07,  -6.598087366627237e-08,   8.685798253803898e-10,   4.410572140693357e-11,  -1.432507621596452e-12,
  -3.406982360901356e-14,   2.434121797045685e-15,   9.052714315105994e-01,  -1.320562782058548e-02,   1.521890892003349e-04,   1.631257907152768e-07,  -6.582868630368393e-08,
   8.618299504678022e-10,   4.388357162194525e-11,  -1.412984499753787e-12,  -3.403363311536119e-14,   2.394363166598113e-15,   9.053089846914950e-01,  -1.320550057845859e-02,
   1.520918674763389e-04,   1.652186697182789e-07,  -6.566748713498483e-08,   8.547022086578132e-10,   4.364795533703742e-11,  -1.392389093808028e-12,  -3.399221198271022e-14,
   2.352433149420527e-15,   9.053385336735744e-01,  -1.320540008058983e-02,   1.520154092306028e-04,   1.668616976336311e-07,  -6.554082766474844e-08,   8.491174613944165e-10,
   4.346260048778361e-11,  -1.376267082448876e-12,  -3.395744781588542e-14,   2.319619577014058e-15,   9.053555847375705e-01,  -1.320534193811779e-02,   1.519713060158278e-04,
   1.678082897927195e-07,  -6.546781221219447e-08,   8.459043180628700e-10,   4.335566008818760e-11,  -1.366997402069499e-12,  -3.393652363214872e-14,   2.300756451576652e-15,
   9.053619871599974e-01,  -1.320532007799845e-02,   1.519547490393020e-04,   1.681634366449076e-07,  -6.544040971893279e-08,   8.446996232583750e-10,   4.331550896461578e-11,
  -1.363523081956995e-12,  -3.392850445897552e-14,   2.293687171646860e-15,   9.053630484309155e-01,  -1.320531645294464e-02,   1.519520047059777e-04,   1.682222910857024e-07,
  -6.543586818293842e-08,   8.445000265542790e-10,   4.330885366339738e-11,  -1.362947508240407e-12,  -3.392716664353439e-14,   2.292516076007186e-15,   1.327256126415797e+00,
  -1.892445549202804e-02,   1.691608345141222e-04,   3.993864636084565e-06,  -2.510055727963366e-07,   3.828006647421265e-09,   1.630095623604450e-10,  -9.235104668178901e-12,
   6.587989344540473e-14,   9.403140731082185e-15,   1.327279772288158e+00,  -1.892273202015706e-02,   1.689485021388422e-04,   3.999086247485251e-06,  -2.506550434389529e-07,
   3.801166213548996e-09,   1.632306477482936e-10,  -9.187572145470007e-12,   6.386506873372783e-14,   9.379763053863904e-15,   1.327318569295802e+00,  -1.891990110338624e-02,
   1.686001412812300e-04,   4.007631075632229e-06,  -2.500792734585341e-07,   3.757205538951479e-09,   1.635879062968645e-10,  -9.109630138910071e-12,   6.057725736549184e-14,
   9.340884129464145e-15,   1.327359706686208e+00,  -1.891689516791278e-02,   1.682307986433655e-04,   4.016660763982419e-06,  -2.494679077763164e-07,   3.710698710399900e-09,
   1.639592846469720e-10,  -9.027051387648974e-12,   5.711553242080294e-14,   9.298957060894936e-15,   1.327392060872680e+00,  -1.891452795386401e-02,   1.679403378249890e-04,
   4.023740407095447e-06,  -2.489864527061498e-07,   3.674198032627190e-09,   1.642460103079955e-10,  -8.962151837801288e-12,   5.441054797407890e-14,   9.265478016598659e-15,
   1.327410724629208e+00,  -1.891316117740238e-02,   1.677727929251796e-04,   4.027815492040656e-06,  -2.487084737016310e-07,   3.653173010620860e-09,   1.644092681661428e-10,
  -8.924733511126607e-12,   5.285720884498066e-14,   9.245965086335150e-15,   1.327417731453484e+00,  -1.891264782391385e-02,   1.677098943538922e-04,   4.029343703377381e-06,
  -2.486040669314665e-07,   3.645285506791077e-09,   1.644701550070818e-10,  -8.910689480843318e-12,   5.227537886549237e-14,   9.238601798924957e-15,   1.327418892850405e+00,
  -1.891256272214400e-02,   1.676994688703252e-04,   4.029596919570969e-06,  -2.485867588108462e-07,   3.643978441034348e-09,   1.644802258386221e-10,  -8.908361847768508e-12,
   5.217900940691012e-14,   9.237379335248631e-15,   4.271909600220157e-03,  -6.039838320285758e-05,   7.996371498056794e-07,  -7.725594941412894e-09,  -1.414487871532074e-11,
   1.696513583106681e-12,   3.578058976456677e-14,  -3.153794648105376e-15,   3.733855237682773e-17,   2.605748766531729e-18,   4.272023371072098e-03,  -6.040167318970903e-05,
   7.996255148700187e-07,  -7.723258282142961e-09,  -1.406690116565563e-11,   1.687299308105941e-12,   3.591678388137920e-14,  -3.140590962216290e-15,   3.672719866766495e-17,
   2.600431934639686e-18,   4.272210143218996e-03,  -6.040707353280034e-05,   7.996064628619186e-07,  -7.719431667647449e-09,  -1.393868490365869e-11,   1.672201006627457e-12,
   3.613863735704717e-14,  -3.118935543914581e-15,   3.572870546187077e-17,   2.591586106263094e-18,   4.272408321384485e-03,  -6.041280276065098e-05,   7.995863133562346e-07,
  -7.715384079549357e-09,  -1.380236241914266e-11,   1.656219144917254e-12,   3.637169624645983e-14,  -3.095985658397788e-15,   3.467619713647600e-17,   2.582041912943652e-18,
   4.272564287545746e-03,  -6.041731100391014e-05,   7.995705035337824e-07,  -7.712207822092479e-09,  -1.369487784473487e-11,   1.643669265679873e-12,   3.655342344201380e-14,
  -3.077944567125250e-15,   3.385289887118108e-17,   2.574417261808625e-18,   4.272654298228520e-03,  -6.041991252340359e-05,   7.995613986115933e-07,  -7.710378431764674e-09,
  -1.363276737358514e-11,   1.636437674113604e-12,   3.665762584988745e-14,  -3.067541012973454e-15,   3.337976912519151e-17,   2.569971874775394e-18,   4.272688098052126e-03,
  -6.042088936775263e-05,   7.995579832605031e-07,  -7.709692174455250e-09,  -1.360942938236572e-11,   1.633724253653836e-12,   3.669662738300847e-14,  -3.063635953086356e-15,
   3.320248385122979e-17,   2.568294116730361e-18,   4.272693700852325e-03,  -6.042105129093901e-05,   7.995574173091291e-07,  -7.709578454238521e-09,  -1.360555999174094e-11,
   1.633274576881562e-12,   3.670308572482648e-14,  -3.062988716939071e-15,   3.317311629312911e-17,   2.568015558513309e-18,   3.868221254189750e-02,  -5.468113949521498e-04,
   7.228877931805912e-06,  -6.912585236647968e-08,  -1.646191586745929e-10,   1.627684105668046e-11,   3.206781850967911e-13,  -2.913693821124004e-14,   3.506231525376324e-16,
   2.405399752182783e-17,   3.868324098973574e-02,  -5.468408271431590e-04,   7.228741343590487e-06,  -6.910340619368550e-08,  -1.639196020831137e-10,   1.619171248791329e-11,
   3.219578251687498e-13,  -2.901500449201898e-14,   3.449177348167322e-16,   2.400676557520554e-17,   3.868492933995305e-02,  -5.468891380903108e-04,   7.228517548338992e-06,
  -6.906664391932554e-08,  -1.627692543345409e-10,   1.605222267032625e-11,   3.240424040203487e-13,  -2.881501382798989e-14,   3.355991826946767e-16,   2.392811125828410e-17,
   3.868672079190649e-02,  -5.469403905694261e-04,   7.228280678020825e-06,  -6.902775405921861e-08,  -1.615460608565732e-10,   1.590456973611466e-11,   3.262324189702255e-13,
  -2.860305956128340e-14,   3.257762834660946e-16,   2.384315065284500e-17,   3.868813066091265e-02,  -5.469807199120972e-04,   7.228094690207531e-06,  -6.899723267642140e-08,
  -1.605815396793677e-10,   1.578862407143516e-11,   3.279401861631623e-13,  -2.843643409774967e-14,   3.180923900077664e-16,   2.377520919535444e-17,   3.868894431864303e-02,
  -5.470039921113862e-04,   7.227987525677811e-06,  -6.897965228037709e-08,  -1.600241529441910e-10,   1.572181290997220e-11,   3.289194634708455e-13,  -2.834034546675922e-14,
   3.136765702546783e-16,   2.373557063433984e-17,   3.868924985422169e-02,  -5.470127305526381e-04,   7.227947316987484e-06,  -6.897305710582454e-08,  -1.598147087164228e-10,
   1.569674418150834e-11,   3.292860017545508e-13,  -2.830427731826715e-14,   3.120219160388820e-16,   2.372060543873283e-17,   3.868930050106501e-02,  -5.470141790479367e-04,
   7.227940653544747e-06,  -6.897196420081487e-08,  -1.597799829639510e-10,   1.569258971090439e-11,   3.293466979953869e-13,  -2.829829925120840e-14,   3.117478195078040e-16,
   2.371812050559455e-17,   1.088112156469172e-01,  -1.537568015444036e-03,   2.026265371475955e-05,  -1.894022974973205e-07,  -6.862630848473945e-10,   5.141361225675437e-11,
   8.805534329829876e-13,  -8.553160926523634e-14,   1.066105318660686e-15,   7.040709120078802e-17,   1.088140980152431e-01,  -1.537648624823752e-03,   2.026207868443875e-05,
  -1.893312369113271e-07,  -6.843376687766409e-10,   5.116370625028217e-11,   8.844493002585855e-13,  -8.517438410025374e-14,   1.049001022454603e-15,   7.028095289925385e-17,
   1.088188298321064e-01,  -1.537780936733618e-03,   2.026113588161698e-05,  -1.892148341316631e-07,  -6.811709615698631e-10,   5.075421435492606e-11,   8.907965516697233e-13,
  -8.458843433651364e-14,   1.021063701455159e-15,   7.007040340457969e-17,   1.088238505778236e-01,  -1.537921300810026e-03,   2.026013713116924e-05,  -1.890916674748443e-07,
  -6.778029640937515e-10,   5.032075668857574e-11,   8.974658577680576e-13,  -8.396737346527912e-14,   9.916127158578776e-16,   6.984231550422973e-17,   1.088278018748987e-01,
  -1.538031747050012e-03,   2.025935229546747e-05,  -1.889949846173636e-07,  -6.751466613602362e-10,   4.998037927398031e-11,   9.026673020816617e-13,  -8.347909090915293e-14,
   9.685737249085276e-16,   6.965945418584185e-17,   1.088300822232023e-01,  -1.538095479317620e-03,   2.025889982739142e-05,  -1.889392871297853e-07,  -6.736113942933049e-10,
   4.978424371477034e-11,   9.056502406602347e-13,  -8.319749391885787e-14,   9.553330918006980e-16,   6.955258716984709e-17,   1.088309385124146e-01,  -1.538119409828219e-03,
   2.025873001114778e-05,  -1.889183910722248e-07,  -6.730344597842424e-10,   4.971065009476455e-11,   9.067667951413423e-13,  -8.309178953842717e-14,   9.503715989376886e-16,
   6.951220663432323e-17,   1.088310804543841e-01,  -1.538123376569058e-03,   2.025870186642496e-05,  -1.889149282484694e-07,  -6.729388021637995e-10,   4.969845391767020e-11,
   9.069516919346350e-13,  -8.307426953879883e-14,   9.495497138251854e-16,   6.950549977682042e-17,   2.175709534038810e-01,  -3.072410119161421e-03,   4.026969064455700e-05,
  -3.613291264883078e-07,  -2.147501082087771e-09,   1.226003467812507e-10,   1.677952189236892e-12,  -1.836362942956345e-13,   2.431110833706097e-15,   1.498950315165546e-16,
   2.175766804318382e-01,  -3.072563779004008e-03,   4.026787795118954e-05,  -3.611591768552305e-07,  -2.143814641375849e-09,   1.220637185628725e-10,   1.686857024388218e-12,
  -1.828745156590051e-13,   2.393123032581274e-15,   1.496739879415905e-16,   2.175860820923369e-01,  -3.072815985123215e-03,   4.026490442930655e-05,  -3.608807239234359e-07,
  -2.137749425900745e-09,   1.211843977385685e-10,   1.701368130929739e-12,  -1.816248128896306e-13,   2.331070881582900e-15,   1.493029021763706e-16,   2.175960577325522e-01,
  -3.073083525569360e-03,   4.026175243339742e-05,  -3.605860061951298e-07,  -2.131295741636226e-09,   1.202535998817034e-10,   1.716619757637616e-12,  -1.802999941163504e-13,
   2.265650292709099e-15,   1.488980919480245e-16,   2.176039084342279e-01,  -3.073294030885173e-03,   4.025927407335401e-05,  -3.603545985534647e-07,  -2.126203680301171e-09,
   1.195226704319203e-10,   1.728517702548308e-12,  -1.792582453187447e-13,   2.214468288433160e-15,   1.485715705809677e-16,   2.176084391557274e-01,  -3.073415497431455e-03,
   4.025784467728054e-05,  -3.602212635995203e-07,  -2.123259773075955e-09,   1.191014831793823e-10,   1.735342209358514e-12,  -1.786573928415588e-13,   2.185051864514819e-15,
   1.483799727415039e-16,   2.176101404731079e-01,  -3.073461105514531e-03,   4.025730809772367e-05,  -3.601712355923841e-07,  -2.122153330492391e-09,   1.189434453247059e-10,
   1.737896950387594e-12,  -1.784318355101388e-13,   2.174028675747015e-15,   1.483074322081500e-16,   2.176104224900988e-01,  -3.073468665506045e-03,   4.025721916110519e-05,
  -3.601629448749305e-07,  -2.121969870367717e-09,   1.189172547311283e-10,   1.738320017347873e-12,  -1.783944497926534e-13,   2.172202635418705e-15,   1.482953763292534e-16,
   3.702488440036252e-01,  -5.222907819169537e-03,   6.784226811426261e-05,  -5.659090817622124e-07,  -5.867580607721024e-09,   2.663264672872650e-10,   2.580524288782428e-12,
  -3.495319799097931e-13,   5.103351362787341e-15,   2.787671433845126e-16,   3.702584884479678e-01,  -5.223148111354506e-03,   6.783729068332179e-05,  -5.655386865557387e-07,
  -5.861851463946729e-09,   2.653046003774629e-10,   2.599293565859767e-12,  -3.481109155087891e-13,   5.027333390528907e-15,   2.785206112763997e-16,   3.702743208580498e-01,
  -5.223542477589389e-03,   6.782912302930535e-05,  -5.649316644828994e-07,  -5.852418014757397e-09,   2.636301049289700e-10,   2.629890913202235e-12,  -3.457790568118388e-13,
   4.903143154863606e-15,   2.780978417940843e-16,   3.702911195811565e-01,  -5.223960778226996e-03,   6.782046142501361e-05,  -5.642889810482366e-07,  -5.842370341654572e-09,
   2.618574993564778e-10,   2.662065187677561e-12,  -3.433062353154702e-13,   4.772188751911533e-15,   2.776249180901728e-16,   3.703043397668268e-01,  -5.224289872808907e-03,
   6.781364825755138e-05,  -5.637842081552962e-07,  -5.834435358737432e-09,   2.604654628831132e-10,   2.687175929894842e-12,  -3.413611974272803e-13,   4.669719841926243e-15,
   2.772352596755624e-16,   3.703119691950498e-01,  -5.224479755591347e-03,   6.780971767501840e-05,  -5.634933032097306e-07,  -5.829844983421776e-09,   2.596632989859103e-10,
   2.701583663931031e-12,  -3.402391223527037e-13,   4.610820177649609e-15,   2.770034293615835e-16,   3.703148340835244e-01,  -5.224551050127486e-03,   6.780824197268859e-05,
  -5.633841428304586e-07,  -5.828119189291638e-09,   2.593623066664284e-10,   2.706978032138770e-12,  -3.398178570716690e-13,   4.588747530172670e-15,   2.769150669310234e-16,
   3.703153089778083e-01,  -5.224562867777669e-03,   6.780799736818129e-05,  -5.633660520128047e-07,  -5.827833005537299e-09,   2.593124249186762e-10,   2.707871388894765e-12,
  -3.397480308355358e-13,   4.585091032820390e-15,   2.769003507434224e-16,   5.763629100040696e-01,  -8.115942547537862e-03,   1.037858233746587e-04,  -7.486303603507101e-07,
  -1.524341900243253e-08,   5.792974294118452e-10,   3.075286875228352e-12,  -6.513118767373600e-13,   1.118058719585404e-14,   4.856044207776502e-16,   5.763776533970983e-01,
  -8.116259301781423e-03,   1.037728480657479e-04,  -7.478220385138091e-07,  -1.523636695355032e-08,   5.773908390651702e-10,   3.116702662152618e-12,  -6.488200415283812e-13,
   1.102845254003408e-14,   4.857947564333905e-16,   5.764018557355980e-01,  -8.116779059470293e-03,   1.037515515002852e-04,  -7.464969918358941e-07,  -1.522472762980701e-08,
   5.742662464844062e-10,   3.184261808896749e-12,  -6.447288989711948e-13,   1.077984546260358e-14,   4.860655960238477e-16,   5.764275344838489e-01,  -8.117330228994564e-03,
   1.037289603400644e-04,  -7.450936545131576e-07,  -1.521229317341838e-08,   5.709581298454529e-10,   3.255362546664256e-12,  -6.403874308386853e-13,   1.051760931025942e-14,
   4.862968080278347e-16,   5.764477424881582e-01,  -8.117763761058277e-03,   1.037111854409785e-04,  -7.439911294317959e-07,  -1.520244648572459e-08,   5.683599229365525e-10,
   3.310897247387161e-12,  -6.369704117078369e-13,   1.031235160234748e-14,   4.864384216995183e-16,   5.764594043993675e-01,  -8.118013864269136e-03,   1.037009289932581e-04,
  -7.433556049906611e-07,  -1.519673952896051e-08,   5.668625707651020e-10,   3.342778733781859e-12,  -6.349982997565061e-13,   1.019434291536449e-14,   4.865040788797580e-16,
   5.764637834641038e-01,  -8.118107762259467e-03,   1.036970779348800e-04,  -7.431171036186561e-07,  -1.519459193923311e-08,   5.663007015664181e-10,   3.354718722794857e-12,
  -6.342577388592804e-13,   1.015011435256464e-14,   4.865257085966883e-16,   5.764645093515482e-01,  -8.118123326232749e-03,   1.036964395847680e-04,  -7.430775762165483e-07,
  -1.519423570463933e-08,   5.662075848816109e-10,   3.356696269255514e-12,  -6.341349796525867e-13,   1.014278731024349e-14,   4.865291347395538e-16,   8.548174884519144e-01,
  -1.199579371633643e-02,   1.486350378325507e-04,  -7.148834821198192e-07,  -4.158650434875581e-08,   1.401986978905551e-09,   5.449504505960121e-13,  -1.330079151735540e-12,
   3.050797489316504e-14,   7.653138554196065e-16,   8.548385689340190e-01,  -1.199609199019259e-02,   1.485995443479987e-04,  -7.129213092940155e-07,  -4.158399063347381e-08,
   1.398076439497797e-09,   6.594804658839013e-13,  -1.326064229190506e-12,   3.016701407670634e-14,   7.689310882811904e-16,   8.548731723102236e-01,  -1.199658105723502e-02,
   1.485412780222884e-04,  -7.097040803146138e-07,  -4.157969097667397e-08,   1.391665387095869e-09,   8.465306418104130e-13,  -1.319460562707811e-12,   2.960946441383856e-14,
   7.747533942901415e-16,   8.549098842107491e-01,  -1.199709918342114e-02,   1.484794556863553e-04,  -7.062957766644946e-07,  -4.157489441738118e-08,   1.384874645221642e-09,
   1.043691324331124e-12,  -1.312436776233382e-12,   2.902083873707826e-14,   7.807746107768597e-16,   8.549387730812358e-01,  -1.199750636425061e-02,   1.484308032108167e-04,
  -7.036173476984882e-07,  -4.157095050334647e-08,   1.379538908311206e-09,   1.197909151714132e-12,  -1.306897047043246e-12,   2.855974114601154e-14,   7.854005966953832e-16,
   8.549554439750464e-01,  -1.199774112106229e-02,   1.484027257432878e-04,  -7.020731455839913e-07,  -4.156860686035930e-08,   1.376463006164453e-09,   1.286531896188493e-12,
  -1.303695221296440e-12,   2.829449544815864e-14,   7.880253844717533e-16,   8.549617037896076e-01,  -1.199782923014336e-02,   1.483921825331762e-04,  -7.014935792337709e-07,
  -4.156771405952345e-08,   1.375308627959445e-09,   1.319739017590014e-12,  -1.302492015086560e-12,   2.819505603871734e-14,   7.890025484259421e-16,   8.549627414291321e-01,
  -1.199784383314102e-02,   1.483904348535724e-04,  -7.013975234744655e-07,  -4.156756539354162e-08,   1.375117307741076e-09,   1.325239798632483e-12,  -1.302292519718238e-12,
   2.817858112963909e-14,   7.891640811877030e-16,   1.254480937866936e+00,  -1.744094520946504e-02,   1.959827027269357e-04,   7.222821007107526e-07,  -1.540470914497610e-07,
   5.096232336401872e-09,  -3.331872726281990e-11,  -4.204126183403235e-12,   1.819169010784373e-13,  -1.579404792082243e-15,   1.254508562426680e+00,  -1.744061162921757e-02,
   1.958508189941909e-04,   7.294273530270769e-07,  -1.541098678946556e-07,   5.083562885283556e-09,  -3.261371818561441e-11,  -4.210899995265075e-12,   1.809614657062553e-13,
  -1.529995208829528e-15,   1.254553898994835e+00,  -1.744006182356404e-02,   1.956342743929223e-04,   7.411443675176977e-07,  -1.542118484564048e-07,   5.062750149349465e-09,
  -3.145909246792019e-11,  -4.221840017960536e-12,   1.793913526480974e-13,  -1.449234993331917e-15,   1.254601986088966e+00,  -1.743947547710643e-02,   1.954044551179686e-04,
   7.535592500682907e-07,  -1.543185961432806e-07,   5.040647709377410e-09,  -3.023769986301151e-11,  -4.233203924115212e-12,   1.777232003719011e-13,  -1.364023034989596e-15,
   1.254639817482772e+00,  -1.743901187786629e-02,   1.952235511512586e-04,   7.633169522779597e-07,  -1.544015507572098e-07,   5.023239730927873e-09,  -2.927917768316251e-11,
  -4.241971061346778e-12,   1.764088438948413e-13,  -1.297309154324237e-15,   1.254661645347341e+00,  -1.743874346783606e-02,   1.951191340019588e-04,   7.689431499873552e-07,
  -1.544490026452684e-07,   5.013187992596201e-09,  -2.872708678467072e-11,  -4.246960257548413e-12,   1.756497095860803e-13,  -1.258946984003163e-15,   1.254669840912022e+00,
  -1.743864251512774e-02,   1.950799217017262e-04,   7.710548670838956e-07,  -1.544667414517815e-07,   5.009412478399557e-09,  -2.851997744192734e-11,  -4.248820449149480e-12,
   1.753645364197230e-13,  -1.244568022906694e-15,   1.254671199390603e+00,  -1.743862577222292e-02,   1.950734215636153e-04,   7.714048629208317e-07,  -1.544696777022246e-07,
   5.008786580995295e-09,  -2.848565698771942e-11,  -4.249128101378263e-12,   1.753172590826888e-13,  -1.242185898000468e-15,   4.042521300149685e-03,  -5.437321631132525e-05,
   7.067686205450049e-07,  -7.660570515380120e-09,   2.218478735266796e-11,   1.689779804088742e-12,  -2.711679950812040e-14,  -1.202916565874543e-15,   6.463290271405183e-17,
  -6.872397369982524e-19,   4.042621915981648e-03,  -5.437647839722752e-05,   7.067872532930847e-07,  -7.658196644855296e-09,   2.212988226635059e-11,   1.686135775615148e-12,
  -2.686530842205762e-14,  -1.206042713688567e-15,   6.434186059937575e-17,  -6.724440635342823e-19,   4.042787095026474e-03,  -5.438183291407769e-05,   7.068178090238316e-07,
  -7.654303320259992e-09,   2.204013147110615e-11,   1.680147015268871e-12,  -2.645328504393313e-14,  -1.211120782286675e-15,   6.386375915673917e-17,  -6.482575317101439e-19,
   4.042962365303885e-03,  -5.438751348549271e-05,   7.068501863755412e-07,  -7.650177326595750e-09,   2.194542119051362e-11,   1.673783709961566e-12,  -2.601723839571079e-14,
  -1.216435811800154e-15,   6.335604863396368e-17,  -6.227336268125999e-19,   4.043100305774362e-03,  -5.439198341253259e-05,   7.068756353019533e-07,  -7.646933861041592e-09,
   2.187126126587775e-11,   1.668769456891050e-12,  -2.567489457790663e-14,  -1.220565937785524e-15,   6.295619151754672e-17,  -6.027474058216353e-19,   4.043179914654835e-03,
  -5.439456280939026e-05,   7.068903094931257e-07,  -7.645063482961828e-09,   2.182861328534489e-11,   1.665873125033765e-12,  -2.547765295485324e-14,  -1.222928391308171e-15,
   6.272531438902254e-17,  -5.912535274535062e-19,   4.043209808720443e-03,  -5.439553134462759e-05,   7.068958173669756e-07,  -7.644361418997572e-09,   2.181262709385890e-11,
   1.664785051456140e-12,  -2.540364946971728e-14,  -1.223811530068410e-15,   6.263859696029563e-17,  -5.869451262657700e-19,   4.043214764097065e-03,  -5.439569189036191e-05,
   7.068967302477629e-07,  -7.644245056704769e-09,   2.180997865936484e-11,   1.664604662824767e-12,  -2.539138564110703e-14,  -1.223957712834932e-15,   6.262422121808640e-17,
  -5.862313513845150e-19,   3.660534673523074e-02,  -4.923169879272646e-04,   6.394975752257859e-06,  -6.898416505252318e-08,   1.808076617435860e-10,   1.599522041478395e-11,
  -2.583442298252796e-13,  -1.098982985453821e-14,   5.984786974513960e-16,  -6.492031051588011e-18,   3.660625709172918e-02,  -4.923463594218216e-04,   6.395127179328864e-06,
  -6.896168431271632e-08,   1.802837838750911e-10,   1.596191238703426e-11,  -2.560151681642585e-13,  -1.101941470612135e-14,   5.958003673710824e-16,  -6.354281137280659e-18,
   3.660775160441065e-02,  -4.923945706144623e-04,   6.395375456802741e-06,  -6.892481298830770e-08,   1.794273172931108e-10,   1.590717033655527e-11,  -2.521993677187657e-13,
  -1.106748013177001e-14,   5.914003335805674e-16,  -6.129092334372801e-18,   3.660933741846297e-02,  -4.924457170862830e-04,   6.395638472059187e-06,  -6.888573651494021e-08,
   1.785233769016236e-10,   1.584900175296713e-11,  -2.481610204684906e-13,  -1.111779971368838e-14,   5.867274242179512e-16,  -5.891440261992307e-18,   3.661058547735157e-02,
  -4.924859628780643e-04,   6.395845158709272e-06,  -6.885501707303299e-08,   1.778154679238134e-10,   1.580316311381816e-11,  -2.449904344196623e-13,  -1.115690954301053e-14,
   5.830469125186244e-16,  -5.705340935556934e-18,   3.661130576250849e-02,  -4.925091868071545e-04,   6.395964318567944e-06,  -6.883730189901113e-08,   1.774083198291925e-10,
   1.577668497696041e-11,  -2.431636806023718e-13,  -1.117928389234837e-14,   5.809216797474310e-16,  -5.598313685436837e-18,   3.661157623787476e-02,  -4.925179071124996e-04,
   6.396009041058965e-06,  -6.883065224970560e-08,   1.772556960873765e-10,   1.576673770011807e-11,  -2.424782936352366e-13,  -1.118764856437568e-14,   5.801234220295589e-16,
  -5.558194622026339e-18,   3.661162107309771e-02,  -4.925193526009798e-04,   6.396016453227892e-06,  -6.882955011100319e-08,   1.772304104617652e-10,   1.576508856106024e-11,
  -2.423647113910406e-13,  -1.118903317176778e-14,   5.799910883006020e-16,  -5.551548044128524e-18,   1.029705958760666e-01,  -1.384662830793217e-03,   1.795958957390598e-05,
  -1.917305733004261e-07,   3.864199797522592e-10,   4.924244301814232e-11,  -8.059738901147618e-13,  -3.147919597979986e-14,   1.764817599248041e-15,  -1.997031814122894e-17,
   1.029731523023650e-01,  -1.384744440245523e-03,   1.795991027015657e-05,  -1.916613053753373e-07,   3.847809176893291e-10,   4.914693099425982e-11,  -7.991035822798325e-13,
  -3.157054686869377e-14,   1.757031059517285e-15,  -1.955953579666846e-17,   1.029773491215262e-01,  -1.384878394189283e-03,   1.796043575918764e-05,  -1.915476896899615e-07,
   3.821006455994863e-10,   4.898994230407161e-11,  -7.878473469736818e-13,  -3.171901403434384e-14,   1.744237294440410e-15,  -1.888794687153170e-17,   1.029818023140141e-01,
  -1.385020500908745e-03,   1.796099200745018e-05,  -1.914272690802751e-07,   3.792709394922540e-10,   4.882310837287136e-11,  -7.759341890764700e-13,  -3.187451604627153e-14,
   1.730647636570057e-15,  -1.817911225963764e-17,   1.029853070309962e-01,  -1.385132318828342e-03,   1.796142881306608e-05,  -1.913325948278430e-07,   3.770542626106037e-10,
   4.869162464513205e-11,  -7.665806228048083e-13,  -3.199542933754858e-14,   1.719942275316013e-15,  -1.762398693625934e-17,   1.029873296841507e-01,  -1.385196842796830e-03,
   1.796168051634252e-05,  -1.912779955348330e-07,   3.757791055441772e-10,   4.861566929294209e-11,  -7.611913803018660e-13,  -3.206462392969480e-14,   1.713759986281465e-15,
  -1.730470785516185e-17,   1.029880892128752e-01,  -1.385221070612898e-03,   1.796177496061635e-05,  -1.912575003450471e-07,   3.753010515072463e-10,   4.858713346046520e-11,
  -7.591693457005482e-13,  -3.209049644315160e-14,   1.711437726307698e-15,  -1.718502224849510e-17,   1.029882151157571e-01,  -1.385225086637089e-03,   1.796179061226821e-05,
  -1.912541033637858e-07,   3.752218483484241e-10,   4.858240250884172e-11,  -7.588342531376310e-13,  -3.209477934458617e-14,   1.711052739210265e-15,  -1.716519355830744e-17,
   2.058975963032832e-01,  -2.767987810771787e-03,   3.581129448392247e-05,  -3.754279317891194e-07,   3.511574389279376e-10,   1.132680708895516e-10,  -1.893731497285239e-12,
  -6.471281063185557e-14,   3.814563273993869e-15,  -4.629065160569013e-17,   2.059026930723013e-01,  -2.768147525978511e-03,   3.581157249906568e-05,  -3.752684071351633e-07,
   3.472910774749880e-10,   1.130713234905378e-10,  -1.878872445861507e-12,  -6.492584743306989e-14,   3.798184010945157e-15,  -4.538695596930711e-17,   2.059110602689198e-01,
  -2.768409675513835e-03,   3.581202657554372e-05,  -3.750067253295295e-07,   3.409665629870812e-10,   1.127478862020971e-10,  -1.854526250574061e-12,  -6.527228005177362e-14,
   3.771264809472634e-15,  -4.390928446964456e-17,   2.059199385456655e-01,  -2.768687770110486e-03,   3.581250522623247e-05,  -3.747293378392402e-07,   3.342866345545445e-10,
   1.124040938833078e-10,  -1.828757443005447e-12,  -6.563539643050234e-14,   3.742661439041599e-15,  -4.234936805052835e-17,   2.059269258209746e-01,  -2.768906584028521e-03,
   3.581287964522251e-05,  -3.745112332665035e-07,   3.290518151114435e-10,   1.121330958876924e-10,  -1.808523909063766e-12,  -6.591794001994652e-14,   3.720122043690267e-15,
  -4.112750353097953e-17,   2.059309583241214e-01,  -2.769032846591327e-03,   3.581309481712575e-05,  -3.743854414213913e-07,   3.260396347441424e-10,   1.119765256242314e-10,
  -1.796865453135545e-12,  -6.607970943884654e-14,   3.707102927368049e-15,  -4.042466581650809e-17,   2.059324725710259e-01,  -2.769080255805974e-03,   3.581317544405495e-05,
  -3.743382205684027e-07,   3.249102188786335e-10,   1.119176995384386e-10,  -1.792491125133222e-12,  -6.614021162926576e-14,   3.702212027239610e-15,  -4.016118257217916e-17,
   2.059327235792237e-01,  -2.769088114370264e-03,   3.581318880004075e-05,  -3.743303938400428e-07,   3.247230910422929e-10,   1.119079465666140e-10,  -1.791766204338187e-12,
  -6.615022787895348e-14,   3.701401180699495e-15,  -4.011752962855974e-17,   3.503979698595437e-01,  -4.708517474454482e-03,   6.066664663312054e-05,  -6.167228693551932e-07,
  -5.918949601591890e-10,   2.352373133699927e-10,  -4.060424981316588e-12,  -1.142219788089996e-13,   7.321622216042303e-15,  -9.900254138620732e-17,   3.504066020573944e-01,
  -4.708779595378056e-03,   6.066609422402439e-05,  -6.163910590776248e-07,  -6.002241012298023e-10,   2.348887146597847e-10,  -4.031871715472169e-12,  -1.146817086069354e-13,
   7.291794162588942e-15,  -9.722432578184271e-17,   3.504207731433886e-01,  -4.709209807616989e-03,   6.066518232188398e-05,  -6.158467003152737e-07,  -6.138540124006741e-10,
   2.343154711066538e-10,  -3.985083259988473e-12,  -1.154299269964311e-13,   7.242748070163932e-15,  -9.431595267022287e-17,   3.504358096739447e-01,  -4.709666157926055e-03,
   6.066420789733765e-05,  -6.152695854424864e-07,  -6.282570532369511e-10,   2.337059151169969e-10,  -3.935554570592400e-12,  -1.162150292263600e-13,   7.190601178594265e-15,
  -9.124470662545224e-17,   3.504476434393682e-01,  -4.710025208058856e-03,   6.066343608946791e-05,  -6.148157495273920e-07,  -6.395494099022748e-10,   2.332252559092026e-10,
  -3.896660381736608e-12,  -1.168265436488195e-13,   7.149486319346417e-15,  -8.883831517519840e-17,   3.504544729114216e-01,  -4.710232382859288e-03,   6.066298869139712e-05,
  -6.145539749932859e-07,  -6.460492674283574e-10,   2.329474850800697e-10,  -3.874247947298496e-12,  -1.171769148285052e-13,   7.125728462258852e-15,  -8.745382899124201e-17,
   3.504570374412853e-01,  -4.710310171488600e-03,   6.066282031657015e-05,  -6.144557031060885e-07,  -6.484867831879499e-10,   2.328431091046684e-10,  -3.865838315936400e-12,
  -1.173080021980328e-13,   7.116801589290919e-15,  -8.693475164989697e-17,   3.504574625485647e-01,  -4.710323065668139e-03,   6.066279238639758e-05,  -6.144394145617233e-07,
  -6.488906651623352e-10,   2.328258035915471e-10,  -3.864444640078621e-12,  -1.173297064743834e-13,   7.115321540055760e-15,  -8.684874993987212e-17,   5.454981239304658e-01,
  -7.324857151325906e-03,   9.371934711593383e-05,  -9.011579398721927e-07,  -4.142790899739196e-09,   4.844144491438144e-10,  -8.782422899738933e-12,  -1.844843468243196e-13,
   1.374821636389651e-14,  -2.199847628006321e-16,   5.455114535612552e-01,  -7.325239458030946e-03,   9.371570752667986e-05,  -9.004733900892036e-07,  -4.160901061368877e-09,
   4.838467715167666e-10,  -8.728680915010956e-12,  -1.855193155085554e-13,   1.369834183831969e-14,  -2.165397141851476e-16,   5.455333359175765e-01,  -7.325866866281726e-03,
   9.370972157686109e-05,  -8.993501814024563e-07,  -4.190549463260479e-09,   4.829126607975940e-10,  -8.640599629673953e-12,  -1.872057665029147e-13,   1.361624704861976e-14,
  -2.109024880571312e-16,   5.455565542584853e-01,  -7.326532309516694e-03,   9.370335513308970e-05,  -8.981591740034401e-07,  -4.221896899265074e-09,   4.819185545808469e-10,
  -8.547335816700341e-12,  -1.889781105179339e-13,   1.352884535575231e-14,  -2.049459771343230e-16,   5.455748268303361e-01,  -7.327055810274926e-03,   9.369833395048568e-05,
  -8.972224278517457e-07,  -4.246486639781533e-09,   4.811340689242549e-10,  -8.474079772198644e-12,  -1.903605953865479e-13,   1.345985019506455e-14,  -2.002763217473959e-16,
   5.455853721346061e-01,  -7.327357850024370e-03,   9.369543182265449e-05,  -8.966820473044579e-07,  -4.260645480633159e-09,   4.806804814033173e-10,  -8.431859709616144e-12,
  -1.911535099954351e-13,   1.341994852381224e-14,  -1.975886586394910e-16,   5.455893319720477e-01,  -7.327471253311564e-03,   9.369434123192347e-05,  -8.964791732955490e-07,
  -4.265956149964143e-09,   4.805099954240665e-10,  -8.416016521829782e-12,  -1.914503239239194e-13,   1.340494941497036e-14,  -1.965807928929155e-16,   5.455899883702444e-01,
  -7.327490050704527e-03,   9.369416040803741e-05,  -8.964455463604856e-07,  -4.266836146857503e-09,   4.804817265371349e-10,  -8.413390860129458e-12,  -1.914994758688116e-13,
   1.340246227548610e-14,  -1.964137974709678e-16,   8.091449230016480e-01,  -1.085025780875555e-02,   1.369623577989151e-04,  -1.165727600124693e-06,  -1.580467914644416e-08,
   1.090375012245361e-09,  -2.151836659015531e-11,  -2.653672955552020e-13,   2.793354570348455e-14,  -5.925031406800561e-16,   8.091643861023676e-01,  -1.085075002820009e-02,
   1.369486108473314e-04,  -1.164183033129731e-06,  -1.584930988063845e-08,   1.089536903455992e-09,  -2.140852983614355e-11,  -2.682117161921308e-13,   2.786352609999769e-14,
  -5.853648634293128e-16,   8.091963364790603e-01,  -1.085155761118521e-02,   1.369260158703222e-04,  -1.161648256965967e-06,  -1.592240978378397e-08,   1.088154992098953e-09,
  -2.122842087678798e-11,  -2.728550522072327e-13,   2.774784435566136e-14,  -5.736714618547544e-16,   8.092302363219559e-01,  -1.085241387388389e-02,   1.369020040364840e-04,
  -1.158959863590799e-06,  -1.599974537097655e-08,   1.086680526421388e-09,  -2.103759225284948e-11,  -2.777463793290056e-13,   2.762410728754445e-14,  -5.612983586744232e-16,
   8.092569142445498e-01,  -1.085308729005910e-02,   1.368830799851429e-04,  -1.156844955350225e-06,  -1.606044317831761e-08,   1.085514236983423e-09,  -2.088761339266735e-11,
  -2.815701371071351e-13,   2.752601420130618e-14,  -5.515857976685945e-16,   8.092723100210012e-01,  -1.085347574451796e-02,   1.368721478923381e-04,  -1.155624750635129e-06,
  -1.609540669262024e-08,   1.084838800656950e-09,  -2.080113983225772e-11,  -2.837665972777501e-13,   2.746911934746740e-14,  -5.459906161038321e-16,   8.092780911795505e-01,
  -1.085362157765502e-02,   1.368680407710495e-04,  -1.155166617921723e-06,  -1.610852329941433e-08,   1.084584724775238e-09,  -2.076868371645447e-11,  -2.845894437440070e-13,
   2.744770140178784e-14,  -5.438914900519171e-16,   8.092790494836000e-01,  -1.085364574971884e-02,   1.368673598508221e-04,  -1.155090679366480e-06,  -1.611069690330529e-08,
   1.084542584723258e-09,  -2.076330447270853e-11,  -2.847257396944037e-13,   2.744414826064787e-14,  -5.435436313131257e-16,   1.187858288016038e+00,  -1.587300476113633e-02,
   1.930014027134250e-04,  -9.996762391449202e-07,  -6.658265876123706e-08,   3.461617161135276e-09,  -8.321518819646599e-11,   6.848375468202614e-14,   7.755158066125331e-14,
  -3.005291386383706e-15,   1.187885637212758e+00,  -1.587341414347782e-02,   1.929435680643438e-04,  -9.947506182746153e-07,  -6.675656382421151e-08,   3.461582038664885e-09,
  -8.290194185506731e-11,   5.343450498957393e-14,   7.775932367498073e-14,  -2.992463260773517e-15,   1.187930529241341e+00,  -1.587408469120142e-02,   1.928485169892604e-04,
  -9.866645498185577e-07,  -6.704157163604202e-08,   3.461492101209378e-09,  -8.238712142239413e-11,   2.877700279673893e-14,   7.809645558349111e-14,  -2.971300605479219e-15,
   1.187978154851765e+00,  -1.587479412888588e-02,   1.927475163656643e-04,  -9.780848082854704e-07,  -6.734332665202843e-08,   3.461352859561147e-09,  -8.184008066552600e-11,
   2.679305038656709e-15,   7.844886836900196e-14,  -2.948706079278177e-15,   1.188015630442409e+00,  -1.587535096479507e-02,   1.926679241511813e-04,  -9.713326671086141e-07,
  -6.758033099041675e-08,   3.461211600745425e-09,  -8.140899935419286e-11,  -1.781190564780553e-14,   7.872237935059996e-14,  -2.930823954861230e-15,   1.188037255925978e+00,
  -1.587567172631955e-02,   1.926219482048595e-04,  -9.674359434070649e-07,  -6.771691892323904e-08,   3.461117395660148e-09,  -8.115999207313238e-11,  -2.961856493348617e-14,
   7.887869039563073e-14,  -2.920463948532029e-15,   1.188045376053915e+00,  -1.587579206217657e-02,   1.926046758988496e-04,  -9.659726985071519e-07,  -6.776817276377431e-08,
   3.461079625499619e-09,  -8.106644562474255e-11,  -3.404844404485447e-14,   7.893709634480670e-14,  -2.916566154396979e-15,   1.188046722057280e+00,  -1.587581200359108e-02,
   1.926018123512636e-04,  -9.657301454513789e-07,  -6.777666690685722e-08,   3.461073238240340e-09,  -8.105093676465807e-11,  -3.478256779795931e-14,   7.894676265173721e-14,
  -2.915919643827103e-15,   3.835766094841519e-03,  -4.907844281680709e-05,   6.179502350501483e-07,  -7.078239163491407e-09,   4.782262876387984e-11,   8.371688687640018e-13,
  -3.713447422572261e-14,   2.742053982215820e-16,   2.548471094079096e-17,  -1.100882219366369e-18,   3.835854114918139e-03,  -4.908146044148470e-05,   6.179906265719561e-07,
  -7.077041714628200e-09,   4.774458813249652e-11,   8.379003700091640e-13,  -3.703136625890257e-14,   2.686864142703547e-16,   2.556113674503258e-17,  -1.096402835945445e-18,
   3.835998618207679e-03,  -4.908641399003762e-05,   6.180568880232010e-07,  -7.075075192557400e-09,   4.761663169972749e-11,   8.390894059639084e-13,  -3.686188486873052e-14,
   2.596428840175999e-16,   2.568535823216007e-17,  -1.089024096745363e-18,   3.836151952920931e-03,  -4.909166958395831e-05,   6.181271316770111e-07,  -7.072987594229366e-09,
   4.748107751975252e-11,   8.403349911224622e-13,  -3.668176452006586e-14,   2.500698480715718e-16,   2.581547915121547e-17,  -1.081160836544332e-18,   3.836272632165850e-03,
  -4.909580539903999e-05,   6.181823668788766e-07,  -7.071343948870284e-09,   4.737455327004397e-11,   8.413036509995778e-13,  -3.653980224052590e-14,   2.425524004147815e-16,
   2.591666528106916e-17,  -1.074948117789204e-18,   3.836342280128605e-03,  -4.909819211247888e-05,   6.182142253990754e-07,  -7.070395092315318e-09,   4.731313926230728e-11,
   8.418580299996078e-13,  -3.645779071490957e-14,   2.382205939723415e-16,   2.597457358178708e-17,  -1.071352969671164e-18,   3.836368433935553e-03,  -4.909908831944945e-05,
   6.182261850394558e-07,  -7.070038735152587e-09,   4.729008964624796e-11,   8.420653258747714e-13,  -3.642697907260302e-14,   2.365952178222501e-16,   2.599622653795198e-17,
  -1.070001137111750e-18,   3.836372769319469e-03,  -4.909923687712372e-05,   6.182281673337593e-07,  -7.069979661108990e-09,   4.728626947324455e-11,   8.420996417797280e-13,
  -3.642187078568709e-14,   2.363258549803682e-16,   2.599981096424522e-17,  -1.069776955776065e-18,   3.473325386712138e-02,  -4.443974916148362e-04,   5.593789034332531e-06,
  -6.393816620409552e-08,   4.237561421176492e-10,   7.972907772489507e-12,  -3.474523433507434e-13,   2.639424784288581e-15,   2.337292660012543e-16,  -1.019623770174724e-17,
   3.473405062362497e-02,  -4.444247479231939e-04,   5.594146723265471e-06,  -6.392676119466164e-08,   4.230257257699208e-10,   7.979980755672531e-12,  -3.465062712992790e-13,
   2.588295065826877e-15,   2.344511606833429e-16,  -1.015526012153718e-17,   3.473535866454472e-02,  -4.444694900332529e-04,   5.594733480375997e-06,  -6.390803108837301e-08,
   4.218280964618012e-10,   7.991482487644861e-12,  -3.449511279954982e-13,   2.504510878249161e-15,   2.356247311695169e-16,  -1.008775104064543e-17,   3.473674664619772e-02,
  -4.445169600698360e-04,   5.595355467790768e-06,  -6.388814763081111e-08,   4.205593150991075e-10,   8.003537786023255e-12,  -3.432982831828313e-13,   2.415818498688147e-15,
   2.368543265662975e-16,  -1.001579810673338e-17,   3.473783903061402e-02,  -4.445543157617826e-04,   5.595844535897267e-06,  -6.387249251141920e-08,   4.195622238816095e-10,
   8.012917685260482e-12,  -3.419955322754574e-13,   2.346168906551178e-15,   2.378107110276301e-16,  -9.958940654109535e-18,   3.473846948127043e-02,  -4.445758730683339e-04,
   5.596126610718213e-06,  -6.386345495253240e-08,   4.189873632496925e-10,   8.018287891005848e-12,  -3.412429109345046e-13,   2.306033725278536e-15,   2.383581307835402e-16,
  -9.926035520280155e-18,   3.473870622445350e-02,  -4.445839677878440e-04,   5.596232499378030e-06,  -6.386006075400893e-08,   4.187716070817859e-10,   8.020296312666838e-12,
  -3.409601475839252e-13,   2.290974102058133e-15,   2.385628372176130e-16,  -9.913662082570222e-18,   3.473874546816680e-02,  -4.445853095895691e-04,   5.596250050185859e-06,
  -6.385949809040950e-08,   4.187358481978951e-10,   8.020628807811333e-12,  -3.409132677934147e-13,   2.288478362896842e-15,   2.385967251466935e-16,  -9.911610100956277e-18,
   9.770496362582071e-02,  -1.250017113786749e-03,   1.572444868871704e-05,  -1.789158017602491e-07,   1.135749960356784e-09,   2.481642758213894e-11,  -1.046033301995445e-12,
   8.402879580298633e-15,   6.749667867094106e-16,  -3.007666931140396e-17,   9.770720325527796e-02,  -1.250093371413526e-03,   1.572540599185462e-05,  -1.788802966378277e-07,
   1.133549637726040e-09,   2.483913409092507e-11,  -1.043298447065615e-12,   8.251970160366337e-15,   6.771859385472708e-16,  -2.995910129595303e-17,   9.771088006608605e-02,
  -1.250218549654254e-03,   1.572697621240618e-05,  -1.788219868743197e-07,   1.129941695168668e-09,   2.487608661938867e-11,  -1.038802544543236e-12,   8.004668779994918e-15,
   6.807949164582288e-16,  -2.976535996506474e-17,   9.771478157774391e-02,  -1.250351358496024e-03,   1.572864050788233e-05,  -1.787600855024967e-07,   1.126119161167106e-09,
   2.491485645356754e-11,  -1.034023677917989e-12,   7.742863522022320e-15,   6.845780220154099e-16,  -2.955879483899125e-17,   9.771785218287106e-02,  -1.250455868928141e-03,
   1.572994899341487e-05,  -1.787113470701134e-07,   1.123114989839635e-09,   2.494505060912656e-11,  -1.030256669282005e-12,   7.537257414171725e-15,   6.875218807563900e-16,
  -2.939551567681242e-17,   9.771962432717626e-02,  -1.250516179602381e-03,   1.573070361575085e-05,  -1.786832105051836e-07,   1.121382901894534e-09,   2.496234895019213e-11,
  -1.028080257485998e-12,   7.418773255020353e-15,   6.892074433527180e-16,  -2.930100088575590e-17,   9.772028979217309e-02,  -1.250538826039914e-03,   1.573098688376339e-05,
  -1.786726433135333e-07,   1.120732802976409e-09,   2.496882060518233e-11,  -1.027262541719696e-12,   7.374314423811139e-15,   6.898378591418780e-16,  -2.926545634601031e-17,
   9.772040010290080e-02,  -1.250542579967811e-03,   1.573103383420732e-05,  -1.786708915643158e-07,   1.120625056519672e-09,   2.496989210659504e-11,  -1.027126969848661e-12,
   7.366946485987076e-15,   6.899422261826373e-16,  -2.925956152380317e-17,   1.953704322448712e-01,  -2.499268491786115e-03,   3.140548917140122e-05,  -3.545484706515639e-07,
   2.078249756955516e-09,   5.787021806602311e-11,  -2.331674350925240e-12,   2.034305576932371e-14,   1.406365124992020e-15,  -6.500651349947616e-17,   1.953749049888141e-01,
  -2.499419563664777e-03,   3.140723589194469e-05,  -3.544656524701800e-07,   2.073340503351574e-09,   5.792580798169155e-11,  -2.325965516859035e-12,   2.001654890534632e-14,
   1.411496388052311e-15,  -6.476508379095742e-17,   1.953822478973197e-01,  -2.499667546949215e-03,   3.141010040847601e-05,  -3.543296380000180e-07,   2.065290031766986e-09,
   5.801636685724900e-11,  -2.316579187947649e-12,   1.948144187179353e-14,   1.419846209367857e-15,  -6.436702876506113e-17,   1.953900395290823e-01,  -2.499930641506515e-03,
   3.141313579690427e-05,  -3.541852417481466e-07,   2.056759916264701e-09,   5.811150523313870e-11,  -2.306600175875666e-12,   1.891488780733662e-14,   1.428605615173266e-15,
  -6.394235511049594e-17,   1.953961717566509e-01,  -2.500137673049576e-03,   3.141552170826751e-05,  -3.540715475897371e-07,   2.050055409468354e-09,   5.818569151067817e-11,
  -2.298732692257896e-12,   1.846990423414570e-14,   1.435426733024386e-15,  -6.360647751607303e-17,   1.953997108541689e-01,  -2.500257144875377e-03,   3.141689748052968e-05,
  -3.540059111039777e-07,   2.046189613534375e-09,   5.822823030924698e-11,  -2.294186652356222e-12,   1.821345612720958e-14,   1.439334276601291e-15,  -6.341197590387620e-17,
   1.954010398335305e-01,  -2.500302005819783e-03,   3.141741387302955e-05,  -3.539812599250084e-07,   2.044738631759961e-09,   5.824415200228729e-11,  -2.292478521607421e-12,
   1.811722557620687e-14,   1.440796110424456e-15,  -6.333881435142005e-17,   1.954012601315708e-01,  -2.500309442062459e-03,   3.141749946068087e-05,  -3.539771734271542e-07,
   2.044498145748945e-09,   5.824678850581950e-11,  -2.292195319309745e-12,   1.810127758866278e-14,   1.441038140915093e-15,  -6.332668023364865e-17,   3.324878916814071e-01,
  -4.252628471775207e-03,   5.334532132661366e-05,  -5.945118796692892e-07,   2.999064640293381e-09,   1.217904853074589e-10,  -4.660387451890995e-12,   4.540078510113774e-14,
   2.535480128108973e-15,  -1.245825656722294e-16,   3.324954881492884e-01,  -4.252881665768366e-03,   5.334782645479605e-05,  -5.943375108086659e-07,   2.989239508983051e-09,
   1.219161693857251e-10,  -4.650061190451081e-12,   4.477392873522252e-14,   2.546379186227438e-15,  -1.241618769939708e-16,   3.325079592299002e-01,  -4.253297270651176e-03,
   5.335193300403065e-05,  -5.940511309698684e-07,   2.973126014557322e-09,   1.221211536280737e-10,  -4.633078386163009e-12,   4.374642777635231e-14,   2.564129743696374e-15,
  -1.234675959378634e-16,   3.325211923486545e-01,  -4.253738186097869e-03,   5.335628218836772e-05,  -5.937470905143153e-07,   2.956050188495162e-09,   1.223368296262106e-10,
  -4.615016988081094e-12,   4.265833157721465e-14,   2.582771680131048e-15,  -1.227259770900364e-16,   3.325316071273864e-01,  -4.254085135672414e-03,   5.335969909976063e-05,
  -5.935076870841130e-07,   2.942627254012541e-09,   1.225052456518566e-10,  -4.600772824317383e-12,   4.180356500314721e-14,   2.597303585767975e-15,  -1.221387719331838e-16,
   3.325376177978654e-01,  -4.254285345726413e-03,   5.336166869471633e-05,  -5.933694739770733e-07,   2.934886968144295e-09,   1.226019123563670e-10,  -4.592540371936049e-12,
   4.131089404202022e-14,   2.605634415181575e-15,  -1.217984704745143e-16,   3.325398748829163e-01,  -4.254360522560383e-03,   5.336240784915244e-05,  -5.933175643982693e-07,
   2.931981615217951e-09,   1.226381116472647e-10,  -4.589446768101765e-12,   4.112601078696692e-14,   2.608752181487111e-15,  -1.216704176095732e-16,   3.325402490280474e-01,
  -4.254372983983948e-03,   5.336253035094752e-05,  -5.933089591586967e-07,   2.931500074781131e-09,   1.226441069229258e-10,  -4.588933841188329e-12,   4.109537005536518e-14,
   2.609268439863876e-15,  -1.216491769899490e-16,   5.176289963454748e-01,  -6.618828344592781e-03,   8.278748261929520e-05,  -9.023574787252468e-07,   3.240453394417223e-09,
   2.528329389268734e-10,  -9.196344701313672e-12,   1.035093484945283e-13,   4.243255914857451e-15,  -2.324795557962519e-16,   5.176407829534402e-01,  -6.619212300668815e-03,
   8.279013951726265e-05,  -9.019952422786266e-07,   3.221030124010358e-09,   2.531235527511626e-10,  -9.178948306035147e-12,   1.023357274835138e-13,   4.267055585484731e-15,
  -2.318395514910098e-16,   5.176601328342583e-01,  -6.619842514389037e-03,   8.279448932476919e-05,  -9.014002813684743e-07,   3.189170778470429e-09,   2.535981188556180e-10,
  -9.150322273319070e-12,   1.004114685086977e-13,   4.305863580600159e-15,  -2.307809060469232e-16,   5.176806649010625e-01,  -6.620511067159323e-03,   8.279908861502044e-05,
  -9.007685875664098e-07,   3.155402432392588e-09,   2.540982434163500e-10,  -9.119857149608884e-12,   9.837299935632804e-14,   4.346684670167925e-15,  -2.296468192475392e-16,
   5.176968239968071e-01,  -6.621037111110969e-03,   8.280269656466242e-05,  -9.002711568584681e-07,   3.128853313745842e-09,   2.544893653138403e-10,  -9.095815600451508e-12,
   9.677112848573619e-14,   4.378552678075056e-15,  -2.287465245839932e-16,   5.177061498274999e-01,  -6.621340657019246e-03,   8.280477408901714e-05,  -8.999839662480328e-07,
   3.113542034140087e-09,   2.547140965603929e-10,  -9.081914669297123e-12,   9.584762965745325e-14,   4.396840818405377e-15,  -2.282238499226973e-16,   5.177096517886465e-01,
  -6.621454633143564e-03,   8.280555333315418e-05,  -8.998761018858684e-07,   3.107794527297142e-09,   2.547982978102324e-10,  -9.076689814210979e-12,   9.550103090197022e-14,
   4.403688640964512e-15,  -2.280269967551307e-16,   5.177102322898339e-01,  -6.621473525875341e-03,   8.280568245724195e-05,  -8.998582206943147e-07,   3.106841902950077e-09,
   2.548122454798032e-10,  -9.075823460599501e-12,   9.544358692832772e-14,   4.404822734114861e-15,  -2.279943347778058e-16,   7.678425730777099e-01,  -9.813343760857849e-03,
   1.220820239029993e-04,  -1.273177265188162e-06,   6.703799596142712e-10,   5.649756024332563e-10,  -1.981312983987758e-11,   2.726042051198849e-13,   6.615402792679580e-15,
  -4.615113954515717e-16,   7.678599469156338e-01,  -9.813884443494359e-03,   1.220823587133937e-04,  -1.272366735726557e-06,   6.284165417953417e-10,   5.657527977754986e-10,
  -1.978550940740818e-11,   2.702571741606019e-13,   6.676621947855346e-15,  -4.608850882415872e-16,   7.678884688796448e-01,  -9.814771809955828e-03,   1.220828825672726e-04,
  -1.271035336583609e-06,   5.595700778496976e-10,   5.670236318504504e-10,  -1.973999251633925e-11,   2.664066115828980e-13,   6.776629940080083e-15,  -4.598370612624006e-16,
   7.679187328828336e-01,  -9.815713032295661e-03,   1.220834033786598e-04,  -1.269621556709289e-06,   4.865776216777199e-10,   5.683652139996595e-10,  -1.969146058166915e-11,
   2.623242620262511e-13,   6.882075749136003e-15,  -4.586981511852345e-16,   7.679425508076332e-01,  -9.816453531463100e-03,   1.220837879031363e-04,  -1.268508137487794e-06,
   4.291749796525690e-10,   5.694160737938215e-10,  -1.965309616386635e-11,   2.591139207823804e-13,   6.964576650522744e-15,  -4.577824412809080e-16,   7.679562965955129e-01,
  -9.816880788665145e-03,   1.220839996593208e-04,  -1.267865254754518e-06,   3.960639879781962e-10,   5.700205531404056e-10,  -1.963088755384441e-11,   2.572621781833662e-13,
   7.011994883342655e-15,  -4.572462226783381e-16,   7.679614582750761e-01,  -9.817041209211468e-03,   1.220840772559101e-04,  -1.267623788008149e-06,   3.836337359211375e-10,
   5.702471646589544e-10,  -1.962253521769388e-11,   2.565670221876459e-13,   7.029764106118171e-15,  -4.570434064034676e-16,   7.679623138973209e-01,  -9.817067800222332e-03,
   1.220840900173801e-04,  -1.267583758386962e-06,   3.815734155200656e-10,   5.702847089027876e-10,  -1.962115002468913e-11,   2.564518002771949e-13,   7.032707667928930e-15,
  -4.570097097077727e-16,   1.127358820832199e+00,  -1.439051218627794e-02,   1.765578882196417e-04,  -1.615117770938787e-06,  -1.609743705964506e-08,   1.680180195759424e-09,
  -6.033833644869602e-11,   1.173309940285388e-12,   3.018578715356916e-15,  -1.123857854232328e-15,   1.127383917198563e+00,  -1.439119316127293e-02,   1.765434151049976e-04,
  -1.612698029207857e-06,  -1.622602062231116e-08,   1.683592303778419e-09,  -6.032087132812819e-11,   1.167426181859690e-12,   3.281075956932177e-15,  -1.128611987776347e-15,
   1.127425115341220e+00,  -1.439231033861948e-02,   1.765195758622936e-04,  -1.608722161237546e-06,  -1.643708152051352e-08,   1.689181041562745e-09,  -6.029144640106722e-11,
   1.157749874375216e-12,   3.711506168558654e-15,  -1.136358639110041e-15,   1.127468827569964e+00,  -1.439349472573228e-02,   1.764941728423748e-04,  -1.604498748837799e-06,
  -1.666099226896160e-08,   1.695093721904314e-09,  -6.025920155593816e-11,   1.147459352782277e-12,   4.167538701863977e-15,  -1.144499501180663e-15,   1.127503227738409e+00,
  -1.439442610246988e-02,   1.764741025335998e-04,  -1.601171497202175e-06,  -1.683718089201389e-08,   1.699734416906929e-09,  -6.023308485389320e-11,   1.139343945428029e-12,
   4.525936755973980e-15,  -1.150849199355599e-15,   1.127523080111687e+00,  -1.439496332056061e-02,   1.764624883031660e-04,  -1.599249912655520e-06,  -1.693885047657092e-08,
   1.702407590678160e-09,  -6.021771604211049e-11,   1.134653716460855e-12,   4.732572630062385e-15,  -1.154490787374477e-15,   1.127530534754801e+00,  -1.439516499502147e-02,
   1.764581211355071e-04,  -1.598528081235088e-06,  -1.697702606933473e-08,   1.703410436617650e-09,  -6.021188891211065e-11,   1.132891232039498e-12,   4.810127980395171e-15,
  -1.155853900652771e-15,   1.127531770462243e+00,  -1.439519842248093e-02,   1.764573969032584e-04,  -1.598408413775962e-06,  -1.698335409596837e-08,   1.703576622164968e-09,
  -6.021092002888909e-11,   1.132599008805792e-12,   4.822981855893935e-15,  -1.156079627227012e-15,   3.648821248495612e-03,  -4.446061257399616e-05,   5.380081989852046e-07,
  -6.223711240387123e-09,   5.661251636433384e-11,   9.806224492829247e-14,  -2.309474216941910e-14,   5.848123331276452e-16,  -1.819394966366993e-18,  -4.057533154365973e-19,
   3.648897907654091e-03,  -4.446326906661961e-05,   5.380562575742155e-07,  -6.223557253245415e-09,   5.656315944900146e-11,   9.977592090278184e-14,  -2.309992808018572e-14,
   5.826896271889798e-16,  -1.719739541113354e-18,  -4.074120665587096e-19,   3.649023760971444e-03,  -4.446763007844098e-05,   5.381351230509371e-07,  -6.223302709998224e-09,
   5.648212517741229e-11,   1.025845841565932e-13,  -2.310815584639029e-14,   5.791988765499011e-16,  -1.556358416351890e-18,  -4.101143912915662e-19,   3.649157307729358e-03,
  -4.447225737979202e-05,   5.382187639973687e-07,  -6.223030246286986e-09,   5.639613240588090e-11,   1.055585162325425e-13,  -2.311649814151173e-14,   5.754868280321757e-16,
  -1.383298190605591e-18,  -4.129535234115086e-19,   3.649262414551319e-03,  -4.447589903991063e-05,   5.382845598712764e-07,  -6.222814099381342e-09,   5.632844920985176e-11,
   1.078944664249531e-13,  -2.312278292579273e-14,   5.725596004705862e-16,  -1.247317192610728e-18,  -4.151674893792954e-19,   3.649323075685937e-03,  -4.447800069291398e-05,
   5.383225199345768e-07,  -6.222688669381652e-09,   5.628938539754969e-11,   1.092407633093469e-13,  -2.312629759260324e-14,   5.708679158253752e-16,  -1.168927823536151e-18,
  -4.164370177425962e-19,   3.649345854910379e-03,  -4.447878988067680e-05,   5.383367720434531e-07,  -6.222641439325618e-09,   5.627471607937538e-11,   1.097459658970929e-13,
  -2.312759615014345e-14,   5.702322333870807e-16,  -1.139508503772866e-18,  -4.169121895165364e-19,   3.649349630912152e-03,  -4.447892069964202e-05,   5.383391344146222e-07,
  -6.222633603419915e-09,   5.627228440539539e-11,   1.098296922371301e-13,  -2.312781028467998e-14,   5.701268368474858e-16,  -1.134632710923708e-18,  -4.169908743393540e-19,
   3.304048042599456e-02,  -4.025916018138941e-04,   4.871102696087772e-06,  -5.629909005783811e-08,   5.088907815310665e-10,   1.068619114229897e-12,  -2.155701648855583e-13,
   5.453758593069200e-15,  -1.824890516512482e-17,  -3.723125078045321e-18,   3.304117448818913e-02,  -4.026156312612483e-04,   4.871534598572307e-06,  -5.629743465041039e-08,
   5.084300138274185e-10,   1.084605188102448e-12,  -2.156237753364118e-13,   5.434271330634278e-15,  -1.732639199470963e-17,  -3.738706558825871e-18,   3.304231394764910e-02,
  -4.026550789470135e-04,   4.872243351882574e-06,  -5.629470071880375e-08,   5.076735164856746e-10,   1.110806558461289e-12,  -2.157091401585502e-13,   5.402223587032171e-15,
  -1.581392386090917e-17,  -3.764094241286725e-18,   3.304352306204580e-02,  -4.026969352526068e-04,   4.872995007221187e-06,  -5.629177766014700e-08,   5.068707179192834e-10,
   1.138550604946380e-12,  -2.157961266838874e-13,   5.368142397595206e-15,  -1.421179322807603e-17,  -3.790771828508259e-18,   3.304447468474640e-02,  -4.027298758487431e-04,
   4.873586283924233e-06,  -5.628946118225411e-08,   5.062388431717683e-10,   1.160343536401976e-12,  -2.158619872352036e-13,   5.341265561619795e-15,  -1.295288551536281e-17,
  -3.811578489839184e-18,   3.304502390217488e-02,  -4.027488862952290e-04,   4.873927409029321e-06,  -5.628811788403451e-08,   5.058741491949733e-10,   1.172903899377030e-12,
  -2.158989559498910e-13,   5.325732563981552e-15,  -1.222714182087155e-17,  -3.823510771309550e-18,   3.304523014206129e-02,  -4.027560248660739e-04,   4.874055483682820e-06,
  -5.628761225071252e-08,   5.057371980014834e-10,   1.177617270016161e-12,  -2.159126414663423e-13,   5.319895651025611e-15,  -1.195476886651870e-17,  -3.827977163936029e-18,
   3.304526432944759e-02,  -4.027572081842143e-04,   4.874076712770639e-06,  -5.628752837085883e-08,   5.057144961198980e-10,   1.178398411355911e-12,  -2.159148996672942e-13,
   5.318927882210940e-15,  -1.190962712884110e-17,  -3.828716778197930e-18,   9.294336409428774e-02,  -1.132471165137939e-03,   1.369875021707099e-05,  -1.580248937720957e-07,
   1.408910566857890e-09,   4.101230359798374e-12,  -6.456590593292507e-13,   1.631319314288346e-14,  -6.254806355167214e-17,  -1.076177535963815e-17,   9.294531593038505e-02,
  -1.132538607324671e-03,   1.369994538468143e-05,  -1.580186542719977e-07,   1.407530125286534e-09,   4.149077962263311e-12,  -6.458519990365822e-13,   1.625680313602679e-14,
  -5.983019571153165e-17,  -1.080911651914314e-17,   9.294852030699914e-02,  -1.132649322573114e-03,   1.370190659320931e-05,  -1.580083622855312e-07,   1.405263639200985e-09,
   4.227504938187429e-12,  -6.461609453776234e-13,   1.616405875262380e-14,  -5.537394478706611e-17,  -1.088627324517230e-17,   9.295192056371337e-02,  -1.132766797261102e-03,
   1.370398642830000e-05,  -1.579973753879986e-07,   1.402858364856832e-09,   4.310555187813702e-12,  -6.464781756383303e-13,   1.606541844886964e-14,  -5.065313222910151e-17,
  -1.096737942379622e-17,   9.295459670338349e-02,  -1.132859248462243e-03,   1.370562243042885e-05,  -1.579886806903476e-07,   1.400965147681013e-09,   4.375795222391043e-12,
  -6.467201802483072e-13,   1.598762140799026e-14,  -4.694337627272357e-17,  -1.103065792319603e-17,   9.295614120391461e-02,  -1.132912603056219e-03,   1.370656626290913e-05,
  -1.579836436069731e-07,   1.399872435061122e-09,   4.413397988703229e-12,  -6.468567787589503e-13,   1.594265672663768e-14,  -4.480463927816267e-17,  -1.106695571778007e-17,
   9.295672118829294e-02,  -1.132932638084968e-03,   1.370692061781685e-05,  -1.579817485045923e-07,   1.399462091913992e-09,   4.427509021963607e-12,  -6.469074934259109e-13,
   1.592575950991853e-14,  -4.400194622775724e-17,  -1.108054404163657e-17,   9.295681732948390e-02,  -1.132935959169743e-03,   1.370697935386109e-05,  -1.579814341729330e-07,
   1.399394070682615e-09,   4.429847643305430e-12,  -6.469158695470514e-13,   1.592295789413615e-14,  -4.386891076456526e-17,  -1.108279429257685e-17,   1.858497910685692e-01,
  -2.264408167105241e-03,   2.737945932638412e-05,  -3.148175395703403e-07,   2.740318906571192e-09,   1.195164902135322e-11,  -1.426685584586928e-12,   3.602714266439362e-14,
  -1.664199580124660e-16,  -2.245199046520512e-17,   1.858536920369606e-01,  -2.264542506238194e-03,   2.738178183828875e-05,  -3.147996401626336e-07,   2.737267228050432e-09,
   1.205742512936018e-11,  -1.427227311690660e-12,   3.590926746860845e-14,  -1.605597833210086e-16,  -2.255935755604291e-17,   1.858600963442163e-01,  -2.264763039942021e-03,
   2.738559273234979e-05,  -3.147701473788820e-07,   2.732256632433372e-09,   1.223081729087044e-11,  -1.428099830105212e-12,   3.571536771303536e-14,  -1.509503027756639e-16,
  -2.273442272067808e-17,   1.858668921302719e-01,  -2.264997035449223e-03,   2.738963382323949e-05,  -3.147387066077229e-07,   2.726938968957460e-09,   1.241445079946557e-11,
  -1.429002805133204e-12,   3.550909945227763e-14,  -1.407688769182145e-16,  -2.291855557820265e-17,   1.858722406820032e-01,  -2.265181185483667e-03,   2.739281232768613e-05,
  -3.147138564927248e-07,   2.722753202165139e-09,   1.255871831188651e-11,  -1.429696932360587e-12,   3.534638658373482e-14,  -1.327669632394780e-16,  -2.306229246534764e-17,
   1.858753275289241e-01,  -2.265287459796317e-03,   2.739464596099243e-05,  -3.146994725278838e-07,   2.720337222262239e-09,   1.264187637320004e-11,  -1.430090909775151e-12,
   3.525233064730305e-14,  -1.281533064421835e-16,  -2.314477410677607e-17,   1.858764866882373e-01,  -2.265327366427293e-03,   2.739533436794620e-05,  -3.146940631818455e-07,
   2.719429943022880e-09,   1.267308384593470e-11,  -1.430237602082503e-12,   3.521698321227491e-14,  -1.264216679393109e-16,  -2.317565761388176e-17,   1.858766788364138e-01,
  -2.265333981499883e-03,   2.739544847383577e-05,  -3.146931660821084e-07,   2.719279545624095e-09,   1.267825591768639e-11,  -1.430261852495678e-12,   3.521112236751978e-14,
  -1.261346682229477e-16,  -2.318077229296458e-17,   3.162870692237407e-01,  -3.853438438665848e-03,   4.656125870747311e-05,  -5.325678177649230e-07,   4.451236754791252e-09,
   3.079729850482896e-11,  -2.811503930175523e-12,   7.118027388249858e-14,  -4.124439059371207e-16,  -4.053320502471859e-17,   3.162937028067283e-01,  -3.853665642187984e-03,
   4.656502526546814e-05,  -5.325222270158050e-07,   4.445218851700595e-09,   3.100659334470143e-11,  -2.812915734592867e-12,   7.096673479464221e-14,  -4.012655295721430e-16,
  -4.075450304355534e-17,   3.163045932890577e-01,  -3.854038619072008e-03,   4.657120496122255e-05,  -5.324471685782613e-07,   4.435337434471920e-09,   3.134971967485966e-11,
  -2.815201346991530e-12,   7.061537317876515e-14,  -3.829318910520983e-16,  -4.111557489690666e-17,   3.163161494518893e-01,  -3.854434356674619e-03,   4.657775704126955e-05,
  -5.323672354060249e-07,   4.424849720747580e-09,   3.171317028728411e-11,  -2.817582969485953e-12,   7.024146501609801e-14,  -3.635024363076315e-16,  -4.149567506557076e-17,
   3.163252445886526e-01,  -3.854745789957770e-03,   4.658290990240269e-05,  -5.323041175520351e-07,   4.416593853319120e-09,   3.199874882472051e-11,  -2.819425781656557e-12,
   6.994641435163193e-14,  -3.482288541689668e-16,  -4.179262460006894e-17,   3.163304937205513e-01,  -3.854925518458180e-03,   4.658588225193085e-05,  -5.322676068833280e-07,
   4.411828443461415e-09,   3.216337754972851e-11,  -2.820476670295483e-12,   6.977582216005653e-14,  -3.394212384952936e-16,  -4.196312123933241e-17,   3.163324648502391e-01,
  -3.854993007211802e-03,   4.658699812136315e-05,  -5.322538808725895e-07,   4.410038836693852e-09,   3.222516242230759e-11,  -2.820868902298219e-12,   6.971170413485648e-14,
  -3.361152331968406e-16,  -4.202697828842045e-17,   3.163327915947005e-01,  -3.855004194381442e-03,   4.658718307806075e-05,  -5.322516047516857e-07,   4.409742175969870e-09,
   3.223540231008212e-11,  -2.820933794456774e-12,   6.970107254736268e-14,  -3.355672864428746e-16,  -4.203755474298364e-17,   4.924113633265321e-01,  -5.998648139937503e-03,
   7.240146502275395e-05,  -8.208749693337915e-07,   6.375541579811801e-09,   7.569676038194159e-11,  -5.418182345686159e-12,   1.386383581823163e-13,  -1.049065715012551e-15,
  -6.789430089889119e-17,   4.924216774005289e-01,  -5.998998196132400e-03,   7.240684294173117e-05,  -8.207638033335609e-07,   6.363931919652526e-09,   7.610529576151208e-11,
  -5.421934229508457e-12,   1.382782591777238e-13,  -1.028409397990469e-15,  -6.835508319816920e-17,   4.924386101653292e-01,  -5.999572834940113e-03,   7.241566448787719e-05,
  -8.205808885598187e-07,   6.344867222198680e-09,   7.677518699691848e-11,  -5.428034186022036e-12,   1.376854215861624e-13,  -9.945198656943755e-16,  -6.910763591393744e-17,
   4.924565778752640e-01,  -6.000182523370333e-03,   7.242501507254892e-05,  -8.203862344775710e-07,   6.324630596469374e-09,   7.748492356250307e-11,  -5.434426059884304e-12,
   1.370541041172680e-13,  -9.585896035698740e-16,  -6.990085200293707e-17,   4.924707190912728e-01,  -6.000662316736510e-03,   7.243236696565212e-05,  -8.202326302517631e-07,
   6.308698868901864e-09,   7.804271385606477e-11,  -5.439398131831030e-12,   1.365556159555397e-13,  -9.303337176124821e-16,  -7.052127524305798e-17,   4.924788804774549e-01,
  -6.000939200969869e-03,   7.243660705399169e-05,  -8.201438178405263e-07,   6.299502207061574e-09,   7.836431393099021e-11,  -5.442244224781470e-12,   1.362672741568641e-13,
  -9.140353820401105e-16,  -7.087779217429954e-17,   4.924819451995394e-01,  -6.001043171123347e-03,   7.243819871381760e-05,  -8.201104368357776e-07,   6.296048364199857e-09,
   7.848501899923557e-11,  -5.443308541693933e-12,   1.361588754757054e-13,  -9.079168494612018e-16,  -7.101137631203821e-17,   4.924824532232245e-01,  -6.001060405525724e-03,
   7.243846252596460e-05,  -8.201049018181530e-07,   6.295475818985908e-09,   7.850502448028617e-11,  -5.443484734346006e-12,   1.361409003351744e-13,  -9.069027026874110e-16,
  -7.103350441224386e-17,   7.304469442247082e-01,  -8.896912795431386e-03,   1.071651999077030e-04,  -1.195034968790807e-06,   7.901662093890823e-09,   1.924069551205894e-10,
  -1.116336193812517e-11,   2.946959240105161e-13,  -3.091553746542196e-15,  -1.058238391456483e-16,   7.304622079118458e-01,  -8.897421987431374e-03,   1.071718108492556e-04,
  -1.194753809972552e-06,   7.877697397101282e-09,   1.932784535618335e-10,  -1.117485005702281e-11,   2.941246885236952e-13,  -3.051536116592161e-15,  -1.069135450403494e-16,
   7.304872663834575e-01,  -8.898257820056635e-03,   1.071826489479834e-04,  -1.194291349714516e-06,   7.838338185492839e-09,   1.947079066522742e-10,  -1.119359438999886e-11,
   2.931829266553408e-13,  -2.985836451976857e-15,  -1.086960328656291e-16,   7.305138562533071e-01,  -8.899144582712947e-03,   1.071941288451022e-04,  -1.193799431293536e-06,
   7.796551627928209e-09,   1.962229597202366e-10,  -1.121332690547483e-11,   2.921782398983363e-13,  -2.916119094461028e-15,  -1.105786157556956e-16,   7.305347832677908e-01,
  -8.899842382322852e-03,   1.072031489812190e-04,  -1.193411411703095e-06,   7.763648527722951e-09,   1.974140747498530e-10,  -1.122874306236523e-11,   2.913836434159184e-13,
  -2.861248252429236e-15,  -1.120538490910662e-16,   7.305468609162750e-01,  -8.900245061105790e-03,   1.072083488229870e-04,  -1.193187126567162e-06,   7.744652772186615e-09,
   1.981009923841592e-10,  -1.123759455628625e-11,   2.909235052629534e-13,  -2.829580264398648e-15,  -1.129026766168201e-16,   7.305513962423474e-01,  -8.900396264369791e-03,
   1.072103003084153e-04,  -1.193102838864130e-06,   7.737518407487821e-09,   1.983588424888657e-10,  -1.124090978558034e-11,   2.907504241761718e-13,  -2.817688465786187e-15,
  -1.132209355793049e-16,   7.305521480401443e-01,  -8.900421328125574e-03,   1.072106237366620e-04,  -1.193088863468298e-06,   7.736335717515407e-09,   1.984015798564027e-10,
  -1.124145887887941e-11,   2.907217179752489e-13,  -2.815717222443025e-15,  -1.132736659979135e-16,   1.072495558064062e+00,  -1.305785564773481e-02,   1.565153233696835e-04,
  -1.671540952899060e-06,   5.620733045747069e-09,   6.097961601830431e-10,  -3.027695717189035e-11,   8.835356078686232e-13,  -1.482855673763364e-14,  -5.641528582452691e-17,
   1.072517840243854e+00,  -1.305856611663133e-02,   1.565197522466355e-04,  -1.670650935763918e-06,   5.555426183789931e-09,   6.124301243778883e-10,  -3.033420370359101e-11,
   8.831453166330869e-13,  -1.474026426448200e-14,  -6.018856600522362e-17,   1.072554420445086e+00,  -1.305973218649856e-02,   1.565269824472491e-04,  -1.669187122120696e-06,
   5.448127058104256e-09,   6.167532940414398e-10,  -3.042792676917480e-11,   8.824906296449065e-13,  -1.459495161103708e-14,  -6.638156275821450e-17,   1.072593235403105e+00,
  -1.306096909601233e-02,   1.565345991526331e-04,  -1.667630224915808e-06,   5.334155905071467e-09,   6.213392594407764e-10,  -3.052702516704436e-11,   8.817769856182585e-13,
  -1.444026740460165e-14,  -7.295074535981597e-17,   1.072623783366261e+00,  -1.306194227427506e-02,   1.565405536255842e-04,  -1.666402276238392e-06,   5.244374392090959e-09,
   6.249475190113033e-10,  -3.060476297747873e-11,   8.812016115241230e-13,  -1.431817203582266e-14,  -7.811916004502259e-17,   1.072641413347770e+00,  -1.306250380371778e-02,
   1.565439740612123e-04,  -1.665692535967345e-06,   5.192525462551003e-09,   6.270295433876603e-10,  -3.064952536520190e-11,   8.808640481304225e-13,  -1.424756527286833e-14,
  -8.110130191175017e-17,   1.072648033610291e+00,  -1.306271464265792e-02,   1.565452554423860e-04,  -1.665425819766278e-06,   5.173049204652580e-09,   6.278112932757983e-10,
  -3.066631486154552e-11,   8.807362495632014e-13,  -1.422102472440176e-14,  -8.222099995004982e-17,   1.072649131015101e+00,  -1.306274959112464e-02,   1.565454676899780e-04,
  -1.665381597099571e-06,   5.169820395008636e-09,   6.279408757532067e-10,  -3.066909694623317e-11,   8.807150102512471e-13,  -1.421662382503069e-14,  -8.240659921803794e-17,
   3.479135649150980e-03,  -4.043990644262790e-05,   4.687402628576684e-07,  -5.327021813918986e-09,   5.428025313652969e-11,  -2.759662490796583e-13,  -8.986836976989771e-15,
   3.931995082225445e-16,  -7.715434631103340e-18,   6.899143947733964e-21,   3.479202447311086e-03,  -4.044218201606919e-05,   4.687864988487054e-07,  -5.327404614726504e-09,
   5.426071405384444e-11,  -2.747913484663354e-13,  -9.016866879623702e-15,   3.931946854262172e-16,  -7.681197801645703e-18,   5.401658421232610e-21,   3.479312112042741e-03,
  -4.044591785406508e-05,   4.688623905421448e-07,  -5.328031835862290e-09,   5.422859153583108e-11,  -2.728625954557254e-13,  -9.066066468271794e-15,   3.931812345450037e-16,
  -7.624860713767943e-18,   2.944806963894178e-21,   3.479428481242240e-03,  -4.044988202425948e-05,   4.689429009409484e-07,  -5.328695723757649e-09,   5.419444469392292e-11,
  -2.708160955889715e-13,  -9.118135793868168e-15,   3.931594448545158e-16,  -7.564904241244772e-18,   3.399855515896654e-22,   3.479520069078547e-03,  -4.045300196079913e-05,
   4.690062510506710e-07,  -5.329217018044230e-09,   5.416752586053359e-11,  -2.692055352383235e-13,  -9.159016547093031e-15,   3.931368560897738e-16,  -7.517589475805553e-18,
  -1.708486554486280e-21,   3.479572928079546e-03,  -4.045480258273534e-05,   4.690428068247179e-07,  -5.329517390579607e-09,   5.415197242326766e-11,  -2.682760694185024e-13,
  -9.182570260881662e-15,   3.931216398306216e-16,  -7.490231775359305e-18,  -2.890076135895458e-21,   3.479592777513422e-03,  -4.045547874278090e-05,   4.690565329711898e-07,
  -5.329630093373984e-09,   5.414612854348198e-11,  -2.679270497523252e-13,  -9.191407467292630e-15,   3.931155140626359e-16,  -7.479948987106960e-18,  -3.333655929419419e-21,
   3.479596067859849e-03,  -4.045559082644057e-05,   4.690588082284124e-07,  -5.329648770723285e-09,   5.414515965696059e-11,  -2.678691949623653e-13,  -9.192871967715098e-15,
   3.931144769012295e-16,  -7.478243956554739e-18,  -3.407179336710266e-21,   3.150396848942953e-02,  -3.661866717475756e-04,   4.244298118486383e-06,  -4.821745912996088e-08,
   4.901596643927377e-10,  -2.427094310012865e-12,  -8.431405981518054e-14,   3.651910120411786e-15,  -7.186289798487181e-17,   8.210660055226073e-20,   3.150457332375223e-02,
  -3.662072687021077e-04,   4.244715598267098e-06,  -4.822082092081510e-08,   4.899763724701280e-10,  -2.416180705149414e-12,  -8.459386291587146e-14,   3.651959427459675e-15,
  -7.154880308946675e-17,   6.826374517706374e-20,   3.150556629998322e-02,  -3.662410829531949e-04,   4.245400844746459e-06,  -4.822632861969152e-08,   4.896750409079323e-10,
  -2.398264391066932e-12,  -8.505229334299379e-14,   3.651989215540214e-15,  -7.103193358893667e-17,   4.555171065796910e-20,   3.150661998268072e-02,  -3.662769638671934e-04,
   4.246127788947227e-06,  -4.823215745850153e-08,   4.893547236363643e-10,  -2.379254040555228e-12,  -8.553748252258804e-14,   3.651951323843648e-15,  -7.048182679496530e-17,
   2.147078646704822e-20,   3.150744927861410e-02,  -3.663052033328745e-04,   4.246699785317383e-06,  -4.823673374012032e-08,   4.891022120696092e-10,  -2.364293018651774e-12,
  -8.591842897294698e-14,   3.651871205920529e-15,  -7.004768663405402e-17,   2.532448094821925e-21,   3.150792789839331e-02,  -3.663215012802138e-04,   4.247029850460676e-06,
  -4.823937037434070e-08,   4.889563144745669e-10,  -2.355658825746345e-12,  -8.613791936397445e-14,   3.651804814220968e-15,  -6.979665508739868e-17,  -8.391761359688761e-21,
   3.150810762806999e-02,  -3.663276213969544e-04,   4.247153784666456e-06,  -4.824035961989331e-08,   4.889014967031694e-10,  -2.352416622236666e-12,  -8.622027184846327e-14,
   3.651776075037597e-15,  -6.970229955839465e-17,  -1.249286678851443e-20,   3.150813742100481e-02,  -3.663286358978850e-04,   4.247174328084523e-06,  -4.824052355735791e-08,
   4.888924081972931e-10,  -2.351879181791442e-12,  -8.623391934486667e-14,   3.651771110216212e-15,  -6.968665399921695e-17,  -1.317262843226880e-20,   8.862119280090244e-02,
  -1.030081628969548e-03,   1.193809311891007e-05,  -1.355203728065493e-07,   1.370671379528848e-09,  -6.393764515879695e-12,  -2.549788770974683e-13,   1.082994028822855e-14,
  -2.144398563792326e-16,   3.561162352372451e-19,   8.862289402639101e-02,  -1.030139516728553e-03,   1.193926031375452e-05,  -1.355291982609889e-07,   1.370117200973188e-09,
  -6.361390212484541e-12,  -2.558144303433443e-13,   1.083067393782828e-14,  -2.135323537114791e-16,   3.154582756202224e-19,   8.862568698299066e-02,  -1.030234551515690e-03,
   1.194117610790748e-05,  -1.355436533710868e-07,   1.369206148128862e-09,  -6.308241677501692e-12,  -2.571834914071859e-13,   1.083172805222385e-14,  -2.120388370903606e-16,
   2.487458998565985e-19,   8.862865068838817e-02,  -1.030335394382728e-03,   1.194320844415098e-05,  -1.355589461001398e-07,   1.368237714541537e-09,  -6.251845960862127e-12,
  -2.586325842637867e-13,   1.083264236509290e-14,  -2.104490835077100e-16,   1.780063066429265e-19,   8.863098325781191e-02,  -1.030414760860462e-03,   1.194480756324491e-05,
  -1.355709487887017e-07,   1.367474296994749e-09,  -6.207461641690524e-12,  -2.597704265048488e-13,   1.083321415747255e-14,  -2.091943201536162e-16,   1.223688575382765e-19,
   8.863232947641456e-02,  -1.030460565852089e-03,   1.194573030966039e-05,  -1.355778626392921e-07,   1.367033211225616e-09,  -6.181846391169709e-12,  -2.604260532270411e-13,
   1.083348493321407e-14,  -2.084687254976365e-16,   9.027364017087831e-20,   8.863283500380273e-02,  -1.030477766279337e-03,   1.194607678430512e-05,  -1.355804563761564e-07,
   1.366867484210614e-09,  -6.172227579068297e-12,  -2.606720500223462e-13,   1.083357542192658e-14,  -2.081959846757059e-16,   7.822428501943159e-20,   8.863291880267368e-02,
  -1.030480617506767e-03,   1.194613421607493e-05,  -1.355808861941899e-07,   1.366840007579800e-09,  -6.170633121788975e-12,  -2.607128170858953e-13,   1.083358983144619e-14,
  -2.081507596013674e-16,   7.622707596212557e-20,   1.772073666174059e-01,  -2.059730655489107e-03,   2.386747599800082e-05,  -2.705957397720019e-07,   2.713200925569073e-09,
  -1.131001144616511e-11,  -5.707948685896422e-13,   2.358020685959835e-14,  -4.719596946227342e-16,   1.179801303418634e-18,   1.772107677790120e-01,  -2.059846233413861e-03,
   2.386978561072951e-05,  -2.706112392808582e-07,   2.711960687288311e-09,  -1.123948859877364e-11,  -5.726360248243071e-13,   2.358391150981278e-14,  -4.700680564039825e-16,
   1.092611121953128e-18,   1.772163515728308e-01,  -2.060035977931494e-03,   2.387357644161346e-05,  -2.706366116757961e-07,   2.709921815812512e-09,  -1.112370744857889e-11,
  -5.756530855562215e-13,   2.358967086799391e-14,  -4.669543685702316e-16,   9.495304688009086e-19,   1.772222767311664e-01,  -2.060237317836499e-03,   2.387759775574860e-05,
  -2.706634351333153e-07,   2.707754588171345e-09,  -1.100084627094962e-11,  -5.788469387801116e-13,   2.359534391128583e-14,  -4.636393182809063e-16,   7.977889824336866e-19,
   1.772269400946825e-01,  -2.060395777956598e-03,   2.388076178983126e-05,  -2.706844739334607e-07,   2.706046201148664e-09,  -1.090414807591272e-11,  -5.813550911628898e-13,
   2.359949154074614e-14,  -4.610222849161162e-16,   6.784256625686379e-19,   1.772296315062522e-01,  -2.060487230213967e-03,   2.388258751037092e-05,  -2.706965872143007e-07,
   2.705059149461439e-09,  -1.084833942945801e-11,  -5.828004162490700e-13,   2.360175814776698e-14,  -4.595087176847832e-16,   6.095624930928712e-19,   1.772306421756923e-01,
  -2.060521571790280e-03,   2.388327302883541e-05,  -2.707011304617454e-07,   2.704688292434202e-09,  -1.082738231854713e-11,  -5.833427379978430e-13,   2.360258526739873e-14,
  -4.589397494802658e-16,   5.837082313061215e-19,   1.772308097095486e-01,  -2.060527264416264e-03,   2.388338666028582e-05,  -2.707018832846387e-07,   2.704626806535405e-09,
  -1.082390835613739e-11,  -5.834326138356767e-13,   2.360272110757542e-14,  -4.588454027739016e-16,   5.794227583951917e-19,   3.015795653600039e-01,  -3.505274686583663e-03,
   4.060797193915570e-05,  -4.594488831100336e-07,   4.541985037212773e-09,  -1.518224067882442e-11,  -1.141142110704883e-12,   4.557147933424696e-14,  -9.285068780470825e-16,
   3.495310142021189e-18,   3.015853519430223e-01,  -3.505470907469203e-03,   4.061183601981368e-05,  -4.594693367945326e-07,   4.539506142313806e-09,  -1.504584585309337e-11,
  -1.144770771692983e-12,   4.558496329290531e-14,  -9.250976696372952e-16,   3.330535141070069e-18,   3.015948519510211e-01,  -3.505793041860571e-03,   4.061817799031084e-05,
  -4.595027744555461e-07,   4.535431074560523e-09,  -1.482190542015449e-11,  -1.150717892543618e-12,   4.560648965564479e-14,  -9.194843301696192e-16,   3.060082275760945e-18,
   3.016049327311733e-01,  -3.506134859548642e-03,   4.062490521188586e-05,  -4.595380636067184e-07,   4.531099563840753e-09,  -1.458425235613649e-11,  -1.157014748206708e-12,
   4.562850222508967e-14,  -9.135056846891124e-16,   2.773185042028203e-18,   3.016128667471792e-01,  -3.506403877785247e-03,   4.063019804921465e-05,  -4.595656982053135e-07,
   4.527685183190540e-09,  -1.439719340395130e-11,  -1.161960612513840e-12,   4.564522642632876e-14,  -9.087842494508589e-16,   2.547451878071010e-18,   3.016174457788918e-01,
  -3.506559135836972e-03,   4.063325203879995e-05,  -4.595815912922477e-07,   4.525712491323541e-09,  -1.428922829387882e-11,  -1.164811034822843e-12,   4.565463789073557e-14,
  -9.060529358703953e-16,   2.417200402048582e-18,   3.016191652803031e-01,  -3.506617437225904e-03,   4.063439872684056e-05,  -4.595875488365756e-07,   4.524971312990296e-09,
  -1.424868450445111e-11,  -1.165880652626953e-12,   4.565812655526798e-14,  -9.050260774815647e-16,   2.368294236801171e-18,   3.016194503138293e-01,  -3.506627101539177e-03,
   4.063458880070655e-05,  -4.595885358325870e-07,   4.524848430295450e-09,  -1.424196369570667e-11,  -1.166057917813323e-12,   4.565870245460604e-14,  -9.048557965364416e-16,
   2.360187583046994e-18,   4.695153573608470e-01,  -5.457028915856517e-03,   6.319348539644494e-05,  -7.125897454814323e-07,   6.877184262028129e-09,  -1.304711456405538e-11,
  -2.226172395428955e-12,   8.570909346778845e-14,  -1.799739536317655e-15,   1.021877305376614e-17,   4.695243620108748e-01,  -5.457333193623722e-03,   6.319933000014875e-05,
  -7.126061434590797e-07,   6.872348648601246e-09,  -1.279028500457226e-11,  -2.233224887667365e-12,   8.575340467987255e-14,  -1.794048000221460e-15,   9.919386807965433e-18,
   4.695391451983965e-01,  -5.457832719389543e-03,   6.320892185253584e-05,  -7.126327989464096e-07,   6.864399388953284e-09,  -1.236856723107003e-11,  -2.244786113910897e-12,
   8.582503955910421e-14,  -1.784671336193173e-15,   9.427819261227819e-18,   4.695548321144314e-01,  -5.458362760997817e-03,   6.321909545413442e-05,  -7.126607230238793e-07,
   6.855949922155905e-09,  -1.192097041606030e-11,  -2.257030881309985e-12,   8.589954214861460e-14,  -1.774677109409570e-15,   8.906130527769724e-18,   4.695671783872188e-01,
  -5.458779910956518e-03,   6.322709916421896e-05,  -7.126824391262938e-07,   6.849289524049951e-09,  -1.156862231632519e-11,  -2.266651183059683e-12,   8.595708447166180e-14,
  -1.766779202633390e-15,   8.495493205964470e-18,   4.695743038980993e-01,  -5.459020658118124e-03,   6.323171707122113e-05,  -7.126948675627508e-07,   6.845441423374540e-09,
  -1.136524078261821e-11,  -2.272196662171098e-12,   8.598985567180727e-14,  -1.762208207012363e-15,   8.258481781397288e-18,   4.695769796427841e-01,  -5.459111061403182e-03,
   6.323345091607351e-05,  -7.126995148393443e-07,   6.843995619562826e-09,  -1.128886250349199e-11,  -2.274277798465283e-12,   8.600207886902628e-14,  -1.760489306556247e-15,
   8.169477185460718e-18,   4.695774231881127e-01,  -5.459126047059169e-03,   6.323373831379542e-05,  -7.127002841513482e-07,   6.843755914495773e-09,  -1.127620136903450e-11,
  -2.274622710810526e-12,   8.600410067529537e-14,  -1.760204245236474e-15,   8.154723169852174e-18,   6.964864301502077e-01,  -8.094592739900625e-03,   9.367028701469013e-05,
  -1.049806485030367e-06,   9.671553909780356e-09,   1.022920119503166e-11,  -4.594907144991810e-12,   1.713346675072194e-13,  -3.804451427279555e-15,   3.348948399621850e-17,
   6.964997766117594e-01,  -8.095040857775435e-03,   9.367848834653408e-05,  -1.049787582006352e-06,   9.661567959081756e-09,   1.074369788143834e-11,  -4.609881968739504e-12,
   1.714911929587886e-13,  -3.795633706975528e-15,   3.292994909574938e-17,   6.965216878234790e-01,  -8.095776508959962e-03,   9.369194594132724e-05,  -1.049756019421107e-06,
   9.645151399391149e-09,   1.158865576406095e-11,  -4.634439753742909e-12,   1.717460769753682e-13,  -3.781085274550171e-15,   3.201058762882366e-17,   6.965449384472687e-01,
  -8.096557082353177e-03,   9.370621702999604e-05,  -1.049721808293493e-06,   9.627700916376940e-09,   1.248566511131162e-11,  -4.660462266789102e-12,   1.720137030822914e-13,
  -3.765549582458069e-15,   3.103400635448386e-17,   6.965632376316501e-01,  -8.097171390860749e-03,   9.371744232075519e-05,  -1.049694361945768e-06,   9.613944690139600e-09,
   1.319193551350018e-11,  -4.680916549340846e-12,   1.722222792495709e-13,  -3.753251580486649e-15,   3.026466808070171e-17,   6.965737987779066e-01,  -8.097525917542007e-03,
   9.372391819593564e-05,  -1.049678312827570e-06,   9.605996647757141e-09,   1.359966533870502e-11,  -4.692710835700390e-12,   1.723418317027129e-13,  -3.746125608869843e-15,
   2.982036488367291e-17,   6.965777646555414e-01,  -8.097659045309701e-03,   9.372634948632853e-05,  -1.049672246659773e-06,   9.603010367960147e-09,   1.375279593980732e-11,
  -4.697137760951132e-12,   1.723865696258676e-13,  -3.743444343241394e-15,   2.965346770573554e-17,   6.965784220598069e-01,  -8.097681113114914e-03,   9.372675248296844e-05,
  -1.049671239018301e-06,   9.602515259100702e-09,   1.377818079292594e-11,  -4.697871484402012e-12,   1.723939773877352e-13,  -3.742999600722665e-15,   2.962579911631109e-17,
   1.022644447073259e+00,  -1.188372995519755e-02,   1.372916646594102e-04,  -1.516071632728145e-06,   1.227943444293483e-08,   1.273057194044917e-10,  -1.195707123671917e-11,
   4.452940070857092e-13,  -1.126709755951921e-14,   1.712902692592314e-16,   1.022664005469993e+00,  -1.188437651713510e-02,   1.373020014900177e-04,  -1.515879105703109e-06,
   1.225337895659053e-08,   1.286499519430683e-10,  -1.200185426569132e-11,   4.461420381982781e-13,  -1.126190506602367e-14,   1.701971948923851e-16,   1.022696114783848e+00,
  -1.188543789114824e-02,   1.373189548217429e-04,  -1.515561653189683e-06,   1.221053562568398e-08,   1.308585396847424e-10,  -1.207535669290500e-11,   4.475301262316334e-13,
  -1.125317003759975e-14,   1.683967984260953e-16,   1.022730186660517e+00,  -1.188656400644722e-02,   1.373369215103429e-04,  -1.515222923777472e-06,   1.216498173242946e-08,
   1.332044804098599e-10,  -1.215332614910062e-11,   4.489974211281954e-13,  -1.124361500346317e-14,   1.664783820001179e-16,   1.022757002428841e+00,  -1.188745020369563e-02,
   1.373510453644745e-04,  -1.514954974361188e-06,   1.212906267091104e-08,   1.350525242198412e-10,  -1.221467211283091e-11,   4.501481449093249e-13,  -1.123588761798447e-14,
   1.649627557106051e-16,   1.022772478742673e+00,  -1.188796162077960e-02,   1.373591900875286e-04,  -1.514799787053776e-06,   1.210830586096660e-08,   1.361197771346306e-10,
  -1.225006940458743e-11,   4.508106255615803e-13,  -1.123134477648483e-14,   1.640857277530016e-16,   1.022778290329795e+00,  -1.188815365830858e-02,   1.373622472960910e-04,
  -1.514741408980865e-06,   1.210050632855386e-08,   1.365206753944890e-10,  -1.226336016987507e-11,   4.510590862094180e-13,  -1.122962316197901e-14,   1.637559549900496e-16,
   1.022779253687628e+00,  -1.188818549103116e-02,   1.373627540080068e-04,  -1.514731726508491e-06,   1.209921317306441e-08,   1.365871370942143e-10,  -1.226556323722636e-11,
   4.511002558911790e-13,  -1.122933694969246e-14,   1.637012672303871e-16,   3.324491228887524e-03,  -3.693139617254550e-05,   4.098158560100618e-07,  -4.511155834885288e-09,
   4.735667984343335e-11,  -3.861348822752135e-13,  -1.193615682594594e-15,   1.764968515566619e-16,  -5.356322291763399e-18,   9.025811475059487e-20,   3.324549629976051e-03,
  -3.693332400884647e-05,   4.098562752324587e-07,  -4.511700812832676e-09,   4.735387858256948e-11,  -3.856002589029383e-13,  -1.214945934638674e-15,   1.769471111955229e-16,
  -5.355799445603763e-18,   8.980818183510223e-20,   3.324645508972277e-03,  -3.693648903133648e-05,   4.099226281201612e-07,  -4.512594929485831e-09,   4.734924695745742e-11,
  -3.847216234774477e-13,  -1.249960987199831e-15,   1.776846020726624e-16,  -5.354853433137300e-18,   8.906726832712638e-20,   3.324747249648590e-03,  -3.693984759197456e-05,
   4.099930311950932e-07,  -4.513542904454252e-09,   4.734428773049465e-11,  -3.837880143651626e-13,  -1.287111796139620e-15,   1.784648446932587e-16,  -5.353730468809295e-18,
   8.827801592277476e-20,   3.324827324186991e-03,  -3.694249096124331e-05,   4.100484369900031e-07,  -4.514288420911255e-09,   4.734035241968697e-11,  -3.830523129015665e-13,
  -1.316347492458543e-15,   1.790772365123789e-16,  -5.352760396417752e-18,   8.765464145118938e-20,   3.324873538408982e-03,  -3.694401656721282e-05,   4.100804120352678e-07,
  -4.514718454504317e-09,   4.733806829865336e-11,  -3.826273464429520e-13,  -1.333219072542061e-15,   1.794299919182074e-16,  -5.352165954865155e-18,   8.729398833632610e-20,
   3.324890892618877e-03,  -3.694458945987305e-05,   4.100924188458367e-07,  -4.514879895073186e-09,   4.733720813591769e-11,  -3.824676957847855e-13,  -1.339554341992961e-15,
   1.795623287020589e-16,  -5.351936197206573e-18,   8.715839121976467e-20,   3.324893769343925e-03,  -3.694468442568837e-05,   4.100944091393217e-07,  -4.514906653977999e-09,
   4.733706542224943e-11,  -3.824412276311295e-13,  -1.340604494163294e-15,   1.795842587477365e-16,  -5.351897766618965e-18,   8.713590518435573e-20,   3.010364869142580e-02,
  -3.344176508449495e-04,   3.710869935367624e-06,  -4.084295747236224e-08,   4.283704140110456e-10,  -3.470926740275974e-12,  -1.195614644055375e-14,   1.639177062212157e-15,
  -4.964330033048548e-17,   8.401396979909093e-19,   3.010417751069174e-02,  -3.344351048973066e-04,   3.711235537825556e-06,  -4.084785487254016e-08,   4.283425437659225e-10,
  -3.465961357594381e-12,  -1.215386739781800e-14,   1.643369923177472e-15,  -4.963982838643986e-17,   8.360171335648812e-19,   3.010504569070677e-02,  -3.344637600512382e-04,
   3.711835715500978e-06,  -4.085588961280829e-08,   4.282964852468378e-10,  -3.457800894361609e-12,  -1.247844371144485e-14,   1.650237758117732e-15,  -4.963331938200113e-17,
   8.292280963828169e-19,   3.010596694791437e-02,  -3.344941674251411e-04,   3.712472525933693e-06,  -4.086440810967676e-08,   4.282471990902606e-10,  -3.449129820571589e-12,
  -1.282282309322290e-14,   1.657504055206245e-15,  -4.962531284632163e-17,   8.219956819762505e-19,   3.010669201918421e-02,  -3.345180996651856e-04,   3.712973681294839e-06,
  -4.087110715124110e-08,   4.282081105227961e-10,  -3.442296827352789e-12,  -1.309383514071024e-14,   1.663207426268588e-15,  -4.961821513655217e-17,   8.162829899279324e-19,
   3.010711048682624e-02,  -3.345319120207282e-04,   3.713262900693502e-06,  -4.087497126942953e-08,   4.281854314540349e-10,  -3.438349845603132e-12,  -1.325023461349392e-14,
   1.666492832076794e-15,  -4.961379958853969e-17,   8.129777853092728e-19,   3.010726762839076e-02,  -3.345370988094191e-04,   3.713371504097169e-06,  -4.087642190044540e-08,
   4.281768925022313e-10,  -3.436867048495165e-12,  -1.330896283105164e-14,   1.667725376352157e-15,  -4.961208114735612e-17,   8.117350816481500e-19,   3.010729367700228e-02,
  -3.345379585997863e-04,   3.713389506594213e-06,  -4.087666234304995e-08,   4.281754758493339e-10,  -3.436621218518287e-12,  -1.331869780209730e-14,   1.667929627071953e-15,
  -4.961179310682955e-17,   8.115290031398851e-19,   8.468208758853125e-02,  -9.407204613508644e-04,   1.043838523671502e-05,  -1.148555313486215e-07,   1.202312188238489e-09,
  -9.609859847167337e-12,  -4.056159709119759e-14,   4.859291695240060e-15,  -1.465977551391507e-16,   2.503801467011752e-18,   8.468357511078840e-02,  -9.407695435582862e-04,
   1.043941129051179e-05,  -1.148690824144223e-07,   1.202218667389045e-09,  -9.595138868824346e-12,  -4.114565015212890e-14,   4.871798298290204e-15,  -1.465960958887278e-16,
   2.491923253638122e-18,   8.468601722484012e-02,  -9.408501240999598e-04,   1.044109566400517e-05,  -1.148913134584503e-07,   1.202064236732224e-09,  -9.570945195448733e-12,
  -4.210444941987031e-14,   4.892285452305950e-15,  -1.465910029710027e-16,   2.472360140924353e-18,   8.468860864001948e-02,  -9.409356319269169e-04,   1.044288283279479e-05,
  -1.149148816092027e-07,   1.201899149291733e-09,  -9.545237460838004e-12,  -4.312178085303385e-14,   4.913963355000589e-15,  -1.465823787585721e-16,   2.451516588536248e-18,
   8.469064820122608e-02,  -9.410029311207590e-04,   1.044428928465476e-05,  -1.149334148647824e-07,   1.201768337999171e-09,  -9.524979042170537e-12,  -4.392240231673354e-14,
   4.930980037560291e-15,  -1.465732594814394e-16,   2.435050788072445e-18,   8.469182531350573e-02,  -9.410417724382125e-04,   1.044510095164880e-05,  -1.149441047511903e-07,
   1.201692488854030e-09,  -9.513276985456138e-12,  -4.438444614126286e-14,   4.940783051282133e-15,  -1.465670616558290e-16,   2.425523322074770e-18,   8.469226733873930e-02,
  -9.410563580484234e-04,   1.044540573615388e-05,  -1.149481177719474e-07,   1.201663939574152e-09,  -9.508880758692070e-12,  -4.455794609600606e-14,   4.944460841123129e-15,
  -1.465645575860288e-16,   2.421940995245776e-18,   8.469234061116386e-02,  -9.410587758384046e-04,   1.044545625830941e-05,  -1.149487829275393e-07,   1.201659203578781e-09,
  -9.508151916337994e-12,  -4.458670608355934e-14,   4.945070311174367e-15,  -1.465641331772054e-16,   2.421346927147365e-18,   1.693307726622979e-01,  -1.881062485921113e-03,
   2.087146055237225e-05,  -2.295435578701675e-07,   2.395054959193848e-09,  -1.869555634712775e-11,  -1.046506876589487e-13,   1.056580634987963e-14,  -3.171388920208499e-16,
   5.500232108909291e-18,   1.693337469341483e-01,  -1.881160576107967e-03,   2.087350419758515e-05,  -2.295698923287519e-07,   2.394816553793242e-09,  -1.866354260541198e-11,
  -1.059148285987015e-13,   1.059331933657860e-14,  -3.171662251874703e-16,   5.475593903034746e-18,   1.693386298928811e-01,  -1.881321615092048e-03,   2.087685902014140e-05,
  -2.296130914953949e-07,   2.394423222147456e-09,  -1.861092787352481e-11,  -1.079901703121268e-13,   1.063839408087915e-14,  -3.172060458115604e-16,   5.435007758112088e-18,
   1.693438113750903e-01,  -1.881492500859836e-03,   2.088041853919652e-05,  -2.296588841188540e-07,   2.394003215814359e-09,  -1.855501950894411e-11,  -1.101923279214161e-13,
   1.068609617698188e-14,  -3.172414317875688e-16,   5.391754805094426e-18,   1.693478894355969e-01,  -1.881626996787624e-03,   2.088321974903302e-05,  -2.296948905243695e-07,
   2.393670749165517e-09,  -1.851096144771978e-11,  -1.119254744404838e-13,   1.072354675341750e-14,  -3.172643076210936e-16,   5.357578742350308e-18,   1.693502430469455e-01,
  -1.881704620195068e-03,   2.088483632156155e-05,  -2.297156574368888e-07,   2.393478106742343e-09,  -1.848551150464255e-11,  -1.129257199139004e-13,   1.074512357408769e-14,
  -3.172755157964852e-16,   5.337800745827051e-18,   1.693511268670772e-01,  -1.881733769156857e-03,   2.088544334917615e-05,  -2.297234531442215e-07,   2.393405622168057e-09,
  -1.847595042114346e-11,  -1.133013241946923e-13,   1.075321895099765e-14,  -3.172793476547143e-16,   5.330363655589622e-18,   1.693512733737412e-01,  -1.881738601046176e-03,
   2.088554397208786e-05,  -2.297247452637151e-07,   2.393393599140312e-09,  -1.847436530388555e-11,  -1.133635860884456e-13,   1.075456050959682e-14,  -3.172799629544227e-16,
   5.329130310671055e-18,   2.881749799125722e-01,  -3.201259865197144e-03,   3.551682087753410e-05,  -3.903183365223578e-07,   4.051350735281128e-09,  -3.039642749449898e-11,
  -2.428943336052831e-13,   2.034327209005825e-14,  -6.075145253201676e-16,   1.079368258747666e-17,   2.881800411671718e-01,  -3.201426651571711e-03,   3.552027698417403e-05,
  -3.903610715138925e-07,   4.050803458107898e-09,  -3.033477032080200e-11,  -2.453178700367169e-13,   2.039737972818531e-14,  -6.076599234095466e-16,   1.074965317055163e-17,
   2.881883503909475e-01,  -3.201700471471005e-03,   3.552595039582418e-05,  -3.904311641439056e-07,   4.049901273448886e-09,  -3.023343399581228e-11,  -2.492968618761966e-13,
   2.048604109167079e-14,  -6.078891627964117e-16,   1.067710026666775e-17,   2.881971676023849e-01,  -3.201991033304241e-03,   3.553196985157903e-05,  -3.905054511011176e-07,
   4.048938901706911e-09,  -3.012575073571292e-11,  -2.535193602518549e-13,   2.057989274160257e-14,  -6.081195481491154e-16,   1.059974769055282e-17,   2.882041071436781e-01,
  -3.202219719842209e-03,   3.553670685179997e-05,  -3.905638524730358e-07,   4.048177828850013e-09,  -3.004088950172898e-11,  -2.568428247985104e-13,   2.065359121157975e-14,
  -6.082915510769056e-16,   1.053860462528359e-17,   2.882081122287737e-01,  -3.202351704462588e-03,   3.553944052940211e-05,  -3.905975318350155e-07,   4.047737123129710e-09,
  -2.999186880156018e-11,  -2.587609920435294e-13,   2.069605845057594e-14,  -6.083870835204722e-16,   1.050321123490195e-17,   2.882096162045363e-01,  -3.202401266972580e-03,
   3.554046702643015e-05,  -3.906101740030515e-07,   4.047571354820029e-09,  -2.997345242413388e-11,  -2.594813071920079e-13,   2.071199290720761e-14,  -6.084222510232370e-16,
   1.048990054916315e-17,   2.882098655114436e-01,  -3.202409482719338e-03,   3.554063718162803e-05,  -3.906122693718158e-07,   4.047543861634961e-09,  -2.997039919152823e-11,
  -2.596007110075980e-13,   2.071463361617645e-14,  -6.084280432982282e-16,   1.048769305176944e-17,   4.486467759751435e-01,  -4.983849842095185e-03,   5.528656435354911e-05,
  -6.068403155074373e-07,   6.244782072364148e-09,  -4.368034578264698e-11,  -5.464622409455597e-13,   3.791133855564759e-14,  -1.129314573927617e-15,   2.085153000927482e-17,
   4.486546543679542e-01,  -4.984109131577425e-03,   5.529188948411133e-05,  -6.069015036467924e-07,   6.243561988797109e-09,  -4.356537765294353e-11,  -5.509731656141031e-13,
   3.801620614571861e-14,  -1.129863204855208e-15,   2.077917023136428e-17,   4.486675885717946e-01,  -4.984534815891416e-03,   5.530063077798910e-05,  -6.070018349354950e-07,
   6.241552058675876e-09,  -4.337641362611747e-11,  -5.583800617437011e-13,   3.818809139368385e-14,  -1.130746976065525e-15,   2.065985803801780e-17,   4.486813135051539e-01,
  -4.984986525198088e-03,   5.530990491788717e-05,  -6.071081324045696e-07,   6.239409899563965e-09,  -4.317560239924002e-11,  -5.662413400922993e-13,   3.837010437018404e-14,
  -1.131661749212416e-15,   2.053255021330890e-17,   4.486921156380687e-01,  -4.985342041134115e-03,   5.531720295372560e-05,  -6.071916718366954e-07,   6.237717153115799e-09,
  -4.301734176392358e-11,  -5.724296265844741e-13,   3.851308041602583e-14,  -1.132365033755822e-15,   2.043184615959490e-17,   4.486983499759463e-01,  -4.985547223678297e-03,
   5.532141448726165e-05,  -6.072398370503594e-07,   6.236737487520849e-09,  -4.292591789527278e-11,  -5.760015696541712e-13,   3.859548653701680e-14,  -1.132764236531936e-15,
   2.037352284323849e-17,   4.487006910725895e-01,  -4.985624273151726e-03,   5.532299590213875e-05,  -6.072579146747041e-07,   6.236369093813190e-09,  -4.289157059453004e-11,
  -5.773429751808226e-13,   3.862641038075910e-14,  -1.132912878785706e-15,   2.035158313333228e-17,   4.487010791450192e-01,  -4.985637045278012e-03,   5.532325804123732e-05,
  -6.072609108304927e-07,   6.236307999874364e-09,  -4.288587615551093e-11,  -5.775653378868322e-13,   3.863153536960231e-14,  -1.132937451761334e-15,   2.034794427020103e-17,
   6.655306925737069e-01,  -7.393006721949372e-03,   8.199231790785496e-05,  -8.980163812916644e-07,   9.096458203234314e-09,  -5.489320742101420e-11,  -1.278377165696886e-12,
   7.408228726631130e-14,  -2.221788194227715e-15,   4.383961037774230e-17,   6.655423762693002e-01,  -7.393390373812338e-03,   8.200006875170157e-05,  -8.980925960624994e-07,
   9.093623642677012e-09,  -5.466827964886841e-11,  -1.287272332650832e-12,   7.430394996469867e-14,  -2.223851656215543e-15,   4.373148769121692e-17,   6.655615577417157e-01,
  -7.394020223525206e-03,   8.201279123365919e-05,  -8.982174821217559e-07,   9.088956506478421e-09,  -5.429854743530524e-11,  -1.301880956614296e-12,   7.466743669911532e-14,
  -2.227208630122918e-15,   4.355291326338750e-17,   6.655819118471702e-01,  -7.394688574093581e-03,   8.202628834295774e-05,  -8.983496791895625e-07,   9.083985627039612e-09,
  -5.390558535787315e-11,  -1.317389626256813e-12,   7.505256690709063e-14,  -2.230729096926557e-15,   4.336197391978365e-17,   6.655979314175317e-01,  -7.395214592165632e-03,
   8.203690887776930e-05,  -8.984534894708070e-07,   9.080059984975765e-09,  -5.359585362648966e-11,  -1.329600633261170e-12,   7.535526118475015e-14,  -2.233469609936199e-15,
   4.321064872637931e-17,   6.656071769384456e-01,  -7.395518176555095e-03,   8.204303748893150e-05,  -8.985133083473058e-07,   9.077788993918418e-09,  -5.341691371235468e-11,
  -1.336650077399468e-12,   7.552978897604371e-14,  -2.235039131266909e-15,   4.312289338347069e-17,   6.656106487827571e-01,  -7.395632177226033e-03,   8.204533870956156e-05,
  -8.985357535204165e-07,   9.076935188428132e-09,  -5.334968453782230e-11,  -1.339297634379533e-12,   7.559529502230540e-14,  -2.235626217073539e-15,   4.308986053119071e-17,
   6.656112242937737e-01,  -7.395651074559405e-03,   8.204572016275790e-05,  -8.985394732104858e-07,   9.076793603829649e-09,  -5.333853846967412e-11,  -1.339736526997951e-12,
   7.560615195669016e-14,  -2.235723414368735e-15,   4.308438065148119e-17,   9.771958376754294e-01,  -1.085471754331897e-02,   1.203211231446953e-04,  -1.311244925245705e-06,
   1.277923066687519e-08,  -4.515506565734899e-11,  -3.628284349968780e-12,   1.796175743773466e-13,  -5.617336613027541e-15,   1.276867833825206e-16,   9.772129821053612e-01,
  -1.085527755241072e-02,   1.203319890743973e-04,  -1.311304554581416e-06,   1.277121671438533e-08,  -4.460785631970991e-11,  -3.650899974232467e-12,   1.802704509688743e-13,
  -5.628603972425846e-15,   1.276419733146153e-16,   9.772411285728652e-01,  -1.085619691530428e-02,   1.203498222255485e-04,  -1.311401878597607e-06,   1.275802549779356e-08,
  -4.370811426773192e-11,  -3.688059323837777e-12,   1.813420675944295e-13,  -5.647047421210811e-15,   1.275657546433099e-16,   9.772709956601796e-01,  -1.085717245385925e-02,
   1.203687377277749e-04,  -1.311504375245167e-06,   1.274398097972526e-08,  -4.275150319470662e-11,  -3.727531864320798e-12,   1.824788775038127e-13,  -5.666544105799647e-15,
   1.274812679729551e-16,   9.772945023078531e-01,  -1.085794022474499e-02,   1.203836193588802e-04,  -1.311584481319027e-06,   1.273289337234994e-08,  -4.199725876817134e-11,
  -3.758628460336253e-12,   1.833733617076195e-13,  -5.681834917548610e-15,   1.274121580715158e-16,   9.773080688919444e-01,  -1.085838332709242e-02,   1.203922058444672e-04,
  -1.311630487688811e-06,   1.272648066187793e-08,  -4.156141385063214e-11,  -3.776587518212203e-12,   1.838895080001852e-13,  -5.690638175685907e-15,   1.273712229060935e-16,
   9.773131633619646e-01,  -1.085854971770400e-02,   1.203954297777966e-04,  -1.311647721097415e-06,   1.272407000945280e-08,  -4.139764472249814e-11,  -3.783333702712323e-12,
   1.840833111494887e-13,  -5.693939841800992e-15,   1.273556526856279e-16,   9.773140078476589e-01,  -1.085857729939668e-02,   1.203959641709745e-04,  -1.311650575542029e-06,
   1.272367027128838e-08,  -4.137049210486242e-11,  -3.784452104830913e-12,   1.841154360045731e-13,  -5.694486926687938e-15,   1.273530612160145e-16,   3.182997257103194e-03,
  -3.385711376696022e-05,   3.599721709398374e-07,  -3.815417587671908e-09,   3.966012856538342e-11,  -3.719414294161402e-13,   1.815578336672613e-15,   5.359379856329771e-17,
  -2.497553388644278e-18,   6.271875254216928e-20,   3.183048551929310e-03,  -3.385874451755733e-05,   3.600060557246119e-07,  -3.815945487366633e-09,   3.966388425801801e-11,
  -3.717761344215638e-13,   1.805503044723482e-15,   5.391498758761845e-17,  -2.503528131454246e-18,   6.271526753774395e-20,   3.183132764179253e-03,  -3.386142182123162e-05,
   3.600616853640509e-07,  -3.816811948020816e-09,   3.967003422515526e-11,  -3.715040822612712e-13,   1.788945747993000e-15,   5.444224971068755e-17,  -2.513313429088458e-18,
   6.270838775520209e-20,   3.183222124630482e-03,  -3.386426286838725e-05,   3.601207158063962e-07,  -3.817731095413179e-09,   3.967653858568057e-11,  -3.712144711583750e-13,
   1.771354007794763e-15,   5.500168380121211e-17,  -2.523664762135868e-18,   6.269951214489071e-20,   3.183292455211196e-03,  -3.386649894744219e-05,   3.601671753117512e-07,
  -3.818454299273083e-09,   3.968164216922931e-11,  -3.709858631577084e-13,   1.757492470105850e-15,   5.544193651024378e-17,  -2.531788356072161e-18,   6.269138540200156e-20,
   3.183333045741975e-03,  -3.386778949652446e-05,   3.601939888961278e-07,  -3.818871606129614e-09,   3.968458137736009e-11,  -3.708536554227118e-13,   1.749486002725123e-15,
   5.569600438137920e-17,  -2.536467416968611e-18,   6.268623743465268e-20,   3.183348288150255e-03,  -3.386827412265916e-05,   3.602040578327600e-07,  -3.819028296095113e-09,
   3.968568391265391e-11,  -3.708039583937233e-13,   1.746478228827656e-15,   5.579140732164185e-17,  -2.538222704966681e-18,   6.268421774974963e-20,   3.183350814811338e-03,
  -3.386835445701725e-05,   3.602057269120464e-07,  -3.819054269018428e-09,   3.968586661210686e-11,  -3.707957176719177e-13,   1.745979580503874e-15,   5.580722161349516e-17,
  -2.538513576913275e-18,   6.268387839026263e-20,   2.882240543343181e-02,  -3.065799480911423e-04,   3.259572320348768e-06,  -3.454724468353135e-08,   3.589877547376659e-10,
  -3.359616111440329e-12,   1.603872245577724e-14,   5.009999928949723e-16,  -2.311569299980403e-17,   5.806152745583164e-19,   2.882286991130068e-02,  -3.065947139132000e-04,
   3.259879027051472e-06,  -3.455201257835667e-08,   3.590208817330481e-10,  -3.358071374868257e-12,   1.594546578480171e-14,   5.039738430226286e-16,  -2.317130069183840e-17,
   5.806001369147781e-19,   2.882363245849425e-02,  -3.066189558687184e-04,   3.260382555847425e-06,  -3.455983824091205e-08,   3.590751205665889e-10,  -3.355529016826930e-12,
   1.579221093203799e-14,   5.088557627347013e-16,  -2.326237736016504e-17,   5.805646102720493e-19,   2.882444162295446e-02,  -3.066446804533255e-04,   3.260916866095169e-06,
  -3.456813968410424e-08,   3.591324756517166e-10,  -3.352822649300521e-12,   1.562938002026458e-14,   5.140356495154581e-16,  -2.335872738871514e-17,   5.805123948349980e-19,
   2.882507847073686e-02,  -3.066649272816957e-04,   3.261337390780105e-06,  -3.457467137533545e-08,   3.591774720216601e-10,  -3.350686403860722e-12,   1.550107535318743e-14,
   5.181120804086527e-16,  -2.343434528253361e-17,   5.804607813680569e-19,   2.882544602051218e-02,  -3.066766127014658e-04,   3.261580091687893e-06,  -3.457844030450747e-08,
   3.592033831976692e-10,  -3.349451001545808e-12,   1.542696582262452e-14,   5.204645957273370e-16,  -2.347790144337951e-17,   5.804267749658860e-19,   2.882558404146412e-02,
  -3.066810008022555e-04,   3.261671229781755e-06,  -3.457985545427201e-08,   3.592131023036083e-10,  -3.348986616879430e-12,   1.539912517349111e-14,   5.213479742181529e-16,
  -2.349424123876098e-17,   5.804132074468963e-19,   2.882560692053682e-02,  -3.066817281985463e-04,   3.261686337303889e-06,  -3.458009002923579e-08,   3.592147128147752e-10,
  -3.348909613214572e-12,   1.539450956601710e-14,   5.214944060712159e-16,  -2.349694895036022e-17,   5.804109163430140e-19,   8.107793312156539e-02,  -8.624141721065711e-04,
   9.169132708391644e-06,  -9.717124285283446e-08,   1.009004475677131e-09,  -9.400497650584834e-12,   4.270134262818282e-14,   1.504052815881751e-15,  -6.805271867171406e-17,
   1.710526585111681e-18,   8.107923969003344e-02,  -8.624557037669662e-04,   9.169994737181667e-06,  -9.718458119137798e-08,   1.009092359693977e-09,  -9.395862805913381e-12,
   4.242675316099971e-14,   1.512816837046121e-15,  -6.821840613554133e-17,   1.710589129003771e-18,   8.108138472244092e-02,  -8.625238888176974e-04,   9.171409950190694e-06,
  -9.720647340780461e-08,   1.009236210063044e-09,  -9.388235027750189e-12,   4.197549642199786e-14,   1.527204392922963e-15,  -6.848979896924158e-17,   1.710660665862496e-18,
   8.108366088832483e-02,  -8.625962440099250e-04,   9.172911672789561e-06,  -9.722969617325887e-08,   1.009388267775623e-09,  -9.380115637480582e-12,   4.149603533110352e-14,
   1.542470633850039e-15,  -6.877693656350829e-17,   1.710694221190896e-18,   8.108545233024145e-02,  -8.626531919684649e-04,   9.174093588541096e-06,  -9.724796784776757e-08,
   1.009507518724175e-09,  -9.373707006945976e-12,   4.111823228181768e-14,   1.554485146683183e-15,  -6.900231183721312e-17,   1.710689942709512e-18,   8.108648624143956e-02,
  -8.626860593689704e-04,   9.174775716110008e-06,  -9.725851087603134e-08,   1.009576172610938e-09,  -9.370000994086952e-12,   4.090000875109454e-14,   1.561418900865436e-15,
  -6.913213782554832e-17,   1.710675165058970e-18,   8.108687449199813e-02,  -8.626984017108722e-04,   9.175031865736674e-06,  -9.726246952619268e-08,   1.009601921030401e-09,
  -9.368607938098915e-12,   4.081802851879627e-14,   1.564022581947384e-15,  -6.918084287459364e-17,   1.710667288564019e-18,   8.108693885043491e-02,  -8.627004476468598e-04,
   9.175074326411588e-06,  -9.726312571002605e-08,   1.009606187521714e-09,  -9.368376944676434e-12,   4.080443726949895e-14,   1.564454178644766e-15,  -6.918891401051888e-17,
   1.710665860122405e-18,   1.621239024138956e-01,  -1.724486317647297e-03,   1.833431217321307e-05,  -1.942682025580399e-07,   2.014814184157007e-09,  -1.862856379449018e-11,
   7.722659161065006e-14,   3.329065068888121e-15,  -1.464242497073173e-16,   3.686858183634178e-18,   1.621265149825635e-01,  -1.724569348357050e-03,   1.833603340100741e-05,
  -1.942946255486652e-07,   2.014972002035888e-09,  -1.861831298243807e-11,   7.663562280746985e-14,   3.347965366306580e-15,  -1.467881152269223e-16,   3.687378574835884e-18,
   1.621308041141666e-01,  -1.724705664841976e-03,   1.833885917023741e-05,  -1.943379924958019e-07,   2.015230169854458e-09,  -1.860144378348870e-11,   7.566441114205244e-14,
   3.378994692693762e-15,  -1.473842010991485e-16,   3.688166898475795e-18,   1.621353554553057e-01,  -1.724850318225910e-03,   1.834185765892909e-05,  -1.943839936564093e-07,
   2.015502860373286e-09,  -1.858348876399270e-11,   7.463246805861690e-14,   3.411921014321695e-15,  -1.480149794159804e-16,   3.688913623540701e-18,   1.621389375592052e-01,
  -1.724964169204056e-03,   1.834421757854514e-05,  -1.944201862790623e-07,   2.015716566785339e-09,  -1.856931788786973e-11,   7.381930235763195e-14,   3.437835405889300e-15,
  -1.485101599109595e-16,   3.689436265085994e-18,   1.621410049313645e-01,  -1.725029878038128e-03,   1.834557957160502e-05,  -1.944410695214161e-07,   2.015839538957367e-09,
  -1.856112349112410e-11,   7.334959975458942e-14,   3.452791555575622e-15,  -1.487954378253860e-16,   3.689711804309301e-18,   1.621417812633902e-01,  -1.725054552965070e-03,
   1.834609102058354e-05,  -1.944489105867519e-07,   2.015885647786299e-09,  -1.855804336922767e-11,   7.317314455553834e-14,   3.458407818953627e-15,  -1.489024677854805e-16,
   3.689810339073605e-18,   1.621419099522332e-01,  -1.725058643219389e-03,   1.834617580094371e-05,  -1.944502103133547e-07,   2.015893287373275e-09,  -1.855753263432678e-11,
   7.314389050937555e-14,   3.459338799141247e-15,  -1.489202045321740e-16,   3.689826412333316e-18,   2.759100386037810e-01,  -2.934806054819040e-03,   3.120128662217202e-05,
  -3.305183068581307e-07,   3.421374059029969e-09,  -3.124615804924398e-11,   1.091926815331954e-13,   6.548941752712248e-15,  -2.779160450406183e-16,   7.025779448838888e-18,
   2.759144846532850e-01,  -2.934947316824295e-03,   3.120420918040760e-05,  -3.305626018045080e-07,   3.421593791818569e-09,  -3.122601067320911e-11,   1.080705278434678e-13,
   6.584989881728571e-15,  -2.786298166483193e-16,   7.027929728109443e-18,   2.759217838641251e-01,  -2.935179234902943e-03,   3.120900716423571e-05,  -3.306352981666763e-07,
   3.421952779592136e-09,  -3.119285759643377e-11,   1.062262880334288e-13,   6.644175759816695e-15,  -2.797993606827669e-16,   7.031337508589492e-18,   2.759295293001289e-01,
  -2.935425336437517e-03,   3.121409837404532e-05,  -3.307124060938506e-07,   3.422331327970628e-09,  -3.115757374113615e-11,   1.042666341000390e-13,   6.706985869936907e-15,
  -2.810373006466470e-16,   7.034787124113974e-18,   2.759356252952222e-01,  -2.935619033051120e-03,   3.121810531143740e-05,  -3.307730697454590e-07,   3.422627533567065e-09,
  -3.112972849657178e-11,   1.027223712517894e-13,   6.756424307996964e-15,  -2.820093600779452e-16,   7.037381461727086e-18,   2.759391435319518e-01,  -2.935730824530025e-03,
   3.122041784472365e-05,  -3.308080716191679e-07,   3.422797792120404e-09,  -3.111362772834174e-11,   1.018303442211586e-13,   6.784958758894110e-15,  -2.825694680084194e-16,
   7.038830351796164e-18,   2.759404646872756e-01,  -2.935772804357929e-03,   3.122128623365838e-05,  -3.308212135995467e-07,   3.422861595904666e-09,  -3.110757592066201e-11,
   1.014952275838552e-13,   6.795674205421131e-15,  -2.827796262517468e-16,   7.039365280552991e-18,   2.759406836888654e-01,  -2.935779763168886e-03,   3.122143018206498e-05,
  -3.308233919879821e-07,   3.422872165436040e-09,  -3.110657244045309e-11,   1.014396692086432e-13,   6.797450469009808e-15,  -2.828144541267912e-16,   7.039453470157473e-18,
   4.295521482658935e-01,  -4.569056582319608e-03,   4.857367024162433e-05,  -5.143293139816377e-07,   5.307694679765636e-09,  -4.748987124777164e-11,   1.131478204877236e-13,
   1.248344341089083e-14,  -5.083189312644933e-16,   1.296488299465568e-17,   4.295590697720849e-01,  -4.569276398385337e-03,   4.857820340298296e-05,  -5.143965706144878e-07,
   5.307911766561337e-09,  -4.745150016484917e-11,   1.110938459098937e-13,   1.255005694589342e-14,  -5.096969108874312e-16,   1.297229815052123e-17,   4.295704330114885e-01,
  -4.569637282720394e-03,   4.858564544740803e-05,  -5.145069433539961e-07,   5.308264965523428e-09,  -4.738836381275287e-11,   1.077179662169078e-13,   1.265943968298421e-14,
  -5.119554892292646e-16,   1.298425668236255e-17,   4.295824909212268e-01,  -4.570020237003355e-03,   4.859354220246457e-05,  -5.146240030413583e-07,   5.308635406052077e-09,
  -4.732117551223973e-11,   1.041305369965393e-13,   1.277553790010384e-14,  -5.143471079836886e-16,   1.299665355049757e-17,   4.295919810189580e-01,  -4.570321644384855e-03,
   4.859975711296559e-05,  -5.147160902374794e-07,   5.308923806404305e-09,  -4.726815621410840e-11,   1.013033351129797e-13,   1.286693257136224e-14,  -5.162257579415688e-16,
   1.300619822998490e-17,   4.295974581240878e-01,  -4.570495600633517e-03,   4.860334390827932e-05,  -5.147692197473474e-07,   5.309088989042441e-09,  -4.723750091137942e-11,
   9.967014932537470e-14,   1.291968803663950e-14,  -5.173085294826500e-16,   1.301162169680284e-17,   4.295995148663356e-01,  -4.570560924475858e-03,   4.860469079480216e-05,
  -5.147891674155263e-07,   5.309150778728203e-09,  -4.722597879819860e-11,   9.905657859950094e-14,   1.293950007975317e-14,  -5.177148493790993e-16,   1.301364219503009e-17,
   4.295998558026392e-01,  -4.570571752919056e-03,   4.860491406100771e-05,  -5.147924738691988e-07,   5.309161008693020e-09,  -4.722406827629455e-11,   9.895485500472581e-14,
   1.294278430629170e-14,  -5.177821883777686e-16,   1.301397627365079e-17,   6.372056665611726e-01,  -6.777790020580145e-03,   7.204936951673552e-05,  -7.623446938629686e-07,
   7.824048543482656e-09,  -6.737533854927278e-11,   1.410976977666863e-14,   2.483919070736129e-14,  -9.690084428922390e-16,   2.522602295093662e-17,   6.372159331498394e-01,
  -6.778115818653938e-03,   7.205604991704327e-05,  -7.624399277412417e-07,   7.824031999266745e-09,  -6.729902998253558e-11,   1.018875056902182e-14,   2.496912492896546e-14,
  -9.719000250280013e-16,   2.525243937373379e-17,   6.372327881043045e-01,  -6.778650698169968e-03,   7.206701685054166e-05,  -7.625961902140724e-07,   7.823998757804135e-09,
  -6.717347600930951e-11,   3.743464685183569e-15,   2.518252797293326e-14,  -9.766418610172317e-16,   2.529543146614673e-17,   6.372506734482775e-01,  -6.779218286418844e-03,
   7.207865357890528e-05,  -7.627618887713373e-07,   7.823955213792893e-09,  -6.703987137403386e-11,  -3.106751608650468e-15,   2.540909343124256e-14,  -9.816662636353051e-16,
   2.534053927663112e-17,   6.372647499846602e-01,  -6.779665010117865e-03,   7.208781171781533e-05,  -7.628922160839797e-07,   7.823914949569417e-09,  -6.693444703819063e-11,
  -8.506060990826000e-15,   2.558749395368039e-14,  -9.856153628806535e-16,   2.537566937699268e-17,   6.372728741003187e-01,  -6.779922834626810e-03,   7.209309704731902e-05,
  -7.629673990877972e-07,   7.823889307447015e-09,  -6.687349361446298e-11,  -1.162537405760854e-14,   2.569048919018909e-14,  -9.878923994596223e-16,   2.539579512658542e-17,
   6.372759248378039e-01,  -6.780019652471977e-03,   7.209508173885880e-05,  -7.629956251065573e-07,   7.823879223816858e-09,  -6.685058401834925e-11,  -1.279732419187707e-14,
   2.572917185884192e-14,  -9.887470578464493e-16,   2.540332444914473e-17,   6.372764305439144e-01,  -6.780035701530547e-03,   7.209541072976992e-05,  -7.630003036593485e-07,
   7.823877528315024e-09,  -6.684678531803153e-11,  -1.299162424804484e-14,   2.573558443004466e-14,  -9.888887090294086e-16,   2.540457105930344e-17,   9.356072376594130e-01,
  -9.951704559122511e-03,   1.057717632955397e-04,  -1.117339302850107e-06,   1.132395177165085e-08,  -8.844220960757217e-11,  -5.226104803426397e-13,   5.980144053974740e-14,
  -2.262225211495808e-15,   6.235478940618783e-17,   9.356223091880109e-01,  -9.952182014731482e-03,   1.057814251892740e-04,  -1.117463605334096e-06,   1.132272682224721e-08,
  -8.825832575786455e-11,  -5.317974970255244e-13,   6.012450653229063e-14,  -2.270560169969637e-15,   6.249012177254176e-17,   9.356470525347942e-01,  -9.952965873398039e-03,
   1.057972859610995e-04,  -1.117667476687631e-06,   1.132070160303817e-08,  -8.795575047834551e-11,  -5.469034705780087e-13,   6.065536828586987e-14,  -2.284242257542003e-15,
   6.271169778993249e-17,   9.356733084882723e-01,  -9.953797659658972e-03,   1.058141143867824e-04,  -1.117883539572693e-06,   1.131853327912037e-08,  -8.763374252707874e-11,
  -5.629646906462028e-13,   6.121932739713051e-14,  -2.298758447708140e-15,   6.294599722012868e-17,   9.356939730391831e-01,  -9.954452317175705e-03,   1.058273576611287e-04,
  -1.118053393365614e-06,   1.131681272755163e-08,  -8.737963070091632e-11,  -5.756285675884157e-13,   6.166365304408006e-14,  -2.310181577102590e-15,   6.312980370626065e-17,
   9.357058993474399e-01,  -9.954830147796766e-03,   1.058350002977520e-04,  -1.118151343514438e-06,   1.131581411867531e-08,  -8.723270110877147e-11,  -5.829466030817226e-13,
   6.192027690575632e-14,  -2.316773593086098e-15,   6.323564549254233e-17,   9.357103778688457e-01,  -9.954972029779944e-03,   1.058378701239304e-04,  -1.118188110430755e-06,
   1.131543806353570e-08,  -8.717747527086056e-11,  -5.856963870002542e-13,   6.201667850714688e-14,  -2.319248864753542e-15,   6.327534534884184e-17,   9.357111202517803e-01,
  -9.954995548898679e-03,   1.058383458355353e-04,  -1.118194204316685e-06,   1.131537567067880e-08,  -8.716831803744625e-11,  -5.861522974112686e-13,   6.203266039233643e-14,
  -2.319659171349484e-15,   6.328192380361347e-17,   3.053052890931066e-03,  -3.115023689989991e-05,   3.177577759988387e-07,  -3.237626739544199e-09,   3.273982732803297e-11,
  -3.175620389239878e-13,   2.485863284698352e-15,   2.759225777191000e-18,  -8.791788569324914e-19,   2.932473093161644e-20,   3.053098166473550e-03,  -3.115162071033587e-05,
   3.177857605074835e-07,  -3.238078561242188e-09,   3.274509091050524e-11,  -3.175513579778057e-13,   2.482273528755325e-15,   2.911367945258372e-18,  -8.833506767163636e-19,
   2.939611058991412e-20,   3.053172496489456e-03,  -3.115389259859065e-05,   3.178317048435992e-07,  -3.238820287702318e-09,   3.275372634862628e-11,  -3.175334936081657e-13,
   2.476368347416306e-15,   3.161396239062137e-18,  -8.901995628369973e-19,   2.951302541919671e-20,   3.053251370303290e-03,  -3.115630343717450e-05,   3.178804597316513e-07,
  -3.239607300336850e-09,   3.276288161608439e-11,  -3.175140895018246e-13,   2.470086162643952e-15,   3.427051528462596e-18,  -8.974669565448846e-19,   2.963671785264834e-20,
   3.053313447249208e-03,  -3.115820091705300e-05,   3.179188332664765e-07,  -3.240226671347535e-09,   3.277008134920957e-11,  -3.174984933042912e-13,   2.465130226008635e-15,
   3.636380921635337e-18,  -9.031865495392189e-19,   2.973380056495672e-20,   3.053349274207034e-03,  -3.115929604480924e-05,   3.179409806587052e-07,  -3.240584117583350e-09,
   3.277423424447553e-11,  -3.174893620518854e-13,   2.462265318302505e-15,   3.757291998235781e-18,  -9.064874763841173e-19,   2.978972282662443e-20,   3.053362727801145e-03,
  -3.115970728656978e-05,   3.179492974656316e-07,  -3.240718341270067e-09,   3.277579327963198e-11,  -3.174859085227441e-13,   2.461188621102076e-15,   3.802714759188038e-18,
  -9.077270133748848e-19,   2.981070210878506e-20,   3.053364957938293e-03,  -3.115977545632657e-05,   3.179506761081324e-07,  -3.240740590718226e-09,   3.277605168994936e-11,
  -3.174853347500641e-13,   2.461010095868360e-15,   3.810245257614628e-18,  -9.079324846722829e-19,   2.981417866476828e-20,   2.764574451991382e-02,  -2.820689449818817e-04,
   2.877328513427898e-06,  -2.931657528775769e-08,   2.964222223468103e-10,  -2.873012106497773e-12,   2.238070894198053e-14,   3.037672827177376e-17,  -8.148582995660014e-18,
   2.709521777913444e-19,   2.764615449441709e-02,  -2.820814753146596e-04,   2.877581880021046e-06,  -2.932066281797263e-08,   2.964696000769116e-10,  -2.872898825042767e-12,
   2.234743907206439e-14,   3.178259621480486e-17,  -8.187179322768656e-18,   2.716160567025053e-19,   2.764682756003924e-02,  -2.821020471455294e-04,   2.877997851413810e-06,
  -2.932737303464002e-08,   2.965473265332286e-10,  -2.872709806983590e-12,   2.229271002315461e-14,   3.409299589541979e-17,  -8.250543866148879e-18,   2.727034883028108e-19,
   2.764754177019422e-02,  -2.821238771628597e-04,   2.878439268778744e-06,  -2.933449292059257e-08,   2.966297298767420e-10,  -2.872505098534654e-12,   2.223448717536103e-14,
   3.654781960788415e-17,  -8.317781535820226e-18,   2.738540200403693e-19,   2.764810388305146e-02,  -2.821410587427950e-04,   2.878786695199124e-06,  -2.934009618196724e-08,
   2.966945306708942e-10,  -2.872340988055581e-12,   2.218855608748420e-14,   3.848217215982645e-17,  -8.370699861261487e-18,   2.747570845642930e-19,   2.764842829968045e-02,
  -2.821509750662376e-04,   2.878987213253709e-06,  -2.934332988260778e-08,   2.967319079804786e-10,  -2.872245071850062e-12,   2.216200450460779e-14,   3.959948293648436e-17,
  -8.401240754637927e-18,   2.752772920049283e-19,   2.764855012329885e-02,  -2.821546988383647e-04,   2.879062511945241e-06,  -2.934454415964844e-08,   2.967459396550669e-10,
  -2.872208826545263e-12,   2.215202583228898e-14,   4.001922517877157e-17,  -8.412709285353655e-18,   2.754724516446137e-19,   2.764857031741013e-02,  -2.821553161118586e-04,
   2.879074993895535e-06,  -2.934474544293552e-08,   2.967482654013848e-10,  -2.872202806346718e-12,   2.215037128724019e-14,   4.008881300489487e-17,  -8.414610364660446e-18,
   2.755047924638955e-19,   7.776796668483633e-02,  -7.934647524467732e-04,   8.093948179970639e-06,  -8.246501848625896e-08,   8.335977654536918e-10,  -8.066571890554595e-12,
   6.218298756723190e-14,   1.178688578418722e-16,  -2.405269526980029e-17,   7.949489192063664e-19,   7.776911994596905e-02,  -7.934999991226171e-04,   8.094660687329274e-06,
  -8.247649421856756e-08,   8.337293320328164e-10,  -8.066153612711999e-12,   6.208479023305572e-14,   1.219942874895083e-16,  -2.416625715917517e-17,   7.969241305163488e-19,
   7.777101328422766e-02,  -7.935578657873758e-04,   8.095830464329006e-06,  -8.249533303316486e-08,   8.339451671108959e-10,  -8.065457996654954e-12,   6.192325628145935e-14,
   1.287741094381042e-16,  -2.435269992175119e-17,   8.001598002406334e-19,   7.777302236230994e-02,  -7.936192716051564e-04,   8.097071797981081e-06,  -8.251532184505864e-08,
   8.341739769269655e-10,  -8.064707728242501e-12,   6.175141165097246e-14,   1.359778792975753e-16,  -2.455054626116475e-17,   8.035836067759677e-19,   7.777460358962339e-02,
  -7.936676017919490e-04,   8.098048813579790e-06,  -8.253105268755032e-08,   8.343539007233587e-10,  -8.064108447779331e-12,   6.161584709073306e-14,   1.416544079254369e-16,
  -2.470626337123831e-17,   8.062712659193691e-19,   7.777551617581102e-02,  -7.936954954849750e-04,   8.098612700237609e-06,  -8.254013107965783e-08,   8.344576777722372e-10,
  -8.063759055485412e-12,   6.153748108119369e-14,   1.449332955000221e-16,  -2.479613494034957e-17,   8.078195949071751e-19,   7.777585886647780e-02,  -7.937059701081545e-04,
   8.098824451303403e-06,  -8.254354007110209e-08,   8.344966356438097e-10,  -8.063627186633754e-12,   6.150802947288390e-14,   1.461650889864113e-16,  -2.482988337088156e-17,
   8.084004830176749e-19,   7.777591567265005e-02,  -7.937077064408091e-04,   8.098859552390982e-06,  -8.254410515837577e-08,   8.345030928648197e-10,  -8.063605292207504e-12,
   6.150314616041967e-14,   1.463693047910067e-16,  -2.483547769587456e-17,   8.084967458269104e-19,   1.555052790874958e-01,  -1.586616202036745e-03,   1.618461403925563e-05,
  -1.648874581020447e-07,   1.666055004257955e-09,  -1.607885621444083e-11,   1.217396078882379e-13,   3.450589719311320e-16,  -5.192902536824883e-17,   1.701361307814262e-18,
   1.555075851406376e-01,  -1.586686676927011e-03,   1.618603804723088e-05,  -1.649103294659850e-07,   1.666312345416314e-09,  -1.607768364977094e-11,   1.215276211155788e-13,
   3.538909813231718e-16,  -5.217330482785353e-17,   1.705688799806186e-18,   1.555113710469037e-01,  -1.586802379923727e-03,   1.618837594486643e-05,  -1.649478752474490e-07,
   1.666734482820298e-09,  -1.607573954263704e-11,   1.211789067181155e-13,   3.684060709074273e-16,  -5.257437548935119e-17,   1.712778827612586e-18,   1.555153883856241e-01,
  -1.586925159339274e-03,   1.619085684969328e-05,  -1.649877124948770e-07,   1.667181954469696e-09,  -1.607365064600842e-11,   1.208079371931955e-13,   3.838293058809347e-16,
  -5.300000364326253e-17,   1.720282460983649e-18,   1.555185501968106e-01,  -1.587021794330463e-03,   1.619280949022336e-05,  -1.650190633579238e-07,   1.667533791623656e-09,
  -1.607198779860234e-11,   1.205152895710824e-13,   3.959830910649236e-16,  -5.333501806556823e-17,   1.726173737025505e-18,   1.555203749978007e-01,  -1.587077567057770e-03,
   1.619393645951712e-05,  -1.650371560461515e-07,   1.667736713140065e-09,  -1.607102056603429e-11,   1.203461192376235e-13,   4.030035311123021e-16,  -5.352837812303142e-17,
   1.729568029370617e-18,   1.555210602396672e-01,  -1.587098510797720e-03,   1.619435965945795e-05,  -1.650439499341630e-07,   1.667812887486961e-09,  -1.607065592904496e-11,
   1.202825416110064e-13,   4.056409571290039e-16,  -5.360098984296695e-17,   1.730841544610224e-18,   1.555211738288926e-01,  -1.587101982550163e-03,   1.619442981152629e-05,
  -1.650450761132571e-07,   1.667825513171799e-09,  -1.607059540971029e-11,   1.202719999405347e-13,   4.060782105220266e-16,  -5.361302643679212e-17,   1.731052591213996e-18,
   2.646461682359013e-01,  -2.700176350325626e-03,   2.754349037102889e-05,  -2.805863592269519e-07,   2.833198062909354e-09,  -2.722636898114914e-11,   2.001502242425261e-13,
   8.847306534982024e-16,  -9.888498149713709e-17,   3.205129390481680e-18,   2.646500927465374e-01,  -2.700296275616572e-03,   2.754591187142810e-05,  -2.806250795326960e-07,
   2.833620496834394e-09,  -2.722345853050760e-11,   1.997465717896092e-13,   9.013771945922928e-16,  -9.934913595782632e-17,   3.213587471016344e-18,   2.646565357155439e-01,
  -2.700493164338623e-03,   2.754988741551924e-05,  -2.806886420781259e-07,   2.834313362594462e-09,  -2.721864445087301e-11,   1.990825733350900e-13,   9.287363174563267e-16,
  -1.001112668968838e-16,   3.227447870171987e-18,   2.646633725429645e-01,  -2.700702094728760e-03,   2.755410612725970e-05,  -2.807560826140179e-07,   2.835047692219540e-09,
  -2.721348723512161e-11,   1.983762014815243e-13,   9.578087207571855e-16,  -1.009201420928165e-16,   3.242120846103006e-18,   2.646687534077813e-01,  -2.700866535800899e-03,
   2.755742653040468e-05,  -2.808091555860942e-07,   2.835624993922162e-09,  -2.720939289674632e-11,   1.978189665384292e-13,   9.807194116440804e-16,  -1.015568698739980e-16,
   3.253643855094783e-18,   2.646718589085846e-01,  -2.700961442671945e-03,   2.755934290208444e-05,  -2.808397837945524e-07,   2.835957917375049e-09,  -2.720701570126400e-11,
   1.974968475484647e-13,   9.939538547152080e-16,  -1.019243926564968e-16,   3.260284075415024e-18,   2.646730250736348e-01,  -2.700997082036515e-03,   2.756006253799711e-05,
  -2.808512847560978e-07,   2.836082886410027e-09,  -2.720612034189089e-11,   1.973757888967493e-13,   9.989258307149265e-16,  -1.020624113543526e-16,   3.262775662778085e-18,
   2.646732183831663e-01,  -2.701002989818318e-03,   2.756018182896785e-05,  -2.808531911926680e-07,   2.836103599334345e-09,  -2.720597178085579e-11,   1.973557164290588e-13,
   9.997501287827723e-16,  -1.020852904666264e-16,   3.263188579701189e-18,   4.120159564051764e-01,  -4.203782087368833e-03,   4.288064780070613e-05,  -4.367663054642156e-07,
   4.405486138073467e-09,  -4.204383902833064e-11,   2.938623572144804e-13,   2.135678711731470e-15,  -1.810760378110206e-16,   5.802393670051317e-18,   4.120220662079435e-01,
  -4.203968763691598e-03,   4.288441289868508e-05,  -4.368260785294130e-07,   4.406104613040296e-09,  -4.203697379181102e-11,   2.931231324146471e-13,   2.165839630436401e-15,
  -1.819289634243222e-16,   5.818628217237338e-18,   4.120320968261389e-01,  -4.204275241527127e-03,   4.289059429542769e-05,  -4.369241984295256e-07,   4.407118789859911e-09,
  -4.202563796421219e-11,   2.919071162756313e-13,   2.215413478476876e-15,  -1.833296191859221e-16,   5.845240575894938e-18,   4.120427406148694e-01,  -4.204600463259134e-03,
   4.289715374993341e-05,  -4.370283013231584e-07,   4.408193344906174e-09,  -4.201352077797087e-11,   2.906134864972329e-13,   2.268096380880188e-15,  -1.848164157201620e-16,
   5.873424734671855e-18,   4.120511177145407e-01,  -4.204856432615737e-03,   4.290231644753535e-05,  -4.371102236477066e-07,   4.409037890671531e-09,  -4.200391999671320e-11,
   2.895929723429245e-13,   2.309616842516915e-15,  -1.859869567406573e-16,   5.895566820695894e-18,   4.120559524557058e-01,  -4.205004164809715e-03,   4.290529609046543e-05,
  -4.371574997275149e-07,   4.409524839162066e-09,  -4.199835332820287e-11,   2.890030431497052e-13,   2.333602637977493e-15,  -1.866626674103845e-16,   5.908329761282241e-18,
   4.120577679780345e-01,  -4.205059641092218e-03,   4.290641500420148e-05,  -4.371752518171429e-07,   4.409707607025526e-09,  -4.199625809696006e-11,   2.887813354125304e-13,
   2.342613986676881e-15,  -1.869164351620533e-16,   5.913119399731462e-18,   4.120580689283745e-01,  -4.205068837152636e-03,   4.290660048165579e-05,  -4.371781944511371e-07,
   4.409737898869316e-09,  -4.199591052427010e-11,   2.887445745028382e-13,   2.344107981089419e-15,  -1.869585024658455e-16,   5.913913193869722e-18,   6.111922289256896e-01,
  -6.235960807812592e-03,   6.360844917821978e-05,  -6.477385633621814e-07,   6.521285195581687e-09,  -6.147258578909151e-11,   3.890057286071536e-13,   5.207327825018086e-15,
  -3.431030247954432e-16,   1.089994507000520e-17,   6.112012920820475e-01,  -6.236237650217294e-03,   6.361402194070974e-05,  -6.478259034729267e-07,   6.522098875259559e-09,
  -6.145611530211341e-11,   3.876043611095137e-13,   5.264072681192378e-15,  -3.447515239055972e-16,   1.093365511532267e-17,   6.112161712943918e-01,  -6.236692158760551e-03,
   6.362317102933866e-05,  -6.479692690834490e-07,   6.523432481798507e-09,  -6.142895317408685e-11,   3.852990335563245e-13,   5.357352971361544e-15,  -3.474592390924376e-16,
   1.098894256654035e-17,   6.112319600694179e-01,  -6.237174464054286e-03,   6.363287959438602e-05,  -6.481213674727260e-07,   6.524844574101750e-09,  -6.139996452674875e-11,
   3.828464367631225e-13,   5.456499563935512e-15,  -3.503342772978292e-16,   1.104753430749937e-17,   6.112443864836494e-01,  -6.237554067353361e-03,   6.364052077416261e-05,
  -6.482410525595817e-07,   6.525953746576894e-09,  -6.137702889647629e-11,   3.809115468085370e-13,   5.534650724247223e-15,  -3.525983464518364e-16,   1.109359347520891e-17,
   6.112515582369112e-01,  -6.237773154461377e-03,   6.364493084388040e-05,  -6.483101182730177e-07,   6.526593008192779e-09,  -6.136374358946165e-11,   3.797930060666388e-13,
   5.579802270787303e-15,  -3.539055432109610e-16,   1.112015383008873e-17,   6.112542513444104e-01,  -6.237855425856451e-03,   6.364658690583192e-05,  -6.483360518306520e-07,
   6.526832893949582e-09,  -6.135874561403068e-11,   3.793726278814217e-13,   5.596766380524054e-15,  -3.543965137839420e-16,   1.113012346999537e-17,   6.112546977677866e-01,
  -6.237869063623698e-03,   6.364686142375198e-05,  -6.483403506201639e-07,   6.526872649827661e-09,  -6.135791664205519e-11,   3.793029254497748e-13,   5.599578912694214e-15,
  -3.544779047257945e-16,   1.113177586719774e-17,   8.974120182619728e-01,  -9.156219173068093e-03,   9.339146436393213e-05,  -9.505428369113026e-07,   9.530649192258551e-09,
  -8.731941073930285e-11,   4.128627716372560e-13,   1.476146100486504e-14,  -7.747223630886847e-16,   2.480267058057702e-17,   8.974253249277531e-01,  -9.156625418296640e-03,
   9.339960681247195e-05,  -9.506667069546743e-07,   9.531492712229324e-09,  -8.727322052166559e-11,   4.096923596907363e-13,   1.489106591672375e-14,  -7.787372568975699e-16,
   2.489723639785249e-17,   8.974471708121321e-01,  -9.157292373736884e-03,   9.341297446842840e-05,  -9.508700113059111e-07,   9.532872550756538e-09,  -8.719711019891476e-11,
   4.044760134316564e-13,   1.510418358456955e-14,  -7.853351207707241e-16,   2.505248943304310e-17,   8.974703521241972e-01,  -9.158000116851027e-03,   9.342715927455986e-05,
  -9.510856670342345e-07,   9.534329947730008e-09,  -8.711596812175011e-11,   3.989252881349402e-13,   1.533079390793214e-14,  -7.923451453059359e-16,   2.521723485669442e-17,
   8.974885967642708e-01,  -9.158557151931814e-03,   9.343832328978860e-05,  -9.512553413855300e-07,   9.535472054775042e-09,  -8.705183114774406e-11,   3.945454055100360e-13,
   1.550948207495131e-14,  -7.978687073984021e-16,   2.534689691772439e-17,   8.974991264337986e-01,  -9.158878642811610e-03,   9.344476646057592e-05,  -9.513532445533972e-07,
   9.536129231576636e-09,  -8.701470500908911e-11,   3.920131040710501e-13,   1.561274466678201e-14,  -8.010591193537975e-16,   2.542172983535410e-17,   8.975030804919718e-01,
  -9.158999368676727e-03,   9.344718597289327e-05,  -9.513900045291007e-07,   9.536375638084799e-09,  -8.700074269930403e-11,   3.910613326584969e-13,   1.565154691020878e-14,
  -8.022576523815568e-16,   2.544983076902498e-17,   8.975037359370118e-01,  -9.159019380866882e-03,   9.344758704367540e-05,  -9.513960978292396e-07,   9.536416463968397e-09,
  -8.699842713446187e-11,   3.909035171751180e-13,   1.565798031506790e-14,  -8.024563528378470e-16,   2.545448892300838e-17,   2.933301970271325e-03,  -2.875513723988244e-05,
   2.818501459780990e-07,  -2.761377904984113e-09,   2.697857016979470e-11,  -2.593379724521668e-13,   2.296657344899325e-15,  -1.273665742810752e-17,  -1.987799400988536e-19,
   1.079259115299642e-20,   2.933342125997641e-03,  -2.875631743798175e-05,   2.818732091855776e-07,  -2.761747274848894e-09,   2.698346268960411e-11,  -2.593751286905524e-13,
   2.295824774939456e-15,  -1.268008269227295e-17,  -2.007287166946622e-19,   1.084038853443051e-20,   2.933408050499937e-03,  -2.875825503827626e-05,   2.819110741905925e-07,
  -2.762353693118458e-09,   2.699149324675788e-11,  -2.594360036325202e-13,   2.294452343659958e-15,  -1.258702903865522e-17,  -2.039315027284969e-19,   1.091886614573569e-20,
   2.933478004725383e-03,  -2.876031113704275e-05,   2.819512559880106e-07,  -2.762997201155523e-09,   2.700001250894331e-11,  -2.595004292230389e-13,   2.292988426718820e-15,
  -1.248805124836890e-17,  -2.073347296019112e-19,   1.100215079799823e-20,   2.933533061409640e-03,  -2.876192940988089e-05,   2.819828822423561e-07,  -2.763503682511480e-09,
   2.700671592079719e-11,  -2.595510111136127e-13,   2.291830765004762e-15,  -1.240998093872595e-17,  -2.100165740364728e-19,   1.106770596856546e-20,   2.933564836637265e-03,
  -2.876286339179937e-05,   2.820011355620363e-07,  -2.763795997679209e-09,   2.701058407162097e-11,  -2.595801541991227e-13,   2.291160429071062e-15,  -1.236485517596230e-17,
  -2.115657149346975e-19,   1.110554293015546e-20,   2.933576768728607e-03,  -2.876321411980652e-05,   2.820079900899691e-07,  -2.763905767740498e-09,   2.701203650243070e-11,
  -2.595910885038483e-13,   2.290908290216179e-15,  -1.234789679838082e-17,  -2.121476964049729e-19,   1.111975178980412e-20,   2.933578746652899e-03,  -2.876327225844285e-05,
   2.820091263379515e-07,  -2.763923963847519e-09,   2.701227725843839e-11,  -2.595929005351469e-13,   2.290866472375656e-15,  -1.234508500792471e-17,  -2.122441820681457e-19,
   1.112210714853250e-20,   2.656138624354758e-02,  -2.603810633749670e-04,   2.552184227227713e-06,  -2.500445757953923e-08,   2.442827482159975e-10,  -2.347601105052857e-12,
   2.075772789230525e-14,  -1.136280938178559e-16,  -1.863127656292738e-18,   9.971163981535290e-20,   2.656174985806795e-02,  -2.603917501421728e-04,   2.552393057081200e-06,
  -2.500780117697056e-08,   2.443269647056893e-10,  -2.347932300526717e-12,   2.074993010213623e-14,  -1.131053964739115e-16,  -1.881117116083949e-18,   1.001535670530626e-19,
   2.656234681168918e-02,  -2.604092952330313e-04,   2.552735912351561e-06,  -2.501329057060912e-08,   2.443995410012008e-10,  -2.348474874747596e-12,   2.073707676767667e-14,
  -1.122456669645068e-16,  -1.910682755444827e-18,   1.008791690471870e-19,   2.656298025489538e-02,  -2.604279133344403e-04,   2.553099745349820e-06,  -2.501911569935484e-08,
   2.444765333966944e-10,  -2.349049041044192e-12,   2.072336766181784e-14,  -1.113312021691521e-16,  -1.942099013490518e-18,   1.016492305267978e-19,   2.656347879922632e-02,
  -2.604425668946714e-04,   2.553386110659296e-06,  -2.502370043726804e-08,   2.445371147171219e-10,  -2.349499791419450e-12,   2.071252727592588e-14,  -1.106099022033977e-16,
  -1.966856183788911e-18,   1.022553726940407e-19,   2.656376652740657e-02,  -2.604510241583391e-04,   2.553551388432056e-06,  -2.502634651167652e-08,   2.445720725202902e-10,
  -2.349759478212158e-12,   2.070625052122358e-14,  -1.101929799217631e-16,  -1.981157006701214e-18,   1.026052282326451e-19,   2.656387457380569e-02,  -2.604542000219715e-04,
   2.553613453911530e-06,  -2.502734016395455e-08,   2.445851986027628e-10,  -2.349856908058575e-12,   2.070388965051053e-14,  -1.100362993586772e-16,  -1.986529558595964e-18,
   1.027366097337167e-19,   2.656389248412764e-02,  -2.604547264708907e-04,   2.553623742260355e-06,  -2.502750487736227e-08,   2.445873743902367e-10,  -2.349873053957939e-12,
   2.070349809730605e-14,  -1.100103208711625e-16,  -1.987420265212679e-18,   1.027583884787432e-19,   7.471764810472205e-02,  -7.324564834196460e-04,   7.179332016732513e-06,
  -7.033716679411524e-08,   6.871042339950405e-10,  -6.599457283604051e-12,   5.815983247289850e-14,  -3.094220563342671e-16,  -5.620490112807047e-18,   2.924411937577993e-19,
   7.471867095763067e-02,  -7.324865451139792e-04,   7.179919398285320e-06,  -7.034656588384640e-08,   6.872281019468048e-10,  -6.600357407731183e-12,   5.813634191895681e-14,
  -3.078889858710253e-16,  -5.673169563192009e-18,   2.937397635994161e-19,   7.472035019680066e-02,  -7.325358991540290e-04,   7.180883756550780e-06,  -7.036199692683947e-08,
   6.874314144153509e-10,  -6.601831773027591e-12,   5.809762609089628e-14,  -3.053673912533281e-16,  -5.759749530651516e-18,   2.958719531774277e-19,   7.472213208169187e-02,
  -7.325882715516050e-04,   7.181907119008154e-06,  -7.037837169924315e-08,   6.876470944862317e-10,  -6.603391651465761e-12,   5.805633848540502e-14,  -3.026852447095249e-16,
  -5.851750754228511e-18,   2.981348730336656e-19,   7.472353449409135e-02,  -7.326294917613360e-04,   7.182712585788114e-06,  -7.039125962977573e-08,   6.878167994079174e-10,
  -6.604615994519897e-12,   5.802369484079439e-14,  -3.005696457447861e-16,  -5.924252495415333e-18,   2.999161580095991e-19,   7.472434387761318e-02,  -7.326532818959381e-04,
   7.183177466537374e-06,  -7.039869786621895e-08,   6.879147248012640e-10,  -6.605321266774515e-12,   5.800479535477591e-14,  -2.993467937896280e-16,  -5.966133222821360e-18,
   3.009443120480692e-19,   7.472464781369208e-02,  -7.326622155445707e-04,   7.183352039574093e-06,  -7.040149106590050e-08,   6.879514939899833e-10,  -6.605585853837390e-12,
   5.799768702657576e-14,  -2.988872418770348e-16,  -5.981867134333150e-18,   3.013304201842085e-19,   7.472469819568597e-02,  -7.326636964361284e-04,   7.183380977854032e-06,
  -7.040195408231126e-08,   6.879575888630794e-10,  -6.605629699754168e-12,   5.799650811879524e-14,  -2.988110456384751e-16,  -5.984475639400565e-18,   3.013944245018844e-19,
   1.494058455056267e-01,  -1.464624124417112e-03,   1.435581024013714e-05,  -1.406439088578635e-07,   1.373713228462531e-09,  -1.318168290212691e-11,   1.155205621340098e-13,
  -5.844339068630065e-16,  -1.251747503567550e-17,   6.252318683699866e-19,   1.494078908044574e-01,  -1.464684234726795e-03,   1.435698457033590e-05,  -1.406626816153848e-07,
   1.373959196218855e-09,  -1.318337692162696e-11,   1.154683479871394e-13,  -5.811559391014077e-16,  -1.262988647506118e-17,   6.280192051740204e-19,   1.494112486146170e-01,
  -1.464782921327568e-03,   1.435891257506898e-05,  -1.406935018564537e-07,   1.374362910303795e-09,  -1.318615079963586e-11,   1.153823050344079e-13,  -5.757642954304556e-16,
  -1.281464249161673e-17,   6.325961042499370e-19,   1.494148116753455e-01,  -1.464887643320524e-03,   1.436095854319818e-05,  -1.407262068498739e-07,   1.374791170709273e-09,
  -1.318908439717290e-11,   1.152905647959330e-13,  -5.700293046226072e-16,  -1.301097400523815e-17,   6.374539320713466e-19,   1.494176159420698e-01,  -1.464970065786580e-03,
   1.436256888006623e-05,  -1.407519475394487e-07,   1.375128132995552e-09,  -1.319138612010694e-11,   1.152180444484917e-13,  -5.655056696687296e-16,  -1.316569842704219e-17,
   6.412780529906008e-19,   1.494192343870193e-01,  -1.465017635691327e-03,   1.436349829676148e-05,  -1.407668036702936e-07,   1.375322568018503e-09,  -1.319271166677206e-11,
   1.151760630591900e-13,  -5.628909155072726e-16,  -1.325507719964439e-17,   6.434854170532874e-19,   1.494198421382241e-01,  -1.465035499096031e-03,   1.436384731327447e-05,
  -1.407723824227147e-07,   1.375395574151408e-09,  -1.319320888883754e-11,   1.151602743358170e-13,  -5.619082788566370e-16,  -1.328865573706762e-17,   6.443143770744192e-19,
   1.494199428821621e-01,  -1.465038460233866e-03,   1.436390516835345e-05,  -1.407733071875078e-07,   1.375407675638195e-09,  -1.319329128233779e-11,   1.151576558470384e-13,
  -5.617453521197562e-16,  -1.329422269984225e-17,   6.444517928908998e-19,   2.542658696644556e-01,  -2.492565611251492e-03,   2.443132725221210e-05,  -2.393472359467560e-07,
   2.337252503220431e-09,  -2.239412403917677e-11,   1.945154083651921e-13,  -9.021141851441622e-16,  -2.477432359502744e-17,   1.174758566277828e-18,   2.542693504397580e-01,
  -2.492667906531533e-03,   2.443332524635472e-05,  -2.393791262679002e-07,   2.337666486762513e-09,  -2.239672123763473e-11,   1.944123083029051e-13,  -8.959540170034075e-16,
  -2.498519504850484e-17,   1.180037541913434e-18,   2.542750649018101e-01,  -2.492835850640016e-03,   2.443660553229117e-05,  -2.394314820229371e-07,   2.338345946356732e-09,
  -2.240097156088552e-11,   1.942424431498695e-13,  -8.858215365682273e-16,  -2.533179218161219e-17,   1.188706465926916e-18,   2.542811286678021e-01,  -2.493014065708386e-03,
   2.444008651598680e-05,  -2.394870390948503e-07,   2.339066685641855e-09,  -2.240546324958316e-11,   1.940613737778069e-13,  -8.750435925749640e-16,  -2.570012536339371e-17,
   1.197908400354748e-18,   2.542859010863163e-01,  -2.493154331598374e-03,   2.444282631949317e-05,  -2.395307653807616e-07,   2.339633751655794e-09,  -2.240898501287864e-11,
   1.939182702641674e-13,  -8.665420314260223e-16,  -2.599041544240422e-17,   1.205152899889561e-18,   2.542886554236655e-01,  -2.493235285672562e-03,   2.444440761428985e-05,
  -2.395560017069782e-07,   2.339960952434949e-09,  -2.241101218636841e-11,   1.938354413605733e-13,  -8.616278915129077e-16,  -2.615811168646415e-17,   1.209334845542444e-18,
   2.542896897200967e-01,  -2.493265685466979e-03,   2.444500142522643e-05,  -2.395654783931643e-07,   2.340083807448454e-09,  -2.241177240675959e-11,   1.938042926990539e-13,
  -8.597811232754524e-16,  -2.622111430345155e-17,   1.210905396122059e-18,   2.542898611703456e-01,  -2.493270724706791e-03,   2.444509985889200e-05,  -2.395670492998147e-07,
   2.340104171785016e-09,  -2.241189837121908e-11,   1.937991269572670e-13,  -8.594749179892503e-16,  -2.623155952446966e-17,   1.211165747270067e-18,   3.958553348432410e-01,
  -3.880564751747863e-03,   3.803590307590896e-05,  -3.726116462332452e-07,   3.637295829888064e-09,  -3.476761681969745e-11,   2.976358322621065e-13,  -1.171748233330764e-15,
  -4.739028509041160e-17,   2.113660522759738e-18,   3.958607538843918e-01,  -3.880724002773167e-03,   3.803901234462391e-05,  -3.726611510074522e-07,   3.637928818157521e-09,
  -3.477094082500431e-11,   2.974391100890338e-13,  -1.160660496346051e-15,  -4.776976757110450e-17,   2.123312326930497e-18,   3.958696504381248e-01,  -3.880985454394874e-03,
   3.804411710247631e-05,  -3.727424244533444e-07,   3.638967663147511e-09,  -3.477637359910130e-11,   2.971150613065182e-13,  -1.142422390643594e-15,  -4.839354591348963e-17,
   2.139164102594895e-18,   3.958790908051009e-01,  -3.881262895555218e-03,   3.804953417512322e-05,  -3.728286663965812e-07,   3.640069538854439e-09,  -3.478210537052442e-11,
   2.967697276477742e-13,  -1.123021694219796e-15,  -4.905650444616629e-17,   2.155993204474768e-18,   3.958865207391268e-01,  -3.881481258254252e-03,   3.805379782344049e-05,
  -3.728965425323557e-07,   3.640936416639709e-09,  -3.478659250742217e-11,   2.964968663853721e-13,  -1.107718004770858e-15,  -4.957903860347505e-17,   2.169244362283730e-18,
   3.958908088258599e-01,  -3.881607285669972e-03,   3.805625861202839e-05,  -3.729357164861346e-07,   3.641436586586234e-09,  -3.478917257170638e-11,   2.963389588273297e-13,
  -1.098871817155419e-15,  -4.988091663079737e-17,   2.176894479023469e-18,   3.958924190689826e-01,  -3.881654611357940e-03,   3.805718269167412e-05,  -3.729504269422272e-07,
   3.641624382253713e-09,  -3.479013960510891e-11,   2.962795809020909e-13,  -1.095547314765307e-15,  -4.999433402908543e-17,   2.179767665990953e-18,   3.958926859910905e-01,
  -3.881662456328280e-03,   3.805733587263550e-05,  -3.729528654239019e-07,   3.641655510853220e-09,  -3.479029980941001e-11,   2.962697338307155e-13,  -1.094996089992062e-15,
  -5.001313770849677e-17,   2.180243963764075e-18,   5.872192780932444e-01,  -5.756500848855180e-03,   5.642279164088651e-05,  -5.526950763210639e-07,   5.391903262094149e-09,
  -5.132669272807569e-11,   4.280349067466385e-13,  -1.126028903808902e-15,  -9.388455832615512e-17,   3.912293655926307e-18,   5.872273167396460e-01,  -5.756737064708277e-03,
   5.642740063371377e-05,  -5.527681433044435e-07,   5.392812310213774e-09,  -5.132972857167818e-11,   4.276461185150024e-13,  -1.105488934026497e-15,  -9.459115579107065e-17,
   3.930787073968745e-18,   5.872405139539986e-01,  -5.757124873824737e-03,   5.643496760112375e-05,  -5.528880975713852e-07,   5.394304052171520e-09,  -5.133466770959340e-11,
   4.270058152889116e-13,  -1.071700621882298e-15,  -9.575278533916205e-17,   3.961166603919183e-18,   5.872545178644808e-01,  -5.757536399939247e-03,   5.644299749896976e-05,
  -5.530153823563552e-07,   5.395886078096210e-09,  -5.133984769649881e-11,   4.263236229402746e-13,  -1.035755300860010e-15,  -9.698758564473547e-17,   3.993428148135771e-18,
   5.872655394834290e-01,  -5.757860295359855e-03,   5.644931762130162e-05,  -5.531155590538117e-07,   5.397130540249510e-09,  -5.134388027374944e-11,   4.257847183219494e-13,
  -1.007398554008664e-15,  -9.796098754829339e-17,   4.018837262966960e-18,   5.872719004627773e-01,  -5.758047230642132e-03,   5.645296530811318e-05,  -5.531733741418387e-07,
   5.397848502507023e-09,  -5.134618985447335e-11,   4.254728972851533e-13,  -9.910062171849930e-16,  -9.852340091615584e-17,   4.033508991354492e-18,   5.872742891092224e-01,
  -5.758117428381983e-03,   5.645433509247777e-05,  -5.531950845002077e-07,   5.398118058833729e-09,  -5.134705377729045e-11,   4.253556524633769e-13,  -9.848456076103976e-16,
  -9.873471443315089e-17,   4.039019810221819e-18,   5.872746850634312e-01,  -5.758129064750918e-03,   5.645456215604241e-05,  -5.531986833143410e-07,   5.398162739244208e-09,
  -5.134719680819525e-11,   4.253362093867025e-13,  -9.838241280435484e-16,  -9.876974909288005e-17,   4.039933383157389e-18,   8.622126535758650e-01,  -8.452249880381331e-03,
   8.284428845091819e-05,  -8.113859739000712e-07,   7.905304767429035e-09,  -7.457452208321753e-11,   5.846776726260765e-13,   3.892182094794361e-16,  -2.191037270984670e-16,
   8.528421978024719e-18,   8.622244565147830e-01,  -8.452596653803957e-03,   8.285104535314684e-05,  -8.114920823653502e-07,   7.906542017154596e-09,  -7.457263933682475e-11,
   5.837717192990550e-13,   4.340970236072033e-16,  -2.206854482564637e-16,   8.572559356178227e-18,   8.622438336459330e-01,  -8.453165971254804e-03,   8.286213866213771e-05,
  -8.116662743513209e-07,   7.908571747524554e-09,  -7.456945078980500e-11,   5.822798692169023e-13,   5.079369169782547e-16,  -2.232865649191653e-16,   8.645100040448057e-18,
   8.622643952267324e-01,  -8.453770105591226e-03,   8.287391055342295e-05,  -8.118511024223521e-07,   7.910723520919583e-09,  -7.456593449758274e-11,   5.806906678130961e-13,
   5.865098850383709e-16,  -2.260526203972839e-16,   8.722182661183634e-18,   8.622805779845996e-01,  -8.454245594722375e-03,   8.288317584132203e-05,  -8.119965608053538e-07,
   7.912415579328237e-09,  -7.456307070968952e-11,   5.794354394086637e-13,   6.485089100713828e-16,  -2.282339158194805e-16,   8.782927594226467e-18,   8.622899176454983e-01,
  -8.454520021718752e-03,   8.288852331969625e-05,  -8.120805067541503e-07,   7.913391537699671e-09,  -7.456137925019379e-11,   5.787092094615909e-13,   6.843546146753443e-16,
  -2.294945460869018e-16,   8.818016915939168e-18,   8.622934248329972e-01,  -8.454623074226945e-03,   8.289053140760390e-05,  -8.121120291154829e-07,   7.913757913499820e-09,
  -7.456073676742878e-11,   5.784361599839457e-13,   6.978272965746170e-16,  -2.299682583527941e-16,   8.831199393063013e-18,   8.622940062022673e-01,  -8.454640156784083e-03,
   8.289086427990363e-05,  -8.121172543886883e-07,   7.913818639923592e-09,  -7.456062988025109e-11,   5.783908800292494e-13,   7.000612335170703e-16,  -2.300468005127135e-16,
   8.833384898391521e-18,   2.822591022713854e-03,  -2.662591941760163e-05,   2.511417380131809e-07,  -2.368350320861919e-09,   2.231166740501550e-11,  -2.089284898539626e-13,
   1.895587788842049e-15,  -1.473997946536409e-17,   2.811334498117752e-20,   3.043938727814643e-21,   2.822626800385088e-03,  -2.662693157033669e-05,   2.511608116310550e-07,
  -2.368648010932637e-09,   2.231571487401623e-11,  -2.089722798446549e-13,   1.895684595938816e-15,  -1.472379865598990e-17,   2.738238037952284e-20,   3.065742506241360e-21,
   2.822685537190071e-03,  -2.662859327485584e-05,   2.511921265608783e-07,  -2.369136762309639e-09,   2.232235959085821e-11,  -2.090441328698047e-13,   1.895841402228324e-15,
  -1.469715417722983e-17,   2.618011297797857e-20,   3.101579849812753e-21,   2.822747864154029e-03,  -2.663035659682731e-05,   2.512253575184957e-07,  -2.369655426364860e-09,
   2.232941033942614e-11,  -2.091203263679449e-13,   1.896004903367200e-15,  -1.466877206913829e-17,   2.490132770899982e-20,   3.139664295430242e-21,   2.822796917738569e-03,
  -2.663174443103007e-05,   2.512515129162184e-07,  -2.370063661902630e-09,   2.233495945207284e-11,  -2.091802561390100e-13,   1.896131489817637e-15,  -1.464635530344316e-17,
   2.389268174964495e-20,   3.169679078690571e-21,   2.822825228297668e-03,  -2.663254541358409e-05,   2.512666086935872e-07,  -2.370299280327041e-09,   2.233816200772984e-11,
  -2.092148287622002e-13,   1.896203706704928e-15,  -1.463338610022632e-17,   2.330967631312133e-20,   3.187018064989395e-21,   2.822835859340852e-03,  -2.663284619735886e-05,
   2.512722774944456e-07,  -2.370387760735658e-09,   2.233936460942109e-11,  -2.092278084731713e-13,   1.896230666243772e-15,  -1.462850997510530e-17,   2.309058258015077e-20,
   3.193532212881492e-21,   2.822837621596170e-03,  -2.663289605693683e-05,   2.512732171891605e-07,  -2.370402427806444e-09,   2.233956395840172e-11,  -2.092299599060325e-13,
   1.896235126802585e-15,  -1.462770136779489e-17,   2.305425572115487e-20,   3.194612194167389e-21,   2.555888591343130e-02,  -2.411007568433651e-04,   2.274116975790166e-06,
  -2.144564879490359e-08,   2.020317020898231e-10,  -1.891670105458301e-12,   1.715375488624933e-14,  -1.329682572195694e-16,   2.349540300171492e-19,   2.821800836918917e-20,
   2.555920988430446e-02,  -2.411099219864666e-04,   2.274289686882508e-06,  -2.144834411289139e-08,   2.020683279211528e-10,  -1.892065067424427e-12,   1.715455075267151e-14,
  -1.328182841205511e-16,   2.282114837095522e-19,   2.841913913242280e-20,   2.555974175273887e-02,  -2.411249688851091e-04,   2.274573242707366e-06,  -2.145276931895648e-08,
   2.021284563055768e-10,  -1.892713133955478e-12,   1.715583775708087e-14,  -1.325713312289621e-16,   2.171215189997571e-19,   2.874972627430784e-20,   2.556030613046980e-02,
  -2.411409359396967e-04,   2.274874148090492e-06,  -2.145746535538053e-08,   2.021922587216592e-10,  -1.893400336701926e-12,   1.715717677960094e-14,  -1.323082780192014e-16,
   2.053256853094235e-19,   2.910104568676314e-20,   2.556075031624366e-02,  -2.411535029153645e-04,   2.275110984463638e-06,  -2.146116155935691e-08,   2.022424726697812e-10,
  -1.893940845308829e-12,   1.715821132031494e-14,  -1.321005167124760e-16,   1.960216459147099e-19,   2.937792705617513e-20,   2.556100667156844e-02,  -2.411607558914006e-04,
   2.275247676287006e-06,  -2.146329487069346e-08,   2.022714525623471e-10,  -1.894252653463586e-12,   1.715880063819037e-14,  -1.319803179451272e-16,   1.906438214367801e-19,
   2.953787733935881e-20,   2.556110293687065e-02,  -2.411634795181436e-04,   2.275299007112153e-06,  -2.146409598050151e-08,   2.022823348830575e-10,  -1.894369715940400e-12,
   1.715902046974084e-14,  -1.319351262060549e-16,   1.886228294374101e-19,   2.959796984696619e-20,   2.556111889429249e-02,  -2.411639310015387e-04,   2.275307516020115e-06,
  -2.146422877751150e-08,   2.022841387878421e-10,  -1.894389119423853e-12,   1.715905683275309e-14,  -1.319276320785047e-16,   1.882877384981311e-19,   2.960793260056655e-20,
   7.189759708286797e-02,  -6.782206731219472e-04,   6.397129350601510e-06,  -6.032677792590326e-08,   5.683008199824682e-10,  -5.320100457293836e-12,   4.818806090487557e-14,
  -3.710277246529447e-16,   5.433902004829671e-19,   8.330972640054896e-20,   7.189850841835786e-02,  -6.782464547349919e-04,   6.397615173817579e-06,  -6.033435811478125e-08,
   5.684037029626523e-10,  -5.321202151360349e-12,   4.818981584871095e-14,  -3.705851029046052e-16,   5.236791276078903e-19,   8.389783860799862e-20,   7.190000457316628e-02,
  -6.782887817678465e-04,   6.398412794777349e-06,  -6.034680335218992e-08,   5.685726045188012e-10,  -5.323009794124064e-12,   4.819263975115037e-14,  -3.698562810236711e-16,
   4.912586196520713e-19,   8.486450123838396e-20,   7.190159217716754e-02,  -6.783336972051511e-04,   6.399259218601954e-06,  -6.036001024701084e-08,   5.687518254648926e-10,
  -5.324926526861253e-12,   4.819555839865495e-14,  -3.690799704332105e-16,   4.567742292158266e-19,   8.589180870113981e-20,   7.190284167918053e-02,  -6.783690481958896e-04,
   6.399925421113664e-06,  -6.037040525436822e-08,   5.688928756720971e-10,  -5.326434050771901e-12,   4.819779903326976e-14,  -3.684668545972622e-16,   4.295741995687126e-19,
   8.670146482696936e-20,   7.190356281099718e-02,  -6.783894508681520e-04,   6.400309924669419e-06,  -6.037640486188000e-08,   5.689742794466163e-10,  -5.327303688884105e-12,
   4.819906953165862e-14,  -3.681121488793998e-16,   4.138522214404378e-19,   8.716919764417318e-20,   7.190383360690238e-02,  -6.783971124491663e-04,   6.400454314314532e-06,
  -6.037865785834711e-08,   5.690048475499276e-10,  -5.327630174093034e-12,   4.819954233883285e-14,  -3.679787898667812e-16,   4.079438671180613e-19,   8.734492369713254e-20,
   7.190387849539694e-02,  -6.783983824751018e-04,   6.400478249214842e-06,  -6.037903132920124e-08,   5.690099146598715e-10,  -5.327684289860365e-12,   4.819962048765348e-14,
  -3.679566750750247e-16,   4.069642303885128e-19,   8.737405743249199e-20,   1.437668553206681e-01,  -1.356173987723410e-03,   1.279173118661953e-05,  -1.206290807417846e-07,
   1.136318195598691e-09,  -1.063411197607000e-11,   9.613801189130447e-14,  -7.318361031607660e-16,   6.925021576109801e-19,   1.798196152274801e-19,   1.437686776314712e-01,
  -1.356225540468921e-03,   1.279270258803513e-05,  -1.206442321862198e-07,   1.136523433928834e-09,  -1.063628370674388e-11,   9.613989848509480e-14,  -7.308811946933457e-16,
   6.505704644021177e-19,   1.810716070330223e-19,   1.437716693497740e-01,  -1.356310177326243e-03,   1.279429742738852e-05,  -1.206691079625147e-07,   1.136860368318224e-09,
  -1.063984686961641e-11,   9.614287411227142e-14,  -7.293089024577109e-16,   5.816008366798632e-19,   1.831295270796202e-19,   1.437748439303117e-01,  -1.356399989937584e-03,
   1.279598984743206e-05,  -1.206955061109099e-07,   1.137217884980158e-09,  -1.064362482226274e-11,   9.614586611470989e-14,  -7.276342464902827e-16,   5.082393337303550e-19,
   1.853166325782477e-19,   1.437773424404943e-01,  -1.356470677542989e-03,   1.279732191559972e-05,  -1.207162837832477e-07,   1.137499254732090e-09,  -1.064659603130245e-11,
   9.614810094091284e-14,  -7.263116945127346e-16,   4.503735234417563e-19,   1.870404225799870e-19,   1.437787844191107e-01,  -1.356511474589684e-03,   1.279809072817353e-05,
  -1.207282758621405e-07,   1.137661639597227e-09,  -1.064830994713659e-11,   9.614934258865099e-14,  -7.255465830829071e-16,   4.169259427694449e-19,   1.880362673287389e-19,
   1.437793259038925e-01,  -1.356526794635583e-03,   1.279837943438801e-05,  -1.207327791729073e-07,   1.137722616891827e-09,  -1.064895338309216e-11,   9.614979973919746e-14,
  -7.252589280374839e-16,   4.043561967821075e-19,   1.884104080727444e-19,   1.437794156631400e-01,  -1.356529334170900e-03,   1.279842729207396e-05,  -1.207335256698771e-07,
   1.137732724759744e-09,  -1.064906003355243e-11,   9.614987503819335e-14,  -7.252112267287688e-16,   4.022720619677628e-19,   1.884724373371795e-19,   2.446691727105368e-01,
  -2.308000366696593e-03,   2.176955176166689e-05,  -2.052903843839342e-07,   1.933682206977459e-09,  -1.808702569308944e-11,   1.630278027964054e-13,  -1.218487944575041e-15,
   1.173892880006045e-19,   3.418782307698653e-19,   2.446722740019226e-01,  -2.308088100734061e-03,   2.177120479637741e-05,  -2.053161540219427e-07,   1.934030191646850e-09,
  -1.809063796571975e-11,   1.630266420749278e-13,  -1.216673515820425e-15,   3.915183805153382e-20,   3.442185875316321e-19,   2.446773654441489e-01,  -2.308232138318902e-03,
   2.177391873521792e-05,  -2.053584627579079e-07,   1.934601462155837e-09,  -1.809656413572002e-11,   1.630245098059633e-13,  -1.213686133605548e-15,  -8.953683675288936e-20,
   3.480656449351006e-19,   2.446827680896190e-01,  -2.308384984153006e-03,   2.177679872607263e-05,  -2.054033606295209e-07,   1.935207620534076e-09,  -1.810284686760051e-11,
   1.630219387263730e-13,  -1.210504450872343e-15,  -2.264243018738836e-19,   3.521544366504783e-19,   2.446870201678102e-01,  -2.308505282465309e-03,   2.177906550542029e-05,
  -2.054386991325686e-07,   1.935684667471831e-09,  -1.810778749813192e-11,   1.630196915439901e-13,  -1.207991869890797e-15,  -3.344008586990252e-19,   3.553772317024934e-19,
   2.446894741925545e-01,  -2.308574712115625e-03,   2.178037379285168e-05,  -2.054590951330818e-07,   1.935959979379094e-09,  -1.811063726162604e-11,   1.630183048670740e-13,
  -1.206538368387094e-15,  -3.968146355370193e-19,   3.572391301682364e-19,   2.446903957159643e-01,  -2.308600784233598e-03,   2.178086508380923e-05,  -2.054667543098595e-07,
   1.936063361503498e-09,  -1.811170707890137e-11,   1.630177671738074e-13,  -1.205991913254797e-15,  -4.202702299268268e-19,   3.579386619139611e-19,   2.446905484723308e-01,
  -2.308605106091673e-03,   2.178094652316267e-05,  -2.054680239425886e-07,   1.936080498557893e-09,  -1.811188440073858e-11,   1.630176771472628e-13,  -1.205901296151188e-15,
  -4.241593117694680e-19,   3.580546388472902e-19,   3.809146619447479e-01,  -3.593223932105535e-03,   3.389201808902968e-05,  -3.196030909877314e-07,   3.010080394059709e-09,
  -2.813285396292570e-11,   2.523670078960976e-13,  -1.829871265638007e-15,  -2.478815477005064e-18,   6.230469318326429e-19,   3.809194902025757e-01,  -3.593360519319883e-03,
   3.389459127959075e-05,  -3.196431717796154e-07,   3.010618943246259e-09,  -2.813826941156689e-11,   2.523542282083432e-13,  -1.826566623276235e-15,  -2.618256789793343e-18,
   6.272366637804963e-19,   3.809274168346162e-01,  -3.593584761723077e-03,   3.389881592078597e-05,  -3.197089764362011e-07,   3.011503037653043e-09,  -2.814715253550716e-11,
   2.523328440826291e-13,  -1.821125932604622e-15,  -2.847625962822612e-18,   6.341242139129367e-19,   3.809358279646101e-01,  -3.593822717078961e-03,   3.390329904343687e-05,
  -3.197788078018605e-07,   3.012441100937796e-09,  -2.815656839705428e-11,   2.523096038099484e-13,  -1.815331738183256e-15,  -3.091621216892862e-18,   6.414452405402333e-19,
   3.809424478293418e-01,  -3.594010001384345e-03,   3.390682761165658e-05,  -3.198337709089546e-07,   3.013179340252882e-09,  -2.816397160538092e-11,   2.522909147670737e-13,
  -1.810756311461406e-15,  -3.284093547761940e-18,   6.472161903466158e-19,   3.809462683874454e-01,  -3.594118091705816e-03,   3.390886414850620e-05,  -3.198654933785593e-07,
   3.013605383922401e-09,  -2.816824128113657e-11,   2.522799688994908e-13,  -1.808109579115251e-15,  -3.395352245256709e-18,   6.505504293027421e-19,   3.809477030647983e-01,
  -3.594158681620018e-03,   3.390962891312931e-05,  -3.198774058943410e-07,   3.013765365906546e-09,  -2.816984404559641e-11,   2.522758283430342e-13,  -1.807114539128376e-15,
  -3.437164861006052e-18,   6.518031703308729e-19,   3.809479408841494e-01,  -3.594165410028020e-03,   3.390975568511978e-05,  -3.198793805861294e-07,   3.013791885123045e-09,
  -2.817010969818024e-11,   2.522751403888869e-13,  -1.806949535498971e-15,  -3.444097687446880e-18,   6.520108670696988e-19,   5.650560066498631e-01,  -5.330255744999035e-03,
   5.027596496117829e-05,  -4.740941556271479e-07,   4.464247372422199e-09,  -4.166698827970289e-11,   3.706799327907290e-13,  -2.541088987046663e-15,  -1.064207609577402e-17,
   1.165599871088315e-18,   5.650631689634787e-01,  -5.330458355963205e-03,   5.027978121193338e-05,  -4.741535139995619e-07,   4.465038055210720e-09,  -4.167448303284783e-11,
   3.706322251194118e-13,  -2.534909350824374e-15,  -1.089681145614657e-17,   1.173335800782774e-18,   5.650749274540465e-01,  -5.330790992993038e-03,   5.028604669314614e-05,
  -4.742509680448478e-07,   4.466336012570104e-09,  -4.168677339932764e-11,   3.705531666563073e-13,  -2.524735688230402e-15,  -1.131586335605737e-17,   1.186054664063658e-18,
   5.650874046563630e-01,  -5.331143971520907e-03,   5.029269551615845e-05,  -4.743543847363516e-07,   4.467713141182712e-09,  -4.169979606819110e-11,   3.704682743267235e-13,
  -2.513901479441290e-15,  -1.176168273135404e-17,   1.199576286819104e-18,   5.650972246675656e-01,  -5.331421785528854e-03,   5.029792865496825e-05,  -4.744357817525722e-07,
   4.468796872509946e-09,  -4.171003165699774e-11,   3.704007347559511e-13,  -2.505346512049887e-15,  -1.211339462145538e-17,   1.210236638649319e-18,   5.651028921433593e-01,
  -5.331582124661735e-03,   5.030094899417285e-05,  -4.744827605813608e-07,   4.469422284372013e-09,  -4.171593346724086e-11,   3.703614638310159e-13,  -2.500397883663148e-15,
  -1.231671518686066e-17,   1.216396455122639e-18,   5.651050203662318e-01,  -5.331642334968330e-03,   5.030208319795560e-05,  -4.745004021691214e-07,   4.469657126927254e-09,
  -4.171814864374859e-11,   3.703466618770605e-13,  -2.498537470580628e-15,  -1.239312850581566e-17,   1.218710948334659e-18,   5.651053731511845e-01,  -5.331652315760643e-03,
   5.030227121038638e-05,  -4.745033265448958e-07,   4.469696055134870e-09,  -4.171851578755286e-11,   3.703442053213262e-13,  -2.498228966824867e-15,  -1.240579850634221e-17,
   1.219094683663998e-18,   8.296703897311593e-01,  -7.826400285147778e-03,   7.381979909690695e-05,  -6.960780865371223e-07,   6.551920291773240e-09,  -6.097630528660664e-11,
   5.326685152855940e-13,  -3.173413610841529e-15,  -3.860776668502180e-17,   2.532463011814949e-18,   8.296809060939446e-01,  -7.826697763079205e-03,   7.382539984529596e-05,
  -6.961649383506310e-07,   6.553055353135286e-09,  -6.098557330719227e-11,   5.325033551620240e-13,  -3.159981445408956e-15,  -3.915150700019871e-17,   2.549480293995418e-18,
   8.296981709830784e-01,  -7.827186148081105e-03,   7.383459508035007e-05,  -6.963075291055600e-07,   6.554918479239679e-09,  -6.100075895014028e-11,   5.322306404860052e-13,
  -3.137866977244847e-15,  -4.004616616113055e-17,   2.577467371947277e-18,   8.297164911500040e-01,  -7.827704398787085e-03,   7.384435288693050e-05,  -6.964588417401328e-07,
   6.556895044217426e-09,  -6.101683217680242e-11,   5.319391218257043e-13,  -3.114315555430089e-15,  -4.099821824881963e-17,   2.607232414695619e-18,   8.297309097861900e-01,
  -7.828112291225032e-03,   7.385203302084152e-05,  -6.965779348499044e-07,   6.558450352563718e-09,  -6.102945293223812e-11,   5.317081378711377e-13,  -3.095717925817740e-15,
  -4.174948078926710e-17,   2.630707334050728e-18,   8.297392312909959e-01,  -7.828347704513617e-03,   7.385646565240829e-05,  -6.966466695244137e-07,   6.559347847384129e-09,
  -6.103672498944327e-11,   5.315742074652892e-13,  -3.084959775602442e-15,  -4.218384838725451e-17,   2.644275085298700e-18,   8.297423561418786e-01,  -7.828436106545435e-03,
   7.385813020182360e-05,  -6.966724807792876e-07,   6.559684845907726e-09,  -6.103945351917515e-11,   5.315237970263226e-13,  -3.080915236926146e-15,  -4.234710888438435e-17,
   2.649373675700777e-18,   8.297428741329135e-01,  -7.828450760553140e-03,   7.385840612746808e-05,  -6.966767594012134e-07,   6.559740707196137e-09,  -6.103990569591374e-11,
   5.315154345344068e-13,  -3.080244546282434e-15,  -4.237417962391809e-17,   2.650219038667361e-18,   2.719933786608308e-03,  -2.472469975279218e-05,   2.247331916803883e-07,
  -2.042457813213332e-09,   1.855546829610051e-11,  -1.682097160127449e-13,   1.506981217130133e-15,  -1.274994369395926e-17,   8.074495164008423e-20,   3.832102265903504e-22,
   2.719965799690284e-03,  -2.472557256993652e-05,   2.247490534062098e-07,  -2.042697509367243e-09,   1.855868887303503e-11,  -1.682477833241484e-13,   1.507298271709795e-15,
  -1.274776174944579e-17,   8.052028073032856e-20,   3.913323961065886e-22,   2.720018355981426e-03,  -2.472700551461972e-05,   2.247750949857834e-07,  -2.043091048548843e-09,
   1.856397645812241e-11,  -1.683102721224971e-13,   1.507818115274617e-15,  -1.274414946439109e-17,   8.015043756533840e-20,   4.046919989220663e-22,   2.720074124492186e-03,
  -2.472852608037676e-05,   2.248027298186830e-07,  -2.043508677246765e-09,   1.856958765567560e-11,  -1.683765709341221e-13,   1.508368820607454e-15,  -1.274027535868278e-17,
   7.975663219456084e-20,   4.189025725236469e-22,   2.720118016213509e-03,  -2.472972284653340e-05,   2.248244805355184e-07,  -2.043837391750663e-09,   1.857400417586486e-11,
  -1.684287436164292e-13,   1.508801583774171e-15,  -1.273719655166403e-17,   7.944571014408260e-20,   4.301117191783795e-22,   2.720143347629688e-03,  -2.473041355291461e-05,
   2.248370340844889e-07,  -2.044027114760394e-09,   1.857655322758313e-11,  -1.684588515458202e-13,   1.509051080967731e-15,  -1.273540772678715e-17,   7.926587173655819e-20,
   4.365909012076193e-22,   2.720152859950373e-03,  -2.473067292555411e-05,   2.248417482153302e-07,  -2.044098360555701e-09,   1.857751045803958e-11,  -1.684701570038121e-13,
   1.509144720662094e-15,  -1.273473373832341e-17,   7.919826513462634e-20,   4.390258199501361e-22,   2.720154436760120e-03,  -2.473071592057318e-05,   2.248425296578216e-07,
  -2.044110170720035e-09,   1.857766913459802e-11,  -1.684720310258106e-13,   1.509160240196505e-15,  -1.273462189545782e-17,   7.918705438924455e-20,   4.394295439576604e-22,
   2.462931285314500e-02,  -2.238849957563901e-04,   2.034984788221043e-06,  -1.849468123186788e-08,   1.680211253420082e-10,  -1.523105328967140e-12,   1.364290599595599e-14,
  -1.153110663240383e-16,   7.254417465987737e-19,   3.669874618418369e-21,   2.462960273526720e-02,  -2.238928992118196e-04,   2.035128417273810e-06,  -1.849685162897243e-08,
   1.680502813890499e-10,  -1.523449594066478e-12,   1.364575335991469e-14,  -1.152902496754049e-16,   7.233671319155799e-19,   3.744720349040099e-21,   2.463007863850014e-02,
  -2.239058746838167e-04,   2.035364225620499e-06,  -1.850041504114882e-08,   1.680981501303332e-10,  -1.524014714678032e-12,   1.365042174041636e-14,  -1.152557968356534e-16,
   7.199520088624498e-19,   3.867829530013970e-21,   2.463058362874934e-02,  -2.239196435742580e-04,   2.035614460983260e-06,  -1.850419657807876e-08,   1.681489485007288e-10,
  -1.524614288115381e-12,   1.365536704525536e-14,  -1.152188601184403e-16,   7.163156389673112e-19,   3.998781173375462e-21,   2.463098107331049e-02,  -2.239304804236220e-04,
   2.035811415255616e-06,  -1.850717301590069e-08,   1.681889313791613e-10,  -1.525086109535558e-12,   1.365925307194631e-14,  -1.151895155120621e-16,   7.134446216720614e-19,
   4.102074948181338e-21,   2.463121045218382e-02,  -2.239367348459706e-04,   2.035925088523778e-06,  -1.850889091601472e-08,   1.682120080000688e-10,  -1.525358388367904e-12,
   1.366149338337292e-14,  -1.151724697203079e-16,   7.117840207928684e-19,   4.161781686008791e-21,   2.463129658733653e-02,  -2.239390834937838e-04,   2.035967775309536e-06,
  -1.850953603098369e-08,   1.682206738256165e-10,  -1.525460628263319e-12,   1.366233419029342e-14,  -1.151660479656910e-16,   7.111597526303526e-19,   4.184219907062925e-21,
   2.463131086552930e-02,  -2.239394728184161e-04,   2.035974851326146e-06,  -1.850964296941619e-08,   1.682221103273791e-10,  -1.525477575803812e-12,   1.366247354220377e-14,
  -1.151649823655218e-16,   7.110562345204217e-19,   4.187940299696859e-21,   6.928269168407210e-02,  -6.297924414291196e-04,   5.724447671385594e-06,  -5.202581200143164e-08,
   4.726418031829571e-10,  -4.284206807957464e-12,   3.835996029016184e-14,  -3.235296406039158e-16,   2.006528375312311e-18,   1.152026749654624e-20,   6.928350712752512e-02,
  -6.298146739645565e-04,   5.724851698303295e-06,  -5.203191689579755e-08,   4.727237800315617e-10,  -4.285172612436317e-12,   3.836782886687709e-14,  -3.234647409730353e-16,
   2.000451210874438e-18,   1.173862350392671e-20,   6.928484585159855e-02,  -6.298511741564517e-04,   5.725515024518500e-06,  -5.204194006118975e-08,   4.728583703722407e-10,
  -4.286757992813484e-12,   3.838072875088502e-14,  -3.233573839098352e-16,   1.990447377469705e-18,   1.209778742687560e-20,   6.928626639795410e-02,  -6.298899062457953e-04,
   5.726218933733589e-06,  -5.205257676424286e-08,   4.730011975244501e-10,  -4.288440007277583e-12,   3.839439248278222e-14,  -3.232423623001192e-16,   1.979795558576221e-18,
   1.247983595783073e-20,   6.928738441641789e-02,  -6.299203904607389e-04,   5.726772963826216e-06,  -5.206094888275269e-08,   4.731136151050681e-10,  -4.289763618360313e-12,
   3.840512847055726e-14,  -3.231510367337169e-16,   1.971385722224331e-18,   1.278119666060095e-20,   6.928802966317829e-02,  -6.299379842417520e-04,   5.727092725406512e-06,
  -5.206578098779265e-08,   4.731784982398200e-10,  -4.290527442570202e-12,   3.841131741663506e-14,  -3.230980087314835e-16,   1.966521490509834e-18,   1.295539307471035e-20,
   6.928827196286104e-02,  -6.299445910221915e-04,   5.727212802836180e-06,  -5.206759556532499e-08,   4.732028633995833e-10,  -4.290814255234116e-12,   3.841364010257101e-14,
  -3.230780352403110e-16,   1.964692890138907e-18,   1.302085759634267e-20,   6.928831212766565e-02,  -6.299456861980410e-04,   5.727232707588144e-06,  -5.206789636143030e-08,
   4.732069023209060e-10,  -4.290861797961602e-12,   3.841402505108659e-14,  -3.230747211318505e-16,   1.964389666179480e-18,   1.303171202319538e-20,   1.385380752783364e-01,
  -1.259336639112485e-03,   1.144663754631064e-05,  -1.040309438968232e-07,   9.450821409873187e-10,  -8.565679967403462e-12,   7.664577138605726e-14,  -6.441273348846982e-16,
   3.898261028555653e-18,   2.704388093604453e-20,   1.385397058435936e-01,  -1.259381095340534e-03,   1.144744542719432e-05,  -1.040431497182057e-07,   9.452459307468058e-10,
  -8.567602473858805e-12,   7.666103427438948e-14,  -6.439763174134101e-16,   3.885297976457872e-18,   2.750690040740930e-20,   1.385423827636839e-01,  -1.259454081206153e-03,
   1.144877179559348e-05,  -1.040631895264387e-07,   9.455148415571059e-10,  -8.570758245086398e-12,   7.668605311080630e-14,  -6.437266720179126e-16,   3.863959262005511e-18,
   2.826851278475614e-20,   1.385452232960617e-01,  -1.259531529978247e-03,   1.145017931250431e-05,  -1.040844559986684e-07,   9.458002084987148e-10,  -8.574106305930747e-12,
   7.671254874834659e-14,  -6.434594304383691e-16,   3.841238656632281e-18,   2.907866945120844e-20,   1.385474588919864e-01,  -1.259592486281839e-03,   1.145128713529052e-05,
  -1.041011947692971e-07,   9.460248167719609e-10,  -8.576740915397258e-12,   7.673336375295819e-14,  -6.432474071272136e-16,   3.823300471340066e-18,   2.971773520677444e-20,
   1.385487491309887e-01,  -1.259627666845052e-03,   1.145192652140264e-05,  -1.041108558208436e-07,   9.461544518060478e-10,  -8.578261266419402e-12,   7.674536156324690e-14,
  -6.431243609815147e-16,   3.812925147483296e-18,   3.008714125784947e-20,   1.385492336347786e-01,  -1.259640877777714e-03,   1.145216662479118e-05,  -1.041144837891337e-07,
   9.462031327897541e-10,  -8.578832148027543e-12,   7.674986403444553e-14,  -6.430780266768607e-16,   3.809024789839949e-18,   3.022596819637285e-20,   1.385493139485448e-01,
  -1.259643067693743e-03,   1.145220642576268e-05,  -1.041150851845818e-07,   9.462112024513456e-10,  -8.578926778488330e-12,   7.675061023434775e-14,  -6.430703392816651e-16,
   3.808378021760410e-18,   3.024898662029156e-20,   2.357705899604338e-01,  -2.143198097740807e-03,   1.948042041772118e-05,  -1.770442794669550e-07,   1.608345107704332e-09,
  -1.457471344235428e-11,   1.302827981595231e-13,  -1.088738983841712e-15,   6.329364349501230e-18,   5.679665403851807e-20,   2.357733649321908e-01,  -2.143273755223729e-03,
   1.948179527115486e-05,  -1.770650477780649e-07,   1.608623503542343e-09,  -1.457796202204132e-11,   1.303075127168497e-13,  -1.088424850950592e-15,   6.305108997106902e-18,
   5.765656777550381e-20,   2.357779206392420e-01,  -2.143397965645216e-03,   1.948405248754702e-05,  -1.770991456622399e-07,   1.609080573240942e-09,  -1.458329439783410e-11,
   1.303480151892095e-13,  -1.087905945589121e-15,   6.265182222299488e-18,   5.907106288244287e-20,   2.357827547892845e-01,  -2.143529771227220e-03,   1.948644780234449e-05,
  -1.771353306922568e-07,   1.609565610934029e-09,  -1.458895151432993e-11,   1.303908954925203e-13,  -1.087350984775975e-15,   6.222670334821339e-18,   6.057576871082819e-20,
   2.357865594303466e-01,  -2.143633509230479e-03,   1.948833309693102e-05,  -1.771638117875138e-07,   1.609947375327742e-09,  -1.459340300655600e-11,   1.304245729115131e-13,
  -1.086911064903315e-15,   6.189107084053776e-18,   6.176274503945903e-20,   2.357887552190535e-01,  -2.143693380993277e-03,   1.948942120515188e-05,  -1.771802501018087e-07,
   1.610167713912808e-09,  -1.459597177291861e-11,   1.304439808631278e-13,  -1.086655909255124e-15,   6.169694481713216e-18,   6.244888099842689e-20,   2.357895797701235e-01,
  -2.143715863914270e-03,   1.948982981343350e-05,  -1.771864231012575e-07,   1.610250456054717e-09,  -1.459693631778638e-11,   1.304512634546971e-13,  -1.086559855686958e-15,
   6.162396801612752e-18,   6.270674147735659e-20,   2.357897164518238e-01,  -2.143719590805494e-03,   1.948989754678146e-05,  -1.771874463774091e-07,   1.610264171897401e-09,
  -1.459709620213491e-11,   1.304524703694362e-13,  -1.086543920763280e-15,   6.161186681645816e-18,   6.274949660133354e-20,   3.670608507513963e-01,  -3.336650704151799e-03,
   3.032819952126005e-05,  -2.756313404783065e-07,   2.503864745507855e-09,  -2.268399935673573e-11,   2.024480230274500e-13,  -1.676608653981791e-15,   9.097480061702146e-18,
   1.153606070677359e-19,   3.670651709812424e-01,  -3.336768491449229e-03,   3.033033988239785e-05,  -2.756636636839882e-07,   2.504297311702434e-09,  -2.268899964202101e-11,
   2.024833704657585e-13,  -1.675976644820754e-15,   9.054175387847911e-18,   1.168831456297660e-19,   3.670722635584895e-01,  -3.336961868350683e-03,   3.033385389880082e-05,
  -2.757167325978526e-07,   2.505007493192759e-09,  -2.269720702784432e-11,   2.025412731868952e-13,  -1.674933423265684e-15,   8.982891773844007e-18,   1.193877253297076e-19,
   3.670797896312057e-01,  -3.337167069767758e-03,   3.033758290497425e-05,  -2.757730498029112e-07,   2.505761124030929e-09,  -2.270591380032733e-11,   2.026025411448587e-13,
  -1.673818759694546e-15,   8.906993173190918e-18,   1.220521938883473e-19,   3.670857129072718e-01,  -3.337328574193713e-03,   3.034051791539787e-05,  -2.758173767966199e-07,
   2.506354288512377e-09,  -2.271276469635325e-11,   2.026506350809269e-13,  -1.672935912428134e-15,   8.847071276431241e-18,   1.241541545316530e-19,   3.670891314328215e-01,
  -3.337421785497640e-03,   3.034221187272252e-05,  -2.758429607985343e-07,   2.506696636571623e-09,  -2.271671792762198e-11,   2.026783411398291e-13,  -1.672424156091946e-15,
   8.812413231795131e-18,   1.253692461740342e-19,   3.670904151396234e-01,  -3.337456788014179e-03,   3.034284799046798e-05,  -2.758525682287692e-07,   2.506825195683048e-09,
  -2.271820230020338e-11,   2.026887356009280e-13,  -1.672231561299588e-15,   8.799384428928132e-18,   1.258259050004511e-19,   3.670906279332691e-01,  -3.337462590221619e-03,
   3.034295343714071e-05,  -2.758541608180595e-07,   2.506846506407446e-09,  -2.271844835065769e-11,   2.026904581334323e-13,  -1.672199613517030e-15,   8.797223960486042e-18,
   1.259016227777129e-19,   5.445050025315686e-01,  -4.949650584385143e-03,   4.498940151562499e-05,  -4.088740263865319e-07,   3.714040213893494e-09,  -3.363307638778516e-11,
   2.993497533940402e-13,  -2.440339908416029e-15,   1.155128267489246e-17,   2.412469439802124e-19,   5.445114112384848e-01,  -4.949825311040806e-03,   4.499257635053519e-05,
  -4.089219501012292e-07,   3.714679733766316e-09,  -3.364034814518251e-11,   2.993941362733360e-13,  -2.439029791875526e-15,   1.147237430476623e-17,   2.440011071088521e-19,
   5.445219324955410e-01,  -4.950112167935182e-03,   4.499778875086194e-05,  -4.090006321080328e-07,   3.715729676766656e-09,  -3.365228303377218e-11,   2.994667686746507e-13,
  -2.436868752699819e-15,   1.134248140980083e-17,   2.485321004587709e-19,   5.445330968075645e-01,  -4.950416565402966e-03,   4.500332004735512e-05,  -4.090841299537417e-07,
   3.716843839160114e-09,  -3.366494294927194e-11,   2.995435250982947e-13,  -2.434561744565541e-15,   1.120417605479027e-17,   2.533528746253350e-19,   5.445418835021018e-01,
  -4.950656142387303e-03,   4.500767359550888e-05,  -4.091498505486080e-07,   3.717720757075077e-09,  -3.367490351879120e-11,   2.996037063492170e-13,  -2.432735980801349e-15,
   1.109498183824034e-17,   2.571562968135007e-19,   5.445469546045426e-01,  -4.950794412793572e-03,   4.501018626911575e-05,  -4.091877821354777e-07,   3.718226870059806e-09,
  -3.368065081243735e-11,   2.996383472055724e-13,  -2.431678228658971e-15,   1.103182442419394e-17,   2.593551152431604e-19,   5.445488588783577e-01,  -4.950846335810662e-03,
   4.501112983249638e-05,  -4.092020263803947e-07,   3.718416925522644e-09,  -3.368280876140637e-11,   2.996513379894452e-13,  -2.431280262680956e-15,   1.100808184306658e-17,
   2.601815098537454e-19,   5.445491745402882e-01,  -4.950854942852232e-03,   4.501128624318661e-05,  -4.092043875972543e-07,   3.718448430199875e-09,  -3.368316646088230e-11,
   2.996534904899076e-13,  -2.431214253512813e-15,   1.100414478024699e-17,   2.603185343898648e-19,   7.994954026757327e-01,  -7.267559846458932e-03,   6.605776540818333e-05,
  -6.003408062120932e-07,   5.452603227600728e-09,  -4.933274319741169e-11,   4.365775260098255e-13,  -3.437253052866882e-15,   1.076859936199576e-17,   5.830562214860834e-19,
   7.995048125541854e-01,  -7.267816393527071e-03,   6.606242636412526e-05,  -6.004110965839051e-07,   5.453535614233717e-09,  -4.934296473413140e-11,   4.366169896106937e-13,
  -3.434110406144090e-15,   1.060331330407426e-17,   5.888309642700021e-19,   7.995202608733086e-01,  -7.268237578782120e-03,   6.607007865343664e-05,  -6.005265001010386e-07,
   5.455066336879219e-09,  -4.935973815141892e-11,   4.366812950890072e-13,  -3.428929693096806e-15,   1.033120649059821e-17,   5.983331748099501e-19,   7.995366533873373e-01,
  -7.268684518417273e-03,   6.607819910644181e-05,  -6.006489664135075e-07,   5.456690631816280e-09,  -4.937752665446049e-11,   4.367488740407962e-13,  -3.423403223009712e-15,
   1.004144184472929e-17,   6.084457301677885e-19,   7.995495548551902e-01,  -7.269036283638959e-03,   6.608459051228822e-05,  -6.007453583677025e-07,   5.457969017998551e-09,
  -4.939151948165676e-11,   4.368015844684003e-13,  -3.419032588616444e-15,   9.812642773653896e-18,   6.164260888444223e-19,   7.995570007342510e-01,  -7.269239302797754e-03,
   6.608827934473427e-05,  -6.008009921862244e-07,   5.458706822617782e-09,  -4.939959227612796e-11,   4.368318141444974e-13,  -3.416501670958230e-15,   9.680296270230142e-18,
   6.210404251464807e-19,   7.995597967717325e-01,  -7.269315540130716e-03,   6.608966458093398e-05,  -6.008218840200881e-07,   5.458983879915110e-09,  -4.940262317209615e-11,
   4.368431296365338e-13,  -3.415549670845879e-15,   9.630541704696545e-18,   6.227748024222112e-19,   7.995602602568584e-01,  -7.269328177645365e-03,   6.608989420592707e-05,
  -6.008253471818321e-07,   5.459029806355794e-09,  -4.940312555910697e-11,   4.368450034384915e-13,  -3.415391777948957e-15,   9.622291158047627e-18,   6.230623872466778e-19,
   2.624482295451297e-03,  -2.302006859958049e-05,   2.019000511481045e-07,  -1.770634811441470e-09,   1.552556767686184e-11,  -1.360289242361288e-13,   1.186788946395898e-15,
  -1.013626165638485e-17,   7.843424063116952e-20,  -3.388496576631895e-22,   2.624511053999266e-03,  -2.302082520745875e-05,   2.019133219383495e-07,  -1.770828646596003e-09,
   1.552810470762715e-11,  -1.360592424874000e-13,   1.187100462761136e-15,  -1.013792852971171e-17,   7.838577112089490e-20,  -3.362875172353235e-22,   2.624558267178836e-03,
  -2.302206736165165e-05,   2.019351096558597e-07,  -1.771146889578048e-09,   1.553227013443554e-11,  -1.361090183603510e-13,   1.187611725578921e-15,  -1.014065540112538e-17,
   7.830582914192656e-20,  -3.320702714096612e-22,   2.624608365871947e-03,  -2.302338546468859e-05,   2.019582302387883e-07,  -1.771484612392698e-09,   1.553669062676398e-11,
  -1.361618392313688e-13,   1.188154021756198e-15,  -1.014353579212453e-17,   7.822049904681990e-20,  -3.275803780044273e-22,   2.624647795153916e-03,  -2.302442287767159e-05,
   2.019764278019028e-07,  -1.771750432733615e-09,   1.554017004982734e-11,  -1.362034130172945e-13,   1.188580671361036e-15,  -1.014579322287551e-17,   7.815297731065127e-20,
  -3.240358863581941e-22,   2.624670551103624e-03,  -2.302502161262841e-05,   2.019869305899183e-07,  -1.771903855161441e-09,   1.554217828223480e-11,  -1.362274074552595e-13,
   1.188826842784255e-15,  -1.014709223557629e-17,   7.811386211144116e-20,  -3.219859092105344e-22,   2.624679096291104e-03,  -2.302524644802653e-05,   2.019908746081651e-07,
  -1.771961469135706e-09,   1.554293242925318e-11,  -1.362364178682830e-13,   1.188919271921925e-15,  -1.014757930982156e-17,   7.809914614406357e-20,  -3.212152937834602e-22,
   2.624680512783628e-03,  -2.302528371794773e-05,   2.019915283918108e-07,  -1.771971019599375e-09,   1.554305744180361e-11,  -1.362379114870789e-13,   1.188934592810660e-15,
  -1.014766001145795e-17,   7.809670529364042e-20,  -3.210875095218142e-22,   2.376498863795021e-02,  -2.084493651962166e-04,   1.828228135695886e-06,  -1.603329944128453e-08,
   1.405856073426157e-10,  -1.231744102398328e-12,   1.074573497361387e-14,  -9.174727067290308e-17,   7.086531050388228e-19,  -3.011005949086909e-21,   2.376524904990242e-02,
  -2.084562163664686e-04,   1.828348304052692e-06,  -1.603505462076152e-08,   1.406085787146891e-10,  -1.232018519959698e-12,   1.074854925016731e-14,  -9.176205960964581e-17,
   7.082020997089849e-19,  -2.987391662712894e-21,   2.376567657066160e-02,  -2.084674642137278e-04,   1.828545594051944e-06,  -1.603793631437840e-08,   1.406462942778026e-10,
  -1.232469052339839e-12,   1.075316802217739e-14,  -9.178624983126887e-17,   7.074582810467934e-19,  -2.948522906978816e-21,   2.376613022007702e-02,  -2.084793997863849e-04,
   1.828754953281732e-06,  -1.604099439792525e-08,   1.406863193001892e-10,  -1.232947144779823e-12,   1.075806709899510e-14,  -9.181179743055260e-17,   7.066643771546298e-19,
  -2.907141282435460e-21,   2.376648725675011e-02,  -2.084887936787278e-04,   1.828919734065370e-06,  -1.604340140371727e-08,   1.407178234704068e-10,  -1.233323436922353e-12,
   1.076192139265767e-14,  -9.183181640909257e-17,   7.060361955788511e-19,  -2.874473077383887e-21,   2.376669331448616e-02,  -2.084942152917361e-04,   1.829014837877947e-06,
  -1.604479064525716e-08,   1.407360068533355e-10,  -1.233540614827004e-12,   1.076414525616735e-14,  -9.184333477853770e-17,   7.056723052327587e-19,  -2.855579238454970e-21,
   2.376677069213943e-02,  -2.084962512017911e-04,   1.829050551363809e-06,  -1.604531234033186e-08,   1.407428352176601e-10,  -1.233622169621026e-12,   1.076498023968167e-14,
  -9.184765342381959e-17,   7.055354045898626e-19,  -2.848476777979687e-21,   2.376678351864179e-02,  -2.084965886851587e-04,   1.829056471441129e-06,  -1.604539881986905e-08,
   1.407439671338371e-10,  -1.233635688618396e-12,   1.076511864490581e-14,  -9.184836895185883e-17,   7.055126978284461e-19,  -2.847299040557293e-21,   6.685133241966403e-02,
  -5.863717422229517e-04,   5.142837901515605e-06,  -4.510194148542496e-08,   3.954686585761125e-10,  -3.464838060144404e-12,   3.022332892994016e-14,  -2.578618343945724e-16,
   1.984040482333062e-18,  -8.127585716639181e-21,   6.685206496306380e-02,  -5.863910146798923e-04,   5.143175936195455e-06,  -4.510687871670683e-08,   3.955332671381044e-10,
  -3.465609300372814e-12,   3.023120652090049e-14,  -2.579016147481810e-16,   1.982699322466959e-18,  -8.058676457080404e-21,   6.685326758647535e-02,  -5.864226550630308e-04,
   5.143730914750032e-06,  -4.511498477469287e-08,   3.956393446911971e-10,  -3.466875500774179e-12,   3.024413494194715e-14,  -2.579666632252749e-16,   1.980487626763237e-18,
  -7.945252896907902e-21,   6.685454371025608e-02,  -5.864562300292055e-04,   5.144319844150702e-06,  -4.512358700763253e-08,   3.957519176730861e-10,  -3.468219152140698e-12,
   3.025784765325854e-14,  -2.580353342343452e-16,   1.978127285732506e-18,  -7.824496530955015e-21,   6.685554806069405e-02,  -5.864826552059671e-04,   5.144783373974173e-06,
  -4.513035779137124e-08,   3.958405251449959e-10,  -3.469276695761895e-12,   3.026863574846403e-14,  -2.580891244637095e-16,   1.976259852275049e-18,  -7.729166954852535e-21,
   6.685612770472794e-02,  -5.864979062943027e-04,   5.145050901850082e-06,  -4.513426565622806e-08,   3.958916670364464e-10,  -3.469887058030448e-12,   3.027486020950231e-14,
  -2.581200657971733e-16,   1.975178173830711e-18,  -7.674032570319302e-21,   6.685634536942683e-02,  -5.865036333434355e-04,   5.145151364204947e-06,  -4.513573315753383e-08,
   3.959108722298792e-10,  -3.470116261390761e-12,   3.027719726123695e-14,  -2.581316652664448e-16,   1.974771246413423e-18,  -7.653306779182018e-21,   6.685638145060345e-02,
  -5.865045826898089e-04,   5.145168017435326e-06,  -4.513597642000347e-08,   3.959140558133110e-10,  -3.470154255458462e-12,   3.027758464542470e-14,  -2.581335870254082e-16,
   1.974703752979575e-18,  -7.649870006898053e-21,   1.336763150989110e-01,  -1.172512361585081e-03,   1.028364837960311e-05,  -9.018606375073238e-08,   7.907776950617947e-10,
  -6.928046634245636e-12,   6.041947234809789e-14,  -5.148760115651011e-16,   3.935994147756491e-18,  -1.511013912631090e-20,   1.336777798969185e-01,  -1.172550898883269e-03,
   1.028432431233186e-05,  -9.019593587211428e-08,   7.909068525693435e-10,  -6.929586483741198e-12,   6.043509463307180e-14,  -5.149494822399358e-16,   3.933069878043880e-18,
  -1.496401381420858e-20,   1.336801846696286e-01,  -1.172614167146424e-03,   1.028543404510188e-05,  -9.021214414191021e-08,   7.911189095977559e-10,  -6.932114552093848e-12,
   6.046073259986419e-14,  -5.150695503875866e-16,   3.928248133407640e-18,  -1.472349357425017e-20,   1.336827364141004e-01,  -1.172681303811005e-03,   1.028661166581128e-05,
  -9.022934452295795e-08,   7.913439512104882e-10,  -6.934797239647675e-12,   6.048792482098439e-14,  -5.151962088166558e-16,   3.923103198084105e-18,  -1.446742337814322e-20,
   1.336847447190282e-01,  -1.172734143722008e-03,   1.028753853804179e-05,  -9.024288287293656e-08,   7.915210838241509e-10,  -6.936908681574964e-12,   6.050931678560380e-14,
  -5.152953505861354e-16,   3.919033303208983e-18,  -1.426527173340840e-20,   1.336859037785810e-01,  -1.172764639871809e-03,   1.028807348561715e-05,  -9.025069674467847e-08,
   7.916233200102437e-10,  -6.938127297050735e-12,   6.052165910831425e-14,  -5.153523508158813e-16,   3.916676138172181e-18,  -1.414835609883853e-20,   1.336863390221681e-01,
  -1.172776091706870e-03,   1.028827436970274e-05,  -9.025363104939688e-08,   7.916617125084293e-10,  -6.938584910798981e-12,   6.052629312985976e-14,  -5.153737140227306e-16,
   3.915789420005506e-18,  -1.410440584326683e-20,   1.336864111702969e-01,  -1.172777990024455e-03,   1.028830766942932e-05,  -9.025411745863949e-08,   7.916680767091644e-10,
  -6.938660767435138e-12,   6.052706125129574e-14,  -5.153772531189859e-16,   3.915642350435365e-18,  -1.409711796486432e-20,   2.274966186574045e-01,  -1.995436489480334e-03,
   1.750119390493356e-05,  -1.534827602743528e-07,   1.345772715576204e-09,  -1.178978031783517e-11,   1.027843785941793e-13,  -8.742644358000316e-16,   6.615242569822026e-18,
  -2.266696700772337e-20,   2.274991115191625e-01,  -1.995502074009970e-03,   1.750234423002636e-05,  -1.534995600730941e-07,   1.345992431707574e-09,  -1.179239474113500e-11,
   1.028106201782158e-13,  -8.743732490559717e-16,   6.609615134476905e-18,  -2.239578706634248e-20,   2.275032040738312e-01,  -1.995609746822087e-03,   1.750423281059004e-05,
  -1.535271423523178e-07,   1.346353171731509e-09,  -1.179668697048371e-11,   1.028536835553110e-13,  -8.745508706060394e-16,   6.600337762952839e-18,  -2.194942634337849e-20,
   2.275075467519162e-01,  -1.995724003055508e-03,   1.750623692505680e-05,  -1.535564129394972e-07,   1.346735999720361e-09,  -1.180124166947863e-11,   1.028993547349537e-13,
  -8.747379616170967e-16,   6.590440643246365e-18,  -2.147420463919830e-20,   2.275109645791682e-01,  -1.995813928422239e-03,   1.750781430728697e-05,  -1.535794516934273e-07,
   1.347037327128614e-09,  -1.180482646641295e-11,   1.029352819323457e-13,  -8.748842027733100e-16,   6.582613047081326e-18,  -2.109904405826896e-20,   2.275129371209225e-01,
  -1.995865828158551e-03,   1.750872469897966e-05,  -1.535927488703218e-07,   1.347211245006148e-09,  -1.180689541265730e-11,   1.029560096862235e-13,  -8.749681997517288e-16,
   6.578080132488618e-18,  -2.088206671130318e-20,   2.275136778388145e-01,  -1.995885317412870e-03,   1.750906657023752e-05,  -1.535977422931091e-07,   1.347276555910596e-09,
  -1.180767233948792e-11,   1.029637919269592e-13,  -8.749996654618246e-16,   6.576375054454539e-18,  -2.080050165103574e-20,   2.275138006238744e-01,  -1.995888548056168e-03,
   1.750912324082610e-05,  -1.535985700349955e-07,   1.347287382286741e-09,  -1.180780112712373e-11,   1.029650818794525e-13,  -8.750048773430173e-16,   6.576092259080716e-18,
  -2.078697643600254e-20,   3.541794692374921e-01,  -3.106607202368275e-03,   2.724683604169874e-05,  -2.389502874189112e-07,   2.095150602688470e-09,  -1.835331024562429e-11,
   1.599224758881145e-13,  -1.356275842806039e-15,   1.009443974172040e-17,  -2.774766707952116e-20,   3.541833502638502e-01,  -3.106709307913061e-03,   2.724862691071686e-05,
  -2.389764397677860e-07,   2.095492449740225e-09,  -1.835736545307429e-11,   1.599624813939813e-13,  -1.356405086463874e-15,   1.008405510740625e-17,  -2.726884620699151e-20,
   3.541897217814380e-01,  -3.106876938772785e-03,   2.725156712325709e-05,  -2.390193772542343e-07,   2.096053708624531e-09,  -1.836402300331891e-11,   1.600281266052782e-13,
  -1.356615472069260e-15,   1.006693828231683e-17,  -2.648069789912157e-20,   3.541964827051212e-01,  -3.107054819057915e-03,   2.725468720309400e-05,  -2.390649429180652e-07,
   2.096649331408373e-09,  -1.837108754477079e-11,   1.600977399571552e-13,  -1.356836272093410e-15,   1.004868241708894e-17,  -2.564157311028921e-20,   3.542018037693931e-01,
  -3.107194819732763e-03,   2.725714293020111e-05,  -2.391008074419088e-07,   2.097118150271566e-09,  -1.837664763940617e-11,   1.601524960492226e-13,  -1.357008276250765e-15,
   1.003424709046034e-17,  -2.497911998134309e-20,   3.542048747325157e-01,  -3.107275620049111e-03,   2.725856026166954e-05,  -2.391215072062533e-07,   2.097388739090840e-09,
  -1.837985658377209e-11,   1.601840848142248e-13,  -1.357106833959967e-15,   1.002588894392561e-17,  -2.459597980342472e-20,   3.542060279234813e-01,  -3.107305961974199e-03,
   2.725909249948156e-05,  -2.391292804847792e-07,   2.097490352472676e-09,  -1.838106159407637e-11,   1.601959444293191e-13,  -1.357143709172004e-15,   1.002274522464778e-17,
  -2.445195073237542e-20,   3.542062190821171e-01,  -3.107310991614392e-03,   2.725918072634823e-05,  -2.391305690333760e-07,   2.097507196587283e-09,  -1.838126134282471e-11,
   1.601979102098995e-13,  -1.357149814684006e-15,   1.002222383628253e-17,  -2.442806761375287e-20,   5.253965180410093e-01,  -4.608399804789001e-03,   4.041846618234042e-05,
  -3.544627280296922e-07,   3.107927946748510e-09,  -2.722150240676059e-11,   2.369883682871777e-13,  -1.999820551590996e-15,   1.445662711682143e-17,  -2.187100661253780e-20,
   5.254022752279905e-01,  -4.608551269786747e-03,   4.042112273861356e-05,  -3.545015166989208e-07,   3.108434503345838e-09,  -2.722748015221756e-11,   2.370455627818292e-13,
  -1.999909429365011e-15,   1.443701297614777e-17,  -2.101171052557046e-20,   5.254117268561682e-01,  -4.608799936082415e-03,   4.042548421864490e-05,  -3.545652007281313e-07,
   3.109266186031269e-09,  -2.723729376593098e-11,   2.371393996054002e-13,  -2.000052126033484e-15,   1.440468971461973e-17,  -1.959723711543649e-20,   5.254217561366119e-01,
  -4.609063806536805e-03,   4.043011251145069e-05,  -3.546327827653705e-07,   3.110148785261150e-09,  -2.724770700546198e-11,   2.372388897976381e-13,  -2.000199167003470e-15,
   1.437022417868679e-17,  -1.809120135588247e-20,   5.254296495027113e-01,  -4.609271485770696e-03,   4.043375531024152e-05,  -3.546859762370033e-07,   3.110843482064802e-09,
  -2.725590244821506e-11,   2.373171325239045e-13,  -2.000311718026493e-15,   1.434297775120628e-17,  -1.690219535625996e-20,   5.254342050267481e-01,  -4.609391346247839e-03,
   4.043585776413952e-05,  -3.547166776561074e-07,   3.111244439864343e-09,  -2.726063226504520e-11,   2.373622652011650e-13,  -2.000375400320447e-15,   1.432720439070080e-17,
  -1.621449286488863e-20,   5.254359156917584e-01,  -4.609436355942984e-03,   4.043664727982541e-05,  -3.547282068029031e-07,   3.111395010060389e-09,  -2.726240837076009e-11,
   2.373792086679918e-13,  -2.000399072785835e-15,   1.432127208413642e-17,  -1.595596931147206e-20,   5.254361992600479e-01,  -4.609443816991382e-03,   4.043677815458264e-05,
  -3.547301179482049e-07,   3.111419969571393e-09,  -2.726270278635967e-11,   2.373820170630309e-13,  -2.000402984123037e-15,   1.432028823109740e-17,  -1.591310032271080e-20,
   7.714384610372402e-01,  -6.766502419825402e-03,   5.934632283933043e-05,  -5.204549269159152e-07,   4.563194065844216e-09,  -3.995703749589237e-11,   3.472404984184800e-13,
  -2.899551837210573e-15,   1.962596741230783e-17,   2.873833562389731e-20,   7.714469142987586e-01,  -6.766724814664870e-03,   5.935022330085587e-05,  -5.205118618459276e-07,
   4.563936206096900e-09,  -3.996569946737456e-11,   3.473178147726531e-13,  -2.899357212088562e-15,   1.958354446359415e-17,   3.049588482689709e-20,   7.714607920979203e-01,
  -6.767089929383420e-03,   5.935662699820153e-05,  -5.206053386589358e-07,   4.565154668281688e-09,  -3.997991904441327e-11,   3.474446184389495e-13,  -2.899031134120126e-15,
   1.951364507013489e-17,   3.338930073109568e-20,   7.714755180622614e-01,  -6.767477368237780e-03,   5.936342243922148e-05,  -5.207045368931446e-07,   4.566447712261306e-09,
  -3.999500649390559e-11,   3.475789984834623e-13,  -2.898676195307101e-15,   1.943912894444175e-17,   3.647048146313574e-20,   7.714871078695457e-01,  -6.767782301971702e-03,
   5.936877093827151e-05,  -5.207826151933169e-07,   4.567465461465334e-09,  -4.000687994034134e-11,   3.476846340059149e-13,  -2.898390367202394e-15,   1.938023235412880e-17,
   3.890339367342938e-20,   7.714937967326930e-01,  -6.767958292135372e-03,   5.937185784255854e-05,  -5.208276792219533e-07,   4.568052871223450e-09,  -4.001373215380014e-11,
   3.477455492109709e-13,  -2.898222804645099e-15,   1.934614082061567e-17,   4.031068817450300e-20,   7.714963084973212e-01,  -6.768024379504215e-03,   5.937301704000726e-05,
  -5.208446018771520e-07,   4.568273458269507e-09,  -4.001630519294723e-11,   3.477684141793602e-13,  -2.898159390246735e-15,   1.933331997361012e-17,   4.083974904868478e-20,
   7.714967248598440e-01,  -6.768035334500795e-03,   5.937320919538075e-05,  -5.208474070845246e-07,   4.568310024196134e-09,  -4.001673170915583e-11,   3.477722038843986e-13,
  -2.898148852382480e-15,   1.933119372471917e-17,   4.092748053631606e-20,   2.535503554946996e-03,  -2.148583287532958e-05,   1.820578700881583e-07,  -1.542534337322243e-09,
   1.306824213899126e-11,  -1.106808291229646e-13,   9.360145634319141e-16,  -7.855199730234353e-18,   6.359186278759703e-20,  -4.362237072171299e-22,   2.535529485581304e-03,
  -2.148649197443389e-05,   1.820690396683556e-07,  -1.542692042803854e-09,   1.307024317593551e-11,  -1.107043394289933e-13,   9.362680087945776e-16,  -7.857417209153100e-18,
   6.359471545635368e-20,  -4.355823162957864e-22,   2.535572056066169e-03,  -2.148757404102637e-05,   1.820873775783997e-07,  -1.542950966079987e-09,   1.307352859309133e-11,
  -1.107429401808661e-13,   9.366840879248861e-16,  -7.861055154576397e-18,   6.359928047010006e-20,  -4.345253711485814e-22,   2.535617228206742e-03,  -2.148872226356751e-05,
   1.821068371989235e-07,  -1.543225736588039e-09,   1.307701520626159e-11,  -1.107839050551670e-13,   9.371255901146989e-16,  -7.864912018940650e-18,   6.360396351190962e-20,
  -4.333984293588025e-22,   2.535652780052634e-03,  -2.148962596871656e-05,   1.821221532395080e-07,  -1.543442006244998e-09,   1.307975957408248e-11,  -1.108161493255397e-13,
   9.374730618051333e-16,  -7.867945012472175e-18,   6.360753245544775e-20,  -4.325075747266520e-22,   2.535673298172638e-03,  -2.149014753386171e-05,   1.821309929138876e-07,
  -1.543566829243350e-09,   1.308134355671947e-11,  -1.108347600073584e-13,   9.376735973285650e-16,  -7.869694456613323e-18,   6.360954533763156e-20,  -4.319918616051564e-22,
   2.535681003016647e-03,  -2.149034339039534e-05,   1.821343123917335e-07,  -1.543613703325654e-09,   1.308193838711578e-11,  -1.108417488592379e-13,   9.377489009382306e-16,
  -7.870351209388584e-18,   6.361029233594951e-20,  -4.317979066729217e-22,   2.535682280209359e-03,  -2.149037585661102e-05,   1.821348626475656e-07,  -1.543621473470975e-09,
   1.308203699030684e-11,  -1.108429073802414e-13,   9.377613836170460e-16,  -7.870460066012464e-18,   6.361041569405454e-20,  -4.317657400596756e-22,   2.295927592264533e-02,
  -1.945566845657923e-04,   1.648554920952601e-06,  -1.396782509342478e-08,   1.183343875790451e-10,  -1.002224324160091e-12,   8.475524928917397e-15,  -7.112003696402304e-17,
   5.754149270178723e-19,  -3.934442593359890e-21,   2.295951072751675e-02,  -1.945626527836521e-04,   1.648656062742462e-06,  -1.396925312972662e-08,   1.183525067626547e-10,
  -1.002437182359276e-12,   8.477818173850522e-15,  -7.114003319882015e-17,   5.754373262375066e-19,  -3.928512227682888e-21,   2.295989620814580e-02,  -1.945724510205478e-04,
   1.648822114555368e-06,  -1.397159770157693e-08,   1.183822558742830e-10,  -1.002786666640130e-12,   8.481582964925286e-15,  -7.117283801789783e-17,   5.754730108998286e-19,
  -3.918739774799335e-21,   2.296030524706605e-02,  -1.945828483071316e-04,   1.648998323580928e-06,  -1.397408577139112e-08,   1.184138267913807e-10,  -1.003157555021621e-12,
   8.485577776854228e-15,  -7.120761616985973e-17,   5.755093948187258e-19,  -3.908320366590925e-21,   2.296062717311320e-02,  -1.945910314607307e-04,   1.649137012029569e-06,
  -1.397604411110014e-08,   1.184386767519808e-10,  -1.003449488497112e-12,   8.488721769681351e-15,  -7.123496476357303e-17,   5.755369553913536e-19,  -3.900083923815099e-21,
   2.296081296704604e-02,  -1.945957542928388e-04,   1.649217056262789e-06,  -1.397717439370681e-08,   1.184530195463250e-10,  -1.003617985991705e-12,   8.490536250958698e-15,
  -7.125073933576575e-17,   5.755524300576569e-19,  -3.895315937443467e-21,   2.296088273529332e-02,  -1.945975277961761e-04,   1.649247114503317e-06,  -1.397759884240889e-08,
   1.184584056721146e-10,  -1.003681261684521e-12,   8.491217610738903e-15,  -7.125666117206199e-17,   5.755581593914417e-19,  -3.893522754351258e-21,   2.296089430042000e-02,
  -1.945978217814764e-04,   1.649252097130982e-06,  -1.397766920171895e-08,   1.184592985134814e-10,  -1.003691750705539e-12,   8.491330556085944e-15,  -7.125764271290747e-17,
   5.755591048060889e-19,  -3.893225363101295e-21,   6.458484833436448e-02,  -5.472913869054791e-04,   4.637414059952109e-06,  -3.929173546080225e-08,   3.328764475299889e-10,
  -2.819255143108900e-12,   2.384064586883077e-14,  -2.000042342936756e-16,   1.616171150856700e-18,  -1.097456913798147e-20,   6.458550884460737e-02,  -5.473081756062477e-04,
   4.637698573344026e-06,  -3.929575252274442e-08,   3.329274145239286e-10,  -2.819853736614327e-12,   2.384708649331245e-14,  -2.000599873983090e-16,   1.616213665709468e-18,
  -1.095715419498415e-20,   6.458659320841284e-02,  -5.473357382172498e-04,   4.638165679615584e-06,  -3.930234779632051e-08,   3.330110950330187e-10,  -2.820836544879316e-12,
   2.385765992532915e-14,  -2.001514498507067e-16,   1.616280295257677e-18,  -1.092845766493764e-20,   6.458774384210675e-02,  -5.473649859654430e-04,   4.638661358278403e-06,
  -3.930934672898706e-08,   3.330999000304430e-10,  -2.821879543626994e-12,   2.386887929103407e-14,  -2.002484096256123e-16,   1.616346684768760e-18,  -1.089786269235112e-20,
   6.458864942575282e-02,  -5.473880053189895e-04,   4.639051490987394e-06,  -3.931485553232926e-08,   3.331697998116939e-10,  -2.822700507237258e-12,   2.387770908614148e-14,
  -2.003246528992543e-16,   1.616395807543284e-18,  -1.087367861257262e-20,   6.458917206736137e-02,  -5.474012907279324e-04,   4.639276656628532e-06,  -3.931803501361596e-08,
   3.332101442633014e-10,  -2.823174348716549e-12,   2.388280497047415e-14,  -2.003686284403092e-16,   1.616422902224129e-18,  -1.085967909505104e-20,   6.458936832667095e-02,
  -5.474062796236957e-04,   4.639361210914555e-06,  -3.931922898641691e-08,   3.332252947471752e-10,  -2.823352289846638e-12,   2.388471853253599e-14,  -2.003851367829980e-16,
   1.616432839102045e-18,  -1.085441411445440e-20,   6.458940085957618e-02,  -5.474071066094633e-04,   4.639375227121664e-06,  -3.931942690692366e-08,   3.332278061958351e-10,
  -2.823381786607674e-12,   2.388503573319413e-14,  -2.003878730178920e-16,   1.616434473749943e-18,  -1.085354094518135e-20,   1.291442402769620e-01,  -1.094367056152679e-03,
   9.273000181944675e-06,  -7.856797400052775e-08,   6.656207921236069e-10,  -5.637334575855351e-12,   4.766808056149490e-14,  -3.997388314514641e-16,   3.223481150656323e-18,
  -2.163555515713055e-20,   1.291455610370916e-01,  -1.094400626932302e-03,   9.273569095770713e-06,  -7.857600644423492e-08,   6.657226974723710e-10,  -5.638530930208798e-12,
   4.768092507788931e-14,  -3.998486652896007e-16,   3.223497881333082e-18,  -2.159828357948471e-20,   1.291477293372741e-01,  -1.094455741282842e-03,   9.274503122857505e-06,
  -7.858919423223655e-08,   6.658900114173701e-10,  -5.640495176141329e-12,   4.770201144070763e-14,  -4.000288355945835e-16,   3.223518659175228e-18,  -2.153687010618718e-20,
   1.291500301511115e-01,  -1.094514225243056e-03,   9.275494283375406e-06,  -7.860318916871614e-08,   6.660675713857014e-10,  -5.642579714347717e-12,   4.772438570495313e-14,
  -4.002198198654581e-16,   3.223531600348087e-18,  -2.147139788200421e-20,   1.291518409614456e-01,  -1.094560254870609e-03,   9.276274393887102e-06,  -7.861420446952033e-08,
   6.662073315202937e-10,  -5.644220489486527e-12,   4.774199436272952e-14,  -4.003699873097595e-16,   3.223535179914358e-18,  -2.141964771682777e-20,   1.291528860386505e-01,
  -1.094586820448309e-03,   9.276724635762882e-06,  -7.862056210098103e-08,   6.662879976460878e-10,  -5.645167506104866e-12,   4.775215665839775e-14,  -4.004565963689549e-16,
   3.223534593971671e-18,  -2.138969211151473e-20,   1.291532784799093e-01,  -1.094596796272055e-03,   9.276893710760567e-06,  -7.862294954667180e-08,   6.663182900563721e-10,
  -5.645523137872998e-12,   4.775597270018914e-14,  -4.004891084257968e-16,   3.223533872243273e-18,  -2.137842654036285e-20,   1.291533435328961e-01,  -1.094598449917400e-03,
   9.276921737609284e-06,  -7.862334530481441e-08,   6.663233115349421e-10,  -5.645582089857929e-12,   4.775660526366224e-14,  -4.004944972099956e-16,   3.223533726127600e-18,
  -2.137655821652407e-20,   2.197837213107511e-01,  -1.862445149844651e-03,   1.578122613849053e-05,  -1.337106349025695e-07,   1.132782314608038e-09,  -9.593711208923157e-12,
   8.111375064567345e-14,  -6.797913925181513e-16,   5.464124506103750e-18,  -3.599965809791488e-20,   2.197859690422114e-01,  -1.862502282158990e-03,   1.578219434057274e-05,
  -1.337243046379121e-07,   1.132955719431618e-09,  -9.595745647600697e-12,   8.113551959661032e-14,  -6.799739312327904e-16,   5.463970941718600e-18,  -3.592966872568216e-20,
   2.197896591570370e-01,  -1.862596078324355e-03,   1.578378390813278e-05,  -1.337467478152795e-07,   1.133240425106873e-09,  -9.599085901093691e-12,   8.117125634053109e-14,
  -6.802733357665869e-16,   5.463706492441795e-18,  -3.581435236482593e-20,   2.197935747898078e-01,  -1.862695609048090e-03,   1.578547070780972e-05,  -1.337705646079601e-07,
   1.133542565489782e-09,  -9.602630702235743e-12,   8.120917507230979e-14,  -6.805906697648542e-16,   5.463409079375848e-18,  -3.569142459831101e-20,   2.197966565116621e-01,
  -1.862773944409138e-03,   1.578679833347845e-05,  -1.337893106103936e-07,   1.133780384615840e-09,  -9.605420865767795e-12,   8.123901677999229e-14,  -6.808401538848986e-16,
   5.463162818394834e-18,  -3.559426777890478e-20,   2.197984350730063e-01,  -1.862819154944824e-03,   1.578756457448934e-05,  -1.338001301213549e-07,   1.133917647934731e-09,
  -9.607031278512216e-12,   8.125623879410135e-14,  -6.809840318459344e-16,   5.463015800289855e-18,  -3.553803131192161e-20,   2.197991029479243e-01,  -1.862836132265641e-03,
   1.578785231359944e-05,  -1.338041931115126e-07,   1.133969194180445e-09,  -9.607636033762631e-12,   8.126270578966684e-14,  -6.810380397291767e-16,   5.462959667216372e-18,
  -3.551688267854159e-20,   2.197992136581447e-01,  -1.862838946516200e-03,   1.578790001089715e-05,  -1.338048666185286e-07,   1.133977738840618e-09,  -9.607736282144610e-12,
   8.126377778451917e-14,  -6.810469912678227e-16,   5.462950313466758e-18,  -3.551337533903402e-20,   3.421715989722867e-01,  -2.899558850522488e-03,   2.456909564717187e-05,
  -2.081681386736656e-07,   1.763573286432758e-09,  -1.493562022670215e-11,   1.262582264502571e-13,  -1.057117519519079e-15,   8.453840278364960e-18,  -5.403418444127243e-20,
   3.421750983663510e-01,  -2.899647797278716e-03,   2.457060299325381e-05,  -2.081894198720917e-07,   1.763843198474710e-09,  -1.493878373682508e-11,   1.262918969553240e-13,
  -1.057390957806972e-15,   8.453151786983479e-18,  -5.390890881130016e-20,   3.421808433435176e-01,  -2.899793824351857e-03,   2.457307771257625e-05,  -2.082243596602810e-07,
   1.764286354728991e-09,  -1.494397773924771e-11,   1.263471704330489e-13,  -1.057839381605416e-15,   8.451999867990617e-18,  -5.370251593513738e-20,   3.421869394196346e-01,
  -2.899948779303302e-03,   2.457570380773910e-05,  -2.082614379027490e-07,   1.764756648376459e-09,  -1.494948977663305e-11,   1.264058169689855e-13,  -1.058314554455220e-15,
   8.450748118276965e-18,  -5.348251995586141e-20,   3.421917372165919e-01,  -2.900070736138267e-03,   2.457777072258264e-05,  -2.082906218798213e-07,   1.765126823071757e-09,
  -1.495382835735894e-11,   1.264519699771987e-13,  -1.058688053821682e-15,   8.449741603488312e-18,  -5.330865883885167e-20,   3.421945061803752e-01,  -2.900141122407758e-03,
   2.457896364536096e-05,  -2.083074658086461e-07,   1.765340478619382e-09,  -1.495633246881671e-11,   1.264786049205133e-13,  -1.058903421161838e-15,   8.449152140065594e-18,
  -5.320802995032761e-20,   3.421955459654047e-01,  -2.900167553642412e-03,   2.457941161216492e-05,  -2.083137911143000e-07,   1.765420712275319e-09,  -1.495727283134292e-11,
   1.264886064429297e-13,  -1.058984258452825e-15,   8.448929166613945e-18,  -5.317018789948962e-20,   3.421957183252682e-01,  -2.900171935023766e-03,   2.457948586973097e-05,
  -2.083148396370648e-07,   1.765434012356567e-09,  -1.495742871220059e-11,   1.264902643297704e-13,  -1.058997656528226e-15,   8.448892119856514e-18,  -5.316391214045910e-20,
   5.075838164242594e-01,  -4.301260389544362e-03,   3.644625958754236e-05,  -3.088004018968310e-07,   2.616104285027541e-09,  -2.215478863229219e-11,   1.872343274916108e-13,
  -1.565126611008776e-15,   1.240819705364786e-17,  -7.508504722618591e-20,   5.075890074913498e-01,  -4.301392334774575e-03,   3.644849560078558e-05,  -3.088319693357958e-07,
   2.616504544032405e-09,  -2.215947197784386e-11,   1.872837235417922e-13,  -1.565505123896356e-15,   1.240603035046349e-17,  -7.485713873847180e-20,   5.075975296987240e-01,
  -4.301608953980916e-03,   3.645216662572080e-05,  -3.088837972170462e-07,   2.617161710174042e-09,  -2.216716126131621e-11,   1.873648086937554e-13,  -1.566125660282528e-15,
   1.240243489886891e-17,  -7.448168311902654e-20,   5.076065727328948e-01,  -4.301838816963063e-03,   3.645606220307257e-05,  -3.089387971579704e-07,   2.617859117810562e-09,
  -2.217532129039840e-11,   1.874508374681033e-13,  -1.566782934319500e-15,   1.239856748575587e-17,  -7.408151674778363e-20,   5.076136898752971e-01,  -4.302019729940957e-03,
   3.645912828633958e-05,  -3.089820871456476e-07,   2.618408056268632e-09,  -2.218174407544337e-11,   1.875185361180025e-13,  -1.567299368273530e-15,   1.239548582669380e-17,
  -7.376529360263653e-20,   5.076177974083431e-01,  -4.302124142207782e-03,   3.646089788053091e-05,  -3.090070725462696e-07,   2.618724889442696e-09,  -2.218545111041370e-11,
   1.875576037323093e-13,  -1.567597073330409e-15,   1.239369209058100e-17,  -7.358227720934993e-20,   5.076193398450463e-01,  -4.302163350779890e-03,   3.646156239919141e-05,
  -3.090164551722108e-07,   2.618843869130806e-09,  -2.218684319938342e-11,   1.875722735165823e-13,  -1.567708800368071e-15,   1.239301563945346e-17,  -7.351345477539655e-20,
   5.076195955269152e-01,  -4.302169850200327e-03,   3.646167255364423e-05,  -3.090180104957299e-07,   2.618863592016837e-09,  -2.218707396124582e-11,   1.875747052172312e-13,
  -1.567727317336448e-15,   1.239290335570915e-17,  -7.350204130210170e-20,   7.452841136863648e-01,  -6.315530409552127e-03,   5.351395309444982e-05,  -4.534104749062960e-07,
   3.841180597723733e-09,  -3.252694888543430e-11,   2.747412877945967e-13,  -2.289096625673604e-15,   1.781977780949674e-17,  -9.470258186346226e-20,   7.452917357173039e-01,
  -6.315724144224859e-03,   5.351723619175743e-05,  -4.534568209721338e-07,   3.841767904838396e-09,  -3.253379727089650e-11,   2.748121506053149e-13,  -2.289569122815553e-15,
   1.781300969923224e-17,  -9.423322157434523e-20,   7.453042488532590e-01,  -6.316042205368853e-03,   5.352262629021537e-05,  -4.535329125894529e-07,   3.842732173802321e-09,
  -3.254504101661472e-11,   2.749284634443410e-13,  -2.290343045223296e-15,   1.780182141306829e-17,  -9.346002391399825e-20,   7.453175267179024e-01,  -6.316379712295830e-03,
   5.352834609452724e-05,  -4.536136612582767e-07,   3.843755486214386e-09,  -3.255697287403313e-11,   2.750518531424790e-13,  -2.291161841820829e-15,   1.778984447029796e-17,
  -9.263597110923928e-20,   7.453279768004352e-01,  -6.316645346119665e-03,   5.353284796774526e-05,  -4.536772178230481e-07,   3.844560945976616e-09,  -3.256636430184312e-11,
   2.751489416831470e-13,  -2.291804500786097e-15,   1.778034215323351e-17,  -9.198480409700433e-20,   7.453340078810149e-01,  -6.316798654245569e-03,   5.353544622999222e-05,
  -4.537139003406818e-07,   3.845025835649433e-09,  -3.257178467610589e-11,   2.752049654096962e-13,  -2.292174693647004e-15,   1.777482750407895e-17,  -9.160794585738119e-20,
   7.453362726369985e-01,  -6.316856224039629e-03,   5.353642193036684e-05,  -4.537276755165332e-07,   3.845200414489050e-09,  -3.257382015563265e-11,   2.752260013661254e-13,
  -2.292313572612804e-15,   1.777275089426915e-17,  -9.146623186935567e-20,   7.453366480540523e-01,  -6.316865767113395e-03,   5.353658366809766e-05,  -4.537299589768395e-07,
   3.845229353860253e-09,  -3.257415756945944e-11,   2.752294882972563e-13,  -2.292336586814461e-15,   1.777240636012186e-17,  -9.144273019351301e-20,   2.452360722713766e-03,
  -2.010001766100245e-05,   1.647327188932046e-07,  -1.350001660390446e-09,   1.106258131187428e-11,  -9.064009567167017e-14,   7.422593004616581e-16,  -6.062104846627484e-18,
   4.887024945445145e-20,  -3.717910807198834e-22,   2.452384184403186e-03,  -2.010059446273800e-05,   1.647421736041644e-07,  -1.350130801146676e-09,   1.106416806301514e-11,
  -9.065824239861229e-14,   7.424543085212736e-16,  -6.064007663598202e-18,   4.888374284138696e-20,  -3.717217931451165e-22,   2.452422701538550e-03,  -2.010154141605151e-05,
   1.647576960228370e-07,  -1.350342825282791e-09,   1.106677327291407e-11,  -9.068803729753560e-14,   7.427744845008612e-16,  -6.067131179575871e-18,   4.890586283834221e-20,
  -3.716067810376264e-22,   2.452463572521587e-03,  -2.010254626095997e-05,   1.647741678414662e-07,  -1.350567824675298e-09,   1.106953801123411e-11,  -9.071965757342560e-14,
   7.431142684944543e-16,  -6.070445107300602e-18,   4.892929084473465e-20,  -3.714830215922769e-22,   2.452495739159794e-03,  -2.010333711846868e-05,   1.647871322143096e-07,
  -1.350744918769874e-09,   1.107171417116903e-11,  -9.074454694043924e-14,   7.433817182794593e-16,  -6.073052920155310e-18,   4.894769758408429e-20,  -3.713843726072744e-22,
   2.452514303540454e-03,  -2.010379355355027e-05,   1.647946145942478e-07,  -1.350847130607233e-09,   1.107297019442138e-11,  -9.075891270169020e-14,   7.435360839981371e-16,
  -6.074557832780340e-18,   4.895830793143798e-20,  -3.713269386491743e-22,   2.452521274722718e-03,  -2.010396495243891e-05,   1.647974243754427e-07,  -1.350885513562084e-09,
   1.107344186609799e-11,  -9.076430749424003e-14,   7.435940527352984e-16,  -6.075122922100020e-18,   4.896228984880702e-20,  -3.713052767076266e-22,   2.452522430299799e-03,
  -2.010399336441511e-05,   1.647978901407520e-07,  -1.350891876159773e-09,   1.107352005361445e-11,  -9.076520177448606e-14,   7.436036620348552e-16,  -6.075216592668568e-18,
   4.896294978331683e-20,  -3.713016809210792e-22,   2.220640802688405e-02,  -1.820079686406959e-04,   1.491673690130315e-06,  -1.222441998107860e-08,   1.001729336623425e-10,
  -8.207556914555004e-13,   6.721195969812600e-15,  -5.489064874791795e-17,   4.424198642469771e-19,  -3.362539130062207e-21,   2.220662047517644e-02,  -1.820131916466095e-04,
   1.491759303614229e-06,  -1.222558936427715e-08,   1.001873017700454e-10,  -8.209200046093117e-13,   6.722961349089572e-15,  -5.490785719127256e-17,   4.425411233217393e-19,
  -3.361877529871695e-21,   2.220696925226106e-02,  -1.820217664175426e-04,   1.491899860882066e-06,  -1.222750926523405e-08,   1.002108920699911e-10,  -8.211897884106210e-13,
   6.725859852526517e-15,  -5.493610509911520e-17,   4.427398985475328e-19,  -3.360779766205400e-21,   2.220733934370671e-02,  -1.820308654035114e-04,   1.492049015074481e-06,
  -1.222954665849812e-08,   1.002359269064882e-10,  -8.214761003858710e-13,   6.728935860719526e-15,  -5.496607484092608e-17,   4.429504177978792e-19,  -3.359599106850272e-21,
   2.220763061631017e-02,  -1.820380267090166e-04,   1.492166408946042e-06,  -1.223115026422192e-08,   1.002556321371545e-10,  -8.217014659842179e-13,   6.731357036730731e-15,
  -5.498965865295640e-17,   4.431158096755242e-19,  -3.358658426136080e-21,   2.220779871890926e-02,  -1.820421597810636e-04,   1.492234162747920e-06,  -1.223207580319755e-08,
   1.002670054865727e-10,  -8.218315435359723e-13,   6.732754481481697e-15,  -5.500326831082342e-17,   4.432111449324318e-19,  -3.358110925735376e-21,   2.220786184376534e-02,
  -1.820437118176710e-04,   1.492259605636404e-06,  -1.223242336490442e-08,   1.002712764956607e-10,  -8.218803917205715e-13,   6.733279261710914e-15,  -5.500837867892859e-17,
   4.432469223863006e-19,  -3.357904460722889e-21,   2.220787230764854e-02,  -1.820439690913762e-04,   1.492263823194286e-06,  -1.223248097889793e-08,   1.002719844872757e-10,
  -8.218884891525216e-13,   6.733366252907749e-15,  -5.500922578535119e-17,   4.432528518562781e-19,  -3.357870190107451e-21,   6.246701765796616e-02,  -5.119916276661657e-04,
   4.196104408385025e-06,  -3.438750843695967e-08,   2.817881662706837e-10,  -2.308795585115792e-12,   1.890656252244038e-14,  -1.543940698886621e-16,   1.243905600142195e-18,
  -9.434649298351908e-21,   6.246761527876083e-02,  -5.120063200736499e-04,   4.196345240567973e-06,  -3.439079792552327e-08,   2.818285833814501e-10,  -2.309257756117942e-12,
   1.891152594302629e-14,  -1.544423478913728e-16,   1.244241190949337e-18,  -9.432584142333156e-21,   6.246859639485325e-02,  -5.120304410550741e-04,   4.196740630546997e-06,
  -3.439619862924051e-08,   2.818949422735415e-10,  -2.310016588883171e-12,   1.891967516307249e-14,  -1.545215961458098e-16,   1.244791267443101e-18,  -9.429160020805256e-21,
   6.246963746861926e-02,  -5.120560366626094e-04,   4.197160203820175e-06,  -3.440192984012148e-08,   2.819653646034515e-10,  -2.310821910797672e-12,   1.892832342132661e-14,
  -1.546056738625350e-16,   1.245373783097176e-18,  -9.425480699739766e-21,   6.247045682359163e-02,  -5.120761815409240e-04,   4.197490434771691e-06,  -3.440644080157525e-08,
   2.820207948898188e-10,  -2.311455805965801e-12,   1.893513059050558e-14,  -1.546718355890802e-16,   1.245831385476287e-18,  -9.422551640163644e-21,   6.247092969916865e-02,
  -5.120878079452699e-04,   4.197681027365216e-06,  -3.440904435340335e-08,   2.820527878156904e-10,  -2.311821680383467e-12,   1.893905951919730e-14,  -1.547100156392688e-16,
   1.246095139162928e-18,  -9.420847807535305e-21,   6.247110727050250e-02,  -5.120921738515379e-04,   4.197752598641904e-06,  -3.441002204849554e-08,   2.820648020490275e-10,
  -2.311959077637482e-12,   1.894053494244115e-14,  -1.547243520253478e-16,   1.246194117405116e-18,  -9.420205463367101e-21,   6.247113670559053e-02,  -5.120928975669945e-04,
   4.197764462703731e-06,  -3.441018411732396e-08,   2.820667936103240e-10,  -2.311981853609008e-12,   1.894077951873105e-14,  -1.547267284547154e-16,   1.246210521093057e-18,
  -9.420098851671470e-21,   1.249094136770579e-01,  -1.023781451571567e-03,   8.390554886016407e-06,  -6.876146061282235e-08,   5.634650548053610e-10,  -4.616665830280079e-12,
   3.780474971856768e-14,  -3.086801344978246e-16,   2.485241282953750e-18,  -1.878533562206301e-20,   1.249106086830895e-01,  -1.023810830594406e-03,   8.391036455266392e-06,
  -6.876803827033020e-08,   5.635458710220707e-10,  -4.617589842311810e-12,   3.781466593506062e-14,  -3.087762420499125e-16,   2.485894030860945e-18,  -1.878052699141544e-20,
   1.249125705285583e-01,  -1.023859063048129e-03,   8.391827079065119e-06,  -6.877883751105344e-08,   5.636785592318223e-10,  -4.619106965158207e-12,   3.783094687933906e-14,
  -3.089339998107928e-16,   2.486963818585900e-18,  -1.877256153940800e-20,   1.249146522657414e-01,  -1.023910244172727e-03,   8.392666059899196e-06,  -6.879029763330126e-08,
   5.638193724882792e-10,  -4.620717031821596e-12,   3.784822475831038e-14,  -3.091013679169823e-16,   2.488096489257728e-18,  -1.876401249698726e-20,   1.249162906527297e-01,
  -1.023950525987700e-03,   8.393326391374806e-06,  -6.879931774614122e-08,   5.639302083299981e-10,  -4.621984366955879e-12,   3.786182437575398e-14,  -3.092330692294366e-16,
   2.488986123896720e-18,  -1.875721393151154e-20,   1.249172362174954e-01,  -1.023973774212945e-03,   8.393707501285235e-06,  -6.880452380503645e-08,   5.639941799024009e-10,
  -4.622715852695797e-12,   3.786967371609216e-14,  -3.093090692722443e-16,   2.489498833242098e-18,  -1.875326207281493e-20,   1.249175912901717e-01,  -1.023982504304321e-03,
   8.393850615570657e-06,  -6.880647880287705e-08,   5.640182030057946e-10,  -4.622990548335178e-12,   3.787262136031031e-14,  -3.093376066484437e-16,   2.489691225159317e-18,
  -1.875177276131148e-20,   1.249176501487456e-01,  -1.023983951449926e-03,   8.393874339008450e-06,  -6.880680287549593e-08,   5.640221852392812e-10,  -4.623036083885445e-12,
   3.787310998185515e-14,  -3.093423370532916e-16,   2.489723109718925e-18,  -1.875152560428611e-20,   2.125766949120741e-01,  -1.742319260406764e-03,   1.427943953664986e-05,
  -1.170214707120253e-07,   9.589306944596741e-10,  -7.856818306150512e-12,   6.433547870536907e-14,  -5.252025882687191e-16,   4.224026853729487e-18,  -3.175790155853302e-20,
   2.125787286293427e-01,  -1.742369259002134e-03,   1.428025909327403e-05,  -1.170326648176700e-07,   9.590682258547701e-10,  -7.858390445142042e-12,   6.435233176652222e-14,
  -5.253650144402544e-16,   4.225089221430478e-18,  -3.174791067833319e-20,   2.125820673899037e-01,  -1.742451343248093e-03,   1.428160461309254e-05,  -1.170510433724633e-07,
   9.592940319186606e-10,  -7.860971716475258e-12,   6.438000183516594e-14,  -5.256316253095391e-16,   4.226829923251913e-18,  -3.173137785980305e-20,   2.125856101878027e-01,
  -1.742538445680056e-03,   1.428303242912562e-05,  -1.170705466397957e-07,   9.595336649724671e-10,  -7.863711121516482e-12,   6.440936604467514e-14,  -5.259144681643333e-16,
   4.228672383786920e-18,  -3.171365667233842e-20,   2.125883984715626e-01,  -1.742606999157037e-03,   1.428415621148979e-05,  -1.170858974068967e-07,   9.597222830547039e-10,
  -7.865867392758056e-12,   6.443247881657338e-14,  -5.261370292015335e-16,   4.230119101319648e-18,  -3.169958045316474e-20,   2.125900076779947e-01,  -1.742646564074233e-03,
   1.428480480179795e-05,  -1.170947572734644e-07,   9.598311485046170e-10,  -7.867111957369694e-12,   6.444581884423666e-14,  -5.262654583162073e-16,   4.230952701410109e-18,
  -3.169140477948095e-20,   2.125906119573157e-01,  -1.742661421352100e-03,   1.428504836024618e-05,  -1.170980843621894e-07,   9.598720305041365e-10,  -7.867579329898535e-12,
   6.445082838298786e-14,  -5.263136818423504e-16,   4.231265475045072e-18,  -3.168832489210660e-20,   2.125907121255953e-01,  -1.742663884172182e-03,   1.428508873387958e-05,
  -1.170986358811378e-07,   9.598788073831063e-10,  -7.867656804964096e-12,   6.445165879764458e-14,  -5.263216754297495e-16,   4.231317308477229e-18,  -3.168781383731589e-20,
   3.309512968922437e-01,  -2.712540144360556e-03,   2.223103059991506e-05,  -1.821855614088082e-07,   1.492915676279410e-09,  -1.223183888208844e-11,   1.001552758868510e-13,
  -8.173666652314213e-16,   6.562955555866932e-18,  -4.892723391812103e-20,   3.309544630970994e-01,  -2.712617984965809e-03,   2.223230653035378e-05,  -1.822029888750223e-07,
   1.493129779816022e-09,  -1.223428554079972e-11,   1.001814584196277e-13,  -8.176167796617112e-16,   6.564490822686002e-18,  -4.890723014242606e-20,   3.309596610663859e-01,
  -2.712745778303556e-03,   2.223440130896338e-05,  -1.822316014004127e-07,   1.493481305845880e-09,  -1.223830266705901e-11,   1.002244456735925e-13,  -8.180273071893116e-16,
   6.567005313803705e-18,  -4.887416193799478e-20,   3.309651766924184e-01,  -2.712881384233430e-03,   2.223662421079543e-05,  -1.822619649254007e-07,   1.493854357077093e-09,
  -1.224256588235089e-11,   1.002700644282926e-13,  -8.184628051554159e-16,   6.569665349734987e-18,  -4.883876254397195e-20,   3.309695176486145e-01,  -2.712988112114371e-03,
   2.223837377643048e-05,  -1.822858636585714e-07,   1.494147990141285e-09,  -1.224592158645296e-11,   1.003059709328209e-13,  -8.188054690605806e-16,   6.571752981509167e-18,
  -4.881067708229601e-20,   3.309720229512431e-01,  -2.713049708986720e-03,   2.223938353716969e-05,  -1.822996570787817e-07,   1.494317467473255e-09,  -1.224785844184367e-11,
   1.003266950018902e-13,  -8.190031968025508e-16,   6.572955452864014e-18,  -4.879437769616592e-20,   3.309729637271068e-01,  -2.713072839626512e-03,   2.223976272223495e-05,
  -1.823048368331122e-07,   1.494381110911288e-09,  -1.224858579054691e-11,   1.003344774213126e-13,  -8.190774397946964e-16,   6.573406549646729e-18,  -4.878823995097480e-20,
   3.309731196746901e-01,  -2.713076673882337e-03,   2.223982557810761e-05,  -1.823056954614461e-07,   1.494391660881157e-09,  -1.224870636112857e-11,   1.003357674858874e-13,
  -8.190897463301179e-16,   6.573481302002820e-18,  -4.878722162597855e-20,   4.909394082865266e-01,  -4.023833311607126e-03,   3.297793065394819e-05,  -2.702574711143265e-07,
   2.214616194091809e-09,  -1.814470951055611e-11,   1.485581104250972e-13,  -1.211766564504889e-15,   9.702920897516482e-18,  -7.129797629147873e-20,   4.909441050946017e-01,
  -4.023948781816400e-03,   3.297982339041742e-05,  -2.702833229982221e-07,   2.214933767556244e-09,  -1.814833663656792e-11,   1.485968136059618e-13,  -1.212130718544341e-15,
   9.704900252044188e-18,  -7.125701558063947e-20,   4.909518158604020e-01,  -4.024138352842947e-03,   3.298293081988516e-05,  -2.703257667840379e-07,   2.215455175546006e-09,
  -1.815429193696229e-11,   1.486603567831903e-13,  -1.212728381632363e-15,   9.708139169238915e-18,  -7.118936870960265e-20,   4.909599978442177e-01,  -4.024339513214572e-03,
   3.298622830944729e-05,  -2.703708079973454e-07,   2.216008510936391e-09,  -1.816061203907695e-11,   1.487277886569765e-13,  -1.213362337283628e-15,   9.711561590205283e-18,
  -7.111704111905186e-20,   4.909664373006149e-01,  -4.024497835348406e-03,   3.298882364419984e-05,  -2.704062593445851e-07,   2.216444047602371e-09,  -1.816558676586429e-11,
   1.487808634228801e-13,  -1.213861110238079e-15,   9.714244660180741e-18,  -7.105972062409462e-20,   4.909701537138448e-01,  -4.024589209300339e-03,   3.299032154006151e-05,
  -2.704267204838275e-07,   2.216695427902708e-09,  -1.816845808786602e-11,   1.488114961192524e-13,  -1.214148900129300e-15,   9.715788937982616e-18,  -7.102647992762229e-20,
   4.909715492785269e-01,  -4.024623521723801e-03,   3.299088402948745e-05,  -2.704344041236020e-07,   2.216789828161025e-09,  -1.816953635639757e-11,   1.488229994187580e-13,
  -1.214256956401348e-15,   9.716368039681841e-18,  -7.101396745851377e-20,   4.909717806141168e-01,  -4.024629209530567e-03,   3.299097727093323e-05,  -2.704356778115703e-07,
   2.216805476590135e-09,  -1.816971509793035e-11,   1.488249062773142e-13,  -1.214274867657607e-15,   9.716463992379255e-18,  -7.101189174071049e-20,   7.208451687364733e-01,
  -5.908184903452935e-03,   4.842141660888282e-05,  -3.968183095768388e-07,   3.251706865227443e-09,  -2.664117474062833e-11,   2.180868818975112e-13,  -1.777106437399132e-15,
   1.415034620881901e-17,  -1.008520241260769e-19,   7.208520650485067e-01,  -5.908354448043570e-03,   4.842419570128223e-05,  -3.968562668417784e-07,   3.252173066026134e-09,
  -2.664649375213544e-11,   2.181433065001337e-13,  -1.777620533368247e-15,   1.415234452398756e-17,  -1.007568643247763e-19,   7.208633867474392e-01,  -5.908632794660049e-03,
   4.842875831929461e-05,  -3.969185853115660e-07,   3.252938497188315e-09,  -2.665522687938525e-11,   2.182359422542483e-13,  -1.778464146717308e-15,   1.415560404869687e-17,
  -1.005998443529209e-19,   7.208754003346526e-01,  -5.908928157879575e-03,   4.843360000120106e-05,  -3.969847174682310e-07,   3.253750797195803e-09,  -2.666449490923812e-11,
   2.183342435772167e-13,  -1.779358796970129e-15,   1.415903400682040e-17,  -1.004321450070213e-19,   7.208848553730357e-01,  -5.909160621832240e-03,   4.843741071383230e-05,
  -3.970367692130897e-07,   3.254390167289440e-09,  -2.667178998812628e-11,   2.184116127317439e-13,  -1.780062536292192e-15,   1.416171260867595e-17,  -1.002993746241610e-19,
   7.208903121736669e-01,  -5.909294785953850e-03,   4.843961006426896e-05,  -3.970668114536640e-07,   3.254759194634901e-09,  -2.667600055789752e-11,   2.184562661784480e-13,
  -1.780468535238803e-15,   1.416325013070393e-17,  -1.002224329832734e-19,   7.208923612779423e-01,  -5.909345166790560e-03,   4.844043596371216e-05,  -3.970780930221665e-07,
   3.254897774567616e-09,  -2.667758175131834e-11,   2.184730344055058e-13,  -1.780620964843471e-15,   1.416382590502708e-17,  -1.001934806029795e-19,   7.208927009474341e-01,
  -5.909353518181543e-03,   4.844057286950002e-05,  -3.970799631251747e-07,   3.254920746517706e-09,  -2.667784386111800e-11,   2.184758140009614e-13,  -1.780646230804731e-15,
   1.416392126443678e-17,  -1.001886781631602e-19,   2.374497849421116e-03,  -1.884407872610243e-05,   1.495378692468036e-07,  -1.186589553022143e-09,   9.415035763904370e-12,
  -7.469779322763647e-14,   5.925215455748540e-16,  -4.695665058168323e-18,   3.704300304366899e-20,  -2.861987897721651e-22,   2.374519145939193e-03,  -1.884458568332753e-05,
   1.495459153963234e-07,  -1.186695972168369e-09,   9.416302323338687e-12,  -7.471184947054175e-14,   5.926694149795602e-16,  -4.697133048281217e-18,   3.705590588901247e-20,
  -2.862652402927799e-22,   2.374554108450104e-03,  -1.884541796855050e-05,   1.495591252355747e-07,  -1.186870690892962e-09,   9.418381813980462e-12,  -7.473492824088240e-14,
   5.929122036742897e-16,  -4.699543235135152e-18,   3.707708238599108e-20,  -2.863739818345702e-22,   2.374591207504386e-03,  -1.884630113220645e-05,   1.495731429597667e-07,
  -1.187056100636201e-09,   9.420588624658613e-12,  -7.475942091234575e-14,   5.931698717066963e-16,  -4.702100959905830e-18,   3.709954462830125e-20,  -2.864888913655808e-22,
   2.374620405471849e-03,  -1.884699621901776e-05,   1.495841757526520e-07,  -1.187202033323693e-09,   9.422325621015312e-12,  -7.477869989606001e-14,   5.933726943318154e-16,
  -4.704114141286488e-18,   3.711721696249711e-20,  -2.865789820190497e-22,   2.374637256517250e-03,  -1.884739738018617e-05,   1.495905433019573e-07,  -1.187286259641983e-09,
   9.423328165680918e-12,  -7.478982742631066e-14,   5.934897618754592e-16,  -4.705276083064658e-18,   3.712741377201926e-20,  -2.866308370353997e-22,   2.374643584314253e-03,
  -1.884754802264700e-05,   1.495929344384072e-07,  -1.187317888541482e-09,   9.423704648203339e-12,  -7.479400616117598e-14,   5.935337246691620e-16,  -4.705712421773190e-18,
   3.713124235103612e-20,  -2.866502829825846e-22,   2.374644633240445e-03,  -1.884757299392055e-05,   1.495933308065791e-07,  -1.187323131541250e-09,   9.423767056468817e-12,
  -7.479469885877559e-14,   5.935410122774545e-16,  -4.705784752109705e-18,   3.713187697039980e-20,  -2.866535050475722e-22,   2.150135076575574e-02,  -1.706352973297377e-04,
   1.354082582015873e-06,  -1.074470467002457e-08,   8.525422780432508e-11,  -6.763969150612224e-13,   5.365339491168649e-15,  -4.251920727631527e-17,   3.354026512080506e-19,
  -2.590540184441427e-21,   2.150154360817305e-02,  -1.706398878856288e-04,   1.354155440821722e-06,  -1.074566830734194e-08,   8.526569662035842e-11,  -6.765241941362563e-13,
   5.366678357041089e-15,  -4.253249461043557e-17,   3.355192489885229e-19,  -2.591132809333581e-21,   2.150186019772515e-02,  -1.706474243239004e-04,   1.354275057429741e-06,
  -1.074725040500794e-08,   8.528452660555897e-11,  -6.767331720543704e-13,   5.368876657624506e-15,  -4.255431009071197e-17,   3.357106108693284e-19,  -2.592102498024586e-21,
   2.150219613392288e-02,  -1.706554214722252e-04,   1.354401989528445e-06,  -1.074892931104546e-08,   8.530450948555170e-11,  -6.769549528100709e-13,   5.371209680442001e-15,
  -4.257746094532255e-17,   3.359135893258529e-19,  -2.593127052720717e-21,   2.150246052487194e-02,  -1.706617155631236e-04,   1.354501892732140e-06,  -1.075025074790997e-08,
   8.532023815214089e-11,  -6.771295236935587e-13,   5.373046111750086e-15,  -4.259568291593499e-17,   3.360732826003361e-19,  -2.593930218420733e-21,   2.150261311302356e-02,
  -1.706653481235717e-04,   1.354559551620676e-06,  -1.075101342667479e-08,   8.532931628901259e-11,  -6.772302832941088e-13,   5.374106084464041e-15,  -4.260620002215881e-17,
   3.361654238594798e-19,  -2.594392470198789e-21,   2.150267041195223e-02,  -1.706667122083539e-04,   1.354581203635198e-06,  -1.075129982990932e-08,   8.533272537388739e-11,
  -6.772681216676422e-13,   5.374504139761138e-15,  -4.261014946070907e-17,   3.362000198685035e-19,  -2.594565809838909e-21,   2.150267991009939e-02,  -1.706669383261035e-04,
   1.354584792794410e-06,  -1.075134730586061e-08,   8.533329048663762e-11,  -6.772743940326457e-13,   5.374570124443251e-15,  -4.261080414514664e-17,   3.362057544436039e-19,
  -2.594594530670807e-21,   6.048367914027261e-02,  -4.800001025978557e-04,   3.809058197569433e-06,  -3.022504369297224e-08,   2.398216327106808e-10,  -1.902715377744670e-12,
   1.509272853280866e-14,  -1.196038457156542e-16,   9.433392701564538e-19,  -7.281158531626551e-21,   6.048422160939542e-02,  -4.800130159125145e-04,   3.809263150662724e-06,
  -3.022775442012182e-08,   2.398538945436948e-10,  -1.903073405240589e-12,   1.509649414161537e-14,  -1.196411906275859e-16,   9.436658401890090e-19,  -7.282771441396066e-21,
   6.048511218139201e-02,  -4.800342160462490e-04,   3.809599634270029e-06,  -3.023220488608917e-08,   2.399068633789390e-10,  -1.903661246030065e-12,   1.510267693772371e-14,
  -1.197025042483062e-16,   9.442018022507497e-19,  -7.285409977956796e-21,   6.048605717584418e-02,  -4.800567121654854e-04,   3.809956696480257e-06,  -3.023692767553449e-08,
   2.399630753112126e-10,  -1.904285100244296e-12,   1.510923863933142e-14,  -1.197675707437402e-16,   9.447702872662349e-19,  -7.288196980397350e-21,   6.048680091224933e-02,
  -4.800744175541537e-04,   3.810237725936735e-06,  -3.024064489848711e-08,   2.400073201208670e-10,  -1.904776156223804e-12,   1.511440365743177e-14,  -1.198187841984991e-16,
   9.452175337091030e-19,  -7.290381157135185e-21,   6.048723014541241e-02,  -4.800846360107398e-04,   3.810399921396975e-06,  -3.024279032599891e-08,   2.400328569602093e-10,
  -1.905059586075185e-12,   1.511738486088054e-14,  -1.198483427970425e-16,   9.454755863325277e-19,  -7.291637989702799e-21,   6.048739132830985e-02,  -4.800884732052822e-04,
   3.810460828891887e-06,  -3.024359598285804e-08,   2.400424467310302e-10,  -1.905166022821721e-12,   1.511850440244196e-14,  -1.198594427811939e-16,   9.455724759062830e-19,
  -7.292109242911433e-21,   6.048741804676541e-02,  -4.800891092784986e-04,   3.810470925259419e-06,  -3.024372953346494e-08,   2.400440363956905e-10,  -1.905183666553504e-12,
   1.511868998617441e-14,  -1.198612827854611e-16,   9.455885361193786e-19,  -7.292187322931460e-21,   1.209435183831375e-01,  -9.598110111078963e-04,   7.616615034674995e-06,
  -6.043817354512182e-08,   4.795486909027972e-10,  -3.804677246406307e-12,   3.017929090729398e-14,  -2.391492473412143e-16,   1.885798143062013e-18,  -1.453938317363532e-20,
   1.209446031075660e-01,  -9.598368326471386e-04,   7.617024860034843e-06,  -6.044359392562918e-08,   4.796132013634652e-10,  -3.805393124775428e-12,   3.018681851602597e-14,
  -2.392238148078772e-16,   1.886446450433628e-18,  -1.454242876878781e-20,   1.209463839005353e-01,  -9.598792245580937e-04,   7.617697694551121e-06,  -6.045249309457825e-08,
   4.797191173495952e-10,  -3.806568516132108e-12,   3.019917816959865e-14,  -2.393462405049918e-16,   1.887510412611505e-18,  -1.454740893972918e-20,   1.209482735169649e-01,
  -9.599242079292078e-04,   7.618411678157287e-06,  -6.046193680255663e-08,   4.798315181977083e-10,  -3.807815916247951e-12,   3.021229525227119e-14,  -2.394761587220050e-16,
   1.888638895859510e-18,  -1.455266649929074e-20,   1.209497606966275e-01,  -9.599596117275599e-04,   7.618973626240618e-06,  -6.046936977586423e-08,   4.799199896974112e-10,
  -3.808797785298877e-12,   3.022262030024720e-14,  -2.395784159357788e-16,   1.889526681629105e-18,  -1.455678478605709e-20,   1.209506189937690e-01,  -9.599800446128928e-04,
   7.619297953195930e-06,  -6.047365978095078e-08,   4.799710529166886e-10,  -3.809364504708418e-12,   3.022857982274952e-14,  -2.396374349299798e-16,   1.890038904832917e-18,
  -1.455915372214279e-20,   1.209509412960328e-01,  -9.599877174894592e-04,   7.619419744165588e-06,  -6.047527077549561e-08,   4.799902285302975e-10,  -3.809577325499892e-12,
   3.023081782169470e-14,  -2.396595979713730e-16,   1.890231224108473e-18,  -1.456004180365275e-20,   1.209509947224127e-01,  -9.599889893851691e-04,   7.619439932918933e-06,
  -6.047553782380109e-08,   4.799934072084682e-10,  -3.809612604226350e-12,   3.023118880938574e-14,  -2.396632718560647e-16,   1.890263102427762e-18,  -1.456018893788362e-20,
   2.058273484131786e-01,  -1.633451366625157e-03,   1.296231245912870e-05,  -1.028565152515906e-07,   8.161183152986018e-10,  -6.474968843630108e-12,   5.135996517431181e-14,
  -4.069658563604427e-16,   3.208006840937951e-18,  -2.469107387087182e-20,   2.058291944480521e-01,  -1.633495310930323e-03,   1.296300991902204e-05,  -1.028657398952832e-07,
   8.162281009481751e-10,  -6.476187066159805e-12,   5.137277044197210e-14,  -4.070924758009265e-16,   3.209097755876503e-18,  -2.469578177259159e-20,   2.058322250849933e-01,
  -1.633567455470352e-03,   1.296415498015199e-05,  -1.028808848951751e-07,   8.164083516341660e-10,  -6.478187249242656e-12,   5.139379549999711e-14,  -4.073003592698271e-16,
   3.210888016530699e-18,  -2.470347431498691e-20,   2.058354409227997e-01,  -1.633644010278677e-03,   1.296537007071933e-05,  -1.028969566155763e-07,   8.165996384218510e-10,
  -6.480309970016662e-12,   5.141610897642785e-14,  -4.075209629528581e-16,   3.212786731115947e-18,  -2.471158733613344e-20,   2.058379718748536e-01,  -1.633704262121291e-03,
   1.296632642014939e-05,  -1.029096063785858e-07,   8.167502015921340e-10,  -6.481980831728604e-12,   5.143367288673187e-14,  -4.076945959902208e-16,   3.214280382354991e-18,
  -2.471793650337287e-20,   2.058394325651575e-01,  -1.633739035762778e-03,   1.296687837487241e-05,  -1.029169072991094e-07,   8.168371023444230e-10,  -6.482945226653097e-12,
   5.144381060001726e-14,  -4.077948097182616e-16,   3.215142137475057e-18,  -2.472158634448606e-20,   2.058399810742564e-01,  -1.633752093823573e-03,   1.296708564441879e-05,
  -1.029196489609180e-07,   8.168697359158885e-10,  -6.483307386942917e-12,   5.144761764597575e-14,  -4.078324422350383e-16,   3.215465685810191e-18,  -2.472295417342486e-20,
   2.058400719977737e-01,  -1.633754258395277e-03,   1.296712000257982e-05,  -1.029201034355418e-07,   8.168751454752756e-10,  -6.483367421271351e-12,   5.144824873067040e-14,
  -4.078386804300561e-16,   3.215519315975721e-18,  -2.472318076693515e-20,   3.204435364924826e-01,  -2.543048514292752e-03,   2.018045353254036e-05,  -1.601327768473490e-07,
   1.270578378372509e-09,  -1.008057196866348e-11,   7.995871634121344e-14,  -6.335164733225609e-16,   4.991199992602760e-18,  -3.831311706137767e-20,   3.204464105028951e-01,
  -2.543116929245210e-03,   2.018153937687160e-05,  -1.601471382558553e-07,   1.270749295770288e-09,  -1.008246834326083e-11,   7.997863890096632e-14,  -6.337129179268673e-16,
   4.992868277236089e-18,  -3.831928682122556e-20,   3.204511287681079e-01,  -2.543229247900767e-03,   2.018332207168665e-05,  -1.601707167847841e-07,   1.271029915105063e-09,
  -1.008558197359751e-11,   8.001134980586917e-14,  -6.340354359149542e-16,   4.995605835183169e-18,  -3.832935220894633e-20,   3.204561353643932e-01,  -2.543348432708697e-03,
   2.018521379221979e-05,  -1.601957380804195e-07,   1.271327715725301e-09,  -1.008888635303699e-11,   8.004606512432884e-14,  -6.343776827116938e-16,   4.998508957616389e-18,
  -3.833994618461610e-20,   3.204600756922065e-01,  -2.543442236147642e-03,   2.018670269016702e-05,  -1.602154318934299e-07,   1.271562116658926e-09,  -1.009148733481285e-11,
   8.007339098171665e-14,  -6.346470545645116e-16,   5.000792539850025e-18,  -3.834822115628287e-20,   3.204623497766255e-01,  -2.543496373697870e-03,   2.018756200395705e-05,
  -1.602267983484643e-07,   1.271697406160379e-09,  -1.009298857973607e-11,   8.008916315961058e-14,  -6.348025230433212e-16,   5.002109961223110e-18,  -3.835297168548798e-20,
   3.204632037262902e-01,  -2.543516703217353e-03,   2.018788469270659e-05,  -1.602310667109867e-07,   1.271748211008027e-09,  -1.009355234378926e-11,   8.009508612665500e-14,
  -6.348609046463312e-16,   5.002604575420900e-18,  -3.835475080295883e-20,   3.204633452811110e-01,  -2.543520073143663e-03,   2.018793818340125e-05,  -1.602317742608540e-07,
   1.271756632759784e-09,  -1.009364579742071e-11,   8.009606796207609e-14,  -6.348705823192827e-16,   5.002686560018794e-18,  -3.835504546623693e-20,   4.753519979318881e-01,
  -3.772406225570286e-03,   2.993606609106451e-05,  -2.375439799793415e-07,   1.884799275378474e-09,  -1.495365829239646e-11,   1.186090077203127e-13,  -9.395985828805991e-16,
   7.396213452126312e-18,  -5.652128607106216e-20,   4.753562612932386e-01,  -3.772507713600232e-03,   2.993767685242406e-05,  -2.375652838845841e-07,   1.885052810119513e-09,
  -1.495647087007140e-11,   1.186385284758111e-13,  -9.398883100818361e-16,   7.398613542079225e-18,  -5.652753790601184e-20,   4.753632604570074e-01,  -3.772674329210820e-03,
   2.994032133454395e-05,  -2.376002605888433e-07,   1.885469074015088e-09,  -1.496108879757658e-11,   1.186869984744798e-13,  -9.403639664947684e-16,   7.402551428912625e-18,
  -5.653768995254630e-20,   4.753706873365370e-01,  -3.772851130201213e-03,   2.994312754740344e-05,  -2.376373775117181e-07,   1.885910824143429e-09,  -1.496598962648957e-11,
   1.187384382647091e-13,  -9.408687048235165e-16,   7.406726764634614e-18,  -5.654831039097374e-20,   4.753765324932679e-01,  -3.772990279990457e-03,   2.994533620586232e-05,
  -2.376665915754299e-07,   1.886258528683757e-09,  -1.496984722071291e-11,   1.187789284352814e-13,  -9.412659581636678e-16,   7.410010547935042e-18,  -5.655655866066470e-20,
   4.753799059130640e-01,  -3.773070588652786e-03,   2.994661092766041e-05,  -2.376834527255292e-07,   1.886459213760068e-09,  -1.497207376074974e-11,   1.188022988234666e-13,
  -9.414952294428905e-16,   7.411904787957622e-18,  -5.656127469086815e-20,   4.753811726781321e-01,  -3.773100745845132e-03,   2.994708961005504e-05,  -2.376897844710449e-07,
   1.886534576401723e-09,  -1.497290989535632e-11,   1.188110751504300e-13,  -9.415813247081581e-16,   7.412615924359442e-18,  -5.656303724122640e-20,   4.753813826632279e-01,
  -3.773105744857333e-03,   2.994716895913008e-05,  -2.376908340598899e-07,   1.886547069017666e-09,  -1.497304849909832e-11,   1.188125299793495e-13,  -9.415955963160185e-16,
   7.412733796444626e-18,  -5.656332896759065e-20,   6.979582110926879e-01,  -5.539015112528148e-03,   4.395505467502018e-05,  -3.487852417840108e-07,   2.767444349644252e-09,
  -2.195627320529479e-11,   1.741440821872386e-13,  -1.379118985120138e-15,   1.083719406193580e-17,  -8.207278999400116e-20,   6.979644709760201e-01,  -5.539164127152217e-03,
   4.395741975031509e-05,  -3.488165220340802e-07,   2.767816593240142e-09,  -2.196040135857956e-11,   1.741873325586992e-13,  -1.379539454919116e-15,   1.084049597463112e-17,
  -8.207320692243217e-20,   6.979747478315368e-01,  -5.539408768442245e-03,   4.396130263418948e-05,  -3.488678778774990e-07,   2.768427758131775e-09,  -2.196717929872817e-11,
   1.742583445276173e-13,  -1.380229724056765e-15,   1.084591185869946e-17,  -8.207367296303682e-20,   6.979856527010875e-01,  -5.539668364900218e-03,   4.396542298672702e-05,
  -3.489223761741133e-07,   2.769076342094633e-09,  -2.197437245174164e-11,   1.743337065980183e-13,  -1.380962152399200e-15,   1.085165206931739e-17,  -8.207386996465889e-20,
   6.979942351308144e-01,  -5.539872678192372e-03,   4.396866595221289e-05,  -3.489652708035051e-07,   2.769586846813839e-09,  -2.198003439489957e-11,   1.743930262652323e-13,
  -1.381538576595215e-15,   1.085616495245638e-17,  -8.207380908712131e-20,   6.979991883150781e-01,  -5.539990595203053e-03,   4.397053762176287e-05,  -3.489900278100357e-07,
   2.769881495420871e-09,  -2.198330237134772e-11,   1.744272645398342e-13,  -1.381871241850504e-15,   1.085876753956303e-17,  -8.207368723180691e-20,   6.980010483032149e-01,
  -5.540034874934137e-03,   4.397124046944479e-05,  -3.489993246291811e-07,   2.769992143883637e-09,  -2.198452959672974e-11,   1.744401220580726e-13,  -1.381996160868676e-15,
   1.085974447984373e-17,  -8.207362506227220e-20,   6.980013566238317e-01,  -5.540042214971412e-03,   4.397135697741345e-05,  -3.490008657267512e-07,   2.770010485712907e-09,
  -2.198473303047607e-11,   1.744422534129815e-13,  -1.382016867978748e-15,   1.085990640282831e-17,  -8.207361389049719e-20,   2.301427431361938e-03,  -1.770227991430411e-05,
   1.361557237136091e-07,  -1.047170389088291e-09,   8.053289128734459e-12,  -6.193005478685378e-14,   4.761957388978887e-16,  -3.660366212588994e-18,   2.809197891597302e-20,
  -2.140104167628615e-22,   2.301446821161340e-03,  -1.770272728612672e-05,   1.361626057343286e-07,  -1.047258612627228e-09,   8.054306953475056e-12,  -6.194101118281316e-14,
   4.763078844234298e-16,  -3.661464723934900e-18,   2.810210089873522e-20,  -2.140895267282522e-22,   2.301478653364897e-03,  -1.770346174664433e-05,   1.361739043140511e-07,
  -1.047403457125850e-09,   8.055978050701319e-12,  -6.195900025470664e-14,   4.764920186159819e-16,  -3.663268400528948e-18,   2.811871873199456e-20,  -2.142193252633559e-22,
   2.301512430757943e-03,  -1.770424110308294e-05,   1.361858938352467e-07,  -1.047557163667876e-09,   8.057751449425379e-12,  -6.197809127822458e-14,   4.766874388625708e-16,
  -3.665182638101225e-18,   2.813635283424082e-20,  -2.143569516316159e-22,   2.301539014442388e-03,  -1.770485448753353e-05,   1.361953302704362e-07,  -1.047678142627802e-09,
   8.059147294005931e-12,  -6.199311835143837e-14,   4.768412643231943e-16,  -3.666689440672314e-18,   2.815023189758655e-20,  -2.144651917171195e-22,   2.301554356686567e-03,
  -1.770520849445298e-05,   1.362007764698536e-07,  -1.047747966402520e-09,   8.059952931546225e-12,  -6.200179170626967e-14,   4.769300515091649e-16,  -3.667559161123510e-18,
   2.815824214790470e-20,  -2.145276300063649e-22,   2.301560117904754e-03,  -1.770534142960501e-05,   1.362028216187954e-07,  -1.047774186765629e-09,   8.060255469371170e-12,
  -6.200504881437616e-14,   4.769633941549431e-16,  -3.667885771575048e-18,   2.816125014649910e-20,  -2.145510706794900e-22,   2.301561072911926e-03,  -1.770536346561654e-05,
   1.362031606339808e-07,  -1.047778533210514e-09,   8.060305620027583e-12,  -6.200558873601050e-14,   4.769689212904586e-16,  -3.667939913080967e-18,   2.816174876900551e-20,
  -2.145549560148552e-22,   2.083968973722791e-02,  -1.602961779406580e-04,   1.232905717280699e-06,  -9.482248147291404e-09,   7.292345752482374e-11,  -5.607837180914819e-13,
   4.312004542062819e-15,  -3.314490091352956e-17,   2.543699004451494e-19,  -1.937640339494758e-21,   2.083986531408864e-02,  -1.603002289438949e-04,   1.232968034768293e-06,
  -9.483047021507453e-09,   7.293267403896253e-11,  -5.608829290887191e-13,   4.313020006749679e-15,  -3.315484672386773e-17,   2.544614966596549e-19,  -1.938354369159333e-21,
   2.084015355834814e-02,  -1.603068795682389e-04,   1.233070344704624e-06,  -9.484358604976458e-09,   7.294780600673500e-11,  -5.610458214976352e-13,   4.314687320274440e-15,
  -3.317117702051712e-17,   2.546118749908204e-19,  -1.939525886751246e-21,   2.084045941652190e-02,  -1.603139367303041e-04,   1.233178911195302e-06,  -9.485750435259488e-09,
   7.296386432568143e-11,  -5.612186921581367e-13,   4.316456827468033e-15,  -3.318850831317571e-17,   2.547714492537101e-19,  -1.940768033514288e-21,   2.084070013483799e-02,
  -1.603194909969549e-04,   1.233264359199128e-06,  -9.486845913550447e-09,   7.297650385062324e-11,  -5.613547634387516e-13,   4.317849698634889e-15,  -3.320215072670030e-17,
   2.548970431070977e-19,  -1.941744938262144e-21,   2.084083906062126e-02,  -1.603226965702702e-04,   1.233313675160007e-06,  -9.487478175800197e-09,   7.298379898641734e-11,
  -5.614333013193755e-13,   4.318653655929279e-15,  -3.321002507021422e-17,   2.549695289902897e-19,  -1.942308459247361e-21,   2.084089122911368e-02,  -1.603239003133402e-04,
   1.233332194218432e-06,  -9.487715604180904e-09,   7.298653849941548e-11,  -5.614627946781479e-13,   4.318955569565587e-15,  -3.321298216101462e-17,   2.549967487653663e-19,
  -1.942520015885781e-21,   2.084089987681332e-02,  -1.603240998519556e-04,   1.233335264039850e-06,  -9.487754961735437e-09,   7.298699261907833e-11,  -5.614676837091265e-13,
   4.319005617110432e-15,  -3.321347235150763e-17,   2.550012608645679e-19,  -1.942555081729053e-21,   5.862241499064849e-02,  -4.509159773063130e-04,   3.468185539632238e-06,
  -2.667373133786333e-08,   2.051349696436363e-10,  -1.577494250325388e-12,   1.212972965915871e-14,  -9.323638818797800e-17,   7.155102950168066e-19,  -5.449141736938825e-21,
   5.862290889145609e-02,  -4.509273728498909e-04,   3.468360839821580e-06,  -2.667597858476096e-08,   2.051608958262451e-10,  -1.577773330084247e-12,   1.213258602553496e-14,
  -9.326435800028085e-17,   7.157676033793364e-19,  -5.451136519907057e-21,   5.862371972764466e-02,  -4.509460811735082e-04,   3.468648639473041e-06,  -2.667966809159497e-08,
   2.052034622620606e-10,  -1.578231545139004e-12,   1.213727595453631e-14,  -9.331028234662757e-17,   7.161900378711423e-19,  -5.454409288447493e-21,   5.862458011208487e-02,
  -4.509659330949078e-04,   3.468954038921960e-06,  -2.668358333409209e-08,   2.052486345362925e-10,  -1.578717828913436e-12,   1.214225333925219e-14,  -9.335902164389438e-17,
   7.166383020638315e-19,  -5.457879234955959e-21,   5.862525725695595e-02,  -4.509815573449907e-04,   3.469194405660482e-06,  -2.668666493334175e-08,   2.052841896952726e-10,
  -1.579100596312256e-12,   1.214617129671979e-14,  -9.339738697595102e-17,   7.169911088293162e-19,  -5.460608129456171e-21,   5.862564805763590e-02,  -4.509905746792827e-04,
   3.469333132326315e-06,  -2.668844349790972e-08,   2.053047110133564e-10,  -1.579321522721045e-12,   1.214843271903351e-14,  -9.341953126399836e-17,   7.171947286670207e-19,
  -5.462182235287336e-21,   5.862579480852569e-02,  -4.509939608297763e-04,   3.469385226763569e-06,  -2.668911138802241e-08,   2.053124173013663e-10,  -1.579404487294135e-12,
   1.214928196087612e-14,  -9.342784721325525e-17,   7.172711914750767e-19,  -5.462773177615776e-21,   5.862581913465736e-02,  -4.509945221354219e-04,   3.469393862225241e-06,
  -2.668922210149925e-08,   2.053136947462671e-10,  -1.579418240097575e-12,   1.214942273778350e-14,  -9.342922572983080e-17,   7.172838663607486e-19,  -5.462871126842337e-21,
   1.172217237090558e-01,  -9.016542241727786e-04,   6.935004078407196e-06,  -5.333694899916987e-08,   4.101890738111833e-10,  -3.154365922890841e-12,   2.425462846254657e-14,
  -1.864333906609696e-16,   1.430617826549074e-18,  -1.089127922674125e-20,   1.172227113159977e-01,  -9.016770107682806e-04,   6.935354609680828e-06,  -5.334144260599190e-08,
   4.102409158449905e-10,  -3.154923964110153e-12,   2.426033956399666e-14,  -1.864892931496664e-16,   1.431131175798280e-18,  -1.089522240228127e-20,   1.172243326687801e-01,
  -9.017144200414639e-04,   6.935930095530234e-06,  -5.334882016342783e-08,   4.103260317534078e-10,  -3.155840199932643e-12,   2.426971674025933e-14,  -1.865810807038651e-16,
   1.431973956600310e-18,  -1.090169150296116e-20,   1.172260530985361e-01,  -9.017541160594521e-04,   6.936540774036443e-06,  -5.335664910308143e-08,   4.104163582991470e-10,
  -3.156812561217606e-12,   2.427966865912664e-14,  -1.866784941888261e-16,   1.432868259162423e-18,  -1.090854991092722e-20,   1.172274071213786e-01,  -9.017853584011809e-04,
   6.937021412758358e-06,  -5.336281108526947e-08,   4.104874544463724e-10,  -3.157577933604410e-12,   2.428750232700071e-14,  -1.867551734393882e-16,   1.433572113626499e-18,
  -1.091394329487039e-20,   1.172281885687026e-01,  -9.018033895155023e-04,   6.937298811402467e-06,  -5.336636751240022e-08,   4.105284889033305e-10,  -3.158019692659372e-12,
   2.429202387333831e-14,  -1.867994322746323e-16,   1.433978335164691e-18,  -1.091705422630023e-20,   1.172284820126396e-01,  -9.018101604818079e-04,   6.937402979740776e-06,
  -5.336770302900656e-08,   4.105438984077863e-10,  -3.158185586590674e-12,   2.429372186922515e-14,  -1.868160529920855e-16,   1.434130877902722e-18,  -1.091822209088746e-20,
   1.172285306553147e-01,  -9.018112828718556e-04,   6.937420247259927e-06,  -5.336792441226115e-08,   4.105464527884223e-10,  -3.158213086359864e-12,   2.429400334216569e-14,
  -1.868188081711256e-16,   1.434156164177119e-18,  -1.091841566420637e-20,   1.994934237900888e-01,  -1.534477420755831e-03,   1.180231499379538e-05,  -9.077131950901561e-08,
   6.980789644698684e-10,  -5.368245698554271e-12,   4.127753395805755e-14,  -3.172742164562972e-16,   2.434377257269412e-18,  -1.852257914617534e-20,   1.994951045458730e-01,
  -1.534516200051967e-03,   1.180291154432161e-05,  -9.077896693658550e-08,   6.981671913804761e-10,  -5.369195377639235e-12,   4.128725205827503e-14,  -3.173692855728226e-16,
   2.435247837962741e-18,  -1.852916974562029e-20,   1.994978638400331e-01,  -1.534579864906283e-03,   1.180389093307252e-05,  -9.079152240444642e-08,   6.983120451407737e-10,
  -5.370754635067590e-12,   4.130320840057323e-14,  -3.175253812621986e-16,   2.436677076939883e-18,  -1.853998128895236e-20,   1.995007917480306e-01,  -1.534647421450077e-03,
   1.180493021433353e-05,  -9.080484605537501e-08,   6.984657665756251e-10,  -5.372409407057778e-12,   4.132014272171773e-14,  -3.176910439290369e-16,   2.438193663274381e-18,
  -1.855144227697449e-20,   1.995030960875687e-01,  -1.534700591131424e-03,   1.180574818780371e-05,  -9.081533280111087e-08,   6.985867609244495e-10,  -5.373711923589179e-12,
   4.133347258953107e-14,  -3.178214452536704e-16,   2.439387262600326e-18,  -1.856045422059020e-20,   1.995044259912523e-01,  -1.534731277326815e-03,   1.180622027779805e-05,
  -9.082138529296425e-08,   6.986565950509898e-10,  -5.374463712440934e-12,   4.134116650625453e-14,  -3.178967119982757e-16,   2.440076127079996e-18,  -1.856565200855287e-20,
   1.995049253878984e-01,  -1.534742800474600e-03,   1.180639755635108e-05,  -9.082365813676978e-08,   6.986828195792918e-10,  -5.374746031958560e-12,   4.134405583549160e-14,
  -3.179249772214717e-16,   2.440334805344116e-18,  -1.856760322737582e-20,   1.995050081702829e-01,  -1.534744710610585e-03,   1.180642694302326e-05,  -9.082403489701096e-08,
   6.986871667292829e-10,  -5.374792831268312e-12,   4.134453479303500e-14,  -3.179296626823854e-16,   2.440377685116211e-18,  -1.856792663802920e-20,   3.105825281197394e-01,
  -2.388960335739656e-03,   1.837450457122630e-05,  -1.413178701402314e-07,   1.086808339328080e-09,  -8.357580450913658e-12,   6.426286752555842e-14,  -4.939339044835436e-16,
   3.789221327957670e-18,  -2.880649073983549e-20,   3.105851448144180e-01,  -2.389020709518100e-03,   1.837543331441584e-05,  -1.413297760760694e-07,   1.086945695226158e-09,
  -8.359058912956589e-12,   6.427799405167399e-14,  -4.940817493115571e-16,   3.790569317578751e-18,  -2.881646054518606e-20,   3.105894406380069e-01,  -2.389119826526195e-03,
   1.837695808154295e-05,  -1.413493231189143e-07,   1.087171210522706e-09,  -8.361486367270954e-12,   6.430283057545987e-14,  -4.943244973406511e-16,   3.792782275134831e-18,
  -2.883281333397412e-20,   3.105939989690557e-01,  -2.389225002334258e-03,   1.837857609267545e-05,  -1.413700661113321e-07,   1.087410531434644e-09,  -8.364062518324301e-12,
   6.432918932433533e-14,  -4.945821217698091e-16,   3.795130412234057e-18,  -2.885014546901077e-20,   3.105975864938249e-01,  -2.389307779869726e-03,   1.837984955947415e-05,
  -1.413863924536952e-07,   1.087598901242619e-09,  -8.366090277304860e-12,   6.434993761936801e-14,  -4.947849097343655e-16,   3.796978420373066e-18,  -2.886377183212821e-20,
   3.105996569623155e-01,  -2.389355553856009e-03,   1.838058453555291e-05,  -1.413958153057806e-07,   1.087707622359776e-09,  -8.367260662769048e-12,   6.436191339787197e-14,
  -4.949019571313336e-16,   3.798044946382113e-18,  -2.887163019869397e-20,   3.106004344509660e-01,  -2.389373493737352e-03,   1.838086053270875e-05,  -1.413993537939748e-07,
   1.087748449962695e-09,  -8.367700177985593e-12,   6.436641071129841e-14,  -4.949459123320303e-16,   3.798445438283716e-18,  -2.887458001926965e-20,   3.106005633312155e-01,
  -2.389376467543950e-03,   1.838090628352182e-05,  -1.413999403550318e-07,   1.087755217814193e-09,  -8.367773035181376e-12,   6.436715622064547e-14,  -4.949531986801953e-16,
   3.798511825588942e-18,  -2.887506893754068e-20,   4.607239917542552e-01,  -3.543828909718499e-03,   2.725708731867055e-05,  -2.096335976398729e-07,   1.612191875071656e-09,
  -1.239778106004840e-11,   9.532801552629988e-14,  -7.326715368312068e-16,   5.619179472325036e-18,  -4.265785463123622e-20,   4.607278734085909e-01,  -3.543918469321661e-03,
   2.725846503372834e-05,  -2.096512591123584e-07,   1.612395629742935e-09,  -1.239997411455543e-11,   9.535044685898892e-14,  -7.328904529111686e-16,   5.621161010002630e-18,
  -4.267192564317273e-20,   4.607342459144839e-01,  -3.544065501363388e-03,   2.726072690186729e-05,  -2.096802555358695e-07,   1.612730160652425e-09,  -1.240357484167213e-11,
   9.538727722933573e-14,  -7.332498910057254e-16,   5.624413927515155e-18,  -4.269499976339691e-20,   4.607410078289035e-01,  -3.544221521143404e-03,   2.726312708991032e-05,
  -2.097110260516144e-07,   1.613085170888790e-09,  -1.240739613465795e-11,   9.542636485572428e-14,  -7.336313531166033e-16,   5.627865389544871e-18,  -4.271944812922850e-20,
   4.607463296309420e-01,  -3.544344314902836e-03,   2.726501617442918e-05,  -2.097352448317205e-07,   1.613364599906248e-09,  -1.241040397808167e-11,   9.545713263922658e-14,
  -7.339316168141858e-16,   5.630581608561116e-18,  -4.273866365985453e-20,   4.607494010030280e-01,  -3.544415183736336e-03,   2.726610645172030e-05,  -2.097492228542759e-07,
   1.613525877524957e-09,  -1.241214005005606e-11,   9.547489157992411e-14,  -7.341049252999943e-16,   5.632149150998787e-18,  -4.274974308628033e-20,   4.607505543443849e-01,
  -3.544441796095127e-03,   2.726651587107428e-05,  -2.097544719091535e-07,   1.613586441458189e-09,  -1.241279199763941e-11,   9.548156066424394e-14,  -7.341700082204794e-16,
   5.632737771002089e-18,  -4.275390158404746e-20,   4.607507455277826e-01,  -3.544446207495998e-03,   2.726658373868789e-05,  -2.097553420240179e-07,   1.613596480933325e-09,
  -1.241290006914512e-11,   9.548266618287639e-14,  -7.341807968497618e-16,   5.632835342781123e-18,  -4.275459081231444e-20,   6.764799443195185e-01,  -5.203395582493578e-03,
   4.002151662553481e-05,  -3.078045097724487e-07,   2.367177081787156e-09,  -1.820360006117511e-11,   1.399678426717624e-13,  -1.075669023078694e-15,   8.245441301649133e-18,
  -6.242093543302218e-20,   6.764856437433673e-01,  -5.203527082644417e-03,   4.002353952089749e-05,  -3.078304420214401e-07,   2.367476249637885e-09,  -1.820681976810508e-11,
   1.400007567764798e-13,  -1.075989305994769e-15,   8.248298054768248e-18,  -6.243947447078242e-20,   6.764950004786459e-01,  -5.203742969439144e-03,   4.002686061587964e-05,
  -3.078730173202204e-07,   2.367967432911199e-09,  -1.821210613041106e-11,   1.400547988325065e-13,  -1.076515170509285e-15,   8.252987378629006e-18,  -6.246985759975723e-20,
   6.765049289815397e-01,  -5.203972052908455e-03,   4.003038480560567e-05,  -3.079181975089663e-07,   2.368488685416691e-09,  -1.821771631039164e-11,   1.401121528104364e-13,
  -1.077073246087368e-15,   8.257962430731225e-18,  -6.250202598809708e-20,   6.765127429708424e-01,  -5.204152350691307e-03,   4.003315854338234e-05,  -3.079537578178820e-07,
   2.368898963906735e-09,  -1.822213223289853e-11,   1.401572987862910e-13,  -1.077512521523758e-15,   8.261877324359745e-18,  -6.252729151251837e-20,   6.765172526591868e-01,
  -5.204256407229780e-03,   4.003475939462906e-05,  -3.079742816755842e-07,   2.369135763702167e-09,  -1.822468102128175e-11,   1.401833566559754e-13,  -1.077766062806958e-15,
   8.264136484859331e-18,  -6.254185218083606e-20,   6.765189461075639e-01,  -5.204295482092448e-03,   4.003536054397738e-05,  -3.079819888354897e-07,   2.369224688171099e-09,
  -1.822563816829608e-11,   1.401931422583258e-13,  -1.077861275149589e-15,   8.264984783909910e-18,  -6.254731596459824e-20,   6.765192268216929e-01,  -5.204301959341778e-03,
   4.003546019381389e-05,  -3.079832664206066e-07,   2.369239428874670e-09,  -1.822579683183795e-11,   1.401947643943310e-13,  -1.077877058225593e-15,   8.265125399601753e-18,
  -6.254822145949953e-20,   2.232720191569261e-03,  -1.666119807386662e-05,   1.243238414108764e-07,  -9.276387187465451e-10,   6.921169591724389e-12,  -5.163636390026974e-14,
   3.852144135526277e-16,  -2.873352298100342e-18,   2.142099909422270e-20,  -1.592843993954195e-22,   2.232737895658740e-03,  -1.666159436315800e-05,   1.243297556757238e-07,
  -9.277122737074979e-10,   6.921992890326112e-12,  -5.164496385369205e-14,   3.852999237801784e-16,  -2.874170049550887e-18,   2.142851430762733e-20,  -1.593487302967842e-22,
   2.232766960396837e-03,  -1.666224495889977e-05,   1.243394654073590e-07,  -9.278330349349874e-10,   6.923344600279802e-12,  -5.165908383697236e-14,   3.854403243175799e-16,
  -2.875512759139634e-18,   2.144085376098099e-20,  -1.594543380931501e-22,   2.232797801159479e-03,  -1.666293532216715e-05,   1.243497688745505e-07,  -9.279611839668572e-10,
   6.924779048511244e-12,  -5.167406863363459e-14,   3.855893295804681e-16,  -2.876937801575824e-18,   2.145394961036463e-20,  -1.595663936062631e-22,   2.232822073602133e-03,
  -1.666347866406223e-05,   1.243578782580711e-07,  -9.280620466437477e-10,   6.925908096786003e-12,  -5.168586348749966e-14,   3.857066188244615e-16,  -2.878059551891046e-18,
   2.146425809183387e-20,  -1.596545799884818e-22,   2.232836081944101e-03,  -1.666379224626448e-05,   1.243625585425930e-07,  -9.281202599607436e-10,   6.926559744730267e-12,
  -5.169267122592140e-14,   3.857743172873058e-16,  -2.878707029903425e-18,   2.147020811091811e-20,  -1.597054732911749e-22,   2.232841342261300e-03,  -1.666391000119512e-05,
   1.243643160739107e-07,  -9.281421203005509e-10,   6.926804454862631e-12,  -5.169522773125980e-14,   3.857997403487918e-16,  -2.878950182096808e-18,   2.147244255204776e-20,
  -1.597245840816765e-22,   2.232842214236571e-03,  -1.666392952084984e-05,   1.243646074118850e-07,  -9.281457439996182e-10,   6.926845019589408e-12,  -5.169565151556961e-14,
   3.858039546703605e-16,  -2.878990488990271e-18,   2.147281295054929e-20,  -1.597277519607303e-22,   2.021753778906408e-02,  -1.508690622950890e-04,   1.125766664033807e-06,
  -8.399875147296433e-09,   6.267198551058639e-11,  -4.675731969747816e-13,   3.488160182770073e-15,  -2.601850413874950e-17,   1.939681698657712e-19,  -1.442279856254354e-21,
   2.021769810162783e-02,  -1.508726507401404e-04,   1.125820218381213e-06,  -8.400541195902612e-09,   6.267944057268393e-11,  -4.676510704432255e-13,   3.488934481675392e-15,
  -2.602590865602722e-17,   1.940362066396703e-19,  -1.442861808590206e-21,   2.021796128616973e-02,  -1.508785419593097e-04,   1.125908141116264e-06,  -8.401634702665453e-09,
   6.269168045941993e-11,  -4.677789283527542e-13,   3.490205814732044e-15,  -2.603806652461275e-17,   1.941479181599484e-19,  -1.443817157664711e-21,   2.021824055281788e-02,
  -1.508847932779913e-04,   1.126001440194965e-06,  -8.402795106843995e-09,   6.270466955061997e-11,  -4.679146172360177e-13,   3.491555063902410e-15,  -2.605096989184893e-17,
   1.942664773597507e-19,  -1.444830829050446e-21,   2.021846034257408e-02,  -1.508897133012596e-04,   1.126074871594048e-06,  -8.403708429949149e-09,   6.271489321061376e-11,
  -4.680214208567344e-13,   3.492617123095067e-15,  -2.606112703033511e-17,   1.943598019010496e-19,  -1.445628572971314e-21,   2.021858718971963e-02,  -1.508925528241192e-04,
   1.126117252107891e-06,  -8.404235558209821e-09,   6.272079395654518e-11,  -4.680830656314385e-13,   3.493230135597015e-15,  -2.606698976363223e-17,   1.944136684604523e-19,
  -1.446088958042669e-21,   2.021863482249607e-02,  -1.508936191085415e-04,   1.126133166755812e-06,  -8.404433506093475e-09,   6.272300983450531e-11,  -4.681062150513351e-13,
   3.493460342512630e-15,  -2.606919143895288e-17,   1.944338972384550e-19,  -1.446261835574588e-21,   2.021864271833231e-02,  -1.508937958612570e-04,   1.126135804854628e-06,
  -8.404466319104056e-09,   6.272337715269991e-11,  -4.681100524620297e-13,   3.493498503375601e-15,  -2.606955640662755e-17,   1.944372505191273e-19,  -1.446290492412877e-21,
   5.687229058129688e-02,  -4.243973346353362e-04,   3.166801492371473e-06,  -2.362899701520413e-08,   1.762974005053639e-10,  -1.315291600096280e-12,   9.812252730750501e-15,
  -7.319032814523361e-17,   5.456273750989683e-19,  -4.056811030177191e-21,   5.687274154336775e-02,  -4.244074289945879e-04,   3.166952141695152e-06,  -2.363087062160495e-08,
   1.763183717188791e-10,  -1.315510658959811e-12,   9.814430811550623e-15,  -7.321115531030402e-17,   5.458186786571209e-19,  -4.058444680484076e-21,   5.687348188612854e-02,
  -4.244240010980684e-04,   3.167199469899354e-06,  -2.363394667529052e-08,   1.763528027235276e-10,  -1.315870324563564e-12,   9.818007035043871e-15,  -7.324535252212133e-17,
   5.461327848870631e-19,  -4.061126504167249e-21,   5.687426746813799e-02,  -4.244415861678311e-04,   3.167461921853045e-06,  -2.363721091257790e-08,   1.763893412527004e-10,
  -1.316252018770883e-12,   9.821802434008433e-15,  -7.328164662891058e-17,   5.464661444271380e-19,  -4.063972018416784e-21,   5.687488574060083e-02,  -4.244554262801042e-04,
   3.167668485673606e-06,  -2.363978010647578e-08,   1.764181005779279e-10,  -1.316552458437217e-12,   9.824789975619926e-15,  -7.331021623455599e-17,   5.467285497305211e-19,
  -4.066211373055440e-21,   5.687524256385973e-02,  -4.244634139080147e-04,   3.167787702806413e-06,  -2.364126292750906e-08,   1.764346994741359e-10,  -1.316725865810955e-12,
   9.826514361859033e-15,  -7.332670669881136e-17,   5.468800088282740e-19,  -4.067503715710822e-21,   5.687537655570045e-02,  -4.244664133849104e-04,   3.167832470991663e-06,
  -2.364181975837405e-08,   1.764409327755987e-10,  -1.316790985362589e-12,   9.827161927161759e-15,  -7.333289948312656e-17,   5.469368869788334e-19,  -4.067988996975492e-21,
   5.687539876682711e-02,  -4.244669105934180e-04,   3.167839892010153e-06,  -2.364191206194773e-08,   1.764419660477736e-10,  -1.316801780037558e-12,   9.827269272549266e-15,
  -7.333392604956151e-17,   5.469463155443913e-19,  -4.068069438959633e-21,   1.137221647092835e-01,  -8.486273912694628e-04,   6.332354776381491e-06,  -4.724868053716014e-08,
   3.525253103157951e-10,  -2.630064595003533e-12,   1.962062673300920e-14,  -1.463512080054606e-16,   1.091011772774776e-18,  -8.110880914392852e-21,   1.137230664556766e-01,
  -8.486475760092205e-04,   6.332656015647648e-06,  -4.725242701120332e-08,   3.525672444516527e-10,  -2.630502624495573e-12,   1.962498191902746e-14,  -1.463928479731808e-16,
   1.091394024468842e-18,  -8.114136389540032e-21,   1.137245468493889e-01,  -8.486807136841983e-04,   6.333150574567078e-06,  -4.725857790569199e-08,   3.526360928481380e-10,
  -2.631221810819775e-12,   1.963213276340378e-14,  -1.464612187742431e-16,   1.092021651565772e-18,  -8.119480551379104e-21,   1.137261177037673e-01,  -8.487158768924742e-04,
   6.333675375024158e-06,  -4.726510509318115e-08,   3.527091554601855e-10,  -2.631985045459522e-12,   1.963972185943068e-14,  -1.465337818620444e-16,   1.092687746969405e-18,
  -8.125150805987626e-21,   1.137273540049983e-01,  -8.487435516618658e-04,   6.334088421244307e-06,  -4.727024246794432e-08,   3.527666627398411e-10,  -2.632585803739725e-12,
   1.964569560222519e-14,  -1.465909012553672e-16,   1.093212064880130e-18,  -8.129613094789455e-21,   1.137280675108726e-01,  -8.487595237693206e-04,   6.334326808518262e-06,
  -4.727320752533408e-08,   3.527998539693504e-10,  -2.632932548613086e-12,   1.964914360070528e-14,  -1.466238707289257e-16,   1.093514697984157e-18,  -8.132188274875082e-21,
   1.137283354417406e-01,  -8.487655215408521e-04,   6.334416327242547e-06,  -4.727432096750534e-08,   3.528123181077265e-10,  -2.633062761475591e-12,   1.965043844058903e-14,
  -1.466362519927736e-16,   1.093628347089211e-18,  -8.133155262675860e-21,   1.137283798552393e-01,  -8.487665157618899e-04,   6.334431166354393e-06,  -4.727450553825734e-08,
   3.528143842435359e-10,  -2.633084346475623e-12,   1.965065308316866e-14,  -1.466383044118881e-16,   1.093647186443582e-18,  -8.133315553795499e-21,   1.935377102540060e-01,
  -1.444233871072521e-03,   1.077669816621992e-05,  -8.041001910153684e-08,   5.999440905407336e-10,  -4.475966744458123e-12,   3.339127323982848e-14,  -2.490657878701016e-16,
   1.856662348615171e-18,  -1.380049932033160e-20,   1.935392448882841e-01,  -1.444268222408705e-03,   1.077721082931715e-05,  -8.041639502597233e-08,   6.000154559531441e-10,
  -4.476712198665843e-12,   3.339868479486266e-14,  -2.491366366705717e-16,   1.857312150352840e-18,  -1.380601032808319e-20,   1.935417642916921e-01,  -1.444324617657153e-03,
   1.077805249285797e-05,  -8.042686290537026e-08,   6.001326252732902e-10,  -4.477936135561155e-12,   3.341085393469821e-14,  -2.492529668485602e-16,   1.858379068793326e-18,
  -1.381505696176640e-20,   1.935444376453017e-01,  -1.444384460053105e-03,   1.077894562286442e-05,  -8.043797117775689e-08,   6.002569665357575e-10,  -4.479235035401757e-12,
   3.342376887814375e-14,  -2.493764298909015e-16,   1.859511374031433e-18,  -1.382465534540730e-20,   1.935465416406840e-01,  -1.444431558272778e-03,   1.077964856427437e-05,
  -8.044671420195889e-08,   6.003548350285368e-10,  -4.480257427164328e-12,   3.343393484977086e-14,  -2.494736160323543e-16,   1.860402665003198e-18,  -1.383220874179640e-20,
   1.935477559184242e-01,  -1.444458740353861e-03,   1.078005426290636e-05,  -8.045176027504167e-08,   6.004113213658201e-10,  -4.480847529882439e-12,   3.343980256973038e-14,
  -2.495297121031180e-16,   1.860917110854621e-18,  -1.383656771890451e-20,   1.935482118957336e-01,  -1.444468947642570e-03,   1.078020661006557e-05,  -8.045365518290682e-08,
   6.004325334008515e-10,  -4.481069130745518e-12,   3.344200609659961e-14,  -2.495507782566464e-16,   1.861110302553890e-18,  -1.383820451333141e-20,   1.935482874807075e-01,
  -1.444470639654532e-03,   1.078023186396137e-05,  -8.045396929402875e-08,   6.004360496443194e-10,  -4.481105864863231e-12,   3.344237137008773e-14,  -2.495542703533762e-16,
   1.861142327485026e-18,  -1.383847583306490e-20,   3.013103399360931e-01,  -2.248464126540602e-03,   1.677776689291522e-05,  -1.251868182663323e-07,   9.340265258351282e-10,
  -6.968434473343454e-12,   5.198533465043285e-14,  -3.877558676873130e-16,   2.890383202864060e-18,  -2.147828535501311e-20,   3.013127291406330e-01,  -2.248517606623402e-03,
   1.677856503550660e-05,  -1.251967446607263e-07,   9.341376313487399e-10,  -6.969595026530525e-12,   5.199687264952894e-14,  -3.878661307640938e-16,   2.891393096750855e-18,
  -2.148679469370657e-20,   3.013166514888733e-01,  -2.248605405902605e-03,   1.677987538439482e-05,  -1.252130416385758e-07,   9.343200468491238e-10,  -6.971500500789165e-12,
   5.201581705285482e-14,  -3.880471769539958e-16,   2.893051244084367e-18,  -2.150076278917654e-20,   3.013208135154042e-01,  -2.248698571893976e-03,   1.678126585915596e-05,
  -1.252303356158924e-07,   9.345136280135902e-10,  -6.973522680269342e-12,   5.203592248503968e-14,  -3.882393237692664e-16,   2.894810996566480e-18,  -2.151558215240418e-20,
   3.013240891331790e-01,  -2.248771897038430e-03,   1.678236023766967e-05,  -1.252439472430502e-07,   9.346659949454029e-10,  -6.975114380778858e-12,   5.205174843045940e-14,
  -3.883905753199081e-16,   2.896196169667436e-18,  -2.152724370598057e-20,   3.013259795887298e-01,  -2.248814215623628e-03,   1.678299185199710e-05,  -1.252518032507411e-07,
   9.347539359120352e-10,  -6.976033076330114e-12,   5.206088304142192e-14,  -3.884778779719920e-16,   2.896995675719363e-18,  -2.153397326607768e-20,   3.013266894797270e-01,
  -2.248830106901988e-03,   1.678322903457773e-05,  -1.252547533488695e-07,   9.347869599484639e-10,  -6.976378073425014e-12,   5.206431339574275e-14,  -3.885106633342695e-16,
   2.897295916244448e-18,  -2.153650017827365e-20,   3.013268071546448e-01,  -2.248832741120911e-03,   1.678326835125556e-05,  -1.252552423745630e-07,   9.347924342253123e-10,
  -6.976435262569709e-12,   5.206488203752451e-14,  -3.885160981012301e-16,   2.897345686361126e-18,  -2.153691904461302e-20,   4.469694525723999e-01,  -3.335414177879031e-03,
   2.488845648076735e-05,  -1.857044917126902e-07,   1.385552566792659e-09,  -1.033710483200527e-11,   7.711586510617089e-14,  -5.751955692922401e-16,   4.287234804728420e-18,
  -3.184415720784845e-20,   4.469729967635663e-01,  -3.335493511244389e-03,   2.488964046054055e-05,  -1.857192167098507e-07,   1.385717382443057e-09,  -1.033882639071203e-11,
   7.713297905246693e-14,  -5.753590431738641e-16,   4.288728642094629e-18,  -3.185660782873704e-20,   4.469788152490717e-01,  -3.335623754354166e-03,   2.489158425679457e-05,
  -1.857433919483863e-07,   1.385987980436480e-09,  -1.034165296135812e-11,   7.716107867009214e-14,  -5.756274580947139e-16,   4.291181349388983e-18,  -3.187704437219929e-20,
   4.469849892778829e-01,  -3.335761958546178e-03,   2.489364691327934e-05,  -1.857690461543426e-07,   1.386275141746206e-09,  -1.034465265165684e-11,   7.719090038773935e-14,
  -5.759123297024811e-16,   4.293784311292035e-18,  -3.189872479457095e-20,   4.469898483911937e-01,  -3.335870730450971e-03,   2.489527033500613e-05,  -1.857892378939074e-07,
   1.386501165219650e-09,  -1.034701377154226e-11,   7.721437447339345e-14,  -5.761365704968870e-16,   4.295833181225815e-18,  -3.191578424459178e-20,   4.469926527286842e-01,
  -3.335933506639882e-03,   2.489620728361133e-05,  -1.858008916410544e-07,   1.386631618214522e-09,  -1.034837655945181e-11,   7.722792352585172e-14,  -5.762660024179782e-16,
   4.297015754334785e-18,  -3.192562831450234e-20,   4.469937057944051e-01,  -3.335957080062473e-03,   2.489655912472456e-05,  -1.858052678711936e-07,   1.386680606582539e-09,
  -1.034888832622317e-11,   7.723301165085124e-14,  -5.763146088262371e-16,   4.297459846887068e-18,  -3.192932461932355e-20,   4.469938803556021e-01,  -3.335960987712598e-03,
   2.489661744782594e-05,  -1.858059933009540e-07,   1.386688727209740e-09,  -1.034897316028149e-11,   7.723385509733854e-14,  -5.763226662153452e-16,   4.297533462881025e-18,
  -3.192993732200450e-20,   6.562841870630315e-01,  -4.897380726207263e-03,   3.654366161157286e-05,  -2.726694637838505e-07,   2.034403456985136e-09,  -1.517793950930605e-11,
   1.132285933597108e-13,  -8.445338095975421e-16,   6.293775823153541e-18,  -4.670821983675090e-20,   6.562893909905135e-01,  -4.897497211199014e-03,   3.654540004618256e-05,
  -2.726910844516407e-07,   2.034645454398052e-09,  -1.518046719250104e-11,   1.132537168462459e-13,  -8.447735760606227e-16,   6.295957033272783e-18,  -4.672600224742107e-20,
   6.562979342589785e-01,  -4.897688446847463e-03,   3.654825411747492e-05,  -2.727265808795348e-07,   2.035042771114962e-09,  -1.518461731188523e-11,   1.132949674008948e-13,
  -8.451672573109799e-16,   6.299538244093837e-18,  -4.675518689287057e-20,   6.563069995708360e-01,  -4.897891371734025e-03,   3.655128271095292e-05,  -2.727642488706046e-07,
   2.035464407597159e-09,  -1.518902161386885e-11,   1.133387459709077e-13,  -8.455850729537693e-16,   6.303338729863079e-18,  -4.678614305159965e-20,   6.563141341953834e-01,
  -4.898051081263234e-03,   3.655366637710811e-05,  -2.727938963391278e-07,   2.035796275912550e-09,  -1.519248833286344e-11,   1.133732061217366e-13,  -8.459139607824710e-16,
   6.306330125244489e-18,  -4.681049770173751e-20,   6.563182517974683e-01,  -4.898143255392163e-03,   3.655504209645577e-05,  -2.728110074998560e-07,   2.035987818916077e-09,
  -1.519448924871538e-11,   1.133930962285293e-13,  -8.461037943193020e-16,   6.308056675268073e-18,  -4.682455002246479e-20,   6.563197980113681e-01,  -4.898177868192508e-03,
   3.655555870390258e-05,  -2.728174331049666e-07,   2.036059748112362e-09,  -1.519524065117561e-11,   1.134005656301630e-13,  -8.461750836024335e-16,   6.308705041654574e-18,
  -4.682982619763055e-20,   6.563200543191596e-01,  -4.898183605785896e-03,   3.655564433956982e-05,  -2.728184982512286e-07,   2.036071671558889e-09,  -1.519536520892839e-11,
   1.134018038151282e-13,  -8.461869010801407e-16,   6.308812519228729e-18,  -4.683070076691380e-20,   2.167996638395486e-03,  -1.570932679705977e-05,   1.138240846833493e-07,
  -8.246855294755825e-10,   5.974755963613652e-12,  -4.328419821019802e-14,   3.135556325459661e-16,  -2.271258148135411e-18,   1.644864010143342e-20,  -1.190141510041535e-22,
   2.168012846665640e-03,  -1.570967909131752e-05,   1.138291899904052e-07,  -8.247471834684297e-10,   5.975426062741344e-12,  -4.329099552788635e-14,   3.136212881845834e-16,
  -2.271869146151383e-18,   1.645414613108552e-20,  -1.190618443125145e-22,   2.168039455690808e-03,  -1.571025745841327e-05,   1.138375715922405e-07,  -8.248484054745811e-10,
   5.976526240301535e-12,  -4.330215574589746e-14,   3.137290884119748e-16,  -2.272872375003438e-18,   1.646318692135758e-20,  -1.191401526491134e-22,   2.168067690638839e-03,
  -1.571087117650531e-05,   1.138464656823950e-07,  -8.249558193594792e-10,   5.977693751543365e-12,  -4.331399939529456e-14,   3.138434943580219e-16,  -2.273937118565994e-18,
   1.647278227884436e-20,  -1.192232602055828e-22,   2.168089912209594e-03,  -1.571135419462450e-05,   1.138534657856101e-07,  -8.250403615398098e-10,   5.978612688823163e-12,
  -4.332332170980398e-14,   3.139335480606070e-16,  -2.274775251286239e-18,   1.648033559882750e-20,  -1.192886781169852e-22,   2.168102736920370e-03,  -1.571163296134488e-05,
   1.138575058454259e-07,  -8.250891552467077e-10,   5.979143065504094e-12,  -4.332870232104040e-14,   3.139855260760783e-16,  -2.275259023799243e-18,   1.648469545818827e-20,
  -1.193264368085040e-22,   2.168107552766065e-03,  -1.571173764244157e-05,   1.138590229589401e-07,  -8.251074782908169e-10,   5.979342234784069e-12,  -4.333072289259062e-14,
   3.140050455215679e-16,  -2.275440698369122e-18,   1.648633275927487e-20,  -1.193406164670665e-22,   2.168108351063494e-03,  -1.571175499490670e-05,   1.138592744438497e-07,
  -8.251105156251868e-10,   5.979375250342044e-12,  -4.333105783644497e-14,   3.140082812115085e-16,  -2.275470814224887e-18,   1.648660417225249e-20,  -1.193429669956068e-22,
   1.963145858080766e-02,  -1.422497585499345e-04,   1.030690160852250e-06,  -7.467622194049524e-09,   5.410210149611579e-11,  -3.919433844966720e-13,   2.839282140845669e-15,
  -2.056649650003165e-17,   1.489439999086102e-19,  -1.077673313056696e-21,   1.963160534855561e-02,  -1.422529486149034e-04,   1.030736389994022e-06,  -7.468180478033417e-09,
   5.410816932039749e-11,  -3.920049349672641e-13,   2.839876658827341e-15,  -2.057202908442840e-17,   1.489938542776266e-19,  -1.078105045059087e-21,   1.963184629633487e-02,
  -1.422581857953876e-04,   1.030812286361329e-06,  -7.469097054920663e-09,   5.411813155409788e-11,  -3.921059919872439e-13,   2.840852800013987e-15,  -2.058111331686162e-17,
   1.490757141297542e-19,  -1.078813911233373e-21,   1.963210196703241e-02,  -1.422637430832036e-04,   1.030892823369227e-06,  -7.470069699980840e-09,   5.412870350198762e-11,
  -3.922132375545079e-13,   2.841888756590728e-15,  -2.059075456403388e-17,   1.491625952817307e-19,  -1.079566219919400e-21,   1.963230318590800e-02,  -1.422681168677530e-04,
   1.030956210107852e-06,  -7.470835239130182e-09,   5.413702458420548e-11,  -3.922976521527819e-13,   2.842704201308443e-15,  -2.059834385077496e-17,   1.492309867859750e-19,
  -1.080158397006429e-21,   1.963241931513715e-02,  -1.422706411324257e-04,   1.030992793313513e-06,  -7.471277071748232e-09,   5.414182720573875e-11,  -3.923463741879542e-13,
   2.843174867106706e-15,  -2.060272440777555e-17,   1.492704631055956e-19,  -1.080500196501718e-21,   1.963246292317308e-02,  -1.422715890317800e-04,   1.031006530950635e-06,
  -7.471442989016340e-09,   5.414363070635837e-11,  -3.923646706888068e-13,   2.843351617513057e-15,  -2.060436946980297e-17,   1.492852880365022e-19,  -1.080628553641450e-21,
   1.963247015184798e-02,  -1.422717461603448e-04,   1.031008808175377e-06,  -7.471470492427781e-09,   5.414392966601354e-11,  -3.923677036427820e-13,   2.843380916988362e-15,
  -2.060464216867558e-17,   1.492877455432674e-19,  -1.080649831098130e-21,   5.522363942588109e-02,  -4.001510810948520e-04,   2.899349611144609e-06,  -2.100655301205506e-08,
   1.521901660996362e-10,  -1.102543645442197e-12,   7.986950014641150e-15,  -5.785387674613030e-17,   4.189801751587328e-19,  -3.031434189958830e-21,   5.522405228614610e-02,
  -4.001600548039042e-04,   2.899479654536083e-06,  -2.100812347473594e-08,   1.522072349947168e-10,  -1.102716787873158e-12,   7.988622396128763e-15,  -5.786943957271104e-17,
   4.191203964658897e-19,  -3.032647851212725e-21,   5.522473007650118e-02,  -4.001747870850259e-04,   2.899693152356432e-06,  -2.101070182166516e-08,   1.522352589311116e-10,
  -1.103001062841001e-12,   7.991368285179666e-15,  -5.789499296832842e-17,   4.193506368475815e-19,  -3.034640571580801e-21,   5.522544928268520e-02,  -4.001904198337209e-04,
   2.899919704380647e-06,  -2.101343788935228e-08,   1.522649980040919e-10,  -1.103302746287284e-12,   7.994282435084890e-15,  -5.792211320870360e-17,   4.195950000426147e-19,
  -3.036755407710401e-21,   5.522601531493316e-02,  -4.002027233668421e-04,   2.900098012394793e-06,  -2.101559136446399e-08,   1.522884053528418e-10,  -1.103540205862312e-12,
   7.996576284211967e-15,  -5.794346140663449e-17,   4.197873588554752e-19,  -3.038420088226079e-21,   5.522634198850410e-02,  -4.002098241679115e-04,   2.900200921597792e-06,
  -2.101683424740119e-08,   1.523019152105934e-10,  -1.103677261703034e-12,   7.997900268890290e-15,  -5.795578364353335e-17,   4.198983904011161e-19,  -3.039380925352760e-21,
   5.522646465867872e-02,  -4.002124906255226e-04,   2.900239565813402e-06,  -2.101730097559890e-08,   1.523069884891461e-10,  -1.103728730043681e-12,   7.998397468450509e-15,
  -5.796041110142357e-17,   4.199400871605959e-19,  -3.039741751429846e-21,   5.522648499306881e-02,  -4.002129326309484e-04,   2.900245971686780e-06,  -2.101737834317973e-08,
   1.523078294678461e-10,  -1.103737261790245e-12,   7.998479887984911e-15,  -5.796117818649978e-17,   4.199469991699308e-19,  -3.039801564686653e-21,   1.104255122212636e-01,
  -8.001444409524285e-04,   5.797556431365955e-06,  -4.200482619742780e-08,   3.043203453029855e-10,  -2.204652680137522e-12,   1.597074948120293e-14,  -1.156848165827834e-16,
   8.377889054839417e-19,  -6.061411750438265e-21,   1.104263377790630e-01,  -8.001623848335053e-04,   5.797816466891293e-06,  -4.200796650372668e-08,   3.043544763598063e-10,
  -2.204998896332760e-12,   1.597409355852521e-14,  -1.157159346888538e-16,   8.380692274518026e-19,  -6.063835936086085e-21,   1.104276930926192e-01,  -8.001918435889539e-04,
   5.798243378380168e-06,  -4.201312218122249e-08,   3.044105131776683e-10,  -2.205567333524612e-12,   1.597958421066656e-14,  -1.157670290785649e-16,   8.385295096855501e-19,
  -6.067816209135299e-21,   1.104291312215091e-01,  -8.002231029246257e-04,   5.798696393131353e-06,  -4.201859323806132e-08,   3.044699795920558e-10,  -2.206170580765005e-12,
   1.598541131526923e-14,  -1.158212563843310e-16,   8.390180247813588e-19,  -6.072040373521637e-21,   1.104302630629010e-01,  -8.002477051413752e-04,   5.799052938878150e-06,
  -4.202289933940210e-08,   3.045167850557030e-10,  -2.206645405732053e-12,   1.598999807254285e-14,  -1.158639423997908e-16,   8.394025756534861e-19,  -6.075365381998974e-21,
   1.104309162812831e-01,  -8.002619039447015e-04,   5.799258716721682e-06,  -4.202538461534181e-08,   3.045437994417509e-10,  -2.206919463052174e-12,   1.599264549870245e-14,
  -1.158885808781879e-16,   8.396245423216343e-19,  -6.077284537145437e-21,   1.104311615732814e-01,  -8.002672358089273e-04,   5.799335989920982e-06,  -4.202631788775662e-08,
   3.045539439975138e-10,  -2.207022379319028e-12,   1.599363969382074e-14,  -1.158978335417525e-16,   8.397078995974720e-19,  -6.078005241994147e-21,   1.104312022340466e-01,
  -8.002681196455606e-04,   5.799348799142812e-06,  -4.202647259242059e-08,   3.045556256231586e-10,  -2.207039439428107e-12,   1.599380449907188e-14,  -1.158993673385213e-16,
   8.397217176064634e-19,  -6.078124711406751e-21,   1.879273125301764e-01,  -1.361723313746488e-03,   9.866553276150269e-06,  -7.148578204729902e-08,   5.179066263621574e-10,
  -3.751981167546766e-12,   2.717976369297402e-14,  -1.968774975285549e-16,   1.425772085885818e-18,  -1.031491441119649e-20,   1.879287175031347e-01,  -1.361753851484358e-03,
   9.866995816794417e-06,  -7.149112636759930e-08,   5.179647121800592e-10,  -3.752570373403459e-12,   2.718545473182965e-14,  -1.969304521076620e-16,   1.426248980650375e-18,
  -1.031903306242254e-20,   1.879310240392705e-01,  -1.361803985775153e-03,   9.867722354774304e-06,  -7.149990054096862e-08,   5.180600782395288e-10,  -3.753537764659246e-12,
   2.719479886776321e-14,  -1.970174008801172e-16,   1.427032029773822e-18,  -1.032579543499449e-20,   1.879334715144228e-01,  -1.361857184377766e-03,   9.868493316509364e-06,
  -7.150921144166951e-08,   5.181612809455212e-10,  -3.754564397166273e-12,   2.720471558667166e-14,  -1.971096809906334e-16,   1.427863108146805e-18,  -1.033297211033080e-20,
   1.879353977351548e-01,  -1.361899053583370e-03,   9.869100102771524e-06,  -7.151653976655570e-08,   5.182409366573864e-10,  -3.755372475030529e-12,   2.721252144960246e-14,
  -1.971823209425383e-16,   1.428517317956499e-18,  -1.033862111321811e-20,   1.879365094128150e-01,  -1.361923217772387e-03,   9.869450305149851e-06,  -7.152076932551747e-08,
   5.182869109941753e-10,  -3.755838877742718e-12,   2.721702690816759e-14,  -1.972242489004956e-16,   1.428894934053118e-18,  -1.034188163213275e-20,   1.879369268622348e-01,
  -1.361932291788839e-03,   9.869581812301988e-06,  -7.152235761221131e-08,   5.183041754703021e-10,  -3.756014025138183e-12,   2.721871885519285e-14,  -1.972399944037822e-16,
   1.429036743769637e-18,  -1.034310605906248e-20,   1.879369960606311e-01,  -1.361933795943448e-03,   9.869603611636029e-06,  -7.152262089585215e-08,   5.183070373389213e-10,
  -3.756043058776495e-12,   2.721899932503965e-14,  -1.972426045063733e-16,   1.429060251346447e-18,  -1.034330902902520e-20,   2.925757587367872e-01,  -2.120007072653409e-03,
   1.536080238670995e-05,  -1.112930666327843e-07,   8.063060209610236e-10,  -5.841294052853677e-12,   4.231496247146386e-14,  -3.065090922355906e-16,   2.219683122803879e-18,
  -1.605722180990977e-20,   2.925779460773272e-01,  -2.120054615512957e-03,   1.536149135875169e-05,  -1.113013869694042e-07,   8.063964521796540e-10,  -5.842211358932948e-12,
   4.232382243675867e-14,  -3.065915261697178e-16,   2.220425173597052e-18,  -1.606361736126566e-20,   2.925815370218838e-01,  -2.120132667382937e-03,   1.536262247373970e-05,
  -1.113150470930267e-07,   8.065449233430255e-10,  -5.843717443536339e-12,   4.233836964257874e-14,  -3.067268785100709e-16,   2.221643599492630e-18,  -1.607411804400899e-20,
   2.925853473881899e-01,  -2.120215489945071e-03,   1.536382275011593e-05,  -1.113295428237611e-07,   8.067024813206342e-10,  -5.845315757949835e-12,   4.235380825963874e-14,
  -3.068705300130032e-16,   2.222936755296785e-18,  -1.608526191112868e-20,   2.925883462364392e-01,  -2.120280674267820e-03,   1.536476742892779e-05,  -1.113409519696293e-07,
   8.068264937441984e-10,  -5.846573815209761e-12,   4.236596063770683e-14,  -3.069836078230069e-16,   2.223954701391309e-18,  -1.609403351590735e-20,   2.925900769584428e-01,
  -2.120318294429779e-03,   1.536531264358952e-05,  -1.113475367834707e-07,   8.068980691376703e-10,  -5.847299934978767e-12,   4.237297485673469e-14,  -3.070488765878197e-16,
   2.224542268438299e-18,  -1.609909630979706e-20,   2.925907268670650e-01,  -2.120332421366473e-03,   1.536551738128379e-05,  -1.113500095169872e-07,   8.069249474301545e-10,
  -5.847572613465316e-12,   4.237560892526705e-14,  -3.070733874252722e-16,   2.224762922801594e-18,  -1.610099753916150e-20,   2.925908345990014e-01,  -2.120334763118558e-03,
   1.536555131970703e-05,  -1.113504194116778e-07,   8.069294029457009e-10,  -5.847617814528799e-12,   4.237604556824642e-14,  -3.070774505406544e-16,   2.224799500322476e-18,
  -1.610131270041049e-20,   4.340124097509614e-01,  -3.144858556509209e-03,   2.278650455589767e-05,  -1.650942382417274e-07,   1.196089582399549e-09,  -8.665085441579664e-12,
   6.277077975571320e-14,  -4.546794471451826e-16,   3.292627839051262e-18,  -2.381572423202145e-20,   4.340156544932559e-01,  -3.144929082485517e-03,   2.278752659003844e-05,
  -1.651065807854794e-07,   1.196223729698376e-09,  -8.666446184641420e-12,   6.278392240847783e-14,  -4.548017103298860e-16,   3.293727634997937e-18,  -2.382517135022431e-20,
   4.340209813682745e-01,  -3.145044866104453e-03,   2.278920450737732e-05,  -1.651268444696447e-07,   1.196443974496221e-09,  -8.668680328925289e-12,   6.280550137001918e-14,
  -4.550024601354769e-16,   3.295533461458185e-18,  -2.384068204853528e-20,   4.340266337376630e-01,  -3.145167726658283e-03,   2.279098502002580e-05,  -1.651483477090990e-07,
   1.196677698837154e-09,  -8.671051287974421e-12,   6.282840262495657e-14,  -4.552155187682092e-16,   3.297450035953030e-18,  -2.385714243583225e-20,   4.340310822858295e-01,
  -3.145264422314488e-03,   2.279238637441929e-05,  -1.651652722505364e-07,   1.196861661098615e-09,  -8.672917505377572e-12,   6.284642915317552e-14,  -4.553832314792683e-16,
   3.298958718092934e-18,  -2.387009853436943e-20,   4.340336496715577e-01,  -3.145320228773675e-03,   2.279319515614699e-05,  -1.651750402871603e-07,   1.196967837325481e-09,
  -8.673994640235049e-12,   6.285683386599820e-14,  -4.554800355735683e-16,   3.299829539485313e-18,  -2.387757642677952e-20,   4.340346137582901e-01,  -3.145341184938534e-03,
   2.279349886790994e-05,  -1.651787083865370e-07,   1.197007709068254e-09,  -8.674399134800331e-12,   6.286074117557455e-14,  -4.555163890837887e-16,   3.300156566415555e-18,
  -2.388038457703781e-20,   4.340347735698804e-01,  -3.145344658737831e-03,   2.279354921280803e-05,  -1.651793164320256e-07,   1.197014318460194e-09,  -8.674466186604478e-12,
   6.286138888053928e-14,  -4.555224153361662e-16,   3.300210777120471e-18,  -2.388085007484889e-20,   6.372593918206845e-01,  -4.617588359350930e-03,   3.345737059154424e-05,
  -2.424074782361250e-07,   1.756215477900887e-09,  -1.272292291923376e-11,   9.216609101198486e-14,  -6.675994523556817e-16,   4.834303171370718e-18,  -3.495780464343035e-20,
   6.372641560680991e-01,  -4.617691912474575e-03,   3.345887124183157e-05,  -2.424256007615892e-07,   1.756412445843801e-09,  -1.272492087826357e-11,   9.218538726642880e-14,
  -6.677789128521346e-16,   4.835915249398334e-18,  -3.497156155327763e-20,   6.372719775060538e-01,  -4.617861917287486e-03,   3.346133492385168e-05,  -2.424553538772720e-07,
   1.756735830398888e-09,  -1.272820123934112e-11,   9.221706983750531e-14,  -6.680735772633187e-16,   4.838562206056089e-18,  -3.499414747012147e-20,   6.372802768666198e-01,
  -4.618042313147107e-03,   3.346394924631960e-05,  -2.424869270287945e-07,   1.757079006910886e-09,  -1.273168248334940e-11,   9.225069380996673e-14,  -6.683863082445255e-16,
   4.841371469759098e-18,  -3.501811520236463e-20,   6.372868086593411e-01,  -4.618184291149638e-03,   3.346600685162742e-05,  -2.425117772897061e-07,   1.757349117959625e-09,
  -1.273442262256133e-11,   9.227716062647126e-14,  -6.686324793243712e-16,   4.843582836887701e-18,  -3.503697960967995e-20,   6.372905783457160e-01,  -4.618266231641223e-03,
   3.346719438390581e-05,  -2.425261196728944e-07,   1.757505016085912e-09,  -1.273600416357688e-11,   9.229243697730061e-14,  -6.687745695735749e-16,   4.844859245165574e-18,
  -3.504786729656449e-20,   6.372919939119784e-01,  -4.618297001528354e-03,   3.346764032316167e-05,  -2.425315055338249e-07,   1.757563559605119e-09,  -1.273659807689332e-11,
   9.229817374551445e-14,  -6.688279296753070e-16,   4.845338584138719e-18,  -3.505195585722084e-20,   6.372922285629575e-01,  -4.618302102099616e-03,   3.346771424445525e-05,
  -2.425323983254602e-07,   1.757573264148659e-09,  -1.273669652805333e-11,   9.229912471524446e-14,  -6.688367750764352e-16,   4.845418043279442e-18,  -3.505263360130792e-20,
   2.106920051247048e-03,  -1.483675713009565e-05,   1.044741351801954e-07,  -7.356266299979625e-10,   5.179465551874735e-12,  -3.646626214294605e-14,   2.567296050169095e-16,
  -1.807325315057241e-18,   1.272200701674673e-20,  -8.952035111976753e-23,   2.106934927583744e-03,  -1.483707136882482e-05,   1.044785607448798e-07,  -7.356785698384744e-10,
   5.180014172788044e-12,  -3.647167059758218e-14,   2.567803810228041e-16,  -1.807784859934943e-18,   1.272604518199936e-20,  -8.955484152199444e-23,   2.106959349954484e-03,
  -1.483758725860928e-05,   1.044858263645417e-07,  -7.357638430613668e-10,   5.180914901219526e-12,  -3.648055044467639e-14,   2.568637496941747e-16,  -1.808539405050113e-18,
   1.273267579155732e-20,  -8.961147478785410e-23,   2.106985264597887e-03,  -1.483813467936450e-05,   1.044935362093315e-07,  -7.358543321107523e-10,   5.181870750284900e-12,
  -3.648997399919468e-14,   2.569522261202115e-16,  -1.809340209487589e-18,   1.273971315830383e-20,  -8.967158294286598e-23,   2.107005660007715e-03,  -1.483856551817638e-05,
   1.044996042313441e-07,  -7.359255529490483e-10,   5.182623085700865e-12,  -3.649739136401056e-14,   2.570218689899649e-16,  -1.809970572609702e-18,   1.274525289003146e-20,
  -8.971889987384037e-23,   2.107017430777655e-03,  -1.483881417001365e-05,   1.045031063392556e-07,  -7.359666580847002e-10,   5.183057304120697e-12,  -3.650167246231655e-14,
   2.570620658452297e-16,  -1.810334417935799e-18,   1.274845049352001e-20,  -8.974621200773703e-23,   2.107021850852858e-03,  -1.483890754244836e-05,   1.045044214408824e-07,
  -7.359820938871937e-10,   5.183220363303439e-12,  -3.650328013140365e-14,   2.570771610323439e-16,  -1.810471055008599e-18,   1.274965132295760e-20,  -8.975646885642187e-23,
   2.107022583545387e-03,  -1.483892302032909e-05,   1.045046394391348e-07,  -7.359846526143117e-10,   5.183247393005501e-12,  -3.650354662947601e-14,   2.570796633214828e-16,
  -1.810493705062230e-18,   1.274985038277060e-20,  -8.975816912184268e-23,   1.907840306880788e-02,  -1.343485399906039e-04,   9.460252941502153e-07,  -6.661183630021542e-09,
   4.690065548979485e-11,  -3.302061918597108e-13,   2.324716034324446e-15,  -1.636553680860633e-17,   1.151991626829703e-19,  -8.106140304468108e-22,   1.907853777574538e-02,
  -1.343513854583906e-04,   9.460653681467560e-07,  -6.661653951242636e-09,   4.690562331511806e-11,  -3.302551660328839e-13,   2.325175816586605e-15,  -1.636969802387211e-17,
   1.152357279651974e-19,  -8.109263133350363e-22,   1.907875892311764e-02,  -1.343560568996449e-04,   9.461311591673288e-07,  -6.662426110069497e-09,   4.691377951442151e-11,
  -3.303355740603913e-13,   2.325930728981353e-15,  -1.637653048953926e-17,   1.152957676301448e-19,  -8.114390818579039e-22,   1.907899358319025e-02,  -1.343610138574612e-04,
   9.462009726974590e-07,  -6.663245498804281e-09,   4.692243483738919e-11,  -3.304209054205441e-13,   2.326731892647670e-15,  -1.638378183687098e-17,   1.153594904433747e-19,
  -8.119833124124185e-22,   1.907917826596890e-02,  -1.343649151523896e-04,   9.462559193337604e-07,  -6.663890411674706e-09,   4.692924732090843e-11,  -3.304880705042643e-13,
   2.327362516410105e-15,  -1.638948982453815e-17,   1.154096522818343e-19,  -8.124117286084042e-22,   1.907928485164272e-02,  -1.343671667233367e-04,   9.462876313231533e-07,
  -6.664262623398922e-09,   4.693317921852477e-11,  -3.305268363373020e-13,   2.327726503306893e-15,  -1.639278447254752e-17,   1.154386063298017e-19,  -8.126590176088824e-22,
   1.907932487593138e-02,  -1.343680122214580e-04,   9.462995397194369e-07,  -6.664402396363289e-09,   4.693465573813483e-11,  -3.305413939640942e-13,   2.327863191868009e-15,
  -1.639402173196653e-17,   1.154494797454728e-19,  -8.127518849563501e-22,   1.907933151054639e-02,  -1.343681523754458e-04,   9.463015137186521e-07,  -6.664425565931208e-09,
   4.693490049518854e-11,  -3.305438071345091e-13,   2.327885850368310e-15,  -1.639422682997953e-17,   1.154512822163296e-19,  -8.127672794635653e-22,   5.366788451080680e-02,
  -3.779248138540101e-04,   2.661185847033239e-06,  -1.873802710140911e-08,   1.319323715203414e-10,  -9.288758423579814e-13,   6.539467066510816e-15,  -4.603653492075535e-17,
   3.240568514910952e-19,  -2.280253653555287e-21,   5.366826344379917e-02,  -3.779328182051081e-04,   2.661298575892667e-06,  -1.873935012330001e-08,   1.319463461002749e-10,
  -9.290136075431361e-13,   6.540760440335466e-15,  -4.604824039586376e-17,   3.241597057320744e-19,  -2.281131923356551e-21,   5.366888553525993e-02,  -3.779459590517934e-04,
   2.661483647194509e-06,  -1.874152221970002e-08,   1.319692896322412e-10,  -9.292397966969203e-13,   6.542884019267745e-15,  -4.606746008263067e-17,   3.243285908783361e-19,
  -2.282574041184238e-21,   5.366954563818525e-02,  -3.779599030616062e-04,   2.661680033886719e-06,  -1.874382717466405e-08,   1.319936372078421e-10,  -9.294798352691847e-13,
   6.545137703644508e-15,  -4.608785808019672e-17,   3.245078362840857e-19,  -2.284104641603887e-21,   5.367006515410070e-02,  -3.779708774730863e-04,   2.661834599744241e-06,
  -1.874564132594405e-08,   1.320128008436891e-10,  -9.296687717956367e-13,   6.546911656920934e-15,  -4.610391461539722e-17,   3.246489360987984e-19,  -2.285309523127842e-21,
   5.367036498148210e-02,  -3.779772111818939e-04,   2.661923806130004e-06,  -1.874668836408964e-08,   1.320238613407732e-10,  -9.297778207452986e-13,   6.547935557039153e-15,
  -4.611318244029164e-17,   3.247303806852151e-19,  -2.286005000420307e-21,   5.367047757051242e-02,  -3.779795895830297e-04,   2.661957304658889e-06,  -1.874708154790383e-08,
   1.320280148163807e-10,  -9.298187715977955e-13,   6.548320063829832e-15,  -4.611666284349217e-17,   3.247609664180268e-19,  -2.286266181096031e-21,   5.367049623380152e-02,
  -3.779799838386707e-04,   2.661962857553515e-06,  -1.874714672430707e-08,   1.320287033222735e-10,  -9.298255598873369e-13,   6.548383802500823e-15,  -4.611723978294932e-17,
   3.247660365719104e-19,  -2.286309476693978e-21,   1.073146155984798e-01,  -7.557006670479282e-04,   5.321322776427587e-06,  -3.746866852928921e-08,   2.638127412342340e-10,
  -1.857385556172113e-12,   1.307635604463177e-14,  -9.205489521402552e-17,   6.479845824167358e-19,  -4.559549914046456e-21,   1.073153733151065e-01,  -7.557166725951749e-04,
   5.321548189713791e-06,  -3.747131405158391e-08,   2.638406848847603e-10,  -1.857661032149531e-12,   1.307894227663402e-14,  -9.207830123353479e-17,   6.481902354740521e-19,
  -4.561305492435288e-21,   1.073166172528280e-01,  -7.557429491090246e-04,   5.321918259370681e-06,  -3.747565738822238e-08,   2.638865629034220e-10,  -1.858113321151697e-12,
   1.308318858782015e-14,  -9.211673250892128e-17,   6.485279146585918e-19,  -4.564188145685660e-21,   1.073179371984963e-01,  -7.557708316325588e-04,   5.322310955348285e-06,
  -3.748026638962077e-08,   2.639352484558096e-10,  -1.858593303521785e-12,   1.308769505796432e-14,  -9.215751990640098e-17,   6.488863086347180e-19,  -4.567247661452044e-21,
   1.073189760255578e-01,  -7.557927761299079e-04,   5.322620026140410e-06,  -3.748389397710803e-08,   2.639735681724025e-10,  -1.858971101976200e-12,   1.309124225714882e-14,
  -9.218962620685512e-17,   6.491684319360387e-19,  -4.569656093968588e-21,   1.073195755621424e-01,  -7.558054410510645e-04,   5.322798403750783e-06,  -3.748598764069462e-08,
   2.639956848060597e-10,  -1.859189156819064e-12,   1.309328964908574e-14,  -9.220815794815020e-17,   6.493312770109638e-19,  -4.571046278922040e-21,   1.073198006958256e-01,
  -7.558101969158790e-04,   5.322865387604938e-06,  -3.748677385334415e-08,   2.640039901198001e-10,  -1.859271042355132e-12,   1.309405850933458e-14,  -9.221511728660334e-17,
   6.493924319083999e-19,  -4.571568350936867e-21,   1.073198380150476e-01,  -7.558109852717635e-04,   5.322876491205489e-06,  -3.748690418046045e-08,   2.640053668601477e-10,
  -1.859284616253942e-12,   1.309418596125887e-14,  -9.221627092217004e-17,   6.494025694692789e-19,  -4.571654894153530e-21,   1.826330428444953e-01,  -1.286086816160776e-03,
   9.056076520374490e-06,  -6.376593632074838e-08,   4.489688881143301e-10,  -3.160985777197083e-12,   2.225395426260564e-14,  -1.566632602550450e-16,   1.102766935051642e-18,
  -7.759503911659377e-21,   1.826343323621661e-01,  -1.286114055151286e-03,   9.056460139270207e-06,  -6.377043859455754e-08,   4.490164439254669e-10,  -3.161454594889570e-12,
   2.225835561829845e-14,  -1.567030928949588e-16,   1.103116886423225e-18,  -7.762490037117788e-21,   1.826364493536861e-01,  -1.286158773754178e-03,   9.057089941157688e-06,
  -6.377783028837558e-08,   4.490945212829009e-10,  -3.162224321120637e-12,   2.226558216472325e-14,  -1.567684956866621e-16,   1.103691500974806e-18,  -7.767393233416950e-21,
   1.826386956990925e-01,  -1.286206225539628e-03,   9.057758249578266e-06,  -6.378567410293060e-08,   4.491773766324792e-10,  -3.163041177196848e-12,   2.227325146017715e-14,
  -1.568379081464836e-16,   1.104301364660278e-18,  -7.772597246184311e-21,   1.826404636236774e-01,  -1.286243571713791e-03,   9.058284240738633e-06,  -6.379184770130292e-08,
   4.492425909179750e-10,  -3.163684131983250e-12,   2.227928822891664e-14,  -1.568925470103143e-16,   1.104781441541662e-18,  -7.776693803321876e-21,   1.826414839431383e-01,
  -1.286265125470241e-03,   9.058587812116627e-06,  -6.379541079610229e-08,   4.492802300392788e-10,  -3.164055227743475e-12,   2.228277256425983e-14,  -1.569240845341343e-16,
   1.105058547777279e-18,  -7.779058395978157e-21,   1.826418670861928e-01,  -1.286273219223897e-03,   9.058701808379200e-06,  -6.379674880963063e-08,   4.492943644105466e-10,
  -3.164194584314652e-12,   2.228408104207193e-14,  -1.569359280134209e-16,   1.105162612331763e-18,  -7.779946397627997e-21,   1.826419305977939e-01,  -1.286274560884893e-03,
   9.058720705007048e-06,  -6.379697060642420e-08,   4.492967074116443e-10,  -3.164217684999900e-12,   2.228429794496808e-14,  -1.569378912831872e-16,   1.105179862964767e-18,
  -7.780093600494252e-21,   2.843333433614484e-01,  -2.002251939718203e-03,   1.409900680983907e-05,  -9.927437873830007e-08,   6.989798938850169e-10,  -4.921199533945408e-12,
   3.464619838606139e-14,  -2.439019556311903e-16,   1.716840810465570e-18,  -1.208007135816578e-20,   2.843353509547347e-01,  -2.002294346903236e-03,   1.409960404920710e-05,
  -9.928138813009055e-08,   6.990539314263133e-10,  -4.921929415010490e-12,   3.465305062726136e-14,  -2.439639673743133e-16,   1.717385542773718e-18,  -1.208471652091513e-20,
   2.843386468056244e-01,  -2.002363967327185e-03,   1.410058456003559e-05,  -9.929289593262754e-08,   6.991754866145128e-10,  -4.923127766967783e-12,   3.466430126035265e-14,
  -2.440657869017062e-16,   1.718279983873544e-18,  -1.209234381871330e-20,   2.843421440418845e-01,  -2.002437842922719e-03,   1.410162501999000e-05,  -9.930510762202544e-08,
   6.993044804475070e-10,  -4.924399493243808e-12,   3.467624118595386e-14,  -2.441738486899619e-16,   1.719229292673504e-18,  -1.210043902460619e-20,   2.843448964458318e-01,
  -2.002495985536976e-03,   1.410244391246821e-05,  -9.931471902541300e-08,   6.994060096872044e-10,  -4.925400480463729e-12,   3.468563951570729e-14,  -2.442589108301631e-16,
   1.719976575775273e-18,  -1.210681148039431e-20,   2.843464849362774e-01,  -2.002529541631413e-03,   1.410291652938037e-05,  -9.932026625076813e-08,   6.994646083721150e-10,
  -4.925978222662941e-12,   3.469106409519961e-14,  -2.443080086478313e-16,   1.720407916451319e-18,  -1.211048974481045e-20,   2.843470814348297e-01,  -2.002542142440124e-03,
   1.410309400514232e-05,  -9.932234934509701e-08,   6.994866135502244e-10,  -4.926195180603235e-12,   3.469310119586257e-14,  -2.443264466506763e-16,   1.720569902203809e-18,
  -1.211187108222316e-20,   2.843471803132453e-01,  -2.002544231213057e-03,   1.410312342447020e-05,  -9.932269465075577e-08,   6.994902612651095e-10,  -4.926231145014859e-12,
   3.469343888063500e-14,  -2.443295030813090e-16,   1.720596754348811e-18,  -1.211210006460837e-20,   4.217854550139640e-01,  -2.970178366920914e-03,   2.091473315157711e-05,
  -1.472654895415193e-07,   1.036879982782612e-09,  -7.300200276487723e-12,   5.139481794288914e-14,  -3.618083544733114e-16,   2.546774060431581e-18,  -1.791895451318450e-20,
   4.217884331157853e-01,  -2.970241274540617e-03,   2.091561910774121e-05,  -1.472758874055929e-07,   1.036989811453542e-09,  -7.301282994536284e-12,   5.140498260254878e-14,
  -3.619003392552518e-16,   2.547581908030522e-18,  -1.792583610733019e-20,   4.217933222432816e-01,  -2.970344550793212e-03,   2.091707361603212e-05,  -1.472929582970670e-07,
   1.037170128688841e-09,  -7.303060650304531e-12,   5.142167186504650e-14,  -3.620513726644982e-16,   2.548908378394694e-18,  -1.793713553445559e-20,   4.217985101096424e-01,
  -2.970454139247753e-03,   2.091861705398924e-05,  -1.473110733475934e-07,   1.037361480548510e-09,  -7.304947150777383e-12,   5.143938362770433e-14,  -3.622116654504288e-16,
   2.550316216349212e-18,  -1.794912805694199e-20,   4.218025930776740e-01,  -2.970540389100540e-03,   2.091983181456536e-05,  -1.473253310847750e-07,   1.037512090917699e-09,
  -7.306432032301702e-12,   5.145332517007330e-14,  -3.623378418178476e-16,   2.551424445914841e-18,  -1.795856837512738e-20,   4.218049494744212e-01,  -2.970590166845181e-03,
   2.092053290342352e-05,  -1.473335599435593e-07,   1.037599017300576e-09,  -7.307289064935509e-12,   5.146137202568426e-14,  -3.624106707303341e-16,   2.552064128566864e-18,
  -1.796401742483347e-20,   4.218058343316466e-01,  -2.970608859122958e-03,   2.092079617432240e-05,  -1.473366500450008e-07,   1.037631660192476e-09,  -7.307610904044403e-12,
   5.146439387367637e-14,  -3.624380206134319e-16,   2.552304354986316e-18,  -1.796606375921711e-20,   4.218059810097569e-01,  -2.970611957648201e-03,   2.092083981550929e-05,
  -1.473371622779319e-07,   1.037637071280815e-09,  -7.307664254265949e-12,   5.146489479739852e-14,  -3.624425543483914e-16,   2.552344176967981e-18,  -1.796640297697906e-20,
   6.193065831809912e-01,  -4.361105851301468e-03,   3.070905307934239e-05,  -2.162295689610228e-07,   1.522448415465642e-09,  -1.071886644192805e-11,   7.546286907148130e-14,
  -5.312412210592596e-16,   3.739367580990407e-18,  -2.630801527870563e-20,   6.193109559208317e-01,  -4.361198218410252e-03,   3.071035392667318e-05,  -2.162448361197095e-07,
   1.522609676596763e-09,  -1.072045619069646e-11,   7.547779358638180e-14,  -5.313762694009938e-16,   3.740553134696784e-18,  -2.631809393444082e-20,   6.193181346151381e-01,
  -4.361349858686950e-03,   3.071248957774088e-05,  -2.162699012683957e-07,   1.522874435889940e-09,  -1.072306631254906e-11,   7.550229801030441e-14,  -5.315980104598767e-16,
   3.742499786966909e-18,  -2.633464268790767e-20,   6.193257519470107e-01,  -4.361510767154791e-03,   3.071475580402615e-05,  -2.162964995532893e-07,   1.523155397290789e-09,
  -1.072583625042518e-11,   7.552830374312126e-14,  -5.318333456297637e-16,   3.744565843777865e-18,  -2.635220628127397e-20,   6.193317469592873e-01,  -4.361637407609039e-03,
   3.071653943409378e-05,  -2.163174341543204e-07,   1.523376538074658e-09,  -1.072801649346467e-11,   7.554877375520998e-14,  -5.320185924080182e-16,   3.746192209374654e-18,
  -2.636603187858952e-20,   6.193352068510419e-01,  -4.361710496153416e-03,   3.071756884119842e-05,  -2.163295165677760e-07,   1.523504171839387e-09,  -1.072927486956255e-11,
   7.556058874796510e-14,  -5.321255166841779e-16,   3.747130964289630e-18,  -2.637401208581835e-20,   6.193365060848073e-01,  -4.361737941980534e-03,   3.071795540123372e-05,
  -2.163340537562504e-07,   1.523552101306191e-09,  -1.072974742407712e-11,   7.556502565013119e-14,  -5.321656705989579e-16,   3.747483503979340e-18,  -2.637700895682243e-20,
   6.193367214519288e-01,  -4.361742491537798e-03,   3.071801947948473e-05,  -2.163348058666245e-07,   1.523560046392051e-09,  -1.072982575790080e-11,   7.556576114362158e-14,
  -5.321723268320571e-16,   3.747541943950108e-18,  -2.637750574289428e-20,   2.049190619741568e-03,  -1.403491864815660e-05,   9.612081590633349e-08,  -6.582714223038960e-10,
   4.507882115877193e-12,  -3.086882336916910e-14,   2.113720036967253e-16,  -1.447284592506591e-18,   9.909107668905824e-21,  -6.783299247319245e-23,   2.049204306185302e-03,
  -1.403519983406713e-05,   9.612466749408533e-08,  -6.583153874767479e-10,   4.508333782557927e-12,  -3.087315407840771e-14,   2.114115494234251e-16,  -1.447632773343712e-18,
   9.912086778723854e-21,  -6.785786510515046e-23,   2.049226775094987e-03,  -1.403566145983592e-05,   9.613099077781310e-08,  -6.583875678823592e-10,   4.509075327582040e-12,
  -3.088026439123806e-14,   2.114764787211832e-16,  -1.448204460722642e-18,   9.916978406357591e-21,  -6.789870642195427e-23,   2.049250616884779e-03,  -1.403615129892655e-05,
   9.613770064991730e-08,  -6.584641629323307e-10,   4.509862247174666e-12,  -3.088781000585990e-14,   2.115453853969859e-16,  -1.448811190524298e-18,   9.922170074636975e-21,
  -6.794205426626974e-23,   2.049269380889669e-03,  -1.403653681824012e-05,   9.614298162920958e-08,  -6.585244480278590e-10,   4.510481617137006e-12,  -3.089374918511452e-14,
   2.115996237654921e-16,  -1.449288780807932e-18,   9.926256866904979e-21,  -6.797617797316732e-23,   2.049280210120566e-03,  -1.403675931433630e-05,   9.614602949574037e-08,
  -6.585592414946642e-10,   4.510839091749928e-12,  -3.089717709861752e-14,   2.116309291771604e-16,  -1.449564443878119e-18,   9.928615804289552e-21,  -6.799587492955544e-23,
   2.049284276634082e-03,  -1.403684286484636e-05,   9.614717402074397e-08,  -6.585723071199798e-10,   4.510973331576455e-12,  -3.089846437036777e-14,   2.116426853110688e-16,
  -1.449667964978631e-18,   9.929501678608292e-21,  -6.800327199370121e-23,   2.049284950718468e-03,  -1.403685671459279e-05,   9.614736374324382e-08,  -6.585744729519380e-10,
   4.510995583989466e-12,  -3.089867775704798e-14,   2.116446340923307e-16,  -1.449685125445598e-18,   9.929648528643124e-21,  -6.800449819784288e-23,   1.855565643561561e-02,
  -1.270878004359844e-04,   8.703850286479128e-07,  -5.960723339233180e-09,   4.081939034186834e-11,  -2.795207411685834e-13,   1.913997766207486e-15,  -1.310532789837498e-17,
   8.972809245560395e-20,  -6.142348716537611e-22,   1.855578036793568e-02,  -1.270903466067018e-04,   8.704199052174053e-07,  -5.961121448923139e-09,   4.082348023552838e-11,
  -2.795599562371443e-13,   1.914355857239047e-15,  -1.310848071223881e-17,   8.975506846575421e-20,  -6.144600890208569e-22,   1.855598382649369e-02,  -1.270945266810614e-04,
   8.704771632778625e-07,  -5.961775050786500e-09,   4.083019501087508e-11,  -2.796243409348313e-13,   1.914943799379295e-15,  -1.311365740116839e-17,   8.979936243313823e-20,
  -6.148299000096925e-22,   1.855619971663877e-02,  -1.270989622302909e-04,   8.705379219404726e-07,  -5.962468627761601e-09,   4.083732065814998e-11,  -2.796926673401253e-13,
   1.915567757127254e-15,  -1.311915140286054e-17,   8.984637328405123e-20,  -6.152224071004256e-22,   1.855636962685832e-02,  -1.271024531519567e-04,   8.705857418145459e-07,
  -5.963014516225878e-09,   4.084292912428246e-11,  -2.797464472890289e-13,   1.916058891692065e-15,  -1.312347603271006e-17,   8.988337941878486e-20,  -6.155313912039518e-22,
   1.855646768678796e-02,  -1.271044678796640e-04,   8.706133405960650e-07,  -5.963329575064131e-09,   4.084616609795195e-11,  -2.797774874387052e-13,   1.916342365737264e-15,
  -1.312597219056263e-17,   8.990473972951292e-20,  -6.157097436251773e-22,   1.855650450953493e-02,  -1.271052244391293e-04,   8.706237044014345e-07,  -5.963447885802065e-09,
   4.084738165499616e-11,  -2.797891438319500e-13,   1.916448818860100e-15,  -1.312690958492319e-17,   8.991276137121664e-20,  -6.157767227158378e-22,   1.855651061344647e-02,
  -1.271053498501740e-04,   8.706254223604625e-07,  -5.963467497659212e-09,   4.084758315315126e-11,  -2.797910760727975e-13,   1.916466465294944e-15,  -1.312706497474101e-17,
   8.991409110652384e-20,  -6.157878257744721e-22,   5.219738900668134e-02,  -3.575002253559690e-04,   2.448408445346904e-06,  -1.676761994260133e-08,   1.148256653682884e-10,
  -7.862967771048418e-13,   5.384109458351235e-15,  -3.686551673467386e-17,   2.524066150735465e-19,  -1.727849597088530e-21,   5.219773763048473e-02,  -3.575073877791295e-04,
   2.448506553752350e-06,  -1.676873983218386e-08,   1.148371703112506e-10,  -7.864070897786715e-13,   5.385116774352760e-15,  -3.687438563439814e-17,   2.524824980530660e-19,
  -1.728483095104068e-21,   5.219830996299888e-02,  -3.575191464020690e-04,   2.448667621686844e-06,  -1.677057842575833e-08,   1.148560590926680e-10,  -7.865882050594660e-13,
   5.386770665326321e-15,  -3.688894771656300e-17,   2.526070960943977e-19,  -1.729523310009067e-21,   5.219891726578681e-02,  -3.575316236803260e-04,   2.448838536876969e-06,
  -1.677252947002749e-08,   1.148761036640614e-10,  -7.867804084326440e-13,   5.388525868796671e-15,  -3.690440240276469e-17,   2.527393366648635e-19,  -1.730627364761376e-21,
   5.219939522623282e-02,  -3.575414437045765e-04,   2.448973055026610e-06,  -1.677406506390972e-08,   1.148918803781562e-10,  -7.869316923695207e-13,   5.389907438452001e-15,
  -3.691656763316903e-17,   2.528434341645138e-19,  -1.731496483468015e-21,   5.219967107054537e-02,  -3.575471111691711e-04,   2.449050690886056e-06,  -1.677495132998095e-08,
   1.149009860421484e-10,  -7.870190088534341e-13,   5.390704855629326e-15,  -3.692358935206622e-17,   2.529035202786060e-19,  -1.731998157787833e-21,   5.219977465358242e-02,
  -3.575492393842981e-04,   2.449079844453449e-06,  -1.677528414017435e-08,   1.149044054255410e-10,  -7.870517984914916e-13,   5.391004310024201e-15,  -3.692622625247698e-17,
   2.529260849909501e-19,  -1.732186558290718e-21,   5.219979182399330e-02,  -3.575495921677800e-04,   2.449084677102512e-06,  -1.677533930867456e-08,   1.149049722434032e-10,
  -7.870572339187886e-13,   5.391053949737212e-15,  -3.692666336570393e-17,   2.529298255088619e-19,  -1.732217789257461e-21,   1.043742041922367e-01,  -7.148595404896190e-04,
   4.895851840172224e-06,  -3.352863085682813e-08,   2.296060716941459e-10,  -1.572283630295509e-12,   1.076609663501224e-14,  -7.371649653272196e-17,   5.047134414828945e-19,
  -3.455005301373424e-21,   1.043749013024320e-01,  -7.148738625128405e-04,   4.896048018313254e-06,  -3.353087019458136e-08,   2.296290770450936e-10,  -1.572504212143201e-12,
   1.076811086870673e-14,  -7.373423076685278e-17,   5.048651742198967e-19,  -3.456271908860140e-21,   1.043760457418730e-01,  -7.148973751240085e-04,   4.896370090696602e-06,
  -3.353454665703658e-08,   2.296668471624153e-10,  -1.572866371284845e-12,   1.077141799666999e-14,  -7.376334907668924e-17,   5.051143157294117e-19,  -3.458351699719410e-21,
   1.043772601080779e-01,  -7.149223247625506e-04,   4.896711853709874e-06,  -3.353844797655796e-08,   2.297069284041012e-10,  -1.573250702238638e-12,   1.077492770955289e-14,
  -7.379425223505368e-17,   5.053787389179836e-19,  -3.460559129759618e-21,   1.043782158405798e-01,  -7.149419609404472e-04,   4.896980836988231e-06,  -3.354151855905795e-08,
   2.297384756134771e-10,  -1.573553210455656e-12,   1.077769030254197e-14,  -7.381857780395362e-17,   5.055868882750686e-19,  -3.462296831350269e-21,   1.043787674204797e-01,
  -7.149532936357814e-04,   4.897136078106606e-06,  -3.354329074187279e-08,   2.297566833522201e-10,  -1.573727808991371e-12,   1.077928482156587e-14,  -7.383261841795901e-17,
   5.057070341488228e-19,  -3.463299870322058e-21,   1.043789745457261e-01,  -7.149575492271902e-04,   4.897194373750385e-06,  -3.354395623108025e-08,   2.297635207711635e-10,
  -1.573793375337311e-12,   1.077988361193864e-14,  -7.383789115831137e-17,   5.057521536746222e-19,  -3.463676554962299e-21,   1.043790088797801e-01,  -7.149582546551030e-04,
   4.897204037143700e-06,  -3.354406654633563e-08,   2.297646541834614e-10,  -1.573804244048513e-12,   1.077998287173497e-14,  -7.383876520897160e-17,   5.057596330694289e-19,
  -3.463738997602197e-21,   1.776289128912552e-01,  -1.216581472690698e-03,   8.331990138523851e-06,  -5.706059553567451e-08,   3.907543747809833e-10,  -2.675785973232563e-12,
   1.832224759030900e-14,  -1.254541729602594e-16,   8.589442140364286e-19,  -5.879856766021965e-21,   1.776300992660601e-01,  -1.216605846581114e-03,   8.332324003679408e-06,
  -5.706440654561783e-08,   3.907935263648713e-10,  -2.676161369709135e-12,   1.832567550434383e-14,  -1.254843537313283e-16,   8.592024313474417e-19,  -5.882011977962059e-21,
   1.776320469267427e-01,  -1.216645861444875e-03,   8.332872121557388e-06,  -5.707066332173509e-08,   3.908578053197988e-10,  -2.676777709027479e-12,   1.833130372431763e-14,
  -1.255339083392947e-16,   8.596264179089963e-19,  -5.885550869837711e-21,   1.776341135920696e-01,  -1.216688321909177e-03,   8.333453749872295e-06,  -5.707730277014622e-08,
   3.909260174544226e-10,  -2.677431781369307e-12,   1.833727671243889e-14,  -1.255865004661889e-16,   8.600764105983795e-19,  -5.889306944231089e-21,   1.776357401024382e-01,
  -1.216721739677103e-03,   8.333911518223038e-06,  -5.708252843135880e-08,   3.909797059730972e-10,  -2.677946603961209e-12,   1.834197821811004e-14,  -1.256278986091017e-16,
   8.604306369943544e-19,  -5.892263745080637e-21,   1.776366788069653e-01,  -1.216741026189205e-03,   8.334175714834661e-06,  -5.708554441513288e-08,   3.910106927557889e-10,
  -2.678243743891949e-12,   1.834469184267818e-14,  -1.256517934390619e-16,   8.606350999598983e-19,  -5.893970473544525e-21,   1.776370313024180e-01,  -1.216748268554131e-03,
   8.334274925093645e-06,  -5.708667697585672e-08,   3.910223289956293e-10,  -2.678355327757223e-12,   1.834571089120592e-14,  -1.256607667811618e-16,   8.607118838827373e-19,
  -5.894611423924166e-21,   1.776370897337203e-01,  -1.216749469084418e-03,   8.334291370709326e-06,  -5.708686471552865e-08,   3.910242578897699e-10,  -2.678373824636819e-12,
   1.834587981601477e-14,  -1.256622542724918e-16,   8.607246122359872e-19,  -5.894717673624188e-21,   2.765426337611526e-01,  -1.894042130679850e-03,   1.297170860234990e-05,
  -8.883512890067009e-08,   6.083482816707115e-10,  -4.165813360820823e-12,   2.852509990044658e-14,  -1.953140407627627e-16,   1.337250605341082e-18,  -9.154012052162509e-21,
   2.765444807758523e-01,  -1.894080077316694e-03,   1.297222838231091e-05,  -8.884106209424246e-08,   6.084092350463552e-10,  -4.166397798948001e-12,   2.853043666119310e-14,
  -1.953610274534613e-16,   1.337652592282151e-18,  -9.157366554955525e-21,   2.765475130030166e-01,  -1.894142374696292e-03,   1.297308172290218e-05,  -8.885080299347767e-08,
   6.085093081186585e-10,  -4.167357350299863e-12,   2.853919897638736e-14,  -1.954381761432235e-16,   1.338312644944947e-18,  -9.162874695336023e-21,   2.765507305032721e-01,
  -1.894208479523697e-03,   1.297398723441728e-05,  -8.886113965835699e-08,   6.086155045850886e-10,  -4.168375646521397e-12,   2.854849804507571e-14,  -1.955200537654982e-16,
   1.339013183161264e-18,  -9.168720863345546e-21,   2.765532627456522e-01,  -1.894260506175247e-03,   1.297469991380756e-05,  -8.886927526019943e-08,   6.086990898738612e-10,
  -4.169177150981962e-12,   2.855581760154350e-14,  -1.955845041223791e-16,   1.339564634483176e-18,  -9.173322990649413e-21,   2.765547241734008e-01,  -1.894290532496784e-03,
   1.297511122987995e-05,  -8.887397071253567e-08,   6.087473318302999e-10,  -4.169639754961390e-12,   2.856004231795155e-14,  -1.956217045898230e-16,   1.339882937561676e-18,
  -9.175979434251777e-21,   2.765552729580512e-01,  -1.894301807815868e-03,   1.297526568596405e-05,  -8.887573394645701e-08,   6.087654477793177e-10,  -4.169813474932203e-12,
   2.856162882740261e-14,  -1.956356746626652e-16,   1.340002472934428e-18,  -9.176977043309451e-21,   2.765553639271732e-01,  -1.894303676868614e-03,   1.297529128941902e-05,
  -8.887602623008556e-08,   6.087684507896019e-10,  -4.169842271903658e-12,   2.856189181861277e-14,  -1.956379904511295e-16,   1.340022288129458e-18,  -9.177142415936411e-21,
   4.102285691602185e-01,  -2.809657891191612e-03,   1.924247768644210e-05,  -1.317797090582291e-07,   9.024353375932742e-10,  -6.179646243107800e-12,   4.231467070319573e-14,
  -2.897324512784061e-16,   1.983698536270650e-18,  -1.357905036149978e-20,   4.102313090567298e-01,  -2.809714181949840e-03,   1.924324873785904e-05,  -1.317885104696663e-07,
   9.025257569790623e-10,  -6.180513209391820e-12,   4.232258733687340e-14,  -2.898021512253131e-16,   1.984294803376443e-18,  -1.358402446661471e-20,   4.102358071198098e-01,
  -2.809806595060060e-03,   1.924451459941852e-05,  -1.318029603036201e-07,   9.026742072598605e-10,  -6.181936625541299e-12,   4.233558549102150e-14,  -2.899165934036130e-16,
   1.985273858942690e-18,  -1.359219200234234e-20,   4.102405800204947e-01,  -2.809904656210311e-03,   1.924585785231232e-05,  -1.318182939075853e-07,   9.028317410988311e-10,
  -6.183447184909560e-12,   4.234937987343515e-14,  -2.900380504588436e-16,   1.986312966226554e-18,  -1.360086075000544e-20,   4.102443363966969e-01,  -2.809981833528444e-03,
   1.924691505438805e-05,  -1.318303624130582e-07,   9.029557330908578e-10,  -6.184636151384977e-12,   4.236023781664917e-14,  -2.901336559459288e-16,   1.987130932802385e-18,
  -1.360768480941466e-20,   4.102465043062380e-01,  -2.810026375141263e-03,   1.924752520842285e-05,  -1.318373277357613e-07,   9.030272961178570e-10,  -6.185322386645431e-12,
   4.236650482622266e-14,  -2.901888390169502e-16,   1.987603070946170e-18,  -1.361162379277346e-20,   4.102473183837597e-01,  -2.810043101162678e-03,   1.924775433149692e-05,
  -1.318399433502717e-07,   9.030541696579096e-10,  -6.185580086048470e-12,   4.236885827883689e-14,  -2.902095621840010e-16,   1.987780377433446e-18,  -1.361310304971007e-20,
   4.102474533290744e-01,  -2.810045873750844e-03,   1.924779231214587e-05,  -1.318403769293281e-07,   9.030586243799377e-10,  -6.185622804006094e-12,   4.236924840405789e-14,
  -2.902129974181144e-16,   1.987809769255972e-18,  -1.361334826455365e-20,   6.023376350932541e-01,  -4.125414017521447e-03,   2.825368434648127e-05,  -1.934918342391748e-07,
   1.325043664939796e-09,  -9.073559858043786e-12,   6.213052644037382e-14,  -4.254132350842188e-16,   2.912648288576261e-18,  -1.993758688498957e-20,   6.023416580768030e-01,
  -4.125496669108235e-03,   2.825481647944721e-05,  -1.935047573306157e-07,   1.325176427499961e-09,  -9.074832821833533e-12,   6.214215036598914e-14,  -4.255155726350675e-16,
   2.913523654791635e-18,  -1.994488474896620e-20,   6.023482625721546e-01,  -4.125632359058773e-03,   2.825667514097133e-05,  -1.935259739873775e-07,   1.325394396679440e-09,
  -9.076922819154501e-12,   6.216123544433795e-14,  -4.256836033344087e-16,   2.914960983101959e-18,  -1.995686788232730e-20,   6.023552706109095e-01,  -4.125776342013093e-03,
   2.825864743600800e-05,  -1.935484882815402e-07,   1.325625703224774e-09,  -9.079140768573340e-12,   6.218148961731669e-14,  -4.258619336585903e-16,   2.916486470605850e-18,
  -1.996958632220809e-20,   6.023607860891775e-01,  -4.125889661286249e-03,   2.826019972330724e-05,  -1.935662084393665e-07,   1.325807760359294e-09,  -9.080886524185366e-12,
   6.219743224152080e-14,  -4.260023071842477e-16,   2.917687305995203e-18,  -1.997959826949464e-20,   6.023639692256147e-01,  -4.125955061630703e-03,   2.826109561102874e-05,
  -1.935764356060926e-07,   1.325912836174404e-09,  -9.081894121185883e-12,   6.220663403737939e-14,  -4.260833301641837e-16,   2.918380439303122e-18,  -1.998537734941596e-20,
   6.023651645337089e-01,  -4.125979620408273e-03,   2.826143203189472e-05,  -1.935802761066448e-07,   1.325952294526627e-09,  -9.082272500380598e-12,   6.221008959143412e-14,
  -4.261137571163722e-16,   2.918640738114880e-18,  -1.998754763838849e-20,   6.023653626735944e-01,  -4.125983691392899e-03,   2.826148779879146e-05,  -1.935809127297402e-07,
   1.325958835383935e-09,  -9.082335223018714e-12,   6.221066240890988e-14,  -4.261188009256601e-16,   2.918683887443017e-18,  -1.998790740471545e-20,   1.994540520916318e-03,
  -1.329636820099186e-05,   8.863479877818339e-08,  -5.908218522902650e-10,   3.938128539620710e-12,  -2.624848638829757e-14,   1.749442394693230e-16,  -1.165938951073698e-18,
   7.770184482061960e-21,  -5.177719785354308e-23,   1.994553141065625e-03,  -1.329662056793869e-05,   8.863816344402302e-08,  -5.908592352730222e-10,   3.938502345772384e-12,
  -2.625197499117521e-14,   1.749752465463066e-16,  -1.166204693031479e-18,   7.772398405721266e-21,  -5.179521958195847e-23,   1.994573859430230e-03,  -1.329703488068026e-05,
   8.864368731851975e-08,  -5.909206090812718e-10,   3.939116056950636e-12,  -2.625770267189527e-14,   1.750261560629144e-16,  -1.166641018256462e-18,   7.776033585152123e-21,
  -5.182481147642901e-23,   1.994595843688146e-03,  -1.329747451422725e-05,   8.864954889025367e-08,  -5.909857363176707e-10,   3.939767317028861e-12,  -2.626378096471847e-14,
   1.750801836690696e-16,  -1.167104083835769e-18,   7.779891696034298e-21,  -5.185621934162308e-23,   1.994613145756272e-03,  -1.329782051951202e-05,   8.865416220534723e-08,
  -5.910369953302595e-10,   3.940279909261454e-12,  -2.626856517857223e-14,   1.751227099603771e-16,  -1.167468584627287e-18,   7.782928704607958e-21,  -5.188094370834230e-23,
   1.994623131255065e-03,  -1.329802021048692e-05,   8.865682473083175e-08,  -5.910665793259886e-10,   3.940575755155403e-12,  -2.627132646862658e-14,   1.751472552328321e-16,
  -1.167678971519877e-18,   7.784681684251075e-21,  -5.189521511415912e-23,   1.994626880935042e-03,  -1.329809519729544e-05,   8.865782455285284e-08,  -5.910776886784466e-10,
   3.940686851801614e-12,  -2.627236340334876e-14,   1.751564727027079e-16,  -1.167757978872496e-18,   7.785339995178705e-21,  -5.190057463969083e-23,   1.994627502499536e-03,
  -1.329810762747776e-05,   8.865799028857281e-08,  -5.910795302267655e-10,   3.940705267849335e-12,  -2.627253529238193e-14,   1.751580006553882e-16,  -1.167771075734939e-18,
   7.785449122256724e-21,  -5.190146308259704e-23,   1.806079351354072e-02,  -1.204001413056266e-04,   8.025982836946980e-07,  -5.349959735385642e-09,   3.566020626681812e-11,
  -2.376830591775323e-13,   1.584140181594496e-15,  -1.055771105541098e-17,   7.035990964249771e-20,  -4.688483300241736e-22,   1.806090779044227e-02,  -1.204024265173174e-04,
   8.026287511303473e-07,  -5.350298242588360e-09,   3.566359112445482e-11,  -2.377146488770796e-13,   1.584420954224019e-15,  -1.056011737858283e-17,   7.037995693804778e-20,
  -4.690115172564178e-22,   1.806109539761351e-02,  -1.204061781667811e-04,   8.026787704483973e-07,  -5.350853989471524e-09,   3.566914834966132e-11,  -2.377665136835335e-13,
   1.584881945721218e-15,  -1.056406835232658e-17,   7.041287384352501e-20,  -4.692794726401649e-22,   1.806129446759410e-02,  -1.204101590990462e-04,   8.027318476537187e-07,
  -5.351443724077701e-09,   3.567504558446971e-11,  -2.378215533228291e-13,   1.585371171875849e-15,  -1.056826146296352e-17,   7.044780941473969e-20,  -4.695638716713480e-22,
   1.806145113980833e-02,  -1.204132922166426e-04,   8.027736217517846e-07,  -5.351907880324359e-09,   3.567968716600926e-11,  -2.378648749284959e-13,   1.585756252308649e-15,
  -1.057156205841207e-17,   7.047530982400956e-20,  -4.697877514399787e-22,   1.806154155964685e-02,  -1.204151004413571e-04,   8.027977312258694e-07,  -5.352175766803736e-09,
   3.568236608455815e-11,  -2.378898787269296e-13,   1.585978512558667e-15,  -1.057346713526084e-17,   7.049118322578980e-20,  -4.699169793776759e-22,   1.806157551342974e-02,
  -1.204157794555215e-04,   8.028067847291117e-07,  -5.352276363266276e-09,   3.568337207744950e-11,  -2.378992682898772e-13,   1.586061977802848e-15,  -1.057418255567706e-17,
   7.049714429547807e-20,  -4.699655100149752e-22,   1.806158114176762e-02,  -1.204158920122502e-04,   8.028082854850928e-07,  -5.352293038697826e-09,   3.568353883687678e-11,
  -2.379008247648051e-13,   1.586075813589161e-15,  -1.057430114923156e-17,   7.049813245181719e-20,  -4.699735548875947e-22,   5.080533087399534e-02,  -3.386877222045679e-04,
   2.257723135555301e-06,  -1.504953114683400e-08,   1.003127895259610e-10,  -6.686066397707038e-13,   4.456214279089957e-15,  -2.969902710817184e-17,   1.979236477769556e-19,
  -1.318877778061808e-21,   5.080565233693606e-02,  -3.386941505453817e-04,   2.257808840989443e-06,  -1.505048337356874e-08,   1.003223111902096e-10,  -6.686955021517164e-13,
   4.457004097368525e-15,  -2.970579613312023e-17,   1.979800409518587e-19,  -1.319336817242171e-21,   5.080618007921948e-02,  -3.387047040015285e-04,   2.257949546213811e-06,
  -1.505204669935812e-08,   1.003379437627573e-10,  -6.688413987654227e-13,   4.458300874448231e-15,  -2.971691028439992e-17,   1.980726364229562e-19,  -1.320090564990732e-21,
   5.080674006658788e-02,  -3.387159024342422e-04,   2.258098853329036e-06,  -1.505370563321210e-08,   1.003545327883135e-10,  -6.689962262397963e-13,   4.459677076108301e-15,
  -2.972870557052185e-17,   1.981709104118326e-19,  -1.320890567969630e-21,   5.080718078829130e-02,  -3.387247159493312e-04,   2.258216364604085e-06,  -1.505501131292472e-08,
   1.003675896390719e-10,  -6.691180906792532e-13,   4.460760314045516e-15,  -2.973799019735799e-17,   1.982482692402487e-19,  -1.321520332643556e-21,   5.080743514089272e-02,
  -3.387298025173631e-04,   2.258284184980146e-06,  -1.505576488231849e-08,   1.003751254842118e-10,  -6.691884268044579e-13,   4.461385535983977e-15,  -2.974334920844128e-17,
   1.982929212210646e-19,  -1.321883845544407e-21,   5.080753065348315e-02,  -3.387317125961901e-04,   2.258309652644534e-06,  -1.505604786194280e-08,   1.003779553599631e-10,
  -6.692148398103388e-13,   4.461620325163536e-15,  -2.974536169730090e-17,   1.983096897481347e-19,  -1.322020360236303e-21,   5.080754648609695e-02,  -3.387320292202541e-04,
   2.258313874297593e-06,  -1.505609477022602e-08,   1.003784244571740e-10,  -6.692192182017140e-13,   4.461659245470411e-15,  -2.974569530283093e-17,   1.983124694382156e-19,
  -1.322042990132700e-21,   1.015906366124516e-01,  -6.772419492143209e-04,   4.514556380009831e-06,  -3.009313045741922e-08,   2.005860403381714e-10,  -1.336949745057649e-12,
   8.910672099129332e-15,  -5.938634690661170e-17,   3.957692189776648e-19,  -2.637232950282310e-21,   1.015912794116270e-01,  -6.772548033621908e-04,   4.514727757096952e-06,
  -3.009503453556398e-08,   2.006050799136113e-10,  -1.337127434790027e-12,   8.912251424105613e-15,  -5.939988227347646e-17,   3.958819823777538e-19,  -2.638150817050252e-21,
   1.015923346881820e-01,  -6.772759061147950e-04,   4.515009112086123e-06,  -3.009816057095039e-08,   2.006363388969746e-10,  -1.337419170504804e-12,   8.914844466688446e-15,
  -5.942210617061867e-17,   3.960671356321286e-19,  -2.639657964892081e-21,   1.015934544421975e-01,  -6.772982985663130e-04,   4.515307667466536e-06,  -3.010147778478161e-08,
   2.006695104093590e-10,  -1.337728764420314e-12,   8.917596327096329e-15,  -5.944569206730581e-17,   3.962636436036612e-19,  -2.641257601563662e-21,   1.015943357118920e-01,
  -6.773159221226067e-04,   4.515542643699063e-06,  -3.010408862956694e-08,   2.006956189643888e-10,  -1.337972445260040e-12,   8.919762375630806e-15,  -5.946425764051616e-17,
   3.964183297634013e-19,  -2.642516839993115e-21,   1.015948443168407e-01,  -6.773260932537784e-04,   4.515678257719495e-06,  -3.010559547133148e-08,   2.007106876843405e-10,
  -1.338113089783806e-12,   8.921012572855360e-15,  -5.947497353830572e-17,   3.965076155426346e-19,  -2.643243697784356e-21,   1.015950353043749e-01,  -6.773299126585667e-04,
   4.515729183010083e-06,  -3.010616131904232e-08,   2.007163463204194e-10,  -1.338165905383504e-12,   8.921482058589123e-15,  -5.947899771824155e-17,   3.965411457681933e-19,
  -2.643516664056642e-21,   1.015950669633620e-01,  -6.773305457818961e-04,   4.515737624652217e-06,  -3.010625511711963e-08,   2.007172843299419e-10,  -1.338174660440284e-12,
   8.921559883848634e-15,  -5.947966479705451e-17,   3.965467040163719e-19,  -2.643561913386645e-21,   1.728917071134184e-01,  -1.152562092657773e-03,   7.683083652454632e-06,
  -5.121389992865346e-08,   3.413667252457351e-10,  -2.275283740342782e-12,   1.516459937671393e-14,  -1.010664653335711e-16,   6.735384422915094e-19,  -4.488159525246574e-21,
   1.728928010591843e-01,  -1.152583968449113e-03,   7.683375310014221e-06,  -5.121714037808622e-08,   3.413991276874997e-10,  -2.275586141047267e-12,   1.516728714528803e-14,
  -1.010895004167018e-16,   6.737303464676606e-19,  -4.489721514668389e-21,   1.728945969782882e-01,  -1.152619882102617e-03,   7.683854133122363e-06,  -5.122246041162712e-08,
   3.414523256903243e-10,  -2.276082630543178e-12,   1.517170010554748e-14,  -1.011273220228223e-16,   6.740454458809556e-19,  -4.492286318788214e-21,   1.728965026281565e-01,
  -1.152657990626183e-03,   7.684362228662531e-06,  -5.122810580160614e-08,   3.415087785246651e-10,  -2.276609511960949e-12,   1.517638334934810e-14,  -1.011674615393103e-16,
   6.743798690771093e-19,  -4.495008515942326e-21,   1.728980024142292e-01,  -1.152687983220329e-03,   7.684762122228766e-06,  -5.123254905963462e-08,   3.415532112871772e-10,
  -2.277024219420821e-12,   1.518006963130026e-14,  -1.011990572481841e-16,   6.746431186383995e-19,  -4.497151436541786e-21,   1.728988679819701e-01,  -1.152705292928096e-03,
   7.684992916525190e-06,  -5.123511347357665e-08,   3.415788559409775e-10,  -2.277263574854974e-12,   1.518219727497379e-14,  -1.012172940341381e-16,   6.747950678587787e-19,
  -4.498388373260491e-21,   1.728991930135076e-01,  -1.152711792970187e-03,   7.685079583571665e-06,  -5.123607645973277e-08,   3.415884860730450e-10,  -2.277353458914849e-12,
   1.518299626758963e-14,  -1.012241425604435e-16,   6.748521306025336e-19,  -4.498852896002538e-21,   1.728992468922558e-01,  -1.152712870449144e-03,   7.685093949953923e-06,
  -5.123623608969714e-08,   3.415900824216097e-10,  -2.277368358680300e-12,   1.518312871422899e-14,  -1.012252778244890e-16,   6.748615897959761e-19,  -4.498929899443513e-21,
   2.691674866572940e-01,  -1.794373176578372e-03,   1.196145466451991e-05,  -7.973266593188604e-08,   5.314588246731361e-10,  -3.542289076092500e-12,   2.360909695681876e-14,
  -1.573459222217990e-16,   1.048601960581284e-18,  -6.987401280345777e-21,   2.691691897732922e-01,  -1.794407234034754e-03,   1.196190873333319e-05,  -7.973771084493284e-08,
   5.315092706077741e-10,  -3.542759870410144e-12,   2.361328142374648e-14,  -1.573817844380368e-16,   1.048900723367093e-18,  -6.989832886237869e-21,   2.691719857606736e-01,
  -1.794463146420673e-03,   1.196265419194839e-05,  -7.974599337091473e-08,   5.315920922356246e-10,  -3.543532833005533e-12,   2.362015176459478e-14,  -1.574406670821246e-16,
   1.049391280551654e-18,  -6.993825609000792e-21,   2.691749525830507e-01,  -1.794522475903153e-03,   1.196344522352419e-05,  -7.975478243000982e-08,   5.316799811673221e-10,
  -3.544353111443173e-12,   2.362744289780679e-14,  -1.575031583687366e-16,   1.049911921596475e-18,  -6.998063349333962e-21,   2.691772875339542e-01,  -1.794569170052454e-03,
   1.196406780021075e-05,  -7.976169994280026e-08,   5.317491565785307e-10,  -3.544998751193761e-12,   2.363318190560924e-14,  -1.575523482106856e-16,   1.050321757150887e-18,
  -7.001399308096654e-21,   2.691786350982603e-01,  -1.794596118774356e-03,   1.196442711368933e-05,  -7.976569236595691e-08,   5.317890816106826e-10,  -3.545371393110607e-12,
   2.363649433905394e-14,  -1.575807401867537e-16,   1.050558316669950e-18,  -7.003324889822044e-21,   2.691791411255506e-01,  -1.794606238403701e-03,   1.196456204179816e-05,
  -7.976719159670367e-08,   5.318040743392027e-10,  -3.545511329638392e-12,   2.363773825498483e-14,  -1.575914023283460e-16,   1.050647153814477e-18,  -7.004048028172598e-21,
   2.691792250070014e-01,  -1.794607915883250e-03,   1.196458440818617e-05,  -7.976744011756677e-08,   5.318065596239823e-10,  -3.545534526425953e-12,   2.363794445524424e-14,
  -1.575931697663961e-16,   1.050661880195866e-18,  -7.004167902042666e-21,   3.992881365671918e-01,  -2.661807081084580e-03,   1.774384790280699e-05,  -1.182769434699452e-07,
   7.883760642295072e-10,  -5.254698554511424e-12,   3.502218027840298e-14,  -2.334098963324616e-16,   1.555515065339518e-18,  -1.036520402264626e-20,   3.992906630016498e-01,
  -2.661857602559011e-03,   1.774452147706577e-05,  -1.182844271892926e-07,   7.884508966815648e-10,  -5.255396939641439e-12,   3.502838759192222e-14,  -2.334630948095882e-16,
   1.555958245399523e-18,  -1.036881067156553e-20,   3.992948106221713e-01,  -2.661940544048942e-03,   1.774562730446352e-05,  -1.182967136448491e-07,   7.885737558483071e-10,
  -5.256543566867453e-12,   3.503857917910486e-14,  -2.335504420866305e-16,   1.556685930205058e-18,  -1.037473282429535e-20,   3.992992116625539e-01,  -2.662028554524492e-03,
   1.774680073565227e-05,  -1.183097515011976e-07,   7.887041319492583e-10,  -5.257760383301572e-12,   3.504939497720809e-14,  -2.336431424685531e-16,   1.557458240831332e-18,
  -1.038101839171175e-20,   3.993026753728513e-01,  -2.662097821508014e-03,   1.774772427767479e-05,  -1.183200130703911e-07,   7.888067480605294e-10,  -5.258718137428238e-12,
   3.505790832454209e-14,  -2.337161113140233e-16,   1.558066184283958e-18,  -1.038596640141861e-20,   3.993046743752099e-01,  -2.662137797751373e-03,   1.774825729007935e-05,
  -1.183259355063465e-07,   7.888659736071512e-10,  -5.259270921443142e-12,   3.506282204784395e-14,  -2.337582283365788e-16,   1.558417092829546e-18,  -1.038882248973032e-20,
   3.993054250256554e-01,  -2.662152809400788e-03,   1.774845744498592e-05,  -1.183281594935671e-07,   7.888882141037540e-10,  -5.259478505915394e-12,   3.506466729508887e-14,
  -2.337740446944619e-16,   1.558548872400048e-18,  -1.038989507288815e-20,   3.993055494569848e-01,  -2.662155297805653e-03,   1.774849062370857e-05,  -1.183285281541117e-07,
   7.888919008221272e-10,  -5.259512916465519e-12,   3.506497317625897e-14,  -2.337766665347766e-16,   1.558570717273585e-18,  -1.039007287383705e-20,   5.862738238660870e-01,
  -3.908325023722946e-03,   2.605324978975820e-05,  -1.736657555589823e-07,   1.157570705030213e-09,  -7.715461411328060e-12,   5.142298337961952e-14,  -3.427151485610285e-16,
   2.283956675473400e-18,  -1.521909935946794e-20,   5.862775334238094e-01,  -3.908399204284022e-03,   2.605423879724459e-05,  -1.736767438863302e-07,   1.157680581340130e-09,
  -7.716486848403531e-12,   5.143209755316836e-14,  -3.427932591877015e-16,   2.284607367788703e-18,  -1.522439378949858e-20,   5.862836233651835e-01,  -3.908520987076961e-03,
   2.605586248098958e-05,  -1.736947840598497e-07,   1.157860975160039e-09,  -7.718170438185028e-12,   5.144706181968058e-14,  -3.429215100453045e-16,   2.285675779616269e-18,
  -1.523308728642195e-20,   5.862900854023387e-01,  -3.908650212649461e-03,   2.605758542722055e-05,  -1.737139275133677e-07,   1.158052406076401e-09,  -7.719957086597031e-12,
   5.146294261247107e-14,  -3.430576207903913e-16,   2.286809712320467e-18,  -1.524231425031884e-20,   5.862951711599528e-01,  -3.908751917197073e-03,   2.605894146178150e-05,
  -1.737289945510482e-07,   1.158203077066472e-09,  -7.721363354494173e-12,   5.147544272599222e-14,  -3.431647599770545e-16,   2.287702315347270e-18,  -1.524957772372299e-20,
   5.862981062903747e-01,  -3.908810614220379e-03,   2.605972408263076e-05,  -1.737376904496984e-07,   1.158290037794529e-09,  -7.722175005827326e-12,   5.148265752604742e-14,
  -3.432265998401474e-16,   2.288217530993997e-18,  -1.525377033959659e-20,   5.862992084686434e-01,  -3.908832655789609e-03,   2.606001796960529e-05,  -1.737409559248536e-07,
   1.158322693462347e-09,  -7.722479801568614e-12,   5.148536689510979e-14,  -3.432498227873753e-16,   2.288411014144930e-18,  -1.525534484527548e-20,   5.862993911708690e-01,
  -3.908836309508570e-03,   2.606006668584507e-05,  -1.737414972282558e-07,   1.158328106662091e-09,  -7.722530326489957e-12,   5.148581601919369e-14,  -3.432536724005063e-16,
   2.288443087514403e-18,  -1.525560584934207e-20  };
  static constexpr double xi[30240] = {  -5.912583661166745e-04,   2.712577001887640e-05,  -8.187302093663322e-07,   2.022645507970950e-08,  -4.395681508080616e-10,
   8.656061765854234e-12,  -1.561458166540127e-13,   2.572745419551090e-15,  -3.797112391937381e-17,   4.737715664926259e-19,  -4.039856747197989e-21,  -1.324180416950967e-23,
   1.726736721955774e-24,  -5.414689994726497e-26,  -5.625238208297296e-04,   2.580817257103232e-05,  -7.789854826084110e-07,   1.924521202610841e-08,  -4.182571652552418e-10,
   8.236636694026090e-12,  -1.485824720160137e-13,   2.448113142052715e-15,  -3.612957258951392e-17,   4.507042925028144e-19,  -3.839930076312805e-21,  -1.272431482436103e-23,
   1.646198298742513e-24,  -5.158909603298794e-26,  -5.078575307342361e-04,   2.330121837398253e-05,  -7.033545984378028e-07,   1.737772951503990e-08,  -3.776929301996555e-10,
   7.438189418814348e-12,  -1.341832821192139e-13,   2.210842397025765e-15,  -3.262454207519884e-17,   4.068367361593871e-19,  -3.461030290058310e-21,  -1.168878182819981e-23,
   1.491607128577858e-24,  -4.669304465465663e-26,  -4.325965669142496e-04,   1.984926666324952e-05,  -5.991957061711907e-07,   1.480532902678868e-08,  -3.218060977992532e-10,
   6.337953730355590e-12,  -1.143395692692721e-13,   1.883867718826119e-15,  -2.779603809412775e-17,   3.464759700239402e-19,  -2.942210929876389e-21,  -1.016396024752361e-23,
   1.276115609220426e-24,  -3.989441445531497e-26,  -3.440975977929699e-04,   1.578944926924993e-05,  -4.766711842147619e-07,   1.177871837912170e-08,  -2.560375904706890e-10,
   5.042944143429054e-12,  -9.098031914894534e-14,   1.498980229362604e-15,  -2.211442916389475e-17,   2.755405345704834e-19,  -2.335723629919307e-21,  -8.245054015032219e-24,
   1.019346305596520e-24,  -3.182639400574636e-26,  -2.510215190389072e-04,   1.151902135984428e-05,  -3.477681506114805e-07,   8.593952000083670e-09,  -1.868195690247939e-10,
   3.679793351475257e-12,  -6.638950772157852e-14,   1.093814088817134e-15,  -1.613544111611081e-17,   2.009763576812243e-19,  -1.701228475050918e-21,  -6.109225084922175e-24,
   7.461457051011549e-25,  -2.327248979911669e-26,  -1.624849523820210e-04,   7.456422759040492e-06,  -2.251228013369805e-07,   5.563376416480118e-09,  -1.209437909743753e-10,
   2.382310003372975e-12,  -4.298161097724183e-14,   7.081476877356559e-16,  -1.044559187372231e-17,   1.300770925695459e-19,  -1.100040927429839e-21,  -3.994892485562396e-24,
   4.840573834927898e-25,  -1.508765967959881e-26,  -8.716315837265824e-05,   3.999971343691114e-06,  -1.207684270341274e-07,   2.984561321048879e-09,  -6.488341430597397e-11,
   1.278072209577274e-12,  -2.305919362012712e-14,   3.799126617295916e-16,  -5.603747122570238e-18,   6.977450619534404e-20,  -5.897854830992299e-22,  -2.154156605636078e-24,
   2.599648865443800e-25,  -8.100072591132403e-27,  -3.243604290951759e-05,   1.488517914810987e-06,  -4.494208637601805e-08,   1.110665184066935e-09,  -2.414566391199580e-11,
   4.756234771449384e-13,  -8.581308346589100e-15,   1.413815167654840e-16,  -2.085366371837011e-18,   2.596470332426070e-20,  -2.194356957920546e-22,  -8.030704391780411e-25,
   9.677938188313267e-26,  -3.015120082809315e-27,  -3.663907888687661e-06,   1.681400251465705e-07,  -5.076573638754889e-09,   1.254587822519571e-10,  -2.727454446408825e-12,
   5.372569281531196e-14,  -9.693318579326032e-16,   1.597024329979847e-17,  -2.355594129652272e-19,   2.932909926284018e-21,  -2.478625921922624e-23,  -9.073904608870248e-26,
   1.093268943823268e-26,  -3.405967187482537e-28,  -4.755867969362990e-03,   1.836279590923182e-04,  -4.000843590891350e-06,   5.079795159984916e-08,   3.219516989643096e-11,
  -2.095575709512611e-11,   6.145085119691473e-13,  -1.002955612708070e-14,   5.317872360390881e-17,   2.472020268550028e-18,  -9.622585858918690e-20,   1.889723672133675e-21,
  -1.748350733811238e-23,  -2.518424102396717e-25,  -4.524659918323731e-03,   1.747007532452155e-04,  -3.806234825404649e-06,   4.832087312008240e-08,   3.090339211422642e-11,
  -1.994271131605366e-11,   5.846621440778540e-13,  -9.539048254229335e-15,   5.046308175866577e-17,   2.354864595903825e-18,  -9.157925808685721e-20,   1.797208778042808e-21,
  -1.659292716185050e-23,  -2.406303169835398e-25,  -4.084827730073046e-03,   1.577183612988497e-04,  -3.436069495195949e-06,   4.361172731115543e-08,   2.833486156392417e-11,
  -1.801324146903883e-11,   5.278731373024313e-13,  -8.607126230418155e-15,   4.534999764646189e-17,   2.130766325573823e-18,  -8.272702795185587e-20,   1.621474756577280e-21,
  -1.491522824787161e-23,  -2.188811506454320e-25,  -3.479356928015740e-03,   1.343405422938314e-04,  -2.926585616548410e-06,   3.713506664523823e-08,   2.458351373529499e-11,
  -1.535262703508896e-11,   4.496753281800661e-13,  -7.326542977871192e-15,   3.841405173288958e-17,   1.819889614189979e-18,  -7.051619149519757e-20,   1.380065790075335e-21,
  -1.263769356059339e-23,  -1.881275443440938e-25,  -2.767464657025216e-03,   1.068537600626541e-04,  -2.327657815279062e-06,   2.952753078745704e-08,   1.989997289403889e-11,
  -1.221865346364472e-11,   3.577049088823111e-13,  -5.823789114975437e-15,   3.038908399521749e-17,   1.451355595595178e-18,  -5.612774800162347e-20,   1.096870232312480e-21,
  -1.000038626414228e-23,  -1.509395809093801e-25,  -2.018826189117120e-03,   7.794824477930691e-05,  -1.697913936603800e-06,   2.153431186713015e-08,   1.472028670330631e-11,
  -8.917589331570866e-12,   2.609612437417045e-13,  -4.246188704665502e-15,   2.207124793200610e-17,   1.060989251149155e-18,  -4.096753085640544e-20,   7.996627328786829e-22,
  -7.264804663590109e-24,  -1.108739056895261e-25,  -1.306751134597447e-03,   5.045452087524169e-05,  -1.098996233286188e-06,   1.393638940713964e-08,   9.615241105104928e-12,
  -5.774020055482125e-12,   1.689244572225506e-13,  -2.747549752873473e-15,   1.424477061031360e-17,   6.877201873703079e-19,  -2.652744381191332e-20,   5.173981965224709e-22,
  -4.689399304575597e-24,  -7.209404084900923e-26,  -7.009845821457088e-04,   2.706546907837295e-05,  -5.895286123389280e-07,   7.475280473846287e-09,   5.181915869783316e-12,
  -3.097876665670040e-12,   9.061908537695831e-14,  -1.473619104300446e-15,   7.629914655046762e-18,   3.691803635785170e-19,  -1.423291526729465e-20,   2.774916757731178e-22,
  -2.511971279010452e-24,  -3.876376338381977e-26,  -2.608566429682899e-04,   1.007184319177381e-05,  -2.193794395526768e-07,   2.781682600209162e-09,   1.931447035338067e-12,
  -1.152874428833256e-12,   3.372229551615777e-14,  -5.483429320482518e-16,   2.837828590961375e-18,   1.374169468196969e-19,  -5.296831091329204e-21,   1.032551811857567e-22,
  -9.343137021247354e-25,  -1.443679025709306e-26,  -2.946580753859891e-05,   1.137693813660432e-06,  -2.478060976477559e-08,   3.142113740176892e-10,   2.182277978008717e-13,
  -1.302273888527888e-13,   3.809203850027081e-15,  -6.193904466424364e-17,   3.205284479019651e-19,   1.552293787481479e-20,  -5.983249926417047e-22,   1.166334959627910e-23,
  -1.055297658546514e-25,  -1.630958115811741e-27,  -1.051904674271635e-02,   2.684784389495570e-04,  -1.069805880198815e-06,  -9.569609794363934e-08,   2.394804694438843e-09,
  -5.330720252893534e-12,  -9.724183873873274e-13,   2.193023660237752e-14,   4.950379799420155e-18,  -1.023191811759515e-17,   2.042339224671526e-19,   6.490659764618653e-22,
  -1.091065543558198e-22,   1.911588346233713e-24,  -1.000742801692132e-02,   2.554110210508633e-04,  -1.017344045935380e-06,  -9.104295103168705e-08,   2.277886977637315e-09,
  -5.057792154457263e-12,  -9.251139620433965e-13,   2.085259931266270e-14,   4.981080956285619e-18,  -9.733130968360823e-18,   1.940862208186929e-19,   6.218797932998031e-22,
  -1.037648308484408e-22,   1.815057776895244e-24,  -9.034258681737239e-03,   2.305587852486941e-04,  -9.177290106237669e-07,  -8.219150695346505e-08,   2.055672514727700e-09,
  -4.544205503929923e-12,  -8.351375919708880e-13,   1.880726093464265e-14,   4.928735888700874e-18,  -8.784819958693840e-18,   1.748710971243079e-19,   5.683750953478474e-22,
  -9.361817751181155e-23,   1.632892503547387e-24,  -7.694781416911899e-03,   1.963593456666491e-04,  -7.809565960896414e-07,  -7.000731810680624e-08,   1.750162279158994e-09,
  -3.848072597774914e-12,  -7.112999158890774e-13,   1.600071994428360e-14,   4.642356245322784e-18,  -7.480441838199658e-18,   1.485922488194375e-19,   4.912659029967726e-22,
  -7.967968515622444e-23,   1.384965028044616e-24,  -6.120100354765307e-03,   1.561640112173812e-04,  -6.205960655468658e-07,  -5.568240755068652e-08,   1.391446059824604e-09,
  -3.043324365726255e-12,  -5.657257515463714e-13,   1.271235017515224e-14,   4.034967160508733e-18,  -5.948157059088695e-18,   1.179127737368461e-19,   3.962477871803216e-22,
  -6.332873222623322e-23,   1.097049582433153e-24,  -4.464353729929061e-03,   1.139080781775157e-04,  -4.523792414578223e-07,  -4.061887935155083e-08,   1.014672873150816e-09,
  -2.209834723806525e-12,  -4.126658148910857e-13,   9.264930663729645e-15,   3.144431431372828e-18,  -4.338060255596409e-18,   8.585309246348791e-20,   2.922800882061743e-22,
  -4.616899810569365e-23,   7.976136620562020e-25,  -2.889624815754528e-03,   7.372586604979326e-05,  -2.926732140222815e-07,  -2.629161755592512e-08,   6.566230531718652e-10,
  -1.426015551898791e-12,  -2.671014776728328e-13,   5.993373094625719e-15,   2.121212029950843e-18,  -2.807506066817162e-18,   5.550169328570782e-20,   1.905639438407830e-22,
  -2.987219660856216e-23,   5.151409944437409e-25,  -1.550070103909277e-03,   3.954765861387421e-05,  -1.569599359385452e-07,  -1.410361763270940e-08,   3.521910797605860e-10,
  -7.637578916921092e-13,  -1.432793297462547e-13,   3.214036832803313e-15,   1.161531692995040e-18,  -1.505916312974702e-18,   2.975379795069384e-20,   1.026035141958166e-22,
  -1.602106934300947e-23,   2.760246455891104e-25,  -5.768232959778632e-04,   1.471665469034445e-05,  -5.840419551363059e-08,  -5.248354205458286e-09,   1.310548855334618e-10,
  -2.840604742610012e-13,  -5.331802722567073e-14,   1.195905670340228e-15,   4.353010559918499e-19,  -5.603790881775507e-19,   1.106976911538771e-20,   3.823076350182862e-23,
  -5.961467003739872e-24,   1.026760887946463e-25,  -6.515667652706521e-05,   1.662358680394002e-06,  -6.597120712760244e-09,  -5.928426688587137e-10,   1.480357864513597e-11,
  -3.208406764577347e-14,  -6.022683734375079e-15,   1.350846047344459e-16,   4.922554731025057e-20,  -6.329893545490801e-20,   1.250372953207233e-21,   4.319343826039024e-24,
  -6.733867165161879e-25,   1.159734210751044e-26,  -1.449083412371703e-02,   1.308313226464334e-04,   5.701770467817752e-06,  -9.974589843771161e-08,  -1.941627416570886e-09,
   5.974554344717934e-11,   5.067942045669275e-13,  -3.190494278766800e-14,  -2.537028935765555e-17,   1.559821388069962e-17,  -9.470341633149010e-20,  -6.985939478085749e-21,
   9.460138585345408e-23,   2.801602210126911e-24,  -1.378582616966551e-02,   1.244587816991639e-04,   5.424088677873675e-06,  -9.487652377936626e-08,  -1.846960098239263e-09,
   5.681965959948743e-11,   4.821217323845207e-13,  -3.033645949947742e-14,  -2.426147246097452e-17,   1.482815045294687e-17,  -8.991336943203207e-20,  -6.639682714256606e-21,
   8.982172307838952e-23,   2.662508004134296e-24,  -1.244489005702719e-02,   1.123410927196102e-04,   4.896047128655647e-06,  -8.562162553783207e-08,  -1.666983996538318e-09,
   5.126237640358544e-11,   4.352006326916584e-13,  -2.735979746117514e-14,  -2.210115055877504e-17,   1.336803507962414e-17,  -8.087728159545325e-20,  -5.983697252344194e-21,
   8.080320742950923e-23,   2.399085709166380e-24,  -1.059938303558942e-02,   9.566951088578677e-05,   4.169532851411153e-06,  -7.289730861107307e-08,  -1.419446199162024e-09,
   4.362908209844622e-11,   3.706363497768848e-13,  -2.327588463299212e-14,  -1.902873017960729e-17,   1.136732607753381e-17,  -6.858535749946773e-20,  -5.085909058020126e-21,
   6.853121970399357e-23,   2.038743972338452e-24,  -8.430028015510198e-03,   7.607973171993553e-05,   3.315809057271951e-06,  -5.795663398736853e-08,  -1.128673449127457e-09,
   3.467539624029228e-11,   2.947583099573304e-13,  -1.849152924702126e-14,  -1.529207893739114e-17,   9.026681538722981e-18,  -5.431839629513088e-20,  -4.036936134425358e-21,
   5.428227923695005e-23,   1.617952628030584e-24,  -6.149190350045194e-03,   5.549005930808155e-05,   2.418472314246938e-06,  -4.226353177148775e-08,  -8.231470224617365e-10,
   2.527936661850103e-11,   2.149959676670697e-13,  -1.347638940943070e-14,  -1.124722725346283e-17,   6.576126461286608e-18,  -3.948725292479964e-20,  -2.939973441265910e-21,
   3.946500121461895e-23,   1.178127696417955e-24,  -3.980095010849882e-03,   3.591389231368002e-05,   1.565279752126191e-06,  -2.735003226036498e-08,  -5.327214267268371e-10,
   1.635612222310747e-11,   1.391519927105159e-13,  -8.717511100026308e-15,  -7.319359680900907e-18,   4.252890441196580e-18,  -2.550081144160348e-20,  -1.900893865278440e-21,
   2.548816442616960e-23,   7.616645044241756e-25,  -2.135008178850541e-03,   1.926433803502999e-05,   8.396250930941013e-07,  -1.466969532059788e-08,  -2.857453534749042e-10,
   8.772100357612992e-12,   7.464265694421767e-14,  -4.674841109614287e-15,  -3.937141063315498e-18,   2.280366440295407e-18,  -1.366335252383606e-20,  -1.019124257902424e-21,
   1.365705278823568e-23,   4.083295314277474e-25,  -7.944922765932197e-04,   7.168679823781306e-06,   3.124432445984452e-07,  -5.458789097165941e-09,  -1.063309964609508e-10,
   3.264110767314048e-12,   2.777629290604601e-14,  -1.739446716947518e-15,  -1.466521492546792e-18,   8.484576175558618e-19,  -5.082440906555966e-21,  -3.791707546327609e-22,
   5.080159396735481e-24,   1.519185300007666e-25,  -8.974403731139523e-05,   8.097562469178289e-07,   3.529282017675635e-08,  -6.166090181481458e-10,  -1.201086570001976e-11,
   3.687026296233722e-13,   3.137543382458968e-15,  -1.964806452928335e-16,  -1.656801704397772e-19,   9.583757617696071e-20,  -5.740642170738272e-22,  -4.282897426675170e-23,
   5.738076286056881e-25,   1.715980554278147e-26,  -1.453396076573472e-02,  -1.187089460008176e-04,   5.714324228113853e-06,   9.305109609629871e-08,  -1.933306460097143e-09,
  -5.606326383443459e-11,   4.984139559617252e-13,   2.964493701807137e-14,  -2.470595951090475e-17,  -1.422296079251394e-17,  -8.973192324472589e-20,   6.174232698253538e-21,
   8.742338216506236e-23,  -2.359467566313848e-24,  -1.382685474219422e-02,  -1.129266364619422e-04,   5.436033294280534e-06,   8.850844925103956e-08,  -1.839047610721111e-09,
  -5.331789137955842e-11,   4.741496921925314e-13,   2.818784400833290e-14,  -2.362291776407532e-17,  -1.352110763515177e-17,  -8.519757347722194e-20,   5.868475840176461e-21,
   8.301106295575612e-23,  -2.242398521785718e-24,  -1.248192801675704e-02,  -1.019313923631238e-04,   4.906832484038917e-06,   7.987458046810910e-08,  -1.659846944729845e-09,
  -4.810338930490818e-11,   4.280048185609857e-13,   2.542246235189904e-14,  -2.151430603972392e-17,  -1.219019810838324e-17,  -7.664215895979996e-20,   5.289110256905507e-21,
   7.468381575168667e-23,  -2.020658824176902e-24,  -1.063092868379556e-02,  -8.680425433002375e-05,   4.178721457468690e-06,   6.800417737872410e-08,  -1.413373499308592e-09,
  -4.094078499910306e-11,   3.645084610457126e-13,   2.162819732410998e-14,  -1.851823549481663e-17,  -1.036628520418047e-17,  -6.500083784702044e-20,   4.495976250131463e-21,
   6.334887287790741e-23,  -1.717278246525526e-24,  -8.455117438817770e-03,  -6.902948417593739e-05,   3.323119100525071e-06,   5.406625100257856e-08,  -1.123848244073800e-09,
  -3.253902801585286e-11,   2.898852515956775e-13,   1.718288453557860e-14,  -1.487785376205704e-17,  -8.232163239495907e-18,  -5.148487192498865e-20,   3.569016386891784e-21,
   5.018335333862023e-23,  -1.362930569103664e-24,  -6.167491646068494e-03,  -5.034767190034552e-05,   2.423805748976169e-06,   3.942648730309294e-08,  -8.196300373858888e-10,
  -2.372202671526836e-11,   2.114417544549896e-13,   1.252287762635746e-14,  -1.094026528362735e-17,  -5.997537087114023e-18,  -3.743053997466098e-20,   2.599401409558890e-21,
   3.648842136337397e-23,  -9.924862472194305e-25,  -3.991940659113547e-03,  -3.258559995649696e-05,   1.568732360254637e-06,   2.551406228236335e-08,  -5.304461978973860e-10,
  -1.534855779110315e-11,   1.368516761689717e-13,   8.100800644755245e-15,  -7.118624761860450e-18,  -3.878807000592113e-18,  -2.417393342630128e-20,   1.680775964209196e-21,
   2.356724951863407e-23,  -6.416702071031631e-25,  -2.141362449349813e-03,  -1.747901049831434e-05,   8.414772878942372e-07,   1.368493029609414e-08,  -2.845251909621630e-10,
  -8.231740139626383e-12,   7.340876393199679e-14,   4.344149681507506e-15,  -3.828898046298813e-18,  -2.079813359187853e-18,  -1.295278072494843e-20,   9.011361529564555e-22,
   1.262819882840215e-23,  -3.440069291827338e-25,  -7.968568679650297e-04,  -6.504317989802817e-06,   3.131325130088486e-07,   5.092343796870184e-09,  -1.058769834482140e-10,
  -3.063044024237093e-12,   2.731713508273088e-14,   1.616404024803695e-15,  -1.426168373185029e-18,  -7.738412493470338e-19,  -4.818173142798073e-21,   3.352756760945067e-22,
   4.697498683158951e-24,  -1.279882260987026e-25,  -9.001113619091394e-05,  -7.347115401678404e-07,   3.537067869525067e-08,   5.752163976030330e-10,  -1.195958216504258e-11,
  -3.459908644837513e-13,   3.085678068138224e-15,   1.825823138764543e-16,  -1.611206645689578e-19,  -8.740934414648205e-20,  -5.442159024215432e-22,   3.787089009400826e-23,
   5.305867790659797e-25,  -1.445679717544146e-26,  -1.080279649813164e-02,  -2.552142254609416e-04,  -5.935375942164388e-07,   9.434298368426423e-08,   2.057975555508061e-09,
  -3.831821848297974e-13,  -8.855238569915641e-13,  -1.690009413326169e-14,   5.753285445382060e-17,   8.489732821247671e-18,   1.393424561747251e-19,  -1.043228099210954e-21,
  -8.225526980930424e-23,  -1.142164864591291e-24,  -1.027736201969021e-02,  -2.427921072141744e-04,  -5.643015946896462e-07,   8.975396359277201e-08,   1.957480235221423e-09,
  -3.750525326224376e-13,  -8.424027329956899e-13,  -1.606899354879028e-14,   5.491954256736768e-17,   8.075058575707459e-18,   1.324038296826109e-19,  -9.950997555866644e-22,
  -7.821539468673132e-23,  -1.084107511152672e-24,  -9.277919282885736e-03,  -2.191672541246934e-04,  -5.088403306820696e-07,   8.102518379306735e-08,   1.766487236003837e-09,
  -3.553100415738293e-13,  -7.604011642934507e-13,  -1.449183715438002e-14,   4.987319429107355e-17,   7.286998887724973e-18,   1.192713075143001e-19,  -9.024834782008377e-22,
  -7.054681161795131e-23,  -9.746964992884891e-25,  -7.902290874381941e-03,  -1.866570644474451e-04,  -4.327930843151015e-07,   6.901116021170647e-08,   1.503919015225391e-09,
  -3.198478834867728e-13,  -6.475740614620528e-13,  -1.232822141245587e-14,   4.278132976525978e-17,   6.203686180033680e-18,   1.013228948798060e-19,  -7.729399226417278e-22,
  -6.002249897500634e-23,  -8.260805048540955e-25,  -6.285125631046668e-03,  -1.484474386578823e-04,  -3.437594265558973e-07,   5.488797565322202e-08,   1.195645329576464e-09,
  -2.676783135269894e-13,  -5.149867474830789e-13,  -9.793790814555024e-15,   3.425976432823940e-17,   4.931904255772873e-18,   8.038382233360993e-20,  -6.180463124180126e-22,
  -4.768932248552847e-23,  -6.538669999998179e-25,  -4.584721579762131e-03,  -1.082792876305642e-04,  -2.504843277721333e-07,   4.003812383809523e-08,   8.718743163380631e-10,
  -2.030617272677969e-13,  -3.756220859078529e-13,  -7.137369808085085e-15,   2.512796556622587e-17,   3.596293491711037e-18,   5.851673447935823e-20,  -4.527626802147942e-22,
  -3.475787972163896e-23,  -4.751124034855767e-25,  -2.967530100500242e-03,  -7.008259296302270e-05,  -1.620130151259122e-07,   2.591517935419507e-08,   5.642071282285487e-10,
  -1.347701915178652e-13,  -2.431107567822550e-13,  -4.616875945900000e-15,   1.632298096040018e-17,   2.327192454338770e-18,   3.782465782938339e-20,  -2.938792640672420e-22,
  -2.248497468383660e-23,  -3.067311462764612e-25,  -1.591859223502305e-03,  -3.759332631150205e-05,  -8.687577886970350e-08,   1.390153906848800e-08,   3.026202780487420e-10,
  -7.321276726611921e-14,  -1.304063462204287e-13,  -2.475813422144261e-15,   8.772178471676834e-18,   1.248210493903864e-18,   2.027602070954839e-20,  -1.578704944700973e-22,
  -1.205804574806393e-23,  -1.643202519137764e-25,  -5.923739961094197e-04,  -1.398939628555770e-05,  -3.232466910764182e-08,   5.173136193267468e-09,   1.126086950619331e-10,
  -2.736341772181917e-14,  -4.852715590861931e-14,  -9.212140812478240e-16,   3.266451959090688e-18,   4.644728690672108e-19,   7.543431831901106e-21,  -5.877716541809282e-23,
  -4.486676086492085e-24,  -6.111976864892818e-26,  -6.691324599208848e-05,  -1.580209221988052e-06,  -3.651247908764457e-09,   5.843458675903873e-10,   1.271994614904602e-11,
  -3.093042939094132e-15,  -5.481508898990303e-15,  -1.040564382101340e-16,   3.690085265625530e-19,   5.246545922822991e-20,   8.520565228679289e-22,  -6.639862185833379e-24,
  -5.067968643946605e-25,  -6.903446395268207e-27,  -5.400381977629257e-03,  -1.915021058570317e-04,  -3.690374313062310e-06,  -3.544486757875006e-08,   3.469699936614264e-10,
   2.265827498753453e-11,   5.042859410573349e-13,   5.655356776256494e-15,  -3.097039336299868e-17,  -3.010863304388753e-18,  -7.307428594971352e-20,  -9.132956557955059e-22,
   2.166363463865864e-24,   4.121946349305984e-25,  -5.137815239819977e-03,  -1.821905286179834e-04,  -3.510810847140976e-06,  -3.371407042439681e-08,   3.303180434404183e-10,
   2.155968458014741e-11,   4.797309659337722e-13,   5.377045701538163e-15,  -2.956170751719877e-17,  -2.865898049949787e-18,  -6.951535432725555e-20,  -8.679104800442190e-22,
   2.089985772943083e-24,   3.926112296808090e-25,  -4.638339067650591e-03,  -1.644775757287421e-04,  -3.169286162172808e-06,  -3.042463948625097e-08,   2.985527725658487e-10,
   1.946860975566737e-11,   4.330352208383947e-13,   4.848978280920558e-15,  -2.684249934061866e-17,  -2.589552339705497e-18,  -6.274764430092594e-20,  -7.819723264439246e-22,
   1.932919710721012e-24,   3.551707525721359e-25,  -3.950782701470056e-03,  -1.400953056862690e-04,  -2.699266916164991e-06,  -2.590244204150147e-08,   2.546544653968274e-10,
   1.658771896423004e-11,   3.687846917373135e-13,   4.124701297307461e-15,  -2.302280791284274e-17,  -2.208023396151610e-18,  -5.343621979210061e-20,  -6.644454443820389e-22,
   1.693884486928948e-24,   3.032699914623640e-25,  -3.142402354013484e-03,  -1.114290875235824e-04,  -2.146788465617597e-06,  -2.059301173055015e-08,   2.028246608681706e-10,
   1.319752229772138e-11,   2.932799771891047e-13,   3.276488328872774e-15,  -1.843500012552462e-17,  -1.758029249806871e-18,  -4.249457093806878e-20,  -5.272446628777200e-22,
   1.383955720025743e-24,   2.417925894251519e-25,  -2.292318985568180e-03,  -8.128471470867437e-05,  -1.565936423695131e-06,  -1.501662511998463e-08,   1.481185045073106e-10,
   9.629592948824500e-12,   2.139143129266265e-13,   2.387635215755039e-15,  -1.352020183607051e-17,  -1.283500464033414e-18,  -3.099422702727732e-20,  -3.838807494522254e-22,
   1.031108938273412e-24,   1.767201659056050e-25,  -1.483770175092786e-03,  -5.261366101203515e-05,  -1.013554134254864e-06,  -9.717569156088035e-09,   9.594330073117457e-11,
   6.234003388757883e-12,   1.384504800782973e-13,   1.544398106084487e-15,  -8.782239081376271e-18,  -8.312332263507307e-19,  -2.005988808318233e-20,  -2.481639521356424e-22,
   6.766276229715482e-25,   1.145312987952704e-25,  -7.959412268507191e-04,  -2.822356591091957e-05,  -5.436904137788535e-07,  -5.212156034068216e-09,   5.148610595467388e-11,
   3.344383357838741e-12,   7.426596418756640e-14,   8.281696121007340e-16,  -4.719581106565667e-18,  -4.460237241027706e-19,  -1.076019699260283e-20,  -1.330364314739747e-22,
   3.655021203942033e-25,   6.147784284137109e-26,  -2.961924687009975e-04,  -1.050278672661203e-05,  -2.023211722558475e-07,  -1.939507287859623e-09,   1.916192292499187e-11,
   1.244575148470602e-12,   2.763606571331718e-14,   3.081474423847119e-16,  -1.757393216542832e-18,  -1.659942186437851e-19,  -4.004103864223220e-21,  -4.949544281067245e-23,
   1.363424565709820e-25,   2.288279245703319e-26,  -3.345726153213701e-05,  -1.186371953035559e-06,  -2.285373462265918e-08,  -2.190810328665822e-10,   2.164533737600408e-12,
   1.405851401173841e-13,   3.121702742618924e-15,   3.480698605915277e-17,  -1.985310996716742e-19,  -1.875063606694518e-20,  -4.522936179214066e-22,  -5.590697295167278e-24,
   1.540684082780448e-26,   2.584882768396775e-27,  -1.143054892376825e-03,  -4.849567384793644e-05,  -1.335523116481312e-06,  -2.954788664860112e-08,  -5.594894461942676e-10,
  -9.192668691117186e-12,  -1.278449724078936e-13,  -1.347626927910168e-15,  -4.921886037687101e-18,   2.441027181817253e-19,   9.213004154352883e-21,   2.194234835465847e-22,
   4.200104505721863e-24,   6.736793580086436e-26,  -1.087496177790731e-03,  -4.613946890932059e-05,  -1.270662772664684e-06,  -2.811340325667262e-08,  -5.323327227465347e-10,
  -8.746374371885021e-12,  -1.216305769046807e-13,  -1.281814171802265e-15,  -4.670090734409449e-18,   2.325897731646302e-19,   8.773147449951864e-21,   2.089071926104192e-22,
   3.998097671485077e-24,   6.411460883905927e-26,  -9.818010290412250e-04,  -4.165662785504828e-05,  -1.147250460949901e-06,  -2.538374219241892e-08,  -4.806543889453320e-10,
  -7.897130438595741e-12,  -1.098084434505564e-13,  -1.156737528845638e-15,  -4.196169356459871e-18,   2.105447673086785e-19,   7.933136481807790e-21,   1.888404684276916e-22,
   3.612927206746349e-24,   5.791675742889435e-26,  -8.362927346452114e-04,  -3.548444579169447e-05,  -9.773092390937955e-07,  -2.162453056660212e-08,  -4.094803249701605e-10,
  -6.727584148172983e-12,  -9.353348604658284e-14,  -9.847916288988283e-16,  -3.553624494884170e-18,   1.799188246312897e-19,   6.770451650836031e-21,   1.610976986702512e-22,
   3.080981912832151e-24,   4.936753843451475e-26,  -6.651977160195376e-04,  -2.822597610699177e-05,  -7.774316417221288e-07,  -1.720258304995876e-08,  -3.257533007484295e-10,
  -5.351861958661421e-12,  -7.439711383686579e-14,  -7.829203766644098e-16,  -2.810636213155993e-18,   1.435563215880648e-19,   5.395384436671625e-21,   1.283279237480656e-22,
   2.453360717170757e-24,   3.929394712528400e-26,  -4.852606882560443e-04,  -2.059151245745458e-05,  -5.671749065350324e-07,  -1.255052699112076e-08,  -2.376644443923561e-10,
  -3.904560922337921e-12,  -5.427222004576770e-14,  -5.709066122450622e-16,  -2.040966231689622e-18,   1.049867754994226e-19,   3.941852730969670e-21,   9.372600058240642e-23,
   1.791314094425505e-24,   2.868030501062978e-26,  -3.141044082226738e-04,  -1.332898334069208e-05,  -3.671436656529360e-07,  -8.124374128165062e-09,  -1.538497689492703e-10,
  -2.527548423305117e-12,  -3.512971134971184e-14,  -3.694425875911915e-16,  -1.317078806834240e-18,   6.806929972661818e-20,   2.554058601464456e-21,   6.071538500760877e-23,
   1.160180149560192e-24,   1.857105236952295e-26,  -1.684969957349391e-04,  -7.150233383367448e-06,  -1.969538602396155e-07,  -4.358358522292124e-09,  -8.253388524098219e-11,
  -1.355914092970499e-12,  -1.884480772490308e-14,  -1.981549544741447e-16,  -7.054214075756858e-19,   3.654581712415693e-20,   1.370788619866701e-21,   3.258301573177337e-23,
   6.225501024430674e-25,   9.963993793521209e-27,  -6.270273500966954e-05,  -2.660824935807352e-06,  -7.329298581339861e-08,  -1.621893988784028e-09,  -3.071373532278785e-11,
  -5.045817797549184e-13,  -7.012706825713397e-15,  -7.373578597765317e-17,  -2.623647865727212e-19,   1.360379636522865e-20,   5.102016873392496e-22,   1.212680201827471e-23,
   2.316936471030461e-25,   3.708131852614367e-27,  -7.082768911707877e-06,  -3.005613752538765e-07,  -8.279032215523112e-09,  -1.832060770377440e-10,  -3.469366504712382e-12,
  -5.699660084656732e-14,  -7.921404946352168e-16,  -8.328975369297684e-18,  -2.963360210681877e-20,   1.536728122110016e-21,   5.763293124864347e-23,   1.369848393197279e-24,
   2.617206150989755e-26,   4.188669574337460e-28,  -4.944707355100688e-04,   2.143918223027326e-05,  -6.130964561605128e-07,   1.439693349644959e-08,  -2.987337406235525e-10,
   5.650339173019004e-12,  -9.877922943797101e-14,   1.599353521748324e-15,  -2.380211051856334e-17,   3.170970574749471e-19,  -3.530541814975430e-21,   2.452770797781184e-23,
   1.925215467827811e-25,  -1.319008996937720e-26,  -4.704378218931571e-04,   2.039766063201411e-05,  -5.833286382938269e-07,   1.369834482318799e-08,  -2.842473594632795e-10,
   5.376504935095530e-12,  -9.399441595772358e-14,   1.521900094298004e-15,  -2.264908814442137e-17,   3.017131611309682e-19,  -3.358426370133055e-21,   2.330375175967156e-23,
   1.841378794525605e-25,  -1.257298975166737e-26,  -4.247170655076443e-04,   1.841604581977463e-05,  -5.266851923875833e-07,   1.236886660168798e-08,  -2.566747023461184e-10,
   4.855235061585895e-12,  -8.488510112178943e-14,   1.374436928036004e-15,  -2.045399004886541e-17,   2.724350005388761e-19,  -3.031198649485347e-21,   2.098813700766300e-23,
   1.677949404747989e-25,  -1.138929488711757e-26,  -3.617734186723092e-04,   1.568757273648301e-05,  -4.486801081288216e-07,   1.053767094682254e-08,  -2.186894324810731e-10,
   4.136980744672862e-12,  -7.233157409026362e-14,   1.171203675294322e-15,  -1.742897620267447e-17,   2.321056293950043e-19,  -2.581112098855092e-21,   1.782525836897320e-23,
   1.445302195931497e-25,  -9.740837762567673e-27,  -2.877604604983701e-04,   1.247877593597896e-05,  -3.569263586143821e-07,   8.383292273698709e-09,  -1.739910435438554e-10,
   3.291624303454127e-12,  -5.755422234430988e-14,   9.319497861591060e-16,  -1.386815037030381e-17,   1.846559160368356e-19,  -2.052392234279214e-21,   1.413794258243503e-23,
   1.162018731794072e-25,  -7.778534199155335e-27,  -2.099215982819664e-04,   9.103649480124703e-06,  -2.604010680870897e-07,   6.116478284039115e-09,  -1.269513076340865e-10,
   2.401833100560806e-12,  -4.199792952655675e-14,   6.800673027651337e-16,  -1.011968691584787e-17,   1.347274206458236e-19,  -1.496829346884138e-21,   1.028976425949014e-23,
   8.549959475421729e-26,  -5.692407903727120e-27,  -1.358804987862589e-04,   5.892873569469817e-06,  -1.685652186560887e-07,   3.959511764644026e-09,  -8.218505967610806e-11,
   1.554938585147792e-12,  -2.719006627523169e-14,   4.402912090242001e-16,  -6.551609608006140e-18,   8.721677776336695e-20,  -9.687164273882724e-22,   6.650249052607829e-24,
   5.565592163979553e-26,  -3.692337294470769e-27,  -7.289132098526871e-05,   3.161198468316052e-06,  -9.042730701815728e-08,   2.124129380225428e-09,  -4.409000629255307e-11,
   8.341959636010204e-13,  -1.458717709880945e-14,   2.362130816579421e-16,  -3.514861746951929e-18,   4.678873613363894e-20,  -5.196087235888799e-22,   3.564618805991505e-24,
   2.994212224399405e-26,  -1.982825791855071e-27,  -2.712503690879755e-05,   1.176381946749775e-06,  -3.365104989454095e-08,   7.904650393278992e-10,  -1.640758380517020e-11,
   3.104382201469010e-13,  -5.428508162509363e-15,   8.790512756269362e-17,  -1.308028549750240e-18,   1.741180075893889e-20,  -1.933558837340983e-22,   1.326135617194920e-24,
   1.115353060308271e-26,  -7.381433001055338e-28,  -3.063987268688187e-06,   1.328817375604634e-07,  -3.801158261630759e-09,   8.928950704758633e-11,  -1.853372988682943e-12,
   3.506661137113068e-14,  -6.131961932141076e-16,   9.929635937960651e-18,  -1.477529416856986e-19,   1.966806134967357e-21,  -2.184096678754378e-23,   1.497909456485754e-25,
   1.260079715678281e-27,  -8.338404173025693e-29,  -4.081532618301704e-03,   1.540411654511153e-04,  -3.399663282742388e-06,   4.867027282084496e-08,  -2.609268156380534e-10,
  -9.325783334636688e-12,   3.664514780455164e-13,  -7.500091877524714e-15,   9.049276754121804e-17,   1.692664890170387e-20,  -3.326595695284906e-20,   9.802456753911577e-22,
  -1.707369242608494e-23,   1.477415519668486e-25,  -3.883106665536316e-03,   1.465528878953986e-04,  -3.234348683016343e-06,   4.630014774142792e-08,  -2.480715431525696e-10,
  -8.876856534871536e-12,   3.487022301939492e-13,  -7.135255767232639e-15,   8.604639169334551e-17,   1.770940855185140e-20,  -3.168133537507319e-20,   9.329041746507058e-22,
  -1.623823471791590e-23,   1.402155202251842e-25,  -3.505636968793756e-03,   1.323075750586834e-04,  -2.919882832930562e-06,   4.179303275269292e-08,  -2.236858530851024e-10,
  -8.021043854575587e-12,   3.149105895154311e-13,  -6.441305712137233e-15,   7.760701990706347e-17,   1.854628447691334e-20,  -2.865359841593248e-20,   8.427168228302572e-22,
  -1.465108974212099e-23,   1.260376621398233e-25,  -2.986014798897688e-03,   1.126971669698098e-04,  -2.487021318892703e-06,   3.559171564358123e-08,  -1.902507981206114e-10,
  -6.839428667742663e-12,   2.683411734976929e-13,  -5.486186099552486e-15,   6.602644989990257e-17,   1.843316690405992e-20,  -2.445990518332302e-20,   7.183171818275949e-22,
  -1.247046713998077e-23,   1.067907372028742e-25,  -2.375061400677414e-03,   8.963942443819181e-05,  -1.978116067945903e-06,   2.830441112297154e-08,  -1.511088674834421e-10,
  -5.445685384702179e-12,   2.135206613668364e-13,  -4.363405469359770e-15,   5.245736415107169e-17,   1.669767047405492e-20,  -1.949656053308745e-20,   5.717397859743970e-22,
  -9.911978610840416e-24,   8.450383950267232e-26,  -1.732572894842794e-03,   6.539104670745825e-05,  -1.442978564178958e-06,   2.064468144337608e-08,  -1.101049682040351e-10,
  -3.975861318788783e-12,   1.558092148552504e-13,  -3.182875160012704e-15,   3.823174015865433e-17,   1.337756698881821e-20,  -1.424670195145998e-20,   4.173066268374548e-22,
  -7.226526157873942e-24,   6.138716277863326e-26,  -1.121464054252615e-03,   4.232664238775347e-05,  -9.340025420889291e-07,   1.336166688641906e-08,  -7.121479205222338e-11,
  -2.574922087635248e-12,   1.008735120605252e-13,  -2.060147831366219e-15,   2.473169073029777e-17,   9.171090478789162e-21,  -9.232006003151381e-21,   2.702137213136582e-22,
  -4.675834731891489e-24,   3.962472640658237e-26,  -6.015903755230730e-04,   2.270545488328846e-05,  -5.010264694219665e-07,   7.167288777409156e-09,  -3.818702911205379e-11,
  -1.381663571450404e-12,   5.411765153613751e-14,  -1.105111609110050e-15,   1.326274978162441e-17,   5.060749905103200e-21,  -4.955208052536107e-21,   1.449786548963940e-22,
  -2.507783728395436e-24,   2.122566059222492e-26,  -2.238691726725099e-04,   8.449362116836542e-06,  -1.864460007457909e-07,   2.667109937284267e-09,  -1.420856271212760e-11,
  -5.142075124159428e-13,   2.013948962730376e-14,  -4.112414178809676e-16,   4.934915505533911e-18,   1.901524785612079e-21,  -1.844345937241406e-21,   5.395425530914199e-23,
  -9.331554862842084e-25,   7.894749603567300e-27,  -2.528778194712229e-05,   9.544219411283189e-07,  -2.106053285711165e-08,   3.012702077094963e-10,  -1.604934108409390e-12,
  -5.808468462850520e-14,   2.274926970369743e-15,  -4.645290319951155e-17,   5.574278498899531e-19,   2.151197189178410e-22,  -2.083399917766642e-22,   6.094619877379266e-24,
  -1.054061079093196e-25,   8.917035012696898e-28,  -9.468622990228754e-03,   2.559626494323806e-04,  -1.995320744058414e-06,  -5.929487823433428e-08,   2.103401233154119e-09,
  -2.156639169882967e-11,  -4.003544850695385e-13,   1.775011880375917e-14,  -2.208497104194657e-16,  -2.673451274456712e-18,   1.528940121754153e-19,  -2.233407373167107e-21,
  -1.655463932075942e-23,   1.327039137341084e-24,  -9.008124813464911e-03,   2.435072409831719e-04,  -1.897892919674157e-06,  -5.641713341637399e-08,   2.000911866540939e-09,
  -2.050632700488248e-11,  -3.810637847940692e-13,   1.688386095719525e-14,  -2.099032307655355e-16,  -2.547036193968400e-18,   1.454240440535814e-19,  -2.121699979319050e-21,
  -1.580960775764057e-23,   1.262230730269003e-24,  -8.132181328502954e-03,   2.198177999363295e-04,  -1.712726551487157e-06,  -5.094074077745915e-08,   1.806038244162873e-09,
  -1.849446531026251e-11,  -3.442962094919087e-13,   1.523730835116631e-14,  -1.891648789378937e-16,  -2.305101110153361e-18,   1.312286321733363e-19,  -1.910470058053254e-21,
  -1.436784747572423e-23,   1.139060124136502e-24,  -6.926502224127973e-03,   1.872162582143369e-04,  -1.458162295116363e-06,  -4.339810256737527e-08,   1.537958857684592e-09,
  -1.573410027898305e-11,  -2.935457974324731e-13,   1.297329253976691e-14,  -1.607820314066501e-16,  -1.969244587473629e-18,   1.117162950720250e-19,  -1.622160170089254e-21,
  -1.233584485439604e-23,   9.697323274227604e-25,  -5.509082806171652e-03,   1.488961358570919e-04,  -1.159277931575506e-06,  -3.452483836357659e-08,   1.222991485978742e-09,
  -1.250013798993647e-11,  -2.337029378240069e-13,   1.031466334996393e-14,  -1.276197695304824e-16,  -1.570809734733720e-18,   8.881129112897261e-20,  -1.286297791109435e-21,
  -9.887081478746092e-24,   7.709368516050696e-25,  -4.018665189773669e-03,   1.086089070271403e-04,  -8.453608593038622e-07,  -2.518901116253231e-08,   8.919821122349905e-10,
  -9.110040720773806e-12,  -1.706108944129428e-13,   7.521908949551909e-15,  -9.294082548011406e-17,  -1.148512392592321e-18,   6.475865580528351e-20,  -9.360090223876555e-22,
  -7.256575582007496e-24,   5.621596372981549e-25,  -2.601155509170187e-03,   7.029693387586198e-05,  -5.470522921845934e-07,  -1.630596175770907e-08,   5.772905976835498e-10,
  -5.893079691449419e-12,  -1.104881302744212e-13,   4.867734375857641e-15,  -6.009228304679469e-17,  -7.445350999389538e-19,   4.190517976651387e-20,  -6.048673672568591e-22,
  -4.715879533951610e-24,   3.637779895408622e-25,  -1.395330338375461e-03,   3.770857691311536e-05,  -2.934197472698062e-07,  -8.747485314247139e-09,   3.096574233261507e-10,
  -3.160226286123658e-12,  -5.928454168629898e-14,   2.610919902236420e-15,  -3.221711890526970e-17,  -3.997023990181516e-19,   2.247602236759886e-20,  -3.241968162866461e-22,
  -2.534934125311016e-24,   1.951153925832994e-25,  -5.192407642631877e-04,   1.403231947202226e-05,  -1.091851563780231e-07,  -3.255247710423986e-09,   1.152298472070739e-10,
  -1.175879935746988e-12,  -2.206344188691854e-14,   9.715607400437295e-16,  -1.198654262422313e-17,  -1.487808493840032e-19,   8.363549946284239e-21,  -1.206075187329058e-22,
  -9.439929457958566e-25,   7.260455645163523e-26,  -5.865228807334472e-05,   1.585058362383598e-06,  -1.233323494543475e-08,  -3.677067995944577e-10,   1.301606937811990e-11,
  -1.328225178404875e-13,  -2.492274056496415e-15,   1.097447369220439e-16,  -1.353931526061133e-18,  -1.680668333256281e-20,   9.447210066272079e-22,  -1.362293068586112e-23,
  -1.066434397773359e-25,   8.201191910812001e-27,  -1.388448346115857e-02,   1.712231747433416e-04,   4.359176107992892e-06,  -1.208908945115984e-07,  -6.958568509464114e-10,
   6.157636914388469e-11,  -3.217202877635097e-13,  -2.496787379928775e-14,   4.089488453031402e-16,   7.365801023381556e-18,  -2.695630691964121e-19,  -6.504785624252171e-22,
   1.345587036122879e-22,  -1.122011535784714e-24,  -1.320900819211800e-02,   1.628840759422864e-04,   4.147019870004445e-06,  -1.149924627723679e-07,  -6.621523197138057e-10,
   5.856572319539212e-11,  -3.057333336551123e-13,  -2.374555224782927e-14,   3.886989449955338e-16,   7.006437979545146e-18,  -2.561889903235965e-19,  -6.213951289090518e-22,
   1.278714289617390e-22,  -1.064058406004937e-24,  -1.192423048482057e-02,   1.470265377992724e-04,   3.743525282069642e-06,  -1.037804064850662e-07,  -5.979844965754555e-10,
   5.284546177593540e-11,  -2.754622828314737e-13,  -2.142376127399017e-14,   3.503275395699021e-16,   6.323325338430329e-18,  -2.308570356209917e-19,  -5.650254589764399e-22,
   1.152095070354160e-22,  -9.552091723581309e-25,  -1.015598766968833e-02,   1.252089806570622e-04,   3.188260687878749e-06,  -8.836273028107139e-08,  -5.095528209277993e-10,
   4.498445926438949e-11,  -2.340648131580424e-13,  -1.823429854160896e-14,   2.977968144584149e-16,   5.383953430879623e-18,  -1.961977844625899e-19,  -4.854145969682656e-22,
   9.789419221670955e-23,  -8.080639064869033e-25,  -8.077422678898718e-03,   9.957162507974771e-05,   2.535632199985812e-06,  -7.025637864464285e-08,  -4.054533740780222e-10,
   3.575880888248706e-11,  -1.857366194144317e-13,  -1.449271709704682e-14,   2.364007448603494e-16,   4.280742755479666e-18,  -1.557150977520532e-19,  -3.892796588573934e-22,
   7.768071942318843e-23,  -6.384510440491052e-25,  -5.892010487676527e-03,   7.262490775274026e-05,   1.849533846836120e-06,  -5.123520815623559e-08,  -2.958648282765916e-10,
   2.607284078070851e-11,  -1.352354294435751e-13,  -1.056590928380263e-14,   1.721777722464362e-16,   3.121780099976556e-18,  -1.133925719630312e-19,  -2.858376130713094e-22,
   5.655905930279975e-23,  -4.632334343438770e-25,  -3.813644368001419e-03,   4.700406080070177e-05,   1.197096779677881e-06,  -3.315689462961208e-08,  -1.915476187905008e-10,
   1.687106569424989e-11,  -8.742579956410079e-14,  -6.836426065793207e-15,   1.113309295880224e-16,   2.020261912781311e-18,  -7.331184797954036e-20,  -1.858126165492722e-22,
   3.656357929843957e-23,  -2.987727459162858e-25,  -2.045723339283927e-03,   2.521321786052746e-05,   6.421418692482371e-07,  -1.778459268112993e-08,  -1.027633472495765e-10,
   9.048702363945521e-12,  -4.686787587773118e-14,  -3.666540640216933e-15,   5.968945144479912e-17,   1.083621671258823e-18,  -3.930344703778429e-20,  -9.989465605002137e-23,
   1.960121712036101e-23,  -1.599771489042425e-25,  -7.612674260544646e-04,   9.382397239040030e-06,   2.389569137622699e-07,  -6.617920095262495e-09,  -3.824262088136704e-11,
   3.367090190112940e-12,  -1.743697947958161e-14,  -1.364329398222498e-15,   2.220800913798994e-17,   4.032322334900512e-19,  -1.462291245226321e-20,  -3.720198559833897e-23,
   7.292535749824307e-24,  -5.949401038077988e-26,  -8.599104051157643e-05,   1.059812434309428e-06,   2.699201348328584e-08,  -7.475417496591425e-10,  -4.319829731380171e-12,
   3.803358215769968e-13,  -1.969573709414930e-15,  -1.541099971117388e-16,   2.508494526026677e-18,   4.554798494714839e-20,  -1.651718424782842e-21,  -4.202763643943296e-24,
   8.237197448828603e-25,  -6.719632869833370e-27,  -1.491114322465049e-02,  -6.913337940474826e-05,   6.611197259439624e-06,   5.407242435167970e-08,  -2.870231660558033e-09,
  -3.471362338892268e-11,   1.238841716717423e-12,   2.055331689790190e-14,  -5.285039762158052e-16,  -1.168465723603609e-17,   2.188657175296897e-19,   6.429644306549735e-21,
  -8.697432913417058e-23,  -3.477919214584893e-24,  -1.418566450326958e-02,  -6.576590609907373e-05,   6.289115801140294e-06,   5.143204276204985e-08,  -2.730071863985890e-09,
  -3.301236782769403e-11,   1.178145768149770e-12,   1.954116265235619e-14,  -5.025059441078480e-16,  -1.110587471750429e-17,   2.080502959847186e-19,   6.108915839568629e-21,
  -8.265968097396991e-23,  -3.303105372801886e-24,  -1.280580157432007e-02,  -5.936254463193006e-05,   5.676688146312960e-06,   4.641392245906785e-08,  -2.463696221666171e-09,
  -2.978158990504748e-11,   1.062873685594219e-12,   1.762100010611158e-14,  -4.531735107836074e-16,  -1.000922503426975e-17,   1.875473526702605e-19,   5.502118977577319e-21,
  -7.448706800516880e-23,  -2.972900183459150e-24,  -1.090673750875261e-02,  -5.055285994793028e-05,   4.834156348705394e-06,   3.951517962561283e-08,  -2.097495918650078e-09,
  -2.534488227314909e-11,   9.045609920739590e-13,   1.498793685531851e-14,  -3.855032056361349e-16,  -8.508058546644370e-18,   1.594614432709877e-19,   4.673247485699786e-21,
  -6.330489019470020e-23,  -2.522876471344909e-24,  -8.674449136099011e-03,  -4.020124569869995e-05,   3.844210215916094e-06,   3.141547623307896e-08,  -1.667551044839542e-09,
  -2.014195974608306e-11,   7.188904028682769e-13,   1.190498550235056e-14,  -3.062426330545060e-16,  -6.753738364216872e-18,   1.266137281311706e-19,   3.706814742669392e-21,
  -5.024340588033169e-23,  -1.999470579727164e-24,  -6.327464341367816e-03,  -2.932138010524561e-05,   2.803794045196696e-06,   2.290849913289330e-08,  -1.215992158004629e-09,
  -1.468314772739964e-11,   5.240719358921430e-13,   8.674919602567856e-15,  -2.231737055462535e-16,  -4.918815761492737e-18,   9.223309639779983e-20,   2.698048312591838e-21,
  -3.658786752786869e-23,  -1.454356180546518e-24,  -4.095476804055349e-03,  -1.897714271605016e-05,   1.814632208185089e-06,   1.482457745772303e-08,  -7.868927898618206e-10,
  -9.499817970406733e-12,   3.390737219928314e-13,   5.611022855495266e-15,  -1.443598927066792e-16,  -3.180471606132076e-18,   5.964540512966108e-20,   1.743828588353367e-21,
  -2.365535004429535e-23,  -9.395738029137274e-25,  -2.196899525222887e-03,  -1.017939555081638e-05,   9.733695899289622e-07,   7.951376239637064e-09,  -4.220608664198086e-10,
  -5.094824903579211e-12,   1.818493549694655e-13,   3.008809006390343e-15,  -7.741283466945620e-17,  -1.705176371558574e-18,   3.198049583924727e-20,   9.347396960425485e-22,
  -1.268198527349410e-23,  -5.035215913059211e-25,  -8.175234138236648e-04,  -3.787973467341073e-06,   3.622113148822323e-07,   2.958805292166571e-09,  -1.570540026062190e-10,
  -1.895777370266036e-12,   6.766609399588982e-14,   1.119518619829811e-15,  -2.880411175837429e-17,  -6.344245333989233e-19,   1.189888979009613e-20,   3.477520565162342e-22,
  -4.718358840910807e-24,  -1.873106213823295e-25,  -9.234557764405718e-05,  -4.278800391768498e-07,   4.091447666180003e-08,   3.342179437141772e-10,  -1.774035718742928e-11,
  -2.141401833061616e-13,   7.643321799119645e-15,   1.264558033932433e-16,  -3.253589032353623e-18,  -7.166106873631427e-20,   1.344037647408829e-21,   3.927968508878641e-23,
  -5.329582347996775e-25,  -2.115705356588110e-26,  -1.182520083022609e-02,  -2.548831481495883e-04,   7.317285203309946e-07,   1.259013817005862e-07,   1.801859188295123e-09,
  -2.678890329535403e-11,  -1.280230020605989e-12,  -9.259891890949204e-15,   4.405764494345392e-16,   1.182050835860277e-17,  -7.939063307899648e-21,  -5.773990754367697e-21,
  -9.512234617741742e-23,   1.134972113777956e-24,  -1.124999693576069e-02,  -2.424743339965185e-04,   6.964570254124589e-07,   1.197695150516222e-07,   1.713646650375794e-09,
  -2.549160414577922e-11,  -1.217592528439275e-12,  -8.796901205289258e-15,   4.191345393175643e-16,   1.123613912631443e-17,  -7.737608739988605e-21,  -5.490487145440177e-21,
  -9.032117054870231e-23,   1.081457262000041e-24,  -1.015590313244418e-02,  -2.188759256554310e-04,   6.292364432799740e-07,   1.081092534635628e-07,   1.546088135289842e-09,
  -2.302165800001843e-11,  -1.098597989640903e-12,  -7.921370279569358e-15,   3.783541904084150e-16,   1.012843586292337e-17,  -7.278873797456121e-21,  -4.952304898782105e-21,
  -8.125996022089364e-23,   9.789686323576267e-25,  -8.650029705699726e-03,  -1.864043412783942e-04,   5.364629144462701e-07,   9.206656832585843e-08,   1.315912659330211e-09,
  -1.961754907681532e-11,  -9.351050445617047e-13,  -6.726237780541069e-15,   3.222340861128514e-16,   8.611239267174071e-18,  -6.501466340697180e-21,  -4.213647641991552e-21,
  -6.892598355848308e-23,   8.365630950908557e-25,  -6.879791499294935e-03,  -1.482428914612691e-04,   4.270818660035721e-07,   7.321522465792879e-08,   1.045893259867005e-09,
  -1.561007386200923e-11,  -7.432733730219734e-13,  -5.333827861575812e-15,   2.562731475587623e-16,   6.837059486407839e-18,  -5.403443479940818e-21,  -3.347954128890015e-21,
  -5.460042013992346e-23,   6.674718603958666e-25,  -5.018473594627313e-03,  -1.081279983395156e-04,   3.117743642839545e-07,   5.340117786027730e-08,   7.625074642437213e-10,
  -1.139106038868402e-11,  -5.419106915160629e-13,  -3.881446582821067e-15,   1.869295595489092e-16,   4.980325296825925e-18,  -4.077883130571457e-21,  -2.440188599773134e-21,
  -3.969938060959215e-23,   4.881231650984758e-25,  -3.248269592552628e-03,  -6.998377878016439e-05,   2.019019919715487e-07,   3.456210941194011e-08,   4.933625103744769e-10,
  -7.374829968757087e-12,  -3.506424966868705e-13,  -2.508330590663689e-15,   1.209884641198985e-16,   3.220594618429578e-18,  -2.697676371032207e-21,  -1.578594045495854e-21,
  -2.564081459824524e-23,   3.164699322186343e-25,  -1.742451494048750e-03,  -3.754007473060535e-05,   1.083333166423344e-07,   1.853928321118686e-08,   2.646021880456860e-10,
  -3.956541864851684e-12,  -1.880612945827740e-13,  -1.344432984794251e-15,   6.490006053972451e-17,   1.726784399737374e-18,  -1.463121407396475e-21,  -8.465626659944964e-22,
  -1.373919130711960e-23,   1.699068369418565e-25,  -6.484129997764208e-04,  -1.396954818131579e-05,   4.031738060747304e-08,   6.898877114880894e-09,   9.845916149367889e-11,
  -1.472400511877247e-12,  -6.997852145410616e-14,  -5.001575539718410e-16,   2.415090993303383e-17,   6.424764549201318e-19,  -5.465410030537021e-22,  -3.149983987220110e-22,
  -5.110757720063531e-24,   6.324560664547736e-26,  -7.324327858069603e-05,  -1.577966655339819e-06,   4.554226227870465e-09,   7.792801110621264e-10,   1.112161105290790e-11,
  -1.663202257411369e-13,  -7.904542718519615e-15,  -5.649412943227834e-17,   2.728030019870283e-18,   7.257079267615804e-20,  -6.177322154707146e-23,  -3.558096953741096e-23,
  -5.772645246370774e-25,   7.144417170898902e-27,  -6.227945864380705e-03,  -2.225931112739770e-04,  -4.065180009486589e-06,  -2.556010616781578e-08,   9.329072095030587e-10,
   3.642716776590564e-11,   6.280144453870814e-13,   2.293022415118712e-15,  -2.006613996739250e-16,  -6.604819838663504e-18,  -1.001857871974956e-19,   3.516689062640850e-24,
   4.296086462848676e-23,   1.202052821878624e-24,  -5.925137134860263e-03,  -2.117683677973598e-04,  -3.867281217984834e-06,  -2.430602010448342e-08,   8.878097145477223e-10,
   3.465673660061219e-11,   5.972998143646380e-13,   2.174420316000948e-15,  -1.910345034641084e-16,  -6.283526790548007e-18,  -9.522797479101526e-20,   6.128351608093921e-24,
   4.091132245599827e-23,   1.143237339745720e-24,  -5.349111675167961e-03,  -1.911775627078462e-04,  -3.490923193613288e-06,  -2.192500955516006e-08,   8.019155085853885e-10,
   3.128860195176045e-11,   5.389451629099865e-13,   1.951698846179214e-15,  -1.726687051542278e-16,  -5.672397966304308e-18,  -8.583199001399613e-20,   9.963863100398765e-24,
   3.699644141581601e-23,   1.031501404905569e-24,  -4.556185589595712e-03,  -1.628349694192921e-04,  -2.973042430335164e-06,  -1.865636717967349e-08,   6.834719736848373e-10,
   2.665165449488425e-11,   4.587589683700540e-13,   1.650719794939019e-15,  -1.472851190554224e-16,  -4.831270818798529e-18,  -7.296620623615665e-20,   1.304890630698455e-23,
   3.157635623319228e-23,   8.779805070110411e-25,  -3.623924746510528e-03,  -1.295139995932436e-04,  -2.364403801784788e-06,  -1.482465629193063e-08,   5.439545186801728e-10,
   2.119920268190700e-11,   3.646618947888845e-13,   1.303949740988120e-15,  -1.173119452669505e-16,  -3.842500805347537e-18,  -5.792614589378764e-20,   1.389977489126789e-23,
   2.516470791984457e-23,   6.978533014363791e-25,  -2.643575501777572e-03,  -9.447615950610679e-05,  -1.724598828134070e-06,  -1.080583620023782e-08,   3.969974331657491e-10,
   1.546486502955021e-11,   2.658787264543578e-13,   9.459095809953095e-16,  -8.567251022003735e-17,  -2.802887157948211e-18,  -4.219110146972273e-20,   1.220775951867078e-23,
   1.838602054988582e-23,   5.087849688050810e-25,  -1.711129323232507e-03,  -6.115172292498905e-05,  -1.116217242844340e-06,  -6.990777543668026e-09,   2.570509250910732e-10,
   1.001028599447699e-11,   1.720400807887541e-13,   6.100027627815292e-16,  -5.549497369057785e-17,  -1.814189361218545e-18,  -2.728166097938001e-20,   8.786112652972393e-24,
   1.191321088509888e-23,   3.292033549966600e-25,  -9.179033502366401e-04,  -3.280351870632699e-05,  -5.987523019652224e-07,  -3.749078374238796e-09,   1.379130431583602e-10,
   5.369889306504999e-12,   9.227184827378659e-14,   3.266008924001966e-16,  -2.978053307021310e-17,  -9.731715316045015e-19,  -1.462709540297095e-20,   4.956706681279298e-24,
   6.394013649837661e-24,   1.765612230317823e-25,  -3.415779928005817e-04,  -1.220710070584365e-05,  -2.228099982112140e-07,  -1.395010201686116e-09,   5.132433621555872e-11,
   1.998296386605507e-12,   3.433493240394694e-14,   1.214567180619885e-16,  -1.108364713328897e-17,  -3.621427149486984e-19,  -5.442169020446210e-21,   1.876075647833593e-24,
   2.379834061569438e-24,   6.569908242205396e-26,  -3.858391112192488e-05,  -1.378887269055373e-06,  -2.516808528422790e-08,  -1.575750277128170e-10,   5.797539096624940e-12,
   2.257233722669259e-13,   3.878362909215436e-15,   1.371804014775691e-17,  -1.252011009918429e-18,  -4.090681916762446e-20,  -6.147178929480687e-22,   2.124828504019865e-25,
   2.688287817101879e-25,   7.421147678043748e-27,  -1.360886306119850e-03,  -6.076545897249434e-05,  -1.750451461675421e-06,  -4.015027108905064e-08,  -7.771285750610222e-10,
  -1.272034427724890e-11,  -1.658261172141896e-13,  -1.270395689858764e-15,   1.346998495770675e-17,   8.794667900076078e-19,   2.477837806801156e-20,   5.268945389914749e-22,
   9.078710398214649e-24,   1.202240406449749e-25,  -1.294744592817706e-03,  -5.781339528018166e-05,  -1.665447729979478e-06,  -3.820113283809715e-08,  -7.394026911164122e-10,
  -1.210241121335239e-11,  -1.577488764113098e-13,  -1.207656002974989e-15,   1.284809582810788e-17,   8.375534497327038e-19,   2.359098672210672e-20,   5.015441973635319e-22,
   8.639202099107977e-24,   1.143171349551805e-25,  -1.168914348782380e-03,  -5.219677849025266e-05,  -1.503704625857096e-06,  -3.449211383105686e-08,  -6.676137495777944e-10,
  -1.092671129992975e-11,  -1.423896478190166e-13,  -1.088701733827636e-15,   1.165169281608338e-17,   7.574789130554150e-19,   2.132518994719170e-20,   4.532118043500736e-22,
   7.802348729960379e-24,   1.031052452952938e-25,  -9.956827081568128e-04,  -4.446334131664923e-05,  -1.280974970920763e-06,  -2.938410523110384e-08,  -5.687464979906350e-10,
  -9.307876869566895e-12,  -1.212584332784163e-13,  -9.257204747717381e-16,   9.978777924289840e-18,   6.465853077685273e-19,   1.819253661067112e-20,   3.864687162961409e-22,
   6.648865487647468e-24,   8.771971020030258e-26,  -7.919845770861117e-04,  -3.536856072994426e-05,  -1.019002075412289e-06,  -2.337550563895100e-08,  -4.524473434217026e-10,
  -7.404036291828819e-12,  -9.642858914549996e-14,  -7.350698855123655e-16,   7.978921763309134e-18,   5.153596914875615e-19,   1.449208498598976e-20,   3.077302408246062e-22,
   5.290790000678163e-24,   6.969205864905602e-26,  -5.777550770387408e-04,  -2.580240379050386e-05,  -7.434183206841046e-07,  -1.705416943799821e-08,  -3.300944374824051e-10,
  -5.401487562141220e-12,  -7.033161842473097e-14,  -5.354912722906989e-16,   5.845120873206188e-18,   3.765759429369546e-19,   1.058459786453847e-20,   2.246814409239514e-22,
   3.860907412627270e-24,   5.079226420234536e-26,  -3.739766326508464e-04,  -1.670210693787557e-05,  -4.812320396454985e-07,  -1.103975302327881e-08,  -2.136817262472702e-10,
  -3.496437841211906e-12,  -4.551943700758244e-14,  -3.463009758981715e-16,   3.793977429765595e-18,   2.440199336499874e-19,   6.856713608396920e-21,   1.455164371390412e-22,
   2.499673750057517e-24,   3.285673784386073e-26,  -2.006150492183348e-04,  -8.959744818541893e-06,  -2.581571414983682e-07,  -5.922332992731708e-09,  -1.146307275435232e-10,
  -1.875645990330194e-12,  -2.441675523547928e-14,  -1.856809836024041e-16,   2.038117559183297e-18,   1.309744589485981e-19,   3.679679999723009e-21,   7.808298044367144e-23,
   1.341065883922104e-24,   1.761986300161245e-26,  -7.465487086753502e-05,  -3.334203775093047e-06,  -9.606882114897018e-08,  -2.203903032407721e-09,  -4.265802830494299e-11,
  -6.979874384615863e-13,  -9.086002439174291e-15,  -6.908608213860894e-17,   7.588184963923430e-19,   4.874898219633144e-20,   1.369511197610197e-21,   2.905993334176097e-23,
   4.990698672240033e-25,   6.556137489139075e-27,  -8.432857987685739e-06,  -3.766249368770252e-07,  -1.085174758356993e-08,  -2.489487311920963e-10,  -4.818570569869341e-12,
  -7.884326072634424e-14,  -1.026332168606042e-15,  -7.803615351267562e-18,   8.572125153376165e-20,   5.506752618246549e-21,   1.547005608610995e-22,   3.282601537436328e-24,
   5.637422951122140e-26,   7.405542767939598e-28,  -4.175337423898982e-04,   1.715202921335414e-05,  -4.656615618259807e-07,   1.040624311774083e-08,  -2.062100671743750e-10,
   3.740579536076069e-12,  -6.312619577778444e-14,   9.952712574781934e-16,  -1.465780316711373e-17,   1.983537328625710e-19,  -2.416751950144741e-21,   2.359534609843136e-23,
  -1.331321113581924e-25,  -1.489300889248572e-27,  -3.972386618752638e-04,   1.631867912877817e-05,  -4.430484825392259e-07,   9.901194007800655e-09,  -1.962081393777567e-10,
   3.559258891955303e-12,  -6.006793704357168e-14,   9.470734939363485e-16,  -1.394807812957969e-17,   1.887442896240105e-19,  -2.299458030367873e-21,   2.244412383839214e-23,
  -1.263398505504257e-25,  -1.422956617945505e-27,  -3.586294773144664e-04,   1.473317510535919e-05,  -4.000208781266809e-07,   8.940080995982377e-09,  -1.771718888423387e-10,
   3.214113753370984e-12,  -5.424582012553771e-14,   8.553095635124496e-16,  -1.259678637042141e-17,   1.704503667106028e-19,  -2.076246134333754e-21,   2.025578668343177e-23,
  -1.135485928211696e-25,  -1.294310513004784e-27,  -3.054775422272389e-04,   1.255018304257045e-05,  -3.407694254689467e-07,   7.616344766630976e-09,  -1.509485230533282e-10,
   2.738571922161743e-12,  -4.622273680129180e-14,   7.288398918774430e-16,  -1.073434359210771e-17,   1.452405557091603e-19,  -1.768817407356770e-21,   1.724656723071462e-23,
  -9.619218902906828e-26,  -1.112465094324393e-27,  -2.429798289967682e-04,   9.982993842321016e-06,  -2.710783975736752e-07,   6.059088063643346e-09,  -1.200929740849369e-10,
   2.178918006768448e-12,  -3.677884415403619e-14,   5.799538018624754e-16,  -8.541682942619335e-18,   1.155661910739665e-19,  -1.407156438037928e-21,   1.371255196521137e-23,
  -7.610453004371702e-26,  -8.926037872277522e-28,  -1.772529131030605e-04,   7.282825773603639e-06,  -1.977666211228681e-07,   4.420654769588488e-09,  -8.762328669388370e-11,
   1.589883791648164e-12,  -2.683757386665064e-14,   4.232078778706148e-16,  -6.233172682942715e-18,   8.432887274452408e-20,  -1.026645315648626e-21,   9.999991515705905e-24,
  -5.527822589942798e-26,  -6.557144556718575e-28,  -1.147338347958173e-04,   4.714206401330343e-06,  -1.280189317552975e-07,   2.861685133227812e-09,  -5.672437521367686e-11,
   1.029272726222283e-12,  -1.737488738154760e-14,   2.739949161103513e-16,  -4.035538147675491e-18,   5.459529529999467e-20,  -6.645913819775778e-22,   6.471482253897825e-24,
  -3.567837664862492e-26,  -4.263933846198479e-28,  -6.154733211583715e-05,   2.528900436801423e-06,  -6.867580726486670e-08,   1.535177626674299e-09,  -3.043085645192630e-11,
   5.521824139080745e-13,  -9.321399454697216e-15,   1.469964232042248e-16,  -2.165048018272935e-18,   2.928966621185808e-20,  -3.565257925199052e-22,   3.471147973169683e-24,
  -1.911088240509583e-26,  -2.292725341375513e-28,  -2.290358222123801e-05,   9.410827158312043e-07,  -2.555654134652617e-08,   5.712937173587602e-10,  -1.132446412320713e-11,
   2.054890663536142e-13,  -3.468883453856124e-15,   5.470375596634560e-17,  -8.057096073362337e-19,   1.089991318255325e-20,  -1.326757577938232e-22,   1.291666697415459e-24,
  -7.108061666532260e-27,  -8.538906444337925e-29,  -2.587140284890156e-06,   1.063027896160271e-07,  -2.886817296749311e-09,   6.453228842089282e-11,  -1.279191903485025e-12,
   2.321171252365965e-14,  -3.918398130155320e-16,   6.179257333723686e-18,  -9.101181553135077e-20,   1.231237670989114e-21,  -1.498680871122862e-23,   1.459030443568220e-25,
  -8.028459788197992e-28,  -9.646622966451678e-30,  -3.516179006292317e-03,   1.290976587930213e-04,  -2.845457167508323e-06,   4.341558933501101e-08,  -3.748382576553186e-10,
  -2.730536031481469e-12,   1.956730735070670e-13,  -4.780272737523967e-15,   7.556339373525456e-17,  -6.630118416008910e-19,  -5.249370801432747e-21,   3.593909324854351e-22,
  -8.877132498945995e-24,   1.436074514710925e-25,  -3.345235593365050e-03,   1.228221767436292e-04,  -2.707119841905708e-06,   4.130301977015616e-08,  -3.565185002152872e-10,
  -2.600709641500110e-12,   1.862183313517168e-13,  -4.548464233437028e-15,   7.188079996589535e-17,  -6.301718799719904e-19,  -5.011486238976533e-21,   3.422427036542180e-22,
  -8.447868682878915e-24,   1.365968755619926e-25,  -3.020047479213984e-03,   1.108839272398979e-04,  -2.443959500871646e-06,   3.728500611796543e-08,  -3.217077763048047e-10,
  -2.352551411120371e-12,   1.682087852431710e-13,  -4.107250612636076e-15,   6.487897025508069e-17,  -5.679459531686115e-19,  -4.551918666679633e-21,   3.094895389235475e-22,
  -7.630328010990921e-24,   1.232719017517604e-25,  -2.572397696084992e-03,   9.444928600837089e-05,  -2.081697819858819e-06,   3.175533058138176e-08,  -2.738638451500550e-10,
  -2.008636901718105e-12,   1.433712247359414e-13,  -3.499415301742014e-15,   5.524739419360943e-17,  -4.827642202149436e-19,  -3.905635535161780e-21,   2.641464286844114e-22,
  -6.503084926051385e-24,   1.049513175760110e-25,  -2.046069320125913e-03,   7.512534503719407e-05,  -1.655767187057500e-06,   2.525562653521277e-08,  -2.177072370493907e-10,
  -1.601360231403028e-12,   1.141102113245152e-13,  -2.784158428095624e-15,   4.393195565138129e-17,  -3.832167669139233e-19,  -3.128476680711262e-21,   2.105105502075838e-22,
  -5.175416380829988e-24,   8.343970592784382e-26,  -1.492576125884891e-03,   5.480335064380464e-05,  -1.207855253113687e-06,   1.842219902162006e-08,  -1.587421461240825e-10,
  -1.170343846233995e-12,   8.328489990151257e-14,  -2.031437995072900e-15,   3.204091893083270e-17,  -2.790972622146409e-19,  -2.295082749272054e-21,   1.538051360862433e-22,
  -3.777087848397355e-24,   6.084543484383160e-26,  -9.661175798002598e-04,   3.547346146913273e-05,  -7.818222678842456e-07,   1.192376107148460e-08,  -1.027201509835170e-10,
  -7.584732719316807e-13,   5.392730949565988e-14,  -1.315099947443651e-15,   2.073660747137151e-17,  -1.804605223853394e-19,  -1.491087121886802e-21,   9.965830937336002e-23,
  -2.445566903485326e-24,   3.937442492536295e-26,  -5.182571802306017e-04,   1.902919571820933e-05,  -4.193949511968064e-07,   6.396132647354949e-09,  -5.509398174763174e-11,
  -4.071263958454982e-13,   2.893347407454371e-14,  -7.055142076764733e-16,   1.112299667770102e-17,  -9.675145402366623e-20,  -8.013893169290565e-22,   5.348836480459324e-23,
  -1.312082150198257e-24,   2.111904072876650e-26,  -1.928584536525480e-04,   7.081321541917375e-06,  -1.560689423954718e-07,   2.380164285816424e-09,  -2.050096236802338e-11,
  -1.515366966525608e-13,   1.076764064142211e-14,  -2.625488574050239e-16,   4.139084367177859e-18,  -3.599707832198497e-20,  -2.984171382359928e-22,   1.990823939052883e-23,
  -4.882894981258626e-25,   7.858654914178716e-27,  -2.178487709399806e-05,   7.998910412052377e-07,  -1.762921243771615e-08,   2.688578692578988e-10,  -2.315725032373071e-12,
  -1.711785546926011e-14,   1.216301410727786e-15,  -2.965707492446812e-17,   4.675402293303658e-19,  -4.066028499798856e-21,  -3.371209165972577e-23,   2.248857878615898e-24,
  -5.515659746944110e-26,   8.876905246989599e-28,  -8.480442770513155e-03,   2.376906595353540e-04,  -2.520432273650125e-06,  -2.945929315263744e-08,   1.611878930359895e-09,
  -2.606107058378495e-11,  -9.489612405452395e-15,   1.012578103659698e-14,  -2.313067980449773e-16,   1.441890682152972e-18,   5.576901629841639e-20,  -1.881144372418509e-21,
   2.168410802182288e-23,   2.371859727098113e-25,  -8.068025745752966e-03,   2.261266651338105e-04,  -2.397550102498502e-06,  -2.803411187893096e-08,   1.533471639994649e-09,
  -2.478712254184785e-11,  -9.220153475378073e-15,   9.634781816822944e-15,  -2.199810051803279e-16,   1.368686095534514e-18,   5.309854126934071e-20,  -1.789084389617560e-21,
   2.059356594274655e-23,   2.264215551578589e-25,  -7.283531652637588e-03,   2.041317136856892e-04,  -2.163931183573645e-06,  -2.532011219054340e-08,   1.384334011464203e-09,
  -2.236650044589610e-11,  -8.629439331622154e-15,   8.700222589204831e-15,  -1.984684538088608e-16,   1.230691993700112e-18,   4.800176727966137e-20,  -1.614201237538248e-21,
   1.853378375758256e-23,   2.056304473302134e-25,  -6.203709436787619e-03,   1.738603416097583e-04,  -1.842608910752858e-06,  -2.157851899351255e-08,   1.179067477075771e-09,
  -1.903978640115655e-11,  -7.664904074694194e-15,   7.412708268829509e-15,  -1.689179617788456e-16,   1.043180457585836e-18,   4.095335026449141e-20,  -1.373934581907061e-21,
   1.572695921381238e-23,   1.764032966330774e-25,  -4.934227960629858e-03,   1.382768458492646e-04,  -1.465158759725088e-06,  -1.717230294893244e-08,   9.377671852165519e-10,
  -1.513531392949797e-11,  -6.339385198539250e-15,   5.897627260306747e-15,  -1.342540755441055e-16,   8.258103497790892e-19,   3.262541950934700e-20,  -1.092044113420638e-21,
   1.246307668525103e-23,   1.412747672239903e-25,  -3.599346853574267e-03,   1.008646038254255e-04,  -1.068551637502439e-06,  -1.253214829766541e-08,   6.840538621802692e-10,
  -1.103579822012848e-11,  -4.767081135447334e-15,   4.303168476898865e-15,  -9.787616278169080e-17,   6.001080815683493e-19,   2.382986953319478e-20,  -7.961724406457230e-22,
   9.064559538750865e-24,   1.036233318710944e-25,  -2.329750911999247e-03,   6.528517228784620e-05,  -6.915433446684538e-07,  -8.114064114463001e-09,   4.427616255780174e-10,
  -7.141056994087908e-12,  -3.146614345053837e-15,   2.785764384364453e-15,  -6.332774440579019e-17,   3.874523483533940e-19,   1.543750970059371e-20,  -5.151521216542932e-22,
   5.855749959138418e-24,   6.731498433414568e-26,  -1.249743473050306e-03,   3.502037512593800e-05,  -3.709360151974306e-07,  -4.353264743443250e-09,   2.375079832061095e-10,
  -3.830086880735411e-12,  -1.704739529054046e-15,   1.494485796718139e-15,  -3.396399054488150e-17,   2.075703698450162e-19,   8.284727705786663e-21,  -2.762904530367366e-22,
   3.138027466277991e-24,   3.617641835945797e-26,  -4.650641393290993e-04,   1.303199718654027e-05,  -1.380320418017009e-07,  -1.620055021916892e-09,   8.838307156229300e-11,
  -1.425206792553463e-12,  -6.365575523617639e-16,   5.561555787370619e-16,  -1.263806261270820e-17,   7.720772571036565e-20,   3.083444690127517e-21,  -1.028086454341655e-22,
   1.167337529501112e-24,   1.347089211293690e-26,  -5.253262082496138e-05,   1.472064734089120e-06,  -1.559173237014680e-08,  -1.829993653524634e-10,   9.983553087894661e-12,
  -1.609868837561692e-13,  -7.194315658609732e-17,   6.282239676044824e-17,  -1.427551970163389e-18,   8.720588099435920e-21,   3.483075117437334e-22,  -1.161291837965663e-23,
   1.318525385334748e-25,   1.521797248999597e-27,  -1.313918019595803e-02,   2.001943547137431e-04,   2.880384530175675e-06,  -1.228005884460648e-07,   4.102429612932393e-10,
   4.711580752688213e-11,  -8.123970980677062e-13,  -9.673296910126287e-15,   4.883602304687174e-16,  -2.381881689704072e-18,  -1.866249349875952e-19,   3.594228401307757e-21,
   3.407295422756996e-23,  -2.094541980956025e-24,  -1.250000039771855e-02,   1.904459096245355e-04,   2.740353973158673e-06,  -1.168135384517614e-07,   3.899278718842627e-10,
   4.481802799507000e-11,  -7.724767320648173e-13,  -9.205293784030733e-15,   4.643571025124681e-16,  -2.260195281646373e-18,  -1.774801409730204e-19,   3.414581128579872e-21,
   3.245516095710964e-23,  -1.990139299226646e-24,  -1.128424301923099e-02,   1.719077075839325e-04,   2.473970552268098e-06,  -1.054311808486736e-07,   3.514331453733572e-10,
   4.044984890140221e-11,  -6.967086235380360e-13,  -8.314070453745129e-15,   4.188018213741656e-16,  -2.031114828372356e-18,  -1.601129548207268e-19,   3.074840024437231e-21,
   2.936163583936452e-23,  -1.792582416190691e-24,  -9.610964110679332e-03,   1.464006733210127e-04,   2.107268167943326e-06,  -8.977573627805327e-08,   2.987342256669253e-10,
   3.444233283833939e-11,  -5.927422948052232e-13,  -7.085421079812262e-15,   3.562968052035142e-16,  -1.720418234988688e-18,  -1.362620063570707e-19,   2.611034992088257e-21,
   2.507239052925424e-23,  -1.522660404687896e-24,  -7.643992318739486e-03,   1.164262555390278e-04,   1.676111561798958e-06,  -7.138561252302790e-08,   2.371427402197505e-10,
   2.738611163838293e-11,  -4.709266063404943e-13,  -5.638556410463766e-15,   2.830662518493966e-16,  -1.360986335313392e-18,  -1.082907041609734e-19,   2.070608475870711e-21,
   1.999071801517098e-23,  -1.207864617837050e-24,  -5.575875546742788e-03,   8.491944809226593e-05,   1.222699572856305e-06,  -5.206210086363913e-08,   1.727167734527244e-10,
   1.997239412877663e-11,  -3.432183743167887e-13,  -4.114913035238264e-15,   2.062986273942293e-16,  -9.884632332062422e-19,  -7.894271384241792e-20,   1.506843286052802e-21,
   1.461115162308481e-23,  -8.792108898840371e-25,  -3.609035534173295e-03,   5.496181517347996e-05,   7.914321734718306e-07,  -3.369346690425461e-08,   1.116787962518945e-10,
   1.292548013259450e-11,  -2.220242459706600e-13,  -2.664222617748888e-15,   1.334504945928743e-16,  -6.379538611356950e-19,  -5.107520988132366e-20,   9.737999705766176e-22,
   9.469561617170866e-24,  -5.682820444710203e-25,  -1.935969845711090e-03,   2.948194145209212e-05,   4.245504159215716e-07,  -1.807279654141274e-08,   5.987577002700135e-11,
   6.933020883357259e-12,  -1.190639656628344e-13,  -1.429372777732253e-15,   7.156439783587081e-17,  -3.417072228069993e-19,  -2.739208417739246e-20,   5.219508686433922e-22,
   5.083089049445002e-24,  -3.046206562990856e-25,  -7.204256830953860e-04,   1.097090250240493e-05,   1.579874907574325e-07,  -6.725216839099692e-09,   2.227730583017206e-11,
   2.579895437971660e-12,  -4.430232963249297e-14,  -5.319362726681835e-16,   2.662822138396698e-17,  -1.270928045122025e-19,  -1.019256436306634e-20,   1.941776408394030e-22,
   1.891991791035918e-24,  -1.133290684470799e-25,  -8.137765740202483e-05,   1.239246401386058e-06,   1.784592846008033e-08,  -7.596626158304523e-10,   2.516321451126511e-12,
   2.914179879764255e-13,  -5.004209910218153e-15,  -6.008683533049321e-17,   3.007813758032716e-18,  -1.435494192431559e-20,  -1.151315487672031e-21,   2.193289776174278e-23,
   2.137229961444223e-25,  -1.280088737022712e-26,  -1.507894559549767e-02,  -1.447048063109378e-05,   6.967288372738298e-06,   4.366985811343874e-09,  -3.231833988438919e-09,
  -3.028540627736222e-13,   1.529114768135033e-12,  -9.432225598815098e-16,  -7.387099307439542e-16,   9.571775720147729e-19,   3.593801896587563e-19,  -7.932042778023372e-22,
  -1.783487560639666e-22,   5.348033036510582e-25,  -1.434529441957086e-02,  -1.376624236685074e-05,   6.627822337832985e-06,   4.154482346221955e-09,  -3.073956954192781e-09,
  -2.887072414281405e-13,   1.454125926292471e-12,  -8.963282832265920e-16,  -7.023008716248750e-16,   9.093349091655596e-19,   3.415525678721441e-19,  -7.533928074254902e-22,
  -1.694311922279647e-22,   5.080227456475330e-25,  -1.294989082530768e-02,  -1.242685983313529e-05,   5.982353373652000e-06,   3.750313822569575e-09,  -2.773933572853904e-09,
  -2.615601086656773e-13,   1.311738047134980e-12,  -8.075447614877118e-16,  -6.332416343078998e-16,   8.188579117854814e-19,   3.077842122143294e-19,  -6.781691777749293e-22,
  -1.525681748391826e-22,   4.573966587348076e-25,  -1.102944513983476e-02,  -1.058366474825522e-05,   5.094394729893696e-06,   3.194095717805706e-09,  -2.361522721600871e-09,
  -2.237341363421035e-13,   1.116240925180141e-12,  -6.861469248657631e-16,  -5.385670331887567e-16,   6.953425199273916e-19,   2.615803452982216e-19,  -5.756042196007987e-22,
  -1.295499844308888e-22,   3.883222356453222e-25,  -8.772031631831000e-03,  -8.417247364334390e-06,   4.051110163100747e-06,   2.540313810163225e-09,  -1.877382535376917e-09,
  -1.786845807923586e-13,   8.870308599914761e-13,  -5.444478595326579e-16,  -4.277470076487358e-16,   5.514228274139232e-19,   2.076106750030072e-19,  -4.562579887885944e-22,
  -1.027323509034026e-22,   3.078856365077170e-25,  -6.398638461982098e-03,  -6.139703457013637e-06,   2.954670300571924e-06,   1.852972657200269e-09,  -1.368958943346830e-09,
  -1.307747792742562e-13,   6.465937050733052e-13,  -3.963982528386167e-16,  -3.116674884851268e-16,   4.012876513505118e-19,   1.511855368191378e-19,  -3.319098040031665e-22,
  -7.475934530749587e-23,   2.240209403406511e-25,  -4.141541904446037e-03,  -3.973884345075330e-06,   1.912268563114991e-06,   1.199332732448017e-09,  -8.858617994557741e-10,
  -8.483065235161193e-14,   4.183225373173701e-13,  -2.562533107656249e-16,  -2.015797444834327e-16,   2.593333111011174e-19,   9.774720775709566e-20,  -2.144447977554718e-22,
  -4.831251325867137e-23,   1.447582975000113e-25,  -2.221609083639220e-03,  -2.131657298679030e-06,   1.025738567149163e-06,   6.433440757460701e-10,  -4.751390765537386e-10,
  -4.555619067830517e-14,   2.243452393528486e-13,  -1.373723610179838e-16,  -1.080907649951849e-16,   1.390012381259341e-19,   5.240385242997132e-20,  -1.149266559263725e-22,
  -2.589498850177047e-23,   7.758527478570014e-26,  -8.267183887004026e-04,  -7.932428208397503e-07,   3.816984979186209e-07,   2.394046476129991e-10,  -1.768043804520461e-10,
  -1.695927926104136e-14,   8.347799542473454e-14,  -5.110852478705147e-17,  -4.021809572136043e-17,   5.171165618513672e-20,   1.949697744125198e-20,  -4.275346795192132e-23,
  -9.633498154527121e-24,   2.886293794948814e-26,  -9.338421931954545e-05,  -8.960285672073102e-08,   4.311569225931563e-08,   2.704259495534359e-11,  -1.997128959960727e-11,
  -1.915800403071462e-15,   9.429363627339385e-15,  -5.772899676987665e-18,  -4.542849467942825e-18,   5.840973967993391e-21,   2.202264892586453e-21,  -4.829088049208076e-24,
  -1.088129555992044e-24,   3.260138140614890e-27,  -1.282283307024366e-02,  -2.425478173141345e-04,   2.392274089970863e-06,   1.487208998344001e-07,   9.476750242017091e-10,
  -5.865523082229238e-11,  -1.281813167963501e-12,   1.102141140656967e-14,   7.893716501046549e-16,   5.431783376698260e-18,  -3.239862102166678e-19,  -7.339879317887439e-21,
   6.093980297638249e-23,   4.605220001925552e-24,  -1.219905487136084e-02,  -2.307369806021272e-04,   2.276080742861583e-06,   1.414696493223799e-07,   9.010106817833768e-10,
  -5.579531310895180e-11,  -1.218810725820075e-12,   1.049105811120376e-14,   7.505438954073958e-16,   5.155679428566514e-18,  -3.081068097056835e-19,  -6.972261198553068e-21,
   5.806848942645922e-23,   4.375685162292394e-24,  -1.101258723090672e-02,  -2.082768139534882e-04,   2.054999580813192e-06,   1.276840331035631e-07,   8.124815468846810e-10,
  -5.035822914135735e-11,  -1.099239528795126e-12,   9.479918947772619e-15,   6.768651127226716e-16,   4.635359281137234e-18,  -2.779511645431351e-19,  -6.277337703541846e-21,
   5.256865707542085e-23,   3.941338993286495e-24,  -9.379610859279094e-03,  -1.773734756092926e-04,   1.750575209070672e-06,   1.087234887013656e-07,   6.910805381514631e-10,
  -4.288016433421878e-11,  -9.351802662878139e-13,   8.083671403072284e-15,   5.757959921126601e-16,   3.928601203288554e-18,  -2.365402868902517e-19,  -5.329231284022067e-21,
   4.492512031025826e-23,   3.347880080765321e-24,  -7.460003205241246e-03,  -1.410576215835393e-04,   1.392535680890529e-06,   8.645140689806556e-08,   5.489327455233806e-10,
  -3.409606504720555e-11,  -7.429699687518191e-13,   6.436571013731451e-15,   4.574134848570088e-16,   3.109622158969733e-18,  -1.879792766456143e-19,  -4.225238942248496e-21,
   3.584716923744520e-23,   2.655748107724825e-24,  -5.441674673216345e-03,  -1.028851771820126e-04,   1.015914918239118e-06,   6.304935126097514e-08,   3.999984512348321e-10,
  -2.486635064978214e-11,  -5.414762281233016e-13,   4.699404512582450e-15,   3.333406623280892e-16,   2.259526737622038e-18,  -1.370318139156243e-19,  -3.074267294909107e-21,
   2.621660747020762e-23,   1.933138074739928e-24,  -3.522176726564071e-03,  -6.658964929430178e-05,   6.576182299390120e-07,   4.080402630068323e-08,   2.587238685485710e-10,
  -1.609288516430112e-11,  -3.502702190833904e-13,   3.043557557661424e-15,   2.156219737725721e-16,   1.458751483423258e-18,  -8.865703552214620e-20,  -1.986508545977203e-21,
   1.699793299789447e-23,   1.249494710078634e-24,  -1.889377857193441e-03,  -3.571920190062928e-05,   3.527775971794024e-07,   2.188677879863529e-08,   1.387362251328990e-10,
  -8.632020356476884e-12,  -1.878365249202770e-13,   1.633136811834937e-15,   1.156272035574068e-16,   7.814763447992905e-19,  -4.754719066204553e-20,  -1.064689843284803e-21,
   9.126053662711451e-24,   6.697768695932188e-25,  -7.030877090783884e-04,  -1.329192937728366e-05,   1.312799673947305e-07,   8.144463704835253e-09,   5.162105141900153e-11,
  -3.212129146548641e-12,  -6.989163234269487e-14,   6.077985221063139e-16,   4.302310377651598e-17,   2.906744918918980e-19,  -1.769221090962348e-20,  -3.960802920956899e-22,
   3.397077725671032e-24,   2.491794461815702e-25,  -7.941920153358846e-05,  -1.501423940204822e-06,   1.482912568680673e-08,   9.199768718017669e-10,   5.830883075965178e-12,
  -3.628335175060076e-13,  -7.894669735272737e-15,   6.865671334900721e-17,   4.859705790105243e-18,   3.283153995450912e-20,  -1.998447811928614e-21,  -4.473820176898806e-23,
   3.837447049081100e-25,   2.814563099719411e-26,  -7.184865762411343e-03,  -2.560269510925942e-04,  -4.255625985629396e-06,  -3.980617604875584e-09,   1.812593987189288e-09,
   5.129784428671556e-11,   5.612860485632164e-13,  -8.659353955140977e-15,  -5.031926639260288e-16,  -9.752405902227536e-18,  -2.944558199042588e-20,   3.824755367198377e-21,
   1.184813822713594e-22,   1.404619823676608e-24,  -6.835517564154553e-03,  -2.435740414868023e-04,  -4.048306996029299e-06,  -3.771765033356790e-09,   1.724677517472429e-09,
   4.879724498403120e-11,   5.335658202926468e-13,  -8.248554634381245e-15,  -4.787547074434952e-16,  -9.271760934493994e-18,  -2.778141368690608e-20,   3.641927959909631e-21,
   1.126688470301961e-22,   1.332824230884932e-24,  -6.170966560706764e-03,  -2.198870655573181e-04,  -3.654094446138114e-06,  -3.380697906191631e-09,   1.557349112176698e-09,
   4.404303073572054e-11,   4.810091081631619e-13,  -7.462933720121845e-15,  -4.322552797371388e-16,  -8.360067048076086e-18,  -2.471037919428038e-20,   3.292853704703952e-21,
   1.016326255766687e-22,   1.197672908101278e-24,  -5.256191231244525e-03,  -1.872844816352617e-04,  -3.111762648037442e-06,  -2.854447875403687e-09,   1.326845078361890e-09,
   3.750370672812387e-11,   4.090012333182638e-13,  -6.373418686656066e-15,  -3.682243431442121e-16,  -7.110173986241004e-18,  -2.066636838744618e-20,   2.809853818658978e-21,
   8.648137343005619e-23,   1.014391039882830e-24,  -4.180682595101564e-03,  -1.489575212061138e-04,  -2.474536574757184e-06,  -2.251001258031104e-09,   1.055623300044937e-09,
   2.982171537397030e-11,   3.247690135141047e-13,  -5.082249762269090e-15,  -2.929141797965048e-16,  -5.647108660720701e-18,  -1.614368654730271e-20,   2.238854372289120e-21,
   6.871953367850502e-23,   8.023965746119035e-25,  -3.049708666204110e-03,  -1.086578702714294e-04,  -1.804818870474178e-06,  -1.630667362083493e-09,   7.702129287462941e-10,
   2.174948124975019e-11,   2.365919374540076e-13,  -3.714980671702726e-15,  -2.136942191566705e-16,  -4.114609026988797e-18,  -1.160377493804444e-20,   1.635502627384910e-21,
   5.009017738377448e-23,   5.827246752113862e-25,  -1.974006371415465e-03,  -7.033041592077551e-05,  -1.168090855039602e-06,  -1.050624940153036e-09,   4.986098592317407e-10,
   1.407590555746406e-11,   1.530039391517426e-13,  -2.407870276494307e-15,  -1.383279479688134e-16,  -2.661227905968811e-18,  -7.437039802851170e-21,   1.059609658084338e-21,
   3.240544979266239e-23,   3.760703377021631e-25,  -1.058917679617904e-03,  -3.772703057002230e-05,  -6.265648586092575e-07,  -5.622464086520691e-10,   2.674885734178804e-10,
   7.550187663293730e-12,   8.203838710318444e-14,  -1.292550209859393e-15,  -7.420571375037667e-17,  -1.426995610230093e-18,  -3.969126557488039e-21,   5.686785316072131e-22,
   1.737865018720574e-23,   2.014288156827547e-25,  -3.940532939792297e-04,  -1.403925043437296e-05,  -2.331580203084559e-07,  -2.090541357261508e-10,   9.954253309960342e-11,
   2.809566282045302e-12,   3.052393636944258e-14,  -4.811104338055423e-16,  -2.761435391015104e-17,  -5.309518407403903e-19,  -1.474391632417711e-21,   2.116565296830072e-22,
   6.466488441290087e-24,   7.491762753366448e-26,  -4.451140494978056e-05,  -1.585842413036988e-06,  -2.633694280162989e-08,  -2.361118807611409e-11,   1.124415244012719e-11,
   3.173612081614730e-13,   3.447830252500212e-15,  -5.434726704036837e-17,  -3.119262931439469e-18,  -5.997384679116382e-20,  -1.664968864705113e-22,   2.390889173489649e-23,
   7.304297425936425e-25,   8.461820183332990e-27,  -1.635332531826553e-03,  -7.692845740218864e-05,  -2.315984898899790e-06,  -5.484658678045761e-08,  -1.073810143061164e-09,
  -1.704094472889950e-11,  -1.889347291218487e-13,  -8.752260732769130e-17,   6.989732304360510e-17,   2.485848533687282e-18,   5.986255049704132e-20,   1.119274630710385e-21,
   1.536826172528376e-23,   8.692203305816646e-26,  -1.555858554928559e-03,  -7.319153336342169e-05,  -2.203526381013803e-06,  -5.218389710014828e-08,  -1.021663694016276e-09,
  -1.621210959507373e-11,  -1.796862360399748e-13,  -8.059232674673235e-17,   6.657782644410740e-17,   2.366768086686243e-18,   5.698087607456570e-20,   1.065028669517484e-21,
   1.461222626180833e-23,   8.228018305134872e-26,  -1.404661975337063e-03,  -6.608148988259062e-05,  -1.989539652772648e-06,  -4.711710115868074e-08,  -9.224410633230774e-10,
  -1.463555207315664e-11,  -1.621182999769135e-13,  -6.849391573060193e-17,   6.023117375607585e-17,   2.139519427600417e-18,   5.148736449279149e-20,   9.617657479050744e-22,
   1.317758445217562e-23,   7.361834927410246e-26,  -1.196503259562522e-03,  -5.629149244485583e-05,  -1.694861094628959e-06,  -4.013926215852064e-08,  -7.858065711806852e-10,
  -1.246557144563191e-11,  -1.379842381970855e-13,  -5.394591023550481e-17,   5.143250142797272e-17,   1.825295113589340e-18,   4.390248265109504e-20,   8.194808419913527e-22,
   1.120964488495506e-23,   6.202184732926209e-26,  -9.517290370005620e-04,  -4.477777009413958e-05,  -1.348254368151176e-06,  -3.193126600489382e-08,  -6.250992710365731e-10,
  -9.914564981049807e-12,  -1.096714820344983e-13,  -3.951136544600104e-17,   4.100888229868027e-17,   1.454074421148150e-18,   3.495593735426240e-20,   6.520198387392909e-22,
   8.904702896526955e-24,   4.880252363049579e-26,  -6.942938618896667e-04,  -3.266696539439939e-05,  -9.836320803457467e-07,  -2.329615516385664e-08,  -4.560435086076478e-10,
  -7.232242814904548e-12,  -7.995639740347956e-14,  -2.682517776569507e-17,   2.997402002154748e-17,   1.062044927236045e-18,   2.552105933824411e-20,   4.757608903715196e-22,
   6.489132334613119e-24,   3.528921038509142e-26,  -4.494133589622989e-04,  -2.114570799515239e-05,  -6.367305890179989e-07,  -1.508037273734307e-08,  -2.952071967883957e-10,
  -4.681179995039347e-12,  -5.173410012471225e-14,  -1.650850198859623e-17,   1.942674553210286e-17,   6.880071267764201e-19,   1.652840027467994e-20,   3.080035301690960e-22,
   4.197419933444806e-24,   2.270870311087675e-26,  -2.410826874270643e-04,  -1.134351934167465e-05,  -3.415751160752873e-07,  -8.089935296517387e-09,  -1.583639156839335e-10,
  -2.511105404907992e-12,  -2.774629277987800e-14,  -8.620096315235970e-18,   1.042806110730661e-17,   3.692251560889446e-19,   8.868876720265978e-21,   1.652375090468424e-22,
   2.250839635162602e-24,   1.214493012033555e-26,  -8.971416379596337e-05,  -4.221285570775490e-06,  -1.271115036281713e-07,  -3.010540931526689e-09,  -5.893244205534303e-11,
  -9.344504878643977e-13,  -1.032447383730441e-14,  -3.177265472846759e-18,   3.881478515159642e-18,   1.374194842899286e-19,   3.300688777200393e-21,   6.149149613441521e-23,
   8.374994468517191e-25,   4.514715883887253e-27,  -1.013392549768186e-05,  -4.768279812511566e-07,  -1.435827039283135e-08,  -3.400650060676085e-10,  -6.656894004645327e-12,
  -1.055534448216804e-13,  -1.166217459714534e-15,  -3.583499774268452e-19,   4.384595458847705e-19,   1.552297122455401e-20,   3.728445254179156e-22,   6.945980607882438e-24,
   9.460029483410472e-26,   5.098872330505935e-28,  -3.556576452074454e-04,   1.387534156810197e-05,  -3.583569080308898e-07,   7.631657947651212e-09,  -1.445396880563486e-10,
   2.512938477242742e-12,  -4.087363896688325e-14,   6.237292867910614e-16,  -9.024769962382270e-18,   1.204971089622917e-19,  -1.522014295285163e-21,   1.743122594785291e-23,
  -9.354221191825033e-26,   1.984963358294612e-27,  -3.383690320534134e-04,   1.320112248329540e-05,  -3.409521374347194e-07,   7.261199883456210e-09,  -1.375274863435701e-10,
   2.391098341773027e-12,  -3.889305592301124e-14,   5.935200503393587e-16,  -8.587839895043604e-18,   1.146646355549755e-19,  -1.448166449665467e-21,   1.658787851285894e-23,
  -8.898195460946601e-26,   1.881800075304545e-27,  -3.054797910145744e-04,   1.191840442970352e-05,  -3.078358034771202e-07,   6.556242791575341e-09,  -1.241820705200840e-10,
   2.159186222114511e-12,  -3.512270726836711e-14,   5.360062132325088e-16,  -7.755921638198137e-18,   1.035590197331317e-19,  -1.307624917363952e-21,   1.498188079100107e-23,
  -8.031209670621686e-26,   1.688269379860183e-27,  -2.602032092239176e-04,   1.015235703237506e-05,  -2.622347304653156e-07,   5.585363039049800e-09,  -1.057992985724943e-10,
   1.839679316118662e-12,  -2.992734015907405e-14,   4.567434594856771e-16,  -6.609278844938818e-18,   8.825096447216387e-20,  -1.114041509321167e-21,   1.276783757360562e-23,
  -6.838726728909770e-26,   1.427118414912991e-27,  -2.069667280266831e-04,   8.075563278883919e-06,  -2.086016860428377e-07,   4.443278860491099e-09,  -8.417083937330084e-11,
   1.463687287257308e-12,  -2.381231263628684e-14,   3.634356343392612e-16,  -5.259286383636996e-18,   7.022678478036227e-20,  -8.862875742819215e-22,   1.016057756957945e-23,
  -5.437907671644128e-26,   1.126712617229143e-27,  -1.509806312441253e-04,   5.891258427334185e-06,  -1.521845326062973e-07,   3.241724131537738e-09,  -6.141234107920638e-11,
   1.067982874993907e-12,  -1.737558897248146e-14,   2.652057596053136e-16,  -3.837924183650696e-18,   5.124846966500481e-20,  -6.466423268350590e-22,   7.414979187898076e-24,
  -3.965949490827072e-26,   8.169844029849674e-28,  -9.772771434132118e-05,   3.813416057532918e-06,  -9.851177922115680e-08,   2.098489370604727e-09,  -3.975580818588940e-11,
   6.913910487788841e-13,  -1.124898954335523e-14,   1.716992828376746e-16,  -2.484798863932643e-18,   3.318038392693531e-20,  -4.186065846228422e-22,   4.800858397493686e-24,
  -2.566695048269440e-26,   5.267104238069601e-28,  -5.242454030065780e-05,   2.045672074321004e-06,  -5.284646116705137e-08,   1.125748129200523e-09,  -2.132761761652310e-11,
   3.709137841052740e-13,  -6.034901509218949e-15,   9.211515470973081e-17,  -1.333087405770823e-18,   1.780129924528460e-20,  -2.245671700220564e-22,   2.575688885263743e-24,
  -1.376751565591213e-26,   2.819641396209085e-28,  -1.950870859418188e-05,   7.612575719750986e-07,  -1.966588885244472e-08,   4.189297863749817e-10,  -7.936790054878059e-12,
   1.380314711711801e-13,  -2.245835406521338e-15,   3.428000587609344e-17,  -4.961009865040360e-19,   6.624668924968098e-21,  -8.356959032375944e-23,   9.585335709607466e-25,
  -5.123150270572976e-27,   1.048518097981742e-28,  -2.203662294908365e-06,   8.599009273849673e-08,  -2.221420110643548e-09,   4.732152479095660e-11,  -8.965257859034627e-13,
   1.559180597415066e-14,  -2.536860818743134e-16,   3.872219179991020e-18,  -5.603887378078402e-20,   7.483136160303480e-22,  -9.439871452335641e-24,   1.082747089837435e-25,
  -5.786975591712618e-28,   1.184248788806551e-29,  -3.042163675575221e-03,   1.083132940826861e-04,  -2.361543344686632e-06,   3.719556535868500e-08,  -3.920137311435045e-10,
   6.098223601619056e-13,   9.194738691188897e-14,  -2.760213790904404e-15,   5.076737330631997e-17,  -6.576130818250526e-19,   3.567771836164352e-21,   8.907066381115104e-23,
  -2.889780707972394e-24,   8.516893425843125e-26,  -2.894262142605668e-03,   1.030482175416323e-04,  -2.246746924125719e-06,   3.538653677877011e-08,  -3.729048881486814e-10,
   5.784338077883174e-13,   8.751732341237522e-14,  -2.626658893045162e-15,   4.830275801074018e-17,  -6.254790294110510e-19,   3.388529316561829e-21,   8.493549704439757e-23,
  -2.752326215893430e-24,   8.100848636101799e-26,  -2.612908134285824e-03,   9.303209834949417e-05,  -2.028362765551194e-06,   3.194548769771256e-08,  -3.365744143148383e-10,
   5.194303900154480e-13,   7.907365966584741e-14,  -2.372336505700938e-15,   4.361284944005173e-17,  -5.644159469590704e-19,   3.049900051968290e-21,   7.698971021280704e-23,
  -2.489611722352049e-24,   7.310213432650003e-26,  -2.225602156167954e-03,   7.924347832930821e-05,  -1.727727719766688e-06,   2.720915058136761e-08,  -2.866022235415458e-10,
   4.395792496105538e-13,   6.741863292947042e-14,  -2.021737691247629e-15,   3.715400906275215e-17,  -4.804856642628378e-19,   2.588304631568253e-21,   6.589776353026016e-23,
  -2.125570539842635e-24,   6.223405576431269e-26,  -1.770226525591250e-03,   6.303067335271553e-05,  -1.374240368577021e-06,   2.164107701090274e-08,  -2.278974665743802e-10,
   3.474313047709934e-13,   5.367513768097910e-14,  -1.608882978710762e-15,   2.955647466347725e-17,  -3.819670209621158e-19,   2.051360666825823e-21,   5.266162112654386e-23,
  -1.694515876407717e-24,   4.947560719170121e-26,  -1.291350841262797e-03,   4.598043500127729e-05,  -1.002496834054889e-06,   1.578629546986024e-08,  -1.662099697016546e-10,
   2.521483691858220e-13,   3.918502507961682e-14,  -1.174128433208295e-15,   2.156357520883708e-17,  -2.785163760618761e-19,   1.492105379318487e-21,   3.856091425695391e-23,
  -1.238386680774444e-24,   3.607705125444674e-26,  -8.358671429637752e-04,   2.976253101592527e-05,  -6.489022069428846e-07,   1.021795396951139e-08,  -1.075685709488733e-10,
   1.626560779348701e-13,   2.537652112586674e-14,  -7.601943968536172e-16,   1.395881469814738e-17,  -1.802260574225640e-19,   9.639590089673868e-22,   2.502181657368888e-23,
  -8.025536747873643e-25,   2.334577161327843e-26,  -4.483863110210148e-04,   1.596566065075471e-05,  -3.480935728330285e-07,   5.481182480934329e-09,  -5.769886464716855e-11,
   8.710114909927314e-14,   1.361631455971897e-14,  -4.078489353495837e-16,   7.488269517780041e-18,  -9.666467771593925e-20,   5.165882814867641e-22,   1.343961016678862e-23,
  -4.307829352517223e-25,   1.252171756337545e-26,  -1.668574531074229e-04,   5.941291143952574e-06,  -1.295358108105712e-07,   2.039697973921137e-09,  -2.147083663119318e-11,
   3.239304517531187e-14,   5.067478980132504e-15,  -1.517795744075169e-16,   2.786640441816133e-18,  -3.596983804404827e-20,   1.921712104738741e-22,   5.003479745222953e-24,
  -1.603413220532026e-25,   4.659469732793707e-27,  -1.884785926168633e-05,   6.711156431991162e-07,  -1.463208985846862e-08,   2.303997591618083e-10,  -2.425289307721617e-12,
   3.658693848257452e-15,   5.724197143111878e-16,  -1.714482436613885e-17,   3.147736281154054e-19,  -4.063042049997975e-21,   2.170606091057491e-23,   5.652220014067872e-25,
  -1.811243116954263e-26,   5.263197106825123e-28,  -7.571678807434116e-03,   2.165123131052872e-04,  -2.736215047963378e-06,  -7.769290520456818e-09,   1.107270331335476e-09,
  -2.366326131181236e-11,   1.804371978556281e-13,   3.842548436382618e-15,  -1.562249033288589e-16,   2.344798708575115e-18,  -2.435753547748905e-21,  -7.723225042110462e-22,
   2.122271128751475e-23,  -1.545999186777661e-25,  -7.203470909179163e-03,   2.059803763343691e-04,  -2.602926935592418e-06,  -7.398417317894880e-09,   1.053492304837588e-09,
  -2.250986168504789e-11,   1.715306090825732e-13,   3.658146484132942e-15,  -1.486289918811869e-16,   2.229480668495752e-18,  -2.275713649503246e-21,  -7.351114241830432e-22,
   2.018341952274091e-23,  -1.468184908053039e-25,  -6.503064914168210e-03,   1.859477284118903e-04,  -2.349478218677064e-06,  -6.690117208688952e-09,   9.511678367524186e-10,
  -2.031694291666014e-11,   1.546421313134458e-13,   3.306374774572759e-15,  -1.341794460305550e-16,   2.010646584854175e-18,  -1.988212530623369e-21,  -6.641866331521785e-22,
   1.820938061017177e-23,  -1.321231536191706e-25,  -5.538974879781298e-03,   1.583757099006209e-04,  -2.000791778044579e-06,  -5.709686486297960e-09,   8.102671914576566e-10,
  -1.730054698132987e-11,   1.314996328024921e-13,   2.820229879295634e-15,  -1.142889778628903e-16,   1.710444445661487e-18,  -1.625275272934084e-21,  -5.662865017403476e-22,
   1.549783835573145e-23,  -1.121024479111340e-25,  -4.405538209288179e-03,   1.259635632384983e-04,  -1.591083532577309e-06,  -4.550110277003002e-09,   6.445487940170859e-10,
  -1.375696664411077e-11,   1.044237522512596e-13,   2.246237873317362e-15,  -9.090344084037318e-17,   1.358799177519562e-18,  -1.240077213326244e-21,  -4.508441432690542e-22,
   1.231723645398857e-23,  -8.882787634375211e-26,  -3.213696979234734e-03,   9.188407403328203e-05,  -1.160474738898728e-06,  -3.324323998384294e-09,   4.702279046455099e-10,
  -1.003327197991545e-11,   7.607548176911584e-14,   1.640383702259052e-15,  -6.631184465717047e-17,   9.902367107060692e-19,  -8.736881017754886e-22,  -3.291320943407188e-22,
   8.979540659254274e-24,  -6.459979594332480e-26,  -2.080135767608451e-03,   5.947301616362156e-05,  -7.510704119186762e-07,  -2.153950957179864e-09,   3.043868953249705e-10,
  -6.493404309403353e-12,   4.919949963079770e-14,   1.062554941425753e-15,  -4.292209436970400e-17,   6.405403161575545e-19,  -5.522985978353510e-22,  -2.131472515482535e-22,
   5.809851634470986e-24,  -4.172916595924179e-26,  -1.115844211660481e-03,   3.190275831893023e-05,  -4.028756982956181e-07,  -1.156049399303151e-09,   1.632877637060953e-10,
  -3.483013015741420e-12,   2.638043992114857e-14,   5.701997954994223e-16,  -2.302471698123820e-17,   3.434905658510798e-19,  -2.926289196005635e-22,  -1.143683504723126e-22,
   3.115920881553658e-24,  -2.236143018004016e-26,  -4.152366830067603e-04,   1.187186978162413e-05,  -1.499186794161315e-07,  -4.302769785539771e-10,   6.076469046833524e-11,
  -1.296095700140419e-12,   9.815396431660779e-15,   2.122150535836722e-16,  -8.568148156512804e-18,   1.278076899805205e-19,  -1.084239689745716e-22,  -4.256354014257268e-23,
   1.159436683677543e-24,  -8.318293431313939e-27,  -4.690422407002293e-05,   1.341019729810669e-06,  -1.693443865218735e-08,  -4.860455577135345e-11,   6.863859821965931e-12,
  -1.464035803641900e-13,   1.108698755310594e-15,   2.397184558366394e-17,  -9.678393872072007e-19,   1.443661241021112e-20,  -1.223888403284228e-23,  -4.807953842384542e-24,
   1.309659128409955e-25,  -9.395620785676467e-28,  -1.230140659549939e-02,   2.175189891278698e-04,   1.473647404114225e-06,  -1.098193141145129e-07,   1.144273079994913e-09,
   2.601119487843845e-11,  -8.857567455295039e-13,   3.465081216629867e-15,   3.081557614713057e-16,  -6.545345424240377e-18,  -2.514446685790380e-20,   3.166405708894687e-21,
  -3.815309821995598e-23,  -5.627375119235582e-25,  -1.170301801073168e-02,   2.069290138834133e-04,   1.402171859400801e-06,  -1.044699267968900e-07,   1.088221239445070e-09,
   2.474813230728516e-11,  -8.424169214163479e-13,   3.289568697980927e-15,   2.931327211942460e-16,  -6.221812781638801e-18,  -2.399544353999458e-20,   3.011074004442007e-21,
  -3.622088147763325e-23,  -5.362328762190997e-25,  -1.056483320558999e-02,   1.867896599033622e-04,   1.266134627188299e-06,  -9.429793234862158e-08,   9.817646095436519e-10,
   2.234477256812638e-11,  -7.600838989026919e-13,   2.958564566920481e-15,   2.645709816429292e-16,  -5.608519373339893e-18,  -2.177958215919191e-20,   2.716147950369574e-21,
  -3.257680298086418e-23,  -4.854608479067864e-25,  -8.998290972476012e-03,   1.590779253688596e-04,   1.078735249371674e-06,  -8.030348168375443e-08,   8.355502975423742e-10,
   1.903514690727926e-11,  -6.469642556024543e-13,   2.508476529265944e-15,   2.252859747844263e-16,  -4.768466598590748e-18,  -1.867118565056239e-20,   2.311252079198481e-21,
  -2.762153955340280e-23,  -4.148912355486439e-25,  -7.156754138520252e-03,   1.265105841341473e-04,   8.582314257452243e-07,  -6.385973991678038e-08,   6.640581083223363e-10,
   1.514232491115271e-11,  -5.142398467025318e-13,   1.986317386111646e-15,   1.791378823727340e-16,  -3.786077135712718e-18,  -1.494327174881285e-20,   1.836582856510150e-21,
  -2.187249045900406e-23,  -3.310680732371913e-25,  -5.220488770441852e-03,   9.227635106397061e-05,   6.261911686523590e-07,  -4.657696776294511e-08,   4.841068172444303e-10,
   1.104719775830289e-11,  -3.749235191195985e-13,   1.443757596275614e-15,   1.306469869379844e-16,  -2.757931277684797e-18,  -1.095500757643755e-20,   1.338715506479141e-21,
  -1.589844031099715e-23,  -2.421325316833992e-25,  -3.379019757429799e-03,   5.972403653979677e-05,   4.053754790782149e-07,  -3.014512368744095e-08,   3.132196125975556e-10,
   7.151122807679193e-12,  -2.425928968762577e-13,   9.322828047199626e-16,   8.455200291739145e-17,  -1.783468754214147e-18,  -7.114083638250742e-21,   8.660795621616645e-22,
  -1.026633733492751e-23,  -1.569937073065731e-25,  -1.812587251064235e-03,   3.203661687951846e-05,   2.174713754863159e-07,  -1.616992286067292e-08,   1.679843754853863e-10,
   3.836226578233019e-12,  -1.301104617214309e-13,   4.994915537002611e-16,   4.535276462618652e-17,  -9.562456275920518e-19,  -3.822585899338833e-21,   4.644703282086408e-22,
  -5.500473778002329e-24,  -8.428961027815096e-26,  -6.745121605017400e-04,   1.192157918997267e-05,   8.092927400771005e-08,  -6.017176974877466e-09,   6.250705445627458e-11,
   1.427587395361219e-12,  -4.841470655169977e-14,   1.857955122042993e-16,   1.687659246351641e-17,  -3.557863029739254e-19,  -1.423317608615319e-21,   1.728268546026623e-22,
  -2.046014104435809e-24,  -3.137604646876744e-26,  -7.619137698749653e-05,   1.346632947645735e-06,   9.141631173551580e-09,  -6.796852847179668e-10,   7.060577072356522e-12,
   1.612575094745417e-13,  -5.468764880312728e-15,   2.098563367791866e-17,   1.906335063624965e-18,  -4.018777665479096e-20,  -1.607896542032532e-22,   1.952186455658902e-23,
  -2.310977532780388e-25,  -3.544340220055877e-27,  -1.502624460718105e-02,   4.061064170487355e-05,   6.715557811531853e-06,  -4.545253559949674e-08,  -2.886364640365493e-09,
   3.353448326595785e-11,   1.195624936336852e-12,  -2.146576530933315e-14,  -4.750078502019714e-16,   1.239073026519312e-17,   1.671888459042522e-19,  -6.847151717769625e-21,
  -4.471047709341654e-23,   3.819792388156954e-24,  -1.429516421826882e-02,   3.863129189616870e-05,   6.388397297031695e-06,  -4.323178054073383e-08,  -2.745439233880637e-09,
   3.189001533807634e-11,   1.137075206902165e-12,  -2.040847821248755e-14,  -4.516803524680573e-16,   1.177692896043582e-17,   1.589692592551089e-19,  -6.505329659926420e-21,
  -4.251209894225947e-23,   3.627842892849356e-24,  -1.290464754393155e-02,   3.486798597696981e-05,   5.766309887195334e-06,  -3.901169437273748e-08,  -2.477599523293486e-09,
   2.876748466240908e-11,   1.025867456348064e-12,  -1.840277414256471e-14,  -4.073995979828505e-16,   1.061394577953917e-17,   1.433702909431631e-19,  -5.858731454977398e-21,
  -3.834015145015717e-23,   3.265250211708632e-24,  -1.099092229765491e-02,   2.969142063476737e-05,   4.910484877704872e-06,  -3.321107387938166e-08,  -2.109369022266135e-09,
   2.448021335652474e-11,   8.731139747197896e-13,  -1.565256592655386e-14,  -3.466282313841721e-16,   9.022012838631609e-18,   1.219691442300407e-19,  -4.975699013063246e-21,
  -3.261659835215908e-23,   2.771048801657701e-24,  -8.741401764374672e-03,   2.361002802018335e-05,   3.904914556153696e-06,  -2.640193918242528e-08,  -1.677018457262391e-09,
   1.945352836684875e-11,   6.939346182425980e-13,  -1.243265139408435e-14,  -2.754095897302042e-16,   7.161663323163146e-18,   9.689782774264136e-20,  -3.946379803336996e-21,
  -2.591174665131110e-23,   2.196214409482464e-24,  -6.376300885660083e-03,   1.721942469812897e-05,   2.848072869445454e-06,  -1.925161820633750e-08,  -1.222912351344673e-09,
   1.418054901809235e-11,   5.059005067810942e-13,  -9.059270890235563e-15,  -2.007330129727185e-16,   5.215879987525280e-18,   7.061754235620705e-20,  -2.872218984868524e-21,
  -1.888383528761467e-23,   1.597495589982751e-24,  -4.127085948902518e-03,   1.114422860820820e-05,   1.843291354780421e-06,  -1.245772297623693e-08,  -7.913780289675052e-10,
   9.174324556042861e-12,   3.273259667209052e-13,  -5.859561696259757e-15,  -1.298564494243454e-16,   3.372537826276648e-18,   4.568041899886096e-20,  -1.856314815295165e-21,
  -1.221530359014229e-23,   1.032061995163839e-24,  -2.213855193266499e-03,   5.977690909456340e-06,   9.887428181905842e-07,  -6.681766995425503e-09,  -4.244685265878517e-10,
   4.920172649153489e-12,   1.755514053512579e-13,  -3.142065993065137e-15,  -6.963877029211593e-17,   1.808146976992594e-18,   2.449647816976138e-20,  -9.950118267332085e-22,
  -6.550524196476863e-24,   5.530903067261443e-25,  -8.238330405730051e-04,   2.224414433648214e-06,   3.679320747866678e-07,  -2.486353422538909e-09,  -1.579501735947736e-10,
   1.830778152257144e-12,   6.532295429176387e-14,  -1.169098661966281e-15,  -2.591194246378508e-17,   6.727350971826028e-19,   9.114810726633930e-21,  -3.701720996165955e-22,
  -2.437358625585925e-24,   2.057507451783436e-25,  -9.305829834759194e-05,   2.512640619710540e-07,   4.156068031371628e-08,  -2.808509084975289e-10,  -1.784159052393259e-11,
   2.067979022511490e-13,   7.378654890790238e-15,  -1.320561021214800e-16,  -2.926909853707569e-18,   7.598840855474876e-20,   1.029570896151963e-21,  -4.181204452887210e-23,
  -2.753137729281399e-25,   2.323990596109365e-26,  -1.374321159383530e-02,  -2.161125347532519e-04,   4.224188229919769e-06,   1.529849774724356e-07,  -4.929215796972523e-10,
  -8.278409230872470e-11,  -6.112610810270412e-13,   3.636475466171955e-14,   6.881460879162086e-16,  -1.224462411468022e-17,  -4.958487099797320e-19,   1.362060650588763e-21,
   2.838012668156480e-22,   2.484585079261024e-24,  -1.307461179524393e-02,  -2.055871522987098e-04,   4.018633732624051e-06,   1.455191957295229e-07,  -4.692161243759256e-10,
  -7.873480487636038e-11,  -5.809600710416595e-13,   3.458287161672548e-14,   6.540155776827408e-16,  -1.164676038595601e-17,  -4.711771970525955e-19,   1.301462637030760e-21,
   2.696740291687740e-22,   2.355730794194513e-24,  -1.180291039883698e-02,  -1.855722148222245e-04,   3.627681784599513e-06,   1.313284192787092e-07,  -4.240154103938848e-10,
  -7.104181650650141e-11,  -5.235561787070614e-13,   3.119885221840464e-14,   5.893643027861758e-16,  -1.051047046912867e-17,  -4.244749417835567e-19,   1.183875138806654e-21,
   2.429341532974030e-22,   2.113915715838111e-24,  -1.005266245927439e-02,  -1.580347354467997e-04,   3.089652342489797e-06,   1.118158409244008e-07,  -3.615885247421259e-10,
  -6.047118070105167e-11,  -4.449956920492291e-13,   2.655146779753225e-14,   5.008996635367115e-16,  -8.948287186044887e-18,  -3.606316569861752e-19,   1.017550395083859e-21,
   2.063848653907201e-22,   1.787419171309729e-24,  -7.995247762981732e-03,  -1.256760514246589e-04,   2.457249199383518e-06,   8.890191062378685e-08,  -2.879316499283208e-10,
  -4.806723809014790e-11,  -3.532097994437878e-13,   2.110119723650971e-14,   3.975602374584768e-16,  -7.114110250030413e-18,  -2.861310729389658e-19,   8.163919537014757e-22,
   1.637407615119488e-22,   1.411575509521160e-24,  -5.832070625900756e-03,  -9.166476137531086e-05,   1.792383702416984e-06,   6.483159279963780e-08,  -2.102332638394363e-10,
  -3.504600440184484e-11,  -2.572285081339689e-13,   1.538261409427901e-14,   2.895139242054840e-16,  -5.187685622045109e-18,  -2.083097325978001e-19,   5.996652716713892e-22,
   1.192019035247424e-22,   1.023789355547235e-24,  -3.774848719569554e-03,  -5.932696381569369e-05,   1.160116940852144e-06,   4.195534658629590e-08,  -1.361620487165872e-10,
  -2.267681857005639e-11,  -1.663144998307657e-13,   9.952447595224887e-15,   1.871834311913720e-16,  -3.357059397059925e-18,  -1.346563244461889e-19,   3.899094265251037e-22,
   7.705277148747701e-23,   6.601482620882531e-25,  -2.024912725194892e-03,  -3.182328305430051e-05,   6.223080896739170e-07,   2.250375348657337e-08,  -7.306432859821530e-11,
  -1.216243394249636e-11,  -8.916565520209316e-14,   5.337596353737763e-15,   1.003525003402190e-16,  -1.800606177206335e-18,  -7.218484550732527e-20,   2.096433557660388e-22,
   4.130487158832208e-23,   3.534285751381465e-25,  -7.535232795092884e-04,  -1.184214865181351e-05,   2.315766348451410e-07,   8.373976038236895e-09,  -2.719226355133877e-11,
  -4.525713473370078e-12,  -3.317452234046917e-14,   1.986115223534960e-15,   3.733644309495008e-17,  -6.700276227554918e-19,  -2.685569012884218e-20,   7.807686981018488e-23,
   1.536701007430157e-23,   1.314307997639405e-25,  -8.511627983263856e-05,  -1.337659876172731e-06,   2.615836095112745e-08,   9.459006271516746e-10,  -3.071632047450960e-12,
  -5.112098782485962e-13,  -3.747204719486225e-15,   2.243444742478392e-16,   4.217307948334018e-18,  -7.568434643429505e-20,  -3.033446885118133e-21,   8.820516189178787e-24,
   1.735757724002904e-24,   1.484452507918289e-26,  -8.276561956578936e-03,  -2.896878318228605e-04,  -4.093470057880842e-06,   3.384112887582567e-08,   2.942842247615437e-09,
   5.971722553037572e-11,   4.143122926576284e-14,  -3.016799419557786e-14,  -8.181507419497395e-16,  -5.696295397949120e-18,   2.809073862739092e-19,   1.036490132412687e-20,
   1.241136888066913e-22,  -2.107415616400764e-24,  -7.874108178034481e-03,  -2.755942678249027e-04,  -3.893837342448673e-06,   3.221278104450872e-08,   2.799717306768139e-09,
   5.679369713574729e-11,   3.873710635280932e-14,  -2.870659343744469e-14,  -7.779778544251575e-16,  -5.402325336339294e-18,   2.674840209473982e-19,   9.855786667879235e-21,
   1.177655574386471e-22,  -2.010477178978909e-24,  -7.108546429932352e-03,  -2.487879544927341e-04,  -3.514326726092046e-06,   2.910827922034551e-08,   2.527470619280465e-09,
   5.124047728850775e-11,   3.388895181604058e-14,  -2.592438822010178e-14,  -7.017175806302815e-16,  -4.850041494946554e-18,   2.418528435348139e-19,   8.889392229532366e-21,
   1.058173469403085e-22,  -1.823806806562481e-24,  -6.054745762748022e-03,  -2.118946328340769e-04,  -2.992388896053649e-06,   2.482134596198024e-08,   2.152742287574167e-09,
   4.361198631367638e-11,   2.775147760590005e-14,  -2.209027425418750e-14,  -5.970516032570021e-16,  -4.103217635268699e-18,   2.063845569784369e-19,   7.563158186038947e-21,
   8.961745584734735e-23,  -1.562470916475946e-24,  -4.815808147954364e-03,  -1.685269778502865e-04,  -2.379337922035029e-06,   1.976410191936452e-08,   1.712207000422468e-09,
   3.466297722644060e-11,   2.121360547600802e-14,  -1.757704418037815e-14,  -4.743863757687372e-16,  -3.242130664364846e-18,   1.644498436820604e-19,   6.009032682595562e-21,
   7.088375974895962e-23,  -1.249704285306342e-24,  -3.512999595687779e-03,  -1.229303698796337e-04,  -1.735226342630205e-06,   1.443015254677763e-08,   1.248986715911174e-09,
   2.527098758928316e-11,   1.497008150908634e-14,  -1.282603174871904e-14,  -3.457606682001399e-16,  -2.352432637764626e-18,   1.201351710213716e-19,   4.379574203923496e-21,
   5.147519739206107e-23,  -9.156964272521130e-25,  -2.273876215966553e-03,  -7.956741354925499e-05,  -1.122982192858277e-06,   9.345740472356780e-09,   8.084285146594124e-10,
   1.635098576336215e-11,   9.474007134424081e-15,  -8.303699554116983e-15,  -2.236775702519493e-16,  -1.517278493943084e-18,   7.783452127260149e-20,   2.833138071890074e-21,
   3.321917227426067e-23,  -5.944446220597502e-25,  -1.219774948944381e-03,  -4.268169187245223e-05,  -6.023498282591144e-07,   5.014839105633926e-09,   4.336626070490952e-10,
   8.769423446050625e-12,   5.022720553124915e-15,  -4.454828140697522e-15,  -1.199529720573691e-16,  -8.124284240665852e-19,   4.177312672708259e-20,   1.519324531340487e-21,
   1.779236965403100e-23,  -3.193557498971707e-25,  -4.539125690259421e-04,  -1.588297530907063e-05,  -2.241446728261420e-07,   1.866357666898184e-09,   1.613777253609935e-10,
   3.263124734547071e-12,   1.861400434514151e-15,  -1.657828501354583e-15,  -4.463342629819826e-17,  -3.021351573812037e-19,   1.554759222627046e-20,   5.653244097918552e-22,
   6.617494747142836e-24,  -1.189031223322836e-25,  -5.127297381167067e-05,  -1.794104765672006e-06,  -2.531877433429890e-08,   2.108231863296714e-10,   1.822886998904257e-11,
   3.685914307307694e-13,   2.101218038026694e-16,  -1.872657964421280e-16,  -5.041614742154168e-18,  -3.412508139526376e-20,   1.756269362820007e-21,   6.385675488041566e-23,
   7.474342058598419e-25,  -1.343214607387763e-26,  -1.984718948010183e-03,  -9.840853344194583e-05,  -3.089263450790263e-06,  -7.499551536655934e-08,  -1.458446165280234e-09,
  -2.125019372812939e-11,  -1.426995099091425e-13,   4.152887492399884e-15,   2.163939918391879e-16,   6.088476026784477e-18,   1.256013709203331e-19,   1.830850134682378e-21,
   9.858614385242400e-24,  -4.421464471711171e-25,  -1.888273791213915e-03,  -9.362861089121749e-05,  -2.939260968745721e-06,  -7.135401835574298e-08,  -1.387569805495745e-09,
  -2.021395371297686e-11,  -1.355774606037705e-13,   3.957426544458207e-15,   2.060367044236178e-16,   5.795314199953730e-18,   1.195108493188117e-19,   1.740752980254009e-21,
   9.327746088823784e-24,  -4.220130308015557e-25,  -1.704786726908383e-03,  -8.453393511322338e-05,  -2.653833505858365e-06,  -6.442491383293170e-08,  -1.252729262413138e-09,
  -1.824396873828339e-11,  -1.221039297616340e-13,   3.582985271522884e-15,   1.862676481225425e-16,   5.236472181110783e-18,   1.079182191467772e-19,   1.569797907025861e-21,
   8.338746930549712e-24,  -3.831604160382789e-25,  -1.452165777395116e-03,  -7.201090769488090e-05,  -2.260771177035039e-06,  -5.488284617625324e-08,  -1.067087465390226e-09,
  -1.553457916784053e-11,  -1.037017376473045e-13,   3.062463779072014e-15,   1.589253648637057e-16,   4.464938492695322e-18,   9.194740534076674e-20,   1.335316937043396e-21,
   7.017876279497890e-24,  -3.286038659487264e-25,  -1.155100027306752e-03,  -5.728252064026506e-05,  -1.798438995346310e-06,  -4.365917851039451e-08,  -8.487896838935090e-10,
  -1.235211979715738e-11,  -8.224939246932116e-14,   2.444031289388718e-15,   1.266147817427866e-16,   3.554970338298787e-18,   7.315390335530143e-20,   1.060710886106084e-21,
   5.516349201973558e-24,  -2.630988900020021e-25,  -8.426608019780806e-04,  -4.178994325832517e-05,  -1.312071995425489e-06,  -3.185204836929332e-08,  -6.191994490344121e-10,
  -9.008333988704350e-12,  -5.986184920368825e-14,   1.787684708050597e-15,   9.248491331900886e-17,   2.595401686243193e-18,   5.337601875628862e-20,   7.729515339452924e-22,
   3.985469031732381e-24,  -1.929436580157234e-25,  -5.454532749293026e-04,  -2.705125511667578e-05,  -8.493397027520709e-07,  -2.061868776013175e-08,  -4.008053343041793e-10,
  -5.829926795046357e-12,  -3.868851264837524e-14,   1.159190413214015e-15,   5.991573168839696e-17,   1.680856635952953e-18,   3.455416796720933e-20,   4.999656600274707e-22,
   2.563184684214785e-24,  -1.253241963121806e-25,  -2.926029383269245e-04,  -1.451156111968421e-05,  -4.556299990733614e-07,  -1.106093528151537e-08,  -2.150075322741955e-10,
  -3.127087001762978e-12,  -2.073753376632830e-14,   6.223938554868347e-16,   3.215506786353658e-17,   9.019145086794071e-19,   1.853731697224117e-20,   2.681009001221192e-22,
   1.370417609222571e-24,  -6.734795650010070e-26,  -1.088865028175332e-04,  -5.400219913009431e-06,  -1.695551839847088e-07,  -4.116144318319667e-09,  -8.001081791321532e-11,
  -1.163643421739173e-12,  -7.714929156398685e-15,   2.316840422053646e-16,   1.196768131569634e-17,   3.356605133466111e-19,   6.898442242549587e-21,   9.975549842997673e-23,
   5.093812991801648e-25,  -2.507765613898252e-26,  -1.229959476372976e-05,  -6.099981359355086e-07,  -1.915262761055759e-08,  -4.649517454989354e-10,  -9.037855862593841e-12,
  -1.314420204584982e-13,  -8.714240978341073e-16,   2.617184666847311e-17,   1.351876808681438e-18,   3.791606661325771e-20,   7.792363078092794e-22,   1.126794143987305e-23,
   5.752803039372835e-26,  -2.832996753111511e-27,  -3.053608536727125e-04,   1.133899173713286e-05,  -2.791520182289149e-07,   5.673192150566203e-09,  -1.028290337957687e-10,
   1.712534637865940e-12,  -2.687559509524351e-14,   3.940283388604335e-16,  -5.607410077415475e-18,   7.396425835173696e-20,  -8.230743349447040e-22,   1.476800585494119e-23,
  -4.481681559726928e-26,  -1.113818598707274e-27,  -2.905163272995974e-04,   1.078796641095197e-05,  -2.655923439660196e-07,   5.397756107028144e-09,  -9.783939872984725e-11,
   1.629482765386516e-12,  -2.557303142031244e-14,   3.749419986930129e-16,  -5.335765697056472e-18,   7.039073517881029e-20,  -7.831306546907508e-22,   1.404707411190792e-23,
  -4.290543461176828e-26,  -1.061726875645760e-27,  -2.622769768166502e-04,   9.739647963817809e-06,  -2.397928466093041e-07,   4.873638476874775e-09,  -8.834367315545235e-11,
   1.471408646392524e-12,  -2.309350957217779e-14,   3.386054155616381e-16,  -4.818619692990811e-18,   6.358367963385555e-20,  -7.071170304726304e-22,   1.267683508995494e-23,
  -3.915992302787404e-26,  -9.617821560027081e-28,  -2.234022844027711e-04,   8.296361936624870e-06,  -2.042684092995128e-07,   4.151850710867921e-09,  -7.526447165298334e-11,
   1.253644189853230e-12,  -1.967705819228233e-14,   2.885299174153600e-16,  -4.105961075407994e-18,   5.419555525114584e-20,  -6.024222904277261e-22,   1.079291428291878e-23,
  -3.379237481440096e-26,  -8.225646602912824e-28,  -1.776940357882891e-04,   6.599171659162087e-06,  -1.624885990955435e-07,   3.302829581488597e-09,  -5.987697254537636e-11,
   9.974009013980700e-13,  -1.565611523227420e-14,   2.295834870283561e-16,  -3.267081279112454e-18,   4.313508907758391e-20,  -4.792553098009624e-22,   8.580839479600963e-24,
  -2.721476699511824e-26,  -6.568287712399480e-28,  -1.296257923965399e-04,   4.814168487456752e-06,  -1.185416117392934e-07,   2.409641446267637e-09,  -4.368642803665085e-11,
   7.277414603182942e-13,  -1.142389544371582e-14,   1.675296888184370e-16,  -2.384005554737090e-18,   3.148299683067598e-20,  -3.496640897696248e-22,   6.257366281779319e-24,
  -2.005004928859652e-26,  -4.806460590204413e-28,  -8.390474495132319e-05,   3.116198851196928e-06,  -7.673355618922328e-08,   1.559836330405631e-09,  -2.828047187864982e-11,
   4.711192852722106e-13,  -7.395764566594185e-15,   1.084612166609931e-16,  -1.543431707763976e-18,   2.038547900978218e-20,  -2.263547941936206e-22,   4.049327644317559e-24,
  -1.306227311698988e-26,  -3.117522682442436e-28,  -4.500934450455333e-05,   1.671651870564314e-06,  -4.116342050520726e-08,   8.367801692260207e-10,  -1.517140970044337e-11,
   2.527418595872340e-13,  -3.967684413530454e-15,   5.818829353239419e-17,  -8.280322653947801e-19,   1.093739667224410e-20,  -1.214306501856660e-22,   2.171929631307168e-24,
  -7.030213880658581e-27,  -1.674096792557395e-28,  -1.674928711379448e-05,   6.220725634108678e-07,  -1.531822916913605e-08,   3.113942941963389e-10,  -5.645827725671738e-12,
   9.405487308300894e-14,  -1.476535672230797e-15,   2.165433826505410e-17,  -3.081456915310136e-19,   4.070374365983403e-21,  -4.518869389301411e-23,   8.082036693807997e-25,
  -2.619146609098257e-27,  -6.232068245303562e-29,  -1.891963730360963e-06,   7.026802959028388e-08,  -1.730316671187486e-09,   3.517450736035503e-11,  -6.377425270352137e-13,
   1.062427846227414e-14,  -1.667871220954693e-16,   2.446041834391761e-18,  -3.480767307396125e-20,   4.597852965492569e-22,  -5.104433042036542e-24,   9.129234225428492e-26,
  -2.959069679771417e-28,  -7.040017487604391e-30,  -2.644016803922834e-03,   9.110129465052896e-05,  -1.952103447633465e-06,   3.111757289594313e-08,  -3.631500720497739e-10,
   2.051965692301526e-12,   3.407742636605576e-14,  -1.481107948650066e-15,   3.033523953168175e-17,  -4.641221605205434e-19,   5.681012502710718e-21,   2.754641395806391e-23,
  -3.224691744013094e-25,   1.031929211428980e-26,  -2.515469085969839e-03,   8.667287417237599e-05,  -1.857217233301259e-06,   2.960461108278989e-08,  -3.454710390810938e-10,
   1.951230367093122e-12,   3.244518481329085e-14,  -1.409562797380945e-15,   2.886731820291053e-17,  -4.415018327785973e-19,   5.404009709633073e-21,   2.623054820038055e-23,
  -3.107089189152112e-25,   9.822462003094574e-27,  -2.270933171779517e-03,   7.824838943029965e-05,  -1.676706610840583e-06,   2.672653952488786e-08,  -3.118497204354607e-10,
   1.759996752094120e-12,   2.933020433298982e-14,  -1.273273994378143e-15,   2.607207776360210e-17,  -3.984937589101770e-19,   4.877383374663308e-21,   2.371788519056405e-23,
  -2.867389352213734e-25,   8.875495431581240e-27,  -1.934312551399554e-03,   6.665089289968839e-05,  -1.428204029245355e-06,   2.276473498560958e-08,  -2.655859828307951e-10,
   1.497516422652436e-12,   2.502287506492803e-14,  -1.085297264070330e-15,   2.221877289689292e-17,  -3.393338495484007e-19,   4.153067320185849e-21,   2.024060384264224e-23,
  -2.506488827814176e-25,   7.568214379162024e-27,  -1.538533283841818e-03,   5.301444804195091e-05,  -1.136007136757111e-06,   1.810674877704735e-08,  -2.112149597863178e-10,
   1.189877268312747e-12,   1.993406717060077e-14,  -8.638221280155742e-16,   1.768136491632083e-17,  -2.698323873518392e-19,   3.302260816720035e-21,   1.612886535698350e-23,
  -2.043086353676855e-25,   6.026280766382232e-27,  -1.122332254636434e-03,   3.867365844585689e-05,  -8.287129241772072e-07,   1.320848804259562e-08,  -1.540601357887069e-10,
   8.672693963768958e-13,   1.455983237181767e-14,  -6.304877069282057e-16,   1.290338913318551e-17,  -1.967964304603315e-19,   2.408316925032797e-21,   1.178317201491832e-23,
  -1.519417407015347e-25,   4.400024129919262e-27,  -7.264636389811266e-04,   2.503294622733582e-05,  -5.364165484084373e-07,   8.549570032974380e-09,  -9.971267235102299e-11,
   5.610564754432426e-13,   9.432117906974745e-15,  -4.082498798837363e-16,   8.354313937828576e-18,  -1.273647389363410e-19,   1.558587815520507e-21,   7.634485271300373e-24,
  -9.958907788304906e-26,   2.849770109076062e-27,  -3.896984535257528e-04,   1.342854505086949e-05,  -2.877529949225251e-07,   4.586257349830369e-09,  -5.348703626365847e-11,
   3.008833267885493e-13,   5.061846955919653e-15,  -2.190390089958469e-16,   4.482129545079209e-18,  -6.831765570923756e-20,   8.360023102571263e-22,   4.097441577285450e-24,
  -5.376423692149717e-26,   1.529186794113165e-27,  -1.450179781948584e-04,   4.997155772889797e-06,  -1.070813949346475e-07,   1.706677081924044e-09,  -1.990379598965830e-11,
   1.119562580266628e-13,   1.883937735573894e-15,  -8.151596577886010e-17,   1.668007640786290e-18,  -2.542232742126350e-20,   3.110908062744179e-22,   1.525042217288166e-24,
  -2.005143005941060e-26,   5.691165263488617e-28,  -1.638091851099390e-05,   5.644681118588108e-07,  -1.209568820183974e-08,   1.927825516803816e-10,  -2.248285177293769e-12,
   1.264613950103415e-14,   2.128105544229451e-16,  -9.207962308647719e-18,   1.884159599537030e-19,  -2.871640012366051e-21,   3.513997452330634e-23,   1.722702638323632e-25,
  -2.265758835670977e-27,   6.428729414632644e-29,  -6.749619589282141e-03,   1.945165485699802e-04,  -2.737926536126459e-06,   6.423602107252060e-09,   6.834295487451103e-10,
  -1.853058950427353e-11,   2.302934609310312e-13,   1.253281929137575e-16,  -7.926228339466109e-17,   1.834846497693712e-18,  -1.732414898008812e-20,   1.245548479015292e-23,
   1.082176959984790e-23,  -2.351373657299013e-25,  -6.421397084784862e-03,   1.850557618228762e-04,  -2.604630725959644e-06,   6.105647121485089e-09,   6.502897559549466e-10,
  -1.762916801870464e-11,   2.190257984995334e-13,   1.211960805954749e-16,  -7.542994379487329e-17,   1.745614095123813e-18,  -1.646029818346087e-20,   1.130437571155790e-23,
   1.029218705483924e-23,  -2.237010910631693e-25,  -5.797047765506923e-03,   1.670600468159717e-04,  -2.351136654544761e-06,   5.503099890990458e-09,   5.872124445260230e-10,
  -1.591459632480172e-11,   1.976202756357688e-13,   1.125381381403750e-16,  -6.813101148150533e-17,   1.575876589145571e-18,  -1.482578105818794e-20,   9.336461879962018e-24,
   9.286170654539701e-24,  -2.019468545614345e-25,  -4.937640639620716e-03,   1.422906262283135e-04,  -2.002328244847350e-06,   4.678106198246636e-09,   5.003131994271909e-10,
  -1.355475817062991e-11,   1.682101771632051e-13,   9.907382808442525e-17,  -5.806672652130547e-17,   1.342239840780751e-18,  -1.259277550504689e-20,   7.057578346817420e-24,
   7.904041353793449e-24,  -1.720032649281473e-25,  -3.927265945865299e-03,   1.131718651761423e-04,  -1.592401246529623e-06,   3.713763798314587e-09,   3.980548181648547e-10,
  -1.078068984596247e-11,   1.337024973922674e-13,   8.128631668637893e-17,  -4.621251205631708e-17,   1.067568641401220e-18,  -9.988865875583418e-21,   4.922575219278345e-24,
   6.282449736698315e-24,  -1.368018206763937e-25,  -2.864819579458154e-03,   8.255406595396555e-05,  -1.161492173091847e-06,   2.704918658819357e-09,   2.904387627271684e-10,
  -7.863946023912623e-12,   9.748051981964589e-14,   6.075651173662831e-17,  -3.372691967106408e-17,   7.787502305463042e-19,  -7.270658337726135e-21,   3.184923128047561e-24,
   4.580382494922471e-24,  -9.978932263150239e-26,  -1.854320084143115e-03,   5.343444311630045e-05,  -7.517530056679274e-07,   1.749042357170903e-09,   1.880230839306668e-10,
  -5.090018210191665e-12,   6.307453818082235e-14,   3.995075240063264e-17,  -2.183749115051155e-17,   5.040601582366933e-19,  -4.699296549479989e-21,   1.887897516564095e-24,
   2.963701674299612e-24,  -6.458931596347601e-26,  -9.947110190297028e-04,   2.866362731624420e-05,  -4.032484825613938e-07,   9.377471475832575e-10,   1.008692771169215e-10,
  -2.730405375458175e-12,   3.382895921252079e-14,   2.160283385347675e-17,  -1.171618171360109e-17,   2.703913952695979e-19,  -2.518964889458942e-21,   9.648959392126803e-25,
   1.589524779326395e-24,  -3.464711127005537e-26,  -3.701597530321275e-04,   1.066651609055973e-05,  -1.500582604288778e-07,   3.488984597251793e-10,   3.753734346477561e-11,
  -1.016056489247959e-12,   1.258791685886325e-14,   8.061307555577570e-18,  -4.360166897663360e-18,   1.006200483174150e-19,  -9.371344942390115e-22,   3.528701368286800e-25,
   5.914689297746323e-25,  -1.289309550443136e-26,  -4.181243485221707e-05,   1.204865929601508e-06,  -1.695022078943368e-08,   3.940966848307099e-11,   4.240155235946863e-12,
  -1.147714505358642e-13,   1.421889465610330e-15,   9.109871813074454e-19,  -4.925193544977581e-19,   1.136581768627674e-20,  -1.058523094296352e-22,   3.974840098395046e-26,
   6.681036009232124e-26,  -1.456374700097191e-27,  -1.141561618872989e-02,   2.243803518792008e-04,   2.792240668700965e-07,  -8.845395268748467e-08,   1.464603675063472e-09,
   6.813036810108762e-12,  -6.860802536402810e-13,   9.599442266211570e-15,   8.265110557579290e-17,  -5.355889885530930e-18,   6.974769558663984e-20,   1.161460613197004e-21,
  -3.764071652277609e-23,   3.297522710919886e-25,  -1.086034816705554e-02,   2.134585323045111e-04,   2.659030237214089e-07,  -8.414947939005446e-08,   1.393059178273926e-09,
   6.487614715361950e-12,  -6.526397514569274e-13,   9.126803061757032e-15,   7.872363787206841e-17,  -5.093471337585329e-18,   6.628136187747505e-20,   1.105714664306797e-21,
  -3.580322198162787e-23,   3.124757774945617e-25,  -9.804169145979579e-03,   1.926872021379157e-04,   2.404589361856836e-07,  -7.596271290158952e-08,   1.257097748478995e-09,
   5.866195197771723e-12,  -5.890602095932865e-13,   8.230117240894129e-15,   7.121533209359403e-17,  -4.595094726634562e-18,   5.971801060524950e-20,   9.993716335621899e-22,
  -3.231071802343780e-23,   2.801195781895570e-25,  -8.350470271196956e-03,   1.641041332376097e-04,   2.052327828243764e-07,  -6.469620388981186e-08,   1.070203842802446e-09,
   5.006178022828352e-12,  -5.016050145898976e-13,   7.000444929113069e-15,   6.080784293802806e-17,  -3.910638871903129e-18,   5.074249672382060e-20,   8.524098382886826e-22,
  -2.750885381588356e-23,   2.365627768482339e-25,  -6.641553419653222e-03,   1.305105870871519e-04,   1.635620857326251e-07,  -5.145366798812869e-08,   8.508018366715683e-10,
   3.989216499434448e-12,  -3.988644678094212e-13,   5.560583252672831e-15,   4.848065618155865e-17,  -3.107915068604054e-18,   4.026475068726292e-20,   6.789009695070274e-22,
  -2.187057004654609e-23,   1.865921658883713e-25,  -4.844700003152199e-03,   9.519557704491054e-05,   1.195047146043545e-07,  -3.753154708811668e-08,   6.203932077031747e-10,
   2.914378083991476e-12,  -2.909013367551635e-13,   4.051938532415372e-15,   3.543307143162168e-17,  -2.265657403320422e-18,   2.931640087152117e-20,   4.957738358468939e-22,
  -1.594843438665835e-23,   1.351962572497206e-25,  -3.135796537577197e-03,   6.161414837165925e-05,   7.743392701337231e-08,  -2.429216097261788e-08,   4.014608466407950e-10,
   1.888264906902290e-12,  -1.882677206842499e-13,   2.620856231678682e-15,   2.296389075111198e-17,  -1.465869203711771e-18,   1.895198100786956e-20,   3.211296293128378e-22,
  -1.032063287755870e-23,   8.711724320959511e-26,  -1.682119309040500e-03,   3.305068626863691e-05,   4.156032336879636e-08,  -1.303074549768864e-08,   2.153268942826691e-10,
   1.013434140321676e-12,  -1.009854160202809e-13,   1.405392639666581e-15,   1.232648714659929e-17,  -7.861612616306356e-19,   1.015985506416066e-20,   1.723260967498170e-22,
  -5.535634716769743e-24,   4.662442045365969e-26,  -6.259619185029995e-04,   1.229896327903817e-05,   1.546867398113373e-08,  -4.849068930559797e-09,   8.012548160034631e-11,
   3.771937310993506e-13,  -3.757860721659262e-14,   5.229197295426205e-16,   4.588064863244339e-18,  -2.925300946266527e-19,   3.779919242403665e-21,   6.413548764437912e-23,
  -2.059879717257188e-24,   1.733629307440914e-26,  -7.070725738216735e-05,   1.389261795943600e-06,   1.747359811318134e-09,  -5.477395692920825e-10,   9.050733100453557e-12,
   4.260817101755873e-14,  -4.244781259276436e-15,   5.906668192288374e-17,   5.182763021297741e-19,  -3.304315592433163e-20,   4.269562226658674e-22,   7.244749949395891e-24,
  -2.326779838029887e-25,   1.958019560152517e-27,  -1.476083727300481e-02,   9.142827239831748e-05,   5.919598910889813e-06,  -8.493940017575138e-08,  -1.984417133527659e-09,
   5.374279410436001e-11,   4.545648444285557e-13,  -2.883683867079959e-14,   1.817123042314754e-17,   1.310565426705086e-17,  -1.149354520681385e-19,  -4.681911317884043e-21,
   1.138136718370483e-22,   1.461216777023976e-24,  -1.404268981203343e-02,   8.697362597688205e-05,   5.631314184181592e-06,  -8.079199723460363e-08,  -1.887691662688534e-09,
   5.111078903462006e-11,   4.324689181608678e-13,  -2.742023103637616e-14,   1.713541091410988e-17,   1.246056760260195e-17,  -1.091239197273645e-19,  -4.450811386189640e-21,
   1.080721451903643e-22,   1.388800545517174e-24,  -1.267676349991224e-02,   7.850345359446713e-05,   5.083107770414230e-06,  -7.290964705663360e-08,  -1.703791289401179e-09,
   4.611172072443588e-11,   3.904339996617636e-13,  -2.473137427934456e-14,   1.522733858360530e-17,   1.123664594401970e-17,  -9.816012370147942e-20,  -4.012607319587632e-21,
   9.723518651417777e-23,   1.251603241704386e-24,  -1.079686551467775e-02,   6.685120942662448e-05,   4.328844992579806e-06,  -6.207307793186631e-08,  -1.450833927663006e-09,
   3.924524136479902e-11,   3.325664952751961e-13,  -2.104150401948516e-14,   1.272125158491344e-17,   9.558077328156723e-18,  -8.324447632214323e-20,  -3.412131272302780e-21,
   8.248190327395411e-23,   1.063826075471164e-24,  -8.587087941278625e-03,   5.316070157994372e-05,   3.442508552625043e-06,  -4.934980961733471e-08,  -1.153667005504240e-09,
   3.119110264520353e-11,   2.645249925925326e-13,  -1.671773929750566e-14,   9.926652616541057e-18,   7.592404608468886e-18,  -6.593042537029619e-20,  -2.709590314911897e-21,
   6.534333089051400e-23,   8.444194722099220e-25,  -6.263753501130227e-03,   3.877266520083890e-05,   2.510888006954212e-06,  -3.598657300666202e-08,  -8.413958473083983e-10,
   2.273914633742400e-11,   1.929689495054543e-13,  -1.218444460113036e-14,   7.128921916161592e-18,   5.532652783717061e-18,  -4.793004206870103e-20,  -1.974022957522606e-21,
   4.751316704378664e-23,   6.149685186758705e-25,  -4.054245542666054e-03,   2.509374602581673e-05,   1.625094636650436e-06,  -2.328774890077900e-08,  -5.445405752121647e-10,
   1.471253241525970e-11,   1.249061517344154e-13,  -7.882116106349328e-15,   4.566424254204970e-18,   3.578668862712741e-18,  -3.095371299130821e-20,  -1.276646206024363e-21,
   3.068874447481152e-23,   3.976209211856933e-25,  -2.174783820890793e-03,   1.346025506044748e-05,   8.717106239328852e-07,  -1.249074013701030e-08,  -2.920874639753090e-10,
   7.890603522334759e-12,   6.700398365325174e-14,  -4.226943865558690e-15,   2.436371146879812e-18,   1.919022217517384e-18,  -1.658517477276865e-20,  -6.845311652012050e-22,
   1.644437623810144e-23,   2.131765395846255e-25,  -8.092937936515513e-04,   5.008838770656800e-06,   3.243830494002680e-07,  -4.647961200426922e-09,  -1.086913289125454e-10,
   2.936103493761899e-12,   2.493414473851230e-14,  -1.572801788635751e-15,   9.049340187703001e-19,   7.140337787325691e-19,  -6.169308909641258e-21,  -2.546944671680030e-22,
   6.117087086307377e-24,   7.931355391480490e-26,  -9.141598227784240e-05,   5.657856972422741e-07,   3.664151226827124e-08,  -5.250200727656494e-10,  -1.227748827178066e-11,
   3.316520465662932e-13,   2.816507999026081e-15,  -1.776573395403441e-16,   1.021887579515192e-19,   8.065411444192010e-20,  -6.968268525699540e-22,  -2.876903547070122e-23,
   6.909310946894558e-25,   8.958809448245717e-27,  -1.452880728125150e-02,  -1.752389566323946e-04,   5.956507712076669e-06,   1.314401470927546e-07,  -2.202174841488323e-09,
  -8.328412345806700e-11,   6.235880738983334e-13,   4.787184813280867e-14,  -5.716604752290096e-17,  -2.671040795787857e-17,  -1.283073665714838e-19,   1.458888555179641e-20,
   1.868977299049365e-22,  -6.570580052367680e-24,  -1.382194479532623e-02,  -1.667036003223251e-04,   5.666389069388978e-06,   1.250221862212083e-07,  -2.094782428795913e-09,
  -7.920340231473989e-11,   5.932079935619355e-13,   4.551492100536539e-14,  -5.455417819586191e-17,  -2.538749504113590e-17,  -1.217043211099002e-19,   1.386413161636934e-20,
   1.773940952595788e-22,  -6.244287655806120e-24,  -1.247748420569750e-02,  -1.504731364041197e-04,   5.114710071738480e-06,   1.128245379419537e-07,  -1.890622903668136e-09,
  -7.145352732383138e-11,   5.354411874271197e-13,   4.104336736669022e-14,  -4.951687016010619e-17,  -2.288083618424305e-17,  -1.092928870589753e-19,   1.249174513600745e-20,
   1.594861453917011e-22,  -5.626371879503887e-24,  -1.062713207412587e-02,  -1.281430234851370e-04,   4.355698176636290e-06,   9.605536786098307e-08,  -1.609840460848603e-09,
  -6.081021121471642e-11,   4.559700775267107e-13,   3.491123603723320e-14,  -4.245002021576556e-17,  -1.944943413144110e-17,  -9.249646810897162e-20,   1.061477371323782e-20,
   1.351645105695729e-22,  -4.781168563147653e-24,  -8.452088772173592e-03,  -1.019040485816293e-04,   3.463817377434684e-06,   7.636663301654784e-08,  -1.280038140263196e-09,
  -4.832791904990731e-11,   3.625946794707115e-13,   2.773083032405988e-14,  -3.397433396157101e-17,  -1.543922268776495e-17,  -7.311203355047359e-20,   8.423364993802836e-21,
   1.069842349292554e-22,  -3.794251742965420e-24,  -6.165277071425006e-03,  -7.432561372824283e-05,   2.526403079230529e-06,   5.568759948689680e-08,  -9.335219219408356e-10,
  -3.523089767663547e-11,   2.644594595391868e-13,   2.020728817826901e-14,  -2.490664358887996e-17,  -1.124463557495909e-17,  -5.306504341249279e-20,   6.133234810762607e-21,
   7.773575941604541e-23,  -2.762764003721505e-24,  -3.990504977578428e-03,  -4.810457171085748e-05,   1.635124697822494e-06,   3.603673328536003e-08,  -6.041465840572010e-10,
  -2.279424561665172e-11,   1.711593577325910e-13,   1.307044229324796e-14,  -1.617404544311561e-17,  -7.270741002733006e-18,  -3.423319403647589e-20,   3.965026452427236e-21,
   5.018564473314286e-23,  -1.786114226183941e-24,  -2.140591689143651e-03,  -2.580347843147485e-05,   8.770876172602331e-07,   1.932885053952568e-08,  -3.240550503555652e-10,
  -1.222480600375407e-11,   9.180985046107264e-14,   7.008834090926271e-15,  -8.690708398456505e-18,  -3.898141747068812e-18,  -1.833220760099216e-20,   2.125619655802839e-21,
   2.688509558602357e-23,  -9.575319245108146e-25,  -7.965699663902755e-04,  -9.602038628539482e-06,   3.263835356028951e-07,   7.192507626613078e-09,  -1.205864795242230e-10,
  -4.548843684565040e-12,   3.416436322072817e-14,   2.607855325486811e-15,  -3.235929731131611e-18,  -1.450336221288949e-18,  -6.817852685040447e-21,   7.908295214860788e-22,
   1.000004260780792e-23,  -3.562477764175060e-25,  -8.997872698041266e-05,  -1.084622446378576e-06,   3.686747486355150e-08,   8.124445730694262e-10,  -1.362112263397069e-11,
  -5.138211792574267e-13,   3.859120041687547e-15,   2.945717531483783e-16,  -3.655571252390781e-19,  -1.638219416883436e-19,  -7.700566943078181e-22,   8.932727103307140e-23,
   1.129499527433077e-24,  -4.023959553726129e-26,  -9.496988714402764e-03,  -3.199212914395912e-04,  -3.366191548253138e-06,   9.019348300625364e-08,   4.062973890706907e-09,
   4.752844548317999e-11,  -1.179588623846619e-12,  -5.648841027058132e-14,  -6.996631177998808e-16,   1.574628936590170e-17,   7.946272911235421e-19,   1.048589998362926e-20,
  -1.917167522055193e-22,  -1.030984896975742e-23,  -9.035151061136922e-03,  -3.043521430011620e-04,  -3.201735421902717e-06,   8.582046414994926e-08,   3.864821258951325e-09,
   4.518145893096318e-11,  -1.122789401989232e-12,  -5.372382639030989e-14,  -6.645712951989127e-16,   1.499730248190092e-17,   7.555961377557322e-19,   9.952055311438434e-21,
  -1.827550870101403e-22,  -9.800988263453220e-24,  -8.156643370141423e-03,  -2.747411416879436e-04,  -2.889215459007159e-06,   7.749677436003695e-08,   3.488126903490782e-09,
   4.073154172648982e-11,  -1.014515381063328e-12,  -4.847214740283917e-14,  -5.982542162581383e-16,   1.356571466692959e-17,   6.815080305148685e-19,   8.946322659234681e-21,
  -1.655595841109229e-22,  -8.836052352200653e-24,  -6.947403211910995e-03,  -2.339914539787875e-04,  -2.459638896826337e-06,   6.602913407137821e-08,   2.970067557953627e-09,
   3.463450045673575e-11,  -8.650335941713586e-13,  -4.125718037531681e-14,  -5.078126094825819e-16,   1.158191901032845e-17,   5.798332047830029e-19,   7.580835137297339e-21,
  -1.416039526019025e-22,  -7.513726777512795e-24,  -5.525757381631463e-03,  -1.860953758241408e-04,  -1.955363073857353e-06,   5.253412992404919e-08,   2.361579373912985e-09,
   2.750209842832705e-11,  -6.887325840185943e-13,  -3.279241443397418e-14,  -4.025493895700674e-16,   9.232965665091007e-18,   4.606868996366911e-19,   5.999352038795164e-21,
  -1.130802754880187e-22,  -5.966617058292979e-24,  -4.030858441881933e-03,  -1.357419700190295e-04,  -1.425808863312462e-06,   3.833162329779491e-08,   1.722269011254333e-09,
   2.003535494784734e-11,  -5.028246176505872e-13,  -2.390785936793975e-14,  -2.928539347893429e-16,   6.747482106946480e-18,   3.357643836380831e-19,   4.358588488386148e-21,
  -8.275332522558810e-23,  -4.346806163424485e-24,  -2.609060554503461e-03,  -8.785830225733373e-05,  -9.226444155488240e-07,   2.481512108558753e-08,   1.114593902948009e-09,
   1.295697771235355e-11,  -3.256421704276776e-13,  -1.546926023870776e-14,  -1.892172081436822e-16,   4.372719834691858e-18,   2.172058828381073e-19,   2.813607797480650e-21,
  -5.367688338488189e-23,  -2.811144869384287e-24,  -1.399574327297795e-03,  -4.712869294396564e-05,  -4.948662532925322e-07,   1.331267890631632e-08,   5.978497201566888e-10,
   6.947368060783489e-12,  -1.747327298121127e-13,  -8.296602325508091e-15,  -1.014081727479595e-16,   2.347100142412372e-18,   1.164809782356597e-19,   1.507211118047657e-21,
  -2.882488132460782e-23,  -1.507310638585037e-24,  -5.208205235418455e-04,  -1.753776750188817e-05,  -1.841448844287341e-07,   4.954165850189102e-09,   2.224700061825141e-10,
   2.584904302307040e-12,  -6.502925187352014e-14,  -3.087195732853212e-15,  -3.772471500613357e-17,   8.736087695085773e-19,   4.334134845294210e-20,   5.606047512404961e-22,
  -1.073056128487558e-23,  -5.608256966016484e-25,  -5.883074233110153e-05,  -1.981025371445382e-06,  -2.080044735574408e-08,   5.596143425554927e-10,   2.512960674568926e-11,
   2.919778611450428e-13,  -7.345675163040959e-15,  -3.487192512784414e-16,  -4.261084314634271e-18,   9.868428878991696e-20,   4.895663521970365e-21,   6.331983442343564e-23,
  -1.212172698673869e-24,  -6.334808795442717e-26,  -2.434084788590688e-03,  -1.271523687823325e-04,  -4.143700036605141e-06,  -1.018601863274758e-07,  -1.903236676322550e-09,
  -2.225594683151263e-11,   1.113235108382029e-13,   1.571520704150701e-14,   5.457858277318429e-16,   1.273014426299713e-17,   2.019164159054058e-19,   1.120795894045310e-21,
  -5.719640618222171e-23,  -2.532897790278352e-24,  -2.315813794042135e-03,  -1.209767331899796e-04,  -3.942488473121028e-06,  -9.691225954827792e-08,  -1.810611225388595e-09,
  -2.116353451370468e-11,   1.063645724911327e-13,   1.496445111685506e-14,   5.195078233387889e-16,   1.211272166789397e-17,   1.919810339232459e-19,   1.060363107175397e-21,
  -5.458198852488966e-23,  -2.412880386538125e-24,  -2.090798733745765e-03,  -1.092262793922320e-04,  -3.559623386053878e-06,  -8.749806247057688e-08,  -1.634447752656878e-09,
  -1.908964491987552e-11,   9.674713374422055e-14,   1.353088840406619e-14,   4.694144601695355e-16,   1.093757883926306e-17,   1.731287326952790e-19,   9.478077798681791e-22,
  -4.954105538482206e-23,  -2.183297605335988e-24,  -1.780994607792102e-03,  -9.304599846426529e-05,  -3.032387338988181e-06,  -7.453533741893882e-08,  -1.392019762585252e-09,
  -1.624295223614940e-11,   8.315090018655193e-14,   1.154701417238369e-14,   4.002545072916379e-16,   9.318721085913205e-18,   1.472702476439713e-19,   7.975418183789376e-22,
  -4.247081145273303e-23,  -1.864793029538419e-24,  -1.416674610463247e-03,  -7.401586111264748e-05,  -2.412245624899826e-06,  -5.929017067883076e-08,  -1.107079922762707e-09,
  -1.290632025004124e-11,   6.671267739215652e-14,   9.201224593586766e-15,   3.186836068752533e-16,   7.413872052610890e-18,   1.169857439069266e-19,   6.267996065638349e-22,
  -3.399196596847229e-23,  -1.487192994114635e-24,  -1.033490809616921e-03,  -5.399792635744970e-05,  -1.759874364680760e-06,  -4.325433379771074e-08,  -8.075247220609466e-10,
  -9.407184180805181e-12,   4.900392114774125e-14,   6.722025632976902e-15,   2.326648254764087e-16,   5.409365770623704e-18,   8.524963399993355e-20,   4.527917537348036e-22,
  -2.492064321262537e-23,  -1.087202951577247e-24,  -6.689806673154565e-04,  -3.495380464087406e-05,  -1.139211135834275e-06,  -2.799905955941290e-08,  -5.226648666025254e-10,
  -6.085771553804057e-12,   3.186399277520011e-14,   4.355269145118632e-15,   1.506809708853200e-16,   3.501835449984332e-18,   5.514210759050607e-20,   2.911791525945633e-22,
  -1.618374984785277e-23,  -7.047179831702387e-25,  -3.588688970315968e-04,  -1.875089749990079e-05,  -6.111312442434100e-07,  -1.501997532978697e-08,  -2.803659558881531e-10,
  -3.263690189355619e-12,   1.713274599679543e-14,   2.337472808980725e-15,   8.085258786820100e-17,   1.878623164086390e-18,   2.956943162790812e-20,   1.556730023866519e-22,
  -8.696117098311714e-24,  -3.783068138387669e-25,  -1.335462130455261e-04,  -6.977818681949257e-06,  -2.274222930040967e-07,  -5.589413016668555e-09,  -1.043311447333393e-10,
  -1.214394461238305e-12,   6.380751803655298e-15,   8.699917920287507e-16,   3.009047820873678e-17,   6.991058899800362e-19,   1.100226444302079e-20,   5.786239183205428e-23,
  -3.237970281961614e-24,  -1.408142324064970e-25,  -1.508510692138939e-05,  -7.882006546337209e-07,  -2.568918297234523e-08,  -6.313689381540496e-10,  -1.178500218070718e-11,
  -1.371732620754787e-13,   7.208485731061354e-16,   9.827510731596853e-17,   3.399007774297326e-18,   7.896978774730996e-20,   1.242767541797890e-21,   6.534792181288364e-24,
  -3.657881283216746e-25,  -1.590670713632748e-26,  -2.640764765933080e-04,   9.352511925031467e-06,  -2.199191132940199e-07,   4.270303252066143e-09,  -7.422990689226796e-11,
   1.181901226257769e-12,  -1.799281476773708e-14,   2.520586603169526e-16,  -3.389330874425252e-18,   5.298313339943989e-20,  -2.671513257789681e-22,   8.916892659358326e-24,
  -2.402326638207357e-25,  -5.672328013259980e-27,  -2.512382674114898e-04,   8.897984204761373e-06,  -2.092354358527890e-07,   4.062946157151244e-09,  -7.062737443368353e-11,
   1.124570796013537e-12,  -1.712046180451240e-14,   2.398552498850713e-16,  -3.224833966056744e-18,   5.042047216845344e-20,  -2.546289942917993e-22,   8.470156043644990e-24,
  -2.286037135819438e-25,  -5.386281827704895e-27,  -2.268158776022600e-04,   8.033266071158801e-06,  -1.889084859747790e-07,   3.668386576342999e-09,  -6.377168657873086e-11,
   1.015457816688042e-12,  -1.546000069377510e-14,   2.166199167095740e-16,  -2.911796296621071e-18,   4.554009594672858e-20,  -2.306184120770466e-22,   7.625735328532937e-24,
  -2.064607104867563e-25,  -4.846330018387956e-27,  -1.931961743736738e-04,   6.842783023103926e-06,  -1.609203911339210e-07,   3.125044671146606e-09,  -5.432931151636509e-11,
   8.651525039131820e-13,  -1.317234733680612e-14,   1.845944774315599e-16,  -2.480653046887374e-18,   3.881141401276373e-20,  -1.971988539364489e-22,   6.473778586285206e-24,
  -1.759386966555396e-25,  -4.111160263246032e-27,  -1.536673004633030e-04,   5.442905608604981e-06,  -1.280051822933142e-07,   2.485956900591040e-09,  -4.322111763977348e-11,
   6.883007335113593e-13,  -1.048023258131650e-14,   1.468896372694737e-16,  -1.973453085605916e-18,   3.088696113327518e-20,  -1.574408773654805e-22,   5.132547715712322e-24,
  -1.400021997260872e-25,  -3.257029290119941e-27,  -1.120980816385767e-04,   3.970632390519151e-06,  -9.338374466518213e-08,   1.813652827809073e-09,  -3.153379434024377e-11,
   5.022010579258331e-13,  -7.646948413128142e-15,   1.071915438072318e-16,  -1.439813966824369e-18,   2.254129980320440e-20,  -1.151975519778360e-22,   3.734347984867155e-24,
  -1.021652684956992e-25,  -2.368347459854304e-27,  -7.255912759172929e-05,   2.570168448572975e-06,  -6.044814908552735e-08,   1.174024067850131e-09,  -2.041324621758983e-11,
   3.251068525049023e-13,  -4.950492923771647e-15,   6.939932632114055e-17,  -9.320556901668652e-19,   1.459473459919874e-20,  -7.471366685349387e-23,   2.413005474291568e-24,
  -6.614492305330419e-26,  -1.529739489272060e-27,  -3.892311501646143e-05,   1.378736431320313e-06,  -3.242707018768250e-08,   6.298069012308436e-10,  -1.095088365343897e-11,
   1.744093304984665e-13,  -2.655816614832853e-15,   3.723253302376767e-17,  -5.000101147210424e-19,   7.830239169932011e-21,  -4.011974012735486e-23,   1.293267539854027e-24,
  -3.548647071113894e-26,  -8.197080438063295e-28,  -1.448441667229808e-05,   5.130693929736826e-07,  -1.206713919397325e-08,   2.343721551803329e-10,  -4.075210877798740e-12,
   6.490421469954109e-14,  -9.883331733569389e-16,   1.385587732001607e-17,  -1.860714142830796e-19,   2.914006153485576e-21,  -1.493500783387279e-23,   4.811135758011866e-25,
  -1.320607781691069e-26,  -3.049212086749734e-28,  -1.636128667439279e-06,   5.795524954468247e-08,  -1.363079772797645e-09,   2.647422648558238e-11,  -4.603283494555291e-13,
   7.331467161350899e-15,  -1.116404814385977e-16,   1.565140517812240e-18,  -2.101828542289510e-20,   3.291625380430045e-22,  -1.687121345069554e-24,   5.434289389491808e-26,
  -1.491739848397154e-27,  -3.444116974356750e-29,  -2.308615395320204e-03,   7.688267881415879e-05,  -1.612090914835002e-06,   2.566761467074952e-08,  -3.167840520079251e-10,
   2.468047054651640e-12,   4.009825016658989e-15,  -7.317709274215256e-16,   1.796339452205389e-17,  -2.182328995313179e-19,   6.385204933917281e-21,  -6.394244104199809e-24,
  -1.636341778387894e-24,  -5.094067060969862e-26,  -2.196371591794602e-03,   7.314537065933443e-05,  -1.533734784379072e-06,   2.441986576742014e-08,  -3.013737255871285e-10,
   2.347542465351114e-12,   3.829787972778343e-15,  -6.964109989843308e-16,   1.709816518226266e-17,  -2.076295510803524e-19,   6.071404288797976e-21,  -6.199902115318630e-24,
  -1.557774907623979e-24,  -4.835601696447354e-26,  -1.982851678896005e-03,   6.603565715779777e-05,  -1.384669601470816e-06,   2.204620847150092e-08,  -2.720622837088668e-10,
   2.118515051402677e-12,   3.481249424774024e-15,  -6.290574702324215e-16,   1.544893385183348e-17,  -1.874563436107000e-19,   5.475826868445593e-21,  -5.782476236741249e-24,
  -1.407909627028164e-24,  -4.348331743932753e-26,  -1.688928897464593e-03,   5.624817088470911e-05,  -1.179454449585684e-06,   1.877857216595856e-08,  -2.317199906324505e-10,
   1.803646576499591e-12,   2.989713870998331e-15,  -5.361691749652349e-16,   1.317224461693523e-17,  -1.596814375133740e-19,   4.658621547976957e-21,  -5.115661529803111e-24,
  -1.200824506772430e-24,  -3.686100804684896e-26,  -1.343354046905087e-03,   4.474000538779660e-05,  -9.381532000980082e-07,   1.493650475092257e-08,  -1.842966248964629e-10,
   1.433953431406542e-12,   2.396909449176343e-15,  -4.267393301968326e-16,   1.048734169749950e-17,  -1.270184530561831e-19,   3.701154487821178e-21,  -4.215476296378758e-24,
  -9.563600947428191e-25,  -2.918259815418817e-26,  -9.799504808441946e-04,   3.263747306110839e-05,  -6.843814910821041e-07,   1.089603506922122e-08,  -1.344344796746210e-10,
   1.045661408188989e-12,   1.759626122154349e-15,  -3.114606016581725e-16,   7.656355719322033e-18,  -9.266335691921752e-20,   2.697416005376103e-21,  -3.160999688180673e-24,
  -6.983702920770687e-25,  -2.120819686209331e-26,  -6.343018372783971e-04,   2.112578680612145e-05,  -4.429934067232907e-07,   7.052842837572397e-09,  -8.701398346089199e-11,
   6.766728031837051e-13,   1.143730949981766e-15,  -2.016716072987222e-16,   4.958386196315855e-18,  -5.998165731511622e-20,   1.744910667902893e-21,  -2.082716577391217e-24,
  -4.523494556001302e-25,  -1.369347501166682e-26,  -3.402596590377760e-04,   1.133260393464687e-05,  -2.376377524956627e-07,   3.783386314252605e-09,  -4.667632224531545e-11,
   3.629440562567072e-13,   6.148454944327384e-16,  -1.082022179212764e-16,   2.660547589029783e-18,  -3.217678281419977e-20,   9.357303010435894e-22,  -1.127324593513206e-24,
  -2.427394781014045e-25,  -7.336211474785668e-27,  -1.266203527700845e-04,   4.217193968038406e-06,  -8.843206654192450e-08,   1.407908520913193e-09,  -1.736949848101710e-11,
   1.350560713708049e-13,   2.289715309949819e-16,  -4.026762224141879e-17,   9.901580337302244e-19,  -1.197399460678769e-20,   3.481737703203640e-22,  -4.208158232342033e-25,
  -9.034128390686578e-26,  -2.728796510563368e-27,  -1.430276180441375e-05,   4.763652708464199e-07,  -9.989100077401356e-09,   1.590343484994888e-10,  -1.962019339566062e-12,
   1.525553850574028e-14,   2.586717615379304e-17,  -4.548588195024635e-18,   1.118477667521803e-19,  -1.352558265457628e-21,   3.932827222276164e-23,  -4.755785508664232e-26,
  -1.020495323519121e-26,  -3.082171408835049e-28,  -6.014644281169036e-03,   1.730811341257410e-04,  -2.606499043459026e-06,   1.469065575630011e-08,   3.671332716564610e-10,
  -1.319162709665083e-11,   2.073130530484328e-13,  -1.479568795658708e-15,  -2.449269615437580e-17,   1.259769685413528e-18,  -9.949238041632698e-21,   2.141204022847773e-22,
  -2.740224128546102e-24,  -2.674868145379940e-25,  -5.722167393936211e-03,   1.646637133902232e-04,  -2.479652355322148e-06,   1.397217273168652e-08,   3.493681608717122e-10,
  -1.255089937478580e-11,   1.972088125947660e-13,  -1.406251418273178e-15,  -2.331471751888117e-17,   1.198838280706770e-18,  -9.470651950039082e-21,   2.030886720997394e-22,
  -2.604385459101425e-24,  -2.542228276998880e-25,  -5.165811835740909e-03,   1.486522977415485e-04,  -2.238402303412247e-06,   1.260713160089137e-08,   3.155393549705554e-10,
  -1.133178879100120e-11,   1.779977076529286e-13,  -1.267341944362090e-15,  -2.106865115919408e-17,   1.082798563551026e-18,  -8.558146321988090e-21,   1.823566002356765e-22,
  -2.347025118877764e-24,  -2.290965959233968e-25,  -4.399993109224808e-03,   1.266134476262596e-04,  -1.906401860014557e-06,   1.073140624410879e-08,   2.689051896135345e-10,
  -9.653102946660462e-12,   1.515720033666866e-13,  -1.077213393878896e-15,  -1.796669143469648e-17,   9.228109981234635e-19,  -7.297968559616222e-21,   1.543082458620929e-22,
  -1.994794368344367e-24,  -1.947133388926788e-25,  -3.499641991727655e-03,   1.007039259864798e-04,  -1.516177498118679e-06,   8.530274376969878e-09,   2.139912894383085e-10,
  -7.678774526654921e-12,   1.205271463708618e-13,  -8.550515079298039e-16,  -1.430679341948408e-17,   7.343913594258660e-19,  -5.811207314969915e-21,   1.219505706276704e-22,
  -1.583274882614902e-24,  -1.545460170264162e-25,  -2.552884812968158e-03,   7.345983171922268e-05,  -1.105932491045559e-06,   6.219518869542208e-09,   1.561654907743230e-10,
  -5.601991355763090e-12,   8.790371514386791e-14,  -6.227139514446676e-16,  -1.044610992230181e-17,   5.359573547876194e-19,  -4.242970783366092e-21,   8.850015464622488e-23,
  -1.152982072705892e-24,  -1.125465932852236e-25,  -1.652414762685867e-03,   4.754830974898856e-05,  -7.158092037554076e-07,   4.024419948325212e-09,   1.011096736792965e-10,
  -3.626257240789048e-12,   5.689036474575699e-14,  -4.026296090397531e-16,  -6.765653575941182e-18,   3.470136691684728e-19,  -2.748015448321939e-21,   5.708759037839269e-23,
  -7.454487821763408e-25,  -7.276719275081211e-26,  -8.864035956043656e-04,   2.550622245013174e-05,  -3.839722752307668e-07,   2.158455654738478e-09,   5.424586674036306e-11,
  -1.945295534497008e-12,   3.051562073099427e-14,  -2.158619926486973e-16,  -3.630441579811563e-18,   1.861765131771991e-19,  -1.474570899650627e-21,   3.056942656679532e-23,
  -3.996468955288538e-25,  -3.901208410815641e-26,  -3.298555927939027e-04,   9.491568899873188e-06,  -1.428857044794346e-07,   8.031750327158719e-10,   2.018740049559172e-11,
  -7.239073588176449e-13,   1.135545323013826e-14,  -8.031270779863462e-17,  -1.351137548724992e-18,   6.928514676740479e-20,  -5.487880382227440e-22,   1.136874347523835e-23,
  -1.486895039361823e-25,  -1.451459257888557e-26,  -3.725976622329216e-05,   1.072146672126906e-06,  -1.614003639710622e-08,   9.072405694846030e-11,   2.280342433970468e-12,
  -8.177114287686534e-14,   1.282682433664539e-15,  -9.071668471492907e-18,  -1.526242057504897e-19,   7.826364108020044e-21,  -6.199095251541788e-23,   1.284063002274930e-24,
  -1.679509791849642e-26,  -1.639484720852235e-27,  -1.051978038661801e-02,   2.227717384702558e-04,  -6.397647342029628e-07,  -6.473016969427399e-08,   1.458841723076780e-09,
  -6.285594047021053e-12,  -4.049821250285083e-13,   9.768338672090141e-15,  -5.202843703373432e-17,  -2.016880956252571e-18,   8.674581657778605e-20,  -2.866383454361288e-22,
  -2.520602297347152e-23,   6.887013436349831e-26,  -1.000811343637177e-02,   2.119302708128885e-04,  -6.083865811844627e-07,  -6.158352286081698e-08,   1.387702416074613e-09,
  -5.973772216493364e-12,  -3.853263093394062e-13,   9.291041624300443e-15,  -4.938210976480149e-17,  -1.919246303812723e-18,   8.247683112785613e-20,  -2.725311845543433e-22,
  -2.399636934463330e-23,   6.590957263834441e-26,  -9.034857476343180e-03,   1.913109216311422e-04,  -5.488074208057054e-07,  -5.559749048960152e-08,   1.252460857950540e-09,
  -5.383128353590622e-12,  -3.479212585352548e-13,   8.384046664021242e-15,  -4.439559278027107e-17,  -1.733343926082854e-18,   7.437687031599755e-20,  -2.457635849773857e-22,
  -2.168871950923033e-23,   6.011812296019138e-26,  -7.695270871387685e-03,   1.629353745524245e-04,  -4.670085142932010e-07,  -4.735696344732523e-08,   1.066459253113837e-09,
  -4.574976767804317e-12,  -2.964038852036929e-13,   7.137378217655126e-15,  -3.762346770809064e-17,  -1.477102776578161e-18,   6.326730891370141e-20,  -2.090499769511106e-22,
  -1.849951496372081e-23,   5.183826511529486e-26,  -6.120473780356934e-03,   1.295836816231577e-04,  -3.711072914675629e-07,  -3.766779806435790e-08,   8.479815985323885e-10,
  -3.631011136107192e-12,  -2.357990729247374e-13,   5.673988503942413e-15,  -2.977770365442219e-17,  -1.175407350488396e-18,   5.025677286460306e-20,  -1.660555076045311e-22,
  -1.473407219924976e-23,   4.171689607465654e-26,  -4.464616809180683e-03,   9.452101057411573e-05,  -2.705123651236782e-07,  -2.747828994988445e-08,   6.184287945606364e-10,
  -2.644127509958991e-12,  -1.720359509670598e-13,   4.137301664485582e-15,  -2.163560410989447e-17,  -8.577521270750125e-19,   3.662293600106262e-20,  -1.210039742451332e-22,
  -1.075977797239792e-23,   3.071566629164864e-26,  -2.889791113721700e-03,   6.117819650932547e-05,  -1.750102320858402e-07,  -1.778629035482910e-08,   4.002290383973609e-10,
  -1.709512223389275e-12,  -1.113660673774437e-13,   2.677236798542494e-15,  -1.396724316215439e-17,  -5.553401956695986e-19,   2.368884484212890e-20,  -7.826743032591918e-23,
  -6.969508683539306e-24,   2.000270871461919e-26,  -1.550158213105788e-03,   3.281701546699365e-05,  -9.385711991902879e-08,  -9.541174467091854e-09,   2.146770516212884e-10,
  -9.164920536586154e-13,  -5.974324739451655e-14,   1.435947242713452e-15,  -7.482272718584629e-18,  -2.979392589266069e-19,   1.270292153174126e-20,  -4.196968048865929e-23,
  -3.740019484722373e-24,   1.076338253244362e-26,  -5.768559416890517e-04,   1.221203199007827e-05,  -3.492382001823550e-08,  -3.550549549308007e-09,   7.988507317061620e-11,
  -3.409823751227574e-13,  -2.223255328218255e-14,   5.343301515162521e-16,  -2.783046754701663e-18,  -1.108765300038403e-19,   4.726533998077117e-21,  -1.561611445087210e-23,
  -1.391943368552310e-24,   4.009671104070886e-27,  -6.516036156658137e-05,   1.379442660720608e-06,  -3.944863791796548e-09,  -4.010625152453828e-10,   9.023602474775105e-12,
  -3.851536894412976e-14,  -2.511348085009525e-15,   6.035629874734292e-17,  -3.143432786257368e-19,  -1.252445975128268e-20,   5.338885674897821e-22,  -1.763926650192054e-24,
  -1.572340572674389e-25,   4.530010052029782e-28,  -1.430751709451316e-02,   1.342524112549234e-04,   4.746476560239554e-06,  -1.077666143387891e-07,  -8.638203299893788e-10,
   5.542500486723817e-11,  -2.819563800640412e-13,  -2.189436829586990e-14,   3.731898773211601e-16,   6.103454566671325e-18,  -1.938650534412282e-19,   8.320432259001987e-22,
   8.287949862471331e-23,  -2.264313136371096e-24,  -1.361145385973462e-02,   1.277127496279640e-04,   4.515451982378659e-06,  -1.025083748269659e-07,  -8.219283786794491e-10,
   5.271547590402855e-11,  -2.679327480838755e-13,  -2.082287765819912e-14,   3.547797540375127e-16,   5.807891386421331e-18,  -1.842738707876089e-19,   7.863832784605958e-22,
   7.874931736486337e-23,  -2.149629875267136e-24,  -1.228752017777300e-02,   1.152774698203322e-04,   4.076079843694794e-06,  -9.251329481764142e-08,  -7.421943368800358e-10,
   4.756719451358850e-11,  -2.413841772415978e-13,  -1.878743815117564e-14,   3.198667984781274e-16,   5.245152310345422e-18,  -1.660962758211839e-19,   7.016565345201841e-22,
   7.093360751948700e-23,  -1.933348427812807e-24,  -1.046539282764063e-02,   9.816932724669058e-05,   3.471457619118594e-06,  -7.876920542035920e-08,  -6.323515029360857e-10,
   4.049194661139634e-11,  -2.050871454884888e-13,  -1.599104926101099e-14,   2.720168812757923e-16,   4.469564182678535e-18,  -1.412045109423671e-19,   5.891434652276203e-22,
   6.025430143392551e-23,  -1.639256134652284e-24,  -8.323494209718750e-03,   7.806705630557836e-05,   2.760835603023709e-06,  -6.262845469667011e-08,  -5.030993040166095e-10,
   3.218809843309317e-11,  -1.627257872813951e-13,  -1.271022345804922e-14,   2.160232756292377e-16,   3.556501427328668e-18,  -1.121035468326090e-19,   4.620488681504544e-22,
   4.779863596362036e-23,  -1.298062108773691e-24,  -6.071499770065924e-03,   5.693918612897319e-05,   2.013787069409778e-06,  -4.567234488978785e-08,  -3.670799517631438e-10,
   2.346959326742810e-11,  -1.184715355442357e-13,  -9.266647200096177e-15,   1.573876595270342e-16,   2.595250482140947e-18,  -8.165478976004509e-20,   3.332165711490622e-22,
   3.479369331980208e-23,  -9.435199277623903e-25,  -3.929817646924571e-03,   3.685163104568081e-05,   1.303402438136152e-06,  -2.955683354011544e-08,  -2.376370081178910e-10,
   1.518668508295900e-11,  -7.658428576789489e-14,  -5.995881103493488e-15,   1.017895689295475e-16,   1.680214570674198e-18,  -5.280110920751256e-20,   2.140452513574250e-22,
   2.248942469794699e-23,  -6.092730612971252e-25,  -2.108040600364264e-03,   1.976730164762315e-05,   6.991642739389656e-07,  -1.585358900992370e-08,  -1.274853153255701e-10,
   8.145325578976706e-12,  -4.105473199934817e-14,  -3.215766906672645e-15,   5.457996472178476e-17,   9.014198679288367e-19,  -2.830977753833832e-20,   1.143696540563074e-22,
   1.205528218141000e-23,  -3.264349070041679e-25,  -7.844572314409478e-04,   7.355838004034569e-06,   2.601761507060255e-07,  -5.899362152987427e-09,  -4.744213351329753e-11,
   3.030940962177890e-12,  -1.527407739797605e-14,  -1.196599299631650e-15,   2.030776267490037e-17,   3.354569691482122e-19,  -1.053301154202817e-20,   4.250183211289198e-23,
   4.484981113934024e-24,  -1.214241723195873e-25,  -8.861050675962642e-05,   8.308970703237604e-07,   2.938888497121613e-08,  -6.663754210742723e-10,  -5.358982543882044e-12,
   3.423655445342719e-13,  -1.725262962249598e-15,  -1.351638485640939e-16,   2.293867213341604e-18,   3.789272553199531e-20,  -1.189752799549447e-21,   4.799868800844600e-24,
   5.065934587891444e-25,  -1.371488776830855e-26,  -1.512547272058319e-02,  -1.219958606446705e-04,   7.271258455697135e-06,   8.413360448668521e-08,  -3.614483981294773e-09,
  -5.333050757990773e-11,   1.794572839491489e-12,   3.102226038371883e-14,  -9.430213729559549e-16,  -1.784281631503264e-17,   5.601181242981797e-19,   1.289577586146769e-20,
  -2.790155353867906e-22,  -8.904378023034123e-24,  -1.438954951318659e-02,  -1.160544682755354e-04,   6.916939246795012e-06,   8.002552240935802e-08,  -3.437876989497580e-09,
  -5.071721524876053e-11,   1.706503480398459e-12,   2.949437408974319e-14,  -8.964075910697920e-16,  -1.695404499329234e-17,   5.323293498442208e-19,   1.224808229742030e-20,
  -2.651718801586487e-22,  -8.455796327781821e-24,  -1.298982789332622e-02,  -1.047563079213768e-04,   6.243245521396868e-06,   7.221791400779822e-08,  -3.102275068502207e-09,
  -4.575428998778275e-11,   1.539303792207187e-12,   2.659589600785686e-14,  -8.080466828807681e-16,  -1.527203861620428e-17,   4.796939860993130e-19,   1.102445266367427e-20,
  -2.389507299440559e-22,  -7.608874049985086e-24,  -1.106344600095384e-02,  -8.921161577586362e-05,   5.316492418742947e-06,   6.148411878670532e-08,  -2.640987441811094e-09,
  -3.893861814654439e-11,   1.309789267733040e-12,   2.262144926744012e-14,  -6.870163347429229e-16,  -1.297346305667104e-17,   4.076773918318499e-19,   9.356425477239785e-21,
  -2.030753395489323e-22,  -6.455418103759985e-24,  -8.799062978055362e-03,  -7.094518944442204e-05,   4.227670030171104e-06,   4.888154188043910e-08,  -2.099506586706245e-09,
  -3.094554380462486e-11,   1.040757406393931e-12,   1.796810618801869e-14,  -5.454794774955908e-16,  -1.029215304441036e-17,   3.235597446205770e-19,   7.415917494416914e-21,
  -1.611727755148191e-22,  -5.114869540586420e-24,  -6.418349935256590e-03,  -5.174568103655305e-05,   3.083412047129977e-06,   3.564508896552894e-08,  -1.530900797040575e-09,
  -2.255903476592700e-11,   7.586054162978400e-13,   1.309287144024813e-14,  -3.973500845576754e-16,  -7.492213520027671e-18,   2.356184472076731e-19,   5.394477226887200e-21,
  -1.173664128281234e-22,  -3.719652143673692e-24,  -4.154297587402937e-03,  -3.349073335880990e-05,   1.995576842681187e-06,   2.306675963217084e-08,  -9.906435585475578e-10,
  -1.459553108981093e-11,   4.907703970439251e-13,   8.468547323536936e-15,  -2.569544665837871e-16,  -4.842846048389441e-18,   1.523349047054578e-19,   3.485205207894844e-21,
  -7.588085792799017e-23,  -2.402725435976248e-24,  -2.228450769828438e-03,  -1.796461638309028e-05,   1.070421271950661e-06,   1.237220725632628e-08,  -5.313363589565115e-10,
  -7.827725065325404e-12,   2.631934261341733e-13,   4.541091023068081e-15,  -1.377718842113088e-16,  -2.596009582494319e-18,   8.166880177459894e-20,   1.867777818503296e-21,
  -4.068067098297006e-23,  -1.287541859952778e-24,  -8.292642635031977e-04,  -6.685034064331737e-06,   3.983253683375395e-07,   4.603853381622739e-09,  -1.977155745998942e-10,
  -2.912689704985004e-12,   9.793255578486380e-14,   1.689648865059565e-15,  -5.126022796121077e-17,  -9.658103059082960e-19,   3.038501953285088e-20,   6.948209063205351e-22,
  -1.513530361115839e-23,  -4.789555599172974e-25,  -9.367179382958725e-05,  -7.551249855436043e-07,   4.499381256443873e-08,   5.200377784428561e-10,  -2.233334747228104e-11,
  -3.290070081878196e-13,   1.106208442117485e-14,   1.908551283465300e-16,  -5.790090027916640e-18,  -1.090915622224877e-19,   3.432113714573097e-21,   7.848130047838183e-23,
  -1.709594994110744e-24,  -5.409863936446432e-26,  -1.082203883978853e-02,  -3.413569823705140e-04,  -1.868997743694708e-06,   1.606931574862426e-07,   4.592331973994550e-09,
  -1.530528580122740e-12,  -2.941691204053666e-12,  -6.301803129316237e-14,   5.104224620521398e-16,   5.192987209066964e-17,   8.409924163068620e-19,  -1.331958751882527e-20,
  -7.932243224877108e-22,  -9.010840873168127e-24,  -1.029570566333402e-02,  -3.247389350767384e-04,  -1.777273104061642e-06,   1.528764140536538e-07,   4.367649242270766e-09,
  -1.495166012446261e-12,  -2.798175118324232e-12,  -5.989738549774661e-14,   4.867078352284223e-16,   4.938201132711084e-17,   7.985380786261329e-19,  -1.269216241693837e-20,
  -7.539023809741068e-22,  -8.539280234532639e-24,  -9.294538340606975e-03,  -2.931353556504366e-04,  -1.603134444160182e-06,   1.380083022844642e-07,   3.940810081353211e-09,
  -1.411969411857333e-12,  -2.525365307329101e-12,  -5.398412575617885e-14,   4.411449011866411e-16,   4.454457781292699e-17,   7.184164032335926e-19,  -1.149031307545217e-20,
  -6.794072711163334e-22,  -7.655925676935206e-24,  -7.916506865444371e-03,  -2.496480543459255e-04,  -1.364096497229280e-06,   1.175445400697399e-07,   3.354349161832783e-09,
  -1.266613097197843e-12,  -2.150213457314507e-12,  -4.588893472946452e-14,   3.775534374283211e-16,   3.790369569142839e-17,   6.093603983406929e-19,  -9.819896227938493e-21,
  -5.774553761976656e-22,  -6.466392800709593e-24,  -6.296479485378544e-03,  -1.985399628625815e-04,  -1.083904487893279e-06,   9.348852352125762e-08,   2.666230021099032e-09,
  -1.056760273224145e-12,  -1.709626631298694e-12,  -3.642775433646560e-14,   3.016881862590502e-16,   3.011880733475944e-17,   4.827013085816609e-19,  -7.835839852877812e-21,
  -4.583414898771781e-22,  -5.101179569426901e-24,  -4.593031379148184e-03,  -1.448150664289665e-04,  -7.900516817721528e-07,   6.819509262966905e-08,   1.943917072520768e-09,
  -7.998315063382669e-13,  -1.246769517064686e-12,  -2.653118689934701e-14,   2.208886315654671e-16,   2.195380908760031e-17,   3.509608797563237e-19,  -5.730838851788450e-21,
  -3.337867345493611e-22,  -3.696518121301954e-24,  -2.972920571574143e-03,  -9.372899920351049e-05,  -5.111125444959858e-07,   4.414001692966161e-08,   1.257810524822972e-09,
  -5.300845099887675e-13,  -8.068499782959839e-13,  -1.715507389720780e-14,   1.433238158353299e-16,   1.420285437120254e-17,   2.266739485283710e-19,  -3.715740274877449e-21,
  -2.158117595534088e-22,  -2.382136634606551e-24,  -1.594754068216178e-03,  -5.027733401587050e-05,  -2.741021737626227e-07,   2.367775793205079e-08,   6.746063726799497e-10,
  -2.877601841895720e-13,  -4.327763019329539e-13,  -9.197564057313381e-15,   7.697898072821192e-17,   7.616823512423365e-18,   1.214585881762672e-19,  -1.994969220871971e-21,
  -1.157017202376795e-22,  -1.274952079700853e-24,  -5.934516682757678e-04,  -1.870939085267574e-05,  -1.019915679800847e-07,   8.811125752516386e-09,   2.510243785744816e-10,
  -1.075248506801575e-13,  -1.610427845059832e-13,  -3.422033996060172e-15,   2.865844858319401e-17,   2.834173759403734e-18,   4.518053701608205e-20,  -7.426087297535663e-22,
  -4.304729693858924e-23,  -4.740704774089355e-25,  -6.703498500025201e-05,  -2.113368053402606e-06,  -1.152057369988586e-08,   9.952849383712574e-10,   2.835488618544624e-11,
  -1.215368038555529e-14,  -1.819094398460802e-14,  -3.865340556098372e-16,   3.237418166450138e-18,   3.201374162763851e-19,   5.103179107218969e-21,  -8.388748668061225e-23,
  -4.862375193835439e-24,  -5.354324530672829e-26,  -3.017507993040204e-03,  -1.657409167674504e-04,  -5.562444467986948e-06,  -1.355366620311489e-07,  -2.273792112821749e-09,
  -1.184996030203436e-11,   8.760918500576640e-13,   4.209613275590933e-14,   1.149586923399557e-15,   2.036150221336721e-17,   1.248576073530893e-19,  -6.620042323215018e-21,
  -3.114195083609547e-22,  -7.861277623097462e-24,  -2.870901376915423e-03,  -1.576913190302965e-04,  -5.292289967945179e-06,  -1.289475558663979e-07,  -2.162799752952820e-09,
  -1.124719021550656e-11,   8.344363367313367e-13,   4.007027954349617e-14,   1.093832649511169e-15,   1.936011216475523e-17,   1.181696812273743e-19,  -6.316293859859347e-21,
  -2.966087423863426e-22,  -7.480608569406693e-24,  -2.591971581422481e-03,  -1.423751586704823e-04,  -4.778261012350333e-06,  -1.164129213275856e-07,  -1.951839431564626e-09,
  -1.011135830420837e-11,   7.548136978395434e-13,   3.620803462663209e-14,   9.877147225217609e-16,   1.745978447589188e-17,   1.056974628258600e-19,  -5.731116514419293e-21,
  -2.682995224203631e-22,  -6.755806597450850e-24,  -2.207926874997380e-03,  -1.212847410207319e-04,  -4.070441876032938e-06,  -9.915775412250706e-08,  -1.661787676345996e-09,
  -8.568794424406380e-12,   6.444678300376748e-13,   3.087498045290975e-14,   8.415271491237919e-16,   1.485283677546272e-17,   8.901456857010946e-20,  -4.911309576535233e-21,
  -2.290692516896333e-22,  -5.756826106128663e-24,  -1.756289664498048e-03,  -9.647940140213464e-05,  -3.237946927683894e-06,  -7.886965812182794e-08,  -1.321204997177007e-09,
  -6.781729327941052e-12,   5.137928032170759e-13,   2.458393883218635e-14,   6.695120609343239e-16,   1.179917228931434e-17,   7.001628611317244e-20,  -3.929357533916418e-21,
  -1.826154873364146e-22,  -4.580761849258665e-24,  -1.281255782072946e-03,  -7.038627186401853e-05,  -2.362233698281004e-06,  -5.753430811213984e-08,  -9.634630121974279e-10,
  -4.927272524650116e-12,   3.755015886268138e-13,   1.794897221688143e-14,   4.884958912179653e-16,   8.598660885810383e-18,   5.061374816460527e-20,  -2.879884190598885e-21,
  -1.334587986039914e-22,  -3.342642537726806e-24,  -8.293634467778476e-04,  -4.556234253859525e-05,  -1.529117243718534e-06,  -3.724096143324639e-08,  -6.234885088053784e-10,
  -3.180822136985353e-12,   2.433538010327749e-13,   1.162461436508555e-14,   3.162358820268802e-16,   5.562048484073236e-18,   3.256356956889482e-20,  -1.869862455508920e-21,
  -8.648953807939850e-23,  -2.164073370981928e-24,  -4.449059595298796e-04,  -2.444184659688257e-05,  -8.202923711151050e-07,  -1.997728539483568e-08,  -3.344200940664220e-10,
  -1.703951840022418e-12,   1.306251737618379e-13,   6.237633632241033e-15,   1.696506484726204e-16,   2.982642131269411e-18,   1.741365002020996e-20,  -1.004643970352434e-21,
  -4.642447482297585e-23,  -1.161000421510080e-24,  -1.655634076506932e-04,  -9.095608545872055e-06,  -3.052575333115726e-07,  -7.434125886251234e-09,  -1.244422373326130e-10,
  -6.337858214090275e-13,   4.862004487929265e-14,   2.321437753790310e-15,   6.313336912092409e-17,   1.109794604358446e-18,   6.473058811224586e-21,  -3.740627520431381e-22,
  -1.727959618662694e-23,  -4.320572966026853e-25,  -1.870170626943084e-05,  -1.027422073951751e-06,  -3.448129094856680e-08,  -8.397429339777130e-10,  -1.405663612557735e-11,
  -7.158564007355265e-14,   5.492206804508579e-15,   2.622288262869685e-16,   7.131436184240008e-18,   1.253576396706821e-19,   7.310562229260788e-22,  -4.225701364766355e-23,
  -1.951932589036447e-24,  -4.880454320680736e-26,  -2.298869058826890e-04,   7.779598189170032e-06,  -1.750914183859254e-07,   3.250467378663546e-09,  -5.439456971216872e-11,
   8.242128859475125e-13,  -1.217828907971701e-14,   1.725776756400044e-16,  -1.618230713036359e-18,   4.573204430104509e-20,  -2.266108228603606e-22,  -8.885935887954179e-24,
  -4.566496790065630e-25,  -4.723768401364803e-28,  -2.187103507459470e-04,   7.401486347997406e-06,  -1.665846302321064e-07,   3.092608943635961e-09,  -5.175423596535129e-11,
   7.842308746537271e-13,  -1.158728194428726e-14,   1.642322865445182e-16,  -1.539829864505888e-18,   4.349308376757294e-20,  -2.164782536486918e-22,  -8.454687819238235e-24,
  -4.338841832274947e-25,  -4.399171931623289e-28,  -1.974491584078934e-04,   6.682156893792776e-06,  -1.503998098698940e-07,   2.792244672110155e-09,  -4.672981410819219e-11,
   7.081367261110611e-13,  -1.046257169558577e-14,   1.483385383465091e-16,  -1.390578063187901e-18,   3.924023496064487e-20,  -1.968417796548725e-22,  -7.633981990444338e-24,
  -3.908076190943612e-25,  -3.820593189255961e-28,  -1.681815244862391e-04,   5.691856026494772e-06,  -1.281156599725456e-07,   2.378635392434777e-09,  -3.981000749161444e-11,
   6.033170638945910e-13,  -8.913478193152583e-15,   1.264241558101888e-16,  -1.184907517253756e-18,   3.339814650207120e-20,  -1.691117822682413e-22,  -6.503586478162668e-24,
  -3.319551448368509e-25,  -3.099264725639810e-28,  -1.337701497240092e-04,   4.527397831852088e-06,  -1.019093769741259e-07,   1.892163718137132e-09,  -3.166986344841397e-11,
   4.799864274602089e-13,  -7.091063776148350e-15,   1.006135298399098e-16,  -9.428170989435607e-19,   2.654486481329237e-20,  -1.356259120682750e-22,  -5.173771532772924e-24,
  -2.633222533965511e-25,  -2.345809090115669e-28,  -9.758303278794584e-05,   3.302743855961924e-06,  -7.434541979547575e-08,   1.380428803275518e-09,  -2.310575128301722e-11,
   3.502084094886316e-13,  -5.173608494809175e-15,   7.342922941185030e-17,  -6.879766619140307e-19,   1.935242587301826e-20,  -9.959151119660187e-23,  -3.774672410703910e-24,
  -1.916712086324422e-25,  -1.641300414424550e-28,  -6.316363462677316e-05,   2.137839284913371e-06,  -4.812419979645635e-08,   8.935798755962120e-10,  -1.495724991220280e-11,
   2.267116823725849e-13,  -3.349119795769226e-15,   4.754361161371594e-17,  -4.454033365211021e-19,   1.252149510811900e-20,  -6.474340184598308e-23,  -2.443478951078491e-24,
  -1.238865706440048e-25,  -1.032534636387292e-28,  -3.388301905393360e-05,   1.146816201781783e-06,  -2.581588293360479e-08,   4.793602404570789e-10,  -8.023921853718625e-12,
   1.216233302319540e-13,  -1.796670471333883e-15,   2.550786395107067e-17,  -2.389533927134962e-19,   6.715568834495763e-21,  -3.480746208556470e-23,  -1.310816859256927e-24,
  -6.640761229305416e-26,  -5.456725146673978e-29,  -1.260884565922944e-05,   4.267645766880211e-07,  -9.606897594821808e-09,   1.783856793792203e-10,  -2.985979788425517e-12,
   4.526055412591506e-14,  -6.686049397179404e-16,   9.492718737508848e-18,  -8.892462021156656e-20,   2.498879252179948e-21,  -1.296282823241171e-23,  -4.877997894798191e-25,
  -2.470581696181809e-26,  -2.019973232640621e-29,  -1.424268085522035e-06,   4.820643183117878e-08,  -1.085175658563492e-09,   2.015009761734673e-11,  -3.372907102798985e-13,
   5.112553052338888e-15,  -7.552439451456991e-17,   1.072286216317821e-18,  -1.004479106468536e-20,   2.822648526494399e-22,  -1.464431902890349e-24,  -5.510094277551667e-26,
  -2.790601861620472e-27,  -2.279813027516251e-30,  -2.025044089143190e-03,   6.513558702940242e-05,  -1.332861349372697e-06,   2.099331237165744e-08,  -2.678092295218013e-10,
   2.377821650039249e-12,  -9.273471159914241e-15,  -2.356765624439133e-16,   1.435590025722599e-17,  -1.011946805689643e-21,   3.460061565046439e-21,  -1.440833185769786e-22,
  -3.724607724214473e-24,  -7.509250121588617e-27,  -1.926584973132366e-03,   6.196924434316343e-05,  -1.268078315479605e-06,   1.997289720640447e-08,  -2.547869898880741e-10,
   2.262016467428851e-12,  -8.810429945923008e-15,  -2.242158815993895e-16,   1.366219444642051e-17,  -1.198474912587556e-21,   3.284511689576283e-21,  -1.370911992171517e-22,
  -3.538325208783471e-24,  -7.050183607190159e-27,  -1.739288472972503e-03,   5.594574116500470e-05,  -1.144834242760381e-06,   1.803166501884739e-08,  -2.300155485326642e-10,
   2.041801726739694e-12,  -7.934535785316872e-15,  -2.024156223382638e-16,   1.234081675643594e-17,  -1.457488167283756e-21,   2.953557148080249e-21,  -1.237845375199777e-22,
  -3.186082705894679e-24,  -6.215395356795671e-27,  -1.481465674686507e-03,   4.765362372681691e-05,  -9.751656747630905e-07,   1.535923132308694e-08,  -1.959173544788615e-10,
   1.738818103065980e-12,  -6.738404264641933e-15,  -1.724083436632302e-16,   1.051848215383609e-17,  -1.628234601997048e-21,   2.503765166118042e-21,  -1.054564822664503e-22,
  -2.705302568033099e-24,  -5.140605335950297e-27,  -1.178337194355813e-03,   3.790378569273801e-05,  -7.756606414016678e-07,   1.221689230808488e-08,  -1.558284455527096e-10,
   1.382786298613261e-12,  -5.344217174454440e-15,  -1.371298683770051e-16,   8.371644260245990e-18,  -1.593754620603256e-21,   1.982233023047796e-21,  -8.389454921422459e-23,
  -2.145213388922312e-24,  -3.970622192295470e-27,  -8.595721180245283e-04,   2.765045613718421e-05,  -5.658441854285495e-07,   8.912184454640907e-09,  -1.136726802709052e-10,
   1.008569198543773e-12,  -3.889431788766268e-15,  -1.000327849966066e-16,   6.110096516967218e-18,  -1.338139811328997e-21,   1.440584023058608e-21,  -6.120847517360498e-23,
  -1.561046272562911e-24,  -2.827236466585417e-27,  -5.563826237677090e-04,   1.789773814116843e-05,  -3.662657156621574e-07,   5.768759920265552e-09,  -7.357751261152206e-11,
   6.527635581104751e-13,  -2.513669228022387e-15,  -6.474891005264382e-17,   3.956282873059547e-18,  -9.412273894650089e-22,   9.301468367644559e-22,  -3.962279812278645e-23,
  -1.008790482224378e-24,  -1.800448060605495e-27,  -2.984611052313543e-04,   9.600960930974906e-06,  -1.964783262554625e-07,   3.094569744750430e-09,  -3.946918284402940e-11,
   3.501458711623958e-13,  -1.347342987647140e-15,  -3.473331291323992e-17,   2.122645291251983e-18,  -5.255870788066759e-22,   4.983234299616023e-22,  -2.125596699030070e-23,
  -5.406950133359826e-25,  -9.576825526427153e-28,  -1.110658877331661e-04,   3.572798109728910e-06,  -7.311543359841235e-08,   1.151580987808307e-09,  -1.468759481174143e-11,
   1.302970619676778e-13,  -5.012463939213232e-16,  -1.292525229278754e-17,   7.899448602534424e-19,  -1.982649014516654e-22,   1.853579408564197e-22,  -7.910087381758148e-24,
  -2.011495221173020e-25,  -3.553279648024472e-28,  -1.254576250798565e-05,   4.035756701475234e-07,  -8.258965681414843e-09,   1.300801581570496e-10,  -1.659078705972231e-12,
   1.471803491244843e-14,  -5.661722879759135e-17,  -1.460008484014922e-18,   8.923132385419498e-20,  -2.244359467067129e-23,   2.093615502091497e-23,  -8.935087996911319e-25,
  -2.272036635951266e-26,  -4.011820627748329e-29,  -5.362790574795461e-03,   1.530157839767608e-04,  -2.402838363294472e-06,   1.870929796715748e-08,   1.494115734761456e-10,
  -8.762270370527611e-12,   1.612696805079610e-13,  -1.600328557816846e-15,   1.527154688345491e-17,   9.658740149765707e-19,  -7.799791704211974e-21,  -1.964686105406971e-22,
  -1.251136438338601e-23,  -5.227365721045699e-26,  -5.102014069326833e-03,   1.455747094438612e-04,  -2.285936684835180e-06,   1.779666346792221e-08,   1.422161117531261e-10,
  -8.337064921094452e-12,   1.534381215893400e-13,  -1.521456514689844e-15,   1.451810039754565e-17,   9.185712046359046e-19,  -7.444754125079177e-21,  -1.870302658877197e-22,
  -1.188462290085318e-23,  -4.949015779987858e-26,  -4.605958659688024e-03,   1.314202680863838e-04,  -2.063587364998519e-06,   1.606178912524330e-08,   1.285002875819186e-10,
  -7.527871084370187e-12,   1.385364566966431e-13,  -1.371852716229052e-15,   1.308923691909011e-17,   8.287266786713928e-19,  -6.759487442701447e-21,  -1.690287568581737e-22,
  -1.069990467853557e-23,  -4.429441628474974e-26,  -3.923140695447917e-03,   1.119370395103692e-04,  -1.757570906502518e-06,   1.367599440828766e-08,   1.095653678122151e-10,
  -6.413326904884720e-12,   1.180160922680509e-13,  -1.166754136895891e-15,   1.113091194161772e-17,   7.053201049378698e-19,  -5.797064418315346e-21,  -1.441581152465110e-22,
  -9.083633542723474e-24,  -3.733377101087834e-26,  -3.120368808795342e-03,   8.903147102178894e-05,  -1.397853754062411e-06,   1.087392655425666e-08,   8.723423559196423e-11,
  -5.102109984351617e-12,   9.388033911091606e-14,  -9.266752533441048e-16,   8.839384760664289e-18,   5.605686766002656e-19,  -4.641393756794682e-21,  -1.148034807643249e-22,
  -7.201727354298992e-24,  -2.939109739894542e-26,  -2.276218081527457e-03,   6.494558397336884e-05,  -1.019649742905600e-06,   7.930084857396644e-09,   6.368693495884679e-11,
  -3.722491504493284e-12,   6.849075825887127e-14,  -6.752001462228337e-16,   6.439896884774839e-18,   4.086683446398510e-19,  -3.403683586106275e-21,  -8.382974561260316e-23,
  -5.239850322292203e-24,  -2.126229952458624e-26,  -1.473336473558250e-03,   4.203745984764453e-05,  -6.599738841367499e-07,   5.132026647837514e-09,   4.124517407316855e-11,
  -2.409749711924319e-12,   4.433560596182398e-14,  -4.367048635026211e-16,   4.164870910154719e-18,   2.644132941837306e-19,  -2.210770690865086e-21,  -5.429655657581120e-23,
  -3.385806407632198e-24,  -1.368672636110388e-26,  -7.903409751463651e-04,   2.255009577750257e-05,  -3.540242189096089e-07,   2.752719184806641e-09,   2.213126266655110e-11,
  -1.292737172480043e-12,   2.378383816153923e-14,  -2.341691775605042e-16,   2.233191817665650e-18,   1.418095634461858e-19,  -1.188029560222185e-21,  -2.913609215936644e-23,
  -1.814645832613777e-24,  -7.321108794380946e-27,  -2.941080296647343e-04,   8.391518448346730e-06,  -1.317416660209249e-07,   1.024331493778563e-09,   8.236458362238725e-12,
  -4.810736589754847e-13,   8.850751498568270e-15,  -8.712898110064561e-17,   8.309078947215906e-19,   5.276749243713183e-20,  -4.423719296886274e-22,  -1.084362745637319e-23,
  -6.750733636267977e-25,  -2.721690544860460e-27,  -3.322180017566695e-05,   9.478875056092658e-07,  -1.488123864480555e-08,   1.157056645154430e-10,   9.303865873443890e-13,
  -5.434120684456238e-14,   9.997636705096501e-16,  -9.841685359980842e-18,   9.385529180006883e-20,   5.960432114898551e-21,  -4.997425616114444e-23,  -1.224895228202653e-24,
  -7.625109757326212e-26,  -3.073878407115664e-28,  -9.643305340564417e-03,   2.149308379472362e-04,  -1.282092570242449e-06,  -4.283351559897480e-08,   1.256915815394451e-09,
  -1.295528563202507e-11,  -1.611648481363440e-13,   7.565617471084385e-15,  -6.842726500397276e-17,   8.483157550457347e-19,   4.778324155012604e-20,  -1.484140884986993e-21,
  -2.440155806965676e-23,   1.097225736708618e-25,  -9.174289574720799e-03,   2.044727034140614e-04,  -1.219507133036435e-06,  -4.075391632235324e-08,   1.195706927658467e-09,
  -1.232040864563880e-11,  -1.533823346616086e-13,   7.198514603695275e-15,  -6.503540195975372e-17,   8.046291757399039e-19,   4.541143786873679e-20,  -1.411686546828759e-21,
  -2.319049280358116e-23,   1.051818675378823e-25,  -8.282153206768981e-03,   1.845817046987092e-04,  -1.100553631904701e-06,  -3.679672193126779e-08,   1.079309969557201e-09,
  -1.111472161431609e-11,  -1.385560372648603e-13,   6.499877605709934e-15,  -5.860960806111719e-17,   7.225182935160686e-19,   4.091941601763370e-20,  -1.273975466899437e-21,
  -2.089678142952285e-23,   9.621853775865649e-26,  -7.054203052230542e-03,   1.572071097355807e-04,  -9.370047540541211e-07,  -3.134708537199937e-08,   9.191600780384687e-10,
  -9.458960764506470e-12,  -1.181047163817605e-13,   5.537580447112906e-15,  -4.981541862509604e-17,   6.114134163248430e-19,   3.477426198213585e-20,  -1.084639023286646e-21,
  -1.775885017454672e-23,   8.325143848935731e-26,  -5.610623375185555e-03,   1.250301621258659e-04,  -7.449650150088711e-07,  -2.493682596274803e-08,   7.309645176207628e-10,
  -7.517213844391495e-12,  -9.400630444746020e-14,   4.405444212715856e-15,  -3.954059076005595e-17,   4.832201220261934e-19,   2.759767908881957e-20,  -8.623260659726502e-22,
  -1.409408411108387e-23,   6.721418010280419e-26,  -4.092718742423520e-03,   9.120087866013172e-05,  -5.432508560957484e-07,  -1.819311424177334e-08,   5.331511117375096e-10,
  -5.479939370355600e-12,  -6.861520695315239e-14,   3.214222636522163e-15,  -2.879595633329184e-17,   3.506837833667083e-19,   2.009595373138565e-20,  -6.288233485791216e-22,
  -1.026311789362107e-23,   4.961552231060712e-26,  -2.649081026721743e-03,   5.902981527786187e-05,  -3.515553546287559e-07,  -1.177696482646354e-08,   3.450664624967964e-10,
  -3.545460744071555e-12,  -4.443007214414396e-14,   2.080729436953187e-15,  -1.861846448560964e-17,   2.262139369236350e-19,   1.299230934604613e-20,  -4.069270152201674e-22,
  -6.635314279487909e-24,   3.236436737422311e-26,  -1.421036952656440e-03,   3.166474063172931e-05,  -1.885634862802502e-07,  -6.317795705551433e-09,   1.850959874743686e-10,
  -1.901459334439875e-12,  -2.383834350707255e-14,   1.116232366499305e-15,  -9.981873126736800e-18,   1.211344646584445e-19,   6.965250405373197e-21,  -2.182616557405178e-22,
  -3.557248736429489e-24,   1.742984772602334e-26,  -5.288066515713716e-04,   1.178326153734617e-05,  -7.016702109883152e-08,  -2.351065870889190e-09,   6.887839448048621e-11,
  -7.075306216412262e-13,  -8.871530530745567e-15,   4.153901459746509e-16,  -3.713807262618071e-18,   4.504989909770886e-20,   2.591420259979753e-21,  -8.121791357865922e-23,
  -1.323476333939052e-24,   6.495021135536670e-27,  -5.973282505537069e-05,   1.331010105421321e-06,  -7.925864265229047e-09,  -2.655719251435215e-10,   7.780334772471753e-12,
  -7.992011421173571e-14,  -1.002119715798421e-15,   4.692172054929585e-17,  -4.194905112095759e-19,   5.088242868067653e-21,   2.927114062817592e-22,  -9.174137627077459e-24,
  -1.494920537900330e-25,   7.338226460059540e-28,  -1.370297886720455e-02,   1.668973956638896e-04,   3.405233537750180e-06,  -1.132694702545733e-07,   1.350034116345717e-10,
   4.280331380488997e-11,  -7.047688852370810e-13,  -7.810367311478378e-15,   4.694267785348857e-16,  -2.118924153669778e-19,  -1.159649700366665e-19,   1.667907822345766e-21,
  -4.378224281474883e-23,  -1.799352195144424e-24,  -1.303636018416553e-02,   1.587693732631938e-04,   3.239625172075728e-06,  -1.077472954795598e-07,   1.281240032477974e-10,
   4.071646929950249e-11,  -6.700988187100741e-13,  -7.430676816696439e-15,   4.464378743771433e-16,  -1.988981841900473e-19,  -1.104088742253115e-19,   1.582647687939268e-21,
  -4.152418952427097e-23,  -1.708883249179527e-24,  -1.176841726001262e-02,   1.433130536681462e-04,   2.924609787483957e-06,  -9.724866296505082e-08,   1.151659671567258e-10,
   3.674903731873496e-11,  -6.043110771647819e-13,  -6.708373940197756e-15,   4.027735616047636e-16,  -1.752834300135518e-19,  -9.980586796739268e-20,   1.422162381827047e-21,
  -3.728166037684200e-23,  -1.538004689178019e-24,  -1.002332335176377e-02,   1.220471985479121e-04,   2.491009858587430e-06,  -8.280855361915773e-08,   9.757749868182653e-11,
   3.129217910365685e-11,  -5.140694425069840e-13,  -5.714041349605217e-15,   3.427974487390077e-16,  -1.449075435696981e-19,  -8.514517399163334e-20,   1.204539092411161e-21,
  -3.154387676709819e-23,  -1.305138873802829e-24,  -7.971943458640654e-03,   9.705774029860333e-05,   1.981259332932600e-06,  -6.584586678273788e-08,   7.721300146154830e-11,
   2.488212329042225e-11,  -4.083729401466112e-13,  -4.544926628383403e-15,   2.724468098240755e-16,  -1.118771012256270e-19,  -6.782632053949685e-20,   9.528275189802672e-22,
  -2.492677618962984e-23,  -1.034327949782428e-24,  -5.815089201425514e-03,   7.079164126713330e-05,   1.445254349580635e-06,  -4.802206264200164e-08,   5.609107652833332e-11,
   1.814672897140330e-11,  -2.975994356852840e-13,  -3.315459428437002e-15,   1.986209879150290e-16,  -7.963152472078465e-20,  -4.953819421058029e-20,   6.919908299556340e-22,
  -1.808810865522268e-23,  -7.523136232461580e-25,  -3.763864949997594e-03,   4.581766578343587e-05,   9.354682628691250e-07,  -3.107890250583625e-08,   3.620644592383267e-11,
   1.174416923716161e-11,  -1.925014690276377e-13,  -2.146038510068553e-15,   1.285103855355330e-16,  -5.069862601417304e-20,  -3.209074287140946e-20,   4.465968526890465e-22,
  -1.166728854598239e-23,  -4.860137722421936e-25,  -2.019022874283899e-03,   2.457686417864550e-05,   5.018107031250105e-07,  -1.667039042815452e-08,   1.939470541052430e-11,
   6.299439734528166e-12,  -1.032285012665700e-13,  -1.151205771979554e-15,   6.892247512540395e-17,  -2.696382492049419e-20,  -1.722155848586296e-20,   2.392069134618372e-22,
  -6.247483203084421e-24,  -2.604535286529179e-25,  -7.513317814067436e-04,   9.145600416097122e-06,   1.867375741265367e-07,  -6.203358152731677e-09,   7.213752661483975e-12,
   2.344136219723705e-12,  -3.840969326295387e-14,  -4.283969196447153e-16,   2.564613606690801e-17,  -1.000391156309392e-20,  -6.409548865908104e-21,   8.896888970728224e-23,
  -2.323414497775321e-24,  -9.688858275327054e-26,  -8.486873802515271e-05,   1.033064530087101e-06,   2.109346365289334e-08,  -7.007148849489979e-10,   8.147859081137256e-13,
   2.647873945129346e-13,  -4.338593879223593e-15,  -4.839079726291617e-17,   2.896898332609394e-18,  -1.129480841738835e-21,  -7.240251932450291e-22,   1.004889418971272e-23,
  -2.624218515325081e-25,  -1.094372254440508e-26,  -1.549219609203320e-02,  -6.083518255217765e-05,   7.906899480617381e-06,   2.033718578050287e-08,  -4.199543465406267e-09,
  -3.663925421370836e-12,   2.179997722588130e-12,  -4.292561992169522e-15,  -1.091498776785702e-15,   1.063024085553405e-17,   7.096908205671267e-19,  -7.732117207868529e-21,
  -4.768501966697844e-22,   2.773908579657866e-24,  -1.473841659464827e-02,  -5.787432745023235e-05,   7.521558539310873e-06,   1.934688099910893e-08,  -3.994307576235508e-09,
  -3.488337695293442e-12,   2.073058697185587e-12,  -4.072479519619149e-15,  -1.037466024676363e-15,   1.010060056128098e-17,   6.742431627636450e-19,  -7.349629246532467e-21,
  -4.529732195403520e-22,   2.636237244865478e-24,  -1.330473791563915e-02,  -5.224318289251155e-05,   6.788900262018485e-06,   1.746365432239234e-08,  -3.604320000955145e-09,
  -3.153272604987552e-12,   1.870016774517425e-12,  -3.658465532231791e-15,  -9.350741657740298e-16,   9.098293174903048e-18,   6.071967685747483e-19,  -6.624702014527862e-21,
  -4.078356193069832e-22,   2.375494902057651e-24,  -1.133163291687143e-02,  -4.449400526200972e-05,   5.781071371580327e-06,   1.487247895642876e-08,  -3.068312099331021e-09,
  -2.690015646107261e-12,   1.591266379044951e-12,  -3.097540000917504e-15,  -7.948877814074328e-16,   7.728664684206991e-18,   5.156484733450112e-19,  -5.631973584978819e-21,
  -3.462486662352989e-22,   2.018786136590598e-24,  -9.012342286974820e-03,  -3.538610804866770e-05,   4.597042363626117e-06,   1.182746471513121e-08,  -2.439163276915134e-09,
  -2.142806745540494e-12,   1.264476395618269e-12,  -2.449391082883200e-15,  -6.310279544632482e-16,   6.131117656453943e-18,   4.089523111694435e-19,  -4.471328806763938e-21,
  -2.745295987354636e-22,   1.602188610821443e-24,  -6.573913399110254e-03,  -2.581118331880630e-05,   3.352774838090100e-06,   8.626769833734117e-09,  -1.778537258755446e-09,
  -1.565009886926531e-12,   9.217074761843115e-13,  -1.778359108371581e-15,  -4.596088638465968e-16,   4.463037325706554e-18,   2.976255649206704e-19,  -3.256889113340332e-21,
  -1.997522743698007e-22,   1.166695600276685e-24,  -4.254982236199642e-03,  -1.670607000319235e-05,   2.169892608636356e-06,   5.583445814239834e-09,  -1.150875218068670e-09,
  -1.013798457099001e-12,   5.963017594370347e-13,  -1.147496376234377e-15,  -2.971904994792412e-16,   2.884775359426260e-18,   1.923491329399017e-19,  -2.106041664199512e-21,
  -1.290770183452003e-22,   7.542944359538346e-25,  -2.282458903618491e-03,  -8.961396978289501e-06,   1.163919529727576e-06,   2.995004020473818e-09,  -6.172736433294682e-10,
  -5.440536697383466e-13,   3.197924449520829e-13,  -6.145627092550803e-16,  -1.593384949928001e-16,   1.546368011142168e-18,   1.031002148779926e-19,  -1.129176118506938e-21,
  -6.918086664436042e-23,   4.043843121992211e-25,  -8.493619357752069e-04,  -3.334757229386313e-06,   4.331174162299951e-07,   1.114509351579290e-09,  -2.296932153869457e-10,
  -2.024864050634148e-13,   1.189931992609401e-13,  -2.285680713752728e-16,  -5.928354460383918e-17,   5.753031076979479e-19,   3.835592591478312e-20,  -4.201247258012656e-22,
  -2.573639228892206e-23,   1.504514869202753e-25,  -9.594197815424736e-05,  -3.766863539837238e-07,   4.892382340139456e-08,   1.258922607756150e-10,  -2.594543546606214e-11,
  -2.287293758890211e-14,   1.344102290323938e-14,  -2.581625666677813e-17,  -6.696346486191509e-18,   6.498240460967419e-20,   4.332412397006938e-21,  -4.745505589056839e-23,
  -2.906987766833388e-24,   1.699411103032397e-26,  -1.220343243293828e-02,  -3.473765874554388e-04,   4.852411716631286e-07,   2.295469830448437e-07,   3.730375443813708e-09,
  -8.954147078871094e-11,  -4.160337946122718e-12,  -1.214302435868836e-14,   2.734690642271032e-15,   6.178235610595549e-17,  -6.434463206107258e-19,  -5.251242685204233e-20,
  -5.620743696697562e-22,   2.256037235838056e-23,  -1.160983805365636e-02,  -3.304596536699022e-04,   4.622997863036617e-07,   2.183550991358228e-07,   3.547082152279630e-09,
  -8.519341687470700e-11,  -3.955706264900755e-12,  -1.148684591915047e-14,   2.600804764414890e-15,   5.869187752327962e-17,  -6.132298465265872e-19,  -4.990595204101652e-20,
  -5.327640161172675e-22,   2.145851765948761e-23,  -1.048076068183915e-02,  -2.982900371837013e-04,   4.183936016354096e-07,   1.970776969284111e-07,   3.199189539725165e-09,
  -7.691991445164473e-11,  -3.567397918829341e-12,  -1.026548425756313e-14,   2.346490162467433e-15,   5.284825247623334e-17,  -5.553100115653956e-19,  -4.496939584149977e-20,
  -4.778198267755735e-22,   1.936437122660594e-23,  -8.926731112195239e-03,  -2.540284558563124e-04,   3.574406464389162e-07,   1.678128590646760e-07,   2.721813036116564e-09,
  -6.552662989014168e-11,  -3.034728387383869e-12,  -8.636193524042400e-15,   1.997139577055898e-15,   4.487257946717455e-17,  -4.747332253582809e-19,  -3.821600348521697e-20,
  -4.037549106769474e-22,   1.648545924444816e-23,  -7.099875159710275e-03,  -2.020162191969407e-04,   2.851269408963515e-07,   1.334365598231114e-07,   2.162465120097719e-09,
  -5.212578203816944e-11,  -2.410803608242241e-12,  -6.786192427607100e-15,   1.587321508468480e-15,   3.558174093136371e-17,  -3.789327306243158e-19,  -3.032904012991093e-20,
  -3.186506785394193e-22,   1.310563448879442e-23,  -5.179019507572849e-03,  -1.473463089114491e-04,   2.084777705530554e-07,   9.731596872319648e-08,   1.576047351590338e-09,
  -3.802862521532999e-11,  -1.756881588458100e-12,  -4.901741428116619e-15,   1.157225539753494e-15,   2.589198686889096e-17,  -2.772054398997706e-19,  -2.208477777971903e-20,
  -2.309895824068903e-22,   9.556284478434891e-24,  -3.352187318671336e-03,  -9.536544591317259e-05,   1.351499699036885e-07,   6.298062559279747e-08,   1.019532389425358e-09,
  -2.461680012980746e-11,  -1.136444106221903e-12,  -3.152013680696131e-15,   7.487509552729316e-16,   1.673191958830305e-17,  -1.797625386522634e-19,  -1.427806335824762e-20,
  -1.488917293484080e-22,   6.183842693389031e-24,  -1.798196167524271e-03,  -5.115463217996860e-05,   7.255563207796668e-08,   3.378205270022243e-08,   5.467413764142893e-10,
  -1.320568677863723e-11,  -6.094183497155575e-13,  -1.685119319675112e-15,   4.015718141837563e-16,   8.967980382650585e-18,  -9.652193437960952e-20,  -7.654535330008044e-21,
  -7.969882061622263e-23,   3.316725071663462e-24,  -6.691571749023052e-04,  -1.903578816308270e-05,   2.700739432843728e-08,   1.257091123994300e-08,   2.034363251278183e-10,
  -4.914272387003307e-12,  -2.267552732079063e-13,  -6.263403689640309e-16,   1.494257366223005e-16,   3.336264019448874e-18,  -3.593042624878691e-20,  -2.847866541880920e-21,
  -2.963601930809973e-23,   1.234185263864983e-24,  -7.558649561251539e-05,  -2.150235926767218e-06,   3.050829047957858e-09,   1.419976607465026e-09,   2.297933786272967e-11,
  -5.551066531472883e-13,  -2.561330724430374e-14,  -7.073678027025454e-17,   1.687861831522872e-17,   3.768396544457549e-19,  -4.058835823867669e-21,  -3.216780141884606e-22,
  -3.347223071919450e-24,   1.394097732040649e-25,  -3.780656268516612e-03,  -2.173729692721542e-04,  -7.409994443892006e-06,  -1.721865001720143e-07,  -2.180634272846914e-09,
   2.816928888427508e-11,   2.681985919668088e-12,   9.067433111977479e-14,   1.849867041381542e-15,   1.340914994658036e-17,  -6.716447657785033e-19,  -3.419322581338730e-20,
  -8.837851719966368e-22,  -1.272665808251108e-23,  -3.596984768950851e-03,  -2.068152172129267e-04,  -7.049955910664353e-06,  -1.638027428838551e-07,  -2.073365597443809e-09,
   2.685580152329574e-11,   2.553067898811326e-12,   8.627786640110634e-14,   1.758976195199166e-15,   1.270073513435493e-17,  -6.407082416867294e-19,  -3.255916693345731e-20,
  -8.406544720196298e-22,  -1.207823144887983e-23,  -3.247531060562697e-03,  -1.867269431069210e-04,  -6.364964720453290e-06,  -1.478593402155384e-07,  -1.869816013426394e-09,
   2.433437618186601e-11,   2.307226429548545e-12,   7.790953391431192e-14,   1.586459279602754e-15,   1.137602240164712e-17,  -5.811588933524888e-19,  -2.943907470321527e-20,
  -7.586688078075150e-22,  -1.085668329525056e-23,  -2.766375248986990e-03,  -1.590657150524407e-04,  -5.421850715728390e-06,  -1.259218439368267e-07,  -1.590600327966849e-09,
   2.081927829966510e-11,   1.967644229243873e-12,   6.638042692029880e-14,   1.349726313054311e-15,   9.596930391803467e-18,  -4.978305041553766e-19,  -2.512160288927584e-20,
  -6.459338157383917e-22,  -9.198423194956157e-24,  -2.200522317087600e-03,  -1.265326868995940e-04,  -4.312768669493503e-06,  -1.001413063502099e-07,  -1.263561957887304e-09,
   1.663048686943305e-11,   1.566910689089914e-12,   5.281324212140494e-14,   1.072341535194557e-15,   7.561558937668689e-18,  -3.981438100014058e-19,  -2.001709645009397e-20,
  -5.135499470836437e-22,  -7.278384959826426e-24,  -1.605343849738884e-03,  -9.231116799451648e-05,  -3.146252184808393e-06,  -7.304203662740512e-08,  -9.208130954941645e-10,
   1.217338913224604e-11,   1.144128692603870e-12,   3.853500881837841e-14,   7.815362983918804e-16,   5.473821033589927e-18,  -2.917160833355926e-19,  -1.462297986003657e-20,
  -3.744936776390129e-22,  -5.287077017126194e-24,  -1.039151423670905e-03,  -5.975456729276903e-05,  -2.036577918691422e-06,  -4.727472075139343e-08,  -5.956252199367546e-10,
   7.897453639334999e-12,   7.410404142116204e-13,   2.494665975596698e-14,   5.055656014836070e-16,   3.525035738414444e-18,  -1.893683129008484e-19,  -9.474074014724481e-21,
  -2.423451892470668e-22,  -3.412629292419754e-24,  -5.574463175018393e-04,  -3.205519673961469e-05,  -1.092505324324500e-06,  -2.535858968896749e-08,  -3.194025672798924e-10,
   4.241367780842493e-12,   3.976468914943752e-13,   1.338320819899742e-14,   2.711168277966427e-16,   1.885964982539440e-18,  -1.017337050636938e-19,  -5.084648116410213e-21,
  -1.299858442713315e-22,  -1.827997936698207e-24,  -2.074433374062538e-04,  -1.192877851287631e-05,  -4.065551023825207e-07,  -9.436517677586299e-09,  -1.188446187176475e-10,
   1.578971899157728e-12,   1.479925244123413e-13,   4.980407506198548e-15,   1.008793604382237e-16,   7.011768741036943e-19,  -3.787751713609911e-20,  -1.892460645177856e-21,
  -4.836939408743394e-23,  -6.799075359094385e-25,  -2.343238070211252e-05,  -1.347451280202199e-06,  -4.592363395793582e-08,  -1.065926181830046e-09,  -1.342417688101480e-11,
   1.783686875952417e-13,   1.671721625577980e-14,   5.625784653737268e-16,   1.139491824630632e-17,   7.919187074395668e-20,  -4.278912039400735e-21,  -2.137739629509284e-22,
  -5.463665458257607e-24,  -7.679474239836540e-26,  -2.013422965454005e-04,   6.521251376845496e-06,  -1.408108725504725e-07,   2.497704170838643e-09,  -4.046579063039662e-11,
   5.855012599778998e-13,  -7.842340207471203e-15,   1.442463679209667e-16,  -2.856666760037902e-19,   2.279449083568208e-20,  -1.048116878694196e-21,  -2.586527139152521e-23,
  -1.303251138011201e-25,   1.316156757958857e-26,  -1.915531377925381e-04,   6.204278664230829e-06,  -1.339690121008229e-07,   2.376389362880473e-09,  -3.850101945707530e-11,
   5.571124561561879e-13,  -7.461132038342482e-15,   1.372542849079665e-16,  -2.731759978429779e-19,   2.164375724269266e-20,  -9.973852528568259e-22,  -2.457676754811595e-23,
  -1.233940250849854e-25,   1.251309054219113e-26,  -1.729313458180274e-04,   5.601270078225244e-06,  -1.209520837270301e-07,   2.145564060488808e-09,  -3.476238091975345e-11,
   5.030771137196385e-13,  -6.735932714028500e-15,   1.239446919970643e-16,  -2.488470230967139e-19,   1.947207232428018e-20,  -9.007851027176402e-22,  -2.213827339181884e-23,
  -1.104518199399063e-25,   1.128302648413496e-26,  -1.472973408013795e-04,   4.771124160345709e-06,  -1.030301244167159e-07,   1.827722925373282e-09,  -2.961382972251452e-11,
   4.286328041606410e-13,  -5.737589287922838e-15,   1.056065507491108e-16,  -2.142548501030249e-19,   1.651617105979310e-20,  -7.676285363938221e-22,  -1.880596341015191e-23,
  -9.310580519117650e-26,   9.596564537700941e-27,  -1.171585734502112e-04,   3.795006519695738e-06,  -8.195438762918208e-08,   1.453904315347470e-09,  -2.355785477335869e-11,
   3.410283055429572e-13,  -4.563720451177910e-15,   8.402474050739790e-17,  -1.721882425264214e-19,   1.308318294105388e-20,  -6.108455518923776e-22,  -1.491892680837543e-23,
  -7.330470734733216e-26,   7.622271588258435e-27,  -8.546489344782727e-05,   2.768448118155130e-06,  -5.978732246153806e-08,   1.060685922937633e-09,  -1.718697145021462e-11,
   2.488315703839125e-13,  -3.329210316558420e-15,   6.130995965537456e-17,  -1.266497620161720e-19,   9.512482757495130e-21,  -4.457650956656683e-22,  -1.086009784145438e-23,
  -5.303386756319831e-26,   5.554023551860628e-27,  -5.531967498820062e-05,   1.791987523877785e-06,  -3.870047611557393e-08,   6.865992377611456e-10,  -1.112561972460363e-11,
   1.610884206736708e-13,  -2.154957894240995e-15,   3.969131952235362e-17,  -8.242344803776073e-20,   6.143800927766622e-21,  -2.886049412693803e-22,  -7.019700965829556e-24,
  -3.413952035621342e-26,   3.592330299164197e-27,  -2.967523221634229e-05,   9.612867212218043e-07,  -2.076054219666666e-08,   3.683243924312578e-10,  -5.968368908021983e-12,
   8.641979360411274e-14,  -1.155995753242649e-15,   2.129351218091646e-17,  -4.433733754525758e-20,   3.292031609222809e-21,  -1.548361843888993e-22,  -3.762887034666410e-24,
  -1.826170422650944e-26,   1.926304543264187e-27,  -1.104300292854885e-05,   3.577232823890304e-07,  -7.725640493033067e-09,   1.370654348152208e-10,  -2.221030982920174e-12,
   3.216016417509944e-14,  -4.301801112772521e-16,   7.924161564799223e-18,  -1.651509521148650e-20,   1.224580249804630e-21,  -5.762147325101805e-23,  -1.399927788086490e-24,
  -6.788992589649348e-27,   7.167378355077513e-28,  -1.247393782282148e-06,   4.040766784197427e-08,  -8.726725540177378e-10,   1.548264068204958e-11,  -2.508834078201207e-13,
   3.632758640151859e-15,  -4.859223539372415e-17,   8.951004295918929e-19,  -1.865794588337228e-21,   1.383173592104628e-22,  -6.508842062227573e-24,  -1.581265463678959e-25,
  -7.667496871046882e-28,   8.095945337049466e-29,  -1.784330212477291e-03,   5.541105951560118e-05,  -1.105124965283388e-06,   1.707541998225893e-08,  -2.227424826764945e-10,
   2.128538840324129e-12,  -9.343043240833857e-15,   2.343675414678208e-16,   1.482125238931958e-17,  -3.889355271173483e-20,  -6.387895875356096e-21,  -2.806254644878160e-22,
  -8.339629652055715e-25,   1.203228810040260e-25,  -1.697572716372880e-03,   5.271737147778690e-05,  -1.051411065302969e-06,   1.624549918575040e-08,  -2.119123343289307e-10,
   2.025152118618317e-12,  -8.876305795995846e-15,   2.229230655005795e-16,   1.409178300762725e-17,  -3.745795710605315e-20,  -6.078760810313963e-21,  -2.666977960069208e-22,
  -7.878258605190602e-25,   1.143914949444859e-25,  -1.532536776299610e-03,   4.759305294140488e-05,  -9.492250038462553e-07,   1.466663869613445e-08,  -1.913104860894133e-10,
   1.828439461439229e-12,  -7.993523026237421e-15,   2.011718962701086e-16,   1.270772561269009e-17,  -3.454124192491290e-20,  -5.490095975896931e-21,  -2.403190200737372e-22,
  -7.023415770941453e-25,   1.031417644890655e-25,  -1.305358355193939e-03,   4.053883247085024e-05,  -8.085466370874602e-07,   1.249302466388179e-08,  -1.629512209473270e-10,
   1.557572532092646e-12,  -6.788170688238807e-15,   1.712686094422379e-16,   1.080947626511139e-17,  -3.016660681944575e-20,  -4.678613208260350e-21,  -2.042310365178335e-22,
  -5.890826062286597e-25,   8.772034607477974e-26,  -1.038261267344346e-03,   3.224457835440684e-05,  -6.431296491692740e-07,   9.937156332539980e-09,  -1.296087978458665e-10,
   1.239003606267777e-12,  -5.383450811377518e-15,   1.361600467278476e-16,   8.586489787921499e-18,  -2.456898095018802e-20,  -3.723091978788844e-21,  -1.620842885724051e-22,
  -4.614957768575764e-25,   6.966991886695408e-26,  -7.573881489047855e-04,   2.352206550566961e-05,  -4.691629633414235e-07,   7.249168149012954e-09,  -9.454668003223964e-11,
   9.039045671198316e-13,  -3.917855858613092e-15,   9.928748123009275e-17,   6.257069889746867e-18,  -1.825996367785220e-20,  -2.716958201675946e-21,  -1.180267200237669e-22,
  -3.325127752238337e-25,   5.076326645969252e-26,  -4.902404718349988e-04,   1.522546870269110e-05,  -3.036848935245186e-07,   4.692326380251649e-09,  -6.119795283635483e-11,
   5.851112404050478e-13,  -2.531986703329114e-15,   6.425010240349843e-17,   4.047246953804851e-18,  -1.196346319024769e-20,  -1.759071129142490e-21,  -7.630625496953345e-23,
  -2.134600570411533e-25,   3.283261925255802e-26,  -2.629801976114245e-04,   8.167457779427794e-06,  -1.629076953757845e-07,   2.517137365029131e-09,  -3.282847840994343e-11,
   3.138811735009880e-13,  -1.357147295693147e-15,   3.446118821527182e-17,   2.170293280983959e-18,  -6.457274057781651e-21,  -9.437423068341533e-22,  -4.090831002449266e-23,
  -1.140198256479786e-25,   1.760547568080489e-26,  -9.786240684272195e-05,   3.039348906190546e-06,  -6.062280401115001e-08,   9.367019812763897e-10,  -1.221640970270891e-11,
   1.168053181053553e-13,  -5.048920677848370e-16,   1.282339577804653e-17,   8.075273670870349e-19,  -2.408076129613945e-21,  -3.512091081664524e-22,  -1.521994212624341e-23,
  -4.236698788017096e-26,   6.550597266389514e-27,  -1.105432543775716e-05,   3.433183692959376e-07,  -6.847824529967568e-09,   1.058078910832952e-10,  -1.379939165612250e-12,
   1.319409736123299e-14,  -5.702898640596219e-17,   1.448492385241536e-18,   9.121474106299608e-20,  -2.721032048788317e-22,  -3.967210239782210e-23,  -1.719154277344083e-24,
  -4.784553439580062e-27,   7.399251336705276e-28,  -4.787709496373478e-03,   1.347197406964620e-04,  -2.169123561353113e-06,   1.989435963051401e-08,   9.653317695334515e-12,
  -5.344924836494368e-12,   1.279502693383283e-13,  -6.429347394132970e-16,   4.075861752915269e-17,   3.100472549801819e-19,  -2.869554574399610e-20,  -6.872829930859481e-22,
  -4.214879177082427e-24,   3.697601465746691e-25,  -4.554898212696310e-03,   1.281686993952545e-04,  -2.063614814111066e-06,   1.892510114427829e-08,   9.240965465979658e-12,
  -5.085345809360906e-12,   1.217604347387985e-13,  -6.113380083989408e-16,   3.873764908098058e-17,   2.938508275683922e-19,  -2.730785900707689e-20,  -6.529996054241379e-22,
  -3.992249912624815e-24,   3.514993549278087e-25,  -4.112038626077907e-03,   1.157071582187399e-04,  -1.862925993468138e-06,   1.708210814044138e-08,   8.433401734285663e-12,
  -4.591434353648046e-12,   1.099729244232510e-13,  -5.513708634572122e-16,   3.490915408862833e-17,   2.634987671223494e-19,  -2.466499247060468e-20,  -5.881365944455658e-22,
  -3.575970447030456e-24,   3.168784281621916e-25,  -3.502443878658887e-03,   9.855392212795088e-05,  -1.586702982769558e-06,   1.454669898358580e-08,   7.276836909868844e-12,
  -3.911308158361604e-12,   9.372220080541993e-14,  -4.690902192832121e-16,   2.966997472283571e-17,   2.226037848996995e-19,  -2.102099004413343e-20,  -4.995339474285356e-22,
  -3.016919007701060e-24,   2.694450745075521e-25,  -2.785757940853439e-03,   7.838731664432891e-05,  -1.261985220428967e-06,   1.156773333185523e-08,   5.860153770500913e-12,
  -3.111373011757856e-12,   7.458471360690163e-14,  -3.726864317448737e-16,   2.354931962309914e-17,   1.756412627101431e-19,  -1.672916766444140e-20,  -3.962267239244348e-22,
  -2.377281072779787e-24,   2.139583558674791e-25,  -2.032129764446082e-03,   5.718124537657827e-05,  -9.205585153923549e-07,   8.436943081869671e-09,   4.317331895640487e-12,
  -2.269899900034419e-12,   5.443108580138725e-14,  -2.716203038941975e-16,   1.714947950407890e-17,   1.272965228088362e-19,  -1.220904733704751e-20,  -2.883957772027615e-22,
  -1.721068986387108e-24,   1.558705304480310e-25,  -1.315344723555788e-03,   3.701191836239380e-05,  -5.958436648107154e-07,   5.460422008949084e-09,   2.812685880858869e-12,
  -1.469351177695623e-12,   3.524195150932566e-14,  -1.757088746423109e-16,   1.108797713137656e-17,   8.204168959597016e-20,  -7.904985849923387e-21,  -1.863974727834087e-22,
  -1.108410485824673e-24,   1.008031134016537e-25,  -7.055896238611878e-04,   1.985427850724657e-05,  -3.196253484777210e-07,   2.928968067528514e-09,   1.513818881726432e-12,
  -7.882318678760982e-13,   1.890760800982169e-14,  -9.422684986906557e-17,   5.944491328660655e-18,   4.391211236986085e-20,  -4.241123098541626e-21,  -9.991374649253309e-23,
  -5.930442242286617e-25,   5.404960198404640e-26,  -2.625696848242034e-04,   7.388333275404380e-06,  -1.189412012397843e-07,   1.089930036599055e-09,   5.639835774948857e-13,
  -2.933268913754410e-13,   7.036412149392446e-15,  -3.506075693707166e-17,   2.211668153665018e-18,   1.632830843616115e-20,  -1.578325707536272e-21,  -3.717094985363582e-23,
  -2.204890022972786e-25,   2.011024625106564e-26,  -2.965929783081044e-05,   8.345699728360401e-07,  -1.343533184173534e-08,   1.231157367554507e-10,   6.371798809010022e-14,
  -3.313363117287623e-14,   7.948242110205716e-16,  -3.960320253316514e-18,   2.498172472066725e-19,   1.844183850952362e-21,  -1.782857438345413e-22,  -4.198574387475798e-24,
  -2.490238225620208e-26,   2.271553446070613e-27,  -8.806895427438254e-03,   2.029392533945265e-04,  -1.684475009215505e-06,  -2.493783076032398e-08,   9.751671204237370e-10,
  -1.449074425283894e-11,   2.640305385410033e-14,   6.086612319379118e-15,  -2.206764714142471e-17,   1.152786438167474e-18,  -3.829974266979983e-20,  -2.241142432833714e-21,
  -6.401288773732967e-25,   8.385334416906103e-25,  -8.378574952234532e-03,   1.930659887180420e-04,  -1.602367610704283e-06,  -2.372914282367103e-08,   9.277463729053100e-10,
  -1.378210394695840e-11,   2.510013712807917e-14,   5.791766234819317e-15,  -2.104551526276451e-17,   1.093068501931406e-18,  -3.643771213741341e-20,  -2.130194937826395e-21,
  -5.753573098777524e-25,   7.972360158066739e-25,  -7.563840736779016e-03,   1.742868301481613e-04,  -1.446260767841808e-06,  -2.142833393091278e-08,   8.375419827611618e-10,
  -1.243573577487103e-11,   2.262936868811380e-14,   5.230438964598624e-15,  -1.908047749885960e-17,   9.809645379031352e-19,  -3.289547009170410e-20,  -1.919949410629980e-21,
  -4.659015563752367e-25,   7.188939330541643e-25,  -6.442416021756541e-03,   1.484412946479487e-04,  -1.231535236644636e-06,  -1.825815480510297e-08,   7.133770571008240e-10,
  -1.058561716969836e-11,   1.924329912863844e-14,   4.456880512299038e-15,  -1.633545069691394e-17,   8.295442018037504e-19,  -2.801921027399996e-20,  -1.632099777800351e-21,
  -3.418283470908890e-25,   6.114704476256962e-25,  -5.124052500556680e-03,   1.180602727942917e-04,  -9.792838045026211e-07,  -1.452709996319859e-08,   5.674007610610196e-10,
  -8.414469368323183e-12,   1.528137283524259e-14,   3.546303743873057e-15,  -1.305735278534753e-17,   6.551750219570854e-19,  -2.228597109632760e-20,  -1.295644760669373e-21,
  -2.295044022793899e-25,   4.856954478705765e-25,  -3.737796725257423e-03,   8.611785357702363e-05,  -7.142127982090714e-07,  -1.060004272138298e-08,   4.139013332770561e-10,
  -6.135131403796122e-12,   1.113301696500119e-14,   2.587751234719401e-15,  -9.562884139975019e-18,   4.752167700348107e-19,  -1.625701822531497e-20,  -9.436747305403009e-22,
  -1.425624766545906e-25,   3.539186316853869e-25,  -2.419356659803746e-03,   5.574026454146067e-05,  -4.622287535578787e-07,  -6.862390613269534e-09,   2.679070934700365e-10,
  -3.969836044817575e-12,   7.199983481295928e-15,   1.675335949942454e-15,  -6.206025693567937e-18,   3.064353891228946e-19,  -1.052274707054519e-20,  -6.101917325725904e-22,
  -8.166204691010535e-26,   2.289194139560276e-25,  -1.297808085000157e-03,   2.990028282589443e-05,  -2.479358609796087e-07,  -3.681535008236683e-09,   1.437131201717725e-10,
  -2.129185663517797e-12,   3.860592767621083e-15,   8.987962755884528e-16,  -3.333562973004031e-18,   1.640615387810978e-19,  -5.644708823076493e-21,  -3.271528601366281e-22,
  -4.088425630061797e-26,   1.227543217159513e-25,  -4.829499991620731e-04,   1.112667725973772e-05,  -9.226165249568453e-08,  -1.370047314784415e-09,   5.347966508587732e-11,
  -7.922841967045677e-13,   1.436415781039911e-15,   3.344798199144364e-16,  -1.241090979312846e-18,   6.101053567259510e-20,  -2.100553947496623e-21,  -1.217204857696403e-22,
  -1.483590736476649e-26,   4.567452930051485e-26,  -5.455296255102511e-05,   1.256844137788242e-06,  -1.042163461425475e-08,  -1.547583557035450e-10,   6.040945802064901e-12,
  -8.949387607598888e-14,   1.622504608185338e-16,   3.778233395331280e-17,  -1.402012984173968e-19,   6.890875404674441e-21,  -2.372739740127896e-22,  -1.374888096853182e-23,
  -1.669052038914645e-27,   5.159191157129299e-27,  -1.298938423375173e-02,   1.887978942274059e-04,   2.084103030644189e-06,  -1.052241015674430e-07,   8.128464415989794e-10,
   2.492568171361153e-11,  -7.200815551068772e-13,   6.290298762814118e-15,   3.886183907387771e-16,  -4.218350784409904e-18,  -1.073335279918023e-19,  -1.346896907267030e-21,
  -5.257852980289313e-23,   1.495426618779049e-24,  -1.235751412788797e-02,   1.796053317462231e-04,   1.982875784556443e-06,  -1.000985441607707e-07,   7.729894386319049e-10,
   2.371719419259162e-11,  -6.847338780349333e-13,   5.979806869955233e-15,   3.695714410647824e-16,  -4.015338287390207e-18,  -1.022144014249770e-19,  -1.277947178154658e-21,
  -4.988133197433003e-23,   1.420358785273584e-24,  -1.115565102869704e-02,   1.621238484251814e-04,   1.790271427100940e-06,  -9.035216981770986e-08,   6.973071286208953e-10,
   2.141692287389283e-11,  -6.176299173050691e-13,   5.391054072198870e-15,   3.334005029372948e-16,  -3.628296034491696e-18,  -9.243556516637882e-20,  -1.148201068574781e-21,
  -4.480801024558993e-23,   1.278527371433023e-24,  -9.501477379308265e-03,   1.380700364691151e-04,   1.525060546200454e-06,  -7.694328424185827e-08,   5.933916480665285e-10,
   1.824778914703804e-11,  -5.255236892032634e-13,   4.584272039799062e-15,   2.837291149481653e-16,  -3.093860950057426e-18,  -7.889571170217300e-20,  -9.723359542401507e-22,
  -3.793556056308870e-23,   1.085157980688794e-24,  -7.556941655649632e-03,   1.098024328673480e-04,   1.213142608426579e-06,  -6.118759923380022e-08,   4.715507435104350e-10,
   1.451835354838805e-11,  -4.175681855347732e-13,   3.640362846207298e-15,   2.254810352769933e-16,  -2.463432814248640e-18,  -6.287740182502326e-20,  -7.690199680365696e-22,
  -2.999586707339548e-23,   8.601601628972778e-25,  -5.512393643691476e-03,   8.008883087076150e-05,   8.850386593678508e-07,  -4.462799887404141e-08,   3.437368704751688e-10,
   1.059336608537945e-11,  -3.043569339407363e-13,   2.652096963521544e-15,   1.643700379383786e-16,  -1.798556230549965e-18,  -4.594086222034812e-20,  -5.584250236220431e-22,
  -2.177717694530145e-23,   6.257354768398130e-25,  -3.567953490680846e-03,   5.183562518464161e-05,   5.728993691383892e-07,  -2.888372660052812e-08,   2.223868700658241e-10,
   6.857941767202350e-12,  -1.968967323045382e-13,   1.715160472445840e-15,   1.063445749561622e-16,  -1.164821442275140e-18,  -2.976773483767126e-20,  -3.603636651955710e-22,
  -1.405139532151694e-23,   4.042857326929715e-25,  -1.913934470877724e-03,   2.780511064596527e-05,   3.073302383903076e-07,  -1.549330530485008e-08,   1.192659269555954e-10,
   3.679113387825738e-12,  -1.055921199393035e-13,   9.196567092014369e-16,   5.703316575657984e-17,  -6.250268314842492e-19,  -1.597692926523148e-20,  -1.930095633779552e-22,
  -7.525357767415910e-24,   2.166681649127068e-25,  -7.122259926541722e-04,   1.034692610252331e-05,   1.143675148112818e-07,  -5.765392877576226e-09,   4.437844843462041e-11,
   1.369141607380093e-12,  -3.929002232543448e-14,   3.421774776479139e-16,   2.122193097311219e-17,  -2.326136105687624e-19,  -5.946581736282006e-21,  -7.178541427520060e-23,
  -2.798813831040251e-24,   8.060207666159117e-26,  -8.045144349376619e-05,   1.168763737853482e-06,   1.291872812954462e-08,  -6.512443797907941e-10,   5.012825390543119e-12,
   1.546559673100309e-13,  -4.438047554060875e-15,   3.865067776681778e-17,   2.397152307789348e-18,  -2.627594808454064e-20,  -6.717329204909419e-22,  -8.108027113422037e-24,
  -3.161195253248132e-25,   9.104164499029180e-27,  -1.560907807258698e-02,   2.266352037366193e-06,   7.754310494010676e-06,  -4.470462017212258e-08,  -3.777615571901722e-09,
   4.379291038222022e-11,   1.661720198937751e-12,  -2.865108681838256e-14,  -3.342642734123307e-16,   2.648570403614075e-17,  -2.382318564730637e-20,  -2.202257051444291e-20,
  -3.736512264191967e-23,   1.193709174211434e-23,  -1.484961782337070e-02,   2.152153670776145e-06,   7.376466235074201e-06,  -4.251720772143568e-08,  -3.593131128849196e-09,
   4.164505336280581e-11,   1.580615139644441e-12,  -2.722938700367536e-14,  -3.180380115222938e-16,   2.516168345196932e-17,  -2.273693434191159e-20,  -2.092392849498766e-20,
  -3.547597171207983e-23,   1.133992974756409e-23,  -1.340513191023332e-02,   1.936547503936645e-06,   6.658037076124308e-06,  -3.836177882434696e-08,  -3.242521797773365e-09,
   3.756682734244940e-11,   1.426457282358959e-12,  -2.453662786110735e-14,  -2.871607668320220e-16,   2.265783799552757e-17,  -2.064109189858900e-20,  -1.884539985243821e-20,
  -3.191167009782551e-23,   1.021082651656065e-23,  -1.141714853871851e-02,   1.642915144744280e-06,   5.669733961491452e-06,  -3.265254592463967e-08,  -2.760532773266763e-09,
   3.196764647525473e-11,   1.214496589768467e-12,  -2.085255944554052e-14,  -2.446364304323045e-16,   1.923982110695938e-17,  -1.769907655888992e-20,  -1.600623922040239e-20,
  -2.706227172477423e-23,   8.669824978943037e-24,  -9.080362917761717e-03,   1.301682032855335e-06,   4.508584369022477e-06,  -2.595387232566304e-08,  -2.194658870706356e-09,
   2.540312082138847e-11,   9.655996465131884e-13,  -1.654969653666707e-14,  -1.946136483525872e-16,   1.525734540721064e-17,  -1.416824342661619e-20,  -1.269598186390862e-20,
  -2.143301118196100e-23,   6.874754454609033e-24,  -6.623534595233967e-03,   9.465714827265850e-07,   3.288304285544334e-06,  -1.892251845929652e-08,  -1.600351902461036e-09,
   1.851724653442365e-11,   7.041529914440353e-13,  -1.205145179120183e-14,  -1.419861623504371e-16,   1.110307273036626e-17,  -1.038857430998973e-20,  -9.240824699928528e-21,
  -1.558086107408062e-23,   5.002615549922230e-24,  -4.287101649474667e-03,   6.114220802356058e-07,   2.128186861804828e-06,  -1.224374420409996e-08,  -1.035614613194010e-09,
   1.197992242502638e-11,   4.556841023514130e-13,  -7.791589150545518e-15,  -9.191301678025899e-17,   7.175315007644459e-18,  -6.746989461945726e-21,  -5.972576947185265e-21,
  -1.006202040482158e-23,   3.232803156878456e-24,  -2.299688951216327e-03,   3.276352705407397e-07,   1.141554049565605e-06,  -6.566717792208847e-09,  -5.554648735503965e-10,
   6.424783424020276e-12,   2.444159704638907e-13,  -4.177159655859753e-15,  -4.930734992076924e-17,   3.845907632695125e-18,  -3.625540313808321e-21,  -3.201452315208570e-21,
  -5.391207725983737e-24,   1.732723311397273e-24,  -8.557737518817772e-04,   1.218770032631948e-07,   4.247954628715188e-07,  -2.443506108170767e-09,  -2.066950818605010e-10,
   2.390634942286232e-12,   9.095061773392581e-14,  -1.554117379939404e-15,  -1.834897194161405e-17,   1.430763172941826e-18,  -1.349975190004255e-21,  -1.191037651852896e-21,
  -2.005396185161892e-24,   6.446075439766376e-25,  -9.666624346840237e-05,   1.376614855533506e-08,   4.798380931068332e-08,  -2.760103550586934e-10,  -2.334766392813647e-11,
   2.700371865549140e-13,   1.027352175480700e-14,  -1.755439523573337e-16,  -2.072665590300521e-18,   1.616085885286493e-19,  -1.525047640356827e-22,  -1.345314090519615e-22,
  -2.265104111545480e-25,   7.281010114342819e-26,  -1.356652047173131e-02,  -3.316328579935145e-04,   3.521414948178355e-06,   2.695672280863274e-07,   9.723264837049338e-10,
  -1.818211330095078e-10,  -3.003856408599301e-12,   1.012067295819912e-13,   3.906182315780868e-15,  -1.250691431532468e-17,  -2.964849250361299e-18,  -3.702934273707905e-20,
   1.392329743469752e-21,   4.215822465650850e-23,  -1.290653549912721e-02,  -3.154781873711731e-04,   3.350302360041408e-06,   2.564015281503561e-07,   9.237049965592028e-10,
  -1.729141721465573e-10,  -2.854518758828436e-12,   9.627020604887439e-14,   3.712240003592422e-15,  -1.195820038393320e-17,  -2.817917379559249e-18,  -3.513182708371210e-20,
   1.323589234110204e-21,   4.000689646135955e-23,  -1.165121212836034e-02,  -2.847599143850292e-04,   3.024757375787412e-06,   2.313807963353614e-07,   8.317628567305559e-10,
  -1.559977932813331e-10,  -2.571778656820119e-12,   8.688589941815954e-14,   3.344947994789857e-15,  -1.089003237817844e-17,  -2.539544923076482e-18,  -3.156203937446300e-20,
   1.193248354915943e-21,   3.595612202547637e-23,  -9.923490432724185e-03,  -2.424987108649930e-04,   2.576548707488882e-06,   1.969851847797160e-07,   7.062631937114635e-10,
  -1.327641509480499e-10,  -2.185169388737618e-12,   7.398029700672865e-14,   2.842527145251157e-15,  -9.372627847641789e-18,  -2.158544827303092e-18,  -2.672492254183904e-20,
   1.014649143266504e-21,   3.046043315711680e-23,  -7.892536464333666e-03,  -1.928415670862300e-04,   2.049478120294041e-06,   1.566044445171634e-07,   5.600529677618557e-10,
  -1.055143347722162e-10,  -1.733903033672688e-12,   5.882264036059241e-14,   2.255829506832650e-15,  -7.529391825738306e-18,  -1.713365729271605e-18,  -2.113462189135196e-20,
   8.057085615415550e-22,   2.410025805039448e-23,  -5.757162719696678e-03,  -1.406512141364731e-04,   1.495125526086993e-06,   1.141956816577190e-07,   4.075497460716855e-10,
  -7.692087939416794e-11,  -1.262409759954905e-12,   4.289791524646693e-14,   1.642599857167832e-15,  -5.536193158684000e-18,  -1.247802911243642e-18,  -1.534576816609591e-20,
   5.869650340445176e-22,   1.750590185085273e-23,  -3.726370054874638e-03,  -9.103083736343489e-05,   9.677945248717552e-07,   7.389762499724396e-08,   2.633721843715256e-10,
  -4.976802662562793e-11,  -8.160899031601315e-13,   2.776176944910278e-14,   1.061946142832511e-15,  -3.602089160650404e-18,  -8.067951018607462e-19,  -9.902474692723369e-21,
   3.795948930026394e-22,   1.129930509733312e-23,  -1.998909346062232e-03,  -4.882913201427662e-05,   5.191641106016340e-07,   3.963582938178247e-08,   1.411638108289778e-10,
  -2.669128904036162e-11,  -4.374896525206671e-13,   1.489086789034455e-14,   5.693105799919752e-16,  -1.937398593404483e-18,  -4.325476199015016e-19,  -5.303603508596972e-21,
   2.035342663005704e-22,   6.052528589157674e-24,  -7.438469524316986e-04,  -1.817036697277679e-05,   1.931969015033969e-07,   1.474895190373750e-08,   5.251589078762735e-11,
  -9.931833008599218e-12,  -1.627652640718494e-13,   5.541132880576699e-15,   2.118112916370286e-16,  -7.216246166609502e-19,  -1.609318871083650e-19,  -1.972535425477040e-21,
   7.572893898802765e-23,   2.251182824486990e-24,  -8.402326772150991e-05,  -2.052479170446019e-06,   2.182312451379617e-08,   1.665997697114670e-09,   5.931809233907582e-12,
  -1.121864815793761e-12,  -1.838494711545541e-14,   6.259110948567585e-16,   2.392493159057426e-17,  -8.152504448092923e-20,  -1.817795486887463e-20,  -2.227938612816006e-22,
   8.553962696821925e-24,   2.542683912994018e-25,  -4.782540699298779e-03,  -2.854406834230202e-04,  -9.652997049617475e-06,  -1.980854724430548e-07,  -7.324129937643641e-10,
   1.298653397395380e-10,   6.064111015984795e-12,   1.486311455390382e-13,   1.357457009314005e-15,  -5.801226832531623e-17,  -3.288067361747666e-18,  -8.627955918479718e-20,
  -1.009395077889574e-21,   2.131633802734452e-23,  -4.550203509041564e-03,  -2.715743468755369e-04,  -9.183596111028329e-06,  -1.884116362593585e-07,  -6.940796780121684e-10,
   1.236411437025567e-10,   5.770255354528618e-12,   1.413386220101907e-13,   1.287015205184404e-15,  -5.533111648916221e-17,  -3.130068952496420e-18,  -8.203161294295811e-20,
  -9.561521210990984e-22,   2.041551858422983e-23,  -4.108155198111673e-03,  -2.451918521690287e-04,  -8.290691388060092e-06,  -1.700266763987664e-07,  -6.222655682485068e-10,
   1.117643690369914e-10,   5.210854555801613e-12,   1.274928381749165e-13,   1.154817704904629e-15,  -5.017400412079732e-17,  -2.828740598010575e-18,  -7.397194444653443e-20,
  -8.565548280483737e-22,   1.864666285506200e-23,  -3.499501590812734e-03,  -2.088655946472654e-04,  -7.061615088996992e-06,  -1.447525644996423e-07,  -5.255557861256870e-10,
   9.534444372114975e-11,   4.440029926052108e-12,   1.084852445571760e-13,   9.763391450575399e-16,  -4.296494297353489e-17,  -2.412462471959809e-18,  -6.291875656194201e-20,
  -7.227302243368749e-22,   1.610474259649599e-23,  -2.783699872239621e-03,  -1.661439683003154e-04,  -5.616625716608088e-06,  -1.150798771668741e-07,  -4.145689384852479e-10,
   7.594940156955374e-11,   3.532770665471546e-12,   8.620344763202184e-14,   7.709303276127080e-16,  -3.434996566422349e-17,  -1.921171858461339e-18,  -4.997624537790522e-20,
  -5.695483308094382e-22,   1.298087422129813e-23,  -2.030794265912477e-03,  -1.212074350762651e-04,  -4.097159726514278e-06,  -8.391641070209832e-08,  -3.003911207824557e-10,
   5.547029566438976e-11,   2.577802708579774e-12,   6.283398306843537e-14,   5.590632548947691e-16,  -2.516106427304459e-17,  -1.402817891591402e-18,  -3.641611327700428e-20,
  -4.123533205504734e-22,   9.569908199773567e-24,  -1.314551203261260e-03,  -7.845878928070671e-05,  -2.651982136443035e-06,  -5.430363132469722e-08,  -1.935691863806505e-10,
   3.593329690683285e-11,   1.668863845765023e-12,   4.064983117019461e-14,   3.604515574980956e-16,  -1.633045463817253e-17,  -9.085948709705102e-19,  -2.355396022619881e-20,
  -2.655714151897185e-22,   6.237412708993596e-24,  -7.051834912097712e-04,  -4.208880754314799e-05,  -1.422600492362501e-06,  -2.912640713179877e-08,  -1.035975779711058e-10,
   1.928361481697261e-11,   8.953154538380864e-13,   2.179998189983860e-14,   1.929667615115332e-16,  -8.772350484808634e-18,  -4.875584525076539e-19,  -1.263027316445856e-20,
  -1.420925289753001e-22,   3.357789798480334e-24,  -2.624210816791484e-04,  -1.566258141721812e-05,  -5.293894326168905e-07,  -1.083827884715314e-08,  -3.852065474169844e-11,
   7.177001680951296e-12,   3.331833440467058e-13,   8.111635012403800e-15,   7.175781476762580e-17,  -3.266019333079864e-18,  -1.814550570593578e-19,  -4.699460872488426e-21,
  -5.282896159848691e-23,   1.251063371603326e-24,  -2.964255729768006e-05,  -1.769213765414632e-06,  -5.979867164415609e-08,  -1.224259798128159e-09,  -4.350654939044043e-12,
   8.107168504039524e-13,   3.763586600184360e-14,   9.162591276269303e-16,   8.104700205705053e-18,  -3.689507578210385e-19,  -2.049714096913367e-20,  -5.308297497849386e-22,
  -5.966589807435893e-24,   1.413449092127731e-25,  -1.773348804435628e-04,   5.504477789189236e-06,  -1.143661115911701e-07,   1.935066380819892e-09,  -3.031413009889259e-11,
   4.451322944044817e-13,  -3.878702942308638e-15,   1.379191018528972e-16,  -4.902822259583020e-19,  -4.089691766829935e-20,  -2.035105237152732e-21,  -1.166243713984559e-23,
   7.837238146947938e-25,   2.047655614795211e-26,  -1.687126614505958e-04,   5.236911017368447e-06,  -1.088087178641925e-07,   1.841076715731115e-09,  -2.884137214550244e-11,
   4.235668126882211e-13,  -3.690465192603684e-15,   1.311667727539307e-16,  -4.691448150402535e-19,  -3.892629224340788e-20,  -1.934576953174546e-21,  -1.104767358496096e-23,
   7.458067564062829e-25,   1.948167077293522e-26,  -1.523108413614649e-04,   4.727898538755935e-06,  -9.823572771440265e-08,   1.662243888791534e-09,  -2.603931662713809e-11,
   3.825118770982822e-13,  -3.332246651378351e-15,   1.183408946995273e-16,  -4.278347073449085e-19,  -3.517026643709184e-20,  -1.743986192526474e-21,  -9.897625932931948e-24,
   6.736033726030822e-25,   1.758883861639860e-26,  -1.297329871316266e-04,   4.027166768708834e-06,  -8.367899085864758e-08,   1.415997152979684e-09,  -2.218125391681157e-11,
   3.259368741149346e-13,  -2.838870255462630e-15,   1.007221572964713e-16,  -3.688377403667594e-19,  -2.998576783527660e-20,  -1.482873675743787e-21,  -8.352150229317055e-24,
   5.740653215885911e-25,   1.498271005375143e-26,  -1.031877275410437e-04,   3.203234727920197e-06,  -6.656112135010374e-08,   1.126384453910726e-09,  -1.764410186341095e-11,
   2.593432835169154e-13,  -2.258447936283045e-15,   8.005389251829313e-17,  -2.967798198329079e-19,  -2.387248631682180e-20,  -1.177454127894817e-21,  -6.582722341251926e-24,
   4.568476989800361e-25,   1.191792291064573e-26,  -7.527321916739873e-05,   2.336740499600379e-06,  -4.855729337772270e-08,   8.217442315378085e-10,  -1.287184687808768e-11,
   1.892427950547607e-13,  -1.647756515223751e-15,   5.836287399280493e-17,  -2.184973947051106e-19,  -1.742746567084163e-20,  -8.577506023686472e-22,  -4.766426638058302e-24,
   3.334053663064255e-25,   8.694391379896080e-27,  -4.872272111405609e-05,   1.512542767953716e-06,  -3.143110549106084e-08,   5.319276191873281e-10,  -8.332033080063203e-12,
   1.225173252781145e-13,  -1.066672064898949e-15,   3.776217041841242e-17,  -1.422846699044850e-19,  -1.128595960577939e-20,  -5.546999492245517e-22,  -3.070009332711916e-24,
   2.158683664108071e-25,   5.627914468062483e-27,  -2.613639114078622e-05,   8.113811207427272e-07,  -1.686090972929223e-08,   2.853509869599227e-10,  -4.469663901119426e-12,
   6.572889176124109e-14,  -5.722280420460760e-16,   2.025271698439797e-17,  -7.656166973155550e-20,  -6.055663984727634e-21,  -2.974197051025369e-22,  -1.642663010453982e-24,
   1.158157665765652e-25,   3.019050816780147e-27,  -9.726095638693670e-06,   3.019387892838399e-07,  -6.274461306957033e-09,   1.061883157799080e-10,  -1.663302314548811e-12,
   2.446046935776250e-14,  -2.129464782232434e-16,   7.536082832579130e-18,  -2.852130361602570e-20,  -2.253682027124757e-21,  -1.106603795231143e-22,  -6.107395175914590e-25,
   4.310058028217934e-26,   1.123482768372017e-27,  -1.098638717678679e-06,   3.410636595158887e-08,  -7.087502268345959e-10,   1.199482183072791e-11,  -1.878832644133146e-13,
   2.763017399905723e-15,  -2.405404735106529e-17,   8.512501085098218e-19,  -3.222251872453160e-21,  -2.545745745605252e-22,  -1.249963499998475e-23,  -6.897809588073547e-26,
   4.868588358599288e-27,   1.269063251660202e-28,  -1.579151591149009e-03,   4.733226509137691e-05,  -9.202294957968938e-07,   1.384307991479317e-08,  -1.816193478697717e-10,
   2.032993682585406e-12,   3.158109890775057e-15,   6.131021023357785e-16,   5.926513266150805e-18,  -5.271178310793987e-19,  -1.696546542972004e-20,  -1.327199905728340e-22,
   7.566725043703039e-24,   1.879703801098053e-25,  -1.502368543088370e-03,   4.503124393360264e-05,  -8.755016233328697e-07,   1.317035351938105e-08,  -1.727838961821330e-10,
   1.934488310162848e-12,   3.009302644104161e-15,   5.827149929336119e-16,   5.615669957186065e-18,  -5.016914802269965e-19,  -1.612539239632899e-20,  -1.258284599792353e-22,
   7.200448966573296e-24,   1.788344329096028e-25,  -1.356307368932419e-03,   4.065393938049529e-05,  -7.904109875687769e-07,   1.189050589706777e-08,  -1.559784453528841e-10,
   1.746964971853091e-12,   2.724275773115200e-15,   5.251448579418646e-16,   5.033614302902821e-18,  -4.532401912782337e-19,  -1.453351630163342e-20,  -1.128971718484537e-22,
   6.503048135344689e-24,   1.614540143290233e-25,  -1.155249812806043e-03,   3.462812268460172e-05,  -6.732682459721828e-07,   1.012846967913034e-08,  -1.328488482481675e-10,
   1.488561213758488e-12,   2.328158965838586e-15,   4.463518175226922e-16,   4.250301231008913e-18,  -3.863840361834953e-19,  -1.235419849596400e-20,  -9.544234790202486e-23,
   5.541778794714392e-24,   1.375264292136290e-25,  -9.188651382402183e-04,   2.754311737817662e-05,  -5.355263769684191e-07,   8.056467678262823e-09,  -1.056598003402139e-10,
   1.184410310629706e-12,   1.857710632358709e-15,   3.542894246835112e-16,   3.351975691094090e-18,  -3.075778769149383e-19,  -9.807090319832622e-21,  -7.535793628925937e-23,
   4.409965637297545e-24,   1.093908717413140e-25,  -6.702900862030329e-04,   2.009235220681973e-05,  -3.906658718823689e-07,   5.877272258160065e-09,  -7.707287555587665e-11,
   8.642543508460461e-13,   1.358626130829006e-15,   2.580159753955827e-16,   2.428375071907626e-18,  -2.245198386700467e-19,  -7.142740500355956e-21,  -5.464554363886292e-23,
   3.218228904106188e-24,   7.980084544072489e-26,  -4.338632880546755e-04,   1.300544736584912e-05,  -2.528742202051295e-07,   3.804339030071433e-09,  -4.988603054551997e-11,
   5.595210203344101e-13,   8.808865176177856e-16,   1.668239560436382e-16,   1.564646849097301e-18,  -1.453900969539951e-19,  -4.618498430686799e-21,  -3.523125441055944e-23,
   2.083629616061777e-24,   5.165445468140311e-26,  -2.327375761354555e-04,   6.976557248338844e-06,  -1.356509281215698e-07,   2.040796240598216e-09,  -2.675999434967200e-11,
   3.001742883344057e-13,   4.729411716516567e-16,   8.943883807074113e-17,   8.373464103902446e-19,  -7.800919281767998e-20,  -2.476172831771068e-21,  -1.886068410540166e-23,
   1.117873382979113e-24,   2.770936771804737e-26,  -8.660824815871925e-05,   2.596179384655315e-06,  -5.047974134026931e-08,   7.594422764533598e-10,  -9.958100152175238e-12,
   1.117072511593514e-13,   1.760474288882719e-16,   3.327616572711296e-17,   3.113441730336103e-19,  -2.903169425952929e-20,  -9.212816350816172e-22,  -7.013616075851241e-24,
   4.160119003522026e-25,   1.031148428360775e-26,  -9.783079706404658e-06,   2.932588720028942e-07,  -5.702085344820166e-09,   8.578502548933744e-11,  -1.124844441612657e-12,
   1.261827834424697e-14,   1.988687825227281e-17,   3.758685843141878e-18,   3.516417065464648e-20,  -3.279397711268151e-21,  -1.040628823743136e-22,  -7.921535990748812e-25,
   4.699215150246945e-26,   1.164763655978241e-27,  -4.282030202120885e-03,   1.183172474487187e-04,  -1.932461947635931e-06,   1.935704527783861e-08,  -6.722346335648494e-11,
  -2.341853415631667e-12,   1.279598845901008e-13,   5.588513926572011e-16,   2.400744281972942e-17,  -1.422009219479171e-18,  -5.522860102529934e-20,  -3.116524632146255e-22,
   2.154715634165828e-23,   5.694285132400181e-25,  -4.073808310369771e-03,   1.125639826267376e-04,  -1.838478212704714e-06,   1.841481703081165e-08,  -6.389655356690312e-11,
  -2.227603176585060e-12,   1.217554374058610e-13,   5.301433303182094e-16,   2.276617120800936e-17,  -1.353339154351281e-18,  -5.249993719289099e-20,  -2.951732231987393e-22,
   2.050326865444193e-23,   5.417232877686188e-25,  -3.677723378669109e-03,   1.016199213783085e-04,  -1.659705694471099e-06,   1.662287509365180e-08,  -5.759160683910290e-11,
  -2.010426521753635e-12,   1.099458412072768e-13,   4.761565946670286e-16,   2.043510166959336e-17,  -1.222515954721291e-18,  -4.732690183995036e-20,  -2.643645248770775e-22,
   1.851603739008062e-23,   4.890283483104106e-25,  -3.132513950050124e-03,   8.655535374220149e-05,  -1.413637079069855e-06,   1.415702659365313e-08,  -4.895860999145101e-11,
  -1.711779066886472e-12,   9.367582775191262e-14,   4.030516195024951e-16,   1.728469124995033e-17,  -1.042058778668944e-18,  -4.024017449891528e-20,  -2.230005526285697e-22,
   1.577761390150486e-23,   4.165065524903000e-25,  -2.491524492945937e-03,   6.884417134711642e-05,  -1.124354253402353e-06,   1.125894132708874e-08,  -3.886692069427884e-11,
  -1.361038441388108e-12,   7.452978767551647e-14,   3.186335363352515e-16,   1.365450626861384e-17,  -8.294237843576907e-19,  -3.195145682840227e-20,  -1.756915252012598e-22,
   1.255422308251553e-23,   3.312599800927228e-25,  -1.817494831821184e-03,   5.021992749463975e-05,  -8.201732889951380e-07,   8.212360598523511e-09,  -2.830906245217143e-11,
  -9.925635958805636e-13,   5.438039178949123e-14,   2.312912471841078e-16,   9.905783985547378e-18,  -6.053888438823664e-19,  -2.327557638902280e-20,  -1.271760761386658e-22,
   9.160972382589240e-24,   2.416334711199950e-25,  -1.176417051660657e-03,   3.250609417880352e-05,  -5.308722997094744e-07,   5.315343226092378e-09,  -1.830522776282971e-11,
  -6.423434372189719e-13,   3.520458546275637e-14,   1.492199444892470e-16,   6.388341851039447e-18,  -3.920007713798544e-19,  -1.505194957867470e-20,  -8.189615041915431e-23,
   5.930966237413450e-24,   1.563983553592027e-25,  -6.310647138943200e-04,   1.743723716035808e-05,  -2.847742780349185e-07,   2.851222779360723e-09,  -9.814368511874062e-12,
  -3.445396968043495e-13,   1.888630815835848e-14,   7.991127685118702e-17,   3.420447117773872e-18,  -2.103215114392391e-19,  -8.070527350470760e-21,  -4.381536164341271e-23,
   3.181906801921513e-24,   8.389539183824572e-26,  -2.348368737385237e-04,   6.488886402933564e-06,  -1.059723326128455e-07,   1.061009098759284e-09,  -3.651541872830084e-12,
  -1.282087108850906e-13,   7.028323171451208e-15,   2.971977990636935e-17,   1.272009357211339e-18,  -7.827180551962893e-20,  -3.002779738446589e-21,  -1.628988166921719e-23,
   1.184123735971943e-24,   3.121966125163204e-26,  -2.652666005110041e-05,   7.329704552660775e-07,  -1.197040022204920e-08,   1.198490747979645e-10,  -4.124583626340438e-13,
  -1.448210105717649e-14,   7.939075808570891e-16,   3.356768652490713e-18,   1.436684322872054e-19,  -8.841506604710033e-21,  -3.391786579238312e-22,  -1.839799793487684e-24,
   1.337568725354452e-25,   3.526501729483446e-27,  -8.023639237318886e-03,   1.885101637878933e-04,  -1.899409638999386e-06,  -1.156238745517793e-08,   7.051900810174156e-10,
  -1.186867585772051e-11,   1.899829629866926e-13,   5.562405802733157e-15,  -3.070673956848291e-17,  -2.183069931883403e-18,  -1.196071766642656e-19,  -1.007480830290609e-21,
   5.496072935106135e-23,   1.184879018200522e-24,  -7.633423062267971e-03,   1.793399292387643e-04,  -1.806895729216446e-06,  -1.100350701415026e-08,   6.709740238900447e-10,
  -1.128791785101199e-11,   1.807156568866195e-13,   5.289500943116767e-15,  -2.937228856442286e-17,  -2.078505719667895e-18,  -1.136815544657381e-19,  -9.557295859390109e-22,
   5.229151455536404e-23,   1.127199772082310e-24,  -6.891164908741609e-03,   1.618975280536470e-04,  -1.630975006331716e-06,  -9.939021985417364e-09,   6.058568050060934e-10,
  -1.018465951221755e-11,   1.630987694152109e-13,   4.771356843596336e-15,  -2.676913174858829e-17,  -1.878947672072262e-18,  -1.024541905654225e-19,  -8.584095319564933e-22,
   4.721283693825000e-23,   1.017507596552790e-24,  -5.869489845352789e-03,   1.378909400282978e-04,  -1.388940179883290e-06,  -8.471110314753349e-09,   5.161639384901132e-10,
  -8.668884708797379e-12,   1.388718906858641e-13,   4.060040482393541e-15,  -2.306059188236224e-17,  -1.602996122771960e-18,  -8.708606305244735e-20,  -7.266249691525835e-22,
   4.021953884375873e-23,   8.665671175530201e-25,  -4.668382626357511e-03,   1.096705389246202e-04,  -1.104536884358333e-06,  -6.741967481589427e-09,   4.106392337760525e-10,
  -6.890437478928873e-12,   1.104179514663096e-13,   3.226180740259204e-15,  -1.854224242893146e-17,  -1.276980286611363e-18,  -6.912738400432982e-20,  -5.744434416541572e-22,
   3.199429894838597e-23,   6.891716861414608e-25,  -3.405411410110297e-03,   7.999881952806057e-05,  -8.056148056553677e-07,  -4.920569011623090e-09,   2.996053038194039e-10,
  -5.023684191694732e-12,   8.052463927351600e-14,   2.351596508113728e-15,  -1.364366939650275e-17,  -9.326893881181666e-19,  -5.034489411113155e-20,  -4.169854808180955e-22,
   2.33417392534