//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/SampleDesigner/MesocrystalForm.h
//! @brief     Defines class MesocrystalForm
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2021
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_MESOCRYSTALFORM_H
#define BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_MESOCRYSTALFORM_H

#include <QComboBox>
#include <QFormLayout>
#include <QGroupBox>

class MesocrystalItem;
class SampleEditorController;
class ItemWithParticles;

//! Form for editing a mesocrystal
class MesocrystalForm : public QGroupBox {
    Q_OBJECT
public:
    MesocrystalForm(QWidget* parent, MesocrystalItem* mesocrystalItem, SampleEditorController* ec,
                    bool allowRemove = true);

    void enableStructureEditing(bool b);
    MesocrystalItem* mesocrystalItem() const;
    void createBasisWidgets();

private:
    QComboBox* createBasisCombo(QWidget* parent, ItemWithParticles* current);

    void onBasisComboChanged();

    QFormLayout* m_layout;
    MesocrystalItem* m_item;
    QAction* m_removeAction = nullptr;
    QAction* m_duplicateAction = nullptr;
    SampleEditorController* m_ec;
    QComboBox* m_basisCombo;
    int m_rowOfBasisTypeCombo;
};


#endif // BORNAGAIN_GUI_VIEW_SAMPLEDESIGNER_MESOCRYSTALFORM_H
