# Generated by Django 3.2.12 on 2022-09-05 15:00

from django.db import migrations
from django.db.backends.base.schema import BaseDatabaseSchemaEditor
from django.db.migrations.state import StateApps

from debusine.db.models import DEFAULT_FILE_STORE_NAME, DEFAULT_WORKSPACE_NAME


def create_system_workspace(
    apps: StateApps, schema_editor: BaseDatabaseSchemaEditor
) -> None:
    Workspace = apps.get_model("db", "Workspace")
    FileStore = apps.get_model("db", "FileStore")

    Workspace.objects.create(
        name=DEFAULT_WORKSPACE_NAME,
        default_file_store=FileStore.objects.get(name=DEFAULT_FILE_STORE_NAME),
    )


class Migration(migrations.Migration):
    dependencies = [
        ('db', '0002_create_default_store'),
    ]

    operations = [migrations.RunPython(create_system_workspace)]
