/*
 * Decompiled with CFR 0.152.
 */
package dumphd.aacs;

import dumphd.aacs.AACSDecrypter;
import dumphd.bdplus.SubTable;
import dumphd.util.TSAlignedUnit;
import dumphd.util.TSParserException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.concurrent.Semaphore;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class PackDecrypter {
    private PackDecrypterThread[] pdts = null;
    private Thread[] threads = null;
    private byte[] packBuffer = null;
    private Semaphore[] packGuard = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PackDecrypter(int decrypterThreads, int queueLength) throws GeneralSecurityException {
        if (decrypterThreads <= 0) throw new IllegalArgumentException("decrypterThreads must be greater than 0");
        if (queueLength <= 0) throw new IllegalArgumentException("queueLength must be greater than 0");
        this.pdts = new PackDecrypterThread[decrypterThreads];
        this.threads = new Thread[decrypterThreads];
        int i = 0;
        while (i < decrypterThreads) {
            PackDecrypterThread pdt = new PackDecrypterThread(queueLength);
            Thread thread = new Thread(pdt);
            thread.setDaemon(true);
            thread.setPriority(6);
            thread.start();
            this.pdts[i] = pdt;
            this.threads[i] = thread;
            ++i;
        }
    }

    public void init(byte[] packBuffer, Semaphore[] packGuard, SubTable subTable) {
        this.waitForDecryption();
        this.packBuffer = packBuffer;
        this.packGuard = packGuard;
        int i = 0;
        while (i < this.pdts.length) {
            if (subTable != null) {
                this.pdts[i].setPatchIterator(subTable.patchIterator());
            } else {
                this.pdts[i].setPatchIterator(null);
            }
            ++i;
        }
    }

    public void updateBaseAddress(long baseAddress) {
        try {
            int i = 0;
            while (i < this.pdts.length) {
                PackDecrypterThread pdt = this.pdts[i];
                WorkUnit wu = pdt.acquireWorkUnit();
                wu.type = 6;
                wu.baseAddress = baseAddress;
                pdt.releaseWorkUnit();
                ++i;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void updateKey(byte[] npk, boolean encrypt) {
        try {
            SecretKeySpec npkKey = new SecretKeySpec(npk, "AES");
            int i = 0;
            while (i < this.pdts.length) {
                PackDecrypterThread pdt = this.pdts[i];
                WorkUnit wu = pdt.acquireWorkUnit();
                wu.type = encrypt ? 4 : 3;
                wu.npkKey = npkKey;
                pdt.releaseWorkUnit();
                ++i;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void updateCpi(int offset) {
        try {
            int i = 0;
            while (i < this.pdts.length) {
                PackDecrypterThread pdt = this.pdts[i];
                WorkUnit wu = pdt.acquireWorkUnit();
                wu.type = 5;
                System.arraycopy(this.packBuffer, offset + 64, wu.dtk_cpi, 4, 12);
                pdt.releaseWorkUnit();
                ++i;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void decryptPack(int offset) {
        try {
            PackDecrypterThread pdt = this.getWorker();
            WorkUnit wu = pdt.acquireWorkUnit();
            wu.type = 0;
            wu.packOffset = offset;
            pdt.releaseWorkUnit();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void decryptAlignedUnit(int offset, boolean bdplusOnly) {
        try {
            PackDecrypterThread pdt = this.getWorker();
            WorkUnit wu = pdt.acquireWorkUnit();
            wu.type = !bdplusOnly ? 1 : 2;
            wu.packOffset = offset;
            pdt.releaseWorkUnit();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void waitForDecryption() {
        try {
            int i = 0;
            while (i < this.pdts.length) {
                this.pdts[i].waitForIdle();
                ++i;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void terminate() {
        if (this.threads != null) {
            int i = 0;
            while (i < this.threads.length) {
                this.threads[i].interrupt();
                try {
                    this.threads[i].join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++i;
            }
        }
        this.pdts = null;
        this.threads = null;
        this.packBuffer = null;
        this.packGuard = null;
    }

    private PackDecrypterThread getWorker() {
        PackDecrypterThread pdt = this.pdts[0];
        int minCapacity = 0;
        int i = 0;
        while (i < this.pdts.length) {
            PackDecrypterThread currentPdt = this.pdts[i];
            int currentCapacity = currentPdt.getFreeCapacity();
            if (currentCapacity > minCapacity) {
                minCapacity = currentCapacity;
                pdt = currentPdt;
            }
            ++i;
        }
        return pdt;
    }

    private final class PackDecrypterThread
    implements Runnable {
        private Cipher aes_128 = null;
        private Cipher aes_128cbcd = null;
        private TSAlignedUnit unit = new TSAlignedUnit();
        private long baseAddress = 0L;
        private byte[] dtk_cpi = new byte[16];
        private byte[] ck = new byte[16];
        private SecretKey ckKey = null;
        private SubTable.PatchIterator patchIt = null;
        private WorkUnit[] queue = null;
        private int putPointer = 0;
        private int getPointer = 0;
        private Semaphore putGuard = null;
        private Semaphore getGuard = new Semaphore(0, false);

        public PackDecrypterThread(int queueLength) throws GeneralSecurityException {
            this.aes_128 = Cipher.getInstance("AES/ECB/NOPADDING");
            this.aes_128cbcd = Cipher.getInstance("AES/CBC/NOPADDING");
            this.queue = new WorkUnit[queueLength];
            int i = 0;
            while (i < this.queue.length) {
                this.queue[i] = new WorkUnit();
                ++i;
            }
            this.putGuard = new Semaphore(queueLength, false);
        }

        public WorkUnit acquireWorkUnit() throws InterruptedException {
            this.putGuard.acquire();
            WorkUnit wu = this.queue[this.putPointer];
            ++this.putPointer;
            if (this.putPointer == this.queue.length) {
                this.putPointer = 0;
            }
            return wu;
        }

        public void releaseWorkUnit() {
            this.getGuard.release();
        }

        public int getFreeCapacity() {
            return this.putGuard.availablePermits();
        }

        public void waitForIdle() throws InterruptedException {
            this.putGuard.acquire(this.queue.length);
            this.putGuard.release(this.queue.length);
        }

        public void setPatchIterator(SubTable.PatchIterator patchIt) {
            this.patchIt = patchIt;
        }

        @Override
        public void run() {
            WorkUnit wu = null;
            try {
                while (true) {
                    this.getGuard.acquire();
                    wu = this.queue[this.getPointer];
                    ++this.getPointer;
                    if (this.getPointer == this.queue.length) {
                        this.getPointer = 0;
                    }
                    switch (wu.type) {
                        case 6: {
                            this.baseAddress = wu.baseAddress;
                            break;
                        }
                        case 3: {
                            try {
                                this.aes_128.init(2, wu.npkKey);
                            }
                            catch (GeneralSecurityException generalSecurityException) {}
                            break;
                        }
                        case 4: {
                            try {
                                this.aes_128.init(1, wu.npkKey);
                            }
                            catch (GeneralSecurityException generalSecurityException) {}
                            break;
                        }
                        case 5: {
                            byte[] temp = this.dtk_cpi;
                            this.dtk_cpi = wu.dtk_cpi;
                            wu.dtk_cpi = temp;
                            break;
                        }
                        case 0: {
                            try {
                                System.arraycopy(PackDecrypter.this.packBuffer, wu.packOffset + 84, this.dtk_cpi, 0, 4);
                                this.aes_128.doFinal(this.dtk_cpi, 0, 16, this.ck);
                                int i = 0;
                                while (i < 16) {
                                    this.ck[i] = (byte)(this.ck[i] ^ this.dtk_cpi[i]);
                                    ++i;
                                }
                                this.ckKey = new SecretKeySpec(this.ck, "AES");
                                this.aes_128cbcd.init(2, (Key)this.ckKey, AACSDecrypter.cbc_iv_spec);
                                int cryptedOffset = wu.packOffset + 128;
                                this.aes_128cbcd.doFinal(PackDecrypter.this.packBuffer, cryptedOffset, 1920, PackDecrypter.this.packBuffer, cryptedOffset);
                            }
                            catch (GeneralSecurityException cryptedOffset) {
                                // empty catch block
                            }
                            PackDecrypter.this.packGuard[wu.packOffset / 2048].release();
                            break;
                        }
                        case 1: {
                            try {
                                System.arraycopy(PackDecrypter.this.packBuffer, wu.packOffset, this.dtk_cpi, 0, 16);
                                this.aes_128.doFinal(this.dtk_cpi, 0, 16, this.ck);
                                int i = 0;
                                while (i < 16) {
                                    this.ck[i] = (byte)(this.ck[i] ^ this.dtk_cpi[i]);
                                    ++i;
                                }
                                this.ckKey = new SecretKeySpec(this.ck, "AES");
                                this.aes_128cbcd.init(2, (Key)this.ckKey, AACSDecrypter.cbc_iv_spec);
                                int cryptedOffset = wu.packOffset + 16;
                                this.aes_128cbcd.doFinal(PackDecrypter.this.packBuffer, cryptedOffset, 6128, PackDecrypter.this.packBuffer, cryptedOffset);
                                this.unit.parse(PackDecrypter.this.packBuffer, wu.packOffset);
                                this.unit.setEncrypted(false);
                            }
                            catch (GeneralSecurityException cryptedOffset) {
                            }
                            catch (TSParserException cryptedOffset) {
                                // empty catch block
                            }
                        }
                        case 2: {
                            if (this.patchIt != null) {
                                long patchOffset = 0L;
                                while (this.patchIt.isValid()) {
                                    patchOffset = this.patchIt.getAddress() - this.baseAddress;
                                    if (patchOffset < (long)wu.packOffset) {
                                        this.patchIt.increment();
                                        continue;
                                    }
                                    if (patchOffset + (long)this.patchIt.getPatchLength() > (long)(wu.packOffset + 6144)) break;
                                    this.patchIt.getPatch(PackDecrypter.this.packBuffer, (int)patchOffset);
                                    this.patchIt.increment();
                                }
                            }
                            PackDecrypter.this.packGuard[wu.packOffset / 6144].release();
                        }
                    }
                    this.putGuard.release();
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private static final class WorkUnit {
        public static final int DECRYPT_PACK = 0;
        public static final int DECRYPT_ALIGNED_UNIT = 1;
        public static final int REMOVE_BDPLUS = 2;
        public static final int UPDATE_KEY_DECRYPT = 3;
        public static final int UPDATE_KEY_ENCRYPT = 4;
        public static final int UPDATE_CPI = 5;
        public static final int UPDATE_BASE_ADDRESS = 6;
        public int type = 0;
        public long baseAddress = 0L;
        public int packOffset = 0;
        public SecretKey npkKey = null;
        public byte[] dtk_cpi = new byte[16];
    }
}

