/*
 * $Id: sig_parallel.c,v 1.15 2012-07-05 21:09:31 potyra Exp $
 *
 * Copyright (C) 2006-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "sig_parallel.h"

void
sig_parallel_send(
	struct sig_parallel *b,
	void *s,
	struct sig_parallel_msg *msg
)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		if (nr == b->nmembers) {
			return;
		}
		if (b->member[nr].s == s) {
			continue;
		}
		b->member[nr].f->recv(b->member[nr].s, msg);
	}
}

void
sig_parallel_connect(
	struct sig_parallel *b,
	void *s,
	const struct sig_parallel_funcs *f
)
{
	assert(b);
	assert(b->type == SIG_GEN_PARALLEL);
	assert(b->nmembers < sizeof(b->member) / sizeof(b->member[0]));

	b->member[b->nmembers].s = s;
	b->member[b->nmembers].f = f;
	b->nmembers++;
}

struct sig_parallel *
sig_parallel_create(const char *name)
{
	struct sig_parallel *sig;

	sig = shm_alloc(sizeof(*sig));
	assert(sig);

	sig->type = SIG_GEN_PARALLEL;
	sig->nmembers = 0;

	return sig;
}

void
sig_parallel_destroy(struct sig_parallel *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_PARALLEL);

	shm_free(sig);
}

void
sig_parallel_suspend(struct sig_parallel *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_suspend(b, size, fSig);
}

void
sig_parallel_resume(struct sig_parallel *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_resume(b, size, fSig);
}
