/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  Class for reporting and monitoring of execution errors
//

#ifndef IERRORSTATUS_H
#define IERRORSTATUS_H


#include "istring.h"
#include "imath.h"


class iErrorStatus
{

public:

	//
	// There functions are needed for AutoPtr signature
	//
	static iErrorStatus* New(const iString &prefix);
	void Delete();

	inline const iString& Message() const { return mMessage; } // no Get to fix a VC++7 bug
	inline int Level() const { return mLevel; }

	inline bool NoError() const { return mMessage.IsEmpty(); }
	inline bool IsError() const { return !mMessage.IsEmpty(); }
	inline bool IsAbort() const { return mMessage == mAbortMessage; }

	void Clear();
	void Set(const iString &msg, int lev = iMath::_IntMax);
	void SetAbort(int lev = iMath::_IntMax);

	void Monitor(iErrorStatus *object, bool prefixed = false, const iString &prefix = "");
	void SetSupervisorPrefix(const iString &prefix);

private:

	iErrorStatus(const iString &prefix);
	~iErrorStatus();

	int mLevel;
	bool mInUpdate;
	iErrorStatus *mSupervisor, *mLastSupervisor;
	iString mMessage, mSupervisorPrefix;
	const iString mPrefix;

	static const iString mAbortMessage;
};

#endif  // IERRORSTATUS_H
