/*
 * TestLaTeXDrawCursor.java
 */

package junit.test;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;

import javax.swing.ImageIcon;

import junit.framework.TestCase;

import org.junit.Test;

/** 
 * This class contains tests the methods of the class <code>TestLaTeXDrawCursor</code>.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * 
 * <br>
 * 02/14/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
@SuppressWarnings("nls")
public class TestLaTeXDrawCursor extends TestCase
{

	@Test
	public void testGetCursor()
	{
		try 
		{//TODO voir pourquoi ca marche pas.
//			Cursor cursor = LaTeXDrawCursor.getCursor("/res/cursors/RotCWDown.gif", "rotate");//$NON-NLS-1$//$NON-NLS-2$
	        BufferedImage bi = new BufferedImage(32, 32, BufferedImage.TYPE_INT_ARGB);
	        Graphics2D graphic = (Graphics2D)bi.getGraphics();
	        ImageIcon img;
	        URL url = getClass().getResource("/res/cursors/RotCWDown.gif");
			img = new ImageIcon(url);
			graphic.drawImage(img.getImage(), null, null);
			
			assertNotNull(Toolkit.getDefaultToolkit().createCustomCursor(bi,new Point(0,0), "aa"));
			
			graphic.dispose();
			bi.flush();
		}
		catch(Exception e)
		{
			fail();
		}
	}
}


