/* Copyright (c) 2010, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef _VIDC_HWIO_REG_H_
#define _VIDC_HWIO_REG_H_

#include <linux/io.h>
#include <linux/delay.h>
#include <asm/system.h>
#include "vidc.h"

extern u8 *VIDC_BASE_PTR;

#define VIDC_BASE  VIDC_BASE_PTR

#define VIDC_BLACKBIRD_REG_BASE  (VIDC_BASE + 0x00000000)
#define VIDC_BLACKBIRD_REG_BASE_PHYS  0x04400000

#define HWIO_REG_557899_ADDR  (VIDC_BLACKBIRD_REG_BASE + 00000000)
#define HWIO_REG_557899_PHYS  (VIDC_BLACKBIRD_REG_BASE_PHYS + 00000000)
#define HWIO_REG_557899_RMSK  0x3ff
#define HWIO_REG_557899_SHFT  0
#define HWIO_REG_557899_IN  in_dword_masked(HWIO_REG_557899_ADDR,\
	HWIO_REG_557899_RMSK)
#define HWIO_REG_557899_INM(m)  in_dword_masked(HWIO_REG_557899_ADDR, m)
#define HWIO_REG_557899_OUT(v)  out_dword(HWIO_REG_557899_ADDR, v)
#define HWIO_REG_557899_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_557899_ADDR, m, v, HWIO_REG_557899_IN);
#define HWIO_REG_557899_RSTN_RG_MPEG2_BMSK     0x200
#define HWIO_REG_557899_RSTN_RG_MPEG2_SHFT     0x9
#define HWIO_REG_557899_RSTN_RG_MPEG4_BMSK     0x100
#define HWIO_REG_557899_RSTN_RG_MPEG4_SHFT     0x8
#define HWIO_REG_557899_RSTN_RG_VC1_BMSK       0x80
#define HWIO_REG_557899_RSTN_RG_VC1_SHFT       0x7
#define HWIO_REG_557899_RSTN_RG_H264_BMSK      0x40
#define HWIO_REG_557899_RSTN_RG_H264_SHFT      0x6
#define HWIO_REG_557899_RSTN_RG_COMMON_BMSK    0x20
#define HWIO_REG_557899_RSTN_RG_COMMON_SHFT    0x5
#define HWIO_REG_557899_RSTN_DMX_BMSK          0x10
#define HWIO_REG_557899_RSTN_DMX_SHFT          0x4
#define HWIO_REG_557899_RSTN_VI_BMSK           0x8
#define HWIO_REG_557899_RSTN_VI_SHFT           0x3
#define HWIO_REG_557899_RSTN_VIDCCORE_BMSK     0x4
#define HWIO_REG_557899_RSTN_VIDCCORE_SHFT     0x2
#define HWIO_REG_557899_RSTN_MC_BMSK           0x2
#define HWIO_REG_557899_RSTN_MC_SHFT           0x1
#define HWIO_REG_557899_RSTN_RISC_BMSK         0x1
#define HWIO_REG_557899_RSTN_RISC_SHFT         0

#define HWIO_REG_575377_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000008)
#define HWIO_REG_575377_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000008)
#define HWIO_REG_575377_RMSK 0x1
#define HWIO_REG_575377_SHFT 0
#define HWIO_REG_575377_IN  in_dword_masked(\
	HWIO_REG_575377_ADDR, HWIO_REG_575377_RMSK)
#define HWIO_REG_575377_INM(m) \
	in_dword_masked(HWIO_REG_575377_ADDR, m)
#define HWIO_REG_575377_OUT(v) \
	out_dword(HWIO_REG_575377_ADDR, v)
#define HWIO_REG_575377_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_575377_ADDR, m, v, HWIO_REG_575377_IN);
#define HWIO_REG_575377_INTERRUPT_BMSK  0x1
#define HWIO_REG_575377_INTERRUPT_SHFT  0

#define HWIO_REG_611794_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000030)
#define HWIO_REG_611794_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000030)
#define HWIO_REG_611794_RMSK  0xffffffff
#define HWIO_REG_611794_SHFT  0
#define HWIO_REG_611794_IN  in_dword_masked(\
	HWIO_REG_611794_ADDR, HWIO_REG_611794_RMSK)
#define HWIO_REG_611794_INM(m) \
	in_dword_masked(HWIO_REG_611794_ADDR, m)
#define HWIO_REG_611794_OUT(v) \
	out_dword(HWIO_REG_611794_ADDR, v)
#define HWIO_REG_611794_OUTM(m, v) \
	out_dword_masked_ns(HWIO_REG_611794_ADDR, m, v,\
	HWIO_REG_611794_IN);
#define HWIO_REG_611794_HOST2RISC_COMMAND_BMSK 0xffffffff
#define HWIO_REG_611794_HOST2RISC_COMMAND_SHFT 0

#define HWIO_REG_356340_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000034)
#define HWIO_REG_356340_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000034)
#define HWIO_REG_356340_RMSK  0xffffffff
#define HWIO_REG_356340_SHFT  0
#define HWIO_REG_356340_IN  in_dword_masked(\
	HWIO_REG_356340_ADDR, HWIO_REG_356340_RMSK)
#define HWIO_REG_356340_INM(m) \
	in_dword_masked(HWIO_REG_356340_ADDR, m)
#define HWIO_REG_356340_OUT(v) \
	out_dword(HWIO_REG_356340_ADDR, v)
#define HWIO_REG_356340_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_356340_ADDR, m, v, HWIO_REG_356340_IN);
#define HWIO_REG_356340_HOST2RISC_ARG1_BMSK  0xffffffff
#define HWIO_REG_356340_HOST2RISC_ARG1_SHFT  0

#define HWIO_REG_899023_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000038)
#define HWIO_REG_899023_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000038)
#define HWIO_REG_899023_RMSK 0xffffffff
#define HWIO_REG_899023_SHFT 0
#define HWIO_REG_899023_IN  in_dword_masked(\
	HWIO_REG_899023_ADDR, HWIO_REG_899023_RMSK)
#define HWIO_REG_899023_INM(m) \
	in_dword_masked(HWIO_REG_899023_ADDR, m)
#define HWIO_REG_899023_OUT(v) \
	out_dword(HWIO_REG_899023_ADDR, v)
#define HWIO_REG_899023_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_899023_ADDR, m, v, HWIO_REG_899023_IN);
#define HWIO_REG_899023_HOST2RISC_ARG2_BMSK  0xffffffff
#define HWIO_REG_899023_HOST2RISC_ARG2_SHFT  0

#define HWIO_REG_987762_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000003c)
#define HWIO_REG_987762_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000003c)
#define HWIO_REG_987762_RMSK  0xffffffff
#define HWIO_REG_987762_SHFT  0
#define HWIO_REG_987762_IN  in_dword_masked(\
	HWIO_REG_987762_ADDR, HWIO_REG_987762_RMSK)
#define HWIO_REG_987762_INM(m) \
	in_dword_masked(HWIO_REG_987762_ADDR, m)
#define HWIO_REG_987762_OUT(v) \
	out_dword(HWIO_REG_987762_ADDR, v)
#define HWIO_REG_987762_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_987762_ADDR, m, v, HWIO_REG_987762_IN);
#define HWIO_REG_987762_HOST2RISC_ARG3_BMSK  0xffffffff
#define HWIO_REG_987762_HOST2RISC_ARG3_SHFT  0

#define HWIO_REG_544000_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000040)
#define HWIO_REG_544000_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000040)
#define HWIO_REG_544000_RMSK  0xffffffff
#define HWIO_REG_544000_SHFT  0
#define HWIO_REG_544000_IN  in_dword_masked(\
	HWIO_REG_544000_ADDR, HWIO_REG_544000_RMSK)
#define HWIO_REG_544000_INM(m)  \
	in_dword_masked(HWIO_REG_544000_ADDR, m)
#define HWIO_REG_544000_OUT(v)  \
	out_dword(HWIO_REG_544000_ADDR, v)
#define HWIO_REG_544000_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_544000_ADDR, m, v, HWIO_REG_544000_IN);
#define HWIO_REG_544000_HOST2RISC_ARG4_BMSK  0xffffffff
#define HWIO_REG_544000_HOST2RISC_ARG4_SHFT  0

#define HWIO_REG_695082_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000044)
#define HWIO_REG_695082_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000044)
#define HWIO_REG_695082_RMSK  0xffffffff
#define HWIO_REG_695082_SHFT  0
#define HWIO_REG_695082_IN  in_dword_masked(\
	HWIO_REG_695082_ADDR, HWIO_REG_695082_RMSK)
#define HWIO_REG_695082_INM(m) \
	in_dword_masked(HWIO_REG_695082_ADDR, m)
#define HWIO_REG_695082_OUT(v) \
	out_dword(HWIO_REG_695082_ADDR, v)
#define HWIO_REG_695082_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_695082_ADDR, m, v, HWIO_REG_695082_IN);
#define HWIO_REG_695082_RISC2HOST_COMMAND_BMSK  0xffffffff
#define HWIO_REG_695082_RISC2HOST_COMMAND_SHFT  0

#define HWIO_REG_156596_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000048)
#define HWIO_REG_156596_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000048)
#define HWIO_REG_156596_RMSK  0xffffffff
#define HWIO_REG_156596_SHFT  0
#define HWIO_REG_156596_IN  in_dword_masked(\
	HWIO_REG_156596_ADDR, HWIO_REG_156596_RMSK)
#define HWIO_REG_156596_INM(m) \
	in_dword_masked(HWIO_REG_156596_ADDR, m)
#define HWIO_REG_156596_OUT(v) \
	out_dword(HWIO_REG_156596_ADDR, v)
#define HWIO_REG_156596_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_156596_ADDR, m, v, HWIO_REG_156596_IN);
#define HWIO_REG_156596_REG_156596_BMSK  0xffffffff
#define HWIO_REG_156596_REG_156596_SHFT  0

#define HWIO_REG_222292_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000004c)
#define HWIO_REG_222292_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000004c)
#define HWIO_REG_222292_RMSK  0xffffffff
#define HWIO_REG_222292_SHFT  0
#define HWIO_REG_222292_IN  in_dword_masked(\
	HWIO_REG_222292_ADDR, HWIO_REG_222292_RMSK)
#define HWIO_REG_222292_INM(m) \
	in_dword_masked(HWIO_REG_222292_ADDR, m)
#define HWIO_REG_222292_OUT(v) \
	out_dword(HWIO_REG_222292_ADDR, v)
#define HWIO_REG_222292_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_222292_ADDR, m, v, HWIO_REG_222292_IN);
#define HWIO_REG_222292_REG_222292_BMSK  0xffffffff
#define HWIO_REG_222292_REG_222292_SHFT  0

#define HWIO_REG_790962_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000050)
#define HWIO_REG_790962_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000050)
#define HWIO_REG_790962_RMSK  0xffffffff
#define HWIO_REG_790962_SHFT  0
#define HWIO_REG_790962_IN  in_dword_masked(\
	HWIO_REG_790962_ADDR, HWIO_REG_790962_RMSK)
#define HWIO_REG_790962_INM(m) \
	in_dword_masked(HWIO_REG_790962_ADDR, m)
#define HWIO_REG_790962_OUT(v) \
	out_dword(HWIO_REG_790962_ADDR, v)
#define HWIO_REG_790962_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_790962_ADDR, m, v, HWIO_REG_790962_IN);
#define HWIO_REG_790962_REG_790962_BMSK  0xffffffff
#define HWIO_REG_790962_REG_790962_SHFT  0

#define HWIO_REG_679882_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000054)
#define HWIO_REG_679882_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000054)
#define HWIO_REG_679882_RMSK  0xffffffff
#define HWIO_REG_679882_SHFT  0
#define HWIO_REG_679882_IN  in_dword_masked(\
	HWIO_REG_679882_ADDR, HWIO_REG_679882_RMSK)
#define HWIO_REG_679882_INM(m) \
	in_dword_masked(HWIO_REG_679882_ADDR, m)
#define HWIO_REG_679882_OUT(v) \
	out_dword(HWIO_REG_679882_ADDR, v)
#define HWIO_REG_679882_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_679882_ADDR, m, v, HWIO_REG_679882_IN);
#define HWIO_REG_679882_REG_679882_BMSK  0xffffffff
#define HWIO_REG_679882_REG_679882_SHFT  0

#define HWIO_REG_653206_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000058)
#define HWIO_REG_653206_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000058)
#define HWIO_REG_653206_RMSK  0xffffff
#define HWIO_REG_653206_SHFT  0
#define HWIO_REG_653206_IN  in_dword_masked(\
	HWIO_REG_653206_ADDR, HWIO_REG_653206_RMSK)
#define HWIO_REG_653206_INM(m) \
	in_dword_masked(HWIO_REG_653206_ADDR, m)
#define HWIO_REG_653206_YEAR_BMSK   0xff0000
#define HWIO_REG_653206_YEAR_SHFT   0x10
#define HWIO_REG_653206_MONTH_BMSK  0xff00
#define HWIO_REG_653206_MONTH_SHFT  0x8
#define HWIO_REG_653206_DAY_BMSK    0xff
#define HWIO_REG_653206_DAY_SHFT    0

#define HWIO_REG_805993_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000064)
#define HWIO_REG_805993_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000064)
#define HWIO_REG_805993_RMSK  0xffffffff
#define HWIO_REG_805993_SHFT  0
#define HWIO_REG_805993_IN  in_dword_masked(\
	HWIO_REG_805993_ADDR, HWIO_REG_805993_RMSK)
#define HWIO_REG_805993_INM(m) \
	in_dword_masked(HWIO_REG_805993_ADDR, m)
#define HWIO_REG_805993_INTERMEDIATE_STAGE_COUNTER_BMSK  0xffffffff
#define HWIO_REG_805993_INTERMEDIATE_STAGE_COUNTER_SHFT  0

#define HWIO_REG_493355_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000068)
#define HWIO_REG_493355_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000068)
#define HWIO_REG_493355_RMSK  0xffffffff
#define HWIO_REG_493355_SHFT  0
#define HWIO_REG_493355_IN  in_dword_masked(\
	HWIO_REG_493355_ADDR, HWIO_REG_493355_RMSK)
#define HWIO_REG_493355_INM(m) \
	in_dword_masked(HWIO_REG_493355_ADDR, m)
#define HWIO_REG_493355_EXCEPTION_STATUS_BMSK  0xffffffff
#define HWIO_REG_493355_EXCEPTION_STATUS_SHFT  0

#define HWIO_REG_350619_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000080)
#define HWIO_REG_350619_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000080)
#define HWIO_REG_350619_RMSK  0x1
#define HWIO_REG_350619_SHFT  0
#define HWIO_REG_350619_IN  in_dword_masked(\
	HWIO_REG_350619_ADDR, HWIO_REG_350619_RMSK)
#define HWIO_REG_350619_INM(m) \
	in_dword_masked(HWIO_REG_350619_ADDR, m)
#define HWIO_REG_350619_FIRMWARE_STATUS_BMSK  0x1
#define HWIO_REG_350619_FIRMWARE_STATUS_SHFT  0

#define HWIO_REG_64440_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000508)
#define HWIO_REG_64440_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000508)
#define HWIO_REG_64440_RMSK  0xfffe0000
#define HWIO_REG_64440_SHFT  0
#define HWIO_REG_64440_IN  in_dword_masked(\
	HWIO_REG_64440_ADDR, HWIO_REG_64440_RMSK)
#define HWIO_REG_64440_INM(m) \
	in_dword_masked(HWIO_REG_64440_ADDR, m)
#define HWIO_REG_64440_OUT(v) \
	out_dword(HWIO_REG_64440_ADDR, v)
#define HWIO_REG_64440_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_64440_ADDR, m, v,\
	HWIO_REG_64440_IN);
#define HWIO_REG_64440_MC_DRAMBASE_ADDR_BMSK  0xfffe0000
#define HWIO_REG_64440_MC_DRAMBASE_ADDR_SHFT  0x11

#define HWIO_REG_675915_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000050c)
#define HWIO_REG_675915_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000050c)
#define HWIO_REG_675915_RMSK  0xfffe0000
#define HWIO_REG_675915_SHFT  0
#define HWIO_REG_675915_IN  in_dword_masked(\
	HWIO_REG_675915_ADDR, HWIO_REG_675915_RMSK)
#define HWIO_REG_675915_INM(m) \
	in_dword_masked(HWIO_REG_675915_ADDR, m)
#define HWIO_REG_675915_OUT(v) \
	out_dword(HWIO_REG_675915_ADDR, v)
#define HWIO_REG_675915_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_675915_ADDR, m, v,\
	HWIO_REG_675915_IN);
#define HWIO_REG_675915_MC_DRAMBASE_ADDR_BMSK  0xfffe0000
#define HWIO_REG_675915_MC_DRAMBASE_ADDR_SHFT  0x11

#define HWIO_REG_399911_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000510)
#define HWIO_REG_399911_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000510)
#define HWIO_REG_399911_RMSK  0x3
#define HWIO_REG_399911_SHFT  0
#define HWIO_REG_399911_IN  in_dword_masked(\
	HWIO_REG_399911_ADDR, HWIO_REG_399911_RMSK)
#define HWIO_REG_399911_INM(m)  in_dword_masked(HWIO_REG_399911_ADDR, m)
#define HWIO_REG_399911_MC_BUSY_B_BMSK  0x2
#define HWIO_REG_399911_MC_BUSY_B_SHFT  0x1
#define HWIO_REG_399911_MC_BUSY_A_BMSK  0x1
#define HWIO_REG_399911_MC_BUSY_A_SHFT  0

#define HWIO_REG_515200_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000600)
#define HWIO_REG_515200_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000600)
#define HWIO_REG_515200_RMSK  0x1ffff
#define HWIO_REG_515200_SHFT  0
#define HWIO_REG_515200_IN  in_dword_masked(\
	HWIO_REG_515200_ADDR, HWIO_REG_515200_RMSK)
#define HWIO_REG_515200_INM(m) \
	in_dword_masked(HWIO_REG_515200_ADDR, m)
#define HWIO_REG_515200_OUT(v) \
	out_dword(HWIO_REG_515200_ADDR, v)
#define HWIO_REG_515200_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_515200_ADDR, m, v,\
	HWIO_REG_515200_IN);
#define HWIO_REG_515200_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_515200_BASE_ADDR_SHFT  0

#define HWIO_REG_29510_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000604)
#define HWIO_REG_29510_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000604)
#define HWIO_REG_29510_RMSK  0x1ffff
#define HWIO_REG_29510_SHFT  0
#define HWIO_REG_29510_IN  in_dword_masked(\
	HWIO_REG_29510_ADDR, HWIO_REG_29510_RMSK)
#define HWIO_REG_29510_INM(m) \
	in_dword_masked(HWIO_REG_29510_ADDR, m)
#define HWIO_REG_29510_OUT(v) \
	out_dword(HWIO_REG_29510_ADDR, v)
#define HWIO_REG_29510_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_29510_ADDR, m, v,\
	HWIO_REG_29510_IN);
#define HWIO_REG_29510_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_29510_BASE_ADDR_SHFT  0

#define HWIO_REG_256132_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000608)
#define HWIO_REG_256132_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000608)
#define HWIO_REG_256132_RMSK  0x1ffff
#define HWIO_REG_256132_SHFT  0
#define HWIO_REG_256132_IN  in_dword_masked(\
	HWIO_REG_256132_ADDR, HWIO_REG_256132_RMSK)
#define HWIO_REG_256132_INM(m) \
	in_dword_masked(HWIO_REG_256132_ADDR, m)
#define HWIO_REG_256132_OUT(v) \
	out_dword(HWIO_REG_256132_ADDR, v)
#define HWIO_REG_256132_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_256132_ADDR, m, v,\
	HWIO_REG_256132_IN);
#define HWIO_REG_256132_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_256132_BASE_ADDR_SHFT  0

#define HWIO_REG_885152_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000060c)
#define HWIO_REG_885152_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000060c)
#define HWIO_REG_885152_RMSK  0x1ffff
#define HWIO_REG_885152_SHFT  0
#define HWIO_REG_885152_IN  in_dword_masked(\
	HWIO_REG_885152_ADDR, HWIO_REG_885152_RMSK)
#define HWIO_REG_885152_INM(m) \
	in_dword_masked(HWIO_REG_885152_ADDR, m)
#define HWIO_REG_885152_OUT(v) \
	out_dword(HWIO_REG_885152_ADDR, v)
#define HWIO_REG_885152_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_885152_ADDR, m, v,\
	HWIO_REG_885152_IN);
#define HWIO_REG_885152_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_885152_BASE_ADDR_SHFT  0

#define HWIO_REG_69832_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000610)
#define HWIO_REG_69832_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000610)
#define HWIO_REG_69832_RMSK 0x1ffff
#define HWIO_REG_69832_SHFT 0
#define HWIO_REG_69832_IN  in_dword_masked(\
	HWIO_REG_69832_ADDR, HWIO_REG_69832_RMSK)
#define HWIO_REG_69832_INM(m) \
	in_dword_masked(HWIO_REG_69832_ADDR, m)
#define HWIO_REG_69832_OUT(v) \
	out_dword(HWIO_REG_69832_ADDR, v)
#define HWIO_REG_69832_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_69832_ADDR, m, v,\
	HWIO_REG_69832_IN);
#define HWIO_REG_69832_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_69832_BASE_ADDR_SHFT  0

#define HWIO_REG_686205_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000614)
#define HWIO_REG_686205_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000614)
#define HWIO_REG_686205_RMSK  0x1ffff
#define HWIO_REG_686205_SHFT  0
#define HWIO_REG_686205_IN  in_dword_masked(\
	HWIO_REG_686205_ADDR, HWIO_REG_686205_RMSK)
#define HWIO_REG_686205_INM(m) \
	in_dword_masked(HWIO_REG_686205_ADDR, m)
#define HWIO_REG_686205_OUT(v) \
	out_dword(HWIO_REG_686205_ADDR, v)
#define HWIO_REG_686205_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_686205_ADDR, m, v,\
	HWIO_REG_686205_IN);
#define HWIO_REG_686205_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_686205_BASE_ADDR_SHFT  0

#define HWIO_REG_728036_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000618)
#define HWIO_REG_728036_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000618)
#define HWIO_REG_728036_RMSK 0x1ffff
#define HWIO_REG_728036_SHFT 0
#define HWIO_REG_728036_IN  in_dword_masked(\
	HWIO_REG_728036_ADDR, HWIO_REG_728036_RMSK)
#define HWIO_REG_728036_INM(m) \
	in_dword_masked(HWIO_REG_728036_ADDR, m)
#define HWIO_REG_728036_OUT(v) \
	out_dword(HWIO_REG_728036_ADDR, v)
#define HWIO_REG_728036_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_728036_ADDR, m, v,\
	HWIO_REG_728036_IN);
#define HWIO_REG_728036_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_728036_BASE_ADDR_SHFT  0

#define HWIO_REG_294579_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000061c)
#define HWIO_REG_294579_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000061c)
#define HWIO_REG_294579_RMSK  0x1ffff
#define HWIO_REG_294579_SHFT  0
#define HWIO_REG_294579_IN  in_dword_masked(\
	HWIO_REG_294579_ADDR, HWIO_REG_294579_RMSK)
#define HWIO_REG_294579_INM(m) \
	in_dword_masked(HWIO_REG_294579_ADDR, m)
#define HWIO_REG_294579_OUT(v) \
	out_dword(HWIO_REG_294579_ADDR, v)
#define HWIO_REG_294579_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_294579_ADDR, m, v,\
	HWIO_REG_294579_IN);
#define HWIO_REG_294579_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_294579_BASE_ADDR_SHFT  0

#define HWIO_REG_61427_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000620)
#define HWIO_REG_61427_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000620)
#define HWIO_REG_61427_RMSK  0x1ffff
#define HWIO_REG_61427_SHFT  0
#define HWIO_REG_61427_IN  in_dword_masked(\
	HWIO_REG_61427_ADDR, HWIO_REG_61427_RMSK)
#define HWIO_REG_61427_INM(m) \
	in_dword_masked(HWIO_REG_61427_ADDR, m)
#define HWIO_REG_61427_OUT(v) \
	out_dword(HWIO_REG_61427_ADDR, v)
#define HWIO_REG_61427_OUTM(m , v)  out_dword_masked_ns(\
	HWIO_REG_61427_ADDR, m, v,\
	HWIO_REG_61427_IN);
#define HWIO_REG_61427_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_61427_BASE_ADDR_SHFT  0

#define HWIO_REG_578196_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000624)
#define HWIO_REG_578196_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000624)
#define HWIO_REG_578196_RMSK  0x1ffff
#define HWIO_REG_578196_SHFT  0
#define HWIO_REG_578196_IN  in_dword_masked(\
	HWIO_REG_578196_ADDR, HWIO_REG_578196_RMSK)
#define HWIO_REG_578196_INM(m) \
	in_dword_masked(HWIO_REG_578196_ADDR, m)
#define HWIO_REG_578196_OUT(v) \
	out_dword(HWIO_REG_578196_ADDR, v)
#define HWIO_REG_578196_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_578196_ADDR, m, v,\
	HWIO_REG_578196_IN);
#define HWIO_REG_578196_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_578196_BASE_ADDR_SHFT  0

#define HWIO_REG_408588_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000628)
#define HWIO_REG_408588_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000628)
#define HWIO_REG_408588_RMSK  0x1ffff
#define HWIO_REG_408588_SHFT  0
#define HWIO_REG_408588_IN  in_dword_masked(\
	HWIO_REG_408588_ADDR, HWIO_REG_408588_RMSK)
#define HWIO_REG_408588_INM(m) \
	in_dword_masked(HWIO_REG_408588_ADDR, m)
#define HWIO_REG_408588_OUT(v) \
	out_dword(HWIO_REG_408588_ADDR, v)
#define HWIO_REG_408588_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_408588_ADDR, m, v,\
	HWIO_REG_408588_IN);
#define HWIO_REG_408588_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_408588_BASE_ADDR_SHFT  0

#define HWIO_REG_55617_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000062c)
#define HWIO_REG_55617_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000062c)
#define HWIO_REG_55617_RMSK  0x1ffff
#define HWIO_REG_55617_SHFT  0
#define HWIO_REG_55617_IN  in_dword_masked(\
	HWIO_REG_55617_ADDR, HWIO_REG_55617_RMSK)
#define HWIO_REG_55617_INM(m) \
	in_dword_masked(HWIO_REG_55617_ADDR, m)
#define HWIO_REG_55617_OUT(v) \
	out_dword(HWIO_REG_55617_ADDR, v)
#define HWIO_REG_55617_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_55617_ADDR, m, v,\
	HWIO_REG_55617_IN);
#define HWIO_REG_55617_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_55617_BASE_ADDR_SHFT  0

#define HWIO_REG_555239_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000630)
#define HWIO_REG_555239_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000630)
#define HWIO_REG_555239_RMSK  0x1ffff
#define HWIO_REG_555239_SHFT  0
#define HWIO_REG_555239_IN  in_dword_masked(\
	HWIO_REG_555239_ADDR, HWIO_REG_555239_RMSK)
#define HWIO_REG_555239_INM(m) \
	in_dword_masked(HWIO_REG_555239_ADDR, m)
#define HWIO_REG_555239_OUT(v) \
	out_dword(HWIO_REG_555239_ADDR, v)
#define HWIO_REG_555239_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_555239_ADDR, m, v,\
	HWIO_REG_555239_IN);
#define HWIO_REG_555239_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_555239_BASE_ADDR_SHFT  0

#define HWIO_REG_515333_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000634)
#define HWIO_REG_515333_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000634)
#define HWIO_REG_515333_RMSK  0x1ffff
#define HWIO_REG_515333_SHFT  0
#define HWIO_REG_515333_IN  in_dword_masked(\
	HWIO_REG_515333_ADDR, HWIO_REG_515333_RMSK)
#define HWIO_REG_515333_INM(m) \
	in_dword_masked(HWIO_REG_515333_ADDR, m)
#define HWIO_REG_515333_OUT(v) \
	out_dword(HWIO_REG_515333_ADDR, v)
#define HWIO_REG_515333_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_515333_ADDR, m, v,\
	HWIO_REG_515333_IN);
#define HWIO_REG_515333_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_515333_BASE_ADDR_SHFT  0

#define HWIO_REG_951675_ADDR \
	(VIDC_BLACKBIRD_REG_BASE  + 0x00000638)
#define HWIO_REG_951675_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000638)
#define HWIO_REG_951675_RMSK  0x1ffff
#define HWIO_REG_951675_SHFT  0
#define HWIO_REG_951675_IN  in_dword_masked(\
	HWIO_REG_951675_ADDR, HWIO_REG_951675_RMSK)
#define HWIO_REG_951675_INM(m) \
	in_dword_masked(HWIO_REG_951675_ADDR, m)
#define HWIO_REG_951675_OUT(v) \
	out_dword(HWIO_REG_951675_ADDR, v)
#define HWIO_REG_951675_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_951675_ADDR, m, v,\
	HWIO_REG_951675_IN);
#define HWIO_REG_951675_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_951675_BASE_ADDR_SHFT  0

#define HWIO_REG_500775_ADDR \
	(VIDC_BLACKBIRD_REG_BASE  + 0x0000063c)
#define HWIO_REG_500775_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000063c)
#define HWIO_REG_500775_RMSK  0x1ffff
#define HWIO_REG_500775_SHFT  0
#define HWIO_REG_500775_IN  in_dword_masked(\
	HWIO_REG_500775_ADDR, HWIO_REG_500775_RMSK)
#define HWIO_REG_500775_INM(m) \
	in_dword_masked(HWIO_REG_500775_ADDR, m)
#define HWIO_REG_500775_OUT(v) \
	out_dword(HWIO_REG_500775_ADDR, v)
#define HWIO_REG_500775_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_500775_ADDR, m, v,\
	HWIO_REG_500775_IN);
#define HWIO_REG_500775_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_500775_BASE_ADDR_SHFT  0

#define HWIO_REG_649786_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000640)
#define HWIO_REG_649786_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000640)
#define HWIO_REG_649786_RMSK  0x1ffff
#define HWIO_REG_649786_SHFT  0
#define HWIO_REG_649786_IN  in_dword_masked(\
	HWIO_REG_649786_ADDR, HWIO_REG_649786_RMSK)
#define HWIO_REG_649786_INM(m) \
	in_dword_masked(HWIO_REG_649786_ADDR, m)
#define HWIO_REG_649786_OUT(v) \
	out_dword(HWIO_REG_649786_ADDR, v)
#define HWIO_REG_649786_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_649786_ADDR, m, v,\
	HWIO_REG_649786_IN);
#define HWIO_REG_649786_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_649786_BASE_ADDR_SHFT  0

#define HWIO_REG_233366_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000644)
#define HWIO_REG_233366_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000644)
#define HWIO_REG_233366_RMSK  0x1ffff
#define HWIO_REG_233366_SHFT  0
#define HWIO_REG_233366_IN  in_dword_masked(\
	HWIO_REG_233366_ADDR, HWIO_REG_233366_RMSK)
#define HWIO_REG_233366_INM(m) \
	in_dword_masked(HWIO_REG_233366_ADDR, m)
#define HWIO_REG_233366_OUT(v) \
	out_dword(HWIO_REG_233366_ADDR, v)
#define HWIO_REG_233366_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_233366_ADDR, m, v,\
	HWIO_REG_233366_IN);
#define HWIO_REG_233366_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_233366_BASE_ADDR_SHFT  0

#define HWIO_REG_366750_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000648)
#define HWIO_REG_366750_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000648)
#define HWIO_REG_366750_RMSK  0x1ffff
#define HWIO_REG_366750_SHFT  0
#define HWIO_REG_366750_IN  in_dword_masked(\
	HWIO_REG_366750_ADDR, HWIO_REG_366750_RMSK)
#define HWIO_REG_366750_INM(m) \
	in_dword_masked(HWIO_REG_366750_ADDR, m)
#define HWIO_REG_366750_OUT(v) \
	out_dword(HWIO_REG_366750_ADDR, v)
#define HWIO_REG_366750_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_366750_ADDR, m, v,\
	HWIO_REG_366750_IN);
#define HWIO_REG_366750_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_366750_BASE_ADDR_SHFT  0

#define HWIO_REG_616292_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000064c)
#define HWIO_REG_616292_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000064c)
#define HWIO_REG_616292_RMSK  0x1ffff
#define HWIO_REG_616292_SHFT  0
#define HWIO_REG_616292_IN  in_dword_masked(\
	HWIO_REG_616292_ADDR, HWIO_REG_616292_RMSK)
#define HWIO_REG_616292_INM(m) \
	in_dword_masked(HWIO_REG_616292_ADDR, m)
#define HWIO_REG_616292_OUT(v) \
	out_dword(HWIO_REG_616292_ADDR, v)
#define HWIO_REG_616292_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_616292_ADDR, m, v,\
	HWIO_REG_616292_IN);
#define HWIO_REG_616292_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_616292_BASE_ADDR_SHFT  0

#define HWIO_REG_666754_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000650)
#define HWIO_REG_666754_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000650)
#define HWIO_REG_666754_RMSK  0x1ffff
#define HWIO_REG_666754_SHFT  0
#define HWIO_REG_666754_IN  in_dword_masked(\
	HWIO_REG_666754_ADDR, HWIO_REG_666754_RMSK)
#define HWIO_REG_666754_INM(m) \
	in_dword_masked(HWIO_REG_666754_ADDR, m)
#define HWIO_REG_666754_OUT(v) \
	out_dword(HWIO_REG_666754_ADDR, v)
#define HWIO_REG_666754_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_666754_ADDR, m, v,\
	HWIO_REG_666754_IN);
#define HWIO_REG_666754_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_666754_BASE_ADDR_SHFT  0

#define HWIO_REG_650155_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000654)
#define HWIO_REG_650155_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000654)
#define HWIO_REG_650155_RMSK  0x1ffff
#define HWIO_REG_650155_SHFT  0
#define HWIO_REG_650155_IN  in_dword_masked(\
	HWIO_REG_650155_ADDR, HWIO_REG_650155_RMSK)
#define HWIO_REG_650155_INM(m) \
	in_dword_masked(HWIO_REG_650155_ADDR, m)
#define HWIO_REG_650155_OUT(v) \
	out_dword(HWIO_REG_650155_ADDR, v)
#define HWIO_REG_650155_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_650155_ADDR, m, v,\
	HWIO_REG_650155_IN);
#define HWIO_REG_650155_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_650155_BASE_ADDR_SHFT  0

#define HWIO_REG_248198_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000658)
#define HWIO_REG_248198_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000658)
#define HWIO_REG_248198_RMSK  0x1ffff
#define HWIO_REG_248198_SHFT  0
#define HWIO_REG_248198_IN  in_dword_masked(\
	HWIO_REG_248198_ADDR, HWIO_REG_248198_RMSK)
#define HWIO_REG_248198_INM(m) \
	in_dword_masked(HWIO_REG_248198_ADDR, m)
#define HWIO_REG_248198_OUT(v) \
	out_dword(HWIO_REG_248198_ADDR, v)
#define HWIO_REG_248198_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_248198_ADDR, m, v,\
	HWIO_REG_248198_IN);
#define HWIO_REG_248198_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_248198_BASE_ADDR_SHFT  0

#define HWIO_REG_389428_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000065c)
#define HWIO_REG_389428_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000065c)
#define HWIO_REG_389428_RMSK  0x1ffff
#define HWIO_REG_389428_SHFT  0
#define HWIO_REG_389428_IN  in_dword_masked(\
	HWIO_REG_389428_ADDR, HWIO_REG_389428_RMSK)
#define HWIO_REG_389428_INM(m) \
	in_dword_masked(HWIO_REG_389428_ADDR, m)
#define HWIO_REG_389428_OUT(v) \
	out_dword(HWIO_REG_389428_ADDR, v)
#define HWIO_REG_389428_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_389428_ADDR, m, v,\
	HWIO_REG_389428_IN);
#define HWIO_REG_389428_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_389428_BASE_ADDR_SHFT  0

#define HWIO_REG_504308_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000660)
#define HWIO_REG_504308_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000660)
#define HWIO_REG_504308_RMSK  0x1ffff
#define HWIO_REG_504308_SHFT  0
#define HWIO_REG_504308_IN  in_dword_masked(\
	HWIO_REG_504308_ADDR, HWIO_REG_504308_RMSK)
#define HWIO_REG_504308_INM(m) \
	in_dword_masked(HWIO_REG_504308_ADDR, m)
#define HWIO_REG_504308_OUT(v) \
	out_dword(HWIO_REG_504308_ADDR, v)
#define HWIO_REG_504308_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_504308_ADDR, m, v,\
	HWIO_REG_504308_IN);
#define HWIO_REG_504308_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_504308_BASE_ADDR_SHFT  0

#define HWIO_REG_280814_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000664)
#define HWIO_REG_280814_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000664)
#define HWIO_REG_280814_RMSK  0x1ffff
#define HWIO_REG_280814_SHFT  0
#define HWIO_REG_280814_IN  in_dword_masked(\
	HWIO_REG_280814_ADDR, HWIO_REG_280814_RMSK)
#define HWIO_REG_280814_INM(m) \
	in_dword_masked(HWIO_REG_280814_ADDR, m)
#define HWIO_REG_280814_OUT(v) \
	out_dword(HWIO_REG_280814_ADDR, v)
#define HWIO_REG_280814_OUTM(m, v) \
	out_dword_masked_ns(HWIO_REG_280814_ADDR, m, v,\
	HWIO_REG_280814_IN);
#define HWIO_REG_280814_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_280814_BASE_ADDR_SHFT  0

#define HWIO_REG_785484_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000668)
#define HWIO_REG_785484_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000668)
#define HWIO_REG_785484_RMSK  0x1ffff
#define HWIO_REG_785484_SHFT  0
#define HWIO_REG_785484_IN  in_dword_masked(\
	HWIO_REG_785484_ADDR, HWIO_REG_785484_RMSK)
#define HWIO_REG_785484_INM(m) \
	in_dword_masked(HWIO_REG_785484_ADDR, m)
#define HWIO_REG_785484_OUT(v) \
		out_dword(HWIO_REG_785484_ADDR, v)
#define HWIO_REG_785484_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_785484_ADDR, m, v,\
	HWIO_REG_785484_IN);
#define HWIO_REG_785484_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_785484_BASE_ADDR_SHFT  0

#define HWIO_REG_218455_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000066c)
#define HWIO_REG_218455_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000066c)
#define HWIO_REG_218455_RMSK  0x1ffff
#define HWIO_REG_218455_SHFT  0
#define HWIO_REG_218455_IN  in_dword_masked(\
	HWIO_REG_218455_ADDR, HWIO_REG_218455_RMSK)
#define HWIO_REG_218455_INM(m) \
	in_dword_masked(HWIO_REG_218455_ADDR, m)
#define HWIO_REG_218455_OUT(v) \
	out_dword(HWIO_REG_218455_ADDR, v)
#define HWIO_REG_218455_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_218455_ADDR, m, v,\
	HWIO_REG_218455_IN);
#define HWIO_REG_218455_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_218455_BASE_ADDR_SHFT  0

#define HWIO_REG_886591_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000670)
#define HWIO_REG_886591_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000670)
#define HWIO_REG_886591_RMSK  0x1ffff
#define HWIO_REG_886591_SHFT  0
#define HWIO_REG_886591_IN  in_dword_masked(\
	HWIO_REG_886591_ADDR, HWIO_REG_886591_RMSK)
#define HWIO_REG_886591_INM(m) \
	in_dword_masked(HWIO_REG_886591_ADDR, m)
#define HWIO_REG_886591_OUT(v) \
	out_dword(HWIO_REG_886591_ADDR, v)
#define HWIO_REG_886591_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_886591_ADDR, m, v,\
	HWIO_REG_886591_IN);
#define HWIO_REG_886591_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_886591_BASE_ADDR_SHFT  0

#define HWIO_REG_912449_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000674)
#define HWIO_REG_912449_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000674)
#define HWIO_REG_912449_RMSK  0x1ffff
#define HWIO_REG_912449_SHFT  0
#define HWIO_REG_912449_IN  in_dword_masked(\
	HWIO_REG_912449_ADDR, HWIO_REG_912449_RMSK)
#define HWIO_REG_912449_INM(m) \
	in_dword_masked(HWIO_REG_912449_ADDR, m)
#define HWIO_REG_912449_OUT(v) \
	out_dword(HWIO_REG_912449_ADDR, v)
#define HWIO_REG_912449_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_912449_ADDR, m, v,\
	HWIO_REG_912449_IN);
#define HWIO_REG_912449_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_912449_BASE_ADDR_SHFT  0

#define HWIO_REG_1065_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000678)
#define HWIO_REG_1065_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000678)
#define HWIO_REG_1065_RMSK  0x1ffff
#define HWIO_REG_1065_SHFT  0
#define HWIO_REG_1065_IN  in_dword_masked(\
	HWIO_REG_1065_ADDR, HWIO_REG_1065_RMSK)
#define HWIO_REG_1065_INM(m) \
	in_dword_masked(HWIO_REG_1065_ADDR, m)
#define HWIO_REG_1065_OUT(v) \
	out_dword(HWIO_REG_1065_ADDR, v)
#define HWIO_REG_1065_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_1065_ADDR, m, v,\
	HWIO_REG_1065_IN);
#define HWIO_REG_1065_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_1065_BASE_ADDR_SHFT  0

#define HWIO_REG_61838_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000067c)
#define HWIO_REG_61838_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000067c)
#define HWIO_REG_61838_RMSK  0x1ffff
#define HWIO_REG_61838_SHFT  0
#define HWIO_REG_61838_IN  in_dword_masked(\
	HWIO_REG_61838_ADDR, HWIO_REG_61838_RMSK)
#define HWIO_REG_61838_INM(m) \
	in_dword_masked(HWIO_REG_61838_ADDR, m)
#define HWIO_REG_61838_OUT(v) \
	out_dword(HWIO_REG_61838_ADDR, v)
#define HWIO_REG_61838_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_61838_ADDR, m, v,\
	HWIO_REG_61838_IN);
#define HWIO_REG_61838_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_61838_BASE_ADDR_SHFT  0

#define HWIO_REG_169838_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000680)
#define HWIO_REG_169838_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000680)
#define HWIO_REG_169838_RMSK  0x1ffff
#define HWIO_REG_169838_SHFT  0
#define HWIO_REG_169838_IN  in_dword_masked(\
	HWIO_REG_169838_ADDR, HWIO_REG_169838_RMSK)
#define HWIO_REG_169838_INM(m) \
	in_dword_masked(HWIO_REG_169838_ADDR, m)
#define HWIO_REG_169838_OUT(v) \
	out_dword(HWIO_REG_169838_ADDR, v)
#define HWIO_REG_169838_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_169838_ADDR, m, v,\
	HWIO_REG_169838_IN);
#define HWIO_REG_169838_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_169838_BASE_ADDR_SHFT  0

#define HWIO_REG_986147_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000684)
#define HWIO_REG_986147_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000684)
#define HWIO_REG_986147_RMSK  0x1ffff
#define HWIO_REG_986147_SHFT  0
#define HWIO_REG_986147_IN  in_dword_masked(\
	HWIO_REG_986147_ADDR, HWIO_REG_986147_RMSK)
#define HWIO_REG_986147_INM(m) \
	in_dword_masked(HWIO_REG_986147_ADDR, m)
#define HWIO_REG_986147_OUT(v)  \
	out_dword(HWIO_REG_986147_ADDR, v)
#define HWIO_REG_986147_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_986147_ADDR, m, v,\
	HWIO_REG_986147_IN);
#define HWIO_REG_986147_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_986147_BASE_ADDR_SHFT  0

#define HWIO_REG_678637_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000688)
#define HWIO_REG_678637_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000688)
#define HWIO_REG_678637_RMSK  0x1ffff
#define HWIO_REG_678637_SHFT  0
#define HWIO_REG_678637_IN  in_dword_masked(\
	HWIO_REG_678637_ADDR, HWIO_REG_678637_RMSK)
#define HWIO_REG_678637_INM(m) \
	in_dword_masked(HWIO_REG_678637_ADDR, m)
#define HWIO_REG_678637_OUT(v) \
	out_dword(HWIO_REG_678637_ADDR, v)
#define HWIO_REG_678637_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_678637_ADDR, m, v,\
	HWIO_REG_678637_IN);
#define HWIO_REG_678637_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_678637_BASE_ADDR_SHFT  0

#define HWIO_REG_931311_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000068c)
#define HWIO_REG_931311_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000068c)
#define HWIO_REG_931311_RMSK  0x1ffff
#define HWIO_REG_931311_SHFT  0
#define HWIO_REG_931311_IN  in_dword_masked(\
	HWIO_REG_931311_ADDR, HWIO_REG_931311_RMSK)
#define HWIO_REG_931311_INM(m) \
	in_dword_masked(HWIO_REG_931311_ADDR, m)
#define HWIO_REG_931311_OUT(v) \
	out_dword(HWIO_REG_931311_ADDR, v)
#define HWIO_REG_931311_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_931311_ADDR, m, v,\
	HWIO_REG_931311_IN);
#define HWIO_REG_931311_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_931311_BASE_ADDR_SHFT  0

#define HWIO_REG_16277_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000690)
#define HWIO_REG_16277_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000690)
#define HWIO_REG_16277_RMSK  0x1ffff
#define HWIO_REG_16277_SHFT  0
#define HWIO_REG_16277_IN  in_dword_masked(\
	HWIO_REG_16277_ADDR, HWIO_REG_16277_RMSK)
#define HWIO_REG_16277_INM(m) \
	in_dword_masked(HWIO_REG_16277_ADDR, m)
#define HWIO_REG_16277_OUT(v) \
	out_dword(HWIO_REG_16277_ADDR, v)
#define HWIO_REG_16277_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_16277_ADDR, m, v,\
	HWIO_REG_16277_IN);
#define HWIO_REG_16277_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_16277_BASE_ADDR_SHFT  0

#define HWIO_REG_654169_ADDR \
	(VIDC_BLACKBIRD_REG_BASE  + 0x00000694)
#define HWIO_REG_654169_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000694)
#define HWIO_REG_654169_RMSK  0x1ffff
#define HWIO_REG_654169_SHFT  0
#define HWIO_REG_654169_IN  in_dword_masked(\
	HWIO_REG_654169_ADDR, HWIO_REG_654169_RMSK)
#define HWIO_REG_654169_INM(m) \
	in_dword_masked(HWIO_REG_654169_ADDR, m)
#define HWIO_REG_654169_OUT(v) \
	out_dword(HWIO_REG_654169_ADDR, v)
#define HWIO_REG_654169_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_654169_ADDR, m, v,\
	HWIO_REG_654169_IN);
#define HWIO_REG_654169_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_654169_BASE_ADDR_SHFT  0

#define HWIO_REG_802794_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000698)
#define HWIO_REG_802794_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000698)
#define HWIO_REG_802794_RMSK  0x1ffff
#define HWIO_REG_802794_SHFT  0
#define HWIO_REG_802794_IN  in_dword_masked(\
	HWIO_REG_802794_ADDR, HWIO_REG_802794_RMSK)
#define HWIO_REG_802794_INM(m) \
	in_dword_masked(HWIO_REG_802794_ADDR, m)
#define HWIO_REG_802794_OUT(v) \
	out_dword(HWIO_REG_802794_ADDR, v)
#define HWIO_REG_802794_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_802794_ADDR, m, v,\
	HWIO_REG_802794_IN);
#define HWIO_REG_802794_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_802794_BASE_ADDR_SHFT  0

#define HWIO_REG_724376_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000069c)
#define HWIO_REG_724376_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000069c)
#define HWIO_REG_724376_RMSK  0x1ffff
#define HWIO_REG_724376_SHFT  0
#define HWIO_REG_724376_IN  in_dword_masked(\
	HWIO_REG_724376_ADDR, HWIO_REG_724376_RMSK)
#define HWIO_REG_724376_INM(m) \
	in_dword_masked(HWIO_REG_724376_ADDR, m)
#define HWIO_REG_724376_OUT(v) \
	out_dword(HWIO_REG_724376_ADDR, v)
#define HWIO_REG_724376_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_724376_ADDR, m, v,\
	HWIO_REG_724376_IN);
#define HWIO_REG_724376_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_724376_BASE_ADDR_SHFT  0

#define HWIO_REG_551674_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006a0)
#define HWIO_REG_551674_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006a0)
#define HWIO_REG_551674_RMSK  0x1ffff
#define HWIO_REG_551674_SHFT  0
#define HWIO_REG_551674_IN  in_dword_masked(\
	HWIO_REG_551674_ADDR, HWIO_REG_551674_RMSK)
#define HWIO_REG_551674_INM(m) \
	in_dword_masked(HWIO_REG_551674_ADDR, m)
#define HWIO_REG_551674_OUT(v) \
	out_dword(HWIO_REG_551674_ADDR, v)
#define HWIO_REG_551674_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_551674_ADDR, m, v,\
	HWIO_REG_551674_IN);
#define HWIO_REG_551674_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_551674_BASE_ADDR_SHFT  0

#define HWIO_REG_115991_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006a4)
#define HWIO_REG_115991_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006a4)
#define HWIO_REG_115991_RMSK  0x1ffff
#define HWIO_REG_115991_SHFT  0
#define HWIO_REG_115991_IN  in_dword_masked(\
	HWIO_REG_115991_ADDR, HWIO_REG_115991_RMSK)
#define HWIO_REG_115991_INM(m) \
	in_dword_masked(HWIO_REG_115991_ADDR, m)
#define HWIO_REG_115991_OUT(v) \
	out_dword(HWIO_REG_115991_ADDR, v)
#define HWIO_REG_115991_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_115991_ADDR, m, v,\
	HWIO_REG_115991_IN);
#define HWIO_REG_115991_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_115991_BASE_ADDR_SHFT  0

#define HWIO_REG_252167_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006a8)
#define HWIO_REG_252167_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006a8)
#define HWIO_REG_252167_RMSK  0x1ffff
#define HWIO_REG_252167_SHFT  0
#define HWIO_REG_252167_IN  in_dword_masked(\
	HWIO_REG_252167_ADDR, HWIO_REG_252167_RMSK)
#define HWIO_REG_252167_INM(m) \
	in_dword_masked(HWIO_REG_252167_ADDR, m)
#define HWIO_REG_252167_OUT(v) \
	out_dword(HWIO_REG_252167_ADDR, v)
#define HWIO_REG_252167_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_252167_ADDR, m, v,\
	HWIO_REG_252167_IN);
#define HWIO_REG_252167_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_252167_BASE_ADDR_SHFT  0

#define HWIO_REG_695516_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006ac)
#define HWIO_REG_695516_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006ac)
#define HWIO_REG_695516_RMSK  0x1ffff
#define HWIO_REG_695516_SHFT  0
#define HWIO_REG_695516_IN  in_dword_masked(\
	HWIO_REG_695516_ADDR, HWIO_REG_695516_RMSK)
#define HWIO_REG_695516_INM(m) \
	in_dword_masked(HWIO_REG_695516_ADDR, m)
#define HWIO_REG_695516_OUT(v) \
	out_dword(HWIO_REG_695516_ADDR, v)
#define HWIO_REG_695516_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_695516_ADDR, m, v,\
	HWIO_REG_695516_IN);
#define HWIO_REG_695516_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_695516_BASE_ADDR_SHFT  0

#define HWIO_REG_152193_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006b0)
#define HWIO_REG_152193_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006b0)
#define HWIO_REG_152193_RMSK  0x1ffff
#define HWIO_REG_152193_SHFT  0
#define HWIO_REG_152193_IN  in_dword_masked(\
	HWIO_REG_152193_ADDR, HWIO_REG_152193_RMSK)
#define HWIO_REG_152193_INM(m) \
	in_dword_masked(HWIO_REG_152193_ADDR, m)
#define HWIO_REG_152193_OUT(v) \
	out_dword(HWIO_REG_152193_ADDR, v)
#define HWIO_REG_152193_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_152193_ADDR, m, v,\
	HWIO_REG_152193_IN);
#define HWIO_REG_152193_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_152193_BASE_ADDR_SHFT  0

#define HWIO_REG_358705_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006b4)
#define HWIO_REG_358705_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006b4)
#define HWIO_REG_358705_RMSK  0x1ffff
#define HWIO_REG_358705_SHFT  0
#define HWIO_REG_358705_IN  in_dword_masked(\
	HWIO_REG_358705_ADDR, HWIO_REG_358705_RMSK)
#define HWIO_REG_358705_INM(m) \
	in_dword_masked(HWIO_REG_358705_ADDR, m)
#define HWIO_REG_358705_OUT(v) \
	out_dword(HWIO_REG_358705_ADDR, v)
#define HWIO_REG_358705_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_358705_ADDR, m, v,\
	HWIO_REG_358705_IN);
#define HWIO_REG_358705_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_358705_BASE_ADDR_SHFT  0

#define HWIO_REG_457068_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006b8)
#define HWIO_REG_457068_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006b8)
#define HWIO_REG_457068_RMSK  0x1ffff
#define HWIO_REG_457068_SHFT  0
#define HWIO_REG_457068_IN  in_dword_masked(\
	HWIO_REG_457068_ADDR, HWIO_REG_457068_RMSK)
#define HWIO_REG_457068_INM(m) \
	in_dword_masked(HWIO_REG_457068_ADDR, m)
#define HWIO_REG_457068_OUT(v) \
	out_dword(HWIO_REG_457068_ADDR, v)
#define HWIO_REG_457068_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_457068_ADDR, m, v,\
	HWIO_REG_457068_IN);
#define HWIO_REG_457068_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_457068_BASE_ADDR_SHFT  0

#define HWIO_REG_485412_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006bc)
#define HWIO_REG_485412_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006bc)
#define HWIO_REG_485412_RMSK  0x1ffff
#define HWIO_REG_485412_SHFT  0
#define HWIO_REG_485412_IN  in_dword_masked(\
	HWIO_REG_485412_ADDR, HWIO_REG_485412_RMSK)
#define HWIO_REG_485412_INM(m) \
	in_dword_masked(HWIO_REG_485412_ADDR, m)
#define HWIO_REG_485412_OUT(v) \
	out_dword(HWIO_REG_485412_ADDR, v)
#define HWIO_REG_485412_OUTM(m, v) \
	out_dword_masked_ns(HWIO_REG_485412_ADDR, m, v,\
	HWIO_REG_485412_IN);
#define HWIO_REG_485412_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_485412_BASE_ADDR_SHFT  0

#define HWIO_REG_223131_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006c0)
#define HWIO_REG_223131_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006c0)
#define HWIO_REG_223131_RMSK  0x1ffff
#define HWIO_REG_223131_SHFT  0
#define HWIO_REG_223131_IN  in_dword_masked(\
	HWIO_REG_223131_ADDR, HWIO_REG_223131_RMSK)
#define HWIO_REG_223131_INM(m) \
		in_dword_masked(HWIO_REG_223131_ADDR, m)
#define HWIO_REG_223131_OUT(v) \
		out_dword(HWIO_REG_223131_ADDR, v)
#define HWIO_REG_223131_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_223131_ADDR, m, v,\
	HWIO_REG_223131_IN);
#define HWIO_REG_223131_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_223131_BASE_ADDR_SHFT  0

#define HWIO_REG_683737_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006c4)
#define HWIO_REG_683737_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006c4)
#define HWIO_REG_683737_RMSK  0x1ffff
#define HWIO_REG_683737_SHFT  0
#define HWIO_REG_683737_IN  in_dword_masked(\
	HWIO_REG_683737_ADDR, HWIO_REG_683737_RMSK)
#define HWIO_REG_683737_INM(m) \
	in_dword_masked(HWIO_REG_683737_ADDR, m)
#define HWIO_REG_683737_OUT(v) \
	out_dword(HWIO_REG_683737_ADDR, v)
#define HWIO_REG_683737_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_683737_ADDR, m, v,\
	HWIO_REG_683737_IN);
#define HWIO_REG_683737_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_683737_BASE_ADDR_SHFT  0

#define HWIO_REG_750474_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006c8)
#define HWIO_REG_750474_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006c8)
#define HWIO_REG_750474_RMSK  0x1ffff
#define HWIO_REG_750474_SHFT  0
#define HWIO_REG_750474_IN  in_dword_masked(\
	HWIO_REG_750474_ADDR, HWIO_REG_750474_RMSK)
#define HWIO_REG_750474_INM(m) \
	in_dword_masked(HWIO_REG_750474_ADDR, m)
#define HWIO_REG_750474_OUT(v) \
	out_dword(HWIO_REG_750474_ADDR, v)
#define HWIO_REG_750474_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_750474_ADDR, m, v,\
	HWIO_REG_750474_IN);
#define HWIO_REG_750474_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_750474_BASE_ADDR_SHFT  0

#define HWIO_REG_170086_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006cc)
#define HWIO_REG_170086_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006cc)
#define HWIO_REG_170086_RMSK  0x1ffff
#define HWIO_REG_170086_SHFT  0
#define HWIO_REG_170086_IN  in_dword_masked(\
	HWIO_REG_170086_ADDR, HWIO_REG_170086_RMSK)
#define HWIO_REG_170086_INM(m) \
	in_dword_masked(HWIO_REG_170086_ADDR, m)
#define HWIO_REG_170086_OUT(v) \
	out_dword(HWIO_REG_170086_ADDR, v)
#define HWIO_REG_170086_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_170086_ADDR, m, v,\
	HWIO_REG_170086_IN);
#define HWIO_REG_170086_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_170086_BASE_ADDR_SHFT  0

#define HWIO_REG_838595_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006d0)
#define HWIO_REG_838595_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006d0)
#define HWIO_REG_838595_RMSK  0x1ffff
#define HWIO_REG_838595_SHFT  0
#define HWIO_REG_838595_IN  in_dword_masked(\
	HWIO_REG_838595_ADDR, HWIO_REG_838595_RMSK)
#define HWIO_REG_838595_INM(m)  \
	in_dword_masked(HWIO_REG_838595_ADDR, m)
#define HWIO_REG_838595_OUT(v)  \
	out_dword(HWIO_REG_838595_ADDR, v)
#define HWIO_REG_838595_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_838595_ADDR, m, v,\
	HWIO_REG_838595_IN);
#define HWIO_REG_838595_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_838595_BASE_ADDR_SHFT  0

#define HWIO_REG_569788_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006d4)
#define HWIO_REG_569788_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006d4)
#define HWIO_REG_569788_RMSK  0x1ffff
#define HWIO_REG_569788_SHFT  0
#define HWIO_REG_569788_IN  in_dword_masked(\
	HWIO_REG_569788_ADDR, HWIO_REG_569788_RMSK)
#define HWIO_REG_569788_INM(m) \
	in_dword_masked(HWIO_REG_569788_ADDR, m)
#define HWIO_REG_569788_OUT(v) \
	out_dword(HWIO_REG_569788_ADDR, v)
#define HWIO_REG_569788_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_569788_ADDR, m, v,\
	HWIO_REG_569788_IN);
#define HWIO_REG_569788_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_569788_BASE_ADDR_SHFT  0

#define HWIO_REG_974527_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006d8)
#define HWIO_REG_974527_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006d8)
#define HWIO_REG_974527_RMSK  0x1ffff
#define HWIO_REG_974527_SHFT  0
#define HWIO_REG_974527_IN  in_dword_masked(\
	HWIO_REG_974527_ADDR, HWIO_REG_974527_RMSK)
#define HWIO_REG_974527_INM(m) \
	in_dword_masked(HWIO_REG_974527_ADDR, m)
#define HWIO_REG_974527_OUT(v) \
	out_dword(HWIO_REG_974527_ADDR, v)
#define HWIO_REG_974527_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_974527_ADDR, m, v,\
	HWIO_REG_974527_IN);
#define HWIO_REG_974527_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_974527_BASE_ADDR_SHFT   0

#define HWIO_REG_316806_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006dc)
#define HWIO_REG_316806_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006dc)
#define HWIO_REG_316806_RMSK  0x1ffff
#define HWIO_REG_316806_SHFT  0
#define HWIO_REG_316806_IN  in_dword_masked(\
	HWIO_REG_316806_ADDR, HWIO_REG_316806_RMSK)
#define HWIO_REG_316806_INM(m) \
	in_dword_masked(HWIO_REG_316806_ADDR, m)
#define HWIO_REG_316806_OUT(v) \
	out_dword(HWIO_REG_316806_ADDR, v)
#define HWIO_REG_316806_OUTM(m, v) \
	out_dword_masked_ns(HWIO_REG_316806_ADDR, m, v,\
	HWIO_REG_316806_IN);
#define HWIO_REG_316806_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_316806_BASE_ADDR_SHFT  0

#define HWIO_REG_900472_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006e0)
#define HWIO_REG_900472_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006e0)
#define HWIO_REG_900472_RMSK  0x1ffff
#define HWIO_REG_900472_SHFT  0
#define HWIO_REG_900472_IN  in_dword_masked(\
	HWIO_REG_900472_ADDR, HWIO_REG_900472_RMSK)
#define HWIO_REG_900472_INM(m) \
	in_dword_masked(HWIO_REG_900472_ADDR, m)
#define HWIO_REG_900472_OUT(v) \
	out_dword(HWIO_REG_900472_ADDR, v)
#define HWIO_REG_900472_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_900472_ADDR, m, v,\
	HWIO_REG_900472_IN);
#define HWIO_REG_900472_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_900472_BASE_ADDR_SHFT  0

#define HWIO_REG_256156_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006e4)
#define HWIO_REG_256156_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006e4)
#define HWIO_REG_256156_RMSK  0x1ffff
#define HWIO_REG_256156_SHFT  0
#define HWIO_REG_256156_IN  in_dword_masked(\
	HWIO_REG_256156_ADDR, HWIO_REG_256156_RMSK)
#define HWIO_REG_256156_INM(m) \
	in_dword_masked(HWIO_REG_256156_ADDR, m)
#define HWIO_REG_256156_OUT(v) \
	out_dword(HWIO_REG_256156_ADDR, v)
#define HWIO_REG_256156_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_256156_ADDR, m, v,\
	HWIO_REG_256156_IN);
#define HWIO_REG_256156_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_256156_BASE_ADDR_SHFT  0

#define HWIO_REG_335729_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006e8)
#define HWIO_REG_335729_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006e8)
#define HWIO_REG_335729_RMSK  0x1ffff
#define HWIO_REG_335729_SHFT  0
#define HWIO_REG_335729_IN  in_dword_masked(\
	HWIO_REG_335729_ADDR, HWIO_REG_335729_RMSK)
#define HWIO_REG_335729_INM(m) \
	in_dword_masked(HWIO_REG_335729_ADDR, m)
#define HWIO_REG_335729_OUT(v) \
	out_dword(HWIO_REG_335729_ADDR, v)
#define HWIO_REG_335729_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_335729_ADDR, m, v,\
	HWIO_REG_335729_IN);
#define HWIO_REG_335729_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_335729_BASE_ADDR_SHFT  0

#define HWIO_REG_303383_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006ec)
#define HWIO_REG_303383_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006ec)
#define HWIO_REG_303383_RMSK  0x1ffff
#define HWIO_REG_303383_SHFT  0
#define HWIO_REG_303383_IN  in_dword_masked(\
	HWIO_REG_303383_ADDR, HWIO_REG_303383_RMSK)
#define HWIO_REG_303383_INM(m) \
	in_dword_masked(HWIO_REG_303383_ADDR, m)
#define HWIO_REG_303383_OUT(v) \
	out_dword(HWIO_REG_303383_ADDR, v)
#define HWIO_REG_303383_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_303383_ADDR, m, v,\
	HWIO_REG_303383_IN);
#define HWIO_REG_303383_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_303383_BASE_ADDR_SHFT  0

#define HWIO_REG_180871_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006f0)
#define HWIO_REG_180871_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006f0)
#define HWIO_REG_180871_RMSK  0x1ffff
#define HWIO_REG_180871_SHFT  0
#define HWIO_REG_180871_IN  in_dword_masked(\
	HWIO_REG_180871_ADDR, HWIO_REG_180871_RMSK)
#define HWIO_REG_180871_INM(m) \
	in_dword_masked(HWIO_REG_180871_ADDR, m)
#define HWIO_REG_180871_OUT(v) \
	out_dword(HWIO_REG_180871_ADDR, v)
#define HWIO_REG_180871_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_180871_ADDR, m, v,\
	HWIO_REG_180871_IN);
#define HWIO_REG_180871_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_180871_BASE_ADDR_SHFT  0

#define HWIO_REG_514148_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006f4)
#define HWIO_REG_514148_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006f4)
#define HWIO_REG_514148_RMSK  0x1ffff
#define HWIO_REG_514148_SHFT  0
#define HWIO_REG_514148_IN  in_dword_masked(\
	HWIO_REG_514148_ADDR, HWIO_REG_514148_RMSK)
#define HWIO_REG_514148_INM(m) \
	in_dword_masked(HWIO_REG_514148_ADDR, m)
#define HWIO_REG_514148_OUT(v) \
	out_dword(HWIO_REG_514148_ADDR, v)
#define HWIO_REG_514148_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_514148_ADDR, m, v,\
	HWIO_REG_514148_IN);
#define HWIO_REG_514148_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_514148_BASE_ADDR_SHFT  0

#define HWIO_REG_578636_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006f8)
#define HWIO_REG_578636_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006f8)
#define HWIO_REG_578636_RMSK  0x1ffff
#define HWIO_REG_578636_SHFT  0
#define HWIO_REG_578636_IN  in_dword_masked(\
	HWIO_REG_578636_ADDR, HWIO_REG_578636_RMSK)
#define HWIO_REG_578636_INM(m) \
	in_dword_masked(HWIO_REG_578636_ADDR, m)
#define HWIO_REG_578636_OUT(v) \
	out_dword(HWIO_REG_578636_ADDR, v)
#define HWIO_REG_578636_OUTM(m, v) \
	out_dword_masked_ns(HWIO_REG_578636_ADDR, m, v,\
	HWIO_REG_578636_IN);
#define HWIO_REG_578636_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_578636_BASE_ADDR_SHFT  0

#define HWIO_REG_888116_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000006fc)
#define HWIO_REG_888116_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000006fc)
#define HWIO_REG_888116_RMSK  0x1ffff
#define HWIO_REG_888116_SHFT  0
#define HWIO_REG_888116_IN  in_dword_masked(\
	HWIO_REG_888116_ADDR, HWIO_REG_888116_RMSK)
#define HWIO_REG_888116_INM(m) \
	in_dword_masked(HWIO_REG_888116_ADDR, m)
#define HWIO_REG_888116_OUT(v) \
	out_dword(HWIO_REG_888116_ADDR, v)
#define HWIO_REG_888116_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_888116_ADDR, m, v,\
	HWIO_REG_888116_IN);
#define HWIO_REG_888116_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_888116_BASE_ADDR_SHFT  0

#define HWIO_REG_759068_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000700)
#define HWIO_REG_759068_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000700)
#define HWIO_REG_759068_RMSK  0x1ffff
#define HWIO_REG_759068_SHFT  0
#define HWIO_REG_759068_IN  in_dword_masked(\
	HWIO_REG_759068_ADDR, HWIO_REG_759068_RMSK)
#define HWIO_REG_759068_INM(m) \
	in_dword_masked(HWIO_REG_759068_ADDR, m)
#define HWIO_REG_759068_OUT(v) \
	out_dword(HWIO_REG_759068_ADDR, v)
#define HWIO_REG_759068_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_759068_ADDR, m, v,\
	HWIO_REG_759068_IN);
#define HWIO_REG_759068_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_759068_BASE_ADDR_SHFT  0

#define HWIO_REG_68356_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000704)
#define HWIO_REG_68356_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000704)
#define HWIO_REG_68356_RMSK  0x1ffff
#define HWIO_REG_68356_SHFT  0
#define HWIO_REG_68356_IN   in_dword_masked(\
	HWIO_REG_68356_ADDR, HWIO_REG_68356_RMSK)
#define HWIO_REG_68356_INM(m) \
	in_dword_masked(HWIO_REG_68356_ADDR, m)
#define HWIO_REG_68356_OUT(v) \
	out_dword(HWIO_REG_68356_ADDR, v)
#define HWIO_REG_68356_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_68356_ADDR, m, v,\
	HWIO_REG_68356_IN);
#define HWIO_REG_68356_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_68356_BASE_ADDR_SHFT  0

#define HWIO_REG_833502_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000708)
#define HWIO_REG_833502_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000708)
#define HWIO_REG_833502_RMSK  0x1ffff
#define HWIO_REG_833502_SHFT  0
#define HWIO_REG_833502_IN  in_dword_masked(\
	HWIO_REG_833502_ADDR, HWIO_REG_833502_RMSK)
#define HWIO_REG_833502_INM(m) \
	in_dword_masked(HWIO_REG_833502_ADDR, m)
#define HWIO_REG_833502_OUT(v) \
	out_dword(HWIO_REG_833502_ADDR, v)
#define HWIO_REG_833502_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_833502_ADDR, m, v,\
	HWIO_REG_833502_IN);
#define HWIO_REG_833502_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_833502_BASE_ADDR_SHFT  0

#define HWIO_REG_127855_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000070c)
#define HWIO_REG_127855_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000070c)
#define HWIO_REG_127855_RMSK  0x1ffff
#define HWIO_REG_127855_SHFT  0
#define HWIO_REG_127855_IN  in_dword_masked(\
	HWIO_REG_127855_ADDR, HWIO_REG_127855_RMSK)
#define HWIO_REG_127855_INM(m) \
	in_dword_masked(HWIO_REG_127855_ADDR, m)
#define HWIO_REG_127855_OUT(v) \
	out_dword(HWIO_REG_127855_ADDR, v)
#define HWIO_REG_127855_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_127855_ADDR, m, v,\
	HWIO_REG_127855_IN);
#define HWIO_REG_127855_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_127855_BASE_ADDR_SHFT  0

#define HWIO_REG_616802_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000710)
#define HWIO_REG_616802_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000710)
#define HWIO_REG_616802_RMSK  0x1ffff
#define HWIO_REG_616802_SHFT  0
#define HWIO_REG_616802_IN  in_dword_masked(\
	HWIO_REG_616802_ADDR, HWIO_REG_616802_RMSK)
#define HWIO_REG_616802_INM(m) \
	in_dword_masked(HWIO_REG_616802_ADDR, m)
#define HWIO_REG_616802_OUT(v) \
	out_dword(HWIO_REG_616802_ADDR, v)
#define HWIO_REG_616802_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_616802_ADDR, m, v,\
	HWIO_REG_616802_IN);
#define HWIO_REG_616802_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_616802_BASE_ADDR_SHFT  0

#define HWIO_REG_23318_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000714)
#define HWIO_REG_23318_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000714)
#define HWIO_REG_23318_RMSK  0x1ffff
#define HWIO_REG_23318_SHFT  0
#define HWIO_REG_23318_IN  in_dword_masked(\
	HWIO_REG_23318_ADDR, HWIO_REG_23318_RMSK)
#define HWIO_REG_23318_INM(m) \
	in_dword_masked(HWIO_REG_23318_ADDR, m)
#define HWIO_REG_23318_OUT(v) \
	out_dword(HWIO_REG_23318_ADDR, v)
#define HWIO_REG_23318_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_23318_ADDR, m, v,\
	HWIO_REG_23318_IN);
#define HWIO_REG_23318_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_23318_BASE_ADDR_SHFT  0

#define HWIO_REG_317106_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000718)
#define HWIO_REG_317106_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000718)
#define HWIO_REG_317106_RMSK  0x1ffff
#define HWIO_REG_317106_SHFT  0
#define HWIO_REG_317106_IN  in_dword_masked(\
	HWIO_REG_317106_ADDR, HWIO_REG_317106_RMSK)
#define HWIO_REG_317106_INM(m) \
	in_dword_masked(HWIO_REG_317106_ADDR, m)
#define HWIO_REG_317106_OUT(v) \
	out_dword(HWIO_REG_317106_ADDR, v)
#define HWIO_REG_317106_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_317106_ADDR, m, v,\
	HWIO_REG_317106_IN);
#define HWIO_REG_317106_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_317106_BASE_ADDR_SHFT  0

#define HWIO_REG_603772_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000071c)
#define HWIO_REG_603772_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000071c)
#define HWIO_REG_603772_RMSK  0x1ffff
#define HWIO_REG_603772_SHFT  0
#define HWIO_REG_603772_IN  in_dword_masked(\
	HWIO_REG_603772_ADDR, HWIO_REG_603772_RMSK)
#define HWIO_REG_603772_INM(m) \
	in_dword_masked(HWIO_REG_603772_ADDR, m)
#define HWIO_REG_603772_OUT(v) \
	out_dword(HWIO_REG_603772_ADDR, v)
#define HWIO_REG_603772_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_603772_ADDR, m, v,\
	HWIO_REG_603772_IN);
#define HWIO_REG_603772_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_603772_BASE_ADDR_SHFT  0

#define HWIO_REG_175929_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000720)
#define HWIO_REG_175929_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000720)
#define HWIO_REG_175929_RMSK  0x1ffff
#define HWIO_REG_175929_SHFT  0
#define HWIO_REG_175929_IN  in_dword_masked(\
	HWIO_REG_175929_ADDR, HWIO_REG_175929_RMSK)
#define HWIO_REG_175929_INM(m) \
	in_dword_masked(HWIO_REG_175929_ADDR, m)
#define HWIO_REG_175929_OUT(v) \
	out_dword(HWIO_REG_175929_ADDR, v)
#define HWIO_REG_175929_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_175929_ADDR, m, v,\
	HWIO_REG_175929_IN);
#define HWIO_REG_175929_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_175929_BASE_ADDR_SHFT  0

#define HWIO_REG_11928_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000724)
#define HWIO_REG_11928_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000724)
#define HWIO_REG_11928_RMSK  0x1ffff
#define HWIO_REG_11928_SHFT  0
#define HWIO_REG_11928_IN  in_dword_masked(\
	HWIO_REG_11928_ADDR, HWIO_REG_11928_RMSK)
#define HWIO_REG_11928_INM(m) \
	in_dword_masked(HWIO_REG_11928_ADDR, m)
#define HWIO_REG_11928_OUT(v) \
	out_dword(HWIO_REG_11928_ADDR, v)
#define HWIO_REG_11928_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_11928_ADDR, m, v,\
	HWIO_REG_11928_IN);
#define HWIO_REG_11928_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_11928_BASE_ADDR_SHFT  0

#define HWIO_REG_772678_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000728)
#define HWIO_REG_772678_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000728)
#define HWIO_REG_772678_RMSK  0x1ffff
#define HWIO_REG_772678_SHFT  0
#define HWIO_REG_772678_IN  in_dword_masked(\
	HWIO_REG_772678_ADDR, HWIO_REG_772678_RMSK)
#define HWIO_REG_772678_INM(m) \
	in_dword_masked(HWIO_REG_772678_ADDR, m)
#define HWIO_REG_772678_OUT(v) \
	out_dword(HWIO_REG_772678_ADDR, v)
#define HWIO_REG_772678_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_772678_ADDR, m, v,\
	HWIO_REG_772678_IN);
#define HWIO_REG_772678_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_772678_BASE_ADDR_SHFT  0

#define HWIO_REG_603389_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000072c)
#define HWIO_REG_603389_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000072c)
#define HWIO_REG_603389_RMSK  0x1ffff
#define HWIO_REG_603389_SHFT  0
#define HWIO_REG_603389_IN  in_dword_masked(\
	HWIO_REG_603389_ADDR, HWIO_REG_603389_RMSK)
#define HWIO_REG_603389_INM(m) \
	in_dword_masked(HWIO_REG_603389_ADDR, m)
#define HWIO_REG_603389_OUT(v) \
	out_dword(HWIO_REG_603389_ADDR, v)
#define HWIO_REG_603389_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_603389_ADDR, m, v,\
	HWIO_REG_603389_IN);
#define HWIO_REG_603389_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_603389_BASE_ADDR_SHFT  0

#define HWIO_REG_989918_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000730)
#define HWIO_REG_989918_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000730)
#define HWIO_REG_989918_RMSK  0x1ffff
#define HWIO_REG_989918_SHFT  0
#define HWIO_REG_989918_IN  in_dword_masked(\
	HWIO_REG_989918_ADDR, HWIO_REG_989918_RMSK)
#define HWIO_REG_989918_INM(m) \
	in_dword_masked(HWIO_REG_989918_ADDR, m)
#define HWIO_REG_989918_OUT(v) \
	out_dword(HWIO_REG_989918_ADDR, v)
#define HWIO_REG_989918_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_989918_ADDR, m, v,\
	HWIO_REG_989918_IN);
#define HWIO_REG_989918_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_989918_BASE_ADDR_SHFT  0

#define HWIO_REG_5460_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000734)
#define HWIO_REG_5460_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000734)
#define HWIO_REG_5460_RMSK  0x1ffff
#define HWIO_REG_5460_SHFT  0
#define HWIO_REG_5460_IN  in_dword_masked(\
	HWIO_REG_5460_ADDR, HWIO_REG_5460_RMSK)
#define HWIO_REG_5460_INM(m) \
	in_dword_masked(HWIO_REG_5460_ADDR, m)
#define HWIO_REG_5460_OUT(v) \
	out_dword(HWIO_REG_5460_ADDR, v)
#define HWIO_REG_5460_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_5460_ADDR, m, v,\
	HWIO_REG_5460_IN);
#define HWIO_REG_5460_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_5460_BASE_ADDR_SHFT  0

#define HWIO_REG_734724_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000738)
#define HWIO_REG_734724_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000738)
#define HWIO_REG_734724_RMSK  0x1ffff
#define HWIO_REG_734724_SHFT  0
#define HWIO_REG_734724_IN  in_dword_masked(\
	HWIO_REG_734724_ADDR, HWIO_REG_734724_RMSK)
#define HWIO_REG_734724_INM(m) \
	in_dword_masked(HWIO_REG_734724_ADDR, m)
#define HWIO_REG_734724_OUT(v) \
	out_dword(HWIO_REG_734724_ADDR, v)
#define HWIO_REG_734724_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_734724_ADDR, m, v,\
	HWIO_REG_734724_IN);
#define HWIO_REG_734724_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_734724_BASE_ADDR_SHFT  0

#define HWIO_REG_451742_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000073c)
#define HWIO_REG_451742_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000073c)
#define HWIO_REG_451742_RMSK  0x1ffff
#define HWIO_REG_451742_SHFT  0
#define HWIO_REG_451742_IN  in_dword_masked(\
	HWIO_REG_451742_ADDR, HWIO_REG_451742_RMSK)
#define HWIO_REG_451742_INM(m) \
	in_dword_masked(HWIO_REG_451742_ADDR, m)
#define HWIO_REG_451742_OUT(v) \
	out_dword(HWIO_REG_451742_ADDR, v)
#define HWIO_REG_451742_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_451742_ADDR, m, v,\
	HWIO_REG_451742_IN);
#define HWIO_REG_451742_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_451742_BASE_ADDR_SHFT  0

#define HWIO_REG_475648_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000740)
#define HWIO_REG_475648_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000740)
#define HWIO_REG_475648_RMSK  0x1ffff
#define HWIO_REG_475648_SHFT  0
#define HWIO_REG_475648_IN  in_dword_masked(\
	HWIO_REG_475648_ADDR, HWIO_REG_475648_RMSK)
#define HWIO_REG_475648_INM(m) \
	in_dword_masked(HWIO_REG_475648_ADDR, m)
#define HWIO_REG_475648_OUT(v) \
	out_dword(HWIO_REG_475648_ADDR, v)
#define HWIO_REG_475648_OUTM(m, v) \
	out_dword_masked_ns(HWIO_REG_475648_ADDR, m, v,\
	HWIO_REG_475648_IN);
#define HWIO_REG_475648_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_475648_BASE_ADDR_SHFT  0

#define HWIO_REG_284758_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000744)
#define HWIO_REG_284758_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000744)
#define HWIO_REG_284758_RMSK  0x1ffff
#define HWIO_REG_284758_SHFT  0
#define HWIO_REG_284758_IN  in_dword_masked(\
	HWIO_REG_284758_ADDR, HWIO_REG_284758_RMSK)
#define HWIO_REG_284758_INM(m) \
	in_dword_masked(HWIO_REG_284758_ADDR, m)
#define HWIO_REG_284758_OUT(v) \
	out_dword(HWIO_REG_284758_ADDR, v)
#define HWIO_REG_284758_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_284758_ADDR, m, v,\
	HWIO_REG_284758_IN);
#define HWIO_REG_284758_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_284758_BASE_ADDR_SHFT  0

#define HWIO_REG_523659_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000748)
#define HWIO_REG_523659_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000748)
#define HWIO_REG_523659_RMSK  0x1ffff
#define HWIO_REG_523659_SHFT  0
#define HWIO_REG_523659_IN  in_dword_masked(\
	HWIO_REG_523659_ADDR, HWIO_REG_523659_RMSK)
#define HWIO_REG_523659_INM(m) \
	in_dword_masked(HWIO_REG_523659_ADDR, m)
#define HWIO_REG_523659_OUT(v) \
	out_dword(HWIO_REG_523659_ADDR, v)
#define HWIO_REG_523659_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_523659_ADDR, m, v,\
	HWIO_REG_523659_IN);
#define HWIO_REG_523659_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_523659_BASE_ADDR_SHFT  0

#define HWIO_REG_815580_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000074c)
#define HWIO_REG_815580_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000074c)
#define HWIO_REG_815580_RMSK  0x1ffff
#define HWIO_REG_815580_SHFT  0
#define HWIO_REG_815580_IN  in_dword_masked(\
	HWIO_REG_815580_ADDR, HWIO_REG_815580_RMSK)
#define HWIO_REG_815580_INM(m) \
	in_dword_masked(HWIO_REG_815580_ADDR, m)
#define HWIO_REG_815580_OUT(v) \
	out_dword(HWIO_REG_815580_ADDR, v)
#define HWIO_REG_815580_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_815580_ADDR, m, v,\
	HWIO_REG_815580_IN);
#define HWIO_REG_815580_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_815580_BASE_ADDR_SHFT  0

#define HWIO_REG_546551_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000750)
#define HWIO_REG_546551_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000750)
#define HWIO_REG_546551_RMSK  0x1ffff
#define HWIO_REG_546551_SHFT  0
#define HWIO_REG_546551_IN  in_dword_masked(\
	HWIO_REG_546551_ADDR, HWIO_REG_546551_RMSK)
#define HWIO_REG_546551_INM(m) \
	in_dword_masked(HWIO_REG_546551_ADDR, m)
#define HWIO_REG_546551_OUT(v) \
	out_dword(HWIO_REG_546551_ADDR, v)
#define HWIO_REG_546551_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_546551_ADDR, m, v,\
	HWIO_REG_546551_IN);
#define HWIO_REG_546551_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_546551_BASE_ADDR_SHFT  0

#define HWIO_REG_769851_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000754)
#define HWIO_REG_769851_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000754)
#define HWIO_REG_769851_RMSK  0x1ffff
#define HWIO_REG_769851_SHFT  0
#define HWIO_REG_769851_IN  in_dword_masked(\
	HWIO_REG_769851_ADDR, HWIO_REG_769851_RMSK)
#define HWIO_REG_769851_INM(m) \
	in_dword_masked(HWIO_REG_769851_ADDR, m)
#define HWIO_REG_769851_OUT(v) \
	out_dword(HWIO_REG_769851_ADDR, v)
#define HWIO_REG_769851_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_769851_ADDR, m, v,\
	HWIO_REG_769851_IN);
#define HWIO_REG_769851_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_769851_BASE_ADDR_SHFT  0

#define HWIO_REG_205028_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000758)
#define HWIO_REG_205028_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000758)
#define HWIO_REG_205028_RMSK  0x1ffff
#define HWIO_REG_205028_SHFT  0
#define HWIO_REG_205028_IN  in_dword_masked(\
	HWIO_REG_205028_ADDR, HWIO_REG_205028_RMSK)
#define HWIO_REG_205028_INM(m) \
	in_dword_masked(HWIO_REG_205028_ADDR, m)
#define HWIO_REG_205028_OUT(v) \
	out_dword(HWIO_REG_205028_ADDR, v)
#define HWIO_REG_205028_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_205028_ADDR, m, v,\
	HWIO_REG_205028_IN);
#define HWIO_REG_205028_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_205028_BASE_ADDR_SHFT  0

#define HWIO_REG_206835_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000075c)
#define HWIO_REG_206835_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000075c)
#define HWIO_REG_206835_RMSK  0x1ffff
#define HWIO_REG_206835_SHFT  0
#define HWIO_REG_206835_IN  in_dword_masked(\
	HWIO_REG_206835_ADDR, HWIO_REG_206835_RMSK)
#define HWIO_REG_206835_INM(m) \
	in_dword_masked(HWIO_REG_206835_ADDR, m)
#define HWIO_REG_206835_OUT(v) \
	out_dword(HWIO_REG_206835_ADDR, v)
#define HWIO_REG_206835_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_206835_ADDR, m, v,\
	HWIO_REG_206835_IN);
#define HWIO_REG_206835_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_206835_BASE_ADDR_SHFT  0

#define HWIO_REG_582575_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000760)
#define HWIO_REG_582575_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000760)
#define HWIO_REG_582575_RMSK  0x1ffff
#define HWIO_REG_582575_SHFT  0
#define HWIO_REG_582575_IN  in_dword_masked(\
	HWIO_REG_582575_ADDR, HWIO_REG_582575_RMSK)
#define HWIO_REG_582575_INM(m) \
	in_dword_masked(HWIO_REG_582575_ADDR, m)
#define HWIO_REG_582575_OUT(v) \
	out_dword(HWIO_REG_582575_ADDR, v)
#define HWIO_REG_582575_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_582575_ADDR, m, v,\
	HWIO_REG_582575_IN);
#define HWIO_REG_582575_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_582575_BASE_ADDR_SHFT  0

#define HWIO_REG_120885_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000764)
#define HWIO_REG_120885_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000764)
#define HWIO_REG_120885_RMSK  0x1ffff
#define HWIO_REG_120885_SHFT  0
#define HWIO_REG_120885_IN  in_dword_masked(\
	HWIO_REG_120885_ADDR, HWIO_REG_120885_RMSK)
#define HWIO_REG_120885_INM(m) \
	in_dword_masked(HWIO_REG_120885_ADDR, m)
#define HWIO_REG_120885_OUT(v) \
	out_dword(HWIO_REG_120885_ADDR, v)
#define HWIO_REG_120885_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_120885_ADDR, m, v,\
	HWIO_REG_120885_IN);
#define HWIO_REG_120885_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_120885_BASE_ADDR_SHFT  0

#define HWIO_REG_496067_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000768)
#define HWIO_REG_496067_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000768)
#define HWIO_REG_496067_RMSK  0x1ffff
#define HWIO_REG_496067_SHFT  0
#define HWIO_REG_496067_IN  in_dword_masked(\
	HWIO_REG_496067_ADDR, HWIO_REG_496067_RMSK)
#define HWIO_REG_496067_INM(m) \
	in_dword_masked(HWIO_REG_496067_ADDR, m)
#define HWIO_REG_496067_OUT(v) \
	out_dword(HWIO_REG_496067_ADDR, v)
#define HWIO_REG_496067_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_496067_ADDR, m, v,\
	HWIO_REG_496067_IN);
#define HWIO_REG_496067_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_496067_BASE_ADDR_SHFT  0

#define HWIO_REG_472919_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000076c)
#define HWIO_REG_472919_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000076c)
#define HWIO_REG_472919_RMSK  0x1ffff
#define HWIO_REG_472919_SHFT  0
#define HWIO_REG_472919_IN  in_dword_masked(\
	HWIO_REG_472919_ADDR, HWIO_REG_472919_RMSK)
#define HWIO_REG_472919_INM(m) \
	in_dword_masked(HWIO_REG_472919_ADDR, m)
#define HWIO_REG_472919_OUT(v) \
	out_dword(HWIO_REG_472919_ADDR, v)
#define HWIO_REG_472919_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_472919_ADDR, m, v,\
	HWIO_REG_472919_IN);
#define HWIO_REG_472919_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_472919_BASE_ADDR_SHFT  0

#define HWIO_REG_486985_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000770)
#define HWIO_REG_486985_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000770)
#define HWIO_REG_486985_RMSK  0x1ffff
#define HWIO_REG_486985_SHFT  0
#define HWIO_REG_486985_IN  in_dword_masked(\
	HWIO_REG_486985_ADDR, HWIO_REG_486985_RMSK)
#define HWIO_REG_486985_INM(m) \
	in_dword_masked(HWIO_REG_486985_ADDR, m)
#define HWIO_REG_486985_OUT(v) \
	out_dword(HWIO_REG_486985_ADDR, v)
#define HWIO_REG_486985_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_486985_ADDR, m, v,\
	HWIO_REG_486985_IN);
#define HWIO_REG_486985_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_486985_BASE_ADDR_SHFT  0

#define HWIO_REG_964692_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000774)
#define HWIO_REG_964692_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000774)
#define HWIO_REG_964692_RMSK  0x1ffff
#define HWIO_REG_964692_SHFT  0
#define HWIO_REG_964692_IN  in_dword_masked(\
	HWIO_REG_964692_ADDR, HWIO_REG_964692_RMSK)
#define HWIO_REG_964692_INM(m) \
	in_dword_masked(HWIO_REG_964692_ADDR, m)
#define HWIO_REG_964692_OUT(v) \
	out_dword(HWIO_REG_964692_ADDR, v)
#define HWIO_REG_964692_OUTM(m, v)   out_dword_masked_ns(\
	HWIO_REG_964692_ADDR, m, v,\
	HWIO_REG_964692_IN);
#define HWIO_REG_964692_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_964692_BASE_ADDR_SHFT  0

#define HWIO_REG_941116_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000778)
#define HWIO_REG_941116_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000778)
#define HWIO_REG_941116_RMSK  0x1ffff
#define HWIO_REG_941116_SHFT  0
#define HWIO_REG_941116_IN  in_dword_masked(\
	HWIO_REG_941116_ADDR, HWIO_REG_941116_RMSK)
#define HWIO_REG_941116_INM(m) \
	in_dword_masked(HWIO_REG_941116_ADDR, m)
#define HWIO_REG_941116_OUT(v) \
	out_dword(HWIO_REG_941116_ADDR, v)
#define HWIO_REG_941116_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_941116_ADDR, m, v,\
	HWIO_REG_941116_IN);
#define HWIO_REG_941116_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_941116_BASE_ADDR_SHFT  0

#define HWIO_REG_122567_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000077c)
#define HWIO_REG_122567_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000077c)
#define HWIO_REG_122567_RMSK  0x1ffff
#define HWIO_REG_122567_SHFT  0
#define HWIO_REG_122567_IN  in_dword_masked(\
	HWIO_REG_122567_ADDR, HWIO_REG_122567_RMSK)
#define HWIO_REG_122567_INM(m) \
	in_dword_masked(HWIO_REG_122567_ADDR, m)
#define HWIO_REG_122567_OUT(v) \
	out_dword(HWIO_REG_122567_ADDR, v)
#define HWIO_REG_122567_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_122567_ADDR, m, v,\
	HWIO_REG_122567_IN);
#define HWIO_REG_122567_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_122567_BASE_ADDR_SHFT  0

#define HWIO_REG_466192_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000780)
#define HWIO_REG_466192_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000780)
#define HWIO_REG_466192_RMSK  0x1ffff
#define HWIO_REG_466192_SHFT  0
#define HWIO_REG_466192_IN  in_dword_masked(\
	HWIO_REG_466192_ADDR, HWIO_REG_466192_RMSK)
#define HWIO_REG_466192_INM(m) \
	in_dword_masked(HWIO_REG_466192_ADDR, m)
#define HWIO_REG_466192_OUT(v) \
	out_dword(HWIO_REG_466192_ADDR, v)
#define HWIO_REG_466192_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_466192_ADDR, m, v,\
	HWIO_REG_466192_IN);
#define HWIO_REG_466192_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_466192_BASE_ADDR_SHFT  0

#define HWIO_REG_554890_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000784)
#define HWIO_REG_554890_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000784)
#define HWIO_REG_554890_RMSK  0x1ffff
#define HWIO_REG_554890_SHFT  0
#define HWIO_REG_554890_IN  in_dword_masked(\
	HWIO_REG_554890_ADDR, HWIO_REG_554890_RMSK)
#define HWIO_REG_554890_INM(m) \
	in_dword_masked(HWIO_REG_554890_ADDR, m)
#define HWIO_REG_554890_OUT(v)                          \
	out_dword(HWIO_REG_554890_ADDR, v)
#define HWIO_REG_554890_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_554890_ADDR, m, v,\
	HWIO_REG_554890_IN);
#define HWIO_REG_554890_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_554890_BASE_ADDR_SHFT  0

#define HWIO_REG_295616_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000788)
#define HWIO_REG_295616_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000788)
#define HWIO_REG_295616_RMSK  0x1ffff
#define HWIO_REG_295616_SHFT  0
#define HWIO_REG_295616_IN  in_dword_masked(\
	HWIO_REG_295616_ADDR, HWIO_REG_295616_RMSK)
#define HWIO_REG_295616_INM(m) \
	in_dword_masked(HWIO_REG_295616_ADDR, m)
#define HWIO_REG_295616_OUT(v) \
	out_dword(HWIO_REG_295616_ADDR, v)
#define HWIO_REG_295616_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_295616_ADDR, m, v,\
	HWIO_REG_295616_IN);
#define HWIO_REG_295616_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_295616_BASE_ADDR_SHFT  0

#define HWIO_REG_440836_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000078c)
#define HWIO_REG_440836_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000078c)
#define HWIO_REG_440836_RMSK  0x1ffff
#define HWIO_REG_440836_SHFT  0
#define HWIO_REG_440836_IN  in_dword_masked(\
	HWIO_REG_440836_ADDR, HWIO_REG_440836_RMSK)
#define HWIO_REG_440836_INM(m) \
	in_dword_masked(HWIO_REG_440836_ADDR, m)
#define HWIO_REG_440836_OUT(v) \
	out_dword(HWIO_REG_440836_ADDR, v)
#define HWIO_REG_440836_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_440836_ADDR, m, v,\
	HWIO_REG_440836_IN);
#define HWIO_REG_440836_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_440836_BASE_ADDR_SHFT  0

#define HWIO_REG_741154_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000790)
#define HWIO_REG_741154_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000790)
#define HWIO_REG_741154_RMSK  0x1ffff
#define HWIO_REG_741154_SHFT  0
#define HWIO_REG_741154_IN  in_dword_masked(\
	HWIO_REG_741154_ADDR,\
	HWIO_REG_741154_RMSK)
#define HWIO_REG_741154_INM(m) \
	in_dword_masked(HWIO_REG_741154_ADDR, m)
#define HWIO_REG_741154_OUT(v) \
	out_dword(HWIO_REG_741154_ADDR, v)
#define HWIO_REG_741154_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_741154_ADDR, m, v,\
	HWIO_REG_741154_IN);
#define HWIO_REG_741154_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_741154_BASE_ADDR_SHFT  0

#define HWIO_REG_753139_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000794)
#define HWIO_REG_753139_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000794)
#define HWIO_REG_753139_RMSK  0x1ffff
#define HWIO_REG_753139_SHFT  0
#define HWIO_REG_753139_IN  in_dword_masked(\
	HWIO_REG_753139_ADDR,\
	HWIO_REG_753139_RMSK)
#define HWIO_REG_753139_INM(m) \
	in_dword_masked(HWIO_REG_753139_ADDR, m)
#define HWIO_REG_753139_OUT(v) \
	out_dword(HWIO_REG_753139_ADDR, v)
#define HWIO_REG_753139_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_753139_ADDR, m, v,\
	HWIO_REG_753139_IN);
#define HWIO_REG_753139_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_753139_BASE_ADDR_SHFT  0

#define HWIO_REG_409994_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x00000798)
#define HWIO_REG_409994_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000798)
#define HWIO_REG_409994_RMSK  0x1ffff
#define HWIO_REG_409994_SHFT  0
#define HWIO_REG_409994_IN  in_dword_masked(\
	HWIO_REG_409994_ADDR,\
	HWIO_REG_409994_RMSK)
#define HWIO_REG_409994_INM(m) \
	in_dword_masked(HWIO_REG_409994_ADDR, m)
#define HWIO_REG_409994_OUT(v) \
	out_dword(HWIO_REG_409994_ADDR, v)
#define HWIO_REG_409994_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_409994_ADDR, m, v,\
	HWIO_REG_409994_IN);
#define HWIO_REG_409994_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_409994_BASE_ADDR_SHFT  0

#define HWIO_REG_492611_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000079c)
#define HWIO_REG_492611_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000079c)
#define HWIO_REG_492611_RMSK  0x1ffff
#define HWIO_REG_492611_SHFT  0
#define HWIO_REG_492611_IN  in_dword_masked(\
	HWIO_REG_492611_ADDR,\
	HWIO_REG_492611_RMSK)
#define HWIO_REG_492611_INM(m) \
	in_dword_masked(HWIO_REG_492611_ADDR, m)
#define HWIO_REG_492611_OUT(v) \
	out_dword(HWIO_REG_492611_ADDR, v)
#define HWIO_REG_492611_OUTM(m, v) \
	out_dword_masked_ns(HWIO_REG_492611_ADDR, m, v,\
	HWIO_REG_492611_IN);
#define HWIO_REG_492611_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_492611_BASE_ADDR_SHFT  0

#define HWIO_REG_91427_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007a0)
#define HWIO_REG_91427_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007a0)
#define HWIO_REG_91427_RMSK  0x1ffff
#define HWIO_REG_91427_SHFT  0
#define HWIO_REG_91427_IN  in_dword_masked(\
	HWIO_REG_91427_ADDR,\
	HWIO_REG_91427_RMSK)
#define HWIO_REG_91427_INM(m) \
	in_dword_masked(HWIO_REG_91427_ADDR, m)
#define HWIO_REG_91427_OUT(v) \
	out_dword(HWIO_REG_91427_ADDR, v)
#define HWIO_REG_91427_OUTM(m, v) \
	out_dword_masked_ns(HWIO_REG_91427_ADDR, m, v,\
	HWIO_REG_91427_IN);
#define HWIO_REG_91427_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_91427_BASE_ADDR_SHFT  0

#define HWIO_REG_617696_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007a4)
#define HWIO_REG_617696_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007a4)
#define HWIO_REG_617696_RMSK  0x1ffff
#define HWIO_REG_617696_SHFT  0
#define HWIO_REG_617696_IN  in_dword_masked(\
	HWIO_REG_617696_ADDR,\
	HWIO_REG_617696_RMSK)
#define HWIO_REG_617696_INM(m) \
	in_dword_masked(HWIO_REG_617696_ADDR, m)
#define HWIO_REG_617696_OUT(v) \
	out_dword(HWIO_REG_617696_ADDR, v)
#define HWIO_REG_617696_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_617696_ADDR, m, v,\
	HWIO_REG_617696_IN);
#define HWIO_REG_617696_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_617696_BASE_ADDR_SHFT  0

#define HWIO_REG_459602_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007a8)
#define HWIO_REG_459602_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007a8)
#define HWIO_REG_459602_RMSK  0x1ffff
#define HWIO_REG_459602_SHFT  0
#define HWIO_REG_459602_IN  in_dword_masked(\
	HWIO_REG_459602_ADDR,\
	HWIO_REG_459602_RMSK)
#define HWIO_REG_459602_INM(m) \
	in_dword_masked(HWIO_REG_459602_ADDR, m)
#define HWIO_REG_459602_OUT(v) \
	out_dword(HWIO_REG_459602_ADDR, v)
#define HWIO_REG_459602_OUTM(m, v) \
	out_dword_masked_ns(HWIO_REG_459602_ADDR, m, v,\
	HWIO_REG_459602_IN);
#define HWIO_REG_459602_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_459602_BASE_ADDR_SHFT  0

#define HWIO_REG_758_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007ac)
#define HWIO_REG_758_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007ac)
#define HWIO_REG_758_RMSK  0x1ffff
#define HWIO_REG_758_SHFT  0
#define HWIO_REG_758_IN  in_dword_masked(\
	HWIO_REG_758_ADDR,\
	HWIO_REG_758_RMSK)
#define HWIO_REG_758_INM(m) \
	in_dword_masked(HWIO_REG_758_ADDR, m)
#define HWIO_REG_758_OUT(v) \
	out_dword(HWIO_REG_758_ADDR, v)
#define HWIO_REG_758_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_758_ADDR, m, v,\
	HWIO_REG_758_IN);
#define HWIO_REG_758_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_758_BASE_ADDR_SHFT  0

#define HWIO_REG_710606_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007b0)
#define HWIO_REG_710606_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007b0)
#define HWIO_REG_710606_RMSK  0x1ffff
#define HWIO_REG_710606_SHFT  0
#define HWIO_REG_710606_IN  in_dword_masked(\
	HWIO_REG_710606_ADDR,\
	HWIO_REG_710606_RMSK)
#define HWIO_REG_710606_INM(m) \
	in_dword_masked(HWIO_REG_710606_ADDR, m)
#define HWIO_REG_710606_OUT(v) \
	out_dword(HWIO_REG_710606_ADDR, v)
#define HWIO_REG_710606_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_710606_ADDR, m, v,\
	HWIO_REG_710606_IN);
#define HWIO_REG_710606_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_710606_BASE_ADDR_SHFT  0

#define HWIO_REG_122975_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007b4)
#define HWIO_REG_122975_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007b4)
#define HWIO_REG_122975_RMSK  0x1ffff
#define HWIO_REG_122975_SHFT  0
#define HWIO_REG_122975_IN  in_dword_masked(\
	HWIO_REG_122975_ADDR,\
	HWIO_REG_122975_RMSK)
#define HWIO_REG_122975_INM(m)\
	in_dword_masked(HWIO_REG_122975_ADDR, m)
#define HWIO_REG_122975_OUT(v)\
	out_dword(HWIO_REG_122975_ADDR, v)
#define HWIO_REG_122975_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_122975_ADDR, m, v,\
	HWIO_REG_122975_IN);
#define HWIO_REG_122975_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_122975_BASE_ADDR_SHFT  0

#define HWIO_REG_860205_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007b8)
#define HWIO_REG_860205_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007b8)
#define HWIO_REG_860205_RMSK  0x1ffff
#define HWIO_REG_860205_SHFT  0
#define HWIO_REG_860205_IN  in_dword_masked(\
	HWIO_REG_860205_ADDR,\
	HWIO_REG_860205_RMSK)
#define HWIO_REG_860205_INM(m) \
	in_dword_masked(HWIO_REG_860205_ADDR, m)
#define HWIO_REG_860205_OUT(v) \
	out_dword(HWIO_REG_860205_ADDR, v)
#define HWIO_REG_860205_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_860205_ADDR, m, v,\
	HWIO_REG_860205_IN);
#define HWIO_REG_860205_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_860205_BASE_ADDR_SHFT  0

#define HWIO_REG_366154_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007bc)
#define HWIO_REG_366154_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007bc)
#define HWIO_REG_366154_RMSK  0x1ffff
#define HWIO_REG_366154_SHFT  0
#define HWIO_REG_366154_IN  in_dword_masked(\
	HWIO_REG_366154_ADDR,\
	HWIO_REG_366154_RMSK)
#define HWIO_REG_366154_INM(m) \
	in_dword_masked(HWIO_REG_366154_ADDR, m)
#define HWIO_REG_366154_OUT(v) \
	out_dword(HWIO_REG_366154_ADDR, v)
#define HWIO_REG_366154_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_366154_ADDR, m, v,\
	HWIO_REG_366154_IN);
#define HWIO_REG_366154_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_366154_BASE_ADDR_SHFT  0

#define HWIO_REG_632247_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007c0)
#define HWIO_REG_632247_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007c0)
#define HWIO_REG_632247_RMSK  0x1ffff
#define HWIO_REG_632247_SHFT  0
#define HWIO_REG_632247_IN  in_dword_masked(\
	HWIO_REG_632247_ADDR,\
	HWIO_REG_632247_RMSK)
#define HWIO_REG_632247_INM(m) \
	in_dword_masked(HWIO_REG_632247_ADDR, m)
#define HWIO_REG_632247_OUT(v) \
	out_dword(HWIO_REG_632247_ADDR, v)
#define HWIO_REG_632247_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_632247_ADDR, m, v,\
	HWIO_REG_632247_IN);
#define HWIO_REG_632247_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_632247_BASE_ADDR_SHFT  0

#define HWIO_REG_709312_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007c4)
#define HWIO_REG_709312_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007c4)
#define HWIO_REG_709312_RMSK  0x1ffff
#define HWIO_REG_709312_SHFT  0
#define HWIO_REG_709312_IN  in_dword_masked(\
	HWIO_REG_709312_ADDR,\
	HWIO_REG_709312_RMSK)
#define HWIO_REG_709312_INM(m) \
	in_dword_masked(HWIO_REG_709312_ADDR, m)
#define HWIO_REG_709312_OUT(v) \
	out_dword(HWIO_REG_709312_ADDR, v)
#define HWIO_REG_709312_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_709312_ADDR, m, v,\
	HWIO_REG_709312_IN);
#define HWIO_REG_709312_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_709312_BASE_ADDR_SHFT  0

#define HWIO_REG_891367_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007c8)
#define HWIO_REG_891367_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007c8)
#define HWIO_REG_891367_RMSK  0x1ffff
#define HWIO_REG_891367_SHFT  0
#define HWIO_REG_891367_IN  in_dword_masked(\
	HWIO_REG_891367_ADDR,\
	HWIO_REG_891367_RMSK)
#define HWIO_REG_891367_INM(m) \
	in_dword_masked(HWIO_REG_891367_ADDR, m)
#define HWIO_REG_891367_OUT(v) \
	out_dword(HWIO_REG_891367_ADDR, v)
#define HWIO_REG_891367_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_891367_ADDR, m, v,\
	HWIO_REG_891367_IN);
#define HWIO_REG_891367_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_891367_BASE_ADDR_SHFT  0

#define HWIO_REG_628746_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007cc)
#define HWIO_REG_628746_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007cc)
#define HWIO_REG_628746_RMSK  0x1ffff
#define HWIO_REG_628746_SHFT  0
#define HWIO_REG_628746_IN  in_dword_masked(\
	HWIO_REG_628746_ADDR,\
	HWIO_REG_628746_RMSK)
#define HWIO_REG_628746_INM(m) \
	in_dword_masked(HWIO_REG_628746_ADDR, m)
#define HWIO_REG_628746_OUT(v) \
	out_dword(HWIO_REG_628746_ADDR, v)
#define HWIO_REG_628746_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_628746_ADDR, m, v,\
	HWIO_REG_628746_IN);
#define HWIO_REG_628746_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_628746_BASE_ADDR_SHFT  0

#define HWIO_REG_821010_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007d0)
#define HWIO_REG_821010_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007d0)
#define HWIO_REG_821010_RMSK  0x1ffff
#define HWIO_REG_821010_SHFT  0
#define HWIO_REG_821010_IN  in_dword_masked(\
	HWIO_REG_821010_ADDR,\
	HWIO_REG_821010_RMSK)
#define HWIO_REG_821010_INM(m) \
	in_dword_masked(HWIO_REG_821010_ADDR, m)
#define HWIO_REG_821010_OUT(v) \
	out_dword(HWIO_REG_821010_ADDR, v)
#define HWIO_REG_821010_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_821010_ADDR, m, v,\
	HWIO_REG_821010_IN);
#define HWIO_REG_821010_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_821010_BASE_ADDR_SHFT  0

#define HWIO_REG_902098_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007d4)
#define HWIO_REG_902098_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007d4)
#define HWIO_REG_902098_RMSK  0x1ffff
#define HWIO_REG_902098_SHFT  0
#define HWIO_REG_902098_IN   in_dword_masked(\
	HWIO_REG_902098_ADDR,\
	HWIO_REG_902098_RMSK)
#define HWIO_REG_902098_INM(m) \
	in_dword_masked(HWIO_REG_902098_ADDR, m)
#define HWIO_REG_902098_OUT(v) \
	out_dword(HWIO_REG_902098_ADDR, v)
#define HWIO_REG_902098_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_902098_ADDR, m, v,\
	HWIO_REG_902098_IN);
#define HWIO_REG_902098_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_902098_BASE_ADDR_SHFT  0

#define HWIO_REG_939091_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007d8)
#define HWIO_REG_939091_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007d8)
#define HWIO_REG_939091_RMSK  0x1ffff
#define HWIO_REG_939091_SHFT  0
#define HWIO_REG_939091_IN  in_dword_masked(\
	HWIO_REG_939091_ADDR,\
	HWIO_REG_939091_RMSK)
#define HWIO_REG_939091_INM(m) \
	in_dword_masked(HWIO_REG_939091_ADDR, m)
#define HWIO_REG_939091_OUT(v) \
	out_dword(HWIO_REG_939091_ADDR, v)
#define HWIO_REG_939091_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_939091_ADDR, m, v,\
	HWIO_REG_939091_IN);
#define HWIO_REG_939091_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_939091_BASE_ADDR_SHFT  0

#define HWIO_REG_261074_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007dc)
#define HWIO_REG_261074_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007dc)
#define HWIO_REG_261074_RMSK  0x1ffff
#define HWIO_REG_261074_SHFT  0
#define HWIO_REG_261074_IN  in_dword_masked(\
	HWIO_REG_261074_ADDR,\
	HWIO_REG_261074_RMSK)
#define HWIO_REG_261074_INM(m) \
	in_dword_masked(HWIO_REG_261074_ADDR, m)
#define HWIO_REG_261074_OUT(v) \
	out_dword(HWIO_REG_261074_ADDR, v)
#define HWIO_REG_261074_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_261074_ADDR, m, v,\
	HWIO_REG_261074_IN);
#define HWIO_REG_261074_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_261074_BASE_ADDR_SHFT  0

#define HWIO_REG_157718_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007e0)
#define HWIO_REG_157718_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007e0)
#define HWIO_REG_157718_RMSK  0x1ffff
#define HWIO_REG_157718_SHFT  0
#define HWIO_REG_157718_IN  in_dword_masked(\
	HWIO_REG_157718_ADDR,\
	HWIO_REG_157718_RMSK)
#define HWIO_REG_157718_INM(m) \
	in_dword_masked(HWIO_REG_157718_ADDR, m)
#define HWIO_REG_157718_OUT(v) \
	out_dword(HWIO_REG_157718_ADDR, v)
#define HWIO_REG_157718_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_157718_ADDR, m, v,\
	HWIO_REG_157718_IN);
#define HWIO_REG_5552391_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_5552391_BASE_ADDR_SHFT  0

#define HWIO_REG_148889_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007e8)
#define HWIO_REG_148889_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007e8)
#define HWIO_REG_148889_RMSK  0x1ffff
#define HWIO_REG_148889_SHFT  0
#define HWIO_REG_148889_IN  in_dword_masked(\
	HWIO_REG_148889_ADDR,\
	HWIO_REG_148889_RMSK)
#define HWIO_REG_148889_INM(m) \
	in_dword_masked(HWIO_REG_148889_ADDR, m)
#define HWIO_REG_148889_OUT(v) \
	out_dword(HWIO_REG_148889_ADDR, v)
#define HWIO_REG_148889_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_148889_ADDR, m, v,\
	HWIO_REG_148889_IN);
#define HWIO_REG_148889_BASE_ADDR_BMSK 0x1ffff
#define HWIO_REG_148889_BASE_ADDR_SHFT 0

#define HWIO_REG_396380_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007ec)
#define HWIO_REG_396380_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007ec)
#define HWIO_REG_396380_RMSK  0x1ffff
#define HWIO_REG_396380_SHFT  0
#define HWIO_REG_396380_IN  in_dword_masked(\
	HWIO_REG_396380_ADDR,\
	HWIO_REG_396380_RMSK)
#define HWIO_REG_396380_INM(m) \
	in_dword_masked(HWIO_REG_396380_ADDR, m)
#define HWIO_REG_396380_OUT(v) \
	out_dword(HWIO_REG_396380_ADDR, v)
#define HWIO_REG_396380_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_396380_ADDR, m, v,\
	HWIO_REG_396380_IN);
#define HWIO_REG_396380_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_396380_BASE_ADDR_SHFT  0

#define HWIO_REG_351005_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007f0)
#define HWIO_REG_351005_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007f0)
#define HWIO_REG_351005_RMSK  0x1ffff
#define HWIO_REG_351005_SHFT  0
#define HWIO_REG_351005_IN  in_dword_masked(\
	HWIO_REG_351005_ADDR,\
	HWIO_REG_351005_RMSK)
#define HWIO_REG_351005_INM(m) \
	in_dword_masked(HWIO_REG_351005_ADDR, m)
#define HWIO_REG_351005_OUT(v) \
	out_dword(HWIO_REG_351005_ADDR, v)
#define HWIO_REG_351005_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_351005_ADDR, m, v,\
	HWIO_REG_351005_IN);
#define HWIO_REG_351005_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_351005_BASE_ADDR_SHFT  0

#define HWIO_REG_863263_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007f4)
#define HWIO_REG_863263_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007f4)
#define HWIO_REG_863263_RMSK  0x1ffff
#define HWIO_REG_863263_SHFT  0
#define HWIO_REG_863263_IN  in_dword_masked(\
	HWIO_REG_863263_ADDR,\
	HWIO_REG_863263_RMSK)
#define HWIO_REG_863263_INM(m) \
	in_dword_masked(HWIO_REG_863263_ADDR, m)
#define HWIO_REG_863263_OUT(v) \
	out_dword(HWIO_REG_863263_ADDR, v)
#define HWIO_REG_863263_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_863263_ADDR, m, v,\
	HWIO_REG_863263_IN);
#define HWIO_REG_863263_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_863263_BASE_ADDR_SHFT   0

#define HWIO_REG_135009_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007f8)
#define HWIO_REG_135009_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007f8)
#define HWIO_REG_135009_RMSK  0x1ffff
#define HWIO_REG_135009_SHFT  0
#define HWIO_REG_135009_IN  in_dword_masked(\
	HWIO_REG_135009_ADDR,\
	HWIO_REG_135009_RMSK)
#define HWIO_REG_135009_INM(m) \
	in_dword_masked(HWIO_REG_135009_ADDR, m)
#define HWIO_REG_135009_OUT(v) \
	out_dword(HWIO_REG_135009_ADDR, v)
#define HWIO_REG_135009_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_135009_ADDR, m, v,\
	HWIO_REG_135009_IN);
#define HWIO_REG_135009_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_135009_BASE_ADDR_SHFT  0

#define HWIO_REG_923883_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x000007fc)
#define HWIO_REG_923883_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000007fc)
#define HWIO_REG_923883_RMSK  0x1ffff
#define HWIO_REG_923883_SHFT  0
#define HWIO_REG_923883_IN  in_dword_masked(\
	HWIO_REG_923883_ADDR,\
	HWIO_REG_923883_RMSK)
#define HWIO_REG_923883_INM(m) \
	in_dword_masked(HWIO_REG_923883_ADDR, m)
#define HWIO_REG_923883_OUT(v) \
	out_dword(HWIO_REG_923883_ADDR, v)
#define HWIO_REG_923883_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_923883_ADDR, m, v,\
	HWIO_REG_923883_IN);
#define HWIO_REG_923883_BASE_ADDR_BMSK  0x1ffff
#define HWIO_REG_923883_BASE_ADDR_SHFT  0

#define HWIO_REG_934655_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000818)
#define HWIO_REG_934655_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000818)
#define HWIO_REG_934655_RMSK  0x1fff
#define HWIO_REG_934655_SHFT  0
#define HWIO_REG_934655_IN \
	in_dword_masked(HWIO_REG_934655_ADDR, HWIO_REG_934655_RMSK)
#define HWIO_REG_934655_INM(m) \
	in_dword_masked(HWIO_REG_934655_ADDR, m)
#define HWIO_REG_934655_OUT(v) \
	out_dword(HWIO_REG_934655_ADDR, v)
#define HWIO_REG_934655_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_934655_ADDR, m, v, HWIO_REG_934655_IN);
#define HWIO_REG_934655_FRAME_WIDTH_BMSK  0x1fff
#define HWIO_REG_934655_FRAME_WIDTH_SHFT  0

#define HWIO_REG_179070_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000081c)
#define HWIO_REG_179070_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000081c)
#define HWIO_REG_179070_RMSK  0x1fff
#define HWIO_REG_179070_SHFT  0
#define HWIO_REG_179070_IN  in_dword_masked(\
	HWIO_REG_179070_ADDR, HWIO_REG_179070_RMSK)
#define HWIO_REG_179070_INM(m) \
	in_dword_masked(HWIO_REG_179070_ADDR, m)
#define HWIO_REG_179070_OUT(v) \
	out_dword(HWIO_REG_179070_ADDR, v)
#define HWIO_REG_179070_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_179070_ADDR, m, v, HWIO_REG_179070_IN);
#define HWIO_REG_179070_FRAME_HEIGHT_BMSK  0x1fff
#define HWIO_REG_179070_FRAME_HEIGHT_SHFT  0

#define HWIO_REG_63643_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000830)
#define HWIO_REG_63643_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000830)
#define HWIO_REG_63643_RMSK  0xff3f
#define HWIO_REG_63643_SHFT  0
#define HWIO_REG_63643_IN  in_dword_masked(\
	HWIO_REG_63643_ADDR, HWIO_REG_63643_RMSK)
#define HWIO_REG_63643_INM(m) \
	in_dword_masked(HWIO_REG_63643_ADDR, m)
#define HWIO_REG_63643_OUT(v) \
	out_dword(HWIO_REG_63643_ADDR, v)
#define HWIO_REG_63643_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_63643_ADDR, m, v, HWIO_REG_63643_IN);
#define HWIO_REG_63643_LEVEL_BMSK    0xff00
#define HWIO_REG_63643_LEVEL_SHFT    0x8
#define HWIO_REG_63643_PROFILE_BMSK  0x3f
#define HWIO_REG_63643_PROFILE_SHFT  0

#define HWIO_REG_786024_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000083c)
#define HWIO_REG_786024_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000083c)
#define HWIO_REG_786024_RMSK  0x1
#define HWIO_REG_786024_SHFT  0
#define HWIO_REG_786024_IN  in_dword_masked(\
	HWIO_REG_786024_ADDR, HWIO_REG_786024_RMSK)
#define HWIO_REG_786024_INM(m) \
	in_dword_masked(HWIO_REG_786024_ADDR, m)
#define HWIO_REG_786024_OUT(v) \
	out_dword(HWIO_REG_786024_ADDR, v)
#define HWIO_REG_786024_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_786024_ADDR, m, v, HWIO_REG_786024_IN);
#define HWIO_REG_786024_FIELD_BMSK  0x1
#define HWIO_REG_786024_FIELD_SHFT  0

#define HWIO_REG_152500_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000848)
#define HWIO_REG_152500_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000848)
#define HWIO_REG_152500_RMSK  0x3
#define HWIO_REG_152500_SHFT  0
#define HWIO_REG_152500_IN  in_dword_masked(\
	HWIO_REG_152500_ADDR, HWIO_REG_152500_RMSK)
#define HWIO_REG_152500_INM(m) \
	in_dword_masked(HWIO_REG_152500_ADDR, m)
#define HWIO_REG_152500_OUT(v) \
	out_dword(HWIO_REG_152500_ADDR, v)
#define HWIO_REG_152500_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_152500_ADDR, m, v, HWIO_REG_152500_IN);
#define HWIO_REG_152500_LF_CONTROL_BMSK  0x3
#define HWIO_REG_152500_LF_CONTROL_SHFT  0

#define HWIO_REG_266285_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000084c)
#define HWIO_REG_266285_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000084c)
#define HWIO_REG_266285_RMSK  0x1f
#define HWIO_REG_266285_SHFT  0
#define HWIO_REG_266285_IN  in_dword_masked(\
	HWIO_REG_266285_ADDR, HWIO_REG_266285_RMSK)
#define HWIO_REG_266285_INM(m) \
	in_dword_masked(HWIO_REG_266285_ADDR, m)
#define HWIO_REG_266285_OUT(v) \
	out_dword(HWIO_REG_266285_ADDR, v)
#define HWIO_REG_266285_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_266285_ADDR, m, v, HWIO_REG_266285_IN);
#define HWIO_REG_266285_LF_ALPHAS_OFF_BMSK  0x1f
#define HWIO_REG_266285_LF_ALPHAS_OFF_SHFT  0

#define HWIO_REG_964731_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000850)
#define HWIO_REG_964731_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000850)
#define HWIO_REG_964731_RMSK  0x1f
#define HWIO_REG_964731_SHFT  0
#define HWIO_REG_964731_IN  in_dword_masked(\
	HWIO_REG_964731_ADDR, HWIO_REG_964731_RMSK)
#define HWIO_REG_964731_INM(m) \
	in_dword_masked(HWIO_REG_964731_ADDR, m)
#define HWIO_REG_964731_OUT(v) \
	out_dword(HWIO_REG_964731_ADDR, v)
#define HWIO_REG_964731_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_964731_ADDR, m, v, HWIO_REG_964731_IN);
#define HWIO_REG_964731_LF_BETA_OFF_BMSK  0x1f
#define HWIO_REG_964731_LF_BETA_OFF_SHFT  0

#define HWIO_REG_919924_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000c30)
#define HWIO_REG_919924_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000c30)
#define HWIO_REG_919924_RMSK  0xffffffff
#define HWIO_REG_919924_SHFT  0
#define HWIO_REG_919924_IN  in_dword_masked(\
	HWIO_REG_919924_ADDR, HWIO_REG_919924_RMSK)
#define HWIO_REG_919924_INM(m) \
	in_dword_masked(HWIO_REG_919924_ADDR, m)
#define HWIO_REG_919924_OUT(v) \
	out_dword(HWIO_REG_919924_ADDR, v)
#define HWIO_REG_919924_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_919924_ADDR, m, v, HWIO_REG_919924_IN);
#define HWIO_REG_919924_VIDC_QP_OFFSET_BMSK  0xffffffff
#define HWIO_REG_919924_VIDC_QP_OFFSET_SHFT  0

#define HWIO_REG_143629_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00000c34)
#define HWIO_REG_143629_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00000c34)
#define HWIO_REG_143629_RMSK  0x1
#define HWIO_REG_143629_SHFT  0
#define HWIO_REG_143629_IN  in_dword_masked(\
	HWIO_REG_143629_ADDR, HWIO_REG_143629_RMSK)
#define HWIO_REG_143629_INM(m) \
	in_dword_masked(HWIO_REG_143629_ADDR, m)
#define HWIO_REG_143629_OUT(v) \
	out_dword(HWIO_REG_143629_ADDR, v)
#define HWIO_REG_143629_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_143629_ADDR, m, v, HWIO_REG_143629_IN);
#define HWIO_REG_143629_REG_143629_BMSK  0x1
#define HWIO_REG_143629_REG_143629_SHFT  0

#define HWIO_REG_607589_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002000)
#define HWIO_REG_607589_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002000)
#define HWIO_REG_607589_RMSK  0xffffffff
#define HWIO_REG_607589_SHFT  0
#define HWIO_REG_607589_IN  in_dword_masked(\
	HWIO_REG_607589_ADDR, HWIO_REG_607589_RMSK)
#define HWIO_REG_607589_INM(m) \
	in_dword_masked(HWIO_REG_607589_ADDR, m)
#define HWIO_REG_607589_OUT(v) \
	out_dword(HWIO_REG_607589_ADDR, v)
#define HWIO_REG_607589_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_607589_ADDR, m, v, HWIO_REG_607589_IN);
#define HWIO_REG_607589_RTN_CHID_BMSK  0xffffffff
#define HWIO_REG_607589_RTN_CHID_SHFT  0

#define HWIO_REG_845544_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002004)
#define HWIO_REG_845544_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002004)
#define HWIO_REG_845544_RMSK  0xffffffff
#define HWIO_REG_845544_SHFT  0
#define HWIO_REG_845544_IN  in_dword_masked(\
	HWIO_REG_845544_ADDR, HWIO_REG_845544_RMSK)
#define HWIO_REG_845544_INM(m) \
	in_dword_masked(HWIO_REG_845544_ADDR, m)
#define HWIO_REG_845544_OUT(v) \
	out_dword(HWIO_REG_845544_ADDR, v)
#define HWIO_REG_845544_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_845544_ADDR, m, v, HWIO_REG_845544_IN);
#define HWIO_REG_845544_REG_845544_BMSK  0xffffffff
#define HWIO_REG_845544_REG_845544_SHFT  0

#define HWIO_REG_859906_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002008)
#define HWIO_REG_859906_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002008)
#define HWIO_REG_859906_RMSK  0xffffffff
#define HWIO_REG_859906_SHFT  0
#define HWIO_REG_859906_IN  in_dword_masked(\
	HWIO_REG_859906_ADDR, HWIO_REG_859906_RMSK)
#define HWIO_REG_859906_INM(m) \
	in_dword_masked(HWIO_REG_859906_ADDR, m)
#define HWIO_REG_859906_OUT(v) \
	out_dword(HWIO_REG_859906_ADDR, v)
#define HWIO_REG_859906_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_859906_ADDR, m, v, HWIO_REG_859906_IN);
#define HWIO_REG_859906_REG_859906_BMSK  0xffffffff
#define HWIO_REG_859906_REG_859906_SHFT  0

#define HWIO_REG_490078_ADDR  (VIDC_BLACKBIRD_REG_BASE + 0x0000200c)
#define HWIO_REG_490078_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000200c)
#define HWIO_REG_490078_RMSK  0xffffffff
#define HWIO_REG_490078_SHFT  0
#define HWIO_REG_490078_IN  in_dword_masked(\
	HWIO_REG_490078_ADDR, HWIO_REG_490078_RMSK)
#define HWIO_REG_490078_INM(m) \
	in_dword_masked(HWIO_REG_490078_ADDR, m)
#define HWIO_REG_490078_OUT(v) \
	out_dword(HWIO_REG_490078_ADDR, v)
#define HWIO_REG_490078_OUTM(m, v) \
	out_dword_masked_ns(HWIO_REG_490078_ADDR, m, v,\
	HWIO_REG_490078_IN);
#define HWIO_REG_490078_REG_490078_BMSK  0xffffffff
#define HWIO_REG_490078_REG_490078_SHFT  0

#define HWIO_REG_640904_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002010)
#define HWIO_REG_640904_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002010)
#define HWIO_REG_640904_RMSK  0xffffffff
#define HWIO_REG_640904_SHFT  0
#define HWIO_REG_640904_IN  in_dword_masked(\
	HWIO_REG_640904_ADDR, HWIO_REG_640904_RMSK)
#define HWIO_REG_640904_INM(m) \
	in_dword_masked(HWIO_REG_640904_ADDR, m)
#define HWIO_REG_640904_OUT(v) \
	out_dword(HWIO_REG_640904_ADDR, v)
#define HWIO_REG_640904_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_640904_ADDR, m, v, HWIO_REG_640904_IN);
#define HWIO_REG_640904_REG_640904_BMSK  0xffffffff
#define HWIO_REG_640904_REG_640904_SHFT  0

#define HWIO_REG_60114_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002014)
#define HWIO_REG_60114_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002014)
#define HWIO_REG_60114_RMSK  0xffffffff
#define HWIO_REG_60114_SHFT  0
#define HWIO_REG_60114_IN  in_dword_masked(\
	HWIO_REG_60114_ADDR, HWIO_REG_60114_RMSK)
#define HWIO_REG_60114_INM(m) \
	in_dword_masked(HWIO_REG_60114_ADDR, m)
#define HWIO_REG_60114_OUT(v) \
	out_dword(HWIO_REG_60114_ADDR, v)
#define HWIO_REG_60114_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_60114_ADDR, m, v, HWIO_REG_60114_IN);
#define HWIO_REG_60114_REG_60114_BMSK  0xffffffff
#define HWIO_REG_60114_REG_60114_SHFT  0

#define HWIO_REG_489688_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002018)
#define HWIO_REG_489688_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002018)
#define HWIO_REG_489688_RMSK  0xffffffff
#define HWIO_REG_489688_SHFT  0
#define HWIO_REG_489688_IN  in_dword_masked(\
	HWIO_REG_489688_ADDR, HWIO_REG_489688_RMSK)
#define HWIO_REG_489688_INM(m) \
	in_dword_masked(HWIO_REG_489688_ADDR, m)
#define HWIO_REG_489688_OUT(v) \
	out_dword(HWIO_REG_489688_ADDR, v)
#define HWIO_REG_489688_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_489688_ADDR, m, v, HWIO_REG_489688_IN);
#define HWIO_REG_489688_REG_489688_BMSK  0xffffffff
#define HWIO_REG_489688_REG_489688_SHFT  0

#define HWIO_REG_853667_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000201c)
#define HWIO_REG_853667_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000201c)
#define HWIO_REG_853667_RMSK  0xffffffff
#define HWIO_REG_853667_SHFT  0
#define HWIO_REG_853667_IN  in_dword_masked(\
	HWIO_REG_853667_ADDR, HWIO_REG_853667_RMSK)
#define HWIO_REG_853667_INM(m) \
	in_dword_masked(HWIO_REG_853667_ADDR, m)
#define HWIO_REG_853667_OUT(v) \
	out_dword(HWIO_REG_853667_ADDR, v)
#define HWIO_REG_853667_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_853667_ADDR, m, v, HWIO_REG_853667_IN);
#define HWIO_REG_853667_REG_853667_BMSK  0xffffffff
#define HWIO_REG_853667_REG_853667_SHFT  0

#define HWIO_REG_760102_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002020)
#define HWIO_REG_760102_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002020)
#define HWIO_REG_760102_RMSK  0xffffffff
#define HWIO_REG_760102_SHFT  0
#define HWIO_REG_760102_IN  in_dword_masked(\
	HWIO_REG_760102_ADDR, HWIO_REG_760102_RMSK)
#define HWIO_REG_760102_INM(m) \
	in_dword_masked(HWIO_REG_760102_ADDR, m)
#define HWIO_REG_760102_OUT(v) \
	out_dword(HWIO_REG_760102_ADDR, v)
#define HWIO_REG_760102_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_760102_ADDR, m, v, HWIO_REG_760102_IN);
#define HWIO_REG_760102_REG_760102_BMSK  0xffffffff
#define HWIO_REG_760102_REG_760102_SHFT  0

#define HWIO_REG_378318_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002024)
#define HWIO_REG_378318_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002024)
#define HWIO_REG_378318_RMSK  0xffffffff
#define HWIO_REG_378318_SHFT  0
#define HWIO_REG_378318_IN  in_dword_masked(\
	HWIO_REG_378318_ADDR, HWIO_REG_378318_RMSK)
#define HWIO_REG_378318_INM(m) \
	in_dword_masked(HWIO_REG_378318_ADDR, m)
#define HWIO_REG_378318_OUT(v) \
	out_dword(HWIO_REG_378318_ADDR, v)
#define HWIO_REG_378318_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_378318_ADDR, m, v, HWIO_REG_378318_IN);
#define HWIO_REG_378318_REG_378318_BMSK  0xffffffff
#define HWIO_REG_378318_REG_378318_SHFT  0

#define HWIO_REG_203487_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002028)
#define HWIO_REG_203487_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002028)
#define HWIO_REG_203487_RMSK  0xffffffff
#define HWIO_REG_203487_SHFT  0
#define HWIO_REG_203487_IN  in_dword_masked(\
	HWIO_REG_203487_ADDR, HWIO_REG_203487_RMSK)
#define HWIO_REG_203487_INM(m) \
	in_dword_masked(HWIO_REG_203487_ADDR, m)
#define HWIO_REG_203487_OUT(v) \
	out_dword(HWIO_REG_203487_ADDR, v)
#define HWIO_REG_203487_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_203487_ADDR, m, v, HWIO_REG_203487_IN);
#define HWIO_REG_203487_REG_203487_BMSK  0xffffffff
#define HWIO_REG_203487_REG_203487_SHFT  0

#define HWIO_REG_692991_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000202c)
#define HWIO_REG_692991_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000202c)
#define HWIO_REG_692991_RMSK  0xffffffff
#define HWIO_REG_692991_SHFT  0
#define HWIO_REG_692991_IN  in_dword_masked(\
	HWIO_REG_692991_ADDR, HWIO_REG_692991_RMSK)
#define HWIO_REG_692991_INM(m) \
	in_dword_masked(HWIO_REG_692991_ADDR, m)
#define HWIO_REG_692991_OUT(v) \
	out_dword(HWIO_REG_692991_ADDR, v)
#define HWIO_REG_692991_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_692991_ADDR, m, v, HWIO_REG_692991_IN);
#define HWIO_REG_692991_REG_692991_BMSK  0xffffffff
#define HWIO_REG_692991_REG_692991_SHFT  0

#define HWIO_REG_161740_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002030)
#define HWIO_REG_161740_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002030)
#define HWIO_REG_161740_RMSK  0xffffffff
#define HWIO_REG_161740_SHFT  0
#define HWIO_REG_161740_IN  in_dword_masked(\
	HWIO_REG_161740_ADDR, HWIO_REG_161740_RMSK)
#define HWIO_REG_161740_INM(m) \
	in_dword_masked(HWIO_REG_161740_ADDR, m)
#define HWIO_REG_161740_OUT(v) \
	out_dword(HWIO_REG_161740_ADDR, v)
#define HWIO_REG_161740_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_161740_ADDR, m, v, HWIO_REG_161740_IN);
#define HWIO_REG_161740_REG_161740_BMSK  0xffffffff
#define HWIO_REG_161740_REG_161740_SHFT  0

#define HWIO_REG_930239_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002034)
#define HWIO_REG_930239_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002034)
#define HWIO_REG_930239_RMSK  0xffffffff
#define HWIO_REG_930239_SHFT  0
#define HWIO_REG_930239_IN  in_dword_masked(\
	HWIO_REG_930239_ADDR, HWIO_REG_930239_RMSK)
#define HWIO_REG_930239_INM(m) \
	in_dword_masked(HWIO_REG_930239_ADDR, m)
#define HWIO_REG_930239_OUT(v) \
	out_dword(HWIO_REG_930239_ADDR, v)
#define HWIO_REG_930239_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_930239_ADDR, m, v, HWIO_REG_930239_IN);
#define HWIO_REG_930239_REG_930239_BMSK  0xffffffff
#define HWIO_REG_930239_REG_930239_SHFT  0

#define HWIO_REG_567827_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002038)
#define HWIO_REG_567827_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002038)
#define HWIO_REG_567827_RMSK  0xffffffff
#define HWIO_REG_567827_SHFT  0
#define HWIO_REG_567827_IN  in_dword_masked(\
	HWIO_REG_567827_ADDR, HWIO_REG_567827_RMSK)
#define HWIO_REG_567827_INM(m) \
	in_dword_masked(HWIO_REG_567827_ADDR, m)
#define HWIO_REG_567827_OUT(v) \
	out_dword(HWIO_REG_567827_ADDR, v)
#define HWIO_REG_567827_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_567827_ADDR, m, v, HWIO_REG_567827_IN);
#define HWIO_REG_567827_REG_567827_BMSK 0xffffffff
#define HWIO_REG_567827_REG_567827_SHFT 0

#define HWIO_REG_542997_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000203c)
#define HWIO_REG_542997_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000203c)
#define HWIO_REG_542997_RMSK  0xffffffff
#define HWIO_REG_542997_SHFT  0
#define HWIO_REG_542997_IN  in_dword_masked(\
	HWIO_REG_542997_ADDR, HWIO_REG_542997_RMSK)
#define HWIO_REG_542997_INM(m) \
	in_dword_masked(HWIO_REG_542997_ADDR, m)
#define HWIO_REG_542997_OUT(v) \
	out_dword(HWIO_REG_542997_ADDR, v)
#define HWIO_REG_542997_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_542997_ADDR, m, v, HWIO_REG_542997_IN);
#define HWIO_REG_542997_REG_542997_BMSK  0xffffffff
#define HWIO_REG_542997_REG_542997_SHFT  0

#define HWIO_REG_666957_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002040)
#define HWIO_REG_666957_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002040)
#define HWIO_REG_666957_RMSK  0x7ffff
#define HWIO_REG_666957_SHFT  0
#define HWIO_REG_666957_IN  in_dword_masked(\
	HWIO_REG_666957_ADDR, HWIO_REG_666957_RMSK)
#define HWIO_REG_666957_INM(m) \
	in_dword_masked(HWIO_REG_666957_ADDR, m)
#define HWIO_REG_666957_OUT(v) \
	out_dword(HWIO_REG_666957_ADDR, v)
#define HWIO_REG_666957_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_666957_ADDR, m, v, HWIO_REG_666957_IN);
#define HWIO_REG_666957_CH_DEC_TYPE_BMSK  0x70000
#define HWIO_REG_666957_CH_DEC_TYPE_SHFT  0x10
#define HWIO_REG_666957_CH_INST_ID_BMSK   0xffff
#define HWIO_REG_666957_CH_INST_ID_SHFT   0

#define HWIO_REG_117192_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002044)
#define HWIO_REG_117192_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002044)
#define HWIO_REG_117192_RMSK  0xffffffff
#define HWIO_REG_117192_SHFT  0
#define HWIO_REG_117192_IN  in_dword_masked(\
	HWIO_REG_117192_ADDR, HWIO_REG_117192_RMSK)
#define HWIO_REG_117192_INM(m) \
	in_dword_masked(HWIO_REG_117192_ADDR, m)
#define HWIO_REG_117192_OUT(v) \
	out_dword(HWIO_REG_117192_ADDR, v)
#define HWIO_REG_117192_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_117192_ADDR, m, v, HWIO_REG_117192_IN);
#define HWIO_REG_117192_REG_117192_BMSK  0xffffffff
#define HWIO_REG_117192_REG_117192_SHFT  0

#define HWIO_REG_145068_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002048)
#define HWIO_REG_145068_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002048)
#define HWIO_REG_145068_RMSK  0xffffffff
#define HWIO_REG_145068_SHFT  0
#define HWIO_REG_145068_IN  in_dword_masked(\
	HWIO_REG_145068_ADDR, HWIO_REG_145068_RMSK)
#define HWIO_REG_145068_INM(m) \
	in_dword_masked(HWIO_REG_145068_ADDR, m)
#define HWIO_REG_145068_OUT(v) \
	out_dword(HWIO_REG_145068_ADDR, v)
#define HWIO_REG_145068_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_145068_ADDR, m, v, HWIO_REG_145068_IN);
#define HWIO_REG_145068_REG_145068_BMSK  0xffffffff
#define HWIO_REG_145068_REG_145068_SHFT  0

#define HWIO_REG_921356_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000204c)
#define HWIO_REG_921356_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000204c)
#define HWIO_REG_921356_RMSK  0xffffffff
#define HWIO_REG_921356_SHFT  0
#define HWIO_REG_921356_IN  in_dword_masked(\
	HWIO_REG_921356_ADDR, HWIO_REG_921356_RMSK)
#define HWIO_REG_921356_INM(m) \
	in_dword_masked(HWIO_REG_921356_ADDR, m)
#define HWIO_REG_921356_OUT(v) \
	out_dword(HWIO_REG_921356_ADDR, v)
#define HWIO_REG_921356_OUTM(m, v) out_dword_masked_ns(\
	HWIO_REG_921356_ADDR, m, v, HWIO_REG_921356_IN);
#define HWIO_REG_921356_REG_921356_BMSK  0xffffffff
#define HWIO_REG_921356_REG_921356_SHFT  0

#define HWIO_REG_612810_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002050)
#define HWIO_REG_612810_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002050)
#define HWIO_REG_612810_RMSK  0xffffffff
#define HWIO_REG_612810_SHFT  0
#define HWIO_REG_612810_IN  in_dword_masked(\
	HWIO_REG_612810_ADDR, HWIO_REG_612810_RMSK)
#define HWIO_REG_612810_INM(m) \
	in_dword_masked(HWIO_REG_612810_ADDR, m)
#define HWIO_REG_612810_OUT(v) \
	out_dword(HWIO_REG_612810_ADDR, v)
#define HWIO_REG_612810_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_612810_ADDR, m, v, HWIO_REG_612810_IN);
#define HWIO_REG_612810_REG_612810_BMSK  0xffffffff
#define HWIO_REG_612810_REG_612810_SHFT  0

#define HWIO_REG_175608_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002054)
#define HWIO_REG_175608_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002054)
#define HWIO_REG_175608_RMSK  0xffffffff
#define HWIO_REG_175608_SHFT  0
#define HWIO_REG_175608_IN  in_dword_masked(\
	HWIO_REG_175608_ADDR, HWIO_REG_175608_RMSK)
#define HWIO_REG_175608_INM(m) \
	in_dword_masked(HWIO_REG_175608_ADDR, m)
#define HWIO_REG_175608_OUT(v) \
	out_dword(HWIO_REG_175608_ADDR, v)
#define HWIO_REG_175608_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_175608_ADDR, m, v, HWIO_REG_175608_IN);
#define HWIO_REG_175608_REG_175608_BMSK  0xffffffff
#define HWIO_REG_175608_REG_175608_SHFT  0

#define HWIO_REG_190381_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002058)
#define HWIO_REG_190381_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002058)
#define HWIO_REG_190381_RMSK  0xffffffff
#define HWIO_REG_190381_SHFT  0
#define HWIO_REG_190381_IN  in_dword_masked(\
	HWIO_REG_190381_ADDR, HWIO_REG_190381_RMSK)
#define HWIO_REG_190381_INM(m) \
	in_dword_masked(HWIO_REG_190381_ADDR, m)
#define HWIO_REG_190381_OUT(v) \
	out_dword(HWIO_REG_190381_ADDR, v)
#define HWIO_REG_190381_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_190381_ADDR, m, v, HWIO_REG_190381_IN);
#define HWIO_REG_190381_REG_190381_BMSK  0xffffffff
#define HWIO_REG_190381_REG_190381_SHFT  0

#define HWIO_REG_85655_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000205c)
#define HWIO_REG_85655_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000205c)
#define HWIO_REG_85655_RMSK  0xffffffff
#define HWIO_REG_85655_SHFT  0
#define HWIO_REG_85655_IN  in_dword_masked(\
	HWIO_REG_85655_ADDR, HWIO_REG_85655_RMSK)
#define HWIO_REG_85655_INM(m) \
	in_dword_masked(HWIO_REG_85655_ADDR, m)
#define HWIO_REG_85655_OUT(v) \
	out_dword(HWIO_REG_85655_ADDR, v)
#define HWIO_REG_85655_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_85655_ADDR, m, v, HWIO_REG_85655_IN);
#define HWIO_REG_85655_REG_85655_BMSK  0xffffffff
#define HWIO_REG_85655_REG_85655_SHFT  0

#define HWIO_REG_86830_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002060)
#define HWIO_REG_86830_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002060)
#define HWIO_REG_86830_RMSK  0xffffffff
#define HWIO_REG_86830_SHFT  0
#define HWIO_REG_86830_IN  in_dword_masked(\
	HWIO_REG_86830_ADDR, HWIO_REG_86830_RMSK)
#define HWIO_REG_86830_INM(m) \
	in_dword_masked(HWIO_REG_86830_ADDR, m)
#define HWIO_REG_86830_OUT(v) \
	out_dword(HWIO_REG_86830_ADDR, v)
#define HWIO_REG_86830_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_86830_ADDR, m, v, HWIO_REG_86830_IN);
#define HWIO_REG_86830_REG_86830_BMSK  0xffffffff
#define HWIO_REG_86830_REG_86830_SHFT  0

#define HWIO_REG_889944_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002064)
#define HWIO_REG_889944_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002064)
#define HWIO_REG_889944_RMSK  0xffffffff
#define HWIO_REG_889944_SHFT  0
#define HWIO_REG_889944_IN  in_dword_masked(\
	HWIO_REG_889944_ADDR, HWIO_REG_889944_RMSK)
#define HWIO_REG_889944_INM(m) \
	in_dword_masked(HWIO_REG_889944_ADDR, m)
#define HWIO_REG_889944_OUT(v) \
	out_dword(HWIO_REG_889944_ADDR, v)
#define HWIO_REG_889944_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_889944_ADDR, m, v, HWIO_REG_889944_IN);
#define HWIO_REG_889944_HOST_WR_ADDR_BMSK  0xffffffff
#define HWIO_REG_889944_HOST_WR_ADSR_SHFT  0

#define HWIO_REG_404623_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002068)
#define HWIO_REG_404623_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002068)
#define HWIO_REG_404623_RMSK  0xffffffff
#define HWIO_REG_404623_SHFT  0
#define HWIO_REG_404623_IN  in_dword_masked(\
	HWIO_REG_404623_ADDR, HWIO_REG_404623_RMSK)
#define HWIO_REG_404623_INM(m) \
	in_dword_masked(HWIO_REG_404623_ADDR, m)
#define HWIO_REG_404623_OUT(v) \
	out_dword(HWIO_REG_404623_ADDR, v)
#define HWIO_REG_404623_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_404623_ADDR, m, v, HWIO_REG_404623_IN);
#define HWIO_REG_404623_REG_404623_BMSK  0xffffffff
#define HWIO_REG_404623_REG_404623_SHFT  0

#define HWIO_REG_397087_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000206c)
#define HWIO_REG_397087_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000206c)
#define HWIO_REG_397087_RMSK  0xffffffff
#define HWIO_REG_397087_SHFT  0
#define HWIO_REG_397087_IN  in_dword_masked(\
	HWIO_REG_397087_ADDR, HWIO_REG_397087_RMSK)
#define HWIO_REG_397087_INM(m) \
	in_dword_masked(HWIO_REG_397087_ADDR, m)
#define HWIO_REG_397087_OUT(v) \
	out_dword(HWIO_REG_397087_ADDR, v)
#define HWIO_REG_397087_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_397087_ADDR, m, v, HWIO_REG_397087_IN);
#define HWIO_REG_397087_CMD_SEQ_NUM_BMSK  0xffffffff
#define HWIO_REG_397087_CMD_SEQ_NUM_SHFT  0

#define HWIO_REG_212613_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002070)
#define HWIO_REG_212613_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002070)
#define HWIO_REG_212613_RMSK  0xffffffff
#define HWIO_REG_212613_SHFT  0
#define HWIO_REG_212613_IN  in_dword_masked(\
	HWIO_REG_212613_ADDR, HWIO_REG_212613_RMSK)
#define HWIO_REG_212613_INM(m) \
	in_dword_masked(HWIO_REG_212613_ADDR, m)
#define HWIO_REG_212613_OUT(v) \
	out_dword(HWIO_REG_212613_ADDR, v)
#define HWIO_REG_212613_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_212613_ADDR, m, v, HWIO_REG_212613_IN);
#define HWIO_REG_212613_REG_212613_BMSK  0xffffffff
#define HWIO_REG_212613_REG_212613_SHFT  0

#define HWIO_REG_840123_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002074)
#define HWIO_REG_840123_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002074)
#define HWIO_REG_840123_RMSK  0xffffffff
#define HWIO_REG_840123_SHFT  0
#define HWIO_REG_840123_IN  in_dword_masked(\
	HWIO_REG_840123_ADDR, HWIO_REG_840123_RMSK)
#define HWIO_REG_840123_INM(m) \
	in_dword_masked(HWIO_REG_840123_ADDR, m)
#define HWIO_REG_840123_OUT(v) \
	out_dword(HWIO_REG_840123_ADDR, v)
#define HWIO_REG_840123_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_840123_ADDR, m, v, HWIO_REG_840123_IN);
#define HWIO_REG_840123_REG_840123_BMSK  0xffffffff
#define HWIO_REG_840123_REG_840123_SHFT  0

#define HWIO_REG_520335_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002078)
#define HWIO_REG_520335_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002078)
#define HWIO_REG_520335_RMSK  0xffffffff
#define HWIO_REG_520335_SHFT  0
#define HWIO_REG_520335_IN  in_dword_masked(\
	HWIO_REG_520335_ADDR, HWIO_REG_520335_RMSK)
#define HWIO_REG_520335_INM(m) \
	in_dword_masked(HWIO_REG_520335_ADDR, m)
#define HWIO_REG_520335_OUT(v) \
	out_dword(HWIO_REG_520335_ADDR, v)
#define HWIO_REG_520335_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_520335_ADDR, m, v, HWIO_REG_520335_IN);
#define HWIO_REG_520335_REG_196943_BMSK  0xffffffff
#define HWIO_REG_520335_REG_196943_SHFT  0

#define HWIO_REG_196943_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000207c)
#define HWIO_REG_196943_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000207c)
#define HWIO_REG_196943_RMSK  0xffffffff
#define HWIO_REG_196943_SHFT  0
#define HWIO_REG_196943_IN  in_dword_masked(\
	HWIO_REG_196943_ADDR, HWIO_REG_196943_RMSK)
#define HWIO_REG_196943_INM(m) \
	in_dword_masked(HWIO_REG_196943_ADDR, m)
#define HWIO_REG_196943_OUT(v) \
	out_dword(HWIO_REG_196943_ADDR, v)
#define HWIO_REG_196943_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_196943_ADDR, m, v, HWIO_REG_196943_IN);
#define HWIO_REG_196943_REG_196943_BMSK  0xffffffff
#define HWIO_REG_196943_REG_196943_SHFT   0

#define HWIO_REG_313350_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002080)
#define HWIO_REG_313350_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002080)
#define HWIO_REG_313350_RMSK  0x7ffff
#define HWIO_REG_313350_SHFT  0
#define HWIO_REG_313350_IN  in_dword_masked(\
	HWIO_REG_313350_ADDR, HWIO_REG_313350_RMSK)
#define HWIO_REG_313350_INM(m) \
	in_dword_masked(HWIO_REG_313350_ADDR, m)
#define HWIO_REG_313350_OUT(v) \
	out_dword(HWIO_REG_313350_ADDR, v)
#define HWIO_REG_313350_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_313350_ADDR, m, v, HWIO_REG_313350_IN);
#define HWIO_REG_313350_CH_DEC_TYPE_BMSK  0x70000
#define HWIO_REG_313350_CH_DEC_TYPE_SHFT  0x10
#define HWIO_REG_313350_CH_INST_ID_BMSK   0xffff
#define HWIO_REG_313350_CH_INST_ID_SHFT   0

#define HWIO_REG_980194_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002084)
#define HWIO_REG_980194_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002084)
#define HWIO_REG_980194_RMSK  0xffffffff
#define HWIO_REG_980194_SHFT  0
#define HWIO_REG_980194_IN  in_dword_masked(\
	HWIO_REG_980194_ADDR, HWIO_REG_980194_RMSK)
#define HWIO_REG_980194_INM(m) \
	in_dword_masked(HWIO_REG_980194_ADDR, m)
#define HWIO_REG_980194_OUT(v) \
	out_dword(HWIO_REG_980194_ADDR, v)
#define HWIO_REG_980194_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_980194_ADDR, m, v, HWIO_REG_980194_IN);
#define HWIO_REG_980194_REG_980194_BMSK  0xffffffff
#define HWIO_REG_980194_REG_980194_SHFT  0

#define HWIO_REG_936704_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002088)
#define HWIO_REG_936704_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002088)
#define HWIO_REG_936704_RMSK  0xffffffff
#define HWIO_REG_936704_SHFT  0
#define HWIO_REG_936704_IN  in_dword_masked(\
	HWIO_REG_936704_ADDR, HWIO_REG_936704_RMSK)
#define HWIO_REG_936704_INM(m) \
	in_dword_masked(HWIO_REG_936704_ADDR, m)
#define HWIO_REG_936704_OUT(v) \
	out_dword(HWIO_REG_936704_ADDR, v)
#define HWIO_REG_936704_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_936704_ADDR, m, v, HWIO_REG_936704_IN);
#define HWIO_REG_936704_REG_936704_BMSK  0xffffffff
#define HWIO_REG_936704_REG_936704_SHFT  0

#define HWIO_REG_821977_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000208c)
#define HWIO_REG_821977_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000208c)
#define HWIO_REG_821977_RMSK  0xffffffff
#define HWIO_REG_821977_SHFT  0
#define HWIO_REG_821977_IN  in_dword_masked(\
	HWIO_REG_821977_ADDR, HWIO_REG_821977_RMSK)
#define HWIO_REG_821977_INM(m) \
	in_dword_masked(HWIO_REG_821977_ADDR, m)
#define HWIO_REG_821977_OUT(v) \
	out_dword(HWIO_REG_821977_ADDR, v)
#define HWIO_REG_821977_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_821977_ADDR, m, v, HWIO_REG_821977_IN);
#define HWIO_REG_821977_REG_821977_BMSK  0xffffffff
#define HWIO_REG_821977_REG_821977_SHFT  0

#define HWIO_REG_655721_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002090)
#define HWIO_REG_655721_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002090)
#define HWIO_REG_655721_RMSK  0xffffffff
#define HWIO_REG_655721_SHFT  0
#define HWIO_REG_655721_IN  in_dword_masked(\
	HWIO_REG_655721_ADDR, HWIO_REG_655721_RMSK)
#define HWIO_REG_655721_INM(m) \
	in_dword_masked(HWIO_REG_655721_ADDR, m)
#define HWIO_REG_655721_OUT(v) \
	out_dword(HWIO_REG_655721_ADDR, v)
#define HWIO_REG_655721_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_655721_ADDR, m, v, HWIO_REG_655721_IN);
#define HWIO_REG_655721_REG_655721_BMSK  0xffffffff
#define HWIO_REG_655721_REG_655721_SHFT  0

#define HWIO_REG_548308_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002094)
#define HWIO_REG_548308_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002094)
#define HWIO_REG_548308_RMSK  0xffffffff
#define HWIO_REG_548308_SHFT  0
#define HWIO_REG_548308_IN  in_dword_masked(\
	HWIO_REG_548308_ADDR, HWIO_REG_548308_RMSK)
#define HWIO_REG_548308_INM(m) \
	in_dword_masked(HWIO_REG_548308_ADDR, m)
#define HWIO_REG_548308_OUT(v) \
	out_dword(HWIO_REG_548308_ADDR, v)
#define HWIO_REG_548308_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_548308_ADDR, m, v, HWIO_REG_548308_IN);
#define HWIO_REG_548308_REG_548308_BMSK  0xffffffff
#define HWIO_REG_548308_REG_548308_SHFT  0

#define HWIO_REG_887095_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x00002098)
#define HWIO_REG_887095_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x00002098)
#define HWIO_REG_887095_RMSK  0xffffffff
#define HWIO_REG_887095_SHFT  0
#define HWIO_REG_887095_IN  in_dword_masked(\
	HWIO_REG_887095_ADDR, HWIO_REG_887095_RMSK)
#define HWIO_REG_887095_INM(m) \
	in_dword_masked(HWIO_REG_887095_ADDR, m)
#define HWIO_REG_887095_OUT(v) \
	out_dword(HWIO_REG_887095_ADDR, v)
#define HWIO_REG_887095_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_887095_ADDR, m, v, HWIO_REG_887095_IN);
#define HWIO_REG_887095_REG_887095_BMSK  0xffffffff
#define HWIO_REG_887095_REG_887095_SHFT  0

#define HWIO_REG_576987_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000209c)
#define HWIO_REG_576987_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000209c)
#define HWIO_REG_576987_RMSK  0xffffffff
#define HWIO_REG_576987_SHFT 0
#define HWIO_REG_576987_IN  in_dword_masked(\
	HWIO_REG_576987_ADDR, HWIO_REG_576987_RMSK)
#define HWIO_REG_576987_INM(m) \
	in_dword_masked(HWIO_REG_576987_ADDR, m)
#define HWIO_REG_576987_OUT(v) \
	out_dword(HWIO_REG_576987_ADDR, v)
#define HWIO_REG_576987_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_576987_ADDR, m, v, HWIO_REG_576987_IN);
#define HWIO_REG_576987_REG_576987_BMSK  0xffffffff
#define HWIO_REG_576987_REG_576987_SHFT  0

#define HWIO_REG_70448_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x000020a0)
#define HWIO_REG_70448_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000020a0)
#define HWIO_REG_70448_RMSK  0xffffffff
#define HWIO_REG_70448_SHFT  0
#define HWIO_REG_70448_IN  in_dword_masked(\
	HWIO_REG_70448_ADDR, HWIO_REG_70448_RMSK)
#define HWIO_REG_70448_INM(m) \
	in_dword_masked(HWIO_REG_70448_ADDR, m)
#define HWIO_REG_70448_OUT(v) \
	out_dword(HWIO_REG_70448_ADDR, v)
#define HWIO_REG_70448_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_70448_ADDR, m, v, HWIO_REG_70448_IN);
#define HWIO_REG_70448_REG_70448_BMSK  0xffffffff
#define HWIO_REG_70448_REG_70448_SHFT  0

#define HWIO_REG_652528_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x000020a4)
#define HWIO_REG_652528_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000020a4)
#define HWIO_REG_652528_RMSK  0xffffffff
#define HWIO_REG_652528_SHFT  0
#define HWIO_REG_652528_IN  in_dword_masked(\
	HWIO_REG_652528_ADDR, HWIO_REG_652528_RMSK)
#define HWIO_REG_652528_INM(m) \
	in_dword_masked(HWIO_REG_652528_ADDR, m)
#define HWIO_REG_652528_OUT(v) \
	out_dword(HWIO_REG_652528_ADDR, v)
#define HWIO_REG_652528_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_652528_ADDR, m, v , HWIO_REG_652528_IN);
#define HWIO_REG_652528_REG_652528_BMSK  0xffffffff
#define HWIO_REG_652528_REG_652528_SHFT  0

#define HWIO_REG_220637_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x000020a8)
#define HWIO_REG_220637_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000020a8)
#define HWIO_REG_220637_RMSK  0xffffffff
#define HWIO_REG_220637_SHFT  0
#define HWIO_REG_220637_IN  in_dword_masked(\
	HWIO_REG_220637_ADDR, HWIO_REG_220637_RMSK)
#define HWIO_REG_220637_INM(m) \
	in_dword_masked(HWIO_REG_220637_ADDR, m)
#define HWIO_REG_220637_OUT(v) \
	out_dword(HWIO_REG_220637_ADDR, v)
#define HWIO_REG_220637_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_220637_ADDR, m, v, HWIO_REG_220637_IN);
#define HWIO_REG_220637_REG_220637_BMSK  0xffffffff
#define HWIO_REG_220637_REG_220637_SHFT  0

#define HWIO_REG_254093_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x000020ac)
#define HWIO_REG_254093_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000020ac)
#define HWIO_REG_254093_RMSK  0xffffffff
#define HWIO_REG_254093_SHFT  0
#define HWIO_REG_254093_IN  in_dword_masked(\
	HWIO_REG_254093_ADDR, HWIO_REG_254093_RMSK)
#define HWIO_REG_254093_INM(m) \
	in_dword_masked(HWIO_REG_254093_ADDR, m)
#define HWIO_REG_254093_OUT(v) \
	out_dword(HWIO_REG_254093_ADDR, v)
#define HWIO_REG_254093_OUTM(m, v)  out_dword_masked_ns\
	(HWIO_REG_254093_ADDR, m, v, HWIO_REG_254093_IN);
#define HWIO_REG_254093_REG_254093_BMSK  0xffffffff
#define HWIO_REG_254093_REG_254093_SHFT  0

#define HWIO_REG_160474_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x000020b0)
#define HWIO_REG_160474_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000020b0)
#define HWIO_REG_160474_RMSK  0xffffffff
#define HWIO_REG_160474_SHFT  0
#define HWIO_REG_160474_IN  in_dword_masked(\
	HWIO_REG_160474_ADDR, HWIO_REG_160474_RMSK)
#define HWIO_REG_160474_INM(m) \
	in_dword_masked(HWIO_REG_160474_ADDR, m)
#define HWIO_REG_160474_OUT(v) \
	out_dword(HWIO_REG_160474_ADDR, v)
#define HWIO_REG_160474_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_160474_ADDR, m, v, HWIO_REG_160474_IN);
#define HWIO_REG_160474_REG_160474_BMSK  0xffffffff
#define HWIO_REG_160474_REG_160474_SHFT  0

#define HWIO_REG_39027_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x000020b4)
#define HWIO_REG_39027_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000020b4)
#define HWIO_REG_39027_RMSK  0xffffffff
#define HWIO_REG_39027_SHFT  0
#define HWIO_REG_39027_IN  in_dword_masked(\
	HWIO_REG_39027_ADDR, HWIO_REG_39027_RMSK)
#define HWIO_REG_39027_INM(m) \
	in_dword_masked(HWIO_REG_39027_ADDR, m)
#define HWIO_REG_39027_OUT(v) \
	out_dword(HWIO_REG_39027_ADDR, v)
#define HWIO_REG_39027_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_39027_ADDR, m, v, HWIO_REG_39027_IN);
#define HWIO_REG_39027_REG_39027_BMSK  0xffffffff
#define HWIO_REG_39027_REG_39027_SHFT  0

#define HWIO_REG_74049_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x000020b8)
#define HWIO_REG_74049_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000020b8)
#define HWIO_REG_74049_RMSK  0xffffffff
#define HWIO_REG_74049_SHFT  0
#define HWIO_REG_74049_IN  in_dword_masked(\
	HWIO_REG_74049_ADDR, HWIO_REG_74049_RMSK)
#define HWIO_REG_74049_INM(m) \
	in_dword_masked(HWIO_REG_74049_ADDR, m)
#define HWIO_REG_74049_OUT(v) \
	out_dword(HWIO_REG_74049_ADDR, v)
#define HWIO_REG_74049_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_74049_ADDR, m, v, HWIO_REG_74049_IN);
#define HWIO_REG_74049_REG_74049_BMSK  0xffffffff
#define HWIO_REG_74049_REG_74049_SHFT  0

#define HWIO_REG_697870_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x000020bc)
#define HWIO_REG_697870_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x000020bc)
#define HWIO_REG_697870_RMSK  0xffffffff
#define HWIO_REG_697870_SHFT  0
#define HWIO_REG_697870_IN  in_dword_masked(\
	HWIO_REG_697870_ADDR, HWIO_REG_697870_RMSK)
#define HWIO_REG_697870_INM(m) \
	in_dword_masked(HWIO_REG_697870_ADDR, m)
#define HWIO_REG_697870_OUT(v) \
	out_dword(HWIO_REG_697870_ADDR, v)
#define HWIO_REG_697870_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_697870_ADDR, m, v, HWIO_REG_697870_IN);
#define HWIO_REG_697870_REG_697870_BMSK  0xffffffff
#define HWIO_REG_697870_REG_697870_SHFT  0

#define HWIO_REG_783891_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000c504)
#define HWIO_REG_783891_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000c504)
#define HWIO_REG_783891_RMSK  0x7ffff
#define HWIO_REG_783891_SHFT  0
#define HWIO_REG_783891_IN  in_dword_masked(\
	HWIO_REG_783891_ADDR, HWIO_REG_783891_RMSK)
#define HWIO_REG_783891_INM(m) \
	in_dword_masked(HWIO_REG_783891_ADDR, m)
#define HWIO_REG_783891_OUT(v) \
	out_dword(HWIO_REG_783891_ADDR, v)
#define HWIO_REG_783891_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_783891_ADDR, m, v, HWIO_REG_783891_IN);
#define HWIO_REG_783891_ENC_PIC_TYPE_USE_BMSK  0x40000
#define HWIO_REG_783891_ENC_PIC_TYPE_USE_SHFT  0x12
#define HWIO_REG_783891_B_FRM_CTRL_BMSK        0x30000
#define HWIO_REG_783891_B_FRM_CTRL_SHFT        0x10
#define HWIO_REG_783891_I_FRM_CTRL_BMSK        0xffff
#define HWIO_REG_783891_I_FRM_CTRL_SHFT        0

#define HWIO_REG_226332_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000c50c)
#define HWIO_REG_226332_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000c50c)
#define HWIO_REG_226332_RMSK  0x7
#define HWIO_REG_226332_SHFT  0
#define HWIO_REG_226332_IN  in_dword_masked(\
	HWIO_REG_226332_ADDR, HWIO_REG_226332_RMSK)
#define HWIO_REG_226332_INM(m)  in_dword_masked(HWIO_REG_226332_ADDR, m)
#define HWIO_REG_226332_OUT(v)  out_dword(HWIO_REG_226332_ADDR, v)
#define HWIO_REG_226332_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_226332_ADDR, m, v, HWIO_REG_226332_IN);
#define HWIO_REG_226332_MSLICE_MODE_BMSK  0x6
#define HWIO_REG_226332_MSLICE_MODE_SHFT  0x1
#define HWIO_REG_226332_MSLICE_ENA_BMSK   0x1
#define HWIO_REG_226332_MSLICE_ENA_SHFT   0

#define HWIO_REG_696136_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000c510)
#define HWIO_REG_696136_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000c510)
#define HWIO_REG_696136_RMSK  0xffff
#define HWIO_REG_696136_SHFT  0
#define HWIO_REG_696136_IN  in_dword_masked(\
	HWIO_REG_696136_ADDR, HWIO_REG_696136_RMSK)
#define HWIO_REG_696136_INM(m)  in_dword_masked(HWIO_REG_696136_ADDR, m)
#define HWIO_REG_696136_OUT(v)  out_dword(HWIO_REG_696136_ADDR, v)
#define HWIO_REG_696136_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_696136_ADDR, m, v, HWIO_REG_696136_IN);
#define HWIO_REG_696136_MSLICE_MB_BMSK  0xffff
#define HWIO_REG_696136_MSLICE_MB_SHFT  0

#define HWIO_REG_515564_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000c514)
#define HWIO_REG_515564_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000c514)
#define HWIO_REG_515564_RMSK  0xffffffff
#define HWIO_REG_515564_SHFT  0
#define HWIO_REG_515564_IN  in_dword_masked(\
	HWIO_REG_515564_ADDR, HWIO_REG_515564_RMSK)
#define HWIO_REG_515564_INM(m) \
	in_dword_masked(HWIO_REG_515564_ADDR, m)
#define HWIO_REG_515564_OUT(v)  out_dword(HWIO_REG_515564_ADDR, v)
#define HWIO_REG_515564_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_515564_ADDR, m, v, HWIO_REG_515564_IN);
#define HWIO_REG_515564_MSLICE_BIT_BMSK  0xffffffff
#define HWIO_REG_515564_MSLICE_BIT_SHFT  0

#define HWIO_REG_886210_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000c518)
#define HWIO_REG_886210_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000c518)
#define HWIO_REG_886210_RMSK  0xffff
#define HWIO_REG_886210_SHFT  0
#define HWIO_REG_886210_IN  in_dword_masked(\
	HWIO_REG_886210_ADDR, HWIO_REG_886210_RMSK)
#define HWIO_REG_886210_INM(m)  in_dword_masked(HWIO_REG_886210_ADDR, m)
#define HWIO_REG_886210_OUT(v)  out_dword(HWIO_REG_886210_ADDR, v)
#define HWIO_REG_886210_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_886210_ADDR, m, v, HWIO_REG_886210_IN);
#define HWIO_REG_886210_CIR_NUM_BMSK  0xffff
#define HWIO_REG_886210_CIR_NUM_SHFT  0

#define HWIO_REG_645603_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000c51c)
#define HWIO_REG_645603_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000c51c)
#define HWIO_REG_645603_RMSK  0x3
#define HWIO_REG_645603_SHFT  0
#define HWIO_REG_645603_IN  in_dword_masked(\
	HWIO_REG_645603_ADDR, HWIO_REG_645603_RMSK)
#define HWIO_REG_645603_INM(m) \
	in_dword_masked(HWIO_REG_645603_ADDR, m)
#define HWIO_REG_645603_OUT(v)  out_dword(HWIO_REG_645603_ADDR, v)
#define HWIO_REG_645603_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_645603_ADDR, m, v, HWIO_REG_645603_IN);
#define HWIO_REG_645603_REG_645603_BMSK  0x3
#define HWIO_REG_645603_REG_645603_SHFT  0

#define HWIO_REG_811733_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000c520)
#define HWIO_REG_811733_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000c520)
#define HWIO_REG_811733_RMSK  0x80ffffff
#define HWIO_REG_811733_SHFT  0
#define HWIO_REG_811733_IN  in_dword_masked(\
	HWIO_REG_811733_ADDR, HWIO_REG_811733_RMSK)
#define HWIO_REG_811733_INM(m) \
	in_dword_masked(HWIO_REG_811733_ADDR, m)
#define HWIO_REG_811733_OUT(v)  out_dword(HWIO_REG_811733_ADDR, v)
#define HWIO_REG_811733_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_811733_ADDR, m, v, HWIO_REG_811733_IN);
#define HWIO_REG_811733_PAD_CTRL_ON_BMSK    0x80000000
#define HWIO_REG_811733_PAD_CTRL_ON_SHFT    0x1f
#define HWIO_REG_811733_CR_PAD_VIDC_BMSK    0xff0000
#define HWIO_REG_811733_CR_PAD_VIDC_SHFT    0x10
#define HWIO_REG_811733_CB_PAD_VIDC_BMSK    0xff00
#define HWIO_REG_811733_CB_PAD_VIDC_SHFT    0x8
#define HWIO_REG_811733_LUMA_PAD_VIDC_BMSK  0xff
#define HWIO_REG_811733_LUMA_PAD_VIDC_SHFT  0

#define HWIO_REG_676866_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000c588)
#define HWIO_REG_676866_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000c588)
#define HWIO_REG_676866_RMSK  0xffff
#define HWIO_REG_676866_SHFT  0
#define HWIO_REG_676866_IN  in_dword_masked(\
	HWIO_REG_676866_ADDR, HWIO_REG_676866_RMSK)
#define HWIO_REG_676866_INM(m) \
	in_dword_masked(HWIO_REG_676866_ADDR, m)
#define HWIO_REG_676866_OUT(v) \
	out_dword(HWIO_REG_676866_ADDR, v)
#define HWIO_REG_676866_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_676866_ADDR, m, v, HWIO_REG_676866_IN);
#define HWIO_REG_676866_REG_676866_BMSK  0xffff
#define HWIO_REG_676866_REG_676866_SHFT  0

#define HWIO_REG_54267_ADDR \
	(VIDC_BLACKBIRD_REG_BASE + 0x0000c58c)
#define HWIO_REG_54267_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000c58c)
#define HWIO_REG_54267_RMSK  0xffff
#define HWIO_REG_54267_SHFT  0
#define HWIO_REG_54267_IN  in_dword_masked(\
	HWIO_REG_54267_ADDR,\
	HWIO_REG_54267_RMSK)
#define HWIO_REG_54267_INM(m) \
	in_dword_masked(HWIO_REG_54267_ADDR, m)
#define HWIO_REG_54267_OUT(v) \
	out_dword(HWIO_REG_54267_ADDR, v)
#define HWIO_REG_54267_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_54267_ADDR, m, v,\
	HWIO_REG_54267_IN);
#define HWIO_REG_54267_REG_54267_BMSK  0xffff
#define HWIO_REG_54267_REG_54267_SHFT  0

#define HWIO_REG_559908_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000c5a0)
#define HWIO_REG_559908_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000c5a0)
#define HWIO_REG_559908_RMSK  0x33f
#define HWIO_REG_559908_SHFT  0
#define HWIO_REG_559908_IN  in_dword_masked(\
	HWIO_REG_559908_ADDR, HWIO_REG_559908_RMSK)
#define HWIO_REG_559908_INM(m)  in_dword_masked(HWIO_REG_559908_ADDR, m)
#define HWIO_REG_559908_OUT(v)  out_dword(HWIO_REG_559908_ADDR, v)
#define HWIO_REG_559908_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_559908_ADDR, m, v, HWIO_REG_559908_IN);
#define HWIO_REG_559908_FR_RC_EN_BMSK  0x200
#define HWIO_REG_559908_FR_RC_EN_SHFT  0x9
#define HWIO_REG_559908_MB_RC_EN_BMSK  0x100
#define HWIO_REG_559908_MB_RC_EN_SHFT  0x8
#define HWIO_REG_559908_FRAME_QP_BMSK  0x3f
#define HWIO_REG_559908_FRAME_QP_SHFT  0

#define HWIO_REG_977937_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000d0d0)
#define HWIO_REG_977937_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000d0d0)
#define HWIO_REG_977937_RMSK  0xff
#define HWIO_REG_977937_SHFT  0
#define HWIO_REG_977937_IN  in_dword_masked(\
	HWIO_REG_977937_ADDR, HWIO_REG_977937_RMSK)
#define HWIO_REG_977937_INM(m)  in_dword_masked(HWIO_REG_977937_ADDR, m)
#define HWIO_REG_977937_OUT(v)  out_dword(HWIO_REG_977937_ADDR, v)
#define HWIO_REG_977937_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_977937_ADDR, m, v, HWIO_REG_977937_IN);
#define HWIO_REG_977937_FRAME_RATE_BMSK  0xff
#define HWIO_REG_977937_FRAME_RATE_SHFT  0

#define HWIO_REG_166135_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000c5a8)
#define HWIO_REG_166135_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000c5a8)
#define HWIO_REG_166135_RMSK  0xffffffff
#define HWIO_REG_166135_SHFT  0
#define HWIO_REG_166135_IN  in_dword_masked(\
	HWIO_REG_166135_ADDR, HWIO_REG_166135_RMSK)
#define HWIO_REG_166135_INM(m)  in_dword_masked(HWIO_REG_166135_ADDR, m)
#define HWIO_REG_166135_OUT(v)  out_dword(HWIO_REG_166135_ADDR, v)
#define HWIO_REG_166135_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_166135_ADDR, m, v, HWIO_REG_166135_IN);
#define HWIO_REG_166135_BIT_RATE_BMSK  0xffffffff
#define HWIO_REG_166135_BIT_RATE_SHFT  0

#define HWIO_REG_109072_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000c5ac)
#define HWIO_REG_109072_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000c5ac)
#define HWIO_REG_109072_RMSK  0x3fff
#define HWIO_REG_109072_SHFT  0
#define HWIO_REG_109072_IN  in_dword_masked(\
	HWIO_REG_109072_ADDR, HWIO_REG_109072_RMSK)
#define HWIO_REG_109072_INM(m)  in_dword_masked(HWIO_REG_109072_ADDR, m)
#define HWIO_REG_109072_OUT(v)  out_dword(HWIO_REG_109072_ADDR, v)
#define HWIO_REG_109072_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_109072_ADDR, m, v, HWIO_REG_109072_IN);
#define HWIO_REG_109072_MAX_QP_BMSK  0x3f00
#define HWIO_REG_109072_MAX_QP_SHFT  0x8
#define HWIO_REG_109072_MIN_QP_BMSK  0x3f
#define HWIO_REG_109072_MIN_QP_SHFT  0

#define HWIO_REG_550322_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000c5b0)
#define HWIO_REG_550322_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000c5b0)
#define HWIO_REG_550322_RMSK  0xffff
#define HWIO_REG_550322_SHFT  0
#define HWIO_REG_550322_IN  in_dword_masked(\
	HWIO_REG_550322_ADDR, HWIO_REG_550322_RMSK)
#define HWIO_REG_550322_INM(m)  in_dword_masked(HWIO_REG_550322_ADDR, m)
#define HWIO_REG_550322_OUT(v)  out_dword(HWIO_REG_550322_ADDR, v)
#define HWIO_REG_550322_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_550322_ADDR, m, v, HWIO_REG_550322_IN);
#define HWIO_REG_550322_REACT_PARA_BMSK  0xffff
#define HWIO_REG_550322_REACT_PARA_SHFT  0

#define HWIO_REG_949086_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000c5b4)
#define HWIO_REG_949086_PHYS (VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000c5b4)
#define HWIO_REG_949086_RMSK  0xf
#define HWIO_REG_949086_SHFT  0
#define HWIO_REG_949086_IN  in_dword_masked(\
	HWIO_REG_949086_ADDR, HWIO_REG_949086_RMSK)
#define HWIO_REG_949086_INM(m)  in_dword_masked(HWIO_REG_949086_ADDR, m)
#define HWIO_REG_949086_OUT(v)  out_dword(HWIO_REG_949086_ADDR, v)
#define HWIO_REG_949086_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_949086_ADDR, m, v, HWIO_REG_949086_IN);
#define HWIO_REG_949086_DARK_DISABLE_BMSK    0x8
#define HWIO_REG_949086_DARK_DISABLE_SHFT    0x3
#define HWIO_REG_949086_SMOOTH_DISABLE_BMSK  0x4
#define HWIO_REG_949086_SMOOTH_DISABLE_SHFT  0x2
#define HWIO_REG_949086_STATIC_DISABLE_BMSK  0x2
#define HWIO_REG_949086_STATIC_DISABLE_SHFT  0x1
#define HWIO_REG_949086_ACT_DISABLE_BMSK     0x1
#define HWIO_REG_949086_ACT_DISABLE_SHFT     0

#define HWIO_REG_447796_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000d004)
#define HWIO_REG_447796_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000d004)
#define HWIO_REG_447796_RMSK  0x1
#define HWIO_REG_447796_SHFT  0
#define HWIO_REG_447796_IN  in_dword_masked(\
	HWIO_REG_447796_ADDR, HWIO_REG_447796_RMSK)
#define HWIO_REG_447796_INM(m) \
	in_dword_masked(HWIO_REG_447796_ADDR, m)
#define HWIO_REG_447796_OUT(v) \
	out_dword(HWIO_REG_447796_ADDR, v)
#define HWIO_REG_447796_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_447796_ADDR, m, v, HWIO_REG_447796_IN);
#define HWIO_REG_447796_REG_447796_BMSK  0x1
#define HWIO_REG_447796_REG_447796_SHFT  0

#define HWIO_REG_744348_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000d010)
#define HWIO_REG_744348_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000d010)
#define HWIO_REG_744348_RMSK  0x7f
#define HWIO_REG_744348_SHFT  0
#define HWIO_REG_744348_IN  in_dword_masked(\
	HWIO_REG_744348_ADDR, HWIO_REG_744348_RMSK)
#define HWIO_REG_744348_INM(m) \
	in_dword_masked(HWIO_REG_744348_ADDR, m)
#define HWIO_REG_744348_OUT(v)  \
	out_dword(HWIO_REG_744348_ADDR, v)
#define HWIO_REG_744348_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_744348_ADDR, m, v, HWIO_REG_744348_IN);
#define HWIO_REG_744348_P_BMSK  0x60
#define HWIO_REG_744348_P_SHFT  0x5
#define HWIO_REG_744348_BMSK  0x1f
#define HWIO_REG_744348_SHFT  0

#define HWIO_REG_672163_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000d034)
#define HWIO_REG_672163_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000d034)
#define HWIO_REG_672163_RMSK  0x1
#define HWIO_REG_672163_SHFT  0
#define HWIO_REG_672163_IN  in_dword_masked(\
	HWIO_REG_672163_ADDR, HWIO_REG_672163_RMSK)
#define HWIO_REG_672163_INM(m) \
	in_dword_masked(HWIO_REG_672163_ADDR, m)
#define HWIO_REG_672163_OUT(v) \
	out_dword(HWIO_REG_672163_ADDR, v)
#define HWIO_REG_672163_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_672163_ADDR, m, v,\
	HWIO_REG_672163_IN);
#define HWIO_REG_672163_ENC_TRANS_8X8_FLAG_BMSK  0x1
#define HWIO_REG_672163_ENC_TRANS_8X8_FLAG_SHFT  0

#define HWIO_REG_780908_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000d140)
#define HWIO_REG_780908_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000d140)
#define HWIO_REG_780908_RMSK  0x1
#define HWIO_REG_780908_SHFT  0
#define HWIO_REG_780908_IN  in_dword_masked(\
	HWIO_REG_780908_ADDR, HWIO_REG_780908_RMSK)
#define HWIO_REG_780908_INM(m)  in_dword_masked(\
	HWIO_REG_780908_ADDR, m)
#define HWIO_REG_780908_OUT(v)  out_dword(\
	HWIO_REG_780908_ADDR, v)
#define HWIO_REG_780908_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_780908_ADDR, m, v,\
	HWIO_REG_780908_IN)
#define HWIO_REG_780908_REG_780908_BMSK  0x1
#define HWIO_REG_780908_REG_780908_SHFT  0

#define HWIO_REG_330132_ADDR (VIDC_BLACKBIRD_REG_BASE + 0x0000e008)
#define HWIO_REG_330132_PHYS \
	(VIDC_BLACKBIRD_REG_BASE_PHYS + 0x0000e008)
#define HWIO_REG_330132_RMSK  0x1
#define HWIO_REG_330132_SHFT  0
#define HWIO_REG_330132_IN  in_dword_masked(\
	HWIO_REG_330132_ADDR, HWIO_REG_330132_RMSK)
#define HWIO_REG_330132_INM(m) \
	in_dword_masked(HWIO_REG_330132_ADDR, m)
#define HWIO_REG_330132_OUT(v) \
	out_dword(HWIO_REG_330132_ADDR, v)
#define HWIO_REG_330132_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_330132_ADDR, m, v, HWIO_REG_330132_IN);
#define HWIO_REG_330132_MPEG4_QUART_PXL_BMSK  0x1
#define HWIO_REG_330132_MPEG4_QUART_PXL_SHFT  0


#define VIDC_MGEN2MAXI_REG_BASE (VIDC_BASE + 0x00080000)
#define VIDC_MGEN2MAXI_REG_BASE_PHYS 0x04480000

#define HWIO_REG_916352_ADDR (VIDC_MGEN2MAXI_REG_BASE + 00000000)
#define HWIO_REG_916352_PHYS (VIDC_MGEN2MAXI_REG_BASE_PHYS + 00000000)
#define HWIO_REG_916352_RMSK  0xff
#define HWIO_REG_916352_SHFT  0
#define HWIO_REG_916352_IN  in_dword_masked(\
	HWIO_REG_916352_ADDR, HWIO_REG_916352_RMSK)
#define HWIO_REG_916352_INM(m) \
	in_dword_masked(HWIO_REG_916352_ADDR, m)
#define HWIO_REG_916352_VERSION_BMSK  0xff
#define HWIO_REG_916352_VERSION_SHFT  0

#define HWIO_REG_5519_ADDR (VIDC_MGEN2MAXI_REG_BASE + 0x00000004)
#define HWIO_REG_5519_PHYS \
	(VIDC_MGEN2MAXI_REG_BASE_PHYS + 0x00000004)
#define HWIO_REG_5519_RMSK  0x1
#define HWIO_REG_5519_SHFT  0
#define HWIO_REG_5519_IN  in_dword_masked(\
	HWIO_REG_5519_ADDR, HWIO_REG_5519_RMSK)
#define HWIO_REG_5519_INM(m) \
	in_dword_masked(HWIO_REG_5519_ADDR, m)
#define HWIO_REG_5519_OUT(v) \
	out_dword(HWIO_REG_5519_ADDR, v)
#define HWIO_REG_5519_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_5519_ADDR, m, v, HWIO_REG_5519_IN);
#define HWIO_REG_5519_AXI_AOOORD_BMSK  0x1
#define HWIO_REG_5519_AXI_AOOORD_SHFT  0

#define HWIO_REG_606364_ADDR (VIDC_MGEN2MAXI_REG_BASE + 0x00000008)
#define HWIO_REG_606364_PHYS \
	(VIDC_MGEN2MAXI_REG_BASE_PHYS + 0x00000008)
#define HWIO_REG_606364_RMSK  0x1
#define HWIO_REG_606364_SHFT  0
#define HWIO_REG_606364_IN  in_dword_masked(\
	HWIO_REG_606364_ADDR, HWIO_REG_606364_RMSK)
#define HWIO_REG_606364_INM(m) \
	in_dword_masked(HWIO_REG_606364_ADDR, m)
#define HWIO_REG_606364_OUT(v) \
	out_dword(HWIO_REG_606364_ADDR, v)
#define HWIO_REG_606364_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_606364_ADDR, m, v, HWIO_REG_606364_IN);
#define HWIO_REG_606364_AXI_AOOOWR_BMSK  0x1
#define HWIO_REG_606364_AXI_AOOOWR_SHFT  0

#define HWIO_REG_821472_ADDR (VIDC_MGEN2MAXI_REG_BASE + 0x0000000c)
#define HWIO_REG_821472_PHYS \
	(VIDC_MGEN2MAXI_REG_BASE_PHYS + 0x0000000c)
#define HWIO_REG_821472_RMSK  0xf
#define HWIO_REG_821472_SHFT  0
#define HWIO_REG_821472_IN  in_dword_masked(\
	HWIO_REG_821472_ADDR, HWIO_REG_821472_RMSK)
#define HWIO_REG_821472_INM(m) \
	in_dword_masked(HWIO_REG_821472_ADDR, m)
#define HWIO_REG_821472_OUT(v) \
	out_dword(HWIO_REG_821472_ADDR, v)
#define HWIO_REG_821472_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_821472_ADDR, m, v, HWIO_REG_821472_IN);
#define HWIO_REG_821472_AXI_TYPE_BMSK  0xf
#define HWIO_REG_821472_AXI_TYPE_SHFT  0

#define HWIO_REG_988424_ADDR \
	(VIDC_MGEN2MAXI_REG_BASE  + 0x00000010)
#define HWIO_REG_988424_PHYS \
	(VIDC_MGEN2MAXI_REG_BASE_PHYS + 0x00000010)
#define HWIO_REG_988424_RMSK  0x3
#define HWIO_REG_988424_SHFT  0
#define HWIO_REG_988424_IN  in_dword_masked(\
	HWIO_REG_988424_ADDR,\
	HWIO_REG_988424_RMSK)
#define HWIO_REG_988424_INM(m) \
	in_dword_masked(HWIO_REG_988424_ADDR, m)
#define HWIO_REG_988424_OUT(v) \
	out_dword(HWIO_REG_988424_ADDR, v)
#define HWIO_REG_988424_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_988424_ADDR, m, v,\
	HWIO_REG_988424_IN);
#define HWIO_REG_988424_AXI_AREQPRIORITY_BMSK  0x3
#define HWIO_REG_988424_AXI_AREQPRIORITY_SHFT  0

#define HWIO_REG_471159_ADDR (VIDC_MGEN2MAXI_REG_BASE + 0x00000014)
#define HWIO_REG_471159_PHYS (VIDC_MGEN2MAXI_REG_BASE_PHYS + 0x00000014)
#define HWIO_REG_471159_RMSK  0x801f1111
#define HWIO_REG_471159_SHFT  0
#define HWIO_REG_471159_IN  in_dword_masked(\
	HWIO_REG_471159_ADDR, HWIO_REG_471159_RMSK)
#define HWIO_REG_471159_INM(m) \
	in_dword_masked(HWIO_REG_471159_ADDR, m)
#define HWIO_REG_471159_OUT(v) \
	out_dword(HWIO_REG_471159_ADDR, v)
#define HWIO_REG_471159_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_471159_ADDR, m, v, HWIO_REG_471159_IN);
#define HWIO_REG_471159_AXI_INTR_CLR_BMSK           0x80000000
#define HWIO_REG_471159_AXI_INTR_CLR_SHFT           0x1f
#define HWIO_REG_471159_AXI_WDTIMEOUT_LOG2_BMSK     0x1e0000
#define HWIO_REG_471159_AXI_WDTIMEOUT_LOG2_SHFT     0x11
#define HWIO_REG_471159_AXI_HALT_ON_WDTIMEOUT_BMSK  0x10000
#define HWIO_REG_471159_AXI_HALT_ON_WDTIMEOUT_SHFT  0x10
#define HWIO_REG_471159_AXI_HALT_ON_WR_ERR_BMSK     0x1000
#define HWIO_REG_471159_AXI_HALT_ON_WR_ERR_SHFT     0xc
#define HWIO_REG_471159_AXI_HALT_ON_RD_ERR_BMSK     0x100
#define HWIO_REG_471159_AXI_HALT_ON_RD_ERR_SHFT     0x8
#define HWIO_REG_471159_AXI_RESET_BMSK              0x10
#define HWIO_REG_471159_AXI_RESET_SHFT              0x4
#define HWIO_REG_471159_AXI_HALT_REQ_BMSK           0x1
#define HWIO_REG_471159_AXI_HALT_REQ_SHFT            0

#define HWIO_REG_437878_ADDR (VIDC_MGEN2MAXI_REG_BASE + 0x00000018)
#define HWIO_REG_437878_PHYS \
	(VIDC_MGEN2MAXI_REG_BASE_PHYS + 0x00000018)
#define HWIO_REG_437878_RMSK  0x3333
#define HWIO_REG_437878_SHFT  0
#define HWIO_REG_437878_IN  in_dword_masked(\
	HWIO_REG_437878_ADDR, HWIO_REG_437878_RMSK)
#define HWIO_REG_437878_INM(m) \
	in_dword_masked(HWIO_REG_437878_ADDR, m)
#define HWIO_REG_437878_AXI_WDTIMEOUT_INTR_BMSK  0x3000
#define HWIO_REG_437878_AXI_WDTIMEOUT_INTR_SHFT  0xc
#define HWIO_REG_437878_AXI_ERR_INTR_BMSK        0x300
#define HWIO_REG_437878_AXI_ERR_INTR_SHFT        0x8
#define HWIO_REG_437878_AXI_IDLE_BMSK            0x30
#define HWIO_REG_437878_AXI_IDLE_SHFT            0x4
#define HWIO_REG_437878_AXI_HALT_ACK_BMSK        0x3
#define HWIO_REG_437878_AXI_HALT_ACK_SHFT        0

#define HWIO_REG_736158_ADDR \
	(VIDC_MGEN2MAXI_REG_BASE + 0x0000001c)
#define HWIO_REG_736158_PHYS \
	(VIDC_MGEN2MAXI_REG_BASE_PHYS + 0x0000001c)
#define HWIO_REG_736158_RMSK  0x10fff
#define HWIO_REG_736158_SHFT  0
#define HWIO_REG_736158_IN  in_dword_masked(\
	HWIO_REG_736158_ADDR,\
	HWIO_REG_736158_RMSK)
#define HWIO_REG_736158_INM(m) \
	in_dword_masked(HWIO_REG_736158_ADDR, m)
#define HWIO_REG_736158_AXI_WDTIMEOUT_BMSK  0x10000
#define HWIO_REG_736158_AXI_WDTIMEOUT_SHFT  0x10
#define HWIO_REG_736158_AXI_ERR_BMSK        0x800
#define HWIO_REG_736158_AXI_ERR_SHFT        0xb
#define HWIO_REG_736158_AXI_ERR_TYPE_BMSK   0x400
#define HWIO_REG_736158_AXI_ERR_TYPE_SHFT   0xa
#define HWIO_REG_736158_AXI_RESP_BMSK       0x300
#define HWIO_REG_736158_AXI_RESP_SHFT       0x8
#define HWIO_REG_736158_AXI_MID_BMSK        0xf0
#define HWIO_REG_736158_AXI_MID_SHFT        0x4
#define HWIO_REG_736158_AXI_TID_BMSK        0xf
#define HWIO_REG_736158_AXI_TID_SHFT        0

#define HWIO_REG_598415_ADDR \
	(VIDC_MGEN2MAXI_REG_BASE + 0x00000020)
#define HWIO_REG_598415_PHYS \
	(VIDC_MGEN2MAXI_REG_BASE_PHYS + 0x00000020)
#define HWIO_REG_598415_RMSK  0x10fff
#define HWIO_REG_598415_SHFT  0
#define HWIO_REG_598415_IN  in_dword_masked(\
	HWIO_REG_598415_ADDR,\
	HWIO_REG_598415_RMSK)
#define HWIO_REG_598415_INM(m) \
	in_dword_masked(HWIO_REG_598415_ADDR, m)
#define HWIO_REG_598415_AXI_WDTIMEOUT_BMSK  0x10000
#define HWIO_REG_598415_AXI_WDTIMEOUT_SHFT  0x10
#define HWIO_REG_598415_AXI_ERR_BMSK        0x800
#define HWIO_REG_598415_AXI_ERR_SHFT        0xb
#define HWIO_REG_598415_AXI_ERR_TYPE_BMSK   0x400
#define HWIO_REG_598415_AXI_ERR_TYPE_SHFT   0xa
#define HWIO_REG_598415_AXI_RESP_BMSK       0x300
#define HWIO_REG_598415_AXI_RESP_SHFT       0x8
#define HWIO_REG_598415_AXI_MID_BMSK        0xf0
#define HWIO_REG_598415_AXI_MID_SHFT        0x4
#define HWIO_REG_598415_AXI_TID_BMSK        0xf
#define HWIO_REG_598415_AXI_TID_SHFT        0

#define HWIO_REG_439061_ADDR (VIDC_MGEN2MAXI_REG_BASE + 0x00000024)
#define HWIO_REG_439061_PHYS \
	(VIDC_MGEN2MAXI_REG_BASE_PHYS + 0x00000024)
#define HWIO_REG_439061_RMSK  0x11111ff
#define HWIO_REG_439061_SHFT  0
#define HWIO_REG_439061_IN  in_dword_masked(\
	HWIO_REG_439061_ADDR, HWIO_REG_439061_RMSK)
#define HWIO_REG_439061_INM(m) \
	in_dword_masked(HWIO_REG_439061_ADDR, m)
#define HWIO_REG_439061_OUT(v) \
	out_dword(HWIO_REG_439061_ADDR, v)
#define HWIO_REG_439061_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_439061_ADDR, m, v, HWIO_REG_439061_IN);
#define HWIO_REG_439061_AXI_RD_LAT_REP_EN_BMSK  0x1000000
#define HWIO_REG_439061_AXI_RD_LAT_REP_EN_SHFT  0x18
#define HWIO_REG_439061_AXI_LSFR_EN_BMSK        0x100000
#define HWIO_REG_439061_AXI_LSFR_EN_SHFT        0x14
#define HWIO_REG_439061_AXI_MISR_RES_BMSK       0x10000
#define HWIO_REG_439061_AXI_MISR_RES_SHFT       0x10
#define HWIO_REG_439061_AXI_MISR_EN_BMSK        0x1000
#define HWIO_REG_439061_AXI_MISR_EN_SHFT        0xc
#define HWIO_REG_439061_AXI_MISR_WD_BMSK        0x100
#define HWIO_REG_439061_AXI_MISR_WD_SHFT        0x8
#define HWIO_REG_439061_AXI_CTR_EN_BMSK         0x80
#define HWIO_REG_439061_AXI_CTR_EN_SHFT         0x7
#define HWIO_REG_439061_AXI_CTR_RES_BMSK        0x40
#define HWIO_REG_439061_AXI_CTR_RES_SHFT        0x6
#define HWIO_REG_439061_AXI_TEST_ARB_SEL_BMSK   0x30
#define HWIO_REG_439061_AXI_TEST_ARB_SEL_SHFT   0x4
#define HWIO_REG_439061_AXI_TEST_OUT_SEL_BMSK   0xf
#define HWIO_REG_439061_AXI_TEST_OUT_SEL_SHFT   0

#define HWIO_REG_573121_ADDR \
	(VIDC_MGEN2MAXI_REG_BASE + 0x00000028)
#define HWIO_REG_573121_PHYS \
	(VIDC_MGEN2MAXI_REG_BASE_PHYS + 0x00000028)
#define HWIO_REG_573121_RMSK  0xffffffff
#define HWIO_REG_573121_SHFT  0
#define HWIO_REG_573121_IN  in_dword_masked(\
	HWIO_REG_573121_ADDR,\
	HWIO_REG_573121_RMSK)
#define HWIO_REG_573121_INM(m) \
	in_dword_masked(HWIO_REG_573121_ADDR, m)
#define HWIO_REG_573121_AXI_TEST_OUT_BMSK  0xffffffff
#define HWIO_REG_573121_AXI_TEST_OUT_SHFT  0

#define HWIO_REG_806413_ADDR \
	(VIDC_MGEN2MAXI_REG_BASE + 0x0000002c)
#define HWIO_REG_806413_PHYS \
	(VIDC_MGEN2MAXI_REG_BASE_PHYS + 0x0000002c)
#define HWIO_REG_806413_RMSK  0xffffffff
#define HWIO_REG_806413_SHFT  0
#define HWIO_REG_806413_IN  in_dword_masked(\
	HWIO_REG_806413_ADDR,\
	HWIO_REG_806413_RMSK)
#define HWIO_REG_806413_INM(m) \
	in_dword_masked(HWIO_REG_806413_ADDR, m)
#define HWIO_REG_806413_AXI_TEST_OUT_BMSK 0xffffffff
#define HWIO_REG_806413_AXI_TEST_OUT_SHFT 0

#define HWIO_REG_804110_ADDR (VIDC_MGEN2MAXI_REG_BASE + 0x00000030)
#define HWIO_REG_804110_PHYS (VIDC_MGEN2MAXI_REG_BASE_PHYS + 0x00000030)
#define HWIO_REG_804110_RMSK  0xc00fffff
#define HWIO_REG_804110_SHFT  0
#define HWIO_REG_804110_IN  in_dword_masked(\
	HWIO_REG_804110_ADDR, HWIO_REG_804110_RMSK)
#define HWIO_REG_804110_INM(m) \
	in_dword_masked(HWIO_REG_804110_ADDR, m)
#define HWIO_REG_804110_OUT(v)  out_dword(HWIO_REG_804110_ADDR, v)
#define HWIO_REG_804110_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_804110_ADDR, m, v, HWIO_REG_804110_IN);
#define HWIO_REG_804110_ENABLE_BMSK                 0x80000000
#define HWIO_REG_804110_ENABLE_SHFT                 0x1f
#define HWIO_REG_804110_CONST_VIDC_BMSK             0x40000000
#define HWIO_REG_804110_CONST_VIDC_SHFT             0x1e
#define HWIO_REG_804110_VIDCV_1080P_VERSION_BMSK    0xff000
#define HWIO_REG_804110_VIDCV_1080P_VERSION_SHFT    0xc
#define HWIO_REG_804110_MGEN2MAXI_DATA_SEL_BMSK     0xf00
#define HWIO_REG_804110_MGEN2MAXI_DATA_SEL_SHFT     0x8
#define HWIO_REG_804110_MGEN2MAXI_XIN_SEL_BMSK      0x80
#define HWIO_REG_804110_MGEN2MAXI_XIN_SEL_SHFT      0x7
#define HWIO_REG_804110_MGEN2MAXI_ARB_SEL_BMSK      0x40
#define HWIO_REG_804110_MGEN2MAXI_ARB_SEL_SHFT      0x6
#define HWIO_REG_804110_MGEN2MAXI_TESTBUS_SEL_BMSK  0x30
#define HWIO_REG_804110_MGEN2MAXI_TESTBUS_SEL_SHFT  0x4
#define HWIO_REG_804110_AHB2AHB_TESTBUS_SEL_BMSK    0x8
#define HWIO_REG_804110_AHB2AHB_TESTBUS_SEL_SHFT    0x3
#define HWIO_REG_804110_MGEN2MAXI_AXI_SEL_BMSK      0x4
#define HWIO_REG_804110_MGEN2MAXI_AXI_SEL_SHFT      0x2
#define HWIO_REG_804110_SELECT_BMSK                 0x3
#define HWIO_REG_804110_SELECT_SHFT                 0

#define HWIO_REG_616440_ADDR \
	(VIDC_MGEN2MAXI_REG_BASE + 0x00000034)
#define HWIO_REG_616440_PHYS \
	(VIDC_MGEN2MAXI_REG_BASE_PHYS + 0x00000034)
#define HWIO_REG_616440_RMSK  0xffff
#define HWIO_REG_616440_SHFT  0
#define HWIO_REG_616440_IN  in_dword_masked(\
	HWIO_REG_616440_ADDR,\
	HWIO_REG_616440_RMSK)
#define HWIO_REG_616440_INM(m) \
	in_dword_masked(HWIO_REG_616440_ADDR, m)
#define HWIO_REG_616440_OUT(v) \
	out_dword(HWIO_REG_616440_ADDR, v)
#define HWIO_REG_616440_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_616440_ADDR, m, v,\
	HWIO_REG_616440_IN);
#define HWIO_REG_616440_XBAR_IN_RD_LIM_BMSK  0xff00
#define HWIO_REG_616440_XBAR_IN_RD_LIM_SHFT  0x8
#define HWIO_REG_616440_XBAR_IN_WR_LIM_BMSK  0xff
#define HWIO_REG_616440_XBAR_IN_WR_LIM_SHFT  0

#define HWIO_REG_527219_ADDR \
	(VIDC_MGEN2MAXI_REG_BASE + 0x00000038)
#define HWIO_REG_527219_PHYS \
	(VIDC_MGEN2MAXI_REG_BASE_PHYS + 0x00000038)
#define HWIO_REG_527219_RMSK  0xffff
#define HWIO_REG_527219_SHFT  0
#define HWIO_REG_527219_IN  in_dword_masked(\
	HWIO_REG_527219_ADDR,\
	HWIO_REG_527219_RMSK)
#define HWIO_REG_527219_INM(m) \
	in_dword_masked(HWIO_REG_527219_ADDR, m)
#define HWIO_REG_527219_OUT(v) \
	out_dword(HWIO_REG_527219_ADDR, v)
#define HWIO_REG_527219_OUTM(m, v) \out_dword_masked_ns(\
	HWIO_REG_527219_ADDR, m, v,\
	HWIO_REG_527219_IN);
#define HWIO_REG_527219_XBAR_OUT_RD_LIM_BMSK  0xff00
#define HWIO_REG_527219_XBAR_OUT_RD_LIM_SHFT  0x8
#define HWIO_REG_527219_XBAR_OUT_WR_LIM_BMSK  0xff
#define HWIO_REG_527219_XBAR_OUT_WR_LIM_SHFT  0

#define HWIO_REG_922106_ADDR \
	(VIDC_MGEN2MAXI_REG_BASE + 0x0000003c)
#define HWIO_REG_922106_PHYS \
	(VIDC_MGEN2MAXI_REG_BASE_PHYS + 0x0000003c)
#define HWIO_REG_922106_RMSK  0xffff
#define HWIO_REG_922106_SHFT  0
#define HWIO_REG_922106_IN  in_dword_masked(\
	HWIO_REG_922106_ADDR,\
	HWIO_REG_922106_RMSK)
#define HWIO_REG_922106_INM(m) \
	in_dword_masked(HWIO_REG_922106_ADDR, m)
#define HWIO_REG_922106_OUT(v) \
	out_dword(HWIO_REG_922106_ADDR, v)
#define HWIO_REG_922106_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_922106_ADDR, m, v,\
	HWIO_REG_922106_IN);
#define HWIO_REG_922106_XBAR_OUT_MAX_RD_BURST_BMSK  0xff00
#define HWIO_REG_922106_XBAR_OUT_MAX_RD_BURST_SHFT  0x8
#define HWIO_REG_922106_XBAR_OUT_MAX_WR_BURST_BMSK  0xff
#define HWIO_REG_922106_XBAR_OUT_MAX_WR_BURST_SHFT  0

#define VIDC_ENHANCE_REG_BASE (VIDC_BASE + 0x000c0000)
#define VIDC_ENHANCE_REG_BASE_PHYS  0x044c0000

#define HWIO_REG_261029_ADDR (VIDC_ENHANCE_REG_BASE + 00000000)
#define HWIO_REG_261029_PHYS (VIDC_ENHANCE_REG_BASE_PHYS + 00000000)
#define HWIO_REG_261029_RMSK  0x10f
#define HWIO_REG_261029_SHFT  0
#define HWIO_REG_261029_IN  in_dword_masked(\
	HWIO_REG_261029_ADDR, HWIO_REG_261029_RMSK)
#define HWIO_REG_261029_INM(m) \
	in_dword_masked(HWIO_REG_261029_ADDR, m)
#define HWIO_REG_261029_OUT(v) \
	out_dword(HWIO_REG_261029_ADDR, v)
#define HWIO_REG_261029_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_261029_ADDR, m, v, HWIO_REG_261029_IN);
#define HWIO_REG_261029_AUTO_INC_EN_BMSK  0x100
#define HWIO_REG_261029_AUTO_INC_EN_SHFT  0x8
#define HWIO_REG_261029_DMI_RAM_SEL_BMSK  0xf
#define HWIO_REG_261029_DMI_RAM_SEL_SHFT  0

#define HWIO_REG_576200_ADDR (VIDC_ENHANCE_REG_BASE + 0x00000004)
#define HWIO_REG_576200_PHYS (VIDC_ENHANCE_REG_BASE_PHYS + 0x00000004)
#define HWIO_REG_576200_RMSK  0x7ff
#define HWIO_REG_576200_SHFT  0
#define HWIO_REG_576200_IN  in_dword_masked(\
	HWIO_REG_576200_ADDR, HWIO_REG_576200_RMSK)
#define HWIO_REG_576200_INM(m) \
	in_dword_masked(HWIO_REG_576200_ADDR, m)
#define HWIO_REG_576200_OUT(v) \
	out_dword(HWIO_REG_576200_ADDR, v)
#define HWIO_REG_576200_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_576200_ADDR, m, v, HWIO_REG_576200_IN);
#define HWIO_REG_576200_DMI_ADDR_BMSK  0x7ff
#define HWIO_REG_576200_DMI_ADDR_SHFT  0

#define HWIO_REG_917583_ADDR (VIDC_ENHANCE_REG_BASE + 0x00000008)
#define HWIO_REG_917583_PHYS (VIDC_ENHANCE_REG_BASE_PHYS + 0x00000008)
#define HWIO_REG_917583_RMSK  0xffffffff
#define HWIO_REG_917583_SHFT   0
#define HWIO_REG_917583_IN  in_dword_masked(\
	HWIO_REG_917583_ADDR, HWIO_REG_917583_RMSK)
#define HWIO_REG_917583_INM(m) \
	in_dword_masked(HWIO_REG_917583_ADDR, m)
#define HWIO_REG_917583_OUT(v) \
	out_dword(HWIO_REG_917583_ADDR, v)
#define HWIO_REG_917583_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_917583_ADDR, m, v, HWIO_REG_917583_IN);
#define HWIO_REG_917583_DMI_DATA_HI_BMSK  0xffffffff
#define HWIO_REG_917583_DMI_DATA_HI_SHFT  0

#define HWIO_REG_556274_ADDR (VIDC_ENHANCE_REG_BASE + 0x0000000c)
#define HWIO_REG_556274_PHYS (VIDC_ENHANCE_REG_BASE_PHYS + 0x0000000c)
#define HWIO_REG_556274_RMSK  0xffffffff
#define HWIO_REG_556274_SHFT  0
#define HWIO_REG_556274_IN  in_dword_masked(\
	HWIO_REG_556274_ADDR, HWIO_REG_556274_RMSK)
#define HWIO_REG_556274_INM(m) \
	in_dword_masked(HWIO_REG_556274_ADDR, m)
#define HWIO_REG_556274_OUT(v) \
	out_dword(HWIO_REG_556274_ADDR, v)
#define HWIO_REG_556274_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_556274_ADDR, m, v, HWIO_REG_556274_IN);
#define HWIO_REG_556274_DMI_DATA_LO_BMSK  0xffffffff
#define HWIO_REG_556274_DMI_DATA_LO_SHFT  0

#define HWIO_REG_39703_ADDR (VIDC_ENHANCE_REG_BASE + 0x00000010)
#define HWIO_REG_39703_PHYS \
	(VIDC_ENHANCE_REG_BASE_PHYS + 0x00000010)
#define HWIO_REG_39703_RMSK  0x1f
#define HWIO_REG_39703_SHFT  0
#define HWIO_REG_39703_IN  in_dword_masked(\
	HWIO_REG_39703_ADDR, HWIO_REG_39703_RMSK)
#define HWIO_REG_39703_INM(m) \
	in_dword_masked(HWIO_REG_39703_ADDR, m)
#define HWIO_REG_39703_OUT(v) \
	out_dword(HWIO_REG_39703_ADDR, v)
#define HWIO_REG_39703_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_39703_ADDR, m, v, HWIO_REG_39703_IN);
#define HWIO_REG_39703_PIX_CACHE_TB_SEL_BMSK  0x1f
#define HWIO_REG_39703_PIX_CACHE_TB_SEL_SHFT  0

#define HWIO_REG_169013_ADDR (VIDC_ENHANCE_REG_BASE + 0x00000014)
#define HWIO_REG_169013_PHYS (VIDC_ENHANCE_REG_BASE_PHYS + 0x00000014)
#define HWIO_REG_169013_RMSK  0x3
#define HWIO_REG_169013_SHFT  0
#define HWIO_REG_169013_IN  in_dword_masked(\
	HWIO_REG_169013_ADDR, HWIO_REG_169013_RMSK)
#define HWIO_REG_169013_INM(m) \
	in_dword_masked(HWIO_REG_169013_ADDR, m)
#define HWIO_REG_169013_OUT(v) \
	out_dword(HWIO_REG_169013_ADDR, v)
#define HWIO_REG_169013_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_169013_ADDR, m, v, HWIO_REG_169013_IN);
#define HWIO_REG_169013_PIX_CACHE_SW_RESET_BMSK  0x2
#define HWIO_REG_169013_PIX_CACHE_SW_RESET_SHFT  0x1
#define HWIO_REG_169013_CRIF_RESET_BMSK          0x1
#define HWIO_REG_169013_CRIF_RESET_SHFT          0

#define HWIO_REG_22756_ADDR (VIDC_ENHANCE_REG_BASE + 0x00000018)
#define HWIO_REG_22756_PHYS \
	(VIDC_ENHANCE_REG_BASE_PHYS + 0x00000018)
#define HWIO_REG_22756_RMSK  0x133f
#define HWIO_REG_22756_SHFT  0
#define HWIO_REG_22756_IN  in_dword_masked(\
	HWIO_REG_22756_ADDR, HWIO_REG_22756_RMSK)
#define HWIO_REG_22756_INM(m) \
	in_dword_masked(HWIO_REG_22756_ADDR, m)
#define HWIO_REG_22756_OUT(v) \
	out_dword(HWIO_REG_22756_ADDR, v)
#define HWIO_REG_22756_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_22756_ADDR, m, v, HWIO_REG_22756_IN);
#define HWIO_REG_22756_CACHE_HALT_BMSK         0x1000
#define HWIO_REG_22756_CACHE_HALT_SHFT         0xc
#define HWIO_REG_22756_PAGE_SIZE_BMSK          0x300
#define HWIO_REG_22756_PAGE_SIZE_SHFT          0x8
#define HWIO_REG_22756_STATISTICS_OFF_BMSK     0x20
#define HWIO_REG_22756_STATISTICS_OFF_SHFT     0x5
#define HWIO_REG_22756_CACHE_PORT_SELECT_BMSK  0x10
#define HWIO_REG_22756_CACHE_PORT_SELECT_SHFT  0x4
#define HWIO_REG_22756_PREFETCH_EN_BMSK        0x8
#define HWIO_REG_22756_PREFETCH_EN_SHFT        0x3
#define HWIO_REG_22756_SS_TILE_FORMAT_BMSK     0x4
#define HWIO_REG_22756_SS_TILE_FORMAT_SHFT     0x2
#define HWIO_REG_22756_CACHE_EN_BMSK           0x2
#define HWIO_REG_22756_CACHE_EN_SHFT           0x1
#define HWIO_REG_22756_CACHE_TAG_CLEAR_BMSK    0x1
#define HWIO_REG_22756_CACHE_TAG_CLEAR_SHFT    0

#define HWIO_REG_951731_ADDR \
	(VIDC_ENHANCE_REG_BASE + 0x0000001c)
#define HWIO_REG_951731_PHYS \
	(VIDC_ENHANCE_REG_BASE_PHYS + 0x0000001c)
#define HWIO_REG_951731_RMSK  0x7ff07ff
#define HWIO_REG_951731_SHFT  0
#define HWIO_REG_951731_IN  in_dword_masked(\
	HWIO_REG_951731_ADDR,\
	HWIO_REG_951731_RMSK)
#define HWIO_REG_951731_INM(m) \
	in_dword_masked(HWIO_REG_951731_ADDR, m)
#define HWIO_REG_951731_OUT(v) \
	out_dword(HWIO_REG_951731_ADDR, v)
#define HWIO_REG_951731_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_951731_ADDR, m, v,\
	HWIO_REG_951731_IN);
#define HWIO_REG_951731_FRAME_HEIGHT_BMSK  0x7ff0000
#define HWIO_REG_951731_FRAME_HEIGHT_SHFT  0x10
#define HWIO_REG_951731_FRAME_WIDTH_BMSK   0x7ff
#define HWIO_REG_951731_FRAME_WIDTH_SHFT   0

#define HWIO_REG_905239_ADDR \
	(VIDC_ENHANCE_REG_BASE + 0x00000020)
#define HWIO_REG_905239_PHYS \
	(VIDC_ENHANCE_REG_BASE_PHYS + 0x00000020)
#define HWIO_REG_905239_RMSK  0x3ffff
#define HWIO_REG_905239_SHFT  0
#define HWIO_REG_905239_IN  in_dword_masked(\
	HWIO_REG_905239_ADDR,\
	HWIO_REG_905239_RMSK)
#define HWIO_REG_905239_INM(m) \
	in_dword_masked(HWIO_REG_905239_ADDR, m)
#define HWIO_REG_905239_OUT(v) \
	out_dword(HWIO_REG_905239_ADDR, v)
#define HWIO_REG_905239_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_905239_ADDR, m, v,\
	HWIO_REG_905239_IN);
#define HWIO_REG_905239_LINEAR_LUMA_BMSK  0x3ffff
#define HWIO_REG_905239_LINEAR_LUMA_SHFT  0
#define HWIO_REG_905239_TILE_LUMA_BMSK    0xff00
#define HWIO_REG_905239_TILE_LUMA_SHFT    0x8
#define HWIO_REG_905239_TILE_CHROMA_BMSK  0xff
#define HWIO_REG_905239_TILE_CHROMA_SHFT  0

#define HWIO_REG_804925_ADDR(n) \
	(VIDC_ENHANCE_REG_BASE + 0x00000024 + 4 * (n))
#define HWIO_REG_804925_PHYS(n) \
	(VIDC_ENHANCE_REG_BASE_PHYS + 0x00000024 + 4 * (n))
#define HWIO_REG_804925_RMSK  0xfffffff8
#define HWIO_REG_804925_SHFT  0
#define HWIO_REG_804925_MAXn  0x12
#define HWIO_REG_804925_INI(n) \
	in_dword(HWIO_REG_804925_ADDR(n))
#define HWIO_REG_804925_INMI(n, mask) \
	in_dword_masked(HWIO_REG_804925_ADDR(n), mask)
#define HWIO_REG_804925_OUTI(n, val) \
	out_dword(HWIO_REG_804925_ADDR(n), val)
#define HWIO_REG_804925_OUTMI(n, mask, val) \
	out_dword_masked_ns(HWIO_REG_804925_ADDR(n),\
	mask, val, HWIO_REG_804925_INI(n));
#define HWIO_REG_804925_ADDR_BMSK  0xfffffff8
#define HWIO_REG_804925_ADDR_SHFT  0x3

#define HWIO_REG_41909_ADDR(n) \
	(VIDC_ENHANCE_REG_BASE + 0x00000070 + 4 * (n))
#define HWIO_REG_41909_PHYS(n) \
	(VIDC_ENHANCE_REG_BASE_PHYS + 0x00000070 + 4 * (n))
#define HWIO_REG_41909_RMSK  0xfffffff8
#define HWIO_REG_41909_SHFT  0
#define HWIO_REG_41909_MAXn  0x12
#define HWIO_REG_41909_INI(n) \
	in_dword(HWIO_REG_41909_ADDR(n))
#define HWIO_REG_41909_INMI(n, mask) \
	in_dword_masked(HWIO_REG_41909_ADDR(n), mask)
#define HWIO_REG_41909_OUTI(n, val) \
	out_dword(HWIO_REG_41909_ADDR(n), val)
#define HWIO_REG_41909_OUTMI(n, mask, val) \
	out_dword_masked_ns(HWIO_REG_41909_ADDR(n),\
	mask, val, HWIO_REG_41909_INI(n));
#define HWIO_REG_41909_ADDR_BMSK  0xfffffff8
#define HWIO_REG_41909_ADDR_SHFT  0x3

#define HWIO_REG_919904_ADDR (VIDC_ENHANCE_REG_BASE + 0x000000bc)
#define HWIO_REG_919904_PHYS \
	(VIDC_ENHANCE_REG_BASE_PHYS + 0x000000bc)
#define HWIO_REG_919904_RMSK  0x1
#define HWIO_REG_919904_SHFT  0
#define HWIO_REG_919904_IN  in_dword_masked(\
	HWIO_REG_919904_ADDR,\
	HWIO_REG_919904_RMSK)
#define HWIO_REG_919904_INM(m) \
	in_dword_masked(HWIO_REG_919904_ADDR, m)
#define HWIO_REG_919904_IDLE_BMSK  0x1
#define HWIO_REG_919904_IDLE_SHFT  0

#define HWIO_REG_278310_ADDR \
	(VIDC_ENHANCE_REG_BASE + 0x000000c0)
#define HWIO_REG_278310_PHYS \
	(VIDC_ENHANCE_REG_BASE_PHYS + 0x000000c0)
#define HWIO_REG_278310_RMSK  0xffffffff
#define HWIO_REG_278310_SHFT  0
#define HWIO_REG_278310_IN  in_dword_masked(\
	HWIO_REG_278310_ADDR,\
	HWIO_REG_278310_RMSK)
#define HWIO_REG_278310_INM(m) \
	in_dword_masked(HWIO_REG_278310_ADDR, m)
#define HWIO_REG_278310_MISS_COUNT_BMSK  0xffffffff
#define HWIO_REG_278310_MISS_COUNT_SHFT  0

#define HWIO_REG_421222_ADDR \
	(VIDC_ENHANCE_REG_BASE + 0x000000c4)
#define HWIO_REG_421222_PHYS \
	(VIDC_ENHANCE_REG_BASE_PHYS + 0x000000c4)
#define HWIO_REG_421222_RMSK  0xffffffff
#define HWIO_REG_421222_SHFT  0
#define HWIO_REG_421222_IN  in_dword_masked(\
	HWIO_REG_421222_ADDR,\
	HWIO_REG_421222_RMSK)
#define HWIO_REG_421222_INM(m) \
	in_dword_masked(HWIO_REG_421222_ADDR, m)
#define HWIO_REG_421222_HIT_COUNT_BMSK  0xffffffff
#define HWIO_REG_421222_HIT_COUNT_SHFT  0

#define HWIO_REG_609607_ADDR \
	(VIDC_ENHANCE_REG_BASE + 0x000000c8)
#define HWIO_REG_609607_PHYS \
	(VIDC_ENHANCE_REG_BASE_PHYS + 0x000000c8)
#define HWIO_REG_609607_RMSK  0xffffffff
#define HWIO_REG_609607_SHFT  0
#define HWIO_REG_609607_IN  in_dword_masked(\
	HWIO_REG_609607_ADDR,\
	HWIO_REG_609607_RMSK)
#define HWIO_REG_609607_INM(m) \
	in_dword_masked(HWIO_REG_609607_ADDR, m)
#define HWIO_REG_609607_AXI_REQUEST_COUNT_BMSK  0xffffffff
#define HWIO_REG_609607_AXI_REQUEST_COUNT_SHFT  0

#define HWIO_REG_395232_ADDR \
	(VIDC_ENHANCE_REG_BASE + 0x000000cc)
#define HWIO_REG_395232_PHYS \
	(VIDC_ENHANCE_REG_BASE_PHYS + 0x000000cc)
#define HWIO_REG_395232_RMSK  0xffffffff
#define HWIO_REG_395232_SHFT  0
#define HWIO_REG_395232_IN  in_dword_masked(\
	HWIO_REG_395232_ADDR,\
	HWIO_REG_395232_RMSK)
#define HWIO_REG_395232_INM(m) \
	in_dword_masked(HWIO_REG_395232_ADDR, m)
#define HWIO_REG_395232_CORE_REQUEST_COUNT_BMSK \
	0xffffffff
#define HWIO_REG_395232_CORE_REQUEST_COUNT_SHFT  0

#define HWIO_REG_450146_ADDR \
	(VIDC_ENHANCE_REG_BASE + 0x000000d0)
#define HWIO_REG_450146_PHYS \
	(VIDC_ENHANCE_REG_BASE_PHYS + 0x000000d0)
#define HWIO_REG_450146_RMSK  0xffffffff
#define HWIO_REG_450146_SHFT  0
#define HWIO_REG_450146_IN  in_dword_masked(\
	HWIO_REG_450146_ADDR,\
	HWIO_REG_450146_RMSK)
#define HWIO_REG_450146_INM(m) \
	in_dword_masked(HWIO_REG_450146_ADDR, m)
#define HWIO_REG_450146_AXI_BEAT_COUNT_BMSK  0xffffffff
#define HWIO_REG_450146_AXI_BEAT_COUNT_SHFT  0

#define HWIO_REG_610651_ADDR \
	(VIDC_ENHANCE_REG_BASE + 0x000000d4)
#define HWIO_REG_610651_PHYS \
	(VIDC_ENHANCE_REG_BASE_PHYS + 0x000000d4)
#define HWIO_REG_610651_RMSK  0xffffffff
#define HWIO_REG_610651_SHFT  0
#define HWIO_REG_610651_IN  in_dword_masked(\
	HWIO_REG_610651_ADDR,\
	HWIO_REG_610651_RMSK)
#define HWIO_REG_610651_INM(m) \
	in_dword_masked(HWIO_REG_610651_ADDR, m)
#define HWIO_REG_610651_CORE_BEAT_COUNT_BMSK  0xffffffff
#define HWIO_REG_610651_CORE_BEAT_COUNT_SHFT  0

#define HWIO_REG_883784_ADDR \
	(VIDC_ENHANCE_REG_BASE + 0x000000d8)
#define HWIO_REG_883784_PHYS \
	(VIDC_ENHANCE_REG_BASE_PHYS + 0x000000d8)
#define HWIO_REG_883784_RMSK  0xffffffff
#define HWIO_REG_883784_SHFT  0
#define HWIO_REG_883784_IN  in_dword_masked(\
	HWIO_REG_883784_ADDR,\
	HWIO_REG_883784_RMSK)
#define HWIO_REG_883784_INM(m) \
	in_dword_masked(HWIO_REG_883784_ADDR, m)
#define HWIO_REG_883784_OUT(v) \
	out_dword(HWIO_REG_883784_ADDR, v)
#define HWIO_REG_883784_OUTM(m, v)  out_dword_masked_ns(\
	HWIO_REG_883784_ADDR, m, v,\
	HWIO_REG_883784_IN);
#define HWIO_REG_883784_COUNTER_BMSK    0xffffff00
#define HWIO_REG_883784_COUNTER_SHFT    0x8
#define HWIO_REG_883784_ID_BMSK         0xf0
#define HWIO_REG_883784_ID_SHFT         0x4
#define HWIO_REG_883784_IGNORE_ID_BMSK  0x8
#define HWIO_REG_883784_IGNORE_ID_SHFT  0x3
#define HWIO_REG_883784_INPUT_SEL_BMSK  0x6
#define HWIO_REG_883784_INPUT_SEL_SHFT  0x1
#define HWIO_REG_883784_MISR_EN_BMSK    0x1
#define HWIO_REG_883784_MISR_EN_SHFT    0

#define HWIO_REG_651391_ADDR(n) \
	(VIDC_ENHANCE_REG_BASE + 0x000000dc + 4 * (n))
#define HWIO_REG_651391_PHYS(n) \
	(VIDC_ENHANCE_REG_BASE_PHYS + 0x000000dc + 4 * (n))
#define HWIO_REG_651391_RMSK  0xffffffff
#define HWIO_REG_651391_SHFT  0
#define HWIO_REG_651391_MAXn  0x1
#define HWIO_REG_651391_INI(n) \
	in_dword(HWIO_REG_651391_ADDR(n))
#define HWIO_REG_651391_INMI(n, mask) \
	in_dword_masked(HWIO_REG_651391_ADDR(n), mask)
#define HWIO_REG_651391_OUTI(n, val) \
	out_dword(HWIO_REG_651391_ADDR(n), val)
#define HWIO_REG_651391_SIGNATURE_BMSK  0xffffffff
#define HWIO_REG_651391_SIGNATURE_SHFT  0

#endif

