/*
 * OMAP44xx Power Management register bits
 *
 * Copyright (C) 2009-2011 Texas Instruments, Inc.
 * Copyright (C) 2009-2010 Nokia Corporation
 *
 * Paul Walmsley (paul@pwsan.com)
 * Rajendra Nayak (rnayak@ti.com)
 * Benoit Cousson (b-cousson@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __ARCH_ARM_MACH_OMAP2_PRM_REGBITS_44XX_H
#define __ARCH_ARM_MACH_OMAP2_PRM_REGBITS_44XX_H


/*
 * Used by PRM_LDO_SRAM_CORE_SETUP, PRM_LDO_SRAM_IVA_SETUP,
 * PRM_LDO_SRAM_MPU_SETUP
 */
#define OMAP4430_ABBOFF_ACT_EXPORT_SHIFT				1
#define OMAP4430_ABBOFF_ACT_EXPORT_MASK					(1 << 1)

/*
 * Used by PRM_LDO_SRAM_CORE_SETUP, PRM_LDO_SRAM_IVA_SETUP,
 * PRM_LDO_SRAM_MPU_SETUP
 */
#define OMAP4430_ABBOFF_SLEEP_EXPORT_SHIFT				2
#define OMAP4430_ABBOFF_SLEEP_EXPORT_MASK				(1 << 2)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_ABB_IVA_DONE_EN_SHIFT					31
#define OMAP4430_ABB_IVA_DONE_EN_MASK					(1 << 31)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_ABB_IVA_DONE_ST_SHIFT					31
#define OMAP4430_ABB_IVA_DONE_ST_MASK					(1 << 31)

/* Used by PRM_IRQENABLE_MPU_2 */
#define OMAP4430_ABB_MPU_DONE_EN_SHIFT					7
#define OMAP4430_ABB_MPU_DONE_EN_MASK					(1 << 7)

/* Used by PRM_IRQSTATUS_MPU_2 */
#define OMAP4430_ABB_MPU_DONE_ST_SHIFT					7
#define OMAP4430_ABB_MPU_DONE_ST_MASK					(1 << 7)

/* Used by PRM_LDO_ABB_IVA_SETUP, PRM_LDO_ABB_MPU_SETUP */
#define OMAP4430_ACTIVE_FBB_SEL_SHIFT					2
#define OMAP4430_ACTIVE_FBB_SEL_MASK					(1 << 2)

/* Used by PRM_LDO_ABB_IVA_SETUP, PRM_LDO_ABB_MPU_SETUP */
#define OMAP4430_ACTIVE_RBB_SEL_SHIFT					1
#define OMAP4430_ACTIVE_RBB_SEL_MASK					(1 << 1)

/* Used by PM_ABE_PWRSTCTRL */
#define OMAP4430_AESSMEM_ONSTATE_SHIFT					16
#define OMAP4430_AESSMEM_ONSTATE_MASK					(0x3 << 16)

/* Used by PM_ABE_PWRSTCTRL */
#define OMAP4430_AESSMEM_RETSTATE_SHIFT					8
#define OMAP4430_AESSMEM_RETSTATE_MASK					(1 << 8)

/* Used by PM_ABE_PWRSTST */
#define OMAP4430_AESSMEM_STATEST_SHIFT					4
#define OMAP4430_AESSMEM_STATEST_MASK					(0x3 << 4)

/*
 * Used by PRM_LDO_SRAM_CORE_SETUP, PRM_LDO_SRAM_IVA_SETUP,
 * PRM_LDO_SRAM_MPU_SETUP
 */
#define OMAP4430_AIPOFF_SHIFT						8
#define OMAP4430_AIPOFF_MASK						(1 << 8)

/* Used by PRM_VOLTCTRL */
#define OMAP4430_AUTO_CTRL_VDD_CORE_L_SHIFT				0
#define OMAP4430_AUTO_CTRL_VDD_CORE_L_MASK				(0x3 << 0)

/* Used by PRM_VOLTCTRL */
#define OMAP4430_AUTO_CTRL_VDD_IVA_L_SHIFT				4
#define OMAP4430_AUTO_CTRL_VDD_IVA_L_MASK				(0x3 << 4)

/* Used by PRM_VOLTCTRL */
#define OMAP4430_AUTO_CTRL_VDD_MPU_L_SHIFT				2
#define OMAP4430_AUTO_CTRL_VDD_MPU_L_MASK				(0x3 << 2)

/* Used by PRM_VOLTCTRL */
#define OMAP4430_AUTO_CTRL_VDD_RET_MASK				(1 << 1)
#define OMAP4430_AUTO_CTRL_VDD_SLEEP_MASK			(1 << 0)

/* Used by PRM_VC_ERRST */
#define OMAP4430_BYPS_RA_ERR_SHIFT					25
#define OMAP4430_BYPS_RA_ERR_MASK					(1 << 25)

/* Used by PRM_VC_ERRST */
#define OMAP4430_BYPS_SA_ERR_SHIFT					24
#define OMAP4430_BYPS_SA_ERR_MASK					(1 << 24)

/* Used by PRM_VC_ERRST */
#define OMAP4430_BYPS_TIMEOUT_ERR_SHIFT					26
#define OMAP4430_BYPS_TIMEOUT_ERR_MASK					(1 << 26)

/* Used by PRM_RSTST */
#define OMAP4430_C2C_RST_SHIFT						10
#define OMAP4430_C2C_RST_MASK						(1 << 10)

/* Used by PM_CAM_PWRSTCTRL */
#define OMAP4430_CAM_MEM_ONSTATE_SHIFT					16
#define OMAP4430_CAM_MEM_ONSTATE_MASK					(0x3 << 16)

/* Used by PM_CAM_PWRSTST */
#define OMAP4430_CAM_MEM_STATEST_SHIFT					4
#define OMAP4430_CAM_MEM_STATEST_MASK					(0x3 << 4)

/* Used by PRM_CLKREQCTRL */
#define OMAP4430_CLKREQ_COND_SHIFT					0
#define OMAP4430_CLKREQ_COND_MASK					(0x7 << 0)

/* Used by PRM_VC_VAL_SMPS_RA_CMD */
#define OMAP4430_CMDRA_VDD_CORE_L_SHIFT					0
#define OMAP4430_CMDRA_VDD_CORE_L_MASK					(0xff << 0)

/* Used by PRM_VC_VAL_SMPS_RA_CMD */
#define OMAP4430_CMDRA_VDD_IVA_L_SHIFT					8
#define OMAP4430_CMDRA_VDD_IVA_L_MASK					(0xff << 8)

/* Used by PRM_VC_VAL_SMPS_RA_CMD */
#define OMAP4430_CMDRA_VDD_MPU_L_SHIFT					16
#define OMAP4430_CMDRA_VDD_MPU_L_MASK					(0xff << 16)

/* Used by PRM_VC_CFG_CHANNEL */
#define OMAP4430_CMD_VDD_CORE_L_SHIFT					4
#define OMAP4430_CMD_VDD_CORE_L_MASK					(1 << 4)

/* Used by PRM_VC_CFG_CHANNEL */
#define OMAP4430_CMD_VDD_IVA_L_SHIFT					12
#define OMAP4430_CMD_VDD_IVA_L_MASK					(1 << 12)

/* Used by PRM_VC_CFG_CHANNEL */
#define OMAP4430_CMD_VDD_MPU_L_SHIFT					17
#define OMAP4430_CMD_VDD_MPU_L_MASK					(1 << 17)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP4430_CORE_OCMRAM_ONSTATE_SHIFT				18
#define OMAP4430_CORE_OCMRAM_ONSTATE_MASK				(0x3 << 18)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP4430_CORE_OCMRAM_RETSTATE_SHIFT				9
#define OMAP4430_CORE_OCMRAM_RETSTATE_MASK				(1 << 9)

/* Used by PM_CORE_PWRSTST */
#define OMAP4430_CORE_OCMRAM_STATEST_SHIFT				6
#define OMAP4430_CORE_OCMRAM_STATEST_MASK				(0x3 << 6)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP4430_CORE_OTHER_BANK_ONSTATE_SHIFT				16
#define OMAP4430_CORE_OTHER_BANK_ONSTATE_MASK				(0x3 << 16)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP4430_CORE_OTHER_BANK_RETSTATE_SHIFT				8
#define OMAP4430_CORE_OTHER_BANK_RETSTATE_MASK				(1 << 8)

/* Used by PM_CORE_PWRSTST */
#define OMAP4430_CORE_OTHER_BANK_STATEST_SHIFT				4
#define OMAP4430_CORE_OTHER_BANK_STATEST_MASK				(0x3 << 4)

/* Used by REVISION_PRM */
#define OMAP4430_CUSTOM_SHIFT						6
#define OMAP4430_CUSTOM_MASK						(0x3 << 6)

/* Used by PRM_VC_VAL_BYPASS */
#define OMAP4430_DATA_SHIFT						16
#define OMAP4430_DATA_MASK						(0xff << 16)

/* Used by PRM_DEVICE_OFF_CTRL */
#define OMAP4430_DEVICE_OFF_ENABLE_SHIFT				0
#define OMAP4430_DEVICE_OFF_ENABLE_MASK					(1 << 0)

/* Used by PRM_VC_CFG_I2C_MODE */
#define OMAP4430_DFILTEREN_SHIFT					6
#define OMAP4430_DFILTEREN_MASK						(1 << 6)

/*
 * Used by PRM_LDO_SRAM_CORE_SETUP, PRM_LDO_SRAM_IVA_SETUP,
 * PRM_LDO_SRAM_MPU_SETUP, PRM_SRAM_WKUP_SETUP
 */
#define OMAP4430_DISABLE_RTA_EXPORT_SHIFT				0
#define OMAP4430_DISABLE_RTA_EXPORT_MASK				(1 << 0)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU, PRM_IRQENABLE_TESLA */
#define OMAP4430_DPLL_ABE_RECAL_EN_SHIFT				4
#define OMAP4430_DPLL_ABE_RECAL_EN_MASK					(1 << 4)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU, PRM_IRQSTATUS_TESLA */
#define OMAP4430_DPLL_ABE_RECAL_ST_SHIFT				4
#define OMAP4430_DPLL_ABE_RECAL_ST_MASK					(1 << 4)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_DPLL_CORE_RECAL_EN_SHIFT				0
#define OMAP4430_DPLL_CORE_RECAL_EN_MASK				(1 << 0)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_DPLL_CORE_RECAL_ST_SHIFT				0
#define OMAP4430_DPLL_CORE_RECAL_ST_MASK				(1 << 0)

/* Used by PRM_IRQENABLE_MPU */
#define OMAP4430_DPLL_DDRPHY_RECAL_EN_SHIFT				6
#define OMAP4430_DPLL_DDRPHY_RECAL_EN_MASK				(1 << 6)

/* Used by PRM_IRQSTATUS_MPU */
#define OMAP4430_DPLL_DDRPHY_RECAL_ST_SHIFT				6
#define OMAP4430_DPLL_DDRPHY_RECAL_ST_MASK				(1 << 6)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU, PRM_IRQENABLE_TESLA */
#define OMAP4430_DPLL_IVA_RECAL_EN_SHIFT				2
#define OMAP4430_DPLL_IVA_RECAL_EN_MASK					(1 << 2)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU, PRM_IRQSTATUS_TESLA */
#define OMAP4430_DPLL_IVA_RECAL_ST_SHIFT				2
#define OMAP4430_DPLL_IVA_RECAL_ST_MASK					(1 << 2)

/* Used by PRM_IRQENABLE_MPU */
#define OMAP4430_DPLL_MPU_RECAL_EN_SHIFT				1
#define OMAP4430_DPLL_MPU_RECAL_EN_MASK					(1 << 1)

/* Used by PRM_IRQSTATUS_MPU */
#define OMAP4430_DPLL_MPU_RECAL_ST_SHIFT				1
#define OMAP4430_DPLL_MPU_RECAL_ST_MASK					(1 << 1)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_DPLL_PER_RECAL_EN_SHIFT				3
#define OMAP4430_DPLL_PER_RECAL_EN_MASK					(1 << 3)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_DPLL_PER_RECAL_ST_SHIFT				3
#define OMAP4430_DPLL_PER_RECAL_ST_MASK					(1 << 3)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_DPLL_UNIPRO_RECAL_EN_SHIFT				7
#define OMAP4430_DPLL_UNIPRO_RECAL_EN_MASK				(1 << 7)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_DPLL_UNIPRO_RECAL_ST_SHIFT				7
#define OMAP4430_DPLL_UNIPRO_RECAL_ST_MASK				(1 << 7)

/* Used by PM_DSS_PWRSTCTRL */
#define OMAP4430_DSS_MEM_ONSTATE_SHIFT					16
#define OMAP4430_DSS_MEM_ONSTATE_MASK					(0x3 << 16)

/* Used by PM_DSS_PWRSTCTRL */
#define OMAP4430_DSS_MEM_RETSTATE_SHIFT					8
#define OMAP4430_DSS_MEM_RETSTATE_MASK					(1 << 8)

/* Used by PM_DSS_PWRSTST */
#define OMAP4430_DSS_MEM_STATEST_SHIFT					4
#define OMAP4430_DSS_MEM_STATEST_MASK					(0x3 << 4)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP4430_DUCATI_L2RAM_ONSTATE_SHIFT				20
#define OMAP4430_DUCATI_L2RAM_ONSTATE_MASK				(0x3 << 20)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP4430_DUCATI_L2RAM_RETSTATE_SHIFT				10
#define OMAP4430_DUCATI_L2RAM_RETSTATE_MASK				(1 << 10)

/* Used by PM_CORE_PWRSTST */
#define OMAP4430_DUCATI_L2RAM_STATEST_SHIFT				8
#define OMAP4430_DUCATI_L2RAM_STATEST_MASK				(0x3 << 8)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP4430_DUCATI_UNICACHE_ONSTATE_SHIFT				22
#define OMAP4430_DUCATI_UNICACHE_ONSTATE_MASK				(0x3 << 22)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP4430_DUCATI_UNICACHE_RETSTATE_SHIFT				11
#define OMAP4430_DUCATI_UNICACHE_RETSTATE_MASK				(1 << 11)

/* Used by PM_CORE_PWRSTST */
#define OMAP4430_DUCATI_UNICACHE_STATEST_SHIFT				10
#define OMAP4430_DUCATI_UNICACHE_STATEST_MASK				(0x3 << 10)

/* Used by PRM_DEVICE_OFF_CTRL */
#define OMAP4460_EMIF1_OFFWKUP_DISABLE_SHIFT				8
#define OMAP4460_EMIF1_OFFWKUP_DISABLE_MASK				(1 << 8)

/* Used by PRM_DEVICE_OFF_CTRL */
#define OMAP4460_EMIF2_OFFWKUP_DISABLE_SHIFT				9
#define OMAP4460_EMIF2_OFFWKUP_DISABLE_MASK				(1 << 9)

/* Used by RM_MPU_RSTST */
#define OMAP4430_EMULATION_RST_SHIFT					0
#define OMAP4430_EMULATION_RST_MASK					(1 << 0)

/* Used by RM_DUCATI_RSTST */
#define OMAP4430_EMULATION_RST1ST_SHIFT					3
#define OMAP4430_EMULATION_RST1ST_MASK					(1 << 3)

/* Used by RM_DUCATI_RSTST */
#define OMAP4430_EMULATION_RST2ST_SHIFT					4
#define OMAP4430_EMULATION_RST2ST_MASK					(1 << 4)

/* Used by RM_IVAHD_RSTST */
#define OMAP4430_EMULATION_SEQ1_RST1ST_SHIFT				3
#define OMAP4430_EMULATION_SEQ1_RST1ST_MASK				(1 << 3)

/* Used by RM_IVAHD_RSTST */
#define OMAP4430_EMULATION_SEQ2_RST2ST_SHIFT				4
#define OMAP4430_EMULATION_SEQ2_RST2ST_MASK				(1 << 4)

/* Used by PM_EMU_PWRSTCTRL */
#define OMAP4430_EMU_BANK_ONSTATE_SHIFT					16
#define OMAP4430_EMU_BANK_ONSTATE_MASK					(0x3 << 16)

/* Used by PM_EMU_PWRSTST */
#define OMAP4430_EMU_BANK_STATEST_SHIFT					4
#define OMAP4430_EMU_BANK_STATEST_MASK					(0x3 << 4)

/*
 * Used by PRM_LDO_SRAM_CORE_SETUP, PRM_LDO_SRAM_IVA_SETUP,
 * PRM_LDO_SRAM_MPU_SETUP
 */
#define OMAP4430_ENFUNC1_EXPORT_SHIFT					3
#define OMAP4430_ENFUNC1_EXPORT_MASK					(1 << 3)

/*
 * Used by PRM_LDO_SRAM_CORE_SETUP, PRM_LDO_SRAM_IVA_SETUP,
 * PRM_LDO_SRAM_MPU_SETUP
 */
#define OMAP4430_ENFUNC3_EXPORT_SHIFT					5
#define OMAP4430_ENFUNC3_EXPORT_MASK					(1 << 5)

/*
 * Used by PRM_LDO_SRAM_CORE_SETUP, PRM_LDO_SRAM_IVA_SETUP,
 * PRM_LDO_SRAM_MPU_SETUP
 */
#define OMAP4430_ENFUNC4_SHIFT						6
#define OMAP4430_ENFUNC4_MASK						(1 << 6)

/*
 * Used by PRM_LDO_SRAM_CORE_SETUP, PRM_LDO_SRAM_IVA_SETUP,
 * PRM_LDO_SRAM_MPU_SETUP
 */
#define OMAP4430_ENFUNC5_SHIFT						7
#define OMAP4430_ENFUNC5_MASK						(1 << 7)

/* Used by PRM_VP_CORE_CONFIG, PRM_VP_IVA_CONFIG, PRM_VP_MPU_CONFIG */
#define OMAP4430_ERRORGAIN_SHIFT					16
#define OMAP4430_ERRORGAIN_MASK						(0xff << 16)

/* Used by PRM_VP_CORE_CONFIG, PRM_VP_IVA_CONFIG, PRM_VP_MPU_CONFIG */
#define OMAP4430_ERROROFFSET_SHIFT					24
#define OMAP4430_ERROROFFSET_MASK					(0xff << 24)

/* Used by PRM_RSTST */
#define OMAP4430_EXTERNAL_WARM_RST_SHIFT				5
#define OMAP4430_EXTERNAL_WARM_RST_MASK					(1 << 5)

/* Used by PRM_VP_CORE_CONFIG, PRM_VP_IVA_CONFIG, PRM_VP_MPU_CONFIG */
#define OMAP4430_FORCEUPDATE_SHIFT					1
#define OMAP4430_FORCEUPDATE_MASK					(1 << 1)

/* Used by PRM_VP_CORE_VOLTAGE, PRM_VP_IVA_VOLTAGE, PRM_VP_MPU_VOLTAGE */
#define OMAP4430_FORCEUPDATEWAIT_SHIFT					8
#define OMAP4430_FORCEUPDATEWAIT_MASK					(0xffffff << 8)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_TESLA */
#define OMAP4430_FORCEWKUP_EN_SHIFT					10
#define OMAP4430_FORCEWKUP_EN_MASK					(1 << 10)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_TESLA */
#define OMAP4430_FORCEWKUP_ST_SHIFT					10
#define OMAP4430_FORCEWKUP_ST_MASK					(1 << 10)

/* Used by REVISION_PRM */
#define OMAP4430_FUNC_SHIFT						16
#define OMAP4430_FUNC_MASK						(0xfff << 16)

/* Used by PM_GFX_PWRSTCTRL */
#define OMAP4430_GFX_MEM_ONSTATE_SHIFT					16
#define OMAP4430_GFX_MEM_ONSTATE_MASK					(0x3 << 16)

/* Used by PM_GFX_PWRSTST */
#define OMAP4430_GFX_MEM_STATEST_SHIFT					4
#define OMAP4430_GFX_MEM_STATEST_MASK					(0x3 << 4)

/* Used by PRM_RSTST */
#define OMAP4430_GLOBAL_COLD_RST_SHIFT					0
#define OMAP4430_GLOBAL_COLD_RST_MASK					(1 << 0)

/* Used by PRM_RSTST */
#define OMAP4430_GLOBAL_WARM_SW_RST_SHIFT				1
#define OMAP4430_GLOBAL_WARM_SW_RST_MASK				(1 << 1)

/* Used by PRM_IO_PMCTRL */
#define OMAP4430_GLOBAL_WUEN_SHIFT					16
#define OMAP4430_GLOBAL_WUEN_MASK					(1 << 16)
#define OMAP4430_ISOOVR_EXTEND_SHIFT					4
#define OMAP4430_ISOOVR_EXTEND_MASK					(1 << 4)

/* Used by PRM_VC_CFG_I2C_MODE */
#define OMAP4430_HSMCODE_SHIFT						0
#define OMAP4430_HSMCODE_MASK						(0x7 << 0)

/* Used by PRM_VC_CFG_I2C_MODE */
#define OMAP4430_HSMODEEN_SHIFT						3
#define OMAP4430_HSMODEEN_MASK						(1 << 3)

/* Used by PRM_VC_CFG_I2C_CLK */
#define OMAP4430_HSSCLH_SHIFT						16
#define OMAP4430_HSSCLH_MASK						(0xff << 16)

/* Used by PRM_VC_CFG_I2C_CLK */
#define OMAP4430_HSSCLL_SHIFT						24
#define OMAP4430_HSSCLL_MASK						(0xff << 24)

/* Used by PM_IVAHD_PWRSTCTRL */
#define OMAP4430_HWA_MEM_ONSTATE_SHIFT					16
#define OMAP4430_HWA_MEM_ONSTATE_MASK					(0x3 << 16)

/* Used by PM_IVAHD_PWRSTCTRL */
#define OMAP4430_HWA_MEM_RETSTATE_SHIFT					8
#define OMAP4430_HWA_MEM_RETSTATE_MASK					(1 << 8)

/* Used by PM_IVAHD_PWRSTST */
#define OMAP4430_HWA_MEM_STATEST_SHIFT					4
#define OMAP4430_HWA_MEM_STATEST_MASK					(0x3 << 4)

/* Used by RM_MPU_RSTST */
#define OMAP4430_ICECRUSHER_MPU_RST_SHIFT				1
#define OMAP4430_ICECRUSHER_MPU_RST_MASK				(1 << 1)

/* Used by RM_DUCATI_RSTST */
#define OMAP4430_ICECRUSHER_RST1ST_SHIFT				5
#define OMAP4430_ICECRUSHER_RST1ST_MASK					(1 << 5)

/* Used by RM_DUCATI_RSTST */
#define OMAP4430_ICECRUSHER_RST2ST_SHIFT				6
#define OMAP4430_ICECRUSHER_RST2ST_MASK					(1 << 6)

/* Used by RM_IVAHD_RSTST */
#define OMAP4430_ICECRUSHER_SEQ1_RST1ST_SHIFT				5
#define OMAP4430_ICECRUSHER_SEQ1_RST1ST_MASK				(1 << 5)

/* Used by RM_IVAHD_RSTST */
#define OMAP4430_ICECRUSHER_SEQ2_RST2ST_SHIFT				6
#define OMAP4430_ICECRUSHER_SEQ2_RST2ST_MASK				(1 << 6)

/* Used by PRM_RSTST */
#define OMAP4430_ICEPICK_RST_SHIFT					9
#define OMAP4430_ICEPICK_RST_MASK					(1 << 9)

/* Used by PRM_VP_CORE_CONFIG, PRM_VP_IVA_CONFIG, PRM_VP_MPU_CONFIG */
#define OMAP4430_INITVDD_SHIFT						2
#define OMAP4430_INITVDD_MASK						(1 << 2)

/* Used by PRM_VP_CORE_CONFIG, PRM_VP_IVA_CONFIG, PRM_VP_MPU_CONFIG */
#define OMAP4430_INITVOLTAGE_SHIFT					8
#define OMAP4430_INITVOLTAGE_MASK					(0xff << 8)

/*
 * Used by PM_ABE_PWRSTST, PM_CAM_PWRSTST, PM_CEFUSE_PWRSTST, PM_CORE_PWRSTST,
 * PM_DSS_PWRSTST, PM_EMU_PWRSTST, PM_GFX_PWRSTST, PM_IVAHD_PWRSTST,
 * PM_L3INIT_PWRSTST, PM_L4PER_PWRSTST, PM_MPU_PWRSTST, PM_TESLA_PWRSTST
 */
#define OMAP4430_INTRANSITION_SHIFT					20
#define OMAP4430_INTRANSITION_MASK					(1 << 20)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_IO_EN_SHIFT						9
#define OMAP4430_IO_EN_MASK						(1 << 9)

/* Used by PRM_IO_PMCTRL */
#define OMAP4430_IO_ON_STATUS_SHIFT					5
#define OMAP4430_IO_ON_STATUS_MASK					(1 << 5)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_IO_ST_SHIFT						9
#define OMAP4430_IO_ST_MASK						(1 << 9)

/* Used by PRM_IO_PMCTRL */
#define OMAP4430_ISOCLK_OVERRIDE_SHIFT					0
#define OMAP4430_ISOCLK_OVERRIDE_MASK					(1 << 0)

/* Used by PRM_IO_PMCTRL */
#define OMAP4430_ISOCLK_STATUS_SHIFT					1
#define OMAP4430_ISOCLK_STATUS_MASK					(1 << 1)

/* Used by PRM_IO_PMCTRL */
#define OMAP4430_ISOOVR_EXTEND_SHIFT					4
#define OMAP4430_ISOOVR_EXTEND_MASK					(1 << 4)

/* Used by PRM_IO_COUNT */
#define OMAP4430_ISO_2_ON_TIME_SHIFT					0
#define OMAP4430_ISO_2_ON_TIME_MASK					(0xff << 0)

/* Used by PM_L3INIT_PWRSTCTRL */
#define OMAP4430_L3INIT_BANK1_ONSTATE_SHIFT				16
#define OMAP4430_L3INIT_BANK1_ONSTATE_MASK				(0x3 << 16)

/* Used by PM_L3INIT_PWRSTCTRL */
#define OMAP4430_L3INIT_BANK1_RETSTATE_SHIFT				8
#define OMAP4430_L3INIT_BANK1_RETSTATE_MASK				(1 << 8)

/* Used by PM_L3INIT_PWRSTST */
#define OMAP4430_L3INIT_BANK1_STATEST_SHIFT				4
#define OMAP4430_L3INIT_BANK1_STATEST_MASK				(0x3 << 4)

/*
 * Used by PM_ABE_PWRSTST, PM_CORE_PWRSTST, PM_IVAHD_PWRSTST,
 * PM_L3INIT_PWRSTST, PM_L4PER_PWRSTST, PM_MPU_PWRSTST, PM_TESLA_PWRSTST
 */
#define OMAP4430_LASTPOWERSTATEENTERED_SHIFT				24
#define OMAP4430_LASTPOWERSTATEENTERED_MASK				(0x3 << 24)

/*
 * Used by PM_ABE_PWRSTCTRL, PM_CORE_PWRSTCTRL, PM_DSS_PWRSTCTRL,
 * PM_IVAHD_PWRSTCTRL, PM_L3INIT_PWRSTCTRL, PM_L4PER_PWRSTCTRL,
 * PM_MPU_PWRSTCTRL, PM_TESLA_PWRSTCTRL
 */
#define OMAP4430_LOGICRETSTATE_SHIFT					2
#define OMAP4430_LOGICRETSTATE_MASK					(1 << 2)

/*
 * Used by PM_ABE_PWRSTST, PM_CAM_PWRSTST, PM_CEFUSE_PWRSTST, PM_CORE_PWRSTST,
 * PM_DSS_PWRSTST, PM_EMU_PWRSTST, PM_GFX_PWRSTST, PM_IVAHD_PWRSTST,
 * PM_L3INIT_PWRSTST, PM_L4PER_PWRSTST, PM_MPU_PWRSTST, PM_TESLA_PWRSTST
 */
#define OMAP4430_LOGICSTATEST_SHIFT					2
#define OMAP4430_LOGICSTATEST_MASK					(1 << 2)

/*
 * Used by RM_ABE_AESS_CONTEXT, RM_ABE_DMIC_CONTEXT, RM_ABE_MCASP_CONTEXT,
 * RM_ABE_MCBSP1_CONTEXT, RM_ABE_MCBSP2_CONTEXT, RM_ABE_MCBSP3_CONTEXT,
 * RM_ABE_PDM_CONTEXT, RM_ABE_SLIMBUS_CONTEXT, RM_ABE_TIMER5_CONTEXT,
 * RM_ABE_TIMER6_CONTEXT, RM_ABE_TIMER7_CONTEXT, RM_ABE_TIMER8_CONTEXT,
 * RM_ABE_WDT3_CONTEXT, RM_ALWON_MDMINTC_CONTEXT, RM_ALWON_SR_CORE_CONTEXT,
 * RM_ALWON_SR_IVA_CONTEXT, RM_ALWON_SR_MPU_CONTEXT, RM_CAM_FDIF_CONTEXT,
 * RM_CAM_ISS_CONTEXT, RM_CEFUSE_CEFUSE_CONTEXT, RM_D2D_SAD2D_CONTEXT,
 * RM_D2D_SAD2D_FW_CONTEXT, RM_DSS_DEISS_CONTEXT, RM_DSS_DSS_CONTEXT,
 * RM_DUCATI_DUCATI_CONTEXT, RM_EMU_DEBUGSS_CONTEXT, RM_GFX_GFX_CONTEXT,
 * RM_IVAHD_IVAHD_CONTEXT, RM_IVAHD_SL2_CONTEXT, RM_L3INIT_CCPTX_CONTEXT,
 * RM_L3INIT_EMAC_CONTEXT, RM_L3INIT_P1500_CONTEXT, RM_L3INIT_PCIESS_CONTEXT,
 * RM_L3INIT_SATA_CONTEXT, RM_L3INIT_TPPSS_CONTEXT, RM_L3INIT_UNIPRO1_CONTEXT,
 * RM_L3INIT_USBPHYOCP2SCP_CONTEXT, RM_L3INIT_XHPI_CONTEXT,
 * RM_L3INSTR_L3_3_CONTEXT, RM_L3INSTR_L3_INSTR_CONTEXT,
 * RM_L3INSTR_OCP_WP1_CONTEXT, RM_L3_1_L3_1_CONTEXT, RM_L3_2_L3_2_CONTEXT,
 * RM_L3_2_OCMC_RAM_CONTEXT, RM_L4CFG_L4_CFG_CONTEXT, RM_L4CFG_SAR_ROM_CONTEXT,
 * RM_L4PER_ADC_CONTEXT, RM_L4PER_DMTIMER10_CONTEXT,
 * RM_L4PER_DMTIMER11_CONTEXT, RM_L4PER_DMTIMER2_CONTEXT,
 * RM_L4PER_DMTIMER3_CONTEXT, RM_L4PER_DMTIMER4_CONTEXT,
 * RM_L4PER_DMTIMER9_CONTEXT, RM_L4PER_ELM_CONTEXT, RM_L4PER_HDQ1W_CONTEXT,
 * RM_L4PER_HECC1_CONTEXT, RM_L4PER_HECC2_CONTEXT, RM_L4PER_I2C2_CONTEXT,
 * RM_L4PER_I2C3_CONTEXT, RM_L4PER_I2C4_CONTEXT, RM_L4PER_I2C5_CONTEXT,
 * RM_L4PER_L4_PER_CONTEXT, RM_L4PER_MCASP2_CONTEXT, RM_L4PER_MCASP3_CONTEXT,
 * RM_L4PER_MCBSP4_CONTEXT, RM_L4PER_MCSPI1_CONTEXT, RM_L4PER_MCSPI2_CONTEXT,
 * RM_L4PER_MCSPI3_CONTEXT, RM_L4PER_MCSPI4_CONTEXT, RM_L4PER_MGATE_CONTEXT,
 * RM_L4PER_MMCSD3_CONTEXT, RM_L4PER_MMCSD4_CONTEXT, RM_L4PER_MMCSD5_CONTEXT,
 * RM_L4PER_MSPROHG_CONTEXT, RM_L4PER_SLIMBUS2_CONTEXT,
 * RM_L4SEC_PKAEIP29_CONTEXT, RM_MEMIF_DLL_CONTEXT, RM_MEMIF_DLL_H_CONTEXT,
 * RM_MEMIF_DMM_CONTEXT, RM_MEMIF_EMIF_1_CONTEXT, RM_MEMIF_EMIF_2_CONTEXT,
 * RM_MEMIF_EMIF_FW_CONTEXT, RM_MPU_MPU_CONTEXT, RM_TESLA_TESLA_CONTEXT,
 * RM_WKUP_GPIO1_CONTEXT, RM_WKUP_KEYBOARD_CONTEXT, RM_WKUP_L4WKUP_CONTEXT,
 * RM_WKUP_RTC_CONTEXT, RM_WKUP_SARRAM_CONTEXT, RM_WKUP_SYNCTIMER_CONTEXT,
 * RM_WKUP_TIMER12_CONTEXT, RM_WKUP_TIMER1_CONTEXT, RM_WKUP_USIM_CONTEXT,
 * RM_WKUP_WDT1_CONTEXT, RM_WKUP_WDT2_CONTEXT
 */
#define OMAP4430_LOSTCONTEXT_DFF_SHIFT					0
#define OMAP4430_LOSTCONTEXT_DFF_MASK					(1 << 0)

/*
 * Used by RM_D2D_MODEM_ICR_CONTEXT, RM_D2D_SAD2D_CONTEXT,
 * RM_D2D_SAD2D_FW_CONTEXT, RM_DSS_DSS_CONTEXT, RM_DUCATI_DUCATI_CONTEXT,
 * RM_L3INIT_HSI_CONTEXT, RM_L3INIT_MMC1_CONTEXT, RM_L3INIT_MMC2_CONTEXT,
 * RM_L3INIT_MMC6_CONTEXT, RM_L3INIT_USB_HOST_CONTEXT,
 * RM_L3INIT_USB_HOST_FS_CONTEXT, RM_L3INIT_USB_OTG_CONTEXT,
 * RM_L3INIT_USB_TLL_CONTEXT, RM_L3INSTR_L3_3_CONTEXT,
 * RM_L3INSTR_OCP_WP1_CONTEXT, RM_L3_1_L3_1_CONTEXT, RM_L3_2_GPMC_CONTEXT,
 * RM_L3_2_L3_2_CONTEXT, RM_L4CFG_HW_SEM_CONTEXT, RM_L4CFG_L4_CFG_CONTEXT,
 * RM_L4CFG_MAILBOX_CONTEXT, RM_L4PER_GPIO2_CONTEXT, RM_L4PER_GPIO3_CONTEXT,
 * RM_L4PER_GPIO4_CONTEXT, RM_L4PER_GPIO5_CONTEXT, RM_L4PER_GPIO6_CONTEXT,
 * RM_L4PER_I2C1_CONTEXT, RM_L4PER_L4_PER_CONTEXT, RM_L4PER_UART1_CONTEXT,
 * RM_L4PER_UART2_CONTEXT, RM_L4PER_UART3_CONTEXT, RM_L4PER_UART4_CONTEXT,
 * RM_L4SEC_AES1_CONTEXT, RM_L4SEC_AES2_CONTEXT, RM_L4SEC_CRYPTODMA_CONTEXT,
 * RM_L4SEC_DES3DES_CONTEXT, RM_L4SEC_RNG_CONTEXT, RM_L4SEC_SHA2MD51_CONTEXT,
 * RM_MEMIF_DMM_CONTEXT, RM_MEMIF_EMIF_1_CONTEXT, RM_MEMIF_EMIF_2_CONTEXT,
 * RM_MEMIF_EMIF_FW_CONTEXT, RM_MEMIF_EMIF_H1_CONTEXT,
 * RM_MEMIF_EMIF_H2_CONTEXT, RM_SDMA_SDMA_CONTEXT, RM_TESLA_TESLA_CONTEXT
 */
#define OMAP4430_LOSTCONTEXT_RFF_SHIFT					1
#define OMAP4430_LOSTCONTEXT_RFF_MASK					(1 << 1)

/* Used by RM_ABE_AESS_CONTEXT */
#define OMAP4430_LOSTMEM_AESSMEM_SHIFT					8
#define OMAP4430_LOSTMEM_AESSMEM_MASK					(1 << 8)

/* Used by RM_CAM_FDIF_CONTEXT, RM_CAM_ISS_CONTEXT */
#define OMAP4430_LOSTMEM_CAM_MEM_SHIFT					8
#define OMAP4430_LOSTMEM_CAM_MEM_MASK					(1 << 8)

/* Used by RM_L3INSTR_OCP_WP1_CONTEXT */
#define OMAP4430_LOSTMEM_CORE_NRET_BANK_SHIFT				8
#define OMAP4430_LOSTMEM_CORE_NRET_BANK_MASK				(1 << 8)

/* Renamed from LOSTMEM_CORE_NRET_BANK Used by RM_MEMIF_DMM_CONTEXT */
#define OMAP4430_LOSTMEM_CORE_NRET_BANK_9_9_SHIFT			9
#define OMAP4430_LOSTMEM_CORE_NRET_BANK_9_9_MASK			(1 << 9)

/* Used by RM_L3_2_OCMC_RAM_CONTEXT */
#define OMAP4430_LOSTMEM_CORE_OCMRAM_SHIFT				8
#define OMAP4430_LOSTMEM_CORE_OCMRAM_MASK				(1 << 8)

/*
 * Used by RM_D2D_MODEM_ICR_CONTEXT, RM_MEMIF_DMM_CONTEXT,
 * RM_SDMA_SDMA_CONTEXT
 */
#define OMAP4430_LOSTMEM_CORE_OTHER_BANK_SHIFT				8
#define OMAP4430_LOSTMEM_CORE_OTHER_BANK_MASK				(1 << 8)

/* Used by RM_DSS_DEISS_CONTEXT, RM_DSS_DSS_CONTEXT */
#define OMAP4430_LOSTMEM_DSS_MEM_SHIFT					8
#define OMAP4430_LOSTMEM_DSS_MEM_MASK					(1 << 8)

/* Used by RM_DUCATI_DUCATI_CONTEXT */
#define OMAP4430_LOSTMEM_DUCATI_L2RAM_SHIFT				9
#define OMAP4430_LOSTMEM_DUCATI_L2RAM_MASK				(1 << 9)

/* Used by RM_DUCATI_DUCATI_CONTEXT */
#define OMAP4430_LOSTMEM_DUCATI_UNICACHE_SHIFT				8
#define OMAP4430_LOSTMEM_DUCATI_UNICACHE_MASK				(1 << 8)

/* Used by RM_EMU_DEBUGSS_CONTEXT */
#define OMAP4430_LOSTMEM_EMU_BANK_SHIFT					8
#define OMAP4430_LOSTMEM_EMU_BANK_MASK					(1 << 8)

/* Used by RM_GFX_GFX_CONTEXT */
#define OMAP4430_LOSTMEM_GFX_MEM_SHIFT					8
#define OMAP4430_LOSTMEM_GFX_MEM_MASK					(1 << 8)

/* Used by RM_IVAHD_IVAHD_CONTEXT */
#define OMAP4430_LOSTMEM_HWA_MEM_SHIFT					10
#define OMAP4430_LOSTMEM_HWA_MEM_MASK					(1 << 10)

/*
 * Used by RM_L3INIT_CCPTX_CONTEXT, RM_L3INIT_EMAC_CONTEXT,
 * RM_L3INIT_HSI_CONTEXT, RM_L3INIT_MMC1_CONTEXT, RM_L3INIT_MMC2_CONTEXT,
 * RM_L3INIT_MMC6_CONTEXT, RM_L3INIT_PCIESS_CONTEXT, RM_L3INIT_SATA_CONTEXT,
 * RM_L3INIT_TPPSS_CONTEXT, RM_L3INIT_UNIPRO1_CONTEXT,
 * RM_L3INIT_USB_OTG_CONTEXT, RM_L3INIT_XHPI_CONTEXT
 */
#define OMAP4430_LOSTMEM_L3INIT_BANK1_SHIFT				8
#define OMAP4430_LOSTMEM_L3INIT_BANK1_MASK				(1 << 8)

/* Used by RM_MPU_MPU_CONTEXT */
#define OMAP4430_LOSTMEM_MPU_L1_SHIFT					8
#define OMAP4430_LOSTMEM_MPU_L1_MASK					(1 << 8)

/* Used by RM_MPU_MPU_CONTEXT */
#define OMAP4430_LOSTMEM_MPU_L2_SHIFT					9
#define OMAP4430_LOSTMEM_MPU_L2_MASK					(1 << 9)

/* Used by RM_MPU_MPU_CONTEXT */
#define OMAP4430_LOSTMEM_MPU_RAM_SHIFT					10
#define OMAP4430_LOSTMEM_MPU_RAM_MASK					(1 << 10)

/*
 * Used by RM_L4PER_HECC1_CONTEXT, RM_L4PER_HECC2_CONTEXT,
 * RM_L4PER_MCBSP4_CONTEXT, RM_L4PER_MMCSD3_CONTEXT, RM_L4PER_MMCSD4_CONTEXT,
 * RM_L4PER_MMCSD5_CONTEXT, RM_L4PER_SLIMBUS2_CONTEXT, RM_L4SEC_PKAEIP29_CONTEXT
 */
#define OMAP4430_LOSTMEM_NONRETAINED_BANK_SHIFT				8
#define OMAP4430_LOSTMEM_NONRETAINED_BANK_MASK				(1 << 8)

/*
 * Used by RM_ABE_DMIC_CONTEXT, RM_ABE_MCBSP1_CONTEXT, RM_ABE_MCBSP2_CONTEXT,
 * RM_ABE_MCBSP3_CONTEXT, RM_ABE_PDM_CONTEXT, RM_ABE_SLIMBUS_CONTEXT
 */
#define OMAP4430_LOSTMEM_PERIHPMEM_SHIFT				8
#define OMAP4430_LOSTMEM_PERIHPMEM_MASK					(1 << 8)

/*
 * Used by RM_L4PER_MSPROHG_CONTEXT, RM_L4PER_UART1_CONTEXT,
 * RM_L4PER_UART2_CONTEXT, RM_L4PER_UART3_CONTEXT, RM_L4PER_UART4_CONTEXT,
 * RM_L4SEC_CRYPTODMA_CONTEXT
 */
#define OMAP4430_LOSTMEM_RETAINED_BANK_SHIFT				8
#define OMAP4430_LOSTMEM_RETAINED_BANK_MASK				(1 << 8)

/* Used by RM_IVAHD_SL2_CONTEXT */
#define OMAP4430_LOSTMEM_SL2_MEM_SHIFT					8
#define OMAP4430_LOSTMEM_SL2_MEM_MASK					(1 << 8)

/* Used by RM_IVAHD_IVAHD_CONTEXT */
#define OMAP4430_LOSTMEM_TCM1_MEM_SHIFT					8
#define OMAP4430_LOSTMEM_TCM1_MEM_MASK					(1 << 8)

/* Used by RM_IVAHD_IVAHD_CONTEXT */
#define OMAP4430_LOSTMEM_TCM2_MEM_SHIFT					9
#define OMAP4430_LOSTMEM_TCM2_MEM_MASK					(1 << 9)

/* Used by RM_TESLA_TESLA_CONTEXT */
#define OMAP4430_LOSTMEM_TESLA_EDMA_SHIFT				10
#define OMAP4430_LOSTMEM_TESLA_EDMA_MASK				(1 << 10)

/* Used by RM_TESLA_TESLA_CONTEXT */
#define OMAP4430_LOSTMEM_TESLA_L1_SHIFT					8
#define OMAP4430_LOSTMEM_TESLA_L1_MASK					(1 << 8)

/* Used by RM_TESLA_TESLA_CONTEXT */
#define OMAP4430_LOSTMEM_TESLA_L2_SHIFT					9
#define OMAP4430_LOSTMEM_TESLA_L2_MASK					(1 << 9)

/* Used by RM_WKUP_SARRAM_CONTEXT */
#define OMAP4430_LOSTMEM_WKUP_BANK_SHIFT				8
#define OMAP4430_LOSTMEM_WKUP_BANK_MASK					(1 << 8)

/*
 * Used by PM_ABE_PWRSTCTRL, PM_CAM_PWRSTCTRL, PM_CEFUSE_PWRSTCTRL,
 * PM_CORE_PWRSTCTRL, PM_DSS_PWRSTCTRL, PM_GFX_PWRSTCTRL, PM_IVAHD_PWRSTCTRL,
 * PM_L3INIT_PWRSTCTRL, PM_L4PER_PWRSTCTRL, PM_MPU_PWRSTCTRL, PM_TESLA_PWRSTCTRL
 */
#define OMAP4430_LOWPOWERSTATECHANGE_SHIFT				4
#define OMAP4430_LOWPOWERSTATECHANGE_MASK				(1 << 4)

/* Used by PRM_MODEM_IF_CTRL */
#define OMAP4430_MODEM_READY_SHIFT					1
#define OMAP4430_MODEM_READY_MASK					(1 << 1)

/* Used by PRM_MODEM_IF_CTRL */
#define OMAP4430_MODEM_SHUTDOWN_IRQ_SHIFT				9
#define OMAP4430_MODEM_SHUTDOWN_IRQ_MASK				(1 << 9)

/* Used by PRM_MODEM_IF_CTRL */
#define OMAP4430_MODEM_SLEEP_ST_SHIFT					16
#define OMAP4430_MODEM_SLEEP_ST_MASK					(1 << 16)

/* Used by PRM_MODEM_IF_CTRL */
#define OMAP4430_MODEM_WAKE_IRQ_SHIFT					8
#define OMAP4430_MODEM_WAKE_IRQ_MASK					(1 << 8)

/* Used by PM_MPU_PWRSTCTRL */
#define OMAP4430_MPU_L1_ONSTATE_SHIFT					16
#define OMAP4430_MPU_L1_ONSTATE_MASK					(0x3 << 16)

/* Used by PM_MPU_PWRSTCTRL */
#define OMAP4430_MPU_L1_RETSTATE_SHIFT					8
#define OMAP4430_MPU_L1_RETSTATE_MASK					(1 << 8)

/* Used by PM_MPU_PWRSTST */
#define OMAP4430_MPU_L1_STATEST_SHIFT					4
#define OMAP4430_MPU_L1_STATEST_MASK					(0x3 << 4)

/* Used by PM_MPU_PWRSTCTRL */
#define OMAP4430_MPU_L2_ONSTATE_SHIFT					18
#define OMAP4430_MPU_L2_ONSTATE_MASK					(0x3 << 18)

/* Used by PM_MPU_PWRSTCTRL */
#define OMAP4430_MPU_L2_RETSTATE_SHIFT					9
#define OMAP4430_MPU_L2_RETSTATE_MASK					(1 << 9)

/* Used by PM_MPU_PWRSTST */
#define OMAP4430_MPU_L2_STATEST_SHIFT					6
#define OMAP4430_MPU_L2_STATEST_MASK					(0x3 << 6)

/* Used by PM_MPU_PWRSTCTRL */
#define OMAP4430_MPU_RAM_ONSTATE_SHIFT					20
#define OMAP4430_MPU_RAM_ONSTATE_MASK					(0x3 << 20)

/* Used by PM_MPU_PWRSTCTRL */
#define OMAP4430_MPU_RAM_RETSTATE_SHIFT					10
#define OMAP4430_MPU_RAM_RETSTATE_MASK					(1 << 10)

/* Used by PM_MPU_PWRSTST */
#define OMAP4430_MPU_RAM_STATEST_SHIFT					8
#define OMAP4430_MPU_RAM_STATEST_MASK					(0x3 << 8)

/* Used by PRM_RSTST */
#define OMAP4430_MPU_SECURITY_VIOL_RST_SHIFT				2
#define OMAP4430_MPU_SECURITY_VIOL_RST_MASK				(1 << 2)

/* Used by PRM_RSTST */
#define OMAP4430_MPU_WDT_RST_SHIFT					3
#define OMAP4430_MPU_WDT_RST_MASK					(1 << 3)

/* Used by PM_L4PER_PWRSTCTRL */
#define OMAP4430_NONRETAINED_BANK_ONSTATE_SHIFT				18
#define OMAP4430_NONRETAINED_BANK_ONSTATE_MASK				(0x3 << 18)

/* Used by PM_L4PER_PWRSTCTRL */
#define OMAP4430_NONRETAINED_BANK_RETSTATE_SHIFT			9
#define OMAP4430_NONRETAINED_BANK_RETSTATE_MASK				(1 << 9)

/* Used by PM_L4PER_PWRSTST */
#define OMAP4430_NONRETAINED_BANK_STATEST_SHIFT				6
#define OMAP4430_NONRETAINED_BANK_STATEST_MASK				(0x3 << 6)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP4430_OCP_NRET_BANK_ONSTATE_SHIFT				24
#define OMAP4430_OCP_NRET_BANK_ONSTATE_MASK				(0x3 << 24)

/* Used by PM_CORE_PWRSTCTRL */
#define OMAP4430_OCP_NRET_BANK_RETSTATE_SHIFT				12
#define OMAP4430_OCP_NRET_BANK_RETSTATE_MASK				(1 << 12)

/* Used by PM_CORE_PWRSTST */
#define OMAP4430_OCP_NRET_BANK_STATEST_SHIFT				12
#define OMAP4430_OCP_NRET_BANK_STATEST_MASK				(0x3 << 12)

/*
 * Used by PRM_VC_VAL_CMD_VDD_CORE_L, PRM_VC_VAL_CMD_VDD_IVA_L,
 * PRM_VC_VAL_CMD_VDD_MPU_L
 */
#define OMAP4430_OFF_SHIFT						0
#define OMAP4430_OFF_MASK						(0xff << 0)

/*
 * Used by PRM_VC_VAL_CMD_VDD_CORE_L, PRM_VC_VAL_CMD_VDD_IVA_L,
 * PRM_VC_VAL_CMD_VDD_MPU_L
 */
#define OMAP4430_ON_SHIFT						24
#define OMAP4430_ON_MASK						(0xff << 24)

/*
 * Used by PRM_VC_VAL_CMD_VDD_CORE_L, PRM_VC_VAL_CMD_VDD_IVA_L,
 * PRM_VC_VAL_CMD_VDD_MPU_L
 */
#define OMAP4430_ONLP_SHIFT						16
#define OMAP4430_ONLP_MASK						(0xff << 16)

/* Used by PRM_LDO_ABB_IVA_CTRL, PRM_LDO_ABB_MPU_CTRL */
#define OMAP4430_OPP_CHANGE_SHIFT					2
#define OMAP4430_OPP_CHANGE_MASK					(1 << 2)

/* Used by PRM_LDO_ABB_IVA_CTRL, PRM_LDO_ABB_MPU_CTRL */
#define OMAP4430_OPP_SEL_SHIFT						0
#define OMAP4430_OPP_SEL_MASK						(0x3 << 0)

/* Used by PRM_SRAM_COUNT */
#define OMAP4430_PCHARGECNT_VALUE_SHIFT					0
#define OMAP4430_PCHARGECNT_VALUE_MASK					(0x3f << 0)

/* Used by PRM_PSCON_COUNT */
#define OMAP4430_PCHARGE_TIME_SHIFT					0
#define OMAP4430_PCHARGE_TIME_MASK					(0xff << 0)

/* Used by PM_ABE_PWRSTCTRL */
#define OMAP4430_PERIPHMEM_ONSTATE_SHIFT				20
#define OMAP4430_PERIPHMEM_ONSTATE_MASK					(0x3 << 20)

/* Used by PM_ABE_PWRSTCTRL */
#define OMAP4430_PERIPHMEM_RETSTATE_SHIFT				10
#define OMAP4430_PERIPHMEM_RETSTATE_MASK				(1 << 10)

/* Used by PM_ABE_PWRSTST */
#define OMAP4430_PERIPHMEM_STATEST_SHIFT				8
#define OMAP4430_PERIPHMEM_STATEST_MASK					(0x3 << 8)

/* Used by PRM_PHASE1_CNDP */
#define OMAP4430_PHASE1_CNDP_SHIFT					0
#define OMAP4430_PHASE1_CNDP_MASK					(0xffffffff << 0)

/* Used by PRM_PHASE2A_CNDP */
#define OMAP4430_PHASE2A_CNDP_SHIFT					0
#define OMAP4430_PHASE2A_CNDP_MASK					(0xffffffff << 0)

/* Used by PRM_PHASE2B_CNDP */
#define OMAP4430_PHASE2B_CNDP_SHIFT					0
#define OMAP4430_PHASE2B_CNDP_MASK					(0xffffffff << 0)

/* Used by PRM_PSCON_COUNT */
#define OMAP4430_PONOUT_2_PGOODIN_TIME_SHIFT				8
#define OMAP4430_PONOUT_2_PGOODIN_TIME_MASK				(0xff << 8)

/*
 * Used by PM_ABE_PWRSTCTRL, PM_CAM_PWRSTCTRL, PM_CEFUSE_PWRSTCTRL,
 * PM_CORE_PWRSTCTRL, PM_DSS_PWRSTCTRL, PM_EMU_PWRSTCTRL, PM_GFX_PWRSTCTRL,
 * PM_IVAHD_PWRSTCTRL, PM_L3INIT_PWRSTCTRL, PM_L4PER_PWRSTCTRL,
 * PM_MPU_PWRSTCTRL, PM_TESLA_PWRSTCTRL
 */
#define OMAP4430_POWERSTATE_SHIFT					0
#define OMAP4430_POWERSTATE_MASK					(0x3 << 0)

/*
 * Used by PM_ABE_PWRSTST, PM_CAM_PWRSTST, PM_CEFUSE_PWRSTST, PM_CORE_PWRSTST,
 * PM_DSS_PWRSTST, PM_EMU_PWRSTST, PM_GFX_PWRSTST, PM_IVAHD_PWRSTST,
 * PM_L3INIT_PWRSTST, PM_L4PER_PWRSTST, PM_MPU_PWRSTST, PM_TESLA_PWRSTST
 */
#define OMAP4430_POWERSTATEST_SHIFT					0
#define OMAP4430_POWERSTATEST_MASK					(0x3 << 0)

/* Used by PRM_PWRREQCTRL */
#define OMAP4430_PWRREQ_COND_SHIFT					0
#define OMAP4430_PWRREQ_COND_MASK					(0x3 << 0)

/* Used by PRM_VC_CFG_CHANNEL */
#define OMAP4430_RACEN_VDD_CORE_L_SHIFT					3
#define OMAP4430_RACEN_VDD_CORE_L_MASK					(1 << 3)

/* Used by PRM_VC_CFG_CHANNEL */
#define OMAP4430_RACEN_VDD_IVA_L_SHIFT					11
#define OMAP4430_RACEN_VDD_IVA_L_MASK					(1 << 11)

/* Used by PRM_VC_CFG_CHANNEL */
#define OMAP4430_RACEN_VDD_MPU_L_SHIFT					20
#define OMAP4430_RACEN_VDD_MPU_L_MASK					(1 << 20)

/* Used by PRM_VC_CFG_CHANNEL */
#define OMAP4430_RAC_VDD_CORE_L_SHIFT					2
#define OMAP4430_RAC_VDD_CORE_L_MASK					(1 << 2)

/* Used by PRM_VC_CFG_CHANNEL */
#define OMAP4430_RAC_VDD_IVA_L_SHIFT					10
#define OMAP4430_RAC_VDD_IVA_L_MASK					(1 << 10)

/* Used by PRM_VC_CFG_CHANNEL */
#define OMAP4430_RAC_VDD_MPU_L_SHIFT					19
#define OMAP4430_RAC_VDD_MPU_L_MASK					(1 << 19)

/*
 * Used by PRM_VOLTSETUP_CORE_OFF, PRM_VOLTSETUP_CORE_RET_SLEEP,
 * PRM_VOLTSETUP_IVA_OFF, PRM_VOLTSETUP_IVA_RET_SLEEP, PRM_VOLTSETUP_MPU_OFF,
 * PRM_VOLTSETUP_MPU_RET_SLEEP
 */
#define OMAP4430_RAMP_DOWN_COUNT_SHIFT					16
#define OMAP4430_RAMP_DOWN_COUNT_MASK					(0x3f << 16)

/*
 * Used by PRM_VOLTSETUP_CORE_OFF, PRM_VOLTSETUP_CORE_RET_SLEEP,
 * PRM_VOLTSETUP_IVA_OFF, PRM_VOLTSETUP_IVA_RET_SLEEP, PRM_VOLTSETUP_MPU_OFF,
 * PRM_VOLTSETUP_MPU_RET_SLEEP
 */
#define OMAP4430_RAMP_DOWN_PRESCAL_SHIFT				24
#define OMAP4430_RAMP_DOWN_PRESCAL_MASK					(0x3 << 24)

/*
 * Used by PRM_VOLTSETUP_CORE_OFF, PRM_VOLTSETUP_CORE_RET_SLEEP,
 * PRM_VOLTSETUP_IVA_OFF, PRM_VOLTSETUP_IVA_RET_SLEEP, PRM_VOLTSETUP_MPU_OFF,
 * PRM_VOLTSETUP_MPU_RET_SLEEP
 */
#define OMAP4430_RAMP_UP_COUNT_SHIFT					0
#define OMAP4430_RAMP_UP_COUNT_MASK					(0x3f << 0)

/*
 * Used by PRM_VOLTSETUP_CORE_OFF, PRM_VOLTSETUP_CORE_RET_SLEEP,
 * PRM_VOLTSETUP_IVA_OFF, PRM_VOLTSETUP_IVA_RET_SLEEP, PRM_VOLTSETUP_MPU_OFF,
 * PRM_VOLTSETUP_MPU_RET_SLEEP
 */
#define OMAP4430_RAMP_UP_PRESCAL_SHIFT					8
#define OMAP4430_RAMP_UP_PRESCAL_MASK					(0x3 << 8)

/* Used by PRM_VC_CFG_CHANNEL */
#define OMAP4430_RAV_VDD_CORE_L_SHIFT					1
#define OMAP4430_RAV_VDD_CORE_L_MASK					(1 << 1)

/* Used by PRM_VC_CFG_CHANNEL */
#define OMAP4430_RAV_VDD_IVA_L_SHIFT					9
#define OMAP4430_RAV_VDD_IVA_L_MASK					(1 << 9)

/* Used by PRM_VC_CFG_CHANNEL */
#define OMAP4430_RAV_VDD_MPU_L_SHIFT					18
#define OMAP4430_RAV_VDD_MPU_L_MASK					(1 << 18)

/* Used by PRM_VC_VAL_BYPASS */
#define OMAP4430_REGADDR_SHIFT						8
#define OMAP4430_REGADDR_MASK						(0xff << 8)

/*
 * Used by PRM_VC_VAL_CMD_VDD_CORE_L, PRM_VC_VAL_CMD_VDD_IVA_L,
 * PRM_VC_VAL_CMD_VDD_MPU_L
 */
#define OMAP4430_RET_SHIFT						8
#define OMAP4430_RET_MASK						(0xff << 8)

/* Used by PM_L4PER_PWRSTCTRL */
#define OMAP4430_RETAINED_BANK_ONSTATE_SHIFT				16
#define OMAP4430_RETAINED_BANK_ONSTATE_MASK				(0x3 << 16)

/* Used by PM_L4PER_PWRSTCTRL */
#define OMAP4430_RETAINED_BANK_RETSTATE_SHIFT				8
#define OMAP4430_RETAINED_BANK_RETSTATE_MASK				(1 << 8)

/* Used by PM_L4PER_PWRSTST */
#define OMAP4430_RETAINED_BANK_STATEST_SHIFT				4
#define OMAP4430_RETAINED_BANK_STATEST_MASK				(0x3 << 4)

/*
 * Used by PRM_LDO_SRAM_CORE_CTRL, PRM_LDO_SRAM_IVA_CTRL,
 * PRM_LDO_SRAM_MPU_CTRL
 */
#define OMAP4430_RETMODE_ENABLE_SHIFT					0
#define OMAP4430_RETMODE_ENABLE_MASK					(1 << 0)

/* Used by RM_DUCATI_RSTCTRL, RM_IVAHD_RSTCTRL, RM_TESLA_RSTCTRL */
#define OMAP4430_RST1_SHIFT						0
#define OMAP4430_RST1_MASK						(1 << 0)

/* Used by RM_DUCATI_RSTST, RM_IVAHD_RSTST, RM_TESLA_RSTST */
#define OMAP4430_RST1ST_SHIFT						0
#define OMAP4430_RST1ST_MASK						(1 << 0)

/* Used by RM_DUCATI_RSTCTRL, RM_IVAHD_RSTCTRL, RM_TESLA_RSTCTRL */
#define OMAP4430_RST2_SHIFT						1
#define OMAP4430_RST2_MASK						(1 << 1)

/* Used by RM_DUCATI_RSTST, RM_IVAHD_RSTST, RM_TESLA_RSTST */
#define OMAP4430_RST2ST_SHIFT						1
#define OMAP4430_RST2ST_MASK						(1 << 1)

/* Used by RM_DUCATI_RSTCTRL, RM_IVAHD_RSTCTRL */
#define OMAP4430_RST3_SHIFT						2
#define OMAP4430_RST3_MASK						(1 << 2)

/* Used by RM_DUCATI_RSTST, RM_IVAHD_RSTST */
#define OMAP4430_RST3ST_SHIFT						2
#define OMAP4430_RST3ST_MASK						(1 << 2)

/* Used by PRM_RSTTIME */
#define OMAP4430_RSTTIME1_SHIFT						0
#define OMAP4430_RSTTIME1_MASK						(0x3ff << 0)

/* Used by PRM_RSTTIME */
#define OMAP4430_RSTTIME2_SHIFT						10
#define OMAP4430_RSTTIME2_MASK						(0x1f << 10)

/* Used by PRM_RSTCTRL */
#define OMAP4430_RST_GLOBAL_COLD_SW_SHIFT				1
#define OMAP4430_RST_GLOBAL_COLD_SW_MASK				(1 << 1)

/* Used by PRM_RSTCTRL */
#define OMAP4430_RST_GLOBAL_WARM_SW_SHIFT				0
#define OMAP4430_RST_GLOBAL_WARM_SW_MASK				(1 << 0)

/* Used by REVISION_PRM */
#define OMAP4430_R_RTL_SHIFT						11
#define OMAP4430_R_RTL_MASK						(0x1f << 11)

/* Used by PRM_VC_CFG_CHANNEL */
#define OMAP4430_SA_VDD_CORE_L_SHIFT					0
#define OMAP4430_SA_VDD_CORE_L_MASK					(1 << 0)

/* Renamed from SA_VDD_CORE_L Used by PRM_VC_SMPS_SA */
#define OMAP4430_SA_VDD_CORE_L_0_6_SHIFT				0
#define OMAP4430_SA_VDD_CORE_L_0_6_MASK					(0x7f << 0)

/* Used by PRM_VC_CFG_CHANNEL */
#define OMAP4430_SA_VDD_IVA_L_SHIFT					8
#define OMAP4430_SA_VDD_IVA_L_MASK					(1 << 8)

/* Renamed from SA_VDD_IVA_L Used by PRM_VC_SMPS_SA */
#define OMAP4430_SA_VDD_IVA_L_PRM_VC_SMPS_SA_SHIFT			8
#define OMAP4430_SA_VDD_IVA_L_PRM_VC_SMPS_SA_MASK			(0x7f << 8)

/* Used by PRM_VC_CFG_CHANNEL */
#define OMAP4430_SA_VDD_MPU_L_SHIFT					16
#define OMAP4430_SA_VDD_MPU_L_MASK					(1 << 16)

/* Renamed from SA_VDD_MPU_L Used by PRM_VC_SMPS_SA */
#define OMAP4430_SA_VDD_MPU_L_PRM_VC_SMPS_SA_SHIFT			16
#define OMAP4430_SA_VDD_MPU_L_PRM_VC_SMPS_SA_MASK			(0x7f << 16)

/* Used by REVISION_PRM */
#define OMAP4430_SCHEME_SHIFT						30
#define OMAP4430_SCHEME_MASK						(0x3 << 30)

/* Used by PRM_VC_CFG_I2C_CLK */
#define OMAP4430_SCLH_SHIFT						0
#define OMAP4430_SCLH_MASK						(0xff << 0)

/* Used by PRM_VC_CFG_I2C_CLK */
#define OMAP4430_SCLL_SHIFT						8
#define OMAP4430_SCLL_MASK						(0xff << 8)

/* Used by PRM_VC_CFG_I2C_CLK */
#define OMAP4430_HSCLH_SHIFT						16
#define OMAP4430_HSCLH_MASK						(0xff << 16)

/* Used by PRM_VC_CFG_I2C_CLK */
#define OMAP4430_HSCLL_SHIFT						24
#define OMAP4430_HSCLL_MASK						(0xff << 24)

/* Used by PRM_RSTST */
#define OMAP4430_SECURE_WDT_RST_SHIFT					4
#define OMAP4430_SECURE_WDT_RST_MASK					(1 << 4)

/* Used by PM_IVAHD_PWRSTCTRL */
#define OMAP4430_SL2_MEM_ONSTATE_SHIFT					18
#define OMAP4430_SL2_MEM_ONSTATE_MASK					(0x3 << 18)

/* Used by PM_IVAHD_PWRSTCTRL */
#define OMAP4430_SL2_MEM_RETSTATE_SHIFT					9
#define OMAP4430_SL2_MEM_RETSTATE_MASK					(1 << 9)

/* Used by PM_IVAHD_PWRSTST */
#define OMAP4430_SL2_MEM_STATEST_SHIFT					6
#define OMAP4430_SL2_MEM_STATEST_MASK					(0x3 << 6)

/* Used by PRM_VC_VAL_BYPASS */
#define OMAP4430_SLAVEADDR_SHIFT					0
#define OMAP4430_SLAVEADDR_MASK						(0x7f << 0)

/* Used by PRM_LDO_ABB_IVA_SETUP, PRM_LDO_ABB_MPU_SETUP */
#define OMAP4430_SLEEP_RBB_SEL_SHIFT					3
#define OMAP4430_SLEEP_RBB_SEL_MASK					(1 << 3)

/* Used by PRM_SRAM_COUNT */
#define OMAP4430_SLPCNT_VALUE_SHIFT					16
#define OMAP4430_SLPCNT_VALUE_MASK					(0xff << 16)

/* Used by PRM_VP_CORE_VSTEPMAX, PRM_VP_IVA_VSTEPMAX, PRM_VP_MPU_VSTEPMAX */
#define OMAP4430_SMPSWAITTIMEMAX_SHIFT					8
#define OMAP4430_SMPSWAITTIMEMAX_MASK					(0xffff << 8)

/* Used by PRM_VP_CORE_VSTEPMIN, PRM_VP_IVA_VSTEPMIN, PRM_VP_MPU_VSTEPMIN */
#define OMAP4430_SMPSWAITTIMEMIN_SHIFT					8
#define OMAP4430_SMPSWAITTIMEMIN_MASK					(0xffff << 8)

/* Used by PRM_VC_ERRST */
#define OMAP4430_SMPS_RA_ERR_CORE_SHIFT					1
#define OMAP4430_SMPS_RA_ERR_CORE_MASK					(1 << 1)

/* Used by PRM_VC_ERRST */
#define OMAP4430_SMPS_RA_ERR_IVA_SHIFT					9
#define OMAP4430_SMPS_RA_ERR_IVA_MASK					(1 << 9)

/* Used by PRM_VC_ERRST */
#define OMAP4430_SMPS_RA_ERR_MPU_SHIFT					17
#define OMAP4430_SMPS_RA_ERR_MPU_MASK					(1 << 17)

/* Used by PRM_VC_ERRST */
#define OMAP4430_SMPS_SA_ERR_CORE_SHIFT					0
#define OMAP4430_SMPS_SA_ERR_CORE_MASK					(1 << 0)

/* Used by PRM_VC_ERRST */
#define OMAP4430_SMPS_SA_ERR_IVA_SHIFT					8
#define OMAP4430_SMPS_SA_ERR_IVA_MASK					(1 << 8)

/* Used by PRM_VC_ERRST */
#define OMAP4430_SMPS_SA_ERR_MPU_SHIFT					16
#define OMAP4430_SMPS_SA_ERR_MPU_MASK					(1 << 16)

/* Used by PRM_VC_ERRST */
#define OMAP4430_SMPS_TIMEOUT_ERR_CORE_SHIFT				2
#define OMAP4430_SMPS_TIMEOUT_ERR_CORE_MASK				(1 << 2)

/* Used by PRM_VC_ERRST */
#define OMAP4430_SMPS_TIMEOUT_ERR_IVA_SHIFT				10
#define OMAP4430_SMPS_TIMEOUT_ERR_IVA_MASK				(1 << 10)

/* Used by PRM_VC_ERRST */
#define OMAP4430_SMPS_TIMEOUT_ERR_MPU_SHIFT				18
#define OMAP4430_SMPS_TIMEOUT_ERR_MPU_MASK				(1 << 18)

/* Used by PRM_LDO_ABB_IVA_SETUP, PRM_LDO_ABB_MPU_SETUP */
#define OMAP4430_SR2EN_SHIFT						0
#define OMAP4430_SR2EN_MASK						(1 << 0)

/* Used by PRM_LDO_ABB_IVA_CTRL, PRM_LDO_ABB_MPU_CTRL */
#define OMAP4430_SR2_IN_TRANSITION_SHIFT				6
#define OMAP4430_SR2_IN_TRANSITION_MASK					(1 << 6)

/* Used by PRM_LDO_ABB_IVA_CTRL, PRM_LDO_ABB_MPU_CTRL */
#define OMAP4430_SR2_STATUS_SHIFT					3
#define OMAP4430_SR2_STATUS_MASK					(0x3 << 3)

/* Used by PRM_LDO_ABB_IVA_SETUP, PRM_LDO_ABB_MPU_SETUP */
#define OMAP4430_SR2_WTCNT_VALUE_SHIFT					8
#define OMAP4430_SR2_WTCNT_VALUE_MASK					(0xff << 8)

/*
 * Used by PRM_LDO_SRAM_CORE_CTRL, PRM_LDO_SRAM_IVA_CTRL,
 * PRM_LDO_SRAM_MPU_CTRL
 */
#define OMAP4430_SRAMLDO_STATUS_SHIFT					8
#define OMAP4430_SRAMLDO_STATUS_MASK					(1 << 8)

/*
 * Used by PRM_LDO_SRAM_CORE_CTRL, PRM_LDO_SRAM_IVA_CTRL,
 * PRM_LDO_SRAM_MPU_CTRL
 */
#define OMAP4430_SRAM_IN_TRANSITION_SHIFT				9
#define OMAP4430_SRAM_IN_TRANSITION_MASK				(1 << 9)

/* Used by PRM_VC_CFG_I2C_MODE */
#define OMAP4430_SRMODEEN_SHIFT						4
#define OMAP4430_SRMODEEN_MASK						(1 << 4)

/* Used by PRM_VOLTSETUP_WARMRESET */
#define OMAP4430_STABLE_COUNT_SHIFT					0
#define OMAP4430_STABLE_COUNT_MASK					(0x3f << 0)

/* Used by PRM_VOLTSETUP_WARMRESET */
#define OMAP4430_STABLE_PRESCAL_SHIFT					8
#define OMAP4430_STABLE_PRESCAL_MASK					(0x3 << 8)

/* Used by PRM_LDO_BANDGAP_SETUP */
#define OMAP4430_STARTUP_COUNT_SHIFT					0
#define OMAP4430_STARTUP_COUNT_MASK					(0xff << 0)

/* Renamed from STARTUP_COUNT Used by PRM_SRAM_COUNT */
#define OMAP4430_STARTUP_COUNT_24_31_SHIFT				24
#define OMAP4430_STARTUP_COUNT_24_31_MASK				(0xff << 24)

/* Used by PM_IVAHD_PWRSTCTRL */
#define OMAP4430_TCM1_MEM_ONSTATE_SHIFT					20
#define OMAP4430_TCM1_MEM_ONSTATE_MASK					(0x3 << 20)

/* Used by PM_IVAHD_PWRSTCTRL */
#define OMAP4430_TCM1_MEM_RETSTATE_SHIFT				10
#define OMAP4430_TCM1_MEM_RETSTATE_MASK					(1 << 10)

/* Used by PM_IVAHD_PWRSTST */
#define OMAP4430_TCM1_MEM_STATEST_SHIFT					8
#define OMAP4430_TCM1_MEM_STATEST_MASK					(0x3 << 8)

/* Used by PM_IVAHD_PWRSTCTRL */
#define OMAP4430_TCM2_MEM_ONSTATE_SHIFT					22
#define OMAP4430_TCM2_MEM_ONSTATE_MASK					(0x3 << 22)

/* Used by PM_IVAHD_PWRSTCTRL */
#define OMAP4430_TCM2_MEM_RETSTATE_SHIFT				11
#define OMAP4430_TCM2_MEM_RETSTATE_MASK					(1 << 11)

/* Used by PM_IVAHD_PWRSTST */
#define OMAP4430_TCM2_MEM_STATEST_SHIFT					10
#define OMAP4430_TCM2_MEM_STATEST_MASK					(0x3 << 10)

/* Used by RM_TESLA_RSTST */
#define OMAP4430_TESLASS_EMU_RSTST_SHIFT				2
#define OMAP4430_TESLASS_EMU_RSTST_MASK					(1 << 2)

/* Used by RM_TESLA_RSTST */
#define OMAP4430_TESLA_DSP_EMU_REQ_RSTST_SHIFT				3
#define OMAP4430_TESLA_DSP_EMU_REQ_RSTST_MASK				(1 << 3)

/* Used by PM_TESLA_PWRSTCTRL */
#define OMAP4430_TESLA_EDMA_ONSTATE_SHIFT				20
#define OMAP4430_TESLA_EDMA_ONSTATE_MASK				(0x3 << 20)

/* Used by PM_TESLA_PWRSTCTRL */
#define OMAP4430_TESLA_EDMA_RETSTATE_SHIFT				10
#define OMAP4430_TESLA_EDMA_RETSTATE_MASK				(1 << 10)

/* Used by PM_TESLA_PWRSTST */
#define OMAP4430_TESLA_EDMA_STATEST_SHIFT				8
#define OMAP4430_TESLA_EDMA_STATEST_MASK				(0x3 << 8)

/* Used by PM_TESLA_PWRSTCTRL */
#define OMAP4430_TESLA_L1_ONSTATE_SHIFT					16
#define OMAP4430_TESLA_L1_ONSTATE_MASK					(0x3 << 16)

/* Used by PM_TESLA_PWRSTCTRL */
#define OMAP4430_TESLA_L1_RETSTATE_SHIFT				8
#define OMAP4430_TESLA_L1_RETSTATE_MASK					(1 << 8)

/* Used by PM_TESLA_PWRSTST */
#define OMAP4430_TESLA_L1_STATEST_SHIFT					4
#define OMAP4430_TESLA_L1_STATEST_MASK					(0x3 << 4)

/* Used by PM_TESLA_PWRSTCTRL */
#define OMAP4430_TESLA_L2_ONSTATE_SHIFT					18
#define OMAP4430_TESLA_L2_ONSTATE_MASK					(0x3 << 18)

/* Used by PM_TESLA_PWRSTCTRL */
#define OMAP4430_TESLA_L2_RETSTATE_SHIFT				9
#define OMAP4430_TESLA_L2_RETSTATE_MASK					(1 << 9)

/* Used by PM_TESLA_PWRSTST */
#define OMAP4430_TESLA_L2_STATEST_SHIFT					6
#define OMAP4430_TESLA_L2_STATEST_MASK					(0x3 << 6)

/* Used by PRM_VP_CORE_VLIMITTO, PRM_VP_IVA_VLIMITTO, PRM_VP_MPU_VLIMITTO */
#define OMAP4430_TIMEOUT_SHIFT						0
#define OMAP4430_TIMEOUT_MASK						(0xffff << 0)

/* Used by PRM_VP_CORE_CONFIG, PRM_VP_IVA_CONFIG, PRM_VP_MPU_CONFIG */
#define OMAP4430_TIMEOUTEN_SHIFT					3
#define OMAP4430_TIMEOUTEN_MASK						(1 << 3)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_TRANSITION_EN_SHIFT					8
#define OMAP4430_TRANSITION_EN_MASK					(1 << 8)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_TRANSITION_ST_SHIFT					8
#define OMAP4430_TRANSITION_ST_MASK					(1 << 8)

/* Used by PRM_VC_VAL_BYPASS */
#define OMAP4430_VALID_SHIFT						24
#define OMAP4430_VALID_MASK						(1 << 24)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VC_BYPASSACK_EN_SHIFT					14
#define OMAP4430_VC_BYPASSACK_EN_MASK					(1 << 14)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VC_BYPASSACK_ST_SHIFT					14
#define OMAP4430_VC_BYPASSACK_ST_MASK					(1 << 14)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VC_CORE_VPACK_EN_SHIFT					22
#define OMAP4430_VC_CORE_VPACK_EN_MASK					(1 << 22)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VC_CORE_VPACK_ST_SHIFT					22
#define OMAP4430_VC_CORE_VPACK_ST_MASK					(1 << 22)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VC_IVA_VPACK_EN_SHIFT					30
#define OMAP4430_VC_IVA_VPACK_EN_MASK					(1 << 30)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VC_IVA_VPACK_ST_SHIFT					30
#define OMAP4430_VC_IVA_VPACK_ST_MASK					(1 << 30)

/* Used by PRM_IRQENABLE_MPU_2 */
#define OMAP4430_VC_MPU_VPACK_EN_SHIFT					6
#define OMAP4430_VC_MPU_VPACK_EN_MASK					(1 << 6)

/* Used by PRM_IRQSTATUS_MPU_2 */
#define OMAP4430_VC_MPU_VPACK_ST_SHIFT					6
#define OMAP4430_VC_MPU_VPACK_ST_MASK					(1 << 6)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VC_RAERR_EN_SHIFT					12
#define OMAP4430_VC_RAERR_EN_MASK					(1 << 12)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VC_RAERR_ST_SHIFT					12
#define OMAP4430_VC_RAERR_ST_MASK					(1 << 12)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VC_SAERR_EN_SHIFT					11
#define OMAP4430_VC_SAERR_EN_MASK					(1 << 11)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VC_SAERR_ST_SHIFT					11
#define OMAP4430_VC_SAERR_ST_MASK					(1 << 11)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VC_TOERR_EN_SHIFT					13
#define OMAP4430_VC_TOERR_EN_MASK					(1 << 13)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VC_TOERR_ST_SHIFT					13
#define OMAP4430_VC_TOERR_ST_MASK					(1 << 13)

/* Used by PRM_VP_CORE_VLIMITTO, PRM_VP_IVA_VLIMITTO, PRM_VP_MPU_VLIMITTO */
#define OMAP4430_VDDMAX_SHIFT						24
#define OMAP4430_VDDMAX_MASK						(0xff << 24)

/* Used by PRM_VP_CORE_VLIMITTO, PRM_VP_IVA_VLIMITTO, PRM_VP_MPU_VLIMITTO */
#define OMAP4430_VDDMIN_SHIFT						16
#define OMAP4430_VDDMIN_MASK						(0xff << 16)

/* Used by PRM_VOLTCTRL */
#define OMAP4430_VDD_CORE_I2C_DISABLE_SHIFT				12
#define OMAP4430_VDD_CORE_I2C_DISABLE_MASK				(1 << 12)

/* Used by PRM_RSTST */
#define OMAP4430_VDD_CORE_VOLT_MGR_RST_SHIFT				8
#define OMAP4430_VDD_CORE_VOLT_MGR_RST_MASK				(1 << 8)

/* Used by PRM_VOLTCTRL */
#define OMAP4430_VDD_IVA_I2C_DISABLE_SHIFT				14
#define OMAP4430_VDD_IVA_I2C_DISABLE_MASK				(1 << 14)

/* Used by PRM_VOLTCTRL */
#define OMAP4430_VDD_IVA_PRESENCE_SHIFT					9
#define OMAP4430_VDD_IVA_PRESENCE_MASK					(1 << 9)

/* Used by PRM_RSTST */
#define OMAP4430_VDD_IVA_VOLT_MGR_RST_SHIFT				7
#define OMAP4430_VDD_IVA_VOLT_MGR_RST_MASK				(1 << 7)

/* Used by PRM_VOLTCTRL */
#define OMAP4430_VDD_MPU_I2C_DISABLE_SHIFT				13
#define OMAP4430_VDD_MPU_I2C_DISABLE_MASK				(1 << 13)

/* Used by PRM_VOLTCTRL */
#define OMAP4430_VDD_MPU_PRESENCE_SHIFT					8
#define OMAP4430_VDD_MPU_PRESENCE_MASK					(1 << 8)

/* Used by PRM_RSTST */
#define OMAP4430_VDD_MPU_VOLT_MGR_RST_SHIFT				6
#define OMAP4430_VDD_MPU_VOLT_MGR_RST_MASK				(1 << 6)

/* Used by PRM_VC_ERRST */
#define OMAP4430_VFSM_RA_ERR_CORE_SHIFT					4
#define OMAP4430_VFSM_RA_ERR_CORE_MASK					(1 << 4)

/* Used by PRM_VC_ERRST */
#define OMAP4430_VFSM_RA_ERR_IVA_SHIFT					12
#define OMAP4430_VFSM_RA_ERR_IVA_MASK					(1 << 12)

/* Used by PRM_VC_ERRST */
#define OMAP4430_VFSM_RA_ERR_MPU_SHIFT					20
#define OMAP4430_VFSM_RA_ERR_MPU_MASK					(1 << 20)

/* Used by PRM_VC_ERRST */
#define OMAP4430_VFSM_SA_ERR_CORE_SHIFT					3
#define OMAP4430_VFSM_SA_ERR_CORE_MASK					(1 << 3)

/* Used by PRM_VC_ERRST */
#define OMAP4430_VFSM_SA_ERR_IVA_SHIFT					11
#define OMAP4430_VFSM_SA_ERR_IVA_MASK					(1 << 11)

/* Used by PRM_VC_ERRST */
#define OMAP4430_VFSM_SA_ERR_MPU_SHIFT					19
#define OMAP4430_VFSM_SA_ERR_MPU_MASK					(1 << 19)

/* Used by PRM_VC_ERRST */
#define OMAP4430_VFSM_TIMEOUT_ERR_CORE_SHIFT				5
#define OMAP4430_VFSM_TIMEOUT_ERR_CORE_MASK				(1 << 5)

/* Used by PRM_VC_ERRST */
#define OMAP4430_VFSM_TIMEOUT_ERR_IVA_SHIFT				13
#define OMAP4430_VFSM_TIMEOUT_ERR_IVA_MASK				(1 << 13)

/* Used by PRM_VC_ERRST */
#define OMAP4430_VFSM_TIMEOUT_ERR_MPU_SHIFT				21
#define OMAP4430_VFSM_TIMEOUT_ERR_MPU_MASK				(1 << 21)

/* Used by PRM_VC_VAL_SMPS_RA_VOL */
#define OMAP4430_VOLRA_VDD_CORE_L_SHIFT					0
#define OMAP4430_VOLRA_VDD_CORE_L_MASK					(0xff << 0)

/* Used by PRM_VC_VAL_SMPS_RA_VOL */
#define OMAP4430_VOLRA_VDD_IVA_L_SHIFT					8
#define OMAP4430_VOLRA_VDD_IVA_L_MASK					(0xff << 8)

/* Used by PRM_VC_VAL_SMPS_RA_VOL */
#define OMAP4430_VOLRA_VDD_MPU_L_SHIFT					16
#define OMAP4430_VOLRA_VDD_MPU_L_MASK					(0xff << 16)

/* Used by PRM_VP_CORE_CONFIG, PRM_VP_IVA_CONFIG, PRM_VP_MPU_CONFIG */
#define OMAP4430_VPENABLE_SHIFT						0
#define OMAP4430_VPENABLE_MASK						(1 << 0)

/* Used by PRM_VP_CORE_STATUS, PRM_VP_IVA_STATUS, PRM_VP_MPU_STATUS */
#define OMAP4430_VPINIDLE_SHIFT						0
#define OMAP4430_VPINIDLE_MASK						(1 << 0)

/* Used by PRM_VP_CORE_VOLTAGE, PRM_VP_IVA_VOLTAGE, PRM_VP_MPU_VOLTAGE */
#define OMAP4430_VPVOLTAGE_SHIFT					0
#define OMAP4430_VPVOLTAGE_MASK						(0xff << 0)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VP_CORE_EQVALUE_EN_SHIFT				20
#define OMAP4430_VP_CORE_EQVALUE_EN_MASK				(1 << 20)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VP_CORE_EQVALUE_ST_SHIFT				20
#define OMAP4430_VP_CORE_EQVALUE_ST_MASK				(1 << 20)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VP_CORE_MAXVDD_EN_SHIFT				18
#define OMAP4430_VP_CORE_MAXVDD_EN_MASK					(1 << 18)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VP_CORE_MAXVDD_ST_SHIFT				18
#define OMAP4430_VP_CORE_MAXVDD_ST_MASK					(1 << 18)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VP_CORE_MINVDD_EN_SHIFT				17
#define OMAP4430_VP_CORE_MINVDD_EN_MASK					(1 << 17)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VP_CORE_MINVDD_ST_SHIFT				17
#define OMAP4430_VP_CORE_MINVDD_ST_MASK					(1 << 17)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VP_CORE_NOSMPSACK_EN_SHIFT				19
#define OMAP4430_VP_CORE_NOSMPSACK_EN_MASK				(1 << 19)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VP_CORE_NOSMPSACK_ST_SHIFT				19
#define OMAP4430_VP_CORE_NOSMPSACK_ST_MASK				(1 << 19)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VP_CORE_OPPCHANGEDONE_EN_SHIFT				16
#define OMAP4430_VP_CORE_OPPCHANGEDONE_EN_MASK				(1 << 16)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VP_CORE_OPPCHANGEDONE_ST_SHIFT				16
#define OMAP4430_VP_CORE_OPPCHANGEDONE_ST_MASK				(1 << 16)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VP_CORE_TRANXDONE_EN_SHIFT				21
#define OMAP4430_VP_CORE_TRANXDONE_EN_MASK				(1 << 21)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VP_CORE_TRANXDONE_ST_SHIFT				21
#define OMAP4430_VP_CORE_TRANXDONE_ST_MASK				(1 << 21)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VP_IVA_EQVALUE_EN_SHIFT				28
#define OMAP4430_VP_IVA_EQVALUE_EN_MASK					(1 << 28)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VP_IVA_EQVALUE_ST_SHIFT				28
#define OMAP4430_VP_IVA_EQVALUE_ST_MASK					(1 << 28)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VP_IVA_MAXVDD_EN_SHIFT					26
#define OMAP4430_VP_IVA_MAXVDD_EN_MASK					(1 << 26)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VP_IVA_MAXVDD_ST_SHIFT					26
#define OMAP4430_VP_IVA_MAXVDD_ST_MASK					(1 << 26)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VP_IVA_MINVDD_EN_SHIFT					25
#define OMAP4430_VP_IVA_MINVDD_EN_MASK					(1 << 25)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VP_IVA_MINVDD_ST_SHIFT					25
#define OMAP4430_VP_IVA_MINVDD_ST_MASK					(1 << 25)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VP_IVA_NOSMPSACK_EN_SHIFT				27
#define OMAP4430_VP_IVA_NOSMPSACK_EN_MASK				(1 << 27)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VP_IVA_NOSMPSACK_ST_SHIFT				27
#define OMAP4430_VP_IVA_NOSMPSACK_ST_MASK				(1 << 27)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VP_IVA_OPPCHANGEDONE_EN_SHIFT				24
#define OMAP4430_VP_IVA_OPPCHANGEDONE_EN_MASK				(1 << 24)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VP_IVA_OPPCHANGEDONE_ST_SHIFT				24
#define OMAP4430_VP_IVA_OPPCHANGEDONE_ST_MASK				(1 << 24)

/* Used by PRM_IRQENABLE_DUCATI, PRM_IRQENABLE_MPU */
#define OMAP4430_VP_IVA_TRANXDONE_EN_SHIFT				29
#define OMAP4430_VP_IVA_TRANXDONE_EN_MASK				(1 << 29)

/* Used by PRM_IRQSTATUS_DUCATI, PRM_IRQSTATUS_MPU */
#define OMAP4430_VP_IVA_TRANXDONE_ST_SHIFT				29
#define OMAP4430_VP_IVA_TRANXDONE_ST_MASK				(1 << 29)

/* Used by PRM_IRQENABLE_MPU_2 */
#define OMAP4430_VP_MPU_EQVALUE_EN_SHIFT				4
#define OMAP4430_VP_MPU_EQVALUE_EN_MASK					(1 << 4)

/* Used by PRM_IRQSTATUS_MPU_2 */
#define OMAP4430_VP_MPU_EQVALUE_ST_SHIFT				4
#define OMAP4430_VP_MPU_EQVALUE_ST_MASK					(1 << 4)

/* Used by PRM_IRQENABLE_MPU_2 */
#define OMAP4430_VP_MPU_MAXVDD_EN_SHIFT					2
#define OMAP4430_VP_MPU_MAXVDD_EN_MASK					(1 << 2)

/* Used by PRM_IRQSTATUS_MPU_2 */
#define OMAP4430_VP_MPU_MAXVDD_ST_SHIFT					2
#define OMAP4430_VP_MPU_MAXVDD_ST_MASK					(1 << 2)

/* Used by PRM_IRQENABLE_MPU_2 */
#define OMAP4430_VP_MPU_MINVDD_EN_SHIFT					1
#define OMAP4430_VP_MPU_MINVDD_EN_MASK					(1 << 1)

/* Used by PRM_IRQSTATUS_MPU_2 */
#define OMAP4430_VP_MPU_MINVDD_ST_SHIFT					1
#define OMAP4430_VP_MPU_MINVDD_ST_MASK					(1 << 1)

/* Used by PRM_IRQENABLE_MPU_2 */
#define OMAP4430_VP_MPU_NOSMPSACK_EN_SHIFT				3
#define OMAP4430_VP_MPU_NOSMPSACK_EN_MASK				(1 << 3)

/* Used by PRM_IRQSTATUS_MPU_2 */
#define OMAP4430_VP_MPU_NOSMPSACK_ST_SHIFT				3
#define OMAP4430_VP_MPU_NOSMPSACK_ST_MASK				(1 << 3)

/* Used by PRM_IRQENABLE_MPU_2 */
#define OMAP4430_VP_MPU_OPPCHANGEDONE_EN_SHIFT				0
#define OMAP4430_VP_MPU_OPPCHANGEDONE_EN_MASK				(1 << 0)

/* Used by PRM_IRQSTATUS_MPU_2 */
#define OMAP4430_VP_MPU_OPPCHANGEDONE_ST_SHIFT				0
#define OMAP4430_VP_MPU_OPPCHANGEDONE_ST_MASK				(1 << 0)

/* Used by PRM_IRQENABLE_MPU_2 */
#define OMAP4430_VP_MPU_TRANXDONE_EN_SHIFT				5
#define OMAP4430_VP_MPU_TRANXDONE_EN_MASK				(1 << 5)

/* Used by PRM_IRQSTATUS_MPU_2 */
#define OMAP4430_VP_MPU_TRANXDONE_ST_SHIFT				5
#define OMAP4430_VP_MPU_TRANXDONE_ST_MASK				(1 << 5)

/* Used by PRM_SRAM_COUNT */
#define OMAP4430_VSETUPCNT_VALUE_SHIFT					8
#define OMAP4430_VSETUPCNT_VALUE_MASK					(0xff << 8)

/* Used by PRM_VP_CORE_VSTEPMAX, PRM_VP_IVA_VSTEPMAX, PRM_VP_MPU_VSTEPMAX */
#define OMAP4430_VSTEPMAX_SHIFT						0
#define OMAP4430_VSTEPMAX_MASK						(0xff << 0)

/* Used by PRM_VP_CORE_VSTEPMIN, PRM_VP_IVA_VSTEPMIN, PRM_VP_MPU_VSTEPMIN */
#define OMAP4430_VSTEPMIN_SHIFT						0
#define OMAP4430_VSTEPMIN_MASK						(0xff << 0)

/* Used by PRM_MODEM_IF_CTRL */
#define OMAP4430_WAKE_MODEM_SHIFT					0
#define OMAP4430_WAKE_MODEM_MASK					(1 << 0)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP4430_WKUPDEP_DISPC_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_DISPC_DUCATI_MASK				(1 << 1)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP4430_WKUPDEP_DISPC_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_DISPC_MPU_MASK					(1 << 0)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP4430_WKUPDEP_DISPC_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_DISPC_SDMA_MASK				(1 << 3)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP4430_WKUPDEP_DISPC_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_DISPC_TESLA_MASK				(1 << 2)

/* Used by PM_ABE_DMIC_WKDEP */
#define OMAP4430_WKUPDEP_DMIC_DMA_SDMA_SHIFT				7
#define OMAP4430_WKUPDEP_DMIC_DMA_SDMA_MASK				(1 << 7)

/* Used by PM_ABE_DMIC_WKDEP */
#define OMAP4430_WKUPDEP_DMIC_DMA_TESLA_SHIFT				6
#define OMAP4430_WKUPDEP_DMIC_DMA_TESLA_MASK				(1 << 6)

/* Used by PM_ABE_DMIC_WKDEP */
#define OMAP4430_WKUPDEP_DMIC_IRQ_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_DMIC_IRQ_MPU_MASK				(1 << 0)

/* Used by PM_ABE_DMIC_WKDEP */
#define OMAP4430_WKUPDEP_DMIC_IRQ_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_DMIC_IRQ_TESLA_MASK				(1 << 2)

/* Used by PM_L4PER_DMTIMER10_WKDEP */
#define OMAP4430_WKUPDEP_DMTIMER10_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_DMTIMER10_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_DMTIMER11_WKDEP */
#define OMAP4430_WKUPDEP_DMTIMER11_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_DMTIMER11_DUCATI_MASK				(1 << 1)

/* Used by PM_L4PER_DMTIMER11_WKDEP */
#define OMAP4430_WKUPDEP_DMTIMER11_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_DMTIMER11_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_DMTIMER2_WKDEP */
#define OMAP4430_WKUPDEP_DMTIMER2_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_DMTIMER2_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_DMTIMER3_WKDEP */
#define OMAP4430_WKUPDEP_DMTIMER3_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_DMTIMER3_DUCATI_MASK				(1 << 1)

/* Used by PM_L4PER_DMTIMER3_WKDEP */
#define OMAP4430_WKUPDEP_DMTIMER3_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_DMTIMER3_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_DMTIMER4_WKDEP */
#define OMAP4430_WKUPDEP_DMTIMER4_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_DMTIMER4_DUCATI_MASK				(1 << 1)

/* Used by PM_L4PER_DMTIMER4_WKDEP */
#define OMAP4430_WKUPDEP_DMTIMER4_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_DMTIMER4_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_DMTIMER9_WKDEP */
#define OMAP4430_WKUPDEP_DMTIMER9_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_DMTIMER9_DUCATI_MASK				(1 << 1)

/* Used by PM_L4PER_DMTIMER9_WKDEP */
#define OMAP4430_WKUPDEP_DMTIMER9_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_DMTIMER9_MPU_MASK				(1 << 0)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP4430_WKUPDEP_DSI1_DUCATI_SHIFT				5
#define OMAP4430_WKUPDEP_DSI1_DUCATI_MASK				(1 << 5)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP4430_WKUPDEP_DSI1_MPU_SHIFT					4
#define OMAP4430_WKUPDEP_DSI1_MPU_MASK					(1 << 4)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP4430_WKUPDEP_DSI1_SDMA_SHIFT				7
#define OMAP4430_WKUPDEP_DSI1_SDMA_MASK					(1 << 7)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP4430_WKUPDEP_DSI1_TESLA_SHIFT				6
#define OMAP4430_WKUPDEP_DSI1_TESLA_MASK				(1 << 6)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP4430_WKUPDEP_DSI2_DUCATI_SHIFT				9
#define OMAP4430_WKUPDEP_DSI2_DUCATI_MASK				(1 << 9)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP4430_WKUPDEP_DSI2_MPU_SHIFT					8
#define OMAP4430_WKUPDEP_DSI2_MPU_MASK					(1 << 8)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP4430_WKUPDEP_DSI2_SDMA_SHIFT				11
#define OMAP4430_WKUPDEP_DSI2_SDMA_MASK					(1 << 11)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP4430_WKUPDEP_DSI2_TESLA_SHIFT				10
#define OMAP4430_WKUPDEP_DSI2_TESLA_MASK				(1 << 10)

/* Used by PM_WKUP_GPIO1_WKDEP */
#define OMAP4430_WKUPDEP_GPIO1_IRQ1_DUCATI_SHIFT			1
#define OMAP4430_WKUPDEP_GPIO1_IRQ1_DUCATI_MASK				(1 << 1)

/* Used by PM_WKUP_GPIO1_WKDEP */
#define OMAP4430_WKUPDEP_GPIO1_IRQ1_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_GPIO1_IRQ1_MPU_MASK				(1 << 0)

/* Used by PM_WKUP_GPIO1_WKDEP */
#define OMAP4430_WKUPDEP_GPIO1_IRQ2_TESLA_SHIFT				6
#define OMAP4430_WKUPDEP_GPIO1_IRQ2_TESLA_MASK				(1 << 6)

/* Used by PM_L4PER_GPIO2_WKDEP */
#define OMAP4430_WKUPDEP_GPIO2_IRQ1_DUCATI_SHIFT			1
#define OMAP4430_WKUPDEP_GPIO2_IRQ1_DUCATI_MASK				(1 << 1)

/* Used by PM_L4PER_GPIO2_WKDEP */
#define OMAP4430_WKUPDEP_GPIO2_IRQ1_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_GPIO2_IRQ1_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_GPIO2_WKDEP */
#define OMAP4430_WKUPDEP_GPIO2_IRQ2_TESLA_SHIFT				6
#define OMAP4430_WKUPDEP_GPIO2_IRQ2_TESLA_MASK				(1 << 6)

/* Used by PM_L4PER_GPIO3_WKDEP */
#define OMAP4430_WKUPDEP_GPIO3_IRQ1_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_GPIO3_IRQ1_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_GPIO3_WKDEP */
#define OMAP4430_WKUPDEP_GPIO3_IRQ2_TESLA_SHIFT				6
#define OMAP4430_WKUPDEP_GPIO3_IRQ2_TESLA_MASK				(1 << 6)

/* Used by PM_L4PER_GPIO4_WKDEP */
#define OMAP4430_WKUPDEP_GPIO4_IRQ1_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_GPIO4_IRQ1_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_GPIO4_WKDEP */
#define OMAP4430_WKUPDEP_GPIO4_IRQ2_TESLA_SHIFT				6
#define OMAP4430_WKUPDEP_GPIO4_IRQ2_TESLA_MASK				(1 << 6)

/* Used by PM_L4PER_GPIO5_WKDEP */
#define OMAP4430_WKUPDEP_GPIO5_IRQ1_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_GPIO5_IRQ1_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_GPIO5_WKDEP */
#define OMAP4430_WKUPDEP_GPIO5_IRQ2_TESLA_SHIFT				6
#define OMAP4430_WKUPDEP_GPIO5_IRQ2_TESLA_MASK				(1 << 6)

/* Used by PM_L4PER_GPIO6_WKDEP */
#define OMAP4430_WKUPDEP_GPIO6_IRQ1_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_GPIO6_IRQ1_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_GPIO6_WKDEP */
#define OMAP4430_WKUPDEP_GPIO6_IRQ2_TESLA_SHIFT				6
#define OMAP4430_WKUPDEP_GPIO6_IRQ2_TESLA_MASK				(1 << 6)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP4430_WKUPDEP_HDMIDMA_SDMA_SHIFT				19
#define OMAP4430_WKUPDEP_HDMIDMA_SDMA_MASK				(1 << 19)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP4430_WKUPDEP_HDMIIRQ_DUCATI_SHIFT				13
#define OMAP4430_WKUPDEP_HDMIIRQ_DUCATI_MASK				(1 << 13)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP4430_WKUPDEP_HDMIIRQ_MPU_SHIFT				12
#define OMAP4430_WKUPDEP_HDMIIRQ_MPU_MASK				(1 << 12)

/* Used by PM_DSS_DSS_WKDEP */
#define OMAP4430_WKUPDEP_HDMIIRQ_TESLA_SHIFT				14
#define OMAP4430_WKUPDEP_HDMIIRQ_TESLA_MASK				(1 << 14)

/* Used by PM_L4PER_HECC1_WKDEP */
#define OMAP4430_WKUPDEP_HECC1_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_HECC1_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_HECC2_WKDEP */
#define OMAP4430_WKUPDEP_HECC2_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_HECC2_MPU_MASK					(1 << 0)

/* Used by PM_L3INIT_HSI_WKDEP */
#define OMAP4430_WKUPDEP_HSI_DSP_TESLA_SHIFT				6
#define OMAP4430_WKUPDEP_HSI_DSP_TESLA_MASK				(1 << 6)

/* Used by PM_L3INIT_HSI_WKDEP */
#define OMAP4430_WKUPDEP_HSI_MCU_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_HSI_MCU_DUCATI_MASK				(1 << 1)

/* Used by PM_L3INIT_HSI_WKDEP */
#define OMAP4430_WKUPDEP_HSI_MCU_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_HSI_MCU_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_I2C1_WKDEP */
#define OMAP4430_WKUPDEP_I2C1_DMA_SDMA_SHIFT				7
#define OMAP4430_WKUPDEP_I2C1_DMA_SDMA_MASK				(1 << 7)

/* Used by PM_L4PER_I2C1_WKDEP */
#define OMAP4430_WKUPDEP_I2C1_IRQ_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_I2C1_IRQ_DUCATI_MASK				(1 << 1)

/* Used by PM_L4PER_I2C1_WKDEP */
#define OMAP4430_WKUPDEP_I2C1_IRQ_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_I2C1_IRQ_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_I2C2_WKDEP */
#define OMAP4430_WKUPDEP_I2C2_DMA_SDMA_SHIFT				7
#define OMAP4430_WKUPDEP_I2C2_DMA_SDMA_MASK				(1 << 7)

/* Used by PM_L4PER_I2C2_WKDEP */
#define OMAP4430_WKUPDEP_I2C2_IRQ_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_I2C2_IRQ_DUCATI_MASK				(1 << 1)

/* Used by PM_L4PER_I2C2_WKDEP */
#define OMAP4430_WKUPDEP_I2C2_IRQ_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_I2C2_IRQ_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_I2C3_WKDEP */
#define OMAP4430_WKUPDEP_I2C3_DMA_SDMA_SHIFT				7
#define OMAP4430_WKUPDEP_I2C3_DMA_SDMA_MASK				(1 << 7)

/* Used by PM_L4PER_I2C3_WKDEP */
#define OMAP4430_WKUPDEP_I2C3_IRQ_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_I2C3_IRQ_DUCATI_MASK				(1 << 1)

/* Used by PM_L4PER_I2C3_WKDEP */
#define OMAP4430_WKUPDEP_I2C3_IRQ_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_I2C3_IRQ_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_I2C4_WKDEP */
#define OMAP4430_WKUPDEP_I2C4_DMA_SDMA_SHIFT				7
#define OMAP4430_WKUPDEP_I2C4_DMA_SDMA_MASK				(1 << 7)

/* Used by PM_L4PER_I2C4_WKDEP */
#define OMAP4430_WKUPDEP_I2C4_IRQ_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_I2C4_IRQ_DUCATI_MASK				(1 << 1)

/* Used by PM_L4PER_I2C4_WKDEP */
#define OMAP4430_WKUPDEP_I2C4_IRQ_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_I2C4_IRQ_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_I2C5_WKDEP */
#define OMAP4430_WKUPDEP_I2C5_DMA_SDMA_SHIFT				7
#define OMAP4430_WKUPDEP_I2C5_DMA_SDMA_MASK				(1 << 7)

/* Used by PM_L4PER_I2C5_WKDEP */
#define OMAP4430_WKUPDEP_I2C5_IRQ_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_I2C5_IRQ_MPU_MASK				(1 << 0)

/* Used by PM_WKUP_KEYBOARD_WKDEP */
#define OMAP4430_WKUPDEP_KEYBOARD_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_KEYBOARD_MPU_MASK				(1 << 0)

/* Used by PM_ABE_MCASP_WKDEP */
#define OMAP4430_WKUPDEP_MCASP1_DMA_SDMA_SHIFT				7
#define OMAP4430_WKUPDEP_MCASP1_DMA_SDMA_MASK				(1 << 7)

/* Used by PM_ABE_MCASP_WKDEP */
#define OMAP4430_WKUPDEP_MCASP1_DMA_TESLA_SHIFT				6
#define OMAP4430_WKUPDEP_MCASP1_DMA_TESLA_MASK				(1 << 6)

/* Used by PM_ABE_MCASP_WKDEP */
#define OMAP4430_WKUPDEP_MCASP1_IRQ_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_MCASP1_IRQ_MPU_MASK				(1 << 0)

/* Used by PM_ABE_MCASP_WKDEP */
#define OMAP4430_WKUPDEP_MCASP1_IRQ_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_MCASP1_IRQ_TESLA_MASK				(1 << 2)

/* Used by PM_L4PER_MCASP2_WKDEP */
#define OMAP4430_WKUPDEP_MCASP2_DMA_SDMA_SHIFT				7
#define OMAP4430_WKUPDEP_MCASP2_DMA_SDMA_MASK				(1 << 7)

/* Used by PM_L4PER_MCASP2_WKDEP */
#define OMAP4430_WKUPDEP_MCASP2_DMA_TESLA_SHIFT				6
#define OMAP4430_WKUPDEP_MCASP2_DMA_TESLA_MASK				(1 << 6)

/* Used by PM_L4PER_MCASP2_WKDEP */
#define OMAP4430_WKUPDEP_MCASP2_IRQ_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_MCASP2_IRQ_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_MCASP2_WKDEP */
#define OMAP4430_WKUPDEP_MCASP2_IRQ_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_MCASP2_IRQ_TESLA_MASK				(1 << 2)

/* Used by PM_L4PER_MCASP3_WKDEP */
#define OMAP4430_WKUPDEP_MCASP3_DMA_SDMA_SHIFT				7
#define OMAP4430_WKUPDEP_MCASP3_DMA_SDMA_MASK				(1 << 7)

/* Used by PM_L4PER_MCASP3_WKDEP */
#define OMAP4430_WKUPDEP_MCASP3_DMA_TESLA_SHIFT				6
#define OMAP4430_WKUPDEP_MCASP3_DMA_TESLA_MASK				(1 << 6)

/* Used by PM_L4PER_MCASP3_WKDEP */
#define OMAP4430_WKUPDEP_MCASP3_IRQ_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_MCASP3_IRQ_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_MCASP3_WKDEP */
#define OMAP4430_WKUPDEP_MCASP3_IRQ_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_MCASP3_IRQ_TESLA_MASK				(1 << 2)

/* Used by PM_ABE_MCBSP1_WKDEP */
#define OMAP4430_WKUPDEP_MCBSP1_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_MCBSP1_MPU_MASK				(1 << 0)

/* Used by PM_ABE_MCBSP1_WKDEP */
#define OMAP4430_WKUPDEP_MCBSP1_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_MCBSP1_SDMA_MASK				(1 << 3)

/* Used by PM_ABE_MCBSP1_WKDEP */
#define OMAP4430_WKUPDEP_MCBSP1_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_MCBSP1_TESLA_MASK				(1 << 2)

/* Used by PM_ABE_MCBSP2_WKDEP */
#define OMAP4430_WKUPDEP_MCBSP2_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_MCBSP2_MPU_MASK				(1 << 0)

/* Used by PM_ABE_MCBSP2_WKDEP */
#define OMAP4430_WKUPDEP_MCBSP2_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_MCBSP2_SDMA_MASK				(1 << 3)

/* Used by PM_ABE_MCBSP2_WKDEP */
#define OMAP4430_WKUPDEP_MCBSP2_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_MCBSP2_TESLA_MASK				(1 << 2)

/* Used by PM_ABE_MCBSP3_WKDEP */
#define OMAP4430_WKUPDEP_MCBSP3_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_MCBSP3_MPU_MASK				(1 << 0)

/* Used by PM_ABE_MCBSP3_WKDEP */
#define OMAP4430_WKUPDEP_MCBSP3_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_MCBSP3_SDMA_MASK				(1 << 3)

/* Used by PM_ABE_MCBSP3_WKDEP */
#define OMAP4430_WKUPDEP_MCBSP3_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_MCBSP3_TESLA_MASK				(1 << 2)

/* Used by PM_L4PER_MCBSP4_WKDEP */
#define OMAP4430_WKUPDEP_MCBSP4_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_MCBSP4_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_MCBSP4_WKDEP */
#define OMAP4430_WKUPDEP_MCBSP4_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_MCBSP4_SDMA_MASK				(1 << 3)

/* Used by PM_L4PER_MCBSP4_WKDEP */
#define OMAP4430_WKUPDEP_MCBSP4_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_MCBSP4_TESLA_MASK				(1 << 2)

/* Used by PM_L4PER_MCSPI1_WKDEP */
#define OMAP4430_WKUPDEP_MCSPI1_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_MCSPI1_DUCATI_MASK				(1 << 1)

/* Used by PM_L4PER_MCSPI1_WKDEP */
#define OMAP4430_WKUPDEP_MCSPI1_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_MCSPI1_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_MCSPI1_WKDEP */
#define OMAP4430_WKUPDEP_MCSPI1_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_MCSPI1_SDMA_MASK				(1 << 3)

/* Used by PM_L4PER_MCSPI1_WKDEP */
#define OMAP4430_WKUPDEP_MCSPI1_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_MCSPI1_TESLA_MASK				(1 << 2)

/* Used by PM_L4PER_MCSPI2_WKDEP */
#define OMAP4430_WKUPDEP_MCSPI2_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_MCSPI2_DUCATI_MASK				(1 << 1)

/* Used by PM_L4PER_MCSPI2_WKDEP */
#define OMAP4430_WKUPDEP_MCSPI2_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_MCSPI2_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_MCSPI2_WKDEP */
#define OMAP4430_WKUPDEP_MCSPI2_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_MCSPI2_SDMA_MASK				(1 << 3)

/* Used by PM_L4PER_MCSPI3_WKDEP */
#define OMAP4430_WKUPDEP_MCSPI3_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_MCSPI3_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_MCSPI3_WKDEP */
#define OMAP4430_WKUPDEP_MCSPI3_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_MCSPI3_SDMA_MASK				(1 << 3)

/* Used by PM_L4PER_MCSPI4_WKDEP */
#define OMAP4430_WKUPDEP_MCSPI4_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_MCSPI4_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_MCSPI4_WKDEP */
#define OMAP4430_WKUPDEP_MCSPI4_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_MCSPI4_SDMA_MASK				(1 << 3)

/* Used by PM_L3INIT_MMC1_WKDEP */
#define OMAP4430_WKUPDEP_MMC1_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_MMC1_DUCATI_MASK				(1 << 1)

/* Used by PM_L3INIT_MMC1_WKDEP */
#define OMAP4430_WKUPDEP_MMC1_MPU_SHIFT					0
#define OMAP4430_WKUPDEP_MMC1_MPU_MASK					(1 << 0)

/* Used by PM_L3INIT_MMC1_WKDEP */
#define OMAP4430_WKUPDEP_MMC1_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_MMC1_SDMA_MASK					(1 << 3)

/* Used by PM_L3INIT_MMC1_WKDEP */
#define OMAP4430_WKUPDEP_MMC1_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_MMC1_TESLA_MASK				(1 << 2)

/* Used by PM_L3INIT_MMC2_WKDEP */
#define OMAP4430_WKUPDEP_MMC2_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_MMC2_DUCATI_MASK				(1 << 1)

/* Used by PM_L3INIT_MMC2_WKDEP */
#define OMAP4430_WKUPDEP_MMC2_MPU_SHIFT					0
#define OMAP4430_WKUPDEP_MMC2_MPU_MASK					(1 << 0)

/* Used by PM_L3INIT_MMC2_WKDEP */
#define OMAP4430_WKUPDEP_MMC2_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_MMC2_SDMA_MASK					(1 << 3)

/* Used by PM_L3INIT_MMC2_WKDEP */
#define OMAP4430_WKUPDEP_MMC2_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_MMC2_TESLA_MASK				(1 << 2)

/* Used by PM_L3INIT_MMC6_WKDEP */
#define OMAP4430_WKUPDEP_MMC6_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_MMC6_DUCATI_MASK				(1 << 1)

/* Used by PM_L3INIT_MMC6_WKDEP */
#define OMAP4430_WKUPDEP_MMC6_MPU_SHIFT					0
#define OMAP4430_WKUPDEP_MMC6_MPU_MASK					(1 << 0)

/* Used by PM_L3INIT_MMC6_WKDEP */
#define OMAP4430_WKUPDEP_MMC6_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_MMC6_TESLA_MASK				(1 << 2)

/* Used by PM_L4PER_MMCSD3_WKDEP */
#define OMAP4430_WKUPDEP_MMCSD3_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_MMCSD3_DUCATI_MASK				(1 << 1)

/* Used by PM_L4PER_MMCSD3_WKDEP */
#define OMAP4430_WKUPDEP_MMCSD3_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_MMCSD3_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_MMCSD3_WKDEP */
#define OMAP4430_WKUPDEP_MMCSD3_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_MMCSD3_SDMA_MASK				(1 << 3)

/* Used by PM_L4PER_MMCSD4_WKDEP */
#define OMAP4430_WKUPDEP_MMCSD4_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_MMCSD4_DUCATI_MASK				(1 << 1)

/* Used by PM_L4PER_MMCSD4_WKDEP */
#define OMAP4430_WKUPDEP_MMCSD4_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_MMCSD4_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_MMCSD4_WKDEP */
#define OMAP4430_WKUPDEP_MMCSD4_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_MMCSD4_SDMA_MASK				(1 << 3)

/* Used by PM_L4PER_MMCSD5_WKDEP */
#define OMAP4430_WKUPDEP_MMCSD5_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_MMCSD5_DUCATI_MASK				(1 << 1)

/* Used by PM_L4PER_MMCSD5_WKDEP */
#define OMAP4430_WKUPDEP_MMCSD5_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_MMCSD5_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_MMCSD5_WKDEP */
#define OMAP4430_WKUPDEP_MMCSD5_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_MMCSD5_SDMA_MASK				(1 << 3)

/* Used by PM_L3INIT_PCIESS_WKDEP */
#define OMAP4430_WKUPDEP_PCIESS_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_PCIESS_MPU_MASK				(1 << 0)

/* Used by PM_L3INIT_PCIESS_WKDEP */
#define OMAP4430_WKUPDEP_PCIESS_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_PCIESS_TESLA_MASK				(1 << 2)

/* Used by PM_ABE_PDM_WKDEP */
#define OMAP4430_WKUPDEP_PDM_DMA_SDMA_SHIFT				7
#define OMAP4430_WKUPDEP_PDM_DMA_SDMA_MASK				(1 << 7)

/* Used by PM_ABE_PDM_WKDEP */
#define OMAP4430_WKUPDEP_PDM_DMA_TESLA_SHIFT				6
#define OMAP4430_WKUPDEP_PDM_DMA_TESLA_MASK				(1 << 6)

/* Used by PM_ABE_PDM_WKDEP */
#define OMAP4430_WKUPDEP_PDM_IRQ_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_PDM_IRQ_MPU_MASK				(1 << 0)

/* Used by PM_ABE_PDM_WKDEP */
#define OMAP4430_WKUPDEP_PDM_IRQ_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_PDM_IRQ_TESLA_MASK				(1 << 2)

/* Used by PM_WKUP_RTC_WKDEP */
#define OMAP4430_WKUPDEP_RTC_MPU_SHIFT					0
#define OMAP4430_WKUPDEP_RTC_MPU_MASK					(1 << 0)

/* Used by PM_L3INIT_SATA_WKDEP */
#define OMAP4430_WKUPDEP_SATA_MPU_SHIFT					0
#define OMAP4430_WKUPDEP_SATA_MPU_MASK					(1 << 0)

/* Used by PM_L3INIT_SATA_WKDEP */
#define OMAP4430_WKUPDEP_SATA_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_SATA_TESLA_MASK				(1 << 2)

/* Used by PM_ABE_SLIMBUS_WKDEP */
#define OMAP4430_WKUPDEP_SLIMBUS1_DMA_SDMA_SHIFT			7
#define OMAP4430_WKUPDEP_SLIMBUS1_DMA_SDMA_MASK				(1 << 7)

/* Used by PM_ABE_SLIMBUS_WKDEP */
#define OMAP4430_WKUPDEP_SLIMBUS1_DMA_TESLA_SHIFT			6
#define OMAP4430_WKUPDEP_SLIMBUS1_DMA_TESLA_MASK			(1 << 6)

/* Used by PM_ABE_SLIMBUS_WKDEP */
#define OMAP4430_WKUPDEP_SLIMBUS1_IRQ_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_SLIMBUS1_IRQ_MPU_MASK				(1 << 0)

/* Used by PM_ABE_SLIMBUS_WKDEP */
#define OMAP4430_WKUPDEP_SLIMBUS1_IRQ_TESLA_SHIFT			2
#define OMAP4430_WKUPDEP_SLIMBUS1_IRQ_TESLA_MASK			(1 << 2)

/* Used by PM_L4PER_SLIMBUS2_WKDEP */
#define OMAP4430_WKUPDEP_SLIMBUS2_DMA_SDMA_SHIFT			7
#define OMAP4430_WKUPDEP_SLIMBUS2_DMA_SDMA_MASK				(1 << 7)

/* Used by PM_L4PER_SLIMBUS2_WKDEP */
#define OMAP4430_WKUPDEP_SLIMBUS2_DMA_TESLA_SHIFT			6
#define OMAP4430_WKUPDEP_SLIMBUS2_DMA_TESLA_MASK			(1 << 6)

/* Used by PM_L4PER_SLIMBUS2_WKDEP */
#define OMAP4430_WKUPDEP_SLIMBUS2_IRQ_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_SLIMBUS2_IRQ_MPU_MASK				(1 << 0)

/* Used by PM_L4PER_SLIMBUS2_WKDEP */
#define OMAP4430_WKUPDEP_SLIMBUS2_IRQ_TESLA_SHIFT			2
#define OMAP4430_WKUPDEP_SLIMBUS2_IRQ_TESLA_MASK			(1 << 2)

/* Used by PM_ALWON_SR_CORE_WKDEP */
#define OMAP4430_WKUPDEP_SR_CORE_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_SR_CORE_DUCATI_MASK				(1 << 1)

/* Used by PM_ALWON_SR_CORE_WKDEP */
#define OMAP4430_WKUPDEP_SR_CORE_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_SR_CORE_MPU_MASK				(1 << 0)

/* Used by PM_ALWON_SR_IVA_WKDEP */
#define OMAP4430_WKUPDEP_SR_IVA_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_SR_IVA_DUCATI_MASK				(1 << 1)

/* Used by PM_ALWON_SR_IVA_WKDEP */
#define OMAP4430_WKUPDEP_SR_IVA_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_SR_IVA_MPU_MASK				(1 << 0)

/* Used by PM_ALWON_SR_MPU_WKDEP */
#define OMAP4430_WKUPDEP_SR_MPU_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_SR_MPU_MPU_MASK				(1 << 0)

/* Used by PM_WKUP_TIMER12_WKDEP */
#define OMAP4430_WKUPDEP_TIMER12_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_TIMER12_MPU_MASK				(1 << 0)

/* Used by PM_WKUP_TIMER1_WKDEP */
#define OMAP4430_WKUPDEP_TIMER1_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_TIMER1_MPU_MASK				(1 << 0)

/* Used by PM_ABE_TIMER5_WKDEP */
#define OMAP4430_WKUPDEP_TIMER5_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_TIMER5_MPU_MASK				(1 << 0)

/* Used by PM_ABE_TIMER5_WKDEP */
#define OMAP4430_WKUPDEP_TIMER5_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_TIMER5_TESLA_MASK				(1 << 2)

/* Used by PM_ABE_TIMER6_WKDEP */
#define OMAP4430_WKUPDEP_TIMER6_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_TIMER6_MPU_MASK				(1 << 0)

/* Used by PM_ABE_TIMER6_WKDEP */
#define OMAP4430_WKUPDEP_TIMER6_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_TIMER6_TESLA_MASK				(1 << 2)

/* Used by PM_ABE_TIMER7_WKDEP */
#define OMAP4430_WKUPDEP_TIMER7_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_TIMER7_MPU_MASK				(1 << 0)

/* Used by PM_ABE_TIMER7_WKDEP */
#define OMAP4430_WKUPDEP_TIMER7_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_TIMER7_TESLA_MASK				(1 << 2)

/* Used by PM_ABE_TIMER8_WKDEP */
#define OMAP4430_WKUPDEP_TIMER8_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_TIMER8_MPU_MASK				(1 << 0)

/* Used by PM_ABE_TIMER8_WKDEP */
#define OMAP4430_WKUPDEP_TIMER8_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_TIMER8_TESLA_MASK				(1 << 2)

/* Used by PM_L4PER_UART1_WKDEP */
#define OMAP4430_WKUPDEP_UART1_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_UART1_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_UART1_WKDEP */
#define OMAP4430_WKUPDEP_UART1_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_UART1_SDMA_MASK				(1 << 3)

/* Used by PM_L4PER_UART2_WKDEP */
#define OMAP4430_WKUPDEP_UART2_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_UART2_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_UART2_WKDEP */
#define OMAP4430_WKUPDEP_UART2_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_UART2_SDMA_MASK				(1 << 3)

/* Used by PM_L4PER_UART3_WKDEP */
#define OMAP4430_WKUPDEP_UART3_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_UART3_DUCATI_MASK				(1 << 1)

/* Used by PM_L4PER_UART3_WKDEP */
#define OMAP4430_WKUPDEP_UART3_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_UART3_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_UART3_WKDEP */
#define OMAP4430_WKUPDEP_UART3_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_UART3_SDMA_MASK				(1 << 3)

/* Used by PM_L4PER_UART3_WKDEP */
#define OMAP4430_WKUPDEP_UART3_TESLA_SHIFT				2
#define OMAP4430_WKUPDEP_UART3_TESLA_MASK				(1 << 2)

/* Used by PM_L4PER_UART4_WKDEP */
#define OMAP4430_WKUPDEP_UART4_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_UART4_MPU_MASK					(1 << 0)

/* Used by PM_L4PER_UART4_WKDEP */
#define OMAP4430_WKUPDEP_UART4_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_UART4_SDMA_MASK				(1 << 3)

/* Used by PM_L3INIT_UNIPRO1_WKDEP */
#define OMAP4430_WKUPDEP_UNIPRO1_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_UNIPRO1_DUCATI_MASK				(1 << 1)

/* Used by PM_L3INIT_UNIPRO1_WKDEP */
#define OMAP4430_WKUPDEP_UNIPRO1_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_UNIPRO1_MPU_MASK				(1 << 0)

/* Used by PM_L3INIT_USB_HOST_WKDEP */
#define OMAP4430_WKUPDEP_USB_HOST_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_USB_HOST_DUCATI_MASK				(1 << 1)

/* Used by PM_L3INIT_USB_HOST_FS_WKDEP */
#define OMAP4430_WKUPDEP_USB_HOST_FS_DUCATI_SHIFT			1
#define OMAP4430_WKUPDEP_USB_HOST_FS_DUCATI_MASK			(1 << 1)

/* Used by PM_L3INIT_USB_HOST_FS_WKDEP */
#define OMAP4430_WKUPDEP_USB_HOST_FS_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_USB_HOST_FS_MPU_MASK				(1 << 0)

/* Used by PM_L3INIT_USB_HOST_WKDEP */
#define OMAP4430_WKUPDEP_USB_HOST_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_USB_HOST_MPU_MASK				(1 << 0)

/* Used by PM_L3INIT_USB_OTG_WKDEP */
#define OMAP4430_WKUPDEP_USB_OTG_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_USB_OTG_DUCATI_MASK				(1 << 1)

/* Used by PM_L3INIT_USB_OTG_WKDEP */
#define OMAP4430_WKUPDEP_USB_OTG_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_USB_OTG_MPU_MASK				(1 << 0)

/* Used by PM_L3INIT_USB_TLL_WKDEP */
#define OMAP4430_WKUPDEP_USB_TLL_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_USB_TLL_DUCATI_MASK				(1 << 1)

/* Used by PM_L3INIT_USB_TLL_WKDEP */
#define OMAP4430_WKUPDEP_USB_TLL_MPU_SHIFT				0
#define OMAP4430_WKUPDEP_USB_TLL_MPU_MASK				(1 << 0)

/* Used by PM_WKUP_USIM_WKDEP */
#define OMAP4430_WKUPDEP_USIM_MPU_SHIFT					0
#define OMAP4430_WKUPDEP_USIM_MPU_MASK					(1 << 0)

/* Used by PM_WKUP_USIM_WKDEP */
#define OMAP4430_WKUPDEP_USIM_SDMA_SHIFT				3
#define OMAP4430_WKUPDEP_USIM_SDMA_MASK					(1 << 3)

/* Used by PM_WKUP_WDT2_WKDEP */
#define OMAP4430_WKUPDEP_WDT2_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_WDT2_DUCATI_MASK				(1 << 1)

/* Used by PM_WKUP_WDT2_WKDEP */
#define OMAP4430_WKUPDEP_WDT2_MPU_SHIFT					0
#define OMAP4430_WKUPDEP_WDT2_MPU_MASK					(1 << 0)

/* Used by PM_ABE_WDT3_WKDEP */
#define OMAP4430_WKUPDEP_WDT3_MPU_SHIFT					0
#define OMAP4430_WKUPDEP_WDT3_MPU_MASK					(1 << 0)

/* Used by PM_L3INIT_HSI_WKDEP */
#define OMAP4430_WKUPDEP_WGM_HSI_WAKE_MPU_SHIFT				8
#define OMAP4430_WKUPDEP_WGM_HSI_WAKE_MPU_MASK				(1 << 8)

/* Used by PM_L3INIT_XHPI_WKDEP */
#define OMAP4430_WKUPDEP_XHPI_DUCATI_SHIFT				1
#define OMAP4430_WKUPDEP_XHPI_DUCATI_MASK				(1 << 1)

/* Used by PRM_IO_PMCTRL */
#define OMAP4430_WUCLK_CTRL_SHIFT					8
#define OMAP4430_WUCLK_CTRL_MASK					(1 << 8)

/* Used by PRM_IO_PMCTRL */
#define OMAP4430_WUCLK_STATUS_SHIFT					9
#define OMAP4430_WUCLK_STATUS_MASK					(1 << 9)

/* Used by REVISION_PRM */
#define OMAP4430_X_MAJOR_SHIFT						8
#define OMAP4430_X_MAJOR_MASK						(0x7 << 8)

/* Used by REVISION_PRM */
#define OMAP4430_Y_MINOR_SHIFT						0
#define OMAP4430_Y_MINOR_MASK						(0x3f << 0)
#endif
