package tests::OutputFormatsLaTeXTest;

use strict;

use base qw/Lire::Test::PluginTestCase/;

use Lire::OutputFormats::LaTeX;
use Lire::PluginManager;
use Lire::Utils qw/tempdir create_file/;
use File::Basename qw/dirname/;
use File::Path qw/rmtree /;
use Lire::Test::Mock;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'cfg'}{'lr_latex_include'} = 'custom.tex';
    $self->{'testdir'} = dirname( __FILE__ ) ;
    $self->{'tmpdir'} = tempdir( $self->name() . '_XXXXXX' );
    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    Lire::Test::Mock->reset_factories();
    rmtree( $self->{'tmpdir'} );

    return;
}

sub create_plugin {
    return new Lire::OutputFormats::LaTeX();
}

sub registration_file {
    return dirname( __FILE__ ) . "/../Lire/OutputFormats/of_latex_init";
}

sub test_format_report {
    my $self = $_[0];

    $self->test_registration_file();
    Lire::Test::Mock->set_mock_factory( 'Lire::ReportParser::LaTeXWriter',
                                        'write_report' => sub { create_file( $_[2] ) } );
    my $latex = Lire::PluginManager->get_plugin( 'output_format', 'latex' );
    my $report = "$self->{'tmpdir'}/report.tex";
    $latex->format_report( "$self->{'testdir'}/data/test-sqlite.xml",
                             $report );
    my ($writer) = @{Lire::Test::Mock->mock_instances( 'Lire::ReportParser::LaTeXWriter' )};
    my $call = $writer->get_invocation( 'write_report' );
    $self->assert_isa( 'Lire::Report', $call->[1] );
    $self->assert_str_equals( $report, $call->[2] );
    $self->assert_str_equals( 'latex', $call->[3] );
    $self->assert_str_equals( 'custom.tex', $call->[4] );
}

sub test_mime_report {
   my $self = $_[0];

   $self->test_registration_file();
   my $create_chart = 0;
   Lire::Test::Mock->set_mock_factory( 'Lire::ReportParser::LaTeXWriter',
                                        'write_report' => 
                                       sub { my $dir = dirname( $_[2] );
                                             create_file( $_[2] );
                                             create_file( "$dir/chart.eps" )
                                               if $create_chart;
                                         } );
   my $latex = Lire::PluginManager->get_plugin( 'output_format', 'latex' );

   my $entity = $latex->mime_report( "$self->{'testdir'}/data/test-sqlite.xml" );
   $self->assert_isa( 'MIME::Entity', $entity );
   $self->assert_str_equals( 'text/x-tex', $entity->head()->mime_type() );
   $self->assert_str_equals( "quoted-printable\n",
                             $entity->head()->get( 'content-transfer-encoding' ) );
   $self->assert_str_equals( 'utf-8',
                             $entity->head()->mime_attr( 'content-type.charset' ) );

   $create_chart = 1;
   $entity = $latex->mime_report( "$self->{'testdir'}/data/test-sqlite.xml" );
   $self->assert_str_equals( 'multipart/mixed',
                             $entity->head()->mime_type() );
   $self->assert_num_equals( 2, scalar $entity->parts() );
   my $tex = $entity->parts(0);
   $self->assert_str_equals( 'text/x-tex', $tex->head()->mime_type() );
   my $chart = $entity->parts(1);
   $self->assert_str_equals( 'application/postscript', $chart->head()->mime_type() );
}

1;
