#include <iostream>
#include "applet.h"
#include "logger.h"

using namespace std;

Applet::Applet(AppletWindowParams p):
	win(p.width_portrait, p.height_portrait, p.disp),
	params(p),
	rot(PORTRAIT),
	vibrator(NULL){
    LOG(INFO) << "Creating applet window";
    win.Create();
    if (!win.SetFont(params.font_path))
	LOG(FATAL) << "Cannot load font: " << params.font_path;
    else 
	LOG(INFO) << "Loaded font: " << params.font_path;
    win.SetFontSize(params.font_size);
}
int Applet::GetCurrentWidth(){
    switch (rot){
	case LANDSCAPE: return params.width_landscape;
	case PORTRAIT:  return params.width_portrait;
	default:	LOG(FATAL) << "Unknown orientation";
    }
}
int Applet::GetCurrentHeight(){
    switch (rot){
	case LANDSCAPE: return params.height_landscape;
	case PORTRAIT:  return params.height_portrait;
	default:	LOG(FATAL) << "Unknown orientation";
    }
}

void Applet::SetPosition(Position p){
    pos = p;
    int posy_hidden = params.disp.Height(),
	posy_south  = params.disp.Height() - GetCurrentHeight(),
	posy_north  = 0,
	posx_center = (params.disp.Width() - GetCurrentWidth())/2,
	posx_west   = 0,
	posx_east   = params.disp.Width() - GetCurrentWidth();

    int posx, posy;

    switch (pos) {
	case NORTH: posx = posx_center;
		    posy = posy_north;
		    break;	
	case SOUTH: posx = posx_center;
		    posy = posy_south;
		    break;
	case NORTH_WEST:
		    posx = posx_west;
		    posy = posy_north;
		    break;
	case NORTH_EAST:
		    posx = posx_east;
		    posy = posy_north;
		    break;
	case SOUTH_WEST:
		    posx = posx_west;
		    posy = posy_south;
		    break;
	case SOUTH_EAST:
		    posx = posx_east;
		    posy = posy_south;
		    break;

	default:    LOG(FATAL) << "Unknown position "<<pos;
    }
    if (hidden)
	posy = posy_hidden;
    win.Move(posx, posy, GetCurrentWidth(), GetCurrentHeight());

}
void Applet::Show(){
    hidden = false;
    SetPosition(pos);
    OnShow();
 /*   switch (pos) {
	case NORTH: win.Move(win.PosX(), 0);
		    break;	
	case SOUTH: win.Move(win.PosX(), win.GetDisplay().Height() - win.Height()-1);
		    break;
	default:    LOG(FATAL) << "Unknown position";
    }
    hidden = false;*/
}

void Applet::Hide(){
    win.Move(win.PosX(), win.GetDisplay().Height());
    hidden = true;
    OnHide();
}
void Applet::Refresh(){
    LOG(INFO) << "Applet refresh";
    win.Refresh();
}


void Applet::SetBackground(XColor col){
    win.SetBackground(col);
}
void Applet::SetForeground(XColor col){
    win.SetForeground(col);
}
 

void Applet::SetTransparent(bool trans){
    win.SetTransparent(trans);
}

void Applet::ToggleTransparent(){
    win.SetTransparent(!win.IsTransparent());
}

bool Applet::IsTransparent(){
    return win.IsTransparent();
}

void Applet::WindowRotate(Rotation r){
    rot = r;
    SetPosition(pos);
    OnRotate(r);
}

bool Applet::Hidden(){
    return hidden;
}

bool Applet::IsWindowOwner(Window xwin){
    return xwin == win.GetInputWindow() || xwin == win.GetWindow();
}

void Applet::SetVibrator(Vibrator* vib){
    vibrator = vib;
}

void Applet::Vibrate(){
    if (vibrator)
	vibrator->Vibrate();
}
