import sys, xmlrpclib
rpc_srv = xmlrpclib.ServerProxy("https://admin:admin@localhost:8080")

if len(sys.argv) == 1:
    print "%s list_users <server>" % (sys.argv[0])
    print "%s delete_user <server> <username> [all]" % (sys.argv[0])
    print "%s set_disabled <server> <true|false>" % (sys.argv[0])
    sys.exit(1)

if len(sys.argv) > 1 and sys.argv[1] not in ['list_users','delete_user','set_disabled']:
    print "Invalid command: %s" % sys.argv[1]
    sys.exit(1)

if sys.argv[1] == "list_users":
    if len(sys.argv) != 3 and len(sys.argv) != 4:
        print "Invalid parameters"
        sys.exit(1)
    else:
        if len(sys.argv) == 3:
            for user in rpc_srv.weblive.list_users(sys.argv[2]):
                print "%s - %s - %s - %s (%s)" % (user['username'],user['fullname'],user['source'],user['session'],user['created'])
        else:
            for user in rpc_srv.weblive.list_users(sys.argv[2],False):
                print "%s - %s - %s - %s (%s)" % (user['username'],user['fullname'],user['source'],user['session'],user['created'])

if sys.argv[1] == "delete_user":
    if len(sys.argv) != 4:
        print "Invalid parameters"
        sys.exit(1)
    else:
        print rpc_srv.weblive.delete_user(sys.argv[2],sys.argv[3])

if sys.argv[1] == "set_disabled":
    if len(sys.argv) != 4:
        print "Invalid parameters"
        sys.exit(1)
    else:
        print rpc_srv.weblive.set_disabled(sys.argv[2],sys.argv[3] == "true")
