<?php
/*
# Copyright 2004, Revolution Linux Inc., Nicolas Dufresne
#
# This file is part of the MILLE-XTERM distribution.
# See the MILLE-XTERM (english) and/or the MILLE (french) project web site
#
# http://www.revolutionlinux.com/mille-xterm/
# http://www.mille.ca/
#
# The MILLE-XTERM framework is covered by the GNU General Public License. See
# the COPYING file in the top-level MILLE-XTERM directory. Software packages
# that are included in the MILLE-XTERM distribution have their own licenses.
#
# -------------------------------------------------------------------------
*/
	require_once 'Node.php';
	require_once 'functions.php';

	/*
	*  Nodes editor class
	*
	* NodesEditor can change node name, move a node, delete a node.
	*
	* Author: Nicolas Dufresne
	*/

	class NodesEditor{
	    var $source;
	    var $dest;
	    var $childrens;
	    var $errors;
	    var $isError;
	    var $permissions;

	    function NodesEditor($source,$dest,$perm) {
		if ($source->isError OR $dest->isError) {
		    $this->isError = true;
		    return;
		}
		$this->permissions = $perm;
		/////////////////////////////
		// Actions
		/////////////////////////////

		// Cancel
		if (isset($_POST['ne_cancel'])) {
		    unset($GLOBALS['_POST']);
		}

		// Move
		elseif (isset($_POST['ne_move'])) {
			//To be valid : canwrite on destination and source
		    if (is_array($_POST['selection'])) {
				foreach ($_POST['selection'] as $id) {
					//canwrite on source
					$this->hasPermission = $this->permissions->canWriteNode();
					if($this->hasPermission == 1){
						//canwrite on destination
						$destPermission = new Permissions($dest->getID());
						$this->hasPermission = $destPermission->canWriteNode();
						if($this->hasPermission == 0){
							break;
						}
					}else{
						break;
					}
				}
		    	if($this->hasPermission == 0){
					$this->errors[] = getMessage('no_permission_to_move_node');
		    	}else{
					foreach ($_POST['selection'] as $id) {
					    $node = new Node($id);
					    if ($node->isError()) $this->errors[] = $node->lastError()." : id=".$id;
					    elseif (!$node->setParent($dest->getID())) {
							$this->errors[] = $node->lastError()." : id=".$id;
					    }else{
					    	logAdminAccess(array("MOVE NODE","SOURCE : ".$id,"DESTINATION : ".$dest->getID()));
					    }
					}
		    	}
		    }
		}

		// Delete
		elseif (isset($_POST['ne_delete'])) {
		    if (is_array($_POST['selection'])) {
		    	//To be valid : canwrite on source
		    	foreach ($_POST['selection'] as $id) {
		    		$this->hasPermission = $this->permissions->canWriteNode();
					if($this->hasPermission == 0){
						break;
					}
				}
		    	if($this->hasPermission == 0){
					$this->errors[] = getMessage('no_permission_to_delete_node').$id;
		    	}else{
					foreach ($_POST['selection'] as $id) {
					    $node = new Node($id);
					    if ($node->isError()) $this->errors[] = $node->lastError()." : id=".$id;
					    elseif (!$node->delete()) {
							$this->errors[] = $node->lastError();
					    }else{
					    	logAdminAccess(array("DELETE NODE","NODE_ID : ".$id));
					    }
					}
		    	}
		    }
		}
		// Rename
		elseif (isset($_POST['ne_change_name'])) {
			$this->hasPermission = $this->permissions->canWriteNode();
			if($this->hasPermission==1){
			    if (!$source->setName($_POST['ne_node_name'])) {
					$this->errors[] = $source->lastError();
		    	}else{
					logAdminAccess(array("RENAME NODE","NODE_ID : ".$source->getID()));
				}
			}else{
				//if we don't have the permission to write
				$this->errors[] = getMessage('no_permission_to_write_node').$source->getID();
				$_POST['ne_node_name'] = $source->getName();
			}
		}

		//edit create child form - check permission
		if (isset($_POST['ne_new_child']) || isset($_POST['ne_new_hwgroup'])) {
			$this->hasPermission = $this->permissions->canAddNode();
			if($this->hasPermission==0){
				$this->errors[] = getMessage('no_permission_to_add_node').$source->getID();
				unset($_POST['ne_new_child']);
			}
		}
		// Create child
		elseif (isset($_POST['ne_create_child'])) {
			$this->hasPermission = $this->permissions->canAddNode();
			if($this->hasPermission==1){
				//Add node
				if(isset($_POST['ne_new_node_action'])){
				    if (!$source->createChildNode($_POST['ne_new_node_name'])) {
						$this->errors[] = $source->lastError();
						$_POST['ne_new_child'] = true;
				    }else{
						logAdminAccess(array("CREATE CHILD NODE","NODE_ID : ".$source->getID(),"NODE_NAME : ".$_POST['ne_new_node_name']));
					}
					unset($_POST['ne_new_node_name']);
				//Add hwgroup
				}else if(isset($_POST['ne_new_hwgroup_action'])){
				    if (!$source->createChildHWGroup($_POST['ne_new_node_name'])) {
						$this->errors[] = $source->lastError();
						$_POST['ne_new_child'] = true;
				    }else{
						logAdminAccess(array("CREATE CHILD NODE","NODE_ID : ".$source->getID(),"NODE_NAME : ".$_POST['ne_new_node_name']));
					}
					unset($_POST['ne_new_hwgroup_action']);
				}
			}else{
				$this->errors[] = getMessage('no_permission_to_add_node').$source->getID();
			}
		}

		$this->source = $source;
		$this->dest = $dest;
		$this->childrens = $source->getChildrens();
		if (!isset($_POST['ne_node_name'])) $_POST['ne_node_name'] = $source->getName();
	    }

	    /**
	    * Print errors
	    *
	    * @access public
	    */
	    function printErrors() {
			if (isset($this->errors[0])) print "<p>\n";
			else return;
			foreach ($this->errors as $error) {
				print "<font color=\"red\" size=\"-1\">".$error."</font><br>\n";
			}
			print "</p>\n";
	    }

	    /**
	    * Print the browser HTML view
	    *
	    * @access public
	    * @return stdout
	    */
	    function printView() {
		if ($this->isError) {
		    $this->printErrors();
		}
		else {
		    include 'nodesEditorView.php';
		}
	    }
	}
?>


