#if   !defined(__WALLFLYWEIGHT_HPP)
#define  __WALLFLYWEIGHT_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__FLYWEIGHT_HPP)
#include <Flyweight.hpp>
#endif

#if   !defined(__MAPSITE_HPP)
#include <MapSite.hpp>
#endif

DECLARE_CLASS( WallFlyweight );

/**
The WallFlyweight is utilized for scale. Because the high
probability that rooms will have more walls than doors we
can represent all walls with a single flyweight. 
*/

class WallFlyweight : public MapSite, public CORELINUX( Flyweight )
   
{
public:

   //
   // Constructors and destructor
   //

                        /// Default constructor

                        WallFlyweight( void );

                        /// Copy constructor

                        WallFlyweight( WallFlyweightCref );

                        /// Virtual Destructor

   virtual              ~WallFlyweight( void );

   //
   // Operator overloads
   //

            /// Assignment operator

            WallFlyweightRef   operator=( WallFlyweightCref );

            /// Equality operator

            bool  operator==( WallFlyweightCref ) const;

   //
   // Operations declared in our type that we
   // are a flyweight representation
   //

            /// Operation defined in MapSite

   virtual  void        enter( void );

};

#endif // if   !defined(__WALLFLYWEIGHT_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/04/21 02:38:47 $
   $Locker:  $
*/

