//start of LhaHeader.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * LhaHeader.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import java.io.File;
import java.io.InputStream;
import java.io.ByteArrayOutputStream;
import java.util.Date;
import java.util.Vector;
import java.util.Hashtable;
import java.util.Properties;
import java.lang.Cloneable;
import jp.gr.java_conf.dangan.io.LittleEndian;
import jp.gr.java_conf.dangan.util.MsdosDate;
import jp.gr.java_conf.dangan.util.lha.CRC16;
import jp.gr.java_conf.dangan.util.lha.LhaProperty;
import jp.gr.java_conf.dangan.util.lha.LhaChecksum;
import jp.gr.java_conf.dangan.util.lha.CompressMethod;

//import exceptions
import java.io.IOException;
import java.io.EOFException;
import java.io.UnsupportedEncodingException;
import java.lang.NullPointerException;
import java.lang.IllegalStateException;
import java.lang.IllegalArgumentException;
import java.lang.CloneNotSupportedException;
import java.lang.ArrayIndexOutOfBoundsException;

import java.lang.Error;


/**
 * LHAwb_B<br>
 * ̃NX java.util.zip pbP[Wł ZipEntry Ƌ߂A
 * wb_̓o͂̂߂̃[eBeB֐_ႤB<br>
 * ̃NX setn\bhňׂꂽǂ`FbN
 * getBytes() ɍs悤ɏĂB̓_͒ӂ邱ƁB<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: LhaHeader.java,v $
 * Revision 1.2.2.3  2005/05/03 07:50:30  dangan
 * [bug fix]
 *     exportLevel1Header()  skip size ̃`FbNĂȂB
 *
 * Revision 1.2.2.2  2005/02/02 00:57:46  dangan
 * [bug fix]
 *     importLevelXHeader(byte[], String) Ńt@CTCY int œǂݍł
 *     31rbglȏ̃TCỸt@C𐳂ĂȂ̂CB
 *
 * Revision 1.2.2.1  2003/07/20 13:19:21  dangan
 * [bug fix]
 *     exportDirNameExtHeader(String)  System.arraycopy  src  dest ̔zuԈĂB
 *
 * Revision 1.2  2002/12/08 00:00:00  dangan
 * [maintenance]
 *     LhaConstants  CompressMethod ւ̃NX̕ύXɍ킹ďCB
 *
 * Revision 1.1  2002/12/05 00:00:00  dangan
 * [improvement]
 *     64rbgt@CTCYwb_ɑΉB
 * [change]
 *     LhaUtil.DefaultEncoding  LhaProperty.encoding gp悤ɕύXB
 *     getNextHeaderData()  getFirstHeaderData() ɖOύXB
 *     V getNextHeaderData() ͌Ăяoꂽʒu
 *     wb_𔭌łȂꍇ null ԂB
 *     LhaHeader gTuNXgpl̂߂ createInstance() ǉB
 *
 * Revision 1.0  2002/08/05 00:00:00  dangan
 * add to version control
 * [bug fix]
 *     setDate( null ) ĂB
 *     setCompressMethod( null ) ĂB
 *     exportLevel2,3Header 
 *     Date  32bit  time_t ͈̔͊O̒l(̒l܂)̏ꍇĂB
 * [change]
 *     exportHeader  wb_x 0,1,2,3 ̂łȂꍇ
 *     IllegalStateException 𓊂悤ɕύXB
 * [maintenance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.2.2.3 $
 */
public class LhaHeader implements Cloneable{

    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  public static final int UNKNOWN
    //  public static final int NO_CRC
    //------------------------------------------------------------------
    /**
     * sӖlB
     * LhaHeader.getCRC(), LhaHeader.getCompressedSize(), 
     * LhaHeader.getOriginalSzie() ̒lԂꍇ
     * Ô߂ɁA̒lsł鎖B
     */
    public static final int UNKNOWN = -1;

    /**
     * CRClӖlB
     * x0wb_CRCl݂ȂӖB
     */
    public static final int NO_CRC = -2;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  file information
    //------------------------------------------------------------------
    //  private long OriginalSize
    //  private Date LastModified
    //  private String Path
    //  private int CRC
    //------------------------------------------------------------------
    /**
     * kOTCYB
     * -1 ͏Ô߃TCYsł邱ƂӖB
     */
    private long OriginalSize;

    /**
     * ŏIXVB
     * kt@C̍ŏIXVB
     */
    private Date LastModified;

    /**
     * pXB
     * pXf~^ɂ java.io.File.separator gpB
     */
    private String Path;

    /**
     * CRC16 ̒lB
     * -1  Ô߂CRC16lsł鎖ӖB
     * -2  x0wb_CRC16lӖB
     */
    private int CRC;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  information of compressed data
    //------------------------------------------------------------------
    //  private String Method
    //  private long CompressedSize
    //  private int HeaderLevel
    //  private byte OSID
    //------------------------------------------------------------------
    /** 
     * k@B 
     */
    private String Method;

    /**
     * kTCYB
     * -1 ͏Ô߃TCYsł邱ƂӖB
     */
    private long CompressedSize;

    /**
     * wb_xB
     * 0,1,2,3̉ꂩ
     */
    private int HeaderLevel;

    /**
     * wb_쐬 OSB
     */
    private byte OSID;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  private byte[] ExtraData
    //  private byte Level0DosAttribute
    //  private Vector ExtraExtHeaders
    //------------------------------------------------------------------
    /**
     * x0wb_ x1wb_̊{wb_
     * g񂪂ꍇAۑB
     */
    private byte[] ExtraData;

    /**
     * x0wb_ɂ DOS̃t@CۑB
     */
    private byte Level0DosAttribute;

    /**
     * LhaHeaderł͓ǂݍ܂Ȃgwb_ۑB
     */
    private Vector ExtraExtHeaders;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private LhaHeader()
    //  public LhaHeader( String path )
    //  public LhaHeader( String path, Date date )
    //  public LhaHeader( byte[] HeaderData )
    //  public LhaHeader( byte[] HeaderData, String encode )
    //------------------------------------------------------------------
    /**
     * LhaHeader̊elB
     */
    private LhaHeader(){
        this.Method             = CompressMethod.LH5;
        this.OriginalSize       = LhaHeader.UNKNOWN;
        this.CompressedSize     = LhaHeader.UNKNOWN;
        this.LastModified       = null;
        this.HeaderLevel        = 2;
        this.Path               = "";
        this.CRC                = LhaHeader.UNKNOWN;
        this.OSID               = (byte)'J';
        this.ExtraData          = null;
        this.Level0DosAttribute = 0x20;
        this.ExtraExtHeaders    = null;
    }

    /**
     * path ƂO LhaHeader ̃CX^X𐶐B<br>
     * pXf~^ɂ File.separator gp邱ƁB<br>
     * path  pXf~^Ń^[~l[gĂꍇ 
     * fBNgłƉ߂B<br>
     * 
     * @param path pX
     * 
     * @exception IllgelArgumentException
     *             path  null  󕶎̂ꂩłꍇ
     */
    public LhaHeader( String path ){
        this( path, new Date( System.currentTimeMillis() ) );
    }

    /**
     * path ƂOAŏIXV date 
     *  LhaHeader ̃CX^X𐶐B<br>
     * pXf~^ɂ File.separator gp邱ƁB<br>
     * path  pXf~^Ń^[~l[gĂꍇ 
     * fBNgłƉ߂B<br>
     * 
     * @param path pX
     * @param date ŏIXV
     *
     * @exception IllgelArgumentException
     *             path  null  󕶎̂ꂩł邩A
     *             date  nullłꍇB
     */
    public LhaHeader( String path, Date date ){
        this();
        if( path != null && !path.equals( "" ) && date != null ){
            if( path.endsWith( File.separator ) ){
                this.Method = CompressMethod.LHD;
            }

            this.Path         = path;
            this.LastModified = date;
        }else if( path == null ){
            throw new NullPointerException( "path" );
        }else if( path.equals( "" ) ){
            throw new IllegalArgumentException( "path must not be empty." );
        }else{
            throw new NullPointerException( "date" );
        }
    }

    /**
     * wb_f[^ V LhaHeader 
     * CX^X𐶐B<br>
     * GR[h LhaUtil.DefaultEncode gpB<br>
     * 
     * @param HeaderData wb_f[^
     * 
     * @exception IndexOutOfBoundsException
     *                   wb_f[^Ă邽
     *                   f[^Ɖ肵ʒu
     *                   HeaderData ͈̔͊OɂȂ
     * @exception IllegalArgumentException
     *                   wb_x 0,1,2,3 ̉łȂA
     *                   HeaderData  null ̏ꍇ
     */
    public LhaHeader( byte[] HeaderData ){
        this();
        if( HeaderData != null ){
            try{
                this.importHeader( HeaderData, LhaProperty.encoding );
            }catch( UnsupportedEncodingException exception ){
                throw new Error( "Java Runtime Environment not support " + LhaProperty.encoding + " encoding" );
            }
        }else{
            throw new NullPointerException( "HeaderData" );
        }
    }

    /**
     * wb_f[^ V LhaHeader 
     * CX^X𐶐B<br>
     * 
     * @param HeaderData wb_f[^
     * @param encode     ߂ۂɎgp
     *                   GR[h
     * 
     * @exception IndexOutOfBoundsException
     *                   wb_f[^Ă邽
     *                   f[^Ɖ肵ʒu
     *                   HeaderData ͈̔͊OɂȂ
     * @exception UnsupportedEncodingException
     *                   encode Ŏw肳ꂽGR[h
     *                   T|[gȂꍇ
     * @exception IllegalArgumentException
     *                   wb_x 0,1,2,3 ̉łȂA
     *                   HeaderData  null ̏ꍇ
     */
    public LhaHeader( byte[] HeaderData, String encode )
                                        throws UnsupportedEncodingException {
        this();
        if( HeaderData != null && encode != null ){
            this.importHeader( HeaderData, encode );                            //throw UnsupportedEncodingException
        }else if( HeaderData == null ){
            throw new NullPointerException( "HeaderData" );
        }else{
            throw new NullPointerException( "encode" );
        }
    }


    //------------------------------------------------------------------
    //  method of java.lang.Cloneable
    //------------------------------------------------------------------
    //  public Object clone()
    //------------------------------------------------------------------
    /**
     * ̃IuWFNg̃Rs[쐬ĕԂB<br>
     * 
     * @return ̃IuWFNg̃Rs[
     */
    public Object clone(){
        try{
            return super.clone();
        }catch( CloneNotSupportedException exception ){ //Ignore
            throw new Error( "java.lang.Object is not support clone()." );
        }
    }


    //------------------------------------------------------------------
    //  access method
    //------------------------------------------------------------------
    //  getter
    //------------------------------------------------------------------
    //  public String getCompressMethod()
    //  public long getOriginalSize()
    //  public long getCompressedSize()
    //  public Date getLastModified()
    //  public int getHeaderLevel()
    //  public String getPath()
    //  public int getCRC()
    //  public byte getOSID()
    //  protected byte[] getExtraData()
    //  protected byte getLevel0DosAttribute()
    //  private String getFileName()
    //  private String getDirName()
    //------------------------------------------------------------------
    /**
     * f[^k@ʂ镶𓾂B<br>
     * 
     * @return k@
     */
    public String getCompressMethod(){
        return this.Method;
    }

    /**
     * f[^̈kÕTCY𓾂B<br>
     * 
     * @return kÕTCY<br>
     *         LhaHeader( String path ) ܂
     *         LhaHeader( String path, Date date )Őꂽ
     *         CX^X͏Ԃł̓TCYŝ 
     *         LhaHeader.UNKNOWN( -1 ) ԂB<br>
     *
     * @see LhaHeader#UNKNOWN
     */
    public long getOriginalSize(){
        return this.OriginalSize;
    }

    /**
     * f[^̈k̃TCY𓾂B<br>
     * 
     * @return k̃TCY<br>
     *         LhaHeader( String path ) ܂
     *         LhaHeader( String path, Date date )Őꂽ
     *         CX^X͏Ԃł̓TCYŝ 
     *         LhaHeader.UNKNOWN( -1 ) ԂB<br>
     *
     * @see LhaHeader#UNKNOWN
     */
    public long getCompressedSize(){
        return this.CompressedSize;
    }

    /**
     * f[^̍ŏIXV𓾂B<br>
     * 
     * @return f[^̍ŏIXV
     */
    public Date getLastModified(){
        return new Date( this.LastModified.getTime() );
    }

    /**
     * ̃wb_̃wb_x𓾂B<br>
     * 
     * @return wb_x
     */
    public int getHeaderLevel(){
        return this.HeaderLevel;
    }

    /**
     * f[^̖OA
     * ̓f[^t@Cłꍇ̃pX𓾂B<br>
     * pXƂ͂ĂAWindows n A: ̂悤
     * hCu܂ł͂ȂȂB<br>
     * pXf~^ɂ File.separator gpB
     * 
     * @return f[^̖OA pXB
     *
     * @see File#separator
     */
    public String getPath(){
        return this.Path;
    }

    /**
     * f[^CRC16l𓾂B<br>
     * 
     * @return f[^CRC16l<br>
     *         LhaHeader( String path ) ܂
     *         LhaHeader( String path, Date date )Őꂽ
     *         CX^X͏ԂłCRCŝ 
     *         LhaHeader.UNKNOWN( -1 ) ԂB<br>
     *         x0wb_CRC16l
     *         tB[hꍇ 
     *         LhaHeader.NO_CRC( -2 )Ԃ<br>
     *
     * @see LhaHeader#UNKNOWN
     * @see LhaHeader#NO_CRC
     */
    public int getCRC(){
        return this.CRC;
    }

    /**
     * ̃wb_쐬 OS ̎ʎq𓾂B
     * 
     * @return OS̎ʎq
     */
    public byte getOSID(){
        return this.OSID;
    }

    /**
     * x 0 wb_A x 1 wb_̎
     * t\{wb_̊gf[^𓾂B
     * 
     * @return gf[^
     */
    protected byte[] getExtraData(){
        return (byte[])this.ExtraData.clone();
    }

    /**
     * x 0 wb_ɋL
     * DOS ̃t@C𓾂B
     * 
     * @return DOS  t@C
     */
    protected byte getLevel0DosAttribute(){
        return this.Level0DosAttribute;
    }

    /**
     * pX؂蕪ꂽt@C𓾂B
     * 
     * @return t@C
     */
    private String getFileName(){
        return this.Path.substring( 
                    this.Path.lastIndexOf( File.separatorChar ) + 1 );
    }

    /**
     * pX؂蕪ꂽfBNg𓾂B
     * 
     * @return fBNg
     */
    private String getDirName(){
        return this.Path.substring( 0,
                    this.Path.lastIndexOf( File.separatorChar ) + 1 );
    }

    /**
     * LhaHeader̃f[^gp wb_f[^𐶐A
     * oCgž`œB<br>
     * GR[h̓ftHĝ̂gpB
     * 
     * @return oCgzɊi[wb_f[^
     *
     * @exception IllegalStateException <br>
     *                <ol>
     *                   <li>k@encodeŃoCgz
     *                       ̂ 5byteŖꍇ
     *                   <li>x0,1,2 t@C邽
     *                       wb_Ɏ܂肫ȂB
     *                   <li>x1,2ŋʊgwb_傫ďo͂łȂB
     *                       ̂߃wb_CRCi[ꏊB
     *                   <li>x0ȊO CRC  x0wb_ 
     *                       CRC񂪖ʂȒlł 
     *                       LhaHeader.NO_CRC( -2 ) ݒ肳ĂB
     *                   <li>x0,1̎LastModifiedMS-DOS`
     *                       ŕ\łȂ͈͂̎Ԃłꍇ
     *                   <li>x2,3̎LastModified4oCg
     *                       time_tŕ\łȂ͈͂̎Ԃłꍇ
     *                   <li>OriginalSize ɃTCYsł鎖
     *                       ʂȒlł LhaHeader.UNKNOWN( -1 )ݒ肳ĂB
     *                   <li>OriginalSize lłꍇ
     *                   <li>x0,1,3 ̎ OriginalSize 
     *                       4bytelŕ\łȂlłꍇ
     *                   <li>CompressedSize ɃTCYsł鎖
     *                       ʂȒlł LhaHeader.UNKNOWN( -1 )ݒ肳ĂB
     *                   <li>CompressedSize lłꍇ
     *                   <li>x0,1,3 ̎ CompressedSize 
     *                       4bytelŕ\łȂlłꍇ
     *                   <li>x2̎OriginalSize ܂ CompressedSize
     *                       4oCgl𒴂邽߃t@CTCYwb_Kvȍۂ
     *                       ̊gwb_傫ăt@CTCYwb_o͏oȂꍇB
     *                   <li>CRC CRC16lsł鎖
     *                       ʂȒlł LhaHeader.UNKNOWN( -1 )ݒ肳ĂB
     *                   <li>wb_x 0,1,2,3 ȊOłꍇ
     *                 </ol>
     *                 ̉ꂩB
     */
    public byte[] getBytes(){
        try{
            return this.exportHeader( LhaProperty.encoding );
        }catch( UnsupportedEncodingException exception ){
            throw new Error( "Java Runtime Environment not support " + LhaProperty.encoding + " encoding" );
        }
    }

    /**
     * LhaHeader̃f[^gp wb_f[^𐶐A
     * oCgž`œB<br>
     * 
     * @param encode o͂ۂɎgp
     *               GR[h
     * 
     * @return oCgzɊi[wb_f[^
     * 
     * @exception IllegalStateException
     *                <ol>
     *                   <li>k@encodeŃoCgz
     *                       ̂ 5byteŖꍇ
     *                   <li>x0,1,2 t@C邽
     *                       wb_Ɏ܂肫ȂB
     *                   <li>x1,2ŋʊgwb_傫ďo͂łȂB
     *                       ̂߃wb_CRCi[ꏊB
     *                   <li>x0ȊO CRC  x0wb_ 
     *                       CRC񂪖ʂȒlł 
     *                       LhaHeader.NO_CRC( -2 ) ݒ肳ĂB
     *                   <li>x0,1̎LastModifiedMS-DOS`
     *                       ŕ\łȂ͈͂̎Ԃłꍇ
     *                   <li>x2,3̎LastModified4oCg
     *                       time_tŕ\łȂ͈͂̎Ԃłꍇ
     *                   <li>OriginalSize ɃTCYsł鎖
     *                       ʂȒlł LhaHeader.UNKNOWN( -1 )ݒ肳ĂB
     *                   <li>OriginalSize lłꍇ
     *                   <li>x0,1,3 ̎ OriginalSize 
     *                       4bytelŕ\łȂlłꍇ
     *                   <li>CompressedSize ɃTCYsł鎖
     *                       ʂȒlł LhaHeader.UNKNOWN( -1 )ݒ肳ĂB
     *                   <li>CompressedSize lłꍇ
     *                   <li>x0,1,3 ̎ CompressedSize 
     *                       4bytelŕ\łȂlłꍇ
     *                   <li>x2̎OriginalSize ܂ CompressedSize
     *                       4oCgl𒴂邽߃t@CTCYwb_Kvȍۂ
     *                       ̊gwb_傫ăt@CTCYwb_o͏oȂꍇB
     *                   <li>CRC CRC16lsł鎖
     *                       ʂȒlł LhaHeader.UNKNOWN( -1 )ݒ肳ĂB
     *                   <li>wb_x 0,1,2,3 ȊOłꍇ
     *                 </ol>
     *                 ̉ꂩB
     * @exception UnsupportedEncodingException
     *                   encode Ŏw肳ꂽGR[h
     *                   T|[gȂꍇ
     */
    public byte[] getBytes( String encode ) 
                                           throws UnsupportedEncodingException {
        return this.exportHeader( encode );                                     //throw UnsupportedEncodingException
    }

    //------------------------------------------------------------------
    //  access method
    //------------------------------------------------------------------
    //  setter
    //------------------------------------------------------------------
    //  public void setCompressMethod( String method )
    //  public void setOriginalSize( long size )
    //  public void setCompressedSize( long size )
    //  public void setLastModified( Date date )
    //  public void setHeaderLevel( int level )
    //  public void setPath( String path )
    //  public void setCRC( int crc )
    //  public void setOSID( byte id )
    //  protected void setExtraData( byte[] data )
    //  protected void setLevel0DosAttribute( byte attribute )
    //  private void setFileName( String filename )
    //  private void setDirName( String dirname )
    //------------------------------------------------------------------
    /**
     * k@ݒ肷B
     * 
     * @param method k@
     * 
     * @exception IllegalArgumentException
     *               k@ '-' Ŏn܂ĂȂA
     *               '-' ŏIĂȂꍇB
     */
    public void setCompressMethod( String method ){
        if( method == null ){
            throw new NullPointerException( "method" );
        }else if( !method.startsWith( "-" ) || !method.endsWith( "-" ) ){
            throw new IllegalArgumentException( "method must starts with \'-\' and ends with \'-\'" );
        }else{
            this.Method = method;
        }
    }

    /**
     * kOf[^TCYݒ肷B<br>
     * LhaHeader.UNKNOWN( -1 )  TCYs
     * ʂȐł邽ߐݒłȂB<br>
     * ܂ x0,1,3 ł͏ł̂ 4oCgl݂̂ł邽 
     * 4oCgŕ\łȂlݒ肵ꍇ getByte() ɗO𓊂B<br>
     * 
     * @param size kOf[^TCY
     * 
     * @exception IllegalArgumentException
     *             size  LhaHeader.UNKNOWN( -1 )ݒ肵悤Ƃꍇ
     * 
     * @see LhaHeader#UNKNOWN
     */
    public void setOriginalSize( long size ){
        if( size != LhaHeader.UNKNOWN ){
            this.OriginalSize = size;
        }else{
            throw new IllegalArgumentException( "size must not LhaHeader.UNKNOWN( " + LhaHeader.UNKNOWN + " )" );
        }
    }

    /**
     * kf[^TCYݒ肷B<br>
     * LhaHeader.UNKNOWN( -1 )  TCYs
     * ʂȐł邽ߐݒłȂB<br>
     * ܂ x0,1,3 ł͏ł̂ 4oCgl݂̂ł邽 
     * 4oCgŕ\łȂlݒ肵ꍇ getByte() ɗO𓊂B<br>
     * 
     * @param size kf[^TCY
     *
     * @exception IllegalArgumentException
     *             size  LhaHeader.UNKNOWN ݒ肵悤Ƃ
     * 
     * @see LhaHeader#UNKNOWN
     */
    public void setCompressedSize( long size ){
        if( size != LhaHeader.UNKNOWN ){
            this.CompressedSize = size;
        }else{
            throw new IllegalArgumentException( "size must not LhaHeader.UNKNOWN( " + LhaHeader.UNKNOWN + " )" );
        }
    }

    /**
     * kf[^̍ŏIXVݒ肷B<br>
     * wb_x 0,1 ̏ꍇ MsdosDateŕ\͈͓A
     * wb_x 2,3 ̏ꍇ 4byte  time_tŕ\͈͓
     * ̓tŖ΂ȂȂB<br>
     * ͈͓łȂĂ ̃\bh͗O𓊂ȂƂɒӂ
     * 邱ƁB͈͓ɖꍇ ̃\bh͗O𓊂ȂA
     * getBytes() ɗO𓊂B<br>
     * 
     * @param date ŏIXV
     * 
     * @exception IllegalArgumentException
     *               date  null ݒ肵悤Ƃꍇ
     */
    public void setLastModified( Date date ){
        if( date != null ){
            this.LastModified = date;
        }else{
            throw new NullPointerException( "date" );
        }
    }

    /**
     * wb_xݒ肷B<br>
     * ݐݒł̂ 0,1,2,3 ݂̂ƂȂĂB<br>
     * wb_x̕ύX̓pX̍ő咷ALastModified ͈̐
     * Ȃǂω邽ߒӂKvłB<br>
     * 
     * @param level wb_x
     */
    public void setHeaderLevel( int level ){
        this.HeaderLevel = level;
    }

    /**
     * f[^̖OA̓f[^t@CłꍇA
     * f[^̃pXݒ肷B<br>
     * pXf~^ɂ File.separator gpB<br>
     * wb_xɂ path ɂ̓oCg݂̐邪A
     * ̃\bh͐zꍇł O𓊂ȂƂ
     * ӁBzꍇ ̃\bh͗O𓊂ȂA
     * getBytes()ɗO𓊂<br>
     * 
     * @param path f[^̖OA̓t@C
     *
     * @exception IllegalArgumentException
     *              path 󕶎łꍇ
     * 
     * @see File#separator
     */
    public void setPath( String path ){
        if( path == null ){
            throw new NullPointerException( "path" );
        }else if( path.equals( "" ) ){
            throw new IllegalArgumentException( "path must not empty." );
        }else{
            this.Path = path;
        }
    }

    /**
     * kÕf[^ CRC16lݒ肷B<br>
     * LhaHeader.UNKNOWN( -1 )  TCYs
     * ʂȐł邽ߐݒłȂB<br>
     * LhaHeader.NO_CRC( -2 )  x0wb_̏
     *  CRClo͂ȂƂӖʂȒl
     * łB<br> 
     * ̃wb_x̎ LhaHeader.NO_CRC( -2 )
     * ݒ肵ĂO𓊂Ȃ getBytes() 
     * O𓊂̂Œӂ邱ƁB<br>
     * LȂ͉̂2oCgŁA2oCg͖B<br>
     * 
     * @param crc f[^̈kOCRC16l
     * 
     * @exception IllegalArgumentException
     *             crc  LhaHeader.UNKNOWN ݒ肵悤Ƃ
     * 
     * @see LhaHeader#UNKNOWN
     * @see LhaHeader#NO_CRC
     */
    public void setCRC( int crc ){
        if( crc != LhaHeader.UNKNOWN ){
            this.CRC = crc;
        }else{
            throw new IllegalArgumentException( "crc must not LhaHeader.UNKNOWN( " + LhaHeader.UNKNOWN + " )" );
        }
    }

    /**
     * ̃wb_OSŗL̏񂪊܂܂ꍇA
     * ̃f[^߂肪Ƃ OS̎ʎqݒ肷B<br>
     * 
     * @param id OSʎq
     */
    public void setOSID( byte id ){
        this.OSID = id;
    }

    /**
     * x 0,1wb_Ɏgp {wb_
     * gݒ肷B<br>
     * g̃oCgɂ݂͐邪Ã\bh
     * zĂO𓊂ȂƂɒӁBzꍇ
     * getBytes()ɗO𓊂B<br>
     * 
     * @param data g
     *             go͂Ȃꍇ nullݒ肷B
     */
    protected void setExtraData( byte[] data ){
        this.ExtraData = data;
    }

    /**
     * x 0wb_̏ꍇɏo͂A
     * MS-DOS ̃t@Cݒ肷B
     * 
     * @param attribute MS-DOS̃t@C
     */
    protected void setLevel0DosAttribute( byte attribute ){
        this.Level0DosAttribute = attribute;
    }

    /**
     * filename Ŏw肳t@CpXɐݒ肷B
     * 
     * @param filename t@C
     */
    private void setFileName( String filename ){
        this.Path = this.getDirName() + filename;
    }

    /**
     * dirname Ŏw肳 fBNgpXɐݒ肷B
     * 
     * @param dirname fBNg
     */
    private void setDirName( String dirname ){
        this.Path = dirname + this.getFileName();
    }

    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  import base header
    //------------------------------------------------------------------
    //  private void importLevel0Header( byte[] HeaderData, String encode )
    //  private void importLevel1Header( byte[] HeaderData, String encode )
    //  private void importLevel2Header( byte[] HeaderData, String encode )
    //  private void importLevel3Header( byte[] HeaderData, String encode )
    //  private void importHeader( byte[] HeaderData, String encode )
    //------------------------------------------------------------------
    /**
     * HeaderDatax0wb_̃f[^Ƃĉ߂A
     * LhaHeaderɒlݒ肷B
     * 
     * @param HeaderData wb_f[^
     * @param encode     ߂ۂɎgp
     *                   GR[h
     * 
     * @exception UnsupportedEncodingException
     *                   encode Ŏw肳ꂽGR[h
     *                   T|[gȂꍇ
     */
    private void importLevel0Header( byte[] HeaderData, String encode )
                                        throws UnsupportedEncodingException {

        //------------------------------------------------------------------
        //  wb_f[^ʒu̒`
        final int HeaderSizeIndex     =  0;
        final int HeaderSize          = ( HeaderData[ HeaderSizeIndex ] & 0xFF ) + 2;
        final int CompressMethodIndex =  2;
        final int CompressedSizeIndex =  7;
        final int OriginalSizeIndex   = 11;
        final int LastModifiedIndex   = 15;
        final int DosAttributeIndex   = 19;
        final int HeaderLevelIndex    = 20;
        final int PathLengthIndex     = 21;
        final int PathLength          = HeaderData[ PathLengthIndex ] & 0xFF;
        final int PathIndex           = 22;
        final int CRCIndex            = 22 + PathLength;
        final int ExtraDataIndex      = 24 + PathLength;
        final int ExtraDataLength     = HeaderSize - ExtraDataIndex;

        //------------------------------------------------------------------
        //  wb_f[^ǂݍ
        this.Method = new String( HeaderData, CompressMethodIndex, 5, encode );//After Java 1.1 throw UnsupportedEncodingException
        this.CompressedSize = ((long)LittleEndian.readInt( HeaderData, CompressedSizeIndex )) & 0xFFFFFFFFL;
        this.OriginalSize   = ((long)LittleEndian.readInt( HeaderData, OriginalSizeIndex )) & 0xFFFFFFFFL;
        this.LastModified   = new MsdosDate( LittleEndian.readInt( HeaderData, LastModifiedIndex ) );
        this.Level0DosAttribute = HeaderData[ DosAttributeIndex ];
        this.HeaderLevel    = HeaderData[ HeaderLevelIndex ] & 0xFF;
        this.Path           = new String( HeaderData, PathIndex, PathLength, encode );    //After Java 1.1 throw IndexOutOfBoundsException
        this.Path           = this.Path.replace( '\\', File.separatorChar );

        if( CRCIndex + 2 <= HeaderSize ){
            this.CRC = LittleEndian.readShort( HeaderData, CRCIndex );          //throw ArrayIndexOutOfBoundsException
            if( 0 < ExtraDataLength ){
                this.ExtraData = new byte[ExtraDataLength];
                System.arraycopy( HeaderData, ExtraDataIndex,
                                  this.ExtraData, 0, ExtraDataLength );         //throw IndexOutOfBoundsException
            }
        }else{
            this.CRC = LhaHeader.NO_CRC;
        }
    }

    /**
     * HeaderDatax1wb_̃f[^Ƃĉ߂A
     * LhaHeaderɒlݒ肷B
     * 
     * @param HeaderData wb_f[^
     * @param encode     ߂ۂɎgp
     *                   GR[h
     * 
     * @exception UnsupportedEncodingException
     *                   encode Ŏw肳ꂽGR[h
     *                   T|[gȂꍇ
     */
    private void importLevel1Header( byte[] HeaderData, String encode )
                                       throws UnsupportedEncodingException {

        //------------------------------------------------------------------
        //  {wb_f[^ʒu̒`
        final int BaseHeaderSizeIndex =  0;
        final int BaseHeaderSize      = (int)( HeaderData[BaseHeaderSizeIndex] & 0xFF ) + 2;
        final int CompressMethodIndex =  2;
        final int SkipSizeIndex       =  7;
        final int OriginalSizeIndex   = 11;
        final int LastModifiedIndex   = 15;
        final int HeaderLevelIndex    = 20;
        final int FileNameLengthIndex = 21;
        final int FileNameLength      = (int)( HeaderData[FileNameLengthIndex] & 0xFF );
        final int FileNameIndex       = 22;
        final int CRCIndex            = 22 + FileNameLength;
        final int OSIDIndex           = 24 + FileNameLength;
        final int ExtraDataIndex      = 25 + FileNameLength;
        final int ExtraDataLength     = BaseHeaderSize - ExtraDataIndex - 2;

        //------------------------------------------------------------------
        //  {wb_f[^ǂݍ
        this.Method = new String( HeaderData, CompressMethodIndex, 5, encode );//After Java 1.1 throws UnsupportedEncodingException
        this.CompressedSize = ((long)LittleEndian.readInt( HeaderData, SkipSizeIndex )) & 0xFFFFFFFFL;
        this.OriginalSize   = ((long)LittleEndian.readInt( HeaderData, OriginalSizeIndex )) & 0xFFFFFFFFL;
        this.LastModified   = new MsdosDate( LittleEndian.readInt( HeaderData, LastModifiedIndex ) );
        this.HeaderLevel    = HeaderData[ HeaderLevelIndex ] & 0xFF;
        this.Path           = new String( HeaderData, FileNameIndex, FileNameLength, encode );//After Java 1.1 throw IndexOutOfBoundsException
        this.CRC            = LittleEndian.readShort( HeaderData, CRCIndex );   //throw ArrayIndexOutOfBoundsException
        this.OSID           = HeaderData[ OSIDIndex ];                          //throw ArrayIndexOutOfBoundsException
        if( 0 < ExtraDataLength ){
            this.ExtraData = new byte[ExtraDataLength];
            System.arraycopy( HeaderData, ExtraDataIndex, 
                              this.ExtraData, 0, ExtraDataLength );             //throw IndexOutOfBoundsException
        }

        //------------------------------------------------------------------
        //  gwb_f[^̓ǂݍ
        boolean hasFileSize = false;
        int index  = BaseHeaderSize;
        int length = LittleEndian.readShort( HeaderData, index - 2 );           //throw ArrayIndexOutOfBoundsException
        while( length != 0 ){
            if( !hasFileSize ){
                this.CompressedSize -= length;
            }

            this.importExtHeader( HeaderData, index, length - 2, encode );      //throw IndexOutOfBoundsException
            if( HeaderData[ index ] == (byte)0x42 ){
                hasFileSize = true;
            }

            index  += length;
            length = LittleEndian.readShort( HeaderData, index - 2 );           //throw ArrayIndexOutOfBoundsException
        }
    }

    /**
     * HeaderDatax2wb_̃f[^Ƃĉ߂A
     * LhaHeaderɒlݒ肷B
     * 
     * @param HeaderData wb_f[^
     * @param encode     ߂ۂɎgp
     *                   GR[h
     * 
     * @exception UnsupportedEncodingException
     *                   encode Ŏw肳ꂽGR[h
     *                   T|[gȂꍇ
     */
    private void importLevel2Header( byte[] HeaderData, String encode )
                                        throws UnsupportedEncodingException {

        //------------------------------------------------------------------
        //  {wb_f[^ʒu̒`
        final int HeaderSizeIndex     =  0;
        final int HeaderSize          = LittleEndian.readShort( HeaderData, HeaderSizeIndex );
        final int CompressMethodIndex =  2;
        final int CompressedSizeIndex =  7;
        final int OriginalSizeIndex   = 11;
        final int LastModifiedIndex   = 15;
        final int HeaderLevelIndex    = 20;
        final int CRCIndex            = 21;
        final int OSIDIndex           = 23;

        //------------------------------------------------------------------
        //  {wb_f[^ǂݍ
        this.Method = new String( HeaderData, CompressMethodIndex, 5, encode );//After Java 1.1  throw UnsupportedEncodingException
        this.CompressedSize = ((long)LittleEndian.readInt( HeaderData, CompressedSizeIndex )) & 0xFFFFFFFFL;
        this.OriginalSize   = ((long)LittleEndian.readInt( HeaderData, OriginalSizeIndex )) & 0xFFFFFFFFL;
        this.LastModified   = new Date( (long)LittleEndian.readInt( HeaderData, LastModifiedIndex ) * 1000L );
        this.HeaderLevel    = HeaderData[ HeaderLevelIndex ] & 0xFF;
        this.CRC            = LittleEndian.readShort( HeaderData, CRCIndex );   //throw ArrayIndexOutOfBoundsException
        this.OSID           = HeaderData[ OSIDIndex ];                          //throw ArrayIndexOutOfBoundsException

        //------------------------------------------------------------------
        //  gwb_f[^̓ǂݍ
        final int BaseHeaderSize = 26;
        int index  = BaseHeaderSize;
        int length = LittleEndian.readShort( HeaderData, index - 2 );           //throw ArrayIndexOutOfBoundsException
        while( length != 0 ){
            this.importExtHeader( HeaderData, index, length - 2, encode );      //throw IndexOutOfBoundsException
            index  += length;
            length = LittleEndian.readShort( HeaderData, index - 2 );           //throw ArrayIndexOutOfBoundsException
        }
    }

    /**
     * HeaderDatax3wb_̃f[^Ƃĉ߂A
     * LhaHeaderɒlݒ肷B
     * 
     * @param HeaderData wb_f[^
     * @param encode     ߂ۂɎgp
     *                   GR[h
     * 
     * @exception UnsupportedEncodingException
     *                   encode Ŏw肳ꂽGR[h
     *                   T|[gȂꍇ
     */
    private void importLevel3Header( byte[] HeaderData, String encode )
                                        throws UnsupportedEncodingException {

        //------------------------------------------------------------------
        //  {wb_f[^ʒu̒`
        final int WordSizeIndex       =  0;
        final int WordSize            = LittleEndian.readShort( HeaderData, WordSizeIndex );
        final int CompressMethodIndex =  2;
        final int CompressedSizeIndex =  7;
        final int OriginalSizeIndex   = 11;
        final int LastModifiedIndex   = 15;
        final int HeaderLevelIndex    = 20;
        final int CRCIndex            = 21;
        final int OSIDIndex           = 23;

        //------------------------------------------------------------------
        //  {wb_f[^ǂݍ
        this.Method = new String( HeaderData, CompressMethodIndex, 5, encode );//After Java 1.1 throw UnsupportedEncodingException
        this.CompressedSize = ((long)LittleEndian.readInt( HeaderData, CompressedSizeIndex )) & 0xFFFFFFFFL;
        this.OriginalSize   = ((long)LittleEndian.readInt( HeaderData, OriginalSizeIndex )) & 0xFFFFFFFFL;
        this.LastModified   = new Date( (long)LittleEndian.readInt( HeaderData, LastModifiedIndex ) * 1000L );
        this.HeaderLevel    = HeaderData[ HeaderLevelIndex ] & 0xFF;
        this.CRC            = LittleEndian.readShort( HeaderData, CRCIndex );   //throw ArrayIndexOutOfBoundsException
        this.OSID           = HeaderData[ OSIDIndex ];                          //throw ArrayIndexOutOfBoundsException

        //------------------------------------------------------------------
        //  gwb_f[^̓ǂݍ
        final int BaseHeaderSize = 32;
        int index  = BaseHeaderSize;
        int length = LittleEndian.readInt( HeaderData, index - 4 );             //throw ArrayIndexOutOfBoundsException
        while( length != 0 ){
            this.importExtHeader( HeaderData, index, length - 4, encode );      //throw IndexOutOfBoundsException
            index  += length;
            length = LittleEndian.readInt( HeaderData, index - 4 );             //throw ArrayIndexOutOfBoundsException
        }
    }

    /**
     * HeaderData  LHAwb_f[^Ƃĉ߂
     * LhaHeader ɒlݒ肷B
     * 
     * @param HeaderData wb_f[^
     * @param encode     ߂ۂɎgp
     *                   GR[h
     * 
     * @exception IndexOutOfBoundsException
     *                   wb_f[^Ă邽
     *                   f[^Ɖ肵ʒu
     *                   HeaderData ͈̔͊OɂȂ
     * @exception UnsupportedEncodingException
     *                   encode Ŏw肳ꂽGR[h
     *                   T|[gȂꍇ
     * @exception IllegalArgumentException
     *                   wb_x 0,1,2,3 ̉łȂB
     */
    private void importHeader( byte[] HeaderData, String encode )
                                        throws UnsupportedEncodingException {
        final int HeaderLevelIndex = 20;

        switch( HeaderData[HeaderLevelIndex] ){                                 //throws ArrayIndexOutOfBoundsException
        case 0:
            this.importLevel0Header( HeaderData, encode );                      //After Java1.1 throws UnsupporetdEncodingException, InexOutOfBoundsException
            break;
        case 1:
            this.importLevel1Header( HeaderData, encode );                      //After Java1.1 throws UnsupporetdEncodingException, InexOutOfBoundsException
            break;
        case 2:
            this.importLevel2Header( HeaderData, encode );                      //After Java1.1 throws UnsupporetdEncodingException, InexOutOfBoundsException
            break;
        case 3:
            this.importLevel3Header( HeaderData, encode );                      //After Java1.1 throws UnsupporetdEncodingException, InexOutOfBoundsException
            break;

        default:
            throw new IllegalArgumentException( "unknown header level \"" + HeaderData[ HeaderLevelIndex ] + "\"." );
        }
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  import extend header
    //------------------------------------------------------------------
    //  private void importCommonExtHeader( byte[] HeaderData, int index, int length )
    //  private void importFileNameExtHeader( byte[] HeaderData, int index, 
    //                                        int length, String encode )
    //  private void importDirNameExtHeader( byte[] HeaderData, int index, 
    //                                       int length, String encode )
    //  protected void importExtendHeader( byte[] HeaderData, int index, 
    //                                     int length, String encode )
    //  private void importExtHeader( byte[] HeaderData, int index,
    //                                int length, String encode )
    //------------------------------------------------------------------
    /**
     * HeaderData  ʊgwb_ǂݍށB
     * ̃\bh͋ʊgwb_ wb_pCRC16lȊO
     * ̃f[^݂ꍇ ʊgwb_ ExtraExtHeaders 
     * o^邾łB
     * 
     * @param HeaderData wb_f[^
     * @param index      HeaderDatågwb_̊Jnʒu
     * @param length     gwb_̒
     */
    private void importCommonExtHeader( byte[] HeaderData,
                                        int    index,
                                        int    length ){
        //( 3 < length )̔r gwb_ID(1byte)
        //wb_CRC16l(2byte)ȊOɃf[^܂ނ̔B
        //CRC16lȊȌȂ ̏ۑ邽
        //ExtraExtHeadersɓo^B
        if( 3 < length  ){
            if( this.ExtraExtHeaders == null ){
                this.ExtraExtHeaders = new Vector();
            }
            byte[] ExtHeaderData = new byte[length];
            System.arraycopy( HeaderData, index, ExtHeaderData, 0, length );    //throws IndexOutOfBoundsException
            this.ExtraExtHeaders.addElement( ExtHeaderData );
        }
    }

    /**
     * HeaderData  t@Cgwb_ǂݍށB
     * 
     * @param HeaderData wb_f[^
     * @param index      HeaderDatågwb_̊Jnʒu
     * @param length     gwb_̒
     * @param encode     ߂ۂɎgp
     *                   GR[h
     * 
     * @exception UnsupportedEncodingException
     *                   ̗O邱Ƃ͖B
     */
    private void importFileNameExtHeader( byte[] HeaderData,
                                          int    index,
                                          int    length,
                                          String encode )
                                     throws UnsupportedEncodingException {

        this.setFileName( new String( HeaderData, index + 1, length - 1, encode ) );//throws IndexOutOfBoundsException
    }

    /**
     * HeaderData  fBNggwb_ǂݍށB
     * 
     * @param HeaderData wb_f[^
     * @param index      HeaderDatågwb_̊Jnʒu
     * @param length     gwb_̒
     * @param encode     ߂ۂɎgp
     *                   GR[h
     * 
     * @exception UnsupportedEncodingException
     *                   ̗O邱Ƃ͖B
     */
    private void importDirNameExtHeader( byte[] HeaderData,
                                         int    index,
                                         int    length,
                                         String encode )
                                    throws UnsupportedEncodingException {

        final byte LhaFileSeparator = (byte)0xFF;

        int off = 1;
        String dir = "";
        while( off < length ){
            int len = 0;
            while( off + len < length ){
                if( HeaderData[ index + off + len ] != LhaFileSeparator ){
                    len++;
                }else{
                    break;
                }
            }

            if( off + len < length ){
                dir += new String( HeaderData, index + off, len, encode ) + File.separator;
            }else{
                dir += new String( HeaderData, index + off, len, encode );
            }
            off += len + 1;
        }
        
        this.setDirName( dir );
    }

    /**
     * HeaderData  t@CTCYgwb_ǂݍށB
     * 
     * @param HeaderData wb_f[^
     * @param index      HeaderDatågwb_̊Jnʒu
     * @param length     gwb_̒
     */
    private void importFileSizeHeader( byte[] HeaderData,
                                       int index,
                                       int length ){
        if( length == 17 ){
            this.CompressedSize = LittleEndian.readLong( HeaderData, index + 1 );
            this.OriginalSize   = LittleEndian.readLong( HeaderData, index + 9 );
        }else{
        }
    }

    /**
     * gwb_ǂݍށB
     * ̃\bhI[o[Ch鎖ɂ
     * lXȊgwb_ɑΉ邱Ƃ\ƂȂB
     * LhaHeader ł gwb_ private oł
     * ExtraExtHeaders ɓo^邾łB
     * 
     * @param HeaderData wb_f[^
     * @param index      HeaderDatågwb_̊Jnʒu
     * @param length     gwb_̒
     * @param encode     ߂ۂɎgp
     *                   GR[h
     * 
     * @exception UnsupportedEncodingException
     *                   encode Ŏw肳ꂽGR[h
     *                   T|[gȂꍇ
     */
    protected void importExtendHeader( byte[] HeaderData,
                                       int    index,
                                       int    length,
                                       String encode )
                                  throws UnsupportedEncodingException {
        if( this.ExtraExtHeaders == null ){
            this.ExtraExtHeaders = new Vector();
        }
        byte[] ExtHeaderData = new byte[length];
        System.arraycopy( HeaderData, index, ExtHeaderData, 0, length );        //throws IndexOutOfBoundsException
        this.ExtraExtHeaders.addElement( ExtHeaderData );
    }

    /**
     * HeaderData  index ͂܂ length oCg
     * gwb_ǂݍށB
     *
     * @param HeaderData wb_f[^
     * @param index      HeaderDatågwb_̊Jnʒu
     * @param length     gwb_̒
     * @param encode     ߂ۂɎgp
     *                   GR[h
     * 
     * @exception UnsupportedEncodingException
     *                   encode Ŏw肳ꂽGR[h
     *                   T|[gȂꍇ
     */
    private void importExtHeader( byte[] HeaderData,
                                  int    index,
                                  int    length,
                                  String encode )
                             throws UnsupportedEncodingException {
        final int ExtendHeaderIDIndex = 0;

        switch( HeaderData[ index + ExtendHeaderIDIndex ] ){                    //throws ArrayIndexOutOfBoundsException
        case 0x00:
            this.importCommonExtHeader( HeaderData, index, length );            //throws IndexOutOfBoundsException
            break;
        case 0x01:
            this.importFileNameExtHeader( HeaderData, index, length, encode );  //throws IndexOutOfBoundsException
            break;
        case 0x02:
            this.importDirNameExtHeader( HeaderData, index, length, encode );   //throws IndexOutOfBoundsException
            break;
        case 0x42:
            this.importFileSizeHeader( HeaderData, index, length );             //throws IndexOutOfBoundsException
            break;
        default:
            this.importExtendHeader( HeaderData, index, length, encode );       //throws UnsupportedEncodingException IndexOutOfBoundsException
        }
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  export base header
    //------------------------------------------------------------------
    //  private byte[] exportLevel0Header( String encode )
    //  private byte[] exportLevel1Header( String encode )
    //  private byte[] exportLevel2Header( String encode )
    //  private byte[] exportLevel3Header( String encode )
    //  private byte[] exportHeader( String encode )
    //------------------------------------------------------------------
    /**
     *  LhaHeader ̏g
     * x0wb_̃f[^𐶐B<br>
     * ̍ہAExtraData ܂߂ƃwb_TCY
     * KlɎ܂Ȃꍇ ExtraData ͊܂܂ȂƂB
     * 
     * @param encode o͂ۂɎgp
     *               GR[h
     * 
     * @exception IllegalStateException <br>
     *                <ol>
     *                   <li>k@encodeŃoCgz
     *                       ̂ 5byteŖꍇ
     *                   <li>Path 傫邽 x0wb_
     *                       őTCYɎ܂肫ȂB
     *                   <li>LastModifiedMS-DOS`
     *                       \łȂ͈͂̎Ԃłꍇ
     *                   <li>OriginalSize ɃTCYsł鎖
     *                       ʂȒlł LhaHeader.UNKNOWN( -1 )ݒ
     *                       ĂB
     *                   <li>OriginalSize lł邩A
     *                       4bytelŕ\łȂlłꍇ
     *                   <li>CompressedSize ɃTCYsł鎖 
     *                       ʂȒlł LhaHeader.UNKNOWN( -1 )
     *                       ݒ肳ĂB
     *                   <li>CompressedSize lł邩A
     *                       4bytelŕ\łȂlłꍇ
     *                 </ol>
     *                 ̉ꂩ
     * @exception UnsupportedEncodingException
     *                   encode Ŏw肳ꂽGR[h
     *                   T|[gȂꍇ
     */
    private byte[] exportLevel0Header( String encode )
                                  throws UnsupportedEncodingException {

        //------------------------------------------------------------------
        //  wb_o͏
        final int LHarcHeaderSize = 100;
        final int CRCLength       = ( this.CRC == LhaHeader.NO_CRC
                                   || this.CRC == LhaHeader.UNKNOWN ? 0 : 2 );
        byte[]    CompressMethod  = this.Method.getBytes( encode );     //After Java 1.1 throw UnsupportedEncodingException
        MsdosDate dosDate         = null;
        try{
            dosDate               = this.LastModified instanceof MsdosDate 
                                        ? (MsdosDate)this.LastModified
                                        : new MsdosDate( this.LastModified );   //throw IllegalArgumentException
        }catch( IllegalArgumentException exception ){
            throw new IllegalStateException( exception.toString() );
        }
        byte[]    PathData        = this.Path.replace( File.separatorChar, 
                                                      '\\' ).getBytes( encode );//After Java 1.1
        int       HeaderLength    = 22 + CRCLength + PathData.length;
        byte[]    ExtraData;
        if( CRCLength != 0 && this.ExtraData != null 
         && ( HeaderLength + this.ExtraData.length <= LHarcHeaderSize ) ){
            ExtraData = this.ExtraData;
        }else{
            ExtraData = new byte[0];
        }

        HeaderLength += ExtraData.length;

        //------------------------------------------------------------------
        //  wb_`FbN
        if( CompressMethod.length != 5 ){
            throw new IllegalStateException( "CompressMethod doesn't follow Format." );
        }

        if( LHarcHeaderSize < HeaderLength ){
            throw new IllegalStateException( "Header size too large." );
        }

        if( this.CompressedSize == LhaHeader.UNKNOWN ){
            throw new IllegalStateException( "CompressedSize must not be UNKNOWN." );
        }

        if( 0x0000000100000000L <= this.CompressedSize ){
            throw new IllegalStateException( "CompressedSize must be 0xFFFFFFFF or less." );
        }

        if( this.CompressedSize < 0 ){
            throw new IllegalStateException( "CompressedSize must be 0 or more." );
        }

        if( this.OriginalSize == LhaHeader.UNKNOWN ){
            throw new IllegalStateException( "OriginalSize must not be UNKNOWN." );
        }

        if( 0x0000000100000000L <= this.OriginalSize ){
            throw new IllegalStateException( "OriginalSize must be 0xFFFFFFFF or less." );
        }

        if( this.OriginalSize < 0 ){
            throw new IllegalStateException( "OriginalSize must be 0 or more." );
        }        

        //------------------------------------------------------------------
        //  wb_o
        byte[] HeaderData;
        try{
            ByteArrayOutputStream out = new ByteArrayOutputStream();

            //o͂wb_ɂ̓wb_擪 wb_(1byte)A
            //`FbNT(1byte)2byte܂܂Ȃ -2 ĂB
            out.write( HeaderLength - 2 );
            out.write( 0 );
            out.write( CompressMethod );
            LittleEndian.writeInt( out, (int)this.CompressedSize );
            LittleEndian.writeInt( out, (int)this.OriginalSize );
            LittleEndian.writeInt( out, dosDate.getMsdosTime() );
            out.write( this.Level0DosAttribute );
            out.write( this.HeaderLevel );
            out.write( PathData.length );
            out.write( PathData );
            if( this.CRC != -1 ){
                LittleEndian.writeShort( out, this.CRC );
                out.write( ExtraData );
            }
            out.close();
            HeaderData = out.toByteArray();
        }catch( IOException exception ){
            throw new Error( "caught the IOException ( " + exception.getMessage() + " ) which should be never thrown by ByteArrayOutputStream." );
        }

        final int ChecksumIndex = 1;
        HeaderData[ ChecksumIndex ] = (byte)LhaHeader.calcHeaderChecksum( HeaderData );

        return HeaderData;
    }

    /**
     *  LhaHeader ̏g
     * x1wb_̃f[^𐶐B<br>
     * ̍ہAExtraData ܂߂ƃwb_TCY
     * KlɎ܂Ȃꍇ ExtraData ͊܂܂ȂƂB
     * ܂Agwb_ 65534oCgȏ̃TCY
     * ͖̂B
     * 
     * @param encode o͂ۂɎgp
     *               GR[h
     * 
     * @exception IllegalStateException <br>
     *                <ol>
     *                   <li>k@encodeŃoCgz
     *                       ̂ 5byteŖꍇ
     *                   <li>t@C傫邽
     *                       {wb_ɂgwb_ɂ܂肫ȂB
     *                   <li>ʊgwb_傫ďo͂łȂB
     *                       ̂߃wb_CRCi[ꏊB
     *                   <li>CRC  x0wb_ CRC񂪖
     *                       ʂȒlł LhaHeader.NO_CRC( -2 ) ݒ肳ĂB
     *                   <li>LastModifiedMS-DOS`
     *                       \łȂ͈͂̎Ԃłꍇ
     *                   <li>OriginalSize ɃTCYsł鎖
     *                       ʂȒlł LhaHeader.UNKNOWN( -1 )ݒ肳ĂB
     *                   <li>OriginalSize lł邩A
     *                       4bytelŕ\łȂlłꍇ
     *                   <li>CompressedSize ɃTCYsł鎖
     *                       ʂȒlł LhaHeader.UNKNOWN( -1 )ݒ肳ĂB
     *                   <li>CompressedSize lł邩A
     *                       4bytelŕ\łȂlłꍇ
     *                   <li>CRC CRC16lsł鎖 ʂȒl
     *                       ł LhaHeader.UNKNOWN( -1 )ݒ肳ĂB
     *                 </ol>
     *                 ̉ꂩ
     * @exception UnsupportedEncodingException<br>
     *                   encode Ŏw肳ꂽGR[h
     *                   T|[gȂꍇ
     */
    private byte[] exportLevel1Header( String encode )
                                  throws UnsupportedEncodingException {

        //------------------------------------------------------------------
        //  wb_o͏
        final int LHarcHeaderSize = 100;
        boolean   hasFileName     = false; //t@C
        boolean   hasCRC          = false; //wb_CRC
        byte[]    CompressMethod  = this.Method.getBytes( encode );     //After Java 1.1 throw UnsupportedEncodingException
        MsdosDate dosDate;
        try{
            if( this.LastModified instanceof MsdosDate ){
                dosDate = (MsdosDate)this.LastModified;
            }else{
                dosDate = new MsdosDate( this.LastModified );                   //throw IllegalArgumentException
            }
        }catch( IllegalArgumentException exception ){
            throw new IllegalStateException( exception.toString() );
        }

        int HeaderLength = 27;
        byte[]    ExtraData;
        if( this.ExtraData != null && ( HeaderLength + this.ExtraData.length <= LHarcHeaderSize ) ){
            ExtraData = this.ExtraData;
        }else{
            ExtraData = new byte[0];
        }
        HeaderLength += ExtraData.length;

        byte[] FileName = this.getFileName().getBytes( encode );                //After Java 1.1
        if( LHarcHeaderSize < HeaderLength + FileName.length ){
            FileName    = new byte[0];
        }else{
            hasFileName = true;
        }
        HeaderLength += FileName.length;


        byte[][] ExtendHeaders = this.exportExtHeaders( encode );
        long SkipSize = this.CompressedSize;
        for( int i = 0 ; i < ExtendHeaders.length ; i++ ){
            if( ExtendHeaders[i].length == 0 
             || 65534 <= ExtendHeaders[i].length
             || ( ExtendHeaders[i][0] == 1 && hasFileName ) ){
                ExtendHeaders[i] = null;
            }else{
                if( ExtendHeaders[i][0] == 0x00 ){
                    hasCRC = true;
                }
                if( ExtendHeaders[i][0] == 0x01 ){
                    hasFileName = true;
                }

                SkipSize += ExtendHeaders[i].length + 2;
            }
        }

        //------------------------------------------------------------------
        //  wb_`FbN
        if( CompressMethod.length != 5 ){
            throw new IllegalStateException( "CompressMethod doesn't follow Format." );
        }

        if( SkipSize != this.CompressedSize && !hasCRC ){
            throw new IllegalStateException( "no Header CRC field." );
        }

        if( !hasFileName ){
            throw new IllegalStateException( "no Filename infomation." );
        }

        if( this.CRC == LhaHeader.NO_CRC ){
            throw new IllegalStateException( "no CRC value." );
        }

        if( this.CRC == LhaHeader.UNKNOWN ){
            throw new IllegalStateException( "CRC is UNKNOWN." );
        }

        if( this.CompressedSize == LhaHeader.UNKNOWN ){
            throw new IllegalStateException( "CompressedSize must not be UNKNOWN." );
        }

        if( 0x0000000100000000L <= this.CompressedSize ){
            throw new IllegalStateException( "CompressedSize must be 0xFFFFFFFF or less." );
        }

        if( this.CompressedSize < 0 ){
            throw new IllegalStateException( "CompressedSize must be 0 or more." );
        }

        if( this.OriginalSize == LhaHeader.UNKNOWN ){
            throw new IllegalStateException( "OriginalSize must not be UNKNOWN." );
        }

        if( 0x0000000100000000L <= this.OriginalSize ){
            throw new IllegalStateException( "OriginalSize must be 0xFFFFFFFF or less." );
        }

        if( this.OriginalSize < 0 ){
            throw new IllegalStateException( "OriginalSize must be 0 or more." );
        }

        if( 0x0000000100000000L <= SkipSize ){
            throw new IllegalStateException( "SkipSize must be 0xFFFFFFFF or less." );
        }

        //------------------------------------------------------------------
        //  wb_o
        byte[]  HeaderData;
        try{
            ByteArrayOutputStream out = new ByteArrayOutputStream();

            //o͂wb_ɂ̓wb_擪 wb_(1byte)A
            //`FbNT(1byte)2byte܂܂Ȃ -2 ĂB
            out.write( HeaderLength - 2 );
            out.write( 0 );
            out.write( CompressMethod );
            LittleEndian.writeInt( out, (int)SkipSize );
            LittleEndian.writeInt( out, (int)this.OriginalSize );
            LittleEndian.writeInt( out, dosDate.getMsdosTime() );
            out.write( 0x20 );
            out.write( this.HeaderLevel );
            out.write( FileName.length );
            out.write( FileName );
            LittleEndian.writeShort( out, this.CRC );
            out.write( this.OSID );
            out.write( ExtraData );

            for( int i = 0 ; i < ExtendHeaders.length ; i++ ){
                if( ExtendHeaders[i] != null ){
                    LittleEndian.writeShort( out, ExtendHeaders[i].length + 2 );
                    out.write( ExtendHeaders[i] );
                }
            }
            LittleEndian.writeShort( out, 0 );
            out.close();
            HeaderData = out.toByteArray();
        }catch( IOException exception ){
            throw new Error( "caught the IOException ( " + exception.getMessage() + " ) which should be never thrown by ByteArrayOutputStream." );
        }

        final int ChecksumIndex = 1;
        final int CRCIndex      = LhaHeader.getCRC16Position( HeaderData );
        HeaderData[ChecksumIndex] = (byte)LhaHeader.calcHeaderChecksum( HeaderData );
        if( hasCRC ){
            LittleEndian.writeShort( HeaderData, CRCIndex,
                                     LhaHeader.calcHeaderCRC16( HeaderData ) );
        }

        return HeaderData;
    }

    /**
     *  LhaHeader ̏g
     * x2wb_̃f[^𐶐B<br>
     * ܂ASgwb_65536oCgȏ̃TCYɂȂꍇ
     * ʊgwb_At@Cgwb_ŗDŊi[B
     * L 2̊gwb_݂̂ 65536oCgȏɂȂꍇ 
     * O𓊂B̌ fBNggwb_D悳A
     * ̌ exportExtendHeaders(String) o͂
     * D悵ēo^ASwb_ 65536oCgȏ
     * ȂȂ悤Ɋi[B
     * 
     * @param encode o͂ۂɎgp
     *               GR[h
     * 
     * @exception IllegalStateException 
     *                 <ol>
     *                   <li>k@encodeŃoCgz
     *                       ̂ 5byteŖꍇ
     *                   <li>t@C傫邽
     *                       gwb_Ɏ܂肫ȂB
     *                   <li>ʊgwb_傫ďo͂łȂB
     *                       ̂߃wb_CRCi[ꏊB
     *                   <li>CRC  x0wb_ CRC񂪖
     *                       ʂȒlł LhaHeader.NO_CRC( -2 ) ݒ肳ĂB
     *                   <li>LastModified4oCgtime_t
     *                       \łȂ͈͂̎Ԃłꍇ
     *                   <li>OriginalSize ɃTCYsł鎖
     *                       ʂȒlł LhaHeader.UNKNOWN( -1 )ݒ肳ĂB
     *                   <li>OriginalSize lłꍇ
     *                   <li>CompressedSize ɃTCYsł鎖
     *                       ʂȒlł LhaHeader.UNKNOWN( -1 )ݒ肳ĂB
     *                   <li>CompressedSize lłꍇ
     *                   <li>CRC CRC16lsł鎖 ʂȒlł
     *                       LhaHeader.UNKNOWN( -1 )ݒ肳ĂB
     *                   <li>OriginalSize ܂ CompressedSize4oCgl
     *                       邽߃t@CTCYwb_Kvȍۂ
     *                       ̊gwb_傫
     *                       t@CTCYwb_o͏oȂꍇB
     *                 </ol>
     *                 ̉ꂩB
     * @exception UnsupportedEncodingException
     *                   encode Ŏw肳ꂽGR[h
     *                   T|[gȂꍇ
     */
    private byte[] exportLevel2Header( String encode )
                                  throws UnsupportedEncodingException {

        //------------------------------------------------------------------
        //  wb_o͏
        final int MaxHeaderLength = 65535;
        boolean   hasFileName     = false; //t@C
        boolean   hasCRC          = false; //wb_CRC
        boolean   needExtraByte   = false; //wb_̐擪0x00ɂȂ߂ɗ]1oCgt邩B
        boolean   hasFileSize     = false; //t@CTCYwb_B
        byte[]    CompressMethod  = this.Method.getBytes( encode );     //After Java 1.1 throw UnsupportedEncodingException
        int       HeaderLength    = 26;

        boolean   needFileSize    = ( 0x0000000100000000L <= this.CompressedSize
                                   || 0x0000000100000000L <= this.OriginalSize );


        byte[][]  ExtendHeaders   = this.exportExtHeaders( encode );
        for( int i = 0 ; i < ExtendHeaders.length ; i++ ){
            if( ExtendHeaders[i].length == 0 
             || MaxHeaderLength <= HeaderLength + ExtendHeaders[i].length + 2 ){
                ExtendHeaders[i] = null;
            }else{
                if( ExtendHeaders[i][0] == 0x00 ){
                    hasCRC = true;
                }
                if( ExtendHeaders[i][0] == 0x01 ){
                    hasFileName = true;
                }
                if( ExtendHeaders[i][0] == 0x42 ){
                    hasFileSize = true;
                }

                HeaderLength += ExtendHeaders[i].length + 2;
            }
        }

        if( ( HeaderLength & 0xFF ) == 0 ){
            HeaderLength++;
            needExtraByte = true;
        }

        //------------------------------------------------------------------
        //  wb_`FbN
        if( CompressMethod.length != 5 ){
            throw new IllegalStateException( "CompressMethod doesn't follow Format." );
        }

        if( this.LastModified.getTime() < 0  
         || ( ( this.LastModified.getTime() / 1000L ) & 0xFFFFFFFF00000000L )
             != 0 ){
            throw new IllegalStateException( "LastModified can not change to 4byte time_t format." );
        }

        if( !hasCRC ){
            throw new IllegalStateException( "HeaderSize too large. can not contain CRC of the Header." );
        }

        if( !hasFileName ){
            throw new IllegalStateException( "HeaderSize too large. can not contain Filename." );
        }

        if( needFileSize && !hasFileSize ){
            throw new IllegalStateException( "HeaderSize too large. can not contain Filesize." );
        }

        if( this.CRC == LhaHeader.NO_CRC ){
            throw new IllegalStateException( "no CRC." );
        }

        if( this.CRC == LhaHeader.UNKNOWN ){
            throw new IllegalStateException( "CRC must not be UNKNOWN." );
        }

        if( this.CompressedSize == LhaHeader.UNKNOWN ){
            throw new IllegalStateException( "CompressedSize must not be UNKNOWN." );
        }

        if( this.CompressedSize < 0 ){
            throw new IllegalStateException( "CompressedSize must be 0 or more." );
        }

        if( this.OriginalSize == LhaHeader.UNKNOWN ){
            throw new IllegalStateException( "OriginalSize must not be UNKNOWN." );
        }

        if( this.OriginalSize < 0 ){
            throw new IllegalStateException( "OriginalSize must be 0 or more." );
        }


        //------------------------------------------------------------------
        //  wb_o
        byte[] HeaderData;
        try{
            ByteArrayOutputStream out = new ByteArrayOutputStream();

            LittleEndian.writeShort( out, HeaderLength );
            out.write( CompressMethod );
            LittleEndian.writeInt( out, (int)this.CompressedSize );
            LittleEndian.writeInt( out, (int)this.OriginalSize );
            LittleEndian.writeInt( out, 
                                  (int)(this.LastModified.getTime() / 1000L) );
            out.write( 0x20 );
            out.write( this.HeaderLevel );
            LittleEndian.writeShort( out, this.CRC );
            out.write( this.OSID );

            for( int i = 0 ; i < ExtendHeaders.length ; i++ ){
                if( ExtendHeaders[i] != null ){
                    LittleEndian.writeShort( out, ExtendHeaders[i].length + 2 );
                    out.write( ExtendHeaders[i] );
                }
            }
            LittleEndian.writeShort( out, 0 );

            if( needExtraByte ) out.write( 0x00 );

            out.close();
            HeaderData = out.toByteArray();
        }catch( IOException exception ){
            throw new Error( "caught the IOException ( " + exception.getMessage() + " ) which should be never thrown by ByteArrayOutputStream." );
        }

        final int CRCIndex = LhaHeader.getCRC16Position( HeaderData );
        LittleEndian.writeShort( HeaderData, CRCIndex,
                                 LhaHeader.calcHeaderCRC16( HeaderData ) );

        return HeaderData;
    }


    /**
     *  LhaHeader ̏g
     * x3wb_̃f[^𐶐B<br>
     * 
     * @param encode o͂ۂɎgp
     *               GR[h
     * 
     * @return oCgzɊi[wb_f[^
     * 
     * @exception IllegalStateException <br>
     *                 <ol>
     *                   <li>k@encodeŃoCgz
     *                       ̂ 5byteŖꍇ
     *                   <li>ʊgwb_傫ďo͂łȂB
     *                       ̂߃wb_CRCi[ꏊB
     *                   <li>CRC  x0wb_ CRC񂪖
     *                       ʂȒlł LhaHeader.NO_CRC( -2 ) ݒ肳ĂB
     *                   <li>LastModified4oCgtime_t
     *                       \łȂ͈͂̎Ԃłꍇ<br>
     *                   <li>OriginalSize ɃTCYsł鎖
     *                       ʂȒlł LhaHeader.UNKNOWN( -1 )ݒ肳ĂB<br>
     *                   <li>OriginalSize lł邩A
     *                       4bytelŕ\łȂlłꍇ<br>
     *                   <li>CompressedSize ɃTCYsł鎖
     *                       ʂȒlł LhaHeader.UNKNOWN( -1 )ݒ肳ĂB<br>
     *                   <li>CompressedSize lł邩A
     *                       4bytelŕ\łȂlłꍇ<br>
     *                   <li>CRC CRC16lsł鎖 ʂȒlł 
     *                       LhaHeader.UNKNOWN( -1 )ݒ肳ĂB<br>
     *                 </ol>
     *                 ̉ꂩB
     * @exception UnsupportedEncodingException
     *                   encode Ŏw肳ꂽGR[h
     *                   T|[gȂꍇ
     */
    private byte[] exportLevel3Header( String encode )
                                  throws UnsupportedEncodingException {

        //wb_o͏
        final int WordSize       = 4;
        byte[]    CompressMethod = this.Method.getBytes( encode );      //After Java 1.1 throw UnsupportedEncodingException
        int       HeaderLength   = 32;

        byte[][]  ExtendHeaders  = this.exportExtHeaders( encode );
        for( int i = 0 ; i < ExtendHeaders.length ; i++ ){
            if( ExtendHeaders[i].length == 0 ){
                ExtendHeaders[i] = null;
            }else{
                HeaderLength += ExtendHeaders[i].length + 4;
            }
        }

        //wb_`FbN
        if( CompressMethod.length != 5 ){
            throw new IllegalStateException( "CompressMethod doesn't follow Format." );
        }

        if( this.LastModified.getTime() < 0  
         || ( ( this.LastModified.getTime() / 1000L ) & 0xFFFFFFFF00000000L )
             != 0 ){
            throw new IllegalStateException( "LastModified can not change to 4byte time_t format." );
        }

        if( this.CRC == LhaHeader.NO_CRC ){
            throw new IllegalStateException( "no CRC value." );
        }

        if( this.CRC == LhaHeader.UNKNOWN ){
            throw new IllegalStateException( "CRC is UNKNOWN." );
        }

        if( this.CompressedSize == LhaHeader.UNKNOWN ){
            throw new IllegalStateException( "CompressedSize must not be UNKNOWN." );
        }

        if( 0x0000000100000000L <= this.CompressedSize ){
            throw new IllegalStateException( "CompressedSize must be 0xFFFFFFFF or less." );
        }

        if( this.CompressedSize < 0 ){
            throw new IllegalStateException( "CompressedSize must be 0 or more." );
        }

        if( this.OriginalSize == LhaHeader.UNKNOWN ){
            throw new IllegalStateException( "OriginalSize must not be UNKNOWN." );
        }

        if( 0x0000000100000000L <= this.OriginalSize ){
            throw new IllegalStateException( "OriginalSize must be 0xFFFFFFFF or less." );
        }

        if( this.OriginalSize < 0 ){
            throw new IllegalStateException( "OriginalSize must be 0 or more." );
        }

        //wb_o
        byte[] HeaderData;
        try{
            ByteArrayOutputStream out = new ByteArrayOutputStream();

            LittleEndian.writeShort( out, WordSize );
            out.write( CompressMethod );
            LittleEndian.writeInt( out, (int)this.CompressedSize );
            LittleEndian.writeInt( out, (int)this.OriginalSize );
            LittleEndian.writeInt( out, 
                                   (int)(this.LastModified.getTime() / 1000L) );
            out.write( 0x20 );
            out.write( this.HeaderLevel );
            LittleEndian.writeShort( out, this.CRC );
            out.write( this.OSID );
            LittleEndian.writeInt( out, HeaderLength );

            for( int i = 0 ; i < ExtendHeaders.length ; i++ ){
                if( ExtendHeaders[i] != null ){
                    LittleEndian.writeInt( out, ExtendHeaders[i].length + 4 );
                    out.write( ExtendHeaders[i] );
                }
            }
            LittleEndian.writeInt( out, 0 );

            out.close();
            HeaderData  = out.toByteArray();
        }catch( IOException exception ){
            throw new Error( "caught the IOException ( " + exception.getMessage() + " ) which should be never thrown by ByteArrayOutputStream." );
        }

        final int CRCIndex = LhaHeader.getCRC16Position( HeaderData );
        LittleEndian.writeShort( HeaderData, CRCIndex,
                                 LhaHeader.calcHeaderCRC16( HeaderData ) );

        return HeaderData;
    }

    /**
     * LhaHeader̃f[^gp wb_f[^𐶐A
     * oCgž`œB<br>
     * 
     * @param encode o͂ۂɎgp
     *               GR[h
     *
     * @exception IllegalStateException 
     *                <ol>
     *                   <li>k@encodeŃoCgz
     *                       ̂ 5byteŖꍇ
     *                   <li>x0,1,2 t@C邽
     *                       wb_Ɏ܂肫ȂB
     *                   <li>x1,2ŋʊgwb_傫ďo͂łȂB
     *                       ̂߃wb_CRCi[ꏊB
     *                   <li>x0ȊO CRC  x0wb_ 
     *                       CRC񂪖ʂȒlł 
     *                       LhaHeader.NO_CRC( -2 ) ݒ肳ĂB
     *                   <li>x0,1̎LastModifiedMS-DOS`
     *                       ŕ\łȂ͈͂̎Ԃłꍇ
     *                   <li>x2,3̎LastModified4oCg
     *                       time_tŕ\łȂ͈͂̎Ԃłꍇ
     *                   <li>OriginalSize ɃTCYsł鎖
     *                       ʂȒlł LhaHeader.UNKNOWN( -1 )ݒ肳ĂB
     *                   <li>OriginalSize lłꍇ
     *                   <li>x0,1,3 ̎ OriginalSize 
     *                       4bytelŕ\łȂlłꍇ
     *                   <li>CompressedSize ɃTCYsł鎖
     *                       ʂȒlł LhaHeader.UNKNOWN( -1 )ݒ肳ĂB
     *                   <li>CompressedSize lłꍇ
     *                   <li>x0,1,3 ̎ CompressedSize 
     *                       4bytelŕ\łȂlłꍇ
     *                   <li>x2̎OriginalSize ܂ CompressedSize
     *                       4oCgl𒴂邽߃t@CTCYwb_Kvȍۂ
     *                       ̊gwb_傫ăt@CTCYwb_o͏oȂꍇB
     *                   <li>CRC CRC16lsł鎖
     *                       ʂȒlł LhaHeader.UNKNOWN( -1 )ݒ肳ĂB
     *                   <li>wb_x 0,1,2,3 ȊOłꍇ
     *                 </ol>
     *                 ̉ꂩB
     * @exception UnsupportedEncodingException
     *                   encode Ŏw肳ꂽGR[h
     *                   T|[gȂꍇ
     */
    private byte[] exportHeader( String encode )
                            throws UnsupportedEncodingException {
        switch( this.HeaderLevel ){
        case 0:
            return this.exportLevel0Header( encode );                           //throw UnsupportedEncodingException IllegalStateException
        case 1:
            return this.exportLevel1Header( encode );                           //throw UnsupportedEncodingException IllegalStateException
        case 2:
            return this.exportLevel2Header( encode );                           //throw UnsupportedEncodingException IllegalStateException
        case 3:
            return this.exportLevel3Header( encode );                           //throw UnsupportedEncodingException IllegalStateException
        default:
            throw new IllegalStateException( "unknown header level \"" + this.HeaderLevel + "\"." );
        }
    }

    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  export extend header
    //------------------------------------------------------------------
    //  private byte[] exportCommonExtHeader()
    //  private byte[] exportFileNameExtHeader( String encode )
    //  private byte[] exportDirNameExtHeader( String encode )
    //  private byte[] exportFileSizeHeader()
    //  protected byte[][] exportExtendHeaders( String encode )
    //  private byte[][] exportExtHeader( String encode )
    //------------------------------------------------------------------
    /**
     * ʊgwb_oCgž`ɂďo͂B
     * ̃\bh ExtraExtHeaders  ʊgwb_̏
     * o^Ă΂̏AłȂ 0ŏꂽ
     * 3 oCg̃oCgzԂłB
     * 
     * @return ʊgwb_oCgzɊi[
     */
    private byte[] exportCommonExtHeader(){
        if( this.ExtraExtHeaders != null ){
            for( int i = 0 ; i  < this.ExtraExtHeaders.size() ; i++ ){
                byte[] ExtendHeaderData = (byte[])this.ExtraExtHeaders.elementAt(i);

                if( ExtendHeaderData[0] == 0x00 ){
                    return ExtendHeaderData;
                }
            }
        }

        return new byte[3];
    }

    /**
     * t@Cgwb_oCgž`ɂďo͂B
     * t@Cgwb_͋ło͂B
     * 
     * @param encode o͂ۂɎgp
     *               GR[h
     * 
     * @return t@Cgwb_oCgzɊi[
     */
    private byte[] exportFileNameExtHeader( String encode )
                                       throws UnsupportedEncodingException {
        byte[] FileName         = this.getFileName().getBytes( encode );        //After Java 1.1

        byte[] ExtendHeaderData = new byte[ FileName.length + 1 ];
        ExtendHeaderData[0] = 0x01; //gwb_IDݒ
        System.arraycopy( FileName, 0, ExtendHeaderData, 1, FileName.length );
        return ExtendHeaderData;
    }

    /**
     * fBNggwb_oCgž`ɂďo͂B
     * ̃\bhł fBNggwb_
     * ło͂邪AfBNggwb_ł
     * ꍇ exportExtHeaders() ̒iKŎ菜B
     * 
     * @param encode o͂ۂɎgp
     *               GR[h
     * 
     * @return fBNggwb_oCgzɊi[
     */
    private byte[] exportDirNameExtHeader( String encode )
                                      throws UnsupportedEncodingException {

        final byte LhaFileSeparator = (byte)0xFF;
        String dir = this.getDirName();

        Vector vec = new Vector();
        int index  = 0;
        int len    = 0;
        int length = 0;
        while( index + len < dir.length() ){
            if( dir.charAt( index + len ) == File.separatorChar ){
                byte[] src = dir.substring( index, index + len ).getBytes( encode );
                byte[] array = new byte[ src.length + 1 ];
                System.arraycopy( src, 0, array, 0, src.length );
                array[ src.length ] = LhaFileSeparator;
                length += array.length;
                vec.addElement( array );

                index += len + 1;
                len = 0;
            }else if( index + len + 1 < dir.length() ){
                byte[] array = dir.substring( index, index + len + 1 ).getBytes( encode );
                length += array.length;
                vec.addElement( array );

                index += len + 1;
                len = 0;
            }else{
                len++;
            }
        }
        
        byte[] ExtendHeaderData = new byte[ length + 1 ];
        ExtendHeaderData[0] = 0x02; //gwb_IDݒ
        index = 1;
        for( int i = 0 ; i < vec.size() ; i++ ){
            byte[] array = (byte[])vec.elementAt( i );

            System.arraycopy( array, 0, ExtendHeaderData, index, array.length );
            index += array.length;
        }

        return ExtendHeaderData;
    }

    /**
     * 64bitt@CTCYwb_oCgzɂďo͂B
     * ̃\bh̓IWiTCYA܂͈kTCY
     * 32bitlŕ\łꍇłoCgzo͂B
     * Kv̖ꍇɂ exportExtHeaders() o͂}~B
     * 
     * @return 64bitt@CTCYwb_
     */
    private byte[] exportFileSizeHeader(){
        byte[] ExtendHeaderData = new byte[ 17 ];

        ExtendHeaderData[0] = (byte)0x42;
        LittleEndian.writeLong( ExtendHeaderData, 1, this.CompressedSize );
        LittleEndian.writeLong( ExtendHeaderData, 9, this.OriginalSize );

        return ExtendHeaderData;
    }

    /**
     * gwb_oCgž`ɂďo͂B
     * ̃\bhI[o[Ch鎖ɂ
     * lXȊgwb_ɑΉ邱Ƃ\ƂȂB
     * LhaHeader ł private oł
     * ExtraExtHeaders ɓo^ꂽgwb_̏
     * ԂłB
     * o͂̌` oCgڂɊgwb_ʎq
     * āAgwb_f[^i[A
     * ̊gwb_̑傫͓YtȂB
     * 
     * @param encode o͂ۂɎgp
     *               GR[h
     * 
     * @return 1̊gwb_1̃oCgzɊi[A
     *         ž`ɂ
     * 
     * @exception UnsupportedEncodingException
     *                   encode Ŏw肳ꂽGR[h
     *                   T|[gȂꍇ
     */
    protected byte[][] exportExtendHeaders( String encode )
                                       throws UnsupportedEncodingException {
        if( this.ExtraExtHeaders != null ){
            byte[][] ExtendHeaders = new byte[this.ExtraExtHeaders.size()][];

            for( int i = 0 ; i  < this.ExtraExtHeaders.size() ; i++ ){
                ExtendHeaders[i] = (byte[])this.ExtraExtHeaders.elementAt(i);
            }

            return ExtendHeaders;
        }else{
            return new byte[0][];
        }
    }

    /**
     * gwb_oCgž`ɂďo͂B
     * 
     * @param encode o͂ۂɎgp
     *               GR[h
     * 
     * @return 1̊gwb_1̃oCgzɊi[A
     *         SĂ̊gwb_̔ž`ɂ
     * 
     * @exception UnsupportedEncodingException
     *                   encode Ŏw肳ꂽGR[h
     *                   T|[gȂꍇ
     */
    private byte[][] exportExtHeaders( String encode )
                                  throws UnsupportedEncodingException {
        byte[] CommonExtHeader   = this.exportCommonExtHeader();
        byte[] FileNameExtHeader = this.exportFileNameExtHeader( encode );
        byte[] DirNameExtHeader  = this.exportDirNameExtHeader( encode );

        byte[][] ExtraExtHeaders = this.exportExtendHeaders( encode );
        Vector Headers           = new Vector();

        Headers.addElement( CommonExtHeader );
        Headers.addElement( FileNameExtHeader );
        if( 1 < DirNameExtHeader.length ){
            Headers.addElement( DirNameExtHeader );
        }

        if( this.HeaderLevel == 2
         && ( 0x0000000100000000L <= this.CompressedSize
           || 0x0000000100000000L <= this.OriginalSize ) ){
            Headers.addElement( this.exportFileSizeHeader() );
        }

        for( int i = 0 ; i < ExtraExtHeaders.length ; i++ ){
            byte[]  ExtendHeaderData = ExtraExtHeaders[i];
            if( 0 < ExtendHeaderData.length
             && ExtendHeaderData[0] != 0x00
             && ExtendHeaderData[0] != 0x01
             && ExtendHeaderData[0] != 0x02 ){
                Headers.addElement( ExtendHeaderData );
            }
        }

        byte[][] ExtendHeaders = new byte[Headers.size()][];
        for( int i = 0 ; i < ExtendHeaders.length ; i++ ){
            ExtendHeaders[i] = (byte[])Headers.elementAt(i);
        }

        return ExtendHeaders;
    }


    //------------------------------------------------------------------
    //  shared method
    //------------------------------------------------------------------
    //  public static boolean checkHeaderData( byte[] HeaderData )
    //------------------------------------------------------------------
    /**
     * wb_f[^ł邩`FbNB
     * 
     * @param HeaderData wb_f[^oCgzɊi[
     * 
     * @return wb_f[^ł true
     *         Ⴆ false
     */
    public static boolean   checkHeaderData( byte[] HeaderData ){
        final int HeaderLevelIndex = 20;
        try{
            switch( HeaderData[ HeaderLevelIndex ] & 0xFF ) {
            case 0:
                return LhaHeader.verifyHeaderChecksum( HeaderData );

            case 1:
                return    LhaHeader.verifyHeaderChecksum( HeaderData )
                       && ( LhaHeader.getCRC16Position( HeaderData ) == -1
                         || LhaHeader.verifyHeaderCRC16( HeaderData ) );

            case 2:
                return LhaHeader.verifyHeaderCRC16( HeaderData );

            case 3:
                return LhaHeader.verifyHeaderCRC16( HeaderData );

            }
        }catch( ArrayIndexOutOfBoundsException exception ){ //Ignore
        }
        return false;
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  check header
    //------------------------------------------------------------------
    //  private static int getCRC16Position( byte[] HeaderData )
    //  private static int calcHeaderChecksum( byte[] HeaderData )
    //  private static int calcHeaderCRC16( byte[] HeaderData )
    //  private static int readHeaderChecksum( byte[] HeaderData )
    //  private static int readHeaderCRC16( byte[] HeaderData )
    //  private static boolean verifyHeaderCRC16( byte[] HeaderData )
    //  public static boolean checkHeaderData( byte[] HeaderData )
    //------------------------------------------------------------------
    /**
     * wb_CRCli[Ăʒu𓾂B
     * 
     * @param HeaderData wb_f[^oCgzɊi[
     * 
     * @return wb_CRCl̈ʒu<br>
     *         wb_CRClȂꍇ -1
     */
    private static int getCRC16Position( byte[] HeaderData ){
        final int HeaderLevelIndex = 20;
        int WordSize;
        int position;
        int length;

        switch( HeaderData[ HeaderLevelIndex ] & 0xFF ){
        case 1:
            WordSize = 2;
            position = length = ( HeaderData[ 0 ] & 0xFF ) + 2;
            break;
        case 2:
            WordSize = 2;
            position = length = 26;
            break;
        case 3:
            WordSize = 4;
            position = length = 32;
            break;
        default:
            return -1;
        }

        while( true ){
            if( 0 < length && position < HeaderData.length ){
                length = 0;

                for (int i = 0; i < WordSize ; i++){
                    length = ( length << 8 | ( HeaderData[ position - (1 + i) ] & 0xFF ) );
                }

                if( HeaderData[ position ] == 0 ){
                    return position + 1;
                }

                position += length;
            } else {
                return -1;
            }
        }
    }

    /**
     * x0wb_Ax1wb_
     * wb_f[^`FbNTlvZB
     * 
     * @param HeaderData wb_f[^oCgzɊi[
     * 
     * @return vZꂽwb_̃`FbNTl
     */
    private static int calcHeaderChecksum( byte[] HeaderData ){
        int length = HeaderData[ 0 ] & 0xFF;

        LhaChecksum checksum = new LhaChecksum();
        checksum.update( HeaderData, 2, length );

        return (int)checksum.getValue();
    }

    /**
     * x1wb_Ax2wb_Ax3wb_
     * wb_f[^CRC16lvZB
     * 
     * @param HeaderData wb_f[^oCgzɊi[
     * 
     * @return vZꂽwb_CRC16l
     */
    private static int calcHeaderCRC16( byte[] HeaderData ){
        int position = LhaHeader.getCRC16Position( HeaderData );
        int crcValue = 0;
        if( position != -1 ){
            crcValue = LittleEndian.readShort( HeaderData, position );
            LittleEndian.writeShort( HeaderData, position, 0);
        }

        CRC16 crc16 = new CRC16();
        crc16.update( HeaderData );

        if( position != -1 ){
            LittleEndian.writeShort( HeaderData, position, crcValue );
        }

        return (int)crc16.getValue();
    }

    /**
     * x0wb_Ax1wb_
     * wb_f[^`FbNTlǂݍށB
     * 
     * @param HeaderData wb_f[^oCgzɊi[
     * 
     * @return wb_ɋL^ꂽ`FbNTl
     */
    private static int readHeaderChecksum( byte[] HeaderData ) {
        return HeaderData[ 1 ] & 0xFF;
    }

    /**
     * x1wb_Ax2wb_Ax3wb_
     * wb_f[^CRC16lǂݍށB
     * 
     * @param HeaderData wb_f[^oCgzɊi[
     * 
     * @return wb_ɋL^ꂽCRC16l
     */
    private static int readHeaderCRC16( byte[] HeaderData ){
        int position = LhaHeader.getCRC16Position( HeaderData );
        if( position != -1 ){
            return LittleEndian.readShort( HeaderData, position );
        }else{
            return -1;
        }
    }

    /**
     * `FbNTlɂăwb_f[^̐`FbNB
     * 
     * @param HeaderData wb_f[^oCgzɊi[
     * 
     * @return `FbNTlɂăwb_f[^̐
     *         ؖ trueA
     *         ؖȂ false
     */
    private static boolean verifyHeaderChecksum( byte[] HeaderData ){
        final int HeaderLevelIndex = 20;

        switch( HeaderData[ HeaderLevelIndex ] & 0xFF ) {
        case 0:
        case 1:
            return LhaHeader.readHeaderChecksum( HeaderData )
                == LhaHeader.calcHeaderChecksum( HeaderData );
        default:
            return false;
        }
    }

    /**
     * CRC16lɂăwb_f[^̐`FbNB
     * 
     * @param HeaderData wb_f[^oCgzɊi[
     * 
     * @return CRC16lɂăwb_f[^̐
     *         ؖ trueA
     *         ؖȂ false
     */
    private static boolean verifyHeaderCRC16( byte[] HeaderData ){
        final int HeaderLevelIndex = 20;

        switch( HeaderData[ HeaderLevelIndex ] & 0xFF ) {
        case 1:
        case 2:
        case 3:
            return LhaHeader.readHeaderCRC16( HeaderData )
                == LhaHeader.calcHeaderCRC16( HeaderData );
        default:
            return false;
        }
    }


    //------------------------------------------------------------------
    //  shared method
    //------------------------------------------------------------------
    //  read header data from InputStream
    //------------------------------------------------------------------
    //  public static byte[] getFirstHeaderData( InputStream in )
    //  public static byte[] getNextHeaderData( InputStream in )
    //------------------------------------------------------------------
    /**
     * ̓Xg[ ŏ̃wb_ǂݍށB<br>
     * ̃\bh̓x1wb_A x3wb_
     * f[^݂ƁAwb_SĂǂݍƂ
     * in.mark( 65536 )  E𒴂 ǂݍމ\A
     * ̌ reset() ł ̊Ԃ̃f[^ǂݗƂ
     * \B<br>
     * ܂AInputStream mark/reset ̎ł
     * Xg[I[t߂ wb_Ɏf[^݂
     * wb_SēǂݍƂ EndOfStreamɒBĂ܂A
     * reset()ł ̊Ԃ̃f[^ǂݗƂ\B<br>
     * 
     * @param in wb_f[^ǂݍޓ̓Xg[
     *           Xg[ mark/reset̃T|[gKvƂB
     * 
     * @return ǂݎꂽwb_f[^<br>
     *         wb_炸 EndOfStream ɒBꍇ null<br>
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception IllegalArgumentException
     *                         in  mark/resetT|[gȂꍇ
     */
    public static byte[] getFirstHeaderData( InputStream in )
                                                            throws IOException {
        if( in.markSupported() ){
            try {
                int stock1 = -1;
                int stock2 = -1;
                int read;

                while( 0 <= ( read = in.read() ) ) {                            //throw IOException
                    if( read == '-' && 0 < stock1 ){
                        in.mark( 65536 );   //65536ŕۏ؂ł̂level0,2̂ 
                        LhaHeader.ensureSkip( in, 3 );                          //throw IOException
                        if( in.read() == '-' ){                                 //throw IOException
                            LhaHeader.ensureSkip( in, 13 );                     //throw IOException
                            int HeaderLevel = in.read();                        //throw IOException
                            in.reset();                                         //throw IOException
                            byte[] HeaderData;
                            switch( HeaderLevel ){
                            case 0:
                                HeaderData = LhaHeader.readLevel0HeaderData(
                                                    stock1, stock2, read, in ); //throw IOException
                                break;
                            case 1:
                                HeaderData = LhaHeader.readLevel1HeaderData(
                                                    stock1, stock2, read, in ); //throw IOException
                                break;
                            case 2:
                                HeaderData = LhaHeader.readLevel2HeaderData(
                                                    stock1, stock2, read, in ); //throw IOException
                                break;
                            case 3:
                                HeaderData = LhaHeader.readLevel3HeaderData(
                                                    stock1, stock2, read, in ); //throw IOException
                                break;
                            default:
                                HeaderData = null;
                            }

                            if( HeaderData != null 
                             && LhaHeader.checkHeaderData( HeaderData ) )
                                return HeaderData;
                        }
                        in.reset();                                             //throw IOException
                    }
                    stock1 = stock2;
                    stock2 = read;
                }
            }catch( EOFException exception ){ //Ignore
            }
            return null;
        }else{
            throw new IllegalArgumentException( "InputStream needed mark()/reset() support." );
        }
    }
    

    /**
     * ̓Xg[ ̃wb_ǂݍށB<br>
     * ̃\bh̓x1wb_A x3wb_
     * f[^݂ƁAwb_SĂǂݍƂ
     * in.mark( 65536 )  E𒴂 ǂݍމ\A
     * ̌ reset() ł ̊Ԃ̃f[^ǂݗƂ
     * \B<br>
     * ܂AXg[I[t߂ wb_Ɏf[^݂
     *  wb_SēǂݍƂ EndOfStreamɒBĂ܂A
     * reset()ł ̊Ԃ̃f[^ǂݗƂ\B<br>
     * 
     * @param in wb_f[^ǂݍޓ̓Xg[
     *           Xg[ mark/reset̃T|[gKvƂB
     * 
     * @return ǂݎꂽwb_f[^<br>
     *         wb_炸 EndOfStream ɒBꍇ null<br>
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception IllegalArgumentException
     *                         in  mark/resetT|[gȂꍇ
     */
    public static byte[] getNextHeaderData( InputStream in )
                                       throws IOException {
        if( in.markSupported() ){
            try{
                int first = in.read();                                          //throw IOException
                if( 0 < first ){ // ̒l EndOfStreamɓBA 0̏ꍇ͏ɏI[ɓB
                    int second  = in.read();                                    //throw IOException
                    int third   = in.read();                                    //throw IOException
                    in.mark( 65536 ); //65536ŕۏ؂ł̂level0,2̂
                    LhaHeader.ensureSkip( in, 3 );                              //throw IOException
                    int seventh = in.read();                                    //throw IOException
                    if( third == '-' && seventh == '-' ){
                        LhaHeader.ensureSkip( in, 13 );                         //throw IOException
                        int HeaderLevel = in.read();                            //throw IOException
                        in.reset();
                        byte[] HeaderData;
                        switch( HeaderLevel ){
                        case 0:
                            HeaderData = LhaHeader.readLevel0HeaderData( 
                                                     first, second, third, in );//throw IOException
                            break;
                        case 1:
                            HeaderData = LhaHeader.readLevel1HeaderData( 
                                                     first, second, third, in );//throw IOException
                            break;
                        case 2:
                            HeaderData = LhaHeader.readLevel2HeaderData( 
                                                     first, second, third, in );//throw IOException
                            break;
                        case 3:
                            HeaderData = LhaHeader.readLevel3HeaderData( 
                                                     first, second, third, in );//throw IOException
                            break;
                        default:
                            HeaderData = null;
                        }

                        if( HeaderData != null && LhaHeader.checkHeaderData( HeaderData ) ){
                            return HeaderData;
                        }
                    }
                }
            }catch( EOFException exception ){ //Ignore
            }
            return null;
        }else{
            throw new IllegalArgumentException( "InputStream needed mark()/reset() support." );
        }
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  read header data
    //------------------------------------------------------------------
    //  private static byte[] readLevel0HeaderData( int HeaderLength,
    //                 int HeaderChecksum, int CompressMethod1, InputStream in )
    //  private static byte[] readLevel1HeaderData( int BaseHeaderLength,
    //             int BaseHeaderChecksum, int CompressMethod1, InputStream in )
    //  private static byte[] readLevel2HeaderData( int HeaderLengthLow,
    //             int HeaderLengthHi, int CompressMethod1, InputStream in )
    //  private static byte[] readLevel2HeaderData( int WordSizeLow,
    //             int WordSizeHi, int CompressMethod1, InputStream in )
    //------------------------------------------------------------------
    /**
     * ̓Xg[烌x0wb_ǂݍ
     * 
     * @param HeaderLength    wb_̒
     * @param HeaderChecksum  wb_̃`FbNT
     * @param CompressMethod1 k@
     * @param in              wb_f[^ǂݍޓ̓Xg[
     * 
     * @return ǂݎꂽwb_f[^
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException wb_̓ǂݍݓr EndOfStreamɒBꍇ
     */
    private static byte[] readLevel0HeaderData( int HeaderLength,
                                                int HeaderChecksum,
                                                int CompressMethod1,
                                                InputStream in )
                                           throws IOException {
        byte[] HeaderData = new byte[ HeaderLength + 2 ];
        HeaderData[0] = (byte)HeaderLength;
        HeaderData[1] = (byte)HeaderChecksum;
        HeaderData[2] = (byte)CompressMethod1;
        int readed = 3;
        int length = 0;
        HeaderLength += 2;

        while( readed < HeaderLength && 0 <= length ){
            length = in.read( HeaderData, readed, HeaderLength - readed );      //throws IOException
            readed += length;
        }

        if( readed == HeaderLength ){
            return HeaderData;
        }else{
            throw new EOFException();
        }
    }

    /**
     * ̓Xg[烌x1wb_ǂݍ
     * 
     * @param BaseHeaderLength   {wb_̒
     * @param BaseHeaderChecksum {wb_̃`FbNT
     * @param CompressMethod1    k@
     * @param in                 wb_f[^ǂݍޓ̓Xg[
     * 
     * @return ǂݎꂽwb_f[^B
     *         x1wb_łȂƂꍇ nullԂB
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException wb_̓ǂݍݓr EndOfStreamɒBꍇ
     */
    private static byte[] readLevel1HeaderData( int BaseHeaderLength,
                                                int BaseHeaderChecksum,
                                                int CompressMethod1,
                                                InputStream in )
                                           throws IOException {
        int HeaderLength  = BaseHeaderLength + 2;
        Vector headers    = new Vector();
        byte[] HeaderData = new byte[HeaderLength];
        HeaderData[0] = (byte) BaseHeaderLength;
        HeaderData[1] = (byte) BaseHeaderChecksum;
        HeaderData[2] = (byte) CompressMethod1;

        //wb_f[^擾
        int readed = 0;
        int length = 0;
        do{
            if( 0 == headers.size() ){
                readed = 3;
            }else{
                readed = 0;
            }

            while( readed < HeaderLength && 0 <= length ){
                length = in.read( HeaderData, readed, HeaderLength - readed );  //throws IOException
                readed += length;
            }

            if( readed == HeaderLength ){
                if( 0 == headers.size() && !LhaHeader.verifyHeaderChecksum( HeaderData ) ){
                    return null;
                 }else{
                    headers.addElement( HeaderData );
                 }
            }else{
                throw new EOFException();
            }

            length       = HeaderLength;
            HeaderLength = LittleEndian.readShort( HeaderData, HeaderLength - 2 );
            HeaderData   = new byte[ HeaderLength ];
        }while( 0 < HeaderLength && readed == length );

        //擾wb_f[^̃oCgz
        HeaderLength = 0;
        for (int i = 0 ; i < headers.size(); i++ ){
            HeaderLength += ((byte[])headers.elementAt(i)).length;
        }

        HeaderData   = new byte[HeaderLength];
        int position = 0;
        for( int i = 0 ; i < headers.size() ; i++ ){
            byte[] Data = (byte[])headers.elementAt(i);
            System.arraycopy( Data, 0, HeaderData, position, Data.length );

            position += Data.length;
        }
        return HeaderData;
    }

    /**
     * ̓Xg[烌x2wb_ǂݍ
     * 
     * @param HeaderLengthLow wb_̒ʃoCg
     * @param HeaderLengthHi  wb_̒ʃoCg
     * @param CompressMethod1 k@
     * @param in              wb_f[^ǂݍޓ̓Xg[
     * 
     * @return ǂݎꂽwb_f[^
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException wb_̓ǂݍݓr EndOfStreamɒBꍇ
     */
    private static byte[] readLevel2HeaderData( int HeaderLengthLow,
                                                int HeaderLengthHi,
                                                int CompressMethod1,
                                                InputStream in )
                                           throws IOException {
        int HeaderLength  = ( HeaderLengthHi << 8 ) | HeaderLengthLow;
        byte[] HeaderData = new byte[ HeaderLength ];
        HeaderData[0] = (byte) HeaderLengthLow;
        HeaderData[1] = (byte) HeaderLengthHi;
        HeaderData[2] = (byte) CompressMethod1;

        int readed = 3;
        int length = 0;
        while( readed < HeaderLength && 0 <= length ){
            length = in.read( HeaderData, readed, HeaderLength - readed );      //throws IOException
            readed += length;
        }

        if( readed == HeaderLength ){
            return HeaderData;
        }else{
            throw new EOFException();
        }
    }

    /**
     * ̓Xg[烌x3wb_ǂݍށB<br>
     * ̃\bh ̓ǂݍ݃\bhƈႢA
     * getNextHeaderData() ɂ mark() 
     * 鎖OƂĂB
     * 
     * @param WordSizeLow     wb_Ɏgp郏[hTCY ʃoCg
     * @param WordSizeHi      wb_Ɏgp郏[hTCY ʃoCg
     * @param CompressMethod1 k@
     * @param in              wb_f[^ǂݍޓ̓Xg[
     * 
     * @return ǂݎꂽwb_f[^B<br>
     *         x3wb_łȂƂꍇ nullԂB
     * 
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException wb_̓ǂݍݓr EndOfStreamɒBꍇ
     */
    private static byte[] readLevel3HeaderData( int WordSizeLow,
                                                int WordSizeHi,
                                                int CompressMethod1,
                                                InputStream in )
                                           throws IOException {
        if( WordSizeLow == 0x04 && WordSizeHi == 0x00 ){
            in.skip( 21 );
            int HeaderLength = LittleEndian.readInt( in );
            in.reset();

            byte[] HeaderData = new byte[ HeaderLength ];
            HeaderData[0] = (byte) WordSizeLow;
            HeaderData[1] = (byte) WordSizeHi;
            HeaderData[2] = (byte) CompressMethod1;

            int readed = 3;
            int length = 0;
            while( readed < HeaderLength && 0 <= length ){
                length = in.read( HeaderData, readed, HeaderLength - readed );  //throws IOException
                readed += length;
            }

            if( readed == HeaderLength ){
                return HeaderData;
            }else{
                throw new EOFException();
            }
        }else{
            return null;
        }
    }


    //------------------------------------------------------------------
    //  shared method
    //------------------------------------------------------------------
    //  public static LhaHeader createInstance( byte[] HeaderData, 
    //                         String encoding, Properties property )
    //------------------------------------------------------------------
    /**
     * property  L["lha.header" Ɍѕtꂽgp
     * HeaderData  LhaHeader ̃CX^X𐶐B<br>
     * 
     * @param HeaderData wb_̃f[^oCgz
     * @param property   LhaProperty.parse()  LhaHeader ̃CX^Xł悤
     *                    L["lha.header" ̒lƂĎvpeB
     * 
     * @return LhaHeader ̃CX^X
     */
    public static LhaHeader createInstance( byte[]     HeaderData, 
                                            Properties property ){

        String encoding = property.getProperty( "lha.encoding" );
        if( encoding == null ){
            encoding = LhaProperty.getProperty( "lha.encoding" );
        }

        String packages = property.getProperty( "lha.packages" );
        if( packages == null ){
            packages = LhaProperty.getProperty( "lha.packages" );
        }

        String generator = property.getProperty( "lha.header" );
        if( generator == null ){
            generator = LhaProperty.getProperty( "lha.header" );
        }


        Hashtable substitute = new Hashtable();
        substitute.put( "data", HeaderData );
        substitute.put( "encoding", encoding );

        return (LhaHeader)LhaProperty.parse( generator, substitute, packages );
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  helper of InputStream
    //------------------------------------------------------------------
    //  private static void ensureSkip( InputStream in, long len )
    //------------------------------------------------------------------
    /**
     * InputStream  len oCgXLbvB
     * 
     * @param in  ̓Xg[
     * @param len XLbv钷
     *
     * @exception IOException  o̓G[ꍇ
     * @exception EOFException EndOfStream ɒBꍇB
     */
    private static void ensureSkip( InputStream in, long len ) throws IOException {
        while( 0 < len ){
            long skiplen = in.skip( len );
            if( skiplen <= 0 ){
                if( 0 <= in.read() ){
                    len--;
                }else{
                    throw new EOFException();
                }
            }else{
                len -= skiplen;
            }
        }
    }

}
//end of LhaHeader.java
