/*
 *  Copyright (c) 2009 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _OPENSHIVA_SOURCE_PARAMETERS_WIDGET_H_
#define _OPENSHIVA_SOURCE_PARAMETERS_WIDGET_H_

#include <QtShiva/ParametersWidgetBase.h>
#include <map>

namespace GTLCore {
  class String;
  class Value;
};

namespace OpenShiva {
  class Source;
};

namespace QtShiva {
  
  class SourceParametersWidget : public ParametersWidgetBase {
    class SourceParametrisation;
    public:
      SourceParametersWidget( QWidget* );
      ~SourceParametersWidget();
      void setSource( const OpenShiva::Source* );
      const std::map< GTLCore::String, GTLCore::Value>& parameters() const;
    private:
      struct Private;
      Private* const d;
  };
};

#endif
