/***************************************************************************
                          alsound.cpp  -  description
                             -------------------
    begin                : Wed Jan 21 2004
    copyright            : (C) 2004 by Harald Krippel
    email                : harald@hte-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 * todo:                                                                   *
 *       make memberfunctins to get boxobjtrans and set boxobjtrans        *
 *       make memberfunctins to get snd and set snd                        *
 ***************************************************************************/

/**
 * @class AlSound
 * @brief The AlSound class set and manipulate an OpenAL sound Object
 */

#include <alsound.hpp>

AlSound::AlSound(void)
{
  snd = 0;
  boxobjtrans = NULL;
  Audio=AudioEnv::theInstance();
}

/*!
 set the sound position to x,y,z coordinate
*/
void AlSound::setPosition (float x, float y, float z)
{
     pos.xyz[0]=x;
     pos.xyz[0]=y;
     pos.xyz[0]=z;
     Audio->SetSourcePosition( snd, pos.xyz);
}

/*!
 play the sound
*/
int AlSound::Play()
{
    if(snd != 0 && Audio->IsPlaying(snd) == 0)
    {
       Audio->Play(snd);
    }
    return 0;
}

/*!
 stop the sound
*/
int AlSound::Stop()
{
    if(snd != 0 && Audio->IsPlaying(snd) == 1){
       Audio->Stop(snd);
    }
    return 0;
}

/*!
 set the sound attribute flag loop
*/
void AlSound::Loop(int flag)
{
    if(snd != 0 ){
       Audio->Loop(snd,flag);
    }
}

/*!
 set the sound attribute flag relative
*/
void AlSound::Relative(int flag)
{
    if(snd != 0 ){
       Audio->Relative(snd,flag);
    }
}

/*!
 adjust the volume of the sound
*/
void AlSound::adjustVolume(float gain)
{
    if(snd != 0 ){
       Audio->SetSourceGain (snd, gain);
    }
}

/*!
 load the sound file
*/
int AlSound::loadFile(const QString &file)
{
   snd = Audio->LoadFile(file.toAscii().constData(), false);
   return 0;
}
    
AlSound::~AlSound()
{
   if (AudioEnv *Audio=AudioEnv::theInstance()) {
      delete Audio;
   }
}
