/***************************************************************************
                              qgswcsserver.h
                              -------------------
  begin                : December 9, 2013
  copyright            : (C) 2013 by René-Luc D'Hont
  email                : rldhont at 3liz dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QGSWCSSERVER_H
#define QGSWCSSERVER_H

#include <QDomDocument>
#include <QMap>
#include <QString>
#include <map>
#include "qgis.h"
#include "qgsowsserver.h"

class QgsWCSProjectParser;
class QgsRequestHandler;

/**This class handles all the wcs server requests. The parameters and values have to be passed in the form of
a map<QString, QString>. This map is usually generated by a subclass of QgsWMSRequestHandler, which makes QgsWCSServer
independent from any server side technology*/

class QgsWCSServer: public QgsOWSServer
{
  public:
    /**Constructor. Takes parameter map and a pointer to a renderer object (does not take ownership)*/
    QgsWCSServer( const QString& configFilePath, QMap<QString, QString>& parameters, QgsWCSProjectParser* pp,
                  QgsRequestHandler* rh );
    ~QgsWCSServer();

    void executeRequest() override;

    /**Returns an XML file with the capabilities description (as described in the WFS specs)*/
    QDomDocument getCapabilities();

    /**Returns an XML file with the describe Coverage (as described in the WCS specs)*/
    QDomDocument describeCoverage();

    /**Creates a file which is the result of the getCoverage request.*/
    QByteArray* getCoverage();

    /**Sets configuration parser for administration settings. Does not take ownership*/
    void setAdminConfigParser( QgsWCSProjectParser* parser ) { mConfigParser = parser; }

  private:
    /**Don't use the default constructor*/
    QgsWCSServer();

    /**Get service address from REQUEST_URI if not specified in the configuration*/
    QString serviceUrl() const;

    QgsWCSProjectParser* mConfigParser;

};

#endif
