/*
    Copyright (c) 2009 by Nigmatullin Ruslan <euroelessar@gmail.com>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************
*/

#include "spellerhighlighter.h"

SpellerHighlighter::SpellerHighlighter( QTextEdit *edit ) : QSyntaxHighlighter(edit)
{
	m_active = true;
}

void SpellerHighlighter::setActive( bool active )
{
	if( m_active == active )
		return;
	m_active = active;
	rehighlight();
}

void SpellerHighlighter::highlightBlock ( const QString &text )
{
#if 0
	static QRegExp regexp("\\b\\w+\\b");
	int pos = 0;
	while( ( ( pos = regexp.indexIn( text, pos ) ) != -1 ) )
	{
		int length = regexp.matchedLength();
		if( !MacSpeller::instance().isCorrect( regexp.cap() ) )
			setFormat( pos, length, QTextCharFormat::SpellCheckUnderline );
		pos += length;
	}
#else
	Q_UNUSED(text);
#endif
}
