#ifndef ABINIT_H
#define ABINIT_H

#include <glib.h>
#include <gio/gio.h>
#include <config.h>
#include <visu_data.h>

#ifdef HAVE_ABINIT_SYMMETRY
#include <ab6_symmetry.h>
#endif
#include <ab6_invars.h>

struct _abinitData
{
  VisuData *data;
  GCancellable *cancel;
  GError *error;

  /* Queue to send messages from V_Sim to ABINIT thread. */
  GAsyncQueue *signals;
  gboolean useSignals;

  /* Queue to send messages from the ABINIT thread to
     V_Sim. */
  GAsyncQueue *messages;
  gboolean getMessages;

  /* Data for the invars part. */
  Ab6Invars *dt;
  gchar *filename;
  int nSet;
  gboolean isABFormat;

  /* Data for the symmetries. */
  Ab6Symmetry *sym;
};
typedef struct _abinitData AbinitData;

void abinit_mutexInit();
void abinit_mutexRelease();
void abinit_mutexUnlock();
AbinitData* abinit_getDt();
AbinitData* abinit_getDirectDt();

#endif
