/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import java.util.ArrayList;
import java.util.Map;
import org.apache.ddlutils.alteration.TableChangeImplBase;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;

public class ColumnOrderChange
extends TableChangeImplBase {
    private Map _newPositions;

    public ColumnOrderChange(Table table, Map newPositions) {
        super(table);
        this._newPositions = newPositions;
    }

    public int getNewPosition(Column sourceColumn) {
        Integer newPos = (Integer)this._newPositions.get(sourceColumn);
        return newPos == null ? -1 : newPos;
    }

    public void apply(Database database, boolean caseSensitive) {
        int idx;
        Table table = database.findTable(this.getChangedTable().getName(), caseSensitive);
        ArrayList<Column> newColumns = new ArrayList<Column>(table.getColumnCount());
        for (idx = 0; idx < table.getColumnCount(); ++idx) {
            Column column = table.getColumn(idx);
            int newPos = this.getNewPosition(column);
            newColumns.set(newPos < 0 ? idx : newPos, column);
        }
        for (idx = 0; idx < table.getColumnCount(); ++idx) {
            table.removeColumn(idx);
        }
        table.addColumns(newColumns);
    }
}

