/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata;

import com.google.common.base.Preconditions;
import java.util.SortedMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.ServicerForMetadataTable;
import org.apache.accumulo.core.metadata.ServicerForRootTable;
import org.apache.accumulo.core.metadata.ServicerForUserTables;

public abstract class MetadataServicer {
    public static MetadataServicer forTableName(ClientContext context, String tableName) throws AccumuloException, AccumuloSecurityException {
        Preconditions.checkArgument((tableName != null ? 1 : 0) != 0, (Object)"tableName is null");
        return MetadataServicer.forTableId(context, TableId.of(context.tableOperations().tableIdMap().get(tableName)));
    }

    public static MetadataServicer forTableId(ClientContext context, TableId tableId) {
        Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"tableId is null");
        if (RootTable.ID.equals(tableId)) {
            return new ServicerForRootTable(context);
        }
        if (MetadataTable.ID.equals(tableId)) {
            return new ServicerForMetadataTable(context);
        }
        return new ServicerForUserTables(context, tableId);
    }

    public abstract TableId getServicedTableId();

    public abstract void getTabletLocations(SortedMap<KeyExtent, String> var1) throws AccumuloException, AccumuloSecurityException, TableNotFoundException;
}

