/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.compactor;

import com.google.common.annotations.VisibleForTesting;
import org.apache.accumulo.compactor.CompactionJobHolder;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.spi.compaction.CompactionKind;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionReason;
import org.apache.accumulo.core.tabletserver.thrift.TExternalCompactionJob;
import org.apache.accumulo.core.util.ratelimit.NullRateLimiter;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.compaction.FileCompactor;
import org.apache.accumulo.server.iterators.SystemIteratorEnvironment;
import org.apache.accumulo.server.iterators.SystemIteratorEnvironmentImpl;

public class ExtCEnv
implements FileCompactor.CompactionEnv {
    private final CompactionJobHolder jobHolder;
    private final TExternalCompactionJob job;
    private final String queueName;

    ExtCEnv(CompactionJobHolder jobHolder, String queueName) {
        this.jobHolder = jobHolder;
        this.job = jobHolder.getJob();
        this.queueName = queueName;
    }

    public boolean isCompactionEnabled() {
        return !this.jobHolder.isCancelled();
    }

    public IteratorUtil.IteratorScope getIteratorScope() {
        return IteratorUtil.IteratorScope.majc;
    }

    public RateLimiter getReadLimiter() {
        return NullRateLimiter.INSTANCE;
    }

    public RateLimiter getWriteLimiter() {
        return NullRateLimiter.INSTANCE;
    }

    public SystemIteratorEnvironment createIteratorEnv(ServerContext context, AccumuloConfiguration acuTableConf, TableId tableId) {
        CompactorIterEnv.Builder builder = new CompactorIterEnv.Builder(context, this.queueName);
        builder.withScope(IteratorUtil.IteratorScope.majc).withTableId(tableId);
        if (CompactionKind.valueOf((String)this.job.getKind().name()) == CompactionKind.USER) {
            builder.isUserCompaction();
        }
        if (!this.jobHolder.getJob().isPropagateDeletes()) {
            builder.isFullMajorCompaction();
        }
        return builder.build();
    }

    public SortedKeyValueIterator<Key, Value> getMinCIterator() {
        throw new UnsupportedOperationException();
    }

    public TCompactionReason getReason() {
        switch (this.job.getKind()) {
            case USER: {
                return TCompactionReason.USER;
            }
            case CHOP: {
                return TCompactionReason.CHOP;
            }
        }
        return TCompactionReason.SYSTEM;
    }

    public static class CompactorIterEnv
    extends SystemIteratorEnvironmentImpl {
        private final String queueName;

        public CompactorIterEnv(Builder builder) {
            super((SystemIteratorEnvironmentImpl.Builder)builder);
            this.queueName = builder.queueName;
        }

        @VisibleForTesting
        public String getQueueName() {
            return this.queueName;
        }

        private static class Builder
        extends SystemIteratorEnvironmentImpl.Builder {
            private final String queueName;

            public Builder(ServerContext context, String queueName) {
                super(context);
                this.queueName = queueName;
            }

            public SystemIteratorEnvironmentImpl build() {
                return new CompactorIterEnv(this);
            }
        }
    }
}

