/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.upgrade;

import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameMasterDirInZK {
    private static final Logger LOG = LoggerFactory.getLogger(RenameMasterDirInZK.class);

    public static void main(String[] args) {
        ServerContext ctx = new ServerContext(SiteConfiguration.auto());
        if (!RenameMasterDirInZK.renameMasterDirInZK(ctx)) {
            LOG.info("Masters directory in ZooKeeper has already been renamed to managers. No action was taken.");
        }
    }

    public static boolean renameMasterDirInZK(ServerContext context) {
        ZooReaderWriter zoo = context.getZooReaderWriter();
        String mastersZooDir = context.getZooKeeperRoot() + "/masters";
        String managersZooDir = context.getZooKeeperRoot() + "/managers";
        try {
            boolean mastersDirExists = zoo.exists(mastersZooDir);
            if (mastersDirExists) {
                LOG.info("Copying ZooKeeper directory {} to {}.", (Object)mastersZooDir, (Object)managersZooDir);
                zoo.recursiveCopyPersistentOverwrite(mastersZooDir, managersZooDir);
                LOG.info("Deleting ZooKeeper directory {}.", (Object)mastersZooDir);
                zoo.recursiveDelete(mastersZooDir, ZooUtil.NodeMissingPolicy.SKIP);
            }
            return mastersDirExists;
        }
        catch (InterruptedException | KeeperException e) {
            throw new RuntimeException("Unable to rename " + mastersZooDir + " in ZooKeeper", e);
        }
    }
}

