/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Credentials;
import org.apache.accumulo.core.clientImpl.Namespaces;
import org.apache.accumulo.core.clientImpl.thrift.ClientService;
import org.apache.accumulo.core.clientImpl.thrift.ConfigurationType;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.TDiskUsage;
import org.apache.accumulo.core.clientImpl.thrift.TVersionedProperties;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.master.thrift.BulkImportState;
import org.apache.accumulo.core.master.thrift.BulkImportStatus;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.client.BulkImporter;
import org.apache.accumulo.server.conf.NamespaceConfiguration;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.conf.store.NamespacePropKey;
import org.apache.accumulo.server.conf.store.SystemPropKey;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.util.ServerBulkImportStatus;
import org.apache.accumulo.server.util.TableDiskUsage;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientServiceHandler
implements ClientService.Iface {
    private static final Logger log = LoggerFactory.getLogger(ClientServiceHandler.class);
    protected final TransactionWatcher transactionWatcher;
    protected final ServerContext context;
    protected final AuditedSecurityOperation security;
    private final ServerBulkImportStatus bulkImportStatus = new ServerBulkImportStatus();

    public ClientServiceHandler(ServerContext context, TransactionWatcher transactionWatcher) {
        this.context = context;
        this.transactionWatcher = transactionWatcher;
        this.security = context.getSecurityOperation();
    }

    public static TableId checkTableId(ClientContext context, String tableName, TableOperation operation) throws ThriftTableOperationException {
        TableOperationExceptionType reason = null;
        try {
            return context._getTableIdDetectNamespaceNotFound(tableName);
        }
        catch (NamespaceNotFoundException e) {
            reason = TableOperationExceptionType.NAMESPACE_NOTFOUND;
        }
        catch (TableNotFoundException e) {
            reason = TableOperationExceptionType.NOTFOUND;
        }
        throw new ThriftTableOperationException(null, tableName, operation, reason, null);
    }

    public static NamespaceId checkNamespaceId(ClientContext context, String namespaceName, TableOperation operation) throws ThriftTableOperationException {
        NamespaceId namespaceId = Namespaces.lookupNamespaceId((ClientContext)context, (String)namespaceName);
        if (namespaceId == null) {
            context.clearTableListCache();
            namespaceId = Namespaces.lookupNamespaceId((ClientContext)context, (String)namespaceName);
            if (namespaceId == null) {
                throw new ThriftTableOperationException(null, namespaceName, operation, TableOperationExceptionType.NAMESPACE_NOTFOUND, null);
            }
        }
        return namespaceId;
    }

    public String getInstanceId() {
        return this.context.getInstanceID().canonical();
    }

    public String getRootTabletLocation() {
        return this.context.getRootTabletLocation();
    }

    public String getZooKeepers() {
        return this.context.getZooKeepers();
    }

    public void ping(TCredentials credentials) {
        log.info("Manager reports: I just got pinged!");
    }

    public boolean authenticate(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException {
        try {
            return this.security.authenticateUser(credentials, credentials);
        }
        catch (ThriftSecurityException e) {
            log.error("ThriftSecurityException", (Throwable)e);
            throw e;
        }
    }

    public boolean authenticateUser(TInfo tinfo, TCredentials credentials, TCredentials toAuth) throws ThriftSecurityException {
        try {
            return this.security.authenticateUser(credentials, toAuth);
        }
        catch (ThriftSecurityException e) {
            log.error("ThriftSecurityException", (Throwable)e);
            throw e;
        }
    }

    public void changeAuthorizations(TInfo tinfo, TCredentials credentials, String user, List<ByteBuffer> authorizations) throws ThriftSecurityException {
        this.security.changeAuthorizations(credentials, user, new Authorizations(authorizations));
    }

    public void changeLocalUserPassword(TInfo tinfo, TCredentials credentials, String principal, ByteBuffer password) throws ThriftSecurityException {
        PasswordToken token = new PasswordToken(password);
        Credentials toChange = new Credentials(principal, (AuthenticationToken)token);
        this.security.changePassword(credentials, toChange);
    }

    public void createLocalUser(TInfo tinfo, TCredentials credentials, String principal, ByteBuffer password) throws ThriftSecurityException {
        KerberosToken token;
        if (this.context.getSaslParams() != null) {
            try {
                token = new KerberosToken();
            }
            catch (IOException e) {
                log.warn("Failed to create KerberosToken");
                throw new ThriftSecurityException(e.getMessage(), SecurityErrorCode.DEFAULT_SECURITY_ERROR);
            }
        } else {
            token = new PasswordToken(password);
        }
        Credentials newUser = new Credentials(principal, (AuthenticationToken)token);
        this.security.createUser(credentials, newUser, new Authorizations());
    }

    public void dropLocalUser(TInfo tinfo, TCredentials credentials, String user) throws ThriftSecurityException {
        this.security.dropUser(credentials, user);
    }

    public List<ByteBuffer> getUserAuthorizations(TInfo tinfo, TCredentials credentials, String user) throws ThriftSecurityException {
        return this.security.getUserAuthorizations(credentials, user).getAuthorizationsBB();
    }

    public void grantSystemPermission(TInfo tinfo, TCredentials credentials, String user, byte permission) throws ThriftSecurityException {
        this.security.grantSystemPermission(credentials, user, SystemPermission.getPermissionById((byte)permission));
    }

    public void grantTablePermission(TInfo tinfo, TCredentials credentials, String user, String tableName, byte permission) throws TException {
        TableId tableId = ClientServiceHandler.checkTableId(this.context, tableName, TableOperation.PERMISSION);
        try {
            NamespaceId namespaceId = this.context.getNamespaceId(tableId);
            this.security.grantTablePermission(credentials, user, tableId, tableName, TablePermission.getPermissionById((byte)permission), namespaceId);
        }
        catch (TableNotFoundException e) {
            throw new TException((Throwable)e);
        }
    }

    public void grantNamespacePermission(TInfo tinfo, TCredentials credentials, String user, String ns, byte permission) throws ThriftSecurityException, ThriftTableOperationException {
        NamespaceId namespaceId = ClientServiceHandler.checkNamespaceId(this.context, ns, TableOperation.PERMISSION);
        this.security.grantNamespacePermission(credentials, user, namespaceId, NamespacePermission.getPermissionById((byte)permission));
    }

    public void revokeSystemPermission(TInfo tinfo, TCredentials credentials, String user, byte permission) throws ThriftSecurityException {
        this.security.revokeSystemPermission(credentials, user, SystemPermission.getPermissionById((byte)permission));
    }

    public void revokeTablePermission(TInfo tinfo, TCredentials credentials, String user, String tableName, byte permission) throws TException {
        NamespaceId namespaceId;
        TableId tableId = ClientServiceHandler.checkTableId(this.context, tableName, TableOperation.PERMISSION);
        try {
            namespaceId = this.context.getNamespaceId(tableId);
        }
        catch (TableNotFoundException e) {
            throw new TException((Throwable)e);
        }
        this.security.revokeTablePermission(credentials, user, tableId, TablePermission.getPermissionById((byte)permission), namespaceId);
    }

    public boolean hasSystemPermission(TInfo tinfo, TCredentials credentials, String user, byte sysPerm) throws ThriftSecurityException {
        return this.security.hasSystemPermission(credentials, user, SystemPermission.getPermissionById((byte)sysPerm));
    }

    public boolean hasTablePermission(TInfo tinfo, TCredentials credentials, String user, String tableName, byte tblPerm) throws ThriftSecurityException, ThriftTableOperationException {
        TableId tableId = ClientServiceHandler.checkTableId(this.context, tableName, TableOperation.PERMISSION);
        return this.security.hasTablePermission(credentials, user, tableId, TablePermission.getPermissionById((byte)tblPerm));
    }

    public boolean hasNamespacePermission(TInfo tinfo, TCredentials credentials, String user, String ns, byte perm) throws ThriftSecurityException, ThriftTableOperationException {
        NamespaceId namespaceId = ClientServiceHandler.checkNamespaceId(this.context, ns, TableOperation.PERMISSION);
        return this.security.hasNamespacePermission(credentials, user, namespaceId, NamespacePermission.getPermissionById((byte)perm));
    }

    public void revokeNamespacePermission(TInfo tinfo, TCredentials credentials, String user, String ns, byte permission) throws ThriftSecurityException, ThriftTableOperationException {
        NamespaceId namespaceId = ClientServiceHandler.checkNamespaceId(this.context, ns, TableOperation.PERMISSION);
        this.security.revokeNamespacePermission(credentials, user, namespaceId, NamespacePermission.getPermissionById((byte)permission));
    }

    public Set<String> listLocalUsers(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException {
        return this.security.listUsers(credentials);
    }

    private Map<String, String> conf(TCredentials credentials, AccumuloConfiguration conf) throws TException {
        conf.invalidateCache();
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : conf) {
            String key = (String)entry.getKey();
            if (Property.isSensitive((String)key)) continue;
            result.put(key, (String)entry.getValue());
        }
        return result;
    }

    private boolean checkSystemUserAndAuthenticate(TCredentials credentials) throws ThriftSecurityException {
        return this.security.isSystemUser(credentials) && this.security.authenticateUser(credentials, credentials);
    }

    private void checkSystemPermission(TCredentials credentials) throws ThriftSecurityException {
        if (!this.checkSystemUserAndAuthenticate(credentials) && !this.security.hasSystemPermission(credentials, credentials.getPrincipal(), SystemPermission.SYSTEM)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
    }

    private void checkTablePermission(TCredentials credentials, TableId tableId, TablePermission tablePermission) throws ThriftSecurityException {
        if (!(this.checkSystemUserAndAuthenticate(credentials) || this.security.hasSystemPermission(credentials, credentials.getPrincipal(), SystemPermission.SYSTEM) || this.security.hasTablePermission(credentials, credentials.getPrincipal(), tableId, tablePermission))) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
    }

    private void checkNamespacePermission(TCredentials credentials, NamespaceId namespaceId, NamespacePermission namespacePermission) throws ThriftSecurityException {
        if (!(this.checkSystemUserAndAuthenticate(credentials) || this.security.hasSystemPermission(credentials, credentials.getPrincipal(), SystemPermission.SYSTEM) || this.security.hasNamespacePermission(credentials, credentials.getPrincipal(), namespaceId, namespacePermission))) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
    }

    public Map<String, String> getConfiguration(TInfo tinfo, TCredentials credentials, ConfigurationType type) throws TException {
        this.checkSystemPermission(credentials);
        switch (type) {
            case CURRENT: {
                this.context.getPropStore().getCache().remove(SystemPropKey.of(this.context));
                return this.conf(credentials, this.context.getConfiguration());
            }
            case SITE: {
                return this.conf(credentials, (AccumuloConfiguration)this.context.getSiteConfiguration());
            }
            case DEFAULT: {
                return this.conf(credentials, (AccumuloConfiguration)this.context.getDefaultConfiguration());
            }
        }
        throw new RuntimeException("Unexpected configuration type " + String.valueOf(type));
    }

    public Map<String, String> getSystemProperties(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException {
        this.checkSystemPermission(credentials);
        return this.context.getPropStore().get(SystemPropKey.of(this.context)).asMap();
    }

    public TVersionedProperties getVersionedSystemProperties(TInfo tinfo, TCredentials credentials) throws ThriftSecurityException {
        this.checkSystemPermission(credentials);
        return Optional.of(this.context.getPropStore().get(SystemPropKey.of(this.context))).map(vProps -> new TVersionedProperties(vProps.getDataVersion(), vProps.asMap())).orElseThrow();
    }

    public Map<String, String> getTableConfiguration(TInfo tinfo, TCredentials credentials, String tableName) throws TException, ThriftTableOperationException {
        TableId tableId = ClientServiceHandler.checkTableId(this.context, tableName, null);
        this.checkTablePermission(credentials, tableId, TablePermission.ALTER_TABLE);
        this.context.getPropStore().getCache().remove(TablePropKey.of(this.context, tableId));
        TableConfiguration config = this.context.getTableConfiguration(tableId);
        return this.conf(credentials, config);
    }

    public Map<String, String> getTableProperties(TInfo tinfo, TCredentials credentials, String tableName) throws TException {
        TableId tableId = ClientServiceHandler.checkTableId(this.context, tableName, null);
        this.checkTablePermission(credentials, tableId, TablePermission.ALTER_TABLE);
        return this.context.getPropStore().get(TablePropKey.of(this.context, tableId)).asMap();
    }

    public TVersionedProperties getVersionedTableProperties(TInfo tinfo, TCredentials credentials, String tableName) throws TException {
        TableId tableId = ClientServiceHandler.checkTableId(this.context, tableName, null);
        this.checkTablePermission(credentials, tableId, TablePermission.ALTER_TABLE);
        return Optional.of(this.context.getPropStore().get(TablePropKey.of(this.context, tableId))).map(vProps -> new TVersionedProperties(vProps.getDataVersion(), vProps.asMap())).orElseThrow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> bulkImportFiles(TInfo tinfo, TCredentials credentials, long tid, String tableId, List<String> files, String errorDir, boolean setTime) throws ThriftSecurityException, ThriftTableOperationException, TException {
        if (!this.security.canPerformSystemActions(credentials)) {
            throw new AccumuloSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        this.bulkImportStatus.updateBulkImportStatus(files, BulkImportState.INITIAL);
        log.debug("Got request to bulk import files to table({}): {}", (Object)tableId, files);
        this.bulkImportStatus.updateBulkImportStatus(files, BulkImportState.PROCESSING);
        try {
            List<String> list = BulkImporter.bulkLoad(this.context, tid, tableId, files, setTime);
            this.bulkImportStatus.removeBulkImportStatus(files);
            return list;
        }
        catch (Throwable throwable) {
            try {
                this.bulkImportStatus.removeBulkImportStatus(files);
                throw throwable;
            }
            catch (AccumuloSecurityException e) {
                throw e.asThriftException();
            }
            catch (Exception ex) {
                throw new TException((Throwable)ex);
            }
        }
    }

    public boolean isActive(TInfo tinfo, long tid) {
        return this.transactionWatcher.isActive(tid);
    }

    public boolean checkClass(TInfo tinfo, TCredentials credentials, String className, String interfaceMatch) throws TException {
        this.security.authenticateUser(credentials, credentials);
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            Class<?> shouldMatch = loader.loadClass(interfaceMatch);
            Class test = ClassLoaderUtil.loadClass((String)className, shouldMatch);
            test.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return true;
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            log.warn("Error checking object types", (Throwable)e);
            return false;
        }
    }

    public boolean checkTableClass(TInfo tinfo, TCredentials credentials, String tableName, String className, String interfaceMatch) throws TException, ThriftTableOperationException, ThriftSecurityException {
        this.security.authenticateUser(credentials, credentials);
        TableId tableId = ClientServiceHandler.checkTableId(this.context, tableName, null);
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            Class<?> shouldMatch = loader.loadClass(interfaceMatch);
            TableConfiguration conf = this.context.getTableConfiguration(tableId);
            String context = ClassLoaderUtil.tableContext((AccumuloConfiguration)conf);
            Class test = ClassLoaderUtil.loadClass((String)context, (String)className, shouldMatch);
            test.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return true;
        }
        catch (Exception e) {
            log.warn("Error checking object types", (Throwable)e);
            return false;
        }
    }

    public boolean checkNamespaceClass(TInfo tinfo, TCredentials credentials, String ns, String className, String interfaceMatch) throws TException, ThriftTableOperationException, ThriftSecurityException {
        this.security.authenticateUser(credentials, credentials);
        NamespaceId namespaceId = ClientServiceHandler.checkNamespaceId(this.context, ns, null);
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            Class<?> shouldMatch = loader.loadClass(interfaceMatch);
            NamespaceConfiguration conf = this.context.getNamespaceConfiguration(namespaceId);
            String context = ClassLoaderUtil.tableContext((AccumuloConfiguration)conf);
            Class test = ClassLoaderUtil.loadClass((String)context, (String)className, shouldMatch);
            test.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return true;
        }
        catch (Exception e) {
            log.warn("Error checking object types", (Throwable)e);
            return false;
        }
    }

    public List<TDiskUsage> getDiskUsage(Set<String> tables, TCredentials credentials) throws ThriftTableOperationException, ThriftSecurityException, TException {
        try {
            HashSet<TableId> tableIds = new HashSet<TableId>();
            for (String table : tables) {
                TableId tableId = ClientServiceHandler.checkTableId(this.context, table, null);
                tableIds.add(tableId);
                NamespaceId namespaceId = this.context.getNamespaceId(tableId);
                if (this.security.canScan(credentials, tableId, namespaceId)) continue;
                throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
            }
            Map<SortedSet<String>, Long> diskUsage = TableDiskUsage.getDiskUsage(tableIds, (AccumuloClient)this.context);
            ArrayList<TDiskUsage> retUsages = new ArrayList<TDiskUsage>();
            for (Map.Entry<SortedSet<String>, Long> usageItem : diskUsage.entrySet()) {
                retUsages.add(new TDiskUsage(new ArrayList(usageItem.getKey()), usageItem.getValue().longValue()));
            }
            return retUsages;
        }
        catch (TableNotFoundException e) {
            throw new TException((Throwable)e);
        }
    }

    public Map<String, String> getNamespaceConfiguration(TInfo tinfo, TCredentials credentials, String ns) throws ThriftTableOperationException, TException {
        NamespaceId namespaceId;
        try {
            namespaceId = Namespaces.getNamespaceId((ClientContext)this.context, (String)ns);
        }
        catch (NamespaceNotFoundException e) {
            String why = "Could not find namespace while getting configuration.";
            throw new ThriftTableOperationException(null, ns, null, TableOperationExceptionType.NAMESPACE_NOTFOUND, why);
        }
        this.checkNamespacePermission(credentials, namespaceId, NamespacePermission.ALTER_NAMESPACE);
        this.context.getPropStore().getCache().remove(NamespacePropKey.of(this.context, namespaceId));
        NamespaceConfiguration config = this.context.getNamespaceConfiguration(namespaceId);
        return this.conf(credentials, config);
    }

    public Map<String, String> getNamespaceProperties(TInfo tinfo, TCredentials credentials, String ns) throws TException {
        try {
            NamespaceId namespaceId = Namespaces.getNamespaceId((ClientContext)this.context, (String)ns);
            this.checkNamespacePermission(credentials, namespaceId, NamespacePermission.ALTER_NAMESPACE);
            return this.context.getPropStore().get(NamespacePropKey.of(this.context, namespaceId)).asMap();
        }
        catch (NamespaceNotFoundException e) {
            String why = "Could not find namespace while getting configuration.";
            throw new ThriftTableOperationException(null, ns, null, TableOperationExceptionType.NAMESPACE_NOTFOUND, why);
        }
    }

    public TVersionedProperties getVersionedNamespaceProperties(TInfo tinfo, TCredentials credentials, String ns) throws TException {
        try {
            NamespaceId namespaceId = Namespaces.getNamespaceId((ClientContext)this.context, (String)ns);
            this.checkNamespacePermission(credentials, namespaceId, NamespacePermission.ALTER_NAMESPACE);
            return Optional.of(this.context.getPropStore().get(NamespacePropKey.of(this.context, namespaceId))).map(vProps -> new TVersionedProperties(vProps.getDataVersion(), vProps.asMap())).orElseThrow();
        }
        catch (NamespaceNotFoundException e) {
            String why = "Could not find namespace while getting configuration.";
            throw new ThriftTableOperationException(null, ns, null, TableOperationExceptionType.NAMESPACE_NOTFOUND, why);
        }
    }

    public List<BulkImportStatus> getBulkLoadStatus() {
        return this.bulkImportStatus.getBulkLoadStatus();
    }
}

