/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.util.impl;

import jakarta.xml.soap.Detail;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPFault;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.soap.SOAPPart;
import jakarta.xml.ws.WebServiceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.util.SAAJConverter;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.axis2.jaxws.utility.SAAJFactory;
import org.apache.axis2.saaj.SOAPElementImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class SAAJConverterImpl
implements SAAJConverter {
    private static final Log log = LogFactory.getLog(SAAJConverterImpl.class);

    SAAJConverterImpl() {
    }

    @Override
    public jakarta.xml.soap.SOAPEnvelope toSAAJ(SOAPEnvelope omEnvelope) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Converting OM SOAPEnvelope to SAAJ SOAPEnvelope");
            log.debug((Object)("The conversion occurs due to " + JavaUtils.stackToString()));
        }
        jakarta.xml.soap.SOAPEnvelope soapEnvelope = null;
        try {
            SOAPHeader soapHeader;
            OMNamespace ns = omEnvelope.getNamespace();
            MessageFactory mf = this.createMessageFactory(ns.getNamespaceURI());
            SOAPMessage sm = mf.createMessage();
            SOAPPart sp = sm.getSOAPPart();
            soapEnvelope = sp.getEnvelope();
            SOAPBody soapBody = soapEnvelope.getBody();
            if (soapBody != null) {
                soapBody.detachNode();
            }
            if ((soapHeader = soapEnvelope.getHeader()) != null) {
                soapHeader.detachNode();
            }
            XMLStreamReader reader = omEnvelope.getXMLStreamReader();
            NameCreator nc = new NameCreator(soapEnvelope);
            this.buildSOAPTree(nc, (SOAPElement)soapEnvelope, null, reader, false);
        }
        catch (WebServiceException e) {
            throw e;
        }
        catch (SOAPException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        return soapEnvelope;
    }

    @Override
    public SOAPEnvelope toOM(jakarta.xml.soap.SOAPEnvelope saajEnvelope) {
        return this.toOM(saajEnvelope, null);
    }

    @Override
    public SOAPEnvelope toOM(jakarta.xml.soap.SOAPEnvelope saajEnvelope, Attachments attachments) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Converting SAAJ SOAPEnvelope to an OM SOAPEnvelope");
            log.debug((Object)("The conversion occurs due to " + JavaUtils.stackToString()));
        }
        this._fixFaultElements(saajEnvelope);
        SOAPModelBuilder builder = attachments != null ? OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)OMAbstractFactory.getMetaFactory(), (Source)new DOMSource((Node)saajEnvelope), (OMAttachmentAccessor)attachments) : OMXMLBuilderFactory.createSOAPModelBuilder((Source)new DOMSource((Node)saajEnvelope));
        SOAPEnvelope omEnvelope = builder.getSOAPEnvelope();
        try {
            omEnvelope.build();
        }
        catch (Exception ex) {
            try {
                return this.toOM(this.toString(saajEnvelope));
            }
            catch (TransformerException e) {
                throw ExceptionFactory.makeWebServiceException((Throwable)e);
            }
        }
        return omEnvelope;
    }

    private SOAPEnvelope toOM(String xml) throws WebServiceException {
        XMLStreamReader reader;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Converting SAAJ SOAPEnvelope String to an OM SOAPEnvelope");
            log.debug((Object)("The conversion occurs due to " + JavaUtils.stackToString()));
        }
        try {
            reader = StAXUtils.createXMLStreamReader((InputStream)new ByteArrayInputStream(xml.getBytes()));
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        SOAPModelBuilder builder = OMXMLBuilderFactory.createStAXSOAPModelBuilder((XMLStreamReader)reader);
        return builder.getSOAPEnvelope();
    }

    private String toString(jakarta.xml.soap.SOAPEnvelope saajEnvelope) throws TransformerException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.transform(new DOMSource(saajEnvelope.getOwnerDocument()), new StreamResult(baos));
        return new String(baos.toByteArray());
    }

    @Override
    public OMElement toOM(SOAPElement soapElement) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Converting SAAJ SOAPElement to an OMElement");
            log.debug((Object)("The conversion occurs due to " + JavaUtils.stackToString()));
        }
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createOMBuilder((Source)new DOMSource((Node)soapElement));
        OMElement om = builder.getDocumentElement();
        om.build();
        return om;
    }

    @Override
    public SOAPElement toSAAJ(OMElement omElement, SOAPElement parent) throws WebServiceException {
        SOAPElement env;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Converting OMElement: " + omElement.getText() + " to an SAAJ SOAPElement"));
            log.debug((Object)("The conversion occurs due to " + JavaUtils.stackToString()));
        }
        XMLStreamReader reader = null;
        reader = omElement.getBuilder() == null ? omElement.getXMLStreamReader() : omElement.getXMLStreamReaderWithoutCaching();
        for (env = parent; env != null && !(env instanceof jakarta.xml.soap.SOAPEnvelope); env = env.getParentElement()) {
        }
        if (env == null) {
            throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SAAJConverterErr1"));
        }
        NameCreator nc = new NameCreator((jakarta.xml.soap.SOAPEnvelope)env);
        return this.buildSOAPTree(nc, null, parent, reader, false);
    }

    @Override
    public SOAPElement toSAAJ(OMElement omElement, SOAPElement parent, SOAPFactory sf) throws WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Converting OMElement to an SAAJ SOAPElement");
            log.debug((Object)("The conversion occurs due to " + JavaUtils.stackToString()));
        }
        XMLStreamReader reader = null;
        reader = omElement.getBuilder() == null ? omElement.getXMLStreamReader() : omElement.getXMLStreamReaderWithoutCaching();
        NameCreator nc = new NameCreator(sf);
        return this.buildSOAPTree(nc, null, parent, reader, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SOAPElement buildSOAPTree(NameCreator nc, SOAPElement root, SOAPElement parent, XMLStreamReader reader, boolean quitAtBody) throws WebServiceException {
        try {
            block19: while (true) {
                if (!reader.hasNext()) {
                    reader.close();
                    return root;
                }
                int eventID = reader.next();
                switch (eventID) {
                    case 1: {
                        if (parent == null) {
                            this.updateTagData(nc, root, reader, false);
                            parent = root;
                        } else {
                            parent = this.createElementFromTag(nc, parent, reader);
                            if (root == null) {
                                root = parent;
                            }
                        }
                        if (!quitAtBody || !(parent instanceof SOAPBody)) continue block19;
                        return root;
                    }
                    case 10: {
                        String eventName = "ATTRIBUTE";
                        this._unexpectedEvent(eventName);
                        continue block19;
                    }
                    case 13: {
                        String eventName = "NAMESPACE";
                        this._unexpectedEvent(eventName);
                        continue block19;
                    }
                    case 2: {
                        if (parent instanceof jakarta.xml.soap.SOAPEnvelope) {
                            parent = null;
                            continue block19;
                        }
                        parent = parent.getParentElement();
                        continue block19;
                    }
                    case 4: {
                        parent.addTextNode(reader.getText());
                        continue block19;
                    }
                    case 12: {
                        parent.addTextNode(reader.getText());
                        continue block19;
                    }
                    case 5: {
                        parent.addTextNode("<!--" + reader.getText() + "-->");
                        continue block19;
                    }
                    case 6: {
                        parent.addTextNode(reader.getText());
                        continue block19;
                    }
                    case 7: {
                        continue block19;
                    }
                    case 8: {
                        continue block19;
                    }
                    case 3: {
                        continue block19;
                    }
                    case 9: {
                        continue block19;
                    }
                    case 11: {
                        continue block19;
                    }
                }
                this._unexpectedEvent("EventID " + String.valueOf(eventID));
            }
        }
        catch (WebServiceException e) {
            throw e;
        }
        catch (XMLStreamException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        catch (SOAPException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    protected SOAPElement createElementFromTag(NameCreator nc, SOAPElement parent, XMLStreamReader reader) throws SOAPException {
        QName qName = reader.getName();
        SOAPElement child = this.createElement(parent, qName);
        this.updateTagData(nc, child, reader, true);
        return child;
    }

    protected SOAPElement createElement(SOAPElement parent, QName qName) throws SOAPException {
        Object child = parent instanceof jakarta.xml.soap.SOAPEnvelope ? (qName.getNamespaceURI().equals(parent.getNamespaceURI()) ? (qName.getLocalPart().equals("Body") ? ((jakarta.xml.soap.SOAPEnvelope)parent).addBody() : ((jakarta.xml.soap.SOAPEnvelope)parent).addHeader()) : parent.addChildElement(qName)) : (parent instanceof SOAPBody ? (qName.getNamespaceURI().equals(parent.getNamespaceURI()) && qName.getLocalPart().equals("Fault") ? ((SOAPBody)parent).addFault() : ((SOAPBody)parent).addBodyElement(qName)) : (parent instanceof SOAPHeader ? ((SOAPHeader)parent).addHeaderElement(qName) : (parent instanceof SOAPFault ? parent.addChildElement(qName) : (parent instanceof Detail ? ((Detail)parent).addDetailEntry(qName) : parent.addChildElement(qName)))));
        return child;
    }

    protected void updateTagData(NameCreator nc, SOAPElement element, XMLStreamReader reader, boolean newElement) throws SOAPException {
        String ns;
        String prefix = reader.getPrefix();
        String string = prefix = prefix == null ? "" : prefix;
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateTagData() proceeding on prefix: " + prefix + " , on element name: " + element.getLocalName()));
        }
        if (prefix.length() > 0 && !element.getPrefix().equals(prefix) && (ns = reader.getNamespaceURI()) != null && ns.length() != 0) {
            element.setPrefix(prefix);
        }
        if (!newElement) {
            int size = reader.getNamespaceCount();
            for (int i = 0; i < size; ++i) {
                String pre = reader.getNamespacePrefix(i);
                String ns2 = reader.getNamespaceURI(i);
                if (pre != null && pre.length() > 0 && (ns2 == null || ns2.length() == 0)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("The prefix is (" + pre + ") but there is no namespace.  This erroneous declaration is skipped."));
                    continue;
                }
                String existingNS = element.getNamespaceURI(pre);
                if (ns2.equals(existingNS)) continue;
                element.removeNamespaceDeclaration(pre);
                element.addNamespaceDeclaration(pre, ns2);
            }
        } else {
            int size = reader.getNamespaceCount();
            for (int i = 0; i < size; ++i) {
                String newPrefix = reader.getNamespacePrefix(i);
                String newNS = reader.getNamespaceURI(i);
                if (newPrefix != null && newPrefix.length() > 0 && (newNS == null || newNS.length() == 0)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("The prefix is (" + newPrefix + ") but there is no namespace.  This erroneous declaration is skipped."));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("updateTagData() proceeding on element.addNamespaceDeclaration() with newPrefix: " + newPrefix + " , newNS: " + newNS + " , on element name: " + element.getLocalName()));
                }
                element.addNamespaceDeclaration(newPrefix, newNS);
            }
        }
        this.addAttributes(nc, element, reader);
    }

    protected void addAttributes(NameCreator nc, SOAPElement element, XMLStreamReader reader) throws SOAPException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"addAttributes: Entry");
        }
        int size = reader.getAttributeCount();
        for (int i = 0; i < size; ++i) {
            QName qName = reader.getAttributeName(i);
            String prefix = reader.getAttributePrefix(i);
            String value = reader.getAttributeValue(i);
            Name name = nc.createName(qName.getLocalPart(), prefix, qName.getNamespaceURI());
            element.addAttribute(name, value);
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Setting attrType");
                }
                String namespace = qName.getNamespaceURI();
                Attr attr = null;
                attr = namespace == null || namespace.length() == 0 ? element.getAttributeNode(qName.getLocalPart()) : element.getAttributeNodeNS(namespace, qName.getLocalPart());
                if (attr == null) continue;
                String attrType = reader.getAttributeType(i);
                attr.setUserData("ATTRIBUTE_TYPE_KEY", attrType, null);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Storing attrType in UserData: " + attrType));
                continue;
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("An error occured while processing attrType: " + e.getMessage()));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"addAttributes: Exit");
        }
    }

    private void _unexpectedEvent(String event) throws WebServiceException {
        throw ExceptionFactory.makeWebServiceException((String)Messages.getMessage((String)"SAAJConverterErr2", (String)event));
    }

    private void _fixFaultElements(jakarta.xml.soap.SOAPEnvelope env) {
        try {
            if (env.getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")) {
                return;
            }
            SOAPBody body = env.getBody();
            if (body != null && !body.hasFault()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No fault found.  No conversion necessary.");
                }
                return;
            }
            if (body != null && body.hasFault()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"A fault was found.  Converting the fault child elements to SOAP 1.1 format");
                }
                SOAPFault fault = body.getFault();
                Iterator itr = fault.getChildElements();
                while (itr.hasNext()) {
                    SOAPElement child;
                    String content;
                    OMElement e;
                    SOAPElementImpl valueElement;
                    Node value;
                    SOAPElement se = (SOAPElement)itr.next();
                    if (se.getLocalName().equals("Code")) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Converting: faultcode");
                        }
                        if ((value = se.getFirstChild()) == null || !(value instanceof SOAPElementImpl)) continue;
                        valueElement = (SOAPElementImpl)value;
                        e = (OMElement)valueElement.getOMTarget();
                        content = e.getText();
                        child = fault.addChildElement(new QName(se.getNamespaceURI(), "faultcode"));
                        child.addTextNode(content);
                        se.detachNode();
                        continue;
                    }
                    if (se.getLocalName().equals("Detail")) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Converting: detail");
                        }
                        se.setElementQName(new QName(se.getNamespaceURI(), "detail"));
                        continue;
                    }
                    if (!se.getLocalName().equals("Reason")) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Converting: faultstring");
                    }
                    se.setElementQName(new QName(se.getNamespaceURI(), "faultstring"));
                    value = se.getFirstChild();
                    if (value == null || !(value instanceof SOAPElementImpl)) continue;
                    valueElement = (SOAPElementImpl)value;
                    e = (OMElement)valueElement.getOMTarget();
                    content = e.getText();
                    child = fault.addChildElement(new QName(se.getNamespaceURI(), "faultstring"));
                    child.addTextNode(content);
                    se.detachNode();
                }
            }
        }
        catch (SOAPException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("An error occured while converting fault elements: " + e.getMessage()));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
    }

    @Override
    public MessageFactory createMessageFactory(String namespace) throws SOAPException, WebServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating a SAAJ MessageFactory " + JavaUtils.stackToString()));
        }
        return SAAJFactory.createMessageFactory(namespace);
    }

    protected class NameCreator {
        private jakarta.xml.soap.SOAPEnvelope env = null;
        private SOAPFactory sf = null;

        public NameCreator(jakarta.xml.soap.SOAPEnvelope env) {
            this.env = env;
        }

        public NameCreator(SOAPFactory sf) {
            this.sf = sf;
        }

        public Name createName(String localName, String prefix, String uri) throws SOAPException {
            if (this.sf != null) {
                return this.sf.createName(localName, prefix, uri);
            }
            return this.env.createName(localName, prefix, uri);
        }
    }
}

