/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.axis2.transport.http.server.AxisHttpConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.EndpointDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.BasicEndpointDetails;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.apache.hc.core5.http.impl.io.AbstractMessageParser;
import org.apache.hc.core5.http.impl.io.ChunkedInputStream;
import org.apache.hc.core5.http.impl.io.ChunkedOutputStream;
import org.apache.hc.core5.http.impl.io.ContentLengthInputStream;
import org.apache.hc.core5.http.impl.io.ContentLengthOutputStream;
import org.apache.hc.core5.http.impl.io.DefaultClassicHttpRequestFactory;
import org.apache.hc.core5.http.impl.io.DefaultHttpRequestParserFactory;
import org.apache.hc.core5.http.impl.io.DefaultHttpResponseWriterFactory;
import org.apache.hc.core5.http.impl.io.IdentityInputStream;
import org.apache.hc.core5.http.impl.io.IdentityOutputStream;
import org.apache.hc.core5.http.impl.io.SessionInputBufferImpl;
import org.apache.hc.core5.http.impl.io.SessionOutputBufferImpl;
import org.apache.hc.core5.http.impl.io.SocketHolder;
import org.apache.hc.core5.http.io.HttpMessageParser;
import org.apache.hc.core5.http.io.HttpMessageWriter;
import org.apache.hc.core5.http.io.SessionInputBuffer;
import org.apache.hc.core5.http.io.SessionOutputBuffer;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EmptyInputStream;
import org.apache.hc.core5.http.message.LazyLineParser;
import org.apache.hc.core5.http.message.LineParser;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.Closer;
import org.apache.hc.core5.net.InetAddressUtils;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.Timeout;

public class AxisHttpConnectionImpl
implements AxisHttpConnection {
    private static final Log HEADERLOG = LogFactory.getLog((String)"org.apache.axis2.transport.http.server.wire");
    private static final Timeout STALE_CHECK_TIMEOUT = Timeout.ofMilliseconds((long)1L);
    private final String scheme;
    private final SessionOutputBufferImpl outbuffer;
    private final SessionInputBufferImpl inbuffer;
    private final HttpMessageParser<ClassicHttpRequest> requestParser;
    private final HttpMessageWriter<ClassicHttpResponse> responseWriter;
    private final ContentLengthStrategy contentLenStrategy;
    private final AtomicReference<SocketHolder> socketHolderRef;
    private final Http1Config http1Config;
    private byte[] chunkedRequestBuffer;
    volatile ProtocolVersion version;
    volatile EndpointDetails endpointDetails;
    private OutputStream out = null;
    private InputStream in = null;

    public AxisHttpConnectionImpl(String scheme, Socket socket, Http1Config http1Config, SocketConfig socketConfig) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (socketConfig == null) {
            throw new IllegalArgumentException("socketConfig may not be null");
        }
        this.scheme = scheme != null ? scheme : URIScheme.HTTP.getId();
        socket.setTcpNoDelay(socketConfig.isTcpNoDelay());
        socket.setSoTimeout(socketConfig.getSoTimeout().toMillisecondsIntBound());
        int linger = socketConfig.getSoLinger().toMillisecondsIntBound();
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
        int buffersize = socketConfig.getRcvBufSize();
        this.inbuffer = new SessionInputBufferImpl(buffersize, 8000);
        this.outbuffer = new SessionOutputBufferImpl(buffersize);
        this.contentLenStrategy = new DefaultContentLengthStrategy();
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        DefaultHttpRequestParserFactory requestParserFactory = new DefaultHttpRequestParserFactory(this.http1Config);
        DefaultHttpResponseWriterFactory responseWriterFactory = new DefaultHttpResponseWriterFactory(this.http1Config);
        this.requestParser = requestParserFactory.create(this.http1Config);
        this.responseWriter = responseWriterFactory.create();
        this.socketHolderRef = new AtomicReference<SocketHolder>(new SocketHolder(socket));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(CloseMode closeMode) {
        SocketHolder socketHolder = this.socketHolderRef.getAndSet(null);
        if (socketHolder != null) {
            Socket socket = socketHolder.getSocket();
            try {
                if (closeMode == CloseMode.IMMEDIATE) {
                    socket.setSoLinger(true, 0);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                Closer.closeQuietly((Closeable)socket);
            }
        }
    }

    public void close() throws IOException {
        if (this.outbuffer != null && this.out != null) {
            this.outbuffer.flush(this.out);
        }
        SocketHolder socketHolder = this.socketHolderRef.getAndSet(null);
        Socket socket = socketHolder.getSocket();
        try {
            socket.shutdownOutput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            socket.shutdownInput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        socket.close();
    }

    public boolean isOpen() {
        return this.socketHolderRef.get() != null;
    }

    public boolean isStale() throws IOException {
        if (!this.isOpen()) {
            return true;
        }
        try {
            int bytesRead = this.fillInputBuffer(STALE_CHECK_TIMEOUT);
            return bytesRead < 0;
        }
        catch (SocketTimeoutException ex) {
            return false;
        }
        catch (SocketException ex) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fillInputBuffer(Timeout timeout) throws IOException {
        SocketHolder socketHolder = this.ensureOpen();
        Socket socket = socketHolder.getSocket();
        int oldtimeout = socket.getSoTimeout();
        try {
            socket.setSoTimeout(timeout.toMillisecondsIntBound());
            int n = this.inbuffer.fillBuffer(socketHolder.getInputStream());
            return n;
        }
        finally {
            socket.setSoTimeout(oldtimeout);
        }
    }

    public void shutdown() throws IOException {
        SocketHolder socketHolder = this.socketHolderRef.get();
        if (socketHolder == null) {
            return;
        }
        Socket socket = socketHolder.getSocket();
        if (socket != null) {
            socket.close();
        }
    }

    @Override
    public ClassicHttpRequest receiveRequest() throws HttpException, IOException {
        ProtocolVersion transportVersion;
        SocketHolder socketHolder = this.ensureOpen();
        this.in = socketHolder.getInputStream();
        CharArrayBuffer headLine = new CharArrayBuffer(128);
        this.inbuffer.clear();
        int i = this.inbuffer.readLine(headLine, this.in);
        if (i == -1) {
            throw new IOException("readLine() from SessionInputBufferImpl returned -1 in method receiveRequest()");
        }
        Header[] headers = AbstractMessageParser.parseHeaders((SessionInputBuffer)this.inbuffer, (InputStream)this.in, (int)this.http1Config.getMaxHeaderCount(), (int)this.http1Config.getMaxLineLength(), (LineParser)LazyLineParser.INSTANCE);
        RequestLine requestLine = LazyLineParser.INSTANCE.parseRequestLine(headLine);
        ClassicHttpRequest request = DefaultClassicHttpRequestFactory.INSTANCE.newHttpRequest(requestLine.getMethod(), requestLine.getUri());
        request.setHeaders(headers);
        long len = DefaultContentLengthStrategy.INSTANCE.determineLength((HttpMessage)request);
        this.in = this.createContentInputStream(len, (SessionInputBuffer)this.inbuffer, this.in);
        if (HEADERLOG.isDebugEnabled()) {
            HEADERLOG.debug((Object)(">> " + String.valueOf(new RequestLine((HttpRequest)request))));
            for (Header header : request.getHeaders()) {
                HEADERLOG.debug((Object)(">> " + String.valueOf(header)));
            }
        }
        if ((transportVersion = request.getVersion()) != null && transportVersion.greaterEquals((ProtocolVersion)HttpVersion.HTTP_2)) {
            HEADERLOG.warn((Object)("receiveRequest() received http2 version: " + String.valueOf(transportVersion) + " , however axis2 is configured for HTTP/1.1 and the connection will be downgraded to HTTP/1.1"));
            transportVersion = HttpVersion.HTTP_1_1;
        }
        this.version = transportVersion;
        request.setScheme(this.scheme);
        return request;
    }

    @Override
    public void sendResponse(ClassicHttpResponse response) throws HttpException, IOException {
        HttpEntity entity;
        Args.notNull((Object)response, (String)"HTTP response");
        if (HEADERLOG.isDebugEnabled()) {
            Header[] headers;
            HEADERLOG.debug((Object)("<< " + String.valueOf(new StatusLine((HttpResponse)response))));
            for (Header header : headers = response.getHeaders()) {
                HEADERLOG.debug((Object)(">> " + String.valueOf(header)));
            }
        }
        if ((entity = response.getEntity()) == null) {
            if (this.out != null) {
                HEADERLOG.debug((Object)"AxisHttpConnectionImpl.sendResponse() found null entity, will flush() and return  ... ");
                this.outbuffer.flush(this.out);
            }
            return;
        }
        long len = this.contentLenStrategy.determineLength((HttpMessage)response);
        SocketHolder socketHolder = this.ensureOpen();
        this.out = null;
        this.out = this.createContentOutputStream(len, (SessionOutputBuffer)this.outbuffer, socketHolder.getOutputStream(), (Supplier<List<? extends Header>>)entity.getTrailers());
        this.responseWriter.write((MessageHeaders)response, (SessionOutputBuffer)this.outbuffer, this.out);
        entity.writeTo(this.out);
    }

    private byte[] getChunkedRequestBuffer() {
        if (this.chunkedRequestBuffer == null) {
            int chunkSizeHint = this.http1Config.getChunkSizeHint();
            this.chunkedRequestBuffer = new byte[chunkSizeHint > 0 ? chunkSizeHint : 8192];
        }
        return this.chunkedRequestBuffer;
    }

    public InputStream createContentInputStream(long len, SessionInputBuffer buffer, InputStream inputStream) {
        if (len > 0L) {
            return new ContentLengthInputStream(buffer, inputStream, len);
        }
        if (len == 0L) {
            return EmptyInputStream.INSTANCE;
        }
        if (len == -1L) {
            return new ChunkedInputStream(buffer, inputStream, this.http1Config);
        }
        return new IdentityInputStream(buffer, inputStream);
    }

    public OutputStream createContentOutputStream(long len, SessionOutputBuffer buffer, OutputStream outputStream, Supplier<List<? extends Header>> trailers) {
        if (len >= 0L) {
            return new ContentLengthOutputStream(buffer, outputStream, len);
        }
        if (len == -1L) {
            return new ChunkedOutputStream(buffer, outputStream, this.getChunkedRequestBuffer(), trailers);
        }
        return new IdentityOutputStream(buffer, outputStream);
    }

    @Override
    public SocketHolder getSocketHolder() {
        return this.socketHolderRef.get();
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    protected SocketHolder ensureOpen() throws IOException {
        SocketHolder socketHolder = this.socketHolderRef.get();
        if (socketHolder == null) {
            throw new ConnectionClosedException();
        }
        return socketHolder;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.version;
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        if (this.out != null) {
            this.out.flush();
            this.out.close();
            this.out = null;
        }
    }

    public Timeout getSocketTimeout() {
        SocketHolder socketHolder = this.socketHolderRef.get();
        if (socketHolder != null) {
            try {
                return Timeout.ofMilliseconds((long)socketHolder.getSocket().getSoTimeout());
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return Timeout.INFINITE;
    }

    public void setSocketTimeout(Timeout timeout) {
        SocketHolder socketHolder = this.socketHolderRef.get();
        if (socketHolder != null) {
            try {
                socketHolder.getSocket().setSoTimeout(Timeout.defaultsToInfinite((Timeout)timeout).toMillisecondsIntBound());
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    public SocketAddress getLocalAddress() {
        SocketHolder socketHolder = this.socketHolderRef.get();
        return socketHolder != null ? socketHolder.getSocket().getLocalSocketAddress() : null;
    }

    public SocketAddress getRemoteAddress() {
        SocketHolder socketHolder = this.socketHolderRef.get();
        return socketHolder != null ? socketHolder.getSocket().getRemoteSocketAddress() : null;
    }

    public SSLSession getSSLSession() {
        SocketHolder socketHolder = this.socketHolderRef.get();
        if (socketHolder != null) {
            Socket socket = socketHolder.getSocket();
            return socket instanceof SSLSocket ? ((SSLSocket)socket).getSession() : null;
        }
        return null;
    }

    public EndpointDetails getEndpointDetails() {
        SocketHolder socketHolder;
        if (this.endpointDetails == null && (socketHolder = this.socketHolderRef.get()) != null) {
            Timeout socketTimeout;
            Socket socket = socketHolder.getSocket();
            try {
                socketTimeout = Timeout.ofMilliseconds((long)socket.getSoTimeout());
            }
            catch (SocketException e) {
                socketTimeout = Timeout.INFINITE;
            }
            this.endpointDetails = new BasicEndpointDetails(socket.getRemoteSocketAddress(), socket.getLocalSocketAddress(), null, socketTimeout);
        }
        return this.endpointDetails;
    }

    public String toString() {
        SocketHolder socketHolder = this.socketHolderRef.get();
        if (socketHolder != null) {
            Socket socket = socketHolder.getSocket();
            StringBuilder buffer = new StringBuilder();
            SocketAddress remoteAddress = socket.getRemoteSocketAddress();
            SocketAddress localAddress = socket.getLocalSocketAddress();
            if (remoteAddress != null && localAddress != null) {
                InetAddressUtils.formatAddress((StringBuilder)buffer, (SocketAddress)localAddress);
                buffer.append("<->");
                InetAddressUtils.formatAddress((StringBuilder)buffer, (SocketAddress)remoteAddress);
            }
            return buffer.toString();
        }
        return "[Not bound]";
    }
}

