/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	camelv1 "github.com/apache/camel-k/v2/pkg/apis/camel/v1"
)

// IntegrationKitSpecApplyConfiguration represents a declarative configuration of the IntegrationKitSpec type for use
// with apply.
type IntegrationKitSpecApplyConfiguration struct {
	Image         *string                                 `json:"image,omitempty"`
	Dependencies  []string                                `json:"dependencies,omitempty"`
	Profile       *camelv1.TraitProfile                   `json:"profile,omitempty"`
	Traits        *IntegrationKitTraitsApplyConfiguration `json:"traits,omitempty"`
	Configuration []ConfigurationSpecApplyConfiguration   `json:"configuration,omitempty"`
	Repositories  []string                                `json:"repositories,omitempty"`
	Sources       []SourceSpecApplyConfiguration          `json:"sources,omitempty"`
	Capabilities  []string                                `json:"capabilities,omitempty"`
}

// IntegrationKitSpecApplyConfiguration constructs a declarative configuration of the IntegrationKitSpec type for use with
// apply.
func IntegrationKitSpec() *IntegrationKitSpecApplyConfiguration {
	return &IntegrationKitSpecApplyConfiguration{}
}

// WithImage sets the Image field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Image field is set to the value of the last call.
func (b *IntegrationKitSpecApplyConfiguration) WithImage(value string) *IntegrationKitSpecApplyConfiguration {
	b.Image = &value
	return b
}

// WithDependencies adds the given value to the Dependencies field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Dependencies field.
func (b *IntegrationKitSpecApplyConfiguration) WithDependencies(values ...string) *IntegrationKitSpecApplyConfiguration {
	for i := range values {
		b.Dependencies = append(b.Dependencies, values[i])
	}
	return b
}

// WithProfile sets the Profile field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Profile field is set to the value of the last call.
func (b *IntegrationKitSpecApplyConfiguration) WithProfile(value camelv1.TraitProfile) *IntegrationKitSpecApplyConfiguration {
	b.Profile = &value
	return b
}

// WithTraits sets the Traits field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Traits field is set to the value of the last call.
func (b *IntegrationKitSpecApplyConfiguration) WithTraits(value *IntegrationKitTraitsApplyConfiguration) *IntegrationKitSpecApplyConfiguration {
	b.Traits = value
	return b
}

// WithConfiguration adds the given value to the Configuration field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Configuration field.
func (b *IntegrationKitSpecApplyConfiguration) WithConfiguration(values ...*ConfigurationSpecApplyConfiguration) *IntegrationKitSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConfiguration")
		}
		b.Configuration = append(b.Configuration, *values[i])
	}
	return b
}

// WithRepositories adds the given value to the Repositories field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Repositories field.
func (b *IntegrationKitSpecApplyConfiguration) WithRepositories(values ...string) *IntegrationKitSpecApplyConfiguration {
	for i := range values {
		b.Repositories = append(b.Repositories, values[i])
	}
	return b
}

// WithSources adds the given value to the Sources field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Sources field.
func (b *IntegrationKitSpecApplyConfiguration) WithSources(values ...*SourceSpecApplyConfiguration) *IntegrationKitSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithSources")
		}
		b.Sources = append(b.Sources, *values[i])
	}
	return b
}

// WithCapabilities adds the given value to the Capabilities field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Capabilities field.
func (b *IntegrationKitSpecApplyConfiguration) WithCapabilities(values ...string) *IntegrationKitSpecApplyConfiguration {
	for i := range values {
		b.Capabilities = append(b.Capabilities, values[i])
	}
	return b
}
