/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import com.google.common.annotations.VisibleForTesting;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.CachedHashDecoratedKey;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.PartitionerDefinedOrder;
import org.apache.cassandra.dht.ComparableObjectToken;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.GuidGenerator;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.Pair;

public class RandomPartitioner
implements IPartitioner {
    public static final BigInteger ZERO = new BigInteger("0");
    public static final BigIntegerToken MINIMUM = new BigIntegerToken("-1");
    public static final BigInteger MAXIMUM = new BigInteger("2").pow(127);
    private static final ThreadLocal<MessageDigest> localMD5Digest = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            return FBUtilities.newMessageDigest("MD5");
        }

        @Override
        public MessageDigest get() {
            MessageDigest digest = (MessageDigest)super.get();
            digest.reset();
            return digest;
        }
    };
    private static final int HEAP_SIZE = (int)ObjectSizes.measureDeep(new BigIntegerToken(RandomPartitioner.hashToBigInteger(ByteBuffer.allocate(1))));
    public static final RandomPartitioner instance = new RandomPartitioner();
    public static final AbstractType<?> partitionOrdering = new PartitionerDefinedOrder(instance);
    private final Token.TokenFactory tokenFactory = new Token.TokenFactory(){

        @Override
        public ByteBuffer toByteArray(Token token) {
            BigIntegerToken bigIntegerToken = (BigIntegerToken)token;
            return ByteBuffer.wrap(((BigInteger)bigIntegerToken.token).toByteArray());
        }

        @Override
        public Token fromByteArray(ByteBuffer bytes) {
            return new BigIntegerToken(new BigInteger(ByteBufferUtil.getArray(bytes)));
        }

        @Override
        public String toString(Token token) {
            BigIntegerToken bigIntegerToken = (BigIntegerToken)token;
            return ((BigInteger)bigIntegerToken.token).toString();
        }

        @Override
        public void validate(String token) throws ConfigurationException {
            try {
                BigInteger i = new BigInteger(token);
                if (i.compareTo(ZERO) < 0) {
                    throw new ConfigurationException("Token must be >= 0");
                }
                if (i.compareTo(MAXIMUM) > 0) {
                    throw new ConfigurationException("Token must be <= 2**127");
                }
            }
            catch (NumberFormatException e) {
                throw new ConfigurationException(e.getMessage());
            }
        }

        @Override
        public Token fromString(String string) {
            return new BigIntegerToken(new BigInteger(string));
        }
    };

    @Override
    public DecoratedKey decorateKey(ByteBuffer key) {
        return new CachedHashDecoratedKey(this.getToken(key), key);
    }

    @Override
    public Token midpoint(Token ltoken, Token rtoken) {
        BigInteger left = ltoken.equals(MINIMUM) ? ZERO : (BigInteger)((BigIntegerToken)ltoken).token;
        BigInteger right = rtoken.equals(MINIMUM) ? ZERO : (BigInteger)((BigIntegerToken)rtoken).token;
        Pair<BigInteger, Boolean> midpair = FBUtilities.midpoint(left, right, 127);
        return new BigIntegerToken((BigInteger)midpair.left);
    }

    @Override
    public BigIntegerToken getMinimumToken() {
        return MINIMUM;
    }

    @Override
    public BigIntegerToken getRandomToken() {
        BigInteger token = RandomPartitioner.hashToBigInteger(GuidGenerator.guidAsBytes());
        if (token.signum() == -1) {
            token = token.multiply(BigInteger.valueOf(-1L));
        }
        return new BigIntegerToken(token);
    }

    @Override
    public Token.TokenFactory getTokenFactory() {
        return this.tokenFactory;
    }

    @Override
    public boolean preservesOrder() {
        return false;
    }

    @Override
    public BigIntegerToken getToken(ByteBuffer key) {
        if (key.remaining() == 0) {
            return MINIMUM;
        }
        return new BigIntegerToken(RandomPartitioner.hashToBigInteger(key));
    }

    @Override
    public Map<Token, Float> describeOwnership(List<Token> sortedTokens) {
        HashMap<Token, Float> ownerships = new HashMap<Token, Float>();
        Iterator<Token> i = sortedTokens.iterator();
        if (!i.hasNext()) {
            throw new RuntimeException("No nodes present in the cluster. Has this node finished starting up?");
        }
        if (sortedTokens.size() == 1) {
            ownerships.put(i.next(), new Float(1.0));
        } else {
            float x;
            BigInteger ti;
            BigInteger ri = MAXIMUM;
            BigDecimal r = new BigDecimal(ri);
            Token start = i.next();
            BigInteger tim1 = ti = (BigInteger)((BigIntegerToken)start).token;
            while (i.hasNext()) {
                Token t = i.next();
                ti = (BigInteger)((BigIntegerToken)t).token;
                x = new BigDecimal(ti.subtract(tim1).add(ri).mod(ri)).divide(r).floatValue();
                ownerships.put(t, Float.valueOf(x));
                tim1 = ti;
            }
            x = new BigDecimal(((BigInteger)((BigIntegerToken)start).token).subtract(ti).add(ri).mod(ri)).divide(r).floatValue();
            ownerships.put(start, Float.valueOf(x));
        }
        return ownerships;
    }

    @Override
    public AbstractType<?> getTokenValidator() {
        return IntegerType.instance;
    }

    @Override
    public AbstractType<?> partitionOrdering() {
        return partitionOrdering;
    }

    private static BigInteger hashToBigInteger(ByteBuffer data) {
        MessageDigest messageDigest = localMD5Digest.get();
        if (data.hasArray()) {
            messageDigest.update(data.array(), data.arrayOffset() + data.position(), data.remaining());
        } else {
            messageDigest.update(data.duplicate());
        }
        return new BigInteger(messageDigest.digest()).abs();
    }

    public static class BigIntegerToken
    extends ComparableObjectToken<BigInteger> {
        static final long serialVersionUID = -5833589141319293006L;

        public BigIntegerToken(BigInteger token) {
            super(token);
        }

        @VisibleForTesting
        public BigIntegerToken(String token) {
            this(new BigInteger(token));
        }

        @Override
        public IPartitioner getPartitioner() {
            return instance;
        }

        @Override
        public long getHeapSize() {
            return HEAP_SIZE;
        }
    }
}

