/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import org.hyperic.sigar.Cpu;
import org.hyperic.sigar.Sigar;

public class CpuPerc
implements Serializable {
    private static final long serialVersionUID = 1393671L;
    private double user;
    private double sys;
    private double nice;
    private double idle;
    private double wait;
    private double irq;
    private double softIrq;
    private double stolen;
    private double combined;

    CpuPerc() {
    }

    native void gather(Sigar var1, Cpu var2, Cpu var3);

    static CpuPerc fetch(Sigar sigar, Cpu oldCpu, Cpu curCpu) {
        CpuPerc perc = new CpuPerc();
        perc.gather(sigar, oldCpu, curCpu);
        return perc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CpuPerc calculate(Cpu oldCpu, Cpu curCpu) {
        Sigar sigar = new Sigar();
        try {
            CpuPerc cpuPerc = CpuPerc.fetch(sigar, oldCpu, curCpu);
            return cpuPerc;
        }
        finally {
            sigar.close();
        }
    }

    public double getUser() {
        return this.user;
    }

    public double getSys() {
        return this.sys;
    }

    public double getNice() {
        return this.nice;
    }

    public double getIdle() {
        return this.idle;
    }

    public double getWait() {
        return this.wait;
    }

    public double getIrq() {
        return this.irq;
    }

    public double getSoftIrq() {
        return this.softIrq;
    }

    public double getStolen() {
        return this.stolen;
    }

    public double getCombined() {
        return this.combined;
    }

    public static String format(double val) {
        String p = String.valueOf(val * 100.0);
        int ix = p.indexOf(".") + 1;
        String percent = p.substring(0, ix) + p.substring(ix, ix + 1);
        return percent + "%";
    }

    public String toString() {
        return "CPU states: " + CpuPerc.format(this.user) + " user, " + CpuPerc.format(this.sys) + " system, " + CpuPerc.format(this.nice) + " nice, " + CpuPerc.format(this.wait) + " wait, " + CpuPerc.format(this.idle) + " idle";
    }
}

