/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.pager.PagingState;

public interface QueryPager {
    public static final QueryPager EMPTY = new QueryPager(){

        @Override
        public ReadExecutionController executionController() {
            return ReadExecutionController.empty();
        }

        @Override
        public PartitionIterator fetchPage(int pageSize, ConsistencyLevel consistency, ClientState clientState, long queryStartNanoTime) throws RequestValidationException, RequestExecutionException {
            return EmptyIterators.partition();
        }

        @Override
        public PartitionIterator fetchPageInternal(int pageSize, ReadExecutionController executionController) throws RequestValidationException, RequestExecutionException {
            return EmptyIterators.partition();
        }

        @Override
        public boolean isExhausted() {
            return true;
        }

        @Override
        public int maxRemaining() {
            return 0;
        }

        @Override
        public PagingState state() {
            return null;
        }

        @Override
        public QueryPager withUpdatedLimit(DataLimits newLimits) {
            throw new UnsupportedOperationException();
        }
    };

    public PartitionIterator fetchPage(int var1, ConsistencyLevel var2, ClientState var3, long var4) throws RequestValidationException, RequestExecutionException;

    public ReadExecutionController executionController();

    public PartitionIterator fetchPageInternal(int var1, ReadExecutionController var2) throws RequestValidationException, RequestExecutionException;

    public boolean isExhausted();

    public int maxRemaining();

    public PagingState state();

    public QueryPager withUpdatedLimit(DataLimits var1);
}

