/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import net.openhft.affinity.lockchecker.FileLockBasedLockChecker;
import net.openhft.affinity.lockchecker.LockChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum LockCheck {

    private static final Logger LOGGER = LoggerFactory.getLogger(LockCheck.class);
    private static final String OS = System.getProperty("os.name").toLowerCase();
    static final boolean IS_LINUX = OS.startsWith("linux");
    private static final int EMPTY_PID = Integer.MIN_VALUE;
    private static final LockChecker lockChecker = FileLockBasedLockChecker.getInstance();

    public static long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }

    static boolean canOSSupportOperation() {
        return IS_LINUX;
    }

    public static boolean isCpuFree(int cpu) {
        if (!LockCheck.canOSSupportOperation()) {
            return true;
        }
        return LockCheck.isLockFree(cpu);
    }

    static boolean replacePid(int cpu, long processID) throws IOException {
        return LockCheck.storePid(processID, cpu);
    }

    public static boolean isProcessRunning(long pid) {
        if (LockCheck.canOSSupportOperation()) {
            return new File("/proc/" + pid).exists();
        }
        throw new UnsupportedOperationException("this is only supported on LINUX");
    }

    private static synchronized boolean storePid(long processID, int cpu) throws IOException {
        return lockChecker.obtainLock(cpu, Long.toString(processID));
    }

    private static synchronized boolean isLockFree(int id) {
        return lockChecker.isLockFree(id);
    }

    public static int getProcessForCpu(int core) throws IOException {
        String meta = lockChecker.getMetaInfo(core);
        if (meta != null && !meta.isEmpty()) {
            try {
                return Integer.parseInt(meta);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Integer.MIN_VALUE;
    }

    static boolean updateCpu(int cpu) throws IOException {
        if (!LockCheck.canOSSupportOperation()) {
            return true;
        }
        return LockCheck.replacePid(cpu, LockCheck.getPID());
    }

    public static void releaseLock(int cpu) {
        lockChecker.releaseLock(cpu);
    }
}

