/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteBufferAccessor;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataOutputBufferFixed;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.vint.VIntCoding;

public class PagingState {
    public final ByteBuffer partitionKey;
    public final RowMark rowMark;
    public final int remaining;
    public final int remainingInPartition;

    public PagingState(ByteBuffer partitionKey, RowMark rowMark, int remaining, int remainingInPartition) {
        this.partitionKey = partitionKey;
        this.rowMark = rowMark;
        this.remaining = remaining;
        this.remainingInPartition = remainingInPartition;
    }

    public ByteBuffer serialize(ProtocolVersion protocolVersion) {
        assert (this.rowMark == null || protocolVersion == this.rowMark.protocolVersion);
        try {
            return protocolVersion.isGreaterThan(ProtocolVersion.V3) ? this.modernSerialize() : this.legacySerialize(true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int serializedSize(ProtocolVersion protocolVersion) {
        assert (this.rowMark == null || protocolVersion == this.rowMark.protocolVersion);
        return protocolVersion.isGreaterThan(ProtocolVersion.V3) ? this.modernSerializedSize() : this.legacySerializedSize(true);
    }

    public static PagingState deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) {
        if (bytes == null) {
            return null;
        }
        try {
            if (protocolVersion.isGreaterThan(ProtocolVersion.V3)) {
                if (PagingState.isModernSerialized(bytes)) {
                    return PagingState.modernDeserialize(bytes, protocolVersion);
                }
                if (PagingState.isLegacySerialized(bytes)) {
                    return PagingState.legacyDeserialize(bytes, ProtocolVersion.V3);
                }
            }
            if (protocolVersion.isSmallerThan(ProtocolVersion.V4)) {
                if (PagingState.isLegacySerialized(bytes)) {
                    return PagingState.legacyDeserialize(bytes, protocolVersion);
                }
                if (PagingState.isModernSerialized(bytes)) {
                    return PagingState.modernDeserialize(bytes, ProtocolVersion.V4);
                }
            }
        }
        catch (IOException e) {
            throw new ProtocolException("Invalid value for the paging state");
        }
        throw new ProtocolException("Invalid value for the paging state");
    }

    private ByteBuffer modernSerialize() throws IOException {
        DataOutputBufferFixed out = new DataOutputBufferFixed(this.modernSerializedSize());
        ByteBufferUtil.writeWithVIntLength(null == this.partitionKey ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.partitionKey, out);
        ByteBufferUtil.writeWithVIntLength(null == this.rowMark ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.rowMark.mark, out);
        out.writeUnsignedVInt32(this.remaining);
        out.writeUnsignedVInt32(this.remainingInPartition);
        return out.buffer(false);
    }

    @VisibleForTesting
    static boolean isModernSerialized(ByteBuffer bytes) {
        int limit;
        int index = bytes.position();
        int partitionKeyLen = PagingState.toIntExact(VIntCoding.getUnsignedVInt(bytes, index, limit = bytes.limit()));
        if (partitionKeyLen < 0) {
            return false;
        }
        if ((index = PagingState.addNonNegative(index, VIntCoding.computeUnsignedVIntSize(partitionKeyLen), partitionKeyLen)) >= limit || index < 0) {
            return false;
        }
        int rowMarkerLen = PagingState.toIntExact(VIntCoding.getUnsignedVInt(bytes, index, limit));
        if (rowMarkerLen < 0) {
            return false;
        }
        if ((index = PagingState.addNonNegative(index, VIntCoding.computeUnsignedVIntSize(rowMarkerLen), rowMarkerLen)) >= limit || index < 0) {
            return false;
        }
        int remaining = PagingState.toIntExact(VIntCoding.getUnsignedVInt(bytes, index, limit));
        if (remaining < 0) {
            return false;
        }
        if ((index = PagingState.addNonNegative(index, VIntCoding.computeUnsignedVIntSize(remaining))) >= limit || index < 0) {
            return false;
        }
        long remainingInPartition = VIntCoding.getUnsignedVInt(bytes, index, limit);
        if (remainingInPartition < 0L) {
            return false;
        }
        return (index = PagingState.addNonNegative(index, VIntCoding.computeUnsignedVIntSize(remainingInPartition))) == limit;
    }

    private static int addNonNegative(int x, int y) {
        int sum = x + y;
        if (sum < 0) {
            return -1;
        }
        return sum;
    }

    private static int addNonNegative(int x, int y, int z) {
        int sum = x + y;
        if (sum < 0) {
            return -1;
        }
        if ((sum += z) < 0) {
            return -1;
        }
        return sum;
    }

    private static int toIntExact(long value) {
        if ((long)((int)value) != value) {
            return -1;
        }
        return (int)value;
    }

    private static PagingState modernDeserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws IOException {
        if (protocolVersion.isSmallerThan(ProtocolVersion.V4)) {
            throw new IllegalArgumentException();
        }
        DataInputBuffer in = new DataInputBuffer(bytes, false);
        ByteBuffer partitionKey = ByteBufferUtil.readWithVIntLength(in);
        ByteBuffer rawMark = ByteBufferUtil.readWithVIntLength(in);
        int remaining = in.readUnsignedVInt32();
        int remainingInPartition = in.readUnsignedVInt32();
        return new PagingState(partitionKey.hasRemaining() ? partitionKey : null, rawMark.hasRemaining() ? new RowMark(rawMark, protocolVersion) : null, remaining, remainingInPartition);
    }

    private int modernSerializedSize() {
        return ByteBufferUtil.serializedSizeWithVIntLength(null == this.partitionKey ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.partitionKey) + ByteBufferUtil.serializedSizeWithVIntLength(null == this.rowMark ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.rowMark.mark) + TypeSizes.sizeofUnsignedVInt(this.remaining) + TypeSizes.sizeofUnsignedVInt(this.remainingInPartition);
    }

    @VisibleForTesting
    ByteBuffer legacySerialize(boolean withRemainingInPartition) throws IOException {
        DataOutputBufferFixed out = new DataOutputBufferFixed(this.legacySerializedSize(withRemainingInPartition));
        ByteBufferUtil.writeWithShortLength(null == this.partitionKey ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.partitionKey, out);
        ByteBufferUtil.writeWithShortLength(null == this.rowMark ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.rowMark.mark, out);
        out.writeInt(this.remaining);
        if (withRemainingInPartition) {
            out.writeInt(this.remainingInPartition);
        }
        return out.buffer(false);
    }

    @VisibleForTesting
    static boolean isLegacySerialized(ByteBuffer bytes) {
        int index = bytes.position();
        int limit = bytes.limit();
        if (limit - index < 2) {
            return false;
        }
        short partitionKeyLen = bytes.getShort(index);
        if (partitionKeyLen < 0) {
            return false;
        }
        if (limit - (index += 2 + partitionKeyLen) < 2) {
            return false;
        }
        short rowMarkerLen = bytes.getShort(index);
        if (rowMarkerLen < 0) {
            return false;
        }
        if (limit - (index += 2 + rowMarkerLen) < 4) {
            return false;
        }
        int remaining = bytes.getInt(index);
        if (remaining < 0) {
            return false;
        }
        if ((index += 4) == limit) {
            return true;
        }
        if (limit - index == 4) {
            int remainingInPartition = bytes.getInt(index);
            return remainingInPartition >= 0;
        }
        return false;
    }

    private static PagingState legacyDeserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws IOException {
        if (protocolVersion.isGreaterThan(ProtocolVersion.V3)) {
            throw new IllegalArgumentException();
        }
        DataInputBuffer in = new DataInputBuffer(bytes, false);
        ByteBuffer partitionKey = ByteBufferUtil.readWithShortLength(in);
        ByteBuffer rawMark = ByteBufferUtil.readWithShortLength(in);
        int remaining = in.readInt();
        int remainingInPartition = in.available() > 0 ? in.readInt() : Integer.MAX_VALUE;
        return new PagingState(partitionKey.hasRemaining() ? partitionKey : null, rawMark.hasRemaining() ? new RowMark(rawMark, protocolVersion) : null, remaining, remainingInPartition);
    }

    @VisibleForTesting
    int legacySerializedSize(boolean withRemainingInPartition) {
        return ByteBufferUtil.serializedSizeWithShortLength(null == this.partitionKey ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.partitionKey) + ByteBufferUtil.serializedSizeWithShortLength(null == this.rowMark ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.rowMark.mark) + TypeSizes.sizeof(this.remaining) + (withRemainingInPartition ? TypeSizes.sizeof(this.remainingInPartition) : 0);
    }

    public final int hashCode() {
        return Objects.hash(this.partitionKey, this.rowMark, this.remaining, this.remainingInPartition);
    }

    public final boolean equals(Object o) {
        if (!(o instanceof PagingState)) {
            return false;
        }
        PagingState that = (PagingState)o;
        return Objects.equals(this.partitionKey, that.partitionKey) && Objects.equals(this.rowMark, that.rowMark) && this.remaining == that.remaining && this.remainingInPartition == that.remainingInPartition;
    }

    public String toString() {
        return String.format("PagingState(key=%s, cellname=%s, remaining=%d, remainingInPartition=%d", this.partitionKey != null ? ByteBufferUtil.bytesToHex(this.partitionKey) : null, this.rowMark, this.remaining, this.remainingInPartition);
    }

    public static class RowMark {
        private final ByteBuffer mark;
        private final ProtocolVersion protocolVersion;

        private RowMark(ByteBuffer mark, ProtocolVersion protocolVersion) {
            this.mark = mark;
            this.protocolVersion = protocolVersion;
        }

        private static List<AbstractType<?>> makeClusteringTypes(TableMetadata metadata) {
            int size = metadata.clusteringColumns().size();
            ArrayList l = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                l.add(BytesType.instance);
            }
            return l;
        }

        public static RowMark create(TableMetadata metadata, Row row, ProtocolVersion protocolVersion) {
            ByteBuffer mark;
            if (protocolVersion.isSmallerOrEqualTo(ProtocolVersion.V3)) {
                Iterator<Cell<?>> cells = row.cellsInLegacyOrder(metadata, true).iterator();
                if (!cells.hasNext()) {
                    assert (!metadata.isCompactTable());
                    mark = RowMark.encodeCellName(metadata, row.clustering(), ByteBufferUtil.EMPTY_BYTE_BUFFER, null);
                } else {
                    Cell<?> cell = cells.next();
                    mark = RowMark.encodeCellName(metadata, row.clustering(), cell.column().name.bytes, cell.column().isComplex() ? cell.path().get(0) : null);
                }
            } else {
                mark = Clustering.serializer.serialize((Clustering<?>)row.clustering(), 12, RowMark.makeClusteringTypes(metadata));
            }
            return new RowMark(mark, protocolVersion);
        }

        public Clustering<?> clustering(TableMetadata metadata) {
            if (this.mark == null) {
                return null;
            }
            return this.protocolVersion.isSmallerOrEqualTo(ProtocolVersion.V3) ? RowMark.decodeClustering(metadata, this.mark) : Clustering.serializer.deserialize(this.mark, 12, RowMark.makeClusteringTypes(metadata));
        }

        private static ByteBuffer encodeCellName(TableMetadata metadata, Clustering<?> clustering, ByteBuffer columnName, ByteBuffer collectionElement) {
            if (metadata.isCompactTable() && metadata.comparator.size() == 1) {
                return clustering.bufferAt(0);
            }
            boolean isStatic = clustering == Clustering.STATIC_CLUSTERING;
            int clusteringSize = metadata.comparator.size();
            int size = clusteringSize + 1 + (collectionElement == null ? 0 : 1);
            ByteBuffer[] values = new ByteBuffer[size];
            for (int i = 0; i < clusteringSize; ++i) {
                if (isStatic) {
                    values[i] = ByteBufferUtil.EMPTY_BYTE_BUFFER;
                    continue;
                }
                ByteBuffer v = clustering.bufferAt(i);
                if (v == null) {
                    return CompositeType.build(ByteBufferAccessor.instance, Arrays.copyOfRange(values, 0, i));
                }
                values[i] = v;
            }
            values[clusteringSize] = columnName;
            if (collectionElement != null) {
                values[clusteringSize + 1] = collectionElement;
            }
            return CompositeType.build(ByteBufferAccessor.instance, isStatic, values);
        }

        private static Clustering<?> decodeClustering(TableMetadata metadata, ByteBuffer value) {
            int csize = metadata.comparator.size();
            if (csize == 0) {
                return Clustering.EMPTY;
            }
            if (metadata.isCompactTable() && metadata.comparator.size() == 1) {
                return Clustering.make(value);
            }
            if (CompositeType.isStaticName(value, ByteBufferAccessor.instance)) {
                return Clustering.STATIC_CLUSTERING;
            }
            List<ByteBuffer> components = CompositeType.splitName(value, ByteBufferAccessor.instance);
            return Clustering.make(components.subList(0, Math.min(csize, components.size())).toArray(new ByteBuffer[csize]));
        }

        public final int hashCode() {
            return Objects.hash(this.mark, this.protocolVersion);
        }

        public final boolean equals(Object o) {
            if (!(o instanceof RowMark)) {
                return false;
            }
            RowMark that = (RowMark)o;
            return Objects.equals(this.mark, that.mark) && this.protocolVersion == that.protocolVersion;
        }

        public String toString() {
            return this.mark == null ? "null" : ByteBufferUtil.bytesToHex(this.mark);
        }
    }
}

