/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db.schema;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import org.apache.cassandra.sidecar.common.server.utils.SecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.SchemaKeyspaceConfiguration;
import org.apache.cassandra.sidecar.coordination.ExecuteOnClusterLeaseholderOnly;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.jetbrains.annotations.NotNull;

public class RestoreSlicesSchema
extends TableSchema
implements ExecuteOnClusterLeaseholderOnly {
    private static final String RESTORE_SLICE_TABLE_NAME = "restore_slice_v3";
    private final SchemaKeyspaceConfiguration keyspaceConfig;
    private final SecondBoundConfiguration tableTtl;
    private PreparedStatement insertSlice;
    private PreparedStatement findAllByTokenRange;

    public RestoreSlicesSchema(SchemaKeyspaceConfiguration keyspaceConfig, SecondBoundConfiguration tableTtl) {
        this.keyspaceConfig = keyspaceConfig;
        this.tableTtl = tableTtl;
    }

    protected String keyspaceName() {
        return this.keyspaceConfig.keyspace();
    }

    protected void prepareStatements(@NotNull Session session) {
        this.insertSlice = this.prepare(this.insertSlice, session, CqlLiterals.insertSlice(this.keyspaceConfig));
        this.findAllByTokenRange = this.prepare(this.findAllByTokenRange, session, CqlLiterals.findAllByTokenRange(this.keyspaceConfig));
    }

    protected String tableName() {
        return RESTORE_SLICE_TABLE_NAME;
    }

    protected String createSchemaStatement() {
        return String.format("CREATE TABLE IF NOT EXISTS %s.%s (  job_id timeuuid,  bucket_id smallint,  slice_id text,  bucket text,  key text,  checksum text,  start_token varint,  end_token varint,  compressed_size bigint,  uncompressed_size bigint,  PRIMARY KEY ((job_id, bucket_id), start_token, end_token, slice_id)) WITH default_time_to_live = %s", this.keyspaceConfig.keyspace(), RESTORE_SLICE_TABLE_NAME, this.tableTtl.toSeconds());
    }

    public PreparedStatement insertSlice() {
        return this.insertSlice;
    }

    public PreparedStatement findAllByTokenRange() {
        return this.findAllByTokenRange;
    }

    private static class CqlLiterals {
        private CqlLiterals() {
        }

        static String insertSlice(SchemaKeyspaceConfiguration config) {
            return CqlLiterals.withTable("INSERT INTO %s.%s (  job_id,  bucket_id,  slice_id,  bucket,  key,  checksum,  start_token,  end_token,  compressed_size,  uncompressed_size) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", config);
        }

        static String findAllByTokenRange(SchemaKeyspaceConfiguration config) {
            return CqlLiterals.withTable("SELECT job_id, bucket_id, slice_id, bucket, key, checksum, start_token, end_token, compressed_size, uncompressed_size FROM %s.%s WHERE job_id = ? AND bucket_id = ? AND end_token > ? AND start_token < ? ALLOW FILTERING", config);
        }

        private static String withTable(String format, SchemaKeyspaceConfiguration config) {
            return String.format(format, config.keyspace(), RestoreSlicesSchema.RESTORE_SLICE_TABLE_NAME);
        }
    }
}

