/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import io.vertx.core.Vertx;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrustOptions;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Objects;
import java.util.function.Function;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.cassandra.sidecar.config.KeyStoreConfiguration;

public class SslUtils {
    public static void validateSslOpts(KeyStoreConfiguration config) throws KeyStoreException, NoSuchAlgorithmException, IOException, CertificateException {
        KeyStore ks;
        Objects.requireNonNull(config, "config must be provided");
        if (config.type() != null) {
            ks = KeyStore.getInstance(config.type());
        } else if (config.path().endsWith("p12")) {
            ks = KeyStore.getInstance("PKCS12");
        } else if (config.path().endsWith("jks")) {
            ks = KeyStore.getInstance("JKS");
        } else {
            throw new IllegalArgumentException("Unrecognized keystore format extension: " + config.path().substring(config.path().length() - 3));
        }
        try (FileInputStream keystore = new FileInputStream(config.path());){
            ks.load(keystore, config.password().toCharArray());
        }
    }

    public static void setKeyStoreConfiguration(SSLOptions options, KeyStoreConfiguration keystore, long timestamp) {
        JksOptions keyCertOptions;
        switch (keystore.type()) {
            case "JKS": {
                keyCertOptions = new JksOptions().setPath(keystore.path()).setPassword(keystore.password());
                break;
            }
            case "PKCS12": {
                keyCertOptions = new PfxOptions().setPath(keystore.path()).setPassword(keystore.password());
                break;
            }
            default: {
                throw new UnsupportedOperationException("KeyStore with type " + keystore.type() + " is not supported");
            }
        }
        options.setKeyCertOptions((KeyCertOptions)new WrappedKeyCertOptions(timestamp, (KeyCertOptions)keyCertOptions));
    }

    public static void setTrustStoreConfiguration(SSLOptions options, KeyStoreConfiguration truststore) {
        JksOptions keyCertOptions;
        switch (truststore.type()) {
            case "JKS": {
                keyCertOptions = new JksOptions().setPath(truststore.path()).setPassword(truststore.password());
                break;
            }
            case "PKCS12": {
                keyCertOptions = new PfxOptions().setPath(truststore.path()).setPassword(truststore.password());
                break;
            }
            default: {
                throw new UnsupportedOperationException("TrustStore with type " + truststore.type() + " is not supported");
            }
        }
        options.setTrustOptions((TrustOptions)keyCertOptions);
    }

    static class WrappedKeyCertOptions
    implements KeyCertOptions {
        private final long timestamp;
        private final KeyCertOptions delegate;

        WrappedKeyCertOptions(long timestamp, KeyCertOptions delegate) {
            this.timestamp = timestamp;
            this.delegate = delegate;
        }

        public KeyCertOptions copy() {
            return new WrappedKeyCertOptions(this.timestamp, this.delegate.copy());
        }

        public KeyManagerFactory getKeyManagerFactory(Vertx vertx) throws Exception {
            return this.delegate.getKeyManagerFactory(vertx);
        }

        public Function<String, X509KeyManager> keyManagerMapper(Vertx vertx) throws Exception {
            return this.delegate.keyManagerMapper(vertx);
        }

        public Function<String, KeyManagerFactory> keyManagerFactoryMapper(Vertx vertx) throws Exception {
            return this.delegate.keyManagerFactoryMapper(vertx);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrappedKeyCertOptions that = (WrappedKeyCertOptions)o;
            return this.timestamp == that.timestamp && Objects.equals(this.delegate, that.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.timestamp, this.delegate);
        }
    }
}

