/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.server.data;

import java.util.Objects;
import org.apache.cassandra.sidecar.common.server.data.Name;
import org.jetbrains.annotations.Nullable;

public class QualifiedTableName {
    @Nullable
    private final Name keyspace;
    @Nullable
    private final Name table;

    public QualifiedTableName(String keyspace, String tableName) {
        this(keyspace, tableName, true);
    }

    public QualifiedTableName(String keyspace, String tableName, boolean required) {
        if (required) {
            Objects.requireNonNull(keyspace, "keyspace must not be null");
            Objects.requireNonNull(tableName, "tableName must not be null");
        }
        this.keyspace = !required && keyspace == null ? null : new Name(keyspace);
        this.table = !required && tableName == null ? null : new Name(tableName);
    }

    public QualifiedTableName(@Nullable Name keyspace, @Nullable Name table) {
        this.keyspace = keyspace;
        this.table = table;
    }

    public String keyspace() {
        return this.keyspace != null ? this.keyspace.name() : null;
    }

    public String maybeQuotedKeyspace() {
        return this.keyspace != null ? this.keyspace.maybeQuotedName() : null;
    }

    @Nullable
    public Name getKeyspace() {
        return this.keyspace;
    }

    public String tableName() {
        return this.table != null ? this.table.name() : null;
    }

    public String maybeQuotedTableName() {
        return this.table != null ? this.table.maybeQuotedName() : null;
    }

    @Nullable
    public Name table() {
        return this.table;
    }

    public String toString() {
        return this.maybeQuotedKeyspace() + "." + this.maybeQuotedTableName();
    }
}

