/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.vertx.core.Handler;
import io.vertx.core.VertxOptions;
import io.vertx.core.file.impl.FileResolverImpl;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.file.FileResolver;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.ext.dropwizard.DropwizardMetricsOptions;
import io.vertx.ext.dropwizard.impl.VertxMetricsImpl;
import io.vertx.ext.dropwizard.reporters.JmxReporter;
import java.io.File;
import java.io.IOException;
import java.util.Scanner;

public class DropwizardVertxMetricsFactory
implements VertxMetricsFactory {
    static final String BASE_NAME = "vertx";
    private Logger logger = LoggerFactory.getLogger(DropwizardVertxMetricsFactory.class);
    private MetricRegistry metricRegistry;

    public DropwizardVertxMetricsFactory() {
        this(null);
    }

    public DropwizardVertxMetricsFactory(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    private MetricRegistry getMetricRegistry(DropwizardMetricsOptions options) {
        if (this.metricRegistry != null) {
            return this.metricRegistry;
        }
        return options.getMetricRegistry() != null ? options.getMetricRegistry() : new MetricRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VertxMetrics metrics(VertxOptions options) {
        MetricRegistry other;
        MetricsOptions baseOptions = options.getMetricsOptions();
        DropwizardMetricsOptions metricsOptions = baseOptions instanceof DropwizardMetricsOptions ? (DropwizardMetricsOptions)baseOptions : new DropwizardMetricsOptions(baseOptions.toJson());
        MetricRegistry registry = this.getMetricRegistry(metricsOptions);
        boolean shutdown = true;
        if (metricsOptions.getRegistryName() != null && (other = SharedMetricRegistries.add((String)metricsOptions.getRegistryName(), (MetricRegistry)registry)) != null) {
            registry = other;
            shutdown = false;
        }
        if (metricsOptions.getConfigPath() != null && !metricsOptions.getConfigPath().isEmpty()) {
            JsonObject loadedFromFile;
            FileResolverImpl resolver = new FileResolverImpl();
            try {
                loadedFromFile = this.loadOptionsFile(metricsOptions.getConfigPath(), (FileResolver)resolver);
            }
            finally {
                try {
                    resolver.close();
                }
                catch (IOException iOException) {}
            }
            if (!loadedFromFile.isEmpty()) {
                metricsOptions = new DropwizardMetricsOptions(loadedFromFile);
            }
        }
        String baseName = metricsOptions.getBaseName() == null ? BASE_NAME : metricsOptions.getBaseName();
        VertxMetricsImpl metrics = new VertxMetricsImpl(registry, shutdown, options, metricsOptions, baseName);
        if (metricsOptions.isJmxEnabled()) {
            String jmxDomain = metricsOptions.getJmxDomain();
            if (jmxDomain == null) {
                jmxDomain = "vertx@" + Integer.toHexString(options.hashCode());
            }
            JmxReporter reporter = JmxReporter.forRegistry(registry).inDomain(jmxDomain).build();
            metrics.setDoneHandler((Handler<Void>)((Handler)v -> reporter.stop()));
            reporter.start();
        }
        return metrics;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject loadOptionsFile(String configPath, FileResolver fileResolver) {
        File file = fileResolver.resolveFile(configPath);
        try (Scanner scanner = new Scanner(file);){
            scanner.useDelimiter("\\A");
            String metricsConfigString = scanner.next();
            JsonObject jsonObject = new JsonObject(metricsConfigString);
            return jsonObject;
        }
        catch (IOException ioe) {
            this.logger.error((Object)"Error while reading metrics config file", (Throwable)ioe);
            return new JsonObject();
        }
        catch (DecodeException de) {
            this.logger.error((Object)"Error while decoding metrics config file into JSON", (Throwable)de);
        }
        return new JsonObject();
    }

    public MetricsOptions newOptions(MetricsOptions options) {
        if (options instanceof DropwizardMetricsOptions) {
            return new DropwizardMetricsOptions((DropwizardMetricsOptions)options);
        }
        return super.newOptions(options);
    }

    public MetricsOptions newOptions() {
        return this.newOptions((JsonObject)null);
    }

    public MetricsOptions newOptions(JsonObject jsonObject) {
        return jsonObject == null ? new DropwizardMetricsOptions() : new DropwizardMetricsOptions(jsonObject);
    }
}

