/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import io.vertx.core.http.HttpMethod;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class HttpRequestMetric {
    final HttpMethod method;
    final String uri;
    long requestBegin;
    private Object routes;
    private int routesLength = 0;

    HttpRequestMetric(HttpMethod method, String uri) {
        this.method = method;
        this.uri = uri;
        this.requestBegin = System.nanoTime();
    }

    String getRoute() {
        if (this.routes == null) {
            return null;
        }
        if (this.routes instanceof String) {
            return (String)this.routes;
        }
        StringBuilder concatenation = new StringBuilder(this.routesLength);
        Iterator iterator = ((List)this.routes).iterator();
        concatenation.append((String)iterator.next());
        while (iterator.hasNext()) {
            concatenation.append('>').append((String)iterator.next());
        }
        this.routes = concatenation.toString();
        return (String)this.routes;
    }

    void addRoute(String route) {
        if (route == null) {
            return;
        }
        this.routesLength += route.length();
        if (this.routes == null) {
            this.routes = route;
            return;
        }
        ++this.routesLength;
        if (this.routes instanceof LinkedList) {
            ((LinkedList)this.routes).add(route);
            return;
        }
        LinkedList<String> multipleRoutes = new LinkedList<String>();
        multipleRoutes.add((String)this.routes);
        multipleRoutes.add(route);
        this.routes = multipleRoutes;
    }
}

