/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.util.LightWeightGSet;
import org.apache.hadoop.util.Timer;

@InterfaceAudience.Private
public class LightWeightCache<K, E extends K>
extends LightWeightGSet<K, E> {
    private static final int EVICTION_LIMIT = 65536;
    private static final Comparator<Entry> expirationTimeComparator = new Comparator<Entry>(){

        @Override
        public int compare(Entry left, Entry right) {
            long r;
            long l = left.getExpirationTime();
            return l > (r = right.getExpirationTime()) ? 1 : (l < r ? -1 : 0);
        }
    };
    private final PriorityQueue<Entry> queue;
    private final long creationExpirationPeriod;
    private final long accessExpirationPeriod;
    private final int sizeLimit;
    private final Timer timer;

    private static int updateRecommendedLength(int recommendedLength, int sizeLimit) {
        return sizeLimit > 0 && sizeLimit < recommendedLength ? sizeLimit / 4 * 3 : recommendedLength;
    }

    public LightWeightCache(int recommendedLength, int sizeLimit, long creationExpirationPeriod, long accessExpirationPeriod) {
        this(recommendedLength, sizeLimit, creationExpirationPeriod, accessExpirationPeriod, new Timer());
    }

    @VisibleForTesting
    LightWeightCache(int recommendedLength, int sizeLimit, long creationExpirationPeriod, long accessExpirationPeriod, Timer timer) {
        super(LightWeightCache.updateRecommendedLength(recommendedLength, sizeLimit));
        this.sizeLimit = sizeLimit;
        if (creationExpirationPeriod <= 0L) {
            throw new IllegalArgumentException("creationExpirationPeriod = " + creationExpirationPeriod + " <= 0");
        }
        this.creationExpirationPeriod = creationExpirationPeriod;
        if (accessExpirationPeriod < 0L) {
            throw new IllegalArgumentException("accessExpirationPeriod = " + accessExpirationPeriod + " < 0");
        }
        this.accessExpirationPeriod = accessExpirationPeriod;
        this.queue = new PriorityQueue<Entry>(sizeLimit > 0 ? sizeLimit + 1 : 1024, expirationTimeComparator);
        this.timer = timer;
    }

    void setExpirationTime(Entry e, long expirationPeriod) {
        e.setExpirationTime(this.timer.monotonicNowNanos() + expirationPeriod);
    }

    boolean isExpired(Entry e, long now) {
        return now > e.getExpirationTime();
    }

    private E evict() {
        Entry polled = this.queue.poll();
        Object removed = super.remove(polled);
        Preconditions.checkState((removed == polled ? 1 : 0) != 0);
        return (E)polled;
    }

    private void evictExpiredEntries() {
        long now = this.timer.monotonicNowNanos();
        for (int i = 0; i < 65536; ++i) {
            Entry peeked = this.queue.peek();
            if (peeked == null || !this.isExpired(peeked, now)) {
                return;
            }
            E evicted = this.evict();
            Preconditions.checkState((evicted == peeked ? 1 : 0) != 0);
        }
    }

    private void evictEntries() {
        if (this.sizeLimit > 0) {
            for (int i = this.size(); i > this.sizeLimit; --i) {
                this.evict();
            }
        }
    }

    @Override
    public E get(K key) {
        Object entry = super.get(key);
        if (entry != null && this.accessExpirationPeriod > 0L) {
            Entry existing = (Entry)entry;
            Preconditions.checkState((boolean)this.queue.remove(existing));
            this.setExpirationTime(existing, this.accessExpirationPeriod);
            this.queue.offer(existing);
        }
        return entry;
    }

    @Override
    public E put(E entry) {
        if (!(entry instanceof Entry)) {
            throw new HadoopIllegalArgumentException("!(entry instanceof Entry), entry.getClass()=" + entry.getClass());
        }
        this.evictExpiredEntries();
        E existing = super.put(entry);
        if (existing != null) {
            this.queue.remove(existing);
        }
        Entry e = (Entry)entry;
        this.setExpirationTime(e, this.creationExpirationPeriod);
        this.queue.offer(e);
        this.evictEntries();
        return existing;
    }

    @Override
    public E remove(K key) {
        this.evictExpiredEntries();
        Object removed = super.remove(key);
        if (removed != null) {
            Preconditions.checkState((boolean)this.queue.remove(removed));
        }
        return removed;
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator iter = super.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public E next() {
                return iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove via iterator is not supported for LightWeightCache");
            }
        };
    }

    public static interface Entry
    extends LightWeightGSet.LinkedElement {
        public void setExpirationTime(long var1);

        public long getExpirationTime();
    }
}

