/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.client.listener.WorkerStatusListener;
import org.apache.celeborn.client.listener.WorkersStatus;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.message.ControlMessages;
import org.apache.celeborn.common.protocol.message.StatusCode;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u000b\u0017\u0001}A\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!)\u0001\b\u0001C\u0001s!9Q\b\u0001b\u0001\n\u0013q\u0004B\u0002\"\u0001A\u0003%q\bC\u0004D\u0001\t\u0007I\u0011\u0002#\t\r}\u0003\u0001\u0015!\u0003F\u0011\u001d\u0001\u0007A1A\u0005\u0002\u0005DaA\u001e\u0001!\u0002\u0013\u0011\u0007bB<\u0001\u0005\u0004%\t\u0001\u001f\u0005\u0007{\u0002\u0001\u000b\u0011B=\t\u000by\u0004A\u0011A@\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e!9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0002bBA\u0018\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003_\u0001A\u0011AA\u001b\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!!\u0017\u0001\t\u0003\tY\u0006C\u0004\u0002\u0000\u0001!\t!!!\t\u000f\u00055\u0005\u0001\"\u0001\u0002\u0010\n\u0019rk\u001c:lKJ\u001cF/\u0019;vgR\u0013\u0018mY6fe*\u0011q\u0003G\u0001\u0007G2LWM\u001c;\u000b\u0005eQ\u0012\u0001C2fY\u0016\u0014wN\u001d8\u000b\u0005ma\u0012AB1qC\u000eDWMC\u0001\u001e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001E\n\t\u0003C\u0011j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005-B\u0012AB2p[6|g.\u0003\u0002.Q\t9Aj\\4hS:<\u0017\u0001B2p]\u001a\u0004\"\u0001M\u0019\u000e\u0003)J!A\r\u0016\u0003\u0019\r+G.\u001a2pe:\u001cuN\u001c4\u0002!1Lg-Z2zG2,W*\u00198bO\u0016\u0014\bCA\u001b7\u001b\u00051\u0012BA\u001c\u0017\u0005Aa\u0015NZ3ds\u000edW-T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0004umb\u0004CA\u001b\u0001\u0011\u0015q3\u00011\u00010\u0011\u0015\u00194\u00011\u00015\u0003m)\u0007p\u00197vI\u0016$wk\u001c:lKJ,\u0005\u0010]5sKRKW.Z8viV\tq\b\u0005\u0002\"\u0001&\u0011\u0011I\t\u0002\u0005\u0019>tw-\u0001\u000ffq\u000edW\u000fZ3e/>\u00148.\u001a:FqBL'/\u001a+j[\u0016|W\u000f\u001e\u0011\u0002+]|'o[3s'R\fG/^:MSN$XM\\3sgV\tQ\t\u0005\u0003G!NKfBA$O\u001b\u0005A%BA%K\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u00172\u000bA!\u001e;jY*\tQ*\u0001\u0003kCZ\f\u0017BA(I\u0003E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r]\u0005\u0003#J\u0013!bS3z'\u0016$h+[3x\u0015\ty\u0005\n\u0005\u0002U/6\tQK\u0003\u0002W-\u0005AA.[:uK:,'/\u0003\u0002Y+\n!rk\u001c:lKJ\u001cF/\u0019;vg2K7\u000f^3oKJ\u0004\"AW/\u000e\u0003mS!\u0001\u0018'\u0002\t1\fgnZ\u0005\u0003=n\u0013qAQ8pY\u0016\fg.\u0001\fx_J\\WM]*uCR,8\u000fT5ti\u0016tWM]:!\u0003=)\u0007p\u00197vI\u0016$wk\u001c:lKJ\u001cX#\u00012\u0011\t\u001d\u001bWm[\u0005\u0003I\"\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\t1\u0017.D\u0001h\u0015\tA'&\u0001\u0003nKR\f\u0017B\u00016h\u0005)9vN]6fe&sgm\u001c\t\u0005C1tw(\u0003\u0002nE\t1A+\u001e9mKJ\u0002\"a\u001c;\u000e\u0003AT!!\u001d:\u0002\u000f5,7o]1hK*\u00111OK\u0001\taJ|Go\\2pY&\u0011Q\u000f\u001d\u0002\u000b'R\fG/^:D_\u0012,\u0017\u0001E3yG2,H-\u001a3X_J\\WM]:!\u0003=\u0019\b.\u001e;uS:<wk\u001c:lKJ\u001cX#A=\u0011\u0007i\\X-D\u0001K\u0013\ta(JA\u0002TKR\f\u0001c\u001d5viRLgnZ,pe.,'o\u001d\u0011\u00029I,w-[:uKJ<vN]6feN#\u0018\r^;t\u0019&\u001cH/\u001a8feR!\u0011\u0011AA\u0004!\r\t\u00131A\u0005\u0004\u0003\u000b\u0011#\u0001B+oSRDa!!\u0003\r\u0001\u0004\u0019\u0016\u0001F<pe.,'o\u0015;biV\u001cH*[:uK:,'/A\u000bhKRtU-\u001a3DQ\u0016\u001c7.\u001a3X_J\\WM]:\u0015\u0005\u0005=\u0001#BA\t\u0003?)g\u0002BA\n\u00037\u00012!!\u0006#\u001b\t\t9BC\u0002\u0002\u001ay\ta\u0001\u0010:p_Rt\u0014bAA\u000fE\u00051\u0001K]3eK\u001aL1\u0001`A\u0011\u0015\r\tiBI\u0001\u000fo>\u00148.\u001a:Fq\u000edW\u000fZ3e)\u0011\t9#a\u000b\u0011\u0007\u0005\nI#\u0003\u0002_E!1\u0011Q\u0006\bA\u0002\u0015\faa^8sW\u0016\u0014\u0018aD<pe.,'/\u0011<bS2\f'\r\\3\u0015\t\u0005\u001d\u00121\u0007\u0005\u0007\u0003[y\u0001\u0019A3\u0015\t\u0005\u001d\u0012q\u0007\u0005\b\u0003s\u0001\u0002\u0019AA\u001e\u0003\rawn\u0019\t\u0005\u0003{\ty$D\u0001s\u0013\r\t\tE\u001d\u0002\u0012!\u0006\u0014H/\u001b;j_:dunY1uS>t\u0017AG3yG2,H-Z,pe.,'O\u0012:p[B\u000b'\u000f^5uS>tG\u0003CA\u0001\u0003\u000f\n\t&!\u0016\t\u000f\u0005%\u0013\u00031\u0001\u0002L\u0005I1\u000f[;gM2,\u0017\n\u001a\t\u0004C\u00055\u0013bAA(E\t\u0019\u0011J\u001c;\t\u000f\u0005M\u0013\u00031\u0001\u0002<\u0005aq\u000e\u001c3QCJ$\u0018\u000e^5p]\"1\u0011qK\tA\u00029\fQaY1vg\u0016\f1C]3d_J$wk\u001c:lKJ4\u0015-\u001b7ve\u0016$B!!\u0001\u0002^!9\u0011q\f\nA\u0002\u0005\u0005\u0014\u0001\u00034bS2,(/Z:\u0011\t\u0005\r\u0014\u0011\u0010\b\u0005\u0003K\n)H\u0004\u0003\u0002h\u0005Md\u0002BA5\u0003crA!a\u001b\u0002p9!\u0011QCA7\u0013\u0005i\u0012BA\u000e\u001d\u0013\tI\"$\u0003\u0002\u00181%\u0019\u0011q\u000f\f\u0002!1Kg-Z2zG2,W*\u00198bO\u0016\u0014\u0018\u0002BA>\u0003{\u0012Ac\u00155vM\u001adWMR1jY\u0016$wk\u001c:lKJ\u001c(bAA<-\u0005I\"/Z7pm\u00164%o\\7Fq\u000edW\u000fZ3e/>\u00148.\u001a:t)\u0011\t\t!a!\t\u000f\u0005\u00155\u00031\u0001\u0002\b\u00069qo\u001c:lKJ\u001c\b\u0003\u0002>\u0002\n\u0016L1!a#K\u0005\u001dA\u0015m\u001d5TKR\fq\u0003[1oI2,\u0007*Z1si\n,\u0017\r\u001e*fgB|gn]3\u0015\t\u0005\u0005\u0011\u0011\u0013\u0005\b\u0003'#\u0002\u0019AAK\u0003\r\u0011Xm\u001d\t\u0005\u0003/\u000bIK\u0004\u0003\u0002\u001a\u0006\u0015f\u0002BAN\u0003GsA!!(\u0002\":!\u0011qMAP\u0013\tY\u0003$\u0003\u0002tU%\u0011\u0011O]\u0005\u0004\u0003O\u0003\u0018aD\"p]R\u0014x\u000e\\'fgN\fw-Z:\n\t\u0005-\u0016Q\u0016\u0002!\u0011\u0016\f'\u000f\u001e2fCR4%o\\7BaBd\u0017nY1uS>t'+Z:q_:\u001cXMC\u0002\u0002(B\u0004")
public class WorkerStatusTracker
implements Logging {
    private final CelebornConf conf;
    private final LifecycleManager lifecycleManager;
    private final long excludedWorkerExpireTimeout;
    private final ConcurrentHashMap.KeySetView<WorkerStatusListener, Boolean> workerStatusListeners;
    private final ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>> excludedWorkers;
    private final Set<WorkerInfo> shuttingWorkers;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        WorkerStatusTracker workerStatusTracker = this;
        synchronized (workerStatusTracker) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    private long excludedWorkerExpireTimeout() {
        return this.excludedWorkerExpireTimeout;
    }

    private ConcurrentHashMap.KeySetView<WorkerStatusListener, Boolean> workerStatusListeners() {
        return this.workerStatusListeners;
    }

    public ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>> excludedWorkers() {
        return this.excludedWorkers;
    }

    public Set<WorkerInfo> shuttingWorkers() {
        return this.shuttingWorkers;
    }

    public void registerWorkerStatusListener(WorkerStatusListener workerStatusListener) {
        this.workerStatusListeners().add(workerStatusListener);
    }

    public scala.collection.immutable.Set<WorkerInfo> getNeedCheckedWorkers() {
        return this.conf.clientCheckedUseAllocatedWorkers() ? this.lifecycleManager.getAllocatedWorkers() : (scala.collection.immutable.Set)((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.excludedWorkers()).asScala()).keys().toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.shuttingWorkers()).asScala()).toSet());
    }

    public boolean workerExcluded(WorkerInfo worker) {
        return this.excludedWorkers().containsKey(worker);
    }

    public boolean workerAvailable(WorkerInfo worker) {
        return !this.excludedWorkers().containsKey(worker) && !this.shuttingWorkers().contains(worker);
    }

    public boolean workerAvailable(PartitionLocation loc) {
        return loc == null ? false : this.workerAvailable(loc.getWorker());
    }

    public void excludeWorkerFromPartition(int shuffleId, PartitionLocation oldPartition, StatusCode cause) {
        ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>> failedWorker = new ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>>();
        if (oldPartition != null) {
            StatusCode statusCode = cause;
            if (((Object)((Object)StatusCode.PUSH_DATA_WRITE_FAIL_PRIMARY)).equals((Object)statusCode)) {
                this.excludeWorker$1(oldPartition, StatusCode.PUSH_DATA_WRITE_FAIL_PRIMARY, shuffleId, failedWorker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (((Object)((Object)StatusCode.PUSH_DATA_WRITE_FAIL_REPLICA)).equals((Object)statusCode) && oldPartition.hasPeer() && this.conf.clientExcludeReplicaOnFailureEnabled()) {
                this.excludeWorker$1(oldPartition.getPeer(), StatusCode.PUSH_DATA_WRITE_FAIL_REPLICA, shuffleId, failedWorker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (((Object)((Object)StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_PRIMARY)).equals((Object)statusCode)) {
                this.excludeWorker$1(oldPartition, StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_PRIMARY, shuffleId, failedWorker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (((Object)((Object)StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_REPLICA)).equals((Object)statusCode) && oldPartition.hasPeer() && this.conf.clientExcludeReplicaOnFailureEnabled()) {
                this.excludeWorker$1(oldPartition.getPeer(), StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_REPLICA, shuffleId, failedWorker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (((Object)((Object)StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_PRIMARY)).equals((Object)statusCode)) {
                this.excludeWorker$1(oldPartition, StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_PRIMARY, shuffleId, failedWorker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (((Object)((Object)StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_REPLICA)).equals((Object)statusCode) && oldPartition.hasPeer() && this.conf.clientExcludeReplicaOnFailureEnabled()) {
                this.excludeWorker$1(oldPartition.getPeer(), StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_REPLICA, shuffleId, failedWorker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (((Object)((Object)StatusCode.PUSH_DATA_TIMEOUT_PRIMARY)).equals((Object)statusCode)) {
                this.excludeWorker$1(oldPartition, StatusCode.PUSH_DATA_TIMEOUT_PRIMARY, shuffleId, failedWorker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (((Object)((Object)StatusCode.PUSH_DATA_TIMEOUT_REPLICA)).equals((Object)statusCode) && oldPartition.hasPeer() && this.conf.clientExcludeReplicaOnFailureEnabled()) {
                this.excludeWorker$1(oldPartition.getPeer(), StatusCode.PUSH_DATA_TIMEOUT_REPLICA, shuffleId, failedWorker);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        this.recordWorkerFailure(failedWorker);
    }

    public void recordWorkerFailure(ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>> failures) {
        block0: {
            if (failures.isEmpty()) break block0;
            ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>> failedWorker = new ConcurrentHashMap<WorkerInfo, Tuple2<StatusCode, Object>>(failures);
            String failedWorkerMsg = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(failedWorker).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                WorkerInfo worker;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$1;
                        if (tuple22 == null) break block2;
                        worker = (WorkerInfo)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                StatusCode status = (StatusCode)((Object)((Object)tuple2._1()));
                long time = tuple2._2$mcJ$sp();
                String string = new StringBuilder(6).append(worker.readableAddress()).append("   ").append(status.name()).append("   ").append(time).toString();
                return string;
            }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
            String excludedWorkerMsg = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.excludedWorkers()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2;
                WorkerInfo worker;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = x0$2;
                        if (tuple22 == null) break block2;
                        worker = (WorkerInfo)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                StatusCode status = (StatusCode)((Object)((Object)tuple2._1()));
                long time = tuple2._2$mcJ$sp();
                String string = new StringBuilder(6).append(worker.readableAddress()).append("   ").append(status.name()).append("   ").append(time).toString();
                return string;
            }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
            String shuttingDownMsg = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.shuttingWorkers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.readableAddress(), Set$.MODULE$.canBuildFrom())).mkString("\n");
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(155).append("\n           |Reporting failed worker:\n           |").append(failedWorkerMsg).append("\n           |Current excluded worker:\n           |").append(excludedWorkerMsg).append("\n           |Current shutting down worker:\n           |").append(shuttingDownMsg).toString())).stripMargin());
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(failedWorker).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                StatusCode statusCode;
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    StatusCode statusCode2;
                    WorkerInfo worker = (WorkerInfo)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null && ((Object)((Object)StatusCode.WORKER_SHUTDOWN)).equals((Object)(statusCode2 = (StatusCode)((Object)((Object)tuple22._1()))))) {
                        return BoxesRunTime.boxToBoolean((boolean)this.shuttingWorkers().add(worker));
                    }
                }
                if (tuple2 != null) {
                    WorkerInfo worker = (WorkerInfo)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple23 != null) {
                        StatusCode statusCode3 = (StatusCode)((Object)((Object)tuple23._1()));
                        long registerTime = tuple23._2$mcJ$sp();
                        if (!this.excludedWorkers().containsKey(worker)) {
                            return this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)statusCode3, (Object)BoxesRunTime.boxToLong((long)registerTime)));
                        }
                    }
                }
                if (tuple2 == null) return BoxedUnit.UNIT;
                WorkerInfo worker = (WorkerInfo)tuple2._1();
                Tuple2 tuple24 = (Tuple2)tuple2._2();
                if (tuple24 == null) return BoxedUnit.UNIT;
                StatusCode statusCode4 = statusCode = (StatusCode)((Object)((Object)tuple24._1()));
                StatusCode statusCode5 = StatusCode.NO_AVAILABLE_WORKING_DIR;
                if (statusCode4 == null) {
                    if (statusCode5 == null) return this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)statusCode, (Object)BoxesRunTime.boxToLong((long)this.excludedWorkers().get(worker)._2$mcJ$sp())));
                } else if (((Object)((Object)statusCode4)).equals((Object)statusCode5)) return this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)statusCode, (Object)BoxesRunTime.boxToLong((long)this.excludedWorkers().get(worker)._2$mcJ$sp())));
                StatusCode statusCode6 = statusCode;
                StatusCode statusCode7 = StatusCode.RESERVE_SLOTS_FAILED;
                if (statusCode6 == null) {
                    if (statusCode7 == null) return this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)statusCode, (Object)BoxesRunTime.boxToLong((long)this.excludedWorkers().get(worker)._2$mcJ$sp())));
                } else if (((Object)((Object)statusCode6)).equals((Object)statusCode7)) return this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)statusCode, (Object)BoxesRunTime.boxToLong((long)this.excludedWorkers().get(worker)._2$mcJ$sp())));
                StatusCode statusCode8 = statusCode;
                StatusCode statusCode9 = StatusCode.WORKER_UNKNOWN;
                if (statusCode8 != null) {
                    if (!((Object)((Object)statusCode8)).equals((Object)statusCode9)) return BoxedUnit.UNIT;
                    return this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)statusCode, (Object)BoxesRunTime.boxToLong((long)this.excludedWorkers().get(worker)._2$mcJ$sp())));
                }
                if (statusCode9 == null) return this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)statusCode, (Object)BoxesRunTime.boxToLong((long)this.excludedWorkers().get(worker)._2$mcJ$sp())));
                return BoxedUnit.UNIT;
            });
        }
    }

    public void removeFromExcludedWorkers(HashSet<WorkerInfo> workers) {
        ((ConcurrentHashMap.KeySetView)this.excludedWorkers().keySet()).removeAll(workers);
    }

    public void handleHeartbeatResponse(ControlMessages.HeartbeatFromApplicationResponse res) {
        block2: {
            StatusCode statusCode = res.statusCode();
            StatusCode statusCode2 = StatusCode.SUCCESS;
            if (statusCode != null ? !((Object)((Object)statusCode)).equals((Object)statusCode2) : statusCode2 != null) break block2;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Received Worker status from Primary, excluded workers: ").append(res.excludedWorkers()).append(" ").append("unknown workers: ").append(res.unknownWorkers()).append(", shutdown workers: ").append(res.shuttingWorkers()).toString());
            long current = System.currentTimeMillis();
            BooleanRef statusChanged = BooleanRef.create((boolean)false);
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.excludedWorkers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                WorkerStatusTracker.$anonfun$handleHeartbeatResponse$2(this, current, res, statusChanged, x0$1);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res.excludedWorkers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)worker -> {
                WorkerStatusTracker.$anonfun$handleHeartbeatResponse$3(this, current, statusChanged, worker);
                return BoxedUnit.UNIT;
            });
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res.unknownWorkers()).asScala()).foreach((Function1 & Serializable & scala.Serializable)worker -> {
                WorkerStatusTracker.$anonfun$handleHeartbeatResponse$4(this, current, statusChanged, worker);
                return BoxedUnit.UNIT;
            });
            boolean retainResult = this.shuttingWorkers().retainAll(res.shuttingWorkers());
            boolean addResult = this.shuttingWorkers().addAll(res.shuttingWorkers());
            boolean bl = statusChanged.elem = statusChanged.elem || retainResult || addResult;
            if (!res.unknownWorkers().isEmpty() || !res.shuttingWorkers().isEmpty()) {
                WorkersStatus workerStatus = new WorkersStatus(res.unknownWorkers(), res.shuttingWorkers());
                ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.workerStatusListeners()).asScala()).foreach((Function1 & Serializable & scala.Serializable)listener -> {
                    WorkerStatusTracker.$anonfun$handleHeartbeatResponse$5(this, workerStatus, listener);
                    return BoxedUnit.UNIT;
                });
            }
            if (statusChanged.elem) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Worker status changed from application heartbeat response");
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(145).append("\n             |Current excluded workers:\n             |").append(((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.excludedWorkers()).asScala()).mkString("\n")).append("\n             |\n             |Current shutting down workers:\n             |").append(((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.shuttingWorkers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.readableAddress(), Set$.MODULE$.canBuildFrom())).mkString("\n")).append("\n             |").toString())).stripMargin());
            }
        }
    }

    private final void excludeWorker$1(PartitionLocation partition, StatusCode statusCode, int shuffleId$1, ConcurrentHashMap failedWorker$1) {
        block0: {
            WorkerInfo tmpWorker = partition.getWorker();
            Option worker = ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.lifecycleManager.workerSnapshots(shuffleId$1).keySet()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.equals(tmpWorker)));
            if (!worker.isDefined()) break block0;
            failedWorker$1.put(worker.get(), new Tuple2((Object)statusCode, (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$handleHeartbeatResponse$2(WorkerStatusTracker $this, long current$1, ControlMessages.HeartbeatFromApplicationResponse res$1, BooleanRef statusChanged$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        WorkerInfo workerInfo = (WorkerInfo)tuple2._1();
        Tuple2 tuple22 = (Tuple2)tuple2._2();
        if (workerInfo == null) throw new MatchError((Object)tuple2);
        WorkerInfo workerInfo2 = workerInfo;
        if (tuple22 == null) throw new MatchError((Object)tuple2);
        StatusCode statusCode = (StatusCode)((Object)tuple22._1());
        long registerTime = tuple22._2$mcJ$sp();
        StatusCode statusCode2 = statusCode;
        boolean bl = ((Object)((Object)StatusCode.WORKER_UNKNOWN)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.NO_AVAILABLE_WORKING_DIR)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.RESERVE_SLOTS_FAILED)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_PRIMARY)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.PUSH_DATA_CREATE_CONNECTION_FAIL_REPLICA)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_PRIMARY)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.PUSH_DATA_CONNECTION_EXCEPTION_REPLICA)).equals((Object)statusCode2) ? true : (((Object)((Object)StatusCode.PUSH_DATA_TIMEOUT_PRIMARY)).equals((Object)statusCode2) ? true : ((Object)((Object)StatusCode.PUSH_DATA_TIMEOUT_REPLICA)).equals((Object)statusCode2))))))));
        if (bl && current$1 - registerTime < $this.excludedWorkerExpireTimeout()) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            if (!(res$1.excludedWorkers().contains(workerInfo2) || res$1.shuttingWorkers().contains(workerInfo2) || res$1.unknownWorkers().contains(workerInfo2))) {
                $this.excludedWorkers().remove(workerInfo2);
                statusChanged$1.elem = true;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$handleHeartbeatResponse$3(WorkerStatusTracker $this, long current$1, BooleanRef statusChanged$1, WorkerInfo worker) {
        block0: {
            if ($this.excludedWorkers().containsKey(worker)) break block0;
            $this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)StatusCode.WORKER_EXCLUDED, (Object)BoxesRunTime.boxToLong((long)current$1)));
            statusChanged$1.elem = true;
        }
    }

    public static final /* synthetic */ void $anonfun$handleHeartbeatResponse$4(WorkerStatusTracker $this, long current$1, BooleanRef statusChanged$1, WorkerInfo worker) {
        block0: {
            if ($this.excludedWorkers().containsKey(worker)) break block0;
            $this.excludedWorkers().put(worker, (Tuple2<StatusCode, Object>)new Tuple2((Object)StatusCode.WORKER_UNKNOWN, (Object)BoxesRunTime.boxToLong((long)current$1)));
            statusChanged$1.elem = true;
        }
    }

    public static final /* synthetic */ void $anonfun$handleHeartbeatResponse$5(WorkerStatusTracker $this, WorkersStatus workerStatus$1, WorkerStatusListener listener) {
        try {
            listener.notifyChangedWorkersStatus(workerStatus$1);
        }
        catch (Throwable t) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error while notify listener", t);
        }
    }

    public WorkerStatusTracker(CelebornConf conf, LifecycleManager lifecycleManager) {
        this.conf = conf;
        this.lifecycleManager = lifecycleManager;
        Logging.$init$(this);
        this.excludedWorkerExpireTimeout = conf.clientExcludedWorkerExpireTimeout();
        this.workerStatusListeners = ConcurrentHashMap.newKeySet();
        this.excludedWorkers = new ConcurrentHashMap();
        this.shuttingWorkers = new HashSet<WorkerInfo>();
    }
}

