/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.protocol.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.WorkerInfo;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PartitionSplitMode;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.protocol.PbApplicationLost;
import org.apache.celeborn.common.protocol.PbApplicationLostResponse;
import org.apache.celeborn.common.protocol.PbChangeLocationResponse;
import org.apache.celeborn.common.protocol.PbCheckForWorkerTimeout;
import org.apache.celeborn.common.protocol.PbCheckForWorkerTimeoutOrBuilder;
import org.apache.celeborn.common.protocol.PbCheckQuota;
import org.apache.celeborn.common.protocol.PbCheckQuotaResponse;
import org.apache.celeborn.common.protocol.PbCheckWorkersAvailable;
import org.apache.celeborn.common.protocol.PbCheckWorkersAvailableResponse;
import org.apache.celeborn.common.protocol.PbCommitFiles;
import org.apache.celeborn.common.protocol.PbCommitFilesResponse;
import org.apache.celeborn.common.protocol.PbDestroyWorkerSlots;
import org.apache.celeborn.common.protocol.PbDestroyWorkerSlotsResponse;
import org.apache.celeborn.common.protocol.PbDiskInfo;
import org.apache.celeborn.common.protocol.PbFileGroup;
import org.apache.celeborn.common.protocol.PbGetBlacklist;
import org.apache.celeborn.common.protocol.PbGetBlacklistResponse;
import org.apache.celeborn.common.protocol.PbGetReducerFileGroup;
import org.apache.celeborn.common.protocol.PbGetReducerFileGroupResponse;
import org.apache.celeborn.common.protocol.PbHeartbeatFromApplication;
import org.apache.celeborn.common.protocol.PbHeartbeatFromApplicationResponse;
import org.apache.celeborn.common.protocol.PbHeartbeatFromWorker;
import org.apache.celeborn.common.protocol.PbHeartbeatFromWorkerResponse;
import org.apache.celeborn.common.protocol.PbMapperEnd;
import org.apache.celeborn.common.protocol.PbMapperEndResponse;
import org.apache.celeborn.common.protocol.PbPartitionLocation;
import org.apache.celeborn.common.protocol.PbPartitionSplit;
import org.apache.celeborn.common.protocol.PbRegisterMapPartitionTask;
import org.apache.celeborn.common.protocol.PbRegisterShuffle;
import org.apache.celeborn.common.protocol.PbRegisterShuffleResponse;
import org.apache.celeborn.common.protocol.PbRegisterWorker;
import org.apache.celeborn.common.protocol.PbRegisterWorkerResponse;
import org.apache.celeborn.common.protocol.PbReleaseSlots;
import org.apache.celeborn.common.protocol.PbReleaseSlotsResponse;
import org.apache.celeborn.common.protocol.PbRemoveWorkersUnavailableInfo;
import org.apache.celeborn.common.protocol.PbReportWorkerUnavailable;
import org.apache.celeborn.common.protocol.PbRequestSlots;
import org.apache.celeborn.common.protocol.PbRequestSlotsResponse;
import org.apache.celeborn.common.protocol.PbReserveSlots;
import org.apache.celeborn.common.protocol.PbReserveSlotsResponse;
import org.apache.celeborn.common.protocol.PbResourceConsumption;
import org.apache.celeborn.common.protocol.PbRevive;
import org.apache.celeborn.common.protocol.PbSlotInfo;
import org.apache.celeborn.common.protocol.PbStageEnd;
import org.apache.celeborn.common.protocol.PbStageEndResponse;
import org.apache.celeborn.common.protocol.PbStorageInfo;
import org.apache.celeborn.common.protocol.PbUnregisterShuffle;
import org.apache.celeborn.common.protocol.PbUnregisterShuffleResponse;
import org.apache.celeborn.common.protocol.PbWorkerInfo;
import org.apache.celeborn.common.protocol.PbWorkerLost;
import org.apache.celeborn.common.protocol.PbWorkerLostResponse;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.protocol.message.ControlMessages;
import org.apache.celeborn.common.protocol.message.ControlMessages$CheckForApplicationTimeOut$;
import org.apache.celeborn.common.protocol.message.ControlMessages$CheckForHDFSExpiredDirsTimeout$;
import org.apache.celeborn.common.protocol.message.ControlMessages$OneWayMessageResponse$;
import org.apache.celeborn.common.protocol.message.ControlMessages$RemoveExpiredShuffle$;
import org.apache.celeborn.common.protocol.message.StatusCode;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.util.PbSerDeUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.shaded.com.google.protobuf.ByteString;
import org.apache.celeborn.shaded.org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ControlMessages$
implements Logging {
    public static ControlMessages$ MODULE$;
    private final String ZERO_UUID;
    private final PbCheckForWorkerTimeout pbCheckForWorkerTimeout;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ControlMessages$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        ControlMessages$ controlMessages$ = this;
        synchronized (controlMessages$) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public String ZERO_UUID() {
        return this.ZERO_UUID;
    }

    public PbCheckForWorkerTimeout pbCheckForWorkerTimeout() {
        return this.pbCheckForWorkerTimeout;
    }

    public TransportMessage toTransportMessage(Object message) {
        TransportMessage transportMessage;
        Object object = message;
        if (object instanceof PbCheckForWorkerTimeoutOrBuilder) {
            transportMessage = new TransportMessage(MessageType.CHECK_FOR_WORKER_TIMEOUT, null);
        } else if (ControlMessages$CheckForApplicationTimeOut$.MODULE$.equals(object)) {
            transportMessage = new TransportMessage(MessageType.CHECK_FOR_APPLICATION_TIMEOUT, null);
        } else if (ControlMessages$CheckForHDFSExpiredDirsTimeout$.MODULE$.equals(object)) {
            transportMessage = new TransportMessage(MessageType.CHECK_FOR_HDFS_EXPIRED_DIRS_TIMEOUT, null);
        } else if (ControlMessages$RemoveExpiredShuffle$.MODULE$.equals(object)) {
            transportMessage = new TransportMessage(MessageType.REMOVE_EXPIRED_SHUFFLE, null);
        } else if (object instanceof PbRegisterWorker) {
            PbRegisterWorker pbRegisterWorker = (PbRegisterWorker)object;
            transportMessage = new TransportMessage(MessageType.REGISTER_WORKER, pbRegisterWorker.toByteArray());
        } else if (object instanceof ControlMessages.HeartbeatFromWorker) {
            ControlMessages.HeartbeatFromWorker heartbeatFromWorker = (ControlMessages.HeartbeatFromWorker)object;
            String host = heartbeatFromWorker.host();
            int rpcPort = heartbeatFromWorker.rpcPort();
            int pushPort = heartbeatFromWorker.pushPort();
            int fetchPort = heartbeatFromWorker.fetchPort();
            int replicatePort = heartbeatFromWorker.replicatePort();
            Seq<DiskInfo> disks = heartbeatFromWorker.disks();
            Map<UserIdentifier, ResourceConsumption> userResourceConsumption = heartbeatFromWorker.userResourceConsumption();
            java.util.Set<String> activeShuffleKeys = heartbeatFromWorker.activeShuffleKeys();
            HashMap<String, Long> estimatedAppDiskUsage = heartbeatFromWorker.estimatedAppDiskUsage();
            boolean highWorkload = heartbeatFromWorker.highWorkload();
            String requestId = heartbeatFromWorker.requestId();
            java.util.List pbDisks = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)disks.map((Function1 & Serializable & scala.Serializable)diskInfo -> PbSerDeUtils$.MODULE$.toPbDiskInfo((DiskInfo)diskInfo), Seq$.MODULE$.canBuildFrom())).asJava();
            Map<String, PbResourceConsumption> pbUserResourceConsumption = PbSerDeUtils$.MODULE$.toPbUserResourceConsumption(userResourceConsumption);
            byte[] payload = PbHeartbeatFromWorker.newBuilder().setHost(host).setRpcPort(rpcPort).setPushPort(pushPort).setFetchPort(fetchPort).addAllDisks(pbDisks).putAllUserResourceConsumption(pbUserResourceConsumption).setReplicatePort(replicatePort).addAllActiveShuffleKeys(activeShuffleKeys).putAllEstimatedAppDiskUsage(estimatedAppDiskUsage).setHighWorkload(highWorkload).setRequestId(requestId).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.HEARTBEAT_FROM_WORKER, payload);
        } else if (object instanceof ControlMessages.HeartbeatFromWorkerResponse) {
            ControlMessages.HeartbeatFromWorkerResponse heartbeatFromWorkerResponse = (ControlMessages.HeartbeatFromWorkerResponse)object;
            HashSet<String> expiredShuffleKeys = heartbeatFromWorkerResponse.expiredShuffleKeys();
            boolean registered = heartbeatFromWorkerResponse.registered();
            byte[] payload = PbHeartbeatFromWorkerResponse.newBuilder().addAllExpiredShuffleKeys(expiredShuffleKeys).setRegistered(registered).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.HEARTBEAT_RESPONSE, payload);
        } else if (object instanceof PbRegisterShuffle) {
            PbRegisterShuffle pbRegisterShuffle = (PbRegisterShuffle)object;
            transportMessage = new TransportMessage(MessageType.REGISTER_SHUFFLE, pbRegisterShuffle.toByteArray());
        } else if (object instanceof PbRegisterMapPartitionTask) {
            PbRegisterMapPartitionTask pbRegisterMapPartitionTask = (PbRegisterMapPartitionTask)object;
            transportMessage = new TransportMessage(MessageType.REGISTER_MAP_PARTITION_TASK, pbRegisterMapPartitionTask.toByteArray());
        } else if (object instanceof PbRegisterShuffleResponse) {
            PbRegisterShuffleResponse pbRegisterShuffleResponse = (PbRegisterShuffleResponse)object;
            transportMessage = new TransportMessage(MessageType.REGISTER_SHUFFLE_RESPONSE, pbRegisterShuffleResponse.toByteArray());
        } else if (object instanceof ControlMessages.RequestSlots) {
            ControlMessages.RequestSlots requestSlots = (ControlMessages.RequestSlots)object;
            String applicationId = requestSlots.applicationId();
            int shuffleId = requestSlots.shuffleId();
            ArrayList<Integer> partitionIdList = requestSlots.partitionIdList();
            String hostname = requestSlots.hostname();
            boolean shouldReplicate = requestSlots.shouldReplicate();
            boolean shouldRackAware = requestSlots.shouldRackAware();
            UserIdentifier userIdentifier = requestSlots.userIdentifier();
            int maxWorkers = requestSlots.maxWorkers();
            int availableStorageTypes = requestSlots.availableStorageTypes();
            String requestId = requestSlots.requestId();
            byte[] payload = PbRequestSlots.newBuilder().setApplicationId(applicationId).setShuffleId(shuffleId).addAllPartitionIdList(partitionIdList).setHostname(hostname).setShouldReplicate(shouldReplicate).setShouldRackAware(shouldRackAware).setMaxWorkers(maxWorkers).setRequestId(requestId).setAvailableStorageTypes(availableStorageTypes).setUserIdentifier(PbSerDeUtils$.MODULE$.toPbUserIdentifier(userIdentifier)).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.REQUEST_SLOTS, payload);
        } else if (object instanceof ControlMessages.ReleaseSlots) {
            ControlMessages.ReleaseSlots releaseSlots = (ControlMessages.ReleaseSlots)object;
            String applicationId = releaseSlots.applicationId();
            int shuffleId = releaseSlots.shuffleId();
            java.util.List<String> workerIds = releaseSlots.workerIds();
            java.util.List<Map<String, Integer>> slots = releaseSlots.slots();
            String requestId = releaseSlots.requestId();
            List pbSlots = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(slots).asScala()).map((Function1 & Serializable & scala.Serializable)slot -> PbSlotInfo.newBuilder().putAllSlot((Map<String, Integer>)slot).build(), Buffer$.MODULE$.canBuildFrom())).toList();
            byte[] payload = PbReleaseSlots.newBuilder().setApplicationId(applicationId).setShuffleId(shuffleId).setRequestId(requestId).addAllWorkerIds(workerIds).addAllSlots((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pbSlots).asJava()).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.RELEASE_SLOTS, payload);
        } else if (object instanceof ControlMessages.ReleaseSlotsResponse) {
            ControlMessages.ReleaseSlotsResponse releaseSlotsResponse = (ControlMessages.ReleaseSlotsResponse)object;
            StatusCode status = releaseSlotsResponse.status();
            byte[] payload = PbReleaseSlotsResponse.newBuilder().setStatus(status.getValue()).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.RELEASE_SLOTS_RESPONSE, payload);
        } else if (object instanceof ControlMessages.RequestSlotsResponse) {
            ControlMessages.RequestSlotsResponse requestSlotsResponse = (ControlMessages.RequestSlotsResponse)object;
            StatusCode status = requestSlotsResponse.status();
            HashMap<WorkerInfo, Tuple2<java.util.List<PartitionLocation>, java.util.List<PartitionLocation>>> workerResource = requestSlotsResponse.workerResource();
            PbRequestSlotsResponse.Builder builder = PbRequestSlotsResponse.newBuilder().setStatus(status.getValue());
            Object object2 = !workerResource.isEmpty() ? builder.putAllWorkerResource(PbSerDeUtils$.MODULE$.toPbWorkerResource(workerResource)) : BoxedUnit.UNIT;
            byte[] payload = builder.build().toByteArray();
            transportMessage = new TransportMessage(MessageType.REQUEST_SLOTS_RESPONSE, payload);
        } else if (object instanceof PbRevive) {
            PbRevive pbRevive = (PbRevive)object;
            transportMessage = new TransportMessage(MessageType.REVIVE, pbRevive.toByteArray());
        } else if (object instanceof PbChangeLocationResponse) {
            PbChangeLocationResponse pbChangeLocationResponse = (PbChangeLocationResponse)object;
            transportMessage = new TransportMessage(MessageType.CHANGE_LOCATION_RESPONSE, pbChangeLocationResponse.toByteArray());
        } else if (object instanceof ControlMessages.MapperEnd) {
            ControlMessages.MapperEnd mapperEnd = (ControlMessages.MapperEnd)object;
            int shuffleId = mapperEnd.shuffleId();
            int mapId = mapperEnd.mapId();
            int attemptId = mapperEnd.attemptId();
            int numMappers = mapperEnd.numMappers();
            int partitionId = mapperEnd.partitionId();
            byte[] payload = PbMapperEnd.newBuilder().setShuffleId(shuffleId).setMapId(mapId).setAttemptId(attemptId).setNumMappers(numMappers).setPartitionId(partitionId).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.MAPPER_END, payload);
        } else if (object instanceof ControlMessages.MapperEndResponse) {
            ControlMessages.MapperEndResponse mapperEndResponse = (ControlMessages.MapperEndResponse)object;
            StatusCode status = mapperEndResponse.status();
            byte[] payload = PbMapperEndResponse.newBuilder().setStatus(status.getValue()).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.MAPPER_END_RESPONSE, payload);
        } else if (object instanceof ControlMessages.GetReducerFileGroup) {
            ControlMessages.GetReducerFileGroup getReducerFileGroup = (ControlMessages.GetReducerFileGroup)object;
            int shuffleId = getReducerFileGroup.shuffleId();
            byte[] payload = PbGetReducerFileGroup.newBuilder().setShuffleId(shuffleId).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.GET_REDUCER_FILE_GROUP, payload);
        } else if (object instanceof ControlMessages.GetReducerFileGroupResponse) {
            ControlMessages.GetReducerFileGroupResponse getReducerFileGroupResponse = (ControlMessages.GetReducerFileGroupResponse)object;
            StatusCode status = getReducerFileGroupResponse.status();
            Map<Integer, java.util.Set<PartitionLocation>> fileGroup = getReducerFileGroupResponse.fileGroup();
            int[] attempts = getReducerFileGroupResponse.attempts();
            java.util.Set<Integer> partitionIds = getReducerFileGroupResponse.partitionIds();
            PbGetReducerFileGroupResponse.Builder builder = PbGetReducerFileGroupResponse.newBuilder().setStatus(status.getValue());
            builder.putAllFileGroups((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(fileGroup).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Integer partitionId = (Integer)tuple2._1();
                java.util.Set fileGroup = (java.util.Set)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)partitionId, (Object)PbFileGroup.newBuilder().addAllLocations((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(fileGroup).asScala()).map((Function1 & Serializable & scala.Serializable)location -> PbSerDeUtils$.MODULE$.toPbPartitionLocation((PartitionLocation)location), Set$.MODULE$.canBuildFrom())).toList()).asJava()).build());
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).asJava());
            builder.addAllAttempts((Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(attempts)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).toIterable()).asJava());
            builder.addAllPartitionIds(partitionIds);
            byte[] payload = builder.build().toByteArray();
            transportMessage = new TransportMessage(MessageType.GET_REDUCER_FILE_GROUP_RESPONSE, payload);
        } else if (object instanceof PbWorkerLost) {
            PbWorkerLost pbWorkerLost = (PbWorkerLost)object;
            transportMessage = new TransportMessage(MessageType.WORKER_LOST, pbWorkerLost.toByteArray());
        } else if (object instanceof PbWorkerLostResponse) {
            PbWorkerLostResponse pbWorkerLostResponse = (PbWorkerLostResponse)object;
            transportMessage = new TransportMessage(MessageType.WORKER_LOST_RESPONSE, pbWorkerLostResponse.toByteArray());
        } else if (object instanceof ControlMessages.StageEnd) {
            ControlMessages.StageEnd stageEnd = (ControlMessages.StageEnd)object;
            int shuffleId = stageEnd.shuffleId();
            byte[] payload = PbStageEnd.newBuilder().setShuffleId(shuffleId).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.STAGE_END, payload);
        } else if (object instanceof ControlMessages.StageEndResponse) {
            ControlMessages.StageEndResponse stageEndResponse = (ControlMessages.StageEndResponse)object;
            StatusCode status = stageEndResponse.status();
            byte[] payload = PbStageEndResponse.newBuilder().setStatus(status.getValue()).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.STAGE_END_RESPONSE, payload);
        } else if (object instanceof PbUnregisterShuffle) {
            PbUnregisterShuffle pbUnregisterShuffle = (PbUnregisterShuffle)object;
            transportMessage = new TransportMessage(MessageType.UNREGISTER_SHUFFLE, pbUnregisterShuffle.toByteArray());
        } else if (object instanceof PbUnregisterShuffleResponse) {
            PbUnregisterShuffleResponse pbUnregisterShuffleResponse = (PbUnregisterShuffleResponse)object;
            transportMessage = new TransportMessage(MessageType.UNREGISTER_SHUFFLE_RESPONSE, pbUnregisterShuffleResponse.toByteArray());
        } else if (object instanceof ControlMessages.ApplicationLost) {
            ControlMessages.ApplicationLost applicationLost = (ControlMessages.ApplicationLost)object;
            String appId = applicationLost.appId();
            String requestId = applicationLost.requestId();
            byte[] payload = PbApplicationLost.newBuilder().setAppId(appId).setRequestId(requestId).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.APPLICATION_LOST, payload);
        } else if (object instanceof ControlMessages.ApplicationLostResponse) {
            ControlMessages.ApplicationLostResponse applicationLostResponse = (ControlMessages.ApplicationLostResponse)object;
            StatusCode status = applicationLostResponse.status();
            byte[] payload = PbApplicationLostResponse.newBuilder().setStatus(status.getValue()).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.APPLICATION_LOST_RESPONSE, payload);
        } else if (object instanceof ControlMessages.HeartbeatFromApplication) {
            ControlMessages.HeartbeatFromApplication heartbeatFromApplication = (ControlMessages.HeartbeatFromApplication)object;
            String appId = heartbeatFromApplication.appId();
            long totalWritten = heartbeatFromApplication.totalWritten();
            long fileCount = heartbeatFromApplication.fileCount();
            java.util.List<WorkerInfo> needCheckedWorkerList = heartbeatFromApplication.needCheckedWorkerList();
            String requestId = heartbeatFromApplication.requestId();
            boolean shouldResponse = heartbeatFromApplication.shouldResponse();
            byte[] payload = PbHeartbeatFromApplication.newBuilder().setAppId(appId).setRequestId(requestId).setTotalWritten(totalWritten).setFileCount(fileCount).addAllNeedCheckedWorkerList((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(needCheckedWorkerList).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)x$1, true), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).setShouldResponse(shouldResponse).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.HEARTBEAT_FROM_APPLICATION, payload);
        } else if (object instanceof ControlMessages.HeartbeatFromApplicationResponse) {
            ControlMessages.HeartbeatFromApplicationResponse heartbeatFromApplicationResponse = (ControlMessages.HeartbeatFromApplicationResponse)object;
            StatusCode statusCode = heartbeatFromApplicationResponse.statusCode();
            java.util.List<WorkerInfo> excludedWorkers = heartbeatFromApplicationResponse.excludedWorkers();
            java.util.List<WorkerInfo> unknownWorkers = heartbeatFromApplicationResponse.unknownWorkers();
            java.util.List<WorkerInfo> shuttingWorkers = heartbeatFromApplicationResponse.shuttingWorkers();
            byte[] payload = PbHeartbeatFromApplicationResponse.newBuilder().setStatus(statusCode.getValue()).addAllExcludedWorkers((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(excludedWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)x$2, true), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).addAllUnknownWorkers((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(unknownWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)x$3, true), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).addAllShuttingWorkers((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(shuttingWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)x$4, true), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.HEARTBEAT_FROM_APPLICATION_RESPONSE, payload);
        } else if (object instanceof ControlMessages.GetBlacklist) {
            ControlMessages.GetBlacklist getBlacklist = (ControlMessages.GetBlacklist)object;
            java.util.List<WorkerInfo> localExcludedWorkers = getBlacklist.localExcludedWorkers();
            byte[] payload = PbGetBlacklist.newBuilder().addAllLocalExcludedWorkers((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(localExcludedWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)workerInfo -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)workerInfo, true), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.GET_BLACKLIST, payload);
        } else if (object instanceof ControlMessages.GetBlacklistResponse) {
            ControlMessages.GetBlacklistResponse getBlacklistResponse = (ControlMessages.GetBlacklistResponse)object;
            StatusCode statusCode = getBlacklistResponse.statusCode();
            java.util.List<WorkerInfo> excludedWorkers = getBlacklistResponse.excludedWorkers();
            java.util.List<WorkerInfo> unknownWorkers = getBlacklistResponse.unknownWorkers();
            PbGetBlacklistResponse.Builder builder = PbGetBlacklistResponse.newBuilder().setStatus(statusCode.getValue());
            builder.addAllExcludedWorkers((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(excludedWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)x$5, true), Buffer$.MODULE$.canBuildFrom())).toList()).asJava());
            builder.addAllUnknownWorkers((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(unknownWorkers).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)x$6, true), Buffer$.MODULE$.canBuildFrom())).toList()).asJava());
            byte[] payload = builder.build().toByteArray();
            transportMessage = new TransportMessage(MessageType.GET_BLACKLIST_RESPONSE, payload);
        } else if (object instanceof ControlMessages.CheckQuota) {
            ControlMessages.CheckQuota checkQuota = (ControlMessages.CheckQuota)object;
            UserIdentifier userIdentifier = checkQuota.userIdentifier();
            PbCheckQuota.Builder builder = PbCheckQuota.newBuilder().setUserIdentifier(PbSerDeUtils$.MODULE$.toPbUserIdentifier(userIdentifier));
            transportMessage = new TransportMessage(MessageType.CHECK_QUOTA, builder.build().toByteArray());
        } else if (object instanceof ControlMessages.CheckQuotaResponse) {
            ControlMessages.CheckQuotaResponse checkQuotaResponse = (ControlMessages.CheckQuotaResponse)object;
            boolean available = checkQuotaResponse.isAvailable();
            String reason = checkQuotaResponse.reason();
            byte[] payload = PbCheckQuotaResponse.newBuilder().setAvailable(available).setReason(reason).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.CHECK_QUOTA_RESPONSE, payload);
        } else if (object instanceof ControlMessages.ReportWorkerUnavailable) {
            ControlMessages.ReportWorkerUnavailable reportWorkerUnavailable = (ControlMessages.ReportWorkerUnavailable)object;
            java.util.List<WorkerInfo> failed = reportWorkerUnavailable.unavailable();
            String requestId = reportWorkerUnavailable.requestId();
            byte[] payload = PbReportWorkerUnavailable.newBuilder().addAllUnavailable((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(failed).asScala()).map((Function1 & Serializable & scala.Serializable)workerInfo -> PbSerDeUtils$.MODULE$.toPbWorkerInfo((WorkerInfo)workerInfo, true), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).setRequestId(requestId).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.REPORT_WORKER_FAILURE, payload);
        } else if (object instanceof PbRemoveWorkersUnavailableInfo) {
            PbRemoveWorkersUnavailableInfo pbRemoveWorkersUnavailableInfo = (PbRemoveWorkersUnavailableInfo)object;
            transportMessage = new TransportMessage(MessageType.REMOVE_WORKERS_UNAVAILABLE_INFO, pbRemoveWorkersUnavailableInfo.toByteArray());
        } else if (object instanceof PbRegisterWorkerResponse) {
            PbRegisterWorkerResponse pbRegisterWorkerResponse = (PbRegisterWorkerResponse)object;
            transportMessage = new TransportMessage(MessageType.REGISTER_WORKER_RESPONSE, pbRegisterWorkerResponse.toByteArray());
        } else if (object instanceof ControlMessages.ReserveSlots) {
            ControlMessages.ReserveSlots reserveSlots = (ControlMessages.ReserveSlots)object;
            String applicationId = reserveSlots.applicationId();
            int shuffleId = reserveSlots.shuffleId();
            java.util.List<PartitionLocation> primaryLocations = reserveSlots.primaryLocations();
            java.util.List<PartitionLocation> replicaLocations = reserveSlots.replicaLocations();
            long splitThreshold = reserveSlots.splitThreshold();
            PartitionSplitMode splitMode = reserveSlots.splitMode();
            PartitionType partType = reserveSlots.partitionType();
            boolean rangeReadFilter = reserveSlots.rangeReadFilter();
            UserIdentifier userIdentifier = reserveSlots.userIdentifier();
            long pushDataTimeout = reserveSlots.pushDataTimeout();
            boolean partitionSplitEnabled = reserveSlots.partitionSplitEnabled();
            byte[] payload = PbReserveSlots.newBuilder().setApplicationId(applicationId).setShuffleId(shuffleId).addAllPrimaryLocations((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(primaryLocations).asScala()).map((Function1 & Serializable & scala.Serializable)location -> PbSerDeUtils$.MODULE$.toPbPartitionLocation((PartitionLocation)location), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).addAllReplicaLocations((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(replicaLocations).asScala()).map((Function1 & Serializable & scala.Serializable)location -> PbSerDeUtils$.MODULE$.toPbPartitionLocation((PartitionLocation)location), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()).setSplitThreshold(splitThreshold).setSplitMode(splitMode.getValue()).setPartitionType(partType.getValue()).setRangeReadFilter(rangeReadFilter).setUserIdentifier(PbSerDeUtils$.MODULE$.toPbUserIdentifier(userIdentifier)).setPushDataTimeout(pushDataTimeout).setPartitionSplitEnabled(partitionSplitEnabled).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.RESERVE_SLOTS, payload);
        } else if (object instanceof ControlMessages.ReserveSlotsResponse) {
            ControlMessages.ReserveSlotsResponse reserveSlotsResponse = (ControlMessages.ReserveSlotsResponse)object;
            StatusCode status = reserveSlotsResponse.status();
            String reason = reserveSlotsResponse.reason();
            byte[] payload = PbReserveSlotsResponse.newBuilder().setStatus(status.getValue()).setReason(reason).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.RESERVE_SLOTS_RESPONSE, payload);
        } else if (object instanceof ControlMessages.CommitFiles) {
            ControlMessages.CommitFiles commitFiles = (ControlMessages.CommitFiles)object;
            String applicationId = commitFiles.applicationId();
            int shuffleId = commitFiles.shuffleId();
            java.util.List<String> primaryIds = commitFiles.primaryIds();
            java.util.List<String> replicaIds = commitFiles.replicaIds();
            int[] mapAttempts = commitFiles.mapAttempts();
            long epoch = commitFiles.epoch();
            boolean mockFailure = commitFiles.mockFailure();
            byte[] payload = PbCommitFiles.newBuilder().setApplicationId(applicationId).setShuffleId(shuffleId).addAllPrimaryIds(primaryIds).addAllReplicaIds(replicaIds).addAllMapAttempts((Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(mapAttempts)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).toIterable()).asJava()).setEpoch(epoch).setMockFailure(mockFailure).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.COMMIT_FILES, payload);
        } else if (object instanceof ControlMessages.CommitFilesResponse) {
            ControlMessages.CommitFilesResponse commitFilesResponse = (ControlMessages.CommitFilesResponse)object;
            StatusCode status = commitFilesResponse.status();
            java.util.List<String> committedPrimaryIds = commitFilesResponse.committedPrimaryIds();
            java.util.List<String> committedReplicaIds = commitFilesResponse.committedReplicaIds();
            java.util.List<String> failedPrimaryIds = commitFilesResponse.failedPrimaryIds();
            java.util.List<String> failedReplicaIds = commitFilesResponse.failedReplicaIds();
            Map<String, StorageInfo> committedPrimaryStorageInfos = commitFilesResponse.committedPrimaryStorageInfos();
            Map<String, StorageInfo> committedReplicaStorageInfos = commitFilesResponse.committedReplicaStorageInfos();
            Map<String, RoaringBitmap> committedMapIdBitMap = commitFilesResponse.committedMapIdBitMap();
            long totalWritten = commitFilesResponse.totalWritten();
            int fileCount = commitFilesResponse.fileCount();
            PbCommitFilesResponse.Builder builder = PbCommitFilesResponse.newBuilder().setStatus(status.getValue());
            builder.addAllCommittedPrimaryIds(committedPrimaryIds);
            builder.addAllCommittedReplicaIds(committedReplicaIds);
            builder.addAllFailedPrimaryIds(failedPrimaryIds);
            builder.addAllFailedReplicaIds(failedReplicaIds);
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(committedPrimaryStorageInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> builder.putCommittedPrimaryStorageInfos((String)entry._1(), StorageInfo.toPb((StorageInfo)entry._2())));
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(committedReplicaStorageInfos).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> builder.putCommittedReplicaStorageInfos((String)entry._1(), StorageInfo.toPb((StorageInfo)entry._2())));
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(committedMapIdBitMap).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> builder.putMapIdBitmap((String)entry._1(), Utils$.MODULE$.roaringBitmapToByteString((RoaringBitmap)entry._2())));
            builder.setTotalWritten(totalWritten);
            builder.setFileCount(fileCount);
            byte[] payload = builder.build().toByteArray();
            transportMessage = new TransportMessage(MessageType.COMMIT_FILES_RESPONSE, payload);
        } else if (object instanceof ControlMessages.DestroyWorkerSlots) {
            ControlMessages.DestroyWorkerSlots destroyWorkerSlots = (ControlMessages.DestroyWorkerSlots)object;
            String shuffleKey = destroyWorkerSlots.shuffleKey();
            java.util.List<String> primaryLocations = destroyWorkerSlots.primaryLocations();
            java.util.List<String> replicaLocations = destroyWorkerSlots.replicaLocations();
            boolean mockFailure = destroyWorkerSlots.mockFailure();
            byte[] payload = PbDestroyWorkerSlots.newBuilder().setShuffleKey(shuffleKey).addAllPrimaryLocations(primaryLocations).addAllReplicaLocation(replicaLocations).setMockFailure(mockFailure).build().toByteArray();
            transportMessage = new TransportMessage(MessageType.DESTROY, payload);
        } else if (object instanceof ControlMessages.DestroyWorkerSlotsResponse) {
            ControlMessages.DestroyWorkerSlotsResponse destroyWorkerSlotsResponse = (ControlMessages.DestroyWorkerSlotsResponse)object;
            StatusCode status = destroyWorkerSlotsResponse.status();
            java.util.List<String> failedPrimaries = destroyWorkerSlotsResponse.failedPrimarys();
            java.util.List<String> failedReplicas = destroyWorkerSlotsResponse.failedReplicas();
            PbDestroyWorkerSlotsResponse.Builder builder = PbDestroyWorkerSlotsResponse.newBuilder().setStatus(status.getValue());
            builder.addAllFailedPrimaries(failedPrimaries);
            builder.addAllFailedReplicas(failedReplicas);
            byte[] payload = builder.build().toByteArray();
            transportMessage = new TransportMessage(MessageType.DESTROY_RESPONSE, payload);
        } else if (object instanceof PbPartitionSplit) {
            PbPartitionSplit pbPartitionSplit = (PbPartitionSplit)object;
            transportMessage = new TransportMessage(MessageType.PARTITION_SPLIT, pbPartitionSplit.toByteArray());
        } else if (ControlMessages$OneWayMessageResponse$.MODULE$.equals(object)) {
            transportMessage = new TransportMessage(MessageType.ONE_WAY_MESSAGE_RESPONSE, null);
        } else if (object instanceof PbCheckWorkersAvailable) {
            PbCheckWorkersAvailable pbCheckWorkersAvailable = (PbCheckWorkersAvailable)object;
            transportMessage = new TransportMessage(MessageType.CHECK_WORKERS_AVAILABLE, pbCheckWorkersAvailable.toByteArray());
        } else if (object instanceof PbCheckWorkersAvailableResponse) {
            PbCheckWorkersAvailableResponse pbCheckWorkersAvailableResponse = (PbCheckWorkersAvailableResponse)object;
            transportMessage = new TransportMessage(MessageType.CHECK_WORKERS_AVAILABLE_RESPONSE, pbCheckWorkersAvailableResponse.toByteArray());
        } else {
            throw new MatchError(object);
        }
        return transportMessage;
    }

    public Object fromTransportMessage(TransportMessage message) {
        Object object;
        int messageTypeValue;
        int n;
        int n2 = message.getMessageTypeValue();
        switch (n2) {
            case 0: {
                n = message.getType().getNumber();
                break;
            }
            default: {
                n = message.getMessageTypeValue();
                break;
            }
        }
        int n3 = messageTypeValue = n;
        switch (n3) {
            case 0: {
                String msg = new StringBuilder(25).append("received unknown message ").append(message).toString();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                throw new UnsupportedOperationException(msg);
            }
            case 7: {
                PbReleaseSlots pbReleaseSlots = PbReleaseSlots.parseFrom(message.getPayload());
                java.util.List slotsList = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbReleaseSlots.getSlotsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbSlot -> new HashMap<String, Integer>(pbSlot.getSlotMap()), Buffer$.MODULE$.canBuildFrom())).toList()).asJava();
                object = new ControlMessages.ReleaseSlots(pbReleaseSlots.getApplicationId(), pbReleaseSlots.getShuffleId(), new ArrayList<String>(pbReleaseSlots.getWorkerIdsList()), new ArrayList<Map<String, Integer>>(slotsList), pbReleaseSlots.getRequestId());
                break;
            }
            case 8: {
                PbReleaseSlotsResponse pbReleaseSlotsResponse = PbReleaseSlotsResponse.parseFrom(message.getPayload());
                object = new ControlMessages.ReleaseSlotsResponse(Utils$.MODULE$.toStatusCode(pbReleaseSlotsResponse.getStatus()));
                break;
            }
            case 1: {
                object = PbRegisterWorker.parseFrom(message.getPayload());
                break;
            }
            case 2: {
                PbHeartbeatFromWorker pbHeartbeatFromWorker = PbHeartbeatFromWorker.parseFrom(message.getPayload());
                HashMap<String, Long> estimatedAppDiskUsage = new HashMap<String, Long>();
                Map<UserIdentifier, ResourceConsumption> userResourceConsumption = PbSerDeUtils$.MODULE$.fromPbUserResourceConsumption(pbHeartbeatFromWorker.getUserResourceConsumptionMap());
                Seq pbDisks = (Seq)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbHeartbeatFromWorker.getDisksList()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)pbDiskInfo -> PbSerDeUtils$.MODULE$.fromPbDiskInfo((PbDiskInfo)pbDiskInfo), Seq$.MODULE$.canBuildFrom());
                if (!pbHeartbeatFromWorker.getEstimatedAppDiskUsageMap().isEmpty()) {
                    estimatedAppDiskUsage.putAll(pbHeartbeatFromWorker.getEstimatedAppDiskUsageMap());
                }
                HashSet<String> activeShuffleKeys = new HashSet<String>();
                Object object2 = !pbHeartbeatFromWorker.getActiveShuffleKeysList().isEmpty() ? BoxesRunTime.boxToBoolean((boolean)activeShuffleKeys.addAll(pbHeartbeatFromWorker.getActiveShuffleKeysList())) : BoxedUnit.UNIT;
                object = new ControlMessages.HeartbeatFromWorker(pbHeartbeatFromWorker.getHost(), pbHeartbeatFromWorker.getRpcPort(), pbHeartbeatFromWorker.getPushPort(), pbHeartbeatFromWorker.getFetchPort(), pbHeartbeatFromWorker.getReplicatePort(), (Seq<DiskInfo>)pbDisks, userResourceConsumption, activeShuffleKeys, estimatedAppDiskUsage, pbHeartbeatFromWorker.getHighWorkload(), pbHeartbeatFromWorker.getRequestId());
                break;
            }
            case 3: {
                PbHeartbeatFromWorkerResponse pbHeartbeatFromWorkerResponse = PbHeartbeatFromWorkerResponse.parseFrom(message.getPayload());
                HashSet<String> expiredShuffleKeys = new HashSet<String>();
                Object object3 = pbHeartbeatFromWorkerResponse.getExpiredShuffleKeysCount() > 0 ? BoxesRunTime.boxToBoolean((boolean)expiredShuffleKeys.addAll(pbHeartbeatFromWorkerResponse.getExpiredShuffleKeysList())) : BoxedUnit.UNIT;
                object = new ControlMessages.HeartbeatFromWorkerResponse(expiredShuffleKeys, pbHeartbeatFromWorkerResponse.getRegistered());
                break;
            }
            case 4: {
                object = PbRegisterShuffle.parseFrom(message.getPayload());
                break;
            }
            case 48: {
                object = PbRegisterMapPartitionTask.parseFrom(message.getPayload());
                break;
            }
            case 5: {
                object = PbRegisterShuffleResponse.parseFrom(message.getPayload());
                break;
            }
            case 6: {
                PbRequestSlots pbRequestSlots = PbRequestSlots.parseFrom(message.getPayload());
                UserIdentifier userIdentifier = PbSerDeUtils$.MODULE$.fromPbUserIdentifier(pbRequestSlots.getUserIdentifier());
                object = new ControlMessages.RequestSlots(pbRequestSlots.getApplicationId(), pbRequestSlots.getShuffleId(), new ArrayList<Integer>(pbRequestSlots.getPartitionIdListList()), pbRequestSlots.getHostname(), pbRequestSlots.getShouldReplicate(), pbRequestSlots.getShouldRackAware(), userIdentifier, pbRequestSlots.getMaxWorkers(), pbRequestSlots.getAvailableStorageTypes(), pbRequestSlots.getRequestId());
                break;
            }
            case 9: {
                PbRequestSlotsResponse pbRequestSlotsResponse = PbRequestSlotsResponse.parseFrom(message.getPayload());
                object = new ControlMessages.RequestSlotsResponse(Utils$.MODULE$.toStatusCode(pbRequestSlotsResponse.getStatus()), PbSerDeUtils$.MODULE$.fromPbWorkerResource(pbRequestSlotsResponse.getWorkerResourceMap()));
                break;
            }
            case 10: {
                object = PbRevive.parseFrom(message.getPayload());
                break;
            }
            case 11: {
                object = PbChangeLocationResponse.parseFrom(message.getPayload());
                break;
            }
            case 12: {
                PbMapperEnd pbMapperEnd = PbMapperEnd.parseFrom(message.getPayload());
                object = new ControlMessages.MapperEnd(pbMapperEnd.getShuffleId(), pbMapperEnd.getMapId(), pbMapperEnd.getAttemptId(), pbMapperEnd.getNumMappers(), pbMapperEnd.getPartitionId());
                break;
            }
            case 13: {
                PbMapperEndResponse pbMapperEndResponse = PbMapperEndResponse.parseFrom(message.getPayload());
                object = new ControlMessages.MapperEndResponse(Utils$.MODULE$.toStatusCode(pbMapperEndResponse.getStatus()));
                break;
            }
            case 14: {
                PbGetReducerFileGroup pbGetReducerFileGroup = PbGetReducerFileGroup.parseFrom(message.getPayload());
                object = new ControlMessages.GetReducerFileGroup(pbGetReducerFileGroup.getShuffleId());
                break;
            }
            case 15: {
                PbGetReducerFileGroupResponse pbGetReducerFileGroupResponse = PbGetReducerFileGroupResponse.parseFrom(message.getPayload());
                Map fileGroup = (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbGetReducerFileGroupResponse.getFileGroupsMap()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Integer partitionId = (Integer)tuple2._1();
                    PbFileGroup fileGroup = (PbFileGroup)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)partitionId, JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fileGroup.getLocationsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbLoc -> PbSerDeUtils$.MODULE$.fromPbPartitionLocation((PbPartitionLocation)pbLoc), Buffer$.MODULE$.canBuildFrom())).toSet()).asJava());
                    return tuple22;
                }, Map$.MODULE$.canBuildFrom())).asJava();
                int[] attempts = (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbGetReducerFileGroupResponse.getAttemptsList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$7)), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
                HashSet<Integer> partitionIds = new HashSet<Integer>(pbGetReducerFileGroupResponse.getPartitionIdsList());
                object = new ControlMessages.GetReducerFileGroupResponse(Utils$.MODULE$.toStatusCode(pbGetReducerFileGroupResponse.getStatus()), fileGroup, attempts, partitionIds);
                break;
            }
            case 16: {
                object = PbUnregisterShuffle.parseFrom(message.getPayload());
                break;
            }
            case 17: {
                object = PbUnregisterShuffleResponse.parseFrom(message.getPayload());
                break;
            }
            case 18: {
                PbApplicationLost pbApplicationLost = PbApplicationLost.parseFrom(message.getPayload());
                object = new ControlMessages.ApplicationLost(pbApplicationLost.getAppId(), pbApplicationLost.getRequestId());
                break;
            }
            case 19: {
                PbApplicationLostResponse pbApplicationLostResponse = PbApplicationLostResponse.parseFrom(message.getPayload());
                object = new ControlMessages.ApplicationLostResponse(Utils$.MODULE$.toStatusCode(pbApplicationLostResponse.getStatus()));
                break;
            }
            case 20: {
                PbHeartbeatFromApplication pbHeartbeatFromApplication = PbHeartbeatFromApplication.parseFrom(message.getPayload());
                object = new ControlMessages.HeartbeatFromApplication(pbHeartbeatFromApplication.getAppId(), pbHeartbeatFromApplication.getTotalWritten(), pbHeartbeatFromApplication.getFileCount(), new ArrayList<WorkerInfo>((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbHeartbeatFromApplication.getNeedCheckedWorkerListList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()), pbHeartbeatFromApplication.getRequestId(), pbHeartbeatFromApplication.getShouldResponse());
                break;
            }
            case 49: {
                PbHeartbeatFromApplicationResponse pbHeartbeatFromApplicationResponse = PbHeartbeatFromApplicationResponse.parseFrom(message.getPayload());
                object = new ControlMessages.HeartbeatFromApplicationResponse(Utils$.MODULE$.toStatusCode(pbHeartbeatFromApplicationResponse.getStatus()), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbHeartbeatFromApplicationResponse.getExcludedWorkersList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbHeartbeatFromApplicationResponse.getUnknownWorkersList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbHeartbeatFromApplicationResponse.getShuttingWorkersList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList()).asJava());
                break;
            }
            case 21: {
                PbGetBlacklist pbGetBlacklist = PbGetBlacklist.parseFrom(message.getPayload());
                object = new ControlMessages.GetBlacklist(new ArrayList<WorkerInfo>((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbGetBlacklist.getLocalExcludedWorkersList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()));
                break;
            }
            case 22: {
                PbGetBlacklistResponse pbGetBlacklistResponse = PbGetBlacklistResponse.parseFrom(message.getPayload());
                object = new ControlMessages.GetBlacklistResponse(Utils$.MODULE$.toStatusCode(pbGetBlacklistResponse.getStatus()), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbGetBlacklistResponse.getExcludedWorkersList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList()).asJava(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbGetBlacklistResponse.getUnknownWorkersList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList()).asJava());
                break;
            }
            case 23: {
                PbCheckQuota pbCheckAvailable = PbCheckQuota.parseFrom(message.getPayload());
                object = new ControlMessages.CheckQuota(PbSerDeUtils$.MODULE$.fromPbUserIdentifier(pbCheckAvailable.getUserIdentifier()));
                break;
            }
            case 24: {
                PbCheckQuotaResponse pbCheckAvailableResponse = PbCheckQuotaResponse.parseFrom(message.getPayload());
                object = new ControlMessages.CheckQuotaResponse(pbCheckAvailableResponse.getAvailable(), pbCheckAvailableResponse.getReason());
                break;
            }
            case 25: {
                PbReportWorkerUnavailable pbReportWorkerUnavailable = PbReportWorkerUnavailable.parseFrom(message.getPayload());
                object = new ControlMessages.ReportWorkerUnavailable(new ArrayList<WorkerInfo>((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbReportWorkerUnavailable.getUnavailableList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbWorkerInfo -> PbSerDeUtils$.MODULE$.fromPbWorkerInfo((PbWorkerInfo)pbWorkerInfo), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()), pbReportWorkerUnavailable.getRequestId());
                break;
            }
            case 55: {
                object = PbRemoveWorkersUnavailableInfo.parseFrom(message.getPayload());
                break;
            }
            case 26: {
                object = PbRegisterWorkerResponse.parseFrom(message.getPayload());
                break;
            }
            case 28: {
                PbReserveSlots pbReserveSlots = PbReserveSlots.parseFrom(message.getPayload());
                UserIdentifier userIdentifier = PbSerDeUtils$.MODULE$.fromPbUserIdentifier(pbReserveSlots.getUserIdentifier());
                object = new ControlMessages.ReserveSlots(pbReserveSlots.getApplicationId(), pbReserveSlots.getShuffleId(), new ArrayList<PartitionLocation>((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbReserveSlots.getPrimaryLocationsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbLoc -> PbSerDeUtils$.MODULE$.fromPbPartitionLocation((PbPartitionLocation)pbLoc), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()), new ArrayList<PartitionLocation>((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbReserveSlots.getReplicaLocationsList()).asScala()).map((Function1 & Serializable & scala.Serializable)pbLoc -> PbSerDeUtils$.MODULE$.fromPbPartitionLocation((PbPartitionLocation)pbLoc), Buffer$.MODULE$.canBuildFrom())).toList()).asJava()), pbReserveSlots.getSplitThreshold(), Utils$.MODULE$.toShuffleSplitMode(pbReserveSlots.getSplitMode()), Utils$.MODULE$.toPartitionType(pbReserveSlots.getPartitionType()), pbReserveSlots.getRangeReadFilter(), userIdentifier, pbReserveSlots.getPushDataTimeout(), pbReserveSlots.getPartitionSplitEnabled());
                break;
            }
            case 29: {
                PbReserveSlotsResponse pbReserveSlotsResponse = PbReserveSlotsResponse.parseFrom(message.getPayload());
                object = new ControlMessages.ReserveSlotsResponse(Utils$.MODULE$.toStatusCode(pbReserveSlotsResponse.getStatus()), pbReserveSlotsResponse.getReason());
                break;
            }
            case 30: {
                PbCommitFiles pbCommitFiles = PbCommitFiles.parseFrom(message.getPayload());
                object = new ControlMessages.CommitFiles(pbCommitFiles.getApplicationId(), pbCommitFiles.getShuffleId(), pbCommitFiles.getPrimaryIdsList(), pbCommitFiles.getReplicaIdsList(), (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pbCommitFiles.getMapAttemptsList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$8)), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int()), pbCommitFiles.getEpoch(), pbCommitFiles.getMockFailure());
                break;
            }
            case 31: {
                PbCommitFilesResponse pbCommitFilesResponse = PbCommitFilesResponse.parseFrom(message.getPayload());
                HashMap<String, StorageInfo> committedPrimaryStorageInfos = new HashMap<String, StorageInfo>();
                HashMap<String, StorageInfo> committedReplicaStorageInfos = new HashMap<String, StorageInfo>();
                HashMap<String, RoaringBitmap> committedBitMap = new HashMap<String, RoaringBitmap>();
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbCommitFilesResponse.getCommittedPrimaryStorageInfosMap()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> committedPrimaryStorageInfos.put((String)entry._1(), StorageInfo.fromPb((PbStorageInfo)entry._2())));
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbCommitFilesResponse.getCommittedReplicaStorageInfosMap()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> committedReplicaStorageInfos.put((String)entry._1(), StorageInfo.fromPb((PbStorageInfo)entry._2())));
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(pbCommitFilesResponse.getMapIdBitmapMap()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> committedBitMap.put((String)entry._1(), Utils$.MODULE$.byteStringToRoaringBitmap((ByteString)entry._2())));
                object = new ControlMessages.CommitFilesResponse(Utils$.MODULE$.toStatusCode(pbCommitFilesResponse.getStatus()), pbCommitFilesResponse.getCommittedPrimaryIdsList(), pbCommitFilesResponse.getCommittedReplicaIdsList(), pbCommitFilesResponse.getFailedPrimaryIdsList(), pbCommitFilesResponse.getFailedReplicaIdsList(), committedPrimaryStorageInfos, committedReplicaStorageInfos, committedBitMap, pbCommitFilesResponse.getTotalWritten(), pbCommitFilesResponse.getFileCount());
                break;
            }
            case 32: {
                PbDestroyWorkerSlots pbDestroy = PbDestroyWorkerSlots.parseFrom(message.getPayload());
                object = new ControlMessages.DestroyWorkerSlots(pbDestroy.getShuffleKey(), pbDestroy.getPrimaryLocationsList(), pbDestroy.getReplicaLocationList(), pbDestroy.getMockFailure());
                break;
            }
            case 33: {
                PbDestroyWorkerSlotsResponse pbDestroyResponse = PbDestroyWorkerSlotsResponse.parseFrom(message.getPayload());
                object = new ControlMessages.DestroyWorkerSlotsResponse(Utils$.MODULE$.toStatusCode(pbDestroyResponse.getStatus()), pbDestroyResponse.getFailedPrimariesList(), pbDestroyResponse.getFailedReplicasList());
                break;
            }
            case 39: {
                object = ControlMessages$RemoveExpiredShuffle$.MODULE$;
                break;
            }
            case 40: {
                object = ControlMessages$OneWayMessageResponse$.MODULE$;
                break;
            }
            case 41: {
                object = this.pbCheckForWorkerTimeout();
                break;
            }
            case 42: {
                object = ControlMessages$CheckForApplicationTimeOut$.MODULE$;
                break;
            }
            case 50: {
                object = ControlMessages$CheckForHDFSExpiredDirsTimeout$.MODULE$;
                break;
            }
            case 43: {
                object = PbWorkerLost.parseFrom(message.getPayload());
                break;
            }
            case 44: {
                object = PbWorkerLostResponse.parseFrom(message.getPayload());
                break;
            }
            case 45: {
                PbStageEnd pbStageEnd = PbStageEnd.parseFrom(message.getPayload());
                object = new ControlMessages.StageEnd(pbStageEnd.getShuffleId());
                break;
            }
            case 47: {
                object = PbPartitionSplit.parseFrom(message.getPayload());
                break;
            }
            case 46: {
                PbStageEndResponse pbStageEndResponse = PbStageEndResponse.parseFrom(message.getPayload());
                object = new ControlMessages.StageEndResponse(Utils$.MODULE$.toStatusCode(pbStageEndResponse.getStatus()));
                break;
            }
            case 53: {
                object = PbCheckWorkersAvailable.parseFrom(message.getPayload());
                break;
            }
            case 54: {
                object = PbCheckWorkersAvailableResponse.parseFrom(message.getPayload());
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n3));
            }
        }
        return object;
    }

    private ControlMessages$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.ZERO_UUID = new UUID(0L, 0L).toString();
        this.pbCheckForWorkerTimeout = PbCheckForWorkerTimeout.newBuilder().build();
    }
}

