/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.compress;

import org.apache.celeborn.client.compress.Lz4Compressor;
import org.apache.celeborn.client.compress.ZstdCompressor;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.protocol.CompressionCodec;

public interface Compressor {
    public void initCompressBuffer(int var1);

    public void compress(byte[] var1, int var2, int var3);

    public int getCompressedTotalSize();

    public byte[] getCompressedBuffer();

    default public void writeIntLE(int i, byte[] buf, int off) {
        buf[off++] = (byte)i;
        buf[off++] = (byte)(i >>> 8);
        buf[off++] = (byte)(i >>> 16);
        buf[off++] = (byte)(i >>> 24);
    }

    public static Compressor getCompressor(CelebornConf conf) {
        CompressionCodec codec = conf.shuffleCompressionCodec();
        int blockSize = conf.clientPushBufferMaxSize();
        switch (codec) {
            case LZ4: {
                return new Lz4Compressor(blockSize);
            }
            case ZSTD: {
                int zstdLevel = conf.shuffleCompressionZstdCompressLevel();
                return new ZstdCompressor(blockSize, zstdLevel);
            }
        }
        throw new IllegalArgumentException("Unknown compression codec: " + (Object)((Object)codec));
    }
}

