/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.metrics.MetricsConfig;
import org.apache.celeborn.common.metrics.MetricsSystem$;
import org.apache.celeborn.common.metrics.sink.JsonServlet;
import org.apache.celeborn.common.metrics.sink.PrometheusServlet;
import org.apache.celeborn.common.metrics.sink.ServletHttpRequestHandler;
import org.apache.celeborn.common.metrics.sink.Sink;
import org.apache.celeborn.common.metrics.source.Source;
import org.apache.celeborn.common.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t}b\u0001B\u001a5\u0001}B\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t!\u0014\u0005\t3\u0002\u0011\t\u0011)A\u0005\u001d\"A!\f\u0001B\u0001B\u0003%1\fC\u0003`\u0001\u0011\u0005\u0001\r\u0003\u0004f\u0001\u0001\u0006IA\u001a\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0011\u0019I\b\u0001)A\u0005W\"9!\u0010\u0001b\u0001\n\u0013Y\bbBA\r\u0001\u0001\u0006I\u0001 \u0005\n\u00037\u0001!\u0019!C\u0005\u0003;A\u0001\"!\r\u0001A\u0003%\u0011q\u0004\u0005\t\u0003g\u0001!\u0019!C\u0005\u001b\"9\u0011Q\u0007\u0001!\u0002\u0013q\u0005\u0002CA\u001c\u0001\t\u0007I\u0011B'\t\u000f\u0005e\u0002\u0001)A\u0005\u001d\"I\u00111\b\u0001A\u0002\u0013%\u0011Q\b\u0005\n\u0003\u0017\u0002\u0001\u0019!C\u0005\u0003\u001bB\u0001\"!\u0017\u0001A\u0003&\u0011q\b\u0005\n\u00037\u0002\u0001\u0019!C\u0005\u0003;B\u0011\"a\u001a\u0001\u0001\u0004%I!!\u001b\t\u0011\u00055\u0004\u0001)Q\u0005\u0003?B\u0011\"a\u001c\u0001\u0001\u0004%\t!!\u001d\t\u0013\u0005e\u0004\u00011A\u0005\u0002\u0005m\u0004\u0002CA@\u0001\u0001\u0006K!a\u001d\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\"9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005\"CAM\u0001E\u0005I\u0011AAN\u0011\u001d\t\t\f\u0001C\u0001\u0003gCq!!.\u0001\t\u0003\t\u0019\fC\u0004\u00028\u0002!I!!/\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\"9\u0011q\u001b\u0001\u0005\u0002\u0005e\u0007bBAo\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0003G\u0004A\u0011BAZ\u0011\u001d\t)\u000f\u0001C\u0005\u0003g;q!a:5\u0011\u0003\tIO\u0002\u00044i!\u0005\u00111\u001e\u0005\u0007?\u0016\"\t!!<\t\u0013\u0005=XE1A\u0005\u0002\u0005E\b\u0002\u0003B\u0001K\u0001\u0006I!a=\t\u0013\t\rQE1A\u0005\u0002\u0005E\b\u0002\u0003B\u0003K\u0001\u0006I!a=\t\u0013\t\u001dQE1A\u0005\u0002\t%\u0001\u0002\u0003B\u000bK\u0001\u0006IAa\u0003\t\u0013\t]QE1A\u0005\u0002\t%\u0001\u0002\u0003B\rK\u0001\u0006IAa\u0003\t\u0011\tmQ\u0005)A\u0005\u0005;A\u0001Ba\t&A\u0003%!Q\u0005\u0005\b\u0005W)C\u0011\u0001B\u0017\u0011\u001d\u00119$\nC\u0001\u0005s\u0011Q\"T3ue&\u001c7oU=ti\u0016l'BA\u001b7\u0003\u001diW\r\u001e:jGNT!a\u000e\u001d\u0002\r\r|W.\\8o\u0015\tI$(\u0001\u0005dK2,'m\u001c:o\u0015\tYD(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002{\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0011$\u0011\u0005\u0005#U\"\u0001\"\u000b\u0003\r\u000bQa]2bY\u0006L!!\u0012\"\u0003\r\u0005s\u0017PU3g!\t9%*D\u0001I\u0015\tIe'\u0001\u0005j]R,'O\\1m\u0013\tY\u0005JA\u0004M_\u001e<\u0017N\\4\u0002\u0011%t7\u000f^1oG\u0016,\u0012A\u0014\t\u0003\u001fZs!\u0001\u0015+\u0011\u0005E\u0013U\"\u0001*\u000b\u0005Ms\u0014A\u0002\u001fs_>$h(\u0003\u0002V\u0005\u00061\u0001K]3eK\u001aL!a\u0016-\u0003\rM#(/\u001b8h\u0015\t)&)A\u0005j]N$\u0018M\\2fA\u0005!1m\u001c8g!\taV,D\u00017\u0013\tqfG\u0001\u0007DK2,'m\u001c:o\u0007>tg-\u0001\u0004=S:LGO\u0010\u000b\u0004C\u000e$\u0007C\u00012\u0001\u001b\u0005!\u0004\"\u0002'\u0005\u0001\u0004q\u0005\"\u0002.\u0005\u0001\u0004Y\u0016!D7fiJL7m]\"p]\u001aLw\r\u0005\u0002cO&\u0011\u0001\u000e\u000e\u0002\u000e\u001b\u0016$(/[2t\u0007>tg-[4\u0002\u000bMLgn[:\u0016\u0003-\u00042\u0001\\9t\u001b\u0005i'B\u00018p\u0003\u001diW\u000f^1cY\u0016T!\u0001\u001d\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002s[\nY\u0011I\u001d:bs\n+hMZ3s!\t!x/D\u0001v\u0015\t1H'\u0001\u0003tS:\\\u0017B\u0001=v\u0005\u0011\u0019\u0016N\\6\u0002\rMLgn[:!\u0003\u001d\u0019x.\u001e:dKN,\u0012\u0001 \t\u0006{\u0006%\u0011QB\u0007\u0002}*\u0019q0!\u0001\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001B;uS2T!!a\u0002\u0002\t)\fg/Y\u0005\u0004\u0003\u0017q(\u0001F\"paf|en\u0016:ji\u0016\f%O]1z\u0019&\u001cH\u000f\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019\u0002N\u0001\u0007g>,(oY3\n\t\u0005]\u0011\u0011\u0003\u0002\u0007'>,(oY3\u0002\u0011M|WO]2fg\u0002\n\u0001B]3hSN$(/_\u000b\u0003\u0003?\u0001B!!\t\u0002.5\u0011\u00111\u0005\u0006\u0004k\u0005\u0015\"\u0002BA\u0014\u0003S\t\u0001bY8eC\"\fG.\u001a\u0006\u0003\u0003W\t1aY8n\u0013\u0011\ty#a\t\u0003\u001d5+GO]5d%\u0016<\u0017n\u001d;ss\u0006I!/Z4jgR\u0014\u0018\u0010I\u0001\u0016aJ|W.\u001a;iKV\u001c8+\u001a:wY\u0016$\b+\u0019;i\u0003Y\u0001(o\\7fi\",Wo]*feZdW\r\u001e)bi\"\u0004\u0013a\u00046t_:\u001cVM\u001d<mKR\u0004\u0016\r\u001e5\u0002!)\u001cxN\\*feZdW\r\u001e)bi\"\u0004\u0013!\u00059s_6,G\u000f[3vgN+'O\u001e7fiV\u0011\u0011q\b\t\u0006\u0003\u0006\u0005\u0013QI\u0005\u0004\u0003\u0007\u0012%AB(qi&|g\u000eE\u0002u\u0003\u000fJ1!!\u0013v\u0005E\u0001&o\\7fi\",Wo]*feZdW\r^\u0001\u0016aJ|W.\u001a;iKV\u001c8+\u001a:wY\u0016$x\fJ3r)\u0011\ty%!\u0016\u0011\u0007\u0005\u000b\t&C\u0002\u0002T\t\u0013A!\u00168ji\"I\u0011qK\t\u0002\u0002\u0003\u0007\u0011qH\u0001\u0004q\u0012\n\u0014A\u00059s_6,G\u000f[3vgN+'O\u001e7fi\u0002\n1B[:p]N+'O\u001e7fiV\u0011\u0011q\f\t\u0006\u0003\u0006\u0005\u0013\u0011\r\t\u0004i\u0006\r\u0014bAA3k\nY!j]8o'\u0016\u0014h\u000f\\3u\u0003=Q7o\u001c8TKJ4H.\u001a;`I\u0015\fH\u0003BA(\u0003WB\u0011\"a\u0016\u0015\u0003\u0003\u0005\r!a\u0018\u0002\u0019)\u001cxN\\*feZdW\r\u001e\u0011\u0002\u000fI,hN\\5oOV\u0011\u00111\u000f\t\u0004\u0003\u0006U\u0014bAA<\u0005\n9!i\\8mK\u0006t\u0017a\u0003:v]:LgnZ0%KF$B!a\u0014\u0002~!I\u0011qK\f\u0002\u0002\u0003\u0007\u00111O\u0001\teVtg.\u001b8hA\u0005\u0011r-\u001a;TKJ4H.\u001a;IC:$G.\u001a:t+\t\t)\tE\u0003B\u0003\u000f\u000bY)C\u0002\u0002\n\n\u0013Q!\u0011:sCf\u00042\u0001^AG\u0013\r\ty)\u001e\u0002\u001a'\u0016\u0014h\u000f\\3u\u0011R$\bOU3rk\u0016\u001cH\u000fS1oI2,'/A\u0003ti\u0006\u0014H\u000f\u0006\u0003\u0002P\u0005U\u0005\"CAL5A\u0005\t\u0019AA:\u0003U\u0011XmZ5ti\u0016\u00148\u000b^1uS\u000e\u001cv.\u001e:dKN\fqb\u001d;beR$C-\u001a4bk2$H%M\u000b\u0003\u0003;SC!a\u001d\u0002 .\u0012\u0011\u0011\u0015\t\u0005\u0003G\u000bi+\u0004\u0002\u0002&*!\u0011qUAU\u0003%)hn\u00195fG.,GMC\u0002\u0002,\n\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\ty+!*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0003ti>\u0004HCAA(\u0003\u0019\u0011X\r]8si\u0006\t\"-^5mIJ+w-[:ueft\u0015-\\3\u0015\u00079\u000bY\fC\u0004\u0002\u0014y\u0001\r!!\u0004\u0002!\u001d,GoU8ve\u000e,7OQ=OC6,G\u0003BAa\u0003'\u0004b!a1\u0002N\u00065a\u0002BAc\u0003\u0013t1!UAd\u0013\u0005\u0019\u0015bAAf\u0005\u00069\u0001/Y2lC\u001e,\u0017\u0002BAh\u0003#\u00141aU3r\u0015\r\tYM\u0011\u0005\u0007\u0003+|\u0002\u0019\u0001(\u0002\u0015M|WO]2f\u001d\u0006lW-\u0001\bsK\u001eL7\u000f^3s'>,(oY3\u0015\t\u0005=\u00131\u001c\u0005\b\u0003'\u0001\u0003\u0019AA\u0007\u00031\u0011X-\\8wKN{WO]2f)\u0011\ty%!9\t\u000f\u0005M\u0011\u00051\u0001\u0002\u000e\u0005y!/Z4jgR,'oU8ve\u000e,7/A\u0007sK\u001eL7\u000f^3s'&t7n]\u0001\u000e\u001b\u0016$(/[2t'f\u001cH/Z7\u0011\u0005\t,3CA\u0013A)\t\tI/\u0001\u0006T\u0013:[uLU#H\u000bb+\"!a=\u0011\t\u0005U\u0018Q`\u0007\u0003\u0003oTA!!?\u0002|\u0006AQ.\u0019;dQ&twMC\u0002\u0002\u0004\tKA!a@\u0002x\n)!+Z4fq\u0006Y1+\u0013(L?J+u)\u0012-!\u00031\u0019v*\u0016*D\u000b~\u0013ViR#Y\u00035\u0019v*\u0016*D\u000b~\u0013ViR#YA\u0005Y!k\u0014'F?^{%kS#S+\t\u0011Y\u0001\u0005\u0003\u0003\u000e\tMQB\u0001B\b\u0015\u0011\u0011\t\"!\u0002\u0002\t1\fgnZ\u0005\u0004/\n=\u0011\u0001\u0004*P\u0019\u0016{vk\u0014*L\u000bJ\u0003\u0013a\u0003*P\u0019\u0016{V*Q*U\u000bJ\u000bABU(M\u000b~k\u0015i\u0015+F%\u0002\n\u0011#T%O\u00136\u000bEj\u0018)P\u00192{VKT%U!\ri(qD\u0005\u0004\u0005Cq(\u0001\u0003+j[\u0016,f.\u001b;\u0002'5Ke*S'B\u0019~\u0003v\n\u0014'`!\u0016\u0013\u0016j\u0014#\u0011\u0007\u0005\u00139#C\u0002\u0003*\t\u00131!\u00138u\u0003e\u0019\u0007.Z2l\u001b&t\u0017.\\1m!>dG.\u001b8h!\u0016\u0014\u0018n\u001c3\u0015\r\u0005=#q\u0006B\u001a\u0011\u001d\u0011\t$\ra\u0001\u0005;\t\u0001\u0002]8mYVs\u0017\u000e\u001e\u0005\b\u0005k\t\u0004\u0019\u0001B\u0013\u0003)\u0001x\u000e\u001c7QKJLw\u000eZ\u0001\u0014GJ,\u0017\r^3NKR\u0014\u0018nY:TsN$X-\u001c\u000b\u0006C\nm\"Q\b\u0005\u0006\u0019J\u0002\rA\u0014\u0005\u00065J\u0002\ra\u0017")
public class MetricsSystem
implements Logging {
    private final String instance;
    private final CelebornConf conf;
    private final MetricsConfig metricsConfig;
    private final ArrayBuffer<Sink> sinks;
    private final CopyOnWriteArrayList<Source> sources;
    private final MetricRegistry registry;
    private final String prometheusServletPath;
    private final String jsonServletPath;
    private Option<PrometheusServlet> prometheusServlet;
    private Option<JsonServlet> jsonServlet;
    private boolean running;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public static MetricsSystem createMetricsSystem(String string, CelebornConf celebornConf) {
        return MetricsSystem$.MODULE$.createMetricsSystem(string, celebornConf);
    }

    public static void checkMinimalPollingPeriod(TimeUnit timeUnit, int n) {
        MetricsSystem$.MODULE$.checkMinimalPollingPeriod(timeUnit, n);
    }

    public static String ROLE_MASTER() {
        return MetricsSystem$.MODULE$.ROLE_MASTER();
    }

    public static String ROLE_WORKER() {
        return MetricsSystem$.MODULE$.ROLE_WORKER();
    }

    public static Regex SOURCE_REGEX() {
        return MetricsSystem$.MODULE$.SOURCE_REGEX();
    }

    public static Regex SINK_REGEX() {
        return MetricsSystem$.MODULE$.SINK_REGEX();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        MetricsSystem metricsSystem = this;
        synchronized (metricsSystem) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public String instance() {
        return this.instance;
    }

    private ArrayBuffer<Sink> sinks() {
        return this.sinks;
    }

    private CopyOnWriteArrayList<Source> sources() {
        return this.sources;
    }

    private MetricRegistry registry() {
        return this.registry;
    }

    private String prometheusServletPath() {
        return this.prometheusServletPath;
    }

    private String jsonServletPath() {
        return this.jsonServletPath;
    }

    private Option<PrometheusServlet> prometheusServlet() {
        return this.prometheusServlet;
    }

    private void prometheusServlet_$eq(Option<PrometheusServlet> x$1) {
        this.prometheusServlet = x$1;
    }

    private Option<JsonServlet> jsonServlet() {
        return this.jsonServlet;
    }

    private void jsonServlet_$eq(Option<JsonServlet> x$1) {
        this.jsonServlet = x$1;
    }

    public boolean running() {
        return this.running;
    }

    public void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    public ServletHttpRequestHandler[] getServletHandlers() {
        Predef$.MODULE$.require(this.running(), (Function0 & Serializable & scala.Serializable)() -> "Can only call getServletHandlers on a running MetricsSystem");
        return (ServletHttpRequestHandler[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.prometheusServlet().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getHandlers($this.conf)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ServletHttpRequestHandler[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ServletHttpRequestHandler.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.jsonServlet().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getHandlers($this.conf)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ServletHttpRequestHandler[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ServletHttpRequestHandler.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ServletHttpRequestHandler.class)));
    }

    public void start(boolean registerStaticSources) {
        Predef$.MODULE$.require(!this.running(), (Function0 & Serializable & scala.Serializable)() -> "Attempting to start a MetricsSystem that is already running");
        this.running_$eq(true);
        if (registerStaticSources) {
            this.registerSources();
        }
        this.registerSinks();
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.start();
            return BoxedUnit.UNIT;
        });
    }

    public boolean start$default$1() {
        return true;
    }

    public void stop() {
        if (this.running()) {
            this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.stop();
                return BoxedUnit.UNIT;
            });
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping a MetricsSystem that is not running");
        }
        this.running_$eq(false);
    }

    public void report() {
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.report();
            return BoxedUnit.UNIT;
        });
    }

    private String buildRegistryName(Source source) {
        return MetricRegistry.name((String)source.sourceName(), (String[])new String[0]);
    }

    public Seq<Source> getSourcesByName(String sourceName) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.sources()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsSystem.$anonfun$getSourcesByName$1(sourceName, x$6)))).toSeq();
    }

    public void registerSource(Source source) {
        this.sources().add(source);
        try {
            String regName = this.buildRegistryName(source);
            this.registry().register(regName, (Metric)source.metricRegistry());
        }
        catch (IllegalArgumentException e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Metrics already registered", e);
        }
    }

    public void removeSource(Source source) {
        this.sources().remove(source);
        String regName = this.buildRegistryName(source);
        this.registry().removeMatching(new MetricFilter(null, regName){
            private final String regName$1;

            public boolean matches(String name, Metric metric) {
                return name.startsWith(this.regName$1);
            }
            {
                this.regName$1 = regName$1;
            }
        });
    }

    private void registerSources() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sourceConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SOURCE_REGEX());
        sourceConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            MetricsSystem.$anonfun$registerSources$1(this, kv);
            return BoxedUnit.UNIT;
        });
    }

    private void registerSinks() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap<String, Properties> sinkConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SINK_REGEX());
        sinkConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            String classPath = ((Properties)kv._2()).getProperty("class");
            if (classPath != null) {
                ArrayBuffer arrayBuffer;
                try {
                    Object object = kv._1();
                    String string = "prometheusServlet";
                    if (!(object != null ? !object.equals(string) : string != null)) {
                        Constructor<?> servlet = Utils$.MODULE$.classForName(classPath).getConstructor(Properties.class, MetricRegistry.class, Seq.class, String.class);
                        this.prometheusServlet_$eq((Option<PrometheusServlet>)new Some((Object)((PrometheusServlet)servlet.newInstance(kv._2(), this.registry(), JavaConverters$.MODULE$.asScalaBufferConverter(this.sources()).asScala(), this.prometheusServletPath()))));
                        arrayBuffer = BoxedUnit.UNIT;
                    } else {
                        Object object2 = kv._1();
                        String string2 = "jsonServlet";
                        if (!(object2 != null ? !object2.equals(string2) : string2 != null)) {
                            Constructor<?> servlet = Utils$.MODULE$.classForName(classPath).getConstructor(Properties.class, MetricRegistry.class, Seq.class, String.class, Boolean.TYPE);
                            this.jsonServlet_$eq((Option<JsonServlet>)new Some((Object)((JsonServlet)servlet.newInstance(kv._2(), this.registry(), JavaConverters$.MODULE$.asScalaBufferConverter(this.sources()).asScala(), this.jsonServletPath(), BoxesRunTime.boxToBoolean((boolean)$this.conf.metricsJsonPrettyEnabled())))));
                            arrayBuffer = BoxedUnit.UNIT;
                        } else {
                            Object sink = Utils$.MODULE$.classForName(classPath).getConstructor(Properties.class, MetricRegistry.class).newInstance(kv._2(), this.registry());
                            arrayBuffer = this.sinks().$plus$eq((Object)((Sink)sink));
                        }
                    }
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Sink class ").append(classPath).append(" cannot be instantiated").toString());
                    throw e;
                }
                return arrayBuffer;
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getSourcesByName$1(String sourceName$1, Source x$6) {
        String string = x$6.sourceName();
        String string2 = sourceName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$registerSources$1(MetricsSystem $this, Tuple2 kv) {
        String classPath = ((Properties)kv._2()).getProperty("class");
        try {
            Object source = Utils$.MODULE$.classForName(classPath).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            $this.registerSource((Source)source);
        }
        catch (Exception e) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Source class ").append(classPath).append(" cannot be instantiated").toString(), e);
        }
    }

    public MetricsSystem(String instance, CelebornConf conf) {
        this.instance = instance;
        this.conf = conf;
        Logging.$init$(this);
        this.metricsConfig = new MetricsConfig(conf);
        this.sinks = new ArrayBuffer();
        this.sources = new CopyOnWriteArrayList();
        this.registry = new MetricRegistry();
        this.prometheusServletPath = conf.get(CelebornConf$.MODULE$.METRICS_PROMETHEUS_PATH());
        this.jsonServletPath = conf.get(CelebornConf$.MODULE$.METRICS_JSON_PATH());
        this.prometheusServlet = None$.MODULE$;
        this.jsonServlet = None$.MODULE$;
        this.running = false;
        this.metricsConfig.initialize();
    }
}

