/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.celeborn.common.exception.CelebornException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.network.client.RpcResponseCallback;
import org.apache.celeborn.common.rpc.RpcEndpoint;
import org.apache.celeborn.common.rpc.RpcEndpointAddress;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.rpc.RpcEnvStoppedException;
import org.apache.celeborn.common.rpc.netty.Inbox;
import org.apache.celeborn.common.rpc.netty.InboxMessage;
import org.apache.celeborn.common.rpc.netty.LocalNettyRpcCallContext;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.NettyRpcEnv;
import org.apache.celeborn.common.rpc.netty.OneWayMessage;
import org.apache.celeborn.common.rpc.netty.RemoteNettyRpcCallContext;
import org.apache.celeborn.common.rpc.netty.RequestMessage;
import org.apache.celeborn.common.rpc.netty.RpcMessage;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.concurrent.Promise;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015b!\u0002\u0016,\u0001E:\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b)\u0003A\u0011A&\u0007\t9\u0003Aa\u0014\u0005\t!\u000e\u0011)\u0019!C\u0001#\"AQl\u0001B\u0001B\u0003%!\u000b\u0003\u0005_\u0007\t\u0015\r\u0011\"\u0001`\u0011!!7A!A!\u0002\u0013\u0001\u0007\u0002C3\u0004\u0005\u000b\u0007I\u0011\u00014\t\u0011)\u001c!\u0011!Q\u0001\n\u001dDQAS\u0002\u0005\u0002-Dq!]\u0002C\u0002\u0013\u0005!\u000f\u0003\u0004w\u0007\u0001\u0006Ia\u001d\u0005\bo\u0002\u0011\r\u0011\"\u0003y\u0011\u001d\t9\u0001\u0001Q\u0001\neD\u0011\"!\u0003\u0001\u0005\u0004%I!a\u0003\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u001bA\u0011\"a\u0006\u0001\u0005\u0004%I!!\u0007\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u00037A\u0011\"a\t\u0001\u0001\u0004%I!!\n\t\u0013\u00055\u0002\u00011A\u0005\n\u0005=\u0002\u0002CA\u001e\u0001\u0001\u0006K!a\n\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBA3\u0001\u0011\u0005\u0011q\r\u0005\b\u0003W\u0002A\u0011BA7\u0011\u001d\t\t\b\u0001C\u0001\u0003gBq!!\u001f\u0001\t\u0003\tY\bC\u0004\u0002\b\u0002!\t!!#\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0007bBAd\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003c\u0002A\u0011AAw\u0011\u001d\ty\u000f\u0001C\u0001\u0003[Dq!!=\u0001\t\u0003\t\u0019\u0010C\u0005\u0002x\u0002\u0011\r\u0011\"\u0003\u0002z\"A!\u0011\u0001\u0001!\u0002\u0013\tYP\u0002\u0004\u0003\u0004\u0001!!Q\u0001\u0005\u0007\u0015\u0016\"\tA!\u0007\t\u000f\tuQ\u0005\"\u0011\u0002n\"I!q\u0004\u0001C\u0002\u0013%!\u0011\u0005\u0005\b\u0005G\u0001\u0001\u0015!\u0003m\u0005)!\u0015n\u001d9bi\u000eDWM\u001d\u0006\u0003Y5\nQA\\3uifT!AL\u0018\u0002\u0007I\u00048M\u0003\u00021c\u000511m\\7n_:T!AM\u001a\u0002\u0011\r,G.\u001a2pe:T!\u0001N\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0014aA8sON\u0019\u0001\u0001\u000f \u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\r\u0005s\u0017PU3g!\ty$)D\u0001A\u0015\t\tu&\u0001\u0005j]R,'O\\1m\u0013\t\u0019\u0005IA\u0004M_\u001e<\u0017N\\4\u0002\u00119,G\u000f^=F]Z\u001c\u0001\u0001\u0005\u0002H\u00116\t1&\u0003\u0002JW\tYa*\u001a;usJ\u00038-\u00128w\u0003\u0019a\u0014N\\5u}Q\u0011A*\u0014\t\u0003\u000f\u0002AQ\u0001\u0012\u0002A\u0002\u0019\u0013A\"\u00128ea>Lg\u000e\u001e#bi\u0006\u001c\"a\u0001\u001d\u0002\t9\fW.Z\u000b\u0002%B\u00111K\u0017\b\u0003)b\u0003\"!\u0016\u001e\u000e\u0003YS!aV#\u0002\rq\u0012xn\u001c;?\u0013\tI&(\u0001\u0004Qe\u0016$WMZ\u0005\u00037r\u0013aa\u0015;sS:<'BA-;\u0003\u0015q\u0017-\\3!\u0003!)g\u000e\u001a9pS:$X#\u00011\u0011\u0005\u0005\u0014W\"A\u0017\n\u0005\rl#a\u0003*qG\u0016sG\r]8j]R\f\u0011\"\u001a8ea>Lg\u000e\u001e\u0011\u0002\u0007I,g-F\u0001h!\t9\u0005.\u0003\u0002jW\t\u0019b*\u001a;usJ\u00038-\u00128ea>Lg\u000e\u001e*fM\u0006!!/\u001a4!)\u0011agn\u001c9\u0011\u00055\u001cQ\"\u0001\u0001\t\u000bAS\u0001\u0019\u0001*\t\u000byS\u0001\u0019\u00011\t\u000b\u0015T\u0001\u0019A4\u0002\u000b%t'm\u001c=\u0016\u0003M\u0004\"a\u0012;\n\u0005U\\#!B%oE>D\u0018AB5oE>D\b%A\u0005f]\u0012\u0004x.\u001b8ugV\t\u0011\u0010E\u0003{\u0003\u0007\u0011F.D\u0001|\u0015\taX0\u0001\u0006d_:\u001cWO\u001d:f]RT!A`@\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u0003\tAA[1wC&\u0019\u0011QA>\u0003\u001b\r{gnY;se\u0016tG/T1q\u0003))g\u000e\u001a9pS:$8\u000fI\u0001\rK:$\u0007o\\5oiJ+gm]\u000b\u0003\u0003\u001b\u0001bA_A\u0002A\u0006=\u0001cA1\u0002\u0012%\u0019\u00111C\u0017\u0003\u001dI\u00038-\u00128ea>Lg\u000e\u001e*fM\u0006iQM\u001c3q_&tGOU3gg\u0002\n\u0011B]3dK&4XM]:\u0016\u0005\u0005m\u0001\u0003\u0002>\u0002\u001e1L1!a\b|\u0005Ma\u0015N\\6fI\ncwnY6j]\u001e\fV/Z;f\u0003)\u0011XmY3jm\u0016\u00148\u000fI\u0001\bgR|\u0007\u000f]3e+\t\t9\u0003E\u0002:\u0003SI1!a\u000b;\u0005\u001d\u0011un\u001c7fC:\f1b\u001d;paB,Gm\u0018\u0013fcR!\u0011\u0011GA\u001c!\rI\u00141G\u0005\u0004\u0003kQ$\u0001B+oSRD\u0011\"!\u000f\u0015\u0003\u0003\u0005\r!a\n\u0002\u0007a$\u0013'\u0001\u0005ti>\u0004\b/\u001a3!Q\u001d)\u0012qHA)\u0003'\u0002B!!\u0011\u0002N5\u0011\u00111\t\u0006\u0004y\u0006\u0015#\u0002BA$\u0003\u0013\n!\"\u00198o_R\fG/[8o\u0015\t\tY%A\u0003kCZ\f\u00070\u0003\u0003\u0002P\u0005\r#!C$vCJ$W\r\u001a\"z\u0003\u00151\u0018\r\\;fC\t\t)&\u0001\u0003uQ&\u001c\u0018a\u0005:fO&\u001cH/\u001a:Sa\u000e,e\u000e\u001a9pS:$H#B4\u0002\\\u0005u\u0003\"\u0002)\u0017\u0001\u0004\u0011\u0006\"\u00020\u0017\u0001\u0004\u0001\u0017!E4fiJ\u00038-\u00128ea>Lg\u000e\u001e*fMR!\u0011qBA2\u0011\u0015qv\u00031\u0001a\u0003Q\u0011X-\\8wKJ\u00038-\u00128ea>Lg\u000e\u001e*fMR!\u0011\u0011GA5\u0011\u0015q\u0006\u00041\u0001a\u0003U)hN]3hSN$XM\u001d*qG\u0016sG\r]8j]R$B!!\r\u0002p!)\u0001+\u0007a\u0001%\u0006!1\u000f^8q)\u0011\t\t$!\u001e\t\u000f\u0005]$\u00041\u0001\u0002\u0010\u0005q!\u000f]2F]\u0012\u0004x.\u001b8u%\u00164\u0017!\u00039pgR$v.\u00117m)\u0011\t\t$! \t\u000f\u0005}4\u00041\u0001\u0002\u0002\u00069Q.Z:tC\u001e,\u0007cA$\u0002\u0004&\u0019\u0011QQ\u0016\u0003\u0019%s'm\u001c=NKN\u001c\u0018mZ3\u0002#A|7\u000f\u001e*f[>$X-T3tg\u0006<W\r\u0006\u0004\u00022\u0005-\u00151\u0013\u0005\b\u0003\u007fb\u0002\u0019AAG!\r9\u0015qR\u0005\u0004\u0003#[#A\u0004*fcV,7\u000f^'fgN\fw-\u001a\u0005\b\u0003+c\u0002\u0019AAL\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007\u0003BAM\u0003Gk!!a'\u000b\t\u0005u\u0015qT\u0001\u0007G2LWM\u001c;\u000b\u0007\u0005\u0005v&A\u0004oKR<xN]6\n\t\u0005\u0015\u00161\u0014\u0002\u0014%B\u001c'+Z:q_:\u001cXmQ1mY\n\f7m[\u0001\u0011a>\u001cH\u000fT8dC2lUm]:bO\u0016$b!!\r\u0002,\u00065\u0006bBA@;\u0001\u0007\u0011Q\u0012\u0005\b\u0003_k\u0002\u0019AAY\u0003\u0005\u0001\bCBAZ\u0003o\u000bY,\u0004\u0002\u00026*\u0011APO\u0005\u0005\u0003s\u000b)LA\u0004Qe>l\u0017n]3\u0011\u0007e\ni,C\u0002\u0002@j\u00121!\u00118z\u0003E\u0001xn\u001d;P]\u0016<\u0016-_'fgN\fw-\u001a\u000b\u0005\u0003c\t)\rC\u0004\u0002\u0000y\u0001\r!!$\u0002\u0017A|7\u000f^'fgN\fw-\u001a\u000b\t\u0003c\tY-a4\u0002R\"1\u0011QZ\u0010A\u0002I\u000bA\"\u001a8ea>Lg\u000e\u001e(b[\u0016Dq!a  \u0001\u0004\t\t\tC\u0004\u0002T~\u0001\r!!6\u0002#\r\fG\u000e\u001c2bG.Lem\u0015;paB,G\rE\u0004:\u0003/\fY.!\r\n\u0007\u0005e'HA\u0005Gk:\u001cG/[8ocA!\u0011Q\\At\u001d\u0011\ty.a9\u000f\u0007U\u000b\t/C\u0001<\u0013\r\t)OO\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI/a;\u0003\u0013\u0015C8-\u001a9uS>t'bAAsuQ\u0011\u0011\u0011G\u0001\u0011C^\f\u0017\u000e\u001e+fe6Lg.\u0019;j_:\faA^3sS\u001aLH\u0003BA\u0014\u0003kDQ\u0001\u0015\u0012A\u0002I\u000b!\u0002\u001e5sK\u0006$\u0007o\\8m+\t\tY\u0010E\u0002{\u0003{L1!a@|\u0005I!\u0006N]3bIB{w\u000e\\#yK\u000e,Ho\u001c:\u0002\u0017QD'/Z1ea>|G\u000e\t\u0002\f\u001b\u0016\u001c8/Y4f\u0019>|\u0007oE\u0003&\u0005\u000f\u0011\u0019\u0002\u0005\u0003\u0003\n\t=QB\u0001B\u0006\u0015\r\u0011ia`\u0001\u0005Y\u0006tw-\u0003\u0003\u0003\u0012\t-!AB(cU\u0016\u001cG\u000f\u0005\u0003\u0003\n\tU\u0011\u0002\u0002B\f\u0005\u0017\u0011\u0001BU;o]\u0006\u0014G.\u001a\u000b\u0003\u00057\u0001\"!\\\u0013\u0002\u0007I,h.\u0001\u0006Q_&\u001cxN\u001c)jY2,\u0012\u0001\\\u0001\f!>L7o\u001c8QS2d\u0007\u0005")
public class Dispatcher
implements Logging {
    private final NettyRpcEnv nettyEnv;
    private final ConcurrentMap<String, EndpointData> endpoints;
    private final ConcurrentMap<RpcEndpoint, RpcEndpointRef> endpointRefs;
    private final LinkedBlockingQueue<EndpointData> org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers;
    @GuardedBy(value="this")
    private boolean stopped;
    private final ThreadPoolExecutor org$apache$celeborn$common$rpc$netty$Dispatcher$$threadpool;
    private final EndpointData org$apache$celeborn$common$rpc$netty$Dispatcher$$PoisonPill;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    private ConcurrentMap<String, EndpointData> endpoints() {
        return this.endpoints;
    }

    private ConcurrentMap<RpcEndpoint, RpcEndpointRef> endpointRefs() {
        return this.endpointRefs;
    }

    public LinkedBlockingQueue<EndpointData> org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers() {
        return this.org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public NettyRpcEndpointRef registerRpcEndpoint(String name, RpcEndpoint endpoint) {
        RpcEndpointAddress addr = new RpcEndpointAddress(this.nettyEnv.address(), name);
        NettyRpcEndpointRef endpointRef = new NettyRpcEndpointRef(this.nettyEnv.celebornConf(), addr, this.nettyEnv);
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            if (this.stopped()) {
                throw new IllegalStateException("RpcEnv has been stopped");
            }
            if (this.endpoints().putIfAbsent(name, new EndpointData(this, name, endpoint, endpointRef)) != null) {
                throw new IllegalArgumentException(new StringBuilder(39).append("There is already an RpcEndpoint called ").append(name).toString());
            }
            EndpointData data = (EndpointData)this.endpoints().get(name);
            this.endpointRefs().put(data.endpoint(), data.ref());
            this.org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers().offer(data);
        }
        return endpointRef;
    }

    public RpcEndpointRef getRpcEndpointRef(RpcEndpoint endpoint) {
        return (RpcEndpointRef)this.endpointRefs().get(endpoint);
    }

    public void removeRpcEndpointRef(RpcEndpoint endpoint) {
        this.endpointRefs().remove(endpoint);
    }

    private void unregisterRpcEndpoint(String name) {
        block0: {
            EndpointData data = (EndpointData)this.endpoints().remove(name);
            if (data == null) break block0;
            data.inbox().stop();
            this.org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers().offer(data);
        }
    }

    public synchronized void stop(RpcEndpointRef rpcEndpointRef) {
        if (this.stopped()) {
            return;
        }
        this.unregisterRpcEndpoint(rpcEndpointRef.name());
    }

    public void postToAll(InboxMessage message) {
        for (String name : this.endpoints().keySet()) {
            this.postMessage(name, message, (Function1<Exception, BoxedUnit>)(Function1<Exception, Object> & Serializable & scala.Serializable)x0$1 -> {
                Dispatcher.$anonfun$postToAll$1(this, message, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void postRemoteMessage(RequestMessage message, RpcResponseCallback callback) {
        RemoteNettyRpcCallContext rpcCallContext = new RemoteNettyRpcCallContext(this.nettyEnv, callback, message.senderAddress());
        RpcMessage rpcMessage = new RpcMessage(message.senderAddress(), message.content(), rpcCallContext);
        this.postMessage(message.receiver().name(), rpcMessage, (Function1<Exception, BoxedUnit>)(Function1<Exception, Object> & Serializable & scala.Serializable)e -> {
            callback.onFailure(e);
            return BoxedUnit.UNIT;
        });
    }

    public void postLocalMessage(RequestMessage message, Promise<Object> p) {
        LocalNettyRpcCallContext rpcCallContext = new LocalNettyRpcCallContext(message.senderAddress(), p);
        RpcMessage rpcMessage = new RpcMessage(message.senderAddress(), message.content(), rpcCallContext);
        this.postMessage(message.receiver().name(), rpcMessage, (Function1<Exception, BoxedUnit>)(Function1<Exception, Object> & Serializable & scala.Serializable)e -> {
            p.tryFailure(e);
            return BoxedUnit.UNIT;
        });
    }

    public void postOneWayMessage(RequestMessage message) {
        this.postMessage(message.receiver().name(), new OneWayMessage(message.senderAddress(), message.content()), (Function1<Exception, BoxedUnit>)(Function1<Exception, Nothing$> & Serializable & scala.Serializable)e -> {
            throw e;
        });
    }

    public void postMessage(String endpointName, InboxMessage message, Function1<Exception, BoxedUnit> callbackIfStopped) {
        Some<RpcEnvStoppedException> some;
        Dispatcher dispatcher = this;
        synchronized (dispatcher) {
            Option option;
            EndpointData data = (EndpointData)this.endpoints().get(endpointName);
            if (this.stopped()) {
                option = new Some<RpcEnvStoppedException>(new RpcEnvStoppedException());
            } else if (data == null) {
                option = new Some<CelebornException>(new CelebornException(new StringBuilder(16).append("Could not find ").append(endpointName).append(".").toString()));
            } else {
                data.inbox().post(message);
                this.org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers().offer(data);
                option = None$.MODULE$;
            }
            some = option;
        }
        Some<RpcEnvStoppedException> error = some;
        error.foreach(callbackIfStopped);
    }

    public void stop() {
        block4: {
            Dispatcher dispatcher = this;
            synchronized (dispatcher) {
                block3: {
                    if (this.stopped()) break block3;
                    this.stopped_$eq(true);
                    break block4;
                }
                return;
            }
        }
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.endpoints().keySet()).asScala()).foreach((Function1<String, Object> & Serializable & scala.Serializable)name -> {
            this.unregisterRpcEndpoint(name);
            return BoxedUnit.UNIT;
        });
        this.org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers().offer(this.org$apache$celeborn$common$rpc$netty$Dispatcher$$PoisonPill());
        this.org$apache$celeborn$common$rpc$netty$Dispatcher$$threadpool().shutdown();
    }

    public void awaitTermination() {
        this.org$apache$celeborn$common$rpc$netty$Dispatcher$$threadpool().awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public boolean verify(String name) {
        return this.endpoints().containsKey(name);
    }

    public ThreadPoolExecutor org$apache$celeborn$common$rpc$netty$Dispatcher$$threadpool() {
        return this.org$apache$celeborn$common$rpc$netty$Dispatcher$$threadpool;
    }

    public EndpointData org$apache$celeborn$common$rpc$netty$Dispatcher$$PoisonPill() {
        return this.org$apache$celeborn$common$rpc$netty$Dispatcher$$PoisonPill;
    }

    public static final /* synthetic */ void $anonfun$postToAll$1(Dispatcher $this, InboxMessage message$1, Exception x0$1) {
        Exception exception = x0$1;
        if (exception instanceof RpcEnvStoppedException) {
            RpcEnvStoppedException rpcEnvStoppedException = (RpcEnvStoppedException)exception;
            $this.logDebug((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Message ").append(message$1).append(" dropped. ").append(rpcEnvStoppedException.getMessage()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (exception != null) {
            Exception exception2 = exception;
            $this.logWarning((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Message ").append(message$1).append(" dropped. ").append(exception2.getMessage()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)exception);
        }
    }

    public Dispatcher(NettyRpcEnv nettyEnv) {
        this.nettyEnv = nettyEnv;
        Logging.$init$(this);
        this.endpoints = JavaUtils.newConcurrentHashMap();
        this.endpointRefs = JavaUtils.newConcurrentHashMap();
        this.org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers = new LinkedBlockingQueue();
        this.stopped = false;
        int numUsableCores = nettyEnv.config().numUsableCores();
        int availableCores = numUsableCores > 0 ? numUsableCores : Math.max(16, Runtime.getRuntime().availableProcessors());
        String role = nettyEnv.config().name().toLowerCase();
        int numThreads = nettyEnv.celebornConf().rpcDispatcherNumThreads(availableCores, role);
        ThreadPoolExecutor pool = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(numThreads, "celeborn-dispatcher");
        this.logInfo((Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Dispatcher numThreads: ").append(numThreads).toString());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> pool.execute(new MessageLoop()));
        this.org$apache$celeborn$common$rpc$netty$Dispatcher$$threadpool = pool;
        this.org$apache$celeborn$common$rpc$netty$Dispatcher$$PoisonPill = new EndpointData(this, null, null, null);
    }

    private class EndpointData {
        private final String name;
        private final RpcEndpoint endpoint;
        private final NettyRpcEndpointRef ref;
        private final Inbox inbox;
        public final /* synthetic */ Dispatcher $outer;

        public String name() {
            return this.name;
        }

        public RpcEndpoint endpoint() {
            return this.endpoint;
        }

        public NettyRpcEndpointRef ref() {
            return this.ref;
        }

        public Inbox inbox() {
            return this.inbox;
        }

        public /* synthetic */ Dispatcher org$apache$celeborn$common$rpc$netty$Dispatcher$EndpointData$$$outer() {
            return this.$outer;
        }

        public EndpointData(Dispatcher $outer, String name, RpcEndpoint endpoint, NettyRpcEndpointRef ref) {
            this.name = name;
            this.endpoint = endpoint;
            this.ref = ref;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.inbox = new Inbox(ref, endpoint);
        }
    }

    private class MessageLoop
    implements Runnable {
        @Override
        public void run() {
            block8: while (true) {
                try {
                    while (true) {
                        try {
                            EndpointData data;
                            EndpointData endpointData = data = this.org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers().take();
                            EndpointData endpointData2 = this.org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$celeborn$common$rpc$netty$Dispatcher$$PoisonPill();
                            if (!(endpointData != null ? !endpointData.equals(endpointData2) : endpointData2 != null)) {
                                this.org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$celeborn$common$rpc$netty$Dispatcher$$receivers().offer(this.org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$celeborn$common$rpc$netty$Dispatcher$$PoisonPill());
                                return;
                            }
                            data.inbox().process(this.org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer());
                            continue block8;
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                            if (!option.isEmpty()) {
                                Throwable e = option.get();
                                this.org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer().logError((Function0<String> & Serializable & scala.Serializable)() -> e.getMessage(), e);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                continue;
                            }
                            throw throwable;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                catch (Throwable t) {
                    try {
                        this.org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer().org$apache$celeborn$common$rpc$netty$Dispatcher$$threadpool().execute(this.org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer().new MessageLoop());
                    }
                    finally {
                        throw t;
                    }
                }
            }
        }

        public /* synthetic */ Dispatcher org$apache$celeborn$common$rpc$netty$Dispatcher$MessageLoop$$$outer() {
            return Dispatcher.this;
        }

        public MessageLoop() {
            if (Dispatcher.this == null) {
                throw null;
            }
        }
    }
}

