/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.constraint;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.yarn.api.records.AllocationTagNamespaceType;
import org.apache.hadoop.yarn.api.records.NodeAttributeOpCode;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.apache.hadoop.yarn.util.constraint.PlacementConstraintParseException;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class PlacementConstraintParser {
    public static final char EXPRESSION_VAL_DELIM = ',';
    private static final char EXPRESSION_DELIM = ':';
    private static final char KV_SPLIT_DELIM = '=';
    private static final char BRACKET_START = '(';
    private static final char BRACKET_END = ')';
    private static final char NAMESPACE_DELIM = '/';
    private static final String KV_NE_DELIM = "!=";
    private static final String IN = "in";
    private static final String NOT_IN = "notin";
    private static final String AND = "and";
    private static final String OR = "or";
    private static final String CARDINALITY = "cardinality";
    private static final String SCOPE_NODE = "node";
    private static final String SCOPE_RACK = "rack";

    private PlacementConstraintParser() {
    }

    public static PlacementConstraint.AbstractConstraint parseExpression(String constraintStr) throws PlacementConstraintParseException {
        TargetConstraintParser tp = new TargetConstraintParser(constraintStr);
        Optional<PlacementConstraint.AbstractConstraint> constraintOptional = Optional.ofNullable(tp.tryParse());
        if (!constraintOptional.isPresent()) {
            CardinalityConstraintParser cp = new CardinalityConstraintParser(constraintStr);
            constraintOptional = Optional.ofNullable(cp.tryParse());
            if (!constraintOptional.isPresent()) {
                ConjunctionConstraintParser jp = new ConjunctionConstraintParser(constraintStr);
                constraintOptional = Optional.ofNullable(jp.tryParse());
            }
            if (!constraintOptional.isPresent()) {
                NodeConstraintParser np = new NodeConstraintParser(constraintStr);
                constraintOptional = Optional.ofNullable(np.tryParse());
            }
            if (!constraintOptional.isPresent()) {
                throw new PlacementConstraintParseException("Invalid constraint expression " + constraintStr);
            }
        }
        return constraintOptional.get();
    }

    public static Map<SourceTags, PlacementConstraint> parsePlacementSpec(String expression) throws PlacementConstraintParseException {
        LinkedHashMap<SourceTags, PlacementConstraint> result = new LinkedHashMap<SourceTags, PlacementConstraint>();
        MultipleConstraintsTokenizer tokenizer = new MultipleConstraintsTokenizer(expression);
        tokenizer.validate();
        while (tokenizer.hasMoreElements()) {
            PlacementConstraint constraint;
            SourceTags st;
            String delimiter;
            String specStr = (String)tokenizer.nextElement();
            String[] splitted = specStr.split(delimiter = new String(new char[]{'[', ')', ']', ','}), 2);
            if (splitted.length == 2) {
                st = SourceTags.parseFrom(splitted[0] + String.valueOf(')'));
                constraint = PlacementConstraintParser.parseExpression(splitted[1]).build();
            } else if (splitted.length == 1) {
                NodeConstraintParser np = new NodeConstraintParser(specStr);
                Optional<PlacementConstraint.AbstractConstraint> constraintOptional = Optional.ofNullable(np.tryParse());
                if (constraintOptional.isPresent()) {
                    st = SourceTags.emptySourceTags();
                    constraint = constraintOptional.get().build();
                } else {
                    st = SourceTags.parseFrom(specStr);
                    constraint = null;
                }
            } else {
                throw new PlacementConstraintParseException("Unexpected placement constraint expression " + specStr);
            }
            result.put(st, constraint);
        }
        Set sourceTagSet = result.keySet();
        if (sourceTagSet.stream().filter(sourceTags -> sourceTags.isEmpty()).findAny().isPresent() && result.size() != 1) {
            throw new PlacementConstraintParseException("Source allocation tags is required for a multi placement constraint expression.");
        }
        return result;
    }

    public static final class SourceTags {
        private String tag;
        private int num;

        private SourceTags(String sourceTag, int number) {
            this.tag = sourceTag;
            this.num = number;
        }

        public static SourceTags emptySourceTags() {
            return new SourceTags("", 0);
        }

        public boolean isEmpty() {
            return Strings.isNullOrEmpty((String)this.tag) && this.num == 0;
        }

        public String getTag() {
            return this.tag;
        }

        public int getNumOfAllocations() {
            return this.num;
        }

        public static SourceTags parseFrom(String expr) throws PlacementConstraintParseException {
            SourceTagsTokenizer stt = new SourceTagsTokenizer(expr);
            stt.validate();
            String allocTag = stt.nextElement();
            int allocNum = Integer.parseInt(stt.nextElement());
            return new SourceTags(allocTag, allocNum);
        }
    }

    public static class ConjunctionConstraintParser
    extends ConstraintParser {
        public ConjunctionConstraintParser(String expr) {
            super(new ConjunctionTokenizer(expr));
        }

        @Override
        public PlacementConstraint.AbstractConstraint parse() throws PlacementConstraintParseException {
            this.validate();
            String op = this.nextToken();
            this.shouldHaveNext();
            ArrayList<PlacementConstraint.AbstractConstraint> constraints = new ArrayList<PlacementConstraint.AbstractConstraint>();
            while (this.hasMoreTokens()) {
                String constraintStr = this.nextToken();
                PlacementConstraint.AbstractConstraint constraint = PlacementConstraintParser.parseExpression(constraintStr);
                constraints.add(constraint);
            }
            if (PlacementConstraintParser.AND.equalsIgnoreCase(op)) {
                return PlacementConstraints.and(constraints.toArray(new PlacementConstraint.AbstractConstraint[constraints.size()]));
            }
            if (PlacementConstraintParser.OR.equalsIgnoreCase(op)) {
                return PlacementConstraints.or(constraints.toArray(new PlacementConstraint.AbstractConstraint[constraints.size()]));
            }
            throw new PlacementConstraintParseException("Unexpected conjunction operator : " + op + ", expecting " + PlacementConstraintParser.AND + " or " + PlacementConstraintParser.OR);
        }
    }

    public static class CardinalityConstraintParser
    extends ConstraintParser {
        public CardinalityConstraintParser(String expr) {
            super(new BaseStringTokenizer(expr, String.valueOf(',')));
        }

        @Override
        public PlacementConstraint.AbstractConstraint parse() throws PlacementConstraintParseException {
            String op = this.nextToken();
            if (!op.equalsIgnoreCase(PlacementConstraintParser.CARDINALITY)) {
                throw new PlacementConstraintParseException("expecting cardinality , but met " + op);
            }
            this.shouldHaveNext();
            String scope = this.nextToken();
            scope = this.parseScope(scope);
            Stack<String> resetElements = new Stack<String>();
            while (this.hasMoreTokens()) {
                resetElements.add(this.nextToken());
            }
            if (resetElements.size() < 3) {
                throw new PlacementConstraintParseException("Invalid syntax for a cardinality expression, expecting \"cardinality,SCOPE,TARGET_TAG,...,TARGET_TAG,MIN_CARDINALITY,MAX_CARDINALITY\" at least 5 elements, but only " + (resetElements.size() + 2) + " is given.");
            }
            String maxCardinalityStr = (String)resetElements.pop();
            int max = this.toInt(maxCardinalityStr);
            String minCardinalityStr = (String)resetElements.pop();
            int min = this.toInt(minCardinalityStr);
            HashSet<PlacementConstraint.TargetExpression> targetExpressions = new HashSet<PlacementConstraint.TargetExpression>();
            while (!resetElements.empty()) {
                String tag = (String)resetElements.pop();
                PlacementConstraint.TargetExpression t = this.parseNameSpace(tag);
                targetExpressions.add(t);
            }
            PlacementConstraint.TargetExpression[] targetArr = targetExpressions.toArray(new PlacementConstraint.TargetExpression[targetExpressions.size()]);
            return PlacementConstraints.targetCardinality(scope, min, max, targetArr);
        }
    }

    public static class TargetConstraintParser
    extends ConstraintParser {
        public TargetConstraintParser(String expression) {
            super(new BaseStringTokenizer(expression, String.valueOf(',')));
        }

        @Override
        public PlacementConstraint.AbstractConstraint parse() throws PlacementConstraintParseException {
            PlacementConstraint.AbstractConstraint placementConstraints = null;
            String op = this.nextToken();
            if (op.equalsIgnoreCase(PlacementConstraintParser.IN) || op.equalsIgnoreCase(PlacementConstraintParser.NOT_IN)) {
                String scope = this.nextToken();
                scope = this.parseScope(scope);
                HashSet<PlacementConstraint.TargetExpression> targetExpressions = new HashSet<PlacementConstraint.TargetExpression>();
                while (this.hasMoreTokens()) {
                    String tag = this.nextToken();
                    PlacementConstraint.TargetExpression t = this.parseNameSpace(tag);
                    targetExpressions.add(t);
                }
                PlacementConstraint.TargetExpression[] targetArr = targetExpressions.toArray(new PlacementConstraint.TargetExpression[targetExpressions.size()]);
                placementConstraints = op.equalsIgnoreCase(PlacementConstraintParser.IN) ? PlacementConstraints.targetIn(scope, targetArr) : PlacementConstraints.targetNotIn(scope, targetArr);
            } else {
                throw new PlacementConstraintParseException("expecting in or notin, but get " + op);
            }
            return placementConstraints;
        }
    }

    public static class NodeConstraintParser
    extends ConstraintParser {
        public NodeConstraintParser(String expression) {
            super(new BaseStringTokenizer(expression, String.valueOf(',')));
        }

        @Override
        public PlacementConstraint.AbstractConstraint parse() throws PlacementConstraintParseException {
            PlacementConstraint.AbstractConstraint placementConstraints = null;
            String attributeName = "";
            NodeAttributeOpCode opCode = NodeAttributeOpCode.EQ;
            String scope = PlacementConstraintParser.SCOPE_NODE;
            TreeSet<String> constraintEntities = new TreeSet<String>();
            while (this.hasMoreTokens()) {
                String currentTag = this.nextToken();
                StringTokenizer attributeKV = this.getAttributeOpCodeTokenizer(currentTag);
                if (attributeKV.countTokens() > 1) {
                    opCode = this.getAttributeOpCode(currentTag);
                    attributeName = attributeKV.nextToken();
                    currentTag = attributeKV.nextToken();
                }
                constraintEntities.add(currentTag);
            }
            if (attributeName.isEmpty()) {
                throw new PlacementConstraintParseException("expecting valid expression like k=v or k!=v, but get " + constraintEntities);
            }
            PlacementConstraint.TargetExpression target = null;
            if (!constraintEntities.isEmpty()) {
                target = PlacementConstraints.PlacementTargets.nodeAttribute(attributeName, constraintEntities.toArray(new String[constraintEntities.size()]));
            }
            placementConstraints = PlacementConstraints.targetNodeAttribute(scope, opCode, target);
            return placementConstraints;
        }

        private StringTokenizer getAttributeOpCodeTokenizer(String currentTag) {
            StringTokenizer attributeKV = new StringTokenizer(currentTag, PlacementConstraintParser.KV_NE_DELIM);
            if (attributeKV.countTokens() < 2) {
                attributeKV = new StringTokenizer(currentTag, String.valueOf('='));
            }
            return attributeKV;
        }

        private NodeAttributeOpCode getAttributeOpCode(String currentTag) throws PlacementConstraintParseException {
            if (currentTag.contains(PlacementConstraintParser.KV_NE_DELIM)) {
                return NodeAttributeOpCode.NE;
            }
            if (currentTag.contains(String.valueOf('='))) {
                return NodeAttributeOpCode.EQ;
            }
            throw new PlacementConstraintParseException("expecting valid expression like k=v or k!=v, but get " + currentTag);
        }
    }

    public static class MultipleConstraintsTokenizer
    implements ConstraintTokenizer {
        private final String expr;
        private Iterator<String> iterator;

        public MultipleConstraintsTokenizer(String expression) {
            this.expr = expression;
        }

        @Override
        public void validate() throws PlacementConstraintParseException {
            ArrayList<String> parsedElements = new ArrayList<String>();
            char[] arr = this.expr.toCharArray();
            Stack<Integer> stack = new Stack<Integer>();
            block5: for (int i = 0; i < arr.length; ++i) {
                char current = arr[i];
                switch (current) {
                    case ':': {
                        stack.add(i);
                        continue block5;
                    }
                    case '(': {
                        stack.add(i);
                        continue block5;
                    }
                    case ')': {
                        while (!stack.isEmpty() && arr[(Integer)stack.pop()] != '(') {
                        }
                        continue block5;
                    }
                }
            }
            if (stack.isEmpty()) {
                parsedElements.add(this.expr);
            } else {
                Iterator it = stack.iterator();
                int currentPos = 0;
                while (it.hasNext()) {
                    int pos = (Integer)it.next();
                    String sub = this.expr.substring(currentPos, pos);
                    if (sub != null && !sub.isEmpty()) {
                        parsedElements.add(sub);
                    }
                    currentPos = pos + 1;
                }
                if (currentPos < this.expr.length()) {
                    parsedElements.add(this.expr.substring(currentPos, this.expr.length()));
                }
            }
            this.iterator = parsedElements.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public String nextElement() {
            return this.iterator.next();
        }
    }

    public static class SourceTagsTokenizer
    implements ConstraintTokenizer {
        private final String expression;
        private StringTokenizer st;
        private Iterator<String> iterator;

        public SourceTagsTokenizer(String expr) {
            this.expression = expr;
            this.st = new StringTokenizer(expr, String.valueOf('('));
        }

        @Override
        public void validate() throws PlacementConstraintParseException {
            ArrayList<String> parsedValues = new ArrayList<String>();
            if (this.st.countTokens() != 2 || !this.expression.endsWith(String.valueOf(')'))) {
                throw new PlacementConstraintParseException("Expecting source allocation tag to be specified sourceTag(numOfAllocations) syntax, but met " + this.expression);
            }
            String sourceTag = this.st.nextToken();
            parsedValues.add(sourceTag);
            String str = this.st.nextToken();
            String num = str.substring(0, str.length() - 1);
            try {
                Integer.parseInt(num);
                parsedValues.add(num);
            }
            catch (NumberFormatException e) {
                throw new PlacementConstraintParseException("Value of the expression must be an integer, but met " + num);
            }
            this.iterator = parsedValues.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public String nextElement() {
            return this.iterator.next();
        }
    }

    public static final class ConjunctionTokenizer
    implements ConstraintTokenizer {
        private final String expression;
        private Iterator<String> iterator;

        private ConjunctionTokenizer(String expr) {
            this.expression = expr;
        }

        @Override
        public void validate() throws PlacementConstraintParseException {
            String op;
            ArrayList<String> parsedElements = new ArrayList<String>();
            if (this.expression.startsWith(PlacementConstraintParser.AND) || this.expression.startsWith(PlacementConstraintParser.AND.toUpperCase())) {
                op = PlacementConstraintParser.AND;
            } else if (this.expression.startsWith(PlacementConstraintParser.OR) || this.expression.startsWith(PlacementConstraintParser.OR.toUpperCase())) {
                op = PlacementConstraintParser.OR;
            } else {
                throw new PlacementConstraintParseException("Excepting starting with \"and\" or \"or\", but met " + this.expression);
            }
            parsedElements.add(op);
            Pattern p = Pattern.compile("\\((.*)\\)");
            Matcher m = p.matcher(this.expression);
            if (!m.find()) {
                throw new PlacementConstraintParseException("Unexpected format, expecting [AND|OR](A:B...) but current expression is " + this.expression);
            }
            String childStrs = m.group(1);
            MultipleConstraintsTokenizer ct = new MultipleConstraintsTokenizer(childStrs);
            ct.validate();
            while (ct.hasMoreElements()) {
                parsedElements.add(ct.nextElement());
            }
            this.iterator = parsedElements.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public String nextElement() {
            return this.iterator.next();
        }
    }

    public static class BaseStringTokenizer
    implements ConstraintTokenizer {
        private final StringTokenizer tokenizer;

        BaseStringTokenizer(String expr, String delimiter) {
            this.tokenizer = new StringTokenizer(expr, delimiter);
        }

        @Override
        public boolean hasMoreElements() {
            return this.tokenizer.hasMoreTokens();
        }

        @Override
        public String nextElement() {
            return this.tokenizer.nextToken();
        }
    }

    public static interface ConstraintTokenizer
    extends Enumeration<String> {
        default public void validate() throws PlacementConstraintParseException {
        }
    }

    public static abstract class ConstraintParser {
        private final ConstraintTokenizer tokenizer;

        public ConstraintParser(ConstraintTokenizer tk) {
            this.tokenizer = tk;
        }

        void validate() throws PlacementConstraintParseException {
            this.tokenizer.validate();
        }

        void shouldHaveNext() throws PlacementConstraintParseException {
            if (!this.tokenizer.hasMoreElements()) {
                throw new PlacementConstraintParseException("Expecting more tokens");
            }
        }

        String nextToken() {
            return ((String)this.tokenizer.nextElement()).trim();
        }

        boolean hasMoreTokens() {
            return this.tokenizer.hasMoreElements();
        }

        int toInt(String name) throws PlacementConstraintParseException {
            try {
                return Integer.parseInt(name);
            }
            catch (NumberFormatException e) {
                throw new PlacementConstraintParseException("Expecting an Integer, but get " + name);
            }
        }

        PlacementConstraint.TargetExpression parseNameSpace(String targetTag) throws PlacementConstraintParseException {
            int i = targetTag.lastIndexOf(47);
            if (i != -1) {
                String namespace = targetTag.substring(0, i);
                for (AllocationTagNamespaceType type : AllocationTagNamespaceType.values()) {
                    if (!type.getTypeKeyword().equals(namespace)) continue;
                    return PlacementConstraints.PlacementTargets.allocationTagWithNamespace(namespace, targetTag.substring(i + 1));
                }
                throw new PlacementConstraintParseException("Invalid namespace prefix: " + namespace);
            }
            return PlacementConstraints.PlacementTargets.allocationTag(targetTag);
        }

        String parseScope(String scopeString) throws PlacementConstraintParseException {
            if (scopeString.equalsIgnoreCase(PlacementConstraintParser.SCOPE_NODE)) {
                return PlacementConstraintParser.SCOPE_NODE;
            }
            if (scopeString.equalsIgnoreCase(PlacementConstraintParser.SCOPE_RACK)) {
                return PlacementConstraintParser.SCOPE_RACK;
            }
            throw new PlacementConstraintParseException("expecting scope to node or rack, but met " + scopeString);
        }

        public PlacementConstraint.AbstractConstraint tryParse() {
            try {
                return this.parse();
            }
            catch (PlacementConstraintParseException e) {
                return null;
            }
        }

        public abstract PlacementConstraint.AbstractConstraint parse() throws PlacementConstraintParseException;
    }
}

