/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.meta.TimeWindow;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.metrics.source.ThreadPoolSource$;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.service.deploy.worker.WorkerSource$;
import org.apache.celeborn.service.deploy.worker.congestcontrol.CongestionController;
import org.apache.celeborn.service.deploy.worker.memory.MemoryManager;
import org.apache.celeborn.service.deploy.worker.storage.FlushTask;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005MgAB\u0011#\u0003\u0003!\u0003\u0007\u0003\u0005@\u0001\t\u0015\r\u0011\"\u0001B\u0011!Q\u0005A!A!\u0002\u0013\u0011\u0005\u0002C&\u0001\u0005\u000b\u0007I\u0011\u0001'\t\u0011A\u0003!\u0011!Q\u0001\n5C\u0001\"\u0015\u0001\u0003\u0006\u0004%\tA\u0015\u0005\t;\u0002\u0011\t\u0011)A\u0005'\"Aa\f\u0001BC\u0002\u0013\u0005A\n\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003N\u0011!\u0001\u0007A!A!\u0002\u0013\t\u0007\u0002C4\u0001\u0005\u0003\u0005\u000b\u0011\u00025\t\u000bM\u0004A\u0011\u0001;\t\u0011u\u0004\u0001R1A\u0005\u00121CqA \u0001C\u0002\u0013Eq\u0010\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\u0001\u0011%\t\u0019\u0003\u0001b\u0001\n#\t)\u0003\u0003\u0005\u00020\u0001\u0001\u000b\u0011BA\u0014\u0011%\t\t\u0004\u0001b\u0001\n#\t\u0019\u0004\u0003\u0005\u0002>\u0001\u0001\u000b\u0011BA\u001b\u0011!\ty\u0004\u0001a\u0001\n#a\u0005\"CA!\u0001\u0001\u0007I\u0011CA\"\u0011\u001d\ty\u0005\u0001Q!\n5C\u0011\"!\u0015\u0001\u0005\u0004%\t!a\u0015\t\u0011\u0005\u0005\u0004\u0001)A\u0005\u0003+B\u0011\"a\u0019\u0001\u0005\u0004%\t!!\u001a\t\u0011\u00055\u0004\u0001)A\u0005\u0003OBq!a\u001c\u0001\t\u0013\t\t\b\u0003\u0004\u0002t\u0001!\t\u0001\u0014\u0005\b\u0003k\u0002A\u0011AA<\u0011\u001d\tI\b\u0001C\u0001\u0003wB\u0011\"!#\u0001#\u0003%\t!a#\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002$\"9\u0011q\u0017\u0001\u0007\u0002\u0005e&a\u0002$mkNDWM\u001d\u0006\u0003G\u0011\nqa\u001d;pe\u0006<WM\u0003\u0002&M\u00051qo\u001c:lKJT!a\n\u0015\u0002\r\u0011,\u0007\u000f\\8z\u0015\tI#&A\u0004tKJ4\u0018nY3\u000b\u0005-b\u0013\u0001C2fY\u0016\u0014wN\u001d8\u000b\u00055r\u0013AB1qC\u000eDWMC\u00010\u0003\ry'oZ\n\u0004\u0001E:\u0004C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$AB!osJ+g\r\u0005\u00029{5\t\u0011H\u0003\u0002;w\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002=U\u000511m\\7n_:L!AP\u001d\u0003\u000f1{wmZ5oO\u0006aqo\u001c:lKJ\u001cv.\u001e:dK\u000e\u0001Q#\u0001\"\u0011\u0005\rCU\"\u0001#\u000b\u0005\u00153\u0015AB:pkJ\u001cWM\u0003\u0002Hw\u00059Q.\u001a;sS\u000e\u001c\u0018BA%E\u00059\t%m\u001d;sC\u000e$8k\\;sG\u0016\fQb^8sW\u0016\u00148k\\;sG\u0016\u0004\u0013a\u0003;ie\u0016\fGmQ8v]R,\u0012!\u0014\t\u0003e9K!aT\u001a\u0003\u0007%sG/\u0001\u0007uQJ,\u0017\rZ\"pk:$\b%A\u0005bY2|7-\u0019;peV\t1\u000b\u0005\u0002U76\tQK\u0003\u0002W/\u00061!-\u001e4gKJT!\u0001W-\u0002\u000b9,G\u000f^=\u000b\u0003i\u000b!![8\n\u0005q+&A\u0006)p_2,GMQ=uK\n+h-\u00117m_\u000e\fGo\u001c:\u0002\u0015\u0005dGn\\2bi>\u0014\b%A\u0007nCb\u001cu.\u001c9p]\u0016tGo]\u0001\u000f[\u0006D8i\\7q_:,g\u000e^:!\u0003=1G.^:i)&lW-T3ue&\u001c\u0007C\u00012f\u001b\u0005\u0019'B\u00013<\u0003\u0011iW\r^1\n\u0005\u0019\u001c'A\u0003+j[\u0016<\u0016N\u001c3po\u0006QQn\\;oiB{\u0017N\u001c;\u0011\u0005%\u0004hB\u00016o!\tY7'D\u0001m\u0015\ti\u0007)\u0001\u0004=e>|GOP\u0005\u0003_N\na\u0001\u0015:fI\u00164\u0017BA9s\u0005\u0019\u0019FO]5oO*\u0011qnM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fU<\b0\u001f>|yB\u0011a\u000fA\u0007\u0002E!)qh\u0003a\u0001\u0005\")1j\u0003a\u0001\u001b\")\u0011k\u0003a\u0001'\")al\u0003a\u0001\u001b\")\u0001m\u0003a\u0001C\")qm\u0003a\u0001Q\u0006Ia\r\\;tQ\u0016\u0014\u0018\nZ\u0001\u000eo>\u00148.\u001b8h#V,W/Z:\u0016\u0005\u0005\u0005\u0001#\u0002\u001a\u0002\u0004\u0005\u001d\u0011bAA\u0003g\t)\u0011I\u001d:bsB1\u0011\u0011BA\f\u00037i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u000bG>t7-\u001e:sK:$(\u0002BA\t\u0003'\tA!\u001e;jY*\u0011\u0011QC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001a\u0005-!a\u0005'j].,GM\u00117pG.LgnZ)vKV,\u0007c\u0001<\u0002\u001e%\u0019\u0011q\u0004\u0012\u0003\u0013\u0019cWo\u001d5UCN\\\u0017AD<pe.LgnZ)vKV,7\u000fI\u0001\fEV4g-\u001a:Rk\u0016,X-\u0006\u0002\u0002(A1\u0011\u0011BA\f\u0003S\u00012\u0001VA\u0016\u0013\r\ti#\u0016\u0002\u0011\u0007>l\u0007o\\:ji\u0016\u0014\u0015\u0010^3Ck\u001a\fABY;gM\u0016\u0014\u0018+^3vK\u0002\nqa^8sW\u0016\u00148/\u0006\u0002\u00026A)!'a\u0001\u00028A!\u0011\u0011BA\u001d\u0013\u0011\tY$a\u0003\u0003\u001f\u0015CXmY;u_J\u001cVM\u001d<jG\u0016\f\u0001b^8sW\u0016\u00148\u000fI\u0001\u0010]\u0016DHoV8sW\u0016\u0014\u0018J\u001c3fq\u0006\u0019b.\u001a=u/>\u00148.\u001a:J]\u0012,\u0007p\u0018\u0013fcR!\u0011QIA&!\r\u0011\u0014qI\u0005\u0004\u0003\u0013\u001a$\u0001B+oSRD\u0001\"!\u0014\u0015\u0003\u0003\u0005\r!T\u0001\u0004q\u0012\n\u0014\u0001\u00058fqR<vN]6fe&sG-\u001a=!\u0003Ia\u0017m\u001d;CK\u001eLgN\u00127vg\"$\u0016.\\3\u0016\u0005\u0005U\u0003\u0003BA,\u0003;j!!!\u0017\u000b\t\u0005m\u00131B\u0001\u0007CR|W.[2\n\t\u0005}\u0013\u0011\f\u0002\u0010\u0003R|W.[2M_:<\u0017I\u001d:bs\u0006\u0019B.Y:u\u0005\u0016<\u0017N\u001c$mkNDG+[7fA\u0005A1\u000f^8q\r2\fw-\u0006\u0002\u0002hA!\u0011qKA5\u0013\u0011\tY'!\u0017\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003%\u0019Ho\u001c9GY\u0006<\u0007%\u0001\u0003j]&$HCAA#\u000399W\r^,pe.,'/\u00138eKb\f!\u0002^1lK\n+hMZ3s)\t\tI#\u0001\u0007sKR,(O\u001c\"vM\u001a,'\u000f\u0006\u0004\u0002F\u0005u\u0014q\u0010\u0005\u0007-v\u0001\r!!\u000b\t\u0013\u0005\u0005U\u0004%AA\u0002\u0005\r\u0015AC6fKB\u0014UO\u001a4feB\u0019!'!\"\n\u0007\u0005\u001d5GA\u0004C_>dW-\u00198\u0002-I,G/\u001e:o\u0005V4g-\u001a:%I\u00164\u0017-\u001e7uII*\"!!$+\t\u0005\r\u0015qR\u0016\u0003\u0003#\u0003B!a%\u0002\u001e6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000bI*A\u0005v]\u000eDWmY6fI*\u0019\u00111T\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002 \u0006U%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00069\u0011\r\u001a3UCN\\G\u0003CAB\u0003K\u000bI+a-\t\u000f\u0005\u001dv\u00041\u0001\u0002\u001c\u0005!A/Y:l\u0011\u001d\tYk\ba\u0001\u0003[\u000b\u0011\u0002^5nK>,H/T:\u0011\u0007I\ny+C\u0002\u00022N\u0012A\u0001T8oO\"1\u0011QW\u0010A\u00025\u000b1b^8sW\u0016\u0014\u0018J\u001c3fq\u0006\u0011\u0002O]8dKN\u001c\u0018jT#yG\u0016\u0004H/[8o)\u0019\t)%a/\u0002J\"9\u0011Q\u0018\u0011A\u0002\u0005}\u0016!A3\u0011\t\u0005\u0005\u0017QY\u0007\u0003\u0003\u0007T1AWA\n\u0013\u0011\t9-a1\u0003\u0017%{U\t_2faRLwN\u001c\u0005\b\u0003\u0017\u0004\u0003\u0019AAg\u0003=!WM^5dK\u0016\u0013(o\u001c:UsB,\u0007c\u00012\u0002P&\u0019\u0011\u0011[2\u0003\u0015\u0011K7o[*uCR,8\u000f")
public abstract class Flusher
implements Logging {
    private int flusherId;
    private final AbstractSource workerSource;
    private final int threadCount;
    private final PooledByteBufAllocator allocator;
    private final int maxComponents;
    public final TimeWindow org$apache$celeborn$service$deploy$worker$storage$Flusher$$flushTimeMetric;
    private final String mountPoint;
    private final LinkedBlockingQueue<FlushTask>[] workingQueues;
    private final LinkedBlockingQueue<CompositeByteBuf> bufferQueue;
    private final ExecutorService[] workers;
    private int nextWorkerIndex;
    private final AtomicLongArray lastBeginFlushTime;
    private final AtomicBoolean stopFlag;
    private transient Logger log;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        Flusher flusher = this;
        synchronized (flusher) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public AbstractSource workerSource() {
        return this.workerSource;
    }

    public int threadCount() {
        return this.threadCount;
    }

    public PooledByteBufAllocator allocator() {
        return this.allocator;
    }

    public int maxComponents() {
        return this.maxComponents;
    }

    private int flusherId$lzycompute() {
        Flusher flusher = this;
        synchronized (flusher) {
            if (!this.bitmap$0) {
                this.flusherId = System.identityHashCode(this);
                this.bitmap$0 = true;
            }
        }
        return this.flusherId;
    }

    public int flusherId() {
        if (!this.bitmap$0) {
            return this.flusherId$lzycompute();
        }
        return this.flusherId;
    }

    public LinkedBlockingQueue<FlushTask>[] workingQueues() {
        return this.workingQueues;
    }

    public LinkedBlockingQueue<CompositeByteBuf> bufferQueue() {
        return this.bufferQueue;
    }

    public ExecutorService[] workers() {
        return this.workers;
    }

    public int nextWorkerIndex() {
        return this.nextWorkerIndex;
    }

    public void nextWorkerIndex_$eq(int x$1) {
        this.nextWorkerIndex = x$1;
    }

    public AtomicLongArray lastBeginFlushTime() {
        return this.lastBeginFlushTime;
    }

    public AtomicBoolean stopFlag() {
        return this.stopFlag;
    }

    private void init() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.lastBeginFlushTime().length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.lastBeginFlushTime().set(i, -1L));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.threadCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            $this.workingQueues()[index] = new LinkedBlockingQueue();
            $this.workers()[index] = ThreadUtils$.MODULE$.newDaemonSingleThreadExecutor(new StringBuilder(1).append(this).append("-").append(index).toString());
            this.workers()[index].submit(new Runnable(this, index){
                private final /* synthetic */ Flusher $outer;
                private final int index$1;

                public void run() {
                    while (!this.$outer.stopFlag().get()) {
                        FlushTask task = this.$outer.workingQueues()[this.index$1].take();
                        String key = new StringBuilder(9).append("Flusher-").append(this).append("-").append(Random$.MODULE$.nextInt()).toString();
                        this.$outer.workerSource().sample(WorkerSource$.MODULE$.FLUSH_DATA_TIME(), key, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
                            if (!task.notifier().hasException()) {
                                try {
                                    long flushBeginTime = System.nanoTime();
                                    $this.$outer.lastBeginFlushTime().set($this.index$1, flushBeginTime);
                                    task.flush();
                                    if ($this.$outer.org$apache$celeborn$service$deploy$worker$storage$Flusher$$flushTimeMetric != null) {
                                        long delta = System.nanoTime() - flushBeginTime;
                                        $this.$outer.org$apache$celeborn$service$deploy$worker$storage$Flusher$$flushTimeMetric.update(delta);
                                    }
                                }
                                catch (Throwable t) {
                                    Throwable throwable = t;
                                    if (throwable instanceof IOException) {
                                        IOException iOException = (IOException)throwable;
                                        task.notifier().setException(iOException);
                                        $this.$outer.processIOException(iOException, DiskStatus.READ_OR_WRITE_FAILURE);
                                    }
                                    $this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Flusher-").append(this).append("-thread-").append($this.index$1).append(" encounter exception.").toString(), t);
                                }
                                $this.$outer.lastBeginFlushTime().set($this.index$1, -1L);
                            }
                            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.$outer.returnBuffer(task.buffer(), task.keepBuffer()));
                            return task$1.notifier().numPendingFlushes.decrementAndGet();
                        });
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.index$1 = index$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.celeborn.service.deploy.worker.storage.Flusher$$anon$1 org.apache.celeborn.service.deploy.worker.storage.FlushTask ), $anonfun$run$2(org.apache.celeborn.service.deploy.worker.storage.Flusher$$anon$1 ), $anonfun$run$3(org.apache.celeborn.service.deploy.worker.storage.Flusher$$anon$1 org.apache.celeborn.service.deploy.worker.storage.FlushTask )}, serializedLambda);
                }
            });
            this.workerSource().addGauge(WorkerSource$.MODULE$.FLUSH_WORKING_QUEUE_SIZE(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mountpoint"), (Object)new StringBuilder(1).append($this.mountPoint).append("-").append(index).toString())})), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.workingQueues()[index].size());
        });
        ThreadPoolSource$.MODULE$.registerSource(String.valueOf(this), this.workers());
    }

    public synchronized int getWorkerIndex() {
        this.nextWorkerIndex_$eq((this.nextWorkerIndex() + 1) % this.threadCount());
        return this.nextWorkerIndex();
    }

    public CompositeByteBuf takeBuffer() {
        CompositeByteBuf buffer;
        block0: {
            buffer = this.bufferQueue().poll();
            if (buffer != null) break block0;
            buffer = this.allocator().compositeDirectBuffer(this.maxComponents());
        }
        return buffer;
    }

    public void returnBuffer(CompositeByteBuf buffer, boolean keepBuffer) {
        int bufferSize = buffer.readableBytes();
        MemoryManager.instance().releaseDiskBuffer(bufferSize);
        Option$.MODULE$.apply((Object)CongestionController.instance()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.consumeBytes(bufferSize);
            return BoxedUnit.UNIT;
        });
        buffer.removeComponents(0, buffer.numComponents());
        buffer.clear();
        if (keepBuffer) {
            this.bufferQueue().put(buffer);
            return;
        }
        buffer.release();
    }

    public boolean returnBuffer$default$2() {
        return false;
    }

    public boolean addTask(FlushTask task, long timeoutMs, int workerIndex) {
        return this.workingQueues()[workerIndex].offer(task, timeoutMs, TimeUnit.MILLISECONDS);
    }

    public abstract void processIOException(IOException var1, DiskStatus var2);

    public Flusher(AbstractSource workerSource, int threadCount, PooledByteBufAllocator allocator, int maxComponents, TimeWindow flushTimeMetric, String mountPoint) {
        this.workerSource = workerSource;
        this.threadCount = threadCount;
        this.allocator = allocator;
        this.maxComponents = maxComponents;
        this.org$apache$celeborn$service$deploy$worker$storage$Flusher$$flushTimeMetric = flushTimeMetric;
        this.mountPoint = mountPoint;
        Logging.$init$((Logging)this);
        this.workingQueues = new LinkedBlockingQueue[threadCount];
        this.bufferQueue = new LinkedBlockingQueue();
        this.workers = new ExecutorService[threadCount];
        this.nextWorkerIndex = 0;
        this.lastBeginFlushTime = new AtomicLongArray(threadCount);
        this.stopFlag = new AtomicBoolean(false);
        this.init();
    }
}

