/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.common.protocol.PbBacklogAnnouncement;

public class BacklogAnnouncement
extends RequestMessage {
    private long streamId;
    private int backlog;

    public BacklogAnnouncement(long streamId, int backlog) {
        this.streamId = streamId;
        this.backlog = backlog;
    }

    @Override
    public int encodedLength() {
        return 12;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.streamId);
        buf.writeInt(this.backlog);
    }

    public static BacklogAnnouncement decode(ByteBuf in) {
        long streamId = in.readLong();
        int backlog = in.readInt();
        return new BacklogAnnouncement(streamId, backlog);
    }

    @Override
    public Message.Type type() {
        return Message.Type.BACKLOG_ANNOUNCEMENT;
    }

    public long getStreamId() {
        return this.streamId;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public static BacklogAnnouncement fromProto(PbBacklogAnnouncement pb) {
        return new BacklogAnnouncement(pb.getStreamId(), pb.getBacklog());
    }
}

