/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network;

import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.client.TransportClientBootstrap;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.client.TransportResponseHandler;
import org.apache.celeborn.common.network.protocol.MessageEncoder;
import org.apache.celeborn.common.network.protocol.SslMessageEncoder;
import org.apache.celeborn.common.network.server.BaseMessageHandler;
import org.apache.celeborn.common.network.server.TransportChannelHandler;
import org.apache.celeborn.common.network.server.TransportRequestHandler;
import org.apache.celeborn.common.network.server.TransportServer;
import org.apache.celeborn.common.network.server.TransportServerBootstrap;
import org.apache.celeborn.common.network.ssl.SSLFactory;
import org.apache.celeborn.common.network.util.NettyLogger;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.network.util.TransportFrameDecoder;
import org.apache.celeborn.shaded.io.netty.channel.Channel;
import org.apache.celeborn.shaded.io.netty.channel.ChannelDuplexHandler;
import org.apache.celeborn.shaded.io.netty.channel.ChannelHandler;
import org.apache.celeborn.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.celeborn.shaded.io.netty.channel.ChannelPipeline;
import org.apache.celeborn.shaded.io.netty.channel.socket.SocketChannel;
import org.apache.celeborn.shaded.io.netty.handler.ssl.SslHandler;
import org.apache.celeborn.shaded.io.netty.handler.stream.ChunkedWriteHandler;
import org.apache.celeborn.shaded.io.netty.handler.timeout.IdleStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportContext
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TransportContext.class);
    private static final NettyLogger nettyLogger = new NettyLogger();
    private final TransportConf conf;
    private final BaseMessageHandler msgHandler;
    private final ChannelDuplexHandler channelsLimiter;
    private final boolean closeIdleConnections;
    @Nullable
    private final SSLFactory sslFactory;
    private final boolean enableHeartbeat;
    private final AbstractSource source;
    private static final MessageEncoder ENCODER = MessageEncoder.INSTANCE;
    private static final SslMessageEncoder SSL_ENCODER = SslMessageEncoder.INSTANCE;

    public TransportContext(TransportConf conf, BaseMessageHandler msgHandler, boolean closeIdleConnections, ChannelDuplexHandler channelsLimiter, boolean enableHeartbeat, AbstractSource source) {
        this.conf = conf;
        this.msgHandler = msgHandler;
        this.closeIdleConnections = closeIdleConnections;
        this.sslFactory = SSLFactory.createSslFactory(conf);
        this.channelsLimiter = channelsLimiter;
        this.enableHeartbeat = enableHeartbeat;
        this.source = source;
        if (null != this.sslFactory) {
            logger.info("SSL factory created for module {}, has keys ? {}", (Object)conf.getModuleName(), (Object)this.sslFactory.hasKeyManagers());
        } else {
            logger.info("SSL not enabled for module = {}", (Object)conf.getModuleName());
        }
    }

    public TransportContext(TransportConf conf, BaseMessageHandler msgHandler, boolean closeIdleConnections, boolean enableHeartbeat, AbstractSource source) {
        this(conf, msgHandler, closeIdleConnections, null, enableHeartbeat, source);
    }

    public TransportContext(TransportConf conf, BaseMessageHandler msgHandler, boolean closeIdleConnections) {
        this(conf, msgHandler, closeIdleConnections, null, false, null);
    }

    public TransportContext(TransportConf conf, BaseMessageHandler msgHandler) {
        this(conf, msgHandler, false, false, null);
    }

    public TransportClientFactory createClientFactory(List<TransportClientBootstrap> bootstraps) {
        return new TransportClientFactory(this, bootstraps);
    }

    public TransportClientFactory createClientFactory() {
        return this.createClientFactory(Collections.emptyList());
    }

    public TransportServer createServer(String host, int port) {
        return new TransportServer(this, host, port, Collections.emptyList());
    }

    public TransportServer createServer(String host, int port, List<TransportServerBootstrap> bootstraps) {
        return new TransportServer(this, host, port, bootstraps);
    }

    public TransportServer createServer(List<TransportServerBootstrap> bootstraps) {
        return this.createServer(null, 0, bootstraps);
    }

    public TransportServer createServer(int port) {
        return this.createServer(null, port, Collections.emptyList());
    }

    public TransportServer createServer(int port, List<TransportServerBootstrap> bootstraps) {
        return this.createServer(null, port, bootstraps);
    }

    public TransportServer createServer() {
        return this.createServer(null, 0, Collections.emptyList());
    }

    public boolean sslEncryptionEnabled() {
        return this.sslFactory != null;
    }

    public TransportChannelHandler initializePipeline(SocketChannel channel, ChannelInboundHandlerAdapter decoder, boolean isClient) {
        return this.initializePipeline(channel, decoder, this.msgHandler, isClient);
    }

    public TransportChannelHandler initializePipeline(SocketChannel channel, BaseMessageHandler resolvedMsgHandler, boolean isClient) {
        return this.initializePipeline(channel, new TransportFrameDecoder(), resolvedMsgHandler, isClient);
    }

    public TransportChannelHandler initializePipeline(SocketChannel channel, ChannelInboundHandlerAdapter decoder, BaseMessageHandler resolvedMsgHandler, boolean isClient) {
        try {
            ChannelPipeline pipeline = channel.pipeline();
            if (nettyLogger.getLoggingHandler() != null) {
                pipeline.addLast("loggingHandler", (ChannelHandler)nettyLogger.getLoggingHandler());
            }
            if (this.sslEncryptionEnabled()) {
                SslHandler sslHandler;
                if (!isClient && !this.sslFactory.hasKeyManagers()) {
                    throw new IllegalStateException("Not a client connection and no keys configured");
                }
                try {
                    sslHandler = new SslHandler(this.sslFactory.createSSLEngine(isClient, channel.alloc()));
                    sslHandler.setHandshakeTimeoutMillis(this.conf.sslHandshakeTimeoutMs());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error creating Netty SslHandler", e);
                }
                pipeline.addFirst("NettySslEncryptionHandler", (ChannelHandler)sslHandler);
                pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
            }
            if (this.channelsLimiter != null) {
                pipeline.addLast("limiter", (ChannelHandler)this.channelsLimiter);
            }
            TransportChannelHandler channelHandler = this.createChannelHandler(channel, resolvedMsgHandler);
            pipeline.addLast("encoder", (ChannelHandler)(this.sslEncryptionEnabled() ? SSL_ENCODER : ENCODER)).addLast("frameDecoder", (ChannelHandler)decoder).addLast("idleStateHandler", (ChannelHandler)(this.enableHeartbeat ? new IdleStateHandler(this.conf.connectionTimeoutMs() / 1000, 0, 0) : new IdleStateHandler(0, 0, this.conf.connectionTimeoutMs() / 1000))).addLast("handler", (ChannelHandler)channelHandler);
            return channelHandler;
        }
        catch (RuntimeException e) {
            logger.error("Error while initializing Netty pipeline", (Throwable)e);
            throw e;
        }
    }

    private TransportChannelHandler createChannelHandler(Channel channel, BaseMessageHandler msgHandler) {
        TransportResponseHandler responseHandler = new TransportResponseHandler(this.conf, channel);
        TransportClient client = new TransportClient(channel, responseHandler);
        TransportRequestHandler requestHandler = new TransportRequestHandler(channel, client, msgHandler);
        return new TransportChannelHandler(client, responseHandler, requestHandler, this.conf.connectionTimeoutMs(), this.closeIdleConnections, this.enableHeartbeat, this.conf.clientHeartbeatInterval(), this);
    }

    public TransportConf getConf() {
        return this.conf;
    }

    public BaseMessageHandler getMsgHandler() {
        return this.msgHandler;
    }

    public AbstractSource getSource() {
        return this.source;
    }

    @Override
    public void close() {
        if (this.sslFactory != null) {
            this.sslFactory.destroy();
        }
    }
}

