/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.exception.CelebornException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.RpcEndpoint;
import org.apache.celeborn.common.rpc.ThreadSafeRpcEndpoint;
import org.apache.celeborn.common.rpc.netty.Dispatcher;
import org.apache.celeborn.common.rpc.netty.InboxMessage;
import org.apache.celeborn.common.rpc.netty.NettyRpcCallContext;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.OnStart$;
import org.apache.celeborn.common.rpc.netty.OnStop$;
import org.apache.celeborn.common.rpc.netty.OneWayMessage;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnected;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnectionError;
import org.apache.celeborn.common.rpc.netty.RemoteProcessDisconnected;
import org.apache.celeborn.common.rpc.netty.RpcMessage;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g!\u0002\u0014(\u00015\u001a\u0004\u0002\u0003!\u0001\u0005\u000b\u0007I\u0011\u0001\"\t\u0011\u001d\u0003!\u0011!Q\u0001\n\rC\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u0015\"Aq\n\u0001BC\u0002\u0013\u0005\u0001\u000b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003R\u0011\u00151\u0006\u0001\"\u0001X\u0011!a\u0006A1A\u0005\u0002\u001dj\u0006BB1\u0001A\u0003%a\f\u0003\u0005c\u0001\t\u0007I\u0011A\u0014d\u0011\u0019\u0001\b\u0001)A\u0005I\"A\u0011\u000f\u0001b\u0001\n\u00039#\u000f\u0003\u0004w\u0001\u0001\u0006Ia\u001d\u0005\bo\u0002\u0011\r\u0011\"\u0005y\u0011\u001d\t\t\u0001\u0001Q\u0001\neD\u0011\"!\b\u0001\u0005\u0004%I!a\b\t\u0011\u00055\u0002\u0001)A\u0005\u0003CA\u0011\"a\f\u0001\u0001\u0004%I!!\r\t\u0013\u0005e\u0002\u00011A\u0005\n\u0005m\u0002\u0002CA$\u0001\u0001\u0006K!a\r\t\u0013\u0005-\u0003\u00011A\u0005\n\u0005E\u0002\"CA'\u0001\u0001\u0007I\u0011BA(\u0011!\t\u0019\u0006\u0001Q!\n\u0005M\u0002\u0002CA,\u0001\u0001\u0007I\u0011B/\t\u0013\u0005e\u0003\u00011A\u0005\n\u0005m\u0003bBA0\u0001\u0001\u0006KA\u0018\u0005\b\u0003G\u0002A\u0011AA3\u0011\u001d\tY\u0007\u0001C\u0005\u0003[B\u0001\"a\u001f\u0001\t\u00039\u0013Q\u0010\u0005\b\u0003\u007f\u0002A\u0011BA?\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007Cq!a\"\u0001\t\u0003\tI\tC\u0004\u0002\u000e\u0002!\t!! \t\u000f\u0005=\u0005\u0001\"\u0001\u00022!9\u0011\u0011\u0013\u0001\u0005\u0012\u0005M\u0005bBAL\u0001\u0011%\u0011\u0011\u0014\u0005\u0007\u0003\u0007\u0004A\u0011A/\u0003\u000b%s'm\u001c=\u000b\u0005!J\u0013!\u00028fiRL(B\u0001\u0016,\u0003\r\u0011\bo\u0019\u0006\u0003Y5\naaY8n[>t'B\u0001\u00180\u0003!\u0019W\r\\3c_Jt'B\u0001\u00192\u0003\u0019\t\u0007/Y2iK*\t!'A\u0002pe\u001e\u001c2\u0001\u0001\u001b;!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u0019\te.\u001f*fMB\u00111HP\u0007\u0002y)\u0011QhK\u0001\tS:$XM\u001d8bY&\u0011q\b\u0010\u0002\b\u0019><w-\u001b8h\u0003-)g\u000e\u001a9pS:$(+\u001a4\u0004\u0001U\t1\t\u0005\u0002E\u000b6\tq%\u0003\u0002GO\t\u0019b*\u001a;usJ\u00038-\u00128ea>Lg\u000e\u001e*fM\u0006aQM\u001c3q_&tGOU3gA\u0005AQM\u001c3q_&tG/F\u0001K!\tYE*D\u0001*\u0013\ti\u0015FA\u0006Sa\u000e,e\u000e\u001a9pS:$\u0018!C3oIB|\u0017N\u001c;!\u0003\u0011\u0019wN\u001c4\u0016\u0003E\u0003\"AU*\u000e\u0003-J!\u0001V\u0016\u0003\u0019\r+G.\u001a2pe:\u001cuN\u001c4\u0002\u000b\r|gN\u001a\u0011\u0002\rqJg.\u001b;?)\u0011A\u0016LW.\u0011\u0005\u0011\u0003\u0001\"\u0002!\b\u0001\u0004\u0019\u0005\"\u0002%\b\u0001\u0004Q\u0005\"B(\b\u0001\u0004\t\u0016\u0001C2ba\u0006\u001c\u0017\u000e^=\u0016\u0003y\u0003\"!N0\n\u0005\u00014$aA%oi\u0006I1-\u00199bG&$\u0018\u0010I\u0001\nS:\u0014w\u000e\u001f'pG.,\u0012\u0001\u001a\t\u0003K:l\u0011A\u001a\u0006\u0003O\"\fQ\u0001\\8dWNT!!\u001b6\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002lY\u0006!Q\u000f^5m\u0015\u0005i\u0017\u0001\u00026bm\u0006L!a\u001c4\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0003)IgNY8y\u0019>\u001c7\u000eI\u0001\u0007SN4U\u000f\u001c7\u0016\u0003M\u0004\"!\u001a;\n\u0005U4'!C\"p]\u0012LG/[8o\u0003\u001dI7OR;mY\u0002\n\u0001\"\\3tg\u0006<Wm]\u000b\u0002sB\u0019!p_?\u000e\u0003)L!\u0001 6\u0003\u00151Kgn[3e\u0019&\u001cH\u000f\u0005\u0002E}&\u0011qp\n\u0002\r\u0013:\u0014w\u000e_'fgN\fw-Z\u0001\n[\u0016\u001c8/Y4fg\u0002BsaDA\u0003\u0003/\tI\u0002\u0005\u0003\u0002\b\u0005MQBAA\u0005\u0015\rI\u00171\u0002\u0006\u0005\u0003\u001b\ty!\u0001\u0006b]:|G/\u0019;j_:T!!!\u0005\u0002\u000b)\fg/\u0019=\n\t\u0005U\u0011\u0011\u0002\u0002\n\u000fV\f'\u000fZ3e\u0005f\fQA^1mk\u0016\f#!a\u0007\u0002\tQD\u0017n]\u0001\r[\u0016\u001c8/Y4f\u0007>,h\u000e^\u000b\u0003\u0003C\u0001B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003OA\u0017AB1u_6L7-\u0003\u0003\u0002,\u0005\u0015\"AC!u_6L7\rT8oO\u0006iQ.Z:tC\u001e,7i\\;oi\u0002\nqa\u001d;paB,G-\u0006\u0002\u00024A\u0019Q'!\u000e\n\u0007\u0005]bGA\u0004C_>dW-\u00198\u0002\u0017M$x\u000e\u001d9fI~#S-\u001d\u000b\u0005\u0003{\t\u0019\u0005E\u00026\u0003\u007fI1!!\u00117\u0005\u0011)f.\u001b;\t\u0013\u0005\u00153#!AA\u0002\u0005M\u0012a\u0001=%c\u0005A1\u000f^8qa\u0016$\u0007\u0005K\u0004\u0015\u0003\u000b\t9\"!\u0007\u0002!\u0015t\u0017M\u00197f\u0007>t7-\u001e:sK:$\u0018\u0001F3oC\ndWmQ8oGV\u0014(/\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002>\u0005E\u0003\"CA#-\u0005\u0005\t\u0019AA\u001a\u0003E)g.\u00192mK\u000e{gnY;se\u0016tG\u000f\t\u0015\b/\u0005\u0015\u0011qCA\r\u0003AqW/\\!di&4X\r\u00165sK\u0006$7/\u0001\u000bok6\f5\r^5wKRC'/Z1eg~#S-\u001d\u000b\u0005\u0003{\ti\u0006\u0003\u0005\u0002Fe\t\t\u00111\u0001_\u0003EqW/\\!di&4X\r\u00165sK\u0006$7\u000f\t\u0015\b5\u0005\u0015\u0011qCA\r\u0003)\tG\rZ'fgN\fw-\u001a\u000b\u0005\u0003{\t9\u0007\u0003\u0004\u0002jm\u0001\r!`\u0001\b[\u0016\u001c8/Y4f\u0003=\u0001(o\\2fgNLe\u000e^3s]\u0006dGCBA\u001f\u0003_\nI\bC\u0004\u0002rq\u0001\r!a\u001d\u0002\u0015\u0011L7\u000f]1uG\",'\u000fE\u0002E\u0003kJ1!a\u001e(\u0005)!\u0015n\u001d9bi\u000eDWM\u001d\u0005\u0007\u0003Sb\u0002\u0019A?\u0002\u0015]\f\u0017\u000e^(o\rVdG\u000e\u0006\u0002\u0002>\u0005i1/[4oC2tu\u000e\u001e$vY2\fq\u0001\u001d:pG\u0016\u001c8\u000f\u0006\u0003\u0002>\u0005\u0015\u0005bBA9?\u0001\u0007\u00111O\u0001\u0005a>\u001cH\u000f\u0006\u0003\u0002>\u0005-\u0005BBA5A\u0001\u0007Q0\u0001\u0003ti>\u0004\u0018aB5t\u000b6\u0004H/_\u0001\u0007_:$%o\u001c9\u0015\t\u0005u\u0012Q\u0013\u0005\u0007\u0003S\u001a\u0003\u0019A?\u0002\u0015M\fg-\u001a7z\u0007\u0006dG\u000e\u0006\u0004\u0002\u001c\u0006\u001d\u0016\u0011\u0016\u000b\u0005\u0003{\ti\n\u0003\u0005\u0002 \u0012\"\t\u0019AAQ\u0003\u0019\t7\r^5p]B)Q'a)\u0002>%\u0019\u0011Q\u0015\u001c\u0003\u0011q\u0012\u0017P\\1nKzBQ\u0001\u0013\u0013A\u0002)Cq!a+%\u0001\u0004\ti+A\bf]\u0012\u0004x.\u001b8u%\u00164g*Y7f!\u0011\ty+!0\u000f\t\u0005E\u0016\u0011\u0018\t\u0004\u0003g3TBAA[\u0015\r\t9,Q\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005mf'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u007f\u000b\tM\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003w3\u0014aE4fi:+X.Q2uSZ,G\u000b\u001b:fC\u0012\u001c\b")
public class Inbox
implements Logging {
    private final NettyRpcEndpointRef endpointRef;
    private final RpcEndpoint endpoint;
    private final CelebornConf conf;
    private final int capacity;
    private final ReentrantLock inboxLock;
    private final Condition isFull;
    @GuardedBy(value="this")
    private final LinkedList<InboxMessage> messages;
    private final AtomicLong messageCount;
    @GuardedBy(value="this")
    private boolean stopped;
    @GuardedBy(value="this")
    private boolean enableConcurrent;
    @GuardedBy(value="this")
    private int numActiveThreads;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        Inbox inbox = this;
        synchronized (inbox) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public NettyRpcEndpointRef endpointRef() {
        return this.endpointRef;
    }

    public RpcEndpoint endpoint() {
        return this.endpoint;
    }

    public CelebornConf conf() {
        return this.conf;
    }

    public int capacity() {
        return this.capacity;
    }

    public ReentrantLock inboxLock() {
        return this.inboxLock;
    }

    public Condition isFull() {
        return this.isFull;
    }

    public LinkedList<InboxMessage> messages() {
        return this.messages;
    }

    private AtomicLong messageCount() {
        return this.messageCount;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    private boolean enableConcurrent() {
        return this.enableConcurrent;
    }

    private void enableConcurrent_$eq(boolean x$1) {
        this.enableConcurrent = x$1;
    }

    private int numActiveThreads() {
        return this.numActiveThreads;
    }

    private void numActiveThreads_$eq(int x$1) {
        this.numActiveThreads = x$1;
    }

    public void addMessage(InboxMessage message) {
        this.messages().add(message);
        this.messageCount().incrementAndGet();
        this.signalNotFull();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("queue length of ").append(this.messageCount().get()).append(" ").toString());
    }

    private void processInternal(Dispatcher dispatcher, InboxMessage message) {
        InboxMessage inboxMessage = message;
        if (inboxMessage instanceof RpcMessage) {
            RpcMessage rpcMessage = (RpcMessage)inboxMessage;
            RpcAddress _sender = rpcMessage.senderAddress();
            Object content = rpcMessage.content();
            NettyRpcCallContext context = rpcMessage.context();
            try {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)this.endpoint().receiveAndReply(context).applyOrElse(content, (Function1 & Serializable & scala.Serializable)msg -> {
                    throw new CelebornException(new StringBuilder(26).append("Unsupported message ").append(message).append(" from ").append(_sender).toString());
                });
            }
            catch (Throwable e) {
                context.sendFailure(e);
                throw e;
            }
            return;
        }
        if (inboxMessage instanceof OneWayMessage) {
            OneWayMessage oneWayMessage = (OneWayMessage)inboxMessage;
            RpcAddress _sender = oneWayMessage.senderAddress();
            Object content = oneWayMessage.content();
            BoxedUnit cfr_ignored_1 = (BoxedUnit)this.endpoint().receive().applyOrElse(content, (Function1 & Serializable & scala.Serializable)msg -> {
                throw new CelebornException(new StringBuilder(26).append("Unsupported message ").append(message).append(" from ").append(_sender).toString());
            });
            return;
        }
        if (OnStart$.MODULE$.equals(inboxMessage)) {
            this.endpoint().onStart();
            if (!(this.endpoint() instanceof ThreadSafeRpcEndpoint)) {
                try {
                    BoxedUnit boxedUnit;
                    this.inboxLock().lockInterruptibly();
                    if (!this.stopped()) {
                        this.enableConcurrent_$eq(true);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                finally {
                    this.inboxLock().unlock();
                }
                return;
            }
            return;
        }
        if (OnStop$.MODULE$.equals(inboxMessage)) {
            int n;
            try {
                this.inboxLock().lockInterruptibly();
                n = this.numActiveThreads();
            }
            finally {
                this.inboxLock().unlock();
            }
            int activeThreads = n;
            Predef$.MODULE$.assert(activeThreads == 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("There should be only a single active thread but found ").append(activeThreads).append(" threads.").toString());
            dispatcher.removeRpcEndpointRef(this.endpoint());
            this.endpoint().onStop();
            Predef$.MODULE$.assert(this.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "OnStop should be the last message");
            return;
        }
        if (inboxMessage instanceof RemoteProcessConnected) {
            RemoteProcessConnected remoteProcessConnected = (RemoteProcessConnected)inboxMessage;
            RpcAddress remoteAddress = remoteProcessConnected.remoteAddress();
            this.endpoint().onConnected(remoteAddress);
            return;
        }
        if (inboxMessage instanceof RemoteProcessDisconnected) {
            RemoteProcessDisconnected remoteProcessDisconnected = (RemoteProcessDisconnected)inboxMessage;
            RpcAddress remoteAddress = remoteProcessDisconnected.remoteAddress();
            this.endpoint().onDisconnected(remoteAddress);
            return;
        }
        if (inboxMessage instanceof RemoteProcessConnectionError) {
            RemoteProcessConnectionError remoteProcessConnectionError = (RemoteProcessConnectionError)inboxMessage;
            Throwable cause = remoteProcessConnectionError.cause();
            RpcAddress remoteAddress = remoteProcessConnectionError.remoteAddress();
            this.endpoint().onNetworkError(cause, remoteAddress);
            return;
        }
        throw new MatchError((Object)inboxMessage);
    }

    public void waitOnFull() {
        if (this.capacity() > 0 && !this.stopped()) {
            try {
                this.inboxLock().lockInterruptibly();
                while (this.messageCount().get() >= (long)this.capacity()) {
                    this.isFull().await();
                }
            }
            finally {
                this.inboxLock().unlock();
            }
            return;
        }
    }

    private void signalNotFull() {
        Predef$.MODULE$.require(this.inboxLock().isHeldByCurrentThread(), (Function0 & Serializable & scala.Serializable)() -> "cannot call signalNotFull without holding lock");
        if (this.capacity() > 0 && this.messageCount().get() < (long)this.capacity()) {
            this.isFull().signal();
            return;
        }
    }

    public void process(Dispatcher dispatcher) {
        ObjectRef message;
        block11: {
            block10: {
                message = ObjectRef.create(null);
                try {
                    this.inboxLock().lockInterruptibly();
                    if (!this.enableConcurrent() && this.numActiveThreads() != 0) {
                        break block10;
                    }
                    message.elem = this.messages().poll();
                    if ((InboxMessage)message.elem == null) break block10;
                    this.numActiveThreads_$eq(this.numActiveThreads() + 1);
                    this.messageCount().decrementAndGet();
                    this.signalNotFull();
                    break block11;
                }
                finally {
                    this.inboxLock().unlock();
                }
            }
            return;
        }
        while (true) {
            this.safelyCall(this.endpoint(), this.endpointRef().name(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.processInternal(dispatcher, (InboxMessage)message$2.elem));
            try {
                this.inboxLock().lockInterruptibly();
                if (!this.enableConcurrent() && this.numActiveThreads() != 1) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
                message.elem = this.messages().poll();
                if ((InboxMessage)message.elem == null) {
                    this.numActiveThreads_$eq(this.numActiveThreads() - 1);
                    break;
                }
                this.messageCount().decrementAndGet();
                this.signalNotFull();
                continue;
            }
            finally {
                this.inboxLock().unlock();
                continue;
            }
            break;
        }
    }

    public void post(InboxMessage message) {
        try {
            this.inboxLock().lockInterruptibly();
            if (this.stopped()) {
                this.onDrop(message);
            } else {
                this.addMessage(message);
            }
        }
        finally {
            this.inboxLock().unlock();
        }
    }

    public void stop() {
        try {
            this.inboxLock().lockInterruptibly();
            if (!this.stopped()) {
                this.enableConcurrent_$eq(false);
                this.stopped_$eq(true);
                this.addMessage(OnStop$.MODULE$);
            }
        }
        finally {
            this.inboxLock().unlock();
        }
    }

    public boolean isEmpty() {
        boolean bl;
        try {
            this.inboxLock().lockInterruptibly();
            bl = this.messages().isEmpty();
        }
        finally {
            this.inboxLock().unlock();
        }
        return bl;
    }

    public void onDrop(InboxMessage message) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Drop ").append(message).append(" because ").append(this.endpointRef()).append(" is stopped").toString());
    }

    private void safelyCall(RpcEndpoint endpoint, String endpointRefName, Function0<BoxedUnit> action) {
        try {
            action.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                try {
                    endpoint.onError(e);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable4);
                    if (!option2.isEmpty()) {
                        Throwable ee = (Throwable)option2.get();
                        if (this.stopped()) {
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring error", ee);
                        } else {
                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Ignoring error", ee);
                        }
                    } else if (throwable4 != null) {
                        Throwable throwable5 = throwable4;
                        this.dealWithFatalError$1(throwable5, endpointRefName);
                    } else {
                        throw throwable3;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            if (throwable2 != null) {
                Throwable throwable6 = throwable2;
                this.dealWithFatalError$1(throwable6, endpointRefName);
            }
            throw throwable;
        }
    }

    public int getNumActiveThreads() {
        int n;
        try {
            this.inboxLock().lockInterruptibly();
            n = this.numActiveThreads();
        }
        finally {
            this.inboxLock().unlock();
        }
        return n;
    }

    private final void dealWithFatalError$1(Throwable fatal, String endpointRefName$1) {
        try {
            this.inboxLock().lockInterruptibly();
            Predef$.MODULE$.assert(this.numActiveThreads() > 0, (Function0 & Serializable & scala.Serializable)() -> "The number of active threads should be positive.");
            this.numActiveThreads_$eq(this.numActiveThreads() - 1);
        }
        finally {
            this.inboxLock().unlock();
        }
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("An error happened while processing message in the inbox for ").append(endpointRefName$1).toString(), fatal);
        throw fatal;
    }

    public Inbox(NettyRpcEndpointRef endpointRef, RpcEndpoint endpoint, CelebornConf conf) {
        this.endpointRef = endpointRef;
        this.endpoint = endpoint;
        this.conf = conf;
        Logging.$init$(this);
        this.capacity = BoxesRunTime.unboxToInt((Object)conf.get(CelebornConf$.MODULE$.RPC_INBOX_CAPACITY()));
        this.inboxLock = new ReentrantLock();
        this.isFull = this.inboxLock().newCondition();
        this.messages = new LinkedList();
        this.messageCount = new AtomicLong(0L);
        this.stopped = false;
        this.enableConcurrent = false;
        this.numActiveThreads = 0;
        try {
            this.inboxLock().lockInterruptibly();
            this.messages().add(OnStart$.MODULE$);
            this.messageCount().incrementAndGet();
        }
        finally {
            this.inboxLock().unlock();
        }
    }
}

